/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.CompassPoint;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedBMOC;
import cds.healpix.HealpixNestedFixedRadiusConeComputer;
import cds.healpix.NeighbourList;
import cds.healpix.VerticesAndPathComputer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Scanner;

public class HealpixCLI {
    private static final String usage() {
        StringBuilder s = new StringBuilder();
        s.append("HealpixCLI action params").append('\n');
        s.append("ACTION").append('\n');
        s.append("  help, -h, -help, --help      print this message").append('\n');
        s.append("  quit, exit                   exits").append('\n');
        s.append("  hash     DEPTH RA DEC        compute a cell number at the given depth from the given coords").append('\n');
        s.append("  center   DEPTH HASH          compute the coordinates (in degrees) of a cell center").append('\n');
        s.append("  vertices DEPTH HASH          compute the coordinates (in degrees) of the 4 cell vertices").append('\n');
        s.append("  neigh    DEPTH HASH          provides the cell number of each neighbour of the given cell").append('\n');
        s.append("  cone     DEPTH RA DEC RADIUS provides the list of cells overlaped by a cone").append('\n');
        s.append("PARAMS").append('\n');
        s.append("  DEPTH    healpix layer depth (in [0, 29]").append('\n');
        s.append("  RA       right ascension, in [-180, 360] degrees").append('\n');
        s.append("  DEC      declination, in [-90, 90] degrees").append('\n');
        s.append("  HASH     an HEALPix hash value, i.e. a cell number").append('\n');
        s.append("  RADIUS   a radius, in degrees").append('\n');
        return s.toString();
    }

    private static final void printUsage() {
        System.out.println(HealpixCLI.usage());
    }

    private static final Deque<String> args2stack(String ... args) {
        ArrayDeque<String> stack = new ArrayDeque<String>(args.length);
        for (String arg : args) {
            stack.addLast(arg);
        }
        return stack;
    }

    private static int popDepth(Deque<String> stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("DEPTH parameter is missing");
        }
        String depthStr = stack.pop();
        int depth = 0;
        try {
            depth = Integer.parseInt(depthStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("DEPTH parameter. Expected: integer; Actual: " + depthStr);
        }
        return depth;
    }

    private static long popHash(Deque<String> stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("HASH parameter is missing");
        }
        String hStr = stack.pop();
        long h = 0L;
        try {
            h = Long.parseLong(hStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("DEPTH parameter. Expected: integer; Actual: " + hStr);
        }
        return h;
    }

    private static double popDouble(Deque<String> stack, String paramName) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException(paramName + " parameter is missing");
        }
        String dStr = stack.pop();
        double d = 0.0;
        try {
            d = Double.parseDouble(dStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(paramName + " parameter. Expected: double; Actual: " + dStr);
        }
        return d;
    }

    private static double popRA(Deque<String> stack) {
        return Math.toRadians(HealpixCLI.popDouble(stack, "RA"));
    }

    private static double popDec(Deque<String> stack) {
        return Math.toRadians(HealpixCLI.popDouble(stack, "DEC"));
    }

    private static double popRadius(Deque<String> stack) {
        return Math.toRadians(HealpixCLI.popDouble(stack, "RADIUS"));
    }

    private static final void execCatchErr(Deque<String> stack) {
        try {
            HealpixCLI.exec(stack);
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
        catch (Error e) {
            System.out.println("Error: " + e.getMessage());
        }
    }

    private static final void exec(Deque<String> stack) {
        String action = stack.pop();
        System.out.println("action: " + action);
        if (action.equals("help") || action.equals("-h") || action.equals("-help") || action.equals("--help")) {
            HealpixCLI.printUsage();
        } else if (action.equals("quit") || action.equals("exit")) {
            System.exit(0);
        } else if (action.equals("hash")) {
            HealpixNested hn = Healpix.getNested(HealpixCLI.popDepth(stack));
            long cellNumber = hn.hash(HealpixCLI.popRA(stack), HealpixCLI.popDec(stack));
            System.out.println(cellNumber);
        } else if (action.equals("center")) {
            HealpixNested hn = Healpix.getNested(HealpixCLI.popDepth(stack));
            double[] centerCoos = hn.center(HealpixCLI.popHash(stack));
            double raDeg = Math.toDegrees(centerCoos[0]);
            double decDeg = Math.toDegrees(centerCoos[1]);
            System.out.println(raDeg + " " + decDeg);
        } else if (action.equals("vertices")) {
            HealpixNested hn = Healpix.getNested(HealpixCLI.popDepth(stack));
            EnumMap<CompassPoint.Cardinal, double[]> vertices = hn.vertices(HealpixCLI.popHash(stack), VerticesAndPathComputer.ALL_CARDINAL_POINTS);
            for (Map.Entry<CompassPoint.Cardinal, double[]> e : vertices.entrySet()) {
                CompassPoint.Cardinal c = e.getKey();
                double[] coos = e.getValue();
                double raDeg = Math.toDegrees(coos[0]);
                double decDeg = Math.toDegrees(coos[1]);
                System.out.println((Object)((Object)c) + ": " + raDeg + " " + decDeg);
            }
        } else if (action.equals("neigh")) {
            HealpixNested hn = Healpix.getNested(HealpixCLI.popDepth(stack));
            NeighbourList neigList = hn.neighbours(HealpixCLI.popHash(stack));
            for (int i = 0; i < neigList.size(); ++i) {
                System.out.println((Object)((Object)neigList.getDirection(i)) + ": " + neigList.get(i));
            }
        } else if (action.equals("cone")) {
            HealpixNested hn = Healpix.getNested(HealpixCLI.popDepth(stack));
            double coneCenterRa = HealpixCLI.popRA(stack);
            double coneCenterDec = HealpixCLI.popDec(stack);
            HealpixNestedFixedRadiusConeComputer cc = hn.newConeComputer(HealpixCLI.popRadius(stack));
            HealpixNestedBMOC bmoc = cc.overlappingCells(coneCenterRa, coneCenterDec);
            for (HealpixNestedBMOC.CurrentValueAccessor cell : bmoc) {
                String isFull = cell.isFull() ? "(f)" : "(p)";
                System.out.println(cell.getDepth() + "/" + cell.getHash() + isFull);
            }
        } else if (!action.equals("")) {
            throw new IllegalArgumentException("Unknown action \"" + action + "\"");
        }
    }

    public static final void main(String[] args) {
        if (args == null || args.length == 0) {
            HealpixCLI.printUsage();
            Scanner in = new Scanner(System.in);
            while (true) {
                args = in.nextLine().split("\\s+");
                HealpixCLI.execCatchErr(HealpixCLI.args2stack(args));
            }
        }
        HealpixCLI.exec(HealpixCLI.args2stack(args));
    }
}

