/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.perflib;

import com.squareup.haha.perflib.ClassObj;
import com.squareup.haha.perflib.Field;
import com.squareup.haha.perflib.Instance;
import com.squareup.haha.perflib.StackTrace;
import com.squareup.haha.perflib.Visitor;
import java.util.ArrayList;
import java.util.List;

public class ClassInstance
extends Instance {
    private final long mValuesOffset;

    public ClassInstance(long id, StackTrace stack, long valuesOffset) {
        super(id, stack);
        this.mValuesOffset = valuesOffset;
    }

    List<FieldValue> getFields(String name) {
        ArrayList<FieldValue> result = new ArrayList<FieldValue>();
        for (FieldValue value : this.getValues()) {
            if (!value.getField().getName().equals(name)) continue;
            result.add(value);
        }
        return result;
    }

    public List<FieldValue> getValues() {
        ArrayList<FieldValue> result = new ArrayList<FieldValue>();
        this.getBuffer().setPosition(this.mValuesOffset);
        for (ClassObj clazz = this.getClassObj(); clazz != null; clazz = clazz.getSuperClassObj()) {
            for (Field field : clazz.getFields()) {
                result.add(new FieldValue(field, this.readValue(field.getType())));
            }
        }
        return result;
    }

    @Override
    public final void accept(Visitor visitor) {
        visitor.visitClassInstance(this);
        for (FieldValue field : this.getValues()) {
            if (!(field.getValue() instanceof Instance)) continue;
            if (!this.mReferencesAdded) {
                ((Instance)field.getValue()).addReference(field.getField(), this);
            }
            visitor.visitLater(this, (Instance)field.getValue());
        }
        this.mReferencesAdded = true;
    }

    @Override
    public boolean getIsSoftReference() {
        return this.getClassObj().getIsSoftReference();
    }

    public final String toString() {
        return String.format("%s@%d (0x%x)", this.getClassObj().getClassName(), this.getUniqueId(), this.getUniqueId());
    }

    public static class FieldValue {
        private Field mField;
        private Object mValue;

        public FieldValue(Field field, Object value) {
            this.mField = field;
            this.mValue = value;
        }

        public Field getField() {
            return this.mField;
        }

        public Object getValue() {
            return this.mValue;
        }
    }
}

