"""DSM 6 SYNO.Storage.CGI.Storage data."""

from tests.const import UNIQUE_KEY

DSM_6_STORAGE_STORAGE_DS1819_PLUS_SHR2_8DISKS_1VOL = {
    "data": {
        "disks": [
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1819+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sda",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 0,
                "exceed_bad_sector_thr": False,
                "firm": "81.00A81",
                "has_system": True,
                "id": "sda",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 1",
                "model": "WD80EFAX-68KNBN0        ",
                "name": "Drive 1",
                "num_id": 1,
                "order": 1,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "VAHG7V1L",
                "size_total": "8001563222016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 39,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1819+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdb",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 0,
                "exceed_bad_sector_thr": False,
                "firm": "81.00A81",
                "has_system": True,
                "id": "sdb",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 2",
                "model": "WD80EFAX-68KNBN0        ",
                "name": "Drive 2",
                "num_id": 2,
                "order": 2,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "VAHGLLPL",
                "size_total": "8001563222016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 40,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1819+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdc",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 0,
                "exceed_bad_sector_thr": False,
                "firm": "81.00A81",
                "has_system": True,
                "id": "sdc",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 3",
                "model": "WD80EFAX-68KNBN0        ",
                "name": "Drive 3",
                "num_id": 3,
                "order": 3,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "VAHH38AL",
                "size_total": "8001563222016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 40,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1819+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdd",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 0,
                "exceed_bad_sector_thr": False,
                "firm": "81.00A81",
                "has_system": True,
                "id": "sdd",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 4",
                "model": "WD80EFAX-68KNBN0        ",
                "name": "Drive 4",
                "num_id": 4,
                "order": 4,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "VAHGW7VL",
                "size_total": "8001563222016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 41,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1819+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sde",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 0,
                "exceed_bad_sector_thr": False,
                "firm": "GX2M",
                "has_system": True,
                "id": "sde",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 5",
                "model": "HDWN180                 ",
                "name": "Drive 5",
                "num_id": 5,
                "order": 5,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "399CK0FUFAVG",
                "size_total": "8001563222016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 36,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "TOSHIBA ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1819+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdf",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 0,
                "exceed_bad_sector_thr": False,
                "firm": "GX2M",
                "has_system": True,
                "id": "sdf",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 6",
                "model": "HDWN180                 ",
                "name": "Drive 6",
                "num_id": 6,
                "order": 6,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "399CK0G0FAVG",
                "size_total": "8001563222016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 36,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "TOSHIBA ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1819+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdg",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 510,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": True,
                "id": "sdg",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 7",
                "model": "WD40EFRX-68WT0N0        ",
                "name": "Drive 7",
                "num_id": 7,
                "order": 7,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC4E7PD98ZY",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 33,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1819+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdh",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 488,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": True,
                "id": "sdh",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 8",
                "model": "WD40EFRX-68N32N0        ",
                "name": "Drive 8",
                "num_id": 8,
                "order": 8,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC7K3FP148E",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 31,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
        ],
        "env": {
            "batchtask": {"max_task": 64, "remain_task": 64},
            "bay_number": "8",
            "data_scrubbing": {"sche_enabled": "0", "sche_status": "disabled"},
            "ebox": [],
            "fs_acting": False,
            "isSyncSysPartition": False,
            "is_space_actioning": False,
            "isns": {"address": "", "enabled": False},
            "isns_server": "",
            "max_fs_bytes": "118747255799808",
            "max_fs_bytes_high_end": "219902325555200",
            "model_name": "DS1819+",
            "ram_enough_for_fs_high_end": False,
            "ram_size": 16,
            "ram_size_required": 32,
            "showpooltab": True,
            "status": {"system_crashed": False, "system_need_repair": False},
            "support": {"ebox": True, "raid_cross": True, "sysdef": True},
            "support_fit_fs_limit": True,
            "unique_key": UNIQUE_KEY,
            "volume_full_critical": 0.1,
            "volume_full_warning": 0.2,
        },
        "hotSpareConf": {"cross_repair": True, "disable_repair": []},
        "hotSpares": [],
        "iscsiLuns": [],
        "iscsiTargets": [],
        "ports": [],
        "ssdCaches": [],
        "storagePools": [
            {
                "cacheStatus": "",
                "can_do": {
                    "data_scrubbing": True,
                    "delete": True,
                    "expand_by_disk": 1,
                    "raid_cross": True,
                },
                "container": "internal",
                "desc": "SHR-2",
                "device_type": "shr_with_2_disk_protect",
                "disk_failure_number": 0,
                "disks": ["sda", "sdb", "sdc", "sdd", "sde", "sdf", "sdg", "sdh"],
                "drive_type": 0,
                "id": "reuse_1",
                "is_actioning": False,
                "is_scheduled": False,
                "is_writable": True,
                "last_done_time": 0,
                "limited_disk_number": 24,
                "maximal_disk_size": "0",
                "minimal_disk_size": "8001457274880",
                "next_schedule_time": 0,
                "num_id": 1,
                "pool_child": [{"id": "volume_1", "size": {"total": "39978088267776"}}],
                "pool_path": "reuse_1",
                "progress": {"percent": "-1", "step": "none"},
                "raidType": "multiple",
                "raids": [
                    {
                        "designedDiskCount": 6,
                        "devices": [
                            {"id": "sdf", "slot": 5, "status": "normal"},
                            {"id": "sde", "slot": 4, "status": "normal"},
                            {"id": "sdd", "slot": 3, "status": "normal"},
                            {"id": "sdc", "slot": 2, "status": "normal"},
                            {"id": "sdb", "slot": 1, "status": "normal"},
                            {"id": "sda", "slot": 0, "status": "normal"},
                        ],
                        "hasParity": True,
                        "minDevSize": "8001457274880",
                        "normalDevCount": 6,
                        "raidPath": "/dev/md3",
                        "raidStatus": 1,
                        "spares": [],
                    },
                    {
                        "designedDiskCount": 8,
                        "devices": [
                            {"id": "sdh", "slot": 7, "status": "normal"},
                            {"id": "sdg", "slot": 6, "status": "normal"},
                            {"id": "sdf", "slot": 5, "status": "normal"},
                            {"id": "sde", "slot": 4, "status": "normal"},
                            {"id": "sdd", "slot": 3, "status": "normal"},
                            {"id": "sdc", "slot": 2, "status": "normal"},
                            {"id": "sdb", "slot": 1, "status": "normal"},
                            {"id": "sda", "slot": 0, "status": "normal"},
                        ],
                        "hasParity": True,
                        "minDevSize": "8001457274880",
                        "normalDevCount": 8,
                        "raidPath": "/dev/md2",
                        "raidStatus": 1,
                        "spares": [],
                    },
                ],
                "scrubbingStatus": "has_not_run_yet",
                "size": {"total": "39978100850688", "used": "39978100850688"},
                "space_path": "/dev/vg1",
                "spares": [],
                "status": "normal",
                "suggestions": [],
                "timebackup": False,
                "vspace_can_do": {
                    "drbd": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                    "flashcache": {
                        "apply": {
                            "can_do": False,
                            "errCode": 768,
                            "stopService": False,
                        },
                        "remove": {
                            "can_do": False,
                            "errCode": 768,
                            "stopService": False,
                        },
                        "resize": {
                            "can_do": False,
                            "errCode": 768,
                            "stopService": False,
                        },
                    },
                    "snapshot": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                },
            }
        ],
        "volumes": [
            {
                "atime_checked": False,
                "atime_opt": "relatime",
                "cacheStatus": "",
                "can_do": {"delete": True, "raid_cross": True},
                "container": "internal",
                "desc": "Located on Storage Pool 1, SHR",
                "device_type": "shr_with_2_disk_protect",
                "disk_failure_number": 0,
                "disks": [],
                "drive_type": 0,
                "eppool_used": "0",
                "exist_alive_vdsm": False,
                "fs_type": "btrfs",
                "id": "volume_1",
                "is_acting": False,
                "is_actioning": False,
                "is_inode_full": False,
                "is_scheduled": False,
                "is_writable": True,
                "last_done_time": 0,
                "limited_disk_number": 24,
                "max_fs_size": "1152921504606846976",
                "next_schedule_time": 0,
                "num_id": 1,
                "pool_path": "reuse_1",
                "progress": {"percent": "-1", "step": "none"},
                "raidType": "multiple",
                "scrubbingStatus": "",
                "size": {
                    "free_inode": "0",
                    "total": "38378964738048",
                    "total_device": "39978088267776",
                    "total_inode": "0",
                    "used": "26724878606336",
                },
                "ssd_trim": {"support": "not support"},
                "status": "normal",
                "suggestions": [],
                "timebackup": False,
                "used_by_gluster": False,
                "vol_path": "/volume1",
                "vspace_can_do": {
                    "drbd": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                    "flashcache": {
                        "apply": {"can_do": True, "errCode": 0, "stopService": True},
                        "remove": {"can_do": True, "errCode": 0, "stopService": False},
                        "resize": {"can_do": True, "errCode": 0, "stopService": False},
                    },
                    "snapshot": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                },
            }
        ],
    },
    "success": True,
}

DSM_6_STORAGE_STORAGE_DS1515_PLUS_SHR2_10DISKS_1VOL_WITH_EXPANSION = {
    "data": {
        "disks": [
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1515+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sda",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 510,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": True,
                "id": "sda",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 1",
                "model": "WD40EFRX-68WT0N0        ",
                "name": "Drive 1",
                "num_id": 1,
                "order": 1,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC4E2JL3SNU",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 33,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1515+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdb",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 490,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": True,
                "id": "sdb",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 2",
                "model": "WD40EFRX-68N32N0        ",
                "name": "Drive 2",
                "num_id": 2,
                "order": 2,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC7K0NAV92K",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 30,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1515+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdc",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 510,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": True,
                "id": "sdc",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 3",
                "model": "WD40EFRX-68WT0N0        ",
                "name": "Drive 3",
                "num_id": 3,
                "order": 3,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC4E4NTR3PK",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 31,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1515+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdd",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 510,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": True,
                "id": "sdd",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 4",
                "model": "WD40EFRX-68WT0N0        ",
                "name": "Drive 4",
                "num_id": 4,
                "order": 4,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC4E2CDEDH1",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 32,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS1515+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sde",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 510,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": True,
                "id": "sde",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 5",
                "model": "WD40EFRX-68WT0N0        ",
                "name": "Drive 5",
                "num_id": 5,
                "order": 5,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC4E2HAC6NK",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 30,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 1,
                    "str": "DX513-1",
                    "supportPwrBtnDisable": True,
                    "type": "ebox",
                },
                "device": "/dev/sdga",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 492,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": False,
                "id": "sdga",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 1 (DX513-1)",
                "model": "WD40EFRX-68N32N0        ",
                "name": "Drive 1 (DX513-1)",
                "num_id": 1,
                "order": 1,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC7K1UZSF9D",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 33,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 1,
                    "str": "DX513-1",
                    "supportPwrBtnDisable": True,
                    "type": "ebox",
                },
                "device": "/dev/sdgb",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 498,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": False,
                "id": "sdgb",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 2 (DX513-1)",
                "model": "WD40EFRX-68N32N0        ",
                "name": "Drive 2 (DX513-1)",
                "num_id": 2,
                "order": 2,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC7K6ZKJE8Y",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 34,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 1,
                    "str": "DX513-1",
                    "supportPwrBtnDisable": True,
                    "type": "ebox",
                },
                "device": "/dev/sdgc",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 494,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": False,
                "id": "sdgc",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 3 (DX513-1)",
                "model": "WD40EFRX-68N32N0        ",
                "name": "Drive 3 (DX513-1)",
                "num_id": 3,
                "order": 3,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC7K6AKHYDP",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 35,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 1,
                    "str": "DX513-1",
                    "supportPwrBtnDisable": True,
                    "type": "ebox",
                },
                "device": "/dev/sdgd",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 502,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": False,
                "id": "sdgd",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 4 (DX513-1)",
                "model": "WD40EFRX-68N32N0        ",
                "name": "Drive 4 (DX513-1)",
                "num_id": 4,
                "order": 4,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC7K7JSL21J",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 35,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 1,
                    "str": "DX513-1",
                    "supportPwrBtnDisable": True,
                    "type": "ebox",
                },
                "device": "/dev/sdge",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 508,
                "exceed_bad_sector_thr": False,
                "firm": "82.00A82",
                "has_system": False,
                "id": "sdge",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 5 (DX513-1)",
                "model": "WD40EFRX-68N32N0        ",
                "name": "Drive 5 (DX513-1)",
                "num_id": 5,
                "order": 5,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-WCC7K6ZKJJ7S",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 34,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
        ],
        "env": {
            "batchtask": {"max_task": 64, "remain_task": 64},
            "bay_number": "5",
            "data_scrubbing": {"sche_enabled": "1", "sche_status": "done"},
            "ebox": [{"id": "sdg", "str": "DX513-1"}],
            "fs_acting": False,
            "isSyncSysPartition": False,
            "is_space_actioning": False,
            "isns": {"address": "", "enabled": False},
            "isns_server": "",
            "max_fs_bytes": "118747255799808",
            "max_fs_bytes_high_end": "219902325555200",
            "model_name": "DS1515+",
            "ram_enough_for_fs_high_end": False,
            "ram_size": 2,
            "ram_size_required": 32,
            "showpooltab": False,
            "status": {"system_crashed": False, "system_need_repair": False},
            "support": {"ebox": True, "raid_cross": True, "sysdef": True},
            "support_fit_fs_limit": True,
            "unique_key": UNIQUE_KEY,
            "volume_full_critical": 0.1,
            "volume_full_warning": 0.2,
        },
        "hotSpareConf": {"cross_repair": True, "disable_repair": []},
        "hotSpares": [],
        "iscsiLuns": [],
        "iscsiTargets": [],
        "ports": [],
        "ssdCaches": [],
        "storagePools": [
            {
                "cacheStatus": "",
                "can_do": {
                    "convert_shr_to_pool": 1,
                    "data_scrubbing": True,
                    "delete": True,
                    "expand_by_disk": 1,
                    "raid_cross": True,
                },
                "container": "cross",
                "deploy_path": "volume_1",
                "desc": "",
                "device_type": "shr_with_2_disk_protect",
                "disk_failure_number": 0,
                "disks": [
                    "sda",
                    "sdb",
                    "sdc",
                    "sdd",
                    "sde",
                    "sdga",
                    "sdgb",
                    "sdgc",
                    "sdgd",
                    "sdge",
                ],
                "drive_type": 0,
                "id": "reuse_1",
                "is_actioning": False,
                "is_scheduled": True,
                "is_writable": True,
                "last_done_time": 1585897389,
                "limited_disk_number": 12,
                "maximal_disk_size": "0",
                "minimal_disk_size": "4000681082880",
                "next_schedule_time": 1588320000,
                "num_id": 1,
                "pool_path": "reuse_1",
                "progress": {"percent": "-1", "step": "none"},
                "raidType": "single",
                "raids": [
                    {
                        "designedDiskCount": 10,
                        "devices": [
                            {"id": "sdge", "slot": 6, "status": "normal"},
                            {"id": "sdgd", "slot": 7, "status": "normal"},
                            {"id": "sdgc", "slot": 8, "status": "normal"},
                            {"id": "sdgb", "slot": 9, "status": "normal"},
                            {"id": "sdga", "slot": 5, "status": "normal"},
                            {"id": "sde", "slot": 4, "status": "normal"},
                            {"id": "sdd", "slot": 3, "status": "normal"},
                            {"id": "sdc", "slot": 2, "status": "normal"},
                            {"id": "sdb", "slot": 1, "status": "normal"},
                            {"id": "sda", "slot": 0, "status": "normal"},
                        ],
                        "hasParity": True,
                        "minDevSize": "4000681082880",
                        "normalDevCount": 10,
                        "raidPath": "/dev/md2",
                        "raidStatus": 1,
                        "spares": [],
                    }
                ],
                "scrubbingStatus": "done",
                "size": {"total": "31966715969536", "used": "31966715969536"},
                "space_path": "/dev/vg1000/lv",
                "spares": [],
                "ssd_trim": {"support": "not support"},
                "status": "normal",
                "suggestions": [],
                "timebackup": False,
                "vspace_can_do": {
                    "drbd": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                    "flashcache": {
                        "apply": {"can_do": True, "errCode": 0, "stopService": True},
                        "remove": {"can_do": True, "errCode": 0, "stopService": False},
                        "resize": {"can_do": True, "errCode": 0, "stopService": False},
                    },
                    "snapshot": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                },
            }
        ],
        "volumes": [
            {
                "atime_checked": False,
                "atime_opt": "relatime",
                "cacheStatus": "",
                "can_do": {
                    "convert_shr_to_pool": 1,
                    "data_scrubbing": True,
                    "delete": True,
                    "expand_by_disk": 1,
                    "raid_cross": True,
                },
                "container": "cross",
                "deploy_path": "volume_1",
                "desc": "",
                "device_type": "shr_with_2_disk_protect",
                "disk_failure_number": 0,
                "disks": [],
                "drive_type": 0,
                "eppool_used": "0",
                "exist_alive_vdsm": False,
                "fs_type": "ext4",
                "id": "volume_1",
                "is_acting": False,
                "is_actioning": False,
                "is_inode_full": False,
                "is_scheduled": True,
                "is_writable": True,
                "last_done_time": 1585897389,
                "limited_disk_number": 12,
                "max_fs_size": "1152921504606846976",
                "next_schedule_time": 1588320000,
                "num_id": 1,
                "pool_path": "reuse_1",
                "progress": {"percent": "-1", "step": "none"},
                "raidType": "single",
                "scrubbingStatus": "done",
                "size": {
                    "free_inode": "974296118",
                    "total": "31714659872768",
                    "total_device": "31966715969536",
                    "total_inode": "975548416",
                    "used": "25419707531264",
                },
                "ssd_trim": {"support": "not support"},
                "status": "normal",
                "suggestions": [{"str": "volume_usage_suggestion", "type": "warning"}],
                "timebackup": False,
                "used_by_gluster": False,
                "vol_path": "/volume1",
                "vspace_can_do": {
                    "drbd": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                    "flashcache": {
                        "apply": {"can_do": True, "errCode": 0, "stopService": True},
                        "remove": {"can_do": True, "errCode": 0, "stopService": False},
                        "resize": {"can_do": True, "errCode": 0, "stopService": False},
                    },
                    "snapshot": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                },
            }
        ],
    },
    "success": True,
}

DSM_6_STORAGE_STORAGE_DS213_PLUS_SHR1_2DISKS_2VOLS = {
    "data": {
        "disks": [
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS213+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sda",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 510,
                "exceed_bad_sector_thr": False,
                "firm": "80.00A80",
                "has_system": True,
                "id": "sda",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 1",
                "model": "WD30E",
                "name": "Drive 1",
                "num_id": 1,
                "order": 1,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "WD-xxxxx",
                "size_total": "3000592982016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 29,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "WDC     ",
            },
            {
                "adv_progress": "",
                "adv_status": "not_support",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS213+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdb",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "",
                "erase_time": 424,
                "exceed_bad_sector_thr": False,
                "firm": "1AN10003",
                "has_system": True,
                "id": "sdb",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 2",
                "model": "HD20xxx",
                "name": "Drive 2",
                "num_id": 2,
                "order": 2,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "S1Uxxxxxxxxxxxx",
                "size_total": "2000398934016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 30,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_2",
                "vendor": "SAMSUNG ",
            },
        ],
        "env": {
            "batchtask": {"max_task": 64, "remain_task": 64},
            "bay_number": "2",
            "data_scrubbing": {"sche_enabled": "0", "sche_status": "disabled"},
            "ebox": [],
            "fs_acting": False,
            "isSyncSysPartition": False,
            "is_space_actioning": False,
            "isns": {"address": "", "enabled": False},
            "isns_server": "",
            "max_fs_bytes": "17592181850112",
            "max_fs_bytes_high_end": "219902325555200",
            "model_name": "DS213+",
            "ram_enough_for_fs_high_end": False,
            "ram_size": 0,
            "ram_size_required": 32,
            "showpooltab": True,
            "status": {"system_crashed": False, "system_need_repair": False},
            "support": {"ebox": True, "raid_cross": False, "sysdef": True},
            "support_fit_fs_limit": False,
            "unique_key": UNIQUE_KEY,
            "volume_full_critical": 0.05,
            "volume_full_warning": 0.1,
        },
        "hotSpareConf": {"cross_repair": True, "disable_repair": []},
        "hotSpares": [],
        "iscsiLuns": [],
        "iscsiTargets": [],
        "ports": [],
        "storagePools": [
            {
                "cacheStatus": "",
                "can_do": {
                    "delete": True,
                    "expand_by_disk": 1,
                    "migrate": {"to_shr2": 3},
                },
                "container": "internal",
                "desc": "Diskgroep 2",
                "device_type": "shr_without_disk_protect",
                "disk_failure_number": 0,
                "disks": ["sdb"],
                "drive_type": 0,
                "id": "reuse_2",
                "is_actioning": False,
                "is_scheduled": False,
                "is_writable": True,
                "last_done_time": 0,
                "limited_disk_number": 12,
                "maximal_disk_size": "0",
                "minimal_disk_size": "2000292986880",
                "next_schedule_time": 0,
                "num_id": 2,
                "pool_child": [{"id": "volume_2", "size": {"total": "1995435933696"}}],
                "pool_path": "reuse_2",
                "progress": {"percent": "-1", "step": "none"},
                "raidType": "multiple",
                "raids": [
                    {
                        "designedDiskCount": 1,
                        "devices": [{"id": "sdb", "slot": 0, "status": "normal"}],
                        "hasParity": False,
                        "minDevSize": "2000292986880",
                        "normalDevCount": 1,
                        "raidPath": "/dev/md3",
                        "raidStatus": 1,
                        "spares": [],
                    }
                ],
                "scrubbingStatus": "has_not_run_yet",
                "size": {"total": "1995448516608", "used": "1995448516608"},
                "space_path": "/dev/vg2",
                "spares": [],
                "status": "normal",
                "suggestions": [],
                "timebackup": False,
                "vspace_can_do": {
                    "drbd": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                    "flashcache": {
                        "apply": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                        "remove": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                    },
                    "snapshot": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                },
            },
            {
                "cacheStatus": "",
                "can_do": {
                    "delete": True,
                    "expand_by_disk": 1,
                    "migrate": {"to_shr2": 3},
                },
                "container": "internal",
                "desc": "Diskgroep1",
                "device_type": "shr_without_disk_protect",
                "disk_failure_number": 0,
                "disks": ["sda"],
                "drive_type": 0,
                "id": "reuse_1",
                "is_actioning": False,
                "is_scheduled": False,
                "is_writable": True,
                "last_done_time": 0,
                "limited_disk_number": 12,
                "maximal_disk_size": "0",
                "minimal_disk_size": "3000487034880",
                "next_schedule_time": 0,
                "num_id": 1,
                "pool_child": [{"id": "volume_1", "size": {"total": "2995630637056"}}],
                "pool_path": "reuse_1",
                "progress": {"percent": "-1", "step": "none"},
                "raidType": "multiple",
                "raids": [
                    {
                        "designedDiskCount": 1,
                        "devices": [{"id": "sda", "slot": 0, "status": "normal"}],
                        "hasParity": False,
                        "minDevSize": "3000487034880",
                        "normalDevCount": 1,
                        "raidPath": "/dev/md2",
                        "raidStatus": 1,
                        "spares": [],
                    }
                ],
                "scrubbingStatus": "has_not_run_yet",
                "size": {"total": "2995643219968", "used": "2995643219968"},
                "space_path": "/dev/vg1",
                "spares": [],
                "status": "normal",
                "suggestions": [],
                "timebackup": False,
                "vspace_can_do": {
                    "drbd": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                    "flashcache": {
                        "apply": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                        "remove": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                    },
                    "snapshot": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                },
            },
        ],
        "volumes": [
            {
                "atime_checked": False,
                "atime_opt": "relatime",
                "cacheStatus": "",
                "can_do": {"delete": True},
                "container": "internal",
                "desc": "Volume_Diskgroep2",
                "device_type": "shr_without_disk_protect",
                "disk_failure_number": 0,
                "disks": [],
                "drive_type": 0,
                "eppool_used": "0",
                "exist_alive_vdsm": False,
                "fs_type": "ext4",
                "id": "volume_2",
                "is_acting": False,
                "is_actioning": False,
                "is_inode_full": False,
                "is_scheduled": False,
                "is_writable": True,
                "last_done_time": 0,
                "limited_disk_number": 12,
                "max_fs_size": "17577577283584",
                "next_schedule_time": 0,
                "num_id": 2,
                "pool_path": "reuse_2",
                "progress": {"percent": "-1", "step": "none"},
                "raidType": "multiple",
                "scrubbingStatus": "",
                "size": {
                    "free_inode": "121689412",
                    "total": "1964124495872",
                    "total_device": "1995435933696",
                    "total_inode": "121798656",
                    "used": "1684179374080",
                },
                "ssd_trim": {"support": "not support"},
                "status": "normal",
                "suggestions": [],
                "timebackup": False,
                "used_by_gluster": False,
                "vol_path": "/volume2",
                "vspace_can_do": {
                    "drbd": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                    "flashcache": {
                        "apply": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                        "remove": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                    },
                    "snapshot": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                },
            },
            {
                "atime_checked": False,
                "atime_opt": "relatime",
                "cacheStatus": "",
                "can_do": {"delete": True},
                "container": "internal",
                "desc": "Volume_Diskgroep1",
                "device_type": "shr_without_disk_protect",
                "disk_failure_number": 0,
                "disks": [],
                "drive_type": 0,
                "eppool_used": "0",
                "exist_alive_vdsm": False,
                "fs_type": "ext4",
                "id": "volume_1",
                "is_acting": False,
                "is_actioning": False,
                "is_inode_full": False,
                "is_scheduled": False,
                "is_writable": True,
                "last_done_time": 0,
                "limited_disk_number": 12,
                "max_fs_size": "17581339574272",
                "next_schedule_time": 0,
                "num_id": 1,
                "pool_path": "reuse_1",
                "progress": {"percent": "-1", "step": "none"},
                "raidType": "multiple",
                "scrubbingStatus": "",
                "size": {
                    "free_inode": "182794183",
                    "total": "2948623499264",
                    "total_device": "2995630637056",
                    "total_inode": "182845440",
                    "used": "2710796488704",
                },
                "ssd_trim": {"support": "not support"},
                "status": "normal",
                "suggestions": [{"str": "volume_usage_suggestion", "type": "warning"}],
                "timebackup": False,
                "used_by_gluster": False,
                "vol_path": "/volume1",
                "vspace_can_do": {
                    "drbd": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                    "flashcache": {
                        "apply": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                        "remove": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        },
                    },
                    "snapshot": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                },
            },
        ],
    },
    "success": True,
}

DSM_6_STORAGE_STORAGE_DS918_PLUS_RAID5_3DISKS_1VOL = {
    "data": {
        "disks": [
            {"id": "test_disk"},
            {
                "adv_progress": "",
                "adv_status": "normal",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS918+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sda",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "ironwolf",
                "erase_time": 448,
                "exceed_bad_sector_thr": False,
                "firm": "SC60",
                "has_system": True,
                "id": "sda",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 1",
                "model": "ST4000VN008-2DR166      ",
                "name": "Drive 1",
                "num_id": 1,
                "order": 1,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "ZDH4LYTS",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 24,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "Seagate",
            },
            {
                "adv_progress": "",
                "adv_status": "normal",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS918+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdb",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "ironwolf",
                "erase_time": 448,
                "exceed_bad_sector_thr": False,
                "firm": "SC60",
                "has_system": True,
                "id": "sdb",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 2",
                "model": "ST4000VN008-2DR166      ",
                "name": "Drive 2",
                "num_id": 2,
                "order": 2,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "ZDH4LS72",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 24,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "Seagate",
            },
            {
                "adv_progress": "",
                "adv_status": "normal",
                "below_remain_life_thr": False,
                "compatibility": "disabled",
                "container": {
                    "order": 0,
                    "str": "DS918+",
                    "supportPwrBtnDisable": False,
                    "type": "internal",
                },
                "device": "/dev/sdc",
                "disable_secera": False,
                "diskType": "SATA",
                "disk_code": "ironwolf",
                "erase_time": 452,
                "exceed_bad_sector_thr": False,
                "firm": "SC60",
                "has_system": True,
                "id": "sdc",
                "ihm_testing": False,
                "is4Kn": False,
                "isSsd": False,
                "isSynoPartition": True,
                "is_erasing": False,
                "longName": "Drive 3",
                "model": "ST4000VN008-2DR166      ",
                "name": "Drive 3",
                "num_id": 3,
                "order": 3,
                "overview_status": "normal",
                "pciSlot": -1,
                "perf_testing": False,
                "portType": "normal",
                "remain_life": -1,
                "remote_info": {"compatibility": "disabled", "unc": 0},
                "serial": "ZDH4LQ1H",
                "size_total": "4000787030016",
                "smart_progress": "",
                "smart_status": "normal",
                "smart_test_limit": 0,
                "smart_testing": False,
                "status": "normal",
                "support": False,
                "temp": 23,
                "testing_progress": "",
                "testing_type": "",
                "tray_status": "join",
                "unc": 0,
                "used_by": "reuse_1",
                "vendor": "Seagate",
            },
        ],
        "env": {
            "batchtask": {"max_task": 64, "remain_task": 64},
            "bay_number": "4",
            "data_scrubbing": {
                "sche_enabled": "0",
                "sche_status": "disabled",
            },
            "ebox": [],
            "fs_acting": False,
            "isSyncSysPartition": False,
            "is_space_actioning": False,
            "isns": {"address": "", "enabled": False},
            "isns_server": "",
            "max_fs_bytes": "118747255799808",
            "max_fs_bytes_high_end": "219902325555200",
            "model_name": "DS918+",
            "ram_enough_for_fs_high_end": False,
            "ram_size": 4,
            "ram_size_required": 32,
            "showpooltab": False,
            "status": {
                "system_crashed": False,
                "system_need_repair": False,
            },
            "support": {
                "ebox": True,
                "raid_cross": True,
                "sysdef": True,
            },
            "support_fit_fs_limit": True,
            "unique_key": UNIQUE_KEY,
            "volume_full_critical": 0.1,
            "volume_full_warning": 0.2,
        },
        "hotSpareConf": {"cross_repair": True, "disable_repair": []},
        "hotSpares": [],
        "iscsiLuns": [],
        "iscsiTargets": [],
        "ports": [],
        "ssdCaches": [],
        "storagePools": [
            {
                "cacheStatus": "",
                "can_do": {
                    "data_scrubbing": True,
                    "delete": True,
                    "expand_by_disk": 1,
                    "migrate": {"to_raid5+spare": "1-1", "to_raid6": 1},
                    "raid_cross": True,
                },
                "container": "internal",
                "deploy_path": "volume_1",
                "desc": "Situé sur Groupe de stockage 1, RAID 5",
                "device_type": "raid_5",
                "disk_failure_number": 0,
                "disks": ["sda", "sdb", "sdc"],
                "drive_type": 0,
                "id": "reuse_1",
                "is_actioning": False,
                "is_scheduled": False,
                "is_writable": True,
                "last_done_time": 1551201018,
                "limited_disk_number": 24,
                "maximal_disk_size": "0",
                "minimal_disk_size": "4000681164800",
                "next_schedule_time": 0,
                "num_id": 1,
                "pool_path": "reuse_1",
                "progress": {"percent": "-1", "step": "none"},
                "raidType": "single",
                "raids": [
                    {
                        "designedDiskCount": 3,
                        "devices": [
                            {
                                "id": "sdc",
                                "slot": 2,
                                "status": "normal",
                            },
                            {
                                "id": "sdb",
                                "slot": 1,
                                "status": "normal",
                            },
                            {
                                "id": "sda",
                                "slot": 0,
                                "status": "normal",
                            },
                        ],
                        "hasParity": True,
                        "minDevSize": "4000681164800",
                        "normalDevCount": 3,
                        "raidPath": "/dev/md2",
                        "raidStatus": 1,
                        "spares": [],
                    }
                ],
                "scrubbingStatus": "no_action",
                "size": {
                    "total": "7991698522112",
                    "used": "7991698522112",
                },
                "space_path": "/dev/md2",
                "ssd_trim": {"support": "not support"},
                "status": "normal",
                "suggestions": [],
                "timebackup": False,
                "vspace_can_do": {
                    "drbd": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                    "flashcache": {
                        "apply": {
                            "can_do": True,
                            "errCode": 0,
                            "stopService": True,
                        },
                        "remove": {
                            "can_do": True,
                            "errCode": 0,
                            "stopService": False,
                        },
                        "resize": {
                            "can_do": True,
                            "errCode": 0,
                            "stopService": False,
                        },
                    },
                    "snapshot": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                },
            }
        ],
        "volumes": [
            {"id": "test_volume"},
            {
                "atime_checked": False,
                "atime_opt": "relatime",
                "cacheStatus": "",
                "can_do": {
                    "data_scrubbing": True,
                    "delete": True,
                    "expand_by_disk": 1,
                    "migrate": {"to_raid5+spare": "1-1", "to_raid6": 1},
                    "raid_cross": True,
                },
                "container": "internal",
                "deploy_path": "volume_1",
                "desc": "Situé sur Groupe de stockage 1, RAID 5",
                "device_type": "raid_5",
                "disk_failure_number": 0,
                "disks": [],
                "drive_type": 0,
                "eppool_used": "0",
                "exist_alive_vdsm": False,
                "fs_type": "btrfs",
                "id": "volume_1",
                "is_acting": False,
                "is_actioning": False,
                "is_inode_full": False,
                "is_scheduled": False,
                "is_writable": True,
                "last_done_time": 1551201018,
                "limited_disk_number": 24,
                "max_fs_size": "1152921504606846976",
                "next_schedule_time": 0,
                "num_id": 1,
                "pool_path": "reuse_1",
                "progress": {"percent": "-1", "step": "none"},
                "raidType": "single",
                "scrubbingStatus": "no_action",
                "size": {
                    "free_inode": "0",
                    "total": "7672030584832",
                    "total_device": "7991698522112",
                    "total_inode": "0",
                    "used": "4377452806144",
                },
                "ssd_trim": {"support": "not support"},
                "status": "normal",
                "suggestions": [],
                "timebackup": False,
                "used_by_gluster": False,
                "vol_path": "/volume1",
                "vspace_can_do": {
                    "drbd": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                    "flashcache": {
                        "apply": {
                            "can_do": True,
                            "errCode": 0,
                            "stopService": True,
                        },
                        "remove": {
                            "can_do": True,
                            "errCode": 0,
                            "stopService": False,
                        },
                        "resize": {
                            "can_do": True,
                            "errCode": 0,
                            "stopService": False,
                        },
                    },
                    "snapshot": {
                        "resize": {
                            "can_do": False,
                            "errCode": 53504,
                            "stopService": False,
                        }
                    },
                },
            },
        ],
    },
    "success": True,
}
