# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from typing import Any, Callable, Dict, Literal, Optional, TypeVar, Union

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._policy_events_operations import (
    build_list_query_results_for_management_group_request,
    build_list_query_results_for_policy_definition_request,
    build_list_query_results_for_policy_set_definition_request,
    build_list_query_results_for_resource_group_level_policy_assignment_request,
    build_list_query_results_for_resource_group_request,
    build_list_query_results_for_resource_request,
    build_list_query_results_for_subscription_level_policy_assignment_request,
    build_list_query_results_for_subscription_request,
    build_next_link_request,
)
from .._configuration import PolicyInsightsClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class PolicyEventsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.policyinsights.aio.PolicyInsightsClient`'s
        :attr:`policy_events` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: PolicyInsightsClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_query_results_for_management_group(
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        management_group_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the resources under the management group.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param management_group_name: Management group name. Required.
        :type management_group_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        management_groups_namespace: Literal["Microsoft.Management"] = kwargs.pop(
            "management_groups_namespace", "Microsoft.Management"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_management_group_request(
                    policy_events_resource=policy_events_resource,
                    management_group_name=management_group_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    management_groups_namespace=management_groups_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_subscription(
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the resources under the subscription.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_subscription_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_resource_group(
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        resource_group_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the resources under the resource group.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Resource group name. Required.
        :type resource_group_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_resource_group_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_resource(
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        resource_id: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the resource.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param resource_id: Resource ID. Required.
        :type resource_id: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _expand = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _expand = query_options.expand
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_resource_request(
                    policy_events_resource=policy_events_resource,
                    resource_id=resource_id,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    expand=_expand,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _expand = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _expand = query_options.expand
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_policy_set_definition(  # pylint: disable=name-too-long
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        policy_set_definition_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the subscription level policy set definition.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_set_definition_name: Policy set definition name. Required.
        :type policy_set_definition_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_policy_set_definition_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    policy_set_definition_name=policy_set_definition_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_policy_definition(
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        policy_definition_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the subscription level policy definition.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_definition_name: Policy definition name. Required.
        :type policy_definition_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_policy_definition_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    policy_definition_name=policy_definition_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_subscription_level_policy_assignment(  # pylint: disable=name-too-long
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        policy_assignment_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the subscription level policy assignment.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param policy_assignment_name: Policy assignment name. Required.
        :type policy_assignment_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_subscription_level_policy_assignment_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    policy_assignment_name=policy_assignment_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_query_results_for_resource_group_level_policy_assignment(  # pylint: disable=name-too-long
        self,
        policy_events_resource: Union[str, _models.PolicyEventsResourceType],
        subscription_id: str,
        resource_group_name: str,
        policy_assignment_name: str,
        query_options: Optional[_models.QueryOptions] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.PolicyEvent"]:
        """Queries policy events for the resource group level policy assignment.

        :param policy_events_resource: The name of the virtual resource under PolicyEvents resource
         type; only "default" is allowed. "default" Required.
        :type policy_events_resource: str or ~azure.mgmt.policyinsights.models.PolicyEventsResourceType
        :param subscription_id: Microsoft Azure subscription ID. Required.
        :type subscription_id: str
        :param resource_group_name: Resource group name. Required.
        :type resource_group_name: str
        :param policy_assignment_name: Policy assignment name. Required.
        :type policy_assignment_name: str
        :param query_options: Parameter group. Default value is None.
        :type query_options: ~azure.mgmt.policyinsights.models.QueryOptions
        :return: An iterator like instance of either PolicyEvent or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.policyinsights.models.PolicyEvent]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        authorization_namespace: Literal["Microsoft.Authorization"] = kwargs.pop(
            "authorization_namespace", "Microsoft.Authorization"
        )
        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-10-01"))
        cls: ClsType[_models.PolicyEventsQueryResults] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_list_query_results_for_resource_group_level_policy_assignment_request(
                    policy_events_resource=policy_events_resource,
                    subscription_id=subscription_id,
                    resource_group_name=resource_group_name,
                    policy_assignment_name=policy_assignment_name,
                    top=_top,
                    order_by=_order_by,
                    select=_select,
                    from_property=_from_property,
                    to=_to,
                    filter=_filter,
                    apply=_apply,
                    skip_token=_skip_token,
                    authorization_namespace=authorization_namespace,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _top = None
                _order_by = None
                _select = None
                _from_property = None
                _to = None
                _filter = None
                _apply = None
                _skip_token = None
                if query_options is not None:
                    _apply = query_options.apply
                    _filter = query_options.filter
                    _from_property = query_options.from_property
                    _order_by = query_options.order_by
                    _select = query_options.select
                    _skip_token = query_options.skip_token
                    _to = query_options.to
                    _top = query_options.top

                _request = build_next_link_request(
                    next_link=next_link,
                    skip_token=_skip_token,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PolicyEventsQueryResults", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.odata_next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.QueryFailure, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
