# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.iothubprovisioningservices.aio import IotDpsClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestIotDpsDpsCertificateOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(IotDpsClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dps_certificate_get(self, resource_group):
        response = await self.client.dps_certificate.get(
            resource_group_name=resource_group.name,
            provisioning_service_name="str",
            certificate_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dps_certificate_create_or_update(self, resource_group):
        response = await self.client.dps_certificate.create_or_update(
            resource_group_name=resource_group.name,
            provisioning_service_name="str",
            certificate_name="str",
            certificate_description={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "certificate": bytes("bytes", encoding="utf-8"),
                    "created": "2020-02-20 00:00:00",
                    "expiry": "2020-02-20 00:00:00",
                    "isVerified": bool,
                    "subject": "str",
                    "thumbprint": "str",
                    "updated": "2020-02-20 00:00:00",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dps_certificate_delete(self, resource_group):
        response = await self.client.dps_certificate.delete(
            resource_group_name=resource_group.name,
            provisioning_service_name="str",
            certificate_name="str",
            etag="str",
            match_condition=~azure.core.MatchConditions,
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dps_certificate_list(self, resource_group):
        response = self.client.dps_certificate.list(
            resource_group_name=resource_group.name,
            provisioning_service_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dps_certificate_generate_verification_code(self, resource_group):
        response = await self.client.dps_certificate.generate_verification_code(
            resource_group_name=resource_group.name,
            provisioning_service_name="str",
            certificate_name="str",
            etag="str",
            match_condition=~azure.core.MatchConditions,
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dps_certificate_verify_certificate(self, resource_group):
        response = await self.client.dps_certificate.verify_certificate(
            resource_group_name=resource_group.name,
            provisioning_service_name="str",
            certificate_name="str",
            request={"certificate": "str"},
            etag="str",
            match_condition=~azure.core.MatchConditions,
        )

        # please add some check logic here by yourself
        # ...
