# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class RestRequestAuthentication(_serialization.Model):
    """The authentication information required in the REST health check request to the health provider.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ApiKeyAuthentication, RolloutIdentityAuthentication

    All required parameters must be populated in order to send to Azure.

    :ivar type: The authentication type. Required. Known values are: "ApiKey" and
     "RolloutIdentity".
    :vartype type: str or ~azure.mgmt.deploymentmanager.models.RestAuthType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"ApiKey": "ApiKeyAuthentication", "RolloutIdentity": "RolloutIdentityAuthentication"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class ApiKeyAuthentication(RestRequestAuthentication):
    """ApiKey authentication gives a name and a value that can be included in either the request header or query parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The authentication type. Required. Known values are: "ApiKey" and
     "RolloutIdentity".
    :vartype type: str or ~azure.mgmt.deploymentmanager.models.RestAuthType
    :ivar name: The key name of the authentication key/value pair. Required.
    :vartype name: str
    :ivar in_property: The location of the authentication key/value pair in the request. Required.
     Known values are: "Query" and "Header".
    :vartype in_property: str or ~azure.mgmt.deploymentmanager.models.RestAuthLocation
    :ivar value: The value of the authentication key/value pair. Required.
    :vartype value: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
        "in_property": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "in_property": {"key": "in", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, in_property: Union[str, "_models.RestAuthLocation"], value: str, **kwargs):
        """
        :keyword name: The key name of the authentication key/value pair. Required.
        :paramtype name: str
        :keyword in_property: The location of the authentication key/value pair in the request.
         Required. Known values are: "Query" and "Header".
        :paramtype in_property: str or ~azure.mgmt.deploymentmanager.models.RestAuthLocation
        :keyword value: The value of the authentication key/value pair. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.type = "ApiKey"  # type: str
        self.name = name
        self.in_property = in_property
        self.value = value


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class ArtifactSource(TrackedResource):
    """The resource that defines the source location where the artifacts are located.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar source_type: The type of artifact source used.
    :vartype source_type: str
    :ivar artifact_root: The path from the location that the 'authentication' property [say, a SAS
     URI to the blob container] refers to, to the location of the artifacts. This can be used to
     differentiate different versions of the artifacts. Or, different types of artifacts like
     binaries or templates. The location referenced by the authentication property concatenated with
     this optional artifactRoot path forms the artifact source location where the artifacts are
     expected to be found.
    :vartype artifact_root: str
    :ivar authentication: The authentication method to use to access the artifact source.
    :vartype authentication: ~azure.mgmt.deploymentmanager.models.Authentication
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "source_type": {"key": "properties.sourceType", "type": "str"},
        "artifact_root": {"key": "properties.artifactRoot", "type": "str"},
        "authentication": {"key": "properties.authentication", "type": "Authentication"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        source_type: Optional[str] = None,
        artifact_root: Optional[str] = None,
        authentication: Optional["_models.Authentication"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword source_type: The type of artifact source used.
        :paramtype source_type: str
        :keyword artifact_root: The path from the location that the 'authentication' property [say, a
         SAS URI to the blob container] refers to, to the location of the artifacts. This can be used to
         differentiate different versions of the artifacts. Or, different types of artifacts like
         binaries or templates. The location referenced by the authentication property concatenated with
         this optional artifactRoot path forms the artifact source location where the artifacts are
         expected to be found.
        :paramtype artifact_root: str
        :keyword authentication: The authentication method to use to access the artifact source.
        :paramtype authentication: ~azure.mgmt.deploymentmanager.models.Authentication
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.source_type = source_type
        self.artifact_root = artifact_root
        self.authentication = authentication


class ArtifactSourcePropertiesAutoGenerated(_serialization.Model):
    """The properties that define the source location where the artifacts are located.

    All required parameters must be populated in order to send to Azure.

    :ivar source_type: The type of artifact source used. Required.
    :vartype source_type: str
    :ivar artifact_root: The path from the location that the 'authentication' property [say, a SAS
     URI to the blob container] refers to, to the location of the artifacts. This can be used to
     differentiate different versions of the artifacts. Or, different types of artifacts like
     binaries or templates. The location referenced by the authentication property concatenated with
     this optional artifactRoot path forms the artifact source location where the artifacts are
     expected to be found.
    :vartype artifact_root: str
    :ivar authentication: The authentication method to use to access the artifact source. Required.
    :vartype authentication: ~azure.mgmt.deploymentmanager.models.Authentication
    """

    _validation = {
        "source_type": {"required": True},
        "authentication": {"required": True},
    }

    _attribute_map = {
        "source_type": {"key": "sourceType", "type": "str"},
        "artifact_root": {"key": "artifactRoot", "type": "str"},
        "authentication": {"key": "authentication", "type": "Authentication"},
    }

    def __init__(
        self,
        *,
        source_type: str,
        authentication: "_models.Authentication",
        artifact_root: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source_type: The type of artifact source used. Required.
        :paramtype source_type: str
        :keyword artifact_root: The path from the location that the 'authentication' property [say, a
         SAS URI to the blob container] refers to, to the location of the artifacts. This can be used to
         differentiate different versions of the artifacts. Or, different types of artifacts like
         binaries or templates. The location referenced by the authentication property concatenated with
         this optional artifactRoot path forms the artifact source location where the artifacts are
         expected to be found.
        :paramtype artifact_root: str
        :keyword authentication: The authentication method to use to access the artifact source.
         Required.
        :paramtype authentication: ~azure.mgmt.deploymentmanager.models.Authentication
        """
        super().__init__(**kwargs)
        self.source_type = source_type
        self.artifact_root = artifact_root
        self.authentication = authentication


class ArtifactSourceProperties(ArtifactSourcePropertiesAutoGenerated):
    """The properties that define the artifact source.

    All required parameters must be populated in order to send to Azure.

    :ivar source_type: The type of artifact source used. Required.
    :vartype source_type: str
    :ivar artifact_root: The path from the location that the 'authentication' property [say, a SAS
     URI to the blob container] refers to, to the location of the artifacts. This can be used to
     differentiate different versions of the artifacts. Or, different types of artifacts like
     binaries or templates. The location referenced by the authentication property concatenated with
     this optional artifactRoot path forms the artifact source location where the artifacts are
     expected to be found.
    :vartype artifact_root: str
    :ivar authentication: The authentication method to use to access the artifact source. Required.
    :vartype authentication: ~azure.mgmt.deploymentmanager.models.Authentication
    """

    _validation = {
        "source_type": {"required": True},
        "authentication": {"required": True},
    }

    _attribute_map = {
        "source_type": {"key": "sourceType", "type": "str"},
        "artifact_root": {"key": "artifactRoot", "type": "str"},
        "authentication": {"key": "authentication", "type": "Authentication"},
    }

    def __init__(
        self,
        *,
        source_type: str,
        authentication: "_models.Authentication",
        artifact_root: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword source_type: The type of artifact source used. Required.
        :paramtype source_type: str
        :keyword artifact_root: The path from the location that the 'authentication' property [say, a
         SAS URI to the blob container] refers to, to the location of the artifacts. This can be used to
         differentiate different versions of the artifacts. Or, different types of artifacts like
         binaries or templates. The location referenced by the authentication property concatenated with
         this optional artifactRoot path forms the artifact source location where the artifacts are
         expected to be found.
        :paramtype artifact_root: str
        :keyword authentication: The authentication method to use to access the artifact source.
         Required.
        :paramtype authentication: ~azure.mgmt.deploymentmanager.models.Authentication
        """
        super().__init__(source_type=source_type, artifact_root=artifact_root, authentication=authentication, **kwargs)


class Authentication(_serialization.Model):
    """Defines the authentication method and properties to access the artifacts.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SasAuthentication

    All required parameters must be populated in order to send to Azure.

    :ivar type: The authentication type. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"Sas": "SasAuthentication"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]


class CloudErrorBody(_serialization.Model):
    """Detailed error information of any failure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code string.
    :vartype code: str
    :ivar message: Descriptive error information.
    :vartype message: str
    :ivar target: Error target.
    :vartype target: str
    :ivar details: More detailed error information.
    :vartype details: list[~azure.mgmt.deploymentmanager.models.CloudErrorBody]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self, *, target: Optional[str] = None, details: Optional[List["_models.CloudErrorBody"]] = None, **kwargs
    ):
        """
        :keyword target: Error target.
        :paramtype target: str
        :keyword details: More detailed error information.
        :paramtype details: list[~azure.mgmt.deploymentmanager.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = target
        self.details = details


class HealthCheckStepAttributes(_serialization.Model):
    """The attributes for the health check step.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    RestHealthCheckStepAttributes

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of health check. Required.
    :vartype type: str
    :ivar wait_duration: The duration in ISO 8601 format for which health check waits idly without
     any checks.
    :vartype wait_duration: str
    :ivar max_elastic_duration: The duration in ISO 8601 format for which the health check waits
     for the resource to become healthy. Health check fails if it doesn't. Health check starts to
     enforce healthyStateDuration once resource becomes healthy.
    :vartype max_elastic_duration: str
    :ivar healthy_state_duration: The duration in ISO 8601 format for which the resource is
     expected to be continuously healthy. If maxElasticDuration is specified, healthy state duration
     is enforced after the detection of first healthy signal. Required.
    :vartype healthy_state_duration: str
    """

    _validation = {
        "type": {"required": True},
        "healthy_state_duration": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "wait_duration": {"key": "waitDuration", "type": "str"},
        "max_elastic_duration": {"key": "maxElasticDuration", "type": "str"},
        "healthy_state_duration": {"key": "healthyStateDuration", "type": "str"},
    }

    _subtype_map = {"type": {"REST": "RestHealthCheckStepAttributes"}}

    def __init__(
        self,
        *,
        healthy_state_duration: str,
        wait_duration: Optional[str] = None,
        max_elastic_duration: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword wait_duration: The duration in ISO 8601 format for which health check waits idly
         without any checks.
        :paramtype wait_duration: str
        :keyword max_elastic_duration: The duration in ISO 8601 format for which the health check waits
         for the resource to become healthy. Health check fails if it doesn't. Health check starts to
         enforce healthyStateDuration once resource becomes healthy.
        :paramtype max_elastic_duration: str
        :keyword healthy_state_duration: The duration in ISO 8601 format for which the resource is
         expected to be continuously healthy. If maxElasticDuration is specified, healthy state duration
         is enforced after the detection of first healthy signal. Required.
        :paramtype healthy_state_duration: str
        """
        super().__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.wait_duration = wait_duration
        self.max_elastic_duration = max_elastic_duration
        self.healthy_state_duration = healthy_state_duration


class StepProperties(_serialization.Model):
    """The properties of a step resource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    HealthCheckStepProperties, WaitStepProperties

    All required parameters must be populated in order to send to Azure.

    :ivar step_type: The type of step. Required. Known values are: "Wait" and "HealthCheck".
    :vartype step_type: str or ~azure.mgmt.deploymentmanager.models.StepType
    """

    _validation = {
        "step_type": {"required": True},
    }

    _attribute_map = {
        "step_type": {"key": "stepType", "type": "str"},
    }

    _subtype_map = {"step_type": {"HealthCheck": "HealthCheckStepProperties", "Wait": "WaitStepProperties"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.step_type = None  # type: Optional[str]


class HealthCheckStepProperties(StepProperties):
    """Defines the properties of a health check step.

    All required parameters must be populated in order to send to Azure.

    :ivar step_type: The type of step. Required. Known values are: "Wait" and "HealthCheck".
    :vartype step_type: str or ~azure.mgmt.deploymentmanager.models.StepType
    :ivar attributes: The health check step attributes. Required.
    :vartype attributes: ~azure.mgmt.deploymentmanager.models.HealthCheckStepAttributes
    """

    _validation = {
        "step_type": {"required": True},
        "attributes": {"required": True},
    }

    _attribute_map = {
        "step_type": {"key": "stepType", "type": "str"},
        "attributes": {"key": "attributes", "type": "HealthCheckStepAttributes"},
    }

    def __init__(self, *, attributes: "_models.HealthCheckStepAttributes", **kwargs):
        """
        :keyword attributes: The health check step attributes. Required.
        :paramtype attributes: ~azure.mgmt.deploymentmanager.models.HealthCheckStepAttributes
        """
        super().__init__(**kwargs)
        self.step_type = "HealthCheck"  # type: str
        self.attributes = attributes


class Identity(_serialization.Model):
    """Identity for the resource.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The identity type. Required.
    :vartype type: str
    :ivar identity_ids: The list of identities. Required.
    :vartype identity_ids: list[str]
    """

    _validation = {
        "type": {"required": True},
        "identity_ids": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "identity_ids": {"key": "identityIds", "type": "[str]"},
    }

    def __init__(self, *, type: str, identity_ids: List[str], **kwargs):
        """
        :keyword type: The identity type. Required.
        :paramtype type: str
        :keyword identity_ids: The list of identities. Required.
        :paramtype identity_ids: list[str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.identity_ids = identity_ids


class Message(_serialization.Model):
    """Supplementary contextual messages during a rollout.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_stamp: Time in UTC this message was provided.
    :vartype time_stamp: ~datetime.datetime
    :ivar message: The actual message text.
    :vartype message: str
    """

    _validation = {
        "time_stamp": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "time_stamp": {"key": "timeStamp", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.time_stamp = None
        self.message = None


class Operation(_serialization.Model):
    """Represents an operation that can be performed on the service.

    :ivar name: The name of the operation.
    :vartype name: str
    :ivar display: The display name of the operation.
    :vartype display: ~azure.mgmt.deploymentmanager.models.OperationDetail
    :ivar origin: The origin of the operation.
    :vartype origin: str
    :ivar properties: The properties of the operation.
    :vartype properties: JSON
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDetail"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDetail"] = None,
        origin: Optional[str] = None,
        properties: Optional[JSON] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the operation.
        :paramtype name: str
        :keyword display: The display name of the operation.
        :paramtype display: ~azure.mgmt.deploymentmanager.models.OperationDetail
        :keyword origin: The origin of the operation.
        :paramtype origin: str
        :keyword properties: The properties of the operation.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDetail(_serialization.Model):
    """The detail about an operation.

    :ivar provider: The name of the provider that supports the operation.
    :vartype provider: str
    :ivar resource: The resource type on which this operation can be performed.
    :vartype resource: str
    :ivar operation: The name of the operation.
    :vartype operation: str
    :ivar description: The description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: The name of the provider that supports the operation.
        :paramtype provider: str
        :keyword resource: The resource type on which this operation can be performed.
        :paramtype resource: str
        :keyword operation: The name of the operation.
        :paramtype operation: str
        :keyword description: The description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsList(_serialization.Model):
    """The operations response.

    :ivar value: The list of supported operations.
    :vartype value: ~azure.mgmt.deploymentmanager.models.Operation
    """

    _attribute_map = {
        "value": {"key": "value", "type": "Operation"},
    }

    def __init__(self, *, value: Optional["_models.Operation"] = None, **kwargs):
        """
        :keyword value: The list of supported operations.
        :paramtype value: ~azure.mgmt.deploymentmanager.models.Operation
        """
        super().__init__(**kwargs)
        self.value = value


class PrePostStep(_serialization.Model):
    """The properties that define a step.

    All required parameters must be populated in order to send to Azure.

    :ivar step_id: The resource Id of the step to be run. Required.
    :vartype step_id: str
    """

    _validation = {
        "step_id": {"required": True},
    }

    _attribute_map = {
        "step_id": {"key": "stepId", "type": "str"},
    }

    def __init__(self, *, step_id: str, **kwargs):
        """
        :keyword step_id: The resource Id of the step to be run. Required.
        :paramtype step_id: str
        """
        super().__init__(**kwargs)
        self.step_id = step_id


class ResourceOperation(_serialization.Model):
    """Individual resource operation information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_name: Name of the resource as specified in the artifacts. For ARM resources,
     this is the name of the resource specified in the template.
    :vartype resource_name: str
    :ivar operation_id: Unique identifier of the operation. For ARM resources, this is the
     operationId obtained from ARM service.
    :vartype operation_id: str
    :ivar resource_type: Type of the resource as specified in the artifacts. For ARM resources,
     this is the type of the resource specified in the template.
    :vartype resource_type: str
    :ivar provisioning_state: State of the resource deployment. For ARM resources, this is the
     current provisioning state of the resource.
    :vartype provisioning_state: str
    :ivar status_message: Descriptive information of the resource operation.
    :vartype status_message: str
    :ivar status_code: Http status code of the operation.
    :vartype status_code: str
    """

    _validation = {
        "operation_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status_message": {"readonly": True},
        "status_code": {"readonly": True},
    }

    _attribute_map = {
        "resource_name": {"key": "resourceName", "type": "str"},
        "operation_id": {"key": "operationId", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "str"},
        "status_code": {"key": "statusCode", "type": "str"},
    }

    def __init__(self, *, resource_name: Optional[str] = None, resource_type: Optional[str] = None, **kwargs):
        """
        :keyword resource_name: Name of the resource as specified in the artifacts. For ARM resources,
         this is the name of the resource specified in the template.
        :paramtype resource_name: str
        :keyword resource_type: Type of the resource as specified in the artifacts. For ARM resources,
         this is the type of the resource specified in the template.
        :paramtype resource_type: str
        """
        super().__init__(**kwargs)
        self.resource_name = resource_name
        self.operation_id = None
        self.resource_type = resource_type
        self.provisioning_state = None
        self.status_message = None
        self.status_code = None


class RestHealthCheck(_serialization.Model):
    """A REST based health check.

    All required parameters must be populated in order to send to Azure.

    :ivar name: A unique name for this check. Required.
    :vartype name: str
    :ivar request: The request to the health provider. Required.
    :vartype request: ~azure.mgmt.deploymentmanager.models.RestRequest
    :ivar response: The expected response from the health provider. If no expected response is
     provided, the default is to expect the received response to have an HTTP status code of 200 OK.
    :vartype response: ~azure.mgmt.deploymentmanager.models.RestResponse
    """

    _validation = {
        "name": {"required": True},
        "request": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "request": {"key": "request", "type": "RestRequest"},
        "response": {"key": "response", "type": "RestResponse"},
    }

    def __init__(
        self, *, name: str, request: "_models.RestRequest", response: Optional["_models.RestResponse"] = None, **kwargs
    ):
        """
        :keyword name: A unique name for this check. Required.
        :paramtype name: str
        :keyword request: The request to the health provider. Required.
        :paramtype request: ~azure.mgmt.deploymentmanager.models.RestRequest
        :keyword response: The expected response from the health provider. If no expected response is
         provided, the default is to expect the received response to have an HTTP status code of 200 OK.
        :paramtype response: ~azure.mgmt.deploymentmanager.models.RestResponse
        """
        super().__init__(**kwargs)
        self.name = name
        self.request = request
        self.response = response


class RestHealthCheckStepAttributes(HealthCheckStepAttributes):
    """Defines the REST health check step properties.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of health check. Required.
    :vartype type: str
    :ivar wait_duration: The duration in ISO 8601 format for which health check waits idly without
     any checks.
    :vartype wait_duration: str
    :ivar max_elastic_duration: The duration in ISO 8601 format for which the health check waits
     for the resource to become healthy. Health check fails if it doesn't. Health check starts to
     enforce healthyStateDuration once resource becomes healthy.
    :vartype max_elastic_duration: str
    :ivar healthy_state_duration: The duration in ISO 8601 format for which the resource is
     expected to be continuously healthy. If maxElasticDuration is specified, healthy state duration
     is enforced after the detection of first healthy signal. Required.
    :vartype healthy_state_duration: str
    :ivar health_checks: The list of checks that form the health check step.
    :vartype health_checks: list[~azure.mgmt.deploymentmanager.models.RestHealthCheck]
    """

    _validation = {
        "type": {"required": True},
        "healthy_state_duration": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "wait_duration": {"key": "waitDuration", "type": "str"},
        "max_elastic_duration": {"key": "maxElasticDuration", "type": "str"},
        "healthy_state_duration": {"key": "healthyStateDuration", "type": "str"},
        "health_checks": {"key": "properties.healthChecks", "type": "[RestHealthCheck]"},
    }

    def __init__(
        self,
        *,
        healthy_state_duration: str,
        wait_duration: Optional[str] = None,
        max_elastic_duration: Optional[str] = None,
        health_checks: Optional[List["_models.RestHealthCheck"]] = None,
        **kwargs
    ):
        """
        :keyword wait_duration: The duration in ISO 8601 format for which health check waits idly
         without any checks.
        :paramtype wait_duration: str
        :keyword max_elastic_duration: The duration in ISO 8601 format for which the health check waits
         for the resource to become healthy. Health check fails if it doesn't. Health check starts to
         enforce healthyStateDuration once resource becomes healthy.
        :paramtype max_elastic_duration: str
        :keyword healthy_state_duration: The duration in ISO 8601 format for which the resource is
         expected to be continuously healthy. If maxElasticDuration is specified, healthy state duration
         is enforced after the detection of first healthy signal. Required.
        :paramtype healthy_state_duration: str
        :keyword health_checks: The list of checks that form the health check step.
        :paramtype health_checks: list[~azure.mgmt.deploymentmanager.models.RestHealthCheck]
        """
        super().__init__(
            wait_duration=wait_duration,
            max_elastic_duration=max_elastic_duration,
            healthy_state_duration=healthy_state_duration,
            **kwargs
        )
        self.type = "REST"  # type: str
        self.health_checks = health_checks


class RestRequest(_serialization.Model):
    """The properties that make up a REST request.

    All required parameters must be populated in order to send to Azure.

    :ivar method: The HTTP method to use for the request. Required. Known values are: "GET" and
     "POST".
    :vartype method: str or ~azure.mgmt.deploymentmanager.models.RestRequestMethod
    :ivar uri: The HTTP URI to use for the request. Required.
    :vartype uri: str
    :ivar authentication: The authentication information required in the request to the health
     provider. Required.
    :vartype authentication: ~azure.mgmt.deploymentmanager.models.RestRequestAuthentication
    """

    _validation = {
        "method": {"required": True},
        "uri": {"required": True},
        "authentication": {"required": True},
    }

    _attribute_map = {
        "method": {"key": "method", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "authentication": {"key": "authentication", "type": "RestRequestAuthentication"},
    }

    def __init__(
        self,
        *,
        method: Union[str, "_models.RestRequestMethod"],
        uri: str,
        authentication: "_models.RestRequestAuthentication",
        **kwargs
    ):
        """
        :keyword method: The HTTP method to use for the request. Required. Known values are: "GET" and
         "POST".
        :paramtype method: str or ~azure.mgmt.deploymentmanager.models.RestRequestMethod
        :keyword uri: The HTTP URI to use for the request. Required.
        :paramtype uri: str
        :keyword authentication: The authentication information required in the request to the health
         provider. Required.
        :paramtype authentication: ~azure.mgmt.deploymentmanager.models.RestRequestAuthentication
        """
        super().__init__(**kwargs)
        self.method = method
        self.uri = uri
        self.authentication = authentication


class RestResponse(_serialization.Model):
    """The properties that make up the expected REST response.

    :ivar success_status_codes: The HTTP status codes expected in a successful health check
     response. The response is expected to match one of the given status codes. If no expected
     status codes are provided, default expected status code is 200 OK.
    :vartype success_status_codes: list[str]
    :ivar regex: The regular expressions to match the response content with.
    :vartype regex: ~azure.mgmt.deploymentmanager.models.RestResponseRegex
    """

    _attribute_map = {
        "success_status_codes": {"key": "successStatusCodes", "type": "[str]"},
        "regex": {"key": "regex", "type": "RestResponseRegex"},
    }

    def __init__(
        self,
        *,
        success_status_codes: Optional[List[str]] = None,
        regex: Optional["_models.RestResponseRegex"] = None,
        **kwargs
    ):
        """
        :keyword success_status_codes: The HTTP status codes expected in a successful health check
         response. The response is expected to match one of the given status codes. If no expected
         status codes are provided, default expected status code is 200 OK.
        :paramtype success_status_codes: list[str]
        :keyword regex: The regular expressions to match the response content with.
        :paramtype regex: ~azure.mgmt.deploymentmanager.models.RestResponseRegex
        """
        super().__init__(**kwargs)
        self.success_status_codes = success_status_codes
        self.regex = regex


class RestResponseRegex(_serialization.Model):
    """The regular expressions to match the response content with.

    :ivar matches: The list of regular expressions.
    :vartype matches: list[str]
    :ivar match_quantifier: Indicates whether any or all of the expressions should match with the
     response content. Known values are: "All" and "Any".
    :vartype match_quantifier: str or ~azure.mgmt.deploymentmanager.models.RestMatchQuantifier
    """

    _attribute_map = {
        "matches": {"key": "matches", "type": "[str]"},
        "match_quantifier": {"key": "matchQuantifier", "type": "str"},
    }

    def __init__(
        self,
        *,
        matches: Optional[List[str]] = None,
        match_quantifier: Optional[Union[str, "_models.RestMatchQuantifier"]] = None,
        **kwargs
    ):
        """
        :keyword matches: The list of regular expressions.
        :paramtype matches: list[str]
        :keyword match_quantifier: Indicates whether any or all of the expressions should match with
         the response content. Known values are: "All" and "Any".
        :paramtype match_quantifier: str or ~azure.mgmt.deploymentmanager.models.RestMatchQuantifier
        """
        super().__init__(**kwargs)
        self.matches = matches
        self.match_quantifier = match_quantifier


class Rollout(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Defines the rollout.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.deploymentmanager.models.Identity
    :ivar build_version: The version of the build being deployed.
    :vartype build_version: str
    :ivar artifact_source_id: The reference to the artifact source resource Id where the payload is
     located.
    :vartype artifact_source_id: str
    :ivar target_service_topology_id: The resource Id of the service topology from which service
     units are being referenced in step groups to be deployed.
    :vartype target_service_topology_id: str
    :ivar step_groups: The list of step groups that define the orchestration.
    :vartype step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
    :ivar status: The current status of the rollout.
    :vartype status: str
    :ivar total_retry_attempts: The cardinal count of total number of retries performed on the
     rollout at a given time.
    :vartype total_retry_attempts: int
    :ivar operation_info: Operational information of the rollout.
    :vartype operation_info: ~azure.mgmt.deploymentmanager.models.RolloutOperationInfo
    :ivar services: The detailed information on the services being deployed.
    :vartype services: list[~azure.mgmt.deploymentmanager.models.Service]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "status": {"readonly": True},
        "total_retry_attempts": {"readonly": True},
        "operation_info": {"readonly": True},
        "services": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "build_version": {"key": "properties.buildVersion", "type": "str"},
        "artifact_source_id": {"key": "properties.artifactSourceId", "type": "str"},
        "target_service_topology_id": {"key": "properties.targetServiceTopologyId", "type": "str"},
        "step_groups": {"key": "properties.stepGroups", "type": "[StepGroup]"},
        "status": {"key": "properties.status", "type": "str"},
        "total_retry_attempts": {"key": "properties.totalRetryAttempts", "type": "int"},
        "operation_info": {"key": "properties.operationInfo", "type": "RolloutOperationInfo"},
        "services": {"key": "properties.services", "type": "[Service]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        build_version: Optional[str] = None,
        artifact_source_id: Optional[str] = None,
        target_service_topology_id: Optional[str] = None,
        step_groups: Optional[List["_models.StepGroup"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.deploymentmanager.models.Identity
        :keyword build_version: The version of the build being deployed.
        :paramtype build_version: str
        :keyword artifact_source_id: The reference to the artifact source resource Id where the payload
         is located.
        :paramtype artifact_source_id: str
        :keyword target_service_topology_id: The resource Id of the service topology from which service
         units are being referenced in step groups to be deployed.
        :paramtype target_service_topology_id: str
        :keyword step_groups: The list of step groups that define the orchestration.
        :paramtype step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.build_version = build_version
        self.artifact_source_id = artifact_source_id
        self.target_service_topology_id = target_service_topology_id
        self.step_groups = step_groups
        self.status = None
        self.total_retry_attempts = None
        self.operation_info = None
        self.services = None


class RolloutIdentityAuthentication(RestRequestAuthentication):
    """RolloutIdentity uses the user-assigned managed identity authentication context specified in the Identity property during rollout creation.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The authentication type. Required. Known values are: "ApiKey" and
     "RolloutIdentity".
    :vartype type: str or ~azure.mgmt.deploymentmanager.models.RestAuthType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = "RolloutIdentity"  # type: str


class RolloutOperationInfo(_serialization.Model):
    """Detailed runtime information of the rollout.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar retry_attempt: The ordinal count of the number of retry attempts on a rollout. 0 if no
     retries of the rollout have been performed. If the rollout is updated with a PUT, this count is
     reset to 0.
    :vartype retry_attempt: int
    :ivar skip_succeeded_on_retry: True, if all steps that succeeded on the previous run/attempt
     were chosen to be skipped in this retry attempt. False, otherwise.
    :vartype skip_succeeded_on_retry: bool
    :ivar start_time: The start time of the rollout in UTC.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The start time of the rollout in UTC. This property will not be set if the
     rollout has not completed yet.
    :vartype end_time: ~datetime.datetime
    :ivar error: The detailed error information for any failure.
    :vartype error: ~azure.mgmt.deploymentmanager.models.CloudErrorBody
    """

    _validation = {
        "retry_attempt": {"readonly": True},
        "skip_succeeded_on_retry": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "retry_attempt": {"key": "retryAttempt", "type": "int"},
        "skip_succeeded_on_retry": {"key": "skipSucceededOnRetry", "type": "bool"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "CloudErrorBody"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.retry_attempt = None
        self.skip_succeeded_on_retry = None
        self.start_time = None
        self.end_time = None
        self.error = None


class RolloutPropertiesAutoGenerated(_serialization.Model):
    """Defines the properties of a rollout.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The current status of the rollout.
    :vartype status: str
    :ivar total_retry_attempts: The cardinal count of total number of retries performed on the
     rollout at a given time.
    :vartype total_retry_attempts: int
    :ivar operation_info: Operational information of the rollout.
    :vartype operation_info: ~azure.mgmt.deploymentmanager.models.RolloutOperationInfo
    :ivar services: The detailed information on the services being deployed.
    :vartype services: list[~azure.mgmt.deploymentmanager.models.Service]
    """

    _validation = {
        "status": {"readonly": True},
        "total_retry_attempts": {"readonly": True},
        "operation_info": {"readonly": True},
        "services": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "total_retry_attempts": {"key": "totalRetryAttempts", "type": "int"},
        "operation_info": {"key": "operationInfo", "type": "RolloutOperationInfo"},
        "services": {"key": "services", "type": "[Service]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.total_retry_attempts = None
        self.operation_info = None
        self.services = None


class RolloutRequestProperties(_serialization.Model):
    """The properties for defining a rollout.

    All required parameters must be populated in order to send to Azure.

    :ivar build_version: The version of the build being deployed. Required.
    :vartype build_version: str
    :ivar artifact_source_id: The reference to the artifact source resource Id where the payload is
     located.
    :vartype artifact_source_id: str
    :ivar target_service_topology_id: The resource Id of the service topology from which service
     units are being referenced in step groups to be deployed. Required.
    :vartype target_service_topology_id: str
    :ivar step_groups: The list of step groups that define the orchestration. Required.
    :vartype step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
    """

    _validation = {
        "build_version": {"required": True},
        "target_service_topology_id": {"required": True},
        "step_groups": {"required": True},
    }

    _attribute_map = {
        "build_version": {"key": "buildVersion", "type": "str"},
        "artifact_source_id": {"key": "artifactSourceId", "type": "str"},
        "target_service_topology_id": {"key": "targetServiceTopologyId", "type": "str"},
        "step_groups": {"key": "stepGroups", "type": "[StepGroup]"},
    }

    def __init__(
        self,
        *,
        build_version: str,
        target_service_topology_id: str,
        step_groups: List["_models.StepGroup"],
        artifact_source_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword build_version: The version of the build being deployed. Required.
        :paramtype build_version: str
        :keyword artifact_source_id: The reference to the artifact source resource Id where the payload
         is located.
        :paramtype artifact_source_id: str
        :keyword target_service_topology_id: The resource Id of the service topology from which service
         units are being referenced in step groups to be deployed. Required.
        :paramtype target_service_topology_id: str
        :keyword step_groups: The list of step groups that define the orchestration. Required.
        :paramtype step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
        """
        super().__init__(**kwargs)
        self.build_version = build_version
        self.artifact_source_id = artifact_source_id
        self.target_service_topology_id = target_service_topology_id
        self.step_groups = step_groups


class RolloutProperties(RolloutRequestProperties, RolloutPropertiesAutoGenerated):
    """The properties that define a rollout.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: The current status of the rollout.
    :vartype status: str
    :ivar total_retry_attempts: The cardinal count of total number of retries performed on the
     rollout at a given time.
    :vartype total_retry_attempts: int
    :ivar operation_info: Operational information of the rollout.
    :vartype operation_info: ~azure.mgmt.deploymentmanager.models.RolloutOperationInfo
    :ivar services: The detailed information on the services being deployed.
    :vartype services: list[~azure.mgmt.deploymentmanager.models.Service]
    :ivar build_version: The version of the build being deployed. Required.
    :vartype build_version: str
    :ivar artifact_source_id: The reference to the artifact source resource Id where the payload is
     located.
    :vartype artifact_source_id: str
    :ivar target_service_topology_id: The resource Id of the service topology from which service
     units are being referenced in step groups to be deployed. Required.
    :vartype target_service_topology_id: str
    :ivar step_groups: The list of step groups that define the orchestration. Required.
    :vartype step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
    """

    _validation = {
        "status": {"readonly": True},
        "total_retry_attempts": {"readonly": True},
        "operation_info": {"readonly": True},
        "services": {"readonly": True},
        "build_version": {"required": True},
        "target_service_topology_id": {"required": True},
        "step_groups": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "total_retry_attempts": {"key": "totalRetryAttempts", "type": "int"},
        "operation_info": {"key": "operationInfo", "type": "RolloutOperationInfo"},
        "services": {"key": "services", "type": "[Service]"},
        "build_version": {"key": "buildVersion", "type": "str"},
        "artifact_source_id": {"key": "artifactSourceId", "type": "str"},
        "target_service_topology_id": {"key": "targetServiceTopologyId", "type": "str"},
        "step_groups": {"key": "stepGroups", "type": "[StepGroup]"},
    }

    def __init__(
        self,
        *,
        build_version: str,
        target_service_topology_id: str,
        step_groups: List["_models.StepGroup"],
        artifact_source_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword build_version: The version of the build being deployed. Required.
        :paramtype build_version: str
        :keyword artifact_source_id: The reference to the artifact source resource Id where the payload
         is located.
        :paramtype artifact_source_id: str
        :keyword target_service_topology_id: The resource Id of the service topology from which service
         units are being referenced in step groups to be deployed. Required.
        :paramtype target_service_topology_id: str
        :keyword step_groups: The list of step groups that define the orchestration. Required.
        :paramtype step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
        """
        super().__init__(
            build_version=build_version,
            artifact_source_id=artifact_source_id,
            target_service_topology_id=target_service_topology_id,
            step_groups=step_groups,
            **kwargs
        )
        self.status = None
        self.total_retry_attempts = None
        self.operation_info = None
        self.services = None
        self.build_version = build_version
        self.artifact_source_id = artifact_source_id
        self.target_service_topology_id = target_service_topology_id
        self.step_groups = step_groups


class RolloutRequest(TrackedResource):
    """Defines the PUT rollout request body.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Identity for the resource. Required.
    :vartype identity: ~azure.mgmt.deploymentmanager.models.Identity
    :ivar build_version: The version of the build being deployed. Required.
    :vartype build_version: str
    :ivar artifact_source_id: The reference to the artifact source resource Id where the payload is
     located.
    :vartype artifact_source_id: str
    :ivar target_service_topology_id: The resource Id of the service topology from which service
     units are being referenced in step groups to be deployed. Required.
    :vartype target_service_topology_id: str
    :ivar step_groups: The list of step groups that define the orchestration. Required.
    :vartype step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "identity": {"required": True},
        "build_version": {"required": True},
        "target_service_topology_id": {"required": True},
        "step_groups": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "build_version": {"key": "properties.buildVersion", "type": "str"},
        "artifact_source_id": {"key": "properties.artifactSourceId", "type": "str"},
        "target_service_topology_id": {"key": "properties.targetServiceTopologyId", "type": "str"},
        "step_groups": {"key": "properties.stepGroups", "type": "[StepGroup]"},
    }

    def __init__(
        self,
        *,
        location: str,
        identity: "_models.Identity",
        build_version: str,
        target_service_topology_id: str,
        step_groups: List["_models.StepGroup"],
        tags: Optional[Dict[str, str]] = None,
        artifact_source_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Identity for the resource. Required.
        :paramtype identity: ~azure.mgmt.deploymentmanager.models.Identity
        :keyword build_version: The version of the build being deployed. Required.
        :paramtype build_version: str
        :keyword artifact_source_id: The reference to the artifact source resource Id where the payload
         is located.
        :paramtype artifact_source_id: str
        :keyword target_service_topology_id: The resource Id of the service topology from which service
         units are being referenced in step groups to be deployed. Required.
        :paramtype target_service_topology_id: str
        :keyword step_groups: The list of step groups that define the orchestration. Required.
        :paramtype step_groups: list[~azure.mgmt.deploymentmanager.models.StepGroup]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.build_version = build_version
        self.artifact_source_id = artifact_source_id
        self.target_service_topology_id = target_service_topology_id
        self.step_groups = step_groups


class RolloutStep(_serialization.Model):
    """Defines a specific step on a target service unit.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the step. Required.
    :vartype name: str
    :ivar status: Current state of the step.
    :vartype status: str
    :ivar step_group: The step group the current step is part of.
    :vartype step_group: str
    :ivar operation_info: Detailed information of specific action execution.
    :vartype operation_info: ~azure.mgmt.deploymentmanager.models.StepOperationInfo
    :ivar resource_operations: Set of resource operations that were performed, if any, on an Azure
     resource.
    :vartype resource_operations: list[~azure.mgmt.deploymentmanager.models.ResourceOperation]
    :ivar messages: Supplementary informative messages during rollout.
    :vartype messages: list[~azure.mgmt.deploymentmanager.models.Message]
    """

    _validation = {
        "name": {"required": True},
        "status": {"readonly": True},
        "operation_info": {"readonly": True},
        "resource_operations": {"readonly": True},
        "messages": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "step_group": {"key": "stepGroup", "type": "str"},
        "operation_info": {"key": "operationInfo", "type": "StepOperationInfo"},
        "resource_operations": {"key": "resourceOperations", "type": "[ResourceOperation]"},
        "messages": {"key": "messages", "type": "[Message]"},
    }

    def __init__(self, *, name: str, step_group: Optional[str] = None, **kwargs):
        """
        :keyword name: Name of the step. Required.
        :paramtype name: str
        :keyword step_group: The step group the current step is part of.
        :paramtype step_group: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.status = None
        self.step_group = step_group
        self.operation_info = None
        self.resource_operations = None
        self.messages = None


class SasAuthentication(Authentication):
    """Defines the properties to access the artifacts using an Azure Storage SAS URI.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The authentication type. Required.
    :vartype type: str
    :ivar sas_uri: The SAS URI to the Azure Storage blob container. Any offset from the root of the
     container to where the artifacts are located can be defined in the artifactRoot.
    :vartype sas_uri: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "sas_uri": {"key": "properties.sasUri", "type": "str"},
    }

    def __init__(self, *, sas_uri: Optional[str] = None, **kwargs):
        """
        :keyword sas_uri: The SAS URI to the Azure Storage blob container. Any offset from the root of
         the container to where the artifacts are located can be defined in the artifactRoot.
        :paramtype sas_uri: str
        """
        super().__init__(**kwargs)
        self.type = "Sas"  # type: str
        self.sas_uri = sas_uri


class ServiceProperties(_serialization.Model):
    """The properties of a service.

    All required parameters must be populated in order to send to Azure.

    :ivar target_location: The Azure location to which the resources in the service belong to or
     should be deployed to. Required.
    :vartype target_location: str
    :ivar target_subscription_id: The subscription to which the resources in the service belong to
     or should be deployed to. Required.
    :vartype target_subscription_id: str
    """

    _validation = {
        "target_location": {"required": True},
        "target_subscription_id": {"required": True},
    }

    _attribute_map = {
        "target_location": {"key": "targetLocation", "type": "str"},
        "target_subscription_id": {"key": "targetSubscriptionId", "type": "str"},
    }

    def __init__(self, *, target_location: str, target_subscription_id: str, **kwargs):
        """
        :keyword target_location: The Azure location to which the resources in the service belong to or
         should be deployed to. Required.
        :paramtype target_location: str
        :keyword target_subscription_id: The subscription to which the resources in the service belong
         to or should be deployed to. Required.
        :paramtype target_subscription_id: str
        """
        super().__init__(**kwargs)
        self.target_location = target_location
        self.target_subscription_id = target_subscription_id


class Service(ServiceProperties):
    """Defines a service.

    All required parameters must be populated in order to send to Azure.

    :ivar target_location: The Azure location to which the resources in the service belong to or
     should be deployed to. Required.
    :vartype target_location: str
    :ivar target_subscription_id: The subscription to which the resources in the service belong to
     or should be deployed to. Required.
    :vartype target_subscription_id: str
    :ivar name: Name of the service.
    :vartype name: str
    :ivar service_units: The detailed information about the units that make up the service.
    :vartype service_units: list[~azure.mgmt.deploymentmanager.models.ServiceUnit]
    """

    _validation = {
        "target_location": {"required": True},
        "target_subscription_id": {"required": True},
    }

    _attribute_map = {
        "target_location": {"key": "targetLocation", "type": "str"},
        "target_subscription_id": {"key": "targetSubscriptionId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "service_units": {"key": "serviceUnits", "type": "[ServiceUnit]"},
    }

    def __init__(
        self,
        *,
        target_location: str,
        target_subscription_id: str,
        name: Optional[str] = None,
        service_units: Optional[List["_models.ServiceUnit"]] = None,
        **kwargs
    ):
        """
        :keyword target_location: The Azure location to which the resources in the service belong to or
         should be deployed to. Required.
        :paramtype target_location: str
        :keyword target_subscription_id: The subscription to which the resources in the service belong
         to or should be deployed to. Required.
        :paramtype target_subscription_id: str
        :keyword name: Name of the service.
        :paramtype name: str
        :keyword service_units: The detailed information about the units that make up the service.
        :paramtype service_units: list[~azure.mgmt.deploymentmanager.models.ServiceUnit]
        """
        super().__init__(target_location=target_location, target_subscription_id=target_subscription_id, **kwargs)
        self.name = name
        self.service_units = service_units


class ServiceResource(TrackedResource):
    """The resource representation of a service in a service topology.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar target_location: The Azure location to which the resources in the service belong to or
     should be deployed to. Required.
    :vartype target_location: str
    :ivar target_subscription_id: The subscription to which the resources in the service belong to
     or should be deployed to. Required.
    :vartype target_subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "target_location": {"required": True},
        "target_subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "target_location": {"key": "properties.targetLocation", "type": "str"},
        "target_subscription_id": {"key": "properties.targetSubscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        target_location: str,
        target_subscription_id: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword target_location: The Azure location to which the resources in the service belong to or
         should be deployed to. Required.
        :paramtype target_location: str
        :keyword target_subscription_id: The subscription to which the resources in the service belong
         to or should be deployed to. Required.
        :paramtype target_subscription_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.target_location = target_location
        self.target_subscription_id = target_subscription_id


class ServiceResourceProperties(ServiceProperties):
    """The properties that define a service in a service topology.

    All required parameters must be populated in order to send to Azure.

    :ivar target_location: The Azure location to which the resources in the service belong to or
     should be deployed to. Required.
    :vartype target_location: str
    :ivar target_subscription_id: The subscription to which the resources in the service belong to
     or should be deployed to. Required.
    :vartype target_subscription_id: str
    """

    _validation = {
        "target_location": {"required": True},
        "target_subscription_id": {"required": True},
    }

    _attribute_map = {
        "target_location": {"key": "targetLocation", "type": "str"},
        "target_subscription_id": {"key": "targetSubscriptionId", "type": "str"},
    }

    def __init__(self, *, target_location: str, target_subscription_id: str, **kwargs):
        """
        :keyword target_location: The Azure location to which the resources in the service belong to or
         should be deployed to. Required.
        :paramtype target_location: str
        :keyword target_subscription_id: The subscription to which the resources in the service belong
         to or should be deployed to. Required.
        :paramtype target_subscription_id: str
        """
        super().__init__(target_location=target_location, target_subscription_id=target_subscription_id, **kwargs)


class ServiceTopologyProperties(_serialization.Model):
    """The properties of a service topology.

    :ivar artifact_source_id: The resource Id of the artifact source that contains the artifacts
     that can be referenced in the service units.
    :vartype artifact_source_id: str
    """

    _attribute_map = {
        "artifact_source_id": {"key": "artifactSourceId", "type": "str"},
    }

    def __init__(self, *, artifact_source_id: Optional[str] = None, **kwargs):
        """
        :keyword artifact_source_id: The resource Id of the artifact source that contains the artifacts
         that can be referenced in the service units.
        :paramtype artifact_source_id: str
        """
        super().__init__(**kwargs)
        self.artifact_source_id = artifact_source_id


class ServiceTopologyResource(TrackedResource):
    """The resource representation of a service topology.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar artifact_source_id: The resource Id of the artifact source that contains the artifacts
     that can be referenced in the service units.
    :vartype artifact_source_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "artifact_source_id": {"key": "properties.artifactSourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        artifact_source_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword artifact_source_id: The resource Id of the artifact source that contains the artifacts
         that can be referenced in the service units.
        :paramtype artifact_source_id: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.artifact_source_id = artifact_source_id


class ServiceTopologyResourceProperties(ServiceTopologyProperties):
    """The properties that define the service topology.

    :ivar artifact_source_id: The resource Id of the artifact source that contains the artifacts
     that can be referenced in the service units.
    :vartype artifact_source_id: str
    """

    _attribute_map = {
        "artifact_source_id": {"key": "artifactSourceId", "type": "str"},
    }

    def __init__(self, *, artifact_source_id: Optional[str] = None, **kwargs):
        """
        :keyword artifact_source_id: The resource Id of the artifact source that contains the artifacts
         that can be referenced in the service units.
        :paramtype artifact_source_id: str
        """
        super().__init__(artifact_source_id=artifact_source_id, **kwargs)


class ServiceUnitProperties(_serialization.Model):
    """Defines the properties of a service unit.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_group: The Azure Resource Group to which the resources in the service
     unit belong to or should be deployed to. Required.
    :vartype target_resource_group: str
    :ivar deployment_mode: Describes the type of ARM deployment to be performed on the resource.
     Required. Known values are: "Incremental" and "Complete".
    :vartype deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
    :ivar artifacts: The artifacts for the service unit.
    :vartype artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
    """

    _validation = {
        "target_resource_group": {"required": True},
        "deployment_mode": {"required": True},
    }

    _attribute_map = {
        "target_resource_group": {"key": "targetResourceGroup", "type": "str"},
        "deployment_mode": {"key": "deploymentMode", "type": "str"},
        "artifacts": {"key": "artifacts", "type": "ServiceUnitArtifacts"},
    }

    def __init__(
        self,
        *,
        target_resource_group: str,
        deployment_mode: Union[str, "_models.DeploymentMode"],
        artifacts: Optional["_models.ServiceUnitArtifacts"] = None,
        **kwargs
    ):
        """
        :keyword target_resource_group: The Azure Resource Group to which the resources in the service
         unit belong to or should be deployed to. Required.
        :paramtype target_resource_group: str
        :keyword deployment_mode: Describes the type of ARM deployment to be performed on the resource.
         Required. Known values are: "Incremental" and "Complete".
        :paramtype deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
        :keyword artifacts: The artifacts for the service unit.
        :paramtype artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
        """
        super().__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.deployment_mode = deployment_mode
        self.artifacts = artifacts


class ServiceUnit(ServiceUnitProperties):
    """Defines a service unit.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_group: The Azure Resource Group to which the resources in the service
     unit belong to or should be deployed to. Required.
    :vartype target_resource_group: str
    :ivar deployment_mode: Describes the type of ARM deployment to be performed on the resource.
     Required. Known values are: "Incremental" and "Complete".
    :vartype deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
    :ivar artifacts: The artifacts for the service unit.
    :vartype artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
    :ivar name: Name of the service unit.
    :vartype name: str
    :ivar steps: Detailed step information, if present.
    :vartype steps: list[~azure.mgmt.deploymentmanager.models.RolloutStep]
    """

    _validation = {
        "target_resource_group": {"required": True},
        "deployment_mode": {"required": True},
    }

    _attribute_map = {
        "target_resource_group": {"key": "targetResourceGroup", "type": "str"},
        "deployment_mode": {"key": "deploymentMode", "type": "str"},
        "artifacts": {"key": "artifacts", "type": "ServiceUnitArtifacts"},
        "name": {"key": "name", "type": "str"},
        "steps": {"key": "steps", "type": "[RolloutStep]"},
    }

    def __init__(
        self,
        *,
        target_resource_group: str,
        deployment_mode: Union[str, "_models.DeploymentMode"],
        artifacts: Optional["_models.ServiceUnitArtifacts"] = None,
        name: Optional[str] = None,
        steps: Optional[List["_models.RolloutStep"]] = None,
        **kwargs
    ):
        """
        :keyword target_resource_group: The Azure Resource Group to which the resources in the service
         unit belong to or should be deployed to. Required.
        :paramtype target_resource_group: str
        :keyword deployment_mode: Describes the type of ARM deployment to be performed on the resource.
         Required. Known values are: "Incremental" and "Complete".
        :paramtype deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
        :keyword artifacts: The artifacts for the service unit.
        :paramtype artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
        :keyword name: Name of the service unit.
        :paramtype name: str
        :keyword steps: Detailed step information, if present.
        :paramtype steps: list[~azure.mgmt.deploymentmanager.models.RolloutStep]
        """
        super().__init__(
            target_resource_group=target_resource_group, deployment_mode=deployment_mode, artifacts=artifacts, **kwargs
        )
        self.name = name
        self.steps = steps


class ServiceUnitArtifacts(_serialization.Model):
    """Defines the artifacts of a service unit.

    :ivar template_uri: The full URI of the ARM template file with the SAS token.
    :vartype template_uri: str
    :ivar parameters_uri: The full URI of the ARM parameters file with the SAS token.
    :vartype parameters_uri: str
    :ivar template_artifact_source_relative_path: The path to the ARM template file relative to the
     artifact source.
    :vartype template_artifact_source_relative_path: str
    :ivar parameters_artifact_source_relative_path: The path to the ARM parameters file relative to
     the artifact source.
    :vartype parameters_artifact_source_relative_path: str
    """

    _attribute_map = {
        "template_uri": {"key": "templateUri", "type": "str"},
        "parameters_uri": {"key": "parametersUri", "type": "str"},
        "template_artifact_source_relative_path": {"key": "templateArtifactSourceRelativePath", "type": "str"},
        "parameters_artifact_source_relative_path": {"key": "parametersArtifactSourceRelativePath", "type": "str"},
    }

    def __init__(
        self,
        *,
        template_uri: Optional[str] = None,
        parameters_uri: Optional[str] = None,
        template_artifact_source_relative_path: Optional[str] = None,
        parameters_artifact_source_relative_path: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword template_uri: The full URI of the ARM template file with the SAS token.
        :paramtype template_uri: str
        :keyword parameters_uri: The full URI of the ARM parameters file with the SAS token.
        :paramtype parameters_uri: str
        :keyword template_artifact_source_relative_path: The path to the ARM template file relative to
         the artifact source.
        :paramtype template_artifact_source_relative_path: str
        :keyword parameters_artifact_source_relative_path: The path to the ARM parameters file relative
         to the artifact source.
        :paramtype parameters_artifact_source_relative_path: str
        """
        super().__init__(**kwargs)
        self.template_uri = template_uri
        self.parameters_uri = parameters_uri
        self.template_artifact_source_relative_path = template_artifact_source_relative_path
        self.parameters_artifact_source_relative_path = parameters_artifact_source_relative_path


class ServiceUnitResource(TrackedResource):
    """Represents the response of a service unit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar target_resource_group: The Azure Resource Group to which the resources in the service
     unit belong to or should be deployed to. Required.
    :vartype target_resource_group: str
    :ivar deployment_mode: Describes the type of ARM deployment to be performed on the resource.
     Required. Known values are: "Incremental" and "Complete".
    :vartype deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
    :ivar artifacts: The artifacts for the service unit.
    :vartype artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "target_resource_group": {"required": True},
        "deployment_mode": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "target_resource_group": {"key": "properties.targetResourceGroup", "type": "str"},
        "deployment_mode": {"key": "properties.deploymentMode", "type": "str"},
        "artifacts": {"key": "properties.artifacts", "type": "ServiceUnitArtifacts"},
    }

    def __init__(
        self,
        *,
        location: str,
        target_resource_group: str,
        deployment_mode: Union[str, "_models.DeploymentMode"],
        tags: Optional[Dict[str, str]] = None,
        artifacts: Optional["_models.ServiceUnitArtifacts"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword target_resource_group: The Azure Resource Group to which the resources in the service
         unit belong to or should be deployed to. Required.
        :paramtype target_resource_group: str
        :keyword deployment_mode: Describes the type of ARM deployment to be performed on the resource.
         Required. Known values are: "Incremental" and "Complete".
        :paramtype deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
        :keyword artifacts: The artifacts for the service unit.
        :paramtype artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.target_resource_group = target_resource_group
        self.deployment_mode = deployment_mode
        self.artifacts = artifacts


class ServiceUnitResourceProperties(ServiceUnitProperties):
    """The properties that define the service unit.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_group: The Azure Resource Group to which the resources in the service
     unit belong to or should be deployed to. Required.
    :vartype target_resource_group: str
    :ivar deployment_mode: Describes the type of ARM deployment to be performed on the resource.
     Required. Known values are: "Incremental" and "Complete".
    :vartype deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
    :ivar artifacts: The artifacts for the service unit.
    :vartype artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
    """

    _validation = {
        "target_resource_group": {"required": True},
        "deployment_mode": {"required": True},
    }

    _attribute_map = {
        "target_resource_group": {"key": "targetResourceGroup", "type": "str"},
        "deployment_mode": {"key": "deploymentMode", "type": "str"},
        "artifacts": {"key": "artifacts", "type": "ServiceUnitArtifacts"},
    }

    def __init__(
        self,
        *,
        target_resource_group: str,
        deployment_mode: Union[str, "_models.DeploymentMode"],
        artifacts: Optional["_models.ServiceUnitArtifacts"] = None,
        **kwargs
    ):
        """
        :keyword target_resource_group: The Azure Resource Group to which the resources in the service
         unit belong to or should be deployed to. Required.
        :paramtype target_resource_group: str
        :keyword deployment_mode: Describes the type of ARM deployment to be performed on the resource.
         Required. Known values are: "Incremental" and "Complete".
        :paramtype deployment_mode: str or ~azure.mgmt.deploymentmanager.models.DeploymentMode
        :keyword artifacts: The artifacts for the service unit.
        :paramtype artifacts: ~azure.mgmt.deploymentmanager.models.ServiceUnitArtifacts
        """
        super().__init__(
            target_resource_group=target_resource_group, deployment_mode=deployment_mode, artifacts=artifacts, **kwargs
        )


class StepGroup(_serialization.Model):
    """The properties that define a Step group in a rollout.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the step group. Required.
    :vartype name: str
    :ivar depends_on_step_groups: The list of step group names on which this step group depends on.
    :vartype depends_on_step_groups: list[str]
    :ivar pre_deployment_steps: The list of steps to be run before deploying the target.
    :vartype pre_deployment_steps: list[~azure.mgmt.deploymentmanager.models.PrePostStep]
    :ivar deployment_target_id: The resource Id of service unit to be deployed. The service unit
     should be from the service topology referenced in targetServiceTopologyId. Required.
    :vartype deployment_target_id: str
    :ivar post_deployment_steps: The list of steps to be run after deploying the target.
    :vartype post_deployment_steps: list[~azure.mgmt.deploymentmanager.models.PrePostStep]
    """

    _validation = {
        "name": {"required": True},
        "deployment_target_id": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "depends_on_step_groups": {"key": "dependsOnStepGroups", "type": "[str]"},
        "pre_deployment_steps": {"key": "preDeploymentSteps", "type": "[PrePostStep]"},
        "deployment_target_id": {"key": "deploymentTargetId", "type": "str"},
        "post_deployment_steps": {"key": "postDeploymentSteps", "type": "[PrePostStep]"},
    }

    def __init__(
        self,
        *,
        name: str,
        deployment_target_id: str,
        depends_on_step_groups: Optional[List[str]] = None,
        pre_deployment_steps: Optional[List["_models.PrePostStep"]] = None,
        post_deployment_steps: Optional[List["_models.PrePostStep"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the step group. Required.
        :paramtype name: str
        :keyword depends_on_step_groups: The list of step group names on which this step group depends
         on.
        :paramtype depends_on_step_groups: list[str]
        :keyword pre_deployment_steps: The list of steps to be run before deploying the target.
        :paramtype pre_deployment_steps: list[~azure.mgmt.deploymentmanager.models.PrePostStep]
        :keyword deployment_target_id: The resource Id of service unit to be deployed. The service unit
         should be from the service topology referenced in targetServiceTopologyId. Required.
        :paramtype deployment_target_id: str
        :keyword post_deployment_steps: The list of steps to be run after deploying the target.
        :paramtype post_deployment_steps: list[~azure.mgmt.deploymentmanager.models.PrePostStep]
        """
        super().__init__(**kwargs)
        self.name = name
        self.depends_on_step_groups = depends_on_step_groups
        self.pre_deployment_steps = pre_deployment_steps
        self.deployment_target_id = deployment_target_id
        self.post_deployment_steps = post_deployment_steps


class StepOperationInfo(_serialization.Model):
    """Detailed information of a specific step run.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar deployment_name: The name of the ARM deployment initiated as part of the step.
    :vartype deployment_name: str
    :ivar correlation_id: Unique identifier to track the request for ARM-based resources.
    :vartype correlation_id: str
    :ivar start_time: Start time of the action in UTC.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the action in UTC.
    :vartype end_time: ~datetime.datetime
    :ivar last_updated_time: Last time in UTC this operation was updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar error: The errors, if any, for the action.
    :vartype error: ~azure.mgmt.deploymentmanager.models.CloudErrorBody
    """

    _validation = {
        "deployment_name": {"readonly": True},
        "correlation_id": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "last_updated_time": {"readonly": True},
    }

    _attribute_map = {
        "deployment_name": {"key": "deploymentName", "type": "str"},
        "correlation_id": {"key": "correlationId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "last_updated_time": {"key": "lastUpdatedTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "CloudErrorBody"},
    }

    def __init__(self, *, error: Optional["_models.CloudErrorBody"] = None, **kwargs):
        """
        :keyword error: The errors, if any, for the action.
        :paramtype error: ~azure.mgmt.deploymentmanager.models.CloudErrorBody
        """
        super().__init__(**kwargs)
        self.deployment_name = None
        self.correlation_id = None
        self.start_time = None
        self.end_time = None
        self.last_updated_time = None
        self.error = error


class StepResource(TrackedResource):
    """The resource representation of a rollout step.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The properties that define the step. Required.
    :vartype properties: ~azure.mgmt.deploymentmanager.models.StepProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "properties": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "StepProperties"},
    }

    def __init__(
        self, *, location: str, properties: "_models.StepProperties", tags: Optional[Dict[str, str]] = None, **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: The properties that define the step. Required.
        :paramtype properties: ~azure.mgmt.deploymentmanager.models.StepProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class WaitStepAttributes(_serialization.Model):
    """The parameters for the wait step.

    All required parameters must be populated in order to send to Azure.

    :ivar duration: The duration in ISO 8601 format of how long the wait should be. Required.
    :vartype duration: str
    """

    _validation = {
        "duration": {"required": True},
    }

    _attribute_map = {
        "duration": {"key": "duration", "type": "str"},
    }

    def __init__(self, *, duration: str, **kwargs):
        """
        :keyword duration: The duration in ISO 8601 format of how long the wait should be. Required.
        :paramtype duration: str
        """
        super().__init__(**kwargs)
        self.duration = duration


class WaitStepProperties(StepProperties):
    """Defines the properties of a Wait step.

    All required parameters must be populated in order to send to Azure.

    :ivar step_type: The type of step. Required. Known values are: "Wait" and "HealthCheck".
    :vartype step_type: str or ~azure.mgmt.deploymentmanager.models.StepType
    :ivar attributes: The Wait attributes. Required.
    :vartype attributes: ~azure.mgmt.deploymentmanager.models.WaitStepAttributes
    """

    _validation = {
        "step_type": {"required": True},
        "attributes": {"required": True},
    }

    _attribute_map = {
        "step_type": {"key": "stepType", "type": "str"},
        "attributes": {"key": "attributes", "type": "WaitStepAttributes"},
    }

    def __init__(self, *, attributes: "_models.WaitStepAttributes", **kwargs):
        """
        :keyword attributes: The Wait attributes. Required.
        :paramtype attributes: ~azure.mgmt.deploymentmanager.models.WaitStepAttributes
        """
        super().__init__(**kwargs)
        self.step_type = "Wait"  # type: str
        self.attributes = attributes
