# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._domains_operations import (
    build_check_availability_request,
    build_create_or_update_ownership_identifier_request,
    build_create_or_update_request,
    build_delete_ownership_identifier_request,
    build_delete_request,
    build_get_control_center_sso_request_request,
    build_get_ownership_identifier_request,
    build_get_request,
    build_list_by_resource_group_request,
    build_list_ownership_identifiers_request,
    build_list_recommendations_request,
    build_list_request,
    build_renew_request,
    build_update_ownership_identifier_request,
    build_update_request,
)
from .._vendor import WebSiteManagementClientMixinABC

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class DomainsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.web.v2021_01_15.aio.WebSiteManagementClient`'s
        :attr:`domains` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def check_availability(
        self, identifier: _models.NameIdentifier, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DomainAvailabilityCheckResult:
        """Check if a domain is available for registration.

        Check if a domain is available for registration.

        :param identifier: Name of the domain. Required.
        :type identifier: ~azure.mgmt.web.v2021_01_15.models.NameIdentifier
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DomainAvailabilityCheckResult or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.DomainAvailabilityCheckResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def check_availability(
        self, identifier: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DomainAvailabilityCheckResult:
        """Check if a domain is available for registration.

        Check if a domain is available for registration.

        :param identifier: Name of the domain. Required.
        :type identifier: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DomainAvailabilityCheckResult or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.DomainAvailabilityCheckResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def check_availability(
        self, identifier: Union[_models.NameIdentifier, IO], **kwargs: Any
    ) -> _models.DomainAvailabilityCheckResult:
        """Check if a domain is available for registration.

        Check if a domain is available for registration.

        :param identifier: Name of the domain. Is either a NameIdentifier type or a IO type. Required.
        :type identifier: ~azure.mgmt.web.v2021_01_15.models.NameIdentifier or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DomainAvailabilityCheckResult or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.DomainAvailabilityCheckResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DomainAvailabilityCheckResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(identifier, (IO, bytes)):
            _content = identifier
        else:
            _json = self._serialize.body(identifier, "NameIdentifier")

        request = build_check_availability_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.check_availability.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DomainAvailabilityCheckResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    check_availability.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/checkDomainAvailability"
    }

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.Domain"]:
        """Get all domains in a subscription.

        Get all domains in a subscription.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Domain or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.Domain]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.DomainCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DomainCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/domains"}

    @distributed_trace_async
    async def get_control_center_sso_request(self, **kwargs: Any) -> _models.DomainControlCenterSsoRequest:
        """Generate a single sign-on request for the domain management portal.

        Generate a single sign-on request for the domain management portal.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DomainControlCenterSsoRequest or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.DomainControlCenterSsoRequest
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.DomainControlCenterSsoRequest] = kwargs.pop("cls", None)

        request = build_get_control_center_sso_request_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_control_center_sso_request.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DomainControlCenterSsoRequest", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_control_center_sso_request.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/generateSsoRequest"
    }

    @overload
    def list_recommendations(
        self,
        parameters: _models.DomainRecommendationSearchParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncIterable["_models.NameIdentifier"]:
        """Get domain name recommendations based on keywords.

        Get domain name recommendations based on keywords.

        :param parameters: Search parameters for domain name recommendations. Required.
        :type parameters: ~azure.mgmt.web.v2021_01_15.models.DomainRecommendationSearchParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either NameIdentifier or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.NameIdentifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def list_recommendations(
        self, parameters: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> AsyncIterable["_models.NameIdentifier"]:
        """Get domain name recommendations based on keywords.

        Get domain name recommendations based on keywords.

        :param parameters: Search parameters for domain name recommendations. Required.
        :type parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either NameIdentifier or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.NameIdentifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def list_recommendations(
        self, parameters: Union[_models.DomainRecommendationSearchParameters, IO], **kwargs: Any
    ) -> AsyncIterable["_models.NameIdentifier"]:
        """Get domain name recommendations based on keywords.

        Get domain name recommendations based on keywords.

        :param parameters: Search parameters for domain name recommendations. Is either a
         DomainRecommendationSearchParameters type or a IO type. Required.
        :type parameters: ~azure.mgmt.web.v2021_01_15.models.DomainRecommendationSearchParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either NameIdentifier or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.NameIdentifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.NameIdentifierCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})
        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IO, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "DomainRecommendationSearchParameters")

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_recommendations_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    content_type=content_type,
                    json=_json,
                    content=_content,
                    template_url=self.list_recommendations.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("NameIdentifierCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_recommendations.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.DomainRegistration/listDomainRecommendations"
    }

    @distributed_trace
    def list_by_resource_group(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.Domain"]:
        """Get all domains in a resource group.

        Get all domains in a resource group.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either Domain or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.Domain]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.DomainCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_by_resource_group.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DomainCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_resource_group.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains"
    }

    @distributed_trace_async
    async def get(self, resource_group_name: str, domain_name: str, **kwargs: Any) -> _models.Domain:
        """Get a domain.

        Get a domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of the domain. Required.
        :type domain_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Domain or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Domain
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.Domain] = kwargs.pop("cls", None)

        request = build_get_request(
            resource_group_name=resource_group_name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Domain", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
    }

    async def _create_or_update_initial(
        self, resource_group_name: str, domain_name: str, domain: Union[_models.Domain, IO], **kwargs: Any
    ) -> _models.Domain:
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Domain] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(domain, (IO, bytes)):
            _content = domain
        else:
            _json = self._serialize.body(domain, "Domain")

        request = build_create_or_update_request(
            resource_group_name=resource_group_name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._create_or_update_initial.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("Domain", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("Domain", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    _create_or_update_initial.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
    }

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        domain_name: str,
        domain: _models.Domain,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Domain]:
        """Creates or updates a domain.

        Creates or updates a domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of the domain. Required.
        :type domain_name: str
        :param domain: Domain registration information. Required.
        :type domain: ~azure.mgmt.web.v2021_01_15.models.Domain
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Domain or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Domain]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        domain_name: str,
        domain: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Domain]:
        """Creates or updates a domain.

        Creates or updates a domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of the domain. Required.
        :type domain_name: str
        :param domain: Domain registration information. Required.
        :type domain: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Domain or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Domain]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self, resource_group_name: str, domain_name: str, domain: Union[_models.Domain, IO], **kwargs: Any
    ) -> AsyncLROPoller[_models.Domain]:
        """Creates or updates a domain.

        Creates or updates a domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of the domain. Required.
        :type domain_name: str
        :param domain: Domain registration information. Is either a Domain type or a IO type. Required.
        :type domain: ~azure.mgmt.web.v2021_01_15.models.Domain or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either Domain or the result of
         cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.web.v2021_01_15.models.Domain]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Domain] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                domain_name=domain_name,
                domain=domain,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("Domain", pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    begin_create_or_update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
    }

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, domain_name: str, force_hard_delete_domain: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """Delete a domain.

        Delete a domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of the domain. Required.
        :type domain_name: str
        :param force_hard_delete_domain: Specify :code:`<code>true</code>` to delete the domain
         immediately. The default is :code:`<code>false</code>` which deletes the domain after 24 hours.
         Default value is None.
        :type force_hard_delete_domain: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_request(
            resource_group_name=resource_group_name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            force_hard_delete_domain=force_hard_delete_domain,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
    }

    @overload
    async def update(
        self,
        resource_group_name: str,
        domain_name: str,
        domain: _models.DomainPatchResource,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Domain:
        """Creates or updates a domain.

        Creates or updates a domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of the domain. Required.
        :type domain_name: str
        :param domain: Domain registration information. Required.
        :type domain: ~azure.mgmt.web.v2021_01_15.models.DomainPatchResource
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Domain or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Domain
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        domain_name: str,
        domain: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Domain:
        """Creates or updates a domain.

        Creates or updates a domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of the domain. Required.
        :type domain_name: str
        :param domain: Domain registration information. Required.
        :type domain: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Domain or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Domain
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self, resource_group_name: str, domain_name: str, domain: Union[_models.DomainPatchResource, IO], **kwargs: Any
    ) -> _models.Domain:
        """Creates or updates a domain.

        Creates or updates a domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of the domain. Required.
        :type domain_name: str
        :param domain: Domain registration information. Is either a DomainPatchResource type or a IO
         type. Required.
        :type domain: ~azure.mgmt.web.v2021_01_15.models.DomainPatchResource or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Domain or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.Domain
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Domain] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(domain, (IO, bytes)):
            _content = domain
        else:
            _json = self._serialize.body(domain, "DomainPatchResource")

        request = build_update_request(
            resource_group_name=resource_group_name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("Domain", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("Domain", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    update.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}"
    }

    @distributed_trace
    def list_ownership_identifiers(
        self, resource_group_name: str, domain_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.DomainOwnershipIdentifier"]:
        """Lists domain ownership identifiers.

        Lists domain ownership identifiers.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of domain. Required.
        :type domain_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DomainOwnershipIdentifier or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.DomainOwnershipIdentifierCollection] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_ownership_identifiers_request(
                    resource_group_name=resource_group_name,
                    domain_name=domain_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_ownership_identifiers.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("DomainOwnershipIdentifierCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_ownership_identifiers.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers"
    }

    @distributed_trace_async
    async def get_ownership_identifier(
        self, resource_group_name: str, domain_name: str, name: str, **kwargs: Any
    ) -> _models.DomainOwnershipIdentifier:
        """Get ownership identifier for domain.

        Get ownership identifier for domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of domain. Required.
        :type domain_name: str
        :param name: Name of identifier. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DomainOwnershipIdentifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[_models.DomainOwnershipIdentifier] = kwargs.pop("cls", None)

        request = build_get_ownership_identifier_request(
            resource_group_name=resource_group_name,
            domain_name=domain_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get_ownership_identifier.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DomainOwnershipIdentifier", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_ownership_identifier.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
    }

    @overload
    async def create_or_update_ownership_identifier(
        self,
        resource_group_name: str,
        domain_name: str,
        name: str,
        domain_ownership_identifier: _models.DomainOwnershipIdentifier,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DomainOwnershipIdentifier:
        """Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of domain. Required.
        :type domain_name: str
        :param name: Name of identifier. Required.
        :type name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DomainOwnershipIdentifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update_ownership_identifier(
        self,
        resource_group_name: str,
        domain_name: str,
        name: str,
        domain_ownership_identifier: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DomainOwnershipIdentifier:
        """Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of domain. Required.
        :type domain_name: str
        :param name: Name of identifier. Required.
        :type name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DomainOwnershipIdentifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update_ownership_identifier(
        self,
        resource_group_name: str,
        domain_name: str,
        name: str,
        domain_ownership_identifier: Union[_models.DomainOwnershipIdentifier, IO],
        **kwargs: Any
    ) -> _models.DomainOwnershipIdentifier:
        """Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of domain. Required.
        :type domain_name: str
        :param name: Name of identifier. Required.
        :type name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Is either a DomainOwnershipIdentifier type or a IO type. Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier
         or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DomainOwnershipIdentifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DomainOwnershipIdentifier] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(domain_ownership_identifier, (IO, bytes)):
            _content = domain_ownership_identifier
        else:
            _json = self._serialize.body(domain_ownership_identifier, "DomainOwnershipIdentifier")

        request = build_create_or_update_ownership_identifier_request(
            resource_group_name=resource_group_name,
            domain_name=domain_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create_or_update_ownership_identifier.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DomainOwnershipIdentifier", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_ownership_identifier.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
    }

    @distributed_trace_async
    async def delete_ownership_identifier(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, domain_name: str, name: str, **kwargs: Any
    ) -> None:
        """Delete ownership identifier for domain.

        Delete ownership identifier for domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of domain. Required.
        :type domain_name: str
        :param name: Name of identifier. Required.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_delete_ownership_identifier_request(
            resource_group_name=resource_group_name,
            domain_name=domain_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete_ownership_identifier.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete_ownership_identifier.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
    }

    @overload
    async def update_ownership_identifier(
        self,
        resource_group_name: str,
        domain_name: str,
        name: str,
        domain_ownership_identifier: _models.DomainOwnershipIdentifier,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DomainOwnershipIdentifier:
        """Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of domain. Required.
        :type domain_name: str
        :param name: Name of identifier. Required.
        :type name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DomainOwnershipIdentifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_ownership_identifier(
        self,
        resource_group_name: str,
        domain_name: str,
        name: str,
        domain_ownership_identifier: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DomainOwnershipIdentifier:
        """Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of domain. Required.
        :type domain_name: str
        :param name: Name of identifier. Required.
        :type name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Required.
        :type domain_ownership_identifier: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DomainOwnershipIdentifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_ownership_identifier(
        self,
        resource_group_name: str,
        domain_name: str,
        name: str,
        domain_ownership_identifier: Union[_models.DomainOwnershipIdentifier, IO],
        **kwargs: Any
    ) -> _models.DomainOwnershipIdentifier:
        """Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        Creates an ownership identifier for a domain or updates identifier details for an existing
        identifier.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of domain. Required.
        :type domain_name: str
        :param name: Name of identifier. Required.
        :type name: str
        :param domain_ownership_identifier: A JSON representation of the domain ownership properties.
         Is either a DomainOwnershipIdentifier type or a IO type. Required.
        :type domain_ownership_identifier: ~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier
         or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DomainOwnershipIdentifier or the result of cls(response)
        :rtype: ~azure.mgmt.web.v2021_01_15.models.DomainOwnershipIdentifier
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DomainOwnershipIdentifier] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(domain_ownership_identifier, (IO, bytes)):
            _content = domain_ownership_identifier
        else:
            _json = self._serialize.body(domain_ownership_identifier, "DomainOwnershipIdentifier")

        request = build_update_ownership_identifier_request(
            resource_group_name=resource_group_name,
            domain_name=domain_name,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update_ownership_identifier.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("DomainOwnershipIdentifier", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_ownership_identifier.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/domainOwnershipIdentifiers/{name}"
    }

    @distributed_trace_async
    async def renew(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, domain_name: str, **kwargs: Any
    ) -> None:
        """Renew a domain.

        Renew a domain.

        :param resource_group_name: Name of the resource group to which the resource belongs. Required.
        :type resource_group_name: str
        :param domain_name: Name of the domain. Required.
        :type domain_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-01-15"] = kwargs.pop("api_version", _params.pop("api-version", "2021-01-15"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_renew_request(
            resource_group_name=resource_group_name,
            domain_name=domain_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.renew.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.DefaultErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    renew.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}/renew"
    }
