# Copyright 2013 OpenStack Foundation
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.


class BackupView(object):

    def __init__(self, backup):
        self.backup = backup

    def data(self):
        return {"backup": {
            "id": self.backup.id,
            "name": self.backup.name,
            "description": self.backup.description,
            "locationRef": self.backup.location,
            "instance_id": self.backup.instance_id,
            "created": self.backup.created,
            "updated": self.backup.updated,
            "size": self.backup.size,
            "status": self.backup.state,
            "parent_id": self.backup.parent_id,
        }
        }


class BackupViews(object):

    def __init__(self, backups):
        self.backups = backups

    def data(self):
        backups = []

        for b in self.backups:
            backups.append(BackupView(b).data()["backup"])
        return {"backups": backups}
