/**********************************************************************
 *
 *    FILE:            Material.cpp
 *
 *    DESCRIPTION:    Read/Write osg::Material in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerated
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 20.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "Material.h"
#include "Object.h"

using namespace ive;

void Material::write(DataOutputStream* out){
    // Write Material's identification.
    out->writeInt(IVEMATERIAL);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj){
        ((ive::Object*)(obj))->write(out);
    }
    else
        out_THROW_EXCEPTION("Material::write(): Could not cast this osg::Material to an osg::Object.");
    // Write Material's properties.

    //    Write color mode
    out->writeInt(_colorMode);
    // Write ambient
    out->writeBool(_ambientFrontAndBack);
    out->writeVec4(_ambientFront);
    out->writeVec4(_ambientBack);
    // Write diffuse
    out->writeBool(_diffuseFrontAndBack);
    out->writeVec4(_diffuseFront);
    out->writeVec4(_diffuseBack);
    // Write specular
    out->writeBool(_specularFrontAndBack);
    out->writeVec4(_specularFront);
    out->writeVec4(_specularBack);
    // Write emmision
    out->writeBool(_emissionFrontAndBack);
    out->writeVec4(_emissionFront);
    out->writeVec4(_emissionBack);
    // Write shininess
    out->writeBool(_shininessFrontAndBack);
    out->writeFloat(_shininessFront);
    out->writeFloat(_shininessBack);

}

void Material::read(DataInputStream* in){
    // Read Material's identification.
    int id = in->peekInt();
    if(id == IVEMATERIAL){
        // Code to read Material's properties.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj){
            ((ive::Object*)(obj))->read(in);
        }
        else
            in_THROW_EXCEPTION("Material::read(): Could not cast this osg::Material to an osg::Object.");

        // Read color mode.
        _colorMode = (osg::Material::ColorMode)in->readInt();
        // Read ambient
        _ambientFrontAndBack = in->readBool();
        _ambientFront = in->readVec4();
        _ambientBack = in->readVec4();
        // Read diffuse
        _diffuseFrontAndBack = in->readBool();
        _diffuseFront = in->readVec4();
        _diffuseBack = in->readVec4();
        // Read specular
        _specularFrontAndBack = in->readBool();
        _specularFront = in->readVec4();
        _specularBack = in->readVec4();
        // Read emission
        _emissionFrontAndBack = in->readBool();
        _emissionFront = in->readVec4();
        _emissionBack = in->readVec4();
        // Read shiniess
        _shininessFrontAndBack = in->readBool();
        _shininessFront = in->readFloat();
        _shininessBack = in->readFloat();
    }
    else{
        in_THROW_EXCEPTION("Material::read(): Expected Material identification.");
    }
}
