# io.js TC Meeting 2015-01-07

## Links

* **Google Hangouts Video**: http://www.youtube.com/watch?v=hWDSToC9EV8
* **GitHub Issue**: https://github.com/nodejs/io.js/issues/230
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1j7Sdui5DqHE8GZHxuoAaoIQ4jlntacZI285OCfVa-Eo

## Agenda

Extracted from https://github.com/nodejs/io.js/labels/tc-agenda prior to meeting.

* Invite Colin Ihrig to the TC #223 https://github.com/nodejs/io.js/issues/223
* File copyright policy #216 https://github.com/nodejs/io.js/issues/216
* Doc: clarified & split up contribution docs #233 https://github.com/nodejs/io.js/pull/233
* Governance: Add new Collaborators #234 https://github.com/nodejs/io.js/issues/234
* deps: upgrade v8 to 3.31.74.1 #243 https://github.com/nodejs/io.js/pull/243
* Build
* Intl - defaults
* Merge v0.10
* npm upgrade _(did not get to this)_

## Minutes

### Present

* Bert (TC)
* Ben (TC)
* Chris (TC)
* Fedor (TC)
* Isaac (TC)
* Colin (for voting as addition to TC)
* Mikeal
* Rod (facilitator)

### Mini stand-up

* ben: integrating tick processor, rename binary to “iojs”, upgrade v8, and plenty of libuv features/bug fixes.
* bert: libuv: readdir on windows, build with clang, plan for next unstable libuv, use similar ev loop impl on windows as unix first tentative patches available for review.
* chris: streams - solving failure on v1.x branch for npm, zlib patch breaks stuff, streams visualization stuff doc/writeup of node streams and whatWG streams
* fedor /few-dir/: no updates, working on non-iojs stuff and holidays
* colin: triaging issues in io.js and joyent/node.  helping with merge of 0.12 to 0.10
* isaac: no io.js, vacation
* mikeal: nada
* rod: build build build ci ci ci.  re-did all the build slaves on Jenkins, introduced a bunch more.  Ansible scripts for linux machines (CentOS 5,6,7, Ubuntu all LTS + Current 14.10 +32bit versions, 2 ARM v7s one virtual one physical, 2 of each Windows 2012,2008, a couple interim OS X machines more permanent ones coming from Voxer soon).  https://github.com/nodejs/build Still lacking specific Jenkins setup and secrets.  Working on release process.
    mikeal: issue re release?
    rod: not yet, a lot of little bugs to get CI working consistently.  No grand plan for what’s in release yet.


### Review of last meeting

* sys: Remove after 3 years of deprecation #182 
* module: force require('process') to return a reference to process #206
* File copyright policy #216
* Rename v0.12 to v1.0.0
* Merge strategy (v0.10 and joyent/node)

### Invite Colin Ihrig to the TC #223 

https://github.com/nodejs/io.js/issues/223

Asked for vote

Passed unanimously

Some discussion about TC member addition process

### File copyright policy #216

https://github.com/nodejs/io.js/issues/216

* Rod: got feedback from NodeSource GC on this, recommendation is to keep the copyright but removal of the license notice is acceptable
* Mikeal & Isaac: removing the copyright should be OK because we have full git record of who made & edited the file, it’s a PITA
* Asked for vote on removing copyright and license from the top of each source file, moving it a single top level file. **Nobody objected**.
* Agreed to table further discussion on modifying the license and copyright.
* isaacs will submit PR to remove license blocks from files.

### Doc: clarified & split up contribution docs #233 

https://github.com/nodejs/io.js/pull/233

* Rod: discussed changes introduced in #233, this is in TC because there are some minor modifications to the governance structure. Recommended that we deal with further changes to governance as a separate discussion.
* Fedor: remove caine block from CONTRIBUTING.md
* Mikeal: take PR as is, move the rest to further discussion & PR
* No objections, agreed to move changes to governance and other adjustments such as moving docs into the docs dir to separate pull requests.
* Isaacs and Chris will review and +1 the PR.

### Governance: Add new Collaborators #234 

https://github.com/nodejs/io.js/issues/234

Rod discussed the generation of the list of proposed collaborators. 

Long discussion:

* Isaacs, Chris, Bert suggest throttling new contrib additions to 5/week, bump up to 10/week if it goes well, etc.
* Ben 50/50 on “add everyone now” or “throttle new additions”
* Bert to review list and see if there’s any contributors that seem we should not add.
* Other TC members can review list this week.
* Two issues to vote on at next TC meeting
  - Issue 1:
    a. Add everyone
    b. Add everyone except some that are not added
  - Issue 2:
    a. Create a queue of people to add, throttle per week
    b. Add immediately

### deps: upgrade v8 to 3.31.74.1 #243 

https://github.com/nodejs/io.js/pull/243

* Ben: clean compile, apparently a clean upgrade. It does break postmortem support so Ben removed it completely. Asked who was using it.
* Ben: adds new features:
 - numeric literals
 - string methods
 - block scoping
 - classes (strict mode)
 - object literal extensions
 - template literals.
* Fedor: Voxer using postmortem support, so it’s not just Joyent. Would prefer to fix it.
* No disagreement about merging this.
* Ben and Fedor to take discussion about details to GitHub.

### Build & release

Rod rambled on about build & release:

* Lots of minor test failures to take care of and make sure there are no serious blockers: https://jenkins-iojs.nodesource.com/job/iojs+any-pr+multi/
* is osx 32-bit necessary? group agreed to leave it out.
* binary naming: Ben currently taking care of renaming, Bert will help out with a solution for windows
* release blobs:
  - source
  - windows 32, 64
  - osx 64-bit, built on 10.10 - specify minimum requirement in XCode (apparently)
  - linux, centos 5, libstdc++ static - Ben says we shouldn't have to, although Rod found it necessary when built with Debian Weezy, give Ben access to CentOS box to try it out
  - linux armv7 (built on Ubuntu 14.04) (perhaps armv6 for rpi, but compile should not hold up a release--drop in later?)
  - Windows bare files, Bert explained the files currently released in nodejs.org/dist/*/
    - node.lib downloaded by node-gyp for compile
    - node.pdb contains debug information (may not be needed, not used by the group, perhaps someone asked for it?), leave it out
    - node.exe is useful where an .msi is a problem to run (no admin access)
    - Rod proposed to move to a .zip for these for 32 and 64, but this may be a problem to get ready for release, discuss further with Bert
* Version number - all agreed to go with 1.0.0, but it should be clearly labeled as an initial “beta”-type release for the project.
* Website for blog/announce/news, Rod proposed Mikeal take responsibility for now until we find a better owner / team, Mikeal agreed.
* Dist folder structure
 - Agreed to keep iojs.org/dist/ to mirror nodejs.org/dist, other things via symlinks and html hyperlinks.
 - Maybe have a iojs.org/downloads/v1/1.0.0/… and perhaps a text/html thing with links to each relevant release

* Bert: Node still merging in 0.10 to 0.12, is there anything that should be merged in 0.10 that we really need?
* intl: Bert kind of hates this patch.  joyent/node is moving towards building with small icu, you get intl object, but only supports english.  CAN build with another icu to add other intls. Bert to open an issue to discuss further. May leave out ICU completely from 1.0.0.


### Next meeting

* Bring a day forward to bless a release, i.e. 2015-01-13
