/*
 * ppdenums.h: enum definitions
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * See the AUTHORS file for a list of people who have hacked on 
 * this code. 
 * See the ChangeLog file for a list of changes.
 *
 * Contents:
 * Several useful enum definitions for libppd.
 *
 */

#ifndef _PPD_ENUMS_H_
#  define _PPD_ENUMS_H_

// C++ magic...
#  ifdef __cplusplus
extern "C" {
#  endif			// __cplusplus
  typedef enum {		// *** UI types ***
    PPD_UI_BOOLEAN,		// True or False option 
    PPD_UI_PICKONE,		// Pick one from a list 
    PPD_UI_PICKMANY		// Pick zero or more from a list
  } PpdUIType;			/* used to be ppd_ui_t */

  typedef enum {		// *** Order dependency sections ***
    PPD_ORDER_ANY,		// Option code can be anywhere in the file 
    PPD_ORDER_DOCUMENT,		// ... must be in the DocumentSetup section 
    PPD_ORDER_EXIT,		// ... must be sent prior to the document 
    PPD_ORDER_JCL,		// ... must be sent as a JCL command 
    PPD_ORDER_PAGE,		// ... must be in the PageSetup section 
    PPD_ORDER_PROLOG		// ... must be in the Prolog section
  } PpdSectionOrder;		/* used to be ppd_section_t */

  typedef enum {		// *** Colorspaces ***
    PPD_CS_CMYK = -4,		// CMYK colorspace 
    PPD_CS_CMY,			// CMY colorspace 
    PPD_CS_GRAY = 1,		// Grayscale colorspace 
    PPD_CS_RGB = 3,		// RGB colorspace 
    PPD_CS_RGBK,		// RGBK (K = gray) colorspace 
    PPD_CS_N			// DeviceN colorspace
  } PpdCSType;			/* used to be ppd_cs_t */

// C++ magic...
#  ifdef __cplusplus
}
#  endif			// __cplusplus
#endif				// !_PPD_ENUMS_H_
// End of ppdenums.h
