package org.eclipse.webdav.internal.kernel.utils;

/*
 * (c) Copyright IBM Corp. 2000, 2001.
 * All Rights Reserved.
 */

import java.util.Enumeration;
import java.util.Vector;

public class ExcludingEnumeration extends EnumerationFilter {

	protected Enumeration enum;
	protected Vector excludeList;
	protected Object next;
public ExcludingEnumeration(Enumeration enum, Vector excludeList) {

	super();

	this.enum = enum;
	this.excludeList = excludeList;

	getNextCandidate();
}
private void getNextCandidate() {

	while (enum.hasMoreElements()) {
		Object candidate = enum.nextElement();
		if (excludeList.indexOf(candidate) != -1) {
			next = candidate;
			return;
		}
	}

	next = null;
}
public boolean hasMoreElements() {

	return (next != null);
}
public Object nextElement() {

	Object answer = next;
	getNextCandidate();
	return answer;
}
}
