/*
 * Atom-4 ncurses interface
 * Header file
 *
 * $Id: textui.h,v 1.14 2003/04/08 09:57:15 hsteoh Exp hsteoh $
 */

#include <stdio.h>
#include <curses.h>
#include <panel.h>

#include "event.h"
#include "game.h"
#include "interface.h"
#include "triboard.h"


#define BOARDWIN_X		0
#define BOARDWIN_Y		1

#define IOWIN_Y			0
#define IOWIN_TITLE_Y		0
#define IOWIN_ROUND_Y		2
#define IOWIN_PLPANEL_Y		4
#define IOWIN_PLPANEL_HEIGHT	6

#define IOWIN_PANEL_TITLE_Y	0
#define IOWIN_PANEL_SCORE_Y	1
#define IOWIN_PANEL_PROMPT_Y	3
#define IOWIN_WAITKEY_X		0
#define IOWIN_WAITKEY_Y		3

#define STRBUF_SIZE		512

#define NUM_CELLTYPES		8	// 8 colors


class ncurses_ui : public interface {
public:
  enum opt_t {				// these can be OR'd together
    ENABLE_COLOR=1
  };
private:
  int options;				// (technically, OR-ified opt_t)

  eventloop *loop;			// [R]
  int *exitflag;			// [R]
  class keyhandler : public eventhandler {
    ncurses_ui *ui;			// [R]
  public:
    keyhandler(ncurses_ui *_ui) : ui(_ui) {}
    virtual void read_ready(eventloop *src, int fd);
    virtual void write_ready(eventloop *src, int fd);
  } khandler;
  class changehandler : public atom4notifier {
    ncurses_ui *ui;			// [R]
  public:
    changehandler(ncurses_ui *_ui) : ui(_ui) {}
    virtual void notify_move(atom4 *src, int player,
                             elist<boardchange> &changes);
    virtual void notify_clear(atom4 *src);
  } notifier;
  void handlekey();

  // Game board
  WINDOW *bwin;
  PANEL *bpanel;
  triboard *board;			// [R]
  int last_x, last_y;			// last cursor position on board
  short cellcolors[NUM_CELLTYPES];	// ncurses color pairs
  char cellbold[NUM_CELLTYPES];		// color pairs which must be bolded

  // I/O panel
  WINDOW *iowin;
  PANEL *iopanel;

  // Players info
  int colors[NUM_PLAYERS];		// cosmetic settings :-)

  // Message panel
  WINDOW *msgwin;
  PANEL *msgpanel;

  // Miscellaneous stuff
  char strbuf[STRBUF_SIZE];		// temp buffer for formatting strings

  int use_color() { return options&ENABLE_COLOR; }
  int formatstr(char *fmt, ...);
  int message(char *fmt, ...);
  void draw_tile(WINDOW *w, celltype cell);
  friend void render_cell(int x, int y, celltype cell, void *context);
  void render_board();
  void render_scorepanel(int player);
  void render_iowin();
  void refresh();
  int wait_key();
  int ask_yn(char *msg);
  int init_color();
public:
  ncurses_ui(atom4 *game, eventloop *loop, int *exitflag, int options=0);
  ~ncurses_ui();
};

