/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewGroupCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;

public class DrawerLayout
extends ViewGroup {
    private static final String TAG = "DrawerLayout";
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGGING = 1;
    public static final int STATE_SETTLING = 2;
    public static final int LOCK_MODE_UNLOCKED = 0;
    public static final int LOCK_MODE_LOCKED_CLOSED = 1;
    public static final int LOCK_MODE_LOCKED_OPEN = 2;
    private static final int MIN_DRAWER_MARGIN = 64;
    private static final int DEFAULT_SCRIM_COLOR = -1728053248;
    private static final int PEEK_DELAY = 160;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final boolean ALLOW_EDGE_LOCK = false;
    private static final int[] LAYOUT_ATTRS = new int[]{16842931};
    private int mMinDrawerMargin;
    private int mScrimColor = -1728053248;
    private float mScrimOpacity;
    private Paint mScrimPaint = new Paint();
    private final ViewDragHelper mLeftDragger;
    private final ViewDragHelper mRightDragger;
    private final ViewDragCallback mLeftCallback;
    private final ViewDragCallback mRightCallback;
    private int mDrawerState;
    private boolean mInLayout;
    private boolean mFirstLayout = true;
    private int mLockModeLeft;
    private int mLockModeRight;
    private boolean mDisallowInterceptRequested;
    private boolean mChildrenCanceledTouch;
    private DrawerListener mListener;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private Drawable mShadowLeft;
    private Drawable mShadowRight;

    public DrawerLayout(Context context) {
        this(context, null);
    }

    public DrawerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DrawerLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        float density = this.getResources().getDisplayMetrics().density;
        this.mMinDrawerMargin = (int)(64.0f * density + 0.5f);
        float minVel = 400.0f * density;
        this.mLeftCallback = new ViewDragCallback(3);
        this.mRightCallback = new ViewDragCallback(5);
        this.mLeftDragger = ViewDragHelper.create(this, 0.5f, this.mLeftCallback);
        this.mLeftDragger.setEdgeTrackingEnabled(1);
        this.mLeftDragger.setMinVelocity(minVel);
        this.mLeftCallback.setDragger(this.mLeftDragger);
        this.mRightDragger = ViewDragHelper.create(this, 0.5f, this.mRightCallback);
        this.mRightDragger.setEdgeTrackingEnabled(2);
        this.mRightDragger.setMinVelocity(minVel);
        this.mRightCallback.setDragger(this.mRightDragger);
        this.setFocusableInTouchMode(true);
        ViewCompat.setAccessibilityDelegate((View)this, new AccessibilityDelegate());
        ViewGroupCompat.setMotionEventSplittingEnabled(this, false);
    }

    public void setDrawerShadow(Drawable shadowDrawable, int gravity) {
        int absGravity = GravityCompat.getAbsoluteGravity(gravity, ViewCompat.getLayoutDirection((View)this));
        if ((absGravity & 3) == 3) {
            this.mShadowLeft = shadowDrawable;
            this.invalidate();
        }
        if ((absGravity & 5) == 5) {
            this.mShadowRight = shadowDrawable;
            this.invalidate();
        }
    }

    public void setDrawerShadow(int resId, int gravity) {
        this.setDrawerShadow(this.getResources().getDrawable(resId), gravity);
    }

    public void setScrimColor(int color) {
        this.mScrimColor = color;
        this.invalidate();
    }

    public void setDrawerListener(DrawerListener listener) {
        this.mListener = listener;
    }

    public void setDrawerLockMode(int lockMode) {
        this.setDrawerLockMode(lockMode, 3);
        this.setDrawerLockMode(lockMode, 5);
    }

    public void setDrawerLockMode(int lockMode, int edgeGravity) {
        int absGrav = GravityCompat.getAbsoluteGravity(edgeGravity, ViewCompat.getLayoutDirection((View)this));
        if (absGrav == 3) {
            this.mLockModeLeft = lockMode;
        } else if (absGrav == 5) {
            this.mLockModeRight = lockMode;
        }
        if (lockMode != 0) {
            ViewDragHelper helper = absGrav == 3 ? this.mLeftDragger : this.mRightDragger;
            helper.cancel();
        }
        switch (lockMode) {
            case 2: {
                View toOpen = this.findDrawerWithGravity(absGrav);
                if (toOpen == null) break;
                this.openDrawer(toOpen);
                break;
            }
            case 1: {
                View toClose = this.findDrawerWithGravity(absGrav);
                if (toClose == null) break;
                this.closeDrawer(toClose);
            }
        }
    }

    public void setDrawerLockMode(int lockMode, View drawerView) {
        if (!this.isDrawerView(drawerView)) {
            throw new IllegalArgumentException("View " + drawerView + " is not a " + "drawer with appropriate layout_gravity");
        }
        this.setDrawerLockMode(lockMode, this.getDrawerViewGravity(drawerView));
    }

    public int getDrawerLockMode(int edgeGravity) {
        int absGrav = GravityCompat.getAbsoluteGravity(edgeGravity, ViewCompat.getLayoutDirection((View)this));
        if (absGrav == 3) {
            return this.mLockModeLeft;
        }
        if (absGrav == 5) {
            return this.mLockModeRight;
        }
        return 0;
    }

    public int getDrawerLockMode(View drawerView) {
        int gravity = this.getDrawerViewGravity(drawerView);
        if (gravity == 3) {
            return this.mLockModeLeft;
        }
        if (gravity == 5) {
            return this.mLockModeRight;
        }
        return 0;
    }

    void updateDrawerState(int forGravity, int activeState, View activeDrawer) {
        int leftState = this.mLeftDragger.getViewDragState();
        int rightState = this.mRightDragger.getViewDragState();
        int state = leftState == 1 || rightState == 1 ? 1 : (leftState == 2 || rightState == 2 ? 2 : 0);
        if (activeDrawer != null && activeState == 0) {
            LayoutParams lp = (LayoutParams)activeDrawer.getLayoutParams();
            if (lp.onScreen == 0.0f) {
                this.dispatchOnDrawerClosed(activeDrawer);
            } else if (lp.onScreen == 1.0f) {
                this.dispatchOnDrawerOpened(activeDrawer);
            }
        }
        if (state != this.mDrawerState) {
            this.mDrawerState = state;
            if (this.mListener != null) {
                this.mListener.onDrawerStateChanged(state);
            }
        }
    }

    void dispatchOnDrawerClosed(View drawerView) {
        LayoutParams lp = (LayoutParams)drawerView.getLayoutParams();
        if (lp.knownOpen) {
            lp.knownOpen = false;
            if (this.mListener != null) {
                this.mListener.onDrawerClosed(drawerView);
            }
            this.sendAccessibilityEvent(32);
        }
    }

    void dispatchOnDrawerOpened(View drawerView) {
        LayoutParams lp = (LayoutParams)drawerView.getLayoutParams();
        if (!lp.knownOpen) {
            lp.knownOpen = true;
            if (this.mListener != null) {
                this.mListener.onDrawerOpened(drawerView);
            }
            drawerView.sendAccessibilityEvent(32);
        }
    }

    void dispatchOnDrawerSlide(View drawerView, float slideOffset) {
        if (this.mListener != null) {
            this.mListener.onDrawerSlide(drawerView, slideOffset);
        }
    }

    void setDrawerViewOffset(View drawerView, float slideOffset) {
        LayoutParams lp = (LayoutParams)drawerView.getLayoutParams();
        if (slideOffset == lp.onScreen) {
            return;
        }
        lp.onScreen = slideOffset;
        this.dispatchOnDrawerSlide(drawerView, slideOffset);
    }

    float getDrawerViewOffset(View drawerView) {
        return ((LayoutParams)drawerView.getLayoutParams()).onScreen;
    }

    int getDrawerViewGravity(View drawerView) {
        int gravity = ((LayoutParams)drawerView.getLayoutParams()).gravity;
        return GravityCompat.getAbsoluteGravity(gravity, ViewCompat.getLayoutDirection(drawerView));
    }

    boolean checkDrawerViewGravity(View drawerView, int checkFor) {
        int absGrav = this.getDrawerViewGravity(drawerView);
        return (absGrav & checkFor) == checkFor;
    }

    View findOpenDrawer() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!((LayoutParams)child.getLayoutParams()).knownOpen) continue;
            return child;
        }
        return null;
    }

    void moveDrawerToOffset(View drawerView, float slideOffset) {
        float oldOffset = this.getDrawerViewOffset(drawerView);
        int width = drawerView.getWidth();
        int oldPos = (int)((float)width * oldOffset);
        int newPos = (int)((float)width * slideOffset);
        int dx = newPos - oldPos;
        drawerView.offsetLeftAndRight(this.checkDrawerViewGravity(drawerView, 3) ? dx : -dx);
        this.setDrawerViewOffset(drawerView, slideOffset);
    }

    View findDrawerWithGravity(int gravity) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            int childGravity = this.getDrawerViewGravity(child);
            if ((childGravity & 7) != (gravity & 7)) continue;
            return child;
        }
        return null;
    }

    static String gravityToString(int gravity) {
        if ((gravity & 3) == 3) {
            return "LEFT";
        }
        if ((gravity & 5) == 5) {
            return "RIGHT";
        }
        return Integer.toHexString(gravity);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mFirstLayout = true;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode != 0x40000000 || heightMode != 0x40000000) {
            throw new IllegalArgumentException("DrawerLayout must be measured with MeasureSpec.EXACTLY.");
        }
        this.setMeasuredDimension(widthSize, heightSize);
        int foundDrawers = 0;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (this.isContentView(child)) {
                int contentWidthSpec = View.MeasureSpec.makeMeasureSpec((int)(widthSize - lp.leftMargin - lp.rightMargin), (int)0x40000000);
                int contentHeightSpec = View.MeasureSpec.makeMeasureSpec((int)(heightSize - lp.topMargin - lp.bottomMargin), (int)0x40000000);
                child.measure(contentWidthSpec, contentHeightSpec);
                continue;
            }
            if (this.isDrawerView(child)) {
                int childGravity = this.getDrawerViewGravity(child) & 7;
                if ((foundDrawers & childGravity) != 0) {
                    throw new IllegalStateException("Child drawer has absolute gravity " + DrawerLayout.gravityToString(childGravity) + " but this " + TAG + " already has a " + "drawer view along that edge");
                }
                int drawerWidthSpec = DrawerLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.mMinDrawerMargin + lp.leftMargin + lp.rightMargin), (int)lp.width);
                int drawerHeightSpec = DrawerLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(lp.topMargin + lp.bottomMargin), (int)lp.height);
                child.measure(drawerWidthSpec, drawerHeightSpec);
                continue;
            }
            throw new IllegalStateException("Child " + child + " at index " + i + " does not have a valid layout_gravity - must be Gravity.LEFT, " + "Gravity.RIGHT or Gravity.NO_GRAVITY");
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mInLayout = true;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (this.isContentView(child)) {
                child.layout(lp.leftMargin, lp.topMargin, lp.leftMargin + child.getMeasuredWidth(), lp.topMargin + child.getMeasuredHeight());
                continue;
            }
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int childLeft = this.checkDrawerViewGravity(child, 3) ? -childWidth + (int)((float)childWidth * lp.onScreen) : r - l - (int)((float)childWidth * lp.onScreen);
            int vgrav = lp.gravity & 0x70;
            switch (vgrav) {
                default: {
                    child.layout(childLeft, lp.topMargin, childLeft + childWidth, childHeight);
                    break;
                }
                case 80: {
                    int height = b - t;
                    child.layout(childLeft, height - lp.bottomMargin - child.getMeasuredHeight(), childLeft + childWidth, height - lp.bottomMargin);
                    break;
                }
                case 16: {
                    int height = b - t;
                    int childTop = (height - childHeight) / 2;
                    if (childTop < lp.topMargin) {
                        childTop = lp.topMargin;
                    } else if (childTop + childHeight > height - lp.bottomMargin) {
                        childTop = height - lp.bottomMargin - childHeight;
                    }
                    child.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
                    break;
                }
            }
            if (lp.onScreen != 0.0f) continue;
            child.setVisibility(4);
        }
        this.mInLayout = false;
        this.mFirstLayout = false;
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    public void computeScroll() {
        int childCount = this.getChildCount();
        float scrimOpacity = 0.0f;
        for (int i = 0; i < childCount; ++i) {
            float onscreen = ((LayoutParams)this.getChildAt((int)i).getLayoutParams()).onScreen;
            scrimOpacity = Math.max(scrimOpacity, onscreen);
        }
        this.mScrimOpacity = scrimOpacity;
        if (this.mLeftDragger.continueSettling(true) | this.mRightDragger.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private static boolean hasOpaqueBackground(View v) {
        Drawable bg = v.getBackground();
        if (bg != null) {
            return bg.getOpacity() == -1;
        }
        return false;
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        int shadowWidth;
        int height = this.getHeight();
        boolean drawingContent = this.isContentView(child);
        int clipLeft = 0;
        int clipRight = this.getWidth();
        int restoreCount = canvas.save();
        if (drawingContent) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View v = this.getChildAt(i);
                if (v == child || v.getVisibility() != 0 || !DrawerLayout.hasOpaqueBackground(v) || !this.isDrawerView(v) || v.getHeight() < height) continue;
                if (this.checkDrawerViewGravity(v, 3)) {
                    int vright = v.getRight();
                    if (vright <= clipLeft) continue;
                    clipLeft = vright;
                    continue;
                }
                int vleft = v.getLeft();
                if (vleft >= clipRight) continue;
                clipRight = vleft;
            }
            canvas.clipRect(clipLeft, 0, clipRight, this.getHeight());
        }
        boolean result = super.drawChild(canvas, child, drawingTime);
        canvas.restoreToCount(restoreCount);
        if (this.mScrimOpacity > 0.0f && drawingContent) {
            int baseAlpha = (this.mScrimColor & 0xFF000000) >>> 24;
            int imag = (int)((float)baseAlpha * this.mScrimOpacity);
            int color = imag << 24 | this.mScrimColor & 0xFFFFFF;
            this.mScrimPaint.setColor(color);
            canvas.drawRect((float)clipLeft, 0.0f, (float)clipRight, (float)this.getHeight(), this.mScrimPaint);
        } else if (this.mShadowLeft != null && this.checkDrawerViewGravity(child, 3)) {
            shadowWidth = this.mShadowLeft.getIntrinsicWidth();
            int childRight = child.getRight();
            int drawerPeekDistance = this.mLeftDragger.getEdgeSize();
            float alpha = Math.max(0.0f, Math.min((float)childRight / (float)drawerPeekDistance, 1.0f));
            this.mShadowLeft.setBounds(childRight, child.getTop(), childRight + shadowWidth, child.getBottom());
            this.mShadowLeft.setAlpha((int)(255.0f * alpha));
            this.mShadowLeft.draw(canvas);
        } else if (this.mShadowRight != null && this.checkDrawerViewGravity(child, 5)) {
            shadowWidth = this.mShadowRight.getIntrinsicWidth();
            int childLeft = child.getLeft();
            int showing = this.getWidth() - childLeft;
            int drawerPeekDistance = this.mRightDragger.getEdgeSize();
            float alpha = Math.max(0.0f, Math.min((float)showing / (float)drawerPeekDistance, 1.0f));
            this.mShadowRight.setBounds(childLeft - shadowWidth, child.getTop(), childLeft, child.getBottom());
            this.mShadowRight.setAlpha((int)(255.0f * alpha));
            this.mShadowRight.draw(canvas);
        }
        return result;
    }

    boolean isContentView(View child) {
        return ((LayoutParams)child.getLayoutParams()).gravity == 0;
    }

    boolean isDrawerView(View child) {
        int gravity = ((LayoutParams)child.getLayoutParams()).gravity;
        int absGravity = GravityCompat.getAbsoluteGravity(gravity, ViewCompat.getLayoutDirection(child));
        return (absGravity & 7) != 0;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = MotionEventCompat.getActionMasked(ev);
        boolean interceptForDrag = this.mLeftDragger.shouldInterceptTouchEvent(ev) | this.mRightDragger.shouldInterceptTouchEvent(ev);
        boolean interceptForTap = false;
        switch (action) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                if (this.mScrimOpacity > 0.0f && this.isContentView(this.mLeftDragger.findTopChildUnder((int)x, (int)y))) {
                    interceptForTap = true;
                }
                this.mDisallowInterceptRequested = false;
                this.mChildrenCanceledTouch = false;
                break;
            }
            case 2: {
                if (!this.mLeftDragger.checkTouchSlop(3)) break;
                this.mLeftCallback.removeCallbacks();
                this.mRightCallback.removeCallbacks();
                break;
            }
            case 1: 
            case 3: {
                this.closeDrawers(true);
                this.mDisallowInterceptRequested = false;
                this.mChildrenCanceledTouch = false;
            }
        }
        return interceptForDrag || interceptForTap || this.hasPeekingDrawer() || this.mChildrenCanceledTouch;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.mLeftDragger.processTouchEvent(ev);
        this.mRightDragger.processTouchEvent(ev);
        int action = ev.getAction();
        boolean wantTouchEvents = true;
        switch (action & 0xFF) {
            case 0: {
                float x = ev.getX();
                float y = ev.getY();
                this.mInitialMotionX = x;
                this.mInitialMotionY = y;
                this.mDisallowInterceptRequested = false;
                this.mChildrenCanceledTouch = false;
                break;
            }
            case 1: {
                View openDrawer;
                int slop;
                float dy;
                float dx;
                float x = ev.getX();
                float y = ev.getY();
                boolean peekingOnly = true;
                View touchedView = this.mLeftDragger.findTopChildUnder((int)x, (int)y);
                if (touchedView != null && this.isContentView(touchedView) && (dx = x - this.mInitialMotionX) * dx + (dy = y - this.mInitialMotionY) * dy < (float)((slop = this.mLeftDragger.getTouchSlop()) * slop) && (openDrawer = this.findOpenDrawer()) != null) {
                    peekingOnly = this.getDrawerLockMode(openDrawer) == 2;
                }
                this.closeDrawers(peekingOnly);
                this.mDisallowInterceptRequested = false;
                break;
            }
            case 3: {
                this.closeDrawers(true);
                this.mDisallowInterceptRequested = false;
                this.mChildrenCanceledTouch = false;
            }
        }
        return wantTouchEvents;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (!this.mLeftDragger.isEdgeTouched(1) && !this.mRightDragger.isEdgeTouched(2)) {
            super.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
        this.mDisallowInterceptRequested = disallowIntercept;
        if (disallowIntercept) {
            this.closeDrawers(true);
        }
    }

    public void closeDrawers() {
        this.closeDrawers(false);
    }

    void closeDrawers(boolean peekingOnly) {
        boolean needsInvalidate = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (!this.isDrawerView(child) || peekingOnly && !lp.isPeeking) continue;
            int childWidth = child.getWidth();
            needsInvalidate = this.checkDrawerViewGravity(child, 3) ? (needsInvalidate |= this.mLeftDragger.smoothSlideViewTo(child, -childWidth, child.getTop())) : (needsInvalidate |= this.mRightDragger.smoothSlideViewTo(child, this.getWidth(), child.getTop()));
            lp.isPeeking = false;
        }
        this.mLeftCallback.removeCallbacks();
        this.mRightCallback.removeCallbacks();
        if (needsInvalidate) {
            this.invalidate();
        }
    }

    public void openDrawer(View drawerView) {
        if (!this.isDrawerView(drawerView)) {
            throw new IllegalArgumentException("View " + drawerView + " is not a sliding drawer");
        }
        if (this.mFirstLayout) {
            LayoutParams lp = (LayoutParams)drawerView.getLayoutParams();
            lp.onScreen = 1.0f;
            lp.knownOpen = true;
        } else if (this.checkDrawerViewGravity(drawerView, 3)) {
            this.mLeftDragger.smoothSlideViewTo(drawerView, 0, drawerView.getTop());
        } else {
            this.mRightDragger.smoothSlideViewTo(drawerView, this.getWidth() - drawerView.getWidth(), drawerView.getTop());
        }
        this.invalidate();
    }

    public void openDrawer(int gravity) {
        int absGravity = GravityCompat.getAbsoluteGravity(gravity, ViewCompat.getLayoutDirection((View)this));
        View drawerView = this.findDrawerWithGravity(absGravity);
        if (drawerView == null) {
            throw new IllegalArgumentException("No drawer view found with absolute gravity " + DrawerLayout.gravityToString(absGravity));
        }
        this.openDrawer(drawerView);
    }

    public void closeDrawer(View drawerView) {
        if (!this.isDrawerView(drawerView)) {
            throw new IllegalArgumentException("View " + drawerView + " is not a sliding drawer");
        }
        if (this.mFirstLayout) {
            LayoutParams lp = (LayoutParams)drawerView.getLayoutParams();
            lp.onScreen = 0.0f;
            lp.knownOpen = false;
        } else if (this.checkDrawerViewGravity(drawerView, 3)) {
            this.mLeftDragger.smoothSlideViewTo(drawerView, -drawerView.getWidth(), drawerView.getTop());
        } else {
            this.mRightDragger.smoothSlideViewTo(drawerView, this.getWidth(), drawerView.getTop());
        }
        this.invalidate();
    }

    public void closeDrawer(int gravity) {
        int absGravity = GravityCompat.getAbsoluteGravity(gravity, ViewCompat.getLayoutDirection((View)this));
        View drawerView = this.findDrawerWithGravity(absGravity);
        if (drawerView == null) {
            throw new IllegalArgumentException("No drawer view found with absolute gravity " + DrawerLayout.gravityToString(absGravity));
        }
        this.closeDrawer(drawerView);
    }

    public boolean isDrawerOpen(View drawer) {
        if (!this.isDrawerView(drawer)) {
            throw new IllegalArgumentException("View " + drawer + " is not a drawer");
        }
        return ((LayoutParams)drawer.getLayoutParams()).knownOpen;
    }

    public boolean isDrawerOpen(int drawerGravity) {
        View drawerView = this.findDrawerWithGravity(drawerGravity);
        if (drawerView != null) {
            return this.isDrawerOpen(drawerView);
        }
        return false;
    }

    public boolean isDrawerVisible(View drawer) {
        if (!this.isDrawerView(drawer)) {
            throw new IllegalArgumentException("View " + drawer + " is not a drawer");
        }
        return ((LayoutParams)drawer.getLayoutParams()).onScreen > 0.0f;
    }

    public boolean isDrawerVisible(int drawerGravity) {
        View drawerView = this.findDrawerWithGravity(drawerGravity);
        if (drawerView != null) {
            return this.isDrawerVisible(drawerView);
        }
        return false;
    }

    private boolean hasPeekingDrawer() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            if (!lp.isPeeking) continue;
            return true;
        }
        return false;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams ? new LayoutParams((LayoutParams)p) : (p instanceof ViewGroup.MarginLayoutParams ? new LayoutParams((ViewGroup.MarginLayoutParams)p) : new LayoutParams(p));
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private boolean hasVisibleDrawer() {
        return this.findVisibleDrawer() != null;
    }

    private View findVisibleDrawer() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!this.isDrawerView(child) || !this.isDrawerVisible(child)) continue;
            return child;
        }
        return null;
    }

    void cancelChildViewTouch() {
        if (!this.mChildrenCanceledTouch) {
            long now = SystemClock.uptimeMillis();
            MotionEvent cancelEvent = MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0);
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                this.getChildAt(i).dispatchTouchEvent(cancelEvent);
            }
            cancelEvent.recycle();
            this.mChildrenCanceledTouch = true;
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.hasVisibleDrawer()) {
            KeyEventCompat.startTracking(event);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            View visibleDrawer = this.findVisibleDrawer();
            if (visibleDrawer != null && this.getDrawerLockMode(visibleDrawer) == 0) {
                this.closeDrawers();
            }
            return visibleDrawer != null;
        }
        return super.onKeyUp(keyCode, event);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        View toOpen;
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.openDrawerGravity != 0 && (toOpen = this.findDrawerWithGravity(ss.openDrawerGravity)) != null) {
            this.openDrawer(toOpen);
        }
        this.setDrawerLockMode(ss.lockModeLeft, 3);
        this.setDrawerLockMode(ss.lockModeRight, 5);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!this.isDrawerView(child)) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (!lp.knownOpen) continue;
            ss.openDrawerGravity = lp.gravity;
            break;
        }
        ss.lockModeLeft = this.mLockModeLeft;
        ss.lockModeRight = this.mLockModeRight;
        return ss;
    }

    class AccessibilityDelegate
    extends AccessibilityDelegateCompat {
        private final Rect mTmpRect = new Rect();

        AccessibilityDelegate() {
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
            AccessibilityNodeInfoCompat superNode = AccessibilityNodeInfoCompat.obtain(info);
            super.onInitializeAccessibilityNodeInfo(host, superNode);
            info.setSource(host);
            ViewParent parent = ViewCompat.getParentForAccessibility(host);
            if (parent instanceof View) {
                info.setParent((View)parent);
            }
            this.copyNodeInfoNoChildren(info, superNode);
            superNode.recycle();
            int childCount = DrawerLayout.this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = DrawerLayout.this.getChildAt(i);
                if (this.filter(child)) continue;
                info.addChild(child);
            }
        }

        public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
            if (!this.filter(child)) {
                return super.onRequestSendAccessibilityEvent(host, child, event);
            }
            return false;
        }

        public boolean filter(View child) {
            View openDrawer = DrawerLayout.this.findOpenDrawer();
            return openDrawer != null && openDrawer != child;
        }

        private void copyNodeInfoNoChildren(AccessibilityNodeInfoCompat dest, AccessibilityNodeInfoCompat src) {
            Rect rect = this.mTmpRect;
            src.getBoundsInParent(rect);
            dest.setBoundsInParent(rect);
            src.getBoundsInScreen(rect);
            dest.setBoundsInScreen(rect);
            dest.setVisibleToUser(src.isVisibleToUser());
            dest.setPackageName(src.getPackageName());
            dest.setClassName(src.getClassName());
            dest.setContentDescription(src.getContentDescription());
            dest.setEnabled(src.isEnabled());
            dest.setClickable(src.isClickable());
            dest.setFocusable(src.isFocusable());
            dest.setFocused(src.isFocused());
            dest.setAccessibilityFocused(src.isAccessibilityFocused());
            dest.setSelected(src.isSelected());
            dest.setLongClickable(src.isLongClickable());
            dest.addAction(src.getActions());
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int gravity = 0;
        float onScreen;
        boolean isPeeking;
        boolean knownOpen;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, LAYOUT_ATTRS);
            this.gravity = a.getInt(0, 0);
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, int gravity) {
            this(width, height);
            this.gravity = gravity;
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.gravity = source.gravity;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private final int mGravity;
        private ViewDragHelper mDragger;
        private final Runnable mPeekRunnable = new Runnable(){

            public void run() {
                ViewDragCallback.this.peekDrawer();
            }
        };

        public ViewDragCallback(int gravity) {
            this.mGravity = gravity;
        }

        public void setDragger(ViewDragHelper dragger) {
            this.mDragger = dragger;
        }

        public void removeCallbacks() {
            DrawerLayout.this.removeCallbacks(this.mPeekRunnable);
        }

        public boolean tryCaptureView(View child, int pointerId) {
            return DrawerLayout.this.isDrawerView(child) && DrawerLayout.this.checkDrawerViewGravity(child, this.mGravity) && DrawerLayout.this.getDrawerLockMode(child) == 0;
        }

        public void onViewDragStateChanged(int state) {
            DrawerLayout.this.updateDrawerState(this.mGravity, state, this.mDragger.getCapturedView());
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            float offset;
            int childWidth = changedView.getWidth();
            if (DrawerLayout.this.checkDrawerViewGravity(changedView, 3)) {
                offset = (float)(childWidth + left) / (float)childWidth;
            } else {
                int width = DrawerLayout.this.getWidth();
                offset = (float)(width - left) / (float)childWidth;
            }
            DrawerLayout.this.setDrawerViewOffset(changedView, offset);
            changedView.setVisibility(offset == 0.0f ? 4 : 0);
            DrawerLayout.this.invalidate();
        }

        public void onViewCaptured(View capturedChild, int activePointerId) {
            LayoutParams lp = (LayoutParams)capturedChild.getLayoutParams();
            lp.isPeeking = false;
            this.closeOtherDrawer();
        }

        private void closeOtherDrawer() {
            int otherGrav = this.mGravity == 3 ? 5 : 3;
            View toClose = DrawerLayout.this.findDrawerWithGravity(otherGrav);
            if (toClose != null) {
                DrawerLayout.this.closeDrawer(toClose);
            }
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            int left;
            float offset = DrawerLayout.this.getDrawerViewOffset(releasedChild);
            int childWidth = releasedChild.getWidth();
            if (DrawerLayout.this.checkDrawerViewGravity(releasedChild, 3)) {
                left = xvel > 0.0f || xvel == 0.0f && offset > 0.5f ? 0 : -childWidth;
            } else {
                int width = DrawerLayout.this.getWidth();
                left = xvel < 0.0f || xvel == 0.0f && offset < 0.5f ? width - childWidth : width;
            }
            this.mDragger.settleCapturedViewAt(left, releasedChild.getTop());
            DrawerLayout.this.invalidate();
        }

        public void onEdgeTouched(int edgeFlags, int pointerId) {
            DrawerLayout.this.postDelayed(this.mPeekRunnable, 160L);
        }

        private void peekDrawer() {
            int childLeft;
            View toCapture;
            boolean leftEdge;
            int peekDistance = this.mDragger.getEdgeSize();
            boolean bl = leftEdge = this.mGravity == 3;
            if (leftEdge) {
                toCapture = DrawerLayout.this.findDrawerWithGravity(3);
                childLeft = (toCapture != null ? -toCapture.getWidth() : 0) + peekDistance;
            } else {
                toCapture = DrawerLayout.this.findDrawerWithGravity(5);
                childLeft = DrawerLayout.this.getWidth() - peekDistance;
            }
            if (toCapture != null && (leftEdge && toCapture.getLeft() < childLeft || !leftEdge && toCapture.getLeft() > childLeft) && DrawerLayout.this.getDrawerLockMode(toCapture) == 0) {
                LayoutParams lp = (LayoutParams)toCapture.getLayoutParams();
                this.mDragger.smoothSlideViewTo(toCapture, childLeft, toCapture.getTop());
                lp.isPeeking = true;
                DrawerLayout.this.invalidate();
                this.closeOtherDrawer();
                DrawerLayout.this.cancelChildViewTouch();
            }
        }

        public boolean onEdgeLock(int edgeFlags) {
            return false;
        }

        public void onEdgeDragStarted(int edgeFlags, int pointerId) {
            View toCapture = (edgeFlags & 1) == 1 ? DrawerLayout.this.findDrawerWithGravity(3) : DrawerLayout.this.findDrawerWithGravity(5);
            if (toCapture != null && DrawerLayout.this.getDrawerLockMode(toCapture) == 0) {
                this.mDragger.captureChildView(toCapture, pointerId);
            }
        }

        public int getViewHorizontalDragRange(View child) {
            return child.getWidth();
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            if (DrawerLayout.this.checkDrawerViewGravity(child, 3)) {
                return Math.max(-child.getWidth(), Math.min(left, 0));
            }
            int width = DrawerLayout.this.getWidth();
            return Math.max(width - child.getWidth(), Math.min(left, width));
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            return child.getTop();
        }
    }

    protected static class SavedState
    extends View.BaseSavedState {
        int openDrawerGravity = 0;
        int lockModeLeft = 0;
        int lockModeRight = 0;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel in) {
            super(in);
            this.openDrawerGravity = in.readInt();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.openDrawerGravity);
        }
    }

    public static abstract class SimpleDrawerListener
    implements DrawerListener {
        public void onDrawerSlide(View drawerView, float slideOffset) {
        }

        public void onDrawerOpened(View drawerView) {
        }

        public void onDrawerClosed(View drawerView) {
        }

        public void onDrawerStateChanged(int newState) {
        }
    }

    public static interface DrawerListener {
        public void onDrawerSlide(View var1, float var2);

        public void onDrawerOpened(View var1);

        public void onDrawerClosed(View var1);

        public void onDrawerStateChanged(int var1);
    }
}

