/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DetachedTest
extends TestCase {
    public DetachedTest(String string) {
        super(string);
    }

    public void test() {
        try {
            XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
            Reference reference = xMLSignatureFactory.newReference("http://www.w3.org/TR/xml-stylesheet", xMLSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
            keyPairGenerator.initialize(1024, new SecureRandom("not so random bytes".getBytes()));
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            KeyInfoFactory keyInfoFactory = xMLSignatureFactory.getKeyInfoFactory();
            KeyValue keyValue = keyInfoFactory.newKeyValue(keyPair.getPublic());
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyValue));
            SignedInfo signedInfo = xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null), Collections.singletonList(reference));
            XMLSignature xMLSignature = xMLSignatureFactory.newXMLSignature(signedInfo, keyInfo, null, null, null);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
            DOMSignContext dOMSignContext = new DOMSignContext(keyPair.getPrivate(), (Node)document);
            dOMSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            xMLSignature.sign(dOMSignContext);
            DOMValidateContext dOMValidateContext = new DOMValidateContext(keyPair.getPublic(), (Node)document.getDocumentElement());
            boolean bl = xMLSignature.validate(dOMValidateContext);
            if (!bl) {
                Iterator<Reference> iterator = xMLSignature.getSignedInfo().getReferences().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    Reference reference2 = iterator.next();
                    reference2.validate(dOMValidateContext);
                    ++n;
                }
                DetachedTest.fail((String)"Signature failed core validation");
            }
            xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
            bl = xMLSignature.validate(dOMValidateContext);
            DetachedTest.assertTrue((String)"Core validity of unmarshalled XMLSignature is false", (boolean)bl);
        }
        catch (Exception exception) {
            DetachedTest.fail((String)("Exception: " + exception));
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DetachedTest detachedTest = new DetachedTest("");
        detachedTest.test();
    }

    static {
        Security.insertProviderAt(new XMLDSigRI(), 1);
    }
}

