/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecSignatureConfirmation;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class SignatureConfirmationAction
implements Action {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$handler$WSHandler == null ? (class$org$apache$ws$security$handler$WSHandler = SignatureConfirmationAction.class$("org.apache.ws.security.handler.WSHandler")) : class$org$apache$ws$security$handler$WSHandler).getName());
    static /* synthetic */ Class class$org$apache$ws$security$handler$WSHandler;

    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Perform Signature confirmation");
        }
        Vector results = (Vector)handler.getProperty(reqData.getMsgContext(), "RECV_RESULTS");
        Vector signatureActions = new Vector();
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult wshResult = (WSHandlerResult)results.get(i);
            WSSecurityUtil.fetchAllActionResults(wshResult.getResults(), 2, signatureActions);
            WSSecurityUtil.fetchAllActionResults(wshResult.getResults(), 16, signatureActions);
            WSSecurityUtil.fetchAllActionResults(wshResult.getResults(), 64, signatureActions);
        }
        Vector signatureParts = reqData.getSignatureParts();
        WSSecSignatureConfirmation wsc = new WSSecSignatureConfirmation();
        if (signatureActions.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Signature Confirmation: number of Signature results: " + signatureActions.size()));
            }
            for (int i = 0; i < signatureActions.size(); ++i) {
                WSSecurityEngineResult wsr = (WSSecurityEngineResult)signatureActions.get(i);
                byte[] sigVal = (byte[])wsr.get("signature-value");
                wsc.build(doc, sigVal, reqData.getSecHeader());
                signatureParts.add(new WSEncryptionPart(wsc.getId()));
            }
        } else {
            wsc.build(doc, null, reqData.getSecHeader());
            signatureParts.add(new WSEncryptionPart(wsc.getId()));
        }
        handler.setProperty(reqData.getMsgContext(), "_sigConfDone_", WSHandler.DONE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

