# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ClusterScopeSettings(_serialization.Model):
    """Extension scope settings.

    :ivar allow_multiple_instances: Describes if multiple instances of the extension are allowed.
    :vartype allow_multiple_instances: bool
    :ivar default_release_namespace: Default extension release namespace.
    :vartype default_release_namespace: str
    """

    _attribute_map = {
        "allow_multiple_instances": {"key": "allowMultipleInstances", "type": "bool"},
        "default_release_namespace": {"key": "defaultReleaseNamespace", "type": "str"},
    }

    def __init__(
        self,
        *,
        allow_multiple_instances: Optional[bool] = None,
        default_release_namespace: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allow_multiple_instances: Describes if multiple instances of the extension are
         allowed.
        :paramtype allow_multiple_instances: bool
        :keyword default_release_namespace: Default extension release namespace.
        :paramtype default_release_namespace: str
        """
        super().__init__(**kwargs)
        self.allow_multiple_instances = allow_multiple_instances
        self.default_release_namespace = default_release_namespace


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details:
     list[~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ExtensionType(ProxyResource):
    """Represents an Extension Type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.SystemData
    :ivar release_trains: Extension release train: preview or stable.
    :vartype release_trains: list[str]
    :ivar cluster_types: Cluster types.
    :vartype cluster_types: list[str]
    :ivar supported_scopes: Extension scopes.
    :vartype supported_scopes:
     ~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.SupportedScopes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "release_trains": {"readonly": True},
        "cluster_types": {"readonly": True},
        "supported_scopes": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "release_trains": {"key": "properties.releaseTrains", "type": "[str]"},
        "cluster_types": {"key": "properties.clusterTypes", "type": "[str]"},
        "supported_scopes": {"key": "properties.supportedScopes", "type": "SupportedScopes"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.system_data = None
        self.release_trains = None
        self.cluster_types = None
        self.supported_scopes = None


class ExtensionTypeList(_serialization.Model):
    """List Extension Types.

    :ivar value: The list of Extension Types.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.ExtensionType]
    :ivar next_link: The link to fetch the next page of Extension Types.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExtensionType]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ExtensionType"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of Extension Types.
        :paramtype value:
         list[~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.ExtensionType]
        :keyword next_link: The link to fetch the next page of Extension Types.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExtensionVersionList(_serialization.Model):
    """List versions for an Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Versions available for this Extension Type.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.ExtensionVersionListValueItem]
    :ivar next_link: The link to fetch the next page of Extension Types.
    :vartype next_link: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.SystemData
    """

    _validation = {
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExtensionVersionListValueItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExtensionVersionListValueItem"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Versions available for this Extension Type.
        :paramtype value:
         list[~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.ExtensionVersionListValueItem]
        :keyword next_link: The link to fetch the next page of Extension Types.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
        self.system_data = None


class ExtensionVersionListValueItem(_serialization.Model):
    """ExtensionVersionListValueItem.

    :ivar release_train: The release train for this Extension Type.
    :vartype release_train: str
    :ivar versions: Versions available for this Extension Type and release train.
    :vartype versions: list[str]
    """

    _attribute_map = {
        "release_train": {"key": "releaseTrain", "type": "str"},
        "versions": {"key": "versions", "type": "[str]"},
    }

    def __init__(
        self, *, release_train: Optional[str] = None, versions: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword release_train: The release train for this Extension Type.
        :paramtype release_train: str
        :keyword versions: Versions available for this Extension Type and release train.
        :paramtype versions: list[str]
        """
        super().__init__(**kwargs)
        self.release_train = release_train
        self.versions = versions


class SupportedScopes(_serialization.Model):
    """Extension scopes.

    :ivar default_scope: Default extension scopes: cluster or namespace.
    :vartype default_scope: str
    :ivar cluster_scope_settings: Scope settings.
    :vartype cluster_scope_settings:
     ~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.ClusterScopeSettings
    """

    _attribute_map = {
        "default_scope": {"key": "defaultScope", "type": "str"},
        "cluster_scope_settings": {"key": "clusterScopeSettings", "type": "ClusterScopeSettings"},
    }

    def __init__(
        self,
        *,
        default_scope: Optional[str] = None,
        cluster_scope_settings: Optional["_models.ClusterScopeSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default_scope: Default extension scopes: cluster or namespace.
        :paramtype default_scope: str
        :keyword cluster_scope_settings: Scope settings.
        :paramtype cluster_scope_settings:
         ~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.ClusterScopeSettings
        """
        super().__init__(**kwargs)
        self.default_scope = default_scope
        self.cluster_scope_settings = cluster_scope_settings


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2022_01_15_preview.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
