# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class DataAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported permissions for data actions."""

    READ_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/read/action"
    """Read HSM key metadata."""
    WRITE_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/write/action"
    """Update an HSM key."""
    READ_DELETED_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/deletedKeys/read/action"
    """Read deleted HSM key."""
    RECOVER_DELETED_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/deletedKeys/recover/action"
    """Recover deleted HSM key."""
    BACKUP_HSM_KEYS = "Microsoft.KeyVault/managedHsm/keys/backup/action"
    """Backup HSM keys."""
    RESTORE_HSM_KEYS = "Microsoft.KeyVault/managedHsm/keys/restore/action"
    """Restore HSM keys."""
    DELETE_ROLE_ASSIGNMENT = "Microsoft.KeyVault/managedHsm/roleAssignments/delete/action"
    """Delete role assignment."""
    GET_ROLE_ASSIGNMENT = "Microsoft.KeyVault/managedHsm/roleAssignments/read/action"
    """Get role assignment."""
    WRITE_ROLE_ASSIGNMENT = "Microsoft.KeyVault/managedHsm/roleAssignments/write/action"
    """Create or update role assignment."""
    READ_ROLE_DEFINITION = "Microsoft.KeyVault/managedHsm/roleDefinitions/read/action"
    """Get role definition."""
    WRITE_ROLE_DEFINITION = "Microsoft.KeyVault/managedHsm/roleDefinitions/write/action"
    """Create or update role definition."""
    DELETE_ROLE_DEFINITION = "Microsoft.KeyVault/managedHsm/roleDefinitions/delete/action"
    """Delete role definition."""
    ENCRYPT_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/encrypt/action"
    """Encrypt using an HSM key."""
    DECRYPT_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/decrypt/action"
    """Decrypt using an HSM key."""
    WRAP_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/wrap/action"
    """Wrap using an HSM key."""
    UNWRAP_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/unwrap/action"
    """Unwrap using an HSM key."""
    SIGN_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/sign/action"
    """Sign using an HSM key."""
    VERIFY_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/verify/action"
    """Verify using an HSM key."""
    CREATE_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/create"
    """Create an HSM key."""
    DELETE_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/delete"
    """Delete an HSM key."""
    EXPORT_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/export/action"
    """Export an HSM key."""
    IMPORT_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/import/action"
    """Import an HSM key."""
    PURGE_DELETED_HSM_KEY = "Microsoft.KeyVault/managedHsm/keys/deletedKeys/delete"
    """Purge a deleted HSM key."""
    DOWNLOAD_HSM_SECURITY_DOMAIN = "Microsoft.KeyVault/managedHsm/securitydomain/download/action"
    """Download an HSM security domain."""
    UPLOAD_HSM_SECURITY_DOMAIN = "Microsoft.KeyVault/managedHsm/securitydomain/upload/action"
    """Upload an HSM security domain."""
    READ_HSM_SECURITY_DOMAIN_STATUS = "Microsoft.KeyVault/managedHsm/securitydomain/upload/read"
    """Check the status of the HSM security domain exchange file."""
    READ_HSM_SECURITY_DOMAIN_TRANSFER_KEY = "Microsoft.KeyVault/managedHsm/securitydomain/transferkey/read"
    """Download an HSM security domain transfer key."""
    START_HSM_BACKUP = "Microsoft.KeyVault/managedHsm/backup/start/action"
    """Start an HSM backup."""
    START_HSM_RESTORE = "Microsoft.KeyVault/managedHsm/restore/start/action"
    """Start an HSM restore."""
    READ_HSM_BACKUP_STATUS = "Microsoft.KeyVault/managedHsm/backup/status/action"
    """Read an HSM backup status."""
    READ_HSM_RESTORE_STATUS = "Microsoft.KeyVault/managedHsm/restore/status/action"
    """Read an HSM restore status."""


class RoleDefinitionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The role definition type."""

    MICROSOFT_AUTHORIZATION_ROLE_DEFINITIONS = "Microsoft.Authorization/roleDefinitions"


class RoleScope(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The role scope."""

    GLOBAL = "/"
    """Global scope"""
    KEYS = "/keys"
    """Keys scope"""


class RoleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The role type."""

    BUILT_IN_ROLE = "AKVBuiltInRole"
    """Built in role."""
    CUSTOM_ROLE = "CustomRole"
    """Custom role."""
