--TEST--
igbinary and large Serializable
--INI--
; Note that php 8.1 deprecates using Serializable without __serialize/__unserialize but we are testing Serialize for igbinary. Suppress deprecations.
error_reporting=E_ALL & ~E_DEPRECATED
--FILE--
<?php
class Test implements Serializable {
    public $prop;
    public function serialize() {
        return $this->prop;
    }
    public function unserialize($s) {
        $this->prop = $s;
    }
}
function var_export_normalized($value) {
    echo ltrim(var_export($value, true), "\\");
}
$t = new Test();
$t->prop = str_repeat('0', 256);
var_export_normalized(bin2hex($s = igbinary_serialize($t)));
echo "\n";
var_export_normalized(igbinary_unserialize($s));
echo "\n";
$t->prop = str_repeat('0', 1 << 16);
$t2 = igbinary_unserialize(igbinary_serialize($t));
var_dump($t2->prop === $t->prop);
?>
--EXPECT--
'000000021704546573741e010030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030303030'
Test::__set_state(array(
   'prop' => '0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
))
bool(true)
