# -*- coding: utf-8 -*-

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

import os.path

readme = ''
here = os.path.abspath(os.path.dirname(__file__))
readme_path = os.path.join(here, 'README.rst')
if os.path.exists(readme_path):
    with open(readme_path, 'rb') as stream:
        readme = stream.read().decode('utf8')

setup(
    long_description=readme,
    name='pendulum',
    version='2.1.2',
    description='Python datetimes made easy',
    python_requires='!=3.0.*,!=3.1.*,!=3.2.*,!=3.3.*,!=3.4.*,<4.0,>=2.7',
    project_urls={
        "documentation": "https://pendulum.eustace.io/docs",
        "homepage": "https://pendulum.eustace.io",
        "repository": "https://github.com/sdispater/pendulum"
    },
    author='Sébastien Eustace',
    author_email='sebastien@eustace.io',
    license='MIT',
    keywords='datetime date time',
    packages=[
        'pendulum', 'pendulum._extensions', 'pendulum.formatting',
        'pendulum.locales', 'pendulum.locales.da', 'pendulum.locales.de',
        'pendulum.locales.en', 'pendulum.locales.es', 'pendulum.locales.fa',
        'pendulum.locales.fo', 'pendulum.locales.fr', 'pendulum.locales.id',
        'pendulum.locales.it', 'pendulum.locales.ko', 'pendulum.locales.lt',
        'pendulum.locales.nb', 'pendulum.locales.nl', 'pendulum.locales.nn',
        'pendulum.locales.pl', 'pendulum.locales.pt_br', 'pendulum.locales.ru',
        'pendulum.locales.zh', 'pendulum.mixins', 'pendulum.parsing',
        'pendulum.parsing.exceptions', 'pendulum.tz', 'pendulum.tz.data',
        'pendulum.tz.zoneinfo', 'pendulum.utils'
    ],
    package_dir={"": "."},
    package_data={
        "pendulum": ["*.typed"],
        "pendulum._extensions": ["*.c"],
        "pendulum.parsing": ["*.c"]
    },
    install_requires=[
        'python-dateutil==2.*,>=2.6.0', 'pytzdata>=2020.1',
        'typing==3.*,>=3.6.0; python_version < "3.5"'
    ],
    extras_require={
        "dev": [
            "babel==2.*,>=2.5.0", "black==19.*,>=19.3.0.b0",
            "cleo==0.*,>=0.8.1", "freezegun==0.*,>=0.3.15",
            "isort==4.*,>=4.3.21", "markdown-include==0.*,>=0.5.1",
            "mkdocs==1.*,>=1.0.0; python_version == \"3.*\" and python_version >= \"3.5.0\"",
            "pre-commit==1.*,>=1.10.0", "pygments==2.*,>=2.2.0",
            "pymdown-extensions==6.*,>=6.0.0", "pytest==4.*,>=4.6.0",
            "pytest-cov==2.*,>=2.5.0", "pytz>=2018.3", "tox==3.*,>=3.0.0"
        ]
    },
)
