/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceCopier;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.query.SequenceWrapper;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;

public class QueryResult {
    public static String RESULT_NS = "http://saxon.sf.net/xquery-results";

    private QueryResult() {
    }

    public static String serialize(NodeInfo nodeInfo) throws XPathException {
        StringWriter sw = new StringWriter();
        Properties props = new Properties();
        props.setProperty("method", "xml");
        props.setProperty("indent", "yes");
        props.setProperty("omit-xml-declaration", "yes");
        QueryResult.serialize(nodeInfo, new StreamResult(sw), props);
        return sw.toString();
    }

    public static DocumentInfo wrap(SequenceIterator iterator, Configuration config) throws XPathException {
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        TinyBuilder builder = new TinyBuilder();
        builder.setPipelineConfiguration(pipe);
        NamespaceReducer reducer = new NamespaceReducer();
        reducer.setUnderlyingReceiver(builder);
        reducer.setPipelineConfiguration(pipe);
        ComplexContentOutputter outputter = new ComplexContentOutputter();
        outputter.setPipelineConfiguration(pipe);
        outputter.setReceiver(reducer);
        QueryResult.sendWrappedSequence(iterator, outputter);
        return (DocumentInfo)builder.getCurrentRoot();
    }

    public static void sendWrappedSequence(SequenceIterator iterator, Receiver destination) throws XPathException {
        SequenceCopier.copySequence(iterator, new SequenceWrapper(destination));
    }

    public static void serialize(NodeInfo node, Result destination, Properties outputProperties, Configuration config) throws XPathException {
        QueryResult.serialize(node, destination, outputProperties);
    }

    public static void serialize(NodeInfo node, Result destination, Properties outputProperties) throws XPathException {
        Configuration config = node.getConfiguration();
        QueryResult.serializeSequence((SequenceIterator)SingletonIterator.makeIterator(node), config, destination, outputProperties);
    }

    public static void serializeSequence(SequenceIterator iterator, Configuration config, OutputStream destination, Properties outputProps) throws XPathException {
        QueryResult.serializeSequence(iterator, config, new StreamResult(destination), outputProps);
        try {
            destination.flush();
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    public static void serializeSequence(SequenceIterator iterator, Configuration config, Writer writer, Properties outputProps) throws XPathException {
        QueryResult.serializeSequence(iterator, config, new StreamResult(writer), outputProps);
        try {
            writer.flush();
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    public static void serializeSequence(SequenceIterator iterator, Configuration config, Result result, Properties outputProperties) throws XPathException {
        Item item;
        SerializerFactory sf = config.getSerializerFactory();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        Receiver receiver = sf.getReceiver(result, pipe, outputProperties);
        TreeReceiver tr = new TreeReceiver(receiver);
        tr.open();
        while ((item = iterator.next()) != null) {
            tr.append(item, 0, 2);
        }
        tr.close();
    }
}

