#!/bin/sh
# Copyright (c)  2012 libchewing Core Team. See ChangeLog for details.

# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:

# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

echo -n "Find lcov.........."
if ! which lcov; then
    echo "not found";
    exit 1;
fi

echo -n "Find genhtml......."
if ! which genhtml; then
    echo "not found";
    exit 1;
fi

echo -n "Check directory...."
if [ ! -e "src" ]; then
    echo "not found";
    exit 1;
fi
echo "ok"

ABSPATH=$(cd "$(dirname "$0")/.."; pwd)
lcov --directory $PWD --capture --output-file coverage.info --no-checksum --compat-libtool
lcov --remove coverage.info "/usr/include/*" --output-file coverage.info
LANG=C genhtml --prefix $ABSPATH --output-directory coveragereport \
    --title "Code Coverage" --legend --show-details coverage.info
