/*
 * Copyright (C) 1999-2001, 2004, 2005, 2007, 2016  Internet Systems Consortium, Inc. ("ISC")
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/*
 * Principal Author: Brian Wellington
 * $Id: dst_lib.c,v 1.5 2007/06/19 23:47:16 tbox Exp $
 */

/*! \file */

#include <config.h>

#include <stddef.h>

#include <isc/once.h>
#include <isc/msgcat.h>
#include <isc/util.h>

#include <dst/lib.h>

/***
 *** Globals
 ***/

LIBDNS_EXTERNAL_DATA isc_msgcat_t *		dst_msgcat = NULL;


/***
 *** Private
 ***/

static isc_once_t		msgcat_once = ISC_ONCE_INIT;


/***
 *** Functions
 ***/

static void
open_msgcat(void) {
	isc_msgcat_open("libdst.cat", &dst_msgcat);
}

void
dst_lib_initmsgcat(void) {

	/*
	 * Initialize the DST library's message catalog, dst_msgcat, if it
	 * has not already been initialized.
	 */

	RUNTIME_CHECK(isc_once_do(&msgcat_once, open_msgcat) == ISC_R_SUCCESS);
}
