/* Xymon Client V1.2 for VSE/ESA and z/VSE
    Copyright (C) 2003-2010 Richard Smrcina
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.
 
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    See the GNU General Public License for more details.
 
    http://www.gnu.org/licenses/old-licenses/gpl-2.0.html            */
/*  This program will read the disk test data collected by the Xymon
    disk test batch utility and report it to the Xymon server.
 
    Rich Smrcina: Original V1.0 release 09/17/2005
   V1.2 - Added cfgmode parameter to designate the configuration mode
          Changed disk utilization test to combine the spool test with
          the rest of the disk information.  Also the disk test results
          are displayed or sent to Hobbit in the form of a Linux df
          display, so that the Hobbit disk processing back end can
          graph the results.
          Changed client architecture to use Hobbit server based
          configuration for most VSE tests (getvis is the exception).
          Server mode writes the test results to librarian members which
          are sent to Hobbit via the client data channel.
          To fit in better with the new architecture, required the
          VSAM specification in HOBVARS to specify the fileid of the
          VSAM catalog.
          Server based configuration will require the Hobbit back-end
          code which should be available with Hobbit 4.3. 02/01/2007
 
          Changed project name to Xymon                   02/10/2009
                                                                      */
arg lib cfgmode .
init='0'             /*  Init flag  */
cr='0a'x             /*  Carriage return   */
call ASSGN 'STDOUT','SYSLST'
/*  Retrieve options member from PRD2.CONFIG                     */
'execio * diskr 'lib'.hobvars.z (stem hobvars. finis'
/*  Init local variables first  */
bbdisplay=''
bbport=''
domainname=''
hostname=''
/*  Go through options table to fill values to run the client    */
do i=1 to hobvars.0
  if left(hobvars.i,1)='#' then iterate   /* Ignore comment */
  parse var hobvars.i kw value
  value=strip(value,'B')
  select
    when kw='bbdisplay' then
      bbdisplay=value
    when kw='bbport' then
      bbport=value
    when kw='domainname' then
      domainname=value
    when kw='hostname' then
      hostname=value
    when kw='DISK' then do
      parse var value kw2 '=' val1 val2 .
      if kw2='DEF' then do
        disk.yellow=val1
        disk.red=val2
        end
      end
    when kw='SPOOL' then
      parse var value splyel splred .
    otherwise
      nop
    end
  end
t=1                             /* Index into test results stem */
call do_sputil
call do_disktest
if cfgmode='CLIENT' then do
  call init_open_socket         /* Initialize and Open the socket  */
  call send_client_data
  call send_to_bb
  call close_term_socket
  end
else
  call write_server_data
return
 
do_disktest:
prevtype=' '  /* Volume header flag  */
/*  Retrieve disk test results from PRD2.CONFIG      */
'execio * diskr 'lib'.hobdskrs.z (stem hobres. finis'
if hobres.0=0 then do
  say 'HOBDSKRS.Z - Member not found.'
  return
  end
do q=1 to hobres.0
  parse var hobres.q type rest
  select
    when type='C' then do   /*  Catalog record */
      parse var rest yelpct redpct fileid catname devtyp err .
      if err=1 then do
        test.t='Error processing 'catname'.' cr
        t=t+1
        end
      spacenum=1
      end
    when type='VV' then do  /*  VSAM Volume record */
      parse var rest volid capacity used numds extstart pct ucat .
      if ucat=1 then
        iterate
      capacity=right(capacity,9)
      used=right(used,9)
      numds=right(numds,6)
      extstart=right(extstart,8)
      pct=right(pct,6)
      fs='/VSM/'fileid'/'volid'/'spacenum
      mount=fs
      if volid=ovsamvolid then
        spacenum=spacenum+1
      if devtyp='FBA' then do
        kcap=(capacity * 2)
        kusd=(used     * 2)
        end
      else do
        kcap=((capacity/15) * 180) * 4
        kusd=((used/15) * 180) * 4
        end
      free=kcap-kusd
      pctused=(kusd / kcap) * 100
      out=left(fs,23) format(kcap,8,0) format(kusd,8,0) ,
          format(free,8,0) format(pctused,3,1)'%' left(mount,23) cr
      test.t=yelpct redpct out
      t=t+1
      ovsamvolid=volid
      end
    when type='V' then do   /*  Volume record */
      parse var rest yelpct redpct volid devnum devtyp capacity used ,
            pct .
      capacity=right(capacity,9)
      used=right(used,9)
      pct=right(pct,6)
      fs='/VOL/'volid
      mount=fs
      if devtyp='9336' then do
        kcap=(capacity * 2)
        kusd=(used     * 2)
        end
      else do
        kcap=((capacity/15) * 180) * 4
        kusd=((used/15) * 180) * 4
        end
      free=kcap - kusd
      pctused=(kusd / kcap) * 100
      out=left(fs,23) format(kcap,8,0) format(kusd,8,0) ,
          format(free,8,0)  format(pctused,3,1)'%' left(mount,23) cr
      test.t=yelpct redpct out
      t=t+1
      end
    when type='L' then do   /*  Library record */
      parse var rest yelpct redpct libname numsl total used delay pct .
      kcap=right(total,9)
      kusd=right(used,9)
      pct=right(pct,6)
      fs='/VSELIB/'libname
      mount=fs
      free=kcap - kusd
      pctused=(kusd / kcap) * 100
      out=left(fs,23) format(kcap,8,0) format(kusd,8,0) ,
          format(free,8,0) format(pctused,3,1)'%' left(mount,23) cr
      test.t=yelpct redpct out
      t=t+1
      end
    otherwise
      nop
    end
  prevtype=type
  end
test.0=t-1
return
 
/*  Spool utilization is integrated into the disk test           */
do_sputil:
call outtrap power.
ADDRESS POWER 'D Q'                     /* POWER command      */
do i=1 to power.0
  parse var power.i . first second pct fourth fifth sixth .
  if first = 'QUEUE' & second = 'FILE' & fourth = 'FULL' then do
    parse var pct qpctval '%'
    qfree=sixth
    end
  if first = 'USED' & second = 'QUEUE' then
    parse var fourth qused',' .
  if first = 'DATA'  & second = 'FILE' & fourth = 'FULL' then do
    parse var pct dpctval '%'
    dfree=sixth
    end
  end
qtot=qfree+qused
out=left('/POWER/QFILE',23) format(qtot,8,0) format(qused,8,0) ,
  format(qfree,8,0) format(qpctval,3,1)'% 'left('/POWER/QFILE',23) ,
  cr
test.t=splyel splred out
t=t+1
out=left('/POWER/DFILE',23) format(0,8,0) format(0,8,0) ,
  format(dfree,8,0) format(dpctval,3,1)'% 'left('/POWER/DFILE',23) ,
  cr
test.t=splyel splred out
t=t+1
return
 
write_server_data:
queue '[df]'
queue left('Filesystem',23) '  kbytes     used    avail' ,
      '   cap Mounted as'
do i=1 to test.0
  parse var test.i yelpct redpct rest
  queue rest
  end
queue ''
'execio * diskw 'lib'.hobvsedu.data (finis'
return
 
send_client_data:
res=''
max_color='green'      /*  Maximum color for all pools and spaces  */
do i=1 to test.0
  mycolor  ='green'
  parse var test.i yelpct redpct rest
  parse var rest mntpnt . . . pct'%' .
  if pct > yelpct then do
    mycolor = 'yellow'
    call COLOR_SET mycolor
    end
  if pct > redpct then do
    mycolor = 'red'
    call COLOR_SET mycolor
    end
  if mycolor ^= 'green' then do
/* Format the non-green text as follows:                             */
/* &yellow /mntpnt (94% used) has reached the WARNING level (90%)    */
    msg = '&'mycolor mntpnt '('format(pct,3,1)'%) has reached the'
    if mycolor = 'yellow' then
      msg = msg 'WARNING level ('yelpct'%)'
    if mycolor = 'red'    then
      msg = msg 'ALERT level ('redpct'%)'
    res=res|| msg cr
    end
  if left(mntpnt,5)='Error' then do
    mycolor = 'red'
    call COLOR_SET mycolor
    end
  end
res=res||left('Filesystem',23) '  kbytes     used    avail'             ,
    '   cap Mounted as' cr
do i=1 to test.0
  parse var test.i yelpct redpct rest
  res=res||rest
  end
if max_color='green' then
  status3='Disk status is OK.'
else
  status3='Disk status is not OK.'
status='status' fqdn'.disk' max_color date() time() status3 cr
status2=res
return
 
color_set:
parse arg col
select
  when max_color='green' then
    if col='yellow' | col='red' then
      max_color=col
  when max_color='yellow' then
    if col='red' then
      max_color=col
  otherwise
    nop
  end
return
 
send_to_bb:
status=toascii(status)
ret=Socket('Send',sid,status)
parse var ret rc .
if rc<>0 then
  say 'Send:' ret
if length(status2) > 0 then do
  status2=toascii(status2)
  ret=Socket('Send',sid,status2)
  parse var ret rc .
  if rc<>0 then
    say 'Send:' ret
  end
return
 
toascii:
parse arg buffer
buffer=translate(buffer,asc,ebc)
return buffer
 
init_open_socket:
ret=socket('Initialize','hobbvse')
parse var ret rc .
if rc<>0 then
  say 'Initialize:' ret
ret=socket('Socket','AF_INET','Sock_Stream',0)
parse var ret rc .
if rc<>0 then
  say 'Socket:' ret
parse var ret rc sid .
if init='0' then do
  init='1'
  call init_values
  end
name='AF_INET' bbport bbdisplay
ret=socket('Connect',sid,name)
parse var ret rc .
if rc<>0 then
  say 'Connect:' ret
return
 
close_term_socket:
ret=Socket('Close',sid)
parse var ret rc .
if rc<>0 then
  say 'Close:' ret
ret=Socket('Terminate')
parse var ret rc .
if rc<>0 then
  say 'Terminate:' ret
return
 
init_values:
ebc=' !"#$%&'||'7D'X||'()*+,-./012' ,
    '3456789:;<=>?@ABCDE' ,
    'FGHIJKLMNOPQRSTUVWX' ,
    'YZ
\Y_`abcdefghijk' ,
    'lmnopqrstuvwxyz{|}~'
asc='202122232425262728292A2B2C2D2E2F303132'x ,
    '333435363738393A3B3C3D3E3F404142434445'x ,
    '464748494A4B4C4D4E4F505152535455565758'x ,
    '595A5B5C5D5E5F606162636465666768696A6B'x ,
    '6C6D6E6F707172737475767778797A7B7C7D7E'x
if hostname='' then do
  ret=socket('Gethostname')
  parse var ret rc hostname .
  if rc<>0 then
    say 'Gethostname:' ret
  hostname=lower(hostname)
  end
if domainname='' then
  fqdn=hostname
else
  fqdn=hostname||'.'||domainname
/*  Change periods to commas  */
fqdn=translate(fqdn,',','.')
return
 
/*  Convert parameter to lower case.  */
lower:
arg string
lc_chars='abcdefghijklmnopqrstuvwxyz'
uc_chars='ABCDEFGHIJKLMNOPQRSTUVWXYZ'
string=translate(string,lc_chars,uc_chars)
return string
