#!/usr/bin/env python
# -*- coding: utf-8 -*- #
'''Watchvideo'''

###
#
# WatchVideo is the legal property of Leonardo Gastón De Luca
# leo[at]kde.org.ar Copyright (c) 2009 Leonardo Gastón De Luca
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.

# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
###

from optparse import OptionParser
from watchvideo.main import Match, download, play
import watchvideo.constants as c
import sys
import getmediumurl

def run():
    '''Main function'''
    try:
        parser = OptionParser(usage="usage: %prog [options] URL", \
        version=c.VERSION)
        parser.add_option("-d", "--download",
                        action="store_true",
                        dest="down",
                        default=False,
                        help="download the video")
        parser.add_option("-L", "--list-plugins",
                          action="store_true",
                          dest="list_plugins",
                          default=False,
                          help="list plugins used and exit")
        (options, args) = parser.parse_args()

        if options.list_plugins:
            matcher = getmediumurl.Matcher()
            print "Installed plugins:"
            print ", ".join(plugin
                            for plugin in matcher.plugins.iterkeys())
            print
            print "Disabled plugins:"
            for plugin, reasons in matcher.disabled.iteritems():
                print plugin
                print "\n".join("\t" + reason for reason in reasons)
        elif len(args) != 1:
            parser.error("wrong number of arguments.")
        else:
            valid_videos = Match([args[0].strip()], cli=True).match()
            
            if not valid_videos:
                print "No valid links found."
            
            for video in valid_videos:
                if options.down:
                    download(video.dl_url, video.name)
                else:
                    play(video.dl_url, video.name)
                    
    except KeyboardInterrupt:
        print '\r'
        sys.exit()
