#!/usr/bin/env python
# -*- coding: utf-8 -*- #
from PyQt4 import QtCore, QtGui
from PyQt4.QtGui import QSlider

class Slider(QSlider):
    def __init__(self, orientation, parent = None):
        QSlider.__init__(self, orientation, parent)
        self.setPageStep(1)
        self.paused = False
        self.setEnabled(False)
        self.max = 0
        self.value_when_pressed = 0
        
        QtCore.QObject.connect(self, QtCore.SIGNAL("sliderPressed()"), self.on_slider_press)
        QtCore.QObject.connect(self, QtCore.SIGNAL("sliderReleased()"), self.on_slider_release)
        
    def add_player(self, player):
        self.player = player
        
    def pause(self):
        self.paused = not self.paused
        
    def reset(self):
        if self.timer_update_slider:
            self.timer_update_slider.stop()
        self.setValue(0)
        
    def loadfile(self, filepath):
        self.setEnabled(True)
        self.filepath = filepath
        
        self.timer_update_slider = QtCore.QTimer()
        QtCore.QObject.connect(self.timer_update_slider, QtCore.SIGNAL("timeout()"), self.update_slider)
        self.timer_update_slider.start(1000)
        
    def on_slider_press(self):
        self.value_when_pressed = self.value()
    
    def on_slider_release(self):
        if self.value() < self.max-5:
            self.player.time_pos = self.value()
        else:
			self.setValue(self.value_when_pressed)
    
    def update_slider(self):
        if self.paused: return
        
        if self.player.time_pos is not None:
            self.setValue(self.player.time_pos)
    
