#!/usr/bin/env python
# -*- coding: utf-8 -*- #

from PyQt4 import QtCore, QtGui
from slider import Slider
from PyQt4.QtCore import Qt
from PyQt4.QtGui import QProgressBar, QWidget
from mplayer.qt4 import QPlayerView
import os
import tempfile
from threads import DownloadItem
#from threading import Timer
from subprocess import Popen, PIPE, STDOUT
import constants as c

class Player(object):
    def __init__(self, parent):
        self.parent = parent
        self.slider = Slider(Qt.Horizontal, parent)
        self.player = QPlayerView(parent.ui.videoWidget)
        self.player.completed.connect(self.completed)
        self.player.resize(self.parent.width(), self.parent.ui.videoWidget.height())
        self.slider.add_player(self.player._mplayer)
        self.progressbar = QProgressBar(parent)
        self.paused = False
        self.download = None
        self.timer_load_file = None
        self.playing = False
        self.check_playback_timer = None
        self.timer_update_progressbar = None
        self.timer_load_file = None
        self.resetted = False
        
    def __del__(self):
        self.player.deleteLater()
        self.slider.deleteLater()
        self.progressbar.deleteLater()
    
    def play(self):
        if self.download.completed:
            self.player.loadfile('"' + self.filepath + '"')
            self.slider.loadfile(self.filepath)
            self.playing = True
            self.parent.ui.stackedWidget.setCurrentIndex(1) #set pause button
        else:
            self.pause()
        
    def pause(self):
        self.player.pause()
        self.slider.pause()
        self.paused = not self.paused
        index = self.parent.ui.stackedWidget.currentIndex()
        #0*(-1)+1 = 1; 1*(-1) +1 = 0
        self.parent.ui.stackedWidget.setCurrentIndex(index*-1+1)
        
    def completed(self):
        self.slider.reset()
        self.playing = False
        
        if self.download.completed:
            self.parent.ui.videoWidget.setStyleSheet("background-color: rgb(0, 0, 0);")
            self.parent.ui.stackedWidget.setCurrentIndex(0) #show play button
        else:
            print "reloading file...."
            self.player.loadfile('"' + self.filepath + '"')
            self.slider.loadfile(self.filepath)
    
    def reset(self):
        self.resetted = True
        if self.download:
            if not self.download.completed:
                self.download.stop = True
                self.download = None
                
                if self.timer_load_file: 
                    self.timer_load_file.stop()
                    self.timer_load_file = None
                
                if self.timer_update_progressbar: 
                    self.timer_update_progressbar.stop()
                    self.timer_update_progressbar = None
                    
                if self.check_playback_timer: 
                    self.check_playback_timer.stop()
                    self.check_playback_timer = None

            if self.playing: #could be playing from complete or incomplete file
                self.player.stop()
                
            self.slider.reset()
            self.playing = False
            
        
    def loadfile(self, filepath, download):
        
        self.player.resize(self.parent.width(), self.parent.ui.videoWidget.height())
        
        self.reset() #reset everything
        
        self.filepath = tempfile.gettempdir() + "/" + os.path.split(filepath)[1]
        self.download = download
        self.download.dest_file = self.filepath
        self.download.start()
        
        self.bitrate = None
        self.max_duration = None
        self.curr_max_duration = None
        self.wait_time = 2 #wait counter to give time for the video to download
        
        #only start playing the file after some bytes are downloaded
        self.timer_load_file = QtCore.QTimer()
        QtCore.QObject.connect(self.timer_load_file, QtCore.SIGNAL("timeout()"), self._load_file)
        self.timer_load_file.start(1000)
        
    def _load_file(self):
        if not os.path.exists(self.filepath): return
        
        filesize = os.path.getsize(self.filepath)
        
        if filesize < 4096: return #4096 bytes minimum (random) to check for info in the file

        if self.timer_update_progressbar is None:
            self.timer_update_progressbar = QtCore.QTimer()
            QtCore.QObject.connect(self.timer_update_progressbar, QtCore.SIGNAL("timeout()"), self.update_progressbar)
            self.timer_update_progressbar.start(1000)
        
        if not self.max_duration or not self.bitrate:
            self.max_duration = self.get_duration(self.filepath)
            self.bitrate = self.get_bitrate(self.filepath)
            print self.max_duration
            return
        elif (self.calc_current_max_time() / float(self.max_duration)) * 100 < 10:
            #load at least 10% of the video before start playing
            return
            
        self.timer_load_file.stop()
        self.timer_load_file = None
        
        #load file
        self.player.loadfile('"' + self.filepath + '"')
        self.slider.loadfile(self.filepath)
        self.slider.setMaximum(self.max_duration)
        
        self.playing = True
        #update buttons' state
        self.parent.ui.btn_pause.setEnabled(True)
        self.parent.ui.stackedWidget.setCurrentIndex(1)
        
        self.check_playback_timer = QtCore.QTimer()
        QtCore.QObject.connect(self.check_playback_timer, QtCore.SIGNAL("timeout()"), self.check_playback)
        self.check_playback_timer.start(1000)
        
    def calc_current_max_time(self):       
        filesize = os.path.getsize(self.filepath)
        max = filesize // self.bitrate
        return max
        
    def check_playback(self):
        if self.paused: return
        
        self.slider.max = max = self.calc_current_max_time()
                
        if self.download.completed:
            self.check_playback_timer.stop()
            self.check_playback_timer = None
            return
        
        if self.player.time_pos > max - 10:
            self.pause()
            Timer(self.wait_time, self.pause).start()
            self.wait_time += 1
            
            
    def update_progressbar(self):
        self.progressbar.setMaximum(self.download.size_kib)
        self.progressbar.setValue(self.download.downloaded)
        
        if self.download.completed:
            #hack to set the progressbar at 100%
            self.progressbar.setValue(self.download.size_kib)
            #stop checking, it's done!
            self.timer_update_progressbar.stop()
            self.timer_update_progressbar = None
            
    def get_duration(self, filepath):
        if not c.HAS_MEDIAINFO:
            print "You need MediaInfo! Install it by doing 'make install-mediainfo'"
            self.reset()
            return
        
        process = Popen(("mediainfo", "-f", str(filepath)),stdout=PIPE,
                stdin=PIPE,stderr=STDOUT)

        output = process.communicate()[0]
        duration = 0
        
        for line in output.splitlines():
            if "Duration" in line and "s" in line:
                conversion = 3600
                line = line.split(':')[1]
                for unit in ["h", "mn", "s"]:
                    if unit in line:
                        duration += int(line.split(unit)[0]) * conversion
                        line = line.split(unit)[1].strip()
                    conversion /= 60 
                break

        return duration
        
    def get_bitrate(self, filepath):
        
        if not c.HAS_MEDIAINFO:
            print "You need MediaInfo! Install it by doing 'make install-mediainfo'"
            self.reset()
            return
        
        process = Popen(("mediainfo", "-f", str(filepath)),stdout=PIPE,
                stdin=PIPE,stderr=STDOUT)

        output = process.communicate()[0]
        overall_bitrate = 0
        video_bitrate = 0
        bitrate = 0
        
        for line in output.splitlines():
            if "Overall bit rate" in line and not "bps" in line:
                #bitrate = float(line.split(":")[1].split("Kbps")[0])
                overall_bitrate = int(line.split(":")[1])
            
            if "Bit rate" in line:
                video_bitrate = int(line.split(":")[1])
                if video_bitrate > overall_bitrate: 
                    bitrate = video_bitrate // 8
                else:
                    bitrate = overall_bitrate // 8
                break

        print "bitrate: ", bitrate
        return bitrate
                
    
        
    

