#!/usr/bin/env python
# -*- coding: utf-8 -*- #

from watchvideo.ui_about import Ui_AboutDialog
from PyQt4 import QtCore, QtGui, QtSvg
import watchvideo.constants as c
import os

copyright = "Copyright © 2010 Leonardo Gastón De Luca".decode("UTF-8")

credits = \
"""
Developer(s):
Carlos Pais <freemind@lavabit.com>
Leonardo Gastón De Luca <leo@kde.org.ar>
Michał Masłowski <mtjm@mtjm.eu>

Web Developer(s):
Miguel Angel Souto

Thanks to:
Python Programming Language <http://www.python.org/>
Qt4 Libraries <http://qt.nokia.com/products/>
FFmpeg <http://www.ffmpeg.org/>
FFmpeg2Theora <http://v2v.cc/~j/ffmpeg2theora/>
MPlayer <http://www.mplayerhq.hu/>
python-mplayer <http://code.google.com/p/python-mplayer/>
MediaInfo <http://mediainfo.sourceforge.net/>
Libnotify
Mariano Street
Edgar Morales
""".decode("UTF-8")

license = \
"""
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
""".strip()

class AboutDialog(QtGui.QDialog):
    def __init__(self, parent):
        QtGui.QDialog.__init__(self, parent)
        self.ui = Ui_AboutDialog()
        self.ui.setupUi(self)
        
        description = self.tr("\n\nWatchVideo is a small application to play, " +
        "download or convert videos (to Ogg) from various youtube-like sites.\n" + "It's made in PyQt4.")
        
        #creates a Svg widget
        svg_icon = QtSvg.QSvgWidget(c.ICON_WATCHVIDEO)
        svg_icon.setFixedSize(200, 200)
        
        label_desc = QtGui.QLabel(description + "\n\n" + 
        copyright + "\n" + self.tr("Version: ") + c.VERSION + " beta")
        
        label_desc.setSizePolicy(QtGui.QSizePolicy(QtGui.QSizePolicy.Fixed, QtGui.QSizePolicy.Preferred))
        label_desc.setMaximumSize(self.maximumSize())
        label_desc.setWordWrap(True)

        vbox = QtGui.QVBoxLayout(self.ui.t_about)
        vbox.addWidget(svg_icon)
        vbox.setAlignment(svg_icon, QtCore.Qt.AlignHCenter)
        vbox.addWidget(label_desc)
        vbox.setAlignment(label_desc, QtCore.Qt.AlignJustify)
        
        self.ui.tedit_credits.setText(credits)
        self.ui.tedit_license.setText(license)
        
        QtCore.QObject.connect(self.ui.b_close, QtCore.SIGNAL("clicked()"), self.close)
        
        
    
