# -*- coding: utf-8 -*- #
# Copyright (C) 2008, 2009 Leonardo Gastón De Luca leo[at]kde.org.ar
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
GetMediumURL plugin for Xvideos videos.
"""


import urllib

from getmediumurl.cache import cachedproperty
from getmediumurl.compat import parse_qs
from getmediumurl.htmlplugin import HTMLPlugin


__all__ = ("Xvideos",)


class Xvideos(HTMLPlugin):

    """Plugin for Xvideos videos"""

    url_format = "http://www.xvideos.com/video%s"
    website_name = "XVIDEOS.COM"

    @cachedproperty
    def _flashvars(self):
        """Dictionary of variables passed to the Flash object."""
        for element in self.page.getiterator("embed"):
            # The file URL already has a query string, so don't
            # unquote it yet.
            return parse_qs(element.get("flashvars"))

    @property
    def description(self):
        """Video description."""
        return None  # the default is just title with site name

    @cachedproperty
    def title(self):
        """Video title."""
        title_text = super(Xvideos, self).title
        for element in self.page.getiterator("strong"):
            text = element.text
            if text is not None and title_text.startswith(text):
                return text
        return title_text

    @property
    def thumbnail(self):
        """Video thumbnail URL."""
        return urllib.unquote(self._flashvars["url_bigthumb"][0])

    def get_file_url(self, high_quality=False):
        """Get video URL."""
        return urllib.unquote(self._flashvars["flv_url"][0])
