# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Plugin for Metacafe videos."""


import re
import urllib
from xml.sax.saxutils import unescape

from getmediumurl.htmlplugin import HTMLPlugin


__all__ = ("Metacafe",)


class Metacafe(HTMLPlugin):

    """Plugin for Metacafe."""

    match_re = re.compile("^http://www\.metacafe\.com/watch/"
                          "(?P<mediumid>\d+)/")
    raw_url_format = "http://www.metacafe.com/watch/%s/"

    # Method originally written by Carlos Pais.
    def get_file_url(self, high_quality=False):
        """Get video URL."""
        mediaurl = self.get_content_substring(start="mediaURL%22%3A%22",
                                              end=(".flv", ".mp4"))
        gdakey = self.get_content_substring(start="key%22%3A%22",
                                            end="%22%7D%7D")
        mediaurl = urllib.unquote(mediaurl)
        mediaurl = unescape(mediaurl, {"\\": ''})
        return "%s?__gda__=%s" % (mediaurl, gdakey)
