/*
 * Copyright (C) 2011 Swapnil Sudhakar Kulkarni (swapnilkulkarni.cofsug@gmail.com)
 * Copyright (C) 2011 Sourabh S. Dige (sourabhdige@gmail.com)
 * Copyright (C) 2011 Mihir S. Kulkarni (mihirk.31@gmail.com)
 * Copyright (C) 2011 Abhijit A. M. (abhijit13@gmail.com)
 *
 * This is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * The full text of the GNU General Public
 * License version 3 can be found in the file `/usr/share/common-licenses/LGPL-3
 */

typedef struct {
        short full_width;
        short halant_width;
} complex_character_width;

/*
 * allocate_complex_width.h:
 *	This file contains the widths for Indic characters
 *	that should be allocated. All Devanagari related work
 *	has been done by:
 *		1. Swapnil S. Kulkarni(swapnilkulkarni.cofsug@gmail.com)
 *		2. Sourabh S. Dige (sourabhdige@gmail.com)
 *		3. Mihir Kulkarni (mihirk.31@gmail.com)
 *		4. Abhijit A. M. (abhijit13@gmail.com)
 *	Other Language community developers can add their language
 *	width array for that language support in this file.
 *
 *	Unicode allocated range for Devanagari is
 *	from 0x0900 to 0xa8fb
 */

complex_character_width devanagari_locale[]= {
        {8,	0},	/* 0x0900 inverted chandrabindu */
        {8,	0},	/* 0x0901 chandrabindu */
        {8,	0},	/* 0x0902 anusvara */
        {4,	0},	/* 0x0903 visarg */
        {9,	0},	/* 0x0904 short a */
        {10,	0},	/* 0x0905 a */
        {14,	0},	/* 0x0906 aa */
        {8,	0},	/* 0x0907 i */
        {8,	0}, 	/* 0x0908 ii */
        {8,	0},	/* 0x0909 u */
        {12,	0},	/* 0x090a uu */
        {11,	0},	/* 0x090b vocalic R */
        {11,	0}, 	/* 0x090c vocalic L */
        {8,	0},  	/* 0x090d chandra e */
        {8,	0},  	/* 0x090e short e*/
        {8,	0},  	/* 0x090f e */
        {8,	0},  	/* 0x0910 ai */
        {13,	0},  	/* 0x0911 chandra O */
        {11,	0},  	/* 0x0912 short O */
        {14,	0},  	/* 0x0913 O */
        {14,	0},  	/* 0x0914 au */
        {11,	8},  	/* 0x0915 ka */
        {12,	9},  	/* 0x0916 kha */
        {9,	5},  	/* 0x0917 ga */
        {9,	7}, 	/* 0x0918 gha */
        {9,	9},  	/* 0x0919 nga */
        {10,	7},  	/* 0x091a ca */
        {11,	9},  	/* 0x091b cha */
        {11,	7},  	/* 0x091c ja */
        {10,	7},  	/* 0x091d jha */
        {9,	9},  	/* 0x091e nya */
        {8,	8},  	/* 0x091f tta */
        {8,	8},  	/* 0x0920 ttha */
        {9,	8},  	/* 0x0921 dda */
        {8,	8},  	/* 0x0922 ddha */
        {11,	7},  	/* 0x0923 nna */
        {9,	4},  	/* 0x0924 ta */
        {10,	7}, 	/* 0x0925 tha */
        {8,	8},  	/* 0x0926 da */
        {8,	7},  	/* 0x0927 dha */
        {9,	7},  	/* 0x0928 na */
        {8,	7},  	/* 0x0929 nnna */
        {8,	5},  	/* 0x092a pa */
        {10,	7},  	/* 0x092b pha */
        {9,	7},  	/* 0x092c ba */
        {10,	7},  	/* 0x092d bha */
        {8,	7},  	/* 0x092e ma */
        {10,	6},  	/* 0x092f ya */
        {7,	2},  	/* 0x0930 ra */
        {6,	6},  	/* 0x0931 rra */
        {11,	8},  	/* 0x0932 la */
        {11,	11},  	/* 0x0933 lla */
        {11,	11},  	/* 0x0934 llla */
        {8,	7},  	/* 0x0935 va */
        {9,	7},  	/* 0x0936 sha */
        {8,	5},  	/* 0x0937 ssa */
        {10,	8},  	/* 0x0938 sa */
        {8,	8},  	/* 0x0939 ha */
        {8,	0},  	/* 0x093a */
        {8,	0},  	/* 0x094b */
        {8,	0}, 	/* 0x093c sign nukta */
        {8,	0}, 	/* 0x093d sign vagraha */
        {4,	0}, 	/* 0x093e vowel sign aa */
        {4,	0}, 	/* 0x093f vowel sign i */
        {4,	0}, 	/* 0x0940 vowel sign ii */
        {8,	0}, 	/* 0x0941 vowel sign u */
        {8,	0}, 	/* 0x0942 cowel sign uu */
        {0,	0}, 	/* 0x0943 vowel sign vocalic r */
        {0,	0}, 	/* 0x0944 vowel sign vocalic rr */
        {0,	0}, 	/* 0x0945 vowel sign chandra e */
        {0,	0}, 	/* 0x0946 vowel sign short e */
        {0,	0}, 	/* 0x0947 vowel sign e */
        {0,	0}, 	/* 0x0948 vowel sign ai */
        {4,	0}, 	/* 0x0949 vowel sign chandra o */
        {4,	0}, 	/* 0x094a vowel sign short o */
        {3,	0}, 	/* 0x094b vowel sign o */
        {4,	0}, 	/* 0x094c vowel sign au */
        {8,	0}, 	/* 0x094d sign virama (halant) */
        {8,	0}, 	/* 0x094e vowel sign prishthamatra e */
        {8,	0}, 	/* 0x094f */
        {10,	0}, 	/* 0x0950 OM */
        {8,	0}, 	/* 0x0951 */
        {8,	0}, 	/* 0x0952 */
        {8,	0}, 	/* 0x0953 Grave accent */
        {8,	0}, 	/* 0x0954 acute accent */
        {8,	0}, 	/* 0x0955 vowel sign chandra long e */
        {8,	0}, 	/* 0x0956 */
        {8,	0}, 	/* 0x0957 */
        {9,	8}, 	/* 0x0958 qa */
        {9,	8}, 	/* 0x0959 khha */
        {7,	6}, 	/* 0x095a ghha */
        {9,	8}, 	/* 0x095b za */
        {8,	8}, 	/* 0x095c dddha */
        {8,	8}, 	/* 0x095d rha */
        {8,	7}, 	/* 0x095e fa */
        {8,	7}, 	/* 0x095f yya */
        {10,	0}, 	/* 0x0960 vocalic rr */
        {8,	0}, 	/* 0x0961 vocalic ll */
        {8,	0}, 	/* 0x0962 vowel sign vocalic l */
        {8,	0}, 	/* 0x0963 vowel sign vocalic ll */
        {8,	0}, 	/* 0x0964 */
        {8,	0}, 	/* 0x0965 */
        {8,	0}, 	/* 0x0966 digit 0 */
        {8,	0}, 	/* 0x0967 digit 1 */
        {8,	0}, 	/* 0x0968 digit 2 */
        {8,	0}, 	/* 0x0969 digit 3 */
        {8,	0}, 	/* 0x096a digit 4 */
        {8,	0}, 	/* 0x096b digit 5 */
        {8,	0}, 	/* 0x096c digit 6 */
        {8,	0},	/* 0x096d digit 7 */
        {8,	0}, 	/* 0x096e digit 8 */
        {8,	0}, 	/* 0x096f digit 9 */
        {8,	0}, 	/* 0x0970 */
        {8,	0}, 	/* 0x0971 sign high spacing dot */
        {8,	0}, 	/* 0x0972 chandra a */
        {8,	0}, 	/* 0x0972 */
        {8,	0}, 	/* 0x0973 */
        {8,	0}, 	/* 0x0974 */
        {8,	0}, 	/* 0x0975 */
        {8,	0}, 	/* 0x0976 */
        {8,	0},	/* 0x0977 */
        {8,	0},	/* 0x0978 */
        {8,	0},	/* 0x0979 zha */
        {8,	0},	/* 0x097a heavy ya */
        {8,	0},	/* 0x097b gga */
        {8,	0},	/* 0x097c jja */
        {8,	0},	/* 0x097d Glottal stop */
        {8,	0},	/* 0x097e ddda */
        {8,	0},	/* 0x097f bba */

        {8,	0}, 	/* 0x980 */
        {8,	0}, 	/* 0x981 */
        {8,	0}, 	/* 0x982 */
        {8,	0}, 	/* 0x983 */
        {8,	0}, 	/* 0x984 */
        {8,	0}, 	/* 0x985 */
        {8,	0}, 	/* 0x986 */
        {8,	0}, 	/* 0x987 */
        {8,	0}, 	/* 0x988 */
        {8,	0}, 	/* 0x989 */
        {8,	0}, 	/* 0x98a */
        {8,	0}, 	/* 0x98b */
        {8,	0}, 	/* 0x98c */
        {8,	0}, 	/* 0x98d */
        {8,	0}, 	/* 0x98e */
        {8,	0}, 	/* 0x98f */
        {8,	0}, 	/* 0x990 */
        {8,	0}, 	/* 0x991 */
        {8,	0}, 	/* 0x992 */
        {8,	0}, 	/* 0x993 */
        {8,	0}, 	/* 0x994 */
        {8,	0}, 	/* 0x995 */
        {8,	0}, 	/* 0x996 */
        {8,	0}, 	/* 0x997 */
        {8,	0}, 	/* 0x998 */
        {8,	0}, 	/* 0x999 */
        {8,	0}, 	/* 0x99a */
        {8,	0}, 	/* 0x99b */
        {8,	0}, 	/* 0x99c */
        {8,	0}, 	/* 0x99d */
        {8,	0}, 	/* 0x99e */
        {8,	0}, 	/* 0x99f */
        {8,	0}, 	/* 0x9a0 */
        {8,	0}, 	/* 0x9a1 */
        {8,	0}, 	/* 0x9a2 */
        {8,	0}, 	/* 0x9a3 */
        {8,	0}, 	/* 0x9a4 */
        {8,	0}, 	/* 0x9a5 */
        {8,	0}, 	/* 0x9a6 */
        {8,	0}, 	/* 0x9a7 */
        {8,	0}, 	/* 0x9a8 */
        {8,	0}, 	/* 0x9a9 */
        {8,	0}, 	/* 0x9aa */
        {8,	0}, 	/* 0x9ab */
        {8,	0}, 	/* 0x9ac */
        {8,	0}, 	/* 0x9ad */
        {8,	0}, 	/* 0x9ae */
        {8,	0}, 	/* 0x9af */
        {8,	0}, 	/* 0x9b0 */
        {8,	0}, 	/* 0x9b1 */
        {8,	0}, 	/* 0x9b2 */
        {8,	0}, 	/* 0x9b3 */
        {8,	0}, 	/* 0x9b4 */
        {8,	0}, 	/* 0x9b5 */
        {8,	0}, 	/* 0x9b6 */
        {8,	0}, 	/* 0x9b7 */
        {8,	0}, 	/* 0x9b8 */
        {8,	0}, 	/* 0x9b9 */
        {8,	0}, 	/* 0x9ba */
        {8,	0}, 	/* 0x9bb */
        {8,	0}, 	/* 0x9bc */
        {8,	0}, 	/* 0x9bd */
        {8,	0}, 	/* 0x9be */
        {8,	0}, 	/* 0x9bf */
        {8,	0}, 	/* 0x9c0 */
        {8,	0}, 	/* 0x9c1 */
        {8,	0}, 	/* 0x9c2 */
        {8,	0}, 	/* 0x9c3 */
        {8,	0}, 	/* 0x9c4 */
        {8,	0}, 	/* 0x9c5 */
        {8,	0}, 	/* 0x9c6 */
        {8,	0}, 	/* 0x9c7 */
        {8,	0}, 	/* 0x9c8 */
        {8,	0}, 	/* 0x9c9 */
        {8,	0}, 	/* 0x9ca */
        {8,	0}, 	/* 0x9cb */
        {8,	0}, 	/* 0x9cc */
        {8,	0}, 	/* 0x9cd */
        {8,	0}, 	/* 0x9ce */
        {8,	0}, 	/* 0x9cf */
        {8,	0}, 	/* 0x9d0 */
        {8,	0}, 	/* 0x9d1 */
        {8,	0}, 	/* 0x9d2 */
        {8,	0}, 	/* 0x9d3 */
        {8,	0}, 	/* 0x9d4 */
        {8,	0}, 	/* 0x9d5 */
        {8,	0}, 	/* 0x9d6 */
        {8,	0}, 	/* 0x9d7 */
        {8,	0}, 	/* 0x9d8 */
        {8,	0}, 	/* 0x9d9 */
        {8,	0}, 	/* 0x9da */
        {8,	0}, 	/* 0x9db */
        {8,	0}, 	/* 0x9dc */
        {8,	0}, 	/* 0x9dd */
        {8,	0}, 	/* 0x9de */
        {8,	0}, 	/* 0x9df */
        {8,	0}, 	/* 0x9e0 */
        {8,	0}, 	/* 0x9e1 */
        {8,	0}, 	/* 0x9e2 */
        {8,	0}, 	/* 0x9e3 */
        {8,	0}, 	/* 0x9e4 */
        {8,	0}, 	/* 0x9e5 */
        {8,	0}, 	/* 0x9e6 */
        {8,	0}, 	/* 0x9e7 */
        {8,	0}, 	/* 0x9e8 */
        {8,	0}, 	/* 0x9e9 */
        {8,	0}, 	/* 0x9ea */
        {8,	0}, 	/* 0x9eb */
        {8,	0}, 	/* 0x9ec */
        {8,	0}, 	/* 0x9ed */
        {8,	0}, 	/* 0x9ee */
        {8,	0}, 	/* 0x9ef */
        {8,	0}, 	/* 0x9f0 */
        {8,	0}, 	/* 0x9f1 */
        {8,	0}, 	/* 0x9f2 */
        {8,	0}, 	/* 0x9f3 */
        {8,	0}, 	/* 0x9f4 */
        {8,	0}, 	/* 0x9f5 */
        {8,	0}, 	/* 0x9f6 */
        {8,	0}, 	/* 0x9f7 */
        {8,	0}, 	/* 0x9f8 */
        {8,	0}, 	/* 0x9f9 */
        {8,	0}, 	/* 0x9fa */
        {8,	0}, 	/* 0x9fb */
        {8,	0}, 	/* 0x9fc */
        {8,	0}, 	/* 0x9fd */
        {8,	0}, 	/* 0x9fe */
        {8,	0}, 	/* 0x9ff */
        {8,	0}, 	/* 0xa00 */
        {8,	0}, 	/* 0xa01 */
        {8,	0}, 	/* 0xa02 */
        {8,	0}, 	/* 0xa03 */
        {8,	0}, 	/* 0xa04 */
        {8,	0}, 	/* 0xa05 */
        {8,	0}, 	/* 0xa06 */
        {8,	0}, 	/* 0xa07 */
        {8,	0}, 	/* 0xa08 */
        {8,	0}, 	/* 0xa09 */
        {8,	0}, 	/* 0xa0a */
        {8,	0}, 	/* 0xa0b */
        {8,	0}, 	/* 0xa0c */
        {8,	0}, 	/* 0xa0d */
        {8,	0}, 	/* 0xa0e */
        {8,	0}, 	/* 0xa0f */
        {8,	0}, 	/* 0xa10 */
        {8,	0}, 	/* 0xa11 */
        {8,	0}, 	/* 0xa12 */
        {8,	0}, 	/* 0xa13 */
        {8,	0}, 	/* 0xa14 */
        {8,	0}, 	/* 0xa15 */
        {8,	0}, 	/* 0xa16 */
        {8,	0}, 	/* 0xa17 */
        {8,	0}, 	/* 0xa18 */
        {8,	0}, 	/* 0xa19 */
        {8,	0}, 	/* 0xa1a */
        {8,	0}, 	/* 0xa1b */
        {8,	0}, 	/* 0xa1c */
        {8,	0}, 	/* 0xa1d */
        {8,	0}, 	/* 0xa1e */
        {8,	0}, 	/* 0xa1f */
        {8,	0}, 	/* 0xa20 */
        {8,	0}, 	/* 0xa21 */
        {8,	0}, 	/* 0xa22 */
        {8,	0}, 	/* 0xa23 */
        {8,	0}, 	/* 0xa24 */
        {8,	0}, 	/* 0xa25 */
        {8,	0}, 	/* 0xa26 */
        {8,	0}, 	/* 0xa27 */
        {8,	0}, 	/* 0xa28 */
        {8,	0}, 	/* 0xa29 */
        {8,	0}, 	/* 0xa2a */
        {8,	0}, 	/* 0xa2b */
        {8,	0}, 	/* 0xa2c */
        {8,	0}, 	/* 0xa2d */
        {8,	0}, 	/* 0xa2e */
        {8,	0}, 	/* 0xa2f */
        {8,	0}, 	/* 0xa30 */
        {8,	0}, 	/* 0xa31 */
        {8,	0}, 	/* 0xa32 */
        {8,	0}, 	/* 0xa33 */
        {8,	0}, 	/* 0xa34 */
        {8,	0}, 	/* 0xa35 */
        {8,	0}, 	/* 0xa36 */
        {8,	0}, 	/* 0xa37 */
        {8,	0}, 	/* 0xa38 */
        {8,	0}, 	/* 0xa39 */
        {8,	0}, 	/* 0xa3a */
        {8,	0}, 	/* 0xa3b */
        {8,	0}, 	/* 0xa3c */
        {8,	0}, 	/* 0xa3d */
        {8,	0}, 	/* 0xa3e */
        {8,	0}, 	/* 0xa3f */
        {8,	0}, 	/* 0xa40 */
        {8,	0}, 	/* 0xa41 */
        {8,	0}, 	/* 0xa42 */
        {8,	0}, 	/* 0xa43 */
        {8,	0}, 	/* 0xa44 */
        {8,	0}, 	/* 0xa45 */
        {8,	0}, 	/* 0xa46 */
        {8,	0}, 	/* 0xa47 */
        {8,	0}, 	/* 0xa48 */
        {8,	0}, 	/* 0xa49 */
        {8,	0}, 	/* 0xa4a */
        {8,	0}, 	/* 0xa4b */
        {8,	0}, 	/* 0xa4c */
        {8,	0}, 	/* 0xa4d */
        {8,	0}, 	/* 0xa4e */
        {8,	0}, 	/* 0xa4f */
        {8,	0}, 	/* 0xa50 */
        {8,	0}, 	/* 0xa51 */
        {8,	0}, 	/* 0xa52 */
        {8,	0}, 	/* 0xa53 */
        {8,	0}, 	/* 0xa54 */
        {8,	0}, 	/* 0xa55 */
        {8,	0}, 	/* 0xa56 */
        {8,	0}, 	/* 0xa57 */
        {8,	0}, 	/* 0xa58 */
        {8,	0}, 	/* 0xa59 */
        {8,	0}, 	/* 0xa5a */
        {8,	0}, 	/* 0xa5b */
        {8,	0}, 	/* 0xa5c */
        {8,	0}, 	/* 0xa5d */
        {8,	0}, 	/* 0xa5e */
        {8,	0}, 	/* 0xa5f */
        {8,	0}, 	/* 0xa60 */
        {8,	0}, 	/* 0xa61 */
        {8,	0}, 	/* 0xa62 */
        {8,	0}, 	/* 0xa63 */
        {8,	0}, 	/* 0xa64 */
        {8,	0}, 	/* 0xa65 */
        {8,	0}, 	/* 0xa66 */
        {8,	0}, 	/* 0xa67 */
        {8,	0}, 	/* 0xa68 */
        {8,	0}, 	/* 0xa69 */
        {8,	0}, 	/* 0xa6a */
        {8,	0}, 	/* 0xa6b */
        {8,	0}, 	/* 0xa6c */
        {8,	0}, 	/* 0xa6d */
        {8,	0}, 	/* 0xa6e */
        {8,	0}, 	/* 0xa6f */
        {8,	0}, 	/* 0xa70 */
        {8,	0}, 	/* 0xa71 */
        {8,	0}, 	/* 0xa72 */
        {8,	0}, 	/* 0xa73 */
        {8,	0}, 	/* 0xa74 */
        {8,	0}, 	/* 0xa75 */
        {8,	0}, 	/* 0xa76 */
        {8,	0}, 	/* 0xa77 */
        {8,	0}, 	/* 0xa78 */
        {8,	0}, 	/* 0xa79 */
        {8,	0}, 	/* 0xa7a */
        {8,	0}, 	/* 0xa7b */
        {8,	0}, 	/* 0xa7c */
        {8,	0}, 	/* 0xa7d */
        {8,	0}, 	/* 0xa7e */
        {8,	0}, 	/* 0xa7f */
        {8,	0}, 	/* 0xa80 */
        {8,	0}, 	/* 0xa81 */
        {8,	0}, 	/* 0xa82 */
        {8,	0}, 	/* 0xa83 */
        {8,	0}, 	/* 0xa84 */
        {8,	0}, 	/* 0xa85 */
        {8,	0}, 	/* 0xa86 */
        {8,	0}, 	/* 0xa87 */
        {8,	0}, 	/* 0xa88 */
        {8,	0}, 	/* 0xa89 */
        {8,	0}, 	/* 0xa8a */
        {8,	0}, 	/* 0xa8b */
        {8,	0}, 	/* 0xa8c */
        {8,	0}, 	/* 0xa8d */
        {8,	0}, 	/* 0xa8e */
        {8,	0}, 	/* 0xa8f */
        {8,	0}, 	/* 0xa90 */
        {8,	0}, 	/* 0xa91 */
        {8,	0}, 	/* 0xa92 */
        {8,	0}, 	/* 0xa93 */
        {8,	0}, 	/* 0xa94 */
        {8,	0}, 	/* 0xa95 */
        {8,	0}, 	/* 0xa96 */
        {8,	0}, 	/* 0xa97 */
        {8,	0}, 	/* 0xa98 */
        {8,	0}, 	/* 0xa99 */
        {8,	0}, 	/* 0xa9a */
        {8,	0}, 	/* 0xa9b */
        {8,	0}, 	/* 0xa9c */
        {8,	0}, 	/* 0xa9d */
        {8,	0}, 	/* 0xa9e */
        {8,	0}, 	/* 0xa9f */
        {8,	0}, 	/* 0xaa0 */
        {8,	0}, 	/* 0xaa1 */
        {8,	0}, 	/* 0xaa2 */
        {8,	0}, 	/* 0xaa3 */
        {8,	0}, 	/* 0xaa4 */
        {8,	0}, 	/* 0xaa5 */
        {8,	0}, 	/* 0xaa6 */
        {8,	0}, 	/* 0xaa7 */
        {8,	0}, 	/* 0xaa8 */
        {8,	0}, 	/* 0xaa9 */
        {8,	0}, 	/* 0xaaa */
        {8,	0}, 	/* 0xaab */
        {8,	0}, 	/* 0xaac */
        {8,	0}, 	/* 0xaad */
        {8,	0}, 	/* 0xaae */
        {8,	0}, 	/* 0xaaf */
        {8,	0}, 	/* 0xab0 */
        {8,	0}, 	/* 0xab1 */
        {8,	0}, 	/* 0xab2 */
        {8,	0}, 	/* 0xab3 */
        {8,	0}, 	/* 0xab4 */
        {8,	0}, 	/* 0xab5 */
        {8,	0}, 	/* 0xab6 */
        {8,	0}, 	/* 0xab7 */
        {8,	0}, 	/* 0xab8 */
        {8,	0}, 	/* 0xab9 */
        {8,	0}, 	/* 0xaba */
        {8,	0}, 	/* 0xabb */
        {8,	0}, 	/* 0xabc */
        {8,	0}, 	/* 0xabd */
        {8,	0}, 	/* 0xabe */
        {8,	0}, 	/* 0xabf */
        {8,	0}, 	/* 0xac0 */
        {8,	0}, 	/* 0xac1 */
        {8,	0}, 	/* 0xac2 */
        {8,	0}, 	/* 0xac3 */
        {8,	0}, 	/* 0xac4 */
        {8,	0}, 	/* 0xac5 */
        {8,	0}, 	/* 0xac6 */
        {8,	0}, 	/* 0xac7 */
        {8,	0}, 	/* 0xac8 */
        {8,	0}, 	/* 0xac9 */
        {8,	0}, 	/* 0xaca */
        {8,	0}, 	/* 0xacb */
        {8,	0}, 	/* 0xacc */
        {8,	0}, 	/* 0xacd */
        {8,	0}, 	/* 0xace */
        {8,	0}, 	/* 0xacf */
        {8,	0}, 	/* 0xad0 */
        {8,	0}, 	/* 0xad1 */
        {8,	0}, 	/* 0xad2 */
        {8,	0}, 	/* 0xad3 */
        {8,	0}, 	/* 0xad4 */
        {8,	0}, 	/* 0xad5 */
        {8,	0}, 	/* 0xad6 */
        {8,	0}, 	/* 0xad7 */
        {8,	0}, 	/* 0xad8 */
        {8,	0}, 	/* 0xad9 */
        {8,	0}, 	/* 0xada */
        {8,	0}, 	/* 0xadb */
        {8,	0}, 	/* 0xadc */
        {8,	0}, 	/* 0xadd */
        {8,	0}, 	/* 0xade */
        {8,	0}, 	/* 0xadf */
        {8,	0}, 	/* 0xae0 */
        {8,	0}, 	/* 0xae1 */
        {8,	0}, 	/* 0xae2 */
        {8,	0}, 	/* 0xae3 */
        {8,	0}, 	/* 0xae4 */
        {8,	0}, 	/* 0xae5 */
        {8,	0}, 	/* 0xae6 */
        {8,	0}, 	/* 0xae7 */
        {8,	0}, 	/* 0xae8 */
        {8,	0}, 	/* 0xae9 */
        {8,	0}, 	/* 0xaea */
        {8,	0}, 	/* 0xaeb */
        {8,	0}, 	/* 0xaec */
        {8,	0}, 	/* 0xaed */
        {8,	0}, 	/* 0xaee */
        {8,	0}, 	/* 0xaef */
        {8,	0}, 	/* 0xaf0 */
        {8,	0}, 	/* 0xaf1 */
        {8,	0}, 	/* 0xaf2 */
        {8,	0}, 	/* 0xaf3 */
        {8,	0}, 	/* 0xaf4 */
        {8,	0}, 	/* 0xaf5 */
        {8,	0}, 	/* 0xaf6 */
        {8,	0}, 	/* 0xaf7 */
        {8,	0}, 	/* 0xaf8 */
        {8,	0}, 	/* 0xaf9 */
        {8,	0}, 	/* 0xafa */
        {8,	0}, 	/* 0xafb */
        {8,	0}, 	/* 0xafc */
        {8,	0}, 	/* 0xafd */
        {8,	0}, 	/* 0xafe */
        {8,	0}, 	/* 0xaff */
        {8,	0}, 	/* 0xb00 */
        {8,	0}, 	/* 0xb01 */
        {8,	0}, 	/* 0xb02 */
        {8,	0}, 	/* 0xb03 */
        {8,	0}, 	/* 0xb04 */
        {8,	0}, 	/* 0xb05 */
        {8,	0}, 	/* 0xb06 */
        {8,	0}, 	/* 0xb07 */
        {8,	0}, 	/* 0xb08 */
        {8,	0}, 	/* 0xb09 */
        {8,	0}, 	/* 0xb0a */
        {8,	0}, 	/* 0xb0b */
        {8,	0}, 	/* 0xb0c */
        {8,	0}, 	/* 0xb0d */
        {8,	0}, 	/* 0xb0e */
        {8,	0}, 	/* 0xb0f */
        {8,	0}, 	/* 0xb10 */
        {8,	0}, 	/* 0xb11 */
        {8,	0}, 	/* 0xb12 */
        {8,	0}, 	/* 0xb13 */
        {8,	0}, 	/* 0xb14 */
        {8,	0}, 	/* 0xb15 */
        {8,	0}, 	/* 0xb16 */
        {8,	0}, 	/* 0xb17 */
        {8,	0}, 	/* 0xb18 */
        {8,	0}, 	/* 0xb19 */
        {8,	0}, 	/* 0xb1a */
        {8,	0}, 	/* 0xb1b */
        {8,	0}, 	/* 0xb1c */
        {8,	0}, 	/* 0xb1d */
        {8,	0}, 	/* 0xb1e */
        {8,	0}, 	/* 0xb1f */
        {8,	0}, 	/* 0xb20 */
        {8,	0}, 	/* 0xb21 */
        {8,	0}, 	/* 0xb22 */
        {8,	0}, 	/* 0xb23 */
        {8,	0}, 	/* 0xb24 */
        {8,	0}, 	/* 0xb25 */
        {8,	0}, 	/* 0xb26 */
        {8,	0}, 	/* 0xb27 */
        {8,	0}, 	/* 0xb28 */
        {8,	0}, 	/* 0xb29 */
        {8,	0}, 	/* 0xb2a */
        {8,	0}, 	/* 0xb2b */
        {8,	0}, 	/* 0xb2c */
        {8,	0}, 	/* 0xb2d */
        {8,	0}, 	/* 0xb2e */
        {8,	0}, 	/* 0xb2f */
        {8,	0}, 	/* 0xb30 */
        {8,	0}, 	/* 0xb31 */
        {8,	0}, 	/* 0xb32 */
        {8,	0}, 	/* 0xb33 */
        {8,	0}, 	/* 0xb34 */
        {8,	0}, 	/* 0xb35 */
        {8,	0}, 	/* 0xb36 */
        {8,	0}, 	/* 0xb37 */
        {8,	0}, 	/* 0xb38 */
        {8,	0}, 	/* 0xb39 */
        {8,	0}, 	/* 0xb3a */
        {8,	0}, 	/* 0xb3b */
        {8,	0}, 	/* 0xb3c */
        {8,	0}, 	/* 0xb3d */
        {8,	0}, 	/* 0xb3e */
        {8,	0}, 	/* 0xb3f */
        {8,	0}, 	/* 0xb40 */
        {8,	0}, 	/* 0xb41 */
        {8,	0}, 	/* 0xb42 */
        {8,	0}, 	/* 0xb43 */
        {8,	0}, 	/* 0xb44 */
        {8,	0}, 	/* 0xb45 */
        {8,	0}, 	/* 0xb46 */
        {8,	0}, 	/* 0xb47 */
        {8,	0}, 	/* 0xb48 */
        {8,	0}, 	/* 0xb49 */
        {8,	0}, 	/* 0xb4a */
        {8,	0}, 	/* 0xb4b */
        {8,	0}, 	/* 0xb4c */
        {8,	0}, 	/* 0xb4d */
        {8,	0}, 	/* 0xb4e */
        {8,	0}, 	/* 0xb4f */
        {8,	0}, 	/* 0xb50 */
        {8,	0}, 	/* 0xb51 */
        {8,	0}, 	/* 0xb52 */
        {8,	0}, 	/* 0xb53 */
        {8,	0}, 	/* 0xb54 */
        {8,	0}, 	/* 0xb55 */
        {8,	0}, 	/* 0xb56 */
        {8,	0}, 	/* 0xb57 */
        {8,	0}, 	/* 0xb58 */
        {8,	0}, 	/* 0xb59 */
        {8,	0}, 	/* 0xb5a */
        {8,	0}, 	/* 0xb5b */
        {8,	0}, 	/* 0xb5c */
        {8,	0}, 	/* 0xb5d */
        {8,	0}, 	/* 0xb5e */
        {8,	0}, 	/* 0xb5f */
        {8,	0}, 	/* 0xb60 */
        {8,	0}, 	/* 0xb61 */
        {8,	0}, 	/* 0xb62 */
        {8,	0}, 	/* 0xb63 */
        {8,	0}, 	/* 0xb64 */
        {8,	0}, 	/* 0xb65 */
        {8,	0}, 	/* 0xb66 */
        {8,	0}, 	/* 0xb67 */
        {8,	0}, 	/* 0xb68 */
        {8,	0}, 	/* 0xb69 */
        {8,	0}, 	/* 0xb6a */
        {8,	0}, 	/* 0xb6b */
        {8,	0}, 	/* 0xb6c */
        {8,	0}, 	/* 0xb6d */
        {8,	0}, 	/* 0xb6e */
        {8,	0}, 	/* 0xb6f */
        {8,	0}, 	/* 0xb70 */
        {8,	0}, 	/* 0xb71 */
        {8,	0}, 	/* 0xb72 */
        {8,	0}, 	/* 0xb73 */
        {8,	0}, 	/* 0xb74 */
        {8,	0}, 	/* 0xb75 */
        {8,	0}, 	/* 0xb76 */
        {8,	0}, 	/* 0xb77 */
        {8,	0}, 	/* 0xb78 */
        {8,	0}, 	/* 0xb79 */
        {8,	0}, 	/* 0xb7a */
        {8,	0}, 	/* 0xb7b */
        {8,	0}, 	/* 0xb7c */
        {8,	0}, 	/* 0xb7d */
        {8,	0}, 	/* 0xb7e */
        {8,	0}, 	/* 0xb7f */
        {8,	0}, 	/* 0xb80 */
        {8,	0}, 	/* 0xb81 */
        {8,	0}, 	/* 0xb82 */
        {8,	0}, 	/* 0xb83 */
        {8,	0}, 	/* 0xb84 */
        {8,	0}, 	/* 0xb85 */
        {8,	0}, 	/* 0xb86 */
        {8,	0}, 	/* 0xb87 */
        {8,	0}, 	/* 0xb88 */
        {8,	0}, 	/* 0xb89 */
        {8,	0}, 	/* 0xb8a */
        {8,	0}, 	/* 0xb8b */
        {8,	0}, 	/* 0xb8c */
        {8,	0}, 	/* 0xb8d */
        {8,	0}, 	/* 0xb8e */
        {8,	0}, 	/* 0xb8f */
        {8,	0}, 	/* 0xb90 */
        {8,	0}, 	/* 0xb91 */
        {8,	0}, 	/* 0xb92 */
        {8,	0}, 	/* 0xb93 */
        {8,	0}, 	/* 0xb94 */
        {8,	0}, 	/* 0xb95 */
        {8,	0}, 	/* 0xb96 */
        {8,	0}, 	/* 0xb97 */
        {8,	0}, 	/* 0xb98 */
        {8,	0}, 	/* 0xb99 */
        {8,	0}, 	/* 0xb9a */
        {8,	0}, 	/* 0xb9b */
        {8,	0}, 	/* 0xb9c */
        {8,	0}, 	/* 0xb9d */
        {8,	0}, 	/* 0xb9e */
        {8,	0}, 	/* 0xb9f */
        {8,	0}, 	/* 0xba0 */
        {8,	0}, 	/* 0xba1 */
        {8,	0}, 	/* 0xba2 */
        {8,	0}, 	/* 0xba3 */
        {8,	0}, 	/* 0xba4 */
        {8,	0}, 	/* 0xba5 */
        {8,	0}, 	/* 0xba6 */
        {8,	0}, 	/* 0xba7 */
        {8,	0}, 	/* 0xba8 */
        {8,	0}, 	/* 0xba9 */
        {8,	0}, 	/* 0xbaa */
        {8,	0}, 	/* 0xbab */
        {8,	0}, 	/* 0xbac */
        {8,	0}, 	/* 0xbad */
        {8,	0}, 	/* 0xbae */
        {8,	0}, 	/* 0xbaf */
        {8,	0}, 	/* 0xbb0 */
        {8,	0}, 	/* 0xbb1 */
        {8,	0}, 	/* 0xbb2 */
        {8,	0}, 	/* 0xbb3 */
        {8,	0}, 	/* 0xbb4 */
        {8,	0}, 	/* 0xbb5 */
        {8,	0}, 	/* 0xbb6 */
        {8,	0}, 	/* 0xbb7 */
        {8,	0}, 	/* 0xbb8 */
        {8,	0}, 	/* 0xbb9 */
        {8,	0}, 	/* 0xbba */
        {8,	0}, 	/* 0xbbb */
        {8,	0}, 	/* 0xbbc */
        {8,	0}, 	/* 0xbbd */
        {8,	0}, 	/* 0xbbe */
        {8,	0}, 	/* 0xbbf */
        {8,	0}, 	/* 0xbc0 */
        {8,	0}, 	/* 0xbc1 */
        {8,	0}, 	/* 0xbc2 */
        {8,	0}, 	/* 0xbc3 */
        {8,	0}, 	/* 0xbc4 */
        {8,	0}, 	/* 0xbc5 */
        {8,	0}, 	/* 0xbc6 */
        {8,	0}, 	/* 0xbc7 */
        {8,	0}, 	/* 0xbc8 */
        {8,	0}, 	/* 0xbc9 */
        {8,	0}, 	/* 0xbca */
        {8,	0}, 	/* 0xbcb */
        {8,	0}, 	/* 0xbcc */
        {8,	0}, 	/* 0xbcd */
        {8,	0}, 	/* 0xbce */
        {8,	0}, 	/* 0xbcf */
        {8,	0}, 	/* 0xbd0 */
        {8,	0}, 	/* 0xbd1 */
        {8,	0}, 	/* 0xbd2 */
        {8,	0}, 	/* 0xbd3 */
        {8,	0}, 	/* 0xbd4 */
        {8,	0}, 	/* 0xbd5 */
        {8,	0}, 	/* 0xbd6 */
        {8,	0}, 	/* 0xbd7 */
        {8,	0}, 	/* 0xbd8 */
        {8,	0}, 	/* 0xbd9 */
        {8,	0}, 	/* 0xbda */
        {8,	0}, 	/* 0xbdb */
        {8,	0}, 	/* 0xbdc */
        {8,	0}, 	/* 0xbdd */
        {8,	0}, 	/* 0xbde */
        {8,	0}, 	/* 0xbdf */
        {8,	0}, 	/* 0xbe0 */
        {8,	0}, 	/* 0xbe1 */
        {8,	0}, 	/* 0xbe2 */
        {8,	0}, 	/* 0xbe3 */
        {8,	0}, 	/* 0xbe4 */
        {8,	0}, 	/* 0xbe5 */
        {8,	0}, 	/* 0xbe6 */
        {8,	0}, 	/* 0xbe7 */
        {8,	0}, 	/* 0xbe8 */
        {8,	0}, 	/* 0xbe9 */
        {8,	0}, 	/* 0xbea */
        {8,	0}, 	/* 0xbeb */
        {8,	0}, 	/* 0xbec */
        {8,	0}, 	/* 0xbed */
        {8,	0}, 	/* 0xbee */
        {8,	0}, 	/* 0xbef */
        {8,	0}, 	/* 0xbf0 */
        {8,	0}, 	/* 0xbf1 */
        {8,	0}, 	/* 0xbf2 */
        {8,	0}, 	/* 0xbf3 */
        {8,	0}, 	/* 0xbf4 */
        {8,	0}, 	/* 0xbf5 */
        {8,	0}, 	/* 0xbf6 */
        {8,	0}, 	/* 0xbf7 */
        {8,	0}, 	/* 0xbf8 */
        {8,	0}, 	/* 0xbf9 */
        {8,	0}, 	/* 0xbfa */
        {8,	0}, 	/* 0xbfb */
        {8,	0}, 	/* 0xbfc */
        {8,	0}, 	/* 0xbfd */
        {8,	0}, 	/* 0xbfe */
        {8,	0}, 	/* 0xbff */
        {8,	0}, 	/* 0xc00 */
        {8,	0}, 	/* 0xc01 */
        {8,	0}, 	/* 0xc02 */
        {8,	0}, 	/* 0xc03 */
        {8,	0}, 	/* 0xc04 */
        {8,	0}, 	/* 0xc05 */
        {8,	0}, 	/* 0xc06 */
        {8,	0}, 	/* 0xc07 */
        {8,	0}, 	/* 0xc08 */
        {8,	0}, 	/* 0xc09 */
        {8,	0}, 	/* 0xc0a */
        {8,	0}, 	/* 0xc0b */
        {8,	0}, 	/* 0xc0c */
        {8,	0}, 	/* 0xc0d */
        {8,	0}, 	/* 0xc0e */
        {8,	0}, 	/* 0xc0f */
        {8,	0}, 	/* 0xc10 */
        {8,	0}, 	/* 0xc11 */
        {8,	0}, 	/* 0xc12 */
        {8,	0}, 	/* 0xc13 */
        {8,	0}, 	/* 0xc14 */
        {8,	0}, 	/* 0xc15 */
        {8,	0}, 	/* 0xc16 */
        {8,	0}, 	/* 0xc17 */
        {8,	0}, 	/* 0xc18 */
        {8,	0}, 	/* 0xc19 */
        {8,	0}, 	/* 0xc1a */
        {8,	0}, 	/* 0xc1b */
        {8,	0}, 	/* 0xc1c */
        {8,	0}, 	/* 0xc1d */
        {8,	0}, 	/* 0xc1e */
        {8,	0}, 	/* 0xc1f */
        {8,	0}, 	/* 0xc20 */
        {8,	0}, 	/* 0xc21 */
        {8,	0}, 	/* 0xc22 */
        {8,	0}, 	/* 0xc23 */
        {8,	0}, 	/* 0xc24 */
        {8,	0}, 	/* 0xc25 */
        {8,	0}, 	/* 0xc26 */
        {8,	0}, 	/* 0xc27 */
        {8,	0}, 	/* 0xc28 */
        {8,	0}, 	/* 0xc29 */
        {8,	0}, 	/* 0xc2a */
        {8,	0}, 	/* 0xc2b */
        {8,	0}, 	/* 0xc2c */
        {8,	0}, 	/* 0xc2d */
        {8,	0}, 	/* 0xc2e */
        {8,	0}, 	/* 0xc2f */
        {8,	0}, 	/* 0xc30 */
        {8,	0}, 	/* 0xc31 */
        {8,	0}, 	/* 0xc32 */
        {8,	0}, 	/* 0xc33 */
        {8,	0}, 	/* 0xc34 */
        {8,	0}, 	/* 0xc35 */
        {8,	0}, 	/* 0xc36 */
        {8,	0}, 	/* 0xc37 */
        {8,	0}, 	/* 0xc38 */
        {8,	0}, 	/* 0xc39 */
        {8,	0}, 	/* 0xc3a */
        {8,	0}, 	/* 0xc3b */
        {8,	0}, 	/* 0xc3c */
        {8,	0}, 	/* 0xc3d */
        {8,	0}, 	/* 0xc3e */
        {8,	0}, 	/* 0xc3f */
        {8,	0}, 	/* 0xc40 */
        {8,	0}, 	/* 0xc41 */
        {8,	0}, 	/* 0xc42 */
        {8,	0}, 	/* 0xc43 */
        {8,	0}, 	/* 0xc44 */
        {8,	0}, 	/* 0xc45 */
        {8,	0}, 	/* 0xc46 */
        {8,	0}, 	/* 0xc47 */
        {8,	0}, 	/* 0xc48 */
        {8,	0}, 	/* 0xc49 */
        {8,	0}, 	/* 0xc4a */
        {8,	0}, 	/* 0xc4b */
        {8,	0}, 	/* 0xc4c */
        {8,	0}, 	/* 0xc4d */
        {8,	0}, 	/* 0xc4e */
        {8,	0}, 	/* 0xc4f */
        {8,	0}, 	/* 0xc50 */
        {8,	0}, 	/* 0xc51 */
        {8,	0}, 	/* 0xc52 */
        {8,	0}, 	/* 0xc53 */
        {8,	0}, 	/* 0xc54 */
        {8,	0}, 	/* 0xc55 */
        {8,	0}, 	/* 0xc56 */
        {8,	0}, 	/* 0xc57 */
        {8,	0}, 	/* 0xc58 */
        {8,	0}, 	/* 0xc59 */
        {8,	0}, 	/* 0xc5a */
        {8,	0}, 	/* 0xc5b */
        {8,	0}, 	/* 0xc5c */
        {8,	0}, 	/* 0xc5d */
        {8,	0}, 	/* 0xc5e */
        {8,	0}, 	/* 0xc5f */
        {8,	0}, 	/* 0xc60 */
        {8,	0}, 	/* 0xc61 */
        {8,	0}, 	/* 0xc62 */
        {8,	0}, 	/* 0xc63 */
        {8,	0}, 	/* 0xc64 */
        {8,	0}, 	/* 0xc65 */
        {8,	0}, 	/* 0xc66 */
        {8,	0}, 	/* 0xc67 */
        {8,	0}, 	/* 0xc68 */
        {8,	0}, 	/* 0xc69 */
        {8,	0}, 	/* 0xc6a */
        {8,	0}, 	/* 0xc6b */
        {8,	0}, 	/* 0xc6c */
        {8,	0}, 	/* 0xc6d */
        {8,	0}, 	/* 0xc6e */
        {8,	0}, 	/* 0xc6f */
        {8,	0}, 	/* 0xc70 */
        {8,	0}, 	/* 0xc71 */
        {8,	0}, 	/* 0xc72 */
        {8,	0}, 	/* 0xc73 */
        {8,	0}, 	/* 0xc74 */
        {8,	0}, 	/* 0xc75 */
        {8,	0}, 	/* 0xc76 */
        {8,	0}, 	/* 0xc77 */
        {8,	0}, 	/* 0xc78 */
        {8,	0}, 	/* 0xc79 */
        {8,	0}, 	/* 0xc7a */
        {8,	0}, 	/* 0xc7b */
        {8,	0}, 	/* 0xc7c */
        {8,	0}, 	/* 0xc7d */
        {8,	0}, 	/* 0xc7e */
        {8,	0}, 	/* 0xc7f */
        {8,	0}, 	/* 0xc80 */
        {8,	0}, 	/* 0xc81 */
        {8,	0}, 	/* 0xc82 */
        {8,	0}, 	/* 0xc83 */
        {8,	0}, 	/* 0xc84 */
        {8,	0}, 	/* 0xc85 */
        {8,	0}, 	/* 0xc86 */
        {8,	0}, 	/* 0xc87 */
        {8,	0}, 	/* 0xc88 */
        {8,	0}, 	/* 0xc89 */
        {8,	0}, 	/* 0xc8a */
        {8,	0}, 	/* 0xc8b */
        {8,	0}, 	/* 0xc8c */
        {8,	0}, 	/* 0xc8d */
        {8,	0}, 	/* 0xc8e */
        {8,	0}, 	/* 0xc8f */
        {8,	0}, 	/* 0xc90 */
        {8,	0}, 	/* 0xc91 */
        {8,	0}, 	/* 0xc92 */
        {8,	0}, 	/* 0xc93 */
        {8,	0}, 	/* 0xc94 */
        {8,	0}, 	/* 0xc95 */
        {8,	0}, 	/* 0xc96 */
        {8,	0}, 	/* 0xc97 */
        {8,	0}, 	/* 0xc98 */
        {8,	0}, 	/* 0xc99 */
        {8,	0}, 	/* 0xc9a */
        {8,	0}, 	/* 0xc9b */
        {8,	0}, 	/* 0xc9c */
        {8,	0}, 	/* 0xc9d */
        {8,	0}, 	/* 0xc9e */
        {8,	0}, 	/* 0xc9f */
        {8,	0}, 	/* 0xca0 */
        {8,	0}, 	/* 0xca1 */
        {8,	0}, 	/* 0xca2 */
        {8,	0}, 	/* 0xca3 */
        {8,	0}, 	/* 0xca4 */
        {8,	0}, 	/* 0xca5 */
        {8,	0}, 	/* 0xca6 */
        {8,	0}, 	/* 0xca7 */
        {8,	0}, 	/* 0xca8 */
        {8,	0}, 	/* 0xca9 */
        {8,	0}, 	/* 0xcaa */
        {8,	0}, 	/* 0xcab */
        {8,	0}, 	/* 0xcac */
        {8,	0}, 	/* 0xcad */
        {8,	0}, 	/* 0xcae */
        {8,	0}, 	/* 0xcaf */
        {8,	0}, 	/* 0xcb0 */
        {8,	0}, 	/* 0xcb1 */
        {8,	0}, 	/* 0xcb2 */
        {8,	0}, 	/* 0xcb3 */
        {8,	0}, 	/* 0xcb4 */
        {8,	0}, 	/* 0xcb5 */
        {8,	0}, 	/* 0xcb6 */
        {8,	0}, 	/* 0xcb7 */
        {8,	0}, 	/* 0xcb8 */
        {8,	0}, 	/* 0xcb9 */
        {8,	0}, 	/* 0xcba */
        {8,	0}, 	/* 0xcbb */
        {8,	0}, 	/* 0xcbc */
        {8,	0}, 	/* 0xcbd */
        {8,	0}, 	/* 0xcbe */
        {8,	0}, 	/* 0xcbf */
        {8,	0}, 	/* 0xcc0 */
        {8,	0}, 	/* 0xcc1 */
        {8,	0}, 	/* 0xcc2 */
        {8,	0}, 	/* 0xcc3 */
        {8,	0}, 	/* 0xcc4 */
        {8,	0}, 	/* 0xcc5 */
        {8,	0}, 	/* 0xcc6 */
        {8,	0}, 	/* 0xcc7 */
        {8,	0}, 	/* 0xcc8 */
        {8,	0}, 	/* 0xcc9 */
        {8,	0}, 	/* 0xcca */
        {8,	0}, 	/* 0xccb */
        {8,	0}, 	/* 0xccc */
        {8,	0}, 	/* 0xccd */
        {8,	0}, 	/* 0xcce */
        {8,	0}, 	/* 0xccf */
        {8,	0}, 	/* 0xcd0 */
        {8,	0}, 	/* 0xcd1 */
        {8,	0}, 	/* 0xcd2 */
        {8,	0}, 	/* 0xcd3 */
        {8,	0}, 	/* 0xcd4 */
        {8,	0}, 	/* 0xcd5 */
        {8,	0}, 	/* 0xcd6 */
        {8,	0}, 	/* 0xcd7 */
        {8,	0}, 	/* 0xcd8 */
        {8,	0}, 	/* 0xcd9 */
        {8,	0}, 	/* 0xcda */
        {8,	0}, 	/* 0xcdb */
        {8,	0}, 	/* 0xcdc */
        {8,	0}, 	/* 0xcdd */
        {8,	0}, 	/* 0xcde */
        {8,	0}, 	/* 0xcdf */
        {8,	0}, 	/* 0xce0 */
        {8,	0}, 	/* 0xce1 */
        {8,	0}, 	/* 0xce2 */
        {8,	0}, 	/* 0xce3 */
        {8,	0}, 	/* 0xce4 */
        {8,	0}, 	/* 0xce5 */
        {8,	0}, 	/* 0xce6 */
        {8,	0}, 	/* 0xce7 */
        {8,	0}, 	/* 0xce8 */
        {8,	0}, 	/* 0xce9 */
        {8,	0}, 	/* 0xcea */
        {8,	0}, 	/* 0xceb */
        {8,	0}, 	/* 0xcec */
        {8,	0}, 	/* 0xced */
        {8,	0}, 	/* 0xcee */
        {8,	0}, 	/* 0xcef */
        {8,	0}, 	/* 0xcf0 */
        {8,	0}, 	/* 0xcf1 */
        {8,	0}, 	/* 0xcf2 */
        {8,	0}, 	/* 0xcf3 */
        {8,	0}, 	/* 0xcf4 */
        {8,	0}, 	/* 0xcf5 */
        {8,	0}, 	/* 0xcf6 */
        {8,	0}, 	/* 0xcf7 */
        {8,	0}, 	/* 0xcf8 */
        {8,	0}, 	/* 0xcf9 */
        {8,	0}, 	/* 0xcfa */
        {8,	0}, 	/* 0xcfb */
        {8,	0}, 	/* 0xcfc */
        {8,	0}, 	/* 0xcfd */
        {8,	0}, 	/* 0xcfe */
        {8,	0}, 	/* 0xcff */
        {8,	0}, 	/* 0xd00 */
        {8,	0}, 	/* 0xd01 */
        {8,	0}, 	/* 0xd02 */
        {8,	0}, 	/* 0xd03 */
        {8,	0}, 	/* 0xd04 */
        {8,	0}, 	/* 0xd05 */
        {8,	0}, 	/* 0xd06 */
        {8,	0}, 	/* 0xd07 */
        {8,	0}, 	/* 0xd08 */
        {8,	0}, 	/* 0xd09 */
        {8,	0}, 	/* 0xd0a */
        {8,	0}, 	/* 0xd0b */
        {8,	0}, 	/* 0xd0c */
        {8,	0}, 	/* 0xd0d */
        {8,	0}, 	/* 0xd0e */
        {8,	0}, 	/* 0xd0f */
        {8,	0}, 	/* 0xd10 */
        {8,	0}, 	/* 0xd11 */
        {8,	0}, 	/* 0xd12 */
        {8,	0}, 	/* 0xd13 */
        {8,	0}, 	/* 0xd14 */
        {8,	0}, 	/* 0xd15 */
        {8,	0}, 	/* 0xd16 */
        {8,	0}, 	/* 0xd17 */
        {8,	0}, 	/* 0xd18 */
        {8,	0}, 	/* 0xd19 */
        {8,	0}, 	/* 0xd1a */
        {8,	0}, 	/* 0xd1b */
        {8,	0}, 	/* 0xd1c */
        {8,	0}, 	/* 0xd1d */
        {8,	0}, 	/* 0xd1e */
        {8,	0}, 	/* 0xd1f */
        {8,	0}, 	/* 0xd20 */
        {8,	0}, 	/* 0xd21 */
        {8,	0}, 	/* 0xd22 */
        {8,	0}, 	/* 0xd23 */
        {8,	0}, 	/* 0xd24 */
        {8,	0}, 	/* 0xd25 */
        {8,	0}, 	/* 0xd26 */
        {8,	0}, 	/* 0xd27 */
        {8,	0}, 	/* 0xd28 */
        {8,	0}, 	/* 0xd29 */
        {8,	0}, 	/* 0xd2a */
        {8,	0}, 	/* 0xd2b */
        {8,	0}, 	/* 0xd2c */
        {8,	0}, 	/* 0xd2d */
        {8,	0}, 	/* 0xd2e */
        {8,	0}, 	/* 0xd2f */
        {8,	0}, 	/* 0xd30 */
        {8,	0}, 	/* 0xd31 */
        {8,	0}, 	/* 0xd32 */
        {8,	0}, 	/* 0xd33 */
        {8,	0}, 	/* 0xd34 */
        {8,	0}, 	/* 0xd35 */
        {8,	0}, 	/* 0xd36 */
        {8,	0}, 	/* 0xd37 */
        {8,	0}, 	/* 0xd38 */
        {8,	0}, 	/* 0xd39 */
        {8,	0}, 	/* 0xd3a */
        {8,	0}, 	/* 0xd3b */
        {8,	0}, 	/* 0xd3c */
        {8,	0}, 	/* 0xd3d */
        {8,	0}, 	/* 0xd3e */
        {8,	0}, 	/* 0xd3f */
        {8,	0}, 	/* 0xd40 */
        {8,	0}, 	/* 0xd41 */
        {8,	0}, 	/* 0xd42 */
        {8,	0}, 	/* 0xd43 */
        {8,	0}, 	/* 0xd44 */
        {8,	0}, 	/* 0xd45 */
        {8,	0}, 	/* 0xd46 */
        {8,	0}, 	/* 0xd47 */
        {8,	0}, 	/* 0xd48 */
        {8,	0}, 	/* 0xd49 */
        {8,	0}, 	/* 0xd4a */
        {8,	0}, 	/* 0xd4b */
        {8,	0}, 	/* 0xd4c */
        {8,	0}, 	/* 0xd4d */
        {8,	0}, 	/* 0xd4e */
        {8,	0}, 	/* 0xd4f */
        {8,	0}, 	/* 0xd50 */
        {8,	0}, 	/* 0xd51 */
        {8,	0}, 	/* 0xd52 */
        {8,	0}, 	/* 0xd53 */
        {8,	0}, 	/* 0xd54 */
        {8,	0}, 	/* 0xd55 */
        {8,	0}, 	/* 0xd56 */
        {8,	0}, 	/* 0xd57 */
        {8,	0}, 	/* 0xd58 */
        {8,	0}, 	/* 0xd59 */
        {8,	0}, 	/* 0xd5a */
        {8,	0}, 	/* 0xd5b */
        {8,	0}, 	/* 0xd5c */
        {8,	0}, 	/* 0xd5d */
        {8,	0}, 	/* 0xd5e */
        {8,	0}, 	/* 0xd5f */
        {8,	0}, 	/* 0xd60 */
        {8,	0}, 	/* 0xd61 */
        {8,	0}, 	/* 0xd62 */
        {8,	0}, 	/* 0xd63 */
        {8,	0}, 	/* 0xd64 */
        {8,	0}, 	/* 0xd65 */
        {8,	0}, 	/* 0xd66 */
        {8,	0}, 	/* 0xd67 */
        {8,	0}, 	/* 0xd68 */
        {8,	0}, 	/* 0xd69 */
        {8,	0}, 	/* 0xd6a */
        {8,	0}, 	/* 0xd6b */
        {8,	0}, 	/* 0xd6c */
        {8,	0}, 	/* 0xd6d */
        {8,	0}, 	/* 0xd6e */
        {8,	0}, 	/* 0xd6f */
        {8,	0}, 	/* 0xd70 */
        {8,	0}, 	/* 0xd71 */
        {8,	0}, 	/* 0xd72 */
        {8,	0}, 	/* 0xd73 */
        {8,	0}, 	/* 0xd74 */
        {8,	0}, 	/* 0xd75 */
        {8,	0}, 	/* 0xd76 */
        {8,	0}, 	/* 0xd77 */
        {8,	0}, 	/* 0xd78 */
        {8,	0}, 	/* 0xd79 */
        {8,	0}, 	/* 0xd7a */
        {8,	0}, 	/* 0xd7b */
        {8,	0}, 	/* 0xd7c */
        {8,	0}, 	/* 0xd7d */
        {8,	0}, 	/* 0xd7e */
        {8,	0}, 	/* 0xd7f */
        {8,	0}, 	/* 0xd80 */
        {8,	0}, 	/* 0xd81 */
        {8,	0}, 	/* 0xd82 */
        {8,	0}, 	/* 0xd83 */
        {8,	0}, 	/* 0xd84 */
        {8,	0}, 	/* 0xd85 */
        {8,	0}, 	/* 0xd86 */
        {8,	0}, 	/* 0xd87 */
        {8,	0}, 	/* 0xd88 */
        {8,	0}, 	/* 0xd89 */
        {8,	0}, 	/* 0xd8a */
        {8,	0}, 	/* 0xd8b */
        {8,	0}, 	/* 0xd8c */
        {8,	0}, 	/* 0xd8d */
        {8,	0}, 	/* 0xd8e */
        {8,	0}, 	/* 0xd8f */
        {8,	0}, 	/* 0xd90 */
        {8,	0}, 	/* 0xd91 */
        {8,	0}, 	/* 0xd92 */
        {8,	0}, 	/* 0xd93 */
        {8,	0}, 	/* 0xd94 */
        {8,	0}, 	/* 0xd95 */
        {8,	0}, 	/* 0xd96 */
        {8,	0}, 	/* 0xd97 */
        {8,	0}, 	/* 0xd98 */
        {8,	0}, 	/* 0xd99 */
        {8,	0}, 	/* 0xd9a */
        {8,	0}, 	/* 0xd9b */
        {8,	0}, 	/* 0xd9c */
        {8,	0}, 	/* 0xd9d */
        {8,	0}, 	/* 0xd9e */
        {8,	0}, 	/* 0xd9f */
        {8,	0}, 	/* 0xda0 */
        {8,	0}, 	/* 0xda1 */
        {8,	0}, 	/* 0xda2 */
        {8,	0}, 	/* 0xda3 */
        {8,	0}, 	/* 0xda4 */
        {8,	0}, 	/* 0xda5 */
        {8,	0}, 	/* 0xda6 */
        {8,	0}, 	/* 0xda7 */
        {8,	0}, 	/* 0xda8 */
        {8,	0}, 	/* 0xda9 */
        {8,	0}, 	/* 0xdaa */
        {8,	0}, 	/* 0xdab */
        {8,	0}, 	/* 0xdac */
        {8,	0}, 	/* 0xdad */
        {8,	0}, 	/* 0xdae */
        {8,	0}, 	/* 0xdaf */
        {8,	0}, 	/* 0xdb0 */
        {8,	0}, 	/* 0xdb1 */
        {8,	0}, 	/* 0xdb2 */
        {8,	0}, 	/* 0xdb3 */
        {8,	0}, 	/* 0xdb4 */
        {8,	0}, 	/* 0xdb5 */
        {8,	0}, 	/* 0xdb6 */
        {8,	0}, 	/* 0xdb7 */
        {8,	0}, 	/* 0xdb8 */
        {8,	0}, 	/* 0xdb9 */
        {8,	0}, 	/* 0xdba */
        {8,	0}, 	/* 0xdbb */
        {8,	0}, 	/* 0xdbc */
        {8,	0}, 	/* 0xdbd */
        {8,	0}, 	/* 0xdbe */
        {8,	0}, 	/* 0xdbf */
        {8,	0}, 	/* 0xdc0 */
        {8,	0}, 	/* 0xdc1 */
        {8,	0}, 	/* 0xdc2 */
        {8,	0}, 	/* 0xdc3 */
        {8,	0}, 	/* 0xdc4 */
        {8,	0}, 	/* 0xdc5 */
        {8,	0}, 	/* 0xdc6 */
        {8,	0}, 	/* 0xdc7 */
        {8,	0}, 	/* 0xdc8 */
        {8,	0}, 	/* 0xdc9 */
        {8,	0}, 	/* 0xdca */
        {8,	0}, 	/* 0xdcb */
        {8,	0}, 	/* 0xdcc */
        {8,	0}, 	/* 0xdcd */
        {8,	0}, 	/* 0xdce */
        {8,	0}, 	/* 0xdcf */
        {8,	0}, 	/* 0xdd0 */
        {8,	0}, 	/* 0xdd1 */
        {8,	0}, 	/* 0xdd2 */
        {8,	0}, 	/* 0xdd3 */
        {8,	0}, 	/* 0xdd4 */
        {8,	0}, 	/* 0xdd5 */
        {8,	0}, 	/* 0xdd6 */
        {8,	0}, 	/* 0xdd7 */
        {8,	0}, 	/* 0xdd8 */
        {8,	0}, 	/* 0xdd9 */
        {8,	0}, 	/* 0xdda */
        {8,	0}, 	/* 0xddb */
        {8,	0}, 	/* 0xddc */
        {8,	0}, 	/* 0xddd */
        {8,	0}, 	/* 0xdde */
        {8,	0}, 	/* 0xddf */
        {8,	0}, 	/* 0xde0 */
        {8,	0}, 	/* 0xde1 */
        {8,	0}, 	/* 0xde2 */
        {8,	0}, 	/* 0xde3 */
        {8,	0}, 	/* 0xde4 */
        {8,	0}, 	/* 0xde5 */
        {8,	0}, 	/* 0xde6 */
        {8,	0}, 	/* 0xde7 */
        {8,	0}, 	/* 0xde8 */
        {8,	0}, 	/* 0xde9 */
        {8,	0}, 	/* 0xdea */
        {8,	0}, 	/* 0xdeb */
        {8,	0}, 	/* 0xdec */
        {8,	0}, 	/* 0xded */
        {8,	0}, 	/* 0xdee */
        {8,	0}, 	/* 0xdef */
        {8,	0}, 	/* 0xdf0 */
        {8,	0}, 	/* 0xdf1 */
        {8,	0}, 	/* 0xdf2 */
        {8,	0}, 	/* 0xdf3 */
        {8,	0}, 	/* 0xdf4 */
        {8,	0}, 	/* 0xdf5 */
        {8,	0}, 	/* 0xdf6 */
        {8,	0}, 	/* 0xdf7 */
        {8,	0}, 	/* 0xdf8 */
        {8,	0}, 	/* 0xdf9 */
        {8,	0}, 	/* 0xdfa */
        {8,	0}, 	/* 0xdfb */
        {8,	0}, 	/* 0xdfc */
        {8,	0}, 	/* 0xdfd */
        {8,	0}, 	/* 0xdfe */
        {8,	0}, 	/* 0xdff */
        {8,	0}, 	/* 0xe00 */
        {8,	0}, 	/* 0xe01 */
        {8,	0}, 	/* 0xe02 */
        {8,	0}, 	/* 0xe03 */
        {8,	0}, 	/* 0xe04 */
        {8,	0}, 	/* 0xe05 */
        {8,	0}, 	/* 0xe06 */
        {8,	0}, 	/* 0xe07 */
        {8,	0}, 	/* 0xe08 */
        {8,	0}, 	/* 0xe09 */
        {8,	0}, 	/* 0xe0a */
        {8,	0}, 	/* 0xe0b */
        {8,	0}, 	/* 0xe0c */
        {8,	0}, 	/* 0xe0d */
        {8,	0}, 	/* 0xe0e */
        {8,	0}, 	/* 0xe0f */
        {8,	0}, 	/* 0xe10 */
        {8,	0}, 	/* 0xe11 */
        {8,	0}, 	/* 0xe12 */
        {8,	0}, 	/* 0xe13 */
        {8,	0}, 	/* 0xe14 */
        {8,	0}, 	/* 0xe15 */
        {8,	0}, 	/* 0xe16 */
        {8,	0}, 	/* 0xe17 */
        {8,	0}, 	/* 0xe18 */
        {8,	0}, 	/* 0xe19 */
        {8,	0}, 	/* 0xe1a */
        {8,	0}, 	/* 0xe1b */
        {8,	0}, 	/* 0xe1c */
        {8,	0}, 	/* 0xe1d */
        {8,	0}, 	/* 0xe1e */
        {8,	0}, 	/* 0xe1f */
        {8,	0}, 	/* 0xe20 */
        {8,	0}, 	/* 0xe21 */
        {8,	0}, 	/* 0xe22 */
        {8,	0}, 	/* 0xe23 */
        {8,	0}, 	/* 0xe24 */
        {8,	0}, 	/* 0xe25 */
        {8,	0}, 	/* 0xe26 */
        {8,	0}, 	/* 0xe27 */
        {8,	0}, 	/* 0xe28 */
        {8,	0}, 	/* 0xe29 */
        {8,	0}, 	/* 0xe2a */
        {8,	0}, 	/* 0xe2b */
        {8,	0}, 	/* 0xe2c */
        {8,	0}, 	/* 0xe2d */
        {8,	0}, 	/* 0xe2e */
        {8,	0}, 	/* 0xe2f */
        {8,	0}, 	/* 0xe30 */
        {8,	0}, 	/* 0xe31 */
        {8,	0}, 	/* 0xe32 */
        {8,	0}, 	/* 0xe33 */
        {8,	0}, 	/* 0xe34 */
        {8,	0}, 	/* 0xe35 */
        {8,	0}, 	/* 0xe36 */
        {8,	0}, 	/* 0xe37 */
        {8,	0}, 	/* 0xe38 */
        {8,	0}, 	/* 0xe39 */
        {8,	0}, 	/* 0xe3a */
        {8,	0}, 	/* 0xe3b */
        {8,	0}, 	/* 0xe3c */
        {8,	0}, 	/* 0xe3d */
        {8,	0}, 	/* 0xe3e */
        {8,	0}, 	/* 0xe3f */
        {8,	0}, 	/* 0xe40 */
        {8,	0}, 	/* 0xe41 */
        {8,	0}, 	/* 0xe42 */
        {8,	0}, 	/* 0xe43 */
        {8,	0}, 	/* 0xe44 */
        {8,	0}, 	/* 0xe45 */
        {8,	0}, 	/* 0xe46 */
        {8,	0}, 	/* 0xe47 */
        {8,	0}, 	/* 0xe48 */
        {8,	0}, 	/* 0xe49 */
        {8,	0}, 	/* 0xe4a */
        {8,	0}, 	/* 0xe4b */
        {8,	0}, 	/* 0xe4c */
        {8,	0}, 	/* 0xe4d */
        {8,	0}, 	/* 0xe4e */
        {8,	0}, 	/* 0xe4f */
        {8,	0}, 	/* 0xe50 */
        {8,	0}, 	/* 0xe51 */
        {8,	0}, 	/* 0xe52 */
        {8,	0}, 	/* 0xe53 */
        {8,	0}, 	/* 0xe54 */
        {8,	0}, 	/* 0xe55 */
        {8,	0}, 	/* 0xe56 */
        {8,	0}, 	/* 0xe57 */
        {8,	0}, 	/* 0xe58 */
        {8,	0}, 	/* 0xe59 */
        {8,	0}, 	/* 0xe5a */
        {8,	0}, 	/* 0xe5b */
        {8,	0}, 	/* 0xe5c */
        {8,	0}, 	/* 0xe5d */
        {8,	0}, 	/* 0xe5e */
        {8,	0}, 	/* 0xe5f */
        {8,	0}, 	/* 0xe60 */
        {8,	0}, 	/* 0xe61 */
        {8,	0}, 	/* 0xe62 */
        {8,	0}, 	/* 0xe63 */
        {8,	0}, 	/* 0xe64 */
        {8,	0}, 	/* 0xe65 */
        {8,	0}, 	/* 0xe66 */
        {8,	0}, 	/* 0xe67 */
        {8,	0}, 	/* 0xe68 */
        {8,	0}, 	/* 0xe69 */
        {8,	0}, 	/* 0xe6a */
        {8,	0}, 	/* 0xe6b */
        {8,	0}, 	/* 0xe6c */
        {8,	0}, 	/* 0xe6d */
        {8,	0}, 	/* 0xe6e */
        {8,	0}, 	/* 0xe6f */
        {8,	0}, 	/* 0xe70 */
        {8,	0}, 	/* 0xe71 */
        {8,	0}, 	/* 0xe72 */
        {8,	0}, 	/* 0xe73 */
        {8,	0}, 	/* 0xe74 */
        {8,	0}, 	/* 0xe75 */
        {8,	0}, 	/* 0xe76 */
        {8,	0}, 	/* 0xe77 */
        {8,	0}, 	/* 0xe78 */
        {8,	0}, 	/* 0xe79 */
        {8,	0}, 	/* 0xe7a */
        {8,	0}, 	/* 0xe7b */
        {8,	0}, 	/* 0xe7c */
        {8,	0}, 	/* 0xe7d */
        {8,	0}, 	/* 0xe7e */
        {8,	0}, 	/* 0xe7f */
        {8,	0}, 	/* 0xe80 */
        {8,	0}, 	/* 0xe81 */
        {8,	0}, 	/* 0xe82 */
        {8,	0}, 	/* 0xe83 */
        {8,	0}, 	/* 0xe84 */
        {8,	0}, 	/* 0xe85 */
        {8,	0}, 	/* 0xe86 */
        {8,	0}, 	/* 0xe87 */
        {8,	0}, 	/* 0xe88 */
        {8,	0}, 	/* 0xe89 */
        {8,	0}, 	/* 0xe8a */
        {8,	0}, 	/* 0xe8b */
        {8,	0}, 	/* 0xe8c */
        {8,	0}, 	/* 0xe8d */
        {8,	0}, 	/* 0xe8e */
        {8,	0}, 	/* 0xe8f */
        {8,	0}, 	/* 0xe90 */
        {8,	0}, 	/* 0xe91 */
        {8,	0}, 	/* 0xe92 */
        {8,	0}, 	/* 0xe93 */
        {8,	0}, 	/* 0xe94 */
        {8,	0}, 	/* 0xe95 */
        {8,	0}, 	/* 0xe96 */
        {8,	0}, 	/* 0xe97 */
        {8,	0}, 	/* 0xe98 */
        {8,	0}, 	/* 0xe99 */
        {8,	0}, 	/* 0xe9a */
        {8,	0}, 	/* 0xe9b */
        {8,	0}, 	/* 0xe9c */
        {8,	0}, 	/* 0xe9d */
        {8,	0}, 	/* 0xe9e */
        {8,	0}, 	/* 0xe9f */
        {8,	0}, 	/* 0xea0 */
        {8,	0}, 	/* 0xea1 */
        {8,	0}, 	/* 0xea2 */
        {8,	0}, 	/* 0xea3 */
        {8,	0}, 	/* 0xea4 */
        {8,	0}, 	/* 0xea5 */
        {8,	0}, 	/* 0xea6 */
        {8,	0}, 	/* 0xea7 */
        {8,	0}, 	/* 0xea8 */
        {8,	0}, 	/* 0xea9 */
        {8,	0}, 	/* 0xeaa */
        {8,	0}, 	/* 0xeab */
        {8,	0}, 	/* 0xeac */
        {8,	0}, 	/* 0xead */
        {8,	0}, 	/* 0xeae */
        {8,	0}, 	/* 0xeaf */
        {8,	0}, 	/* 0xeb0 */
        {8,	0}, 	/* 0xeb1 */
        {8,	0}, 	/* 0xeb2 */
        {8,	0}, 	/* 0xeb3 */
        {8,	0}, 	/* 0xeb4 */
        {8,	0}, 	/* 0xeb5 */
        {8,	0}, 	/* 0xeb6 */
        {8,	0}, 	/* 0xeb7 */
        {8,	0}, 	/* 0xeb8 */
        {8,	0}, 	/* 0xeb9 */
        {8,	0}, 	/* 0xeba */
        {8,	0}, 	/* 0xebb */
        {8,	0}, 	/* 0xebc */
        {8,	0}, 	/* 0xebd */
        {8,	0}, 	/* 0xebe */
        {8,	0}, 	/* 0xebf */
        {8,	0}, 	/* 0xec0 */
        {8,	0}, 	/* 0xec1 */
        {8,	0}, 	/* 0xec2 */
        {8,	0}, 	/* 0xec3 */
        {8,	0}, 	/* 0xec4 */
        {8,	0}, 	/* 0xec5 */
        {8,	0}, 	/* 0xec6 */
        {8,	0}, 	/* 0xec7 */
        {8,	0}, 	/* 0xec8 */
        {8,	0}, 	/* 0xec9 */
        {8,	0}, 	/* 0xeca */
        {8,	0}, 	/* 0xecb */
        {8,	0}, 	/* 0xecc */
        {8,	0}, 	/* 0xecd */
        {8,	0}, 	/* 0xece */
        {8,	0}, 	/* 0xecf */
        {8,	0}, 	/* 0xed0 */
        {8,	0}, 	/* 0xed1 */
        {8,	0}, 	/* 0xed2 */
        {8,	0}, 	/* 0xed3 */
        {8,	0}, 	/* 0xed4 */
        {8,	0}, 	/* 0xed5 */
        {8,	0}, 	/* 0xed6 */
        {8,	0}, 	/* 0xed7 */
        {8,	0}, 	/* 0xed8 */
        {8,	0}, 	/* 0xed9 */
        {8,	0}, 	/* 0xeda */
        {8,	0}, 	/* 0xedb */
        {8,	0}, 	/* 0xedc */
        {8,	0}, 	/* 0xedd */
        {8,	0}, 	/* 0xede */
        {8,	0}, 	/* 0xedf */
        {8,	0}, 	/* 0xee0 */
        {8,	0}, 	/* 0xee1 */
        {8,	0}, 	/* 0xee2 */
        {8,	0}, 	/* 0xee3 */
        {8,	0}, 	/* 0xee4 */
        {8,	0}, 	/* 0xee5 */
        {8,	0}, 	/* 0xee6 */
        {8,	0}, 	/* 0xee7 */
        {8,	0}, 	/* 0xee8 */
        {8,	0}, 	/* 0xee9 */
        {8,	0}, 	/* 0xeea */
        {8,	0}, 	/* 0xeeb */
        {8,	0}, 	/* 0xeec */
        {8,	0}, 	/* 0xeed */
        {8,	0}, 	/* 0xeee */
        {8,	0}, 	/* 0xeef */
        {8,	0}, 	/* 0xef0 */
        {8,	0}, 	/* 0xef1 */
        {8,	0}, 	/* 0xef2 */
        {8,	0}, 	/* 0xef3 */
        {8,	0}, 	/* 0xef4 */
        {8,	0}, 	/* 0xef5 */
        {8,	0}, 	/* 0xef6 */
        {8,	0}, 	/* 0xef7 */
        {8,	0}, 	/* 0xef8 */
        {8,	0}, 	/* 0xef9 */
        {8,	0}, 	/* 0xefa */
        {8,	0}, 	/* 0xefb */
        {8,	0}, 	/* 0xefc */
        {8,	0}, 	/* 0xefd */
        {8,	0}, 	/* 0xefe */
        {8,	0}, 	/* 0xeff */
        {8,	0}, 	/* 0xf00 */
        {8,	0}, 	/* 0xf01 */
        {8,	0}, 	/* 0xf02 */
        {8,	0}, 	/* 0xf03 */
        {8,	0}, 	/* 0xf04 */
        {8,	0}, 	/* 0xf05 */
        {8,	0}, 	/* 0xf06 */
        {8,	0}, 	/* 0xf07 */
        {8,	0}, 	/* 0xf08 */
        {8,	0}, 	/* 0xf09 */
        {8,	0}, 	/* 0xf0a */
        {8,	0}, 	/* 0xf0b */
        {8,	0}, 	/* 0xf0c */
        {8,	0}, 	/* 0xf0d */
        {8,	0}, 	/* 0xf0e */
        {8,	0}, 	/* 0xf0f */
        {8,	0}, 	/* 0xf10 */
        {8,	0}, 	/* 0xf11 */
        {8,	0}, 	/* 0xf12 */
        {8,	0}, 	/* 0xf13 */
        {8,	0}, 	/* 0xf14 */
        {8,	0}, 	/* 0xf15 */
        {8,	0}, 	/* 0xf16 */
        {8,	0}, 	/* 0xf17 */
        {8,	0}, 	/* 0xf18 */
        {8,	0}, 	/* 0xf19 */
        {8,	0}, 	/* 0xf1a */
        {8,	0}, 	/* 0xf1b */
        {8,	0}, 	/* 0xf1c */
        {8,	0}, 	/* 0xf1d */
        {8,	0}, 	/* 0xf1e */
        {8,	0}, 	/* 0xf1f */
        {8,	0}, 	/* 0xf20 */
        {8,	0}, 	/* 0xf21 */
        {8,	0}, 	/* 0xf22 */
        {8,	0}, 	/* 0xf23 */
        {8,	0}, 	/* 0xf24 */
        {8,	0}, 	/* 0xf25 */
        {8,	0}, 	/* 0xf26 */
        {8,	0}, 	/* 0xf27 */
        {8,	0}, 	/* 0xf28 */
        {8,	0}, 	/* 0xf29 */
        {8,	0}, 	/* 0xf2a */
        {8,	0}, 	/* 0xf2b */
        {8,	0}, 	/* 0xf2c */
        {8,	0}, 	/* 0xf2d */
        {8,	0}, 	/* 0xf2e */
        {8,	0}, 	/* 0xf2f */
        {8,	0}, 	/* 0xf30 */
        {8,	0}, 	/* 0xf31 */
        {8,	0}, 	/* 0xf32 */
        {8,	0}, 	/* 0xf33 */
        {8,	0}, 	/* 0xf34 */
        {8,	0}, 	/* 0xf35 */
        {8,	0}, 	/* 0xf36 */
        {8,	0}, 	/* 0xf37 */
        {8,	0}, 	/* 0xf38 */
        {8,	0}, 	/* 0xf39 */
        {8,	0}, 	/* 0xf3a */
        {8,	0}, 	/* 0xf3b */
        {8,	0}, 	/* 0xf3c */
        {8,	0}, 	/* 0xf3d */
        {8,	0}, 	/* 0xf3e */
        {8,	0}, 	/* 0xf3f */
        {8,	0}, 	/* 0xf40 */
        {8,	0}, 	/* 0xf41 */
        {8,	0}, 	/* 0xf42 */
        {8,	0}, 	/* 0xf43 */
        {8,	0}, 	/* 0xf44 */
        {8,	0}, 	/* 0xf45 */
        {8,	0}, 	/* 0xf46 */
        {8,	0}, 	/* 0xf47 */
        {8,	0}, 	/* 0xf48 */
        {8,	0}, 	/* 0xf49 */
        {8,	0}, 	/* 0xf4a */
        {8,	0}, 	/* 0xf4b */
        {8,	0}, 	/* 0xf4c */
        {8,	0}, 	/* 0xf4d */
        {8,	0}, 	/* 0xf4e */
        {8,	0}, 	/* 0xf4f */
        {8,	0}, 	/* 0xf50 */
        {8,	0}, 	/* 0xf51 */
        {8,	0}, 	/* 0xf52 */
        {8,	0}, 	/* 0xf53 */
        {8,	0}, 	/* 0xf54 */
        {8,	0}, 	/* 0xf55 */
        {8,	0}, 	/* 0xf56 */
        {8,	0}, 	/* 0xf57 */
        {8,	0}, 	/* 0xf58 */
        {8,	0}, 	/* 0xf59 */
        {8,	0}, 	/* 0xf5a */
        {8,	0}, 	/* 0xf5b */
        {8,	0}, 	/* 0xf5c */
        {8,	0}, 	/* 0xf5d */
        {8,	0}, 	/* 0xf5e */
        {8,	0}, 	/* 0xf5f */
        {8,	0}, 	/* 0xf60 */
        {8,	0}, 	/* 0xf61 */
        {8,	0}, 	/* 0xf62 */
        {8,	0}, 	/* 0xf63 */
        {8,	0}, 	/* 0xf64 */
        {8,	0}, 	/* 0xf65 */
        {8,	0}, 	/* 0xf66 */
        {8,	0}, 	/* 0xf67 */
        {8,	0}, 	/* 0xf68 */
        {8,	0}, 	/* 0xf69 */
        {8,	0}, 	/* 0xf6a */
        {8,	0}, 	/* 0xf6b */
        {8,	0}, 	/* 0xf6c */
        {8,	0}, 	/* 0xf6d */
        {8,	0}, 	/* 0xf6e */
        {8,	0}, 	/* 0xf6f */
        {8,	0}, 	/* 0xf70 */
        {8,	0}, 	/* 0xf71 */
        {8,	0}, 	/* 0xf72 */
        {8,	0}, 	/* 0xf73 */
        {8,	0}, 	/* 0xf74 */
        {8,	0}, 	/* 0xf75 */
        {8,	0}, 	/* 0xf76 */
        {8,	0}, 	/* 0xf77 */
        {8,	0}, 	/* 0xf78 */
        {8,	0}, 	/* 0xf79 */
        {8,	0}, 	/* 0xf7a */
        {8,	0}, 	/* 0xf7b */
        {8,	0}, 	/* 0xf7c */
        {8,	0}, 	/* 0xf7d */
        {8,	0}, 	/* 0xf7e */
        {8,	0}, 	/* 0xf7f */
        {8,	0}, 	/* 0xf80 */
        {8,	0}, 	/* 0xf81 */
        {8,	0}, 	/* 0xf82 */
        {8,	0}, 	/* 0xf83 */
        {8,	0}, 	/* 0xf84 */
        {8,	0}, 	/* 0xf85 */
        {8,	0}, 	/* 0xf86 */
        {8,	0}, 	/* 0xf87 */
        {8,	0}, 	/* 0xf88 */
        {8,	0}, 	/* 0xf89 */
        {8,	0}, 	/* 0xf8a */
        {8,	0}, 	/* 0xf8b */
        {8,	0}, 	/* 0xf8c */
        {8,	0}, 	/* 0xf8d */
        {8,	0}, 	/* 0xf8e */
        {8,	0}, 	/* 0xf8f */
        {8,	0}, 	/* 0xf90 */
        {8,	0}, 	/* 0xf91 */
        {8,	0}, 	/* 0xf92 */
        {8,	0}, 	/* 0xf93 */
        {8,	0}, 	/* 0xf94 */
        {8,	0}, 	/* 0xf95 */
        {8,	0}, 	/* 0xf96 */
        {8,	0}, 	/* 0xf97 */
        {8,	0}, 	/* 0xf98 */
        {8,	0}, 	/* 0xf99 */
        {8,	0}, 	/* 0xf9a */
        {8,	0}, 	/* 0xf9b */
        {8,	0}, 	/* 0xf9c */
        {8,	0}, 	/* 0xf9d */
        {8,	0}, 	/* 0xf9e */
        {8,	0}, 	/* 0xf9f */
        {8,	0}, 	/* 0xfa0 */
        {8,	0}, 	/* 0xfa1 */
        {8,	0}, 	/* 0xfa2 */
        {8,	0}, 	/* 0xfa3 */
        {8,	0}, 	/* 0xfa4 */
        {8,	0}, 	/* 0xfa5 */
        {8,	0}, 	/* 0xfa6 */
        {8,	0}, 	/* 0xfa7 */
        {8,	0}, 	/* 0xfa8 */
        {8,	0}, 	/* 0xfa9 */
        {8,	0}, 	/* 0xfaa */
        {8,	0}, 	/* 0xfab */
        {8,	0}, 	/* 0xfac */
        {8,	0}, 	/* 0xfad */
        {8,	0}, 	/* 0xfae */
        {8,	0}, 	/* 0xfaf */
        {8,	0}, 	/* 0xfb0 */
        {8,	0}, 	/* 0xfb1 */
        {8,	0}, 	/* 0xfb2 */
        {8,	0}, 	/* 0xfb3 */
        {8,	0}, 	/* 0xfb4 */
        {8,	0}, 	/* 0xfb5 */
        {8,	0}, 	/* 0xfb6 */
        {8,	0}, 	/* 0xfb7 */
        {8,	0}, 	/* 0xfb8 */
        {8,	0}, 	/* 0xfb9 */
        {8,	0}, 	/* 0xfba */
        {8,	0}, 	/* 0xfbb */
        {8,	0}, 	/* 0xfbc */
        {8,	0}, 	/* 0xfbd */
        {8,	0}, 	/* 0xfbe */
        {8,	0}, 	/* 0xfbf */
        {8,	0}, 	/* 0xfc0 */
        {8,	0}, 	/* 0xfc1 */
        {8,	0}, 	/* 0xfc2 */
        {8,	0}, 	/* 0xfc3 */
        {8,	0}, 	/* 0xfc4 */
        {8,	0}, 	/* 0xfc5 */
        {8,	0}, 	/* 0xfc6 */
        {8,	0}, 	/* 0xfc7 */
        {8,	0}, 	/* 0xfc8 */
        {8,	0}, 	/* 0xfc9 */
        {8,	0}, 	/* 0xfca */
        {8,	0}, 	/* 0xfcb */
        {8,	0}, 	/* 0xfcc */
        {8,	0}, 	/* 0xfcd */
        {8,	0}, 	/* 0xfce */
        {8,	0}, 	/* 0xfcf */
        {8,	0}, 	/* 0xfd0 */
        {8,	0}, 	/* 0xfd1 */
        {8,	0}, 	/* 0xfd2 */
        {8,	0}, 	/* 0xfd3 */
        {8,	0}, 	/* 0xfd4 */
        {8,	0}, 	/* 0xfd5 */
        {8,	0}, 	/* 0xfd6 */
        {8,	0}, 	/* 0xfd7 */
        {8,	0}, 	/* 0xfd8 */
        {8,	0}, 	/* 0xfd9 */
        {8,	0}, 	/* 0xfda */
        {8,	0}, 	/* 0xfdb */
        {8,	0}, 	/* 0xfdc */
        {8,	0}, 	/* 0xfdd */
        {8,	0}, 	/* 0xfde */
        {8,	0}, 	/* 0xfdf */
        {8,	0}, 	/* 0xfe0 */
        {8,	0}, 	/* 0xfe1 */
        {8,	0}, 	/* 0xfe2 */
        {8,	0}, 	/* 0xfe3 */
        {8,	0}, 	/* 0xfe4 */
        {8,	0}, 	/* 0xfe5 */
        {8,	0}, 	/* 0xfe6 */
        {8,	0}, 	/* 0xfe7 */
        {8,	0}, 	/* 0xfe8 */
        {8,	0}, 	/* 0xfe9 */
        {8,	0}, 	/* 0xfea */
        {8,	0}, 	/* 0xfeb */
        {8,	0}, 	/* 0xfec */
        {8,	0}, 	/* 0xfed */
        {8,	0}, 	/* 0xfee */
        {8,	0}, 	/* 0xfef */
        {8,	0}, 	/* 0xff0 */
        {8,	0}, 	/* 0xff1 */
        {8,	0}, 	/* 0xff2 */
        {8,	0}, 	/* 0xff3 */
        {8,	0}, 	/* 0xff4 */
        {8,	0}, 	/* 0xff5 */
        {8,	0}, 	/* 0xff6 */
        {8,	0}, 	/* 0xff7 */
        {8,	0}, 	/* 0xff8 */
        {8,	0}, 	/* 0xff9 */
        {8,	0}, 	/* 0xffa */
        {8,	0}, 	/* 0xffb */
        {8,	0}, 	/* 0xffc */
        {8,	0}, 	/* 0xffd */
        {8,	0}, 	/* 0xffe */
        {8,	0}, 	/* 0xfff */
        {8,	0}, 	/* 0x1000 */
        {8,	0}, 	/* 0x1001 */
        {8,	0}, 	/* 0x1002 */
        {8,	0}, 	/* 0x1003 */
        {8,	0}, 	/* 0x1004 */
        {8,	0}, 	/* 0x1005 */
        {8,	0}, 	/* 0x1006 */
        {8,	0}, 	/* 0x1007 */
        {8,	0}, 	/* 0x1008 */
        {8,	0}, 	/* 0x1009 */
        {8,	0}, 	/* 0x100a */
        {8,	0}, 	/* 0x100b */
        {8,	0}, 	/* 0x100c */
        {8,	0}, 	/* 0x100d */
        {8,	0}, 	/* 0x100e */
        {8,	0}, 	/* 0x100f */
        {8,	0}, 	/* 0x1010 */
        {8,	0}, 	/* 0x1011 */
        {8,	0}, 	/* 0x1012 */
        {8,	0}, 	/* 0x1013 */
        {8,	0}, 	/* 0x1014 */
        {8,	0}, 	/* 0x1015 */
        {8,	0}, 	/* 0x1016 */
        {8,	0}, 	/* 0x1017 */
        {8,	0}, 	/* 0x1018 */
        {8,	0}, 	/* 0x1019 */
        {8,	0}, 	/* 0x101a */
        {8,	0}, 	/* 0x101b */
        {8,	0}, 	/* 0x101c */
        {8,	0}, 	/* 0x101d */
        {8,	0}, 	/* 0x101e */
        {8,	0}, 	/* 0x101f */
        {8,	0}, 	/* 0x1020 */
        {8,	0}, 	/* 0x1021 */
        {8,	0}, 	/* 0x1022 */
        {8,	0}, 	/* 0x1023 */
        {8,	0}, 	/* 0x1024 */
        {8,	0}, 	/* 0x1025 */
        {8,	0}, 	/* 0x1026 */
        {8,	0}, 	/* 0x1027 */
        {8,	0}, 	/* 0x1028 */
        {8,	0}, 	/* 0x1029 */
        {8,	0}, 	/* 0x102a */
        {8,	0}, 	/* 0x102b */
        {8,	0}, 	/* 0x102c */
        {8,	0}, 	/* 0x102d */
        {8,	0}, 	/* 0x102e */
        {8,	0}, 	/* 0x102f */
        {8,	0}, 	/* 0x1030 */
        {8,	0}, 	/* 0x1031 */
        {8,	0}, 	/* 0x1032 */
        {8,	0}, 	/* 0x1033 */
        {8,	0}, 	/* 0x1034 */
        {8,	0}, 	/* 0x1035 */
        {8,	0}, 	/* 0x1036 */
        {8,	0}, 	/* 0x1037 */
        {8,	0}, 	/* 0x1038 */
        {8,	0}, 	/* 0x1039 */
        {8,	0}, 	/* 0x103a */
        {8,	0}, 	/* 0x103b */
        {8,	0}, 	/* 0x103c */
        {8,	0}, 	/* 0x103d */
        {8,	0}, 	/* 0x103e */
        {8,	0}, 	/* 0x103f */
        {8,	0}, 	/* 0x1040 */
        {8,	0}, 	/* 0x1041 */
        {8,	0}, 	/* 0x1042 */
        {8,	0}, 	/* 0x1043 */
        {8,	0}, 	/* 0x1044 */
        {8,	0}, 	/* 0x1045 */
        {8,	0}, 	/* 0x1046 */
        {8,	0}, 	/* 0x1047 */
        {8,	0}, 	/* 0x1048 */
        {8,	0}, 	/* 0x1049 */
        {8,	0}, 	/* 0x104a */
        {8,	0}, 	/* 0x104b */
        {8,	0}, 	/* 0x104c */
        {8,	0}, 	/* 0x104d */
        {8,	0}, 	/* 0x104e */
        {8,	0}, 	/* 0x104f */
        {8,	0}, 	/* 0x1050 */
        {8,	0}, 	/* 0x1051 */
        {8,	0}, 	/* 0x1052 */
        {8,	0}, 	/* 0x1053 */
        {8,	0}, 	/* 0x1054 */
        {8,	0}, 	/* 0x1055 */
        {8,	0}, 	/* 0x1056 */
        {8,	0}, 	/* 0x1057 */
        {8,	0}, 	/* 0x1058 */
        {8,	0}, 	/* 0x1059 */
        {8,	0}, 	/* 0x105a */
        {8,	0}, 	/* 0x105b */
        {8,	0}, 	/* 0x105c */
        {8,	0}, 	/* 0x105d */
        {8,	0}, 	/* 0x105e */
        {8,	0}, 	/* 0x105f */
        {8,	0}, 	/* 0x1060 */
        {8,	0}, 	/* 0x1061 */
        {8,	0}, 	/* 0x1062 */
        {8,	0}, 	/* 0x1063 */
        {8,	0}, 	/* 0x1064 */
        {8,	0}, 	/* 0x1065 */
        {8,	0}, 	/* 0x1066 */
        {8,	0}, 	/* 0x1067 */
        {8,	0}, 	/* 0x1068 */
        {8,	0}, 	/* 0x1069 */
        {8,	0}, 	/* 0x106a */
        {8,	0}, 	/* 0x106b */
        {8,	0}, 	/* 0x106c */
        {8,	0}, 	/* 0x106d */
        {8,	0}, 	/* 0x106e */
        {8,	0}, 	/* 0x106f */
        {8,	0}, 	/* 0x1070 */
        {8,	0}, 	/* 0x1071 */
        {8,	0}, 	/* 0x1072 */
        {8,	0}, 	/* 0x1073 */
        {8,	0}, 	/* 0x1074 */
        {8,	0}, 	/* 0x1075 */
        {8,	0}, 	/* 0x1076 */
        {8,	0}, 	/* 0x1077 */
        {8,	0}, 	/* 0x1078 */
        {8,	0}, 	/* 0x1079 */
        {8,	0}, 	/* 0x107a */
        {8,	0}, 	/* 0x107b */
        {8,	0}, 	/* 0x107c */
        {8,	0}, 	/* 0x107d */
        {8,	0}, 	/* 0x107e */
        {8,	0}, 	/* 0x107f */
        {8,	0}, 	/* 0x1080 */
        {8,	0}, 	/* 0x1081 */
        {8,	0}, 	/* 0x1082 */
        {8,	0}, 	/* 0x1083 */
        {8,	0}, 	/* 0x1084 */
        {8,	0}, 	/* 0x1085 */
        {8,	0}, 	/* 0x1086 */
        {8,	0}, 	/* 0x1087 */
        {8,	0}, 	/* 0x1088 */
        {8,	0}, 	/* 0x1089 */
        {8,	0}, 	/* 0x108a */
        {8,	0}, 	/* 0x108b */
        {8,	0}, 	/* 0x108c */
        {8,	0}, 	/* 0x108d */
        {8,	0}, 	/* 0x108e */
        {8,	0}, 	/* 0x108f */
        {8,	0}, 	/* 0x1090 */
        {8,	0}, 	/* 0x1091 */
        {8,	0}, 	/* 0x1092 */
        {8,	0}, 	/* 0x1093 */
        {8,	0}, 	/* 0x1094 */
        {8,	0}, 	/* 0x1095 */
        {8,	0}, 	/* 0x1096 */
        {8,	0}, 	/* 0x1097 */
        {8,	0}, 	/* 0x1098 */
        {8,	0}, 	/* 0x1099 */
        {8,	0}, 	/* 0x109a */
        {8,	0}, 	/* 0x109b */
        {8,	0}, 	/* 0x109c */
        {8,	0}, 	/* 0x109d */
        {8,	0}, 	/* 0x109e */
        {8,	0}, 	/* 0x109f */
        {8,	0}, 	/* 0x10a0 */
        {8,	0}, 	/* 0x10a1 */
        {8,	0}, 	/* 0x10a2 */
        {8,	0}, 	/* 0x10a3 */
        {8,	0}, 	/* 0x10a4 */
        {8,	0}, 	/* 0x10a5 */
        {8,	0}, 	/* 0x10a6 */
        {8,	0}, 	/* 0x10a7 */
        {8,	0}, 	/* 0x10a8 */
        {8,	0}, 	/* 0x10a9 */
        {8,	0}, 	/* 0x10aa */
        {8,	0}, 	/* 0x10ab */
        {8,	0}, 	/* 0x10ac */
        {8,	0}, 	/* 0x10ad */
        {8,	0}, 	/* 0x10ae */
        {8,	0}, 	/* 0x10af */
        {8,	0}, 	/* 0x10b0 */
        {8,	0}, 	/* 0x10b1 */
        {8,	0}, 	/* 0x10b2 */
        {8,	0}, 	/* 0x10b3 */
        {8,	0}, 	/* 0x10b4 */
        {8,	0}, 	/* 0x10b5 */
        {8,	0}, 	/* 0x10b6 */
        {8,	0}, 	/* 0x10b7 */
        {8,	0}, 	/* 0x10b8 */
        {8,	0}, 	/* 0x10b9 */
        {8,	0}, 	/* 0x10ba */
        {8,	0}, 	/* 0x10bb */
        {8,	0}, 	/* 0x10bc */
        {8,	0}, 	/* 0x10bd */
        {8,	0}, 	/* 0x10be */
        {8,	0}, 	/* 0x10bf */
        {8,	0}, 	/* 0x10c0 */
        {8,	0}, 	/* 0x10c1 */
        {8,	0}, 	/* 0x10c2 */
        {8,	0}, 	/* 0x10c3 */
        {8,	0}, 	/* 0x10c4 */
        {8,	0}, 	/* 0x10c5 */
        {8,	0}, 	/* 0x10c6 */
        {8,	0}, 	/* 0x10c7 */
        {8,	0}, 	/* 0x10c8 */
        {8,	0}, 	/* 0x10c9 */
        {8,	0}, 	/* 0x10ca */
        {8,	0}, 	/* 0x10cb */
        {8,	0}, 	/* 0x10cc */
        {8,	0}, 	/* 0x10cd */
        {8,	0}, 	/* 0x10ce */
        {8,	0}, 	/* 0x10cf */
        {8,	0}, 	/* 0x10d0 */
        {8,	0}, 	/* 0x10d1 */
        {8,	0}, 	/* 0x10d2 */
        {8,	0}, 	/* 0x10d3 */
        {8,	0}, 	/* 0x10d4 */
        {8,	0}, 	/* 0x10d5 */
        {8,	0}, 	/* 0x10d6 */
        {8,	0}, 	/* 0x10d7 */
        {8,	0}, 	/* 0x10d8 */
        {8,	0}, 	/* 0x10d9 */
        {8,	0}, 	/* 0x10da */
        {8,	0}, 	/* 0x10db */
        {8,	0}, 	/* 0x10dc */
        {8,	0}, 	/* 0x10dd */
        {8,	0}, 	/* 0x10de */
        {8,	0}, 	/* 0x10df */
        {8,	0}, 	/* 0x10e0 */
        {8,	0}, 	/* 0x10e1 */
        {8,	0}, 	/* 0x10e2 */
        {8,	0}, 	/* 0x10e3 */
        {8,	0}, 	/* 0x10e4 */
        {8,	0}, 	/* 0x10e5 */
        {8,	0}, 	/* 0x10e6 */
        {8,	0}, 	/* 0x10e7 */
        {8,	0}, 	/* 0x10e8 */
        {8,	0}, 	/* 0x10e9 */
        {8,	0}, 	/* 0x10ea */
        {8,	0}, 	/* 0x10eb */
        {8,	0}, 	/* 0x10ec */
        {8,	0}, 	/* 0x10ed */
        {8,	0}, 	/* 0x10ee */
        {8,	0}, 	/* 0x10ef */
        {8,	0}, 	/* 0x10f0 */
        {8,	0}, 	/* 0x10f1 */
        {8,	0}, 	/* 0x10f2 */
        {8,	0}, 	/* 0x10f3 */
        {8,	0}, 	/* 0x10f4 */
        {8,	0}, 	/* 0x10f5 */
        {8,	0}, 	/* 0x10f6 */
        {8,	0}, 	/* 0x10f7 */
        {8,	0}, 	/* 0x10f8 */
        {8,	0}, 	/* 0x10f9 */
        {8,	0}, 	/* 0x10fa */
        {8,	0}, 	/* 0x10fb */
        {8,	0}, 	/* 0x10fc */
        {8,	0}, 	/* 0x10fd */
        {8,	0}, 	/* 0x10fe */
        {8,	0}, 	/* 0x10ff */
        {8,	0}, 	/* 0x1100 */
        {8,	0}, 	/* 0x1101 */
        {8,	0}, 	/* 0x1102 */
        {8,	0}, 	/* 0x1103 */
        {8,	0}, 	/* 0x1104 */
        {8,	0}, 	/* 0x1105 */
        {8,	0}, 	/* 0x1106 */
        {8,	0}, 	/* 0x1107 */
        {8,	0}, 	/* 0x1108 */
        {8,	0}, 	/* 0x1109 */
        {8,	0}, 	/* 0x110a */
        {8,	0}, 	/* 0x110b */
        {8,	0}, 	/* 0x110c */
        {8,	0}, 	/* 0x110d */
        {8,	0}, 	/* 0x110e */
        {8,	0}, 	/* 0x110f */
        {8,	0}, 	/* 0x1110 */
        {8,	0}, 	/* 0x1111 */
        {8,	0}, 	/* 0x1112 */
        {8,	0}, 	/* 0x1113 */
        {8,	0}, 	/* 0x1114 */
        {8,	0}, 	/* 0x1115 */
        {8,	0}, 	/* 0x1116 */
        {8,	0}, 	/* 0x1117 */
        {8,	0}, 	/* 0x1118 */
        {8,	0}, 	/* 0x1119 */
        {8,	0}, 	/* 0x111a */
        {8,	0}, 	/* 0x111b */
        {8,	0}, 	/* 0x111c */
        {8,	0}, 	/* 0x111d */
        {8,	0}, 	/* 0x111e */
        {8,	0}, 	/* 0x111f */
        {8,	0}, 	/* 0x1120 */
        {8,	0}, 	/* 0x1121 */
        {8,	0}, 	/* 0x1122 */
        {8,	0}, 	/* 0x1123 */
        {8,	0}, 	/* 0x1124 */
        {8,	0}, 	/* 0x1125 */
        {8,	0}, 	/* 0x1126 */
        {8,	0}, 	/* 0x1127 */
        {8,	0}, 	/* 0x1128 */
        {8,	0}, 	/* 0x1129 */
        {8,	0}, 	/* 0x112a */
        {8,	0}, 	/* 0x112b */
        {8,	0}, 	/* 0x112c */
        {8,	0}, 	/* 0x112d */
        {8,	0}, 	/* 0x112e */
        {8,	0}, 	/* 0x112f */
        {8,	0}, 	/* 0x1130 */
        {8,	0}, 	/* 0x1131 */
        {8,	0}, 	/* 0x1132 */
        {8,	0}, 	/* 0x1133 */
        {8,	0}, 	/* 0x1134 */
        {8,	0}, 	/* 0x1135 */
        {8,	0}, 	/* 0x1136 */
        {8,	0}, 	/* 0x1137 */
        {8,	0}, 	/* 0x1138 */
        {8,	0}, 	/* 0x1139 */
        {8,	0}, 	/* 0x113a */
        {8,	0}, 	/* 0x113b */
        {8,	0}, 	/* 0x113c */
        {8,	0}, 	/* 0x113d */
        {8,	0}, 	/* 0x113e */
        {8,	0}, 	/* 0x113f */
        {8,	0}, 	/* 0x1140 */
        {8,	0}, 	/* 0x1141 */
        {8,	0}, 	/* 0x1142 */
        {8,	0}, 	/* 0x1143 */
        {8,	0}, 	/* 0x1144 */
        {8,	0}, 	/* 0x1145 */
        {8,	0}, 	/* 0x1146 */
        {8,	0}, 	/* 0x1147 */
        {8,	0}, 	/* 0x1148 */
        {8,	0}, 	/* 0x1149 */
        {8,	0}, 	/* 0x114a */
        {8,	0}, 	/* 0x114b */
        {8,	0}, 	/* 0x114c */
        {8,	0}, 	/* 0x114d */
        {8,	0}, 	/* 0x114e */
        {8,	0}, 	/* 0x114f */
        {8,	0}, 	/* 0x1150 */
        {8,	0}, 	/* 0x1151 */
        {8,	0}, 	/* 0x1152 */
        {8,	0}, 	/* 0x1153 */
        {8,	0}, 	/* 0x1154 */
        {8,	0}, 	/* 0x1155 */
        {8,	0}, 	/* 0x1156 */
        {8,	0}, 	/* 0x1157 */
        {8,	0}, 	/* 0x1158 */
        {8,	0}, 	/* 0x1159 */
        {8,	0}, 	/* 0x115a */
        {8,	0}, 	/* 0x115b */
        {8,	0}, 	/* 0x115c */
        {8,	0}, 	/* 0x115d */
        {8,	0}, 	/* 0x115e */
        {8,	0}, 	/* 0x115f */
        {8,	0}, 	/* 0x1160 */
        {8,	0}, 	/* 0x1161 */
        {8,	0}, 	/* 0x1162 */
        {8,	0}, 	/* 0x1163 */
        {8,	0}, 	/* 0x1164 */
        {8,	0}, 	/* 0x1165 */
        {8,	0}, 	/* 0x1166 */
        {8,	0}, 	/* 0x1167 */
        {8,	0}, 	/* 0x1168 */
        {8,	0}, 	/* 0x1169 */
        {8,	0}, 	/* 0x116a */
        {8,	0}, 	/* 0x116b */
        {8,	0}, 	/* 0x116c */
        {8,	0}, 	/* 0x116d */
        {8,	0}, 	/* 0x116e */
        {8,	0}, 	/* 0x116f */
        {8,	0}, 	/* 0x1170 */
        {8,	0}, 	/* 0x1171 */
        {8,	0}, 	/* 0x1172 */
        {8,	0}, 	/* 0x1173 */
        {8,	0}, 	/* 0x1174 */
        {8,	0}, 	/* 0x1175 */
        {8,	0}, 	/* 0x1176 */
        {8,	0}, 	/* 0x1177 */
        {8,	0}, 	/* 0x1178 */
        {8,	0}, 	/* 0x1179 */
        {8,	0}, 	/* 0x117a */
        {8,	0}, 	/* 0x117b */
        {8,	0}, 	/* 0x117c */
        {8,	0}, 	/* 0x117d */
        {8,	0}, 	/* 0x117e */
        {8,	0}, 	/* 0x117f */
        {8,	0}, 	/* 0x1180 */
        {8,	0}, 	/* 0x1181 */
        {8,	0}, 	/* 0x1182 */
        {8,	0}, 	/* 0x1183 */
        {8,	0}, 	/* 0x1184 */
        {8,	0}, 	/* 0x1185 */
        {8,	0}, 	/* 0x1186 */
        {8,	0}, 	/* 0x1187 */
        {8,	0}, 	/* 0x1188 */
        {8,	0}, 	/* 0x1189 */
        {8,	0}, 	/* 0x118a */
        {8,	0}, 	/* 0x118b */
        {8,	0}, 	/* 0x118c */
        {8,	0}, 	/* 0x118d */
        {8,	0}, 	/* 0x118e */
        {8,	0}, 	/* 0x118f */
        {8,	0}, 	/* 0x1190 */
        {8,	0}, 	/* 0x1191 */
        {8,	0}, 	/* 0x1192 */
        {8,	0}, 	/* 0x1193 */
        {8,	0}, 	/* 0x1194 */
        {8,	0}, 	/* 0x1195 */
        {8,	0}, 	/* 0x1196 */
        {8,	0}, 	/* 0x1197 */
        {8,	0}, 	/* 0x1198 */
        {8,	0}, 	/* 0x1199 */
        {8,	0}, 	/* 0x119a */
        {8,	0}, 	/* 0x119b */
        {8,	0}, 	/* 0x119c */
        {8,	0}, 	/* 0x119d */
        {8,	0}, 	/* 0x119e */
        {8,	0}, 	/* 0x119f */
        {8,	0}, 	/* 0x11a0 */
        {8,	0}, 	/* 0x11a1 */
        {8,	0}, 	/* 0x11a2 */
        {8,	0}, 	/* 0x11a3 */
        {8,	0}, 	/* 0x11a4 */
        {8,	0}, 	/* 0x11a5 */
        {8,	0}, 	/* 0x11a6 */
        {8,	0}, 	/* 0x11a7 */
        {8,	0}, 	/* 0x11a8 */
        {8,	0}, 	/* 0x11a9 */
        {8,	0}, 	/* 0x11aa */
        {8,	0}, 	/* 0x11ab */
        {8,	0}, 	/* 0x11ac */
        {8,	0}, 	/* 0x11ad */
        {8,	0}, 	/* 0x11ae */
        {8,	0}, 	/* 0x11af */
        {8,	0}, 	/* 0x11b0 */
        {8,	0}, 	/* 0x11b1 */
        {8,	0}, 	/* 0x11b2 */
        {8,	0}, 	/* 0x11b3 */
        {8,	0}, 	/* 0x11b4 */
        {8,	0}, 	/* 0x11b5 */
        {8,	0}, 	/* 0x11b6 */
        {8,	0}, 	/* 0x11b7 */
        {8,	0}, 	/* 0x11b8 */
        {8,	0}, 	/* 0x11b9 */
        {8,	0}, 	/* 0x11ba */
        {8,	0}, 	/* 0x11bb */
        {8,	0}, 	/* 0x11bc */
        {8,	0}, 	/* 0x11bd */
        {8,	0}, 	/* 0x11be */
        {8,	0}, 	/* 0x11bf */
        {8,	0}, 	/* 0x11c0 */
        {8,	0}, 	/* 0x11c1 */
        {8,	0}, 	/* 0x11c2 */
        {8,	0}, 	/* 0x11c3 */
        {8,	0}, 	/* 0x11c4 */
        {8,	0}, 	/* 0x11c5 */
        {8,	0}, 	/* 0x11c6 */
        {8,	0}, 	/* 0x11c7 */
        {8,	0}, 	/* 0x11c8 */
        {8,	0}, 	/* 0x11c9 */
        {8,	0}, 	/* 0x11ca */
        {8,	0}, 	/* 0x11cb */
        {8,	0}, 	/* 0x11cc */
        {8,	0}, 	/* 0x11cd */
        {8,	0}, 	/* 0x11ce */
        {8,	0}, 	/* 0x11cf */
        {8,	0}, 	/* 0x11d0 */
        {8,	0}, 	/* 0x11d1 */
        {8,	0}, 	/* 0x11d2 */
        {8,	0}, 	/* 0x11d3 */
        {8,	0}, 	/* 0x11d4 */
        {8,	0}, 	/* 0x11d5 */
        {8,	0}, 	/* 0x11d6 */
        {8,	0}, 	/* 0x11d7 */
        {8,	0}, 	/* 0x11d8 */
        {8,	0}, 	/* 0x11d9 */
        {8,	0}, 	/* 0x11da */
        {8,	0}, 	/* 0x11db */
        {8,	0}, 	/* 0x11dc */
        {8,	0}, 	/* 0x11dd */
        {8,	0}, 	/* 0x11de */
        {8,	0}, 	/* 0x11df */
        {8,	0}, 	/* 0x11e0 */
        {8,	0}, 	/* 0x11e1 */
        {8,	0}, 	/* 0x11e2 */
        {8,	0}, 	/* 0x11e3 */
        {8,	0}, 	/* 0x11e4 */
        {8,	0}, 	/* 0x11e5 */
        {8,	0}, 	/* 0x11e6 */
        {8,	0}, 	/* 0x11e7 */
        {8,	0}, 	/* 0x11e8 */
        {8,	0}, 	/* 0x11e9 */
        {8,	0}, 	/* 0x11ea */
        {8,	0}, 	/* 0x11eb */
        {8,	0}, 	/* 0x11ec */
        {8,	0}, 	/* 0x11ed */
        {8,	0}, 	/* 0x11ee */
        {8,	0}, 	/* 0x11ef */
        {8,	0}, 	/* 0x11f0 */
        {8,	0}, 	/* 0x11f1 */
        {8,	0}, 	/* 0x11f2 */
        {8,	0}, 	/* 0x11f3 */
        {8,	0}, 	/* 0x11f4 */
        {8,	0}, 	/* 0x11f5 */
        {8,	0}, 	/* 0x11f6 */
        {8,	0}, 	/* 0x11f7 */
        {8,	0}, 	/* 0x11f8 */
        {8,	0}, 	/* 0x11f9 */
        {8,	0}, 	/* 0x11fa */
        {8,	0}, 	/* 0x11fb */
        {8,	0}, 	/* 0x11fc */
        {8,	0}, 	/* 0x11fd */
        {8,	0}, 	/* 0x11fe */
        {8,	0}, 	/* 0x11ff */
        {8,	0}, 	/* 0x1200 */
        {8,	0}, 	/* 0x1201 */
        {8,	0}, 	/* 0x1202 */
        {8,	0}, 	/* 0x1203 */
        {8,	0}, 	/* 0x1204 */
        {8,	0}, 	/* 0x1205 */
        {8,	0}, 	/* 0x1206 */
        {8,	0}, 	/* 0x1207 */
        {8,	0}, 	/* 0x1208 */
        {8,	0}, 	/* 0x1209 */
        {8,	0}, 	/* 0x120a */
        {8,	0}, 	/* 0x120b */
        {8,	0}, 	/* 0x120c */
        {8,	0}, 	/* 0x120d */
        {8,	0}, 	/* 0x120e */
        {8,	0}, 	/* 0x120f */
        {8,	0}, 	/* 0x1210 */
        {8,	0}, 	/* 0x1211 */
        {8,	0}, 	/* 0x1212 */
        {8,	0}, 	/* 0x1213 */
        {8,	0}, 	/* 0x1214 */
        {8,	0}, 	/* 0x1215 */
        {8,	0}, 	/* 0x1216 */
        {8,	0}, 	/* 0x1217 */
        {8,	0}, 	/* 0x1218 */
        {8,	0}, 	/* 0x1219 */
        {8,	0}, 	/* 0x121a */
        {8,	0}, 	/* 0x121b */
        {8,	0}, 	/* 0x121c */
        {8,	0}, 	/* 0x121d */
        {8,	0}, 	/* 0x121e */
        {8,	0}, 	/* 0x121f */
        {8,	0}, 	/* 0x1220 */
        {8,	0}, 	/* 0x1221 */
        {8,	0}, 	/* 0x1222 */
        {8,	0}, 	/* 0x1223 */
        {8,	0}, 	/* 0x1224 */
        {8,	0}, 	/* 0x1225 */
        {8,	0}, 	/* 0x1226 */
        {8,	0}, 	/* 0x1227 */
        {8,	0}, 	/* 0x1228 */
        {8,	0}, 	/* 0x1229 */
        {8,	0}, 	/* 0x122a */
        {8,	0}, 	/* 0x122b */
        {8,	0}, 	/* 0x122c */
        {8,	0}, 	/* 0x122d */
        {8,	0}, 	/* 0x122e */
        {8,	0}, 	/* 0x122f */
        {8,	0}, 	/* 0x1230 */
        {8,	0}, 	/* 0x1231 */
        {8,	0}, 	/* 0x1232 */
        {8,	0}, 	/* 0x1233 */
        {8,	0}, 	/* 0x1234 */
        {8,	0}, 	/* 0x1235 */
        {8,	0}, 	/* 0x1236 */
        {8,	0}, 	/* 0x1237 */
        {8,	0}, 	/* 0x1238 */
        {8,	0}, 	/* 0x1239 */
        {8,	0}, 	/* 0x123a */
        {8,	0}, 	/* 0x123b */
        {8,	0}, 	/* 0x123c */
        {8,	0}, 	/* 0x123d */
        {8,	0}, 	/* 0x123e */
        {8,	0}, 	/* 0x123f */
        {8,	0}, 	/* 0x1240 */
        {8,	0}, 	/* 0x1241 */
        {8,	0}, 	/* 0x1242 */
        {8,	0}, 	/* 0x1243 */
        {8,	0}, 	/* 0x1244 */
        {8,	0}, 	/* 0x1245 */
        {8,	0}, 	/* 0x1246 */
        {8,	0}, 	/* 0x1247 */
        {8,	0}, 	/* 0x1248 */
        {8,	0}, 	/* 0x1249 */
        {8,	0}, 	/* 0x124a */
        {8,	0}, 	/* 0x124b */
        {8,	0}, 	/* 0x124c */
        {8,	0}, 	/* 0x124d */
        {8,	0}, 	/* 0x124e */
        {8,	0}, 	/* 0x124f */
        {8,	0}, 	/* 0x1250 */
        {8,	0}, 	/* 0x1251 */
        {8,	0}, 	/* 0x1252 */
        {8,	0}, 	/* 0x1253 */
        {8,	0}, 	/* 0x1254 */
        {8,	0}, 	/* 0x1255 */
        {8,	0}, 	/* 0x1256 */
        {8,	0}, 	/* 0x1257 */
        {8,	0}, 	/* 0x1258 */
        {8,	0}, 	/* 0x1259 */
        {8,	0}, 	/* 0x125a */
        {8,	0}, 	/* 0x125b */
        {8,	0}, 	/* 0x125c */
        {8,	0}, 	/* 0x125d */
        {8,	0}, 	/* 0x125e */
        {8,	0}, 	/* 0x125f */
        {8,	0}, 	/* 0x1260 */
        {8,	0}, 	/* 0x1261 */
        {8,	0}, 	/* 0x1262 */
        {8,	0}, 	/* 0x1263 */
        {8,	0}, 	/* 0x1264 */
        {8,	0}, 	/* 0x1265 */
        {8,	0}, 	/* 0x1266 */
        {8,	0}, 	/* 0x1267 */
        {8,	0}, 	/* 0x1268 */
        {8,	0}, 	/* 0x1269 */
        {8,	0}, 	/* 0x126a */
        {8,	0}, 	/* 0x126b */
        {8,	0}, 	/* 0x126c */
        {8,	0}, 	/* 0x126d */
        {8,	0}, 	/* 0x126e */
        {8,	0}, 	/* 0x126f */
        {8,	0}, 	/* 0x1270 */
        {8,	0}, 	/* 0x1271 */
        {8,	0}, 	/* 0x1272 */
        {8,	0}, 	/* 0x1273 */
        {8,	0}, 	/* 0x1274 */
        {8,	0}, 	/* 0x1275 */
        {8,	0}, 	/* 0x1276 */
        {8,	0}, 	/* 0x1277 */
        {8,	0}, 	/* 0x1278 */
        {8,	0}, 	/* 0x1279 */
        {8,	0}, 	/* 0x127a */
        {8,	0}, 	/* 0x127b */
        {8,	0}, 	/* 0x127c */
        {8,	0}, 	/* 0x127d */
        {8,	0}, 	/* 0x127e */
        {8,	0}, 	/* 0x127f */
        {8,	0}, 	/* 0x1280 */
        {8,	0}, 	/* 0x1281 */
        {8,	0}, 	/* 0x1282 */
        {8,	0}, 	/* 0x1283 */
        {8,	0}, 	/* 0x1284 */
        {8,	0}, 	/* 0x1285 */
        {8,	0}, 	/* 0x1286 */
        {8,	0}, 	/* 0x1287 */
        {8,	0}, 	/* 0x1288 */
        {8,	0}, 	/* 0x1289 */
        {8,	0}, 	/* 0x128a */
        {8,	0}, 	/* 0x128b */
        {8,	0}, 	/* 0x128c */
        {8,	0}, 	/* 0x128d */
        {8,	0}, 	/* 0x128e */
        {8,	0}, 	/* 0x128f */
        {8,	0}, 	/* 0x1290 */
        {8,	0}, 	/* 0x1291 */
        {8,	0}, 	/* 0x1292 */
        {8,	0}, 	/* 0x1293 */
        {8,	0}, 	/* 0x1294 */
        {8,	0}, 	/* 0x1295 */
        {8,	0}, 	/* 0x1296 */
        {8,	0}, 	/* 0x1297 */
        {8,	0}, 	/* 0x1298 */
        {8,	0}, 	/* 0x1299 */
        {8,	0}, 	/* 0x129a */
        {8,	0}, 	/* 0x129b */
        {8,	0}, 	/* 0x129c */
        {8,	0}, 	/* 0x129d */
        {8,	0}, 	/* 0x129e */
        {8,	0}, 	/* 0x129f */
        {8,	0}, 	/* 0x12a0 */
        {8,	0}, 	/* 0x12a1 */
        {8,	0}, 	/* 0x12a2 */
        {8,	0}, 	/* 0x12a3 */
        {8,	0}, 	/* 0x12a4 */
        {8,	0}, 	/* 0x12a5 */
        {8,	0}, 	/* 0x12a6 */
        {8,	0}, 	/* 0x12a7 */
        {8,	0}, 	/* 0x12a8 */
        {8,	0}, 	/* 0x12a9 */
        {8,	0}, 	/* 0x12aa */
        {8,	0}, 	/* 0x12ab */
        {8,	0}, 	/* 0x12ac */
        {8,	0}, 	/* 0x12ad */
        {8,	0}, 	/* 0x12ae */
        {8,	0}, 	/* 0x12af */
        {8,	0}, 	/* 0x12b0 */
        {8,	0}, 	/* 0x12b1 */
        {8,	0}, 	/* 0x12b2 */
        {8,	0}, 	/* 0x12b3 */
        {8,	0}, 	/* 0x12b4 */
        {8,	0}, 	/* 0x12b5 */
        {8,	0}, 	/* 0x12b6 */
        {8,	0}, 	/* 0x12b7 */
        {8,	0}, 	/* 0x12b8 */
        {8,	0}, 	/* 0x12b9 */
        {8,	0}, 	/* 0x12ba */
        {8,	0}, 	/* 0x12bb */
        {8,	0}, 	/* 0x12bc */
        {8,	0}, 	/* 0x12bd */
        {8,	0}, 	/* 0x12be */
        {8,	0}, 	/* 0x12bf */
        {8,	0}, 	/* 0x12c0 */
        {8,	0}, 	/* 0x12c1 */
        {8,	0}, 	/* 0x12c2 */
        {8,	0}, 	/* 0x12c3 */
        {8,	0}, 	/* 0x12c4 */
        {8,	0}, 	/* 0x12c5 */
        {8,	0}, 	/* 0x12c6 */
        {8,	0}, 	/* 0x12c7 */
        {8,	0}, 	/* 0x12c8 */
        {8,	0}, 	/* 0x12c9 */
        {8,	0}, 	/* 0x12ca */
        {8,	0}, 	/* 0x12cb */
        {8,	0}, 	/* 0x12cc */
        {8,	0}, 	/* 0x12cd */
        {8,	0}, 	/* 0x12ce */
        {8,	0}, 	/* 0x12cf */
        {8,	0}, 	/* 0x12d0 */
        {8,	0}, 	/* 0x12d1 */
        {8,	0}, 	/* 0x12d2 */
        {8,	0}, 	/* 0x12d3 */
        {8,	0}, 	/* 0x12d4 */
        {8,	0}, 	/* 0x12d5 */
        {8,	0}, 	/* 0x12d6 */
        {8,	0}, 	/* 0x12d7 */
        {8,	0}, 	/* 0x12d8 */
        {8,	0}, 	/* 0x12d9 */
        {8,	0}, 	/* 0x12da */
        {8,	0}, 	/* 0x12db */
        {8,	0}, 	/* 0x12dc */
        {8,	0}, 	/* 0x12dd */
        {8,	0}, 	/* 0x12de */
        {8,	0}, 	/* 0x12df */
        {8,	0}, 	/* 0x12e0 */
        {8,	0}, 	/* 0x12e1 */
        {8,	0}, 	/* 0x12e2 */
        {8,	0}, 	/* 0x12e3 */
        {8,	0}, 	/* 0x12e4 */
        {8,	0}, 	/* 0x12e5 */
        {8,	0}, 	/* 0x12e6 */
        {8,	0}, 	/* 0x12e7 */
        {8,	0}, 	/* 0x12e8 */
        {8,	0}, 	/* 0x12e9 */
        {8,	0}, 	/* 0x12ea */
        {8,	0}, 	/* 0x12eb */
        {8,	0}, 	/* 0x12ec */
        {8,	0}, 	/* 0x12ed */
        {8,	0}, 	/* 0x12ee */
        {8,	0}, 	/* 0x12ef */
        {8,	0}, 	/* 0x12f0 */
        {8,	0}, 	/* 0x12f1 */
        {8,	0}, 	/* 0x12f2 */
        {8,	0}, 	/* 0x12f3 */
        {8,	0}, 	/* 0x12f4 */
        {8,	0}, 	/* 0x12f5 */
        {8,	0}, 	/* 0x12f6 */
        {8,	0}, 	/* 0x12f7 */
        {8,	0}, 	/* 0x12f8 */
        {8,	0}, 	/* 0x12f9 */
        {8,	0}, 	/* 0x12fa */
        {8,	0}, 	/* 0x12fb */
        {8,	0}, 	/* 0x12fc */
        {8,	0}, 	/* 0x12fd */
        {8,	0}, 	/* 0x12fe */
        {8,	0}, 	/* 0x12ff */
        {8,	0}, 	/* 0x1300 */
        {8,	0}, 	/* 0x1301 */
        {8,	0}, 	/* 0x1302 */
        {8,	0}, 	/* 0x1303 */
        {8,	0}, 	/* 0x1304 */
        {8,	0}, 	/* 0x1305 */
        {8,	0}, 	/* 0x1306 */
        {8,	0}, 	/* 0x1307 */
        {8,	0}, 	/* 0x1308 */
        {8,	0}, 	/* 0x1309 */
        {8,	0}, 	/* 0x130a */
        {8,	0}, 	/* 0x130b */
        {8,	0}, 	/* 0x130c */
        {8,	0}, 	/* 0x130d */
        {8,	0}, 	/* 0x130e */
        {8,	0}, 	/* 0x130f */
        {8,	0}, 	/* 0x1310 */
        {8,	0}, 	/* 0x1311 */
        {8,	0}, 	/* 0x1312 */
        {8,	0}, 	/* 0x1313 */
        {8,	0}, 	/* 0x1314 */
        {8,	0}, 	/* 0x1315 */
        {8,	0}, 	/* 0x1316 */
        {8,	0}, 	/* 0x1317 */
        {8,	0}, 	/* 0x1318 */
        {8,	0}, 	/* 0x1319 */
        {8,	0}, 	/* 0x131a */
        {8,	0}, 	/* 0x131b */
        {8,	0}, 	/* 0x131c */
        {8,	0}, 	/* 0x131d */
        {8,	0}, 	/* 0x131e */
        {8,	0}, 	/* 0x131f */
        {8,	0}, 	/* 0x1320 */
        {8,	0}, 	/* 0x1321 */
        {8,	0}, 	/* 0x1322 */
        {8,	0}, 	/* 0x1323 */
        {8,	0}, 	/* 0x1324 */
        {8,	0}, 	/* 0x1325 */
        {8,	0}, 	/* 0x1326 */
        {8,	0}, 	/* 0x1327 */
        {8,	0}, 	/* 0x1328 */
        {8,	0}, 	/* 0x1329 */
        {8,	0}, 	/* 0x132a */
        {8,	0}, 	/* 0x132b */
        {8,	0}, 	/* 0x132c */
        {8,	0}, 	/* 0x132d */
        {8,	0}, 	/* 0x132e */
        {8,	0}, 	/* 0x132f */
        {8,	0}, 	/* 0x1330 */
        {8,	0}, 	/* 0x1331 */
        {8,	0}, 	/* 0x1332 */
        {8,	0}, 	/* 0x1333 */
        {8,	0}, 	/* 0x1334 */
        {8,	0}, 	/* 0x1335 */
        {8,	0}, 	/* 0x1336 */
        {8,	0}, 	/* 0x1337 */
        {8,	0}, 	/* 0x1338 */
        {8,	0}, 	/* 0x1339 */
        {8,	0}, 	/* 0x133a */
        {8,	0}, 	/* 0x133b */
        {8,	0}, 	/* 0x133c */
        {8,	0}, 	/* 0x133d */
        {8,	0}, 	/* 0x133e */
        {8,	0}, 	/* 0x133f */
        {8,	0}, 	/* 0x1340 */
        {8,	0}, 	/* 0x1341 */
        {8,	0}, 	/* 0x1342 */
        {8,	0}, 	/* 0x1343 */
        {8,	0}, 	/* 0x1344 */
        {8,	0}, 	/* 0x1345 */
        {8,	0}, 	/* 0x1346 */
        {8,	0}, 	/* 0x1347 */
        {8,	0}, 	/* 0x1348 */
        {8,	0}, 	/* 0x1349 */
        {8,	0}, 	/* 0x134a */
        {8,	0}, 	/* 0x134b */
        {8,	0}, 	/* 0x134c */
        {8,	0}, 	/* 0x134d */
        {8,	0}, 	/* 0x134e */
        {8,	0}, 	/* 0x134f */
        {8,	0}, 	/* 0x1350 */
        {8,	0}, 	/* 0x1351 */
        {8,	0}, 	/* 0x1352 */
        {8,	0}, 	/* 0x1353 */
        {8,	0}, 	/* 0x1354 */
        {8,	0}, 	/* 0x1355 */
        {8,	0}, 	/* 0x1356 */
        {8,	0}, 	/* 0x1357 */
        {8,	0}, 	/* 0x1358 */
        {8,	0}, 	/* 0x1359 */
        {8,	0}, 	/* 0x135a */
        {8,	0}, 	/* 0x135b */
        {8,	0}, 	/* 0x135c */
        {8,	0}, 	/* 0x135d */
        {8,	0}, 	/* 0x135e */
        {8,	0}, 	/* 0x135f */
        {8,	0}, 	/* 0x1360 */
        {8,	0}, 	/* 0x1361 */
        {8,	0}, 	/* 0x1362 */
        {8,	0}, 	/* 0x1363 */
        {8,	0}, 	/* 0x1364 */
        {8,	0}, 	/* 0x1365 */
        {8,	0}, 	/* 0x1366 */
        {8,	0}, 	/* 0x1367 */
        {8,	0}, 	/* 0x1368 */
        {8,	0}, 	/* 0x1369 */
        {8,	0}, 	/* 0x136a */
        {8,	0}, 	/* 0x136b */
        {8,	0}, 	/* 0x136c */
        {8,	0}, 	/* 0x136d */
        {8,	0}, 	/* 0x136e */
        {8,	0}, 	/* 0x136f */
        {8,	0}, 	/* 0x1370 */
        {8,	0}, 	/* 0x1371 */
        {8,	0}, 	/* 0x1372 */
        {8,	0}, 	/* 0x1373 */
        {8,	0}, 	/* 0x1374 */
        {8,	0}, 	/* 0x1375 */
        {8,	0}, 	/* 0x1376 */
        {8,	0}, 	/* 0x1377 */
        {8,	0}, 	/* 0x1378 */
        {8,	0}, 	/* 0x1379 */
        {8,	0}, 	/* 0x137a */
        {8,	0}, 	/* 0x137b */
        {8,	0}, 	/* 0x137c */
        {8,	0}, 	/* 0x137d */
        {8,	0}, 	/* 0x137e */
        {8,	0}, 	/* 0x137f */
        {8,	0}, 	/* 0x1380 */
        {8,	0}, 	/* 0x1381 */
        {8,	0}, 	/* 0x1382 */
        {8,	0}, 	/* 0x1383 */
        {8,	0}, 	/* 0x1384 */
        {8,	0}, 	/* 0x1385 */
        {8,	0}, 	/* 0x1386 */
        {8,	0}, 	/* 0x1387 */
        {8,	0}, 	/* 0x1388 */
        {8,	0}, 	/* 0x1389 */
        {8,	0}, 	/* 0x138a */
        {8,	0}, 	/* 0x138b */
        {8,	0}, 	/* 0x138c */
        {8,	0}, 	/* 0x138d */
        {8,	0}, 	/* 0x138e */
        {8,	0}, 	/* 0x138f */
        {8,	0}, 	/* 0x1390 */
        {8,	0}, 	/* 0x1391 */
        {8,	0}, 	/* 0x1392 */
        {8,	0}, 	/* 0x1393 */
        {8,	0}, 	/* 0x1394 */
        {8,	0}, 	/* 0x1395 */
        {8,	0}, 	/* 0x1396 */
        {8,	0}, 	/* 0x1397 */
        {8,	0}, 	/* 0x1398 */
        {8,	0}, 	/* 0x1399 */
        {8,	0}, 	/* 0x139a */
        {8,	0}, 	/* 0x139b */
        {8,	0}, 	/* 0x139c */
        {8,	0}, 	/* 0x139d */
        {8,	0}, 	/* 0x139e */
        {8,	0}, 	/* 0x139f */
        {8,	0}, 	/* 0x13a0 */
        {8,	0}, 	/* 0x13a1 */
        {8,	0}, 	/* 0x13a2 */
        {8,	0}, 	/* 0x13a3 */
        {8,	0}, 	/* 0x13a4 */
        {8,	0}, 	/* 0x13a5 */
        {8,	0}, 	/* 0x13a6 */
        {8,	0}, 	/* 0x13a7 */
        {8,	0}, 	/* 0x13a8 */
        {8,	0}, 	/* 0x13a9 */
        {8,	0}, 	/* 0x13aa */
        {8,	0}, 	/* 0x13ab */
        {8,	0}, 	/* 0x13ac */
        {8,	0}, 	/* 0x13ad */
        {8,	0}, 	/* 0x13ae */
        {8,	0}, 	/* 0x13af */
        {8,	0}, 	/* 0x13b0 */
        {8,	0}, 	/* 0x13b1 */
        {8,	0}, 	/* 0x13b2 */
        {8,	0}, 	/* 0x13b3 */
        {8,	0}, 	/* 0x13b4 */
        {8,	0}, 	/* 0x13b5 */
        {8,	0}, 	/* 0x13b6 */
        {8,	0}, 	/* 0x13b7 */
        {8,	0}, 	/* 0x13b8 */
        {8,	0}, 	/* 0x13b9 */
        {8,	0}, 	/* 0x13ba */
        {8,	0}, 	/* 0x13bb */
        {8,	0}, 	/* 0x13bc */
        {8,	0}, 	/* 0x13bd */
        {8,	0}, 	/* 0x13be */
        {8,	0}, 	/* 0x13bf */
        {8,	0}, 	/* 0x13c0 */
        {8,	0}, 	/* 0x13c1 */
        {8,	0}, 	/* 0x13c2 */
        {8,	0}, 	/* 0x13c3 */
        {8,	0}, 	/* 0x13c4 */
        {8,	0}, 	/* 0x13c5 */
        {8,	0}, 	/* 0x13c6 */
        {8,	0}, 	/* 0x13c7 */
        {8,	0}, 	/* 0x13c8 */
        {8,	0}, 	/* 0x13c9 */
        {8,	0}, 	/* 0x13ca */
        {8,	0}, 	/* 0x13cb */
        {8,	0}, 	/* 0x13cc */
        {8,	0}, 	/* 0x13cd */
        {8,	0}, 	/* 0x13ce */
        {8,	0}, 	/* 0x13cf */
        {8,	0}, 	/* 0x13d0 */
        {8,	0}, 	/* 0x13d1 */
        {8,	0}, 	/* 0x13d2 */
        {8,	0}, 	/* 0x13d3 */
        {8,	0}, 	/* 0x13d4 */
        {8,	0}, 	/* 0x13d5 */
        {8,	0}, 	/* 0x13d6 */
        {8,	0}, 	/* 0x13d7 */
        {8,	0}, 	/* 0x13d8 */
        {8,	0}, 	/* 0x13d9 */
        {8,	0}, 	/* 0x13da */
        {8,	0}, 	/* 0x13db */
        {8,	0}, 	/* 0x13dc */
        {8,	0}, 	/* 0x13dd */
        {8,	0}, 	/* 0x13de */
        {8,	0}, 	/* 0x13df */
        {8,	0}, 	/* 0x13e0 */
        {8,	0}, 	/* 0x13e1 */
        {8,	0}, 	/* 0x13e2 */
        {8,	0}, 	/* 0x13e3 */
        {8,	0}, 	/* 0x13e4 */
        {8,	0}, 	/* 0x13e5 */
        {8,	0}, 	/* 0x13e6 */
        {8,	0}, 	/* 0x13e7 */
        {8,	0}, 	/* 0x13e8 */
        {8,	0}, 	/* 0x13e9 */
        {8,	0}, 	/* 0x13ea */
        {8,	0}, 	/* 0x13eb */
        {8,	0}, 	/* 0x13ec */
        {8,	0}, 	/* 0x13ed */
        {8,	0}, 	/* 0x13ee */
        {8,	0}, 	/* 0x13ef */
        {8,	0}, 	/* 0x13f0 */
        {8,	0}, 	/* 0x13f1 */
        {8,	0}, 	/* 0x13f2 */
        {8,	0}, 	/* 0x13f3 */
        {8,	0}, 	/* 0x13f4 */
        {8,	0}, 	/* 0x13f5 */
        {8,	0}, 	/* 0x13f6 */
        {8,	0}, 	/* 0x13f7 */
        {8,	0}, 	/* 0x13f8 */
        {8,	0}, 	/* 0x13f9 */
        {8,	0}, 	/* 0x13fa */
        {8,	0}, 	/* 0x13fb */
        {8,	0}, 	/* 0x13fc */
        {8,	0}, 	/* 0x13fd */
        {8,	0}, 	/* 0x13fe */
        {8,	0}, 	/* 0x13ff */
        {8,	0}, 	/* 0x1400 */
        {8,	0}, 	/* 0x1401 */
        {8,	0}, 	/* 0x1402 */
        {8,	0}, 	/* 0x1403 */
        {8,	0}, 	/* 0x1404 */
        {8,	0}, 	/* 0x1405 */
        {8,	0}, 	/* 0x1406 */
        {8,	0}, 	/* 0x1407 */
        {8,	0}, 	/* 0x1408 */
        {8,	0}, 	/* 0x1409 */
        {8,	0}, 	/* 0x140a */
        {8,	0}, 	/* 0x140b */
        {8,	0}, 	/* 0x140c */
        {8,	0}, 	/* 0x140d */
        {8,	0}, 	/* 0x140e */
        {8,	0}, 	/* 0x140f */
        {8,	0}, 	/* 0x1410 */
        {8,	0}, 	/* 0x1411 */
        {8,	0}, 	/* 0x1412 */
        {8,	0}, 	/* 0x1413 */
        {8,	0}, 	/* 0x1414 */
        {8,	0}, 	/* 0x1415 */
        {8,	0}, 	/* 0x1416 */
        {8,	0}, 	/* 0x1417 */
        {8,	0}, 	/* 0x1418 */
        {8,	0}, 	/* 0x1419 */
        {8,	0}, 	/* 0x141a */
        {8,	0}, 	/* 0x141b */
        {8,	0}, 	/* 0x141c */
        {8,	0}, 	/* 0x141d */
        {8,	0}, 	/* 0x141e */
        {8,	0}, 	/* 0x141f */
        {8,	0}, 	/* 0x1420 */
        {8,	0}, 	/* 0x1421 */
        {8,	0}, 	/* 0x1422 */
        {8,	0}, 	/* 0x1423 */
        {8,	0}, 	/* 0x1424 */
        {8,	0}, 	/* 0x1425 */
        {8,	0}, 	/* 0x1426 */
        {8,	0}, 	/* 0x1427 */
        {8,	0}, 	/* 0x1428 */
        {8,	0}, 	/* 0x1429 */
        {8,	0}, 	/* 0x142a */
        {8,	0}, 	/* 0x142b */
        {8,	0}, 	/* 0x142c */
        {8,	0}, 	/* 0x142d */
        {8,	0}, 	/* 0x142e */
        {8,	0}, 	/* 0x142f */
        {8,	0}, 	/* 0x1430 */
        {8,	0}, 	/* 0x1431 */
        {8,	0}, 	/* 0x1432 */
        {8,	0}, 	/* 0x1433 */
        {8,	0}, 	/* 0x1434 */
        {8,	0}, 	/* 0x1435 */
        {8,	0}, 	/* 0x1436 */
        {8,	0}, 	/* 0x1437 */
        {8,	0}, 	/* 0x1438 */
        {8,	0}, 	/* 0x1439 */
        {8,	0}, 	/* 0x143a */
        {8,	0}, 	/* 0x143b */
        {8,	0}, 	/* 0x143c */
        {8,	0}, 	/* 0x143d */
        {8,	0}, 	/* 0x143e */
        {8,	0}, 	/* 0x143f */
        {8,	0}, 	/* 0x1440 */
        {8,	0}, 	/* 0x1441 */
        {8,	0}, 	/* 0x1442 */
        {8,	0}, 	/* 0x1443 */
        {8,	0}, 	/* 0x1444 */
        {8,	0}, 	/* 0x1445 */
        {8,	0}, 	/* 0x1446 */
        {8,	0}, 	/* 0x1447 */
        {8,	0}, 	/* 0x1448 */
        {8,	0}, 	/* 0x1449 */
        {8,	0}, 	/* 0x144a */
        {8,	0}, 	/* 0x144b */
        {8,	0}, 	/* 0x144c */
        {8,	0}, 	/* 0x144d */
        {8,	0}, 	/* 0x144e */
        {8,	0}, 	/* 0x144f */
        {8,	0}, 	/* 0x1450 */
        {8,	0}, 	/* 0x1451 */
        {8,	0}, 	/* 0x1452 */
        {8,	0}, 	/* 0x1453 */
        {8,	0}, 	/* 0x1454 */
        {8,	0}, 	/* 0x1455 */
        {8,	0}, 	/* 0x1456 */
        {8,	0}, 	/* 0x1457 */
        {8,	0}, 	/* 0x1458 */
        {8,	0}, 	/* 0x1459 */
        {8,	0}, 	/* 0x145a */
        {8,	0}, 	/* 0x145b */
        {8,	0}, 	/* 0x145c */
        {8,	0}, 	/* 0x145d */
        {8,	0}, 	/* 0x145e */
        {8,	0}, 	/* 0x145f */
        {8,	0}, 	/* 0x1460 */
        {8,	0}, 	/* 0x1461 */
        {8,	0}, 	/* 0x1462 */
        {8,	0}, 	/* 0x1463 */
        {8,	0}, 	/* 0x1464 */
        {8,	0}, 	/* 0x1465 */
        {8,	0}, 	/* 0x1466 */
        {8,	0}, 	/* 0x1467 */
        {8,	0}, 	/* 0x1468 */
        {8,	0}, 	/* 0x1469 */
        {8,	0}, 	/* 0x146a */
        {8,	0}, 	/* 0x146b */
        {8,	0}, 	/* 0x146c */
        {8,	0}, 	/* 0x146d */
        {8,	0}, 	/* 0x146e */
        {8,	0}, 	/* 0x146f */
        {8,	0}, 	/* 0x1470 */
        {8,	0}, 	/* 0x1471 */
        {8,	0}, 	/* 0x1472 */
        {8,	0}, 	/* 0x1473 */
        {8,	0}, 	/* 0x1474 */
        {8,	0}, 	/* 0x1475 */
        {8,	0}, 	/* 0x1476 */
        {8,	0}, 	/* 0x1477 */
        {8,	0}, 	/* 0x1478 */
        {8,	0}, 	/* 0x1479 */
        {8,	0}, 	/* 0x147a */
        {8,	0}, 	/* 0x147b */
        {8,	0}, 	/* 0x147c */
        {8,	0}, 	/* 0x147d */
        {8,	0}, 	/* 0x147e */
        {8,	0}, 	/* 0x147f */
        {8,	0}, 	/* 0x1480 */
        {8,	0}, 	/* 0x1481 */
        {8,	0}, 	/* 0x1482 */
        {8,	0}, 	/* 0x1483 */
        {8,	0}, 	/* 0x1484 */
        {8,	0}, 	/* 0x1485 */
        {8,	0}, 	/* 0x1486 */
        {8,	0}, 	/* 0x1487 */
        {8,	0}, 	/* 0x1488 */
        {8,	0}, 	/* 0x1489 */
        {8,	0}, 	/* 0x148a */
        {8,	0}, 	/* 0x148b */
        {8,	0}, 	/* 0x148c */
        {8,	0}, 	/* 0x148d */
        {8,	0}, 	/* 0x148e */
        {8,	0}, 	/* 0x148f */
        {8,	0}, 	/* 0x1490 */
        {8,	0}, 	/* 0x1491 */
        {8,	0}, 	/* 0x1492 */
        {8,	0}, 	/* 0x1493 */
        {8,	0}, 	/* 0x1494 */
        {8,	0}, 	/* 0x1495 */
        {8,	0}, 	/* 0x1496 */
        {8,	0}, 	/* 0x1497 */
        {8,	0}, 	/* 0x1498 */
        {8,	0}, 	/* 0x1499 */
        {8,	0}, 	/* 0x149a */
        {8,	0}, 	/* 0x149b */
        {8,	0}, 	/* 0x149c */
        {8,	0}, 	/* 0x149d */
        {8,	0}, 	/* 0x149e */
        {8,	0}, 	/* 0x149f */
        {8,	0}, 	/* 0x14a0 */
        {8,	0}, 	/* 0x14a1 */
        {8,	0}, 	/* 0x14a2 */
        {8,	0}, 	/* 0x14a3 */
        {8,	0}, 	/* 0x14a4 */
        {8,	0}, 	/* 0x14a5 */
        {8,	0}, 	/* 0x14a6 */
        {8,	0}, 	/* 0x14a7 */
        {8,	0}, 	/* 0x14a8 */
        {8,	0}, 	/* 0x14a9 */
        {8,	0}, 	/* 0x14aa */
        {8,	0}, 	/* 0x14ab */
        {8,	0}, 	/* 0x14ac */
        {8,	0}, 	/* 0x14ad */
        {8,	0}, 	/* 0x14ae */
        {8,	0}, 	/* 0x14af */
        {8,	0}, 	/* 0x14b0 */
        {8,	0}, 	/* 0x14b1 */
        {8,	0}, 	/* 0x14b2 */
        {8,	0}, 	/* 0x14b3 */
        {8,	0}, 	/* 0x14b4 */
        {8,	0}, 	/* 0x14b5 */
        {8,	0}, 	/* 0x14b6 */
        {8,	0}, 	/* 0x14b7 */
        {8,	0}, 	/* 0x14b8 */
        {8,	0}, 	/* 0x14b9 */
        {8,	0}, 	/* 0x14ba */
        {8,	0}, 	/* 0x14bb */
        {8,	0}, 	/* 0x14bc */
        {8,	0}, 	/* 0x14bd */
        {8,	0}, 	/* 0x14be */
        {8,	0}, 	/* 0x14bf */
        {8,	0}, 	/* 0x14c0 */
        {8,	0}, 	/* 0x14c1 */
        {8,	0}, 	/* 0x14c2 */
        {8,	0}, 	/* 0x14c3 */
        {8,	0}, 	/* 0x14c4 */
        {8,	0}, 	/* 0x14c5 */
        {8,	0}, 	/* 0x14c6 */
        {8,	0}, 	/* 0x14c7 */
        {8,	0}, 	/* 0x14c8 */
        {8,	0}, 	/* 0x14c9 */
        {8,	0}, 	/* 0x14ca */
        {8,	0}, 	/* 0x14cb */
        {8,	0}, 	/* 0x14cc */
        {8,	0}, 	/* 0x14cd */
        {8,	0}, 	/* 0x14ce */
        {8,	0}, 	/* 0x14cf */
        {8,	0}, 	/* 0x14d0 */
        {8,	0}, 	/* 0x14d1 */
        {8,	0}, 	/* 0x14d2 */
        {8,	0}, 	/* 0x14d3 */
        {8,	0}, 	/* 0x14d4 */
        {8,	0}, 	/* 0x14d5 */
        {8,	0}, 	/* 0x14d6 */
        {8,	0}, 	/* 0x14d7 */
        {8,	0}, 	/* 0x14d8 */
        {8,	0}, 	/* 0x14d9 */
        {8,	0}, 	/* 0x14da */
        {8,	0}, 	/* 0x14db */
        {8,	0}, 	/* 0x14dc */
        {8,	0}, 	/* 0x14dd */
        {8,	0}, 	/* 0x14de */
        {8,	0}, 	/* 0x14df */
        {8,	0}, 	/* 0x14e0 */
        {8,	0}, 	/* 0x14e1 */
        {8,	0}, 	/* 0x14e2 */
        {8,	0}, 	/* 0x14e3 */
        {8,	0}, 	/* 0x14e4 */
        {8,	0}, 	/* 0x14e5 */
        {8,	0}, 	/* 0x14e6 */
        {8,	0}, 	/* 0x14e7 */
        {8,	0}, 	/* 0x14e8 */
        {8,	0}, 	/* 0x14e9 */
        {8,	0}, 	/* 0x14ea */
        {8,	0}, 	/* 0x14eb */
        {8,	0}, 	/* 0x14ec */
        {8,	0}, 	/* 0x14ed */
        {8,	0}, 	/* 0x14ee */
        {8,	0}, 	/* 0x14ef */
        {8,	0}, 	/* 0x14f0 */
        {8,	0}, 	/* 0x14f1 */
        {8,	0}, 	/* 0x14f2 */
        {8,	0}, 	/* 0x14f3 */
        {8,	0}, 	/* 0x14f4 */
        {8,	0}, 	/* 0x14f5 */
        {8,	0}, 	/* 0x14f6 */
        {8,	0}, 	/* 0x14f7 */
        {8,	0}, 	/* 0x14f8 */
        {8,	0}, 	/* 0x14f9 */
        {8,	0}, 	/* 0x14fa */
        {8,	0}, 	/* 0x14fb */
        {8,	0}, 	/* 0x14fc */
        {8,	0}, 	/* 0x14fd */
        {8,	0}, 	/* 0x14fe */
        {8,	0}, 	/* 0x14ff */
        {8,	0}, 	/* 0x1500 */
        {8,	0}, 	/* 0x1501 */
        {8,	0}, 	/* 0x1502 */
        {8,	0}, 	/* 0x1503 */
        {8,	0}, 	/* 0x1504 */
        {8,	0}, 	/* 0x1505 */
        {8,	0}, 	/* 0x1506 */
        {8,	0}, 	/* 0x1507 */
        {8,	0}, 	/* 0x1508 */
        {8,	0}, 	/* 0x1509 */
        {8,	0}, 	/* 0x150a */
        {8,	0}, 	/* 0x150b */
        {8,	0}, 	/* 0x150c */
        {8,	0}, 	/* 0x150d */
        {8,	0}, 	/* 0x150e */
        {8,	0}, 	/* 0x150f */
        {8,	0}, 	/* 0x1510 */
        {8,	0}, 	/* 0x1511 */
        {8,	0}, 	/* 0x1512 */
        {8,	0}, 	/* 0x1513 */
        {8,	0}, 	/* 0x1514 */
        {8,	0}, 	/* 0x1515 */
        {8,	0}, 	/* 0x1516 */
        {8,	0}, 	/* 0x1517 */
        {8,	0}, 	/* 0x1518 */
        {8,	0}, 	/* 0x1519 */
        {8,	0}, 	/* 0x151a */
        {8,	0}, 	/* 0x151b */
        {8,	0}, 	/* 0x151c */
        {8,	0}, 	/* 0x151d */
        {8,	0}, 	/* 0x151e */
        {8,	0}, 	/* 0x151f */
        {8,	0}, 	/* 0x1520 */
        {8,	0}, 	/* 0x1521 */
        {8,	0}, 	/* 0x1522 */
        {8,	0}, 	/* 0x1523 */
        {8,	0}, 	/* 0x1524 */
        {8,	0}, 	/* 0x1525 */
        {8,	0}, 	/* 0x1526 */
        {8,	0}, 	/* 0x1527 */
        {8,	0}, 	/* 0x1528 */
        {8,	0}, 	/* 0x1529 */
        {8,	0}, 	/* 0x152a */
        {8,	0}, 	/* 0x152b */
        {8,	0}, 	/* 0x152c */
        {8,	0}, 	/* 0x152d */
        {8,	0}, 	/* 0x152e */
        {8,	0}, 	/* 0x152f */
        {8,	0}, 	/* 0x1530 */
        {8,	0}, 	/* 0x1531 */
        {8,	0}, 	/* 0x1532 */
        {8,	0}, 	/* 0x1533 */
        {8,	0}, 	/* 0x1534 */
        {8,	0}, 	/* 0x1535 */
        {8,	0}, 	/* 0x1536 */
        {8,	0}, 	/* 0x1537 */
        {8,	0}, 	/* 0x1538 */
        {8,	0}, 	/* 0x1539 */
        {8,	0}, 	/* 0x153a */
        {8,	0}, 	/* 0x153b */
        {8,	0}, 	/* 0x153c */
        {8,	0}, 	/* 0x153d */
        {8,	0}, 	/* 0x153e */
        {8,	0}, 	/* 0x153f */
        {8,	0}, 	/* 0x1540 */
        {8,	0}, 	/* 0x1541 */
        {8,	0}, 	/* 0x1542 */
        {8,	0}, 	/* 0x1543 */
        {8,	0}, 	/* 0x1544 */
        {8,	0}, 	/* 0x1545 */
        {8,	0}, 	/* 0x1546 */
        {8,	0}, 	/* 0x1547 */
        {8,	0}, 	/* 0x1548 */
        {8,	0}, 	/* 0x1549 */
        {8,	0}, 	/* 0x154a */
        {8,	0}, 	/* 0x154b */
        {8,	0}, 	/* 0x154c */
        {8,	0}, 	/* 0x154d */
        {8,	0}, 	/* 0x154e */
        {8,	0}, 	/* 0x154f */
        {8,	0}, 	/* 0x1550 */
        {8,	0}, 	/* 0x1551 */
        {8,	0}, 	/* 0x1552 */
        {8,	0}, 	/* 0x1553 */
        {8,	0}, 	/* 0x1554 */
        {8,	0}, 	/* 0x1555 */
        {8,	0}, 	/* 0x1556 */
        {8,	0}, 	/* 0x1557 */
        {8,	0}, 	/* 0x1558 */
        {8,	0}, 	/* 0x1559 */
        {8,	0}, 	/* 0x155a */
        {8,	0}, 	/* 0x155b */
        {8,	0}, 	/* 0x155c */
        {8,	0}, 	/* 0x155d */
        {8,	0}, 	/* 0x155e */
        {8,	0}, 	/* 0x155f */
        {8,	0}, 	/* 0x1560 */
        {8,	0}, 	/* 0x1561 */
        {8,	0}, 	/* 0x1562 */
        {8,	0}, 	/* 0x1563 */
        {8,	0}, 	/* 0x1564 */
        {8,	0}, 	/* 0x1565 */
        {8,	0}, 	/* 0x1566 */
        {8,	0}, 	/* 0x1567 */
        {8,	0}, 	/* 0x1568 */
        {8,	0}, 	/* 0x1569 */
        {8,	0}, 	/* 0x156a */
        {8,	0}, 	/* 0x156b */
        {8,	0}, 	/* 0x156c */
        {8,	0}, 	/* 0x156d */
        {8,	0}, 	/* 0x156e */
        {8,	0}, 	/* 0x156f */
        {8,	0}, 	/* 0x1570 */
        {8,	0}, 	/* 0x1571 */
        {8,	0}, 	/* 0x1572 */
        {8,	0}, 	/* 0x1573 */
        {8,	0}, 	/* 0x1574 */
        {8,	0}, 	/* 0x1575 */
        {8,	0}, 	/* 0x1576 */
        {8,	0}, 	/* 0x1577 */
        {8,	0}, 	/* 0x1578 */
        {8,	0}, 	/* 0x1579 */
        {8,	0}, 	/* 0x157a */
        {8,	0}, 	/* 0x157b */
        {8,	0}, 	/* 0x157c */
        {8,	0}, 	/* 0x157d */
        {8,	0}, 	/* 0x157e */
        {8,	0}, 	/* 0x157f */
        {8,	0}, 	/* 0x1580 */
        {8,	0}, 	/* 0x1581 */
        {8,	0}, 	/* 0x1582 */
        {8,	0}, 	/* 0x1583 */
        {8,	0}, 	/* 0x1584 */
        {8,	0}, 	/* 0x1585 */
        {8,	0}, 	/* 0x1586 */
        {8,	0}, 	/* 0x1587 */
        {8,	0}, 	/* 0x1588 */
        {8,	0}, 	/* 0x1589 */
        {8,	0}, 	/* 0x158a */
        {8,	0}, 	/* 0x158b */
        {8,	0}, 	/* 0x158c */
        {8,	0}, 	/* 0x158d */
        {8,	0}, 	/* 0x158e */
        {8,	0}, 	/* 0x158f */
        {8,	0}, 	/* 0x1590 */
        {8,	0}, 	/* 0x1591 */
        {8,	0}, 	/* 0x1592 */
        {8,	0}, 	/* 0x1593 */
        {8,	0}, 	/* 0x1594 */
        {8,	0}, 	/* 0x1595 */
        {8,	0}, 	/* 0x1596 */
        {8,	0}, 	/* 0x1597 */
        {8,	0}, 	/* 0x1598 */
        {8,	0}, 	/* 0x1599 */
        {8,	0}, 	/* 0x159a */
        {8,	0}, 	/* 0x159b */
        {8,	0}, 	/* 0x159c */
        {8,	0}, 	/* 0x159d */
        {8,	0}, 	/* 0x159e */
        {8,	0}, 	/* 0x159f */
        {8,	0}, 	/* 0x15a0 */
        {8,	0}, 	/* 0x15a1 */
        {8,	0}, 	/* 0x15a2 */
        {8,	0}, 	/* 0x15a3 */
        {8,	0}, 	/* 0x15a4 */
        {8,	0}, 	/* 0x15a5 */
        {8,	0}, 	/* 0x15a6 */
        {8,	0}, 	/* 0x15a7 */
        {8,	0}, 	/* 0x15a8 */
        {8,	0}, 	/* 0x15a9 */
        {8,	0}, 	/* 0x15aa */
        {8,	0}, 	/* 0x15ab */
        {8,	0}, 	/* 0x15ac */
        {8,	0}, 	/* 0x15ad */
        {8,	0}, 	/* 0x15ae */
        {8,	0}, 	/* 0x15af */
        {8,	0}, 	/* 0x15b0 */
        {8,	0}, 	/* 0x15b1 */
        {8,	0}, 	/* 0x15b2 */
        {8,	0}, 	/* 0x15b3 */
        {8,	0}, 	/* 0x15b4 */
        {8,	0}, 	/* 0x15b5 */
        {8,	0}, 	/* 0x15b6 */
        {8,	0}, 	/* 0x15b7 */
        {8,	0}, 	/* 0x15b8 */
        {8,	0}, 	/* 0x15b9 */
        {8,	0}, 	/* 0x15ba */
        {8,	0}, 	/* 0x15bb */
        {8,	0}, 	/* 0x15bc */
        {8,	0}, 	/* 0x15bd */
        {8,	0}, 	/* 0x15be */
        {8,	0}, 	/* 0x15bf */
        {8,	0}, 	/* 0x15c0 */
        {8,	0}, 	/* 0x15c1 */
        {8,	0}, 	/* 0x15c2 */
        {8,	0}, 	/* 0x15c3 */
        {8,	0}, 	/* 0x15c4 */
        {8,	0}, 	/* 0x15c5 */
        {8,	0}, 	/* 0x15c6 */
        {8,	0}, 	/* 0x15c7 */
        {8,	0}, 	/* 0x15c8 */
        {8,	0}, 	/* 0x15c9 */
        {8,	0}, 	/* 0x15ca */
        {8,	0}, 	/* 0x15cb */
        {8,	0}, 	/* 0x15cc */
        {8,	0}, 	/* 0x15cd */
        {8,	0}, 	/* 0x15ce */
        {8,	0}, 	/* 0x15cf */
        {8,	0}, 	/* 0x15d0 */
        {8,	0}, 	/* 0x15d1 */
        {8,	0}, 	/* 0x15d2 */
        {8,	0}, 	/* 0x15d3 */
        {8,	0}, 	/* 0x15d4 */
        {8,	0}, 	/* 0x15d5 */
        {8,	0}, 	/* 0x15d6 */
        {8,	0}, 	/* 0x15d7 */
        {8,	0}, 	/* 0x15d8 */
        {8,	0}, 	/* 0x15d9 */
        {8,	0}, 	/* 0x15da */
        {8,	0}, 	/* 0x15db */
        {8,	0}, 	/* 0x15dc */
        {8,	0}, 	/* 0x15dd */
        {8,	0}, 	/* 0x15de */
        {8,	0}, 	/* 0x15df */
        {8,	0}, 	/* 0x15e0 */
        {8,	0}, 	/* 0x15e1 */
        {8,	0}, 	/* 0x15e2 */
        {8,	0}, 	/* 0x15e3 */
        {8,	0}, 	/* 0x15e4 */
        {8,	0}, 	/* 0x15e5 */
        {8,	0}, 	/* 0x15e6 */
        {8,	0}, 	/* 0x15e7 */
        {8,	0}, 	/* 0x15e8 */
        {8,	0}, 	/* 0x15e9 */
        {8,	0}, 	/* 0x15ea */
        {8,	0}, 	/* 0x15eb */
        {8,	0}, 	/* 0x15ec */
        {8,	0}, 	/* 0x15ed */
        {8,	0}, 	/* 0x15ee */
        {8,	0}, 	/* 0x15ef */
        {8,	0}, 	/* 0x15f0 */
        {8,	0}, 	/* 0x15f1 */
        {8,	0}, 	/* 0x15f2 */
        {8,	0}, 	/* 0x15f3 */
        {8,	0}, 	/* 0x15f4 */
        {8,	0}, 	/* 0x15f5 */
        {8,	0}, 	/* 0x15f6 */
        {8,	0}, 	/* 0x15f7 */
        {8,	0}, 	/* 0x15f8 */
        {8,	0}, 	/* 0x15f9 */
        {8,	0}, 	/* 0x15fa */
        {8,	0}, 	/* 0x15fb */
        {8,	0}, 	/* 0x15fc */
        {8,	0}, 	/* 0x15fd */
        {8,	0}, 	/* 0x15fe */
        {8,	0}, 	/* 0x15ff */
        {8,	0}, 	/* 0x1600 */
        {8,	0}, 	/* 0x1601 */
        {8,	0}, 	/* 0x1602 */
        {8,	0}, 	/* 0x1603 */
        {8,	0}, 	/* 0x1604 */
        {8,	0}, 	/* 0x1605 */
        {8,	0}, 	/* 0x1606 */
        {8,	0}, 	/* 0x1607 */
        {8,	0}, 	/* 0x1608 */
        {8,	0}, 	/* 0x1609 */
        {8,	0}, 	/* 0x160a */
        {8,	0}, 	/* 0x160b */
        {8,	0}, 	/* 0x160c */
        {8,	0}, 	/* 0x160d */
        {8,	0}, 	/* 0x160e */
        {8,	0}, 	/* 0x160f */
        {8,	0}, 	/* 0x1610 */
        {8,	0}, 	/* 0x1611 */
        {8,	0}, 	/* 0x1612 */
        {8,	0}, 	/* 0x1613 */
        {8,	0}, 	/* 0x1614 */
        {8,	0}, 	/* 0x1615 */
        {8,	0}, 	/* 0x1616 */
        {8,	0}, 	/* 0x1617 */
        {8,	0}, 	/* 0x1618 */
        {8,	0}, 	/* 0x1619 */
        {8,	0}, 	/* 0x161a */
        {8,	0}, 	/* 0x161b */
        {8,	0}, 	/* 0x161c */
        {8,	0}, 	/* 0x161d */
        {8,	0}, 	/* 0x161e */
        {8,	0}, 	/* 0x161f */
        {8,	0}, 	/* 0x1620 */
        {8,	0}, 	/* 0x1621 */
        {8,	0}, 	/* 0x1622 */
        {8,	0}, 	/* 0x1623 */
        {8,	0}, 	/* 0x1624 */
        {8,	0}, 	/* 0x1625 */
        {8,	0}, 	/* 0x1626 */
        {8,	0}, 	/* 0x1627 */
        {8,	0}, 	/* 0x1628 */
        {8,	0}, 	/* 0x1629 */
        {8,	0}, 	/* 0x162a */
        {8,	0}, 	/* 0x162b */
        {8,	0}, 	/* 0x162c */
        {8,	0}, 	/* 0x162d */
        {8,	0}, 	/* 0x162e */
        {8,	0}, 	/* 0x162f */
        {8,	0}, 	/* 0x1630 */
        {8,	0}, 	/* 0x1631 */
        {8,	0}, 	/* 0x1632 */
        {8,	0}, 	/* 0x1633 */
        {8,	0}, 	/* 0x1634 */
        {8,	0}, 	/* 0x1635 */
        {8,	0}, 	/* 0x1636 */
        {8,	0}, 	/* 0x1637 */
        {8,	0}, 	/* 0x1638 */
        {8,	0}, 	/* 0x1639 */
        {8,	0}, 	/* 0x163a */
        {8,	0}, 	/* 0x163b */
        {8,	0}, 	/* 0x163c */
        {8,	0}, 	/* 0x163d */
        {8,	0}, 	/* 0x163e */
        {8,	0}, 	/* 0x163f */
        {8,	0}, 	/* 0x1640 */
        {8,	0}, 	/* 0x1641 */
        {8,	0}, 	/* 0x1642 */
        {8,	0}, 	/* 0x1643 */
        {8,	0}, 	/* 0x1644 */
        {8,	0}, 	/* 0x1645 */
        {8,	0}, 	/* 0x1646 */
        {8,	0}, 	/* 0x1647 */
        {8,	0}, 	/* 0x1648 */
        {8,	0}, 	/* 0x1649 */
        {8,	0}, 	/* 0x164a */
        {8,	0}, 	/* 0x164b */
        {8,	0}, 	/* 0x164c */
        {8,	0}, 	/* 0x164d */
        {8,	0}, 	/* 0x164e */
        {8,	0}, 	/* 0x164f */
        {8,	0}, 	/* 0x1650 */
        {8,	0}, 	/* 0x1651 */
        {8,	0}, 	/* 0x1652 */
        {8,	0}, 	/* 0x1653 */
        {8,	0}, 	/* 0x1654 */
        {8,	0}, 	/* 0x1655 */
        {8,	0}, 	/* 0x1656 */
        {8,	0}, 	/* 0x1657 */
        {8,	0}, 	/* 0x1658 */
        {8,	0}, 	/* 0x1659 */
        {8,	0}, 	/* 0x165a */
        {8,	0}, 	/* 0x165b */
        {8,	0}, 	/* 0x165c */
        {8,	0}, 	/* 0x165d */
        {8,	0}, 	/* 0x165e */
        {8,	0}, 	/* 0x165f */
        {8,	0}, 	/* 0x1660 */
        {8,	0}, 	/* 0x1661 */
        {8,	0}, 	/* 0x1662 */
        {8,	0}, 	/* 0x1663 */
        {8,	0}, 	/* 0x1664 */
        {8,	0}, 	/* 0x1665 */
        {8,	0}, 	/* 0x1666 */
        {8,	0}, 	/* 0x1667 */
        {8,	0}, 	/* 0x1668 */
        {8,	0}, 	/* 0x1669 */
        {8,	0}, 	/* 0x166a */
        {8,	0}, 	/* 0x166b */
        {8,	0}, 	/* 0x166c */
        {8,	0}, 	/* 0x166d */
        {8,	0}, 	/* 0x166e */
        {8,	0}, 	/* 0x166f */
        {8,	0}, 	/* 0x1670 */
        {8,	0}, 	/* 0x1671 */
        {8,	0}, 	/* 0x1672 */
        {8,	0}, 	/* 0x1673 */
        {8,	0}, 	/* 0x1674 */
        {8,	0}, 	/* 0x1675 */
        {8,	0}, 	/* 0x1676 */
        {8,	0}, 	/* 0x1677 */
        {8,	0}, 	/* 0x1678 */
        {8,	0}, 	/* 0x1679 */
        {8,	0}, 	/* 0x167a */
        {8,	0}, 	/* 0x167b */
        {8,	0}, 	/* 0x167c */
        {8,	0}, 	/* 0x167d */
        {8,	0}, 	/* 0x167e */
        {8,	0}, 	/* 0x167f */
        {8,	0}, 	/* 0x1680 */
        {8,	0}, 	/* 0x1681 */
        {8,	0}, 	/* 0x1682 */
        {8,	0}, 	/* 0x1683 */
        {8,	0}, 	/* 0x1684 */
        {8,	0}, 	/* 0x1685 */
        {8,	0}, 	/* 0x1686 */
        {8,	0}, 	/* 0x1687 */
        {8,	0}, 	/* 0x1688 */
        {8,	0}, 	/* 0x1689 */
        {8,	0}, 	/* 0x168a */
        {8,	0}, 	/* 0x168b */
        {8,	0}, 	/* 0x168c */
        {8,	0}, 	/* 0x168d */
        {8,	0}, 	/* 0x168e */
        {8,	0}, 	/* 0x168f */
        {8,	0}, 	/* 0x1690 */
        {8,	0}, 	/* 0x1691 */
        {8,	0}, 	/* 0x1692 */
        {8,	0}, 	/* 0x1693 */
        {8,	0}, 	/* 0x1694 */
        {8,	0}, 	/* 0x1695 */
        {8,	0}, 	/* 0x1696 */
        {8,	0}, 	/* 0x1697 */
        {8,	0}, 	/* 0x1698 */
        {8,	0}, 	/* 0x1699 */
        {8,	0}, 	/* 0x169a */
        {8,	0}, 	/* 0x169b */
        {8,	0}, 	/* 0x169c */
        {8,	0}, 	/* 0x169d */
        {8,	0}, 	/* 0x169e */
        {8,	0}, 	/* 0x169f */
        {8,	0}, 	/* 0x16a0 */
        {8,	0}, 	/* 0x16a1 */
        {8,	0}, 	/* 0x16a2 */
        {8,	0}, 	/* 0x16a3 */
        {8,	0}, 	/* 0x16a4 */
        {8,	0}, 	/* 0x16a5 */
        {8,	0}, 	/* 0x16a6 */
        {8,	0}, 	/* 0x16a7 */
        {8,	0}, 	/* 0x16a8 */
        {8,	0}, 	/* 0x16a9 */
        {8,	0}, 	/* 0x16aa */
        {8,	0}, 	/* 0x16ab */
        {8,	0}, 	/* 0x16ac */
        {8,	0}, 	/* 0x16ad */
        {8,	0}, 	/* 0x16ae */
        {8,	0}, 	/* 0x16af */
        {8,	0}, 	/* 0x16b0 */
        {8,	0}, 	/* 0x16b1 */
        {8,	0}, 	/* 0x16b2 */
        {8,	0}, 	/* 0x16b3 */
        {8,	0}, 	/* 0x16b4 */
        {8,	0}, 	/* 0x16b5 */
        {8,	0}, 	/* 0x16b6 */
        {8,	0}, 	/* 0x16b7 */
        {8,	0}, 	/* 0x16b8 */
        {8,	0}, 	/* 0x16b9 */
        {8,	0}, 	/* 0x16ba */
        {8,	0}, 	/* 0x16bb */
        {8,	0}, 	/* 0x16bc */
        {8,	0}, 	/* 0x16bd */
        {8,	0}, 	/* 0x16be */
        {8,	0}, 	/* 0x16bf */
        {8,	0}, 	/* 0x16c0 */
        {8,	0}, 	/* 0x16c1 */
        {8,	0}, 	/* 0x16c2 */
        {8,	0}, 	/* 0x16c3 */
        {8,	0}, 	/* 0x16c4 */
        {8,	0}, 	/* 0x16c5 */
        {8,	0}, 	/* 0x16c6 */
        {8,	0}, 	/* 0x16c7 */
        {8,	0}, 	/* 0x16c8 */
        {8,	0}, 	/* 0x16c9 */
        {8,	0}, 	/* 0x16ca */
        {8,	0}, 	/* 0x16cb */
        {8,	0}, 	/* 0x16cc */
        {8,	0}, 	/* 0x16cd */
        {8,	0}, 	/* 0x16ce */
        {8,	0}, 	/* 0x16cf */
        {8,	0}, 	/* 0x16d0 */
        {8,	0}, 	/* 0x16d1 */
        {8,	0}, 	/* 0x16d2 */
        {8,	0}, 	/* 0x16d3 */
        {8,	0}, 	/* 0x16d4 */
        {8,	0}, 	/* 0x16d5 */
        {8,	0}, 	/* 0x16d6 */
        {8,	0}, 	/* 0x16d7 */
        {8,	0}, 	/* 0x16d8 */
        {8,	0}, 	/* 0x16d9 */
        {8,	0}, 	/* 0x16da */
        {8,	0}, 	/* 0x16db */
        {8,	0}, 	/* 0x16dc */
        {8,	0}, 	/* 0x16dd */
        {8,	0}, 	/* 0x16de */
        {8,	0}, 	/* 0x16df */
        {8,	0}, 	/* 0x16e0 */
        {8,	0}, 	/* 0x16e1 */
        {8,	0}, 	/* 0x16e2 */
        {8,	0}, 	/* 0x16e3 */
        {8,	0}, 	/* 0x16e4 */
        {8,	0}, 	/* 0x16e5 */
        {8,	0}, 	/* 0x16e6 */
        {8,	0}, 	/* 0x16e7 */
        {8,	0}, 	/* 0x16e8 */
        {8,	0}, 	/* 0x16e9 */
        {8,	0}, 	/* 0x16ea */
        {8,	0}, 	/* 0x16eb */
        {8,	0}, 	/* 0x16ec */
        {8,	0}, 	/* 0x16ed */
        {8,	0}, 	/* 0x16ee */
        {8,	0}, 	/* 0x16ef */
        {8,	0}, 	/* 0x16f0 */
        {8,	0}, 	/* 0x16f1 */
        {8,	0}, 	/* 0x16f2 */
        {8,	0}, 	/* 0x16f3 */
        {8,	0}, 	/* 0x16f4 */
        {8,	0}, 	/* 0x16f5 */
        {8,	0}, 	/* 0x16f6 */
        {8,	0}, 	/* 0x16f7 */
        {8,	0}, 	/* 0x16f8 */
        {8,	0}, 	/* 0x16f9 */
        {8,	0}, 	/* 0x16fa */
        {8,	0}, 	/* 0x16fb */
        {8,	0}, 	/* 0x16fc */
        {8,	0}, 	/* 0x16fd */
        {8,	0}, 	/* 0x16fe */
        {8,	0}, 	/* 0x16ff */
        {8,	0}, 	/* 0x1700 */
        {8,	0}, 	/* 0x1701 */
        {8,	0}, 	/* 0x1702 */
        {8,	0}, 	/* 0x1703 */
        {8,	0}, 	/* 0x1704 */
        {8,	0}, 	/* 0x1705 */
        {8,	0}, 	/* 0x1706 */
        {8,	0}, 	/* 0x1707 */
        {8,	0}, 	/* 0x1708 */
        {8,	0}, 	/* 0x1709 */
        {8,	0}, 	/* 0x170a */
        {8,	0}, 	/* 0x170b */
        {8,	0}, 	/* 0x170c */
        {8,	0}, 	/* 0x170d */
        {8,	0}, 	/* 0x170e */
        {8,	0}, 	/* 0x170f */
        {8,	0}, 	/* 0x1710 */
        {8,	0}, 	/* 0x1711 */
        {8,	0}, 	/* 0x1712 */
        {8,	0}, 	/* 0x1713 */
        {8,	0}, 	/* 0x1714 */
        {8,	0}, 	/* 0x1715 */
        {8,	0}, 	/* 0x1716 */
        {8,	0}, 	/* 0x1717 */
        {8,	0}, 	/* 0x1718 */
        {8,	0}, 	/* 0x1719 */
        {8,	0}, 	/* 0x171a */
        {8,	0}, 	/* 0x171b */
        {8,	0}, 	/* 0x171c */
        {8,	0}, 	/* 0x171d */
        {8,	0}, 	/* 0x171e */
        {8,	0}, 	/* 0x171f */
        {8,	0}, 	/* 0x1720 */
        {8,	0}, 	/* 0x1721 */
        {8,	0}, 	/* 0x1722 */
        {8,	0}, 	/* 0x1723 */
        {8,	0}, 	/* 0x1724 */
        {8,	0}, 	/* 0x1725 */
        {8,	0}, 	/* 0x1726 */
        {8,	0}, 	/* 0x1727 */
        {8,	0}, 	/* 0x1728 */
        {8,	0}, 	/* 0x1729 */
        {8,	0}, 	/* 0x172a */
        {8,	0}, 	/* 0x172b */
        {8,	0}, 	/* 0x172c */
        {8,	0}, 	/* 0x172d */
        {8,	0}, 	/* 0x172e */
        {8,	0}, 	/* 0x172f */
        {8,	0}, 	/* 0x1730 */
        {8,	0}, 	/* 0x1731 */
        {8,	0}, 	/* 0x1732 */
        {8,	0}, 	/* 0x1733 */
        {8,	0}, 	/* 0x1734 */
        {8,	0}, 	/* 0x1735 */
        {8,	0}, 	/* 0x1736 */
        {8,	0}, 	/* 0x1737 */
        {8,	0}, 	/* 0x1738 */
        {8,	0}, 	/* 0x1739 */
        {8,	0}, 	/* 0x173a */
        {8,	0}, 	/* 0x173b */
        {8,	0}, 	/* 0x173c */
        {8,	0}, 	/* 0x173d */
        {8,	0}, 	/* 0x173e */
        {8,	0}, 	/* 0x173f */
        {8,	0}, 	/* 0x1740 */
        {8,	0}, 	/* 0x1741 */
        {8,	0}, 	/* 0x1742 */
        {8,	0}, 	/* 0x1743 */
        {8,	0}, 	/* 0x1744 */
        {8,	0}, 	/* 0x1745 */
        {8,	0}, 	/* 0x1746 */
        {8,	0}, 	/* 0x1747 */
        {8,	0}, 	/* 0x1748 */
        {8,	0}, 	/* 0x1749 */
        {8,	0}, 	/* 0x174a */
        {8,	0}, 	/* 0x174b */
        {8,	0}, 	/* 0x174c */
        {8,	0}, 	/* 0x174d */
        {8,	0}, 	/* 0x174e */
        {8,	0}, 	/* 0x174f */
        {8,	0}, 	/* 0x1750 */
        {8,	0}, 	/* 0x1751 */
        {8,	0}, 	/* 0x1752 */
        {8,	0}, 	/* 0x1753 */
        {8,	0}, 	/* 0x1754 */
        {8,	0}, 	/* 0x1755 */
        {8,	0}, 	/* 0x1756 */
        {8,	0}, 	/* 0x1757 */
        {8,	0}, 	/* 0x1758 */
        {8,	0}, 	/* 0x1759 */
        {8,	0}, 	/* 0x175a */
        {8,	0}, 	/* 0x175b */
        {8,	0}, 	/* 0x175c */
        {8,	0}, 	/* 0x175d */
        {8,	0}, 	/* 0x175e */
        {8,	0}, 	/* 0x175f */
        {8,	0}, 	/* 0x1760 */
        {8,	0}, 	/* 0x1761 */
        {8,	0}, 	/* 0x1762 */
        {8,	0}, 	/* 0x1763 */
        {8,	0}, 	/* 0x1764 */
        {8,	0}, 	/* 0x1765 */
        {8,	0}, 	/* 0x1766 */
        {8,	0}, 	/* 0x1767 */
        {8,	0}, 	/* 0x1768 */
        {8,	0}, 	/* 0x1769 */
        {8,	0}, 	/* 0x176a */
        {8,	0}, 	/* 0x176b */
        {8,	0}, 	/* 0x176c */
        {8,	0}, 	/* 0x176d */
        {8,	0}, 	/* 0x176e */
        {8,	0}, 	/* 0x176f */
        {8,	0}, 	/* 0x1770 */
        {8,	0}, 	/* 0x1771 */
        {8,	0}, 	/* 0x1772 */
        {8,	0}, 	/* 0x1773 */
        {8,	0}, 	/* 0x1774 */
        {8,	0}, 	/* 0x1775 */
        {8,	0}, 	/* 0x1776 */
        {8,	0}, 	/* 0x1777 */
        {8,	0}, 	/* 0x1778 */
        {8,	0}, 	/* 0x1779 */
        {8,	0}, 	/* 0x177a */
        {8,	0}, 	/* 0x177b */
        {8,	0}, 	/* 0x177c */
        {8,	0}, 	/* 0x177d */
        {8,	0}, 	/* 0x177e */
        {8,	0}, 	/* 0x177f */
        {8,	0}, 	/* 0x1780 */
        {8,	0}, 	/* 0x1781 */
        {8,	0}, 	/* 0x1782 */
        {8,	0}, 	/* 0x1783 */
        {8,	0}, 	/* 0x1784 */
        {8,	0}, 	/* 0x1785 */
        {8,	0}, 	/* 0x1786 */
        {8,	0}, 	/* 0x1787 */
        {8,	0}, 	/* 0x1788 */
        {8,	0}, 	/* 0x1789 */
        {8,	0}, 	/* 0x178a */
        {8,	0}, 	/* 0x178b */
        {8,	0}, 	/* 0x178c */
        {8,	0}, 	/* 0x178d */
        {8,	0}, 	/* 0x178e */
        {8,	0}, 	/* 0x178f */
        {8,	0}, 	/* 0x1790 */
        {8,	0}, 	/* 0x1791 */
        {8,	0}, 	/* 0x1792 */
        {8,	0}, 	/* 0x1793 */
        {8,	0}, 	/* 0x1794 */
        {8,	0}, 	/* 0x1795 */
        {8,	0}, 	/* 0x1796 */
        {8,	0}, 	/* 0x1797 */
        {8,	0}, 	/* 0x1798 */
        {8,	0}, 	/* 0x1799 */
        {8,	0}, 	/* 0x179a */
        {8,	0}, 	/* 0x179b */
        {8,	0}, 	/* 0x179c */
        {8,	0}, 	/* 0x179d */
        {8,	0}, 	/* 0x179e */
        {8,	0}, 	/* 0x179f */
        {8,	0}, 	/* 0x17a0 */
        {8,	0}, 	/* 0x17a1 */
        {8,	0}, 	/* 0x17a2 */
        {8,	0}, 	/* 0x17a3 */
        {8,	0}, 	/* 0x17a4 */
        {8,	0}, 	/* 0x17a5 */
        {8,	0}, 	/* 0x17a6 */
        {8,	0}, 	/* 0x17a7 */
        {8,	0}, 	/* 0x17a8 */
        {8,	0}, 	/* 0x17a9 */
        {8,	0}, 	/* 0x17aa */
        {8,	0}, 	/* 0x17ab */
        {8,	0}, 	/* 0x17ac */
        {8,	0}, 	/* 0x17ad */
        {8,	0}, 	/* 0x17ae */
        {8,	0}, 	/* 0x17af */
        {8,	0}, 	/* 0x17b0 */
        {8,	0}, 	/* 0x17b1 */
        {8,	0}, 	/* 0x17b2 */
        {8,	0}, 	/* 0x17b3 */
        {8,	0}, 	/* 0x17b4 */
        {8,	0}, 	/* 0x17b5 */
        {8,	0}, 	/* 0x17b6 */
        {8,	0}, 	/* 0x17b7 */
        {8,	0}, 	/* 0x17b8 */
        {8,	0}, 	/* 0x17b9 */
        {8,	0}, 	/* 0x17ba */
        {8,	0}, 	/* 0x17bb */
        {8,	0}, 	/* 0x17bc */
        {8,	0}, 	/* 0x17bd */
        {8,	0}, 	/* 0x17be */
        {8,	0}, 	/* 0x17bf */
        {8,	0}, 	/* 0x17c0 */
        {8,	0}, 	/* 0x17c1 */
        {8,	0}, 	/* 0x17c2 */
        {8,	0}, 	/* 0x17c3 */
        {8,	0}, 	/* 0x17c4 */
        {8,	0}, 	/* 0x17c5 */
        {8,	0}, 	/* 0x17c6 */
        {8,	0}, 	/* 0x17c7 */
        {8,	0}, 	/* 0x17c8 */
        {8,	0}, 	/* 0x17c9 */
        {8,	0}, 	/* 0x17ca */
        {8,	0}, 	/* 0x17cb */
        {8,	0}, 	/* 0x17cc */
        {8,	0}, 	/* 0x17cd */
        {8,	0}, 	/* 0x17ce */
        {8,	0}, 	/* 0x17cf */
        {8,	0}, 	/* 0x17d0 */
        {8,	0}, 	/* 0x17d1 */
        {8,	0}, 	/* 0x17d2 */
        {8,	0}, 	/* 0x17d3 */
        {8,	0}, 	/* 0x17d4 */
        {8,	0}, 	/* 0x17d5 */
        {8,	0}, 	/* 0x17d6 */
        {8,	0}, 	/* 0x17d7 */
        {8,	0}, 	/* 0x17d8 */
        {8,	0}, 	/* 0x17d9 */
        {8,	0}, 	/* 0x17da */
        {8,	0}, 	/* 0x17db */
        {8,	0}, 	/* 0x17dc */
        {8,	0}, 	/* 0x17dd */
        {8,	0}, 	/* 0x17de */
        {8,	0}, 	/* 0x17df */
        {8,	0}, 	/* 0x17e0 */
        {8,	0}, 	/* 0x17e1 */
        {8,	0}, 	/* 0x17e2 */
        {8,	0}, 	/* 0x17e3 */
        {8,	0}, 	/* 0x17e4 */
        {8,	0}, 	/* 0x17e5 */
        {8,	0}, 	/* 0x17e6 */
        {8,	0}, 	/* 0x17e7 */
        {8,	0}, 	/* 0x17e8 */
        {8,	0}, 	/* 0x17e9 */
        {8,	0}, 	/* 0x17ea */
        {8,	0}, 	/* 0x17eb */
        {8,	0}, 	/* 0x17ec */
        {8,	0}, 	/* 0x17ed */
        {8,	0}, 	/* 0x17ee */
        {8,	0}, 	/* 0x17ef */
        {8,	0}, 	/* 0x17f0 */
        {8,	0}, 	/* 0x17f1 */
        {8,	0}, 	/* 0x17f2 */
        {8,	0}, 	/* 0x17f3 */
        {8,	0}, 	/* 0x17f4 */
        {8,	0}, 	/* 0x17f5 */
        {8,	0}, 	/* 0x17f6 */
        {8,	0}, 	/* 0x17f7 */
        {8,	0}, 	/* 0x17f8 */
        {8,	0}, 	/* 0x17f9 */
        {8,	0}, 	/* 0x17fa */
        {8,	0}, 	/* 0x17fb */
        {8,	0}, 	/* 0x17fc */
        {8,	0}, 	/* 0x17fd */
        {8,	0}, 	/* 0x17fe */
        {8,	0}, 	/* 0x17ff */
        {8,	0}, 	/* 0x1800 */
        {8,	0}, 	/* 0x1801 */
        {8,	0}, 	/* 0x1802 */
        {8,	0}, 	/* 0x1803 */
        {8,	0}, 	/* 0x1804 */
        {8,	0}, 	/* 0x1805 */
        {8,	0}, 	/* 0x1806 */
        {8,	0}, 	/* 0x1807 */
        {8,	0}, 	/* 0x1808 */
        {8,	0}, 	/* 0x1809 */
        {8,	0}, 	/* 0x180a */
        {8,	0}, 	/* 0x180b */
        {8,	0}, 	/* 0x180c */
        {8,	0}, 	/* 0x180d */
        {8,	0}, 	/* 0x180e */
        {8,	0}, 	/* 0x180f */
        {8,	0}, 	/* 0x1810 */
        {8,	0}, 	/* 0x1811 */
        {8,	0}, 	/* 0x1812 */
        {8,	0}, 	/* 0x1813 */
        {8,	0}, 	/* 0x1814 */
        {8,	0}, 	/* 0x1815 */
        {8,	0}, 	/* 0x1816 */
        {8,	0}, 	/* 0x1817 */
        {8,	0}, 	/* 0x1818 */
        {8,	0}, 	/* 0x1819 */
        {8,	0}, 	/* 0x181a */
        {8,	0}, 	/* 0x181b */
        {8,	0}, 	/* 0x181c */
        {8,	0}, 	/* 0x181d */
        {8,	0}, 	/* 0x181e */
        {8,	0}, 	/* 0x181f */
        {8,	0}, 	/* 0x1820 */
        {8,	0}, 	/* 0x1821 */
        {8,	0}, 	/* 0x1822 */
        {8,	0}, 	/* 0x1823 */
        {8,	0}, 	/* 0x1824 */
        {8,	0}, 	/* 0x1825 */
        {8,	0}, 	/* 0x1826 */
        {8,	0}, 	/* 0x1827 */
        {8,	0}, 	/* 0x1828 */
        {8,	0}, 	/* 0x1829 */
        {8,	0}, 	/* 0x182a */
        {8,	0}, 	/* 0x182b */
        {8,	0}, 	/* 0x182c */
        {8,	0}, 	/* 0x182d */
        {8,	0}, 	/* 0x182e */
        {8,	0}, 	/* 0x182f */
        {8,	0}, 	/* 0x1830 */
        {8,	0}, 	/* 0x1831 */
        {8,	0}, 	/* 0x1832 */
        {8,	0}, 	/* 0x1833 */
        {8,	0}, 	/* 0x1834 */
        {8,	0}, 	/* 0x1835 */
        {8,	0}, 	/* 0x1836 */
        {8,	0}, 	/* 0x1837 */
        {8,	0}, 	/* 0x1838 */
        {8,	0}, 	/* 0x1839 */
        {8,	0}, 	/* 0x183a */
        {8,	0}, 	/* 0x183b */
        {8,	0}, 	/* 0x183c */
        {8,	0}, 	/* 0x183d */
        {8,	0}, 	/* 0x183e */
        {8,	0}, 	/* 0x183f */
        {8,	0}, 	/* 0x1840 */
        {8,	0}, 	/* 0x1841 */
        {8,	0}, 	/* 0x1842 */
        {8,	0}, 	/* 0x1843 */
        {8,	0}, 	/* 0x1844 */
        {8,	0}, 	/* 0x1845 */
        {8,	0}, 	/* 0x1846 */
        {8,	0}, 	/* 0x1847 */
        {8,	0}, 	/* 0x1848 */
        {8,	0}, 	/* 0x1849 */
        {8,	0}, 	/* 0x184a */
        {8,	0}, 	/* 0x184b */
        {8,	0}, 	/* 0x184c */
        {8,	0}, 	/* 0x184d */
        {8,	0}, 	/* 0x184e */
        {8,	0}, 	/* 0x184f */
        {8,	0}, 	/* 0x1850 */
        {8,	0}, 	/* 0x1851 */
        {8,	0}, 	/* 0x1852 */
        {8,	0}, 	/* 0x1853 */
        {8,	0}, 	/* 0x1854 */
        {8,	0}, 	/* 0x1855 */
        {8,	0}, 	/* 0x1856 */
        {8,	0}, 	/* 0x1857 */
        {8,	0}, 	/* 0x1858 */
        {8,	0}, 	/* 0x1859 */
        {8,	0}, 	/* 0x185a */
        {8,	0}, 	/* 0x185b */
        {8,	0}, 	/* 0x185c */
        {8,	0}, 	/* 0x185d */
        {8,	0}, 	/* 0x185e */
        {8,	0}, 	/* 0x185f */
        {8,	0}, 	/* 0x1860 */
        {8,	0}, 	/* 0x1861 */
        {8,	0}, 	/* 0x1862 */
        {8,	0}, 	/* 0x1863 */
        {8,	0}, 	/* 0x1864 */
        {8,	0}, 	/* 0x1865 */
        {8,	0}, 	/* 0x1866 */
        {8,	0}, 	/* 0x1867 */
        {8,	0}, 	/* 0x1868 */
        {8,	0}, 	/* 0x1869 */
        {8,	0}, 	/* 0x186a */
        {8,	0}, 	/* 0x186b */
        {8,	0}, 	/* 0x186c */
        {8,	0}, 	/* 0x186d */
        {8,	0}, 	/* 0x186e */
        {8,	0}, 	/* 0x186f */
        {8,	0}, 	/* 0x1870 */
        {8,	0}, 	/* 0x1871 */
        {8,	0}, 	/* 0x1872 */
        {8,	0}, 	/* 0x1873 */
        {8,	0}, 	/* 0x1874 */
        {8,	0}, 	/* 0x1875 */
        {8,	0}, 	/* 0x1876 */
        {8,	0}, 	/* 0x1877 */
        {8,	0}, 	/* 0x1878 */
        {8,	0}, 	/* 0x1879 */
        {8,	0}, 	/* 0x187a */
        {8,	0}, 	/* 0x187b */
        {8,	0}, 	/* 0x187c */
        {8,	0}, 	/* 0x187d */
        {8,	0}, 	/* 0x187e */
        {8,	0}, 	/* 0x187f */
        {8,	0}, 	/* 0x1880 */
        {8,	0}, 	/* 0x1881 */
        {8,	0}, 	/* 0x1882 */
        {8,	0}, 	/* 0x1883 */
        {8,	0}, 	/* 0x1884 */
        {8,	0}, 	/* 0x1885 */
        {8,	0}, 	/* 0x1886 */
        {8,	0}, 	/* 0x1887 */
        {8,	0}, 	/* 0x1888 */
        {8,	0}, 	/* 0x1889 */
        {8,	0}, 	/* 0x188a */
        {8,	0}, 	/* 0x188b */
        {8,	0}, 	/* 0x188c */
        {8,	0}, 	/* 0x188d */
        {8,	0}, 	/* 0x188e */
        {8,	0}, 	/* 0x188f */
        {8,	0}, 	/* 0x1890 */
        {8,	0}, 	/* 0x1891 */
        {8,	0}, 	/* 0x1892 */
        {8,	0}, 	/* 0x1893 */
        {8,	0}, 	/* 0x1894 */
        {8,	0}, 	/* 0x1895 */
        {8,	0}, 	/* 0x1896 */
        {8,	0}, 	/* 0x1897 */
        {8,	0}, 	/* 0x1898 */
        {8,	0}, 	/* 0x1899 */
        {8,	0}, 	/* 0x189a */
        {8,	0}, 	/* 0x189b */
        {8,	0}, 	/* 0x189c */
        {8,	0}, 	/* 0x189d */
        {8,	0}, 	/* 0x189e */
        {8,	0}, 	/* 0x189f */
        {8,	0}, 	/* 0x18a0 */
        {8,	0}, 	/* 0x18a1 */
        {8,	0}, 	/* 0x18a2 */
        {8,	0}, 	/* 0x18a3 */
        {8,	0}, 	/* 0x18a4 */
        {8,	0}, 	/* 0x18a5 */
        {8,	0}, 	/* 0x18a6 */
        {8,	0}, 	/* 0x18a7 */
        {8,	0}, 	/* 0x18a8 */
        {8,	0}, 	/* 0x18a9 */
        {8,	0}, 	/* 0x18aa */
        {8,	0}, 	/* 0x18ab */
        {8,	0}, 	/* 0x18ac */
        {8,	0}, 	/* 0x18ad */
        {8,	0}, 	/* 0x18ae */
        {8,	0}, 	/* 0x18af */
        {8,	0}, 	/* 0x18b0 */
        {8,	0}, 	/* 0x18b1 */
        {8,	0}, 	/* 0x18b2 */
        {8,	0}, 	/* 0x18b3 */
        {8,	0}, 	/* 0x18b4 */
        {8,	0}, 	/* 0x18b5 */
        {8,	0}, 	/* 0x18b6 */
        {8,	0}, 	/* 0x18b7 */
        {8,	0}, 	/* 0x18b8 */
        {8,	0}, 	/* 0x18b9 */
        {8,	0}, 	/* 0x18ba */
        {8,	0}, 	/* 0x18bb */
        {8,	0}, 	/* 0x18bc */
        {8,	0}, 	/* 0x18bd */
        {8,	0}, 	/* 0x18be */
        {8,	0}, 	/* 0x18bf */
        {8,	0}, 	/* 0x18c0 */
        {8,	0}, 	/* 0x18c1 */
        {8,	0}, 	/* 0x18c2 */
        {8,	0}, 	/* 0x18c3 */
        {8,	0}, 	/* 0x18c4 */
        {8,	0}, 	/* 0x18c5 */
        {8,	0}, 	/* 0x18c6 */
        {8,	0}, 	/* 0x18c7 */
        {8,	0}, 	/* 0x18c8 */
        {8,	0}, 	/* 0x18c9 */
        {8,	0}, 	/* 0x18ca */
        {8,	0}, 	/* 0x18cb */
        {8,	0}, 	/* 0x18cc */
        {8,	0}, 	/* 0x18cd */
        {8,	0}, 	/* 0x18ce */
        {8,	0}, 	/* 0x18cf */
        {8,	0}, 	/* 0x18d0 */
        {8,	0}, 	/* 0x18d1 */
        {8,	0}, 	/* 0x18d2 */
        {8,	0}, 	/* 0x18d3 */
        {8,	0}, 	/* 0x18d4 */
        {8,	0}, 	/* 0x18d5 */
        {8,	0}, 	/* 0x18d6 */
        {8,	0}, 	/* 0x18d7 */
        {8,	0}, 	/* 0x18d8 */
        {8,	0}, 	/* 0x18d9 */
        {8,	0}, 	/* 0x18da */
        {8,	0}, 	/* 0x18db */
        {8,	0}, 	/* 0x18dc */
        {8,	0}, 	/* 0x18dd */
        {8,	0}, 	/* 0x18de */
        {8,	0}, 	/* 0x18df */
        {8,	0}, 	/* 0x18e0 */
        {8,	0}, 	/* 0x18e1 */
        {8,	0}, 	/* 0x18e2 */
        {8,	0}, 	/* 0x18e3 */
        {8,	0}, 	/* 0x18e4 */
        {8,	0}, 	/* 0x18e5 */
        {8,	0}, 	/* 0x18e6 */
        {8,	0}, 	/* 0x18e7 */
        {8,	0}, 	/* 0x18e8 */
        {8,	0}, 	/* 0x18e9 */
        {8,	0}, 	/* 0x18ea */
        {8,	0}, 	/* 0x18eb */
        {8,	0}, 	/* 0x18ec */
        {8,	0}, 	/* 0x18ed */
        {8,	0}, 	/* 0x18ee */
        {8,	0}, 	/* 0x18ef */
        {8,	0}, 	/* 0x18f0 */
        {8,	0}, 	/* 0x18f1 */
        {8,	0}, 	/* 0x18f2 */
        {8,	0}, 	/* 0x18f3 */
        {8,	0}, 	/* 0x18f4 */
        {8,	0}, 	/* 0x18f5 */
        {8,	0}, 	/* 0x18f6 */
        {8,	0}, 	/* 0x18f7 */
        {8,	0}, 	/* 0x18f8 */
        {8,	0}, 	/* 0x18f9 */
        {8,	0}, 	/* 0x18fa */
        {8,	0}, 	/* 0x18fb */
        {8,	0}, 	/* 0x18fc */
        {8,	0}, 	/* 0x18fd */
        {8,	0}, 	/* 0x18fe */
        {8,	0}, 	/* 0x18ff */
        {8,	0}, 	/* 0x1900 */
        {8,	0}, 	/* 0x1901 */
        {8,	0}, 	/* 0x1902 */
        {8,	0}, 	/* 0x1903 */
        {8,	0}, 	/* 0x1904 */
        {8,	0}, 	/* 0x1905 */
        {8,	0}, 	/* 0x1906 */
        {8,	0}, 	/* 0x1907 */
        {8,	0}, 	/* 0x1908 */
        {8,	0}, 	/* 0x1909 */
        {8,	0}, 	/* 0x190a */
        {8,	0}, 	/* 0x190b */
        {8,	0}, 	/* 0x190c */
        {8,	0}, 	/* 0x190d */
        {8,	0}, 	/* 0x190e */
        {8,	0}, 	/* 0x190f */
        {8,	0}, 	/* 0x1910 */
        {8,	0}, 	/* 0x1911 */
        {8,	0}, 	/* 0x1912 */
        {8,	0}, 	/* 0x1913 */
        {8,	0}, 	/* 0x1914 */
        {8,	0}, 	/* 0x1915 */
        {8,	0}, 	/* 0x1916 */
        {8,	0}, 	/* 0x1917 */
        {8,	0}, 	/* 0x1918 */
        {8,	0}, 	/* 0x1919 */
        {8,	0}, 	/* 0x191a */
        {8,	0}, 	/* 0x191b */
        {8,	0}, 	/* 0x191c */
        {8,	0}, 	/* 0x191d */
        {8,	0}, 	/* 0x191e */
        {8,	0}, 	/* 0x191f */
        {8,	0}, 	/* 0x1920 */
        {8,	0}, 	/* 0x1921 */
        {8,	0}, 	/* 0x1922 */
        {8,	0}, 	/* 0x1923 */
        {8,	0}, 	/* 0x1924 */
        {8,	0}, 	/* 0x1925 */
        {8,	0}, 	/* 0x1926 */
        {8,	0}, 	/* 0x1927 */
        {8,	0}, 	/* 0x1928 */
        {8,	0}, 	/* 0x1929 */
        {8,	0}, 	/* 0x192a */
        {8,	0}, 	/* 0x192b */
        {8,	0}, 	/* 0x192c */
        {8,	0}, 	/* 0x192d */
        {8,	0}, 	/* 0x192e */
        {8,	0}, 	/* 0x192f */
        {8,	0}, 	/* 0x1930 */
        {8,	0}, 	/* 0x1931 */
        {8,	0}, 	/* 0x1932 */
        {8,	0}, 	/* 0x1933 */
        {8,	0}, 	/* 0x1934 */
        {8,	0}, 	/* 0x1935 */
        {8,	0}, 	/* 0x1936 */
        {8,	0}, 	/* 0x1937 */
        {8,	0}, 	/* 0x1938 */
        {8,	0}, 	/* 0x1939 */
        {8,	0}, 	/* 0x193a */
        {8,	0}, 	/* 0x193b */
        {8,	0}, 	/* 0x193c */
        {8,	0}, 	/* 0x193d */
        {8,	0}, 	/* 0x193e */
        {8,	0}, 	/* 0x193f */
        {8,	0}, 	/* 0x1940 */
        {8,	0}, 	/* 0x1941 */
        {8,	0}, 	/* 0x1942 */
        {8,	0}, 	/* 0x1943 */
        {8,	0}, 	/* 0x1944 */
        {8,	0}, 	/* 0x1945 */
        {8,	0}, 	/* 0x1946 */
        {8,	0}, 	/* 0x1947 */
        {8,	0}, 	/* 0x1948 */
        {8,	0}, 	/* 0x1949 */
        {8,	0}, 	/* 0x194a */
        {8,	0}, 	/* 0x194b */
        {8,	0}, 	/* 0x194c */
        {8,	0}, 	/* 0x194d */
        {8,	0}, 	/* 0x194e */
        {8,	0}, 	/* 0x194f */
        {8,	0}, 	/* 0x1950 */
        {8,	0}, 	/* 0x1951 */
        {8,	0}, 	/* 0x1952 */
        {8,	0}, 	/* 0x1953 */
        {8,	0}, 	/* 0x1954 */
        {8,	0}, 	/* 0x1955 */
        {8,	0}, 	/* 0x1956 */
        {8,	0}, 	/* 0x1957 */
        {8,	0}, 	/* 0x1958 */
        {8,	0}, 	/* 0x1959 */
        {8,	0}, 	/* 0x195a */
        {8,	0}, 	/* 0x195b */
        {8,	0}, 	/* 0x195c */
        {8,	0}, 	/* 0x195d */
        {8,	0}, 	/* 0x195e */
        {8,	0}, 	/* 0x195f */
        {8,	0}, 	/* 0x1960 */
        {8,	0}, 	/* 0x1961 */
        {8,	0}, 	/* 0x1962 */
        {8,	0}, 	/* 0x1963 */
        {8,	0}, 	/* 0x1964 */
        {8,	0}, 	/* 0x1965 */
        {8,	0}, 	/* 0x1966 */
        {8,	0}, 	/* 0x1967 */
        {8,	0}, 	/* 0x1968 */
        {8,	0}, 	/* 0x1969 */
        {8,	0}, 	/* 0x196a */
        {8,	0}, 	/* 0x196b */
        {8,	0}, 	/* 0x196c */
        {8,	0}, 	/* 0x196d */
        {8,	0}, 	/* 0x196e */
        {8,	0}, 	/* 0x196f */
        {8,	0}, 	/* 0x1970 */
        {8,	0}, 	/* 0x1971 */
        {8,	0}, 	/* 0x1972 */
        {8,	0}, 	/* 0x1973 */
        {8,	0}, 	/* 0x1974 */
        {8,	0}, 	/* 0x1975 */
        {8,	0}, 	/* 0x1976 */
        {8,	0}, 	/* 0x1977 */
        {8,	0}, 	/* 0x1978 */
        {8,	0}, 	/* 0x1979 */
        {8,	0}, 	/* 0x197a */
        {8,	0}, 	/* 0x197b */
        {8,	0}, 	/* 0x197c */
        {8,	0}, 	/* 0x197d */
        {8,	0}, 	/* 0x197e */
        {8,	0}, 	/* 0x197f */
        {8,	0}, 	/* 0x1980 */
        {8,	0}, 	/* 0x1981 */
        {8,	0}, 	/* 0x1982 */
        {8,	0}, 	/* 0x1983 */
        {8,	0}, 	/* 0x1984 */
        {8,	0}, 	/* 0x1985 */
        {8,	0}, 	/* 0x1986 */
        {8,	0}, 	/* 0x1987 */
        {8,	0}, 	/* 0x1988 */
        {8,	0}, 	/* 0x1989 */
        {8,	0}, 	/* 0x198a */
        {8,	0}, 	/* 0x198b */
        {8,	0}, 	/* 0x198c */
        {8,	0}, 	/* 0x198d */
        {8,	0}, 	/* 0x198e */
        {8,	0}, 	/* 0x198f */
        {8,	0}, 	/* 0x1990 */
        {8,	0}, 	/* 0x1991 */
        {8,	0}, 	/* 0x1992 */
        {8,	0}, 	/* 0x1993 */
        {8,	0}, 	/* 0x1994 */
        {8,	0}, 	/* 0x1995 */
        {8,	0}, 	/* 0x1996 */
        {8,	0}, 	/* 0x1997 */
        {8,	0}, 	/* 0x1998 */
        {8,	0}, 	/* 0x1999 */
        {8,	0}, 	/* 0x199a */
        {8,	0}, 	/* 0x199b */
        {8,	0}, 	/* 0x199c */
        {8,	0}, 	/* 0x199d */
        {8,	0}, 	/* 0x199e */
        {8,	0}, 	/* 0x199f */
        {8,	0}, 	/* 0x19a0 */
        {8,	0}, 	/* 0x19a1 */
        {8,	0}, 	/* 0x19a2 */
        {8,	0}, 	/* 0x19a3 */
        {8,	0}, 	/* 0x19a4 */
        {8,	0}, 	/* 0x19a5 */
        {8,	0}, 	/* 0x19a6 */
        {8,	0}, 	/* 0x19a7 */
        {8,	0}, 	/* 0x19a8 */
        {8,	0}, 	/* 0x19a9 */
        {8,	0}, 	/* 0x19aa */
        {8,	0}, 	/* 0x19ab */
        {8,	0}, 	/* 0x19ac */
        {8,	0}, 	/* 0x19ad */
        {8,	0}, 	/* 0x19ae */
        {8,	0}, 	/* 0x19af */
        {8,	0}, 	/* 0x19b0 */
        {8,	0}, 	/* 0x19b1 */
        {8,	0}, 	/* 0x19b2 */
        {8,	0}, 	/* 0x19b3 */
        {8,	0}, 	/* 0x19b4 */
        {8,	0}, 	/* 0x19b5 */
        {8,	0}, 	/* 0x19b6 */
        {8,	0}, 	/* 0x19b7 */
        {8,	0}, 	/* 0x19b8 */
        {8,	0}, 	/* 0x19b9 */
        {8,	0}, 	/* 0x19ba */
        {8,	0}, 	/* 0x19bb */
        {8,	0}, 	/* 0x19bc */
        {8,	0}, 	/* 0x19bd */
        {8,	0}, 	/* 0x19be */
        {8,	0}, 	/* 0x19bf */
        {8,	0}, 	/* 0x19c0 */
        {8,	0}, 	/* 0x19c1 */
        {8,	0}, 	/* 0x19c2 */
        {8,	0}, 	/* 0x19c3 */
        {8,	0}, 	/* 0x19c4 */
        {8,	0}, 	/* 0x19c5 */
        {8,	0}, 	/* 0x19c6 */
        {8,	0}, 	/* 0x19c7 */
        {8,	0}, 	/* 0x19c8 */
        {8,	0}, 	/* 0x19c9 */
        {8,	0}, 	/* 0x19ca */
        {8,	0}, 	/* 0x19cb */
        {8,	0}, 	/* 0x19cc */
        {8,	0}, 	/* 0x19cd */
        {8,	0}, 	/* 0x19ce */
        {8,	0}, 	/* 0x19cf */
        {8,	0}, 	/* 0x19d0 */
        {8,	0}, 	/* 0x19d1 */
        {8,	0}, 	/* 0x19d2 */
        {8,	0}, 	/* 0x19d3 */
        {8,	0}, 	/* 0x19d4 */
        {8,	0}, 	/* 0x19d5 */
        {8,	0}, 	/* 0x19d6 */
        {8,	0}, 	/* 0x19d7 */
        {8,	0}, 	/* 0x19d8 */
        {8,	0}, 	/* 0x19d9 */
        {8,	0}, 	/* 0x19da */
        {8,	0}, 	/* 0x19db */
        {8,	0}, 	/* 0x19dc */
        {8,	0}, 	/* 0x19dd */
        {8,	0}, 	/* 0x19de */
        {8,	0}, 	/* 0x19df */
        {8,	0}, 	/* 0x19e0 */
        {8,	0}, 	/* 0x19e1 */
        {8,	0}, 	/* 0x19e2 */
        {8,	0}, 	/* 0x19e3 */
        {8,	0}, 	/* 0x19e4 */
        {8,	0}, 	/* 0x19e5 */
        {8,	0}, 	/* 0x19e6 */
        {8,	0}, 	/* 0x19e7 */
        {8,	0}, 	/* 0x19e8 */
        {8,	0}, 	/* 0x19e9 */
        {8,	0}, 	/* 0x19ea */
        {8,	0}, 	/* 0x19eb */
        {8,	0}, 	/* 0x19ec */
        {8,	0}, 	/* 0x19ed */
        {8,	0}, 	/* 0x19ee */
        {8,	0}, 	/* 0x19ef */
        {8,	0}, 	/* 0x19f0 */
        {8,	0}, 	/* 0x19f1 */
        {8,	0}, 	/* 0x19f2 */
        {8,	0}, 	/* 0x19f3 */
        {8,	0}, 	/* 0x19f4 */
        {8,	0}, 	/* 0x19f5 */
        {8,	0}, 	/* 0x19f6 */
        {8,	0}, 	/* 0x19f7 */
        {8,	0}, 	/* 0x19f8 */
        {8,	0}, 	/* 0x19f9 */
        {8,	0}, 	/* 0x19fa */
        {8,	0}, 	/* 0x19fb */
        {8,	0}, 	/* 0x19fc */
        {8,	0}, 	/* 0x19fd */
        {8,	0}, 	/* 0x19fe */
        {8,	0}, 	/* 0x19ff */
        {8,	0}, 	/* 0x1a00 */
        {8,	0}, 	/* 0x1a01 */
        {8,	0}, 	/* 0x1a02 */
        {8,	0}, 	/* 0x1a03 */
        {8,	0}, 	/* 0x1a04 */
        {8,	0}, 	/* 0x1a05 */
        {8,	0}, 	/* 0x1a06 */
        {8,	0}, 	/* 0x1a07 */
        {8,	0}, 	/* 0x1a08 */
        {8,	0}, 	/* 0x1a09 */
        {8,	0}, 	/* 0x1a0a */
        {8,	0}, 	/* 0x1a0b */
        {8,	0}, 	/* 0x1a0c */
        {8,	0}, 	/* 0x1a0d */
        {8,	0}, 	/* 0x1a0e */
        {8,	0}, 	/* 0x1a0f */
        {8,	0}, 	/* 0x1a10 */
        {8,	0}, 	/* 0x1a11 */
        {8,	0}, 	/* 0x1a12 */
        {8,	0}, 	/* 0x1a13 */
        {8,	0}, 	/* 0x1a14 */
        {8,	0}, 	/* 0x1a15 */
        {8,	0}, 	/* 0x1a16 */
        {8,	0}, 	/* 0x1a17 */
        {8,	0}, 	/* 0x1a18 */
        {8,	0}, 	/* 0x1a19 */
        {8,	0}, 	/* 0x1a1a */
        {8,	0}, 	/* 0x1a1b */
        {8,	0}, 	/* 0x1a1c */
        {8,	0}, 	/* 0x1a1d */
        {8,	0}, 	/* 0x1a1e */
        {8,	0}, 	/* 0x1a1f */
        {8,	0}, 	/* 0x1a20 */
        {8,	0}, 	/* 0x1a21 */
        {8,	0}, 	/* 0x1a22 */
        {8,	0}, 	/* 0x1a23 */
        {8,	0}, 	/* 0x1a24 */
        {8,	0}, 	/* 0x1a25 */
        {8,	0}, 	/* 0x1a26 */
        {8,	0}, 	/* 0x1a27 */
        {8,	0}, 	/* 0x1a28 */
        {8,	0}, 	/* 0x1a29 */
        {8,	0}, 	/* 0x1a2a */
        {8,	0}, 	/* 0x1a2b */
        {8,	0}, 	/* 0x1a2c */
        {8,	0}, 	/* 0x1a2d */
        {8,	0}, 	/* 0x1a2e */
        {8,	0}, 	/* 0x1a2f */
        {8,	0}, 	/* 0x1a30 */
        {8,	0}, 	/* 0x1a31 */
        {8,	0}, 	/* 0x1a32 */
        {8,	0}, 	/* 0x1a33 */
        {8,	0}, 	/* 0x1a34 */
        {8,	0}, 	/* 0x1a35 */
        {8,	0}, 	/* 0x1a36 */
        {8,	0}, 	/* 0x1a37 */
        {8,	0}, 	/* 0x1a38 */
        {8,	0}, 	/* 0x1a39 */
        {8,	0}, 	/* 0x1a3a */
        {8,	0}, 	/* 0x1a3b */
        {8,	0}, 	/* 0x1a3c */
        {8,	0}, 	/* 0x1a3d */
        {8,	0}, 	/* 0x1a3e */
        {8,	0}, 	/* 0x1a3f */
        {8,	0}, 	/* 0x1a40 */
        {8,	0}, 	/* 0x1a41 */
        {8,	0}, 	/* 0x1a42 */
        {8,	0}, 	/* 0x1a43 */
        {8,	0}, 	/* 0x1a44 */
        {8,	0}, 	/* 0x1a45 */
        {8,	0}, 	/* 0x1a46 */
        {8,	0}, 	/* 0x1a47 */
        {8,	0}, 	/* 0x1a48 */
        {8,	0}, 	/* 0x1a49 */
        {8,	0}, 	/* 0x1a4a */
        {8,	0}, 	/* 0x1a4b */
        {8,	0}, 	/* 0x1a4c */
        {8,	0}, 	/* 0x1a4d */
        {8,	0}, 	/* 0x1a4e */
        {8,	0}, 	/* 0x1a4f */
        {8,	0}, 	/* 0x1a50 */
        {8,	0}, 	/* 0x1a51 */
        {8,	0}, 	/* 0x1a52 */
        {8,	0}, 	/* 0x1a53 */
        {8,	0}, 	/* 0x1a54 */
        {8,	0}, 	/* 0x1a55 */
        {8,	0}, 	/* 0x1a56 */
        {8,	0}, 	/* 0x1a57 */
        {8,	0}, 	/* 0x1a58 */
        {8,	0}, 	/* 0x1a59 */
        {8,	0}, 	/* 0x1a5a */
        {8,	0}, 	/* 0x1a5b */
        {8,	0}, 	/* 0x1a5c */
        {8,	0}, 	/* 0x1a5d */
        {8,	0}, 	/* 0x1a5e */
        {8,	0}, 	/* 0x1a5f */
        {8,	0}, 	/* 0x1a60 */
        {8,	0}, 	/* 0x1a61 */
        {8,	0}, 	/* 0x1a62 */
        {8,	0}, 	/* 0x1a63 */
        {8,	0}, 	/* 0x1a64 */
        {8,	0}, 	/* 0x1a65 */
        {8,	0}, 	/* 0x1a66 */
        {8,	0}, 	/* 0x1a67 */
        {8,	0}, 	/* 0x1a68 */
        {8,	0}, 	/* 0x1a69 */
        {8,	0}, 	/* 0x1a6a */
        {8,	0}, 	/* 0x1a6b */
        {8,	0}, 	/* 0x1a6c */
        {8,	0}, 	/* 0x1a6d */
        {8,	0}, 	/* 0x1a6e */
        {8,	0}, 	/* 0x1a6f */
        {8,	0}, 	/* 0x1a70 */
        {8,	0}, 	/* 0x1a71 */
        {8,	0}, 	/* 0x1a72 */
        {8,	0}, 	/* 0x1a73 */
        {8,	0}, 	/* 0x1a74 */
        {8,	0}, 	/* 0x1a75 */
        {8,	0}, 	/* 0x1a76 */
        {8,	0}, 	/* 0x1a77 */
        {8,	0}, 	/* 0x1a78 */
        {8,	0}, 	/* 0x1a79 */
        {8,	0}, 	/* 0x1a7a */
        {8,	0}, 	/* 0x1a7b */
        {8,	0}, 	/* 0x1a7c */
        {8,	0}, 	/* 0x1a7d */
        {8,	0}, 	/* 0x1a7e */
        {8,	0}, 	/* 0x1a7f */
        {8,	0}, 	/* 0x1a80 */
        {8,	0}, 	/* 0x1a81 */
        {8,	0}, 	/* 0x1a82 */
        {8,	0}, 	/* 0x1a83 */
        {8,	0}, 	/* 0x1a84 */
        {8,	0}, 	/* 0x1a85 */
        {8,	0}, 	/* 0x1a86 */
        {8,	0}, 	/* 0x1a87 */
        {8,	0}, 	/* 0x1a88 */
        {8,	0}, 	/* 0x1a89 */
        {8,	0}, 	/* 0x1a8a */
        {8,	0}, 	/* 0x1a8b */
        {8,	0}, 	/* 0x1a8c */
        {8,	0}, 	/* 0x1a8d */
        {8,	0}, 	/* 0x1a8e */
        {8,	0}, 	/* 0x1a8f */
        {8,	0}, 	/* 0x1a90 */
        {8,	0}, 	/* 0x1a91 */
        {8,	0}, 	/* 0x1a92 */
        {8,	0}, 	/* 0x1a93 */
        {8,	0}, 	/* 0x1a94 */
        {8,	0}, 	/* 0x1a95 */
        {8,	0}, 	/* 0x1a96 */
        {8,	0}, 	/* 0x1a97 */
        {8,	0}, 	/* 0x1a98 */
        {8,	0}, 	/* 0x1a99 */
        {8,	0}, 	/* 0x1a9a */
        {8,	0}, 	/* 0x1a9b */
        {8,	0}, 	/* 0x1a9c */
        {8,	0}, 	/* 0x1a9d */
        {8,	0}, 	/* 0x1a9e */
        {8,	0}, 	/* 0x1a9f */
        {8,	0}, 	/* 0x1aa0 */
        {8,	0}, 	/* 0x1aa1 */
        {8,	0}, 	/* 0x1aa2 */
        {8,	0}, 	/* 0x1aa3 */
        {8,	0}, 	/* 0x1aa4 */
        {8,	0}, 	/* 0x1aa5 */
        {8,	0}, 	/* 0x1aa6 */
        {8,	0}, 	/* 0x1aa7 */
        {8,	0}, 	/* 0x1aa8 */
        {8,	0}, 	/* 0x1aa9 */
        {8,	0}, 	/* 0x1aaa */
        {8,	0}, 	/* 0x1aab */
        {8,	0}, 	/* 0x1aac */
        {8,	0}, 	/* 0x1aad */
        {8,	0}, 	/* 0x1aae */
        {8,	0}, 	/* 0x1aaf */
        {8,	0}, 	/* 0x1ab0 */
        {8,	0}, 	/* 0x1ab1 */
        {8,	0}, 	/* 0x1ab2 */
        {8,	0}, 	/* 0x1ab3 */
        {8,	0}, 	/* 0x1ab4 */
        {8,	0}, 	/* 0x1ab5 */
        {8,	0}, 	/* 0x1ab6 */
        {8,	0}, 	/* 0x1ab7 */
        {8,	0}, 	/* 0x1ab8 */
        {8,	0}, 	/* 0x1ab9 */
        {8,	0}, 	/* 0x1aba */
        {8,	0}, 	/* 0x1abb */
        {8,	0}, 	/* 0x1abc */
        {8,	0}, 	/* 0x1abd */
        {8,	0}, 	/* 0x1abe */
        {8,	0}, 	/* 0x1abf */
        {8,	0}, 	/* 0x1ac0 */
        {8,	0}, 	/* 0x1ac1 */
        {8,	0}, 	/* 0x1ac2 */
        {8,	0}, 	/* 0x1ac3 */
        {8,	0}, 	/* 0x1ac4 */
        {8,	0}, 	/* 0x1ac5 */
        {8,	0}, 	/* 0x1ac6 */
        {8,	0}, 	/* 0x1ac7 */
        {8,	0}, 	/* 0x1ac8 */
        {8,	0}, 	/* 0x1ac9 */
        {8,	0}, 	/* 0x1aca */
        {8,	0}, 	/* 0x1acb */
        {8,	0}, 	/* 0x1acc */
        {8,	0}, 	/* 0x1acd */
        {8,	0}, 	/* 0x1ace */
        {8,	0}, 	/* 0x1acf */
        {8,	0}, 	/* 0x1ad0 */
        {8,	0}, 	/* 0x1ad1 */
        {8,	0}, 	/* 0x1ad2 */
        {8,	0}, 	/* 0x1ad3 */
        {8,	0}, 	/* 0x1ad4 */
        {8,	0}, 	/* 0x1ad5 */
        {8,	0}, 	/* 0x1ad6 */
        {8,	0}, 	/* 0x1ad7 */
        {8,	0}, 	/* 0x1ad8 */
        {8,	0}, 	/* 0x1ad9 */
        {8,	0}, 	/* 0x1ada */
        {8,	0}, 	/* 0x1adb */
        {8,	0}, 	/* 0x1adc */
        {8,	0}, 	/* 0x1add */
        {8,	0}, 	/* 0x1ade */
        {8,	0}, 	/* 0x1adf */
        {8,	0}, 	/* 0x1ae0 */
        {8,	0}, 	/* 0x1ae1 */
        {8,	0}, 	/* 0x1ae2 */
        {8,	0}, 	/* 0x1ae3 */
        {8,	0}, 	/* 0x1ae4 */
        {8,	0}, 	/* 0x1ae5 */
        {8,	0}, 	/* 0x1ae6 */
        {8,	0}, 	/* 0x1ae7 */
        {8,	0}, 	/* 0x1ae8 */
        {8,	0}, 	/* 0x1ae9 */
        {8,	0}, 	/* 0x1aea */
        {8,	0}, 	/* 0x1aeb */
        {8,	0}, 	/* 0x1aec */
        {8,	0}, 	/* 0x1aed */
        {8,	0}, 	/* 0x1aee */
        {8,	0}, 	/* 0x1aef */
        {8,	0}, 	/* 0x1af0 */
        {8,	0}, 	/* 0x1af1 */
        {8,	0}, 	/* 0x1af2 */
        {8,	0}, 	/* 0x1af3 */
        {8,	0}, 	/* 0x1af4 */
        {8,	0}, 	/* 0x1af5 */
        {8,	0}, 	/* 0x1af6 */
        {8,	0}, 	/* 0x1af7 */
        {8,	0}, 	/* 0x1af8 */
        {8,	0}, 	/* 0x1af9 */
        {8,	0}, 	/* 0x1afa */
        {8,	0}, 	/* 0x1afb */
        {8,	0}, 	/* 0x1afc */
        {8,	0}, 	/* 0x1afd */
        {8,	0}, 	/* 0x1afe */
        {8,	0}, 	/* 0x1aff */
        {8,	0}, 	/* 0x1b00 */
        {8,	0}, 	/* 0x1b01 */
        {8,	0}, 	/* 0x1b02 */
        {8,	0}, 	/* 0x1b03 */
        {8,	0}, 	/* 0x1b04 */
        {8,	0}, 	/* 0x1b05 */
        {8,	0}, 	/* 0x1b06 */
        {8,	0}, 	/* 0x1b07 */
        {8,	0}, 	/* 0x1b08 */
        {8,	0}, 	/* 0x1b09 */
        {8,	0}, 	/* 0x1b0a */
        {8,	0}, 	/* 0x1b0b */
        {8,	0}, 	/* 0x1b0c */
        {8,	0}, 	/* 0x1b0d */
        {8,	0}, 	/* 0x1b0e */
        {8,	0}, 	/* 0x1b0f */
        {8,	0}, 	/* 0x1b10 */
        {8,	0}, 	/* 0x1b11 */
        {8,	0}, 	/* 0x1b12 */
        {8,	0}, 	/* 0x1b13 */
        {8,	0}, 	/* 0x1b14 */
        {8,	0}, 	/* 0x1b15 */
        {8,	0}, 	/* 0x1b16 */
        {8,	0}, 	/* 0x1b17 */
        {8,	0}, 	/* 0x1b18 */
        {8,	0}, 	/* 0x1b19 */
        {8,	0}, 	/* 0x1b1a */
        {8,	0}, 	/* 0x1b1b */
        {8,	0}, 	/* 0x1b1c */
        {8,	0}, 	/* 0x1b1d */
        {8,	0}, 	/* 0x1b1e */
        {8,	0}, 	/* 0x1b1f */
        {8,	0}, 	/* 0x1b20 */
        {8,	0}, 	/* 0x1b21 */
        {8,	0}, 	/* 0x1b22 */
        {8,	0}, 	/* 0x1b23 */
        {8,	0}, 	/* 0x1b24 */
        {8,	0}, 	/* 0x1b25 */
        {8,	0}, 	/* 0x1b26 */
        {8,	0}, 	/* 0x1b27 */
        {8,	0}, 	/* 0x1b28 */
        {8,	0}, 	/* 0x1b29 */
        {8,	0}, 	/* 0x1b2a */
        {8,	0}, 	/* 0x1b2b */
        {8,	0}, 	/* 0x1b2c */
        {8,	0}, 	/* 0x1b2d */
        {8,	0}, 	/* 0x1b2e */
        {8,	0}, 	/* 0x1b2f */
        {8,	0}, 	/* 0x1b30 */
        {8,	0}, 	/* 0x1b31 */
        {8,	0}, 	/* 0x1b32 */
        {8,	0}, 	/* 0x1b33 */
        {8,	0}, 	/* 0x1b34 */
        {8,	0}, 	/* 0x1b35 */
        {8,	0}, 	/* 0x1b36 */
        {8,	0}, 	/* 0x1b37 */
        {8,	0}, 	/* 0x1b38 */
        {8,	0}, 	/* 0x1b39 */
        {8,	0}, 	/* 0x1b3a */
        {8,	0}, 	/* 0x1b3b */
        {8,	0}, 	/* 0x1b3c */
        {8,	0}, 	/* 0x1b3d */
        {8,	0}, 	/* 0x1b3e */
        {8,	0}, 	/* 0x1b3f */
        {8,	0}, 	/* 0x1b40 */
        {8,	0}, 	/* 0x1b41 */
        {8,	0}, 	/* 0x1b42 */
        {8,	0}, 	/* 0x1b43 */
        {8,	0}, 	/* 0x1b44 */
        {8,	0}, 	/* 0x1b45 */
        {8,	0}, 	/* 0x1b46 */
        {8,	0}, 	/* 0x1b47 */
        {8,	0}, 	/* 0x1b48 */
        {8,	0}, 	/* 0x1b49 */
        {8,	0}, 	/* 0x1b4a */
        {8,	0}, 	/* 0x1b4b */
        {8,	0}, 	/* 0x1b4c */
        {8,	0}, 	/* 0x1b4d */
        {8,	0}, 	/* 0x1b4e */
        {8,	0}, 	/* 0x1b4f */
        {8,	0}, 	/* 0x1b50 */
        {8,	0}, 	/* 0x1b51 */
        {8,	0}, 	/* 0x1b52 */
        {8,	0}, 	/* 0x1b53 */
        {8,	0}, 	/* 0x1b54 */
        {8,	0}, 	/* 0x1b55 */
        {8,	0}, 	/* 0x1b56 */
        {8,	0}, 	/* 0x1b57 */
        {8,	0}, 	/* 0x1b58 */
        {8,	0}, 	/* 0x1b59 */
        {8,	0}, 	/* 0x1b5a */
        {8,	0}, 	/* 0x1b5b */
        {8,	0}, 	/* 0x1b5c */
        {8,	0}, 	/* 0x1b5d */
        {8,	0}, 	/* 0x1b5e */
        {8,	0}, 	/* 0x1b5f */
        {8,	0}, 	/* 0x1b60 */
        {8,	0}, 	/* 0x1b61 */
        {8,	0}, 	/* 0x1b62 */
        {8,	0}, 	/* 0x1b63 */
        {8,	0}, 	/* 0x1b64 */
        {8,	0}, 	/* 0x1b65 */
        {8,	0}, 	/* 0x1b66 */
        {8,	0}, 	/* 0x1b67 */
        {8,	0}, 	/* 0x1b68 */
        {8,	0}, 	/* 0x1b69 */
        {8,	0}, 	/* 0x1b6a */
        {8,	0}, 	/* 0x1b6b */
        {8,	0}, 	/* 0x1b6c */
        {8,	0}, 	/* 0x1b6d */
        {8,	0}, 	/* 0x1b6e */
        {8,	0}, 	/* 0x1b6f */
        {8,	0}, 	/* 0x1b70 */
        {8,	0}, 	/* 0x1b71 */
        {8,	0}, 	/* 0x1b72 */
        {8,	0}, 	/* 0x1b73 */
        {8,	0}, 	/* 0x1b74 */
        {8,	0}, 	/* 0x1b75 */
        {8,	0}, 	/* 0x1b76 */
        {8,	0}, 	/* 0x1b77 */
        {8,	0}, 	/* 0x1b78 */
        {8,	0}, 	/* 0x1b79 */
        {8,	0}, 	/* 0x1b7a */
        {8,	0}, 	/* 0x1b7b */
        {8,	0}, 	/* 0x1b7c */
        {8,	0}, 	/* 0x1b7d */
        {8,	0}, 	/* 0x1b7e */
        {8,	0}, 	/* 0x1b7f */
        {8,	0}, 	/* 0x1b80 */
        {8,	0}, 	/* 0x1b81 */
        {8,	0}, 	/* 0x1b82 */
        {8,	0}, 	/* 0x1b83 */
        {8,	0}, 	/* 0x1b84 */
        {8,	0}, 	/* 0x1b85 */
        {8,	0}, 	/* 0x1b86 */
        {8,	0}, 	/* 0x1b87 */
        {8,	0}, 	/* 0x1b88 */
        {8,	0}, 	/* 0x1b89 */
        {8,	0}, 	/* 0x1b8a */
        {8,	0}, 	/* 0x1b8b */
        {8,	0}, 	/* 0x1b8c */
        {8,	0}, 	/* 0x1b8d */
        {8,	0}, 	/* 0x1b8e */
        {8,	0}, 	/* 0x1b8f */
        {8,	0}, 	/* 0x1b90 */
        {8,	0}, 	/* 0x1b91 */
        {8,	0}, 	/* 0x1b92 */
        {8,	0}, 	/* 0x1b93 */
        {8,	0}, 	/* 0x1b94 */
        {8,	0}, 	/* 0x1b95 */
        {8,	0}, 	/* 0x1b96 */
        {8,	0}, 	/* 0x1b97 */
        {8,	0}, 	/* 0x1b98 */
        {8,	0}, 	/* 0x1b99 */
        {8,	0}, 	/* 0x1b9a */
        {8,	0}, 	/* 0x1b9b */
        {8,	0}, 	/* 0x1b9c */
        {8,	0}, 	/* 0x1b9d */
        {8,	0}, 	/* 0x1b9e */
        {8,	0}, 	/* 0x1b9f */
        {8,	0}, 	/* 0x1ba0 */
        {8,	0}, 	/* 0x1ba1 */
        {8,	0}, 	/* 0x1ba2 */
        {8,	0}, 	/* 0x1ba3 */
        {8,	0}, 	/* 0x1ba4 */
        {8,	0}, 	/* 0x1ba5 */
        {8,	0}, 	/* 0x1ba6 */
        {8,	0}, 	/* 0x1ba7 */
        {8,	0}, 	/* 0x1ba8 */
        {8,	0}, 	/* 0x1ba9 */
        {8,	0}, 	/* 0x1baa */
        {8,	0}, 	/* 0x1bab */
        {8,	0}, 	/* 0x1bac */
        {8,	0}, 	/* 0x1bad */
        {8,	0}, 	/* 0x1bae */
        {8,	0}, 	/* 0x1baf */
        {8,	0}, 	/* 0x1bb0 */
        {8,	0}, 	/* 0x1bb1 */
        {8,	0}, 	/* 0x1bb2 */
        {8,	0}, 	/* 0x1bb3 */
        {8,	0}, 	/* 0x1bb4 */
        {8,	0}, 	/* 0x1bb5 */
        {8,	0}, 	/* 0x1bb6 */
        {8,	0}, 	/* 0x1bb7 */
        {8,	0}, 	/* 0x1bb8 */
        {8,	0}, 	/* 0x1bb9 */
        {8,	0}, 	/* 0x1bba */
        {8,	0}, 	/* 0x1bbb */
        {8,	0}, 	/* 0x1bbc */
        {8,	0}, 	/* 0x1bbd */
        {8,	0}, 	/* 0x1bbe */
        {8,	0}, 	/* 0x1bbf */
        {8,	0}, 	/* 0x1bc0 */
        {8,	0}, 	/* 0x1bc1 */
        {8,	0}, 	/* 0x1bc2 */
        {8,	0}, 	/* 0x1bc3 */
        {8,	0}, 	/* 0x1bc4 */
        {8,	0}, 	/* 0x1bc5 */
        {8,	0}, 	/* 0x1bc6 */
        {8,	0}, 	/* 0x1bc7 */
        {8,	0}, 	/* 0x1bc8 */
        {8,	0}, 	/* 0x1bc9 */
        {8,	0}, 	/* 0x1bca */
        {8,	0}, 	/* 0x1bcb */
        {8,	0}, 	/* 0x1bcc */
        {8,	0}, 	/* 0x1bcd */
        {8,	0}, 	/* 0x1bce */
        {8,	0}, 	/* 0x1bcf */
        {8,	0}, 	/* 0x1bd0 */
        {8,	0}, 	/* 0x1bd1 */
        {8,	0}, 	/* 0x1bd2 */
        {8,	0}, 	/* 0x1bd3 */
        {8,	0}, 	/* 0x1bd4 */
        {8,	0}, 	/* 0x1bd5 */
        {8,	0}, 	/* 0x1bd6 */
        {8,	0}, 	/* 0x1bd7 */
        {8,	0}, 	/* 0x1bd8 */
        {8,	0}, 	/* 0x1bd9 */
        {8,	0}, 	/* 0x1bda */
        {8,	0}, 	/* 0x1bdb */
        {8,	0}, 	/* 0x1bdc */
        {8,	0}, 	/* 0x1bdd */
        {8,	0}, 	/* 0x1bde */
        {8,	0}, 	/* 0x1bdf */
        {8,	0}, 	/* 0x1be0 */
        {8,	0}, 	/* 0x1be1 */
        {8,	0}, 	/* 0x1be2 */
        {8,	0}, 	/* 0x1be3 */
        {8,	0}, 	/* 0x1be4 */
        {8,	0}, 	/* 0x1be5 */
        {8,	0}, 	/* 0x1be6 */
        {8,	0}, 	/* 0x1be7 */
        {8,	0}, 	/* 0x1be8 */
        {8,	0}, 	/* 0x1be9 */
        {8,	0}, 	/* 0x1bea */
        {8,	0}, 	/* 0x1beb */
        {8,	0}, 	/* 0x1bec */
        {8,	0}, 	/* 0x1bed */
        {8,	0}, 	/* 0x1bee */
        {8,	0}, 	/* 0x1bef */
        {8,	0}, 	/* 0x1bf0 */
        {8,	0}, 	/* 0x1bf1 */
        {8,	0}, 	/* 0x1bf2 */
        {8,	0}, 	/* 0x1bf3 */
        {8,	0}, 	/* 0x1bf4 */
        {8,	0}, 	/* 0x1bf5 */
        {8,	0}, 	/* 0x1bf6 */
        {8,	0}, 	/* 0x1bf7 */
        {8,	0}, 	/* 0x1bf8 */
        {8,	0}, 	/* 0x1bf9 */
        {8,	0}, 	/* 0x1bfa */
        {8,	0}, 	/* 0x1bfb */
        {8,	0}, 	/* 0x1bfc */
        {8,	0}, 	/* 0x1bfd */
        {8,	0}, 	/* 0x1bfe */
        {8,	0}, 	/* 0x1bff */
        {8,	0}, 	/* 0x1c00 */
        {8,	0}, 	/* 0x1c01 */
        {8,	0}, 	/* 0x1c02 */
        {8,	0}, 	/* 0x1c03 */
        {8,	0}, 	/* 0x1c04 */
        {8,	0}, 	/* 0x1c05 */
        {8,	0}, 	/* 0x1c06 */
        {8,	0}, 	/* 0x1c07 */
        {8,	0}, 	/* 0x1c08 */
        {8,	0}, 	/* 0x1c09 */
        {8,	0}, 	/* 0x1c0a */
        {8,	0}, 	/* 0x1c0b */
        {8,	0}, 	/* 0x1c0c */
        {8,	0}, 	/* 0x1c0d */
        {8,	0}, 	/* 0x1c0e */
        {8,	0}, 	/* 0x1c0f */
        {8,	0}, 	/* 0x1c10 */
        {8,	0}, 	/* 0x1c11 */
        {8,	0}, 	/* 0x1c12 */
        {8,	0}, 	/* 0x1c13 */
        {8,	0}, 	/* 0x1c14 */
        {8,	0}, 	/* 0x1c15 */
        {8,	0}, 	/* 0x1c16 */
        {8,	0}, 	/* 0x1c17 */
        {8,	0}, 	/* 0x1c18 */
        {8,	0}, 	/* 0x1c19 */
        {8,	0}, 	/* 0x1c1a */
        {8,	0}, 	/* 0x1c1b */
        {8,	0}, 	/* 0x1c1c */
        {8,	0}, 	/* 0x1c1d */
        {8,	0}, 	/* 0x1c1e */
        {8,	0}, 	/* 0x1c1f */
        {8,	0}, 	/* 0x1c20 */
        {8,	0}, 	/* 0x1c21 */
        {8,	0}, 	/* 0x1c22 */
        {8,	0}, 	/* 0x1c23 */
        {8,	0}, 	/* 0x1c24 */
        {8,	0}, 	/* 0x1c25 */
        {8,	0}, 	/* 0x1c26 */
        {8,	0}, 	/* 0x1c27 */
        {8,	0}, 	/* 0x1c28 */
        {8,	0}, 	/* 0x1c29 */
        {8,	0}, 	/* 0x1c2a */
        {8,	0}, 	/* 0x1c2b */
        {8,	0}, 	/* 0x1c2c */
        {8,	0}, 	/* 0x1c2d */
        {8,	0}, 	/* 0x1c2e */
        {8,	0}, 	/* 0x1c2f */
        {8,	0}, 	/* 0x1c30 */
        {8,	0}, 	/* 0x1c31 */
        {8,	0}, 	/* 0x1c32 */
        {8,	0}, 	/* 0x1c33 */
        {8,	0}, 	/* 0x1c34 */
        {8,	0}, 	/* 0x1c35 */
        {8,	0}, 	/* 0x1c36 */
        {8,	0}, 	/* 0x1c37 */
        {8,	0}, 	/* 0x1c38 */
        {8,	0}, 	/* 0x1c39 */
        {8,	0}, 	/* 0x1c3a */
        {8,	0}, 	/* 0x1c3b */
        {8,	0}, 	/* 0x1c3c */
        {8,	0}, 	/* 0x1c3d */
        {8,	0}, 	/* 0x1c3e */
        {8,	0}, 	/* 0x1c3f */
        {8,	0}, 	/* 0x1c40 */
        {8,	0}, 	/* 0x1c41 */
        {8,	0}, 	/* 0x1c42 */
        {8,	0}, 	/* 0x1c43 */
        {8,	0}, 	/* 0x1c44 */
        {8,	0}, 	/* 0x1c45 */
        {8,	0}, 	/* 0x1c46 */
        {8,	0}, 	/* 0x1c47 */
        {8,	0}, 	/* 0x1c48 */
        {8,	0}, 	/* 0x1c49 */
        {8,	0}, 	/* 0x1c4a */
        {8,	0}, 	/* 0x1c4b */
        {8,	0}, 	/* 0x1c4c */
        {8,	0}, 	/* 0x1c4d */
        {8,	0}, 	/* 0x1c4e */
        {8,	0}, 	/* 0x1c4f */
        {8,	0}, 	/* 0x1c50 */
        {8,	0}, 	/* 0x1c51 */
        {8,	0}, 	/* 0x1c52 */
        {8,	0}, 	/* 0x1c53 */
        {8,	0}, 	/* 0x1c54 */
        {8,	0}, 	/* 0x1c55 */
        {8,	0}, 	/* 0x1c56 */
        {8,	0}, 	/* 0x1c57 */
        {8,	0}, 	/* 0x1c58 */
        {8,	0}, 	/* 0x1c59 */
        {8,	0}, 	/* 0x1c5a */
        {8,	0}, 	/* 0x1c5b */
        {8,	0}, 	/* 0x1c5c */
        {8,	0}, 	/* 0x1c5d */
        {8,	0}, 	/* 0x1c5e */
        {8,	0}, 	/* 0x1c5f */
        {8,	0}, 	/* 0x1c60 */
        {8,	0}, 	/* 0x1c61 */
        {8,	0}, 	/* 0x1c62 */
        {8,	0}, 	/* 0x1c63 */
        {8,	0}, 	/* 0x1c64 */
        {8,	0}, 	/* 0x1c65 */
        {8,	0}, 	/* 0x1c66 */
        {8,	0}, 	/* 0x1c67 */
        {8,	0}, 	/* 0x1c68 */
        {8,	0}, 	/* 0x1c69 */
        {8,	0}, 	/* 0x1c6a */
        {8,	0}, 	/* 0x1c6b */
        {8,	0}, 	/* 0x1c6c */
        {8,	0}, 	/* 0x1c6d */
        {8,	0}, 	/* 0x1c6e */
        {8,	0}, 	/* 0x1c6f */
        {8,	0}, 	/* 0x1c70 */
        {8,	0}, 	/* 0x1c71 */
        {8,	0}, 	/* 0x1c72 */
        {8,	0}, 	/* 0x1c73 */
        {8,	0}, 	/* 0x1c74 */
        {8,	0}, 	/* 0x1c75 */
        {8,	0}, 	/* 0x1c76 */
        {8,	0}, 	/* 0x1c77 */
        {8,	0}, 	/* 0x1c78 */
        {8,	0}, 	/* 0x1c79 */
        {8,	0}, 	/* 0x1c7a */
        {8,	0}, 	/* 0x1c7b */
        {8,	0}, 	/* 0x1c7c */
        {8,	0}, 	/* 0x1c7d */
        {8,	0}, 	/* 0x1c7e */
        {8,	0}, 	/* 0x1c7f */
        {8,	0}, 	/* 0x1c80 */
        {8,	0}, 	/* 0x1c81 */
        {8,	0}, 	/* 0x1c82 */
        {8,	0}, 	/* 0x1c83 */
        {8,	0}, 	/* 0x1c84 */
        {8,	0}, 	/* 0x1c85 */
        {8,	0}, 	/* 0x1c86 */
        {8,	0}, 	/* 0x1c87 */
        {8,	0}, 	/* 0x1c88 */
        {8,	0}, 	/* 0x1c89 */
        {8,	0}, 	/* 0x1c8a */
        {8,	0}, 	/* 0x1c8b */
        {8,	0}, 	/* 0x1c8c */
        {8,	0}, 	/* 0x1c8d */
        {8,	0}, 	/* 0x1c8e */
        {8,	0}, 	/* 0x1c8f */
        {8,	0}, 	/* 0x1c90 */
        {8,	0}, 	/* 0x1c91 */
        {8,	0}, 	/* 0x1c92 */
        {8,	0}, 	/* 0x1c93 */
        {8,	0}, 	/* 0x1c94 */
        {8,	0}, 	/* 0x1c95 */
        {8,	0}, 	/* 0x1c96 */
        {8,	0}, 	/* 0x1c97 */
        {8,	0}, 	/* 0x1c98 */
        {8,	0}, 	/* 0x1c99 */
        {8,	0}, 	/* 0x1c9a */
        {8,	0}, 	/* 0x1c9b */
        {8,	0}, 	/* 0x1c9c */
        {8,	0}, 	/* 0x1c9d */
        {8,	0}, 	/* 0x1c9e */
        {8,	0}, 	/* 0x1c9f */
        {8,	0}, 	/* 0x1ca0 */
        {8,	0}, 	/* 0x1ca1 */
        {8,	0}, 	/* 0x1ca2 */
        {8,	0}, 	/* 0x1ca3 */
        {8,	0}, 	/* 0x1ca4 */
        {8,	0}, 	/* 0x1ca5 */
        {8,	0}, 	/* 0x1ca6 */
        {8,	0}, 	/* 0x1ca7 */
        {8,	0}, 	/* 0x1ca8 */
        {8,	0}, 	/* 0x1ca9 */
        {8,	0}, 	/* 0x1caa */
        {8,	0}, 	/* 0x1cab */
        {8,	0}, 	/* 0x1cac */
        {8,	0}, 	/* 0x1cad */
        {8,	0}, 	/* 0x1cae */
        {8,	0}, 	/* 0x1caf */
        {8,	0}, 	/* 0x1cb0 */
        {8,	0}, 	/* 0x1cb1 */
        {8,	0}, 	/* 0x1cb2 */
        {8,	0}, 	/* 0x1cb3 */
        {8,	0}, 	/* 0x1cb4 */
        {8,	0}, 	/* 0x1cb5 */
        {8,	0}, 	/* 0x1cb6 */
        {8,	0}, 	/* 0x1cb7 */
        {8,	0}, 	/* 0x1cb8 */
        {8,	0}, 	/* 0x1cb9 */
        {8,	0}, 	/* 0x1cba */
        {8,	0}, 	/* 0x1cbb */
        {8,	0}, 	/* 0x1cbc */
        {8,	0}, 	/* 0x1cbd */
        {8,	0}, 	/* 0x1cbe */
        {8,	0}, 	/* 0x1cbf */
        {8,	0}, 	/* 0x1cc0 */
        {8,	0}, 	/* 0x1cc1 */
        {8,	0}, 	/* 0x1cc2 */
        {8,	0}, 	/* 0x1cc3 */
        {8,	0}, 	/* 0x1cc4 */
        {8,	0}, 	/* 0x1cc5 */
        {8,	0}, 	/* 0x1cc6 */
        {8,	0}, 	/* 0x1cc7 */
        {8,	0}, 	/* 0x1cc8 */
        {8,	0}, 	/* 0x1cc9 */
        {8,	0}, 	/* 0x1cca */
        {8,	0}, 	/* 0x1ccb */
        {8,	0}, 	/* 0x1ccc */
        {8,	0}, 	/* 0x1ccd */
        {8,	0}, 	/* 0x1cce */
        {8,	0}, 	/* 0x1ccf */
        {8,	0}, 	/* 0x1cd0 */
        {8,	0}, 	/* 0x1cd1 */
        {8,	0}, 	/* 0x1cd2 */
        {8,	0}, 	/* 0x1cd3 */
        {8,	0}, 	/* 0x1cd4 */
        {8,	0}, 	/* 0x1cd5 */
        {8,	0}, 	/* 0x1cd6 */
        {8,	0}, 	/* 0x1cd7 */
        {8,	0}, 	/* 0x1cd8 */
        {8,	0}, 	/* 0x1cd9 */
        {8,	0}, 	/* 0x1cda */
        {8,	0}, 	/* 0x1cdb */
        {8,	0}, 	/* 0x1cdc */
        {8,	0}, 	/* 0x1cdd */
        {8,	0}, 	/* 0x1cde */
        {8,	0}, 	/* 0x1cdf */
        {8,	0}, 	/* 0x1ce0 */
        {8,	0}, 	/* 0x1ce1 */
        {8,	0}, 	/* 0x1ce2 */
        {8,	0}, 	/* 0x1ce3 */
        {8,	0}, 	/* 0x1ce4 */
        {8,	0}, 	/* 0x1ce5 */
        {8,	0}, 	/* 0x1ce6 */
        {8,	0}, 	/* 0x1ce7 */
        {8,	0}, 	/* 0x1ce8 */
        {8,	0}, 	/* 0x1ce9 */
        {8,	0}, 	/* 0x1cea */
        {8,	0}, 	/* 0x1ceb */
        {8,	0}, 	/* 0x1cec */
        {8,	0}, 	/* 0x1ced */
        {8,	0}, 	/* 0x1cee */
        {8,	0}, 	/* 0x1cef */
        {8,	0}, 	/* 0x1cf0 */
        {8,	0}, 	/* 0x1cf1 */
        {8,	0}, 	/* 0x1cf2 */
        {8,	0}, 	/* 0x1cf3 */
        {8,	0}, 	/* 0x1cf4 */
        {8,	0}, 	/* 0x1cf5 */
        {8,	0}, 	/* 0x1cf6 */
        {8,	0}, 	/* 0x1cf7 */
        {8,	0}, 	/* 0x1cf8 */
        {8,	0}, 	/* 0x1cf9 */
        {8,	0}, 	/* 0x1cfa */
        {8,	0}, 	/* 0x1cfb */
        {8,	0}, 	/* 0x1cfc */
        {8,	0}, 	/* 0x1cfd */
        {8,	0}, 	/* 0x1cfe */
        {8,	0}, 	/* 0x1cff */
        {8,	0}, 	/* 0x1d00 */
        {8,	0}, 	/* 0x1d01 */
        {8,	0}, 	/* 0x1d02 */
        {8,	0}, 	/* 0x1d03 */
        {8,	0}, 	/* 0x1d04 */
        {8,	0}, 	/* 0x1d05 */
        {8,	0}, 	/* 0x1d06 */
        {8,	0}, 	/* 0x1d07 */
        {8,	0}, 	/* 0x1d08 */
        {8,	0}, 	/* 0x1d09 */
        {8,	0}, 	/* 0x1d0a */
        {8,	0}, 	/* 0x1d0b */
        {8,	0}, 	/* 0x1d0c */
        {8,	0}, 	/* 0x1d0d */
        {8,	0}, 	/* 0x1d0e */
        {8,	0}, 	/* 0x1d0f */
        {8,	0}, 	/* 0x1d10 */
        {8,	0}, 	/* 0x1d11 */
        {8,	0}, 	/* 0x1d12 */
        {8,	0}, 	/* 0x1d13 */
        {8,	0}, 	/* 0x1d14 */
        {8,	0}, 	/* 0x1d15 */
        {8,	0}, 	/* 0x1d16 */
        {8,	0}, 	/* 0x1d17 */
        {8,	0}, 	/* 0x1d18 */
        {8,	0}, 	/* 0x1d19 */
        {8,	0}, 	/* 0x1d1a */
        {8,	0}, 	/* 0x1d1b */
        {8,	0}, 	/* 0x1d1c */
        {8,	0}, 	/* 0x1d1d */
        {8,	0}, 	/* 0x1d1e */
        {8,	0}, 	/* 0x1d1f */
        {8,	0}, 	/* 0x1d20 */
        {8,	0}, 	/* 0x1d21 */
        {8,	0}, 	/* 0x1d22 */
        {8,	0}, 	/* 0x1d23 */
        {8,	0}, 	/* 0x1d24 */
        {8,	0}, 	/* 0x1d25 */
        {8,	0}, 	/* 0x1d26 */
        {8,	0}, 	/* 0x1d27 */
        {8,	0}, 	/* 0x1d28 */
        {8,	0}, 	/* 0x1d29 */
        {8,	0}, 	/* 0x1d2a */
        {8,	0}, 	/* 0x1d2b */
        {8,	0}, 	/* 0x1d2c */
        {8,	0}, 	/* 0x1d2d */
        {8,	0}, 	/* 0x1d2e */
        {8,	0}, 	/* 0x1d2f */
        {8,	0}, 	/* 0x1d30 */
        {8,	0}, 	/* 0x1d31 */
        {8,	0}, 	/* 0x1d32 */
        {8,	0}, 	/* 0x1d33 */
        {8,	0}, 	/* 0x1d34 */
        {8,	0}, 	/* 0x1d35 */
        {8,	0}, 	/* 0x1d36 */
        {8,	0}, 	/* 0x1d37 */
        {8,	0}, 	/* 0x1d38 */
        {8,	0}, 	/* 0x1d39 */
        {8,	0}, 	/* 0x1d3a */
        {8,	0}, 	/* 0x1d3b */
        {8,	0}, 	/* 0x1d3c */
        {8,	0}, 	/* 0x1d3d */
        {8,	0}, 	/* 0x1d3e */
        {8,	0}, 	/* 0x1d3f */
        {8,	0}, 	/* 0x1d40 */
        {8,	0}, 	/* 0x1d41 */
        {8,	0}, 	/* 0x1d42 */
        {8,	0}, 	/* 0x1d43 */
        {8,	0}, 	/* 0x1d44 */
        {8,	0}, 	/* 0x1d45 */
        {8,	0}, 	/* 0x1d46 */
        {8,	0}, 	/* 0x1d47 */
        {8,	0}, 	/* 0x1d48 */
        {8,	0}, 	/* 0x1d49 */
        {8,	0}, 	/* 0x1d4a */
        {8,	0}, 	/* 0x1d4b */
        {8,	0}, 	/* 0x1d4c */
        {8,	0}, 	/* 0x1d4d */
        {8,	0}, 	/* 0x1d4e */
        {8,	0}, 	/* 0x1d4f */
        {8,	0}, 	/* 0x1d50 */
        {8,	0}, 	/* 0x1d51 */
        {8,	0}, 	/* 0x1d52 */
        {8,	0}, 	/* 0x1d53 */
        {8,	0}, 	/* 0x1d54 */
        {8,	0}, 	/* 0x1d55 */
        {8,	0}, 	/* 0x1d56 */
        {8,	0}, 	/* 0x1d57 */
        {8,	0}, 	/* 0x1d58 */
        {8,	0}, 	/* 0x1d59 */
        {8,	0}, 	/* 0x1d5a */
        {8,	0}, 	/* 0x1d5b */
        {8,	0}, 	/* 0x1d5c */
        {8,	0}, 	/* 0x1d5d */
        {8,	0}, 	/* 0x1d5e */
        {8,	0}, 	/* 0x1d5f */
        {8,	0}, 	/* 0x1d60 */
        {8,	0}, 	/* 0x1d61 */
        {8,	0}, 	/* 0x1d62 */
        {8,	0}, 	/* 0x1d63 */
        {8,	0}, 	/* 0x1d64 */
        {8,	0}, 	/* 0x1d65 */
        {8,	0}, 	/* 0x1d66 */
        {8,	0}, 	/* 0x1d67 */
        {8,	0}, 	/* 0x1d68 */
        {8,	0}, 	/* 0x1d69 */
        {8,	0}, 	/* 0x1d6a */
        {8,	0}, 	/* 0x1d6b */
        {8,	0}, 	/* 0x1d6c */
        {8,	0}, 	/* 0x1d6d */
        {8,	0}, 	/* 0x1d6e */
        {8,	0}, 	/* 0x1d6f */
        {8,	0}, 	/* 0x1d70 */
        {8,	0}, 	/* 0x1d71 */
        {8,	0}, 	/* 0x1d72 */
        {8,	0}, 	/* 0x1d73 */
        {8,	0}, 	/* 0x1d74 */
        {8,	0}, 	/* 0x1d75 */
        {8,	0}, 	/* 0x1d76 */
        {8,	0}, 	/* 0x1d77 */
        {8,	0}, 	/* 0x1d78 */
        {8,	0}, 	/* 0x1d79 */
        {8,	0}, 	/* 0x1d7a */
        {8,	0}, 	/* 0x1d7b */
        {8,	0}, 	/* 0x1d7c */
        {8,	0}, 	/* 0x1d7d */
        {8,	0}, 	/* 0x1d7e */
        {8,	0}, 	/* 0x1d7f */
        {8,	0}, 	/* 0x1d80 */
        {8,	0}, 	/* 0x1d81 */
        {8,	0}, 	/* 0x1d82 */
        {8,	0}, 	/* 0x1d83 */
        {8,	0}, 	/* 0x1d84 */
        {8,	0}, 	/* 0x1d85 */
        {8,	0}, 	/* 0x1d86 */
        {8,	0}, 	/* 0x1d87 */
        {8,	0}, 	/* 0x1d88 */
        {8,	0}, 	/* 0x1d89 */
        {8,	0}, 	/* 0x1d8a */
        {8,	0}, 	/* 0x1d8b */
        {8,	0}, 	/* 0x1d8c */
        {8,	0}, 	/* 0x1d8d */
        {8,	0}, 	/* 0x1d8e */
        {8,	0}, 	/* 0x1d8f */
        {8,	0}, 	/* 0x1d90 */
        {8,	0}, 	/* 0x1d91 */
        {8,	0}, 	/* 0x1d92 */
        {8,	0}, 	/* 0x1d93 */
        {8,	0}, 	/* 0x1d94 */
        {8,	0}, 	/* 0x1d95 */
        {8,	0}, 	/* 0x1d96 */
        {8,	0}, 	/* 0x1d97 */
        {8,	0}, 	/* 0x1d98 */
        {8,	0}, 	/* 0x1d99 */
        {8,	0}, 	/* 0x1d9a */
        {8,	0}, 	/* 0x1d9b */
        {8,	0}, 	/* 0x1d9c */
        {8,	0}, 	/* 0x1d9d */
        {8,	0}, 	/* 0x1d9e */
        {8,	0}, 	/* 0x1d9f */
        {8,	0}, 	/* 0x1da0 */
        {8,	0}, 	/* 0x1da1 */
        {8,	0}, 	/* 0x1da2 */
        {8,	0}, 	/* 0x1da3 */
        {8,	0}, 	/* 0x1da4 */
        {8,	0}, 	/* 0x1da5 */
        {8,	0}, 	/* 0x1da6 */
        {8,	0}, 	/* 0x1da7 */
        {8,	0}, 	/* 0x1da8 */
        {8,	0}, 	/* 0x1da9 */
        {8,	0}, 	/* 0x1daa */
        {8,	0}, 	/* 0x1dab */
        {8,	0}, 	/* 0x1dac */
        {8,	0}, 	/* 0x1dad */
        {8,	0}, 	/* 0x1dae */
        {8,	0}, 	/* 0x1daf */
        {8,	0}, 	/* 0x1db0 */
        {8,	0}, 	/* 0x1db1 */
        {8,	0}, 	/* 0x1db2 */
        {8,	0}, 	/* 0x1db3 */
        {8,	0}, 	/* 0x1db4 */
        {8,	0}, 	/* 0x1db5 */
        {8,	0}, 	/* 0x1db6 */
        {8,	0}, 	/* 0x1db7 */
        {8,	0}, 	/* 0x1db8 */
        {8,	0}, 	/* 0x1db9 */
        {8,	0}, 	/* 0x1dba */
        {8,	0}, 	/* 0x1dbb */
        {8,	0}, 	/* 0x1dbc */
        {8,	0}, 	/* 0x1dbd */
        {8,	0}, 	/* 0x1dbe */
        {8,	0}, 	/* 0x1dbf */
        {8,	0}, 	/* 0x1dc0 */
        {8,	0}, 	/* 0x1dc1 */
        {8,	0}, 	/* 0x1dc2 */
        {8,	0}, 	/* 0x1dc3 */
        {8,	0}, 	/* 0x1dc4 */
        {8,	0}, 	/* 0x1dc5 */
        {8,	0}, 	/* 0x1dc6 */
        {8,	0}, 	/* 0x1dc7 */
        {8,	0}, 	/* 0x1dc8 */
        {8,	0}, 	/* 0x1dc9 */
        {8,	0}, 	/* 0x1dca */
        {8,	0}, 	/* 0x1dcb */
        {8,	0}, 	/* 0x1dcc */
        {8,	0}, 	/* 0x1dcd */
        {8,	0}, 	/* 0x1dce */
        {8,	0}, 	/* 0x1dcf */
        {8,	0}, 	/* 0x1dd0 */
        {8,	0}, 	/* 0x1dd1 */
        {8,	0}, 	/* 0x1dd2 */
        {8,	0}, 	/* 0x1dd3 */
        {8,	0}, 	/* 0x1dd4 */
        {8,	0}, 	/* 0x1dd5 */
        {8,	0}, 	/* 0x1dd6 */
        {8,	0}, 	/* 0x1dd7 */
        {8,	0}, 	/* 0x1dd8 */
        {8,	0}, 	/* 0x1dd9 */
        {8,	0}, 	/* 0x1dda */
        {8,	0}, 	/* 0x1ddb */
        {8,	0}, 	/* 0x1ddc */
        {8,	0}, 	/* 0x1ddd */
        {8,	0}, 	/* 0x1dde */
        {8,	0}, 	/* 0x1ddf */
        {8,	0}, 	/* 0x1de0 */
        {8,	0}, 	/* 0x1de1 */
        {8,	0}, 	/* 0x1de2 */
        {8,	0}, 	/* 0x1de3 */
        {8,	0}, 	/* 0x1de4 */
        {8,	0}, 	/* 0x1de5 */
        {8,	0}, 	/* 0x1de6 */
        {8,	0}, 	/* 0x1de7 */
        {8,	0}, 	/* 0x1de8 */
        {8,	0}, 	/* 0x1de9 */
        {8,	0}, 	/* 0x1dea */
        {8,	0}, 	/* 0x1deb */
        {8,	0}, 	/* 0x1dec */
        {8,	0}, 	/* 0x1ded */
        {8,	0}, 	/* 0x1dee */
        {8,	0}, 	/* 0x1def */
        {8,	0}, 	/* 0x1df0 */
        {8,	0}, 	/* 0x1df1 */
        {8,	0}, 	/* 0x1df2 */
        {8,	0}, 	/* 0x1df3 */
        {8,	0}, 	/* 0x1df4 */
        {8,	0}, 	/* 0x1df5 */
        {8,	0}, 	/* 0x1df6 */
        {8,	0}, 	/* 0x1df7 */
        {8,	0}, 	/* 0x1df8 */
        {8,	0}, 	/* 0x1df9 */
        {8,	0}, 	/* 0x1dfa */
        {8,	0}, 	/* 0x1dfb */
        {8,	0}, 	/* 0x1dfc */
        {8,	0}, 	/* 0x1dfd */
        {8,	0}, 	/* 0x1dfe */
        {8,	0}, 	/* 0x1dff */
        {8,	0}, 	/* 0x1e00 */
        {8,	0}, 	/* 0x1e01 */
        {8,	0}, 	/* 0x1e02 */
        {8,	0}, 	/* 0x1e03 */
        {8,	0}, 	/* 0x1e04 */
        {8,	0}, 	/* 0x1e05 */
        {8,	0}, 	/* 0x1e06 */
        {8,	0}, 	/* 0x1e07 */
        {8,	0}, 	/* 0x1e08 */
        {8,	0}, 	/* 0x1e09 */
        {8,	0}, 	/* 0x1e0a */
        {8,	0}, 	/* 0x1e0b */
        {8,	0}, 	/* 0x1e0c */
        {8,	0}, 	/* 0x1e0d */
        {8,	0}, 	/* 0x1e0e */
        {8,	0}, 	/* 0x1e0f */
        {8,	0}, 	/* 0x1e10 */
        {8,	0}, 	/* 0x1e11 */
        {8,	0}, 	/* 0x1e12 */
        {8,	0}, 	/* 0x1e13 */
        {8,	0}, 	/* 0x1e14 */
        {8,	0}, 	/* 0x1e15 */
        {8,	0}, 	/* 0x1e16 */
        {8,	0}, 	/* 0x1e17 */
        {8,	0}, 	/* 0x1e18 */
        {8,	0}, 	/* 0x1e19 */
        {8,	0}, 	/* 0x1e1a */
        {8,	0}, 	/* 0x1e1b */
        {8,	0}, 	/* 0x1e1c */
        {8,	0}, 	/* 0x1e1d */
        {8,	0}, 	/* 0x1e1e */
        {8,	0}, 	/* 0x1e1f */
        {8,	0}, 	/* 0x1e20 */
        {8,	0}, 	/* 0x1e21 */
        {8,	0}, 	/* 0x1e22 */
        {8,	0}, 	/* 0x1e23 */
        {8,	0}, 	/* 0x1e24 */
        {8,	0}, 	/* 0x1e25 */
        {8,	0}, 	/* 0x1e26 */
        {8,	0}, 	/* 0x1e27 */
        {8,	0}, 	/* 0x1e28 */
        {8,	0}, 	/* 0x1e29 */
        {8,	0}, 	/* 0x1e2a */
        {8,	0}, 	/* 0x1e2b */
        {8,	0}, 	/* 0x1e2c */
        {8,	0}, 	/* 0x1e2d */
        {8,	0}, 	/* 0x1e2e */
        {8,	0}, 	/* 0x1e2f */
        {8,	0}, 	/* 0x1e30 */
        {8,	0}, 	/* 0x1e31 */
        {8,	0}, 	/* 0x1e32 */
        {8,	0}, 	/* 0x1e33 */
        {8,	0}, 	/* 0x1e34 */
        {8,	0}, 	/* 0x1e35 */
        {8,	0}, 	/* 0x1e36 */
        {8,	0}, 	/* 0x1e37 */
        {8,	0}, 	/* 0x1e38 */
        {8,	0}, 	/* 0x1e39 */
        {8,	0}, 	/* 0x1e3a */
        {8,	0}, 	/* 0x1e3b */
        {8,	0}, 	/* 0x1e3c */
        {8,	0}, 	/* 0x1e3d */
        {8,	0}, 	/* 0x1e3e */
        {8,	0}, 	/* 0x1e3f */
        {8,	0}, 	/* 0x1e40 */
        {8,	0}, 	/* 0x1e41 */
        {8,	0}, 	/* 0x1e42 */
        {8,	0}, 	/* 0x1e43 */
        {8,	0}, 	/* 0x1e44 */
        {8,	0}, 	/* 0x1e45 */
        {8,	0}, 	/* 0x1e46 */
        {8,	0}, 	/* 0x1e47 */
        {8,	0}, 	/* 0x1e48 */
        {8,	0}, 	/* 0x1e49 */
        {8,	0}, 	/* 0x1e4a */
        {8,	0}, 	/* 0x1e4b */
        {8,	0}, 	/* 0x1e4c */
        {8,	0}, 	/* 0x1e4d */
        {8,	0}, 	/* 0x1e4e */
        {8,	0}, 	/* 0x1e4f */
        {8,	0}, 	/* 0x1e50 */
        {8,	0}, 	/* 0x1e51 */
        {8,	0}, 	/* 0x1e52 */
        {8,	0}, 	/* 0x1e53 */
        {8,	0}, 	/* 0x1e54 */
        {8,	0}, 	/* 0x1e55 */
        {8,	0}, 	/* 0x1e56 */
        {8,	0}, 	/* 0x1e57 */
        {8,	0}, 	/* 0x1e58 */
        {8,	0}, 	/* 0x1e59 */
        {8,	0}, 	/* 0x1e5a */
        {8,	0}, 	/* 0x1e5b */
        {8,	0}, 	/* 0x1e5c */
        {8,	0}, 	/* 0x1e5d */
        {8,	0}, 	/* 0x1e5e */
        {8,	0}, 	/* 0x1e5f */
        {8,	0}, 	/* 0x1e60 */
        {8,	0}, 	/* 0x1e61 */
        {8,	0}, 	/* 0x1e62 */
        {8,	0}, 	/* 0x1e63 */
        {8,	0}, 	/* 0x1e64 */
        {8,	0}, 	/* 0x1e65 */
        {8,	0}, 	/* 0x1e66 */
        {8,	0}, 	/* 0x1e67 */
        {8,	0}, 	/* 0x1e68 */
        {8,	0}, 	/* 0x1e69 */
        {8,	0}, 	/* 0x1e6a */
        {8,	0}, 	/* 0x1e6b */
        {8,	0}, 	/* 0x1e6c */
        {8,	0}, 	/* 0x1e6d */
        {8,	0}, 	/* 0x1e6e */
        {8,	0}, 	/* 0x1e6f */
        {8,	0}, 	/* 0x1e70 */
        {8,	0}, 	/* 0x1e71 */
        {8,	0}, 	/* 0x1e72 */
        {8,	0}, 	/* 0x1e73 */
        {8,	0}, 	/* 0x1e74 */
        {8,	0}, 	/* 0x1e75 */
        {8,	0}, 	/* 0x1e76 */
        {8,	0}, 	/* 0x1e77 */
        {8,	0}, 	/* 0x1e78 */
        {8,	0}, 	/* 0x1e79 */
        {8,	0}, 	/* 0x1e7a */
        {8,	0}, 	/* 0x1e7b */
        {8,	0}, 	/* 0x1e7c */
        {8,	0}, 	/* 0x1e7d */
        {8,	0}, 	/* 0x1e7e */
        {8,	0}, 	/* 0x1e7f */
        {8,	0}, 	/* 0x1e80 */
        {8,	0}, 	/* 0x1e81 */
        {8,	0}, 	/* 0x1e82 */
        {8,	0}, 	/* 0x1e83 */
        {8,	0}, 	/* 0x1e84 */
        {8,	0}, 	/* 0x1e85 */
        {8,	0}, 	/* 0x1e86 */
        {8,	0}, 	/* 0x1e87 */
        {8,	0}, 	/* 0x1e88 */
        {8,	0}, 	/* 0x1e89 */
        {8,	0}, 	/* 0x1e8a */
        {8,	0}, 	/* 0x1e8b */
        {8,	0}, 	/* 0x1e8c */
        {8,	0}, 	/* 0x1e8d */
        {8,	0}, 	/* 0x1e8e */
        {8,	0}, 	/* 0x1e8f */
        {8,	0}, 	/* 0x1e90 */
        {8,	0}, 	/* 0x1e91 */
        {8,	0}, 	/* 0x1e92 */
        {8,	0}, 	/* 0x1e93 */
        {8,	0}, 	/* 0x1e94 */
        {8,	0}, 	/* 0x1e95 */
        {8,	0}, 	/* 0x1e96 */
        {8,	0}, 	/* 0x1e97 */
        {8,	0}, 	/* 0x1e98 */
        {8,	0}, 	/* 0x1e99 */
        {8,	0}, 	/* 0x1e9a */
        {8,	0}, 	/* 0x1e9b */
        {8,	0}, 	/* 0x1e9c */
        {8,	0}, 	/* 0x1e9d */
        {8,	0}, 	/* 0x1e9e */
        {8,	0}, 	/* 0x1e9f */
        {8,	0}, 	/* 0x1ea0 */
        {8,	0}, 	/* 0x1ea1 */
        {8,	0}, 	/* 0x1ea2 */
        {8,	0}, 	/* 0x1ea3 */
        {8,	0}, 	/* 0x1ea4 */
        {8,	0}, 	/* 0x1ea5 */
        {8,	0}, 	/* 0x1ea6 */
        {8,	0}, 	/* 0x1ea7 */
        {8,	0}, 	/* 0x1ea8 */
        {8,	0}, 	/* 0x1ea9 */
        {8,	0}, 	/* 0x1eaa */
        {8,	0}, 	/* 0x1eab */
        {8,	0}, 	/* 0x1eac */
        {8,	0}, 	/* 0x1ead */
        {8,	0}, 	/* 0x1eae */
        {8,	0}, 	/* 0x1eaf */
        {8,	0}, 	/* 0x1eb0 */
        {8,	0}, 	/* 0x1eb1 */
        {8,	0}, 	/* 0x1eb2 */
        {8,	0}, 	/* 0x1eb3 */
        {8,	0}, 	/* 0x1eb4 */
        {8,	0}, 	/* 0x1eb5 */
        {8,	0}, 	/* 0x1eb6 */
        {8,	0}, 	/* 0x1eb7 */
        {8,	0}, 	/* 0x1eb8 */
        {8,	0}, 	/* 0x1eb9 */
        {8,	0}, 	/* 0x1eba */
        {8,	0}, 	/* 0x1ebb */
        {8,	0}, 	/* 0x1ebc */
        {8,	0}, 	/* 0x1ebd */
        {8,	0}, 	/* 0x1ebe */
        {8,	0}, 	/* 0x1ebf */
        {8,	0}, 	/* 0x1ec0 */
        {8,	0}, 	/* 0x1ec1 */
        {8,	0}, 	/* 0x1ec2 */
        {8,	0}, 	/* 0x1ec3 */
        {8,	0}, 	/* 0x1ec4 */
        {8,	0}, 	/* 0x1ec5 */
        {8,	0}, 	/* 0x1ec6 */
        {8,	0}, 	/* 0x1ec7 */
        {8,	0}, 	/* 0x1ec8 */
        {8,	0}, 	/* 0x1ec9 */
        {8,	0}, 	/* 0x1eca */
        {8,	0}, 	/* 0x1ecb */
        {8,	0}, 	/* 0x1ecc */
        {8,	0}, 	/* 0x1ecd */
        {8,	0}, 	/* 0x1ece */
        {8,	0}, 	/* 0x1ecf */
        {8,	0}, 	/* 0x1ed0 */
        {8,	0}, 	/* 0x1ed1 */
        {8,	0}, 	/* 0x1ed2 */
        {8,	0}, 	/* 0x1ed3 */
        {8,	0}, 	/* 0x1ed4 */
        {8,	0}, 	/* 0x1ed5 */
        {8,	0}, 	/* 0x1ed6 */
        {8,	0}, 	/* 0x1ed7 */
        {8,	0}, 	/* 0x1ed8 */
        {8,	0}, 	/* 0x1ed9 */
        {8,	0}, 	/* 0x1eda */
        {8,	0}, 	/* 0x1edb */
        {8,	0}, 	/* 0x1edc */
        {8,	0}, 	/* 0x1edd */
        {8,	0}, 	/* 0x1ede */
        {8,	0}, 	/* 0x1edf */
        {8,	0}, 	/* 0x1ee0 */
        {8,	0}, 	/* 0x1ee1 */
        {8,	0}, 	/* 0x1ee2 */
        {8,	0}, 	/* 0x1ee3 */
        {8,	0}, 	/* 0x1ee4 */
        {8,	0}, 	/* 0x1ee5 */
        {8,	0}, 	/* 0x1ee6 */
        {8,	0}, 	/* 0x1ee7 */
        {8,	0}, 	/* 0x1ee8 */
        {8,	0}, 	/* 0x1ee9 */
        {8,	0}, 	/* 0x1eea */
        {8,	0}, 	/* 0x1eeb */
        {8,	0}, 	/* 0x1eec */
        {8,	0}, 	/* 0x1eed */
        {8,	0}, 	/* 0x1eee */
        {8,	0}, 	/* 0x1eef */
        {8,	0}, 	/* 0x1ef0 */
        {8,	0}, 	/* 0x1ef1 */
        {8,	0}, 	/* 0x1ef2 */
        {8,	0}, 	/* 0x1ef3 */
        {8,	0}, 	/* 0x1ef4 */
        {8,	0}, 	/* 0x1ef5 */
        {8,	0}, 	/* 0x1ef6 */
        {8,	0}, 	/* 0x1ef7 */
        {8,	0}, 	/* 0x1ef8 */
        {8,	0}, 	/* 0x1ef9 */
        {8,	0}, 	/* 0x1efa */
        {8,	0}, 	/* 0x1efb */
        {8,	0}, 	/* 0x1efc */
        {8,	0}, 	/* 0x1efd */
        {8,	0}, 	/* 0x1efe */
        {8,	0}, 	/* 0x1eff */
        {8,	0}, 	/* 0x1f00 */
        {8,	0}, 	/* 0x1f01 */
        {8,	0}, 	/* 0x1f02 */
        {8,	0}, 	/* 0x1f03 */
        {8,	0}, 	/* 0x1f04 */
        {8,	0}, 	/* 0x1f05 */
        {8,	0}, 	/* 0x1f06 */
        {8,	0}, 	/* 0x1f07 */
        {8,	0}, 	/* 0x1f08 */
        {8,	0}, 	/* 0x1f09 */
        {8,	0}, 	/* 0x1f0a */
        {8,	0}, 	/* 0x1f0b */
        {8,	0}, 	/* 0x1f0c */
        {8,	0}, 	/* 0x1f0d */
        {8,	0}, 	/* 0x1f0e */
        {8,	0}, 	/* 0x1f0f */
        {8,	0}, 	/* 0x1f10 */
        {8,	0}, 	/* 0x1f11 */
        {8,	0}, 	/* 0x1f12 */
        {8,	0}, 	/* 0x1f13 */
        {8,	0}, 	/* 0x1f14 */
        {8,	0}, 	/* 0x1f15 */
        {8,	0}, 	/* 0x1f16 */
        {8,	0}, 	/* 0x1f17 */
        {8,	0}, 	/* 0x1f18 */
        {8,	0}, 	/* 0x1f19 */
        {8,	0}, 	/* 0x1f1a */
        {8,	0}, 	/* 0x1f1b */
        {8,	0}, 	/* 0x1f1c */
        {8,	0}, 	/* 0x1f1d */
        {8,	0}, 	/* 0x1f1e */
        {8,	0}, 	/* 0x1f1f */
        {8,	0}, 	/* 0x1f20 */
        {8,	0}, 	/* 0x1f21 */
        {8,	0}, 	/* 0x1f22 */
        {8,	0}, 	/* 0x1f23 */
        {8,	0}, 	/* 0x1f24 */
        {8,	0}, 	/* 0x1f25 */
        {8,	0}, 	/* 0x1f26 */
        {8,	0}, 	/* 0x1f27 */
        {8,	0}, 	/* 0x1f28 */
        {8,	0}, 	/* 0x1f29 */
        {8,	0}, 	/* 0x1f2a */
        {8,	0}, 	/* 0x1f2b */
        {8,	0}, 	/* 0x1f2c */
        {8,	0}, 	/* 0x1f2d */
        {8,	0}, 	/* 0x1f2e */
        {8,	0}, 	/* 0x1f2f */
        {8,	0}, 	/* 0x1f30 */
        {8,	0}, 	/* 0x1f31 */
        {8,	0}, 	/* 0x1f32 */
        {8,	0}, 	/* 0x1f33 */
        {8,	0}, 	/* 0x1f34 */
        {8,	0}, 	/* 0x1f35 */
        {8,	0}, 	/* 0x1f36 */
        {8,	0}, 	/* 0x1f37 */
        {8,	0}, 	/* 0x1f38 */
        {8,	0}, 	/* 0x1f39 */
        {8,	0}, 	/* 0x1f3a */
        {8,	0}, 	/* 0x1f3b */
        {8,	0}, 	/* 0x1f3c */
        {8,	0}, 	/* 0x1f3d */
        {8,	0}, 	/* 0x1f3e */
        {8,	0}, 	/* 0x1f3f */
        {8,	0}, 	/* 0x1f40 */
        {8,	0}, 	/* 0x1f41 */
        {8,	0}, 	/* 0x1f42 */
        {8,	0}, 	/* 0x1f43 */
        {8,	0}, 	/* 0x1f44 */
        {8,	0}, 	/* 0x1f45 */
        {8,	0}, 	/* 0x1f46 */
        {8,	0}, 	/* 0x1f47 */
        {8,	0}, 	/* 0x1f48 */
        {8,	0}, 	/* 0x1f49 */
        {8,	0}, 	/* 0x1f4a */
        {8,	0}, 	/* 0x1f4b */
        {8,	0}, 	/* 0x1f4c */
        {8,	0}, 	/* 0x1f4d */
        {8,	0}, 	/* 0x1f4e */
        {8,	0}, 	/* 0x1f4f */
        {8,	0}, 	/* 0x1f50 */
        {8,	0}, 	/* 0x1f51 */
        {8,	0}, 	/* 0x1f52 */
        {8,	0}, 	/* 0x1f53 */
        {8,	0}, 	/* 0x1f54 */
        {8,	0}, 	/* 0x1f55 */
        {8,	0}, 	/* 0x1f56 */
        {8,	0}, 	/* 0x1f57 */
        {8,	0}, 	/* 0x1f58 */
        {8,	0}, 	/* 0x1f59 */
        {8,	0}, 	/* 0x1f5a */
        {8,	0}, 	/* 0x1f5b */
        {8,	0}, 	/* 0x1f5c */
        {8,	0}, 	/* 0x1f5d */
        {8,	0}, 	/* 0x1f5e */
        {8,	0}, 	/* 0x1f5f */
        {8,	0}, 	/* 0x1f60 */
        {8,	0}, 	/* 0x1f61 */
        {8,	0}, 	/* 0x1f62 */
        {8,	0}, 	/* 0x1f63 */
        {8,	0}, 	/* 0x1f64 */
        {8,	0}, 	/* 0x1f65 */
        {8,	0}, 	/* 0x1f66 */
        {8,	0}, 	/* 0x1f67 */
        {8,	0}, 	/* 0x1f68 */
        {8,	0}, 	/* 0x1f69 */
        {8,	0}, 	/* 0x1f6a */
        {8,	0}, 	/* 0x1f6b */
        {8,	0}, 	/* 0x1f6c */
        {8,	0}, 	/* 0x1f6d */
        {8,	0}, 	/* 0x1f6e */
        {8,	0}, 	/* 0x1f6f */
        {8,	0}, 	/* 0x1f70 */
        {8,	0}, 	/* 0x1f71 */
        {8,	0}, 	/* 0x1f72 */
        {8,	0}, 	/* 0x1f73 */
        {8,	0}, 	/* 0x1f74 */
        {8,	0}, 	/* 0x1f75 */
        {8,	0}, 	/* 0x1f76 */
        {8,	0}, 	/* 0x1f77 */
        {8,	0}, 	/* 0x1f78 */
        {8,	0}, 	/* 0x1f79 */
        {8,	0}, 	/* 0x1f7a */
        {8,	0}, 	/* 0x1f7b */
        {8,	0}, 	/* 0x1f7c */
        {8,	0}, 	/* 0x1f7d */
        {8,	0}, 	/* 0x1f7e */
        {8,	0}, 	/* 0x1f7f */
        {8,	0}, 	/* 0x1f80 */
        {8,	0}, 	/* 0x1f81 */
        {8,	0}, 	/* 0x1f82 */
        {8,	0}, 	/* 0x1f83 */
        {8,	0}, 	/* 0x1f84 */
        {8,	0}, 	/* 0x1f85 */
        {8,	0}, 	/* 0x1f86 */
        {8,	0}, 	/* 0x1f87 */
        {8,	0}, 	/* 0x1f88 */
        {8,	0}, 	/* 0x1f89 */
        {8,	0}, 	/* 0x1f8a */
        {8,	0}, 	/* 0x1f8b */
        {8,	0}, 	/* 0x1f8c */
        {8,	0}, 	/* 0x1f8d */
        {8,	0}, 	/* 0x1f8e */
        {8,	0}, 	/* 0x1f8f */
        {8,	0}, 	/* 0x1f90 */
        {8,	0}, 	/* 0x1f91 */
        {8,	0}, 	/* 0x1f92 */
        {8,	0}, 	/* 0x1f93 */
        {8,	0}, 	/* 0x1f94 */
        {8,	0}, 	/* 0x1f95 */
        {8,	0}, 	/* 0x1f96 */
        {8,	0}, 	/* 0x1f97 */
        {8,	0}, 	/* 0x1f98 */
        {8,	0}, 	/* 0x1f99 */
        {8,	0}, 	/* 0x1f9a */
        {8,	0}, 	/* 0x1f9b */
        {8,	0}, 	/* 0x1f9c */
        {8,	0}, 	/* 0x1f9d */
        {8,	0}, 	/* 0x1f9e */
        {8,	0}, 	/* 0x1f9f */
        {8,	0}, 	/* 0x1fa0 */
        {8,	0}, 	/* 0x1fa1 */
        {8,	0}, 	/* 0x1fa2 */
        {8,	0}, 	/* 0x1fa3 */
        {8,	0}, 	/* 0x1fa4 */
        {8,	0}, 	/* 0x1fa5 */
        {8,	0}, 	/* 0x1fa6 */
        {8,	0}, 	/* 0x1fa7 */
        {8,	0}, 	/* 0x1fa8 */
        {8,	0}, 	/* 0x1fa9 */
        {8,	0}, 	/* 0x1faa */
        {8,	0}, 	/* 0x1fab */
        {8,	0}, 	/* 0x1fac */
        {8,	0}, 	/* 0x1fad */
        {8,	0}, 	/* 0x1fae */
        {8,	0}, 	/* 0x1faf */
        {8,	0}, 	/* 0x1fb0 */
        {8,	0}, 	/* 0x1fb1 */
        {8,	0}, 	/* 0x1fb2 */
        {8,	0}, 	/* 0x1fb3 */
        {8,	0}, 	/* 0x1fb4 */
        {8,	0}, 	/* 0x1fb5 */
        {8,	0}, 	/* 0x1fb6 */
        {8,	0}, 	/* 0x1fb7 */
        {8,	0}, 	/* 0x1fb8 */
        {8,	0}, 	/* 0x1fb9 */
        {8,	0}, 	/* 0x1fba */
        {8,	0}, 	/* 0x1fbb */
        {8,	0}, 	/* 0x1fbc */
        {8,	0}, 	/* 0x1fbd */
        {8,	0}, 	/* 0x1fbe */
        {8,	0}, 	/* 0x1fbf */
        {8,	0}, 	/* 0x1fc0 */
        {8,	0}, 	/* 0x1fc1 */
        {8,	0}, 	/* 0x1fc2 */
        {8,	0}, 	/* 0x1fc3 */
        {8,	0}, 	/* 0x1fc4 */
        {8,	0}, 	/* 0x1fc5 */
        {8,	0}, 	/* 0x1fc6 */
        {8,	0}, 	/* 0x1fc7 */
        {8,	0}, 	/* 0x1fc8 */
        {8,	0}, 	/* 0x1fc9 */
        {8,	0}, 	/* 0x1fca */
        {8,	0}, 	/* 0x1fcb */
        {8,	0}, 	/* 0x1fcc */
        {8,	0}, 	/* 0x1fcd */
        {8,	0}, 	/* 0x1fce */
        {8,	0}, 	/* 0x1fcf */
        {8,	0}, 	/* 0x1fd0 */
        {8,	0}, 	/* 0x1fd1 */
        {8,	0}, 	/* 0x1fd2 */
        {8,	0}, 	/* 0x1fd3 */
        {8,	0}, 	/* 0x1fd4 */
        {8,	0}, 	/* 0x1fd5 */
        {8,	0}, 	/* 0x1fd6 */
        {8,	0}, 	/* 0x1fd7 */
        {8,	0}, 	/* 0x1fd8 */
        {8,	0}, 	/* 0x1fd9 */
        {8,	0}, 	/* 0x1fda */
        {8,	0}, 	/* 0x1fdb */
        {8,	0}, 	/* 0x1fdc */
        {8,	0}, 	/* 0x1fdd */
        {8,	0}, 	/* 0x1fde */
        {8,	0}, 	/* 0x1fdf */
        {8,	0}, 	/* 0x1fe0 */
        {8,	0}, 	/* 0x1fe1 */
        {8,	0}, 	/* 0x1fe2 */
        {8,	0}, 	/* 0x1fe3 */
        {8,	0}, 	/* 0x1fe4 */
        {8,	0}, 	/* 0x1fe5 */
        {8,	0}, 	/* 0x1fe6 */
        {8,	0}, 	/* 0x1fe7 */
        {8,	0}, 	/* 0x1fe8 */
        {8,	0}, 	/* 0x1fe9 */
        {8,	0}, 	/* 0x1fea */
        {8,	0}, 	/* 0x1feb */
        {8,	0}, 	/* 0x1fec */
        {8,	0}, 	/* 0x1fed */
        {8,	0}, 	/* 0x1fee */
        {8,	0}, 	/* 0x1fef */
        {8,	0}, 	/* 0x1ff0 */
        {8,	0}, 	/* 0x1ff1 */
        {8,	0}, 	/* 0x1ff2 */
        {8,	0}, 	/* 0x1ff3 */
        {8,	0}, 	/* 0x1ff4 */
        {8,	0}, 	/* 0x1ff5 */
        {8,	0}, 	/* 0x1ff6 */
        {8,	0}, 	/* 0x1ff7 */
        {8,	0}, 	/* 0x1ff8 */
        {8,	0}, 	/* 0x1ff9 */
        {8,	0}, 	/* 0x1ffa */
        {8,	0}, 	/* 0x1ffb */
        {8,	0}, 	/* 0x1ffc */
        {8,	0}, 	/* 0x1ffd */
        {8,	0}, 	/* 0x1ffe */
        {8,	0}, 	/* 0x1fff */
        {8,	0}, 	/* 0x2000 */
        {8,	0}, 	/* 0x2001 */
        {8,	0}, 	/* 0x2002 */
        {8,	0}, 	/* 0x2003 */
        {8,	0}, 	/* 0x2004 */
        {8,	0}, 	/* 0x2005 */
        {8,	0}, 	/* 0x2006 */
        {8,	0}, 	/* 0x2007 */
        {8,	0}, 	/* 0x2008 */
        {8,	0}, 	/* 0x2009 */
        {8,	0}, 	/* 0x200a */
        {8,	0}, 	/* 0x200b */
        {8,	0}, 	/* 0x200c */
        {8,	0}, 	/* 0x200d */
        {8,	0}, 	/* 0x200e */
        {8,	0}, 	/* 0x200f */
        {8,	0}, 	/* 0x2010 */
        {8,	0}, 	/* 0x2011 */
        {8,	0}, 	/* 0x2012 */
        {8,	0}, 	/* 0x2013 */
        {8,	0}, 	/* 0x2014 */
        {8,	0}, 	/* 0x2015 */
        {8,	0}, 	/* 0x2016 */
        {8,	0}, 	/* 0x2017 */
        {8,	0}, 	/* 0x2018 */
        {8,	0}, 	/* 0x2019 */
        {8,	0}, 	/* 0x201a */
        {8,	0}, 	/* 0x201b */
        {8,	0}, 	/* 0x201c */
        {8,	0}, 	/* 0x201d */
        {8,	0}, 	/* 0x201e */
        {8,	0}, 	/* 0x201f */
        {8,	0}, 	/* 0x2020 */
        {8,	0}, 	/* 0x2021 */
        {8,	0}, 	/* 0x2022 */
        {8,	0}, 	/* 0x2023 */
        {8,	0}, 	/* 0x2024 */
        {8,	0}, 	/* 0x2025 */
        {8,	0}, 	/* 0x2026 */
        {8,	0}, 	/* 0x2027 */
        {8,	0}, 	/* 0x2028 */
        {8,	0}, 	/* 0x2029 */
        {8,	0}, 	/* 0x202a */
        {8,	0}, 	/* 0x202b */
        {8,	0}, 	/* 0x202c */
        {8,	0}, 	/* 0x202d */
        {8,	0}, 	/* 0x202e */
        {8,	0}, 	/* 0x202f */
        {8,	0}, 	/* 0x2030 */
        {8,	0}, 	/* 0x2031 */
        {8,	0}, 	/* 0x2032 */
        {8,	0}, 	/* 0x2033 */
        {8,	0}, 	/* 0x2034 */
        {8,	0}, 	/* 0x2035 */
        {8,	0}, 	/* 0x2036 */
        {8,	0}, 	/* 0x2037 */
        {8,	0}, 	/* 0x2038 */
        {8,	0}, 	/* 0x2039 */
        {8,	0}, 	/* 0x203a */
        {8,	0}, 	/* 0x203b */
        {8,	0}, 	/* 0x203c */
        {8,	0}, 	/* 0x203d */
        {8,	0}, 	/* 0x203e */
        {8,	0}, 	/* 0x203f */
        {8,	0}, 	/* 0x2040 */
        {8,	0}, 	/* 0x2041 */
        {8,	0}, 	/* 0x2042 */
        {8,	0}, 	/* 0x2043 */
        {8,	0}, 	/* 0x2044 */
        {8,	0}, 	/* 0x2045 */
        {8,	0}, 	/* 0x2046 */
        {8,	0}, 	/* 0x2047 */
        {8,	0}, 	/* 0x2048 */
        {8,	0}, 	/* 0x2049 */
        {8,	0}, 	/* 0x204a */
        {8,	0}, 	/* 0x204b */
        {8,	0}, 	/* 0x204c */
        {8,	0}, 	/* 0x204d */
        {8,	0}, 	/* 0x204e */
        {8,	0}, 	/* 0x204f */
        {8,	0}, 	/* 0x2050 */
        {8,	0}, 	/* 0x2051 */
        {8,	0}, 	/* 0x2052 */
        {8,	0}, 	/* 0x2053 */
        {8,	0}, 	/* 0x2054 */
        {8,	0}, 	/* 0x2055 */
        {8,	0}, 	/* 0x2056 */
        {8,	0}, 	/* 0x2057 */
        {8,	0}, 	/* 0x2058 */
        {8,	0}, 	/* 0x2059 */
        {8,	0}, 	/* 0x205a */
        {8,	0}, 	/* 0x205b */
        {8,	0}, 	/* 0x205c */
        {8,	0}, 	/* 0x205d */
        {8,	0}, 	/* 0x205e */
        {8,	0}, 	/* 0x205f */
        {8,	0}, 	/* 0x2060 */
        {8,	0}, 	/* 0x2061 */
        {8,	0}, 	/* 0x2062 */
        {8,	0}, 	/* 0x2063 */
        {8,	0}, 	/* 0x2064 */
        {8,	0}, 	/* 0x2065 */
        {8,	0}, 	/* 0x2066 */
        {8,	0}, 	/* 0x2067 */
        {8,	0}, 	/* 0x2068 */
        {8,	0}, 	/* 0x2069 */
        {8,	0}, 	/* 0x206a */
        {8,	0}, 	/* 0x206b */
        {8,	0}, 	/* 0x206c */
        {8,	0}, 	/* 0x206d */
        {8,	0}, 	/* 0x206e */
        {8,	0}, 	/* 0x206f */
        {8,	0}, 	/* 0x2070 */
        {8,	0}, 	/* 0x2071 */
        {8,	0}, 	/* 0x2072 */
        {8,	0}, 	/* 0x2073 */
        {8,	0}, 	/* 0x2074 */
        {8,	0}, 	/* 0x2075 */
        {8,	0}, 	/* 0x2076 */
        {8,	0}, 	/* 0x2077 */
        {8,	0}, 	/* 0x2078 */
        {8,	0}, 	/* 0x2079 */
        {8,	0}, 	/* 0x207a */
        {8,	0}, 	/* 0x207b */
        {8,	0}, 	/* 0x207c */
        {8,	0}, 	/* 0x207d */
        {8,	0}, 	/* 0x207e */
        {8,	0}, 	/* 0x207f */
        {8,	0}, 	/* 0x2080 */
        {8,	0}, 	/* 0x2081 */
        {8,	0}, 	/* 0x2082 */
        {8,	0}, 	/* 0x2083 */
        {8,	0}, 	/* 0x2084 */
        {8,	0}, 	/* 0x2085 */
        {8,	0}, 	/* 0x2086 */
        {8,	0}, 	/* 0x2087 */
        {8,	0}, 	/* 0x2088 */
        {8,	0}, 	/* 0x2089 */
        {8,	0}, 	/* 0x208a */
        {8,	0}, 	/* 0x208b */
        {8,	0}, 	/* 0x208c */
        {8,	0}, 	/* 0x208d */
        {8,	0}, 	/* 0x208e */
        {8,	0}, 	/* 0x208f */
        {8,	0}, 	/* 0x2090 */
        {8,	0}, 	/* 0x2091 */
        {8,	0}, 	/* 0x2092 */
        {8,	0}, 	/* 0x2093 */
        {8,	0}, 	/* 0x2094 */
        {8,	0}, 	/* 0x2095 */
        {8,	0}, 	/* 0x2096 */
        {8,	0}, 	/* 0x2097 */
        {8,	0}, 	/* 0x2098 */
        {8,	0}, 	/* 0x2099 */
        {8,	0}, 	/* 0x209a */
        {8,	0}, 	/* 0x209b */
        {8,	0}, 	/* 0x209c */
        {8,	0}, 	/* 0x209d */
        {8,	0}, 	/* 0x209e */
        {8,	0}, 	/* 0x209f */
        {8,	0}, 	/* 0x20a0 */
        {8,	0}, 	/* 0x20a1 */
        {8,	0}, 	/* 0x20a2 */
        {8,	0}, 	/* 0x20a3 */
        {8,	0}, 	/* 0x20a4 */
        {8,	0}, 	/* 0x20a5 */
        {8,	0}, 	/* 0x20a6 */
        {8,	0}, 	/* 0x20a7 */
        {8,	0}, 	/* 0x20a8 */
        {8,	0}, 	/* 0x20a9 */
        {8,	0}, 	/* 0x20aa */
        {8,	0}, 	/* 0x20ab */
        {8,	0}, 	/* 0x20ac */
        {8,	0}, 	/* 0x20ad */
        {8,	0}, 	/* 0x20ae */
        {8,	0}, 	/* 0x20af */
        {8,	0}, 	/* 0x20b0 */
        {8,	0}, 	/* 0x20b1 */
        {8,	0}, 	/* 0x20b2 */
        {8,	0}, 	/* 0x20b3 */
        {8,	0}, 	/* 0x20b4 */
        {8,	0}, 	/* 0x20b5 */
        {8,	0}, 	/* 0x20b6 */
        {8,	0}, 	/* 0x20b7 */
        {8,	0}, 	/* 0x20b8 */
        {8,	0}, 	/* 0x20b9 */
        {8,	0}, 	/* 0x20ba */
        {8,	0}, 	/* 0x20bb */
        {8,	0}, 	/* 0x20bc */
        {8,	0}, 	/* 0x20bd */
        {8,	0}, 	/* 0x20be */
        {8,	0}, 	/* 0x20bf */
        {8,	0}, 	/* 0x20c0 */
        {8,	0}, 	/* 0x20c1 */
        {8,	0}, 	/* 0x20c2 */
        {8,	0}, 	/* 0x20c3 */
        {8,	0}, 	/* 0x20c4 */
        {8,	0}, 	/* 0x20c5 */
        {8,	0}, 	/* 0x20c6 */
        {8,	0}, 	/* 0x20c7 */
        {8,	0}, 	/* 0x20c8 */
        {8,	0}, 	/* 0x20c9 */
        {8,	0}, 	/* 0x20ca */
        {8,	0}, 	/* 0x20cb */
        {8,	0}, 	/* 0x20cc */
        {8,	0}, 	/* 0x20cd */
        {8,	0}, 	/* 0x20ce */
        {8,	0}, 	/* 0x20cf */
        {8,	0}, 	/* 0x20d0 */
        {8,	0}, 	/* 0x20d1 */
        {8,	0}, 	/* 0x20d2 */
        {8,	0}, 	/* 0x20d3 */
        {8,	0}, 	/* 0x20d4 */
        {8,	0}, 	/* 0x20d5 */
        {8,	0}, 	/* 0x20d6 */
        {8,	0}, 	/* 0x20d7 */
        {8,	0}, 	/* 0x20d8 */
        {8,	0}, 	/* 0x20d9 */
        {8,	0}, 	/* 0x20da */
        {8,	0}, 	/* 0x20db */
        {8,	0}, 	/* 0x20dc */
        {8,	0}, 	/* 0x20dd */
        {8,	0}, 	/* 0x20de */
        {8,	0}, 	/* 0x20df */
        {8,	0}, 	/* 0x20e0 */
        {8,	0}, 	/* 0x20e1 */
        {8,	0}, 	/* 0x20e2 */
        {8,	0}, 	/* 0x20e3 */
        {8,	0}, 	/* 0x20e4 */
        {8,	0}, 	/* 0x20e5 */
        {8,	0}, 	/* 0x20e6 */
        {8,	0}, 	/* 0x20e7 */
        {8,	0}, 	/* 0x20e8 */
        {8,	0}, 	/* 0x20e9 */
        {8,	0}, 	/* 0x20ea */
        {8,	0}, 	/* 0x20eb */
        {8,	0}, 	/* 0x20ec */
        {8,	0}, 	/* 0x20ed */
        {8,	0}, 	/* 0x20ee */
        {8,	0}, 	/* 0x20ef */
        {8,	0}, 	/* 0x20f0 */
        {8,	0}, 	/* 0x20f1 */
        {8,	0}, 	/* 0x20f2 */
        {8,	0}, 	/* 0x20f3 */
        {8,	0}, 	/* 0x20f4 */
        {8,	0}, 	/* 0x20f5 */
        {8,	0}, 	/* 0x20f6 */
        {8,	0}, 	/* 0x20f7 */
        {8,	0}, 	/* 0x20f8 */
        {8,	0}, 	/* 0x20f9 */
        {8,	0}, 	/* 0x20fa */
        {8,	0}, 	/* 0x20fb */
        {8,	0}, 	/* 0x20fc */
        {8,	0}, 	/* 0x20fd */
        {8,	0}, 	/* 0x20fe */
        {8,	0}, 	/* 0x20ff */
        {8,	0}, 	/* 0x2100 */
        {8,	0}, 	/* 0x2101 */
        {8,	0}, 	/* 0x2102 */
        {8,	0}, 	/* 0x2103 */
        {8,	0}, 	/* 0x2104 */
        {8,	0}, 	/* 0x2105 */
        {8,	0}, 	/* 0x2106 */
        {8,	0}, 	/* 0x2107 */
        {8,	0}, 	/* 0x2108 */
        {8,	0}, 	/* 0x2109 */
        {8,	0}, 	/* 0x210a */
        {8,	0}, 	/* 0x210b */
        {8,	0}, 	/* 0x210c */
        {8,	0}, 	/* 0x210d */
        {8,	0}, 	/* 0x210e */
        {8,	0}, 	/* 0x210f */
        {8,	0}, 	/* 0x2110 */
        {8,	0}, 	/* 0x2111 */
        {8,	0}, 	/* 0x2112 */
        {8,	0}, 	/* 0x2113 */
        {8,	0}, 	/* 0x2114 */
        {8,	0}, 	/* 0x2115 */
        {8,	0}, 	/* 0x2116 */
        {8,	0}, 	/* 0x2117 */
        {8,	0}, 	/* 0x2118 */
        {8,	0}, 	/* 0x2119 */
        {8,	0}, 	/* 0x211a */
        {8,	0}, 	/* 0x211b */
        {8,	0}, 	/* 0x211c */
        {8,	0}, 	/* 0x211d */
        {8,	0}, 	/* 0x211e */
        {8,	0}, 	/* 0x211f */
        {8,	0}, 	/* 0x2120 */
        {8,	0}, 	/* 0x2121 */
        {8,	0}, 	/* 0x2122 */
        {8,	0}, 	/* 0x2123 */
        {8,	0}, 	/* 0x2124 */
        {8,	0}, 	/* 0x2125 */
        {8,	0}, 	/* 0x2126 */
        {8,	0}, 	/* 0x2127 */
        {8,	0}, 	/* 0x2128 */
        {8,	0}, 	/* 0x2129 */
        {8,	0}, 	/* 0x212a */
        {8,	0}, 	/* 0x212b */
        {8,	0}, 	/* 0x212c */
        {8,	0}, 	/* 0x212d */
        {8,	0}, 	/* 0x212e */
        {8,	0}, 	/* 0x212f */
        {8,	0}, 	/* 0x2130 */
        {8,	0}, 	/* 0x2131 */
        {8,	0}, 	/* 0x2132 */
        {8,	0}, 	/* 0x2133 */
        {8,	0}, 	/* 0x2134 */
        {8,	0}, 	/* 0x2135 */
        {8,	0}, 	/* 0x2136 */
        {8,	0}, 	/* 0x2137 */
        {8,	0}, 	/* 0x2138 */
        {8,	0}, 	/* 0x2139 */
        {8,	0}, 	/* 0x213a */
        {8,	0}, 	/* 0x213b */
        {8,	0}, 	/* 0x213c */
        {8,	0}, 	/* 0x213d */
        {8,	0}, 	/* 0x213e */
        {8,	0}, 	/* 0x213f */
        {8,	0}, 	/* 0x2140 */
        {8,	0}, 	/* 0x2141 */
        {8,	0}, 	/* 0x2142 */
        {8,	0}, 	/* 0x2143 */
        {8,	0}, 	/* 0x2144 */
        {8,	0}, 	/* 0x2145 */
        {8,	0}, 	/* 0x2146 */
        {8,	0}, 	/* 0x2147 */
        {8,	0}, 	/* 0x2148 */
        {8,	0}, 	/* 0x2149 */
        {8,	0}, 	/* 0x214a */
        {8,	0}, 	/* 0x214b */
        {8,	0}, 	/* 0x214c */
        {8,	0}, 	/* 0x214d */
        {8,	0}, 	/* 0x214e */
        {8,	0}, 	/* 0x214f */
        {8,	0}, 	/* 0x2150 */
        {8,	0}, 	/* 0x2151 */
        {8,	0}, 	/* 0x2152 */
        {8,	0}, 	/* 0x2153 */
        {8,	0}, 	/* 0x2154 */
        {8,	0}, 	/* 0x2155 */
        {8,	0}, 	/* 0x2156 */
        {8,	0}, 	/* 0x2157 */
        {8,	0}, 	/* 0x2158 */
        {8,	0}, 	/* 0x2159 */
        {8,	0}, 	/* 0x215a */
        {8,	0}, 	/* 0x215b */
        {8,	0}, 	/* 0x215c */
        {8,	0}, 	/* 0x215d */
        {8,	0}, 	/* 0x215e */
        {8,	0}, 	/* 0x215f */
        {8,	0}, 	/* 0x2160 */
        {8,	0}, 	/* 0x2161 */
        {8,	0}, 	/* 0x2162 */
        {8,	0}, 	/* 0x2163 */
        {8,	0}, 	/* 0x2164 */
        {8,	0}, 	/* 0x2165 */
        {8,	0}, 	/* 0x2166 */
        {8,	0}, 	/* 0x2167 */
        {8,	0}, 	/* 0x2168 */
        {8,	0}, 	/* 0x2169 */
        {8,	0}, 	/* 0x216a */
        {8,	0}, 	/* 0x216b */
        {8,	0}, 	/* 0x216c */
        {8,	0}, 	/* 0x216d */
        {8,	0}, 	/* 0x216e */
        {8,	0}, 	/* 0x216f */
        {8,	0}, 	/* 0x2170 */
        {8,	0}, 	/* 0x2171 */
        {8,	0}, 	/* 0x2172 */
        {8,	0}, 	/* 0x2173 */
        {8,	0}, 	/* 0x2174 */
        {8,	0}, 	/* 0x2175 */
        {8,	0}, 	/* 0x2176 */
        {8,	0}, 	/* 0x2177 */
        {8,	0}, 	/* 0x2178 */
        {8,	0}, 	/* 0x2179 */
        {8,	0}, 	/* 0x217a */
        {8,	0}, 	/* 0x217b */
        {8,	0}, 	/* 0x217c */
        {8,	0}, 	/* 0x217d */
        {8,	0}, 	/* 0x217e */
        {8,	0}, 	/* 0x217f */
        {8,	0}, 	/* 0x2180 */
        {8,	0}, 	/* 0x2181 */
        {8,	0}, 	/* 0x2182 */
        {8,	0}, 	/* 0x2183 */
        {8,	0}, 	/* 0x2184 */
        {8,	0}, 	/* 0x2185 */
        {8,	0}, 	/* 0x2186 */
        {8,	0}, 	/* 0x2187 */
        {8,	0}, 	/* 0x2188 */
        {8,	0}, 	/* 0x2189 */
        {8,	0}, 	/* 0x218a */
        {8,	0}, 	/* 0x218b */
        {8,	0}, 	/* 0x218c */
        {8,	0}, 	/* 0x218d */
        {8,	0}, 	/* 0x218e */
        {8,	0}, 	/* 0x218f */
        {8,	0}, 	/* 0x2190 */
        {8,	0}, 	/* 0x2191 */
        {8,	0}, 	/* 0x2192 */
        {8,	0}, 	/* 0x2193 */
        {8,	0}, 	/* 0x2194 */
        {8,	0}, 	/* 0x2195 */
        {8,	0}, 	/* 0x2196 */
        {8,	0}, 	/* 0x2197 */
        {8,	0}, 	/* 0x2198 */
        {8,	0}, 	/* 0x2199 */
        {8,	0}, 	/* 0x219a */
        {8,	0}, 	/* 0x219b */
        {8,	0}, 	/* 0x219c */
        {8,	0}, 	/* 0x219d */
        {8,	0}, 	/* 0x219e */
        {8,	0}, 	/* 0x219f */
        {8,	0}, 	/* 0x21a0 */
        {8,	0}, 	/* 0x21a1 */
        {8,	0}, 	/* 0x21a2 */
        {8,	0}, 	/* 0x21a3 */
        {8,	0}, 	/* 0x21a4 */
        {8,	0}, 	/* 0x21a5 */
        {8,	0}, 	/* 0x21a6 */
        {8,	0}, 	/* 0x21a7 */
        {8,	0}, 	/* 0x21a8 */
        {8,	0}, 	/* 0x21a9 */
        {8,	0}, 	/* 0x21aa */
        {8,	0}, 	/* 0x21ab */
        {8,	0}, 	/* 0x21ac */
        {8,	0}, 	/* 0x21ad */
        {8,	0}, 	/* 0x21ae */
        {8,	0}, 	/* 0x21af */
        {8,	0}, 	/* 0x21b0 */
        {8,	0}, 	/* 0x21b1 */
        {8,	0}, 	/* 0x21b2 */
        {8,	0}, 	/* 0x21b3 */
        {8,	0}, 	/* 0x21b4 */
        {8,	0}, 	/* 0x21b5 */
        {8,	0}, 	/* 0x21b6 */
        {8,	0}, 	/* 0x21b7 */
        {8,	0}, 	/* 0x21b8 */
        {8,	0}, 	/* 0x21b9 */
        {8,	0}, 	/* 0x21ba */
        {8,	0}, 	/* 0x21bb */
        {8,	0}, 	/* 0x21bc */
        {8,	0}, 	/* 0x21bd */
        {8,	0}, 	/* 0x21be */
        {8,	0}, 	/* 0x21bf */
        {8,	0}, 	/* 0x21c0 */
        {8,	0}, 	/* 0x21c1 */
        {8,	0}, 	/* 0x21c2 */
        {8,	0}, 	/* 0x21c3 */
        {8,	0}, 	/* 0x21c4 */
        {8,	0}, 	/* 0x21c5 */
        {8,	0}, 	/* 0x21c6 */
        {8,	0}, 	/* 0x21c7 */
        {8,	0}, 	/* 0x21c8 */
        {8,	0}, 	/* 0x21c9 */
        {8,	0}, 	/* 0x21ca */
        {8,	0}, 	/* 0x21cb */
        {8,	0}, 	/* 0x21cc */
        {8,	0}, 	/* 0x21cd */
        {8,	0}, 	/* 0x21ce */
        {8,	0}, 	/* 0x21cf */
        {8,	0}, 	/* 0x21d0 */
        {8,	0}, 	/* 0x21d1 */
        {8,	0}, 	/* 0x21d2 */
        {8,	0}, 	/* 0x21d3 */
        {8,	0}, 	/* 0x21d4 */
        {8,	0}, 	/* 0x21d5 */
        {8,	0}, 	/* 0x21d6 */
        {8,	0}, 	/* 0x21d7 */
        {8,	0}, 	/* 0x21d8 */
        {8,	0}, 	/* 0x21d9 */
        {8,	0}, 	/* 0x21da */
        {8,	0}, 	/* 0x21db */
        {8,	0}, 	/* 0x21dc */
        {8,	0}, 	/* 0x21dd */
        {8,	0}, 	/* 0x21de */
        {8,	0}, 	/* 0x21df */
        {8,	0}, 	/* 0x21e0 */
        {8,	0}, 	/* 0x21e1 */
        {8,	0}, 	/* 0x21e2 */
        {8,	0}, 	/* 0x21e3 */
        {8,	0}, 	/* 0x21e4 */
        {8,	0}, 	/* 0x21e5 */
        {8,	0}, 	/* 0x21e6 */
        {8,	0}, 	/* 0x21e7 */
        {8,	0}, 	/* 0x21e8 */
        {8,	0}, 	/* 0x21e9 */
        {8,	0}, 	/* 0x21ea */
        {8,	0}, 	/* 0x21eb */
        {8,	0}, 	/* 0x21ec */
        {8,	0}, 	/* 0x21ed */
        {8,	0}, 	/* 0x21ee */
        {8,	0}, 	/* 0x21ef */
        {8,	0}, 	/* 0x21f0 */
        {8,	0}, 	/* 0x21f1 */
        {8,	0}, 	/* 0x21f2 */
        {8,	0}, 	/* 0x21f3 */
        {8,	0}, 	/* 0x21f4 */
        {8,	0}, 	/* 0x21f5 */
        {8,	0}, 	/* 0x21f6 */
        {8,	0}, 	/* 0x21f7 */
        {8,	0}, 	/* 0x21f8 */
        {8,	0}, 	/* 0x21f9 */
        {8,	0}, 	/* 0x21fa */
        {8,	0}, 	/* 0x21fb */
        {8,	0}, 	/* 0x21fc */
        {8,	0}, 	/* 0x21fd */
        {8,	0}, 	/* 0x21fe */
        {8,	0}, 	/* 0x21ff */
        {8,	0}, 	/* 0x2200 */
        {8,	0}, 	/* 0x2201 */
        {8,	0}, 	/* 0x2202 */
        {8,	0}, 	/* 0x2203 */
        {8,	0}, 	/* 0x2204 */
        {8,	0}, 	/* 0x2205 */
        {8,	0}, 	/* 0x2206 */
        {8,	0}, 	/* 0x2207 */
        {8,	0}, 	/* 0x2208 */
        {8,	0}, 	/* 0x2209 */
        {8,	0}, 	/* 0x220a */
        {8,	0}, 	/* 0x220b */
        {8,	0}, 	/* 0x220c */
        {8,	0}, 	/* 0x220d */
        {8,	0}, 	/* 0x220e */
        {8,	0}, 	/* 0x220f */
        {8,	0}, 	/* 0x2210 */
        {8,	0}, 	/* 0x2211 */
        {8,	0}, 	/* 0x2212 */
        {8,	0}, 	/* 0x2213 */
        {8,	0}, 	/* 0x2214 */
        {8,	0}, 	/* 0x2215 */
        {8,	0}, 	/* 0x2216 */
        {8,	0}, 	/* 0x2217 */
        {8,	0}, 	/* 0x2218 */
        {8,	0}, 	/* 0x2219 */
        {8,	0}, 	/* 0x221a */
        {8,	0}, 	/* 0x221b */
        {8,	0}, 	/* 0x221c */
        {8,	0}, 	/* 0x221d */
        {8,	0}, 	/* 0x221e */
        {8,	0}, 	/* 0x221f */
        {8,	0}, 	/* 0x2220 */
        {8,	0}, 	/* 0x2221 */
        {8,	0}, 	/* 0x2222 */
        {8,	0}, 	/* 0x2223 */
        {8,	0}, 	/* 0x2224 */
        {8,	0}, 	/* 0x2225 */
        {8,	0}, 	/* 0x2226 */
        {8,	0}, 	/* 0x2227 */
        {8,	0}, 	/* 0x2228 */
        {8,	0}, 	/* 0x2229 */
        {8,	0}, 	/* 0x222a */
        {8,	0}, 	/* 0x222b */
        {8,	0}, 	/* 0x222c */
        {8,	0}, 	/* 0x222d */
        {8,	0}, 	/* 0x222e */
        {8,	0}, 	/* 0x222f */
        {8,	0}, 	/* 0x2230 */
        {8,	0}, 	/* 0x2231 */
        {8,	0}, 	/* 0x2232 */
        {8,	0}, 	/* 0x2233 */
        {8,	0}, 	/* 0x2234 */
        {8,	0}, 	/* 0x2235 */
        {8,	0}, 	/* 0x2236 */
        {8,	0}, 	/* 0x2237 */
        {8,	0}, 	/* 0x2238 */
        {8,	0}, 	/* 0x2239 */
        {8,	0}, 	/* 0x223a */
        {8,	0}, 	/* 0x223b */
        {8,	0}, 	/* 0x223c */
        {8,	0}, 	/* 0x223d */
        {8,	0}, 	/* 0x223e */
        {8,	0}, 	/* 0x223f */
        {8,	0}, 	/* 0x2240 */
        {8,	0}, 	/* 0x2241 */
        {8,	0}, 	/* 0x2242 */
        {8,	0}, 	/* 0x2243 */
        {8,	0}, 	/* 0x2244 */
        {8,	0}, 	/* 0x2245 */
        {8,	0}, 	/* 0x2246 */
        {8,	0}, 	/* 0x2247 */
        {8,	0}, 	/* 0x2248 */
        {8,	0}, 	/* 0x2249 */
        {8,	0}, 	/* 0x224a */
        {8,	0}, 	/* 0x224b */
        {8,	0}, 	/* 0x224c */
        {8,	0}, 	/* 0x224d */
        {8,	0}, 	/* 0x224e */
        {8,	0}, 	/* 0x224f */
        {8,	0}, 	/* 0x2250 */
        {8,	0}, 	/* 0x2251 */
        {8,	0}, 	/* 0x2252 */
        {8,	0}, 	/* 0x2253 */
        {8,	0}, 	/* 0x2254 */
        {8,	0}, 	/* 0x2255 */
        {8,	0}, 	/* 0x2256 */
        {8,	0}, 	/* 0x2257 */
        {8,	0}, 	/* 0x2258 */
        {8,	0}, 	/* 0x2259 */
        {8,	0}, 	/* 0x225a */
        {8,	0}, 	/* 0x225b */
        {8,	0}, 	/* 0x225c */
        {8,	0}, 	/* 0x225d */
        {8,	0}, 	/* 0x225e */
        {8,	0}, 	/* 0x225f */
        {8,	0}, 	/* 0x2260 */
        {8,	0}, 	/* 0x2261 */
        {8,	0}, 	/* 0x2262 */
        {8,	0}, 	/* 0x2263 */
        {8,	0}, 	/* 0x2264 */
        {8,	0}, 	/* 0x2265 */
        {8,	0}, 	/* 0x2266 */
        {8,	0}, 	/* 0x2267 */
        {8,	0}, 	/* 0x2268 */
        {8,	0}, 	/* 0x2269 */
        {8,	0}, 	/* 0x226a */
        {8,	0}, 	/* 0x226b */
        {8,	0}, 	/* 0x226c */
        {8,	0}, 	/* 0x226d */
        {8,	0}, 	/* 0x226e */
        {8,	0}, 	/* 0x226f */
        {8,	0}, 	/* 0x2270 */
        {8,	0}, 	/* 0x2271 */
        {8,	0}, 	/* 0x2272 */
        {8,	0}, 	/* 0x2273 */
        {8,	0}, 	/* 0x2274 */
        {8,	0}, 	/* 0x2275 */
        {8,	0}, 	/* 0x2276 */
        {8,	0}, 	/* 0x2277 */
        {8,	0}, 	/* 0x2278 */
        {8,	0}, 	/* 0x2279 */
        {8,	0}, 	/* 0x227a */
        {8,	0}, 	/* 0x227b */
        {8,	0}, 	/* 0x227c */
        {8,	0}, 	/* 0x227d */
        {8,	0}, 	/* 0x227e */
        {8,	0}, 	/* 0x227f */
        {8,	0}, 	/* 0x2280 */
        {8,	0}, 	/* 0x2281 */
        {8,	0}, 	/* 0x2282 */
        {8,	0}, 	/* 0x2283 */
        {8,	0}, 	/* 0x2284 */
        {8,	0}, 	/* 0x2285 */
        {8,	0}, 	/* 0x2286 */
        {8,	0}, 	/* 0x2287 */
        {8,	0}, 	/* 0x2288 */
        {8,	0}, 	/* 0x2289 */
        {8,	0}, 	/* 0x228a */
        {8,	0}, 	/* 0x228b */
        {8,	0}, 	/* 0x228c */
        {8,	0}, 	/* 0x228d */
        {8,	0}, 	/* 0x228e */
        {8,	0}, 	/* 0x228f */
        {8,	0}, 	/* 0x2290 */
        {8,	0}, 	/* 0x2291 */
        {8,	0}, 	/* 0x2292 */
        {8,	0}, 	/* 0x2293 */
        {8,	0}, 	/* 0x2294 */
        {8,	0}, 	/* 0x2295 */
        {8,	0}, 	/* 0x2296 */
        {8,	0}, 	/* 0x2297 */
        {8,	0}, 	/* 0x2298 */
        {8,	0}, 	/* 0x2299 */
        {8,	0}, 	/* 0x229a */
        {8,	0}, 	/* 0x229b */
        {8,	0}, 	/* 0x229c */
        {8,	0}, 	/* 0x229d */
        {8,	0}, 	/* 0x229e */
        {8,	0}, 	/* 0x229f */
        {8,	0}, 	/* 0x22a0 */
        {8,	0}, 	/* 0x22a1 */
        {8,	0}, 	/* 0x22a2 */
        {8,	0}, 	/* 0x22a3 */
        {8,	0}, 	/* 0x22a4 */
        {8,	0}, 	/* 0x22a5 */
        {8,	0}, 	/* 0x22a6 */
        {8,	0}, 	/* 0x22a7 */
        {8,	0}, 	/* 0x22a8 */
        {8,	0}, 	/* 0x22a9 */
        {8,	0}, 	/* 0x22aa */
        {8,	0}, 	/* 0x22ab */
        {8,	0}, 	/* 0x22ac */
        {8,	0}, 	/* 0x22ad */
        {8,	0}, 	/* 0x22ae */
        {8,	0}, 	/* 0x22af */
        {8,	0}, 	/* 0x22b0 */
        {8,	0}, 	/* 0x22b1 */
        {8,	0}, 	/* 0x22b2 */
        {8,	0}, 	/* 0x22b3 */
        {8,	0}, 	/* 0x22b4 */
        {8,	0}, 	/* 0x22b5 */
        {8,	0}, 	/* 0x22b6 */
        {8,	0}, 	/* 0x22b7 */
        {8,	0}, 	/* 0x22b8 */
        {8,	0}, 	/* 0x22b9 */
        {8,	0}, 	/* 0x22ba */
        {8,	0}, 	/* 0x22bb */
        {8,	0}, 	/* 0x22bc */
        {8,	0}, 	/* 0x22bd */
        {8,	0}, 	/* 0x22be */
        {8,	0}, 	/* 0x22bf */
        {8,	0}, 	/* 0x22c0 */
        {8,	0}, 	/* 0x22c1 */
        {8,	0}, 	/* 0x22c2 */
        {8,	0}, 	/* 0x22c3 */
        {8,	0}, 	/* 0x22c4 */
        {8,	0}, 	/* 0x22c5 */
        {8,	0}, 	/* 0x22c6 */
        {8,	0}, 	/* 0x22c7 */
        {8,	0}, 	/* 0x22c8 */
        {8,	0}, 	/* 0x22c9 */
        {8,	0}, 	/* 0x22ca */
        {8,	0}, 	/* 0x22cb */
        {8,	0}, 	/* 0x22cc */
        {8,	0}, 	/* 0x22cd */
        {8,	0}, 	/* 0x22ce */
        {8,	0}, 	/* 0x22cf */
        {8,	0}, 	/* 0x22d0 */
        {8,	0}, 	/* 0x22d1 */
        {8,	0}, 	/* 0x22d2 */
        {8,	0}, 	/* 0x22d3 */
        {8,	0}, 	/* 0x22d4 */
        {8,	0}, 	/* 0x22d5 */
        {8,	0}, 	/* 0x22d6 */
        {8,	0}, 	/* 0x22d7 */
        {8,	0}, 	/* 0x22d8 */
        {8,	0}, 	/* 0x22d9 */
        {8,	0}, 	/* 0x22da */
        {8,	0}, 	/* 0x22db */
        {8,	0}, 	/* 0x22dc */
        {8,	0}, 	/* 0x22dd */
        {8,	0}, 	/* 0x22de */
        {8,	0}, 	/* 0x22df */
        {8,	0}, 	/* 0x22e0 */
        {8,	0}, 	/* 0x22e1 */
        {8,	0}, 	/* 0x22e2 */
        {8,	0}, 	/* 0x22e3 */
        {8,	0}, 	/* 0x22e4 */
        {8,	0}, 	/* 0x22e5 */
        {8,	0}, 	/* 0x22e6 */
        {8,	0}, 	/* 0x22e7 */
        {8,	0}, 	/* 0x22e8 */
        {8,	0}, 	/* 0x22e9 */
        {8,	0}, 	/* 0x22ea */
        {8,	0}, 	/* 0x22eb */
        {8,	0}, 	/* 0x22ec */
        {8,	0}, 	/* 0x22ed */
        {8,	0}, 	/* 0x22ee */
        {8,	0}, 	/* 0x22ef */
        {8,	0}, 	/* 0x22f0 */
        {8,	0}, 	/* 0x22f1 */
        {8,	0}, 	/* 0x22f2 */
        {8,	0}, 	/* 0x22f3 */
        {8,	0}, 	/* 0x22f4 */
        {8,	0}, 	/* 0x22f5 */
        {8,	0}, 	/* 0x22f6 */
        {8,	0}, 	/* 0x22f7 */
        {8,	0}, 	/* 0x22f8 */
        {8,	0}, 	/* 0x22f9 */
        {8,	0}, 	/* 0x22fa */
        {8,	0}, 	/* 0x22fb */
        {8,	0}, 	/* 0x22fc */
        {8,	0}, 	/* 0x22fd */
        {8,	0}, 	/* 0x22fe */
        {8,	0}, 	/* 0x22ff */
        {8,	0}, 	/* 0x2300 */
        {8,	0}, 	/* 0x2301 */
        {8,	0}, 	/* 0x2302 */
        {8,	0}, 	/* 0x2303 */
        {8,	0}, 	/* 0x2304 */
        {8,	0}, 	/* 0x2305 */
        {8,	0}, 	/* 0x2306 */
        {8,	0}, 	/* 0x2307 */
        {8,	0}, 	/* 0x2308 */
        {8,	0}, 	/* 0x2309 */
        {8,	0}, 	/* 0x230a */
        {8,	0}, 	/* 0x230b */
        {8,	0}, 	/* 0x230c */
        {8,	0}, 	/* 0x230d */
        {8,	0}, 	/* 0x230e */
        {8,	0}, 	/* 0x230f */
        {8,	0}, 	/* 0x2310 */
        {8,	0}, 	/* 0x2311 */
        {8,	0}, 	/* 0x2312 */
        {8,	0}, 	/* 0x2313 */
        {8,	0}, 	/* 0x2314 */
        {8,	0}, 	/* 0x2315 */
        {8,	0}, 	/* 0x2316 */
        {8,	0}, 	/* 0x2317 */
        {8,	0}, 	/* 0x2318 */
        {8,	0}, 	/* 0x2319 */
        {8,	0}, 	/* 0x231a */
        {8,	0}, 	/* 0x231b */
        {8,	0}, 	/* 0x231c */
        {8,	0}, 	/* 0x231d */
        {8,	0}, 	/* 0x231e */
        {8,	0}, 	/* 0x231f */
        {8,	0}, 	/* 0x2320 */
        {8,	0}, 	/* 0x2321 */
        {8,	0}, 	/* 0x2322 */
        {8,	0}, 	/* 0x2323 */
        {8,	0}, 	/* 0x2324 */
        {8,	0}, 	/* 0x2325 */
        {8,	0}, 	/* 0x2326 */
        {8,	0}, 	/* 0x2327 */
        {8,	0}, 	/* 0x2328 */
        {8,	0}, 	/* 0x2329 */
        {8,	0}, 	/* 0x232a */
        {8,	0}, 	/* 0x232b */
        {8,	0}, 	/* 0x232c */
        {8,	0}, 	/* 0x232d */
        {8,	0}, 	/* 0x232e */
        {8,	0}, 	/* 0x232f */
        {8,	0}, 	/* 0x2330 */
        {8,	0}, 	/* 0x2331 */
        {8,	0}, 	/* 0x2332 */
        {8,	0}, 	/* 0x2333 */
        {8,	0}, 	/* 0x2334 */
        {8,	0}, 	/* 0x2335 */
        {8,	0}, 	/* 0x2336 */
        {8,	0}, 	/* 0x2337 */
        {8,	0}, 	/* 0x2338 */
        {8,	0}, 	/* 0x2339 */
        {8,	0}, 	/* 0x233a */
        {8,	0}, 	/* 0x233b */
        {8,	0}, 	/* 0x233c */
        {8,	0}, 	/* 0x233d */
        {8,	0}, 	/* 0x233e */
        {8,	0}, 	/* 0x233f */
        {8,	0}, 	/* 0x2340 */
        {8,	0}, 	/* 0x2341 */
        {8,	0}, 	/* 0x2342 */
        {8,	0}, 	/* 0x2343 */
        {8,	0}, 	/* 0x2344 */
        {8,	0}, 	/* 0x2345 */
        {8,	0}, 	/* 0x2346 */
        {8,	0}, 	/* 0x2347 */
        {8,	0}, 	/* 0x2348 */
        {8,	0}, 	/* 0x2349 */
        {8,	0}, 	/* 0x234a */
        {8,	0}, 	/* 0x234b */
        {8,	0}, 	/* 0x234c */
        {8,	0}, 	/* 0x234d */
        {8,	0}, 	/* 0x234e */
        {8,	0}, 	/* 0x234f */
        {8,	0}, 	/* 0x2350 */
        {8,	0}, 	/* 0x2351 */
        {8,	0}, 	/* 0x2352 */
        {8,	0}, 	/* 0x2353 */
        {8,	0}, 	/* 0x2354 */
        {8,	0}, 	/* 0x2355 */
        {8,	0}, 	/* 0x2356 */
        {8,	0}, 	/* 0x2357 */
        {8,	0}, 	/* 0x2358 */
        {8,	0}, 	/* 0x2359 */
        {8,	0}, 	/* 0x235a */
        {8,	0}, 	/* 0x235b */
        {8,	0}, 	/* 0x235c */
        {8,	0}, 	/* 0x235d */
        {8,	0}, 	/* 0x235e */
        {8,	0}, 	/* 0x235f */
        {8,	0}, 	/* 0x2360 */
        {8,	0}, 	/* 0x2361 */
        {8,	0}, 	/* 0x2362 */
        {8,	0}, 	/* 0x2363 */
        {8,	0}, 	/* 0x2364 */
        {8,	0}, 	/* 0x2365 */
        {8,	0}, 	/* 0x2366 */
        {8,	0}, 	/* 0x2367 */
        {8,	0}, 	/* 0x2368 */
        {8,	0}, 	/* 0x2369 */
        {8,	0}, 	/* 0x236a */
        {8,	0}, 	/* 0x236b */
        {8,	0}, 	/* 0x236c */
        {8,	0}, 	/* 0x236d */
        {8,	0}, 	/* 0x236e */
        {8,	0}, 	/* 0x236f */
        {8,	0}, 	/* 0x2370 */
        {8,	0}, 	/* 0x2371 */
        {8,	0}, 	/* 0x2372 */
        {8,	0}, 	/* 0x2373 */
        {8,	0}, 	/* 0x2374 */
        {8,	0}, 	/* 0x2375 */
        {8,	0}, 	/* 0x2376 */
        {8,	0}, 	/* 0x2377 */
        {8,	0}, 	/* 0x2378 */
        {8,	0}, 	/* 0x2379 */
        {8,	0}, 	/* 0x237a */
        {8,	0}, 	/* 0x237b */
        {8,	0}, 	/* 0x237c */
        {8,	0}, 	/* 0x237d */
        {8,	0}, 	/* 0x237e */
        {8,	0}, 	/* 0x237f */
        {8,	0}, 	/* 0x2380 */
        {8,	0}, 	/* 0x2381 */
        {8,	0}, 	/* 0x2382 */
        {8,	0}, 	/* 0x2383 */
        {8,	0}, 	/* 0x2384 */
        {8,	0}, 	/* 0x2385 */
        {8,	0}, 	/* 0x2386 */
        {8,	0}, 	/* 0x2387 */
        {8,	0}, 	/* 0x2388 */
        {8,	0}, 	/* 0x2389 */
        {8,	0}, 	/* 0x238a */
        {8,	0}, 	/* 0x238b */
        {8,	0}, 	/* 0x238c */
        {8,	0}, 	/* 0x238d */
        {8,	0}, 	/* 0x238e */
        {8,	0}, 	/* 0x238f */
        {8,	0}, 	/* 0x2390 */
        {8,	0}, 	/* 0x2391 */
        {8,	0}, 	/* 0x2392 */
        {8,	0}, 	/* 0x2393 */
        {8,	0}, 	/* 0x2394 */
        {8,	0}, 	/* 0x2395 */
        {8,	0}, 	/* 0x2396 */
        {8,	0}, 	/* 0x2397 */
        {8,	0}, 	/* 0x2398 */
        {8,	0}, 	/* 0x2399 */
        {8,	0}, 	/* 0x239a */
        {8,	0}, 	/* 0x239b */
        {8,	0}, 	/* 0x239c */
        {8,	0}, 	/* 0x239d */
        {8,	0}, 	/* 0x239e */
        {8,	0}, 	/* 0x239f */
        {8,	0}, 	/* 0x23a0 */
        {8,	0}, 	/* 0x23a1 */
        {8,	0}, 	/* 0x23a2 */
        {8,	0}, 	/* 0x23a3 */
        {8,	0}, 	/* 0x23a4 */
        {8,	0}, 	/* 0x23a5 */
        {8,	0}, 	/* 0x23a6 */
        {8,	0}, 	/* 0x23a7 */
        {8,	0}, 	/* 0x23a8 */
        {8,	0}, 	/* 0x23a9 */
        {8,	0}, 	/* 0x23aa */
        {8,	0}, 	/* 0x23ab */
        {8,	0}, 	/* 0x23ac */
        {8,	0}, 	/* 0x23ad */
        {8,	0}, 	/* 0x23ae */
        {8,	0}, 	/* 0x23af */
        {8,	0}, 	/* 0x23b0 */
        {8,	0}, 	/* 0x23b1 */
        {8,	0}, 	/* 0x23b2 */
        {8,	0}, 	/* 0x23b3 */
        {8,	0}, 	/* 0x23b4 */
        {8,	0}, 	/* 0x23b5 */
        {8,	0}, 	/* 0x23b6 */
        {8,	0}, 	/* 0x23b7 */
        {8,	0}, 	/* 0x23b8 */
        {8,	0}, 	/* 0x23b9 */
        {8,	0}, 	/* 0x23ba */
        {8,	0}, 	/* 0x23bb */
        {8,	0}, 	/* 0x23bc */
        {8,	0}, 	/* 0x23bd */
        {8,	0}, 	/* 0x23be */
        {8,	0}, 	/* 0x23bf */
        {8,	0}, 	/* 0x23c0 */
        {8,	0}, 	/* 0x23c1 */
        {8,	0}, 	/* 0x23c2 */
        {8,	0}, 	/* 0x23c3 */
        {8,	0}, 	/* 0x23c4 */
        {8,	0}, 	/* 0x23c5 */
        {8,	0}, 	/* 0x23c6 */
        {8,	0}, 	/* 0x23c7 */
        {8,	0}, 	/* 0x23c8 */
        {8,	0}, 	/* 0x23c9 */
        {8,	0}, 	/* 0x23ca */
        {8,	0}, 	/* 0x23cb */
        {8,	0}, 	/* 0x23cc */
        {8,	0}, 	/* 0x23cd */
        {8,	0}, 	/* 0x23ce */
        {8,	0}, 	/* 0x23cf */
        {8,	0}, 	/* 0x23d0 */
        {8,	0}, 	/* 0x23d1 */
        {8,	0}, 	/* 0x23d2 */
        {8,	0}, 	/* 0x23d3 */
        {8,	0}, 	/* 0x23d4 */
        {8,	0}, 	/* 0x23d5 */
        {8,	0}, 	/* 0x23d6 */
        {8,	0}, 	/* 0x23d7 */
        {8,	0}, 	/* 0x23d8 */
        {8,	0}, 	/* 0x23d9 */
        {8,	0}, 	/* 0x23da */
        {8,	0}, 	/* 0x23db */
        {8,	0}, 	/* 0x23dc */
        {8,	0}, 	/* 0x23dd */
        {8,	0}, 	/* 0x23de */
        {8,	0}, 	/* 0x23df */
        {8,	0}, 	/* 0x23e0 */
        {8,	0}, 	/* 0x23e1 */
        {8,	0}, 	/* 0x23e2 */
        {8,	0}, 	/* 0x23e3 */
        {8,	0}, 	/* 0x23e4 */
        {8,	0}, 	/* 0x23e5 */
        {8,	0}, 	/* 0x23e6 */
        {8,	0}, 	/* 0x23e7 */
        {8,	0}, 	/* 0x23e8 */
        {8,	0}, 	/* 0x23e9 */
        {8,	0}, 	/* 0x23ea */
        {8,	0}, 	/* 0x23eb */
        {8,	0}, 	/* 0x23ec */
        {8,	0}, 	/* 0x23ed */
        {8,	0}, 	/* 0x23ee */
        {8,	0}, 	/* 0x23ef */
        {8,	0}, 	/* 0x23f0 */
        {8,	0}, 	/* 0x23f1 */
        {8,	0}, 	/* 0x23f2 */
        {8,	0}, 	/* 0x23f3 */
        {8,	0}, 	/* 0x23f4 */
        {8,	0}, 	/* 0x23f5 */
        {8,	0}, 	/* 0x23f6 */
        {8,	0}, 	/* 0x23f7 */
        {8,	0}, 	/* 0x23f8 */
        {8,	0}, 	/* 0x23f9 */
        {8,	0}, 	/* 0x23fa */
        {8,	0}, 	/* 0x23fb */
        {8,	0}, 	/* 0x23fc */
        {8,	0}, 	/* 0x23fd */
        {8,	0}, 	/* 0x23fe */
        {8,	0}, 	/* 0x23ff */
        {8,	0}, 	/* 0x2400 */
        {8,	0}, 	/* 0x2401 */
        {8,	0}, 	/* 0x2402 */
        {8,	0}, 	/* 0x2403 */
        {8,	0}, 	/* 0x2404 */
        {8,	0}, 	/* 0x2405 */
        {8,	0}, 	/* 0x2406 */
        {8,	0}, 	/* 0x2407 */
        {8,	0}, 	/* 0x2408 */
        {8,	0}, 	/* 0x2409 */
        {8,	0}, 	/* 0x240a */
        {8,	0}, 	/* 0x240b */
        {8,	0}, 	/* 0x240c */
        {8,	0}, 	/* 0x240d */
        {8,	0}, 	/* 0x240e */
        {8,	0}, 	/* 0x240f */
        {8,	0}, 	/* 0x2410 */
        {8,	0}, 	/* 0x2411 */
        {8,	0}, 	/* 0x2412 */
        {8,	0}, 	/* 0x2413 */
        {8,	0}, 	/* 0x2414 */
        {8,	0}, 	/* 0x2415 */
        {8,	0}, 	/* 0x2416 */
        {8,	0}, 	/* 0x2417 */
        {8,	0}, 	/* 0x2418 */
        {8,	0}, 	/* 0x2419 */
        {8,	0}, 	/* 0x241a */
        {8,	0}, 	/* 0x241b */
        {8,	0}, 	/* 0x241c */
        {8,	0}, 	/* 0x241d */
        {8,	0}, 	/* 0x241e */
        {8,	0}, 	/* 0x241f */
        {8,	0}, 	/* 0x2420 */
        {8,	0}, 	/* 0x2421 */
        {8,	0}, 	/* 0x2422 */
        {8,	0}, 	/* 0x2423 */
        {8,	0}, 	/* 0x2424 */
        {8,	0}, 	/* 0x2425 */
        {8,	0}, 	/* 0x2426 */
        {8,	0}, 	/* 0x2427 */
        {8,	0}, 	/* 0x2428 */
        {8,	0}, 	/* 0x2429 */
        {8,	0}, 	/* 0x242a */
        {8,	0}, 	/* 0x242b */
        {8,	0}, 	/* 0x242c */
        {8,	0}, 	/* 0x242d */
        {8,	0}, 	/* 0x242e */
        {8,	0}, 	/* 0x242f */
        {8,	0}, 	/* 0x2430 */
        {8,	0}, 	/* 0x2431 */
        {8,	0}, 	/* 0x2432 */
        {8,	0}, 	/* 0x2433 */
        {8,	0}, 	/* 0x2434 */
        {8,	0}, 	/* 0x2435 */
        {8,	0}, 	/* 0x2436 */
        {8,	0}, 	/* 0x2437 */
        {8,	0}, 	/* 0x2438 */
        {8,	0}, 	/* 0x2439 */
        {8,	0}, 	/* 0x243a */
        {8,	0}, 	/* 0x243b */
        {8,	0}, 	/* 0x243c */
        {8,	0}, 	/* 0x243d */
        {8,	0}, 	/* 0x243e */
        {8,	0}, 	/* 0x243f */
        {8,	0}, 	/* 0x2440 */
        {8,	0}, 	/* 0x2441 */
        {8,	0}, 	/* 0x2442 */
        {8,	0}, 	/* 0x2443 */
        {8,	0}, 	/* 0x2444 */
        {8,	0}, 	/* 0x2445 */
        {8,	0}, 	/* 0x2446 */
        {8,	0}, 	/* 0x2447 */
        {8,	0}, 	/* 0x2448 */
        {8,	0}, 	/* 0x2449 */
        {8,	0}, 	/* 0x244a */
        {8,	0}, 	/* 0x244b */
        {8,	0}, 	/* 0x244c */
        {8,	0}, 	/* 0x244d */
        {8,	0}, 	/* 0x244e */
        {8,	0}, 	/* 0x244f */
        {8,	0}, 	/* 0x2450 */
        {8,	0}, 	/* 0x2451 */
        {8,	0}, 	/* 0x2452 */
        {8,	0}, 	/* 0x2453 */
        {8,	0}, 	/* 0x2454 */
        {8,	0}, 	/* 0x2455 */
        {8,	0}, 	/* 0x2456 */
        {8,	0}, 	/* 0x2457 */
        {8,	0}, 	/* 0x2458 */
        {8,	0}, 	/* 0x2459 */
        {8,	0}, 	/* 0x245a */
        {8,	0}, 	/* 0x245b */
        {8,	0}, 	/* 0x245c */
        {8,	0}, 	/* 0x245d */
        {8,	0}, 	/* 0x245e */
        {8,	0}, 	/* 0x245f */
        {8,	0}, 	/* 0x2460 */
        {8,	0}, 	/* 0x2461 */
        {8,	0}, 	/* 0x2462 */
        {8,	0}, 	/* 0x2463 */
        {8,	0}, 	/* 0x2464 */
        {8,	0}, 	/* 0x2465 */
        {8,	0}, 	/* 0x2466 */
        {8,	0}, 	/* 0x2467 */
        {8,	0}, 	/* 0x2468 */
        {8,	0}, 	/* 0x2469 */
        {8,	0}, 	/* 0x246a */
        {8,	0}, 	/* 0x246b */
        {8,	0}, 	/* 0x246c */
        {8,	0}, 	/* 0x246d */
        {8,	0}, 	/* 0x246e */
        {8,	0}, 	/* 0x246f */
        {8,	0}, 	/* 0x2470 */
        {8,	0}, 	/* 0x2471 */
        {8,	0}, 	/* 0x2472 */
        {8,	0}, 	/* 0x2473 */
        {8,	0}, 	/* 0x2474 */
        {8,	0}, 	/* 0x2475 */
        {8,	0}, 	/* 0x2476 */
        {8,	0}, 	/* 0x2477 */
        {8,	0}, 	/* 0x2478 */
        {8,	0}, 	/* 0x2479 */
        {8,	0}, 	/* 0x247a */
        {8,	0}, 	/* 0x247b */
        {8,	0}, 	/* 0x247c */
        {8,	0}, 	/* 0x247d */
        {8,	0}, 	/* 0x247e */
        {8,	0}, 	/* 0x247f */
        {8,	0}, 	/* 0x2480 */
        {8,	0}, 	/* 0x2481 */
        {8,	0}, 	/* 0x2482 */
        {8,	0}, 	/* 0x2483 */
        {8,	0}, 	/* 0x2484 */
        {8,	0}, 	/* 0x2485 */
        {8,	0}, 	/* 0x2486 */
        {8,	0}, 	/* 0x2487 */
        {8,	0}, 	/* 0x2488 */
        {8,	0}, 	/* 0x2489 */
        {8,	0}, 	/* 0x248a */
        {8,	0}, 	/* 0x248b */
        {8,	0}, 	/* 0x248c */
        {8,	0}, 	/* 0x248d */
        {8,	0}, 	/* 0x248e */
        {8,	0}, 	/* 0x248f */
        {8,	0}, 	/* 0x2490 */
        {8,	0}, 	/* 0x2491 */
        {8,	0}, 	/* 0x2492 */
        {8,	0}, 	/* 0x2493 */
        {8,	0}, 	/* 0x2494 */
        {8,	0}, 	/* 0x2495 */
        {8,	0}, 	/* 0x2496 */
        {8,	0}, 	/* 0x2497 */
        {8,	0}, 	/* 0x2498 */
        {8,	0}, 	/* 0x2499 */
        {8,	0}, 	/* 0x249a */
        {8,	0}, 	/* 0x249b */
        {8,	0}, 	/* 0x249c */
        {8,	0}, 	/* 0x249d */
        {8,	0}, 	/* 0x249e */
        {8,	0}, 	/* 0x249f */
        {8,	0}, 	/* 0x24a0 */
        {8,	0}, 	/* 0x24a1 */
        {8,	0}, 	/* 0x24a2 */
        {8,	0}, 	/* 0x24a3 */
        {8,	0}, 	/* 0x24a4 */
        {8,	0}, 	/* 0x24a5 */
        {8,	0}, 	/* 0x24a6 */
        {8,	0}, 	/* 0x24a7 */
        {8,	0}, 	/* 0x24a8 */
        {8,	0}, 	/* 0x24a9 */
        {8,	0}, 	/* 0x24aa */
        {8,	0}, 	/* 0x24ab */
        {8,	0}, 	/* 0x24ac */
        {8,	0}, 	/* 0x24ad */
        {8,	0}, 	/* 0x24ae */
        {8,	0}, 	/* 0x24af */
        {8,	0}, 	/* 0x24b0 */
        {8,	0}, 	/* 0x24b1 */
        {8,	0}, 	/* 0x24b2 */
        {8,	0}, 	/* 0x24b3 */
        {8,	0}, 	/* 0x24b4 */
        {8,	0}, 	/* 0x24b5 */
        {8,	0}, 	/* 0x24b6 */
        {8,	0}, 	/* 0x24b7 */
        {8,	0}, 	/* 0x24b8 */
        {8,	0}, 	/* 0x24b9 */
        {8,	0}, 	/* 0x24ba */
        {8,	0}, 	/* 0x24bb */
        {8,	0}, 	/* 0x24bc */
        {8,	0}, 	/* 0x24bd */
        {8,	0}, 	/* 0x24be */
        {8,	0}, 	/* 0x24bf */
        {8,	0}, 	/* 0x24c0 */
        {8,	0}, 	/* 0x24c1 */
        {8,	0}, 	/* 0x24c2 */
        {8,	0}, 	/* 0x24c3 */
        {8,	0}, 	/* 0x24c4 */
        {8,	0}, 	/* 0x24c5 */
        {8,	0}, 	/* 0x24c6 */
        {8,	0}, 	/* 0x24c7 */
        {8,	0}, 	/* 0x24c8 */
        {8,	0}, 	/* 0x24c9 */
        {8,	0}, 	/* 0x24ca */
        {8,	0}, 	/* 0x24cb */
        {8,	0}, 	/* 0x24cc */
        {8,	0}, 	/* 0x24cd */
        {8,	0}, 	/* 0x24ce */
        {8,	0}, 	/* 0x24cf */
        {8,	0}, 	/* 0x24d0 */
        {8,	0}, 	/* 0x24d1 */
        {8,	0}, 	/* 0x24d2 */
        {8,	0}, 	/* 0x24d3 */
        {8,	0}, 	/* 0x24d4 */
        {8,	0}, 	/* 0x24d5 */
        {8,	0}, 	/* 0x24d6 */
        {8,	0}, 	/* 0x24d7 */
        {8,	0}, 	/* 0x24d8 */
        {8,	0}, 	/* 0x24d9 */
        {8,	0}, 	/* 0x24da */
        {8,	0}, 	/* 0x24db */
        {8,	0}, 	/* 0x24dc */
        {8,	0}, 	/* 0x24dd */
        {8,	0}, 	/* 0x24de */
        {8,	0}, 	/* 0x24df */
        {8,	0}, 	/* 0x24e0 */
        {8,	0}, 	/* 0x24e1 */
        {8,	0}, 	/* 0x24e2 */
        {8,	0}, 	/* 0x24e3 */
        {8,	0}, 	/* 0x24e4 */
        {8,	0}, 	/* 0x24e5 */
        {8,	0}, 	/* 0x24e6 */
        {8,	0}, 	/* 0x24e7 */
        {8,	0}, 	/* 0x24e8 */
        {8,	0}, 	/* 0x24e9 */
        {8,	0}, 	/* 0x24ea */
        {8,	0}, 	/* 0x24eb */
        {8,	0}, 	/* 0x24ec */
        {8,	0}, 	/* 0x24ed */
        {8,	0}, 	/* 0x24ee */
        {8,	0}, 	/* 0x24ef */
        {8,	0}, 	/* 0x24f0 */
        {8,	0}, 	/* 0x24f1 */
        {8,	0}, 	/* 0x24f2 */
        {8,	0}, 	/* 0x24f3 */
        {8,	0}, 	/* 0x24f4 */
        {8,	0}, 	/* 0x24f5 */
        {8,	0}, 	/* 0x24f6 */
        {8,	0}, 	/* 0x24f7 */
        {8,	0}, 	/* 0x24f8 */
        {8,	0}, 	/* 0x24f9 */
        {8,	0}, 	/* 0x24fa */
        {8,	0}, 	/* 0x24fb */
        {8,	0}, 	/* 0x24fc */
        {8,	0}, 	/* 0x24fd */
        {8,	0}, 	/* 0x24fe */
        {8,	0}, 	/* 0x24ff */
        {8,	0}, 	/* 0x2500 */
        {8,	0}, 	/* 0x2501 */
        {8,	0}, 	/* 0x2502 */
        {8,	0}, 	/* 0x2503 */
        {8,	0}, 	/* 0x2504 */
        {8,	0}, 	/* 0x2505 */
        {8,	0}, 	/* 0x2506 */
        {8,	0}, 	/* 0x2507 */
        {8,	0}, 	/* 0x2508 */
        {8,	0}, 	/* 0x2509 */
        {8,	0}, 	/* 0x250a */
        {8,	0}, 	/* 0x250b */
        {8,	0}, 	/* 0x250c */
        {8,	0}, 	/* 0x250d */
        {8,	0}, 	/* 0x250e */
        {8,	0}, 	/* 0x250f */
        {8,	0}, 	/* 0x2510 */
        {8,	0}, 	/* 0x2511 */
        {8,	0}, 	/* 0x2512 */
        {8,	0}, 	/* 0x2513 */
        {8,	0}, 	/* 0x2514 */
        {8,	0}, 	/* 0x2515 */
        {8,	0}, 	/* 0x2516 */
        {8,	0}, 	/* 0x2517 */
        {8,	0}, 	/* 0x2518 */
        {8,	0}, 	/* 0x2519 */
        {8,	0}, 	/* 0x251a */
        {8,	0}, 	/* 0x251b */
        {8,	0}, 	/* 0x251c */
        {8,	0}, 	/* 0x251d */
        {8,	0}, 	/* 0x251e */
        {8,	0}, 	/* 0x251f */
        {8,	0}, 	/* 0x2520 */
        {8,	0}, 	/* 0x2521 */
        {8,	0}, 	/* 0x2522 */
        {8,	0}, 	/* 0x2523 */
        {8,	0}, 	/* 0x2524 */
        {8,	0}, 	/* 0x2525 */
        {8,	0}, 	/* 0x2526 */
        {8,	0}, 	/* 0x2527 */
        {8,	0}, 	/* 0x2528 */
        {8,	0}, 	/* 0x2529 */
        {8,	0}, 	/* 0x252a */
        {8,	0}, 	/* 0x252b */
        {8,	0}, 	/* 0x252c */
        {8,	0}, 	/* 0x252d */
        {8,	0}, 	/* 0x252e */
        {8,	0}, 	/* 0x252f */
        {8,	0}, 	/* 0x2530 */
        {8,	0}, 	/* 0x2531 */
        {8,	0}, 	/* 0x2532 */
        {8,	0}, 	/* 0x2533 */
        {8,	0}, 	/* 0x2534 */
        {8,	0}, 	/* 0x2535 */
        {8,	0}, 	/* 0x2536 */
        {8,	0}, 	/* 0x2537 */
        {8,	0}, 	/* 0x2538 */
        {8,	0}, 	/* 0x2539 */
        {8,	0}, 	/* 0x253a */
        {8,	0}, 	/* 0x253b */
        {8,	0}, 	/* 0x253c */
        {8,	0}, 	/* 0x253d */
        {8,	0}, 	/* 0x253e */
        {8,	0}, 	/* 0x253f */
        {8,	0}, 	/* 0x2540 */
        {8,	0}, 	/* 0x2541 */
        {8,	0}, 	/* 0x2542 */
        {8,	0}, 	/* 0x2543 */
        {8,	0}, 	/* 0x2544 */
        {8,	0}, 	/* 0x2545 */
        {8,	0}, 	/* 0x2546 */
        {8,	0}, 	/* 0x2547 */
        {8,	0}, 	/* 0x2548 */
        {8,	0}, 	/* 0x2549 */
        {8,	0}, 	/* 0x254a */
        {8,	0}, 	/* 0x254b */
        {8,	0}, 	/* 0x254c */
        {8,	0}, 	/* 0x254d */
        {8,	0}, 	/* 0x254e */
        {8,	0}, 	/* 0x254f */
        {8,	0}, 	/* 0x2550 */
        {8,	0}, 	/* 0x2551 */
        {8,	0}, 	/* 0x2552 */
        {8,	0}, 	/* 0x2553 */
        {8,	0}, 	/* 0x2554 */
        {8,	0}, 	/* 0x2555 */
        {8,	0}, 	/* 0x2556 */
        {8,	0}, 	/* 0x2557 */
        {8,	0}, 	/* 0x2558 */
        {8,	0}, 	/* 0x2559 */
        {8,	0}, 	/* 0x255a */
        {8,	0}, 	/* 0x255b */
        {8,	0}, 	/* 0x255c */
        {8,	0}, 	/* 0x255d */
        {8,	0}, 	/* 0x255e */
        {8,	0}, 	/* 0x255f */
        {8,	0}, 	/* 0x2560 */
        {8,	0}, 	/* 0x2561 */
        {8,	0}, 	/* 0x2562 */
        {8,	0}, 	/* 0x2563 */
        {8,	0}, 	/* 0x2564 */
        {8,	0}, 	/* 0x2565 */
        {8,	0}, 	/* 0x2566 */
        {8,	0}, 	/* 0x2567 */
        {8,	0}, 	/* 0x2568 */
        {8,	0}, 	/* 0x2569 */
        {8,	0}, 	/* 0x256a */
        {8,	0}, 	/* 0x256b */
        {8,	0}, 	/* 0x256c */
        {8,	0}, 	/* 0x256d */
        {8,	0}, 	/* 0x256e */
        {8,	0}, 	/* 0x256f */
        {8,	0}, 	/* 0x2570 */
        {8,	0}, 	/* 0x2571 */
        {8,	0}, 	/* 0x2572 */
        {8,	0}, 	/* 0x2573 */
        {8,	0}, 	/* 0x2574 */
        {8,	0}, 	/* 0x2575 */
        {8,	0}, 	/* 0x2576 */
        {8,	0}, 	/* 0x2577 */
        {8,	0}, 	/* 0x2578 */
        {8,	0}, 	/* 0x2579 */
        {8,	0}, 	/* 0x257a */
        {8,	0}, 	/* 0x257b */
        {8,	0}, 	/* 0x257c */
        {8,	0}, 	/* 0x257d */
        {8,	0}, 	/* 0x257e */
        {8,	0}, 	/* 0x257f */
        {8,	0}, 	/* 0x2580 */
        {8,	0}, 	/* 0x2581 */
        {8,	0}, 	/* 0x2582 */
        {8,	0}, 	/* 0x2583 */
        {8,	0}, 	/* 0x2584 */
        {8,	0}, 	/* 0x2585 */
        {8,	0}, 	/* 0x2586 */
        {8,	0}, 	/* 0x2587 */
        {8,	0}, 	/* 0x2588 */
        {8,	0}, 	/* 0x2589 */
        {8,	0}, 	/* 0x258a */
        {8,	0}, 	/* 0x258b */
        {8,	0}, 	/* 0x258c */
        {8,	0}, 	/* 0x258d */
        {8,	0}, 	/* 0x258e */
        {8,	0}, 	/* 0x258f */
        {8,	0}, 	/* 0x2590 */
        {8,	0}, 	/* 0x2591 */
        {8,	0}, 	/* 0x2592 */
        {8,	0}, 	/* 0x2593 */
        {8,	0}, 	/* 0x2594 */
        {8,	0}, 	/* 0x2595 */
        {8,	0}, 	/* 0x2596 */
        {8,	0}, 	/* 0x2597 */
        {8,	0}, 	/* 0x2598 */
        {8,	0}, 	/* 0x2599 */
        {8,	0}, 	/* 0x259a */
        {8,	0}, 	/* 0x259b */
        {8,	0}, 	/* 0x259c */
        {8,	0}, 	/* 0x259d */
        {8,	0}, 	/* 0x259e */
        {8,	0}, 	/* 0x259f */
        {8,	0}, 	/* 0x25a0 */
        {8,	0}, 	/* 0x25a1 */
        {8,	0}, 	/* 0x25a2 */
        {8,	0}, 	/* 0x25a3 */
        {8,	0}, 	/* 0x25a4 */
        {8,	0}, 	/* 0x25a5 */
        {8,	0}, 	/* 0x25a6 */
        {8,	0}, 	/* 0x25a7 */
        {8,	0}, 	/* 0x25a8 */
        {8,	0}, 	/* 0x25a9 */
        {8,	0}, 	/* 0x25aa */
        {8,	0}, 	/* 0x25ab */
        {8,	0}, 	/* 0x25ac */
        {8,	0}, 	/* 0x25ad */
        {8,	0}, 	/* 0x25ae */
        {8,	0}, 	/* 0x25af */
        {8,	0}, 	/* 0x25b0 */
        {8,	0}, 	/* 0x25b1 */
        {8,	0}, 	/* 0x25b2 */
        {8,	0}, 	/* 0x25b3 */
        {8,	0}, 	/* 0x25b4 */
        {8,	0}, 	/* 0x25b5 */
        {8,	0}, 	/* 0x25b6 */
        {8,	0}, 	/* 0x25b7 */
        {8,	0}, 	/* 0x25b8 */
        {8,	0}, 	/* 0x25b9 */
        {8,	0}, 	/* 0x25ba */
        {8,	0}, 	/* 0x25bb */
        {8,	0}, 	/* 0x25bc */
        {8,	0}, 	/* 0x25bd */
        {8,	0}, 	/* 0x25be */
        {8,	0}, 	/* 0x25bf */
        {8,	0}, 	/* 0x25c0 */
        {8,	0}, 	/* 0x25c1 */
        {8,	0}, 	/* 0x25c2 */
        {8,	0}, 	/* 0x25c3 */
        {8,	0}, 	/* 0x25c4 */
        {8,	0}, 	/* 0x25c5 */
        {8,	0}, 	/* 0x25c6 */
        {8,	0}, 	/* 0x25c7 */
        {8,	0}, 	/* 0x25c8 */
        {8,	0}, 	/* 0x25c9 */
        {8,	0}, 	/* 0x25ca */
        {8,	0}, 	/* 0x25cb */
        {8,	0}, 	/* 0x25cc */
        {8,	0}, 	/* 0x25cd */
        {8,	0}, 	/* 0x25ce */
        {8,	0}, 	/* 0x25cf */
        {8,	0}, 	/* 0x25d0 */
        {8,	0}, 	/* 0x25d1 */
        {8,	0}, 	/* 0x25d2 */
        {8,	0}, 	/* 0x25d3 */
        {8,	0}, 	/* 0x25d4 */
        {8,	0}, 	/* 0x25d5 */
        {8,	0}, 	/* 0x25d6 */
        {8,	0}, 	/* 0x25d7 */
        {8,	0}, 	/* 0x25d8 */
        {8,	0}, 	/* 0x25d9 */
        {8,	0}, 	/* 0x25da */
        {8,	0}, 	/* 0x25db */
        {8,	0}, 	/* 0x25dc */
        {8,	0}, 	/* 0x25dd */
        {8,	0}, 	/* 0x25de */
        {8,	0}, 	/* 0x25df */
        {8,	0}, 	/* 0x25e0 */
        {8,	0}, 	/* 0x25e1 */
        {8,	0}, 	/* 0x25e2 */
        {8,	0}, 	/* 0x25e3 */
        {8,	0}, 	/* 0x25e4 */
        {8,	0}, 	/* 0x25e5 */
        {8,	0}, 	/* 0x25e6 */
        {8,	0}, 	/* 0x25e7 */
        {8,	0}, 	/* 0x25e8 */
        {8,	0}, 	/* 0x25e9 */
        {8,	0}, 	/* 0x25ea */
        {8,	0}, 	/* 0x25eb */
        {8,	0}, 	/* 0x25ec */
        {8,	0}, 	/* 0x25ed */
        {8,	0}, 	/* 0x25ee */
        {8,	0}, 	/* 0x25ef */
        {8,	0}, 	/* 0x25f0 */
        {8,	0}, 	/* 0x25f1 */
        {8,	0}, 	/* 0x25f2 */
        {8,	0}, 	/* 0x25f3 */
        {8,	0}, 	/* 0x25f4 */
        {8,	0}, 	/* 0x25f5 */
        {8,	0}, 	/* 0x25f6 */
        {8,	0}, 	/* 0x25f7 */
        {8,	0}, 	/* 0x25f8 */
        {8,	0}, 	/* 0x25f9 */
        {8,	0}, 	/* 0x25fa */
        {8,	0}, 	/* 0x25fb */
        {8,	0}, 	/* 0x25fc */
        {8,	0}, 	/* 0x25fd */
        {8,	0}, 	/* 0x25fe */
        {8,	0}, 	/* 0x25ff */
        {8,	0}, 	/* 0x2600 */
        {8,	0}, 	/* 0x2601 */
        {8,	0}, 	/* 0x2602 */
        {8,	0}, 	/* 0x2603 */
        {8,	0}, 	/* 0x2604 */
        {8,	0}, 	/* 0x2605 */
        {8,	0}, 	/* 0x2606 */
        {8,	0}, 	/* 0x2607 */
        {8,	0}, 	/* 0x2608 */
        {8,	0}, 	/* 0x2609 */
        {8,	0}, 	/* 0x260a */
        {8,	0}, 	/* 0x260b */
        {8,	0}, 	/* 0x260c */
        {8,	0}, 	/* 0x260d */
        {8,	0}, 	/* 0x260e */
        {8,	0}, 	/* 0x260f */
        {8,	0}, 	/* 0x2610 */
        {8,	0}, 	/* 0x2611 */
        {8,	0}, 	/* 0x2612 */
        {8,	0}, 	/* 0x2613 */
        {8,	0}, 	/* 0x2614 */
        {8,	0}, 	/* 0x2615 */
        {8,	0}, 	/* 0x2616 */
        {8,	0}, 	/* 0x2617 */
        {8,	0}, 	/* 0x2618 */
        {8,	0}, 	/* 0x2619 */
        {8,	0}, 	/* 0x261a */
        {8,	0}, 	/* 0x261b */
        {8,	0}, 	/* 0x261c */
        {8,	0}, 	/* 0x261d */
        {8,	0}, 	/* 0x261e */
        {8,	0}, 	/* 0x261f */
        {8,	0}, 	/* 0x2620 */
        {8,	0}, 	/* 0x2621 */
        {8,	0}, 	/* 0x2622 */
        {8,	0}, 	/* 0x2623 */
        {8,	0}, 	/* 0x2624 */
        {8,	0}, 	/* 0x2625 */
        {8,	0}, 	/* 0x2626 */
        {8,	0}, 	/* 0x2627 */
        {8,	0}, 	/* 0x2628 */
        {8,	0}, 	/* 0x2629 */
        {8,	0}, 	/* 0x262a */
        {8,	0}, 	/* 0x262b */
        {8,	0}, 	/* 0x262c */
        {8,	0}, 	/* 0x262d */
        {8,	0}, 	/* 0x262e */
        {8,	0}, 	/* 0x262f */
        {8,	0}, 	/* 0x2630 */
        {8,	0}, 	/* 0x2631 */
        {8,	0}, 	/* 0x2632 */
        {8,	0}, 	/* 0x2633 */
        {8,	0}, 	/* 0x2634 */
        {8,	0}, 	/* 0x2635 */
        {8,	0}, 	/* 0x2636 */
        {8,	0}, 	/* 0x2637 */
        {8,	0}, 	/* 0x2638 */
        {8,	0}, 	/* 0x2639 */
        {8,	0}, 	/* 0x263a */
        {8,	0}, 	/* 0x263b */
        {8,	0}, 	/* 0x263c */
        {8,	0}, 	/* 0x263d */
        {8,	0}, 	/* 0x263e */
        {8,	0}, 	/* 0x263f */
        {8,	0}, 	/* 0x2640 */
        {8,	0}, 	/* 0x2641 */
        {8,	0}, 	/* 0x2642 */
        {8,	0}, 	/* 0x2643 */
        {8,	0}, 	/* 0x2644 */
        {8,	0}, 	/* 0x2645 */
        {8,	0}, 	/* 0x2646 */
        {8,	0}, 	/* 0x2647 */
        {8,	0}, 	/* 0x2648 */
        {8,	0}, 	/* 0x2649 */
        {8,	0}, 	/* 0x264a */
        {8,	0}, 	/* 0x264b */
        {8,	0}, 	/* 0x264c */
        {8,	0}, 	/* 0x264d */
        {8,	0}, 	/* 0x264e */
        {8,	0}, 	/* 0x264f */
        {8,	0}, 	/* 0x2650 */
        {8,	0}, 	/* 0x2651 */
        {8,	0}, 	/* 0x2652 */
        {8,	0}, 	/* 0x2653 */
        {8,	0}, 	/* 0x2654 */
        {8,	0}, 	/* 0x2655 */
        {8,	0}, 	/* 0x2656 */
        {8,	0}, 	/* 0x2657 */
        {8,	0}, 	/* 0x2658 */
        {8,	0}, 	/* 0x2659 */
        {8,	0}, 	/* 0x265a */
        {8,	0}, 	/* 0x265b */
        {8,	0}, 	/* 0x265c */
        {8,	0}, 	/* 0x265d */
        {8,	0}, 	/* 0x265e */
        {8,	0}, 	/* 0x265f */
        {8,	0}, 	/* 0x2660 */
        {8,	0}, 	/* 0x2661 */
        {8,	0}, 	/* 0x2662 */
        {8,	0}, 	/* 0x2663 */
        {8,	0}, 	/* 0x2664 */
        {8,	0}, 	/* 0x2665 */
        {8,	0}, 	/* 0x2666 */
        {8,	0}, 	/* 0x2667 */
        {8,	0}, 	/* 0x2668 */
        {8,	0}, 	/* 0x2669 */
        {8,	0}, 	/* 0x266a */
        {8,	0}, 	/* 0x266b */
        {8,	0}, 	/* 0x266c */
        {8,	0}, 	/* 0x266d */
        {8,	0}, 	/* 0x266e */
        {8,	0}, 	/* 0x266f */
        {8,	0}, 	/* 0x2670 */
        {8,	0}, 	/* 0x2671 */
        {8,	0}, 	/* 0x2672 */
        {8,	0}, 	/* 0x2673 */
        {8,	0}, 	/* 0x2674 */
        {8,	0}, 	/* 0x2675 */
        {8,	0}, 	/* 0x2676 */
        {8,	0}, 	/* 0x2677 */
        {8,	0}, 	/* 0x2678 */
        {8,	0}, 	/* 0x2679 */
        {8,	0}, 	/* 0x267a */
        {8,	0}, 	/* 0x267b */
        {8,	0}, 	/* 0x267c */
        {8,	0}, 	/* 0x267d */
        {8,	0}, 	/* 0x267e */
        {8,	0}, 	/* 0x267f */
        {8,	0}, 	/* 0x2680 */
        {8,	0}, 	/* 0x2681 */
        {8,	0}, 	/* 0x2682 */
        {8,	0}, 	/* 0x2683 */
        {8,	0}, 	/* 0x2684 */
        {8,	0}, 	/* 0x2685 */
        {8,	0}, 	/* 0x2686 */
        {8,	0}, 	/* 0x2687 */
        {8,	0}, 	/* 0x2688 */
        {8,	0}, 	/* 0x2689 */
        {8,	0}, 	/* 0x268a */
        {8,	0}, 	/* 0x268b */
        {8,	0}, 	/* 0x268c */
        {8,	0}, 	/* 0x268d */
        {8,	0}, 	/* 0x268e */
        {8,	0}, 	/* 0x268f */
        {8,	0}, 	/* 0x2690 */
        {8,	0}, 	/* 0x2691 */
        {8,	0}, 	/* 0x2692 */
        {8,	0}, 	/* 0x2693 */
        {8,	0}, 	/* 0x2694 */
        {8,	0}, 	/* 0x2695 */
        {8,	0}, 	/* 0x2696 */
        {8,	0}, 	/* 0x2697 */
        {8,	0}, 	/* 0x2698 */
        {8,	0}, 	/* 0x2699 */
        {8,	0}, 	/* 0x269a */
        {8,	0}, 	/* 0x269b */
        {8,	0}, 	/* 0x269c */
        {8,	0}, 	/* 0x269d */
        {8,	0}, 	/* 0x269e */
        {8,	0}, 	/* 0x269f */
        {8,	0}, 	/* 0x26a0 */
        {8,	0}, 	/* 0x26a1 */
        {8,	0}, 	/* 0x26a2 */
        {8,	0}, 	/* 0x26a3 */
        {8,	0}, 	/* 0x26a4 */
        {8,	0}, 	/* 0x26a5 */
        {8,	0}, 	/* 0x26a6 */
        {8,	0}, 	/* 0x26a7 */
        {8,	0}, 	/* 0x26a8 */
        {8,	0}, 	/* 0x26a9 */
        {8,	0}, 	/* 0x26aa */
        {8,	0}, 	/* 0x26ab */
        {8,	0}, 	/* 0x26ac */
        {8,	0}, 	/* 0x26ad */
        {8,	0}, 	/* 0x26ae */
        {8,	0}, 	/* 0x26af */
        {8,	0}, 	/* 0x26b0 */
        {8,	0}, 	/* 0x26b1 */
        {8,	0}, 	/* 0x26b2 */
        {8,	0}, 	/* 0x26b3 */
        {8,	0}, 	/* 0x26b4 */
        {8,	0}, 	/* 0x26b5 */
        {8,	0}, 	/* 0x26b6 */
        {8,	0}, 	/* 0x26b7 */
        {8,	0}, 	/* 0x26b8 */
        {8,	0}, 	/* 0x26b9 */
        {8,	0}, 	/* 0x26ba */
        {8,	0}, 	/* 0x26bb */
        {8,	0}, 	/* 0x26bc */
        {8,	0}, 	/* 0x26bd */
        {8,	0}, 	/* 0x26be */
        {8,	0}, 	/* 0x26bf */
        {8,	0}, 	/* 0x26c0 */
        {8,	0}, 	/* 0x26c1 */
        {8,	0}, 	/* 0x26c2 */
        {8,	0}, 	/* 0x26c3 */
        {8,	0}, 	/* 0x26c4 */
        {8,	0}, 	/* 0x26c5 */
        {8,	0}, 	/* 0x26c6 */
        {8,	0}, 	/* 0x26c7 */
        {8,	0}, 	/* 0x26c8 */
        {8,	0}, 	/* 0x26c9 */
        {8,	0}, 	/* 0x26ca */
        {8,	0}, 	/* 0x26cb */
        {8,	0}, 	/* 0x26cc */
        {8,	0}, 	/* 0x26cd */
        {8,	0}, 	/* 0x26ce */
        {8,	0}, 	/* 0x26cf */
        {8,	0}, 	/* 0x26d0 */
        {8,	0}, 	/* 0x26d1 */
        {8,	0}, 	/* 0x26d2 */
        {8,	0}, 	/* 0x26d3 */
        {8,	0}, 	/* 0x26d4 */
        {8,	0}, 	/* 0x26d5 */
        {8,	0}, 	/* 0x26d6 */
        {8,	0}, 	/* 0x26d7 */
        {8,	0}, 	/* 0x26d8 */
        {8,	0}, 	/* 0x26d9 */
        {8,	0}, 	/* 0x26da */
        {8,	0}, 	/* 0x26db */
        {8,	0}, 	/* 0x26dc */
        {8,	0}, 	/* 0x26dd */
        {8,	0}, 	/* 0x26de */
        {8,	0}, 	/* 0x26df */
        {8,	0}, 	/* 0x26e0 */
        {8,	0}, 	/* 0x26e1 */
        {8,	0}, 	/* 0x26e2 */
        {8,	0}, 	/* 0x26e3 */
        {8,	0}, 	/* 0x26e4 */
        {8,	0}, 	/* 0x26e5 */
        {8,	0}, 	/* 0x26e6 */
        {8,	0}, 	/* 0x26e7 */
        {8,	0}, 	/* 0x26e8 */
        {8,	0}, 	/* 0x26e9 */
        {8,	0}, 	/* 0x26ea */
        {8,	0}, 	/* 0x26eb */
        {8,	0}, 	/* 0x26ec */
        {8,	0}, 	/* 0x26ed */
        {8,	0}, 	/* 0x26ee */
        {8,	0}, 	/* 0x26ef */
        {8,	0}, 	/* 0x26f0 */
        {8,	0}, 	/* 0x26f1 */
        {8,	0}, 	/* 0x26f2 */
        {8,	0}, 	/* 0x26f3 */
        {8,	0}, 	/* 0x26f4 */
        {8,	0}, 	/* 0x26f5 */
        {8,	0}, 	/* 0x26f6 */
        {8,	0}, 	/* 0x26f7 */
        {8,	0}, 	/* 0x26f8 */
        {8,	0}, 	/* 0x26f9 */
        {8,	0}, 	/* 0x26fa */
        {8,	0}, 	/* 0x26fb */
        {8,	0}, 	/* 0x26fc */
        {8,	0}, 	/* 0x26fd */
        {8,	0}, 	/* 0x26fe */
        {8,	0}, 	/* 0x26ff */
        {8,	0}, 	/* 0x2700 */
        {8,	0}, 	/* 0x2701 */
        {8,	0}, 	/* 0x2702 */
        {8,	0}, 	/* 0x2703 */
        {8,	0}, 	/* 0x2704 */
        {8,	0}, 	/* 0x2705 */
        {8,	0}, 	/* 0x2706 */
        {8,	0}, 	/* 0x2707 */
        {8,	0}, 	/* 0x2708 */
        {8,	0}, 	/* 0x2709 */
        {8,	0}, 	/* 0x270a */
        {8,	0}, 	/* 0x270b */
        {8,	0}, 	/* 0x270c */
        {8,	0}, 	/* 0x270d */
        {8,	0}, 	/* 0x270e */
        {8,	0}, 	/* 0x270f */
        {8,	0}, 	/* 0x2710 */
        {8,	0}, 	/* 0x2711 */
        {8,	0}, 	/* 0x2712 */
        {8,	0}, 	/* 0x2713 */
        {8,	0}, 	/* 0x2714 */
        {8,	0}, 	/* 0x2715 */
        {8,	0}, 	/* 0x2716 */
        {8,	0}, 	/* 0x2717 */
        {8,	0}, 	/* 0x2718 */
        {8,	0}, 	/* 0x2719 */
        {8,	0}, 	/* 0x271a */
        {8,	0}, 	/* 0x271b */
        {8,	0}, 	/* 0x271c */
        {8,	0}, 	/* 0x271d */
        {8,	0}, 	/* 0x271e */
        {8,	0}, 	/* 0x271f */
        {8,	0}, 	/* 0x2720 */
        {8,	0}, 	/* 0x2721 */
        {8,	0}, 	/* 0x2722 */
        {8,	0}, 	/* 0x2723 */
        {8,	0}, 	/* 0x2724 */
        {8,	0}, 	/* 0x2725 */
        {8,	0}, 	/* 0x2726 */
        {8,	0}, 	/* 0x2727 */
        {8,	0}, 	/* 0x2728 */
        {8,	0}, 	/* 0x2729 */
        {8,	0}, 	/* 0x272a */
        {8,	0}, 	/* 0x272b */
        {8,	0}, 	/* 0x272c */
        {8,	0}, 	/* 0x272d */
        {8,	0}, 	/* 0x272e */
        {8,	0}, 	/* 0x272f */
        {8,	0}, 	/* 0x2730 */
        {8,	0}, 	/* 0x2731 */
        {8,	0}, 	/* 0x2732 */
        {8,	0}, 	/* 0x2733 */
        {8,	0}, 	/* 0x2734 */
        {8,	0}, 	/* 0x2735 */
        {8,	0}, 	/* 0x2736 */
        {8,	0}, 	/* 0x2737 */
        {8,	0}, 	/* 0x2738 */
        {8,	0}, 	/* 0x2739 */
        {8,	0}, 	/* 0x273a */
        {8,	0}, 	/* 0x273b */
        {8,	0}, 	/* 0x273c */
        {8,	0}, 	/* 0x273d */
        {8,	0}, 	/* 0x273e */
        {8,	0}, 	/* 0x273f */
        {8,	0}, 	/* 0x2740 */
        {8,	0}, 	/* 0x2741 */
        {8,	0}, 	/* 0x2742 */
        {8,	0}, 	/* 0x2743 */
        {8,	0}, 	/* 0x2744 */
        {8,	0}, 	/* 0x2745 */
        {8,	0}, 	/* 0x2746 */
        {8,	0}, 	/* 0x2747 */
        {8,	0}, 	/* 0x2748 */
        {8,	0}, 	/* 0x2749 */
        {8,	0}, 	/* 0x274a */
        {8,	0}, 	/* 0x274b */
        {8,	0}, 	/* 0x274c */
        {8,	0}, 	/* 0x274d */
        {8,	0}, 	/* 0x274e */
        {8,	0}, 	/* 0x274f */
        {8,	0}, 	/* 0x2750 */
        {8,	0}, 	/* 0x2751 */
        {8,	0}, 	/* 0x2752 */
        {8,	0}, 	/* 0x2753 */
        {8,	0}, 	/* 0x2754 */
        {8,	0}, 	/* 0x2755 */
        {8,	0}, 	/* 0x2756 */
        {8,	0}, 	/* 0x2757 */
        {8,	0}, 	/* 0x2758 */
        {8,	0}, 	/* 0x2759 */
        {8,	0}, 	/* 0x275a */
        {8,	0}, 	/* 0x275b */
        {8,	0}, 	/* 0x275c */
        {8,	0}, 	/* 0x275d */
        {8,	0}, 	/* 0x275e */
        {8,	0}, 	/* 0x275f */
        {8,	0}, 	/* 0x2760 */
        {8,	0}, 	/* 0x2761 */
        {8,	0}, 	/* 0x2762 */
        {8,	0}, 	/* 0x2763 */
        {8,	0}, 	/* 0x2764 */
        {8,	0}, 	/* 0x2765 */
        {8,	0}, 	/* 0x2766 */
        {8,	0}, 	/* 0x2767 */
        {8,	0}, 	/* 0x2768 */
        {8,	0}, 	/* 0x2769 */
        {8,	0}, 	/* 0x276a */
        {8,	0}, 	/* 0x276b */
        {8,	0}, 	/* 0x276c */
        {8,	0}, 	/* 0x276d */
        {8,	0}, 	/* 0x276e */
        {8,	0}, 	/* 0x276f */
        {8,	0}, 	/* 0x2770 */
        {8,	0}, 	/* 0x2771 */
        {8,	0}, 	/* 0x2772 */
        {8,	0}, 	/* 0x2773 */
        {8,	0}, 	/* 0x2774 */
        {8,	0}, 	/* 0x2775 */
        {8,	0}, 	/* 0x2776 */
        {8,	0}, 	/* 0x2777 */
        {8,	0}, 	/* 0x2778 */
        {8,	0}, 	/* 0x2779 */
        {8,	0}, 	/* 0x277a */
        {8,	0}, 	/* 0x277b */
        {8,	0}, 	/* 0x277c */
        {8,	0}, 	/* 0x277d */
        {8,	0}, 	/* 0x277e */
        {8,	0}, 	/* 0x277f */
        {8,	0}, 	/* 0x2780 */
        {8,	0}, 	/* 0x2781 */
        {8,	0}, 	/* 0x2782 */
        {8,	0}, 	/* 0x2783 */
        {8,	0}, 	/* 0x2784 */
        {8,	0}, 	/* 0x2785 */
        {8,	0}, 	/* 0x2786 */
        {8,	0}, 	/* 0x2787 */
        {8,	0}, 	/* 0x2788 */
        {8,	0}, 	/* 0x2789 */
        {8,	0}, 	/* 0x278a */
        {8,	0}, 	/* 0x278b */
        {8,	0}, 	/* 0x278c */
        {8,	0}, 	/* 0x278d */
        {8,	0}, 	/* 0x278e */
        {8,	0}, 	/* 0x278f */
        {8,	0}, 	/* 0x2790 */
        {8,	0}, 	/* 0x2791 */
        {8,	0}, 	/* 0x2792 */
        {8,	0}, 	/* 0x2793 */
        {8,	0}, 	/* 0x2794 */
        {8,	0}, 	/* 0x2795 */
        {8,	0}, 	/* 0x2796 */
        {8,	0}, 	/* 0x2797 */
        {8,	0}, 	/* 0x2798 */
        {8,	0}, 	/* 0x2799 */
        {8,	0}, 	/* 0x279a */
        {8,	0}, 	/* 0x279b */
        {8,	0}, 	/* 0x279c */
        {8,	0}, 	/* 0x279d */
        {8,	0}, 	/* 0x279e */
        {8,	0}, 	/* 0x279f */
        {8,	0}, 	/* 0x27a0 */
        {8,	0}, 	/* 0x27a1 */
        {8,	0}, 	/* 0x27a2 */
        {8,	0}, 	/* 0x27a3 */
        {8,	0}, 	/* 0x27a4 */
        {8,	0}, 	/* 0x27a5 */
        {8,	0}, 	/* 0x27a6 */
        {8,	0}, 	/* 0x27a7 */
        {8,	0}, 	/* 0x27a8 */
        {8,	0}, 	/* 0x27a9 */
        {8,	0}, 	/* 0x27aa */
        {8,	0}, 	/* 0x27ab */
        {8,	0}, 	/* 0x27ac */
        {8,	0}, 	/* 0x27ad */
        {8,	0}, 	/* 0x27ae */
        {8,	0}, 	/* 0x27af */
        {8,	0}, 	/* 0x27b0 */
        {8,	0}, 	/* 0x27b1 */
        {8,	0}, 	/* 0x27b2 */
        {8,	0}, 	/* 0x27b3 */
        {8,	0}, 	/* 0x27b4 */
        {8,	0}, 	/* 0x27b5 */
        {8,	0}, 	/* 0x27b6 */
        {8,	0}, 	/* 0x27b7 */
        {8,	0}, 	/* 0x27b8 */
        {8,	0}, 	/* 0x27b9 */
        {8,	0}, 	/* 0x27ba */
        {8,	0}, 	/* 0x27bb */
        {8,	0}, 	/* 0x27bc */
        {8,	0}, 	/* 0x27bd */
        {8,	0}, 	/* 0x27be */
        {8,	0}, 	/* 0x27bf */
        {8,	0}, 	/* 0x27c0 */
        {8,	0}, 	/* 0x27c1 */
        {8,	0}, 	/* 0x27c2 */
        {8,	0}, 	/* 0x27c3 */
        {8,	0}, 	/* 0x27c4 */
        {8,	0}, 	/* 0x27c5 */
        {8,	0}, 	/* 0x27c6 */
        {8,	0}, 	/* 0x27c7 */
        {8,	0}, 	/* 0x27c8 */
        {8,	0}, 	/* 0x27c9 */
        {8,	0}, 	/* 0x27ca */
        {8,	0}, 	/* 0x27cb */
        {8,	0}, 	/* 0x27cc */
        {8,	0}, 	/* 0x27cd */
        {8,	0}, 	/* 0x27ce */
        {8,	0}, 	/* 0x27cf */
        {8,	0}, 	/* 0x27d0 */
        {8,	0}, 	/* 0x27d1 */
        {8,	0}, 	/* 0x27d2 */
        {8,	0}, 	/* 0x27d3 */
        {8,	0}, 	/* 0x27d4 */
        {8,	0}, 	/* 0x27d5 */
        {8,	0}, 	/* 0x27d6 */
        {8,	0}, 	/* 0x27d7 */
        {8,	0}, 	/* 0x27d8 */
        {8,	0}, 	/* 0x27d9 */
        {8,	0}, 	/* 0x27da */
        {8,	0}, 	/* 0x27db */
        {8,	0}, 	/* 0x27dc */
        {8,	0}, 	/* 0x27dd */
        {8,	0}, 	/* 0x27de */
        {8,	0}, 	/* 0x27df */
        {8,	0}, 	/* 0x27e0 */
        {8,	0}, 	/* 0x27e1 */
        {8,	0}, 	/* 0x27e2 */
        {8,	0}, 	/* 0x27e3 */
        {8,	0}, 	/* 0x27e4 */
        {8,	0}, 	/* 0x27e5 */
        {8,	0}, 	/* 0x27e6 */
        {8,	0}, 	/* 0x27e7 */
        {8,	0}, 	/* 0x27e8 */
        {8,	0}, 	/* 0x27e9 */
        {8,	0}, 	/* 0x27ea */
        {8,	0}, 	/* 0x27eb */
        {8,	0}, 	/* 0x27ec */
        {8,	0}, 	/* 0x27ed */
        {8,	0}, 	/* 0x27ee */
        {8,	0}, 	/* 0x27ef */
        {8,	0}, 	/* 0x27f0 */
        {8,	0}, 	/* 0x27f1 */
        {8,	0}, 	/* 0x27f2 */
        {8,	0}, 	/* 0x27f3 */
        {8,	0}, 	/* 0x27f4 */
        {8,	0}, 	/* 0x27f5 */
        {8,	0}, 	/* 0x27f6 */
        {8,	0}, 	/* 0x27f7 */
        {8,	0}, 	/* 0x27f8 */
        {8,	0}, 	/* 0x27f9 */
        {8,	0}, 	/* 0x27fa */
        {8,	0}, 	/* 0x27fb */
        {8,	0}, 	/* 0x27fc */
        {8,	0}, 	/* 0x27fd */
        {8,	0}, 	/* 0x27fe */
        {8,	0}, 	/* 0x27ff */
        {8,	0}, 	/* 0x2800 */
        {8,	0}, 	/* 0x2801 */
        {8,	0}, 	/* 0x2802 */
        {8,	0}, 	/* 0x2803 */
        {8,	0}, 	/* 0x2804 */
        {8,	0}, 	/* 0x2805 */
        {8,	0}, 	/* 0x2806 */
        {8,	0}, 	/* 0x2807 */
        {8,	0}, 	/* 0x2808 */
        {8,	0}, 	/* 0x2809 */
        {8,	0}, 	/* 0x280a */
        {8,	0}, 	/* 0x280b */
        {8,	0}, 	/* 0x280c */
        {8,	0}, 	/* 0x280d */
        {8,	0}, 	/* 0x280e */
        {8,	0}, 	/* 0x280f */
        {8,	0}, 	/* 0x2810 */
        {8,	0}, 	/* 0x2811 */
        {8,	0}, 	/* 0x2812 */
        {8,	0}, 	/* 0x2813 */
        {8,	0}, 	/* 0x2814 */
        {8,	0}, 	/* 0x2815 */
        {8,	0}, 	/* 0x2816 */
        {8,	0}, 	/* 0x2817 */
        {8,	0}, 	/* 0x2818 */
        {8,	0}, 	/* 0x2819 */
        {8,	0}, 	/* 0x281a */
        {8,	0}, 	/* 0x281b */
        {8,	0}, 	/* 0x281c */
        {8,	0}, 	/* 0x281d */
        {8,	0}, 	/* 0x281e */
        {8,	0}, 	/* 0x281f */
        {8,	0}, 	/* 0x2820 */
        {8,	0}, 	/* 0x2821 */
        {8,	0}, 	/* 0x2822 */
        {8,	0}, 	/* 0x2823 */
        {8,	0}, 	/* 0x2824 */
        {8,	0}, 	/* 0x2825 */
        {8,	0}, 	/* 0x2826 */
        {8,	0}, 	/* 0x2827 */
        {8,	0}, 	/* 0x2828 */
        {8,	0}, 	/* 0x2829 */
        {8,	0}, 	/* 0x282a */
        {8,	0}, 	/* 0x282b */
        {8,	0}, 	/* 0x282c */
        {8,	0}, 	/* 0x282d */
        {8,	0}, 	/* 0x282e */
        {8,	0}, 	/* 0x282f */
        {8,	0}, 	/* 0x2830 */
        {8,	0}, 	/* 0x2831 */
        {8,	0}, 	/* 0x2832 */
        {8,	0}, 	/* 0x2833 */
        {8,	0}, 	/* 0x2834 */
        {8,	0}, 	/* 0x2835 */
        {8,	0}, 	/* 0x2836 */
        {8,	0}, 	/* 0x2837 */
        {8,	0}, 	/* 0x2838 */
        {8,	0}, 	/* 0x2839 */
        {8,	0}, 	/* 0x283a */
        {8,	0}, 	/* 0x283b */
        {8,	0}, 	/* 0x283c */
        {8,	0}, 	/* 0x283d */
        {8,	0}, 	/* 0x283e */
        {8,	0}, 	/* 0x283f */
        {8,	0}, 	/* 0x2840 */
        {8,	0}, 	/* 0x2841 */
        {8,	0}, 	/* 0x2842 */
        {8,	0}, 	/* 0x2843 */
        {8,	0}, 	/* 0x2844 */
        {8,	0}, 	/* 0x2845 */
        {8,	0}, 	/* 0x2846 */
        {8,	0}, 	/* 0x2847 */
        {8,	0}, 	/* 0x2848 */
        {8,	0}, 	/* 0x2849 */
        {8,	0}, 	/* 0x284a */
        {8,	0}, 	/* 0x284b */
        {8,	0}, 	/* 0x284c */
        {8,	0}, 	/* 0x284d */
        {8,	0}, 	/* 0x284e */
        {8,	0}, 	/* 0x284f */
        {8,	0}, 	/* 0x2850 */
        {8,	0}, 	/* 0x2851 */
        {8,	0}, 	/* 0x2852 */
        {8,	0}, 	/* 0x2853 */
        {8,	0}, 	/* 0x2854 */
        {8,	0}, 	/* 0x2855 */
        {8,	0}, 	/* 0x2856 */
        {8,	0}, 	/* 0x2857 */
        {8,	0}, 	/* 0x2858 */
        {8,	0}, 	/* 0x2859 */
        {8,	0}, 	/* 0x285a */
        {8,	0}, 	/* 0x285b */
        {8,	0}, 	/* 0x285c */
        {8,	0}, 	/* 0x285d */
        {8,	0}, 	/* 0x285e */
        {8,	0}, 	/* 0x285f */
        {8,	0}, 	/* 0x2860 */
        {8,	0}, 	/* 0x2861 */
        {8,	0}, 	/* 0x2862 */
        {8,	0}, 	/* 0x2863 */
        {8,	0}, 	/* 0x2864 */
        {8,	0}, 	/* 0x2865 */
        {8,	0}, 	/* 0x2866 */
        {8,	0}, 	/* 0x2867 */
        {8,	0}, 	/* 0x2868 */
        {8,	0}, 	/* 0x2869 */
        {8,	0}, 	/* 0x286a */
        {8,	0}, 	/* 0x286b */
        {8,	0}, 	/* 0x286c */
        {8,	0}, 	/* 0x286d */
        {8,	0}, 	/* 0x286e */
        {8,	0}, 	/* 0x286f */
        {8,	0}, 	/* 0x2870 */
        {8,	0}, 	/* 0x2871 */
        {8,	0}, 	/* 0x2872 */
        {8,	0}, 	/* 0x2873 */
        {8,	0}, 	/* 0x2874 */
        {8,	0}, 	/* 0x2875 */
        {8,	0}, 	/* 0x2876 */
        {8,	0}, 	/* 0x2877 */
        {8,	0}, 	/* 0x2878 */
        {8,	0}, 	/* 0x2879 */
        {8,	0}, 	/* 0x287a */
        {8,	0}, 	/* 0x287b */
        {8,	0}, 	/* 0x287c */
        {8,	0}, 	/* 0x287d */
        {8,	0}, 	/* 0x287e */
        {8,	0}, 	/* 0x287f */
        {8,	0}, 	/* 0x2880 */
        {8,	0}, 	/* 0x2881 */
        {8,	0}, 	/* 0x2882 */
        {8,	0}, 	/* 0x2883 */
        {8,	0}, 	/* 0x2884 */
        {8,	0}, 	/* 0x2885 */
        {8,	0}, 	/* 0x2886 */
        {8,	0}, 	/* 0x2887 */
        {8,	0}, 	/* 0x2888 */
        {8,	0}, 	/* 0x2889 */
        {8,	0}, 	/* 0x288a */
        {8,	0}, 	/* 0x288b */
        {8,	0}, 	/* 0x288c */
        {8,	0}, 	/* 0x288d */
        {8,	0}, 	/* 0x288e */
        {8,	0}, 	/* 0x288f */
        {8,	0}, 	/* 0x2890 */
        {8,	0}, 	/* 0x2891 */
        {8,	0}, 	/* 0x2892 */
        {8,	0}, 	/* 0x2893 */
        {8,	0}, 	/* 0x2894 */
        {8,	0}, 	/* 0x2895 */
        {8,	0}, 	/* 0x2896 */
        {8,	0}, 	/* 0x2897 */
        {8,	0}, 	/* 0x2898 */
        {8,	0}, 	/* 0x2899 */
        {8,	0}, 	/* 0x289a */
        {8,	0}, 	/* 0x289b */
        {8,	0}, 	/* 0x289c */
        {8,	0}, 	/* 0x289d */
        {8,	0}, 	/* 0x289e */
        {8,	0}, 	/* 0x289f */
        {8,	0}, 	/* 0x28a0 */
        {8,	0}, 	/* 0x28a1 */
        {8,	0}, 	/* 0x28a2 */
        {8,	0}, 	/* 0x28a3 */
        {8,	0}, 	/* 0x28a4 */
        {8,	0}, 	/* 0x28a5 */
        {8,	0}, 	/* 0x28a6 */
        {8,	0}, 	/* 0x28a7 */
        {8,	0}, 	/* 0x28a8 */
        {8,	0}, 	/* 0x28a9 */
        {8,	0}, 	/* 0x28aa */
        {8,	0}, 	/* 0x28ab */
        {8,	0}, 	/* 0x28ac */
        {8,	0}, 	/* 0x28ad */
        {8,	0}, 	/* 0x28ae */
        {8,	0}, 	/* 0x28af */
        {8,	0}, 	/* 0x28b0 */
        {8,	0}, 	/* 0x28b1 */
        {8,	0}, 	/* 0x28b2 */
        {8,	0}, 	/* 0x28b3 */
        {8,	0}, 	/* 0x28b4 */
        {8,	0}, 	/* 0x28b5 */
        {8,	0}, 	/* 0x28b6 */
        {8,	0}, 	/* 0x28b7 */
        {8,	0}, 	/* 0x28b8 */
        {8,	0}, 	/* 0x28b9 */
        {8,	0}, 	/* 0x28ba */
        {8,	0}, 	/* 0x28bb */
        {8,	0}, 	/* 0x28bc */
        {8,	0}, 	/* 0x28bd */
        {8,	0}, 	/* 0x28be */
        {8,	0}, 	/* 0x28bf */
        {8,	0}, 	/* 0x28c0 */
        {8,	0}, 	/* 0x28c1 */
        {8,	0}, 	/* 0x28c2 */
        {8,	0}, 	/* 0x28c3 */
        {8,	0}, 	/* 0x28c4 */
        {8,	0}, 	/* 0x28c5 */
        {8,	0}, 	/* 0x28c6 */
        {8,	0}, 	/* 0x28c7 */
        {8,	0}, 	/* 0x28c8 */
        {8,	0}, 	/* 0x28c9 */
        {8,	0}, 	/* 0x28ca */
        {8,	0}, 	/* 0x28cb */
        {8,	0}, 	/* 0x28cc */
        {8,	0}, 	/* 0x28cd */
        {8,	0}, 	/* 0x28ce */
        {8,	0}, 	/* 0x28cf */
        {8,	0}, 	/* 0x28d0 */
        {8,	0}, 	/* 0x28d1 */
        {8,	0}, 	/* 0x28d2 */
        {8,	0}, 	/* 0x28d3 */
        {8,	0}, 	/* 0x28d4 */
        {8,	0}, 	/* 0x28d5 */
        {8,	0}, 	/* 0x28d6 */
        {8,	0}, 	/* 0x28d7 */
        {8,	0}, 	/* 0x28d8 */
        {8,	0}, 	/* 0x28d9 */
        {8,	0}, 	/* 0x28da */
        {8,	0}, 	/* 0x28db */
        {8,	0}, 	/* 0x28dc */
        {8,	0}, 	/* 0x28dd */
        {8,	0}, 	/* 0x28de */
        {8,	0}, 	/* 0x28df */
        {8,	0}, 	/* 0x28e0 */
        {8,	0}, 	/* 0x28e1 */
        {8,	0}, 	/* 0x28e2 */
        {8,	0}, 	/* 0x28e3 */
        {8,	0}, 	/* 0x28e4 */
        {8,	0}, 	/* 0x28e5 */
        {8,	0}, 	/* 0x28e6 */
        {8,	0}, 	/* 0x28e7 */
        {8,	0}, 	/* 0x28e8 */
        {8,	0}, 	/* 0x28e9 */
        {8,	0}, 	/* 0x28ea */
        {8,	0}, 	/* 0x28eb */
        {8,	0}, 	/* 0x28ec */
        {8,	0}, 	/* 0x28ed */
        {8,	0}, 	/* 0x28ee */
        {8,	0}, 	/* 0x28ef */
        {8,	0}, 	/* 0x28f0 */
        {8,	0}, 	/* 0x28f1 */
        {8,	0}, 	/* 0x28f2 */
        {8,	0}, 	/* 0x28f3 */
        {8,	0}, 	/* 0x28f4 */
        {8,	0}, 	/* 0x28f5 */
        {8,	0}, 	/* 0x28f6 */
        {8,	0}, 	/* 0x28f7 */
        {8,	0}, 	/* 0x28f8 */
        {8,	0}, 	/* 0x28f9 */
        {8,	0}, 	/* 0x28fa */
        {8,	0}, 	/* 0x28fb */
        {8,	0}, 	/* 0x28fc */
        {8,	0}, 	/* 0x28fd */
        {8,	0}, 	/* 0x28fe */
        {8,	0}, 	/* 0x28ff */
        {8,	0}, 	/* 0x2900 */
        {8,	0}, 	/* 0x2901 */
        {8,	0}, 	/* 0x2902 */
        {8,	0}, 	/* 0x2903 */
        {8,	0}, 	/* 0x2904 */
        {8,	0}, 	/* 0x2905 */
        {8,	0}, 	/* 0x2906 */
        {8,	0}, 	/* 0x2907 */
        {8,	0}, 	/* 0x2908 */
        {8,	0}, 	/* 0x2909 */
        {8,	0}, 	/* 0x290a */
        {8,	0}, 	/* 0x290b */
        {8,	0}, 	/* 0x290c */
        {8,	0}, 	/* 0x290d */
        {8,	0}, 	/* 0x290e */
        {8,	0}, 	/* 0x290f */
        {8,	0}, 	/* 0x2910 */
        {8,	0}, 	/* 0x2911 */
        {8,	0}, 	/* 0x2912 */
        {8,	0}, 	/* 0x2913 */
        {8,	0}, 	/* 0x2914 */
        {8,	0}, 	/* 0x2915 */
        {8,	0}, 	/* 0x2916 */
        {8,	0}, 	/* 0x2917 */
        {8,	0}, 	/* 0x2918 */
        {8,	0}, 	/* 0x2919 */
        {8,	0}, 	/* 0x291a */
        {8,	0}, 	/* 0x291b */
        {8,	0}, 	/* 0x291c */
        {8,	0}, 	/* 0x291d */
        {8,	0}, 	/* 0x291e */
        {8,	0}, 	/* 0x291f */
        {8,	0}, 	/* 0x2920 */
        {8,	0}, 	/* 0x2921 */
        {8,	0}, 	/* 0x2922 */
        {8,	0}, 	/* 0x2923 */
        {8,	0}, 	/* 0x2924 */
        {8,	0}, 	/* 0x2925 */
        {8,	0}, 	/* 0x2926 */
        {8,	0}, 	/* 0x2927 */
        {8,	0}, 	/* 0x2928 */
        {8,	0}, 	/* 0x2929 */
        {8,	0}, 	/* 0x292a */
        {8,	0}, 	/* 0x292b */
        {8,	0}, 	/* 0x292c */
        {8,	0}, 	/* 0x292d */
        {8,	0}, 	/* 0x292e */
        {8,	0}, 	/* 0x292f */
        {8,	0}, 	/* 0x2930 */
        {8,	0}, 	/* 0x2931 */
        {8,	0}, 	/* 0x2932 */
        {8,	0}, 	/* 0x2933 */
        {8,	0}, 	/* 0x2934 */
        {8,	0}, 	/* 0x2935 */
        {8,	0}, 	/* 0x2936 */
        {8,	0}, 	/* 0x2937 */
        {8,	0}, 	/* 0x2938 */
        {8,	0}, 	/* 0x2939 */
        {8,	0}, 	/* 0x293a */
        {8,	0}, 	/* 0x293b */
        {8,	0}, 	/* 0x293c */
        {8,	0}, 	/* 0x293d */
        {8,	0}, 	/* 0x293e */
        {8,	0}, 	/* 0x293f */
        {8,	0}, 	/* 0x2940 */
        {8,	0}, 	/* 0x2941 */
        {8,	0}, 	/* 0x2942 */
        {8,	0}, 	/* 0x2943 */
        {8,	0}, 	/* 0x2944 */
        {8,	0}, 	/* 0x2945 */
        {8,	0}, 	/* 0x2946 */
        {8,	0}, 	/* 0x2947 */
        {8,	0}, 	/* 0x2948 */
        {8,	0}, 	/* 0x2949 */
        {8,	0}, 	/* 0x294a */
        {8,	0}, 	/* 0x294b */
        {8,	0}, 	/* 0x294c */
        {8,	0}, 	/* 0x294d */
        {8,	0}, 	/* 0x294e */
        {8,	0}, 	/* 0x294f */
        {8,	0}, 	/* 0x2950 */
        {8,	0}, 	/* 0x2951 */
        {8,	0}, 	/* 0x2952 */
        {8,	0}, 	/* 0x2953 */
        {8,	0}, 	/* 0x2954 */
        {8,	0}, 	/* 0x2955 */
        {8,	0}, 	/* 0x2956 */
        {8,	0}, 	/* 0x2957 */
        {8,	0}, 	/* 0x2958 */
        {8,	0}, 	/* 0x2959 */
        {8,	0}, 	/* 0x295a */
        {8,	0}, 	/* 0x295b */
        {8,	0}, 	/* 0x295c */
        {8,	0}, 	/* 0x295d */
        {8,	0}, 	/* 0x295e */
        {8,	0}, 	/* 0x295f */
        {8,	0}, 	/* 0x2960 */
        {8,	0}, 	/* 0x2961 */
        {8,	0}, 	/* 0x2962 */
        {8,	0}, 	/* 0x2963 */
        {8,	0}, 	/* 0x2964 */
        {8,	0}, 	/* 0x2965 */
        {8,	0}, 	/* 0x2966 */
        {8,	0}, 	/* 0x2967 */
        {8,	0}, 	/* 0x2968 */
        {8,	0}, 	/* 0x2969 */
        {8,	0}, 	/* 0x296a */
        {8,	0}, 	/* 0x296b */
        {8,	0}, 	/* 0x296c */
        {8,	0}, 	/* 0x296d */
        {8,	0}, 	/* 0x296e */
        {8,	0}, 	/* 0x296f */
        {8,	0}, 	/* 0x2970 */
        {8,	0}, 	/* 0x2971 */
        {8,	0}, 	/* 0x2972 */
        {8,	0}, 	/* 0x2973 */
        {8,	0}, 	/* 0x2974 */
        {8,	0}, 	/* 0x2975 */
        {8,	0}, 	/* 0x2976 */
        {8,	0}, 	/* 0x2977 */
        {8,	0}, 	/* 0x2978 */
        {8,	0}, 	/* 0x2979 */
        {8,	0}, 	/* 0x297a */
        {8,	0}, 	/* 0x297b */
        {8,	0}, 	/* 0x297c */
        {8,	0}, 	/* 0x297d */
        {8,	0}, 	/* 0x297e */
        {8,	0}, 	/* 0x297f */
        {8,	0}, 	/* 0x2980 */
        {8,	0}, 	/* 0x2981 */
        {8,	0}, 	/* 0x2982 */
        {8,	0}, 	/* 0x2983 */
        {8,	0}, 	/* 0x2984 */
        {8,	0}, 	/* 0x2985 */
        {8,	0}, 	/* 0x2986 */
        {8,	0}, 	/* 0x2987 */
        {8,	0}, 	/* 0x2988 */
        {8,	0}, 	/* 0x2989 */
        {8,	0}, 	/* 0x298a */
        {8,	0}, 	/* 0x298b */
        {8,	0}, 	/* 0x298c */
        {8,	0}, 	/* 0x298d */
        {8,	0}, 	/* 0x298e */
        {8,	0}, 	/* 0x298f */
        {8,	0}, 	/* 0x2990 */
        {8,	0}, 	/* 0x2991 */
        {8,	0}, 	/* 0x2992 */
        {8,	0}, 	/* 0x2993 */
        {8,	0}, 	/* 0x2994 */
        {8,	0}, 	/* 0x2995 */
        {8,	0}, 	/* 0x2996 */
        {8,	0}, 	/* 0x2997 */
        {8,	0}, 	/* 0x2998 */
        {8,	0}, 	/* 0x2999 */
        {8,	0}, 	/* 0x299a */
        {8,	0}, 	/* 0x299b */
        {8,	0}, 	/* 0x299c */
        {8,	0}, 	/* 0x299d */
        {8,	0}, 	/* 0x299e */
        {8,	0}, 	/* 0x299f */
        {8,	0}, 	/* 0x29a0 */
        {8,	0}, 	/* 0x29a1 */
        {8,	0}, 	/* 0x29a2 */
        {8,	0}, 	/* 0x29a3 */
        {8,	0}, 	/* 0x29a4 */
        {8,	0}, 	/* 0x29a5 */
        {8,	0}, 	/* 0x29a6 */
        {8,	0}, 	/* 0x29a7 */
        {8,	0}, 	/* 0x29a8 */
        {8,	0}, 	/* 0x29a9 */
        {8,	0}, 	/* 0x29aa */
        {8,	0}, 	/* 0x29ab */
        {8,	0}, 	/* 0x29ac */
        {8,	0}, 	/* 0x29ad */
        {8,	0}, 	/* 0x29ae */
        {8,	0}, 	/* 0x29af */
        {8,	0}, 	/* 0x29b0 */
        {8,	0}, 	/* 0x29b1 */
        {8,	0}, 	/* 0x29b2 */
        {8,	0}, 	/* 0x29b3 */
        {8,	0}, 	/* 0x29b4 */
        {8,	0}, 	/* 0x29b5 */
        {8,	0}, 	/* 0x29b6 */
        {8,	0}, 	/* 0x29b7 */
        {8,	0}, 	/* 0x29b8 */
        {8,	0}, 	/* 0x29b9 */
        {8,	0}, 	/* 0x29ba */
        {8,	0}, 	/* 0x29bb */
        {8,	0}, 	/* 0x29bc */
        {8,	0}, 	/* 0x29bd */
        {8,	0}, 	/* 0x29be */
        {8,	0}, 	/* 0x29bf */
        {8,	0}, 	/* 0x29c0 */
        {8,	0}, 	/* 0x29c1 */
        {8,	0}, 	/* 0x29c2 */
        {8,	0}, 	/* 0x29c3 */
        {8,	0}, 	/* 0x29c4 */
        {8,	0}, 	/* 0x29c5 */
        {8,	0}, 	/* 0x29c6 */
        {8,	0}, 	/* 0x29c7 */
        {8,	0}, 	/* 0x29c8 */
        {8,	0}, 	/* 0x29c9 */
        {8,	0}, 	/* 0x29ca */
        {8,	0}, 	/* 0x29cb */
        {8,	0}, 	/* 0x29cc */
        {8,	0}, 	/* 0x29cd */
        {8,	0}, 	/* 0x29ce */
        {8,	0}, 	/* 0x29cf */
        {8,	0}, 	/* 0x29d0 */
        {8,	0}, 	/* 0x29d1 */
        {8,	0}, 	/* 0x29d2 */
        {8,	0}, 	/* 0x29d3 */
        {8,	0}, 	/* 0x29d4 */
        {8,	0}, 	/* 0x29d5 */
        {8,	0}, 	/* 0x29d6 */
        {8,	0}, 	/* 0x29d7 */
        {8,	0}, 	/* 0x29d8 */
        {8,	0}, 	/* 0x29d9 */
        {8,	0}, 	/* 0x29da */
        {8,	0}, 	/* 0x29db */
        {8,	0}, 	/* 0x29dc */
        {8,	0}, 	/* 0x29dd */
        {8,	0}, 	/* 0x29de */
        {8,	0}, 	/* 0x29df */
        {8,	0}, 	/* 0x29e0 */
        {8,	0}, 	/* 0x29e1 */
        {8,	0}, 	/* 0x29e2 */
        {8,	0}, 	/* 0x29e3 */
        {8,	0}, 	/* 0x29e4 */
        {8,	0}, 	/* 0x29e5 */
        {8,	0}, 	/* 0x29e6 */
        {8,	0}, 	/* 0x29e7 */
        {8,	0}, 	/* 0x29e8 */
        {8,	0}, 	/* 0x29e9 */
        {8,	0}, 	/* 0x29ea */
        {8,	0}, 	/* 0x29eb */
        {8,	0}, 	/* 0x29ec */
        {8,	0}, 	/* 0x29ed */
        {8,	0}, 	/* 0x29ee */
        {8,	0}, 	/* 0x29ef */
        {8,	0}, 	/* 0x29f0 */
        {8,	0}, 	/* 0x29f1 */
        {8,	0}, 	/* 0x29f2 */
        {8,	0}, 	/* 0x29f3 */
        {8,	0}, 	/* 0x29f4 */
        {8,	0}, 	/* 0x29f5 */
        {8,	0}, 	/* 0x29f6 */
        {8,	0}, 	/* 0x29f7 */
        {8,	0}, 	/* 0x29f8 */
        {8,	0}, 	/* 0x29f9 */
        {8,	0}, 	/* 0x29fa */
        {8,	0}, 	/* 0x29fb */
        {8,	0}, 	/* 0x29fc */
        {8,	0}, 	/* 0x29fd */
        {8,	0}, 	/* 0x29fe */
        {8,	0}, 	/* 0x29ff */
        {8,	0}, 	/* 0x2a00 */
        {8,	0}, 	/* 0x2a01 */
        {8,	0}, 	/* 0x2a02 */
        {8,	0}, 	/* 0x2a03 */
        {8,	0}, 	/* 0x2a04 */
        {8,	0}, 	/* 0x2a05 */
        {8,	0}, 	/* 0x2a06 */
        {8,	0}, 	/* 0x2a07 */
        {8,	0}, 	/* 0x2a08 */
        {8,	0}, 	/* 0x2a09 */
        {8,	0}, 	/* 0x2a0a */
        {8,	0}, 	/* 0x2a0b */
        {8,	0}, 	/* 0x2a0c */
        {8,	0}, 	/* 0x2a0d */
        {8,	0}, 	/* 0x2a0e */
        {8,	0}, 	/* 0x2a0f */
        {8,	0}, 	/* 0x2a10 */
        {8,	0}, 	/* 0x2a11 */
        {8,	0}, 	/* 0x2a12 */
        {8,	0}, 	/* 0x2a13 */
        {8,	0}, 	/* 0x2a14 */
        {8,	0}, 	/* 0x2a15 */
        {8,	0}, 	/* 0x2a16 */
        {8,	0}, 	/* 0x2a17 */
        {8,	0}, 	/* 0x2a18 */
        {8,	0}, 	/* 0x2a19 */
        {8,	0}, 	/* 0x2a1a */
        {8,	0}, 	/* 0x2a1b */
        {8,	0}, 	/* 0x2a1c */
        {8,	0}, 	/* 0x2a1d */
        {8,	0}, 	/* 0x2a1e */
        {8,	0}, 	/* 0x2a1f */
        {8,	0}, 	/* 0x2a20 */
        {8,	0}, 	/* 0x2a21 */
        {8,	0}, 	/* 0x2a22 */
        {8,	0}, 	/* 0x2a23 */
        {8,	0}, 	/* 0x2a24 */
        {8,	0}, 	/* 0x2a25 */
        {8,	0}, 	/* 0x2a26 */
        {8,	0}, 	/* 0x2a27 */
        {8,	0}, 	/* 0x2a28 */
        {8,	0}, 	/* 0x2a29 */
        {8,	0}, 	/* 0x2a2a */
        {8,	0}, 	/* 0x2a2b */
        {8,	0}, 	/* 0x2a2c */
        {8,	0}, 	/* 0x2a2d */
        {8,	0}, 	/* 0x2a2e */
        {8,	0}, 	/* 0x2a2f */
        {8,	0}, 	/* 0x2a30 */
        {8,	0}, 	/* 0x2a31 */
        {8,	0}, 	/* 0x2a32 */
        {8,	0}, 	/* 0x2a33 */
        {8,	0}, 	/* 0x2a34 */
        {8,	0}, 	/* 0x2a35 */
        {8,	0}, 	/* 0x2a36 */
        {8,	0}, 	/* 0x2a37 */
        {8,	0}, 	/* 0x2a38 */
        {8,	0}, 	/* 0x2a39 */
        {8,	0}, 	/* 0x2a3a */
        {8,	0}, 	/* 0x2a3b */
        {8,	0}, 	/* 0x2a3c */
        {8,	0}, 	/* 0x2a3d */
        {8,	0}, 	/* 0x2a3e */
        {8,	0}, 	/* 0x2a3f */
        {8,	0}, 	/* 0x2a40 */
        {8,	0}, 	/* 0x2a41 */
        {8,	0}, 	/* 0x2a42 */
        {8,	0}, 	/* 0x2a43 */
        {8,	0}, 	/* 0x2a44 */
        {8,	0}, 	/* 0x2a45 */
        {8,	0}, 	/* 0x2a46 */
        {8,	0}, 	/* 0x2a47 */
        {8,	0}, 	/* 0x2a48 */
        {8,	0}, 	/* 0x2a49 */
        {8,	0}, 	/* 0x2a4a */
        {8,	0}, 	/* 0x2a4b */
        {8,	0}, 	/* 0x2a4c */
        {8,	0}, 	/* 0x2a4d */
        {8,	0}, 	/* 0x2a4e */
        {8,	0}, 	/* 0x2a4f */
        {8,	0}, 	/* 0x2a50 */
        {8,	0}, 	/* 0x2a51 */
        {8,	0}, 	/* 0x2a52 */
        {8,	0}, 	/* 0x2a53 */
        {8,	0}, 	/* 0x2a54 */
        {8,	0}, 	/* 0x2a55 */
        {8,	0}, 	/* 0x2a56 */
        {8,	0}, 	/* 0x2a57 */
        {8,	0}, 	/* 0x2a58 */
        {8,	0}, 	/* 0x2a59 */
        {8,	0}, 	/* 0x2a5a */
        {8,	0}, 	/* 0x2a5b */
        {8,	0}, 	/* 0x2a5c */
        {8,	0}, 	/* 0x2a5d */
        {8,	0}, 	/* 0x2a5e */
        {8,	0}, 	/* 0x2a5f */
        {8,	0}, 	/* 0x2a60 */
        {8,	0}, 	/* 0x2a61 */
        {8,	0}, 	/* 0x2a62 */
        {8,	0}, 	/* 0x2a63 */
        {8,	0}, 	/* 0x2a64 */
        {8,	0}, 	/* 0x2a65 */
        {8,	0}, 	/* 0x2a66 */
        {8,	0}, 	/* 0x2a67 */
        {8,	0}, 	/* 0x2a68 */
        {8,	0}, 	/* 0x2a69 */
        {8,	0}, 	/* 0x2a6a */
        {8,	0}, 	/* 0x2a6b */
        {8,	0}, 	/* 0x2a6c */
        {8,	0}, 	/* 0x2a6d */
        {8,	0}, 	/* 0x2a6e */
        {8,	0}, 	/* 0x2a6f */
        {8,	0}, 	/* 0x2a70 */
        {8,	0}, 	/* 0x2a71 */
        {8,	0}, 	/* 0x2a72 */
        {8,	0}, 	/* 0x2a73 */
        {8,	0}, 	/* 0x2a74 */
        {8,	0}, 	/* 0x2a75 */
        {8,	0}, 	/* 0x2a76 */
        {8,	0}, 	/* 0x2a77 */
        {8,	0}, 	/* 0x2a78 */
        {8,	0}, 	/* 0x2a79 */
        {8,	0}, 	/* 0x2a7a */
        {8,	0}, 	/* 0x2a7b */
        {8,	0}, 	/* 0x2a7c */
        {8,	0}, 	/* 0x2a7d */
        {8,	0}, 	/* 0x2a7e */
        {8,	0}, 	/* 0x2a7f */
        {8,	0}, 	/* 0x2a80 */
        {8,	0}, 	/* 0x2a81 */
        {8,	0}, 	/* 0x2a82 */
        {8,	0}, 	/* 0x2a83 */
        {8,	0}, 	/* 0x2a84 */
        {8,	0}, 	/* 0x2a85 */
        {8,	0}, 	/* 0x2a86 */
        {8,	0}, 	/* 0x2a87 */
        {8,	0}, 	/* 0x2a88 */
        {8,	0}, 	/* 0x2a89 */
        {8,	0}, 	/* 0x2a8a */
        {8,	0}, 	/* 0x2a8b */
        {8,	0}, 	/* 0x2a8c */
        {8,	0}, 	/* 0x2a8d */
        {8,	0}, 	/* 0x2a8e */
        {8,	0}, 	/* 0x2a8f */
        {8,	0}, 	/* 0x2a90 */
        {8,	0}, 	/* 0x2a91 */
        {8,	0}, 	/* 0x2a92 */
        {8,	0}, 	/* 0x2a93 */
        {8,	0}, 	/* 0x2a94 */
        {8,	0}, 	/* 0x2a95 */
        {8,	0}, 	/* 0x2a96 */
        {8,	0}, 	/* 0x2a97 */
        {8,	0}, 	/* 0x2a98 */
        {8,	0}, 	/* 0x2a99 */
        {8,	0}, 	/* 0x2a9a */
        {8,	0}, 	/* 0x2a9b */
        {8,	0}, 	/* 0x2a9c */
        {8,	0}, 	/* 0x2a9d */
        {8,	0}, 	/* 0x2a9e */
        {8,	0}, 	/* 0x2a9f */
        {8,	0}, 	/* 0x2aa0 */
        {8,	0}, 	/* 0x2aa1 */
        {8,	0}, 	/* 0x2aa2 */
        {8,	0}, 	/* 0x2aa3 */
        {8,	0}, 	/* 0x2aa4 */
        {8,	0}, 	/* 0x2aa5 */
        {8,	0}, 	/* 0x2aa6 */
        {8,	0}, 	/* 0x2aa7 */
        {8,	0}, 	/* 0x2aa8 */
        {8,	0}, 	/* 0x2aa9 */
        {8,	0}, 	/* 0x2aaa */
        {8,	0}, 	/* 0x2aab */
        {8,	0}, 	/* 0x2aac */
        {8,	0}, 	/* 0x2aad */
        {8,	0}, 	/* 0x2aae */
        {8,	0}, 	/* 0x2aaf */
        {8,	0}, 	/* 0x2ab0 */
        {8,	0}, 	/* 0x2ab1 */
        {8,	0}, 	/* 0x2ab2 */
        {8,	0}, 	/* 0x2ab3 */
        {8,	0}, 	/* 0x2ab4 */
        {8,	0}, 	/* 0x2ab5 */
        {8,	0}, 	/* 0x2ab6 */
        {8,	0}, 	/* 0x2ab7 */
        {8,	0}, 	/* 0x2ab8 */
        {8,	0}, 	/* 0x2ab9 */
        {8,	0}, 	/* 0x2aba */
        {8,	0}, 	/* 0x2abb */
        {8,	0}, 	/* 0x2abc */
        {8,	0}, 	/* 0x2abd */
        {8,	0}, 	/* 0x2abe */
        {8,	0}, 	/* 0x2abf */
        {8,	0}, 	/* 0x2ac0 */
        {8,	0}, 	/* 0x2ac1 */
        {8,	0}, 	/* 0x2ac2 */
        {8,	0}, 	/* 0x2ac3 */
        {8,	0}, 	/* 0x2ac4 */
        {8,	0}, 	/* 0x2ac5 */
        {8,	0}, 	/* 0x2ac6 */
        {8,	0}, 	/* 0x2ac7 */
        {8,	0}, 	/* 0x2ac8 */
        {8,	0}, 	/* 0x2ac9 */
        {8,	0}, 	/* 0x2aca */
        {8,	0}, 	/* 0x2acb */
        {8,	0}, 	/* 0x2acc */
        {8,	0}, 	/* 0x2acd */
        {8,	0}, 	/* 0x2ace */
        {8,	0}, 	/* 0x2acf */
        {8,	0}, 	/* 0x2ad0 */
        {8,	0}, 	/* 0x2ad1 */
        {8,	0}, 	/* 0x2ad2 */
        {8,	0}, 	/* 0x2ad3 */
        {8,	0}, 	/* 0x2ad4 */
        {8,	0}, 	/* 0x2ad5 */
        {8,	0}, 	/* 0x2ad6 */
        {8,	0}, 	/* 0x2ad7 */
        {8,	0}, 	/* 0x2ad8 */
        {8,	0}, 	/* 0x2ad9 */
        {8,	0}, 	/* 0x2ada */
        {8,	0}, 	/* 0x2adb */
        {8,	0}, 	/* 0x2adc */
        {8,	0}, 	/* 0x2add */
        {8,	0}, 	/* 0x2ade */
        {8,	0}, 	/* 0x2adf */
        {8,	0}, 	/* 0x2ae0 */
        {8,	0}, 	/* 0x2ae1 */
        {8,	0}, 	/* 0x2ae2 */
        {8,	0}, 	/* 0x2ae3 */
        {8,	0}, 	/* 0x2ae4 */
        {8,	0}, 	/* 0x2ae5 */
        {8,	0}, 	/* 0x2ae6 */
        {8,	0}, 	/* 0x2ae7 */
        {8,	0}, 	/* 0x2ae8 */
        {8,	0}, 	/* 0x2ae9 */
        {8,	0}, 	/* 0x2aea */
        {8,	0}, 	/* 0x2aeb */
        {8,	0}, 	/* 0x2aec */
        {8,	0}, 	/* 0x2aed */
        {8,	0}, 	/* 0x2aee */
        {8,	0}, 	/* 0x2aef */
        {8,	0}, 	/* 0x2af0 */
        {8,	0}, 	/* 0x2af1 */
        {8,	0}, 	/* 0x2af2 */
        {8,	0}, 	/* 0x2af3 */
        {8,	0}, 	/* 0x2af4 */
        {8,	0}, 	/* 0x2af5 */
        {8,	0}, 	/* 0x2af6 */
        {8,	0}, 	/* 0x2af7 */
        {8,	0}, 	/* 0x2af8 */
        {8,	0}, 	/* 0x2af9 */
        {8,	0}, 	/* 0x2afa */
        {8,	0}, 	/* 0x2afb */
        {8,	0}, 	/* 0x2afc */
        {8,	0}, 	/* 0x2afd */
        {8,	0}, 	/* 0x2afe */
        {8,	0}, 	/* 0x2aff */
        {8,	0}, 	/* 0x2b00 */
        {8,	0}, 	/* 0x2b01 */
        {8,	0}, 	/* 0x2b02 */
        {8,	0}, 	/* 0x2b03 */
        {8,	0}, 	/* 0x2b04 */
        {8,	0}, 	/* 0x2b05 */
        {8,	0}, 	/* 0x2b06 */
        {8,	0}, 	/* 0x2b07 */
        {8,	0}, 	/* 0x2b08 */
        {8,	0}, 	/* 0x2b09 */
        {8,	0}, 	/* 0x2b0a */
        {8,	0}, 	/* 0x2b0b */
        {8,	0}, 	/* 0x2b0c */
        {8,	0}, 	/* 0x2b0d */
        {8,	0}, 	/* 0x2b0e */
        {8,	0}, 	/* 0x2b0f */
        {8,	0}, 	/* 0x2b10 */
        {8,	0}, 	/* 0x2b11 */
        {8,	0}, 	/* 0x2b12 */
        {8,	0}, 	/* 0x2b13 */
        {8,	0}, 	/* 0x2b14 */
        {8,	0}, 	/* 0x2b15 */
        {8,	0}, 	/* 0x2b16 */
        {8,	0}, 	/* 0x2b17 */
        {8,	0}, 	/* 0x2b18 */
        {8,	0}, 	/* 0x2b19 */
        {8,	0}, 	/* 0x2b1a */
        {8,	0}, 	/* 0x2b1b */
        {8,	0}, 	/* 0x2b1c */
        {8,	0}, 	/* 0x2b1d */
        {8,	0}, 	/* 0x2b1e */
        {8,	0}, 	/* 0x2b1f */
        {8,	0}, 	/* 0x2b20 */
        {8,	0}, 	/* 0x2b21 */
        {8,	0}, 	/* 0x2b22 */
        {8,	0}, 	/* 0x2b23 */
        {8,	0}, 	/* 0x2b24 */
        {8,	0}, 	/* 0x2b25 */
        {8,	0}, 	/* 0x2b26 */
        {8,	0}, 	/* 0x2b27 */
        {8,	0}, 	/* 0x2b28 */
        {8,	0}, 	/* 0x2b29 */
        {8,	0}, 	/* 0x2b2a */
        {8,	0}, 	/* 0x2b2b */
        {8,	0}, 	/* 0x2b2c */
        {8,	0}, 	/* 0x2b2d */
        {8,	0}, 	/* 0x2b2e */
        {8,	0}, 	/* 0x2b2f */
        {8,	0}, 	/* 0x2b30 */
        {8,	0}, 	/* 0x2b31 */
        {8,	0}, 	/* 0x2b32 */
        {8,	0}, 	/* 0x2b33 */
        {8,	0}, 	/* 0x2b34 */
        {8,	0}, 	/* 0x2b35 */
        {8,	0}, 	/* 0x2b36 */
        {8,	0}, 	/* 0x2b37 */
        {8,	0}, 	/* 0x2b38 */
        {8,	0}, 	/* 0x2b39 */
        {8,	0}, 	/* 0x2b3a */
        {8,	0}, 	/* 0x2b3b */
        {8,	0}, 	/* 0x2b3c */
        {8,	0}, 	/* 0x2b3d */
        {8,	0}, 	/* 0x2b3e */
        {8,	0}, 	/* 0x2b3f */
        {8,	0}, 	/* 0x2b40 */
        {8,	0}, 	/* 0x2b41 */
        {8,	0}, 	/* 0x2b42 */
        {8,	0}, 	/* 0x2b43 */
        {8,	0}, 	/* 0x2b44 */
        {8,	0}, 	/* 0x2b45 */
        {8,	0}, 	/* 0x2b46 */
        {8,	0}, 	/* 0x2b47 */
        {8,	0}, 	/* 0x2b48 */
        {8,	0}, 	/* 0x2b49 */
        {8,	0}, 	/* 0x2b4a */
        {8,	0}, 	/* 0x2b4b */
        {8,	0}, 	/* 0x2b4c */
        {8,	0}, 	/* 0x2b4d */
        {8,	0}, 	/* 0x2b4e */
        {8,	0}, 	/* 0x2b4f */
        {8,	0}, 	/* 0x2b50 */
        {8,	0}, 	/* 0x2b51 */
        {8,	0}, 	/* 0x2b52 */
        {8,	0}, 	/* 0x2b53 */
        {8,	0}, 	/* 0x2b54 */
        {8,	0}, 	/* 0x2b55 */
        {8,	0}, 	/* 0x2b56 */
        {8,	0}, 	/* 0x2b57 */
        {8,	0}, 	/* 0x2b58 */
        {8,	0}, 	/* 0x2b59 */
        {8,	0}, 	/* 0x2b5a */
        {8,	0}, 	/* 0x2b5b */
        {8,	0}, 	/* 0x2b5c */
        {8,	0}, 	/* 0x2b5d */
        {8,	0}, 	/* 0x2b5e */
        {8,	0}, 	/* 0x2b5f */
        {8,	0}, 	/* 0x2b60 */
        {8,	0}, 	/* 0x2b61 */
        {8,	0}, 	/* 0x2b62 */
        {8,	0}, 	/* 0x2b63 */
        {8,	0}, 	/* 0x2b64 */
        {8,	0}, 	/* 0x2b65 */
        {8,	0}, 	/* 0x2b66 */
        {8,	0}, 	/* 0x2b67 */
        {8,	0}, 	/* 0x2b68 */
        {8,	0}, 	/* 0x2b69 */
        {8,	0}, 	/* 0x2b6a */
        {8,	0}, 	/* 0x2b6b */
        {8,	0}, 	/* 0x2b6c */
        {8,	0}, 	/* 0x2b6d */
        {8,	0}, 	/* 0x2b6e */
        {8,	0}, 	/* 0x2b6f */
        {8,	0}, 	/* 0x2b70 */
        {8,	0}, 	/* 0x2b71 */
        {8,	0}, 	/* 0x2b72 */
        {8,	0}, 	/* 0x2b73 */
        {8,	0}, 	/* 0x2b74 */
        {8,	0}, 	/* 0x2b75 */
        {8,	0}, 	/* 0x2b76 */
        {8,	0}, 	/* 0x2b77 */
        {8,	0}, 	/* 0x2b78 */
        {8,	0}, 	/* 0x2b79 */
        {8,	0}, 	/* 0x2b7a */
        {8,	0}, 	/* 0x2b7b */
        {8,	0}, 	/* 0x2b7c */
        {8,	0}, 	/* 0x2b7d */
        {8,	0}, 	/* 0x2b7e */
        {8,	0}, 	/* 0x2b7f */
        {8,	0}, 	/* 0x2b80 */
        {8,	0}, 	/* 0x2b81 */
        {8,	0}, 	/* 0x2b82 */
        {8,	0}, 	/* 0x2b83 */
        {8,	0}, 	/* 0x2b84 */
        {8,	0}, 	/* 0x2b85 */
        {8,	0}, 	/* 0x2b86 */
        {8,	0}, 	/* 0x2b87 */
        {8,	0}, 	/* 0x2b88 */
        {8,	0}, 	/* 0x2b89 */
        {8,	0}, 	/* 0x2b8a */
        {8,	0}, 	/* 0x2b8b */
        {8,	0}, 	/* 0x2b8c */
        {8,	0}, 	/* 0x2b8d */
        {8,	0}, 	/* 0x2b8e */
        {8,	0}, 	/* 0x2b8f */
        {8,	0}, 	/* 0x2b90 */
        {8,	0}, 	/* 0x2b91 */
        {8,	0}, 	/* 0x2b92 */
        {8,	0}, 	/* 0x2b93 */
        {8,	0}, 	/* 0x2b94 */
        {8,	0}, 	/* 0x2b95 */
        {8,	0}, 	/* 0x2b96 */
        {8,	0}, 	/* 0x2b97 */
        {8,	0}, 	/* 0x2b98 */
        {8,	0}, 	/* 0x2b99 */
        {8,	0}, 	/* 0x2b9a */
        {8,	0}, 	/* 0x2b9b */
        {8,	0}, 	/* 0x2b9c */
        {8,	0}, 	/* 0x2b9d */
        {8,	0}, 	/* 0x2b9e */
        {8,	0}, 	/* 0x2b9f */
        {8,	0}, 	/* 0x2ba0 */
        {8,	0}, 	/* 0x2ba1 */
        {8,	0}, 	/* 0x2ba2 */
        {8,	0}, 	/* 0x2ba3 */
        {8,	0}, 	/* 0x2ba4 */
        {8,	0}, 	/* 0x2ba5 */
        {8,	0}, 	/* 0x2ba6 */
        {8,	0}, 	/* 0x2ba7 */
        {8,	0}, 	/* 0x2ba8 */
        {8,	0}, 	/* 0x2ba9 */
        {8,	0}, 	/* 0x2baa */
        {8,	0}, 	/* 0x2bab */
        {8,	0}, 	/* 0x2bac */
        {8,	0}, 	/* 0x2bad */
        {8,	0}, 	/* 0x2bae */
        {8,	0}, 	/* 0x2baf */
        {8,	0}, 	/* 0x2bb0 */
        {8,	0}, 	/* 0x2bb1 */
        {8,	0}, 	/* 0x2bb2 */
        {8,	0}, 	/* 0x2bb3 */
        {8,	0}, 	/* 0x2bb4 */
        {8,	0}, 	/* 0x2bb5 */
        {8,	0}, 	/* 0x2bb6 */
        {8,	0}, 	/* 0x2bb7 */
        {8,	0}, 	/* 0x2bb8 */
        {8,	0}, 	/* 0x2bb9 */
        {8,	0}, 	/* 0x2bba */
        {8,	0}, 	/* 0x2bbb */
        {8,	0}, 	/* 0x2bbc */
        {8,	0}, 	/* 0x2bbd */
        {8,	0}, 	/* 0x2bbe */
        {8,	0}, 	/* 0x2bbf */
        {8,	0}, 	/* 0x2bc0 */
        {8,	0}, 	/* 0x2bc1 */
        {8,	0}, 	/* 0x2bc2 */
        {8,	0}, 	/* 0x2bc3 */
        {8,	0}, 	/* 0x2bc4 */
        {8,	0}, 	/* 0x2bc5 */
        {8,	0}, 	/* 0x2bc6 */
        {8,	0}, 	/* 0x2bc7 */
        {8,	0}, 	/* 0x2bc8 */
        {8,	0}, 	/* 0x2bc9 */
        {8,	0}, 	/* 0x2bca */
        {8,	0}, 	/* 0x2bcb */
        {8,	0}, 	/* 0x2bcc */
        {8,	0}, 	/* 0x2bcd */
        {8,	0}, 	/* 0x2bce */
        {8,	0}, 	/* 0x2bcf */
        {8,	0}, 	/* 0x2bd0 */
        {8,	0}, 	/* 0x2bd1 */
        {8,	0}, 	/* 0x2bd2 */
        {8,	0}, 	/* 0x2bd3 */
        {8,	0}, 	/* 0x2bd4 */
        {8,	0}, 	/* 0x2bd5 */
        {8,	0}, 	/* 0x2bd6 */
        {8,	0}, 	/* 0x2bd7 */
        {8,	0}, 	/* 0x2bd8 */
        {8,	0}, 	/* 0x2bd9 */
        {8,	0}, 	/* 0x2bda */
        {8,	0}, 	/* 0x2bdb */
        {8,	0}, 	/* 0x2bdc */
        {8,	0}, 	/* 0x2bdd */
        {8,	0}, 	/* 0x2bde */
        {8,	0}, 	/* 0x2bdf */
        {8,	0}, 	/* 0x2be0 */
        {8,	0}, 	/* 0x2be1 */
        {8,	0}, 	/* 0x2be2 */
        {8,	0}, 	/* 0x2be3 */
        {8,	0}, 	/* 0x2be4 */
        {8,	0}, 	/* 0x2be5 */
        {8,	0}, 	/* 0x2be6 */
        {8,	0}, 	/* 0x2be7 */
        {8,	0}, 	/* 0x2be8 */
        {8,	0}, 	/* 0x2be9 */
        {8,	0}, 	/* 0x2bea */
        {8,	0}, 	/* 0x2beb */
        {8,	0}, 	/* 0x2bec */
        {8,	0}, 	/* 0x2bed */
        {8,	0}, 	/* 0x2bee */
        {8,	0}, 	/* 0x2bef */
        {8,	0}, 	/* 0x2bf0 */
        {8,	0}, 	/* 0x2bf1 */
        {8,	0}, 	/* 0x2bf2 */
        {8,	0}, 	/* 0x2bf3 */
        {8,	0}, 	/* 0x2bf4 */
        {8,	0}, 	/* 0x2bf5 */
        {8,	0}, 	/* 0x2bf6 */
        {8,	0}, 	/* 0x2bf7 */
        {8,	0}, 	/* 0x2bf8 */
        {8,	0}, 	/* 0x2bf9 */
        {8,	0}, 	/* 0x2bfa */
        {8,	0}, 	/* 0x2bfb */
        {8,	0}, 	/* 0x2bfc */
        {8,	0}, 	/* 0x2bfd */
        {8,	0}, 	/* 0x2bfe */
        {8,	0}, 	/* 0x2bff */
        {8,	0}, 	/* 0x2c00 */
        {8,	0}, 	/* 0x2c01 */
        {8,	0}, 	/* 0x2c02 */
        {8,	0}, 	/* 0x2c03 */
        {8,	0}, 	/* 0x2c04 */
        {8,	0}, 	/* 0x2c05 */
        {8,	0}, 	/* 0x2c06 */
        {8,	0}, 	/* 0x2c07 */
        {8,	0}, 	/* 0x2c08 */
        {8,	0}, 	/* 0x2c09 */
        {8,	0}, 	/* 0x2c0a */
        {8,	0}, 	/* 0x2c0b */
        {8,	0}, 	/* 0x2c0c */
        {8,	0}, 	/* 0x2c0d */
        {8,	0}, 	/* 0x2c0e */
        {8,	0}, 	/* 0x2c0f */
        {8,	0}, 	/* 0x2c10 */
        {8,	0}, 	/* 0x2c11 */
        {8,	0}, 	/* 0x2c12 */
        {8,	0}, 	/* 0x2c13 */
        {8,	0}, 	/* 0x2c14 */
        {8,	0}, 	/* 0x2c15 */
        {8,	0}, 	/* 0x2c16 */
        {8,	0}, 	/* 0x2c17 */
        {8,	0}, 	/* 0x2c18 */
        {8,	0}, 	/* 0x2c19 */
        {8,	0}, 	/* 0x2c1a */
        {8,	0}, 	/* 0x2c1b */
        {8,	0}, 	/* 0x2c1c */
        {8,	0}, 	/* 0x2c1d */
        {8,	0}, 	/* 0x2c1e */
        {8,	0}, 	/* 0x2c1f */
        {8,	0}, 	/* 0x2c20 */
        {8,	0}, 	/* 0x2c21 */
        {8,	0}, 	/* 0x2c22 */
        {8,	0}, 	/* 0x2c23 */
        {8,	0}, 	/* 0x2c24 */
        {8,	0}, 	/* 0x2c25 */
        {8,	0}, 	/* 0x2c26 */
        {8,	0}, 	/* 0x2c27 */
        {8,	0}, 	/* 0x2c28 */
        {8,	0}, 	/* 0x2c29 */
        {8,	0}, 	/* 0x2c2a */
        {8,	0}, 	/* 0x2c2b */
        {8,	0}, 	/* 0x2c2c */
        {8,	0}, 	/* 0x2c2d */
        {8,	0}, 	/* 0x2c2e */
        {8,	0}, 	/* 0x2c2f */
        {8,	0}, 	/* 0x2c30 */
        {8,	0}, 	/* 0x2c31 */
        {8,	0}, 	/* 0x2c32 */
        {8,	0}, 	/* 0x2c33 */
        {8,	0}, 	/* 0x2c34 */
        {8,	0}, 	/* 0x2c35 */
        {8,	0}, 	/* 0x2c36 */
        {8,	0}, 	/* 0x2c37 */
        {8,	0}, 	/* 0x2c38 */
        {8,	0}, 	/* 0x2c39 */
        {8,	0}, 	/* 0x2c3a */
        {8,	0}, 	/* 0x2c3b */
        {8,	0}, 	/* 0x2c3c */
        {8,	0}, 	/* 0x2c3d */
        {8,	0}, 	/* 0x2c3e */
        {8,	0}, 	/* 0x2c3f */
        {8,	0}, 	/* 0x2c40 */
        {8,	0}, 	/* 0x2c41 */
        {8,	0}, 	/* 0x2c42 */
        {8,	0}, 	/* 0x2c43 */
        {8,	0}, 	/* 0x2c44 */
        {8,	0}, 	/* 0x2c45 */
        {8,	0}, 	/* 0x2c46 */
        {8,	0}, 	/* 0x2c47 */
        {8,	0}, 	/* 0x2c48 */
        {8,	0}, 	/* 0x2c49 */
        {8,	0}, 	/* 0x2c4a */
        {8,	0}, 	/* 0x2c4b */
        {8,	0}, 	/* 0x2c4c */
        {8,	0}, 	/* 0x2c4d */
        {8,	0}, 	/* 0x2c4e */
        {8,	0}, 	/* 0x2c4f */
        {8,	0}, 	/* 0x2c50 */
        {8,	0}, 	/* 0x2c51 */
        {8,	0}, 	/* 0x2c52 */
        {8,	0}, 	/* 0x2c53 */
        {8,	0}, 	/* 0x2c54 */
        {8,	0}, 	/* 0x2c55 */
        {8,	0}, 	/* 0x2c56 */
        {8,	0}, 	/* 0x2c57 */
        {8,	0}, 	/* 0x2c58 */
        {8,	0}, 	/* 0x2c59 */
        {8,	0}, 	/* 0x2c5a */
        {8,	0}, 	/* 0x2c5b */
        {8,	0}, 	/* 0x2c5c */
        {8,	0}, 	/* 0x2c5d */
        {8,	0}, 	/* 0x2c5e */
        {8,	0}, 	/* 0x2c5f */
        {8,	0}, 	/* 0x2c60 */
        {8,	0}, 	/* 0x2c61 */
        {8,	0}, 	/* 0x2c62 */
        {8,	0}, 	/* 0x2c63 */
        {8,	0}, 	/* 0x2c64 */
        {8,	0}, 	/* 0x2c65 */
        {8,	0}, 	/* 0x2c66 */
        {8,	0}, 	/* 0x2c67 */
        {8,	0}, 	/* 0x2c68 */
        {8,	0}, 	/* 0x2c69 */
        {8,	0}, 	/* 0x2c6a */
        {8,	0}, 	/* 0x2c6b */
        {8,	0}, 	/* 0x2c6c */
        {8,	0}, 	/* 0x2c6d */
        {8,	0}, 	/* 0x2c6e */
        {8,	0}, 	/* 0x2c6f */
        {8,	0}, 	/* 0x2c70 */
        {8,	0}, 	/* 0x2c71 */
        {8,	0}, 	/* 0x2c72 */
        {8,	0}, 	/* 0x2c73 */
        {8,	0}, 	/* 0x2c74 */
        {8,	0}, 	/* 0x2c75 */
        {8,	0}, 	/* 0x2c76 */
        {8,	0}, 	/* 0x2c77 */
        {8,	0}, 	/* 0x2c78 */
        {8,	0}, 	/* 0x2c79 */
        {8,	0}, 	/* 0x2c7a */
        {8,	0}, 	/* 0x2c7b */
        {8,	0}, 	/* 0x2c7c */
        {8,	0}, 	/* 0x2c7d */
        {8,	0}, 	/* 0x2c7e */
        {8,	0}, 	/* 0x2c7f */
        {8,	0}, 	/* 0x2c80 */
        {8,	0}, 	/* 0x2c81 */
        {8,	0}, 	/* 0x2c82 */
        {8,	0}, 	/* 0x2c83 */
        {8,	0}, 	/* 0x2c84 */
        {8,	0}, 	/* 0x2c85 */
        {8,	0}, 	/* 0x2c86 */
        {8,	0}, 	/* 0x2c87 */
        {8,	0}, 	/* 0x2c88 */
        {8,	0}, 	/* 0x2c89 */
        {8,	0}, 	/* 0x2c8a */
        {8,	0}, 	/* 0x2c8b */
        {8,	0}, 	/* 0x2c8c */
        {8,	0}, 	/* 0x2c8d */
        {8,	0}, 	/* 0x2c8e */
        {8,	0}, 	/* 0x2c8f */
        {8,	0}, 	/* 0x2c90 */
        {8,	0}, 	/* 0x2c91 */
        {8,	0}, 	/* 0x2c92 */
        {8,	0}, 	/* 0x2c93 */
        {8,	0}, 	/* 0x2c94 */
        {8,	0}, 	/* 0x2c95 */
        {8,	0}, 	/* 0x2c96 */
        {8,	0}, 	/* 0x2c97 */
        {8,	0}, 	/* 0x2c98 */
        {8,	0}, 	/* 0x2c99 */
        {8,	0}, 	/* 0x2c9a */
        {8,	0}, 	/* 0x2c9b */
        {8,	0}, 	/* 0x2c9c */
        {8,	0}, 	/* 0x2c9d */
        {8,	0}, 	/* 0x2c9e */
        {8,	0}, 	/* 0x2c9f */
        {8,	0}, 	/* 0x2ca0 */
        {8,	0}, 	/* 0x2ca1 */
        {8,	0}, 	/* 0x2ca2 */
        {8,	0}, 	/* 0x2ca3 */
        {8,	0}, 	/* 0x2ca4 */
        {8,	0}, 	/* 0x2ca5 */
        {8,	0}, 	/* 0x2ca6 */
        {8,	0}, 	/* 0x2ca7 */
        {8,	0}, 	/* 0x2ca8 */
        {8,	0}, 	/* 0x2ca9 */
        {8,	0}, 	/* 0x2caa */
        {8,	0}, 	/* 0x2cab */
        {8,	0}, 	/* 0x2cac */
        {8,	0}, 	/* 0x2cad */
        {8,	0}, 	/* 0x2cae */
        {8,	0}, 	/* 0x2caf */
        {8,	0}, 	/* 0x2cb0 */
        {8,	0}, 	/* 0x2cb1 */
        {8,	0}, 	/* 0x2cb2 */
        {8,	0}, 	/* 0x2cb3 */
        {8,	0}, 	/* 0x2cb4 */
        {8,	0}, 	/* 0x2cb5 */
        {8,	0}, 	/* 0x2cb6 */
        {8,	0}, 	/* 0x2cb7 */
        {8,	0}, 	/* 0x2cb8 */
        {8,	0}, 	/* 0x2cb9 */
        {8,	0}, 	/* 0x2cba */
        {8,	0}, 	/* 0x2cbb */
        {8,	0}, 	/* 0x2cbc */
        {8,	0}, 	/* 0x2cbd */
        {8,	0}, 	/* 0x2cbe */
        {8,	0}, 	/* 0x2cbf */
        {8,	0}, 	/* 0x2cc0 */
        {8,	0}, 	/* 0x2cc1 */
        {8,	0}, 	/* 0x2cc2 */
        {8,	0}, 	/* 0x2cc3 */
        {8,	0}, 	/* 0x2cc4 */
        {8,	0}, 	/* 0x2cc5 */
        {8,	0}, 	/* 0x2cc6 */
        {8,	0}, 	/* 0x2cc7 */
        {8,	0}, 	/* 0x2cc8 */
        {8,	0}, 	/* 0x2cc9 */
        {8,	0}, 	/* 0x2cca */
        {8,	0}, 	/* 0x2ccb */
        {8,	0}, 	/* 0x2ccc */
        {8,	0}, 	/* 0x2ccd */
        {8,	0}, 	/* 0x2cce */
        {8,	0}, 	/* 0x2ccf */
        {8,	0}, 	/* 0x2cd0 */
        {8,	0}, 	/* 0x2cd1 */
        {8,	0}, 	/* 0x2cd2 */
        {8,	0}, 	/* 0x2cd3 */
        {8,	0}, 	/* 0x2cd4 */
        {8,	0}, 	/* 0x2cd5 */
        {8,	0}, 	/* 0x2cd6 */
        {8,	0}, 	/* 0x2cd7 */
        {8,	0}, 	/* 0x2cd8 */
        {8,	0}, 	/* 0x2cd9 */
        {8,	0}, 	/* 0x2cda */
        {8,	0}, 	/* 0x2cdb */
        {8,	0}, 	/* 0x2cdc */
        {8,	0}, 	/* 0x2cdd */
        {8,	0}, 	/* 0x2cde */
        {8,	0}, 	/* 0x2cdf */
        {8,	0}, 	/* 0x2ce0 */
        {8,	0}, 	/* 0x2ce1 */
        {8,	0}, 	/* 0x2ce2 */
        {8,	0}, 	/* 0x2ce3 */
        {8,	0}, 	/* 0x2ce4 */
        {8,	0}, 	/* 0x2ce5 */
        {8,	0}, 	/* 0x2ce6 */
        {8,	0}, 	/* 0x2ce7 */
        {8,	0}, 	/* 0x2ce8 */
        {8,	0}, 	/* 0x2ce9 */
        {8,	0}, 	/* 0x2cea */
        {8,	0}, 	/* 0x2ceb */
        {8,	0}, 	/* 0x2cec */
        {8,	0}, 	/* 0x2ced */
        {8,	0}, 	/* 0x2cee */
        {8,	0}, 	/* 0x2cef */
        {8,	0}, 	/* 0x2cf0 */
        {8,	0}, 	/* 0x2cf1 */
        {8,	0}, 	/* 0x2cf2 */
        {8,	0}, 	/* 0x2cf3 */
        {8,	0}, 	/* 0x2cf4 */
        {8,	0}, 	/* 0x2cf5 */
        {8,	0}, 	/* 0x2cf6 */
        {8,	0}, 	/* 0x2cf7 */
        {8,	0}, 	/* 0x2cf8 */
        {8,	0}, 	/* 0x2cf9 */
        {8,	0}, 	/* 0x2cfa */
        {8,	0}, 	/* 0x2cfb */
        {8,	0}, 	/* 0x2cfc */
        {8,	0}, 	/* 0x2cfd */
        {8,	0}, 	/* 0x2cfe */
        {8,	0}, 	/* 0x2cff */
        {8,	0}, 	/* 0x2d00 */
        {8,	0}, 	/* 0x2d01 */
        {8,	0}, 	/* 0x2d02 */
        {8,	0}, 	/* 0x2d03 */
        {8,	0}, 	/* 0x2d04 */
        {8,	0}, 	/* 0x2d05 */
        {8,	0}, 	/* 0x2d06 */
        {8,	0}, 	/* 0x2d07 */
        {8,	0}, 	/* 0x2d08 */
        {8,	0}, 	/* 0x2d09 */
        {8,	0}, 	/* 0x2d0a */
        {8,	0}, 	/* 0x2d0b */
        {8,	0}, 	/* 0x2d0c */
        {8,	0}, 	/* 0x2d0d */
        {8,	0}, 	/* 0x2d0e */
        {8,	0}, 	/* 0x2d0f */
        {8,	0}, 	/* 0x2d10 */
        {8,	0}, 	/* 0x2d11 */
        {8,	0}, 	/* 0x2d12 */
        {8,	0}, 	/* 0x2d13 */
        {8,	0}, 	/* 0x2d14 */
        {8,	0}, 	/* 0x2d15 */
        {8,	0}, 	/* 0x2d16 */
        {8,	0}, 	/* 0x2d17 */
        {8,	0}, 	/* 0x2d18 */
        {8,	0}, 	/* 0x2d19 */
        {8,	0}, 	/* 0x2d1a */
        {8,	0}, 	/* 0x2d1b */
        {8,	0}, 	/* 0x2d1c */
        {8,	0}, 	/* 0x2d1d */
        {8,	0}, 	/* 0x2d1e */
        {8,	0}, 	/* 0x2d1f */
        {8,	0}, 	/* 0x2d20 */
        {8,	0}, 	/* 0x2d21 */
        {8,	0}, 	/* 0x2d22 */
        {8,	0}, 	/* 0x2d23 */
        {8,	0}, 	/* 0x2d24 */
        {8,	0}, 	/* 0x2d25 */
        {8,	0}, 	/* 0x2d26 */
        {8,	0}, 	/* 0x2d27 */
        {8,	0}, 	/* 0x2d28 */
        {8,	0}, 	/* 0x2d29 */
        {8,	0}, 	/* 0x2d2a */
        {8,	0}, 	/* 0x2d2b */
        {8,	0}, 	/* 0x2d2c */
        {8,	0}, 	/* 0x2d2d */
        {8,	0}, 	/* 0x2d2e */
        {8,	0}, 	/* 0x2d2f */
        {8,	0}, 	/* 0x2d30 */
        {8,	0}, 	/* 0x2d31 */
        {8,	0}, 	/* 0x2d32 */
        {8,	0}, 	/* 0x2d33 */
        {8,	0}, 	/* 0x2d34 */
        {8,	0}, 	/* 0x2d35 */
        {8,	0}, 	/* 0x2d36 */
        {8,	0}, 	/* 0x2d37 */
        {8,	0}, 	/* 0x2d38 */
        {8,	0}, 	/* 0x2d39 */
        {8,	0}, 	/* 0x2d3a */
        {8,	0}, 	/* 0x2d3b */
        {8,	0}, 	/* 0x2d3c */
        {8,	0}, 	/* 0x2d3d */
        {8,	0}, 	/* 0x2d3e */
        {8,	0}, 	/* 0x2d3f */
        {8,	0}, 	/* 0x2d40 */
        {8,	0}, 	/* 0x2d41 */
        {8,	0}, 	/* 0x2d42 */
        {8,	0}, 	/* 0x2d43 */
        {8,	0}, 	/* 0x2d44 */
        {8,	0}, 	/* 0x2d45 */
        {8,	0}, 	/* 0x2d46 */
        {8,	0}, 	/* 0x2d47 */
        {8,	0}, 	/* 0x2d48 */
        {8,	0}, 	/* 0x2d49 */
        {8,	0}, 	/* 0x2d4a */
        {8,	0}, 	/* 0x2d4b */
        {8,	0}, 	/* 0x2d4c */
        {8,	0}, 	/* 0x2d4d */
        {8,	0}, 	/* 0x2d4e */
        {8,	0}, 	/* 0x2d4f */
        {8,	0}, 	/* 0x2d50 */
        {8,	0}, 	/* 0x2d51 */
        {8,	0}, 	/* 0x2d52 */
        {8,	0}, 	/* 0x2d53 */
        {8,	0}, 	/* 0x2d54 */
        {8,	0}, 	/* 0x2d55 */
        {8,	0}, 	/* 0x2d56 */
        {8,	0}, 	/* 0x2d57 */
        {8,	0}, 	/* 0x2d58 */
        {8,	0}, 	/* 0x2d59 */
        {8,	0}, 	/* 0x2d5a */
        {8,	0}, 	/* 0x2d5b */
        {8,	0}, 	/* 0x2d5c */
        {8,	0}, 	/* 0x2d5d */
        {8,	0}, 	/* 0x2d5e */
        {8,	0}, 	/* 0x2d5f */
        {8,	0}, 	/* 0x2d60 */
        {8,	0}, 	/* 0x2d61 */
        {8,	0}, 	/* 0x2d62 */
        {8,	0}, 	/* 0x2d63 */
        {8,	0}, 	/* 0x2d64 */
        {8,	0}, 	/* 0x2d65 */
        {8,	0}, 	/* 0x2d66 */
        {8,	0}, 	/* 0x2d67 */
        {8,	0}, 	/* 0x2d68 */
        {8,	0}, 	/* 0x2d69 */
        {8,	0}, 	/* 0x2d6a */
        {8,	0}, 	/* 0x2d6b */
        {8,	0}, 	/* 0x2d6c */
        {8,	0}, 	/* 0x2d6d */
        {8,	0}, 	/* 0x2d6e */
        {8,	0}, 	/* 0x2d6f */
        {8,	0}, 	/* 0x2d70 */
        {8,	0}, 	/* 0x2d71 */
        {8,	0}, 	/* 0x2d72 */
        {8,	0}, 	/* 0x2d73 */
        {8,	0}, 	/* 0x2d74 */
        {8,	0}, 	/* 0x2d75 */
        {8,	0}, 	/* 0x2d76 */
        {8,	0}, 	/* 0x2d77 */
        {8,	0}, 	/* 0x2d78 */
        {8,	0}, 	/* 0x2d79 */
        {8,	0}, 	/* 0x2d7a */
        {8,	0}, 	/* 0x2d7b */
        {8,	0}, 	/* 0x2d7c */
        {8,	0}, 	/* 0x2d7d */
        {8,	0}, 	/* 0x2d7e */
        {8,	0}, 	/* 0x2d7f */
        {8,	0}, 	/* 0x2d80 */
        {8,	0}, 	/* 0x2d81 */
        {8,	0}, 	/* 0x2d82 */
        {8,	0}, 	/* 0x2d83 */
        {8,	0}, 	/* 0x2d84 */
        {8,	0}, 	/* 0x2d85 */
        {8,	0}, 	/* 0x2d86 */
        {8,	0}, 	/* 0x2d87 */
        {8,	0}, 	/* 0x2d88 */
        {8,	0}, 	/* 0x2d89 */
        {8,	0}, 	/* 0x2d8a */
        {8,	0}, 	/* 0x2d8b */
        {8,	0}, 	/* 0x2d8c */
        {8,	0}, 	/* 0x2d8d */
        {8,	0}, 	/* 0x2d8e */
        {8,	0}, 	/* 0x2d8f */
        {8,	0}, 	/* 0x2d90 */
        {8,	0}, 	/* 0x2d91 */
        {8,	0}, 	/* 0x2d92 */
        {8,	0}, 	/* 0x2d93 */
        {8,	0}, 	/* 0x2d94 */
        {8,	0}, 	/* 0x2d95 */
        {8,	0}, 	/* 0x2d96 */
        {8,	0}, 	/* 0x2d97 */
        {8,	0}, 	/* 0x2d98 */
        {8,	0}, 	/* 0x2d99 */
        {8,	0}, 	/* 0x2d9a */
        {8,	0}, 	/* 0x2d9b */
        {8,	0}, 	/* 0x2d9c */
        {8,	0}, 	/* 0x2d9d */
        {8,	0}, 	/* 0x2d9e */
        {8,	0}, 	/* 0x2d9f */
        {8,	0}, 	/* 0x2da0 */
        {8,	0}, 	/* 0x2da1 */
        {8,	0}, 	/* 0x2da2 */
        {8,	0}, 	/* 0x2da3 */
        {8,	0}, 	/* 0x2da4 */
        {8,	0}, 	/* 0x2da5 */
        {8,	0}, 	/* 0x2da6 */
        {8,	0}, 	/* 0x2da7 */
        {8,	0}, 	/* 0x2da8 */
        {8,	0}, 	/* 0x2da9 */
        {8,	0}, 	/* 0x2daa */
        {8,	0}, 	/* 0x2dab */
        {8,	0}, 	/* 0x2dac */
        {8,	0}, 	/* 0x2dad */
        {8,	0}, 	/* 0x2dae */
        {8,	0}, 	/* 0x2daf */
        {8,	0}, 	/* 0x2db0 */
        {8,	0}, 	/* 0x2db1 */
        {8,	0}, 	/* 0x2db2 */
        {8,	0}, 	/* 0x2db3 */
        {8,	0}, 	/* 0x2db4 */
        {8,	0}, 	/* 0x2db5 */
        {8,	0}, 	/* 0x2db6 */
        {8,	0}, 	/* 0x2db7 */
        {8,	0}, 	/* 0x2db8 */
        {8,	0}, 	/* 0x2db9 */
        {8,	0}, 	/* 0x2dba */
        {8,	0}, 	/* 0x2dbb */
        {8,	0}, 	/* 0x2dbc */
        {8,	0}, 	/* 0x2dbd */
        {8,	0}, 	/* 0x2dbe */
        {8,	0}, 	/* 0x2dbf */
        {8,	0}, 	/* 0x2dc0 */
        {8,	0}, 	/* 0x2dc1 */
        {8,	0}, 	/* 0x2dc2 */
        {8,	0}, 	/* 0x2dc3 */
        {8,	0}, 	/* 0x2dc4 */
        {8,	0}, 	/* 0x2dc5 */
        {8,	0}, 	/* 0x2dc6 */
        {8,	0}, 	/* 0x2dc7 */
        {8,	0}, 	/* 0x2dc8 */
        {8,	0}, 	/* 0x2dc9 */
        {8,	0}, 	/* 0x2dca */
        {8,	0}, 	/* 0x2dcb */
        {8,	0}, 	/* 0x2dcc */
        {8,	0}, 	/* 0x2dcd */
        {8,	0}, 	/* 0x2dce */
        {8,	0}, 	/* 0x2dcf */
        {8,	0}, 	/* 0x2dd0 */
        {8,	0}, 	/* 0x2dd1 */
        {8,	0}, 	/* 0x2dd2 */
        {8,	0}, 	/* 0x2dd3 */
        {8,	0}, 	/* 0x2dd4 */
        {8,	0}, 	/* 0x2dd5 */
        {8,	0}, 	/* 0x2dd6 */
        {8,	0}, 	/* 0x2dd7 */
        {8,	0}, 	/* 0x2dd8 */
        {8,	0}, 	/* 0x2dd9 */
        {8,	0}, 	/* 0x2dda */
        {8,	0}, 	/* 0x2ddb */
        {8,	0}, 	/* 0x2ddc */
        {8,	0}, 	/* 0x2ddd */
        {8,	0}, 	/* 0x2dde */
        {8,	0}, 	/* 0x2ddf */
        {8,	0}, 	/* 0x2de0 */
        {8,	0}, 	/* 0x2de1 */
        {8,	0}, 	/* 0x2de2 */
        {8,	0}, 	/* 0x2de3 */
        {8,	0}, 	/* 0x2de4 */
        {8,	0}, 	/* 0x2de5 */
        {8,	0}, 	/* 0x2de6 */
        {8,	0}, 	/* 0x2de7 */
        {8,	0}, 	/* 0x2de8 */
        {8,	0}, 	/* 0x2de9 */
        {8,	0}, 	/* 0x2dea */
        {8,	0}, 	/* 0x2deb */
        {8,	0}, 	/* 0x2dec */
        {8,	0}, 	/* 0x2ded */
        {8,	0}, 	/* 0x2dee */
        {8,	0}, 	/* 0x2def */
        {8,	0}, 	/* 0x2df0 */
        {8,	0}, 	/* 0x2df1 */
        {8,	0}, 	/* 0x2df2 */
        {8,	0}, 	/* 0x2df3 */
        {8,	0}, 	/* 0x2df4 */
        {8,	0}, 	/* 0x2df5 */
        {8,	0}, 	/* 0x2df6 */
        {8,	0}, 	/* 0x2df7 */
        {8,	0}, 	/* 0x2df8 */
        {8,	0}, 	/* 0x2df9 */
        {8,	0}, 	/* 0x2dfa */
        {8,	0}, 	/* 0x2dfb */
        {8,	0}, 	/* 0x2dfc */
        {8,	0}, 	/* 0x2dfd */
        {8,	0}, 	/* 0x2dfe */
        {8,	0}, 	/* 0x2dff */
        {8,	0}, 	/* 0x2e00 */
        {8,	0}, 	/* 0x2e01 */
        {8,	0}, 	/* 0x2e02 */
        {8,	0}, 	/* 0x2e03 */
        {8,	0}, 	/* 0x2e04 */
        {8,	0}, 	/* 0x2e05 */
        {8,	0}, 	/* 0x2e06 */
        {8,	0}, 	/* 0x2e07 */
        {8,	0}, 	/* 0x2e08 */
        {8,	0}, 	/* 0x2e09 */
        {8,	0}, 	/* 0x2e0a */
        {8,	0}, 	/* 0x2e0b */
        {8,	0}, 	/* 0x2e0c */
        {8,	0}, 	/* 0x2e0d */
        {8,	0}, 	/* 0x2e0e */
        {8,	0}, 	/* 0x2e0f */
        {8,	0}, 	/* 0x2e10 */
        {8,	0}, 	/* 0x2e11 */
        {8,	0}, 	/* 0x2e12 */
        {8,	0}, 	/* 0x2e13 */
        {8,	0}, 	/* 0x2e14 */
        {8,	0}, 	/* 0x2e15 */
        {8,	0}, 	/* 0x2e16 */
        {8,	0}, 	/* 0x2e17 */
        {8,	0}, 	/* 0x2e18 */
        {8,	0}, 	/* 0x2e19 */
        {8,	0}, 	/* 0x2e1a */
        {8,	0}, 	/* 0x2e1b */
        {8,	0}, 	/* 0x2e1c */
        {8,	0}, 	/* 0x2e1d */
        {8,	0}, 	/* 0x2e1e */
        {8,	0}, 	/* 0x2e1f */
        {8,	0}, 	/* 0x2e20 */
        {8,	0}, 	/* 0x2e21 */
        {8,	0}, 	/* 0x2e22 */
        {8,	0}, 	/* 0x2e23 */
        {8,	0}, 	/* 0x2e24 */
        {8,	0}, 	/* 0x2e25 */
        {8,	0}, 	/* 0x2e26 */
        {8,	0}, 	/* 0x2e27 */
        {8,	0}, 	/* 0x2e28 */
        {8,	0}, 	/* 0x2e29 */
        {8,	0}, 	/* 0x2e2a */
        {8,	0}, 	/* 0x2e2b */
        {8,	0}, 	/* 0x2e2c */
        {8,	0}, 	/* 0x2e2d */
        {8,	0}, 	/* 0x2e2e */
        {8,	0}, 	/* 0x2e2f */
        {8,	0}, 	/* 0x2e30 */
        {8,	0}, 	/* 0x2e31 */
        {8,	0}, 	/* 0x2e32 */
        {8,	0}, 	/* 0x2e33 */
        {8,	0}, 	/* 0x2e34 */
        {8,	0}, 	/* 0x2e35 */
        {8,	0}, 	/* 0x2e36 */
        {8,	0}, 	/* 0x2e37 */
        {8,	0}, 	/* 0x2e38 */
        {8,	0}, 	/* 0x2e39 */
        {8,	0}, 	/* 0x2e3a */
        {8,	0}, 	/* 0x2e3b */
        {8,	0}, 	/* 0x2e3c */
        {8,	0}, 	/* 0x2e3d */
        {8,	0}, 	/* 0x2e3e */
        {8,	0}, 	/* 0x2e3f */
        {8,	0}, 	/* 0x2e40 */
        {8,	0}, 	/* 0x2e41 */
        {8,	0}, 	/* 0x2e42 */
        {8,	0}, 	/* 0x2e43 */
        {8,	0}, 	/* 0x2e44 */
        {8,	0}, 	/* 0x2e45 */
        {8,	0}, 	/* 0x2e46 */
        {8,	0}, 	/* 0x2e47 */
        {8,	0}, 	/* 0x2e48 */
        {8,	0}, 	/* 0x2e49 */
        {8,	0}, 	/* 0x2e4a */
        {8,	0}, 	/* 0x2e4b */
        {8,	0}, 	/* 0x2e4c */
        {8,	0}, 	/* 0x2e4d */
        {8,	0}, 	/* 0x2e4e */
        {8,	0}, 	/* 0x2e4f */
        {8,	0}, 	/* 0x2e50 */
        {8,	0}, 	/* 0x2e51 */
        {8,	0}, 	/* 0x2e52 */
        {8,	0}, 	/* 0x2e53 */
        {8,	0}, 	/* 0x2e54 */
        {8,	0}, 	/* 0x2e55 */
        {8,	0}, 	/* 0x2e56 */
        {8,	0}, 	/* 0x2e57 */
        {8,	0}, 	/* 0x2e58 */
        {8,	0}, 	/* 0x2e59 */
        {8,	0}, 	/* 0x2e5a */
        {8,	0}, 	/* 0x2e5b */
        {8,	0}, 	/* 0x2e5c */
        {8,	0}, 	/* 0x2e5d */
        {8,	0}, 	/* 0x2e5e */
        {8,	0}, 	/* 0x2e5f */
        {8,	0}, 	/* 0x2e60 */
        {8,	0}, 	/* 0x2e61 */
        {8,	0}, 	/* 0x2e62 */
        {8,	0}, 	/* 0x2e63 */
        {8,	0}, 	/* 0x2e64 */
        {8,	0}, 	/* 0x2e65 */
        {8,	0}, 	/* 0x2e66 */
        {8,	0}, 	/* 0x2e67 */
        {8,	0}, 	/* 0x2e68 */
        {8,	0}, 	/* 0x2e69 */
        {8,	0}, 	/* 0x2e6a */
        {8,	0}, 	/* 0x2e6b */
        {8,	0}, 	/* 0x2e6c */
        {8,	0}, 	/* 0x2e6d */
        {8,	0}, 	/* 0x2e6e */
        {8,	0}, 	/* 0x2e6f */
        {8,	0}, 	/* 0x2e70 */
        {8,	0}, 	/* 0x2e71 */
        {8,	0}, 	/* 0x2e72 */
        {8,	0}, 	/* 0x2e73 */
        {8,	0}, 	/* 0x2e74 */
        {8,	0}, 	/* 0x2e75 */
        {8,	0}, 	/* 0x2e76 */
        {8,	0}, 	/* 0x2e77 */
        {8,	0}, 	/* 0x2e78 */
        {8,	0}, 	/* 0x2e79 */
        {8,	0}, 	/* 0x2e7a */
        {8,	0}, 	/* 0x2e7b */
        {8,	0}, 	/* 0x2e7c */
        {8,	0}, 	/* 0x2e7d */
        {8,	0}, 	/* 0x2e7e */
        {8,	0}, 	/* 0x2e7f */
        {8,	0}, 	/* 0x2e80 */
        {8,	0}, 	/* 0x2e81 */
        {8,	0}, 	/* 0x2e82 */
        {8,	0}, 	/* 0x2e83 */
        {8,	0}, 	/* 0x2e84 */
        {8,	0}, 	/* 0x2e85 */
        {8,	0}, 	/* 0x2e86 */
        {8,	0}, 	/* 0x2e87 */
        {8,	0}, 	/* 0x2e88 */
        {8,	0}, 	/* 0x2e89 */
        {8,	0}, 	/* 0x2e8a */
        {8,	0}, 	/* 0x2e8b */
        {8,	0}, 	/* 0x2e8c */
        {8,	0}, 	/* 0x2e8d */
        {8,	0}, 	/* 0x2e8e */
        {8,	0}, 	/* 0x2e8f */
        {8,	0}, 	/* 0x2e90 */
        {8,	0}, 	/* 0x2e91 */
        {8,	0}, 	/* 0x2e92 */
        {8,	0}, 	/* 0x2e93 */
        {8,	0}, 	/* 0x2e94 */
        {8,	0}, 	/* 0x2e95 */
        {8,	0}, 	/* 0x2e96 */
        {8,	0}, 	/* 0x2e97 */
        {8,	0}, 	/* 0x2e98 */
        {8,	0}, 	/* 0x2e99 */
        {8,	0}, 	/* 0x2e9a */
        {8,	0}, 	/* 0x2e9b */
        {8,	0}, 	/* 0x2e9c */
        {8,	0}, 	/* 0x2e9d */
        {8,	0}, 	/* 0x2e9e */
        {8,	0}, 	/* 0x2e9f */
        {8,	0}, 	/* 0x2ea0 */
        {8,	0}, 	/* 0x2ea1 */
        {8,	0}, 	/* 0x2ea2 */
        {8,	0}, 	/* 0x2ea3 */
        {8,	0}, 	/* 0x2ea4 */
        {8,	0}, 	/* 0x2ea5 */
        {8,	0}, 	/* 0x2ea6 */
        {8,	0}, 	/* 0x2ea7 */
        {8,	0}, 	/* 0x2ea8 */
        {8,	0}, 	/* 0x2ea9 */
        {8,	0}, 	/* 0x2eaa */
        {8,	0}, 	/* 0x2eab */
        {8,	0}, 	/* 0x2eac */
        {8,	0}, 	/* 0x2ead */
        {8,	0}, 	/* 0x2eae */
        {8,	0}, 	/* 0x2eaf */
        {8,	0}, 	/* 0x2eb0 */
        {8,	0}, 	/* 0x2eb1 */
        {8,	0}, 	/* 0x2eb2 */
        {8,	0}, 	/* 0x2eb3 */
        {8,	0}, 	/* 0x2eb4 */
        {8,	0}, 	/* 0x2eb5 */
        {8,	0}, 	/* 0x2eb6 */
        {8,	0}, 	/* 0x2eb7 */
        {8,	0}, 	/* 0x2eb8 */
        {8,	0}, 	/* 0x2eb9 */
        {8,	0}, 	/* 0x2eba */
        {8,	0}, 	/* 0x2ebb */
        {8,	0}, 	/* 0x2ebc */
        {8,	0}, 	/* 0x2ebd */
        {8,	0}, 	/* 0x2ebe */
        {8,	0}, 	/* 0x2ebf */
        {8,	0}, 	/* 0x2ec0 */
        {8,	0}, 	/* 0x2ec1 */
        {8,	0}, 	/* 0x2ec2 */
        {8,	0}, 	/* 0x2ec3 */
        {8,	0}, 	/* 0x2ec4 */
        {8,	0}, 	/* 0x2ec5 */
        {8,	0}, 	/* 0x2ec6 */
        {8,	0}, 	/* 0x2ec7 */
        {8,	0}, 	/* 0x2ec8 */
        {8,	0}, 	/* 0x2ec9 */
        {8,	0}, 	/* 0x2eca */
        {8,	0}, 	/* 0x2ecb */
        {8,	0}, 	/* 0x2ecc */
        {8,	0}, 	/* 0x2ecd */
        {8,	0}, 	/* 0x2ece */
        {8,	0}, 	/* 0x2ecf */
        {8,	0}, 	/* 0x2ed0 */
        {8,	0}, 	/* 0x2ed1 */
        {8,	0}, 	/* 0x2ed2 */
        {8,	0}, 	/* 0x2ed3 */
        {8,	0}, 	/* 0x2ed4 */
        {8,	0}, 	/* 0x2ed5 */
        {8,	0}, 	/* 0x2ed6 */
        {8,	0}, 	/* 0x2ed7 */
        {8,	0}, 	/* 0x2ed8 */
        {8,	0}, 	/* 0x2ed9 */
        {8,	0}, 	/* 0x2eda */
        {8,	0}, 	/* 0x2edb */
        {8,	0}, 	/* 0x2edc */
        {8,	0}, 	/* 0x2edd */
        {8,	0}, 	/* 0x2ede */
        {8,	0}, 	/* 0x2edf */
        {8,	0}, 	/* 0x2ee0 */
        {8,	0}, 	/* 0x2ee1 */
        {8,	0}, 	/* 0x2ee2 */
        {8,	0}, 	/* 0x2ee3 */
        {8,	0}, 	/* 0x2ee4 */
        {8,	0}, 	/* 0x2ee5 */
        {8,	0}, 	/* 0x2ee6 */
        {8,	0}, 	/* 0x2ee7 */
        {8,	0}, 	/* 0x2ee8 */
        {8,	0}, 	/* 0x2ee9 */
        {8,	0}, 	/* 0x2eea */
        {8,	0}, 	/* 0x2eeb */
        {8,	0}, 	/* 0x2eec */
        {8,	0}, 	/* 0x2eed */
        {8,	0}, 	/* 0x2eee */
        {8,	0}, 	/* 0x2eef */
        {8,	0}, 	/* 0x2ef0 */
        {8,	0}, 	/* 0x2ef1 */
        {8,	0}, 	/* 0x2ef2 */
        {8,	0}, 	/* 0x2ef3 */
        {8,	0}, 	/* 0x2ef4 */
        {8,	0}, 	/* 0x2ef5 */
        {8,	0}, 	/* 0x2ef6 */
        {8,	0}, 	/* 0x2ef7 */
        {8,	0}, 	/* 0x2ef8 */
        {8,	0}, 	/* 0x2ef9 */
        {8,	0}, 	/* 0x2efa */
        {8,	0}, 	/* 0x2efb */
        {8,	0}, 	/* 0x2efc */
        {8,	0}, 	/* 0x2efd */
        {8,	0}, 	/* 0x2efe */
        {8,	0}, 	/* 0x2eff */
        {8,	0}, 	/* 0x2f00 */
        {8,	0}, 	/* 0x2f01 */
        {8,	0}, 	/* 0x2f02 */
        {8,	0}, 	/* 0x2f03 */
        {8,	0}, 	/* 0x2f04 */
        {8,	0}, 	/* 0x2f05 */
        {8,	0}, 	/* 0x2f06 */
        {8,	0}, 	/* 0x2f07 */
        {8,	0}, 	/* 0x2f08 */
        {8,	0}, 	/* 0x2f09 */
        {8,	0}, 	/* 0x2f0a */
        {8,	0}, 	/* 0x2f0b */
        {8,	0}, 	/* 0x2f0c */
        {8,	0}, 	/* 0x2f0d */
        {8,	0}, 	/* 0x2f0e */
        {8,	0}, 	/* 0x2f0f */
        {8,	0}, 	/* 0x2f10 */
        {8,	0}, 	/* 0x2f11 */
        {8,	0}, 	/* 0x2f12 */
        {8,	0}, 	/* 0x2f13 */
        {8,	0}, 	/* 0x2f14 */
        {8,	0}, 	/* 0x2f15 */
        {8,	0}, 	/* 0x2f16 */
        {8,	0}, 	/* 0x2f17 */
        {8,	0}, 	/* 0x2f18 */
        {8,	0}, 	/* 0x2f19 */
        {8,	0}, 	/* 0x2f1a */
        {8,	0}, 	/* 0x2f1b */
        {8,	0}, 	/* 0x2f1c */
        {8,	0}, 	/* 0x2f1d */
        {8,	0}, 	/* 0x2f1e */
        {8,	0}, 	/* 0x2f1f */
        {8,	0}, 	/* 0x2f20 */
        {8,	0}, 	/* 0x2f21 */
        {8,	0}, 	/* 0x2f22 */
        {8,	0}, 	/* 0x2f23 */
        {8,	0}, 	/* 0x2f24 */
        {8,	0}, 	/* 0x2f25 */
        {8,	0}, 	/* 0x2f26 */
        {8,	0}, 	/* 0x2f27 */
        {8,	0}, 	/* 0x2f28 */
        {8,	0}, 	/* 0x2f29 */
        {8,	0}, 	/* 0x2f2a */
        {8,	0}, 	/* 0x2f2b */
        {8,	0}, 	/* 0x2f2c */
        {8,	0}, 	/* 0x2f2d */
        {8,	0}, 	/* 0x2f2e */
        {8,	0}, 	/* 0x2f2f */
        {8,	0}, 	/* 0x2f30 */
        {8,	0}, 	/* 0x2f31 */
        {8,	0}, 	/* 0x2f32 */
        {8,	0}, 	/* 0x2f33 */
        {8,	0}, 	/* 0x2f34 */
        {8,	0}, 	/* 0x2f35 */
        {8,	0}, 	/* 0x2f36 */
        {8,	0}, 	/* 0x2f37 */
        {8,	0}, 	/* 0x2f38 */
        {8,	0}, 	/* 0x2f39 */
        {8,	0}, 	/* 0x2f3a */
        {8,	0}, 	/* 0x2f3b */
        {8,	0}, 	/* 0x2f3c */
        {8,	0}, 	/* 0x2f3d */
        {8,	0}, 	/* 0x2f3e */
        {8,	0}, 	/* 0x2f3f */
        {8,	0}, 	/* 0x2f40 */
        {8,	0}, 	/* 0x2f41 */
        {8,	0}, 	/* 0x2f42 */
        {8,	0}, 	/* 0x2f43 */
        {8,	0}, 	/* 0x2f44 */
        {8,	0}, 	/* 0x2f45 */
        {8,	0}, 	/* 0x2f46 */
        {8,	0}, 	/* 0x2f47 */
        {8,	0}, 	/* 0x2f48 */
        {8,	0}, 	/* 0x2f49 */
        {8,	0}, 	/* 0x2f4a */
        {8,	0}, 	/* 0x2f4b */
        {8,	0}, 	/* 0x2f4c */
        {8,	0}, 	/* 0x2f4d */
        {8,	0}, 	/* 0x2f4e */
        {8,	0}, 	/* 0x2f4f */
        {8,	0}, 	/* 0x2f50 */
        {8,	0}, 	/* 0x2f51 */
        {8,	0}, 	/* 0x2f52 */
        {8,	0}, 	/* 0x2f53 */
        {8,	0}, 	/* 0x2f54 */
        {8,	0}, 	/* 0x2f55 */
        {8,	0}, 	/* 0x2f56 */
        {8,	0}, 	/* 0x2f57 */
        {8,	0}, 	/* 0x2f58 */
        {8,	0}, 	/* 0x2f59 */
        {8,	0}, 	/* 0x2f5a */
        {8,	0}, 	/* 0x2f5b */
        {8,	0}, 	/* 0x2f5c */
        {8,	0}, 	/* 0x2f5d */
        {8,	0}, 	/* 0x2f5e */
        {8,	0}, 	/* 0x2f5f */
        {8,	0}, 	/* 0x2f60 */
        {8,	0}, 	/* 0x2f61 */
        {8,	0}, 	/* 0x2f62 */
        {8,	0}, 	/* 0x2f63 */
        {8,	0}, 	/* 0x2f64 */
        {8,	0}, 	/* 0x2f65 */
        {8,	0}, 	/* 0x2f66 */
        {8,	0}, 	/* 0x2f67 */
        {8,	0}, 	/* 0x2f68 */
        {8,	0}, 	/* 0x2f69 */
        {8,	0}, 	/* 0x2f6a */
        {8,	0}, 	/* 0x2f6b */
        {8,	0}, 	/* 0x2f6c */
        {8,	0}, 	/* 0x2f6d */
        {8,	0}, 	/* 0x2f6e */
        {8,	0}, 	/* 0x2f6f */
        {8,	0}, 	/* 0x2f70 */
        {8,	0}, 	/* 0x2f71 */
        {8,	0}, 	/* 0x2f72 */
        {8,	0}, 	/* 0x2f73 */
        {8,	0}, 	/* 0x2f74 */
        {8,	0}, 	/* 0x2f75 */
        {8,	0}, 	/* 0x2f76 */
        {8,	0}, 	/* 0x2f77 */
        {8,	0}, 	/* 0x2f78 */
        {8,	0}, 	/* 0x2f79 */
        {8,	0}, 	/* 0x2f7a */
        {8,	0}, 	/* 0x2f7b */
        {8,	0}, 	/* 0x2f7c */
        {8,	0}, 	/* 0x2f7d */
        {8,	0}, 	/* 0x2f7e */
        {8,	0}, 	/* 0x2f7f */
        {8,	0}, 	/* 0x2f80 */
        {8,	0}, 	/* 0x2f81 */
        {8,	0}, 	/* 0x2f82 */
        {8,	0}, 	/* 0x2f83 */
        {8,	0}, 	/* 0x2f84 */
        {8,	0}, 	/* 0x2f85 */
        {8,	0}, 	/* 0x2f86 */
        {8,	0}, 	/* 0x2f87 */
        {8,	0}, 	/* 0x2f88 */
        {8,	0}, 	/* 0x2f89 */
        {8,	0}, 	/* 0x2f8a */
        {8,	0}, 	/* 0x2f8b */
        {8,	0}, 	/* 0x2f8c */
        {8,	0}, 	/* 0x2f8d */
        {8,	0}, 	/* 0x2f8e */
        {8,	0}, 	/* 0x2f8f */
        {8,	0}, 	/* 0x2f90 */
        {8,	0}, 	/* 0x2f91 */
        {8,	0}, 	/* 0x2f92 */
        {8,	0}, 	/* 0x2f93 */
        {8,	0}, 	/* 0x2f94 */
        {8,	0}, 	/* 0x2f95 */
        {8,	0}, 	/* 0x2f96 */
        {8,	0}, 	/* 0x2f97 */
        {8,	0}, 	/* 0x2f98 */
        {8,	0}, 	/* 0x2f99 */
        {8,	0}, 	/* 0x2f9a */
        {8,	0}, 	/* 0x2f9b */
        {8,	0}, 	/* 0x2f9c */
        {8,	0}, 	/* 0x2f9d */
        {8,	0}, 	/* 0x2f9e */
        {8,	0}, 	/* 0x2f9f */
        {8,	0}, 	/* 0x2fa0 */
        {8,	0}, 	/* 0x2fa1 */
        {8,	0}, 	/* 0x2fa2 */
        {8,	0}, 	/* 0x2fa3 */
        {8,	0}, 	/* 0x2fa4 */
        {8,	0}, 	/* 0x2fa5 */
        {8,	0}, 	/* 0x2fa6 */
        {8,	0}, 	/* 0x2fa7 */
        {8,	0}, 	/* 0x2fa8 */
        {8,	0}, 	/* 0x2fa9 */
        {8,	0}, 	/* 0x2faa */
        {8,	0}, 	/* 0x2fab */
        {8,	0}, 	/* 0x2fac */
        {8,	0}, 	/* 0x2fad */
        {8,	0}, 	/* 0x2fae */
        {8,	0}, 	/* 0x2faf */
        {8,	0}, 	/* 0x2fb0 */
        {8,	0}, 	/* 0x2fb1 */
        {8,	0}, 	/* 0x2fb2 */
        {8,	0}, 	/* 0x2fb3 */
        {8,	0}, 	/* 0x2fb4 */
        {8,	0}, 	/* 0x2fb5 */
        {8,	0}, 	/* 0x2fb6 */
        {8,	0}, 	/* 0x2fb7 */
        {8,	0}, 	/* 0x2fb8 */
        {8,	0}, 	/* 0x2fb9 */
        {8,	0}, 	/* 0x2fba */
        {8,	0}, 	/* 0x2fbb */
        {8,	0}, 	/* 0x2fbc */
        {8,	0}, 	/* 0x2fbd */
        {8,	0}, 	/* 0x2fbe */
        {8,	0}, 	/* 0x2fbf */
        {8,	0}, 	/* 0x2fc0 */
        {8,	0}, 	/* 0x2fc1 */
        {8,	0}, 	/* 0x2fc2 */
        {8,	0}, 	/* 0x2fc3 */
        {8,	0}, 	/* 0x2fc4 */
        {8,	0}, 	/* 0x2fc5 */
        {8,	0}, 	/* 0x2fc6 */
        {8,	0}, 	/* 0x2fc7 */
        {8,	0}, 	/* 0x2fc8 */
        {8,	0}, 	/* 0x2fc9 */
        {8,	0}, 	/* 0x2fca */
        {8,	0}, 	/* 0x2fcb */
        {8,	0}, 	/* 0x2fcc */
        {8,	0}, 	/* 0x2fcd */
        {8,	0}, 	/* 0x2fce */
        {8,	0}, 	/* 0x2fcf */
        {8,	0}, 	/* 0x2fd0 */
        {8,	0}, 	/* 0x2fd1 */
        {8,	0}, 	/* 0x2fd2 */
        {8,	0}, 	/* 0x2fd3 */
        {8,	0}, 	/* 0x2fd4 */
        {8,	0}, 	/* 0x2fd5 */
        {8,	0}, 	/* 0x2fd6 */
        {8,	0}, 	/* 0x2fd7 */
        {8,	0}, 	/* 0x2fd8 */
        {8,	0}, 	/* 0x2fd9 */
        {8,	0}, 	/* 0x2fda */
        {8,	0}, 	/* 0x2fdb */
        {8,	0}, 	/* 0x2fdc */
        {8,	0}, 	/* 0x2fdd */
        {8,	0}, 	/* 0x2fde */
        {8,	0}, 	/* 0x2fdf */
        {8,	0}, 	/* 0x2fe0 */
        {8,	0}, 	/* 0x2fe1 */
        {8,	0}, 	/* 0x2fe2 */
        {8,	0}, 	/* 0x2fe3 */
        {8,	0}, 	/* 0x2fe4 */
        {8,	0}, 	/* 0x2fe5 */
        {8,	0}, 	/* 0x2fe6 */
        {8,	0}, 	/* 0x2fe7 */
        {8,	0}, 	/* 0x2fe8 */
        {8,	0}, 	/* 0x2fe9 */
        {8,	0}, 	/* 0x2fea */
        {8,	0}, 	/* 0x2feb */
        {8,	0}, 	/* 0x2fec */
        {8,	0}, 	/* 0x2fed */
        {8,	0}, 	/* 0x2fee */
        {8,	0}, 	/* 0x2fef */
        {8,	0}, 	/* 0x2ff0 */
        {8,	0}, 	/* 0x2ff1 */
        {8,	0}, 	/* 0x2ff2 */
        {8,	0}, 	/* 0x2ff3 */
        {8,	0}, 	/* 0x2ff4 */
        {8,	0}, 	/* 0x2ff5 */
        {8,	0}, 	/* 0x2ff6 */
        {8,	0}, 	/* 0x2ff7 */
        {8,	0}, 	/* 0x2ff8 */
        {8,	0}, 	/* 0x2ff9 */
        {8,	0}, 	/* 0x2ffa */
        {8,	0}, 	/* 0x2ffb */
        {8,	0}, 	/* 0x2ffc */
        {8,	0}, 	/* 0x2ffd */
        {8,	0}, 	/* 0x2ffe */
        {8,	0}, 	/* 0x2fff */
        {8,	0}, 	/* 0x3000 */
        {8,	0}, 	/* 0x3001 */
        {8,	0}, 	/* 0x3002 */
        {8,	0}, 	/* 0x3003 */
        {8,	0}, 	/* 0x3004 */
        {8,	0}, 	/* 0x3005 */
        {8,	0}, 	/* 0x3006 */
        {8,	0}, 	/* 0x3007 */
        {8,	0}, 	/* 0x3008 */
        {8,	0}, 	/* 0x3009 */
        {8,	0}, 	/* 0x300a */
        {8,	0}, 	/* 0x300b */
        {8,	0}, 	/* 0x300c */
        {8,	0}, 	/* 0x300d */
        {8,	0}, 	/* 0x300e */
        {8,	0}, 	/* 0x300f */
        {8,	0}, 	/* 0x3010 */
        {8,	0}, 	/* 0x3011 */
        {8,	0}, 	/* 0x3012 */
        {8,	0}, 	/* 0x3013 */
        {8,	0}, 	/* 0x3014 */
        {8,	0}, 	/* 0x3015 */
        {8,	0}, 	/* 0x3016 */
        {8,	0}, 	/* 0x3017 */
        {8,	0}, 	/* 0x3018 */
        {8,	0}, 	/* 0x3019 */
        {8,	0}, 	/* 0x301a */
        {8,	0}, 	/* 0x301b */
        {8,	0}, 	/* 0x301c */
        {8,	0}, 	/* 0x301d */
        {8,	0}, 	/* 0x301e */
        {8,	0}, 	/* 0x301f */
        {8,	0}, 	/* 0x3020 */
        {8,	0}, 	/* 0x3021 */
        {8,	0}, 	/* 0x3022 */
        {8,	0}, 	/* 0x3023 */
        {8,	0}, 	/* 0x3024 */
        {8,	0}, 	/* 0x3025 */
        {8,	0}, 	/* 0x3026 */
        {8,	0}, 	/* 0x3027 */
        {8,	0}, 	/* 0x3028 */
        {8,	0}, 	/* 0x3029 */
        {8,	0}, 	/* 0x302a */
        {8,	0}, 	/* 0x302b */
        {8,	0}, 	/* 0x302c */
        {8,	0}, 	/* 0x302d */
        {8,	0}, 	/* 0x302e */
        {8,	0}, 	/* 0x302f */
        {8,	0}, 	/* 0x3030 */
        {8,	0}, 	/* 0x3031 */
        {8,	0}, 	/* 0x3032 */
        {8,	0}, 	/* 0x3033 */
        {8,	0}, 	/* 0x3034 */
        {8,	0}, 	/* 0x3035 */
        {8,	0}, 	/* 0x3036 */
        {8,	0}, 	/* 0x3037 */
        {8,	0}, 	/* 0x3038 */
        {8,	0}, 	/* 0x3039 */
        {8,	0}, 	/* 0x303a */
        {8,	0}, 	/* 0x303b */
        {8,	0}, 	/* 0x303c */
        {8,	0}, 	/* 0x303d */
        {8,	0}, 	/* 0x303e */
        {8,	0}, 	/* 0x303f */
        {8,	0}, 	/* 0x3040 */
        {8,	0}, 	/* 0x3041 */
        {8,	0}, 	/* 0x3042 */
        {8,	0}, 	/* 0x3043 */
        {8,	0}, 	/* 0x3044 */
        {8,	0}, 	/* 0x3045 */
        {8,	0}, 	/* 0x3046 */
        {8,	0}, 	/* 0x3047 */
        {8,	0}, 	/* 0x3048 */
        {8,	0}, 	/* 0x3049 */
        {8,	0}, 	/* 0x304a */
        {8,	0}, 	/* 0x304b */
        {8,	0}, 	/* 0x304c */
        {8,	0}, 	/* 0x304d */
        {8,	0}, 	/* 0x304e */
        {8,	0}, 	/* 0x304f */
        {8,	0}, 	/* 0x3050 */
        {8,	0}, 	/* 0x3051 */
        {8,	0}, 	/* 0x3052 */
        {8,	0}, 	/* 0x3053 */
        {8,	0}, 	/* 0x3054 */
        {8,	0}, 	/* 0x3055 */
        {8,	0}, 	/* 0x3056 */
        {8,	0}, 	/* 0x3057 */
        {8,	0}, 	/* 0x3058 */
        {8,	0}, 	/* 0x3059 */
        {8,	0}, 	/* 0x305a */
        {8,	0}, 	/* 0x305b */
        {8,	0}, 	/* 0x305c */
        {8,	0}, 	/* 0x305d */
        {8,	0}, 	/* 0x305e */
        {8,	0}, 	/* 0x305f */
        {8,	0}, 	/* 0x3060 */
        {8,	0}, 	/* 0x3061 */
        {8,	0}, 	/* 0x3062 */
        {8,	0}, 	/* 0x3063 */
        {8,	0}, 	/* 0x3064 */
        {8,	0}, 	/* 0x3065 */
        {8,	0}, 	/* 0x3066 */
        {8,	0}, 	/* 0x3067 */
        {8,	0}, 	/* 0x3068 */
        {8,	0}, 	/* 0x3069 */
        {8,	0}, 	/* 0x306a */
        {8,	0}, 	/* 0x306b */
        {8,	0}, 	/* 0x306c */
        {8,	0}, 	/* 0x306d */
        {8,	0}, 	/* 0x306e */
        {8,	0}, 	/* 0x306f */
        {8,	0}, 	/* 0x3070 */
        {8,	0}, 	/* 0x3071 */
        {8,	0}, 	/* 0x3072 */
        {8,	0}, 	/* 0x3073 */
        {8,	0}, 	/* 0x3074 */
        {8,	0}, 	/* 0x3075 */
        {8,	0}, 	/* 0x3076 */
        {8,	0}, 	/* 0x3077 */
        {8,	0}, 	/* 0x3078 */
        {8,	0}, 	/* 0x3079 */
        {8,	0}, 	/* 0x307a */
        {8,	0}, 	/* 0x307b */
        {8,	0}, 	/* 0x307c */
        {8,	0}, 	/* 0x307d */
        {8,	0}, 	/* 0x307e */
        {8,	0}, 	/* 0x307f */
        {8,	0}, 	/* 0x3080 */
        {8,	0}, 	/* 0x3081 */
        {8,	0}, 	/* 0x3082 */
        {8,	0}, 	/* 0x3083 */
        {8,	0}, 	/* 0x3084 */
        {8,	0}, 	/* 0x3085 */
        {8,	0}, 	/* 0x3086 */
        {8,	0}, 	/* 0x3087 */
        {8,	0}, 	/* 0x3088 */
        {8,	0}, 	/* 0x3089 */
        {8,	0}, 	/* 0x308a */
        {8,	0}, 	/* 0x308b */
        {8,	0}, 	/* 0x308c */
        {8,	0}, 	/* 0x308d */
        {8,	0}, 	/* 0x308e */
        {8,	0}, 	/* 0x308f */
        {8,	0}, 	/* 0x3090 */
        {8,	0}, 	/* 0x3091 */
        {8,	0}, 	/* 0x3092 */
        {8,	0}, 	/* 0x3093 */
        {8,	0}, 	/* 0x3094 */
        {8,	0}, 	/* 0x3095 */
        {8,	0}, 	/* 0x3096 */
        {8,	0}, 	/* 0x3097 */
        {8,	0}, 	/* 0x3098 */
        {8,	0}, 	/* 0x3099 */
        {8,	0}, 	/* 0x309a */
        {8,	0}, 	/* 0x309b */
        {8,	0}, 	/* 0x309c */
        {8,	0}, 	/* 0x309d */
        {8,	0}, 	/* 0x309e */
        {8,	0}, 	/* 0x309f */
        {8,	0}, 	/* 0x30a0 */
        {8,	0}, 	/* 0x30a1 */
        {8,	0}, 	/* 0x30a2 */
        {8,	0}, 	/* 0x30a3 */
        {8,	0}, 	/* 0x30a4 */
        {8,	0}, 	/* 0x30a5 */
        {8,	0}, 	/* 0x30a6 */
        {8,	0}, 	/* 0x30a7 */
        {8,	0}, 	/* 0x30a8 */
        {8,	0}, 	/* 0x30a9 */
        {8,	0}, 	/* 0x30aa */
        {8,	0}, 	/* 0x30ab */
        {8,	0}, 	/* 0x30ac */
        {8,	0}, 	/* 0x30ad */
        {8,	0}, 	/* 0x30ae */
        {8,	0}, 	/* 0x30af */
        {8,	0}, 	/* 0x30b0 */
        {8,	0}, 	/* 0x30b1 */
        {8,	0}, 	/* 0x30b2 */
        {8,	0}, 	/* 0x30b3 */
        {8,	0}, 	/* 0x30b4 */
        {8,	0}, 	/* 0x30b5 */
        {8,	0}, 	/* 0x30b6 */
        {8,	0}, 	/* 0x30b7 */
        {8,	0}, 	/* 0x30b8 */
        {8,	0}, 	/* 0x30b9 */
        {8,	0}, 	/* 0x30ba */
        {8,	0}, 	/* 0x30bb */
        {8,	0}, 	/* 0x30bc */
        {8,	0}, 	/* 0x30bd */
        {8,	0}, 	/* 0x30be */
        {8,	0}, 	/* 0x30bf */
        {8,	0}, 	/* 0x30c0 */
        {8,	0}, 	/* 0x30c1 */
        {8,	0}, 	/* 0x30c2 */
        {8,	0}, 	/* 0x30c3 */
        {8,	0}, 	/* 0x30c4 */
        {8,	0}, 	/* 0x30c5 */
        {8,	0}, 	/* 0x30c6 */
        {8,	0}, 	/* 0x30c7 */
        {8,	0}, 	/* 0x30c8 */
        {8,	0}, 	/* 0x30c9 */
        {8,	0}, 	/* 0x30ca */
        {8,	0}, 	/* 0x30cb */
        {8,	0}, 	/* 0x30cc */
        {8,	0}, 	/* 0x30cd */
        {8,	0}, 	/* 0x30ce */
        {8,	0}, 	/* 0x30cf */
        {8,	0}, 	/* 0x30d0 */
        {8,	0}, 	/* 0x30d1 */
        {8,	0}, 	/* 0x30d2 */
        {8,	0}, 	/* 0x30d3 */
        {8,	0}, 	/* 0x30d4 */
        {8,	0}, 	/* 0x30d5 */
        {8,	0}, 	/* 0x30d6 */
        {8,	0}, 	/* 0x30d7 */
        {8,	0}, 	/* 0x30d8 */
        {8,	0}, 	/* 0x30d9 */
        {8,	0}, 	/* 0x30da */
        {8,	0}, 	/* 0x30db */
        {8,	0}, 	/* 0x30dc */
        {8,	0}, 	/* 0x30dd */
        {8,	0}, 	/* 0x30de */
        {8,	0}, 	/* 0x30df */
        {8,	0}, 	/* 0x30e0 */
        {8,	0}, 	/* 0x30e1 */
        {8,	0}, 	/* 0x30e2 */
        {8,	0}, 	/* 0x30e3 */
        {8,	0}, 	/* 0x30e4 */
        {8,	0}, 	/* 0x30e5 */
        {8,	0}, 	/* 0x30e6 */
        {8,	0}, 	/* 0x30e7 */
        {8,	0}, 	/* 0x30e8 */
        {8,	0}, 	/* 0x30e9 */
        {8,	0}, 	/* 0x30ea */
        {8,	0}, 	/* 0x30eb */
        {8,	0}, 	/* 0x30ec */
        {8,	0}, 	/* 0x30ed */
        {8,	0}, 	/* 0x30ee */
        {8,	0}, 	/* 0x30ef */
        {8,	0}, 	/* 0x30f0 */
        {8,	0}, 	/* 0x30f1 */
        {8,	0}, 	/* 0x30f2 */
        {8,	0}, 	/* 0x30f3 */
        {8,	0}, 	/* 0x30f4 */
        {8,	0}, 	/* 0x30f5 */
        {8,	0}, 	/* 0x30f6 */
        {8,	0}, 	/* 0x30f7 */
        {8,	0}, 	/* 0x30f8 */
        {8,	0}, 	/* 0x30f9 */
        {8,	0}, 	/* 0x30fa */
        {8,	0}, 	/* 0x30fb */
        {8,	0}, 	/* 0x30fc */
        {8,	0}, 	/* 0x30fd */
        {8,	0}, 	/* 0x30fe */
        {8,	0}, 	/* 0x30ff */
        {8,	0}, 	/* 0x3100 */
        {8,	0}, 	/* 0x3101 */
        {8,	0}, 	/* 0x3102 */
        {8,	0}, 	/* 0x3103 */
        {8,	0}, 	/* 0x3104 */
        {8,	0}, 	/* 0x3105 */
        {8,	0}, 	/* 0x3106 */
        {8,	0}, 	/* 0x3107 */
        {8,	0}, 	/* 0x3108 */
        {8,	0}, 	/* 0x3109 */
        {8,	0}, 	/* 0x310a */
        {8,	0}, 	/* 0x310b */
        {8,	0}, 	/* 0x310c */
        {8,	0}, 	/* 0x310d */
        {8,	0}, 	/* 0x310e */
        {8,	0}, 	/* 0x310f */
        {8,	0}, 	/* 0x3110 */
        {8,	0}, 	/* 0x3111 */
        {8,	0}, 	/* 0x3112 */
        {8,	0}, 	/* 0x3113 */
        {8,	0}, 	/* 0x3114 */
        {8,	0}, 	/* 0x3115 */
        {8,	0}, 	/* 0x3116 */
        {8,	0}, 	/* 0x3117 */
        {8,	0}, 	/* 0x3118 */
        {8,	0}, 	/* 0x3119 */
        {8,	0}, 	/* 0x311a */
        {8,	0}, 	/* 0x311b */
        {8,	0}, 	/* 0x311c */
        {8,	0}, 	/* 0x311d */
        {8,	0}, 	/* 0x311e */
        {8,	0}, 	/* 0x311f */
        {8,	0}, 	/* 0x3120 */
        {8,	0}, 	/* 0x3121 */
        {8,	0}, 	/* 0x3122 */
        {8,	0}, 	/* 0x3123 */
        {8,	0}, 	/* 0x3124 */
        {8,	0}, 	/* 0x3125 */
        {8,	0}, 	/* 0x3126 */
        {8,	0}, 	/* 0x3127 */
        {8,	0}, 	/* 0x3128 */
        {8,	0}, 	/* 0x3129 */
        {8,	0}, 	/* 0x312a */
        {8,	0}, 	/* 0x312b */
        {8,	0}, 	/* 0x312c */
        {8,	0}, 	/* 0x312d */
        {8,	0}, 	/* 0x312e */
        {8,	0}, 	/* 0x312f */
        {8,	0}, 	/* 0x3130 */
        {8,	0}, 	/* 0x3131 */
        {8,	0}, 	/* 0x3132 */
        {8,	0}, 	/* 0x3133 */
        {8,	0}, 	/* 0x3134 */
        {8,	0}, 	/* 0x3135 */
        {8,	0}, 	/* 0x3136 */
        {8,	0}, 	/* 0x3137 */
        {8,	0}, 	/* 0x3138 */
        {8,	0}, 	/* 0x3139 */
        {8,	0}, 	/* 0x313a */
        {8,	0}, 	/* 0x313b */
        {8,	0}, 	/* 0x313c */
        {8,	0}, 	/* 0x313d */
        {8,	0}, 	/* 0x313e */
        {8,	0}, 	/* 0x313f */
        {8,	0}, 	/* 0x3140 */
        {8,	0}, 	/* 0x3141 */
        {8,	0}, 	/* 0x3142 */
        {8,	0}, 	/* 0x3143 */
        {8,	0}, 	/* 0x3144 */
        {8,	0}, 	/* 0x3145 */
        {8,	0}, 	/* 0x3146 */
        {8,	0}, 	/* 0x3147 */
        {8,	0}, 	/* 0x3148 */
        {8,	0}, 	/* 0x3149 */
        {8,	0}, 	/* 0x314a */
        {8,	0}, 	/* 0x314b */
        {8,	0}, 	/* 0x314c */
        {8,	0}, 	/* 0x314d */
        {8,	0}, 	/* 0x314e */
        {8,	0}, 	/* 0x314f */
        {8,	0}, 	/* 0x3150 */
        {8,	0}, 	/* 0x3151 */
        {8,	0}, 	/* 0x3152 */
        {8,	0}, 	/* 0x3153 */
        {8,	0}, 	/* 0x3154 */
        {8,	0}, 	/* 0x3155 */
        {8,	0}, 	/* 0x3156 */
        {8,	0}, 	/* 0x3157 */
        {8,	0}, 	/* 0x3158 */
        {8,	0}, 	/* 0x3159 */
        {8,	0}, 	/* 0x315a */
        {8,	0}, 	/* 0x315b */
        {8,	0}, 	/* 0x315c */
        {8,	0}, 	/* 0x315d */
        {8,	0}, 	/* 0x315e */
        {8,	0}, 	/* 0x315f */
        {8,	0}, 	/* 0x3160 */
        {8,	0}, 	/* 0x3161 */
        {8,	0}, 	/* 0x3162 */
        {8,	0}, 	/* 0x3163 */
        {8,	0}, 	/* 0x3164 */
        {8,	0}, 	/* 0x3165 */
        {8,	0}, 	/* 0x3166 */
        {8,	0}, 	/* 0x3167 */
        {8,	0}, 	/* 0x3168 */
        {8,	0}, 	/* 0x3169 */
        {8,	0}, 	/* 0x316a */
        {8,	0}, 	/* 0x316b */
        {8,	0}, 	/* 0x316c */
        {8,	0}, 	/* 0x316d */
        {8,	0}, 	/* 0x316e */
        {8,	0}, 	/* 0x316f */
        {8,	0}, 	/* 0x3170 */
        {8,	0}, 	/* 0x3171 */
        {8,	0}, 	/* 0x3172 */
        {8,	0}, 	/* 0x3173 */
        {8,	0}, 	/* 0x3174 */
        {8,	0}, 	/* 0x3175 */
        {8,	0}, 	/* 0x3176 */
        {8,	0}, 	/* 0x3177 */
        {8,	0}, 	/* 0x3178 */
        {8,	0}, 	/* 0x3179 */
        {8,	0}, 	/* 0x317a */
        {8,	0}, 	/* 0x317b */
        {8,	0}, 	/* 0x317c */
        {8,	0}, 	/* 0x317d */
        {8,	0}, 	/* 0x317e */
        {8,	0}, 	/* 0x317f */
        {8,	0}, 	/* 0x3180 */
        {8,	0}, 	/* 0x3181 */
        {8,	0}, 	/* 0x3182 */
        {8,	0}, 	/* 0x3183 */
        {8,	0}, 	/* 0x3184 */
        {8,	0}, 	/* 0x3185 */
        {8,	0}, 	/* 0x3186 */
        {8,	0}, 	/* 0x3187 */
        {8,	0}, 	/* 0x3188 */
        {8,	0}, 	/* 0x3189 */
        {8,	0}, 	/* 0x318a */
        {8,	0}, 	/* 0x318b */
        {8,	0}, 	/* 0x318c */
        {8,	0}, 	/* 0x318d */
        {8,	0}, 	/* 0x318e */
        {8,	0}, 	/* 0x318f */
        {8,	0}, 	/* 0x3190 */
        {8,	0}, 	/* 0x3191 */
        {8,	0}, 	/* 0x3192 */
        {8,	0}, 	/* 0x3193 */
        {8,	0}, 	/* 0x3194 */
        {8,	0}, 	/* 0x3195 */
        {8,	0}, 	/* 0x3196 */
        {8,	0}, 	/* 0x3197 */
        {8,	0}, 	/* 0x3198 */
        {8,	0}, 	/* 0x3199 */
        {8,	0}, 	/* 0x319a */
        {8,	0}, 	/* 0x319b */
        {8,	0}, 	/* 0x319c */
        {8,	0}, 	/* 0x319d */
        {8,	0}, 	/* 0x319e */
        {8,	0}, 	/* 0x319f */
        {8,	0}, 	/* 0x31a0 */
        {8,	0}, 	/* 0x31a1 */
        {8,	0}, 	/* 0x31a2 */
        {8,	0}, 	/* 0x31a3 */
        {8,	0}, 	/* 0x31a4 */
        {8,	0}, 	/* 0x31a5 */
        {8,	0}, 	/* 0x31a6 */
        {8,	0}, 	/* 0x31a7 */
        {8,	0}, 	/* 0x31a8 */
        {8,	0}, 	/* 0x31a9 */
        {8,	0}, 	/* 0x31aa */
        {8,	0}, 	/* 0x31ab */
        {8,	0}, 	/* 0x31ac */
        {8,	0}, 	/* 0x31ad */
        {8,	0}, 	/* 0x31ae */
        {8,	0}, 	/* 0x31af */
        {8,	0}, 	/* 0x31b0 */
        {8,	0}, 	/* 0x31b1 */
        {8,	0}, 	/* 0x31b2 */
        {8,	0}, 	/* 0x31b3 */
        {8,	0}, 	/* 0x31b4 */
        {8,	0}, 	/* 0x31b5 */
        {8,	0}, 	/* 0x31b6 */
        {8,	0}, 	/* 0x31b7 */
        {8,	0}, 	/* 0x31b8 */
        {8,	0}, 	/* 0x31b9 */
        {8,	0}, 	/* 0x31ba */
        {8,	0}, 	/* 0x31bb */
        {8,	0}, 	/* 0x31bc */
        {8,	0}, 	/* 0x31bd */
        {8,	0}, 	/* 0x31be */
        {8,	0}, 	/* 0x31bf */
        {8,	0}, 	/* 0x31c0 */
        {8,	0}, 	/* 0x31c1 */
        {8,	0}, 	/* 0x31c2 */
        {8,	0}, 	/* 0x31c3 */
        {8,	0}, 	/* 0x31c4 */
        {8,	0}, 	/* 0x31c5 */
        {8,	0}, 	/* 0x31c6 */
        {8,	0}, 	/* 0x31c7 */
        {8,	0}, 	/* 0x31c8 */
        {8,	0}, 	/* 0x31c9 */
        {8,	0}, 	/* 0x31ca */
        {8,	0}, 	/* 0x31cb */
        {8,	0}, 	/* 0x31cc */
        {8,	0}, 	/* 0x31cd */
        {8,	0}, 	/* 0x31ce */
        {8,	0}, 	/* 0x31cf */
        {8,	0}, 	/* 0x31d0 */
        {8,	0}, 	/* 0x31d1 */
        {8,	0}, 	/* 0x31d2 */
        {8,	0}, 	/* 0x31d3 */
        {8,	0}, 	/* 0x31d4 */
        {8,	0}, 	/* 0x31d5 */
        {8,	0}, 	/* 0x31d6 */
        {8,	0}, 	/* 0x31d7 */
        {8,	0}, 	/* 0x31d8 */
        {8,	0}, 	/* 0x31d9 */
        {8,	0}, 	/* 0x31da */
        {8,	0}, 	/* 0x31db */
        {8,	0}, 	/* 0x31dc */
        {8,	0}, 	/* 0x31dd */
        {8,	0}, 	/* 0x31de */
        {8,	0}, 	/* 0x31df */
        {8,	0}, 	/* 0x31e0 */
        {8,	0}, 	/* 0x31e1 */
        {8,	0}, 	/* 0x31e2 */
        {8,	0}, 	/* 0x31e3 */
        {8,	0}, 	/* 0x31e4 */
        {8,	0}, 	/* 0x31e5 */
        {8,	0}, 	/* 0x31e6 */
        {8,	0}, 	/* 0x31e7 */
        {8,	0}, 	/* 0x31e8 */
        {8,	0}, 	/* 0x31e9 */
        {8,	0}, 	/* 0x31ea */
        {8,	0}, 	/* 0x31eb */
        {8,	0}, 	/* 0x31ec */
        {8,	0}, 	/* 0x31ed */
        {8,	0}, 	/* 0x31ee */
        {8,	0}, 	/* 0x31ef */
        {8,	0}, 	/* 0x31f0 */
        {8,	0}, 	/* 0x31f1 */
        {8,	0}, 	/* 0x31f2 */
        {8,	0}, 	/* 0x31f3 */
        {8,	0}, 	/* 0x31f4 */
        {8,	0}, 	/* 0x31f5 */
        {8,	0}, 	/* 0x31f6 */
        {8,	0}, 	/* 0x31f7 */
        {8,	0}, 	/* 0x31f8 */
        {8,	0}, 	/* 0x31f9 */
        {8,	0}, 	/* 0x31fa */
        {8,	0}, 	/* 0x31fb */
        {8,	0}, 	/* 0x31fc */
        {8,	0}, 	/* 0x31fd */
        {8,	0}, 	/* 0x31fe */
        {8,	0}, 	/* 0x31ff */
        {8,	0}, 	/* 0x3200 */
        {8,	0}, 	/* 0x3201 */
        {8,	0}, 	/* 0x3202 */
        {8,	0}, 	/* 0x3203 */
        {8,	0}, 	/* 0x3204 */
        {8,	0}, 	/* 0x3205 */
        {8,	0}, 	/* 0x3206 */
        {8,	0}, 	/* 0x3207 */
        {8,	0}, 	/* 0x3208 */
        {8,	0}, 	/* 0x3209 */
        {8,	0}, 	/* 0x320a */
        {8,	0}, 	/* 0x320b */
        {8,	0}, 	/* 0x320c */
        {8,	0}, 	/* 0x320d */
        {8,	0}, 	/* 0x320e */
        {8,	0}, 	/* 0x320f */
        {8,	0}, 	/* 0x3210 */
        {8,	0}, 	/* 0x3211 */
        {8,	0}, 	/* 0x3212 */
        {8,	0}, 	/* 0x3213 */
        {8,	0}, 	/* 0x3214 */
        {8,	0}, 	/* 0x3215 */
        {8,	0}, 	/* 0x3216 */
        {8,	0}, 	/* 0x3217 */
        {8,	0}, 	/* 0x3218 */
        {8,	0}, 	/* 0x3219 */
        {8,	0}, 	/* 0x321a */
        {8,	0}, 	/* 0x321b */
        {8,	0}, 	/* 0x321c */
        {8,	0}, 	/* 0x321d */
        {8,	0}, 	/* 0x321e */
        {8,	0}, 	/* 0x321f */
        {8,	0}, 	/* 0x3220 */
        {8,	0}, 	/* 0x3221 */
        {8,	0}, 	/* 0x3222 */
        {8,	0}, 	/* 0x3223 */
        {8,	0}, 	/* 0x3224 */
        {8,	0}, 	/* 0x3225 */
        {8,	0}, 	/* 0x3226 */
        {8,	0}, 	/* 0x3227 */
        {8,	0}, 	/* 0x3228 */
        {8,	0}, 	/* 0x3229 */
        {8,	0}, 	/* 0x322a */
        {8,	0}, 	/* 0x322b */
        {8,	0}, 	/* 0x322c */
        {8,	0}, 	/* 0x322d */
        {8,	0}, 	/* 0x322e */
        {8,	0}, 	/* 0x322f */
        {8,	0}, 	/* 0x3230 */
        {8,	0}, 	/* 0x3231 */
        {8,	0}, 	/* 0x3232 */
        {8,	0}, 	/* 0x3233 */
        {8,	0}, 	/* 0x3234 */
        {8,	0}, 	/* 0x3235 */
        {8,	0}, 	/* 0x3236 */
        {8,	0}, 	/* 0x3237 */
        {8,	0}, 	/* 0x3238 */
        {8,	0}, 	/* 0x3239 */
        {8,	0}, 	/* 0x323a */
        {8,	0}, 	/* 0x323b */
        {8,	0}, 	/* 0x323c */
        {8,	0}, 	/* 0x323d */
        {8,	0}, 	/* 0x323e */
        {8,	0}, 	/* 0x323f */
        {8,	0}, 	/* 0x3240 */
        {8,	0}, 	/* 0x3241 */
        {8,	0}, 	/* 0x3242 */
        {8,	0}, 	/* 0x3243 */
        {8,	0}, 	/* 0x3244 */
        {8,	0}, 	/* 0x3245 */
        {8,	0}, 	/* 0x3246 */
        {8,	0}, 	/* 0x3247 */
        {8,	0}, 	/* 0x3248 */
        {8,	0}, 	/* 0x3249 */
        {8,	0}, 	/* 0x324a */
        {8,	0}, 	/* 0x324b */
        {8,	0}, 	/* 0x324c */
        {8,	0}, 	/* 0x324d */
        {8,	0}, 	/* 0x324e */
        {8,	0}, 	/* 0x324f */
        {8,	0}, 	/* 0x3250 */
        {8,	0}, 	/* 0x3251 */
        {8,	0}, 	/* 0x3252 */
        {8,	0}, 	/* 0x3253 */
        {8,	0}, 	/* 0x3254 */
        {8,	0}, 	/* 0x3255 */
        {8,	0}, 	/* 0x3256 */
        {8,	0}, 	/* 0x3257 */
        {8,	0}, 	/* 0x3258 */
        {8,	0}, 	/* 0x3259 */
        {8,	0}, 	/* 0x325a */
        {8,	0}, 	/* 0x325b */
        {8,	0}, 	/* 0x325c */
        {8,	0}, 	/* 0x325d */
        {8,	0}, 	/* 0x325e */
        {8,	0}, 	/* 0x325f */
        {8,	0}, 	/* 0x3260 */
        {8,	0}, 	/* 0x3261 */
        {8,	0}, 	/* 0x3262 */
        {8,	0}, 	/* 0x3263 */
        {8,	0}, 	/* 0x3264 */
        {8,	0}, 	/* 0x3265 */
        {8,	0}, 	/* 0x3266 */
        {8,	0}, 	/* 0x3267 */
        {8,	0}, 	/* 0x3268 */
        {8,	0}, 	/* 0x3269 */
        {8,	0}, 	/* 0x326a */
        {8,	0}, 	/* 0x326b */
        {8,	0}, 	/* 0x326c */
        {8,	0}, 	/* 0x326d */
        {8,	0}, 	/* 0x326e */
        {8,	0}, 	/* 0x326f */
        {8,	0}, 	/* 0x3270 */
        {8,	0}, 	/* 0x3271 */
        {8,	0}, 	/* 0x3272 */
        {8,	0}, 	/* 0x3273 */
        {8,	0}, 	/* 0x3274 */
        {8,	0}, 	/* 0x3275 */
        {8,	0}, 	/* 0x3276 */
        {8,	0}, 	/* 0x3277 */
        {8,	0}, 	/* 0x3278 */
        {8,	0}, 	/* 0x3279 */
        {8,	0}, 	/* 0x327a */
        {8,	0}, 	/* 0x327b */
        {8,	0}, 	/* 0x327c */
        {8,	0}, 	/* 0x327d */
        {8,	0}, 	/* 0x327e */
        {8,	0}, 	/* 0x327f */
        {8,	0}, 	/* 0x3280 */
        {8,	0}, 	/* 0x3281 */
        {8,	0}, 	/* 0x3282 */
        {8,	0}, 	/* 0x3283 */
        {8,	0}, 	/* 0x3284 */
        {8,	0}, 	/* 0x3285 */
        {8,	0}, 	/* 0x3286 */
        {8,	0}, 	/* 0x3287 */
        {8,	0}, 	/* 0x3288 */
        {8,	0}, 	/* 0x3289 */
        {8,	0}, 	/* 0x328a */
        {8,	0}, 	/* 0x328b */
        {8,	0}, 	/* 0x328c */
        {8,	0}, 	/* 0x328d */
        {8,	0}, 	/* 0x328e */
        {8,	0}, 	/* 0x328f */
        {8,	0}, 	/* 0x3290 */
        {8,	0}, 	/* 0x3291 */
        {8,	0}, 	/* 0x3292 */
        {8,	0}, 	/* 0x3293 */
        {8,	0}, 	/* 0x3294 */
        {8,	0}, 	/* 0x3295 */
        {8,	0}, 	/* 0x3296 */
        {8,	0}, 	/* 0x3297 */
        {8,	0}, 	/* 0x3298 */
        {8,	0}, 	/* 0x3299 */
        {8,	0}, 	/* 0x329a */
        {8,	0}, 	/* 0x329b */
        {8,	0}, 	/* 0x329c */
        {8,	0}, 	/* 0x329d */
        {8,	0}, 	/* 0x329e */
        {8,	0}, 	/* 0x329f */
        {8,	0}, 	/* 0x32a0 */
        {8,	0}, 	/* 0x32a1 */
        {8,	0}, 	/* 0x32a2 */
        {8,	0}, 	/* 0x32a3 */
        {8,	0}, 	/* 0x32a4 */
        {8,	0}, 	/* 0x32a5 */
        {8,	0}, 	/* 0x32a6 */
        {8,	0}, 	/* 0x32a7 */
        {8,	0}, 	/* 0x32a8 */
        {8,	0}, 	/* 0x32a9 */
        {8,	0}, 	/* 0x32aa */
        {8,	0}, 	/* 0x32ab */
        {8,	0}, 	/* 0x32ac */
        {8,	0}, 	/* 0x32ad */
        {8,	0}, 	/* 0x32ae */
        {8,	0}, 	/* 0x32af */
        {8,	0}, 	/* 0x32b0 */
        {8,	0}, 	/* 0x32b1 */
        {8,	0}, 	/* 0x32b2 */
        {8,	0}, 	/* 0x32b3 */
        {8,	0}, 	/* 0x32b4 */
        {8,	0}, 	/* 0x32b5 */
        {8,	0}, 	/* 0x32b6 */
        {8,	0}, 	/* 0x32b7 */
        {8,	0}, 	/* 0x32b8 */
        {8,	0}, 	/* 0x32b9 */
        {8,	0}, 	/* 0x32ba */
        {8,	0}, 	/* 0x32bb */
        {8,	0}, 	/* 0x32bc */
        {8,	0}, 	/* 0x32bd */
        {8,	0}, 	/* 0x32be */
        {8,	0}, 	/* 0x32bf */
        {8,	0}, 	/* 0x32c0 */
        {8,	0}, 	/* 0x32c1 */
        {8,	0}, 	/* 0x32c2 */
        {8,	0}, 	/* 0x32c3 */
        {8,	0}, 	/* 0x32c4 */
        {8,	0}, 	/* 0x32c5 */
        {8,	0}, 	/* 0x32c6 */
        {8,	0}, 	/* 0x32c7 */
        {8,	0}, 	/* 0x32c8 */
        {8,	0}, 	/* 0x32c9 */
        {8,	0}, 	/* 0x32ca */
        {8,	0}, 	/* 0x32cb */
        {8,	0}, 	/* 0x32cc */
        {8,	0}, 	/* 0x32cd */
        {8,	0}, 	/* 0x32ce */
        {8,	0}, 	/* 0x32cf */
        {8,	0}, 	/* 0x32d0 */
        {8,	0}, 	/* 0x32d1 */
        {8,	0}, 	/* 0x32d2 */
        {8,	0}, 	/* 0x32d3 */
        {8,	0}, 	/* 0x32d4 */
        {8,	0}, 	/* 0x32d5 */
        {8,	0}, 	/* 0x32d6 */
        {8,	0}, 	/* 0x32d7 */
        {8,	0}, 	/* 0x32d8 */
        {8,	0}, 	/* 0x32d9 */
        {8,	0}, 	/* 0x32da */
        {8,	0}, 	/* 0x32db */
        {8,	0}, 	/* 0x32dc */
        {8,	0}, 	/* 0x32dd */
        {8,	0}, 	/* 0x32de */
        {8,	0}, 	/* 0x32df */
        {8,	0}, 	/* 0x32e0 */
        {8,	0}, 	/* 0x32e1 */
        {8,	0}, 	/* 0x32e2 */
        {8,	0}, 	/* 0x32e3 */
        {8,	0}, 	/* 0x32e4 */
        {8,	0}, 	/* 0x32e5 */
        {8,	0}, 	/* 0x32e6 */
        {8,	0}, 	/* 0x32e7 */
        {8,	0}, 	/* 0x32e8 */
        {8,	0}, 	/* 0x32e9 */
        {8,	0}, 	/* 0x32ea */
        {8,	0}, 	/* 0x32eb */
        {8,	0}, 	/* 0x32ec */
        {8,	0}, 	/* 0x32ed */
        {8,	0}, 	/* 0x32ee */
        {8,	0}, 	/* 0x32ef */
        {8,	0}, 	/* 0x32f0 */
        {8,	0}, 	/* 0x32f1 */
        {8,	0}, 	/* 0x32f2 */
        {8,	0}, 	/* 0x32f3 */
        {8,	0}, 	/* 0x32f4 */
        {8,	0}, 	/* 0x32f5 */
        {8,	0}, 	/* 0x32f6 */
        {8,	0}, 	/* 0x32f7 */
        {8,	0}, 	/* 0x32f8 */
        {8,	0}, 	/* 0x32f9 */
        {8,	0}, 	/* 0x32fa */
        {8,	0}, 	/* 0x32fb */
        {8,	0}, 	/* 0x32fc */
        {8,	0}, 	/* 0x32fd */
        {8,	0}, 	/* 0x32fe */
        {8,	0}, 	/* 0x32ff */
        {8,	0}, 	/* 0x3300 */
        {8,	0}, 	/* 0x3301 */
        {8,	0}, 	/* 0x3302 */
        {8,	0}, 	/* 0x3303 */
        {8,	0}, 	/* 0x3304 */
        {8,	0}, 	/* 0x3305 */
        {8,	0}, 	/* 0x3306 */
        {8,	0}, 	/* 0x3307 */
        {8,	0}, 	/* 0x3308 */
        {8,	0}, 	/* 0x3309 */
        {8,	0}, 	/* 0x330a */
        {8,	0}, 	/* 0x330b */
        {8,	0}, 	/* 0x330c */
        {8,	0}, 	/* 0x330d */
        {8,	0}, 	/* 0x330e */
        {8,	0}, 	/* 0x330f */
        {8,	0}, 	/* 0x3310 */
        {8,	0}, 	/* 0x3311 */
        {8,	0}, 	/* 0x3312 */
        {8,	0}, 	/* 0x3313 */
        {8,	0}, 	/* 0x3314 */
        {8,	0}, 	/* 0x3315 */
        {8,	0}, 	/* 0x3316 */
        {8,	0}, 	/* 0x3317 */
        {8,	0}, 	/* 0x3318 */
        {8,	0}, 	/* 0x3319 */
        {8,	0}, 	/* 0x331a */
        {8,	0}, 	/* 0x331b */
        {8,	0}, 	/* 0x331c */
        {8,	0}, 	/* 0x331d */
        {8,	0}, 	/* 0x331e */
        {8,	0}, 	/* 0x331f */
        {8,	0}, 	/* 0x3320 */
        {8,	0}, 	/* 0x3321 */
        {8,	0}, 	/* 0x3322 */
        {8,	0}, 	/* 0x3323 */
        {8,	0}, 	/* 0x3324 */
        {8,	0}, 	/* 0x3325 */
        {8,	0}, 	/* 0x3326 */
        {8,	0}, 	/* 0x3327 */
        {8,	0}, 	/* 0x3328 */
        {8,	0}, 	/* 0x3329 */
        {8,	0}, 	/* 0x332a */
        {8,	0}, 	/* 0x332b */
        {8,	0}, 	/* 0x332c */
        {8,	0}, 	/* 0x332d */
        {8,	0}, 	/* 0x332e */
        {8,	0}, 	/* 0x332f */
        {8,	0}, 	/* 0x3330 */
        {8,	0}, 	/* 0x3331 */
        {8,	0}, 	/* 0x3332 */
        {8,	0}, 	/* 0x3333 */
        {8,	0}, 	/* 0x3334 */
        {8,	0}, 	/* 0x3335 */
        {8,	0}, 	/* 0x3336 */
        {8,	0}, 	/* 0x3337 */
        {8,	0}, 	/* 0x3338 */
        {8,	0}, 	/* 0x3339 */
        {8,	0}, 	/* 0x333a */
        {8,	0}, 	/* 0x333b */
        {8,	0}, 	/* 0x333c */
        {8,	0}, 	/* 0x333d */
        {8,	0}, 	/* 0x333e */
        {8,	0}, 	/* 0x333f */
        {8,	0}, 	/* 0x3340 */
        {8,	0}, 	/* 0x3341 */
        {8,	0}, 	/* 0x3342 */
        {8,	0}, 	/* 0x3343 */
        {8,	0}, 	/* 0x3344 */
        {8,	0}, 	/* 0x3345 */
        {8,	0}, 	/* 0x3346 */
        {8,	0}, 	/* 0x3347 */
        {8,	0}, 	/* 0x3348 */
        {8,	0}, 	/* 0x3349 */
        {8,	0}, 	/* 0x334a */
        {8,	0}, 	/* 0x334b */
        {8,	0}, 	/* 0x334c */
        {8,	0}, 	/* 0x334d */
        {8,	0}, 	/* 0x334e */
        {8,	0}, 	/* 0x334f */
        {8,	0}, 	/* 0x3350 */
        {8,	0}, 	/* 0x3351 */
        {8,	0}, 	/* 0x3352 */
        {8,	0}, 	/* 0x3353 */
        {8,	0}, 	/* 0x3354 */
        {8,	0}, 	/* 0x3355 */
        {8,	0}, 	/* 0x3356 */
        {8,	0}, 	/* 0x3357 */
        {8,	0}, 	/* 0x3358 */
        {8,	0}, 	/* 0x3359 */
        {8,	0}, 	/* 0x335a */
        {8,	0}, 	/* 0x335b */
        {8,	0}, 	/* 0x335c */
        {8,	0}, 	/* 0x335d */
        {8,	0}, 	/* 0x335e */
        {8,	0}, 	/* 0x335f */
        {8,	0}, 	/* 0x3360 */
        {8,	0}, 	/* 0x3361 */
        {8,	0}, 	/* 0x3362 */
        {8,	0}, 	/* 0x3363 */
        {8,	0}, 	/* 0x3364 */
        {8,	0}, 	/* 0x3365 */
        {8,	0}, 	/* 0x3366 */
        {8,	0}, 	/* 0x3367 */
        {8,	0}, 	/* 0x3368 */
        {8,	0}, 	/* 0x3369 */
        {8,	0}, 	/* 0x336a */
        {8,	0}, 	/* 0x336b */
        {8,	0}, 	/* 0x336c */
        {8,	0}, 	/* 0x336d */
        {8,	0}, 	/* 0x336e */
        {8,	0}, 	/* 0x336f */
        {8,	0}, 	/* 0x3370 */
        {8,	0}, 	/* 0x3371 */
        {8,	0}, 	/* 0x3372 */
        {8,	0}, 	/* 0x3373 */
        {8,	0}, 	/* 0x3374 */
        {8,	0}, 	/* 0x3375 */
        {8,	0}, 	/* 0x3376 */
        {8,	0}, 	/* 0x3377 */
        {8,	0}, 	/* 0x3378 */
        {8,	0}, 	/* 0x3379 */
        {8,	0}, 	/* 0x337a */
        {8,	0}, 	/* 0x337b */
        {8,	0}, 	/* 0x337c */
        {8,	0}, 	/* 0x337d */
        {8,	0}, 	/* 0x337e */
        {8,	0}, 	/* 0x337f */
        {8,	0}, 	/* 0x3380 */
        {8,	0}, 	/* 0x3381 */
        {8,	0}, 	/* 0x3382 */
        {8,	0}, 	/* 0x3383 */
        {8,	0}, 	/* 0x3384 */
        {8,	0}, 	/* 0x3385 */
        {8,	0}, 	/* 0x3386 */
        {8,	0}, 	/* 0x3387 */
        {8,	0}, 	/* 0x3388 */
        {8,	0}, 	/* 0x3389 */
        {8,	0}, 	/* 0x338a */
        {8,	0}, 	/* 0x338b */
        {8,	0}, 	/* 0x338c */
        {8,	0}, 	/* 0x338d */
        {8,	0}, 	/* 0x338e */
        {8,	0}, 	/* 0x338f */
        {8,	0}, 	/* 0x3390 */
        {8,	0}, 	/* 0x3391 */
        {8,	0}, 	/* 0x3392 */
        {8,	0}, 	/* 0x3393 */
        {8,	0}, 	/* 0x3394 */
        {8,	0}, 	/* 0x3395 */
        {8,	0}, 	/* 0x3396 */
        {8,	0}, 	/* 0x3397 */
        {8,	0}, 	/* 0x3398 */
        {8,	0}, 	/* 0x3399 */
        {8,	0}, 	/* 0x339a */
        {8,	0}, 	/* 0x339b */
        {8,	0}, 	/* 0x339c */
        {8,	0}, 	/* 0x339d */
        {8,	0}, 	/* 0x339e */
        {8,	0}, 	/* 0x339f */
        {8,	0}, 	/* 0x33a0 */
        {8,	0}, 	/* 0x33a1 */
        {8,	0}, 	/* 0x33a2 */
        {8,	0}, 	/* 0x33a3 */
        {8,	0}, 	/* 0x33a4 */
        {8,	0}, 	/* 0x33a5 */
        {8,	0}, 	/* 0x33a6 */
        {8,	0}, 	/* 0x33a7 */
        {8,	0}, 	/* 0x33a8 */
        {8,	0}, 	/* 0x33a9 */
        {8,	0}, 	/* 0x33aa */
        {8,	0}, 	/* 0x33ab */
        {8,	0}, 	/* 0x33ac */
        {8,	0}, 	/* 0x33ad */
        {8,	0}, 	/* 0x33ae */
        {8,	0}, 	/* 0x33af */
        {8,	0}, 	/* 0x33b0 */
        {8,	0}, 	/* 0x33b1 */
        {8,	0}, 	/* 0x33b2 */
        {8,	0}, 	/* 0x33b3 */
        {8,	0}, 	/* 0x33b4 */
        {8,	0}, 	/* 0x33b5 */
        {8,	0}, 	/* 0x33b6 */
        {8,	0}, 	/* 0x33b7 */
        {8,	0}, 	/* 0x33b8 */
        {8,	0}, 	/* 0x33b9 */
        {8,	0}, 	/* 0x33ba */
        {8,	0}, 	/* 0x33bb */
        {8,	0}, 	/* 0x33bc */
        {8,	0}, 	/* 0x33bd */
        {8,	0}, 	/* 0x33be */
        {8,	0}, 	/* 0x33bf */
        {8,	0}, 	/* 0x33c0 */
        {8,	0}, 	/* 0x33c1 */
        {8,	0}, 	/* 0x33c2 */
        {8,	0}, 	/* 0x33c3 */
        {8,	0}, 	/* 0x33c4 */
        {8,	0}, 	/* 0x33c5 */
        {8,	0}, 	/* 0x33c6 */
        {8,	0}, 	/* 0x33c7 */
        {8,	0}, 	/* 0x33c8 */
        {8,	0}, 	/* 0x33c9 */
        {8,	0}, 	/* 0x33ca */
        {8,	0}, 	/* 0x33cb */
        {8,	0}, 	/* 0x33cc */
        {8,	0}, 	/* 0x33cd */
        {8,	0}, 	/* 0x33ce */
        {8,	0}, 	/* 0x33cf */
        {8,	0}, 	/* 0x33d0 */
        {8,	0}, 	/* 0x33d1 */
        {8,	0}, 	/* 0x33d2 */
        {8,	0}, 	/* 0x33d3 */
        {8,	0}, 	/* 0x33d4 */
        {8,	0}, 	/* 0x33d5 */
        {8,	0}, 	/* 0x33d6 */
        {8,	0}, 	/* 0x33d7 */
        {8,	0}, 	/* 0x33d8 */
        {8,	0}, 	/* 0x33d9 */
        {8,	0}, 	/* 0x33da */
        {8,	0}, 	/* 0x33db */
        {8,	0}, 	/* 0x33dc */
        {8,	0}, 	/* 0x33dd */
        {8,	0}, 	/* 0x33de */
        {8,	0}, 	/* 0x33df */
        {8,	0}, 	/* 0x33e0 */
        {8,	0}, 	/* 0x33e1 */
        {8,	0}, 	/* 0x33e2 */
        {8,	0}, 	/* 0x33e3 */
        {8,	0}, 	/* 0x33e4 */
        {8,	0}, 	/* 0x33e5 */
        {8,	0}, 	/* 0x33e6 */
        {8,	0}, 	/* 0x33e7 */
        {8,	0}, 	/* 0x33e8 */
        {8,	0}, 	/* 0x33e9 */
        {8,	0}, 	/* 0x33ea */
        {8,	0}, 	/* 0x33eb */
        {8,	0}, 	/* 0x33ec */
        {8,	0}, 	/* 0x33ed */
        {8,	0}, 	/* 0x33ee */
        {8,	0}, 	/* 0x33ef */
        {8,	0}, 	/* 0x33f0 */
        {8,	0}, 	/* 0x33f1 */
        {8,	0}, 	/* 0x33f2 */
        {8,	0}, 	/* 0x33f3 */
        {8,	0}, 	/* 0x33f4 */
        {8,	0}, 	/* 0x33f5 */
        {8,	0}, 	/* 0x33f6 */
        {8,	0}, 	/* 0x33f7 */
        {8,	0}, 	/* 0x33f8 */
        {8,	0}, 	/* 0x33f9 */
        {8,	0}, 	/* 0x33fa */
        {8,	0}, 	/* 0x33fb */
        {8,	0}, 	/* 0x33fc */
        {8,	0}, 	/* 0x33fd */
        {8,	0}, 	/* 0x33fe */
        {8,	0}, 	/* 0x33ff */
        {8,	0}, 	/* 0x3400 */
        {8,	0}, 	/* 0x3401 */
        {8,	0}, 	/* 0x3402 */
        {8,	0}, 	/* 0x3403 */
        {8,	0}, 	/* 0x3404 */
        {8,	0}, 	/* 0x3405 */
        {8,	0}, 	/* 0x3406 */
        {8,	0}, 	/* 0x3407 */
        {8,	0}, 	/* 0x3408 */
        {8,	0}, 	/* 0x3409 */
        {8,	0}, 	/* 0x340a */
        {8,	0}, 	/* 0x340b */
        {8,	0}, 	/* 0x340c */
        {8,	0}, 	/* 0x340d */
        {8,	0}, 	/* 0x340e */
        {8,	0}, 	/* 0x340f */
        {8,	0}, 	/* 0x3410 */
        {8,	0}, 	/* 0x3411 */
        {8,	0}, 	/* 0x3412 */
        {8,	0}, 	/* 0x3413 */
        {8,	0}, 	/* 0x3414 */
        {8,	0}, 	/* 0x3415 */
        {8,	0}, 	/* 0x3416 */
        {8,	0}, 	/* 0x3417 */
        {8,	0}, 	/* 0x3418 */
        {8,	0}, 	/* 0x3419 */
        {8,	0}, 	/* 0x341a */
        {8,	0}, 	/* 0x341b */
        {8,	0}, 	/* 0x341c */
        {8,	0}, 	/* 0x341d */
        {8,	0}, 	/* 0x341e */
        {8,	0}, 	/* 0x341f */
        {8,	0}, 	/* 0x3420 */
        {8,	0}, 	/* 0x3421 */
        {8,	0}, 	/* 0x3422 */
        {8,	0}, 	/* 0x3423 */
        {8,	0}, 	/* 0x3424 */
        {8,	0}, 	/* 0x3425 */
        {8,	0}, 	/* 0x3426 */
        {8,	0}, 	/* 0x3427 */
        {8,	0}, 	/* 0x3428 */
        {8,	0}, 	/* 0x3429 */
        {8,	0}, 	/* 0x342a */
        {8,	0}, 	/* 0x342b */
        {8,	0}, 	/* 0x342c */
        {8,	0}, 	/* 0x342d */
        {8,	0}, 	/* 0x342e */
        {8,	0}, 	/* 0x342f */
        {8,	0}, 	/* 0x3430 */
        {8,	0}, 	/* 0x3431 */
        {8,	0}, 	/* 0x3432 */
        {8,	0}, 	/* 0x3433 */
        {8,	0}, 	/* 0x3434 */
        {8,	0}, 	/* 0x3435 */
        {8,	0}, 	/* 0x3436 */
        {8,	0}, 	/* 0x3437 */
        {8,	0}, 	/* 0x3438 */
        {8,	0}, 	/* 0x3439 */
        {8,	0}, 	/* 0x343a */
        {8,	0}, 	/* 0x343b */
        {8,	0}, 	/* 0x343c */
        {8,	0}, 	/* 0x343d */
        {8,	0}, 	/* 0x343e */
        {8,	0}, 	/* 0x343f */
        {8,	0}, 	/* 0x3440 */
        {8,	0}, 	/* 0x3441 */
        {8,	0}, 	/* 0x3442 */
        {8,	0}, 	/* 0x3443 */
        {8,	0}, 	/* 0x3444 */
        {8,	0}, 	/* 0x3445 */
        {8,	0}, 	/* 0x3446 */
        {8,	0}, 	/* 0x3447 */
        {8,	0}, 	/* 0x3448 */
        {8,	0}, 	/* 0x3449 */
        {8,	0}, 	/* 0x344a */
        {8,	0}, 	/* 0x344b */
        {8,	0}, 	/* 0x344c */
        {8,	0}, 	/* 0x344d */
        {8,	0}, 	/* 0x344e */
        {8,	0}, 	/* 0x344f */
        {8,	0}, 	/* 0x3450 */
        {8,	0}, 	/* 0x3451 */
        {8,	0}, 	/* 0x3452 */
        {8,	0}, 	/* 0x3453 */
        {8,	0}, 	/* 0x3454 */
        {8,	0}, 	/* 0x3455 */
        {8,	0}, 	/* 0x3456 */
        {8,	0}, 	/* 0x3457 */
        {8,	0}, 	/* 0x3458 */
        {8,	0}, 	/* 0x3459 */
        {8,	0}, 	/* 0x345a */
        {8,	0}, 	/* 0x345b */
        {8,	0}, 	/* 0x345c */
        {8,	0}, 	/* 0x345d */
        {8,	0}, 	/* 0x345e */
        {8,	0}, 	/* 0x345f */
        {8,	0}, 	/* 0x3460 */
        {8,	0}, 	/* 0x3461 */
        {8,	0}, 	/* 0x3462 */
        {8,	0}, 	/* 0x3463 */
        {8,	0}, 	/* 0x3464 */
        {8,	0}, 	/* 0x3465 */
        {8,	0}, 	/* 0x3466 */
        {8,	0}, 	/* 0x3467 */
        {8,	0}, 	/* 0x3468 */
        {8,	0}, 	/* 0x3469 */
        {8,	0}, 	/* 0x346a */
        {8,	0}, 	/* 0x346b */
        {8,	0}, 	/* 0x346c */
        {8,	0}, 	/* 0x346d */
        {8,	0}, 	/* 0x346e */
        {8,	0}, 	/* 0x346f */
        {8,	0}, 	/* 0x3470 */
        {8,	0}, 	/* 0x3471 */
        {8,	0}, 	/* 0x3472 */
        {8,	0}, 	/* 0x3473 */
        {8,	0}, 	/* 0x3474 */
        {8,	0}, 	/* 0x3475 */
        {8,	0}, 	/* 0x3476 */
        {8,	0}, 	/* 0x3477 */
        {8,	0}, 	/* 0x3478 */
        {8,	0}, 	/* 0x3479 */
        {8,	0}, 	/* 0x347a */
        {8,	0}, 	/* 0x347b */
        {8,	0}, 	/* 0x347c */
        {8,	0}, 	/* 0x347d */
        {8,	0}, 	/* 0x347e */
        {8,	0}, 	/* 0x347f */
        {8,	0}, 	/* 0x3480 */
        {8,	0}, 	/* 0x3481 */
        {8,	0}, 	/* 0x3482 */
        {8,	0}, 	/* 0x3483 */
        {8,	0}, 	/* 0x3484 */
        {8,	0}, 	/* 0x3485 */
        {8,	0}, 	/* 0x3486 */
        {8,	0}, 	/* 0x3487 */
        {8,	0}, 	/* 0x3488 */
        {8,	0}, 	/* 0x3489 */
        {8,	0}, 	/* 0x348a */
        {8,	0}, 	/* 0x348b */
        {8,	0}, 	/* 0x348c */
        {8,	0}, 	/* 0x348d */
        {8,	0}, 	/* 0x348e */
        {8,	0}, 	/* 0x348f */
        {8,	0}, 	/* 0x3490 */
        {8,	0}, 	/* 0x3491 */
        {8,	0}, 	/* 0x3492 */
        {8,	0}, 	/* 0x3493 */
        {8,	0}, 	/* 0x3494 */
        {8,	0}, 	/* 0x3495 */
        {8,	0}, 	/* 0x3496 */
        {8,	0}, 	/* 0x3497 */
        {8,	0}, 	/* 0x3498 */
        {8,	0}, 	/* 0x3499 */
        {8,	0}, 	/* 0x349a */
        {8,	0}, 	/* 0x349b */
        {8,	0}, 	/* 0x349c */
        {8,	0}, 	/* 0x349d */
        {8,	0}, 	/* 0x349e */
        {8,	0}, 	/* 0x349f */
        {8,	0}, 	/* 0x34a0 */
        {8,	0}, 	/* 0x34a1 */
        {8,	0}, 	/* 0x34a2 */
        {8,	0}, 	/* 0x34a3 */
        {8,	0}, 	/* 0x34a4 */
        {8,	0}, 	/* 0x34a5 */
        {8,	0}, 	/* 0x34a6 */
        {8,	0}, 	/* 0x34a7 */
        {8,	0}, 	/* 0x34a8 */
        {8,	0}, 	/* 0x34a9 */
        {8,	0}, 	/* 0x34aa */
        {8,	0}, 	/* 0x34ab */
        {8,	0}, 	/* 0x34ac */
        {8,	0}, 	/* 0x34ad */
        {8,	0}, 	/* 0x34ae */
        {8,	0}, 	/* 0x34af */
        {8,	0}, 	/* 0x34b0 */
        {8,	0}, 	/* 0x34b1 */
        {8,	0}, 	/* 0x34b2 */
        {8,	0}, 	/* 0x34b3 */
        {8,	0}, 	/* 0x34b4 */
        {8,	0}, 	/* 0x34b5 */
        {8,	0}, 	/* 0x34b6 */
        {8,	0}, 	/* 0x34b7 */
        {8,	0}, 	/* 0x34b8 */
        {8,	0}, 	/* 0x34b9 */
        {8,	0}, 	/* 0x34ba */
        {8,	0}, 	/* 0x34bb */
        {8,	0}, 	/* 0x34bc */
        {8,	0}, 	/* 0x34bd */
        {8,	0}, 	/* 0x34be */
        {8,	0}, 	/* 0x34bf */
        {8,	0}, 	/* 0x34c0 */
        {8,	0}, 	/* 0x34c1 */
        {8,	0}, 	/* 0x34c2 */
        {8,	0}, 	/* 0x34c3 */
        {8,	0}, 	/* 0x34c4 */
        {8,	0}, 	/* 0x34c5 */
        {8,	0}, 	/* 0x34c6 */
        {8,	0}, 	/* 0x34c7 */
        {8,	0}, 	/* 0x34c8 */
        {8,	0}, 	/* 0x34c9 */
        {8,	0}, 	/* 0x34ca */
        {8,	0}, 	/* 0x34cb */
        {8,	0}, 	/* 0x34cc */
        {8,	0}, 	/* 0x34cd */
        {8,	0}, 	/* 0x34ce */
        {8,	0}, 	/* 0x34cf */
        {8,	0}, 	/* 0x34d0 */
        {8,	0}, 	/* 0x34d1 */
        {8,	0}, 	/* 0x34d2 */
        {8,	0}, 	/* 0x34d3 */
        {8,	0}, 	/* 0x34d4 */
        {8,	0}, 	/* 0x34d5 */
        {8,	0}, 	/* 0x34d6 */
        {8,	0}, 	/* 0x34d7 */
        {8,	0}, 	/* 0x34d8 */
        {8,	0}, 	/* 0x34d9 */
        {8,	0}, 	/* 0x34da */
        {8,	0}, 	/* 0x34db */
        {8,	0}, 	/* 0x34dc */
        {8,	0}, 	/* 0x34dd */
        {8,	0}, 	/* 0x34de */
        {8,	0}, 	/* 0x34df */
        {8,	0}, 	/* 0x34e0 */
        {8,	0}, 	/* 0x34e1 */
        {8,	0}, 	/* 0x34e2 */
        {8,	0}, 	/* 0x34e3 */
        {8,	0}, 	/* 0x34e4 */
        {8,	0}, 	/* 0x34e5 */
        {8,	0}, 	/* 0x34e6 */
        {8,	0}, 	/* 0x34e7 */
        {8,	0}, 	/* 0x34e8 */
        {8,	0}, 	/* 0x34e9 */
        {8,	0}, 	/* 0x34ea */
        {8,	0}, 	/* 0x34eb */
        {8,	0}, 	/* 0x34ec */
        {8,	0}, 	/* 0x34ed */
        {8,	0}, 	/* 0x34ee */
        {8,	0}, 	/* 0x34ef */
        {8,	0}, 	/* 0x34f0 */
        {8,	0}, 	/* 0x34f1 */
        {8,	0}, 	/* 0x34f2 */
        {8,	0}, 	/* 0x34f3 */
        {8,	0}, 	/* 0x34f4 */
        {8,	0}, 	/* 0x34f5 */
        {8,	0}, 	/* 0x34f6 */
        {8,	0}, 	/* 0x34f7 */
        {8,	0}, 	/* 0x34f8 */
        {8,	0}, 	/* 0x34f9 */
        {8,	0}, 	/* 0x34fa */
        {8,	0}, 	/* 0x34fb */
        {8,	0}, 	/* 0x34fc */
        {8,	0}, 	/* 0x34fd */
        {8,	0}, 	/* 0x34fe */
        {8,	0}, 	/* 0x34ff */
        {8,	0}, 	/* 0x3500 */
        {8,	0}, 	/* 0x3501 */
        {8,	0}, 	/* 0x3502 */
        {8,	0}, 	/* 0x3503 */
        {8,	0}, 	/* 0x3504 */
        {8,	0}, 	/* 0x3505 */
        {8,	0}, 	/* 0x3506 */
        {8,	0}, 	/* 0x3507 */
        {8,	0}, 	/* 0x3508 */
        {8,	0}, 	/* 0x3509 */
        {8,	0}, 	/* 0x350a */
        {8,	0}, 	/* 0x350b */
        {8,	0}, 	/* 0x350c */
        {8,	0}, 	/* 0x350d */
        {8,	0}, 	/* 0x350e */
        {8,	0}, 	/* 0x350f */
        {8,	0}, 	/* 0x3510 */
        {8,	0}, 	/* 0x3511 */
        {8,	0}, 	/* 0x3512 */
        {8,	0}, 	/* 0x3513 */
        {8,	0}, 	/* 0x3514 */
        {8,	0}, 	/* 0x3515 */
        {8,	0}, 	/* 0x3516 */
        {8,	0}, 	/* 0x3517 */
        {8,	0}, 	/* 0x3518 */
        {8,	0}, 	/* 0x3519 */
        {8,	0}, 	/* 0x351a */
        {8,	0}, 	/* 0x351b */
        {8,	0}, 	/* 0x351c */
        {8,	0}, 	/* 0x351d */
        {8,	0}, 	/* 0x351e */
        {8,	0}, 	/* 0x351f */
        {8,	0}, 	/* 0x3520 */
        {8,	0}, 	/* 0x3521 */
        {8,	0}, 	/* 0x3522 */
        {8,	0}, 	/* 0x3523 */
        {8,	0}, 	/* 0x3524 */
        {8,	0}, 	/* 0x3525 */
        {8,	0}, 	/* 0x3526 */
        {8,	0}, 	/* 0x3527 */
        {8,	0}, 	/* 0x3528 */
        {8,	0}, 	/* 0x3529 */
        {8,	0}, 	/* 0x352a */
        {8,	0}, 	/* 0x352b */
        {8,	0}, 	/* 0x352c */
        {8,	0}, 	/* 0x352d */
        {8,	0}, 	/* 0x352e */
        {8,	0}, 	/* 0x352f */
        {8,	0}, 	/* 0x3530 */
        {8,	0}, 	/* 0x3531 */
        {8,	0}, 	/* 0x3532 */
        {8,	0}, 	/* 0x3533 */
        {8,	0}, 	/* 0x3534 */
        {8,	0}, 	/* 0x3535 */
        {8,	0}, 	/* 0x3536 */
        {8,	0}, 	/* 0x3537 */
        {8,	0}, 	/* 0x3538 */
        {8,	0}, 	/* 0x3539 */
        {8,	0}, 	/* 0x353a */
        {8,	0}, 	/* 0x353b */
        {8,	0}, 	/* 0x353c */
        {8,	0}, 	/* 0x353d */
        {8,	0}, 	/* 0x353e */
        {8,	0}, 	/* 0x353f */
        {8,	0}, 	/* 0x3540 */
        {8,	0}, 	/* 0x3541 */
        {8,	0}, 	/* 0x3542 */
        {8,	0}, 	/* 0x3543 */
        {8,	0}, 	/* 0x3544 */
        {8,	0}, 	/* 0x3545 */
        {8,	0}, 	/* 0x3546 */
        {8,	0}, 	/* 0x3547 */
        {8,	0}, 	/* 0x3548 */
        {8,	0}, 	/* 0x3549 */
        {8,	0}, 	/* 0x354a */
        {8,	0}, 	/* 0x354b */
        {8,	0}, 	/* 0x354c */
        {8,	0}, 	/* 0x354d */
        {8,	0}, 	/* 0x354e */
        {8,	0}, 	/* 0x354f */
        {8,	0}, 	/* 0x3550 */
        {8,	0}, 	/* 0x3551 */
        {8,	0}, 	/* 0x3552 */
        {8,	0}, 	/* 0x3553 */
        {8,	0}, 	/* 0x3554 */
        {8,	0}, 	/* 0x3555 */
        {8,	0}, 	/* 0x3556 */
        {8,	0}, 	/* 0x3557 */
        {8,	0}, 	/* 0x3558 */
        {8,	0}, 	/* 0x3559 */
        {8,	0}, 	/* 0x355a */
        {8,	0}, 	/* 0x355b */
        {8,	0}, 	/* 0x355c */
        {8,	0}, 	/* 0x355d */
        {8,	0}, 	/* 0x355e */
        {8,	0}, 	/* 0x355f */
        {8,	0}, 	/* 0x3560 */
        {8,	0}, 	/* 0x3561 */
        {8,	0}, 	/* 0x3562 */
        {8,	0}, 	/* 0x3563 */
        {8,	0}, 	/* 0x3564 */
        {8,	0}, 	/* 0x3565 */
        {8,	0}, 	/* 0x3566 */
        {8,	0}, 	/* 0x3567 */
        {8,	0}, 	/* 0x3568 */
        {8,	0}, 	/* 0x3569 */
        {8,	0}, 	/* 0x356a */
        {8,	0}, 	/* 0x356b */
        {8,	0}, 	/* 0x356c */
        {8,	0}, 	/* 0x356d */
        {8,	0}, 	/* 0x356e */
        {8,	0}, 	/* 0x356f */
        {8,	0}, 	/* 0x3570 */
        {8,	0}, 	/* 0x3571 */
        {8,	0}, 	/* 0x3572 */
        {8,	0}, 	/* 0x3573 */
        {8,	0}, 	/* 0x3574 */
        {8,	0}, 	/* 0x3575 */
        {8,	0}, 	/* 0x3576 */
        {8,	0}, 	/* 0x3577 */
        {8,	0}, 	/* 0x3578 */
        {8,	0}, 	/* 0x3579 */
        {8,	0}, 	/* 0x357a */
        {8,	0}, 	/* 0x357b */
        {8,	0}, 	/* 0x357c */
        {8,	0}, 	/* 0x357d */
        {8,	0}, 	/* 0x357e */
        {8,	0}, 	/* 0x357f */
        {8,	0}, 	/* 0x3580 */
        {8,	0}, 	/* 0x3581 */
        {8,	0}, 	/* 0x3582 */
        {8,	0}, 	/* 0x3583 */
        {8,	0}, 	/* 0x3584 */
        {8,	0}, 	/* 0x3585 */
        {8,	0}, 	/* 0x3586 */
        {8,	0}, 	/* 0x3587 */
        {8,	0}, 	/* 0x3588 */
        {8,	0}, 	/* 0x3589 */
        {8,	0}, 	/* 0x358a */
        {8,	0}, 	/* 0x358b */
        {8,	0}, 	/* 0x358c */
        {8,	0}, 	/* 0x358d */
        {8,	0}, 	/* 0x358e */
        {8,	0}, 	/* 0x358f */
        {8,	0}, 	/* 0x3590 */
        {8,	0}, 	/* 0x3591 */
        {8,	0}, 	/* 0x3592 */
        {8,	0}, 	/* 0x3593 */
        {8,	0}, 	/* 0x3594 */
        {8,	0}, 	/* 0x3595 */
        {8,	0}, 	/* 0x3596 */
        {8,	0}, 	/* 0x3597 */
        {8,	0}, 	/* 0x3598 */
        {8,	0}, 	/* 0x3599 */
        {8,	0}, 	/* 0x359a */
        {8,	0}, 	/* 0x359b */
        {8,	0}, 	/* 0x359c */
        {8,	0}, 	/* 0x359d */
        {8,	0}, 	/* 0x359e */
        {8,	0}, 	/* 0x359f */
        {8,	0}, 	/* 0x35a0 */
        {8,	0}, 	/* 0x35a1 */
        {8,	0}, 	/* 0x35a2 */
        {8,	0}, 	/* 0x35a3 */
        {8,	0}, 	/* 0x35a4 */
        {8,	0}, 	/* 0x35a5 */
        {8,	0}, 	/* 0x35a6 */
        {8,	0}, 	/* 0x35a7 */
        {8,	0}, 	/* 0x35a8 */
        {8,	0}, 	/* 0x35a9 */
        {8,	0}, 	/* 0x35aa */
        {8,	0}, 	/* 0x35ab */
        {8,	0}, 	/* 0x35ac */
        {8,	0}, 	/* 0x35ad */
        {8,	0}, 	/* 0x35ae */
        {8,	0}, 	/* 0x35af */
        {8,	0}, 	/* 0x35b0 */
        {8,	0}, 	/* 0x35b1 */
        {8,	0}, 	/* 0x35b2 */
        {8,	0}, 	/* 0x35b3 */
        {8,	0}, 	/* 0x35b4 */
        {8,	0}, 	/* 0x35b5 */
        {8,	0}, 	/* 0x35b6 */
        {8,	0}, 	/* 0x35b7 */
        {8,	0}, 	/* 0x35b8 */
        {8,	0}, 	/* 0x35b9 */
        {8,	0}, 	/* 0x35ba */
        {8,	0}, 	/* 0x35bb */
        {8,	0}, 	/* 0x35bc */
        {8,	0}, 	/* 0x35bd */
        {8,	0}, 	/* 0x35be */
        {8,	0}, 	/* 0x35bf */
        {8,	0}, 	/* 0x35c0 */
        {8,	0}, 	/* 0x35c1 */
        {8,	0}, 	/* 0x35c2 */
        {8,	0}, 	/* 0x35c3 */
        {8,	0}, 	/* 0x35c4 */
        {8,	0}, 	/* 0x35c5 */
        {8,	0}, 	/* 0x35c6 */
        {8,	0}, 	/* 0x35c7 */
        {8,	0}, 	/* 0x35c8 */
        {8,	0}, 	/* 0x35c9 */
        {8,	0}, 	/* 0x35ca */
        {8,	0}, 	/* 0x35cb */
        {8,	0}, 	/* 0x35cc */
        {8,	0}, 	/* 0x35cd */
        {8,	0}, 	/* 0x35ce */
        {8,	0}, 	/* 0x35cf */
        {8,	0}, 	/* 0x35d0 */
        {8,	0}, 	/* 0x35d1 */
        {8,	0}, 	/* 0x35d2 */
        {8,	0}, 	/* 0x35d3 */
        {8,	0}, 	/* 0x35d4 */
        {8,	0}, 	/* 0x35d5 */
        {8,	0}, 	/* 0x35d6 */
        {8,	0}, 	/* 0x35d7 */
        {8,	0}, 	/* 0x35d8 */
        {8,	0}, 	/* 0x35d9 */
        {8,	0}, 	/* 0x35da */
        {8,	0}, 	/* 0x35db */
        {8,	0}, 	/* 0x35dc */
        {8,	0}, 	/* 0x35dd */
        {8,	0}, 	/* 0x35de */
        {8,	0}, 	/* 0x35df */
        {8,	0}, 	/* 0x35e0 */
        {8,	0}, 	/* 0x35e1 */
        {8,	0}, 	/* 0x35e2 */
        {8,	0}, 	/* 0x35e3 */
        {8,	0}, 	/* 0x35e4 */
        {8,	0}, 	/* 0x35e5 */
        {8,	0}, 	/* 0x35e6 */
        {8,	0}, 	/* 0x35e7 */
        {8,	0}, 	/* 0x35e8 */
        {8,	0}, 	/* 0x35e9 */
        {8,	0}, 	/* 0x35ea */
        {8,	0}, 	/* 0x35eb */
        {8,	0}, 	/* 0x35ec */
        {8,	0}, 	/* 0x35ed */
        {8,	0}, 	/* 0x35ee */
        {8,	0}, 	/* 0x35ef */
        {8,	0}, 	/* 0x35f0 */
        {8,	0}, 	/* 0x35f1 */
        {8,	0}, 	/* 0x35f2 */
        {8,	0}, 	/* 0x35f3 */
        {8,	0}, 	/* 0x35f4 */
        {8,	0}, 	/* 0x35f5 */
        {8,	0}, 	/* 0x35f6 */
        {8,	0}, 	/* 0x35f7 */
        {8,	0}, 	/* 0x35f8 */
        {8,	0}, 	/* 0x35f9 */
        {8,	0}, 	/* 0x35fa */
        {8,	0}, 	/* 0x35fb */
        {8,	0}, 	/* 0x35fc */
        {8,	0}, 	/* 0x35fd */
        {8,	0}, 	/* 0x35fe */
        {8,	0}, 	/* 0x35ff */
        {8,	0}, 	/* 0x3600 */
        {8,	0}, 	/* 0x3601 */
        {8,	0}, 	/* 0x3602 */
        {8,	0}, 	/* 0x3603 */
        {8,	0}, 	/* 0x3604 */
        {8,	0}, 	/* 0x3605 */
        {8,	0}, 	/* 0x3606 */
        {8,	0}, 	/* 0x3607 */
        {8,	0}, 	/* 0x3608 */
        {8,	0}, 	/* 0x3609 */
        {8,	0}, 	/* 0x360a */
        {8,	0}, 	/* 0x360b */
        {8,	0}, 	/* 0x360c */
        {8,	0}, 	/* 0x360d */
        {8,	0}, 	/* 0x360e */
        {8,	0}, 	/* 0x360f */
        {8,	0}, 	/* 0x3610 */
        {8,	0}, 	/* 0x3611 */
        {8,	0}, 	/* 0x3612 */
        {8,	0}, 	/* 0x3613 */
        {8,	0}, 	/* 0x3614 */
        {8,	0}, 	/* 0x3615 */
        {8,	0}, 	/* 0x3616 */
        {8,	0}, 	/* 0x3617 */
        {8,	0}, 	/* 0x3618 */
        {8,	0}, 	/* 0x3619 */
        {8,	0}, 	/* 0x361a */
        {8,	0}, 	/* 0x361b */
        {8,	0}, 	/* 0x361c */
        {8,	0}, 	/* 0x361d */
        {8,	0}, 	/* 0x361e */
        {8,	0}, 	/* 0x361f */
        {8,	0}, 	/* 0x3620 */
        {8,	0}, 	/* 0x3621 */
        {8,	0}, 	/* 0x3622 */
        {8,	0}, 	/* 0x3623 */
        {8,	0}, 	/* 0x3624 */
        {8,	0}, 	/* 0x3625 */
        {8,	0}, 	/* 0x3626 */
        {8,	0}, 	/* 0x3627 */
        {8,	0}, 	/* 0x3628 */
        {8,	0}, 	/* 0x3629 */
        {8,	0}, 	/* 0x362a */
        {8,	0}, 	/* 0x362b */
        {8,	0}, 	/* 0x362c */
        {8,	0}, 	/* 0x362d */
        {8,	0}, 	/* 0x362e */
        {8,	0}, 	/* 0x362f */
        {8,	0}, 	/* 0x3630 */
        {8,	0}, 	/* 0x3631 */
        {8,	0}, 	/* 0x3632 */
        {8,	0}, 	/* 0x3633 */
        {8,	0}, 	/* 0x3634 */
        {8,	0}, 	/* 0x3635 */
        {8,	0}, 	/* 0x3636 */
        {8,	0}, 	/* 0x3637 */
        {8,	0}, 	/* 0x3638 */
        {8,	0}, 	/* 0x3639 */
        {8,	0}, 	/* 0x363a */
        {8,	0}, 	/* 0x363b */
        {8,	0}, 	/* 0x363c */
        {8,	0}, 	/* 0x363d */
        {8,	0}, 	/* 0x363e */
        {8,	0}, 	/* 0x363f */
        {8,	0}, 	/* 0x3640 */
        {8,	0}, 	/* 0x3641 */
        {8,	0}, 	/* 0x3642 */
        {8,	0}, 	/* 0x3643 */
        {8,	0}, 	/* 0x3644 */
        {8,	0}, 	/* 0x3645 */
        {8,	0}, 	/* 0x3646 */
        {8,	0}, 	/* 0x3647 */
        {8,	0}, 	/* 0x3648 */
        {8,	0}, 	/* 0x3649 */
        {8,	0}, 	/* 0x364a */
        {8,	0}, 	/* 0x364b */
        {8,	0}, 	/* 0x364c */
        {8,	0}, 	/* 0x364d */
        {8,	0}, 	/* 0x364e */
        {8,	0}, 	/* 0x364f */
        {8,	0}, 	/* 0x3650 */
        {8,	0}, 	/* 0x3651 */
        {8,	0}, 	/* 0x3652 */
        {8,	0}, 	/* 0x3653 */
        {8,	0}, 	/* 0x3654 */
        {8,	0}, 	/* 0x3655 */
        {8,	0}, 	/* 0x3656 */
        {8,	0}, 	/* 0x3657 */
        {8,	0}, 	/* 0x3658 */
        {8,	0}, 	/* 0x3659 */
        {8,	0}, 	/* 0x365a */
        {8,	0}, 	/* 0x365b */
        {8,	0}, 	/* 0x365c */
        {8,	0}, 	/* 0x365d */
        {8,	0}, 	/* 0x365e */
        {8,	0}, 	/* 0x365f */
        {8,	0}, 	/* 0x3660 */
        {8,	0}, 	/* 0x3661 */
        {8,	0}, 	/* 0x3662 */
        {8,	0}, 	/* 0x3663 */
        {8,	0}, 	/* 0x3664 */
        {8,	0}, 	/* 0x3665 */
        {8,	0}, 	/* 0x3666 */
        {8,	0}, 	/* 0x3667 */
        {8,	0}, 	/* 0x3668 */
        {8,	0}, 	/* 0x3669 */
        {8,	0}, 	/* 0x366a */
        {8,	0}, 	/* 0x366b */
        {8,	0}, 	/* 0x366c */
        {8,	0}, 	/* 0x366d */
        {8,	0}, 	/* 0x366e */
        {8,	0}, 	/* 0x366f */
        {8,	0}, 	/* 0x3670 */
        {8,	0}, 	/* 0x3671 */
        {8,	0}, 	/* 0x3672 */
        {8,	0}, 	/* 0x3673 */
        {8,	0}, 	/* 0x3674 */
        {8,	0}, 	/* 0x3675 */
        {8,	0}, 	/* 0x3676 */
        {8,	0}, 	/* 0x3677 */
        {8,	0}, 	/* 0x3678 */
        {8,	0}, 	/* 0x3679 */
        {8,	0}, 	/* 0x367a */
        {8,	0}, 	/* 0x367b */
        {8,	0}, 	/* 0x367c */
        {8,	0}, 	/* 0x367d */
        {8,	0}, 	/* 0x367e */
        {8,	0}, 	/* 0x367f */
        {8,	0}, 	/* 0x3680 */
        {8,	0}, 	/* 0x3681 */
        {8,	0}, 	/* 0x3682 */
        {8,	0}, 	/* 0x3683 */
        {8,	0}, 	/* 0x3684 */
        {8,	0}, 	/* 0x3685 */
        {8,	0}, 	/* 0x3686 */
        {8,	0}, 	/* 0x3687 */
        {8,	0}, 	/* 0x3688 */
        {8,	0}, 	/* 0x3689 */
        {8,	0}, 	/* 0x368a */
        {8,	0}, 	/* 0x368b */
        {8,	0}, 	/* 0x368c */
        {8,	0}, 	/* 0x368d */
        {8,	0}, 	/* 0x368e */
        {8,	0}, 	/* 0x368f */
        {8,	0}, 	/* 0x3690 */
        {8,	0}, 	/* 0x3691 */
        {8,	0}, 	/* 0x3692 */
        {8,	0}, 	/* 0x3693 */
        {8,	0}, 	/* 0x3694 */
        {8,	0}, 	/* 0x3695 */
        {8,	0}, 	/* 0x3696 */
        {8,	0}, 	/* 0x3697 */
        {8,	0}, 	/* 0x3698 */
        {8,	0}, 	/* 0x3699 */
        {8,	0}, 	/* 0x369a */
        {8,	0}, 	/* 0x369b */
        {8,	0}, 	/* 0x369c */
        {8,	0}, 	/* 0x369d */
        {8,	0}, 	/* 0x369e */
        {8,	0}, 	/* 0x369f */
        {8,	0}, 	/* 0x36a0 */
        {8,	0}, 	/* 0x36a1 */
        {8,	0}, 	/* 0x36a2 */
        {8,	0}, 	/* 0x36a3 */
        {8,	0}, 	/* 0x36a4 */
        {8,	0}, 	/* 0x36a5 */
        {8,	0}, 	/* 0x36a6 */
        {8,	0}, 	/* 0x36a7 */
        {8,	0}, 	/* 0x36a8 */
        {8,	0}, 	/* 0x36a9 */
        {8,	0}, 	/* 0x36aa */
        {8,	0}, 	/* 0x36ab */
        {8,	0}, 	/* 0x36ac */
        {8,	0}, 	/* 0x36ad */
        {8,	0}, 	/* 0x36ae */
        {8,	0}, 	/* 0x36af */
        {8,	0}, 	/* 0x36b0 */
        {8,	0}, 	/* 0x36b1 */
        {8,	0}, 	/* 0x36b2 */
        {8,	0}, 	/* 0x36b3 */
        {8,	0}, 	/* 0x36b4 */
        {8,	0}, 	/* 0x36b5 */
        {8,	0}, 	/* 0x36b6 */
        {8,	0}, 	/* 0x36b7 */
        {8,	0}, 	/* 0x36b8 */
        {8,	0}, 	/* 0x36b9 */
        {8,	0}, 	/* 0x36ba */
        {8,	0}, 	/* 0x36bb */
        {8,	0}, 	/* 0x36bc */
        {8,	0}, 	/* 0x36bd */
        {8,	0}, 	/* 0x36be */
        {8,	0}, 	/* 0x36bf */
        {8,	0}, 	/* 0x36c0 */
        {8,	0}, 	/* 0x36c1 */
        {8,	0}, 	/* 0x36c2 */
        {8,	0}, 	/* 0x36c3 */
        {8,	0}, 	/* 0x36c4 */
        {8,	0}, 	/* 0x36c5 */
        {8,	0}, 	/* 0x36c6 */
        {8,	0}, 	/* 0x36c7 */
        {8,	0}, 	/* 0x36c8 */
        {8,	0}, 	/* 0x36c9 */
        {8,	0}, 	/* 0x36ca */
        {8,	0}, 	/* 0x36cb */
        {8,	0}, 	/* 0x36cc */
        {8,	0}, 	/* 0x36cd */
        {8,	0}, 	/* 0x36ce */
        {8,	0}, 	/* 0x36cf */
        {8,	0}, 	/* 0x36d0 */
        {8,	0}, 	/* 0x36d1 */
        {8,	0}, 	/* 0x36d2 */
        {8,	0}, 	/* 0x36d3 */
        {8,	0}, 	/* 0x36d4 */
        {8,	0}, 	/* 0x36d5 */
        {8,	0}, 	/* 0x36d6 */
        {8,	0}, 	/* 0x36d7 */
        {8,	0}, 	/* 0x36d8 */
        {8,	0}, 	/* 0x36d9 */
        {8,	0}, 	/* 0x36da */
        {8,	0}, 	/* 0x36db */
        {8,	0}, 	/* 0x36dc */
        {8,	0}, 	/* 0x36dd */
        {8,	0}, 	/* 0x36de */
        {8,	0}, 	/* 0x36df */
        {8,	0}, 	/* 0x36e0 */
        {8,	0}, 	/* 0x36e1 */
        {8,	0}, 	/* 0x36e2 */
        {8,	0}, 	/* 0x36e3 */
        {8,	0}, 	/* 0x36e4 */
        {8,	0}, 	/* 0x36e5 */
        {8,	0}, 	/* 0x36e6 */
        {8,	0}, 	/* 0x36e7 */
        {8,	0}, 	/* 0x36e8 */
        {8,	0}, 	/* 0x36e9 */
        {8,	0}, 	/* 0x36ea */
        {8,	0}, 	/* 0x36eb */
        {8,	0}, 	/* 0x36ec */
        {8,	0}, 	/* 0x36ed */
        {8,	0}, 	/* 0x36ee */
        {8,	0}, 	/* 0x36ef */
        {8,	0}, 	/* 0x36f0 */
        {8,	0}, 	/* 0x36f1 */
        {8,	0}, 	/* 0x36f2 */
        {8,	0}, 	/* 0x36f3 */
        {8,	0}, 	/* 0x36f4 */
        {8,	0}, 	/* 0x36f5 */
        {8,	0}, 	/* 0x36f6 */
        {8,	0}, 	/* 0x36f7 */
        {8,	0}, 	/* 0x36f8 */
        {8,	0}, 	/* 0x36f9 */
        {8,	0}, 	/* 0x36fa */
        {8,	0}, 	/* 0x36fb */
        {8,	0}, 	/* 0x36fc */
        {8,	0}, 	/* 0x36fd */
        {8,	0}, 	/* 0x36fe */
        {8,	0}, 	/* 0x36ff */
        {8,	0}, 	/* 0x3700 */
        {8,	0}, 	/* 0x3701 */
        {8,	0}, 	/* 0x3702 */
        {8,	0}, 	/* 0x3703 */
        {8,	0}, 	/* 0x3704 */
        {8,	0}, 	/* 0x3705 */
        {8,	0}, 	/* 0x3706 */
        {8,	0}, 	/* 0x3707 */
        {8,	0}, 	/* 0x3708 */
        {8,	0}, 	/* 0x3709 */
        {8,	0}, 	/* 0x370a */
        {8,	0}, 	/* 0x370b */
        {8,	0}, 	/* 0x370c */
        {8,	0}, 	/* 0x370d */
        {8,	0}, 	/* 0x370e */
        {8,	0}, 	/* 0x370f */
        {8,	0}, 	/* 0x3710 */
        {8,	0}, 	/* 0x3711 */
        {8,	0}, 	/* 0x3712 */
        {8,	0}, 	/* 0x3713 */
        {8,	0}, 	/* 0x3714 */
        {8,	0}, 	/* 0x3715 */
        {8,	0}, 	/* 0x3716 */
        {8,	0}, 	/* 0x3717 */
        {8,	0}, 	/* 0x3718 */
        {8,	0}, 	/* 0x3719 */
        {8,	0}, 	/* 0x371a */
        {8,	0}, 	/* 0x371b */
        {8,	0}, 	/* 0x371c */
        {8,	0}, 	/* 0x371d */
        {8,	0}, 	/* 0x371e */
        {8,	0}, 	/* 0x371f */
        {8,	0}, 	/* 0x3720 */
        {8,	0}, 	/* 0x3721 */
        {8,	0}, 	/* 0x3722 */
        {8,	0}, 	/* 0x3723 */
        {8,	0}, 	/* 0x3724 */
        {8,	0}, 	/* 0x3725 */
        {8,	0}, 	/* 0x3726 */
        {8,	0}, 	/* 0x3727 */
        {8,	0}, 	/* 0x3728 */
        {8,	0}, 	/* 0x3729 */
        {8,	0}, 	/* 0x372a */
        {8,	0}, 	/* 0x372b */
        {8,	0}, 	/* 0x372c */
        {8,	0}, 	/* 0x372d */
        {8,	0}, 	/* 0x372e */
        {8,	0}, 	/* 0x372f */
        {8,	0}, 	/* 0x3730 */
        {8,	0}, 	/* 0x3731 */
        {8,	0}, 	/* 0x3732 */
        {8,	0}, 	/* 0x3733 */
        {8,	0}, 	/* 0x3734 */
        {8,	0}, 	/* 0x3735 */
        {8,	0}, 	/* 0x3736 */
        {8,	0}, 	/* 0x3737 */
        {8,	0}, 	/* 0x3738 */
        {8,	0}, 	/* 0x3739 */
        {8,	0}, 	/* 0x373a */
        {8,	0}, 	/* 0x373b */
        {8,	0}, 	/* 0x373c */
        {8,	0}, 	/* 0x373d */
        {8,	0}, 	/* 0x373e */
        {8,	0}, 	/* 0x373f */
        {8,	0}, 	/* 0x3740 */
        {8,	0}, 	/* 0x3741 */
        {8,	0}, 	/* 0x3742 */
        {8,	0}, 	/* 0x3743 */
        {8,	0}, 	/* 0x3744 */
        {8,	0}, 	/* 0x3745 */
        {8,	0}, 	/* 0x3746 */
        {8,	0}, 	/* 0x3747 */
        {8,	0}, 	/* 0x3748 */
        {8,	0}, 	/* 0x3749 */
        {8,	0}, 	/* 0x374a */
        {8,	0}, 	/* 0x374b */
        {8,	0}, 	/* 0x374c */
        {8,	0}, 	/* 0x374d */
        {8,	0}, 	/* 0x374e */
        {8,	0}, 	/* 0x374f */
        {8,	0}, 	/* 0x3750 */
        {8,	0}, 	/* 0x3751 */
        {8,	0}, 	/* 0x3752 */
        {8,	0}, 	/* 0x3753 */
        {8,	0}, 	/* 0x3754 */
        {8,	0}, 	/* 0x3755 */
        {8,	0}, 	/* 0x3756 */
        {8,	0}, 	/* 0x3757 */
        {8,	0}, 	/* 0x3758 */
        {8,	0}, 	/* 0x3759 */
        {8,	0}, 	/* 0x375a */
        {8,	0}, 	/* 0x375b */
        {8,	0}, 	/* 0x375c */
        {8,	0}, 	/* 0x375d */
        {8,	0}, 	/* 0x375e */
        {8,	0}, 	/* 0x375f */
        {8,	0}, 	/* 0x3760 */
        {8,	0}, 	/* 0x3761 */
        {8,	0}, 	/* 0x3762 */
        {8,	0}, 	/* 0x3763 */
        {8,	0}, 	/* 0x3764 */
        {8,	0}, 	/* 0x3765 */
        {8,	0}, 	/* 0x3766 */
        {8,	0}, 	/* 0x3767 */
        {8,	0}, 	/* 0x3768 */
        {8,	0}, 	/* 0x3769 */
        {8,	0}, 	/* 0x376a */
        {8,	0}, 	/* 0x376b */
        {8,	0}, 	/* 0x376c */
        {8,	0}, 	/* 0x376d */
        {8,	0}, 	/* 0x376e */
        {8,	0}, 	/* 0x376f */
        {8,	0}, 	/* 0x3770 */
        {8,	0}, 	/* 0x3771 */
        {8,	0}, 	/* 0x3772 */
        {8,	0}, 	/* 0x3773 */
        {8,	0}, 	/* 0x3774 */
        {8,	0}, 	/* 0x3775 */
        {8,	0}, 	/* 0x3776 */
        {8,	0}, 	/* 0x3777 */
        {8,	0}, 	/* 0x3778 */
        {8,	0}, 	/* 0x3779 */
        {8,	0}, 	/* 0x377a */
        {8,	0}, 	/* 0x377b */
        {8,	0}, 	/* 0x377c */
        {8,	0}, 	/* 0x377d */
        {8,	0}, 	/* 0x377e */
        {8,	0}, 	/* 0x377f */
        {8,	0}, 	/* 0x3780 */
        {8,	0}, 	/* 0x3781 */
        {8,	0}, 	/* 0x3782 */
        {8,	0}, 	/* 0x3783 */
        {8,	0}, 	/* 0x3784 */
        {8,	0}, 	/* 0x3785 */
        {8,	0}, 	/* 0x3786 */
        {8,	0}, 	/* 0x3787 */
        {8,	0}, 	/* 0x3788 */
        {8,	0}, 	/* 0x3789 */
        {8,	0}, 	/* 0x378a */
        {8,	0}, 	/* 0x378b */
        {8,	0}, 	/* 0x378c */
        {8,	0}, 	/* 0x378d */
        {8,	0}, 	/* 0x378e */
        {8,	0}, 	/* 0x378f */
        {8,	0}, 	/* 0x3790 */
        {8,	0}, 	/* 0x3791 */
        {8,	0}, 	/* 0x3792 */
        {8,	0}, 	/* 0x3793 */
        {8,	0}, 	/* 0x3794 */
        {8,	0}, 	/* 0x3795 */
        {8,	0}, 	/* 0x3796 */
        {8,	0}, 	/* 0x3797 */
        {8,	0}, 	/* 0x3798 */
        {8,	0}, 	/* 0x3799 */
        {8,	0}, 	/* 0x379a */
        {8,	0}, 	/* 0x379b */
        {8,	0}, 	/* 0x379c */
        {8,	0}, 	/* 0x379d */
        {8,	0}, 	/* 0x379e */
        {8,	0}, 	/* 0x379f */
        {8,	0}, 	/* 0x37a0 */
        {8,	0}, 	/* 0x37a1 */
        {8,	0}, 	/* 0x37a2 */
        {8,	0}, 	/* 0x37a3 */
        {8,	0}, 	/* 0x37a4 */
        {8,	0}, 	/* 0x37a5 */
        {8,	0}, 	/* 0x37a6 */
        {8,	0}, 	/* 0x37a7 */
        {8,	0}, 	/* 0x37a8 */
        {8,	0}, 	/* 0x37a9 */
        {8,	0}, 	/* 0x37aa */
        {8,	0}, 	/* 0x37ab */
        {8,	0}, 	/* 0x37ac */
        {8,	0}, 	/* 0x37ad */
        {8,	0}, 	/* 0x37ae */
        {8,	0}, 	/* 0x37af */
        {8,	0}, 	/* 0x37b0 */
        {8,	0}, 	/* 0x37b1 */
        {8,	0}, 	/* 0x37b2 */
        {8,	0}, 	/* 0x37b3 */
        {8,	0}, 	/* 0x37b4 */
        {8,	0}, 	/* 0x37b5 */
        {8,	0}, 	/* 0x37b6 */
        {8,	0}, 	/* 0x37b7 */
        {8,	0}, 	/* 0x37b8 */
        {8,	0}, 	/* 0x37b9 */
        {8,	0}, 	/* 0x37ba */
        {8,	0}, 	/* 0x37bb */
        {8,	0}, 	/* 0x37bc */
        {8,	0}, 	/* 0x37bd */
        {8,	0}, 	/* 0x37be */
        {8,	0}, 	/* 0x37bf */
        {8,	0}, 	/* 0x37c0 */
        {8,	0}, 	/* 0x37c1 */
        {8,	0}, 	/* 0x37c2 */
        {8,	0}, 	/* 0x37c3 */
        {8,	0}, 	/* 0x37c4 */
        {8,	0}, 	/* 0x37c5 */
        {8,	0}, 	/* 0x37c6 */
        {8,	0}, 	/* 0x37c7 */
        {8,	0}, 	/* 0x37c8 */
        {8,	0}, 	/* 0x37c9 */
        {8,	0}, 	/* 0x37ca */
        {8,	0}, 	/* 0x37cb */
        {8,	0}, 	/* 0x37cc */
        {8,	0}, 	/* 0x37cd */
        {8,	0}, 	/* 0x37ce */
        {8,	0}, 	/* 0x37cf */
        {8,	0}, 	/* 0x37d0 */
        {8,	0}, 	/* 0x37d1 */
        {8,	0}, 	/* 0x37d2 */
        {8,	0}, 	/* 0x37d3 */
        {8,	0}, 	/* 0x37d4 */
        {8,	0}, 	/* 0x37d5 */
        {8,	0}, 	/* 0x37d6 */
        {8,	0}, 	/* 0x37d7 */
        {8,	0}, 	/* 0x37d8 */
        {8,	0}, 	/* 0x37d9 */
        {8,	0}, 	/* 0x37da */
        {8,	0}, 	/* 0x37db */
        {8,	0}, 	/* 0x37dc */
        {8,	0}, 	/* 0x37dd */
        {8,	0}, 	/* 0x37de */
        {8,	0}, 	/* 0x37df */
        {8,	0}, 	/* 0x37e0 */
        {8,	0}, 	/* 0x37e1 */
        {8,	0}, 	/* 0x37e2 */
        {8,	0}, 	/* 0x37e3 */
        {8,	0}, 	/* 0x37e4 */
        {8,	0}, 	/* 0x37e5 */
        {8,	0}, 	/* 0x37e6 */
        {8,	0}, 	/* 0x37e7 */
        {8,	0}, 	/* 0x37e8 */
        {8,	0}, 	/* 0x37e9 */
        {8,	0}, 	/* 0x37ea */
        {8,	0}, 	/* 0x37eb */
        {8,	0}, 	/* 0x37ec */
        {8,	0}, 	/* 0x37ed */
        {8,	0}, 	/* 0x37ee */
        {8,	0}, 	/* 0x37ef */
        {8,	0}, 	/* 0x37f0 */
        {8,	0}, 	/* 0x37f1 */
        {8,	0}, 	/* 0x37f2 */
        {8,	0}, 	/* 0x37f3 */
        {8,	0}, 	/* 0x37f4 */
        {8,	0}, 	/* 0x37f5 */
        {8,	0}, 	/* 0x37f6 */
        {8,	0}, 	/* 0x37f7 */
        {8,	0}, 	/* 0x37f8 */
        {8,	0}, 	/* 0x37f9 */
        {8,	0}, 	/* 0x37fa */
        {8,	0}, 	/* 0x37fb */
        {8,	0}, 	/* 0x37fc */
        {8,	0}, 	/* 0x37fd */
        {8,	0}, 	/* 0x37fe */
        {8,	0}, 	/* 0x37ff */
        {8,	0}, 	/* 0x3800 */
        {8,	0}, 	/* 0x3801 */
        {8,	0}, 	/* 0x3802 */
        {8,	0}, 	/* 0x3803 */
        {8,	0}, 	/* 0x3804 */
        {8,	0}, 	/* 0x3805 */
        {8,	0}, 	/* 0x3806 */
        {8,	0}, 	/* 0x3807 */
        {8,	0}, 	/* 0x3808 */
        {8,	0}, 	/* 0x3809 */
        {8,	0}, 	/* 0x380a */
        {8,	0}, 	/* 0x380b */
        {8,	0}, 	/* 0x380c */
        {8,	0}, 	/* 0x380d */
        {8,	0}, 	/* 0x380e */
        {8,	0}, 	/* 0x380f */
        {8,	0}, 	/* 0x3810 */
        {8,	0}, 	/* 0x3811 */
        {8,	0}, 	/* 0x3812 */
        {8,	0}, 	/* 0x3813 */
        {8,	0}, 	/* 0x3814 */
        {8,	0}, 	/* 0x3815 */
        {8,	0}, 	/* 0x3816 */
        {8,	0}, 	/* 0x3817 */
        {8,	0}, 	/* 0x3818 */
        {8,	0}, 	/* 0x3819 */
        {8,	0}, 	/* 0x381a */
        {8,	0}, 	/* 0x381b */
        {8,	0}, 	/* 0x381c */
        {8,	0}, 	/* 0x381d */
        {8,	0}, 	/* 0x381e */
        {8,	0}, 	/* 0x381f */
        {8,	0}, 	/* 0x3820 */
        {8,	0}, 	/* 0x3821 */
        {8,	0}, 	/* 0x3822 */
        {8,	0}, 	/* 0x3823 */
        {8,	0}, 	/* 0x3824 */
        {8,	0}, 	/* 0x3825 */
        {8,	0}, 	/* 0x3826 */
        {8,	0}, 	/* 0x3827 */
        {8,	0}, 	/* 0x3828 */
        {8,	0}, 	/* 0x3829 */
        {8,	0}, 	/* 0x382a */
        {8,	0}, 	/* 0x382b */
        {8,	0}, 	/* 0x382c */
        {8,	0}, 	/* 0x382d */
        {8,	0}, 	/* 0x382e */
        {8,	0}, 	/* 0x382f */
        {8,	0}, 	/* 0x3830 */
        {8,	0}, 	/* 0x3831 */
        {8,	0}, 	/* 0x3832 */
        {8,	0}, 	/* 0x3833 */
        {8,	0}, 	/* 0x3834 */
        {8,	0}, 	/* 0x3835 */
        {8,	0}, 	/* 0x3836 */
        {8,	0}, 	/* 0x3837 */
        {8,	0}, 	/* 0x3838 */
        {8,	0}, 	/* 0x3839 */
        {8,	0}, 	/* 0x383a */
        {8,	0}, 	/* 0x383b */
        {8,	0}, 	/* 0x383c */
        {8,	0}, 	/* 0x383d */
        {8,	0}, 	/* 0x383e */
        {8,	0}, 	/* 0x383f */
        {8,	0}, 	/* 0x3840 */
        {8,	0}, 	/* 0x3841 */
        {8,	0}, 	/* 0x3842 */
        {8,	0}, 	/* 0x3843 */
        {8,	0}, 	/* 0x3844 */
        {8,	0}, 	/* 0x3845 */
        {8,	0}, 	/* 0x3846 */
        {8,	0}, 	/* 0x3847 */
        {8,	0}, 	/* 0x3848 */
        {8,	0}, 	/* 0x3849 */
        {8,	0}, 	/* 0x384a */
        {8,	0}, 	/* 0x384b */
        {8,	0}, 	/* 0x384c */
        {8,	0}, 	/* 0x384d */
        {8,	0}, 	/* 0x384e */
        {8,	0}, 	/* 0x384f */
        {8,	0}, 	/* 0x3850 */
        {8,	0}, 	/* 0x3851 */
        {8,	0}, 	/* 0x3852 */
        {8,	0}, 	/* 0x3853 */
        {8,	0}, 	/* 0x3854 */
        {8,	0}, 	/* 0x3855 */
        {8,	0}, 	/* 0x3856 */
        {8,	0}, 	/* 0x3857 */
        {8,	0}, 	/* 0x3858 */
        {8,	0}, 	/* 0x3859 */
        {8,	0}, 	/* 0x385a */
        {8,	0}, 	/* 0x385b */
        {8,	0}, 	/* 0x385c */
        {8,	0}, 	/* 0x385d */
        {8,	0}, 	/* 0x385e */
        {8,	0}, 	/* 0x385f */
        {8,	0}, 	/* 0x3860 */
        {8,	0}, 	/* 0x3861 */
        {8,	0}, 	/* 0x3862 */
        {8,	0}, 	/* 0x3863 */
        {8,	0}, 	/* 0x3864 */
        {8,	0}, 	/* 0x3865 */
        {8,	0}, 	/* 0x3866 */
        {8,	0}, 	/* 0x3867 */
        {8,	0}, 	/* 0x3868 */
        {8,	0}, 	/* 0x3869 */
        {8,	0}, 	/* 0x386a */
        {8,	0}, 	/* 0x386b */
        {8,	0}, 	/* 0x386c */
        {8,	0}, 	/* 0x386d */
        {8,	0}, 	/* 0x386e */
        {8,	0}, 	/* 0x386f */
        {8,	0}, 	/* 0x3870 */
        {8,	0}, 	/* 0x3871 */
        {8,	0}, 	/* 0x3872 */
        {8,	0}, 	/* 0x3873 */
        {8,	0}, 	/* 0x3874 */
        {8,	0}, 	/* 0x3875 */
        {8,	0}, 	/* 0x3876 */
        {8,	0}, 	/* 0x3877 */
        {8,	0}, 	/* 0x3878 */
        {8,	0}, 	/* 0x3879 */
        {8,	0}, 	/* 0x387a */
        {8,	0}, 	/* 0x387b */
        {8,	0}, 	/* 0x387c */
        {8,	0}, 	/* 0x387d */
        {8,	0}, 	/* 0x387e */
        {8,	0}, 	/* 0x387f */
        {8,	0}, 	/* 0x3880 */
        {8,	0}, 	/* 0x3881 */
        {8,	0}, 	/* 0x3882 */
        {8,	0}, 	/* 0x3883 */
        {8,	0}, 	/* 0x3884 */
        {8,	0}, 	/* 0x3885 */
        {8,	0}, 	/* 0x3886 */
        {8,	0}, 	/* 0x3887 */
        {8,	0}, 	/* 0x3888 */
        {8,	0}, 	/* 0x3889 */
        {8,	0}, 	/* 0x388a */
        {8,	0}, 	/* 0x388b */
        {8,	0}, 	/* 0x388c */
        {8,	0}, 	/* 0x388d */
        {8,	0}, 	/* 0x388e */
        {8,	0}, 	/* 0x388f */
        {8,	0}, 	/* 0x3890 */
        {8,	0}, 	/* 0x3891 */
        {8,	0}, 	/* 0x3892 */
        {8,	0}, 	/* 0x3893 */
        {8,	0}, 	/* 0x3894 */
        {8,	0}, 	/* 0x3895 */
        {8,	0}, 	/* 0x3896 */
        {8,	0}, 	/* 0x3897 */
        {8,	0}, 	/* 0x3898 */
        {8,	0}, 	/* 0x3899 */
        {8,	0}, 	/* 0x389a */
        {8,	0}, 	/* 0x389b */
        {8,	0}, 	/* 0x389c */
        {8,	0}, 	/* 0x389d */
        {8,	0}, 	/* 0x389e */
        {8,	0}, 	/* 0x389f */
        {8,	0}, 	/* 0x38a0 */
        {8,	0}, 	/* 0x38a1 */
        {8,	0}, 	/* 0x38a2 */
        {8,	0}, 	/* 0x38a3 */
        {8,	0}, 	/* 0x38a4 */
        {8,	0}, 	/* 0x38a5 */
        {8,	0}, 	/* 0x38a6 */
        {8,	0}, 	/* 0x38a7 */
        {8,	0}, 	/* 0x38a8 */
        {8,	0}, 	/* 0x38a9 */
        {8,	0}, 	/* 0x38aa */
        {8,	0}, 	/* 0x38ab */
        {8,	0}, 	/* 0x38ac */
        {8,	0}, 	/* 0x38ad */
        {8,	0}, 	/* 0x38ae */
        {8,	0}, 	/* 0x38af */
        {8,	0}, 	/* 0x38b0 */
        {8,	0}, 	/* 0x38b1 */
        {8,	0}, 	/* 0x38b2 */
        {8,	0}, 	/* 0x38b3 */
        {8,	0}, 	/* 0x38b4 */
        {8,	0}, 	/* 0x38b5 */
        {8,	0}, 	/* 0x38b6 */
        {8,	0}, 	/* 0x38b7 */
        {8,	0}, 	/* 0x38b8 */
        {8,	0}, 	/* 0x38b9 */
        {8,	0}, 	/* 0x38ba */
        {8,	0}, 	/* 0x38bb */
        {8,	0}, 	/* 0x38bc */
        {8,	0}, 	/* 0x38bd */
        {8,	0}, 	/* 0x38be */
        {8,	0}, 	/* 0x38bf */
        {8,	0}, 	/* 0x38c0 */
        {8,	0}, 	/* 0x38c1 */
        {8,	0}, 	/* 0x38c2 */
        {8,	0}, 	/* 0x38c3 */
        {8,	0}, 	/* 0x38c4 */
        {8,	0}, 	/* 0x38c5 */
        {8,	0}, 	/* 0x38c6 */
        {8,	0}, 	/* 0x38c7 */
        {8,	0}, 	/* 0x38c8 */
        {8,	0}, 	/* 0x38c9 */
        {8,	0}, 	/* 0x38ca */
        {8,	0}, 	/* 0x38cb */
        {8,	0}, 	/* 0x38cc */
        {8,	0}, 	/* 0x38cd */
        {8,	0}, 	/* 0x38ce */
        {8,	0}, 	/* 0x38cf */
        {8,	0}, 	/* 0x38d0 */
        {8,	0}, 	/* 0x38d1 */
        {8,	0}, 	/* 0x38d2 */
        {8,	0}, 	/* 0x38d3 */
        {8,	0}, 	/* 0x38d4 */
        {8,	0}, 	/* 0x38d5 */
        {8,	0}, 	/* 0x38d6 */
        {8,	0}, 	/* 0x38d7 */
        {8,	0}, 	/* 0x38d8 */
        {8,	0}, 	/* 0x38d9 */
        {8,	0}, 	/* 0x38da */
        {8,	0}, 	/* 0x38db */
        {8,	0}, 	/* 0x38dc */
        {8,	0}, 	/* 0x38dd */
        {8,	0}, 	/* 0x38de */
        {8,	0}, 	/* 0x38df */
        {8,	0}, 	/* 0x38e0 */
        {8,	0}, 	/* 0x38e1 */
        {8,	0}, 	/* 0x38e2 */
        {8,	0}, 	/* 0x38e3 */
        {8,	0}, 	/* 0x38e4 */
        {8,	0}, 	/* 0x38e5 */
        {8,	0}, 	/* 0x38e6 */
        {8,	0}, 	/* 0x38e7 */
        {8,	0}, 	/* 0x38e8 */
        {8,	0}, 	/* 0x38e9 */
        {8,	0}, 	/* 0x38ea */
        {8,	0}, 	/* 0x38eb */
        {8,	0}, 	/* 0x38ec */
        {8,	0}, 	/* 0x38ed */
        {8,	0}, 	/* 0x38ee */
        {8,	0}, 	/* 0x38ef */
        {8,	0}, 	/* 0x38f0 */
        {8,	0}, 	/* 0x38f1 */
        {8,	0}, 	/* 0x38f2 */
        {8,	0}, 	/* 0x38f3 */
        {8,	0}, 	/* 0x38f4 */
        {8,	0}, 	/* 0x38f5 */
        {8,	0}, 	/* 0x38f6 */
        {8,	0}, 	/* 0x38f7 */
        {8,	0}, 	/* 0x38f8 */
        {8,	0}, 	/* 0x38f9 */
        {8,	0}, 	/* 0x38fa */
        {8,	0}, 	/* 0x38fb */
        {8,	0}, 	/* 0x38fc */
        {8,	0}, 	/* 0x38fd */
        {8,	0}, 	/* 0x38fe */
        {8,	0}, 	/* 0x38ff */
        {8,	0}, 	/* 0x3900 */
        {8,	0}, 	/* 0x3901 */
        {8,	0}, 	/* 0x3902 */
        {8,	0}, 	/* 0x3903 */
        {8,	0}, 	/* 0x3904 */
        {8,	0}, 	/* 0x3905 */
        {8,	0}, 	/* 0x3906 */
        {8,	0}, 	/* 0x3907 */
        {8,	0}, 	/* 0x3908 */
        {8,	0}, 	/* 0x3909 */
        {8,	0}, 	/* 0x390a */
        {8,	0}, 	/* 0x390b */
        {8,	0}, 	/* 0x390c */
        {8,	0}, 	/* 0x390d */
        {8,	0}, 	/* 0x390e */
        {8,	0}, 	/* 0x390f */
        {8,	0}, 	/* 0x3910 */
        {8,	0}, 	/* 0x3911 */
        {8,	0}, 	/* 0x3912 */
        {8,	0}, 	/* 0x3913 */
        {8,	0}, 	/* 0x3914 */
        {8,	0}, 	/* 0x3915 */
        {8,	0}, 	/* 0x3916 */
        {8,	0}, 	/* 0x3917 */
        {8,	0}, 	/* 0x3918 */
        {8,	0}, 	/* 0x3919 */
        {8,	0}, 	/* 0x391a */
        {8,	0}, 	/* 0x391b */
        {8,	0}, 	/* 0x391c */
        {8,	0}, 	/* 0x391d */
        {8,	0}, 	/* 0x391e */
        {8,	0}, 	/* 0x391f */
        {8,	0}, 	/* 0x3920 */
        {8,	0}, 	/* 0x3921 */
        {8,	0}, 	/* 0x3922 */
        {8,	0}, 	/* 0x3923 */
        {8,	0}, 	/* 0x3924 */
        {8,	0}, 	/* 0x3925 */
        {8,	0}, 	/* 0x3926 */
        {8,	0}, 	/* 0x3927 */
        {8,	0}, 	/* 0x3928 */
        {8,	0}, 	/* 0x3929 */
        {8,	0}, 	/* 0x392a */
        {8,	0}, 	/* 0x392b */
        {8,	0}, 	/* 0x392c */
        {8,	0}, 	/* 0x392d */
        {8,	0}, 	/* 0x392e */
        {8,	0}, 	/* 0x392f */
        {8,	0}, 	/* 0x3930 */
        {8,	0}, 	/* 0x3931 */
        {8,	0}, 	/* 0x3932 */
        {8,	0}, 	/* 0x3933 */
        {8,	0}, 	/* 0x3934 */
        {8,	0}, 	/* 0x3935 */
        {8,	0}, 	/* 0x3936 */
        {8,	0}, 	/* 0x3937 */
        {8,	0}, 	/* 0x3938 */
        {8,	0}, 	/* 0x3939 */
        {8,	0}, 	/* 0x393a */
        {8,	0}, 	/* 0x393b */
        {8,	0}, 	/* 0x393c */
        {8,	0}, 	/* 0x393d */
        {8,	0}, 	/* 0x393e */
        {8,	0}, 	/* 0x393f */
        {8,	0}, 	/* 0x3940 */
        {8,	0}, 	/* 0x3941 */
        {8,	0}, 	/* 0x3942 */
        {8,	0}, 	/* 0x3943 */
        {8,	0}, 	/* 0x3944 */
        {8,	0}, 	/* 0x3945 */
        {8,	0}, 	/* 0x3946 */
        {8,	0}, 	/* 0x3947 */
        {8,	0}, 	/* 0x3948 */
        {8,	0}, 	/* 0x3949 */
        {8,	0}, 	/* 0x394a */
        {8,	0}, 	/* 0x394b */
        {8,	0}, 	/* 0x394c */
        {8,	0}, 	/* 0x394d */
        {8,	0}, 	/* 0x394e */
        {8,	0}, 	/* 0x394f */
        {8,	0}, 	/* 0x3950 */
        {8,	0}, 	/* 0x3951 */
        {8,	0}, 	/* 0x3952 */
        {8,	0}, 	/* 0x3953 */
        {8,	0}, 	/* 0x3954 */
        {8,	0}, 	/* 0x3955 */
        {8,	0}, 	/* 0x3956 */
        {8,	0}, 	/* 0x3957 */
        {8,	0}, 	/* 0x3958 */
        {8,	0}, 	/* 0x3959 */
        {8,	0}, 	/* 0x395a */
        {8,	0}, 	/* 0x395b */
        {8,	0}, 	/* 0x395c */
        {8,	0}, 	/* 0x395d */
        {8,	0}, 	/* 0x395e */
        {8,	0}, 	/* 0x395f */
        {8,	0}, 	/* 0x3960 */
        {8,	0}, 	/* 0x3961 */
        {8,	0}, 	/* 0x3962 */
        {8,	0}, 	/* 0x3963 */
        {8,	0}, 	/* 0x3964 */
        {8,	0}, 	/* 0x3965 */
        {8,	0}, 	/* 0x3966 */
        {8,	0}, 	/* 0x3967 */
        {8,	0}, 	/* 0x3968 */
        {8,	0}, 	/* 0x3969 */
        {8,	0}, 	/* 0x396a */
        {8,	0}, 	/* 0x396b */
        {8,	0}, 	/* 0x396c */
        {8,	0}, 	/* 0x396d */
        {8,	0}, 	/* 0x396e */
        {8,	0}, 	/* 0x396f */
        {8,	0}, 	/* 0x3970 */
        {8,	0}, 	/* 0x3971 */
        {8,	0}, 	/* 0x3972 */
        {8,	0}, 	/* 0x3973 */
        {8,	0}, 	/* 0x3974 */
        {8,	0}, 	/* 0x3975 */
        {8,	0}, 	/* 0x3976 */
        {8,	0}, 	/* 0x3977 */
        {8,	0}, 	/* 0x3978 */
        {8,	0}, 	/* 0x3979 */
        {8,	0}, 	/* 0x397a */
        {8,	0}, 	/* 0x397b */
        {8,	0}, 	/* 0x397c */
        {8,	0}, 	/* 0x397d */
        {8,	0}, 	/* 0x397e */
        {8,	0}, 	/* 0x397f */
        {8,	0}, 	/* 0x3980 */
        {8,	0}, 	/* 0x3981 */
        {8,	0}, 	/* 0x3982 */
        {8,	0}, 	/* 0x3983 */
        {8,	0}, 	/* 0x3984 */
        {8,	0}, 	/* 0x3985 */
        {8,	0}, 	/* 0x3986 */
        {8,	0}, 	/* 0x3987 */
        {8,	0}, 	/* 0x3988 */
        {8,	0}, 	/* 0x3989 */
        {8,	0}, 	/* 0x398a */
        {8,	0}, 	/* 0x398b */
        {8,	0}, 	/* 0x398c */
        {8,	0}, 	/* 0x398d */
        {8,	0}, 	/* 0x398e */
        {8,	0}, 	/* 0x398f */
        {8,	0}, 	/* 0x3990 */
        {8,	0}, 	/* 0x3991 */
        {8,	0}, 	/* 0x3992 */
        {8,	0}, 	/* 0x3993 */
        {8,	0}, 	/* 0x3994 */
        {8,	0}, 	/* 0x3995 */
        {8,	0}, 	/* 0x3996 */
        {8,	0}, 	/* 0x3997 */
        {8,	0}, 	/* 0x3998 */
        {8,	0}, 	/* 0x3999 */
        {8,	0}, 	/* 0x399a */
        {8,	0}, 	/* 0x399b */
        {8,	0}, 	/* 0x399c */
        {8,	0}, 	/* 0x399d */
        {8,	0}, 	/* 0x399e */
        {8,	0}, 	/* 0x399f */
        {8,	0}, 	/* 0x39a0 */
        {8,	0}, 	/* 0x39a1 */
        {8,	0}, 	/* 0x39a2 */
        {8,	0}, 	/* 0x39a3 */
        {8,	0}, 	/* 0x39a4 */
        {8,	0}, 	/* 0x39a5 */
        {8,	0}, 	/* 0x39a6 */
        {8,	0}, 	/* 0x39a7 */
        {8,	0}, 	/* 0x39a8 */
        {8,	0}, 	/* 0x39a9 */
        {8,	0}, 	/* 0x39aa */
        {8,	0}, 	/* 0x39ab */
        {8,	0}, 	/* 0x39ac */
        {8,	0}, 	/* 0x39ad */
        {8,	0}, 	/* 0x39ae */
        {8,	0}, 	/* 0x39af */
        {8,	0}, 	/* 0x39b0 */
        {8,	0}, 	/* 0x39b1 */
        {8,	0}, 	/* 0x39b2 */
        {8,	0}, 	/* 0x39b3 */
        {8,	0}, 	/* 0x39b4 */
        {8,	0}, 	/* 0x39b5 */
        {8,	0}, 	/* 0x39b6 */
        {8,	0}, 	/* 0x39b7 */
        {8,	0}, 	/* 0x39b8 */
        {8,	0}, 	/* 0x39b9 */
        {8,	0}, 	/* 0x39ba */
        {8,	0}, 	/* 0x39bb */
        {8,	0}, 	/* 0x39bc */
        {8,	0}, 	/* 0x39bd */
        {8,	0}, 	/* 0x39be */
        {8,	0}, 	/* 0x39bf */
        {8,	0}, 	/* 0x39c0 */
        {8,	0}, 	/* 0x39c1 */
        {8,	0}, 	/* 0x39c2 */
        {8,	0}, 	/* 0x39c3 */
        {8,	0}, 	/* 0x39c4 */
        {8,	0}, 	/* 0x39c5 */
        {8,	0}, 	/* 0x39c6 */
        {8,	0}, 	/* 0x39c7 */
        {8,	0}, 	/* 0x39c8 */
        {8,	0}, 	/* 0x39c9 */
        {8,	0}, 	/* 0x39ca */
        {8,	0}, 	/* 0x39cb */
        {8,	0}, 	/* 0x39cc */
        {8,	0}, 	/* 0x39cd */
        {8,	0}, 	/* 0x39ce */
        {8,	0}, 	/* 0x39cf */
        {8,	0}, 	/* 0x39d0 */
        {8,	0}, 	/* 0x39d1 */
        {8,	0}, 	/* 0x39d2 */
        {8,	0}, 	/* 0x39d3 */
        {8,	0}, 	/* 0x39d4 */
        {8,	0}, 	/* 0x39d5 */
        {8,	0}, 	/* 0x39d6 */
        {8,	0}, 	/* 0x39d7 */
        {8,	0}, 	/* 0x39d8 */
        {8,	0}, 	/* 0x39d9 */
        {8,	0}, 	/* 0x39da */
        {8,	0}, 	/* 0x39db */
        {8,	0}, 	/* 0x39dc */
        {8,	0}, 	/* 0x39dd */
        {8,	0}, 	/* 0x39de */
        {8,	0}, 	/* 0x39df */
        {8,	0}, 	/* 0x39e0 */
        {8,	0}, 	/* 0x39e1 */
        {8,	0}, 	/* 0x39e2 */
        {8,	0}, 	/* 0x39e3 */
        {8,	0}, 	/* 0x39e4 */
        {8,	0}, 	/* 0x39e5 */
        {8,	0}, 	/* 0x39e6 */
        {8,	0}, 	/* 0x39e7 */
        {8,	0}, 	/* 0x39e8 */
        {8,	0}, 	/* 0x39e9 */
        {8,	0}, 	/* 0x39ea */
        {8,	0}, 	/* 0x39eb */
        {8,	0}, 	/* 0x39ec */
        {8,	0}, 	/* 0x39ed */
        {8,	0}, 	/* 0x39ee */
        {8,	0}, 	/* 0x39ef */
        {8,	0}, 	/* 0x39f0 */
        {8,	0}, 	/* 0x39f1 */
        {8,	0}, 	/* 0x39f2 */
        {8,	0}, 	/* 0x39f3 */
        {8,	0}, 	/* 0x39f4 */
        {8,	0}, 	/* 0x39f5 */
        {8,	0}, 	/* 0x39f6 */
        {8,	0}, 	/* 0x39f7 */
        {8,	0}, 	/* 0x39f8 */
        {8,	0}, 	/* 0x39f9 */
        {8,	0}, 	/* 0x39fa */
        {8,	0}, 	/* 0x39fb */
        {8,	0}, 	/* 0x39fc */
        {8,	0}, 	/* 0x39fd */
        {8,	0}, 	/* 0x39fe */
        {8,	0}, 	/* 0x39ff */
        {8,	0}, 	/* 0x3a00 */
        {8,	0}, 	/* 0x3a01 */
        {8,	0}, 	/* 0x3a02 */
        {8,	0}, 	/* 0x3a03 */
        {8,	0}, 	/* 0x3a04 */
        {8,	0}, 	/* 0x3a05 */
        {8,	0}, 	/* 0x3a06 */
        {8,	0}, 	/* 0x3a07 */
        {8,	0}, 	/* 0x3a08 */
        {8,	0}, 	/* 0x3a09 */
        {8,	0}, 	/* 0x3a0a */
        {8,	0}, 	/* 0x3a0b */
        {8,	0}, 	/* 0x3a0c */
        {8,	0}, 	/* 0x3a0d */
        {8,	0}, 	/* 0x3a0e */
        {8,	0}, 	/* 0x3a0f */
        {8,	0}, 	/* 0x3a10 */
        {8,	0}, 	/* 0x3a11 */
        {8,	0}, 	/* 0x3a12 */
        {8,	0}, 	/* 0x3a13 */
        {8,	0}, 	/* 0x3a14 */
        {8,	0}, 	/* 0x3a15 */
        {8,	0}, 	/* 0x3a16 */
        {8,	0}, 	/* 0x3a17 */
        {8,	0}, 	/* 0x3a18 */
        {8,	0}, 	/* 0x3a19 */
        {8,	0}, 	/* 0x3a1a */
        {8,	0}, 	/* 0x3a1b */
        {8,	0}, 	/* 0x3a1c */
        {8,	0}, 	/* 0x3a1d */
        {8,	0}, 	/* 0x3a1e */
        {8,	0}, 	/* 0x3a1f */
        {8,	0}, 	/* 0x3a20 */
        {8,	0}, 	/* 0x3a21 */
        {8,	0}, 	/* 0x3a22 */
        {8,	0}, 	/* 0x3a23 */
        {8,	0}, 	/* 0x3a24 */
        {8,	0}, 	/* 0x3a25 */
        {8,	0}, 	/* 0x3a26 */
        {8,	0}, 	/* 0x3a27 */
        {8,	0}, 	/* 0x3a28 */
        {8,	0}, 	/* 0x3a29 */
        {8,	0}, 	/* 0x3a2a */
        {8,	0}, 	/* 0x3a2b */
        {8,	0}, 	/* 0x3a2c */
        {8,	0}, 	/* 0x3a2d */
        {8,	0}, 	/* 0x3a2e */
        {8,	0}, 	/* 0x3a2f */
        {8,	0}, 	/* 0x3a30 */
        {8,	0}, 	/* 0x3a31 */
        {8,	0}, 	/* 0x3a32 */
        {8,	0}, 	/* 0x3a33 */
        {8,	0}, 	/* 0x3a34 */
        {8,	0}, 	/* 0x3a35 */
        {8,	0}, 	/* 0x3a36 */
        {8,	0}, 	/* 0x3a37 */
        {8,	0}, 	/* 0x3a38 */
        {8,	0}, 	/* 0x3a39 */
        {8,	0}, 	/* 0x3a3a */
        {8,	0}, 	/* 0x3a3b */
        {8,	0}, 	/* 0x3a3c */
        {8,	0}, 	/* 0x3a3d */
        {8,	0}, 	/* 0x3a3e */
        {8,	0}, 	/* 0x3a3f */
        {8,	0}, 	/* 0x3a40 */
        {8,	0}, 	/* 0x3a41 */
        {8,	0}, 	/* 0x3a42 */
        {8,	0}, 	/* 0x3a43 */
        {8,	0}, 	/* 0x3a44 */
        {8,	0}, 	/* 0x3a45 */
        {8,	0}, 	/* 0x3a46 */
        {8,	0}, 	/* 0x3a47 */
        {8,	0}, 	/* 0x3a48 */
        {8,	0}, 	/* 0x3a49 */
        {8,	0}, 	/* 0x3a4a */
        {8,	0}, 	/* 0x3a4b */
        {8,	0}, 	/* 0x3a4c */
        {8,	0}, 	/* 0x3a4d */
        {8,	0}, 	/* 0x3a4e */
        {8,	0}, 	/* 0x3a4f */
        {8,	0}, 	/* 0x3a50 */
        {8,	0}, 	/* 0x3a51 */
        {8,	0}, 	/* 0x3a52 */
        {8,	0}, 	/* 0x3a53 */
        {8,	0}, 	/* 0x3a54 */
        {8,	0}, 	/* 0x3a55 */
        {8,	0}, 	/* 0x3a56 */
        {8,	0}, 	/* 0x3a57 */
        {8,	0}, 	/* 0x3a58 */
        {8,	0}, 	/* 0x3a59 */
        {8,	0}, 	/* 0x3a5a */
        {8,	0}, 	/* 0x3a5b */
        {8,	0}, 	/* 0x3a5c */
        {8,	0}, 	/* 0x3a5d */
        {8,	0}, 	/* 0x3a5e */
        {8,	0}, 	/* 0x3a5f */
        {8,	0}, 	/* 0x3a60 */
        {8,	0}, 	/* 0x3a61 */
        {8,	0}, 	/* 0x3a62 */
        {8,	0}, 	/* 0x3a63 */
        {8,	0}, 	/* 0x3a64 */
        {8,	0}, 	/* 0x3a65 */
        {8,	0}, 	/* 0x3a66 */
        {8,	0}, 	/* 0x3a67 */
        {8,	0}, 	/* 0x3a68 */
        {8,	0}, 	/* 0x3a69 */
        {8,	0}, 	/* 0x3a6a */
        {8,	0}, 	/* 0x3a6b */
        {8,	0}, 	/* 0x3a6c */
        {8,	0}, 	/* 0x3a6d */
        {8,	0}, 	/* 0x3a6e */
        {8,	0}, 	/* 0x3a6f */
        {8,	0}, 	/* 0x3a70 */
        {8,	0}, 	/* 0x3a71 */
        {8,	0}, 	/* 0x3a72 */
        {8,	0}, 	/* 0x3a73 */
        {8,	0}, 	/* 0x3a74 */
        {8,	0}, 	/* 0x3a75 */
        {8,	0}, 	/* 0x3a76 */
        {8,	0}, 	/* 0x3a77 */
        {8,	0}, 	/* 0x3a78 */
        {8,	0}, 	/* 0x3a79 */
        {8,	0}, 	/* 0x3a7a */
        {8,	0}, 	/* 0x3a7b */
        {8,	0}, 	/* 0x3a7c */
        {8,	0}, 	/* 0x3a7d */
        {8,	0}, 	/* 0x3a7e */
        {8,	0}, 	/* 0x3a7f */
        {8,	0}, 	/* 0x3a80 */
        {8,	0}, 	/* 0x3a81 */
        {8,	0}, 	/* 0x3a82 */
        {8,	0}, 	/* 0x3a83 */
        {8,	0}, 	/* 0x3a84 */
        {8,	0}, 	/* 0x3a85 */
        {8,	0}, 	/* 0x3a86 */
        {8,	0}, 	/* 0x3a87 */
        {8,	0}, 	/* 0x3a88 */
        {8,	0}, 	/* 0x3a89 */
        {8,	0}, 	/* 0x3a8a */
        {8,	0}, 	/* 0x3a8b */
        {8,	0}, 	/* 0x3a8c */
        {8,	0}, 	/* 0x3a8d */
        {8,	0}, 	/* 0x3a8e */
        {8,	0}, 	/* 0x3a8f */
        {8,	0}, 	/* 0x3a90 */
        {8,	0}, 	/* 0x3a91 */
        {8,	0}, 	/* 0x3a92 */
        {8,	0}, 	/* 0x3a93 */
        {8,	0}, 	/* 0x3a94 */
        {8,	0}, 	/* 0x3a95 */
        {8,	0}, 	/* 0x3a96 */
        {8,	0}, 	/* 0x3a97 */
        {8,	0}, 	/* 0x3a98 */
        {8,	0}, 	/* 0x3a99 */
        {8,	0}, 	/* 0x3a9a */
        {8,	0}, 	/* 0x3a9b */
        {8,	0}, 	/* 0x3a9c */
        {8,	0}, 	/* 0x3a9d */
        {8,	0}, 	/* 0x3a9e */
        {8,	0}, 	/* 0x3a9f */
        {8,	0}, 	/* 0x3aa0 */
        {8,	0}, 	/* 0x3aa1 */
        {8,	0}, 	/* 0x3aa2 */
        {8,	0}, 	/* 0x3aa3 */
        {8,	0}, 	/* 0x3aa4 */
        {8,	0}, 	/* 0x3aa5 */
        {8,	0}, 	/* 0x3aa6 */
        {8,	0}, 	/* 0x3aa7 */
        {8,	0}, 	/* 0x3aa8 */
        {8,	0}, 	/* 0x3aa9 */
        {8,	0}, 	/* 0x3aaa */
        {8,	0}, 	/* 0x3aab */
        {8,	0}, 	/* 0x3aac */
        {8,	0}, 	/* 0x3aad */
        {8,	0}, 	/* 0x3aae */
        {8,	0}, 	/* 0x3aaf */
        {8,	0}, 	/* 0x3ab0 */
        {8,	0}, 	/* 0x3ab1 */
        {8,	0}, 	/* 0x3ab2 */
        {8,	0}, 	/* 0x3ab3 */
        {8,	0}, 	/* 0x3ab4 */
        {8,	0}, 	/* 0x3ab5 */
        {8,	0}, 	/* 0x3ab6 */
        {8,	0}, 	/* 0x3ab7 */
        {8,	0}, 	/* 0x3ab8 */
        {8,	0}, 	/* 0x3ab9 */
        {8,	0}, 	/* 0x3aba */
        {8,	0}, 	/* 0x3abb */
        {8,	0}, 	/* 0x3abc */
        {8,	0}, 	/* 0x3abd */
        {8,	0}, 	/* 0x3abe */
        {8,	0}, 	/* 0x3abf */
        {8,	0}, 	/* 0x3ac0 */
        {8,	0}, 	/* 0x3ac1 */
        {8,	0}, 	/* 0x3ac2 */
        {8,	0}, 	/* 0x3ac3 */
        {8,	0}, 	/* 0x3ac4 */
        {8,	0}, 	/* 0x3ac5 */
        {8,	0}, 	/* 0x3ac6 */
        {8,	0}, 	/* 0x3ac7 */
        {8,	0}, 	/* 0x3ac8 */
        {8,	0}, 	/* 0x3ac9 */
        {8,	0}, 	/* 0x3aca */
        {8,	0}, 	/* 0x3acb */
        {8,	0}, 	/* 0x3acc */
        {8,	0}, 	/* 0x3acd */
        {8,	0}, 	/* 0x3ace */
        {8,	0}, 	/* 0x3acf */
        {8,	0}, 	/* 0x3ad0 */
        {8,	0}, 	/* 0x3ad1 */
        {8,	0}, 	/* 0x3ad2 */
        {8,	0}, 	/* 0x3ad3 */
        {8,	0}, 	/* 0x3ad4 */
        {8,	0}, 	/* 0x3ad5 */
        {8,	0}, 	/* 0x3ad6 */
        {8,	0}, 	/* 0x3ad7 */
        {8,	0}, 	/* 0x3ad8 */
        {8,	0}, 	/* 0x3ad9 */
        {8,	0}, 	/* 0x3ada */
        {8,	0}, 	/* 0x3adb */
        {8,	0}, 	/* 0x3adc */
        {8,	0}, 	/* 0x3add */
        {8,	0}, 	/* 0x3ade */
        {8,	0}, 	/* 0x3adf */
        {8,	0}, 	/* 0x3ae0 */
        {8,	0}, 	/* 0x3ae1 */
        {8,	0}, 	/* 0x3ae2 */
        {8,	0}, 	/* 0x3ae3 */
        {8,	0}, 	/* 0x3ae4 */
        {8,	0}, 	/* 0x3ae5 */
        {8,	0}, 	/* 0x3ae6 */
        {8,	0}, 	/* 0x3ae7 */
        {8,	0}, 	/* 0x3ae8 */
        {8,	0}, 	/* 0x3ae9 */
        {8,	0}, 	/* 0x3aea */
        {8,	0}, 	/* 0x3aeb */
        {8,	0}, 	/* 0x3aec */
        {8,	0}, 	/* 0x3aed */
        {8,	0}, 	/* 0x3aee */
        {8,	0}, 	/* 0x3aef */
        {8,	0}, 	/* 0x3af0 */
        {8,	0}, 	/* 0x3af1 */
        {8,	0}, 	/* 0x3af2 */
        {8,	0}, 	/* 0x3af3 */
        {8,	0}, 	/* 0x3af4 */
        {8,	0}, 	/* 0x3af5 */
        {8,	0}, 	/* 0x3af6 */
        {8,	0}, 	/* 0x3af7 */
        {8,	0}, 	/* 0x3af8 */
        {8,	0}, 	/* 0x3af9 */
        {8,	0}, 	/* 0x3afa */
        {8,	0}, 	/* 0x3afb */
        {8,	0}, 	/* 0x3afc */
        {8,	0}, 	/* 0x3afd */
        {8,	0}, 	/* 0x3afe */
        {8,	0}, 	/* 0x3aff */
        {8,	0}, 	/* 0x3b00 */
        {8,	0}, 	/* 0x3b01 */
        {8,	0}, 	/* 0x3b02 */
        {8,	0}, 	/* 0x3b03 */
        {8,	0}, 	/* 0x3b04 */
        {8,	0}, 	/* 0x3b05 */
        {8,	0}, 	/* 0x3b06 */
        {8,	0}, 	/* 0x3b07 */
        {8,	0}, 	/* 0x3b08 */
        {8,	0}, 	/* 0x3b09 */
        {8,	0}, 	/* 0x3b0a */
        {8,	0}, 	/* 0x3b0b */
        {8,	0}, 	/* 0x3b0c */
        {8,	0}, 	/* 0x3b0d */
        {8,	0}, 	/* 0x3b0e */
        {8,	0}, 	/* 0x3b0f */
        {8,	0}, 	/* 0x3b10 */
        {8,	0}, 	/* 0x3b11 */
        {8,	0}, 	/* 0x3b12 */
        {8,	0}, 	/* 0x3b13 */
        {8,	0}, 	/* 0x3b14 */
        {8,	0}, 	/* 0x3b15 */
        {8,	0}, 	/* 0x3b16 */
        {8,	0}, 	/* 0x3b17 */
        {8,	0}, 	/* 0x3b18 */
        {8,	0}, 	/* 0x3b19 */
        {8,	0}, 	/* 0x3b1a */
        {8,	0}, 	/* 0x3b1b */
        {8,	0}, 	/* 0x3b1c */
        {8,	0}, 	/* 0x3b1d */
        {8,	0}, 	/* 0x3b1e */
        {8,	0}, 	/* 0x3b1f */
        {8,	0}, 	/* 0x3b20 */
        {8,	0}, 	/* 0x3b21 */
        {8,	0}, 	/* 0x3b22 */
        {8,	0}, 	/* 0x3b23 */
        {8,	0}, 	/* 0x3b24 */
        {8,	0}, 	/* 0x3b25 */
        {8,	0}, 	/* 0x3b26 */
        {8,	0}, 	/* 0x3b27 */
        {8,	0}, 	/* 0x3b28 */
        {8,	0}, 	/* 0x3b29 */
        {8,	0}, 	/* 0x3b2a */
        {8,	0}, 	/* 0x3b2b */
        {8,	0}, 	/* 0x3b2c */
        {8,	0}, 	/* 0x3b2d */
        {8,	0}, 	/* 0x3b2e */
        {8,	0}, 	/* 0x3b2f */
        {8,	0}, 	/* 0x3b30 */
        {8,	0}, 	/* 0x3b31 */
        {8,	0}, 	/* 0x3b32 */
        {8,	0}, 	/* 0x3b33 */
        {8,	0}, 	/* 0x3b34 */
        {8,	0}, 	/* 0x3b35 */
        {8,	0}, 	/* 0x3b36 */
        {8,	0}, 	/* 0x3b37 */
        {8,	0}, 	/* 0x3b38 */
        {8,	0}, 	/* 0x3b39 */
        {8,	0}, 	/* 0x3b3a */
        {8,	0}, 	/* 0x3b3b */
        {8,	0}, 	/* 0x3b3c */
        {8,	0}, 	/* 0x3b3d */
        {8,	0}, 	/* 0x3b3e */
        {8,	0}, 	/* 0x3b3f */
        {8,	0}, 	/* 0x3b40 */
        {8,	0}, 	/* 0x3b41 */
        {8,	0}, 	/* 0x3b42 */
        {8,	0}, 	/* 0x3b43 */
        {8,	0}, 	/* 0x3b44 */
        {8,	0}, 	/* 0x3b45 */
        {8,	0}, 	/* 0x3b46 */
        {8,	0}, 	/* 0x3b47 */
        {8,	0}, 	/* 0x3b48 */
        {8,	0}, 	/* 0x3b49 */
        {8,	0}, 	/* 0x3b4a */
        {8,	0}, 	/* 0x3b4b */
        {8,	0}, 	/* 0x3b4c */
        {8,	0}, 	/* 0x3b4d */
        {8,	0}, 	/* 0x3b4e */
        {8,	0}, 	/* 0x3b4f */
        {8,	0}, 	/* 0x3b50 */
        {8,	0}, 	/* 0x3b51 */
        {8,	0}, 	/* 0x3b52 */
        {8,	0}, 	/* 0x3b53 */
        {8,	0}, 	/* 0x3b54 */
        {8,	0}, 	/* 0x3b55 */
        {8,	0}, 	/* 0x3b56 */
        {8,	0}, 	/* 0x3b57 */
        {8,	0}, 	/* 0x3b58 */
        {8,	0}, 	/* 0x3b59 */
        {8,	0}, 	/* 0x3b5a */
        {8,	0}, 	/* 0x3b5b */
        {8,	0}, 	/* 0x3b5c */
        {8,	0}, 	/* 0x3b5d */
        {8,	0}, 	/* 0x3b5e */
        {8,	0}, 	/* 0x3b5f */
        {8,	0}, 	/* 0x3b60 */
        {8,	0}, 	/* 0x3b61 */
        {8,	0}, 	/* 0x3b62 */
        {8,	0}, 	/* 0x3b63 */
        {8,	0}, 	/* 0x3b64 */
        {8,	0}, 	/* 0x3b65 */
        {8,	0}, 	/* 0x3b66 */
        {8,	0}, 	/* 0x3b67 */
        {8,	0}, 	/* 0x3b68 */
        {8,	0}, 	/* 0x3b69 */
        {8,	0}, 	/* 0x3b6a */
        {8,	0}, 	/* 0x3b6b */
        {8,	0}, 	/* 0x3b6c */
        {8,	0}, 	/* 0x3b6d */
        {8,	0}, 	/* 0x3b6e */
        {8,	0}, 	/* 0x3b6f */
        {8,	0}, 	/* 0x3b70 */
        {8,	0}, 	/* 0x3b71 */
        {8,	0}, 	/* 0x3b72 */
        {8,	0}, 	/* 0x3b73 */
        {8,	0}, 	/* 0x3b74 */
        {8,	0}, 	/* 0x3b75 */
        {8,	0}, 	/* 0x3b76 */
        {8,	0}, 	/* 0x3b77 */
        {8,	0}, 	/* 0x3b78 */
        {8,	0}, 	/* 0x3b79 */
        {8,	0}, 	/* 0x3b7a */
        {8,	0}, 	/* 0x3b7b */
        {8,	0}, 	/* 0x3b7c */
        {8,	0}, 	/* 0x3b7d */
        {8,	0}, 	/* 0x3b7e */
        {8,	0}, 	/* 0x3b7f */
        {8,	0}, 	/* 0x3b80 */
        {8,	0}, 	/* 0x3b81 */
        {8,	0}, 	/* 0x3b82 */
        {8,	0}, 	/* 0x3b83 */
        {8,	0}, 	/* 0x3b84 */
        {8,	0}, 	/* 0x3b85 */
        {8,	0}, 	/* 0x3b86 */
        {8,	0}, 	/* 0x3b87 */
        {8,	0}, 	/* 0x3b88 */
        {8,	0}, 	/* 0x3b89 */
        {8,	0}, 	/* 0x3b8a */
        {8,	0}, 	/* 0x3b8b */
        {8,	0}, 	/* 0x3b8c */
        {8,	0}, 	/* 0x3b8d */
        {8,	0}, 	/* 0x3b8e */
        {8,	0}, 	/* 0x3b8f */
        {8,	0}, 	/* 0x3b90 */
        {8,	0}, 	/* 0x3b91 */
        {8,	0}, 	/* 0x3b92 */
        {8,	0}, 	/* 0x3b93 */
        {8,	0}, 	/* 0x3b94 */
        {8,	0}, 	/* 0x3b95 */
        {8,	0}, 	/* 0x3b96 */
        {8,	0}, 	/* 0x3b97 */
        {8,	0}, 	/* 0x3b98 */
        {8,	0}, 	/* 0x3b99 */
        {8,	0}, 	/* 0x3b9a */
        {8,	0}, 	/* 0x3b9b */
        {8,	0}, 	/* 0x3b9c */
        {8,	0}, 	/* 0x3b9d */
        {8,	0}, 	/* 0x3b9e */
        {8,	0}, 	/* 0x3b9f */
        {8,	0}, 	/* 0x3ba0 */
        {8,	0}, 	/* 0x3ba1 */
        {8,	0}, 	/* 0x3ba2 */
        {8,	0}, 	/* 0x3ba3 */
        {8,	0}, 	/* 0x3ba4 */
        {8,	0}, 	/* 0x3ba5 */
        {8,	0}, 	/* 0x3ba6 */
        {8,	0}, 	/* 0x3ba7 */
        {8,	0}, 	/* 0x3ba8 */
        {8,	0}, 	/* 0x3ba9 */
        {8,	0}, 	/* 0x3baa */
        {8,	0}, 	/* 0x3bab */
        {8,	0}, 	/* 0x3bac */
        {8,	0}, 	/* 0x3bad */
        {8,	0}, 	/* 0x3bae */
        {8,	0}, 	/* 0x3baf */
        {8,	0}, 	/* 0x3bb0 */
        {8,	0}, 	/* 0x3bb1 */
        {8,	0}, 	/* 0x3bb2 */
        {8,	0}, 	/* 0x3bb3 */
        {8,	0}, 	/* 0x3bb4 */
        {8,	0}, 	/* 0x3bb5 */
        {8,	0}, 	/* 0x3bb6 */
        {8,	0}, 	/* 0x3bb7 */
        {8,	0}, 	/* 0x3bb8 */
        {8,	0}, 	/* 0x3bb9 */
        {8,	0}, 	/* 0x3bba */
        {8,	0}, 	/* 0x3bbb */
        {8,	0}, 	/* 0x3bbc */
        {8,	0}, 	/* 0x3bbd */
        {8,	0}, 	/* 0x3bbe */
        {8,	0}, 	/* 0x3bbf */
        {8,	0}, 	/* 0x3bc0 */
        {8,	0}, 	/* 0x3bc1 */
        {8,	0}, 	/* 0x3bc2 */
        {8,	0}, 	/* 0x3bc3 */
        {8,	0}, 	/* 0x3bc4 */
        {8,	0}, 	/* 0x3bc5 */
        {8,	0}, 	/* 0x3bc6 */
        {8,	0}, 	/* 0x3bc7 */
        {8,	0}, 	/* 0x3bc8 */
        {8,	0}, 	/* 0x3bc9 */
        {8,	0}, 	/* 0x3bca */
        {8,	0}, 	/* 0x3bcb */
        {8,	0}, 	/* 0x3bcc */
        {8,	0}, 	/* 0x3bcd */
        {8,	0}, 	/* 0x3bce */
        {8,	0}, 	/* 0x3bcf */
        {8,	0}, 	/* 0x3bd0 */
        {8,	0}, 	/* 0x3bd1 */
        {8,	0}, 	/* 0x3bd2 */
        {8,	0}, 	/* 0x3bd3 */
        {8,	0}, 	/* 0x3bd4 */
        {8,	0}, 	/* 0x3bd5 */
        {8,	0}, 	/* 0x3bd6 */
        {8,	0}, 	/* 0x3bd7 */
        {8,	0}, 	/* 0x3bd8 */
        {8,	0}, 	/* 0x3bd9 */
        {8,	0}, 	/* 0x3bda */
        {8,	0}, 	/* 0x3bdb */
        {8,	0}, 	/* 0x3bdc */
        {8,	0}, 	/* 0x3bdd */
        {8,	0}, 	/* 0x3bde */
        {8,	0}, 	/* 0x3bdf */
        {8,	0}, 	/* 0x3be0 */
        {8,	0}, 	/* 0x3be1 */
        {8,	0}, 	/* 0x3be2 */
        {8,	0}, 	/* 0x3be3 */
        {8,	0}, 	/* 0x3be4 */
        {8,	0}, 	/* 0x3be5 */
        {8,	0}, 	/* 0x3be6 */
        {8,	0}, 	/* 0x3be7 */
        {8,	0}, 	/* 0x3be8 */
        {8,	0}, 	/* 0x3be9 */
        {8,	0}, 	/* 0x3bea */
        {8,	0}, 	/* 0x3beb */
        {8,	0}, 	/* 0x3bec */
        {8,	0}, 	/* 0x3bed */
        {8,	0}, 	/* 0x3bee */
        {8,	0}, 	/* 0x3bef */
        {8,	0}, 	/* 0x3bf0 */
        {8,	0}, 	/* 0x3bf1 */
        {8,	0}, 	/* 0x3bf2 */
        {8,	0}, 	/* 0x3bf3 */
        {8,	0}, 	/* 0x3bf4 */
        {8,	0}, 	/* 0x3bf5 */
        {8,	0}, 	/* 0x3bf6 */
        {8,	0}, 	/* 0x3bf7 */
        {8,	0}, 	/* 0x3bf8 */
        {8,	0}, 	/* 0x3bf9 */
        {8,	0}, 	/* 0x3bfa */
        {8,	0}, 	/* 0x3bfb */
        {8,	0}, 	/* 0x3bfc */
        {8,	0}, 	/* 0x3bfd */
        {8,	0}, 	/* 0x3bfe */
        {8,	0}, 	/* 0x3bff */
        {8,	0}, 	/* 0x3c00 */
        {8,	0}, 	/* 0x3c01 */
        {8,	0}, 	/* 0x3c02 */
        {8,	0}, 	/* 0x3c03 */
        {8,	0}, 	/* 0x3c04 */
        {8,	0}, 	/* 0x3c05 */
        {8,	0}, 	/* 0x3c06 */
        {8,	0}, 	/* 0x3c07 */
        {8,	0}, 	/* 0x3c08 */
        {8,	0}, 	/* 0x3c09 */
        {8,	0}, 	/* 0x3c0a */
        {8,	0}, 	/* 0x3c0b */
        {8,	0}, 	/* 0x3c0c */
        {8,	0}, 	/* 0x3c0d */
        {8,	0}, 	/* 0x3c0e */
        {8,	0}, 	/* 0x3c0f */
        {8,	0}, 	/* 0x3c10 */
        {8,	0}, 	/* 0x3c11 */
        {8,	0}, 	/* 0x3c12 */
        {8,	0}, 	/* 0x3c13 */
        {8,	0}, 	/* 0x3c14 */
        {8,	0}, 	/* 0x3c15 */
        {8,	0}, 	/* 0x3c16 */
        {8,	0}, 	/* 0x3c17 */
        {8,	0}, 	/* 0x3c18 */
        {8,	0}, 	/* 0x3c19 */
        {8,	0}, 	/* 0x3c1a */
        {8,	0}, 	/* 0x3c1b */
        {8,	0}, 	/* 0x3c1c */
        {8,	0}, 	/* 0x3c1d */
        {8,	0}, 	/* 0x3c1e */
        {8,	0}, 	/* 0x3c1f */
        {8,	0}, 	/* 0x3c20 */
        {8,	0}, 	/* 0x3c21 */
        {8,	0}, 	/* 0x3c22 */
        {8,	0}, 	/* 0x3c23 */
        {8,	0}, 	/* 0x3c24 */
        {8,	0}, 	/* 0x3c25 */
        {8,	0}, 	/* 0x3c26 */
        {8,	0}, 	/* 0x3c27 */
        {8,	0}, 	/* 0x3c28 */
        {8,	0}, 	/* 0x3c29 */
        {8,	0}, 	/* 0x3c2a */
        {8,	0}, 	/* 0x3c2b */
        {8,	0}, 	/* 0x3c2c */
        {8,	0}, 	/* 0x3c2d */
        {8,	0}, 	/* 0x3c2e */
        {8,	0}, 	/* 0x3c2f */
        {8,	0}, 	/* 0x3c30 */
        {8,	0}, 	/* 0x3c31 */
        {8,	0}, 	/* 0x3c32 */
        {8,	0}, 	/* 0x3c33 */
        {8,	0}, 	/* 0x3c34 */
        {8,	0}, 	/* 0x3c35 */
        {8,	0}, 	/* 0x3c36 */
        {8,	0}, 	/* 0x3c37 */
        {8,	0}, 	/* 0x3c38 */
        {8,	0}, 	/* 0x3c39 */
        {8,	0}, 	/* 0x3c3a */
        {8,	0}, 	/* 0x3c3b */
        {8,	0}, 	/* 0x3c3c */
        {8,	0}, 	/* 0x3c3d */
        {8,	0}, 	/* 0x3c3e */
        {8,	0}, 	/* 0x3c3f */
        {8,	0}, 	/* 0x3c40 */
        {8,	0}, 	/* 0x3c41 */
        {8,	0}, 	/* 0x3c42 */
        {8,	0}, 	/* 0x3c43 */
        {8,	0}, 	/* 0x3c44 */
        {8,	0}, 	/* 0x3c45 */
        {8,	0}, 	/* 0x3c46 */
        {8,	0}, 	/* 0x3c47 */
        {8,	0}, 	/* 0x3c48 */
        {8,	0}, 	/* 0x3c49 */
        {8,	0}, 	/* 0x3c4a */
        {8,	0}, 	/* 0x3c4b */
        {8,	0}, 	/* 0x3c4c */
        {8,	0}, 	/* 0x3c4d */
        {8,	0}, 	/* 0x3c4e */
        {8,	0}, 	/* 0x3c4f */
        {8,	0}, 	/* 0x3c50 */
        {8,	0}, 	/* 0x3c51 */
        {8,	0}, 	/* 0x3c52 */
        {8,	0}, 	/* 0x3c53 */
        {8,	0}, 	/* 0x3c54 */
        {8,	0}, 	/* 0x3c55 */
        {8,	0}, 	/* 0x3c56 */
        {8,	0}, 	/* 0x3c57 */
        {8,	0}, 	/* 0x3c58 */
        {8,	0}, 	/* 0x3c59 */
        {8,	0}, 	/* 0x3c5a */
        {8,	0}, 	/* 0x3c5b */
        {8,	0}, 	/* 0x3c5c */
        {8,	0}, 	/* 0x3c5d */
        {8,	0}, 	/* 0x3c5e */
        {8,	0}, 	/* 0x3c5f */
        {8,	0}, 	/* 0x3c60 */
        {8,	0}, 	/* 0x3c61 */
        {8,	0}, 	/* 0x3c62 */
        {8,	0}, 	/* 0x3c63 */
        {8,	0}, 	/* 0x3c64 */
        {8,	0}, 	/* 0x3c65 */
        {8,	0}, 	/* 0x3c66 */
        {8,	0}, 	/* 0x3c67 */
        {8,	0}, 	/* 0x3c68 */
        {8,	0}, 	/* 0x3c69 */
        {8,	0}, 	/* 0x3c6a */
        {8,	0}, 	/* 0x3c6b */
        {8,	0}, 	/* 0x3c6c */
        {8,	0}, 	/* 0x3c6d */
        {8,	0}, 	/* 0x3c6e */
        {8,	0}, 	/* 0x3c6f */
        {8,	0}, 	/* 0x3c70 */
        {8,	0}, 	/* 0x3c71 */
        {8,	0}, 	/* 0x3c72 */
        {8,	0}, 	/* 0x3c73 */
        {8,	0}, 	/* 0x3c74 */
        {8,	0}, 	/* 0x3c75 */
        {8,	0}, 	/* 0x3c76 */
        {8,	0}, 	/* 0x3c77 */
        {8,	0}, 	/* 0x3c78 */
        {8,	0}, 	/* 0x3c79 */
        {8,	0}, 	/* 0x3c7a */
        {8,	0}, 	/* 0x3c7b */
        {8,	0}, 	/* 0x3c7c */
        {8,	0}, 	/* 0x3c7d */
        {8,	0}, 	/* 0x3c7e */
        {8,	0}, 	/* 0x3c7f */
        {8,	0}, 	/* 0x3c80 */
        {8,	0}, 	/* 0x3c81 */
        {8,	0}, 	/* 0x3c82 */
        {8,	0}, 	/* 0x3c83 */
        {8,	0}, 	/* 0x3c84 */
        {8,	0}, 	/* 0x3c85 */
        {8,	0}, 	/* 0x3c86 */
        {8,	0}, 	/* 0x3c87 */
        {8,	0}, 	/* 0x3c88 */
        {8,	0}, 	/* 0x3c89 */
        {8,	0}, 	/* 0x3c8a */
        {8,	0}, 	/* 0x3c8b */
        {8,	0}, 	/* 0x3c8c */
        {8,	0}, 	/* 0x3c8d */
        {8,	0}, 	/* 0x3c8e */
        {8,	0}, 	/* 0x3c8f */
        {8,	0}, 	/* 0x3c90 */
        {8,	0}, 	/* 0x3c91 */
        {8,	0}, 	/* 0x3c92 */
        {8,	0}, 	/* 0x3c93 */
        {8,	0}, 	/* 0x3c94 */
        {8,	0}, 	/* 0x3c95 */
        {8,	0}, 	/* 0x3c96 */
        {8,	0}, 	/* 0x3c97 */
        {8,	0}, 	/* 0x3c98 */
        {8,	0}, 	/* 0x3c99 */
        {8,	0}, 	/* 0x3c9a */
        {8,	0}, 	/* 0x3c9b */
        {8,	0}, 	/* 0x3c9c */
        {8,	0}, 	/* 0x3c9d */
        {8,	0}, 	/* 0x3c9e */
        {8,	0}, 	/* 0x3c9f */
        {8,	0}, 	/* 0x3ca0 */
        {8,	0}, 	/* 0x3ca1 */
        {8,	0}, 	/* 0x3ca2 */
        {8,	0}, 	/* 0x3ca3 */
        {8,	0}, 	/* 0x3ca4 */
        {8,	0}, 	/* 0x3ca5 */
        {8,	0}, 	/* 0x3ca6 */
        {8,	0}, 	/* 0x3ca7 */
        {8,	0}, 	/* 0x3ca8 */
        {8,	0}, 	/* 0x3ca9 */
        {8,	0}, 	/* 0x3caa */
        {8,	0}, 	/* 0x3cab */
        {8,	0}, 	/* 0x3cac */
        {8,	0}, 	/* 0x3cad */
        {8,	0}, 	/* 0x3cae */
        {8,	0}, 	/* 0x3caf */
        {8,	0}, 	/* 0x3cb0 */
        {8,	0}, 	/* 0x3cb1 */
        {8,	0}, 	/* 0x3cb2 */
        {8,	0}, 	/* 0x3cb3 */
        {8,	0}, 	/* 0x3cb4 */
        {8,	0}, 	/* 0x3cb5 */
        {8,	0}, 	/* 0x3cb6 */
        {8,	0}, 	/* 0x3cb7 */
        {8,	0}, 	/* 0x3cb8 */
        {8,	0}, 	/* 0x3cb9 */
        {8,	0}, 	/* 0x3cba */
        {8,	0}, 	/* 0x3cbb */
        {8,	0}, 	/* 0x3cbc */
        {8,	0}, 	/* 0x3cbd */
        {8,	0}, 	/* 0x3cbe */
        {8,	0}, 	/* 0x3cbf */
        {8,	0}, 	/* 0x3cc0 */
        {8,	0}, 	/* 0x3cc1 */
        {8,	0}, 	/* 0x3cc2 */
        {8,	0}, 	/* 0x3cc3 */
        {8,	0}, 	/* 0x3cc4 */
        {8,	0}, 	/* 0x3cc5 */
        {8,	0}, 	/* 0x3cc6 */
        {8,	0}, 	/* 0x3cc7 */
        {8,	0}, 	/* 0x3cc8 */
        {8,	0}, 	/* 0x3cc9 */
        {8,	0}, 	/* 0x3cca */
        {8,	0}, 	/* 0x3ccb */
        {8,	0}, 	/* 0x3ccc */
        {8,	0}, 	/* 0x3ccd */
        {8,	0}, 	/* 0x3cce */
        {8,	0}, 	/* 0x3ccf */
        {8,	0}, 	/* 0x3cd0 */
        {8,	0}, 	/* 0x3cd1 */
        {8,	0}, 	/* 0x3cd2 */
        {8,	0}, 	/* 0x3cd3 */
        {8,	0}, 	/* 0x3cd4 */
        {8,	0}, 	/* 0x3cd5 */
        {8,	0}, 	/* 0x3cd6 */
        {8,	0}, 	/* 0x3cd7 */
        {8,	0}, 	/* 0x3cd8 */
        {8,	0}, 	/* 0x3cd9 */
        {8,	0}, 	/* 0x3cda */
        {8,	0}, 	/* 0x3cdb */
        {8,	0}, 	/* 0x3cdc */
        {8,	0}, 	/* 0x3cdd */
        {8,	0}, 	/* 0x3cde */
        {8,	0}, 	/* 0x3cdf */
        {8,	0}, 	/* 0x3ce0 */
        {8,	0}, 	/* 0x3ce1 */
        {8,	0}, 	/* 0x3ce2 */
        {8,	0}, 	/* 0x3ce3 */
        {8,	0}, 	/* 0x3ce4 */
        {8,	0}, 	/* 0x3ce5 */
        {8,	0}, 	/* 0x3ce6 */
        {8,	0}, 	/* 0x3ce7 */
        {8,	0}, 	/* 0x3ce8 */
        {8,	0}, 	/* 0x3ce9 */
        {8,	0}, 	/* 0x3cea */
        {8,	0}, 	/* 0x3ceb */
        {8,	0}, 	/* 0x3cec */
        {8,	0}, 	/* 0x3ced */
        {8,	0}, 	/* 0x3cee */
        {8,	0}, 	/* 0x3cef */
        {8,	0}, 	/* 0x3cf0 */
        {8,	0}, 	/* 0x3cf1 */
        {8,	0}, 	/* 0x3cf2 */
        {8,	0}, 	/* 0x3cf3 */
        {8,	0}, 	/* 0x3cf4 */
        {8,	0}, 	/* 0x3cf5 */
        {8,	0}, 	/* 0x3cf6 */
        {8,	0}, 	/* 0x3cf7 */
        {8,	0}, 	/* 0x3cf8 */
        {8,	0}, 	/* 0x3cf9 */
        {8,	0}, 	/* 0x3cfa */
        {8,	0}, 	/* 0x3cfb */
        {8,	0}, 	/* 0x3cfc */
        {8,	0}, 	/* 0x3cfd */
        {8,	0}, 	/* 0x3cfe */
        {8,	0}, 	/* 0x3cff */
        {8,	0}, 	/* 0x3d00 */
        {8,	0}, 	/* 0x3d01 */
        {8,	0}, 	/* 0x3d02 */
        {8,	0}, 	/* 0x3d03 */
        {8,	0}, 	/* 0x3d04 */
        {8,	0}, 	/* 0x3d05 */
        {8,	0}, 	/* 0x3d06 */
        {8,	0}, 	/* 0x3d07 */
        {8,	0}, 	/* 0x3d08 */
        {8,	0}, 	/* 0x3d09 */
        {8,	0}, 	/* 0x3d0a */
        {8,	0}, 	/* 0x3d0b */
        {8,	0}, 	/* 0x3d0c */
        {8,	0}, 	/* 0x3d0d */
        {8,	0}, 	/* 0x3d0e */
        {8,	0}, 	/* 0x3d0f */
        {8,	0}, 	/* 0x3d10 */
        {8,	0}, 	/* 0x3d11 */
        {8,	0}, 	/* 0x3d12 */
        {8,	0}, 	/* 0x3d13 */
        {8,	0}, 	/* 0x3d14 */
        {8,	0}, 	/* 0x3d15 */
        {8,	0}, 	/* 0x3d16 */
        {8,	0}, 	/* 0x3d17 */
        {8,	0}, 	/* 0x3d18 */
        {8,	0}, 	/* 0x3d19 */
        {8,	0}, 	/* 0x3d1a */
        {8,	0}, 	/* 0x3d1b */
        {8,	0}, 	/* 0x3d1c */
        {8,	0}, 	/* 0x3d1d */
        {8,	0}, 	/* 0x3d1e */
        {8,	0}, 	/* 0x3d1f */
        {8,	0}, 	/* 0x3d20 */
        {8,	0}, 	/* 0x3d21 */
        {8,	0}, 	/* 0x3d22 */
        {8,	0}, 	/* 0x3d23 */
        {8,	0}, 	/* 0x3d24 */
        {8,	0}, 	/* 0x3d25 */
        {8,	0}, 	/* 0x3d26 */
        {8,	0}, 	/* 0x3d27 */
        {8,	0}, 	/* 0x3d28 */
        {8,	0}, 	/* 0x3d29 */
        {8,	0}, 	/* 0x3d2a */
        {8,	0}, 	/* 0x3d2b */
        {8,	0}, 	/* 0x3d2c */
        {8,	0}, 	/* 0x3d2d */
        {8,	0}, 	/* 0x3d2e */
        {8,	0}, 	/* 0x3d2f */
        {8,	0}, 	/* 0x3d30 */
        {8,	0}, 	/* 0x3d31 */
        {8,	0}, 	/* 0x3d32 */
        {8,	0}, 	/* 0x3d33 */
        {8,	0}, 	/* 0x3d34 */
        {8,	0}, 	/* 0x3d35 */
        {8,	0}, 	/* 0x3d36 */
        {8,	0}, 	/* 0x3d37 */
        {8,	0}, 	/* 0x3d38 */
        {8,	0}, 	/* 0x3d39 */
        {8,	0}, 	/* 0x3d3a */
        {8,	0}, 	/* 0x3d3b */
        {8,	0}, 	/* 0x3d3c */
        {8,	0}, 	/* 0x3d3d */
        {8,	0}, 	/* 0x3d3e */
        {8,	0}, 	/* 0x3d3f */
        {8,	0}, 	/* 0x3d40 */
        {8,	0}, 	/* 0x3d41 */
        {8,	0}, 	/* 0x3d42 */
        {8,	0}, 	/* 0x3d43 */
        {8,	0}, 	/* 0x3d44 */
        {8,	0}, 	/* 0x3d45 */
        {8,	0}, 	/* 0x3d46 */
        {8,	0}, 	/* 0x3d47 */
        {8,	0}, 	/* 0x3d48 */
        {8,	0}, 	/* 0x3d49 */
        {8,	0}, 	/* 0x3d4a */
        {8,	0}, 	/* 0x3d4b */
        {8,	0}, 	/* 0x3d4c */
        {8,	0}, 	/* 0x3d4d */
        {8,	0}, 	/* 0x3d4e */
        {8,	0}, 	/* 0x3d4f */
        {8,	0}, 	/* 0x3d50 */
        {8,	0}, 	/* 0x3d51 */
        {8,	0}, 	/* 0x3d52 */
        {8,	0}, 	/* 0x3d53 */
        {8,	0}, 	/* 0x3d54 */
        {8,	0}, 	/* 0x3d55 */
        {8,	0}, 	/* 0x3d56 */
        {8,	0}, 	/* 0x3d57 */
        {8,	0}, 	/* 0x3d58 */
        {8,	0}, 	/* 0x3d59 */
        {8,	0}, 	/* 0x3d5a */
        {8,	0}, 	/* 0x3d5b */
        {8,	0}, 	/* 0x3d5c */
        {8,	0}, 	/* 0x3d5d */
        {8,	0}, 	/* 0x3d5e */
        {8,	0}, 	/* 0x3d5f */
        {8,	0}, 	/* 0x3d60 */
        {8,	0}, 	/* 0x3d61 */
        {8,	0}, 	/* 0x3d62 */
        {8,	0}, 	/* 0x3d63 */
        {8,	0}, 	/* 0x3d64 */
        {8,	0}, 	/* 0x3d65 */
        {8,	0}, 	/* 0x3d66 */
        {8,	0}, 	/* 0x3d67 */
        {8,	0}, 	/* 0x3d68 */
        {8,	0}, 	/* 0x3d69 */
        {8,	0}, 	/* 0x3d6a */
        {8,	0}, 	/* 0x3d6b */
        {8,	0}, 	/* 0x3d6c */
        {8,	0}, 	/* 0x3d6d */
        {8,	0}, 	/* 0x3d6e */
        {8,	0}, 	/* 0x3d6f */
        {8,	0}, 	/* 0x3d70 */
        {8,	0}, 	/* 0x3d71 */
        {8,	0}, 	/* 0x3d72 */
        {8,	0}, 	/* 0x3d73 */
        {8,	0}, 	/* 0x3d74 */
        {8,	0}, 	/* 0x3d75 */
        {8,	0}, 	/* 0x3d76 */
        {8,	0}, 	/* 0x3d77 */
        {8,	0}, 	/* 0x3d78 */
        {8,	0}, 	/* 0x3d79 */
        {8,	0}, 	/* 0x3d7a */
        {8,	0}, 	/* 0x3d7b */
        {8,	0}, 	/* 0x3d7c */
        {8,	0}, 	/* 0x3d7d */
        {8,	0}, 	/* 0x3d7e */
        {8,	0}, 	/* 0x3d7f */
        {8,	0}, 	/* 0x3d80 */
        {8,	0}, 	/* 0x3d81 */
        {8,	0}, 	/* 0x3d82 */
        {8,	0}, 	/* 0x3d83 */
        {8,	0}, 	/* 0x3d84 */
        {8,	0}, 	/* 0x3d85 */
        {8,	0}, 	/* 0x3d86 */
        {8,	0}, 	/* 0x3d87 */
        {8,	0}, 	/* 0x3d88 */
        {8,	0}, 	/* 0x3d89 */
        {8,	0}, 	/* 0x3d8a */
        {8,	0}, 	/* 0x3d8b */
        {8,	0}, 	/* 0x3d8c */
        {8,	0}, 	/* 0x3d8d */
        {8,	0}, 	/* 0x3d8e */
        {8,	0}, 	/* 0x3d8f */
        {8,	0}, 	/* 0x3d90 */
        {8,	0}, 	/* 0x3d91 */
        {8,	0}, 	/* 0x3d92 */
        {8,	0}, 	/* 0x3d93 */
        {8,	0}, 	/* 0x3d94 */
        {8,	0}, 	/* 0x3d95 */
        {8,	0}, 	/* 0x3d96 */
        {8,	0}, 	/* 0x3d97 */
        {8,	0}, 	/* 0x3d98 */
        {8,	0}, 	/* 0x3d99 */
        {8,	0}, 	/* 0x3d9a */
        {8,	0}, 	/* 0x3d9b */
        {8,	0}, 	/* 0x3d9c */
        {8,	0}, 	/* 0x3d9d */
        {8,	0}, 	/* 0x3d9e */
        {8,	0}, 	/* 0x3d9f */
        {8,	0}, 	/* 0x3da0 */
        {8,	0}, 	/* 0x3da1 */
        {8,	0}, 	/* 0x3da2 */
        {8,	0}, 	/* 0x3da3 */
        {8,	0}, 	/* 0x3da4 */
        {8,	0}, 	/* 0x3da5 */
        {8,	0}, 	/* 0x3da6 */
        {8,	0}, 	/* 0x3da7 */
        {8,	0}, 	/* 0x3da8 */
        {8,	0}, 	/* 0x3da9 */
        {8,	0}, 	/* 0x3daa */
        {8,	0}, 	/* 0x3dab */
        {8,	0}, 	/* 0x3dac */
        {8,	0}, 	/* 0x3dad */
        {8,	0}, 	/* 0x3dae */
        {8,	0}, 	/* 0x3daf */
        {8,	0}, 	/* 0x3db0 */
        {8,	0}, 	/* 0x3db1 */
        {8,	0}, 	/* 0x3db2 */
        {8,	0}, 	/* 0x3db3 */
        {8,	0}, 	/* 0x3db4 */
        {8,	0}, 	/* 0x3db5 */
        {8,	0}, 	/* 0x3db6 */
        {8,	0}, 	/* 0x3db7 */
        {8,	0}, 	/* 0x3db8 */
        {8,	0}, 	/* 0x3db9 */
        {8,	0}, 	/* 0x3dba */
        {8,	0}, 	/* 0x3dbb */
        {8,	0}, 	/* 0x3dbc */
        {8,	0}, 	/* 0x3dbd */
        {8,	0}, 	/* 0x3dbe */
        {8,	0}, 	/* 0x3dbf */
        {8,	0}, 	/* 0x3dc0 */
        {8,	0}, 	/* 0x3dc1 */
        {8,	0}, 	/* 0x3dc2 */
        {8,	0}, 	/* 0x3dc3 */
        {8,	0}, 	/* 0x3dc4 */
        {8,	0}, 	/* 0x3dc5 */
        {8,	0}, 	/* 0x3dc6 */
        {8,	0}, 	/* 0x3dc7 */
        {8,	0}, 	/* 0x3dc8 */
        {8,	0}, 	/* 0x3dc9 */
        {8,	0}, 	/* 0x3dca */
        {8,	0}, 	/* 0x3dcb */
        {8,	0}, 	/* 0x3dcc */
        {8,	0}, 	/* 0x3dcd */
        {8,	0}, 	/* 0x3dce */
        {8,	0}, 	/* 0x3dcf */
        {8,	0}, 	/* 0x3dd0 */
        {8,	0}, 	/* 0x3dd1 */
        {8,	0}, 	/* 0x3dd2 */
        {8,	0}, 	/* 0x3dd3 */
        {8,	0}, 	/* 0x3dd4 */
        {8,	0}, 	/* 0x3dd5 */
        {8,	0}, 	/* 0x3dd6 */
        {8,	0}, 	/* 0x3dd7 */
        {8,	0}, 	/* 0x3dd8 */
        {8,	0}, 	/* 0x3dd9 */
        {8,	0}, 	/* 0x3dda */
        {8,	0}, 	/* 0x3ddb */
        {8,	0}, 	/* 0x3ddc */
        {8,	0}, 	/* 0x3ddd */
        {8,	0}, 	/* 0x3dde */
        {8,	0}, 	/* 0x3ddf */
        {8,	0}, 	/* 0x3de0 */
        {8,	0}, 	/* 0x3de1 */
        {8,	0}, 	/* 0x3de2 */
        {8,	0}, 	/* 0x3de3 */
        {8,	0}, 	/* 0x3de4 */
        {8,	0}, 	/* 0x3de5 */
        {8,	0}, 	/* 0x3de6 */
        {8,	0}, 	/* 0x3de7 */
        {8,	0}, 	/* 0x3de8 */
        {8,	0}, 	/* 0x3de9 */
        {8,	0}, 	/* 0x3dea */
        {8,	0}, 	/* 0x3deb */
        {8,	0}, 	/* 0x3dec */
        {8,	0}, 	/* 0x3ded */
        {8,	0}, 	/* 0x3dee */
        {8,	0}, 	/* 0x3def */
        {8,	0}, 	/* 0x3df0 */
        {8,	0}, 	/* 0x3df1 */
        {8,	0}, 	/* 0x3df2 */
        {8,	0}, 	/* 0x3df3 */
        {8,	0}, 	/* 0x3df4 */
        {8,	0}, 	/* 0x3df5 */
        {8,	0}, 	/* 0x3df6 */
        {8,	0}, 	/* 0x3df7 */
        {8,	0}, 	/* 0x3df8 */
        {8,	0}, 	/* 0x3df9 */
        {8,	0}, 	/* 0x3dfa */
        {8,	0}, 	/* 0x3dfb */
        {8,	0}, 	/* 0x3dfc */
        {8,	0}, 	/* 0x3dfd */
        {8,	0}, 	/* 0x3dfe */
        {8,	0}, 	/* 0x3dff */
        {8,	0}, 	/* 0x3e00 */
        {8,	0}, 	/* 0x3e01 */
        {8,	0}, 	/* 0x3e02 */
        {8,	0}, 	/* 0x3e03 */
        {8,	0}, 	/* 0x3e04 */
        {8,	0}, 	/* 0x3e05 */
        {8,	0}, 	/* 0x3e06 */
        {8,	0}, 	/* 0x3e07 */
        {8,	0}, 	/* 0x3e08 */
        {8,	0}, 	/* 0x3e09 */
        {8,	0}, 	/* 0x3e0a */
        {8,	0}, 	/* 0x3e0b */
        {8,	0}, 	/* 0x3e0c */
        {8,	0}, 	/* 0x3e0d */
        {8,	0}, 	/* 0x3e0e */
        {8,	0}, 	/* 0x3e0f */
        {8,	0}, 	/* 0x3e10 */
        {8,	0}, 	/* 0x3e11 */
        {8,	0}, 	/* 0x3e12 */
        {8,	0}, 	/* 0x3e13 */
        {8,	0}, 	/* 0x3e14 */
        {8,	0}, 	/* 0x3e15 */
        {8,	0}, 	/* 0x3e16 */
        {8,	0}, 	/* 0x3e17 */
        {8,	0}, 	/* 0x3e18 */
        {8,	0}, 	/* 0x3e19 */
        {8,	0}, 	/* 0x3e1a */
        {8,	0}, 	/* 0x3e1b */
        {8,	0}, 	/* 0x3e1c */
        {8,	0}, 	/* 0x3e1d */
        {8,	0}, 	/* 0x3e1e */
        {8,	0}, 	/* 0x3e1f */
        {8,	0}, 	/* 0x3e20 */
        {8,	0}, 	/* 0x3e21 */
        {8,	0}, 	/* 0x3e22 */
        {8,	0}, 	/* 0x3e23 */
        {8,	0}, 	/* 0x3e24 */
        {8,	0}, 	/* 0x3e25 */
        {8,	0}, 	/* 0x3e26 */
        {8,	0}, 	/* 0x3e27 */
        {8,	0}, 	/* 0x3e28 */
        {8,	0}, 	/* 0x3e29 */
        {8,	0}, 	/* 0x3e2a */
        {8,	0}, 	/* 0x3e2b */
        {8,	0}, 	/* 0x3e2c */
        {8,	0}, 	/* 0x3e2d */
        {8,	0}, 	/* 0x3e2e */
        {8,	0}, 	/* 0x3e2f */
        {8,	0}, 	/* 0x3e30 */
        {8,	0}, 	/* 0x3e31 */
        {8,	0}, 	/* 0x3e32 */
        {8,	0}, 	/* 0x3e33 */
        {8,	0}, 	/* 0x3e34 */
        {8,	0}, 	/* 0x3e35 */
        {8,	0}, 	/* 0x3e36 */
        {8,	0}, 	/* 0x3e37 */
        {8,	0}, 	/* 0x3e38 */
        {8,	0}, 	/* 0x3e39 */
        {8,	0}, 	/* 0x3e3a */
        {8,	0}, 	/* 0x3e3b */
        {8,	0}, 	/* 0x3e3c */
        {8,	0}, 	/* 0x3e3d */
        {8,	0}, 	/* 0x3e3e */
        {8,	0}, 	/* 0x3e3f */
        {8,	0}, 	/* 0x3e40 */
        {8,	0}, 	/* 0x3e41 */
        {8,	0}, 	/* 0x3e42 */
        {8,	0}, 	/* 0x3e43 */
        {8,	0}, 	/* 0x3e44 */
        {8,	0}, 	/* 0x3e45 */
        {8,	0}, 	/* 0x3e46 */
        {8,	0}, 	/* 0x3e47 */
        {8,	0}, 	/* 0x3e48 */
        {8,	0}, 	/* 0x3e49 */
        {8,	0}, 	/* 0x3e4a */
        {8,	0}, 	/* 0x3e4b */
        {8,	0}, 	/* 0x3e4c */
        {8,	0}, 	/* 0x3e4d */
        {8,	0}, 	/* 0x3e4e */
        {8,	0}, 	/* 0x3e4f */
        {8,	0}, 	/* 0x3e50 */
        {8,	0}, 	/* 0x3e51 */
        {8,	0}, 	/* 0x3e52 */
        {8,	0}, 	/* 0x3e53 */
        {8,	0}, 	/* 0x3e54 */
        {8,	0}, 	/* 0x3e55 */
        {8,	0}, 	/* 0x3e56 */
        {8,	0}, 	/* 0x3e57 */
        {8,	0}, 	/* 0x3e58 */
        {8,	0}, 	/* 0x3e59 */
        {8,	0}, 	/* 0x3e5a */
        {8,	0}, 	/* 0x3e5b */
        {8,	0}, 	/* 0x3e5c */
        {8,	0}, 	/* 0x3e5d */
        {8,	0}, 	/* 0x3e5e */
        {8,	0}, 	/* 0x3e5f */
        {8,	0}, 	/* 0x3e60 */
        {8,	0}, 	/* 0x3e61 */
        {8,	0}, 	/* 0x3e62 */
        {8,	0}, 	/* 0x3e63 */
        {8,	0}, 	/* 0x3e64 */
        {8,	0}, 	/* 0x3e65 */
        {8,	0}, 	/* 0x3e66 */
        {8,	0}, 	/* 0x3e67 */
        {8,	0}, 	/* 0x3e68 */
        {8,	0}, 	/* 0x3e69 */
        {8,	0}, 	/* 0x3e6a */
        {8,	0}, 	/* 0x3e6b */
        {8,	0}, 	/* 0x3e6c */
        {8,	0}, 	/* 0x3e6d */
        {8,	0}, 	/* 0x3e6e */
        {8,	0}, 	/* 0x3e6f */
        {8,	0}, 	/* 0x3e70 */
        {8,	0}, 	/* 0x3e71 */
        {8,	0}, 	/* 0x3e72 */
        {8,	0}, 	/* 0x3e73 */
        {8,	0}, 	/* 0x3e74 */
        {8,	0}, 	/* 0x3e75 */
        {8,	0}, 	/* 0x3e76 */
        {8,	0}, 	/* 0x3e77 */
        {8,	0}, 	/* 0x3e78 */
        {8,	0}, 	/* 0x3e79 */
        {8,	0}, 	/* 0x3e7a */
        {8,	0}, 	/* 0x3e7b */
        {8,	0}, 	/* 0x3e7c */
        {8,	0}, 	/* 0x3e7d */
        {8,	0}, 	/* 0x3e7e */
        {8,	0}, 	/* 0x3e7f */
        {8,	0}, 	/* 0x3e80 */
        {8,	0}, 	/* 0x3e81 */
        {8,	0}, 	/* 0x3e82 */
        {8,	0}, 	/* 0x3e83 */
        {8,	0}, 	/* 0x3e84 */
        {8,	0}, 	/* 0x3e85 */
        {8,	0}, 	/* 0x3e86 */
        {8,	0}, 	/* 0x3e87 */
        {8,	0}, 	/* 0x3e88 */
        {8,	0}, 	/* 0x3e89 */
        {8,	0}, 	/* 0x3e8a */
        {8,	0}, 	/* 0x3e8b */
        {8,	0}, 	/* 0x3e8c */
        {8,	0}, 	/* 0x3e8d */
        {8,	0}, 	/* 0x3e8e */
        {8,	0}, 	/* 0x3e8f */
        {8,	0}, 	/* 0x3e90 */
        {8,	0}, 	/* 0x3e91 */
        {8,	0}, 	/* 0x3e92 */
        {8,	0}, 	/* 0x3e93 */
        {8,	0}, 	/* 0x3e94 */
        {8,	0}, 	/* 0x3e95 */
        {8,	0}, 	/* 0x3e96 */
        {8,	0}, 	/* 0x3e97 */
        {8,	0}, 	/* 0x3e98 */
        {8,	0}, 	/* 0x3e99 */
        {8,	0}, 	/* 0x3e9a */
        {8,	0}, 	/* 0x3e9b */
        {8,	0}, 	/* 0x3e9c */
        {8,	0}, 	/* 0x3e9d */
        {8,	0}, 	/* 0x3e9e */
        {8,	0}, 	/* 0x3e9f */
        {8,	0}, 	/* 0x3ea0 */
        {8,	0}, 	/* 0x3ea1 */
        {8,	0}, 	/* 0x3ea2 */
        {8,	0}, 	/* 0x3ea3 */
        {8,	0}, 	/* 0x3ea4 */
        {8,	0}, 	/* 0x3ea5 */
        {8,	0}, 	/* 0x3ea6 */
        {8,	0}, 	/* 0x3ea7 */
        {8,	0}, 	/* 0x3ea8 */
        {8,	0}, 	/* 0x3ea9 */
        {8,	0}, 	/* 0x3eaa */
        {8,	0}, 	/* 0x3eab */
        {8,	0}, 	/* 0x3eac */
        {8,	0}, 	/* 0x3ead */
        {8,	0}, 	/* 0x3eae */
        {8,	0}, 	/* 0x3eaf */
        {8,	0}, 	/* 0x3eb0 */
        {8,	0}, 	/* 0x3eb1 */
        {8,	0}, 	/* 0x3eb2 */
        {8,	0}, 	/* 0x3eb3 */
        {8,	0}, 	/* 0x3eb4 */
        {8,	0}, 	/* 0x3eb5 */
        {8,	0}, 	/* 0x3eb6 */
        {8,	0}, 	/* 0x3eb7 */
        {8,	0}, 	/* 0x3eb8 */
        {8,	0}, 	/* 0x3eb9 */
        {8,	0}, 	/* 0x3eba */
        {8,	0}, 	/* 0x3ebb */
        {8,	0}, 	/* 0x3ebc */
        {8,	0}, 	/* 0x3ebd */
        {8,	0}, 	/* 0x3ebe */
        {8,	0}, 	/* 0x3ebf */
        {8,	0}, 	/* 0x3ec0 */
        {8,	0}, 	/* 0x3ec1 */
        {8,	0}, 	/* 0x3ec2 */
        {8,	0}, 	/* 0x3ec3 */
        {8,	0}, 	/* 0x3ec4 */
        {8,	0}, 	/* 0x3ec5 */
        {8,	0}, 	/* 0x3ec6 */
        {8,	0}, 	/* 0x3ec7 */
        {8,	0}, 	/* 0x3ec8 */
        {8,	0}, 	/* 0x3ec9 */
        {8,	0}, 	/* 0x3eca */
        {8,	0}, 	/* 0x3ecb */
        {8,	0}, 	/* 0x3ecc */
        {8,	0}, 	/* 0x3ecd */
        {8,	0}, 	/* 0x3ece */
        {8,	0}, 	/* 0x3ecf */
        {8,	0}, 	/* 0x3ed0 */
        {8,	0}, 	/* 0x3ed1 */
        {8,	0}, 	/* 0x3ed2 */
        {8,	0}, 	/* 0x3ed3 */
        {8,	0}, 	/* 0x3ed4 */
        {8,	0}, 	/* 0x3ed5 */
        {8,	0}, 	/* 0x3ed6 */
        {8,	0}, 	/* 0x3ed7 */
        {8,	0}, 	/* 0x3ed8 */
        {8,	0}, 	/* 0x3ed9 */
        {8,	0}, 	/* 0x3eda */
        {8,	0}, 	/* 0x3edb */
        {8,	0}, 	/* 0x3edc */
        {8,	0}, 	/* 0x3edd */
        {8,	0}, 	/* 0x3ede */
        {8,	0}, 	/* 0x3edf */
        {8,	0}, 	/* 0x3ee0 */
        {8,	0}, 	/* 0x3ee1 */
        {8,	0}, 	/* 0x3ee2 */
        {8,	0}, 	/* 0x3ee3 */
        {8,	0}, 	/* 0x3ee4 */
        {8,	0}, 	/* 0x3ee5 */
        {8,	0}, 	/* 0x3ee6 */
        {8,	0}, 	/* 0x3ee7 */
        {8,	0}, 	/* 0x3ee8 */
        {8,	0}, 	/* 0x3ee9 */
        {8,	0}, 	/* 0x3eea */
        {8,	0}, 	/* 0x3eeb */
        {8,	0}, 	/* 0x3eec */
        {8,	0}, 	/* 0x3eed */
        {8,	0}, 	/* 0x3eee */
        {8,	0}, 	/* 0x3eef */
        {8,	0}, 	/* 0x3ef0 */
        {8,	0}, 	/* 0x3ef1 */
        {8,	0}, 	/* 0x3ef2 */
        {8,	0}, 	/* 0x3ef3 */
        {8,	0}, 	/* 0x3ef4 */
        {8,	0}, 	/* 0x3ef5 */
        {8,	0}, 	/* 0x3ef6 */
        {8,	0}, 	/* 0x3ef7 */
        {8,	0}, 	/* 0x3ef8 */
        {8,	0}, 	/* 0x3ef9 */
        {8,	0}, 	/* 0x3efa */
        {8,	0}, 	/* 0x3efb */
        {8,	0}, 	/* 0x3efc */
        {8,	0}, 	/* 0x3efd */
        {8,	0}, 	/* 0x3efe */
        {8,	0}, 	/* 0x3eff */
        {8,	0}, 	/* 0x3f00 */
        {8,	0}, 	/* 0x3f01 */
        {8,	0}, 	/* 0x3f02 */
        {8,	0}, 	/* 0x3f03 */
        {8,	0}, 	/* 0x3f04 */
        {8,	0}, 	/* 0x3f05 */
        {8,	0}, 	/* 0x3f06 */
        {8,	0}, 	/* 0x3f07 */
        {8,	0}, 	/* 0x3f08 */
        {8,	0}, 	/* 0x3f09 */
        {8,	0}, 	/* 0x3f0a */
        {8,	0}, 	/* 0x3f0b */
        {8,	0}, 	/* 0x3f0c */
        {8,	0}, 	/* 0x3f0d */
        {8,	0}, 	/* 0x3f0e */
        {8,	0}, 	/* 0x3f0f */
        {8,	0}, 	/* 0x3f10 */
        {8,	0}, 	/* 0x3f11 */
        {8,	0}, 	/* 0x3f12 */
        {8,	0}, 	/* 0x3f13 */
        {8,	0}, 	/* 0x3f14 */
        {8,	0}, 	/* 0x3f15 */
        {8,	0}, 	/* 0x3f16 */
        {8,	0}, 	/* 0x3f17 */
        {8,	0}, 	/* 0x3f18 */
        {8,	0}, 	/* 0x3f19 */
        {8,	0}, 	/* 0x3f1a */
        {8,	0}, 	/* 0x3f1b */
        {8,	0}, 	/* 0x3f1c */
        {8,	0}, 	/* 0x3f1d */
        {8,	0}, 	/* 0x3f1e */
        {8,	0}, 	/* 0x3f1f */
        {8,	0}, 	/* 0x3f20 */
        {8,	0}, 	/* 0x3f21 */
        {8,	0}, 	/* 0x3f22 */
        {8,	0}, 	/* 0x3f23 */
        {8,	0}, 	/* 0x3f24 */
        {8,	0}, 	/* 0x3f25 */
        {8,	0}, 	/* 0x3f26 */
        {8,	0}, 	/* 0x3f27 */
        {8,	0}, 	/* 0x3f28 */
        {8,	0}, 	/* 0x3f29 */
        {8,	0}, 	/* 0x3f2a */
        {8,	0}, 	/* 0x3f2b */
        {8,	0}, 	/* 0x3f2c */
        {8,	0}, 	/* 0x3f2d */
        {8,	0}, 	/* 0x3f2e */
        {8,	0}, 	/* 0x3f2f */
        {8,	0}, 	/* 0x3f30 */
        {8,	0}, 	/* 0x3f31 */
        {8,	0}, 	/* 0x3f32 */
        {8,	0}, 	/* 0x3f33 */
        {8,	0}, 	/* 0x3f34 */
        {8,	0}, 	/* 0x3f35 */
        {8,	0}, 	/* 0x3f36 */
        {8,	0}, 	/* 0x3f37 */
        {8,	0}, 	/* 0x3f38 */
        {8,	0}, 	/* 0x3f39 */
        {8,	0}, 	/* 0x3f3a */
        {8,	0}, 	/* 0x3f3b */
        {8,	0}, 	/* 0x3f3c */
        {8,	0}, 	/* 0x3f3d */
        {8,	0}, 	/* 0x3f3e */
        {8,	0}, 	/* 0x3f3f */
        {8,	0}, 	/* 0x3f40 */
        {8,	0}, 	/* 0x3f41 */
        {8,	0}, 	/* 0x3f42 */
        {8,	0}, 	/* 0x3f43 */
        {8,	0}, 	/* 0x3f44 */
        {8,	0}, 	/* 0x3f45 */
        {8,	0}, 	/* 0x3f46 */
        {8,	0}, 	/* 0x3f47 */
        {8,	0}, 	/* 0x3f48 */
        {8,	0}, 	/* 0x3f49 */
        {8,	0}, 	/* 0x3f4a */
        {8,	0}, 	/* 0x3f4b */
        {8,	0}, 	/* 0x3f4c */
        {8,	0}, 	/* 0x3f4d */
        {8,	0}, 	/* 0x3f4e */
        {8,	0}, 	/* 0x3f4f */
        {8,	0}, 	/* 0x3f50 */
        {8,	0}, 	/* 0x3f51 */
        {8,	0}, 	/* 0x3f52 */
        {8,	0}, 	/* 0x3f53 */
        {8,	0}, 	/* 0x3f54 */
        {8,	0}, 	/* 0x3f55 */
        {8,	0}, 	/* 0x3f56 */
        {8,	0}, 	/* 0x3f57 */
        {8,	0}, 	/* 0x3f58 */
        {8,	0}, 	/* 0x3f59 */
        {8,	0}, 	/* 0x3f5a */
        {8,	0}, 	/* 0x3f5b */
        {8,	0}, 	/* 0x3f5c */
        {8,	0}, 	/* 0x3f5d */
        {8,	0}, 	/* 0x3f5e */
        {8,	0}, 	/* 0x3f5f */
        {8,	0}, 	/* 0x3f60 */
        {8,	0}, 	/* 0x3f61 */
        {8,	0}, 	/* 0x3f62 */
        {8,	0}, 	/* 0x3f63 */
        {8,	0}, 	/* 0x3f64 */
        {8,	0}, 	/* 0x3f65 */
        {8,	0}, 	/* 0x3f66 */
        {8,	0}, 	/* 0x3f67 */
        {8,	0}, 	/* 0x3f68 */
        {8,	0}, 	/* 0x3f69 */
        {8,	0}, 	/* 0x3f6a */
        {8,	0}, 	/* 0x3f6b */
        {8,	0}, 	/* 0x3f6c */
        {8,	0}, 	/* 0x3f6d */
        {8,	0}, 	/* 0x3f6e */
        {8,	0}, 	/* 0x3f6f */
        {8,	0}, 	/* 0x3f70 */
        {8,	0}, 	/* 0x3f71 */
        {8,	0}, 	/* 0x3f72 */
        {8,	0}, 	/* 0x3f73 */
        {8,	0}, 	/* 0x3f74 */
        {8,	0}, 	/* 0x3f75 */
        {8,	0}, 	/* 0x3f76 */
        {8,	0}, 	/* 0x3f77 */
        {8,	0}, 	/* 0x3f78 */
        {8,	0}, 	/* 0x3f79 */
        {8,	0}, 	/* 0x3f7a */
        {8,	0}, 	/* 0x3f7b */
        {8,	0}, 	/* 0x3f7c */
        {8,	0}, 	/* 0x3f7d */
        {8,	0}, 	/* 0x3f7e */
        {8,	0}, 	/* 0x3f7f */
        {8,	0}, 	/* 0x3f80 */
        {8,	0}, 	/* 0x3f81 */
        {8,	0}, 	/* 0x3f82 */
        {8,	0}, 	/* 0x3f83 */
        {8,	0}, 	/* 0x3f84 */
        {8,	0}, 	/* 0x3f85 */
        {8,	0}, 	/* 0x3f86 */
        {8,	0}, 	/* 0x3f87 */
        {8,	0}, 	/* 0x3f88 */
        {8,	0}, 	/* 0x3f89 */
        {8,	0}, 	/* 0x3f8a */
        {8,	0}, 	/* 0x3f8b */
        {8,	0}, 	/* 0x3f8c */
        {8,	0}, 	/* 0x3f8d */
        {8,	0}, 	/* 0x3f8e */
        {8,	0}, 	/* 0x3f8f */
        {8,	0}, 	/* 0x3f90 */
        {8,	0}, 	/* 0x3f91 */
        {8,	0}, 	/* 0x3f92 */
        {8,	0}, 	/* 0x3f93 */
        {8,	0}, 	/* 0x3f94 */
        {8,	0}, 	/* 0x3f95 */
        {8,	0}, 	/* 0x3f96 */
        {8,	0}, 	/* 0x3f97 */
        {8,	0}, 	/* 0x3f98 */
        {8,	0}, 	/* 0x3f99 */
        {8,	0}, 	/* 0x3f9a */
        {8,	0}, 	/* 0x3f9b */
        {8,	0}, 	/* 0x3f9c */
        {8,	0}, 	/* 0x3f9d */
        {8,	0}, 	/* 0x3f9e */
        {8,	0}, 	/* 0x3f9f */
        {8,	0}, 	/* 0x3fa0 */
        {8,	0}, 	/* 0x3fa1 */
        {8,	0}, 	/* 0x3fa2 */
        {8,	0}, 	/* 0x3fa3 */
        {8,	0}, 	/* 0x3fa4 */
        {8,	0}, 	/* 0x3fa5 */
        {8,	0}, 	/* 0x3fa6 */
        {8,	0}, 	/* 0x3fa7 */
        {8,	0}, 	/* 0x3fa8 */
        {8,	0}, 	/* 0x3fa9 */
        {8,	0}, 	/* 0x3faa */
        {8,	0}, 	/* 0x3fab */
        {8,	0}, 	/* 0x3fac */
        {8,	0}, 	/* 0x3fad */
        {8,	0}, 	/* 0x3fae */
        {8,	0}, 	/* 0x3faf */
        {8,	0}, 	/* 0x3fb0 */
        {8,	0}, 	/* 0x3fb1 */
        {8,	0}, 	/* 0x3fb2 */
        {8,	0}, 	/* 0x3fb3 */
        {8,	0}, 	/* 0x3fb4 */
        {8,	0}, 	/* 0x3fb5 */
        {8,	0}, 	/* 0x3fb6 */
        {8,	0}, 	/* 0x3fb7 */
        {8,	0}, 	/* 0x3fb8 */
        {8,	0}, 	/* 0x3fb9 */
        {8,	0}, 	/* 0x3fba */
        {8,	0}, 	/* 0x3fbb */
        {8,	0}, 	/* 0x3fbc */
        {8,	0}, 	/* 0x3fbd */
        {8,	0}, 	/* 0x3fbe */
        {8,	0}, 	/* 0x3fbf */
        {8,	0}, 	/* 0x3fc0 */
        {8,	0}, 	/* 0x3fc1 */
        {8,	0}, 	/* 0x3fc2 */
        {8,	0}, 	/* 0x3fc3 */
        {8,	0}, 	/* 0x3fc4 */
        {8,	0}, 	/* 0x3fc5 */
        {8,	0}, 	/* 0x3fc6 */
        {8,	0}, 	/* 0x3fc7 */
        {8,	0}, 	/* 0x3fc8 */
        {8,	0}, 	/* 0x3fc9 */
        {8,	0}, 	/* 0x3fca */
        {8,	0}, 	/* 0x3fcb */
        {8,	0}, 	/* 0x3fcc */
        {8,	0}, 	/* 0x3fcd */
        {8,	0}, 	/* 0x3fce */
        {8,	0}, 	/* 0x3fcf */
        {8,	0}, 	/* 0x3fd0 */
        {8,	0}, 	/* 0x3fd1 */
        {8,	0}, 	/* 0x3fd2 */
        {8,	0}, 	/* 0x3fd3 */
        {8,	0}, 	/* 0x3fd4 */
        {8,	0}, 	/* 0x3fd5 */
        {8,	0}, 	/* 0x3fd6 */
        {8,	0}, 	/* 0x3fd7 */
        {8,	0}, 	/* 0x3fd8 */
        {8,	0}, 	/* 0x3fd9 */
        {8,	0}, 	/* 0x3fda */
        {8,	0}, 	/* 0x3fdb */
        {8,	0}, 	/* 0x3fdc */
        {8,	0}, 	/* 0x3fdd */
        {8,	0}, 	/* 0x3fde */
        {8,	0}, 	/* 0x3fdf */
        {8,	0}, 	/* 0x3fe0 */
        {8,	0}, 	/* 0x3fe1 */
        {8,	0}, 	/* 0x3fe2 */
        {8,	0}, 	/* 0x3fe3 */
        {8,	0}, 	/* 0x3fe4 */
        {8,	0}, 	/* 0x3fe5 */
        {8,	0}, 	/* 0x3fe6 */
        {8,	0}, 	/* 0x3fe7 */
        {8,	0}, 	/* 0x3fe8 */
        {8,	0}, 	/* 0x3fe9 */
        {8,	0}, 	/* 0x3fea */
        {8,	0}, 	/* 0x3feb */
        {8,	0}, 	/* 0x3fec */
        {8,	0}, 	/* 0x3fed */
        {8,	0}, 	/* 0x3fee */
        {8,	0}, 	/* 0x3fef */
        {8,	0}, 	/* 0x3ff0 */
        {8,	0}, 	/* 0x3ff1 */
        {8,	0}, 	/* 0x3ff2 */
        {8,	0}, 	/* 0x3ff3 */
        {8,	0}, 	/* 0x3ff4 */
        {8,	0}, 	/* 0x3ff5 */
        {8,	0}, 	/* 0x3ff6 */
        {8,	0}, 	/* 0x3ff7 */
        {8,	0}, 	/* 0x3ff8 */
        {8,	0}, 	/* 0x3ff9 */
        {8,	0}, 	/* 0x3ffa */
        {8,	0}, 	/* 0x3ffb */
        {8,	0}, 	/* 0x3ffc */
        {8,	0}, 	/* 0x3ffd */
        {8,	0}, 	/* 0x3ffe */
        {8,	0}, 	/* 0x3fff */
        {8,	0}, 	/* 0x4000 */
        {8,	0}, 	/* 0x4001 */
        {8,	0}, 	/* 0x4002 */
        {8,	0}, 	/* 0x4003 */
        {8,	0}, 	/* 0x4004 */
        {8,	0}, 	/* 0x4005 */
        {8,	0}, 	/* 0x4006 */
        {8,	0}, 	/* 0x4007 */
        {8,	0}, 	/* 0x4008 */
        {8,	0}, 	/* 0x4009 */
        {8,	0}, 	/* 0x400a */
        {8,	0}, 	/* 0x400b */
        {8,	0}, 	/* 0x400c */
        {8,	0}, 	/* 0x400d */
        {8,	0}, 	/* 0x400e */
        {8,	0}, 	/* 0x400f */
        {8,	0}, 	/* 0x4010 */
        {8,	0}, 	/* 0x4011 */
        {8,	0}, 	/* 0x4012 */
        {8,	0}, 	/* 0x4013 */
        {8,	0}, 	/* 0x4014 */
        {8,	0}, 	/* 0x4015 */
        {8,	0}, 	/* 0x4016 */
        {8,	0}, 	/* 0x4017 */
        {8,	0}, 	/* 0x4018 */
        {8,	0}, 	/* 0x4019 */
        {8,	0}, 	/* 0x401a */
        {8,	0}, 	/* 0x401b */
        {8,	0}, 	/* 0x401c */
        {8,	0}, 	/* 0x401d */
        {8,	0}, 	/* 0x401e */
        {8,	0}, 	/* 0x401f */
        {8,	0}, 	/* 0x4020 */
        {8,	0}, 	/* 0x4021 */
        {8,	0}, 	/* 0x4022 */
        {8,	0}, 	/* 0x4023 */
        {8,	0}, 	/* 0x4024 */
        {8,	0}, 	/* 0x4025 */
        {8,	0}, 	/* 0x4026 */
        {8,	0}, 	/* 0x4027 */
        {8,	0}, 	/* 0x4028 */
        {8,	0}, 	/* 0x4029 */
        {8,	0}, 	/* 0x402a */
        {8,	0}, 	/* 0x402b */
        {8,	0}, 	/* 0x402c */
        {8,	0}, 	/* 0x402d */
        {8,	0}, 	/* 0x402e */
        {8,	0}, 	/* 0x402f */
        {8,	0}, 	/* 0x4030 */
        {8,	0}, 	/* 0x4031 */
        {8,	0}, 	/* 0x4032 */
        {8,	0}, 	/* 0x4033 */
        {8,	0}, 	/* 0x4034 */
        {8,	0}, 	/* 0x4035 */
        {8,	0}, 	/* 0x4036 */
        {8,	0}, 	/* 0x4037 */
        {8,	0}, 	/* 0x4038 */
        {8,	0}, 	/* 0x4039 */
        {8,	0}, 	/* 0x403a */
        {8,	0}, 	/* 0x403b */
        {8,	0}, 	/* 0x403c */
        {8,	0}, 	/* 0x403d */
        {8,	0}, 	/* 0x403e */
        {8,	0}, 	/* 0x403f */
        {8,	0}, 	/* 0x4040 */
        {8,	0}, 	/* 0x4041 */
        {8,	0}, 	/* 0x4042 */
        {8,	0}, 	/* 0x4043 */
        {8,	0}, 	/* 0x4044 */
        {8,	0}, 	/* 0x4045 */
        {8,	0}, 	/* 0x4046 */
        {8,	0}, 	/* 0x4047 */
        {8,	0}, 	/* 0x4048 */
        {8,	0}, 	/* 0x4049 */
        {8,	0}, 	/* 0x404a */
        {8,	0}, 	/* 0x404b */
        {8,	0}, 	/* 0x404c */
        {8,	0}, 	/* 0x404d */
        {8,	0}, 	/* 0x404e */
        {8,	0}, 	/* 0x404f */
        {8,	0}, 	/* 0x4050 */
        {8,	0}, 	/* 0x4051 */
        {8,	0}, 	/* 0x4052 */
        {8,	0}, 	/* 0x4053 */
        {8,	0}, 	/* 0x4054 */
        {8,	0}, 	/* 0x4055 */
        {8,	0}, 	/* 0x4056 */
        {8,	0}, 	/* 0x4057 */
        {8,	0}, 	/* 0x4058 */
        {8,	0}, 	/* 0x4059 */
        {8,	0}, 	/* 0x405a */
        {8,	0}, 	/* 0x405b */
        {8,	0}, 	/* 0x405c */
        {8,	0}, 	/* 0x405d */
        {8,	0}, 	/* 0x405e */
        {8,	0}, 	/* 0x405f */
        {8,	0}, 	/* 0x4060 */
        {8,	0}, 	/* 0x4061 */
        {8,	0}, 	/* 0x4062 */
        {8,	0}, 	/* 0x4063 */
        {8,	0}, 	/* 0x4064 */
        {8,	0}, 	/* 0x4065 */
        {8,	0}, 	/* 0x4066 */
        {8,	0}, 	/* 0x4067 */
        {8,	0}, 	/* 0x4068 */
        {8,	0}, 	/* 0x4069 */
        {8,	0}, 	/* 0x406a */
        {8,	0}, 	/* 0x406b */
        {8,	0}, 	/* 0x406c */
        {8,	0}, 	/* 0x406d */
        {8,	0}, 	/* 0x406e */
        {8,	0}, 	/* 0x406f */
        {8,	0}, 	/* 0x4070 */
        {8,	0}, 	/* 0x4071 */
        {8,	0}, 	/* 0x4072 */
        {8,	0}, 	/* 0x4073 */
        {8,	0}, 	/* 0x4074 */
        {8,	0}, 	/* 0x4075 */
        {8,	0}, 	/* 0x4076 */
        {8,	0}, 	/* 0x4077 */
        {8,	0}, 	/* 0x4078 */
        {8,	0}, 	/* 0x4079 */
        {8,	0}, 	/* 0x407a */
        {8,	0}, 	/* 0x407b */
        {8,	0}, 	/* 0x407c */
        {8,	0}, 	/* 0x407d */
        {8,	0}, 	/* 0x407e */
        {8,	0}, 	/* 0x407f */
        {8,	0}, 	/* 0x4080 */
        {8,	0}, 	/* 0x4081 */
        {8,	0}, 	/* 0x4082 */
        {8,	0}, 	/* 0x4083 */
        {8,	0}, 	/* 0x4084 */
        {8,	0}, 	/* 0x4085 */
        {8,	0}, 	/* 0x4086 */
        {8,	0}, 	/* 0x4087 */
        {8,	0}, 	/* 0x4088 */
        {8,	0}, 	/* 0x4089 */
        {8,	0}, 	/* 0x408a */
        {8,	0}, 	/* 0x408b */
        {8,	0}, 	/* 0x408c */
        {8,	0}, 	/* 0x408d */
        {8,	0}, 	/* 0x408e */
        {8,	0}, 	/* 0x408f */
        {8,	0}, 	/* 0x4090 */
        {8,	0}, 	/* 0x4091 */
        {8,	0}, 	/* 0x4092 */
        {8,	0}, 	/* 0x4093 */
        {8,	0}, 	/* 0x4094 */
        {8,	0}, 	/* 0x4095 */
        {8,	0}, 	/* 0x4096 */
        {8,	0}, 	/* 0x4097 */
        {8,	0}, 	/* 0x4098 */
        {8,	0}, 	/* 0x4099 */
        {8,	0}, 	/* 0x409a */
        {8,	0}, 	/* 0x409b */
        {8,	0}, 	/* 0x409c */
        {8,	0}, 	/* 0x409d */
        {8,	0}, 	/* 0x409e */
        {8,	0}, 	/* 0x409f */
        {8,	0}, 	/* 0x40a0 */
        {8,	0}, 	/* 0x40a1 */
        {8,	0}, 	/* 0x40a2 */
        {8,	0}, 	/* 0x40a3 */
        {8,	0}, 	/* 0x40a4 */
        {8,	0}, 	/* 0x40a5 */
        {8,	0}, 	/* 0x40a6 */
        {8,	0}, 	/* 0x40a7 */
        {8,	0}, 	/* 0x40a8 */
        {8,	0}, 	/* 0x40a9 */
        {8,	0}, 	/* 0x40aa */
        {8,	0}, 	/* 0x40ab */
        {8,	0}, 	/* 0x40ac */
        {8,	0}, 	/* 0x40ad */
        {8,	0}, 	/* 0x40ae */
        {8,	0}, 	/* 0x40af */
        {8,	0}, 	/* 0x40b0 */
        {8,	0}, 	/* 0x40b1 */
        {8,	0}, 	/* 0x40b2 */
        {8,	0}, 	/* 0x40b3 */
        {8,	0}, 	/* 0x40b4 */
        {8,	0}, 	/* 0x40b5 */
        {8,	0}, 	/* 0x40b6 */
        {8,	0}, 	/* 0x40b7 */
        {8,	0}, 	/* 0x40b8 */
        {8,	0}, 	/* 0x40b9 */
        {8,	0}, 	/* 0x40ba */
        {8,	0}, 	/* 0x40bb */
        {8,	0}, 	/* 0x40bc */
        {8,	0}, 	/* 0x40bd */
        {8,	0}, 	/* 0x40be */
        {8,	0}, 	/* 0x40bf */
        {8,	0}, 	/* 0x40c0 */
        {8,	0}, 	/* 0x40c1 */
        {8,	0}, 	/* 0x40c2 */
        {8,	0}, 	/* 0x40c3 */
        {8,	0}, 	/* 0x40c4 */
        {8,	0}, 	/* 0x40c5 */
        {8,	0}, 	/* 0x40c6 */
        {8,	0}, 	/* 0x40c7 */
        {8,	0}, 	/* 0x40c8 */
        {8,	0}, 	/* 0x40c9 */
        {8,	0}, 	/* 0x40ca */
        {8,	0}, 	/* 0x40cb */
        {8,	0}, 	/* 0x40cc */
        {8,	0}, 	/* 0x40cd */
        {8,	0}, 	/* 0x40ce */
        {8,	0}, 	/* 0x40cf */
        {8,	0}, 	/* 0x40d0 */
        {8,	0}, 	/* 0x40d1 */
        {8,	0}, 	/* 0x40d2 */
        {8,	0}, 	/* 0x40d3 */
        {8,	0}, 	/* 0x40d4 */
        {8,	0}, 	/* 0x40d5 */
        {8,	0}, 	/* 0x40d6 */
        {8,	0}, 	/* 0x40d7 */
        {8,	0}, 	/* 0x40d8 */
        {8,	0}, 	/* 0x40d9 */
        {8,	0}, 	/* 0x40da */
        {8,	0}, 	/* 0x40db */
        {8,	0}, 	/* 0x40dc */
        {8,	0}, 	/* 0x40dd */
        {8,	0}, 	/* 0x40de */
        {8,	0}, 	/* 0x40df */
        {8,	0}, 	/* 0x40e0 */
        {8,	0}, 	/* 0x40e1 */
        {8,	0}, 	/* 0x40e2 */
        {8,	0}, 	/* 0x40e3 */
        {8,	0}, 	/* 0x40e4 */
        {8,	0}, 	/* 0x40e5 */
        {8,	0}, 	/* 0x40e6 */
        {8,	0}, 	/* 0x40e7 */
        {8,	0}, 	/* 0x40e8 */
        {8,	0}, 	/* 0x40e9 */
        {8,	0}, 	/* 0x40ea */
        {8,	0}, 	/* 0x40eb */
        {8,	0}, 	/* 0x40ec */
        {8,	0}, 	/* 0x40ed */
        {8,	0}, 	/* 0x40ee */
        {8,	0}, 	/* 0x40ef */
        {8,	0}, 	/* 0x40f0 */
        {8,	0}, 	/* 0x40f1 */
        {8,	0}, 	/* 0x40f2 */
        {8,	0}, 	/* 0x40f3 */
        {8,	0}, 	/* 0x40f4 */
        {8,	0}, 	/* 0x40f5 */
        {8,	0}, 	/* 0x40f6 */
        {8,	0}, 	/* 0x40f7 */
        {8,	0}, 	/* 0x40f8 */
        {8,	0}, 	/* 0x40f9 */
        {8,	0}, 	/* 0x40fa */
        {8,	0}, 	/* 0x40fb */
        {8,	0}, 	/* 0x40fc */
        {8,	0}, 	/* 0x40fd */
        {8,	0}, 	/* 0x40fe */
        {8,	0}, 	/* 0x40ff */
        {8,	0}, 	/* 0x4100 */
        {8,	0}, 	/* 0x4101 */
        {8,	0}, 	/* 0x4102 */
        {8,	0}, 	/* 0x4103 */
        {8,	0}, 	/* 0x4104 */
        {8,	0}, 	/* 0x4105 */
        {8,	0}, 	/* 0x4106 */
        {8,	0}, 	/* 0x4107 */
        {8,	0}, 	/* 0x4108 */
        {8,	0}, 	/* 0x4109 */
        {8,	0}, 	/* 0x410a */
        {8,	0}, 	/* 0x410b */
        {8,	0}, 	/* 0x410c */
        {8,	0}, 	/* 0x410d */
        {8,	0}, 	/* 0x410e */
        {8,	0}, 	/* 0x410f */
        {8,	0}, 	/* 0x4110 */
        {8,	0}, 	/* 0x4111 */
        {8,	0}, 	/* 0x4112 */
        {8,	0}, 	/* 0x4113 */
        {8,	0}, 	/* 0x4114 */
        {8,	0}, 	/* 0x4115 */
        {8,	0}, 	/* 0x4116 */
        {8,	0}, 	/* 0x4117 */
        {8,	0}, 	/* 0x4118 */
        {8,	0}, 	/* 0x4119 */
        {8,	0}, 	/* 0x411a */
        {8,	0}, 	/* 0x411b */
        {8,	0}, 	/* 0x411c */
        {8,	0}, 	/* 0x411d */
        {8,	0}, 	/* 0x411e */
        {8,	0}, 	/* 0x411f */
        {8,	0}, 	/* 0x4120 */
        {8,	0}, 	/* 0x4121 */
        {8,	0}, 	/* 0x4122 */
        {8,	0}, 	/* 0x4123 */
        {8,	0}, 	/* 0x4124 */
        {8,	0}, 	/* 0x4125 */
        {8,	0}, 	/* 0x4126 */
        {8,	0}, 	/* 0x4127 */
        {8,	0}, 	/* 0x4128 */
        {8,	0}, 	/* 0x4129 */
        {8,	0}, 	/* 0x412a */
        {8,	0}, 	/* 0x412b */
        {8,	0}, 	/* 0x412c */
        {8,	0}, 	/* 0x412d */
        {8,	0}, 	/* 0x412e */
        {8,	0}, 	/* 0x412f */
        {8,	0}, 	/* 0x4130 */
        {8,	0}, 	/* 0x4131 */
        {8,	0}, 	/* 0x4132 */
        {8,	0}, 	/* 0x4133 */
        {8,	0}, 	/* 0x4134 */
        {8,	0}, 	/* 0x4135 */
        {8,	0}, 	/* 0x4136 */
        {8,	0}, 	/* 0x4137 */
        {8,	0}, 	/* 0x4138 */
        {8,	0}, 	/* 0x4139 */
        {8,	0}, 	/* 0x413a */
        {8,	0}, 	/* 0x413b */
        {8,	0}, 	/* 0x413c */
        {8,	0}, 	/* 0x413d */
        {8,	0}, 	/* 0x413e */
        {8,	0}, 	/* 0x413f */
        {8,	0}, 	/* 0x4140 */
        {8,	0}, 	/* 0x4141 */
        {8,	0}, 	/* 0x4142 */
        {8,	0}, 	/* 0x4143 */
        {8,	0}, 	/* 0x4144 */
        {8,	0}, 	/* 0x4145 */
        {8,	0}, 	/* 0x4146 */
        {8,	0}, 	/* 0x4147 */
        {8,	0}, 	/* 0x4148 */
        {8,	0}, 	/* 0x4149 */
        {8,	0}, 	/* 0x414a */
        {8,	0}, 	/* 0x414b */
        {8,	0}, 	/* 0x414c */
        {8,	0}, 	/* 0x414d */
        {8,	0}, 	/* 0x414e */
        {8,	0}, 	/* 0x414f */
        {8,	0}, 	/* 0x4150 */
        {8,	0}, 	/* 0x4151 */
        {8,	0}, 	/* 0x4152 */
        {8,	0}, 	/* 0x4153 */
        {8,	0}, 	/* 0x4154 */
        {8,	0}, 	/* 0x4155 */
        {8,	0}, 	/* 0x4156 */
        {8,	0}, 	/* 0x4157 */
        {8,	0}, 	/* 0x4158 */
        {8,	0}, 	/* 0x4159 */
        {8,	0}, 	/* 0x415a */
        {8,	0}, 	/* 0x415b */
        {8,	0}, 	/* 0x415c */
        {8,	0}, 	/* 0x415d */
        {8,	0}, 	/* 0x415e */
        {8,	0}, 	/* 0x415f */
        {8,	0}, 	/* 0x4160 */
        {8,	0}, 	/* 0x4161 */
        {8,	0}, 	/* 0x4162 */
        {8,	0}, 	/* 0x4163 */
        {8,	0}, 	/* 0x4164 */
        {8,	0}, 	/* 0x4165 */
        {8,	0}, 	/* 0x4166 */
        {8,	0}, 	/* 0x4167 */
        {8,	0}, 	/* 0x4168 */
        {8,	0}, 	/* 0x4169 */
        {8,	0}, 	/* 0x416a */
        {8,	0}, 	/* 0x416b */
        {8,	0}, 	/* 0x416c */
        {8,	0}, 	/* 0x416d */
        {8,	0}, 	/* 0x416e */
        {8,	0}, 	/* 0x416f */
        {8,	0}, 	/* 0x4170 */
        {8,	0}, 	/* 0x4171 */
        {8,	0}, 	/* 0x4172 */
        {8,	0}, 	/* 0x4173 */
        {8,	0}, 	/* 0x4174 */
        {8,	0}, 	/* 0x4175 */
        {8,	0}, 	/* 0x4176 */
        {8,	0}, 	/* 0x4177 */
        {8,	0}, 	/* 0x4178 */
        {8,	0}, 	/* 0x4179 */
        {8,	0}, 	/* 0x417a */
        {8,	0}, 	/* 0x417b */
        {8,	0}, 	/* 0x417c */
        {8,	0}, 	/* 0x417d */
        {8,	0}, 	/* 0x417e */
        {8,	0}, 	/* 0x417f */
        {8,	0}, 	/* 0x4180 */
        {8,	0}, 	/* 0x4181 */
        {8,	0}, 	/* 0x4182 */
        {8,	0}, 	/* 0x4183 */
        {8,	0}, 	/* 0x4184 */
        {8,	0}, 	/* 0x4185 */
        {8,	0}, 	/* 0x4186 */
        {8,	0}, 	/* 0x4187 */
        {8,	0}, 	/* 0x4188 */
        {8,	0}, 	/* 0x4189 */
        {8,	0}, 	/* 0x418a */
        {8,	0}, 	/* 0x418b */
        {8,	0}, 	/* 0x418c */
        {8,	0}, 	/* 0x418d */
        {8,	0}, 	/* 0x418e */
        {8,	0}, 	/* 0x418f */
        {8,	0}, 	/* 0x4190 */
        {8,	0}, 	/* 0x4191 */
        {8,	0}, 	/* 0x4192 */
        {8,	0}, 	/* 0x4193 */
        {8,	0}, 	/* 0x4194 */
        {8,	0}, 	/* 0x4195 */
        {8,	0}, 	/* 0x4196 */
        {8,	0}, 	/* 0x4197 */
        {8,	0}, 	/* 0x4198 */
        {8,	0}, 	/* 0x4199 */
        {8,	0}, 	/* 0x419a */
        {8,	0}, 	/* 0x419b */
        {8,	0}, 	/* 0x419c */
        {8,	0}, 	/* 0x419d */
        {8,	0}, 	/* 0x419e */
        {8,	0}, 	/* 0x419f */
        {8,	0}, 	/* 0x41a0 */
        {8,	0}, 	/* 0x41a1 */
        {8,	0}, 	/* 0x41a2 */
        {8,	0}, 	/* 0x41a3 */
        {8,	0}, 	/* 0x41a4 */
        {8,	0}, 	/* 0x41a5 */
        {8,	0}, 	/* 0x41a6 */
        {8,	0}, 	/* 0x41a7 */
        {8,	0}, 	/* 0x41a8 */
        {8,	0}, 	/* 0x41a9 */
        {8,	0}, 	/* 0x41aa */
        {8,	0}, 	/* 0x41ab */
        {8,	0}, 	/* 0x41ac */
        {8,	0}, 	/* 0x41ad */
        {8,	0}, 	/* 0x41ae */
        {8,	0}, 	/* 0x41af */
        {8,	0}, 	/* 0x41b0 */
        {8,	0}, 	/* 0x41b1 */
        {8,	0}, 	/* 0x41b2 */
        {8,	0}, 	/* 0x41b3 */
        {8,	0}, 	/* 0x41b4 */
        {8,	0}, 	/* 0x41b5 */
        {8,	0}, 	/* 0x41b6 */
        {8,	0}, 	/* 0x41b7 */
        {8,	0}, 	/* 0x41b8 */
        {8,	0}, 	/* 0x41b9 */
        {8,	0}, 	/* 0x41ba */
        {8,	0}, 	/* 0x41bb */
        {8,	0}, 	/* 0x41bc */
        {8,	0}, 	/* 0x41bd */
        {8,	0}, 	/* 0x41be */
        {8,	0}, 	/* 0x41bf */
        {8,	0}, 	/* 0x41c0 */
        {8,	0}, 	/* 0x41c1 */
        {8,	0}, 	/* 0x41c2 */
        {8,	0}, 	/* 0x41c3 */
        {8,	0}, 	/* 0x41c4 */
        {8,	0}, 	/* 0x41c5 */
        {8,	0}, 	/* 0x41c6 */
        {8,	0}, 	/* 0x41c7 */
        {8,	0}, 	/* 0x41c8 */
        {8,	0}, 	/* 0x41c9 */
        {8,	0}, 	/* 0x41ca */
        {8,	0}, 	/* 0x41cb */
        {8,	0}, 	/* 0x41cc */
        {8,	0}, 	/* 0x41cd */
        {8,	0}, 	/* 0x41ce */
        {8,	0}, 	/* 0x41cf */
        {8,	0}, 	/* 0x41d0 */
        {8,	0}, 	/* 0x41d1 */
        {8,	0}, 	/* 0x41d2 */
        {8,	0}, 	/* 0x41d3 */
        {8,	0}, 	/* 0x41d4 */
        {8,	0}, 	/* 0x41d5 */
        {8,	0}, 	/* 0x41d6 */
        {8,	0}, 	/* 0x41d7 */
        {8,	0}, 	/* 0x41d8 */
        {8,	0}, 	/* 0x41d9 */
        {8,	0}, 	/* 0x41da */
        {8,	0}, 	/* 0x41db */
        {8,	0}, 	/* 0x41dc */
        {8,	0}, 	/* 0x41dd */
        {8,	0}, 	/* 0x41de */
        {8,	0}, 	/* 0x41df */
        {8,	0}, 	/* 0x41e0 */
        {8,	0}, 	/* 0x41e1 */
        {8,	0}, 	/* 0x41e2 */
        {8,	0}, 	/* 0x41e3 */
        {8,	0}, 	/* 0x41e4 */
        {8,	0}, 	/* 0x41e5 */
        {8,	0}, 	/* 0x41e6 */
        {8,	0}, 	/* 0x41e7 */
        {8,	0}, 	/* 0x41e8 */
        {8,	0}, 	/* 0x41e9 */
        {8,	0}, 	/* 0x41ea */
        {8,	0}, 	/* 0x41eb */
        {8,	0}, 	/* 0x41ec */
        {8,	0}, 	/* 0x41ed */
        {8,	0}, 	/* 0x41ee */
        {8,	0}, 	/* 0x41ef */
        {8,	0}, 	/* 0x41f0 */
        {8,	0}, 	/* 0x41f1 */
        {8,	0}, 	/* 0x41f2 */
        {8,	0}, 	/* 0x41f3 */
        {8,	0}, 	/* 0x41f4 */
        {8,	0}, 	/* 0x41f5 */
        {8,	0}, 	/* 0x41f6 */
        {8,	0}, 	/* 0x41f7 */
        {8,	0}, 	/* 0x41f8 */
        {8,	0}, 	/* 0x41f9 */
        {8,	0}, 	/* 0x41fa */
        {8,	0}, 	/* 0x41fb */
        {8,	0}, 	/* 0x41fc */
        {8,	0}, 	/* 0x41fd */
        {8,	0}, 	/* 0x41fe */
        {8,	0}, 	/* 0x41ff */
        {8,	0}, 	/* 0x4200 */
        {8,	0}, 	/* 0x4201 */
        {8,	0}, 	/* 0x4202 */
        {8,	0}, 	/* 0x4203 */
        {8,	0}, 	/* 0x4204 */
        {8,	0}, 	/* 0x4205 */
        {8,	0}, 	/* 0x4206 */
        {8,	0}, 	/* 0x4207 */
        {8,	0}, 	/* 0x4208 */
        {8,	0}, 	/* 0x4209 */
        {8,	0}, 	/* 0x420a */
        {8,	0}, 	/* 0x420b */
        {8,	0}, 	/* 0x420c */
        {8,	0}, 	/* 0x420d */
        {8,	0}, 	/* 0x420e */
        {8,	0}, 	/* 0x420f */
        {8,	0}, 	/* 0x4210 */
        {8,	0}, 	/* 0x4211 */
        {8,	0}, 	/* 0x4212 */
        {8,	0}, 	/* 0x4213 */
        {8,	0}, 	/* 0x4214 */
        {8,	0}, 	/* 0x4215 */
        {8,	0}, 	/* 0x4216 */
        {8,	0}, 	/* 0x4217 */
        {8,	0}, 	/* 0x4218 */
        {8,	0}, 	/* 0x4219 */
        {8,	0}, 	/* 0x421a */
        {8,	0}, 	/* 0x421b */
        {8,	0}, 	/* 0x421c */
        {8,	0}, 	/* 0x421d */
        {8,	0}, 	/* 0x421e */
        {8,	0}, 	/* 0x421f */
        {8,	0}, 	/* 0x4220 */
        {8,	0}, 	/* 0x4221 */
        {8,	0}, 	/* 0x4222 */
        {8,	0}, 	/* 0x4223 */
        {8,	0}, 	/* 0x4224 */
        {8,	0}, 	/* 0x4225 */
        {8,	0}, 	/* 0x4226 */
        {8,	0}, 	/* 0x4227 */
        {8,	0}, 	/* 0x4228 */
        {8,	0}, 	/* 0x4229 */
        {8,	0}, 	/* 0x422a */
        {8,	0}, 	/* 0x422b */
        {8,	0}, 	/* 0x422c */
        {8,	0}, 	/* 0x422d */
        {8,	0}, 	/* 0x422e */
        {8,	0}, 	/* 0x422f */
        {8,	0}, 	/* 0x4230 */
        {8,	0}, 	/* 0x4231 */
        {8,	0}, 	/* 0x4232 */
        {8,	0}, 	/* 0x4233 */
        {8,	0}, 	/* 0x4234 */
        {8,	0}, 	/* 0x4235 */
        {8,	0}, 	/* 0x4236 */
        {8,	0}, 	/* 0x4237 */
        {8,	0}, 	/* 0x4238 */
        {8,	0}, 	/* 0x4239 */
        {8,	0}, 	/* 0x423a */
        {8,	0}, 	/* 0x423b */
        {8,	0}, 	/* 0x423c */
        {8,	0}, 	/* 0x423d */
        {8,	0}, 	/* 0x423e */
        {8,	0}, 	/* 0x423f */
        {8,	0}, 	/* 0x4240 */
        {8,	0}, 	/* 0x4241 */
        {8,	0}, 	/* 0x4242 */
        {8,	0}, 	/* 0x4243 */
        {8,	0}, 	/* 0x4244 */
        {8,	0}, 	/* 0x4245 */
        {8,	0}, 	/* 0x4246 */
        {8,	0}, 	/* 0x4247 */
        {8,	0}, 	/* 0x4248 */
        {8,	0}, 	/* 0x4249 */
        {8,	0}, 	/* 0x424a */
        {8,	0}, 	/* 0x424b */
        {8,	0}, 	/* 0x424c */
        {8,	0}, 	/* 0x424d */
        {8,	0}, 	/* 0x424e */
        {8,	0}, 	/* 0x424f */
        {8,	0}, 	/* 0x4250 */
        {8,	0}, 	/* 0x4251 */
        {8,	0}, 	/* 0x4252 */
        {8,	0}, 	/* 0x4253 */
        {8,	0}, 	/* 0x4254 */
        {8,	0}, 	/* 0x4255 */
        {8,	0}, 	/* 0x4256 */
        {8,	0}, 	/* 0x4257 */
        {8,	0}, 	/* 0x4258 */
        {8,	0}, 	/* 0x4259 */
        {8,	0}, 	/* 0x425a */
        {8,	0}, 	/* 0x425b */
        {8,	0}, 	/* 0x425c */
        {8,	0}, 	/* 0x425d */
        {8,	0}, 	/* 0x425e */
        {8,	0}, 	/* 0x425f */
        {8,	0}, 	/* 0x4260 */
        {8,	0}, 	/* 0x4261 */
        {8,	0}, 	/* 0x4262 */
        {8,	0}, 	/* 0x4263 */
        {8,	0}, 	/* 0x4264 */
        {8,	0}, 	/* 0x4265 */
        {8,	0}, 	/* 0x4266 */
        {8,	0}, 	/* 0x4267 */
        {8,	0}, 	/* 0x4268 */
        {8,	0}, 	/* 0x4269 */
        {8,	0}, 	/* 0x426a */
        {8,	0}, 	/* 0x426b */
        {8,	0}, 	/* 0x426c */
        {8,	0}, 	/* 0x426d */
        {8,	0}, 	/* 0x426e */
        {8,	0}, 	/* 0x426f */
        {8,	0}, 	/* 0x4270 */
        {8,	0}, 	/* 0x4271 */
        {8,	0}, 	/* 0x4272 */
        {8,	0}, 	/* 0x4273 */
        {8,	0}, 	/* 0x4274 */
        {8,	0}, 	/* 0x4275 */
        {8,	0}, 	/* 0x4276 */
        {8,	0}, 	/* 0x4277 */
        {8,	0}, 	/* 0x4278 */
        {8,	0}, 	/* 0x4279 */
        {8,	0}, 	/* 0x427a */
        {8,	0}, 	/* 0x427b */
        {8,	0}, 	/* 0x427c */
        {8,	0}, 	/* 0x427d */
        {8,	0}, 	/* 0x427e */
        {8,	0}, 	/* 0x427f */
        {8,	0}, 	/* 0x4280 */
        {8,	0}, 	/* 0x4281 */
        {8,	0}, 	/* 0x4282 */
        {8,	0}, 	/* 0x4283 */
        {8,	0}, 	/* 0x4284 */
        {8,	0}, 	/* 0x4285 */
        {8,	0}, 	/* 0x4286 */
        {8,	0}, 	/* 0x4287 */
        {8,	0}, 	/* 0x4288 */
        {8,	0}, 	/* 0x4289 */
        {8,	0}, 	/* 0x428a */
        {8,	0}, 	/* 0x428b */
        {8,	0}, 	/* 0x428c */
        {8,	0}, 	/* 0x428d */
        {8,	0}, 	/* 0x428e */
        {8,	0}, 	/* 0x428f */
        {8,	0}, 	/* 0x4290 */
        {8,	0}, 	/* 0x4291 */
        {8,	0}, 	/* 0x4292 */
        {8,	0}, 	/* 0x4293 */
        {8,	0}, 	/* 0x4294 */
        {8,	0}, 	/* 0x4295 */
        {8,	0}, 	/* 0x4296 */
        {8,	0}, 	/* 0x4297 */
        {8,	0}, 	/* 0x4298 */
        {8,	0}, 	/* 0x4299 */
        {8,	0}, 	/* 0x429a */
        {8,	0}, 	/* 0x429b */
        {8,	0}, 	/* 0x429c */
        {8,	0}, 	/* 0x429d */
        {8,	0}, 	/* 0x429e */
        {8,	0}, 	/* 0x429f */
        {8,	0}, 	/* 0x42a0 */
        {8,	0}, 	/* 0x42a1 */
        {8,	0}, 	/* 0x42a2 */
        {8,	0}, 	/* 0x42a3 */
        {8,	0}, 	/* 0x42a4 */
        {8,	0}, 	/* 0x42a5 */
        {8,	0}, 	/* 0x42a6 */
        {8,	0}, 	/* 0x42a7 */
        {8,	0}, 	/* 0x42a8 */
        {8,	0}, 	/* 0x42a9 */
        {8,	0}, 	/* 0x42aa */
        {8,	0}, 	/* 0x42ab */
        {8,	0}, 	/* 0x42ac */
        {8,	0}, 	/* 0x42ad */
        {8,	0}, 	/* 0x42ae */
        {8,	0}, 	/* 0x42af */
        {8,	0}, 	/* 0x42b0 */
        {8,	0}, 	/* 0x42b1 */
        {8,	0}, 	/* 0x42b2 */
        {8,	0}, 	/* 0x42b3 */
        {8,	0}, 	/* 0x42b4 */
        {8,	0}, 	/* 0x42b5 */
        {8,	0}, 	/* 0x42b6 */
        {8,	0}, 	/* 0x42b7 */
        {8,	0}, 	/* 0x42b8 */
        {8,	0}, 	/* 0x42b9 */
        {8,	0}, 	/* 0x42ba */
        {8,	0}, 	/* 0x42bb */
        {8,	0}, 	/* 0x42bc */
        {8,	0}, 	/* 0x42bd */
        {8,	0}, 	/* 0x42be */
        {8,	0}, 	/* 0x42bf */
        {8,	0}, 	/* 0x42c0 */
        {8,	0}, 	/* 0x42c1 */
        {8,	0}, 	/* 0x42c2 */
        {8,	0}, 	/* 0x42c3 */
        {8,	0}, 	/* 0x42c4 */
        {8,	0}, 	/* 0x42c5 */
        {8,	0}, 	/* 0x42c6 */
        {8,	0}, 	/* 0x42c7 */
        {8,	0}, 	/* 0x42c8 */
        {8,	0}, 	/* 0x42c9 */
        {8,	0}, 	/* 0x42ca */
        {8,	0}, 	/* 0x42cb */
        {8,	0}, 	/* 0x42cc */
        {8,	0}, 	/* 0x42cd */
        {8,	0}, 	/* 0x42ce */
        {8,	0}, 	/* 0x42cf */
        {8,	0}, 	/* 0x42d0 */
        {8,	0}, 	/* 0x42d1 */
        {8,	0}, 	/* 0x42d2 */
        {8,	0}, 	/* 0x42d3 */
        {8,	0}, 	/* 0x42d4 */
        {8,	0}, 	/* 0x42d5 */
        {8,	0}, 	/* 0x42d6 */
        {8,	0}, 	/* 0x42d7 */
        {8,	0}, 	/* 0x42d8 */
        {8,	0}, 	/* 0x42d9 */
        {8,	0}, 	/* 0x42da */
        {8,	0}, 	/* 0x42db */
        {8,	0}, 	/* 0x42dc */
        {8,	0}, 	/* 0x42dd */
        {8,	0}, 	/* 0x42de */
        {8,	0}, 	/* 0x42df */
        {8,	0}, 	/* 0x42e0 */
        {8,	0}, 	/* 0x42e1 */
        {8,	0}, 	/* 0x42e2 */
        {8,	0}, 	/* 0x42e3 */
        {8,	0}, 	/* 0x42e4 */
        {8,	0}, 	/* 0x42e5 */
        {8,	0}, 	/* 0x42e6 */
        {8,	0}, 	/* 0x42e7 */
        {8,	0}, 	/* 0x42e8 */
        {8,	0}, 	/* 0x42e9 */
        {8,	0}, 	/* 0x42ea */
        {8,	0}, 	/* 0x42eb */
        {8,	0}, 	/* 0x42ec */
        {8,	0}, 	/* 0x42ed */
        {8,	0}, 	/* 0x42ee */
        {8,	0}, 	/* 0x42ef */
        {8,	0}, 	/* 0x42f0 */
        {8,	0}, 	/* 0x42f1 */
        {8,	0}, 	/* 0x42f2 */
        {8,	0}, 	/* 0x42f3 */
        {8,	0}, 	/* 0x42f4 */
        {8,	0}, 	/* 0x42f5 */
        {8,	0}, 	/* 0x42f6 */
        {8,	0}, 	/* 0x42f7 */
        {8,	0}, 	/* 0x42f8 */
        {8,	0}, 	/* 0x42f9 */
        {8,	0}, 	/* 0x42fa */
        {8,	0}, 	/* 0x42fb */
        {8,	0}, 	/* 0x42fc */
        {8,	0}, 	/* 0x42fd */
        {8,	0}, 	/* 0x42fe */
        {8,	0}, 	/* 0x42ff */
        {8,	0}, 	/* 0x4300 */
        {8,	0}, 	/* 0x4301 */
        {8,	0}, 	/* 0x4302 */
        {8,	0}, 	/* 0x4303 */
        {8,	0}, 	/* 0x4304 */
        {8,	0}, 	/* 0x4305 */
        {8,	0}, 	/* 0x4306 */
        {8,	0}, 	/* 0x4307 */
        {8,	0}, 	/* 0x4308 */
        {8,	0}, 	/* 0x4309 */
        {8,	0}, 	/* 0x430a */
        {8,	0}, 	/* 0x430b */
        {8,	0}, 	/* 0x430c */
        {8,	0}, 	/* 0x430d */
        {8,	0}, 	/* 0x430e */
        {8,	0}, 	/* 0x430f */
        {8,	0}, 	/* 0x4310 */
        {8,	0}, 	/* 0x4311 */
        {8,	0}, 	/* 0x4312 */
        {8,	0}, 	/* 0x4313 */
        {8,	0}, 	/* 0x4314 */
        {8,	0}, 	/* 0x4315 */
        {8,	0}, 	/* 0x4316 */
        {8,	0}, 	/* 0x4317 */
        {8,	0}, 	/* 0x4318 */
        {8,	0}, 	/* 0x4319 */
        {8,	0}, 	/* 0x431a */
        {8,	0}, 	/* 0x431b */
        {8,	0}, 	/* 0x431c */
        {8,	0}, 	/* 0x431d */
        {8,	0}, 	/* 0x431e */
        {8,	0}, 	/* 0x431f */
        {8,	0}, 	/* 0x4320 */
        {8,	0}, 	/* 0x4321 */
        {8,	0}, 	/* 0x4322 */
        {8,	0}, 	/* 0x4323 */
        {8,	0}, 	/* 0x4324 */
        {8,	0}, 	/* 0x4325 */
        {8,	0}, 	/* 0x4326 */
        {8,	0}, 	/* 0x4327 */
        {8,	0}, 	/* 0x4328 */
        {8,	0}, 	/* 0x4329 */
        {8,	0}, 	/* 0x432a */
        {8,	0}, 	/* 0x432b */
        {8,	0}, 	/* 0x432c */
        {8,	0}, 	/* 0x432d */
        {8,	0}, 	/* 0x432e */
        {8,	0}, 	/* 0x432f */
        {8,	0}, 	/* 0x4330 */
        {8,	0}, 	/* 0x4331 */
        {8,	0}, 	/* 0x4332 */
        {8,	0}, 	/* 0x4333 */
        {8,	0}, 	/* 0x4334 */
        {8,	0}, 	/* 0x4335 */
        {8,	0}, 	/* 0x4336 */
        {8,	0}, 	/* 0x4337 */
        {8,	0}, 	/* 0x4338 */
        {8,	0}, 	/* 0x4339 */
        {8,	0}, 	/* 0x433a */
        {8,	0}, 	/* 0x433b */
        {8,	0}, 	/* 0x433c */
        {8,	0}, 	/* 0x433d */
        {8,	0}, 	/* 0x433e */
        {8,	0}, 	/* 0x433f */
        {8,	0}, 	/* 0x4340 */
        {8,	0}, 	/* 0x4341 */
        {8,	0}, 	/* 0x4342 */
        {8,	0}, 	/* 0x4343 */
        {8,	0}, 	/* 0x4344 */
        {8,	0}, 	/* 0x4345 */
        {8,	0}, 	/* 0x4346 */
        {8,	0}, 	/* 0x4347 */
        {8,	0}, 	/* 0x4348 */
        {8,	0}, 	/* 0x4349 */
        {8,	0}, 	/* 0x434a */
        {8,	0}, 	/* 0x434b */
        {8,	0}, 	/* 0x434c */
        {8,	0}, 	/* 0x434d */
        {8,	0}, 	/* 0x434e */
        {8,	0}, 	/* 0x434f */
        {8,	0}, 	/* 0x4350 */
        {8,	0}, 	/* 0x4351 */
        {8,	0}, 	/* 0x4352 */
        {8,	0}, 	/* 0x4353 */
        {8,	0}, 	/* 0x4354 */
        {8,	0}, 	/* 0x4355 */
        {8,	0}, 	/* 0x4356 */
        {8,	0}, 	/* 0x4357 */
        {8,	0}, 	/* 0x4358 */
        {8,	0}, 	/* 0x4359 */
        {8,	0}, 	/* 0x435a */
        {8,	0}, 	/* 0x435b */
        {8,	0}, 	/* 0x435c */
        {8,	0}, 	/* 0x435d */
        {8,	0}, 	/* 0x435e */
        {8,	0}, 	/* 0x435f */
        {8,	0}, 	/* 0x4360 */
        {8,	0}, 	/* 0x4361 */
        {8,	0}, 	/* 0x4362 */
        {8,	0}, 	/* 0x4363 */
        {8,	0}, 	/* 0x4364 */
        {8,	0}, 	/* 0x4365 */
        {8,	0}, 	/* 0x4366 */
        {8,	0}, 	/* 0x4367 */
        {8,	0}, 	/* 0x4368 */
        {8,	0}, 	/* 0x4369 */
        {8,	0}, 	/* 0x436a */
        {8,	0}, 	/* 0x436b */
        {8,	0}, 	/* 0x436c */
        {8,	0}, 	/* 0x436d */
        {8,	0}, 	/* 0x436e */
        {8,	0}, 	/* 0x436f */
        {8,	0}, 	/* 0x4370 */
        {8,	0}, 	/* 0x4371 */
        {8,	0}, 	/* 0x4372 */
        {8,	0}, 	/* 0x4373 */
        {8,	0}, 	/* 0x4374 */
        {8,	0}, 	/* 0x4375 */
        {8,	0}, 	/* 0x4376 */
        {8,	0}, 	/* 0x4377 */
        {8,	0}, 	/* 0x4378 */
        {8,	0}, 	/* 0x4379 */
        {8,	0}, 	/* 0x437a */
        {8,	0}, 	/* 0x437b */
        {8,	0}, 	/* 0x437c */
        {8,	0}, 	/* 0x437d */
        {8,	0}, 	/* 0x437e */
        {8,	0}, 	/* 0x437f */
        {8,	0}, 	/* 0x4380 */
        {8,	0}, 	/* 0x4381 */
        {8,	0}, 	/* 0x4382 */
        {8,	0}, 	/* 0x4383 */
        {8,	0}, 	/* 0x4384 */
        {8,	0}, 	/* 0x4385 */
        {8,	0}, 	/* 0x4386 */
        {8,	0}, 	/* 0x4387 */
        {8,	0}, 	/* 0x4388 */
        {8,	0}, 	/* 0x4389 */
        {8,	0}, 	/* 0x438a */
        {8,	0}, 	/* 0x438b */
        {8,	0}, 	/* 0x438c */
        {8,	0}, 	/* 0x438d */
        {8,	0}, 	/* 0x438e */
        {8,	0}, 	/* 0x438f */
        {8,	0}, 	/* 0x4390 */
        {8,	0}, 	/* 0x4391 */
        {8,	0}, 	/* 0x4392 */
        {8,	0}, 	/* 0x4393 */
        {8,	0}, 	/* 0x4394 */
        {8,	0}, 	/* 0x4395 */
        {8,	0}, 	/* 0x4396 */
        {8,	0}, 	/* 0x4397 */
        {8,	0}, 	/* 0x4398 */
        {8,	0}, 	/* 0x4399 */
        {8,	0}, 	/* 0x439a */
        {8,	0}, 	/* 0x439b */
        {8,	0}, 	/* 0x439c */
        {8,	0}, 	/* 0x439d */
        {8,	0}, 	/* 0x439e */
        {8,	0}, 	/* 0x439f */
        {8,	0}, 	/* 0x43a0 */
        {8,	0}, 	/* 0x43a1 */
        {8,	0}, 	/* 0x43a2 */
        {8,	0}, 	/* 0x43a3 */
        {8,	0}, 	/* 0x43a4 */
        {8,	0}, 	/* 0x43a5 */
        {8,	0}, 	/* 0x43a6 */
        {8,	0}, 	/* 0x43a7 */
        {8,	0}, 	/* 0x43a8 */
        {8,	0}, 	/* 0x43a9 */
        {8,	0}, 	/* 0x43aa */
        {8,	0}, 	/* 0x43ab */
        {8,	0}, 	/* 0x43ac */
        {8,	0}, 	/* 0x43ad */
        {8,	0}, 	/* 0x43ae */
        {8,	0}, 	/* 0x43af */
        {8,	0}, 	/* 0x43b0 */
        {8,	0}, 	/* 0x43b1 */
        {8,	0}, 	/* 0x43b2 */
        {8,	0}, 	/* 0x43b3 */
        {8,	0}, 	/* 0x43b4 */
        {8,	0}, 	/* 0x43b5 */
        {8,	0}, 	/* 0x43b6 */
        {8,	0}, 	/* 0x43b7 */
        {8,	0}, 	/* 0x43b8 */
        {8,	0}, 	/* 0x43b9 */
        {8,	0}, 	/* 0x43ba */
        {8,	0}, 	/* 0x43bb */
        {8,	0}, 	/* 0x43bc */
        {8,	0}, 	/* 0x43bd */
        {8,	0}, 	/* 0x43be */
        {8,	0}, 	/* 0x43bf */
        {8,	0}, 	/* 0x43c0 */
        {8,	0}, 	/* 0x43c1 */
        {8,	0}, 	/* 0x43c2 */
        {8,	0}, 	/* 0x43c3 */
        {8,	0}, 	/* 0x43c4 */
        {8,	0}, 	/* 0x43c5 */
        {8,	0}, 	/* 0x43c6 */
        {8,	0}, 	/* 0x43c7 */
        {8,	0}, 	/* 0x43c8 */
        {8,	0}, 	/* 0x43c9 */
        {8,	0}, 	/* 0x43ca */
        {8,	0}, 	/* 0x43cb */
        {8,	0}, 	/* 0x43cc */
        {8,	0}, 	/* 0x43cd */
        {8,	0}, 	/* 0x43ce */
        {8,	0}, 	/* 0x43cf */
        {8,	0}, 	/* 0x43d0 */
        {8,	0}, 	/* 0x43d1 */
        {8,	0}, 	/* 0x43d2 */
        {8,	0}, 	/* 0x43d3 */
        {8,	0}, 	/* 0x43d4 */
        {8,	0}, 	/* 0x43d5 */
        {8,	0}, 	/* 0x43d6 */
        {8,	0}, 	/* 0x43d7 */
        {8,	0}, 	/* 0x43d8 */
        {8,	0}, 	/* 0x43d9 */
        {8,	0}, 	/* 0x43da */
        {8,	0}, 	/* 0x43db */
        {8,	0}, 	/* 0x43dc */
        {8,	0}, 	/* 0x43dd */
        {8,	0}, 	/* 0x43de */
        {8,	0}, 	/* 0x43df */
        {8,	0}, 	/* 0x43e0 */
        {8,	0}, 	/* 0x43e1 */
        {8,	0}, 	/* 0x43e2 */
        {8,	0}, 	/* 0x43e3 */
        {8,	0}, 	/* 0x43e4 */
        {8,	0}, 	/* 0x43e5 */
        {8,	0}, 	/* 0x43e6 */
        {8,	0}, 	/* 0x43e7 */
        {8,	0}, 	/* 0x43e8 */
        {8,	0}, 	/* 0x43e9 */
        {8,	0}, 	/* 0x43ea */
        {8,	0}, 	/* 0x43eb */
        {8,	0}, 	/* 0x43ec */
        {8,	0}, 	/* 0x43ed */
        {8,	0}, 	/* 0x43ee */
        {8,	0}, 	/* 0x43ef */
        {8,	0}, 	/* 0x43f0 */
        {8,	0}, 	/* 0x43f1 */
        {8,	0}, 	/* 0x43f2 */
        {8,	0}, 	/* 0x43f3 */
        {8,	0}, 	/* 0x43f4 */
        {8,	0}, 	/* 0x43f5 */
        {8,	0}, 	/* 0x43f6 */
        {8,	0}, 	/* 0x43f7 */
        {8,	0}, 	/* 0x43f8 */
        {8,	0}, 	/* 0x43f9 */
        {8,	0}, 	/* 0x43fa */
        {8,	0}, 	/* 0x43fb */
        {8,	0}, 	/* 0x43fc */
        {8,	0}, 	/* 0x43fd */
        {8,	0}, 	/* 0x43fe */
        {8,	0}, 	/* 0x43ff */
        {8,	0}, 	/* 0x4400 */
        {8,	0}, 	/* 0x4401 */
        {8,	0}, 	/* 0x4402 */
        {8,	0}, 	/* 0x4403 */
        {8,	0}, 	/* 0x4404 */
        {8,	0}, 	/* 0x4405 */
        {8,	0}, 	/* 0x4406 */
        {8,	0}, 	/* 0x4407 */
        {8,	0}, 	/* 0x4408 */
        {8,	0}, 	/* 0x4409 */
        {8,	0}, 	/* 0x440a */
        {8,	0}, 	/* 0x440b */
        {8,	0}, 	/* 0x440c */
        {8,	0}, 	/* 0x440d */
        {8,	0}, 	/* 0x440e */
        {8,	0}, 	/* 0x440f */
        {8,	0}, 	/* 0x4410 */
        {8,	0}, 	/* 0x4411 */
        {8,	0}, 	/* 0x4412 */
        {8,	0}, 	/* 0x4413 */
        {8,	0}, 	/* 0x4414 */
        {8,	0}, 	/* 0x4415 */
        {8,	0}, 	/* 0x4416 */
        {8,	0}, 	/* 0x4417 */
        {8,	0}, 	/* 0x4418 */
        {8,	0}, 	/* 0x4419 */
        {8,	0}, 	/* 0x441a */
        {8,	0}, 	/* 0x441b */
        {8,	0}, 	/* 0x441c */
        {8,	0}, 	/* 0x441d */
        {8,	0}, 	/* 0x441e */
        {8,	0}, 	/* 0x441f */
        {8,	0}, 	/* 0x4420 */
        {8,	0}, 	/* 0x4421 */
        {8,	0}, 	/* 0x4422 */
        {8,	0}, 	/* 0x4423 */
        {8,	0}, 	/* 0x4424 */
        {8,	0}, 	/* 0x4425 */
        {8,	0}, 	/* 0x4426 */
        {8,	0}, 	/* 0x4427 */
        {8,	0}, 	/* 0x4428 */
        {8,	0}, 	/* 0x4429 */
        {8,	0}, 	/* 0x442a */
        {8,	0}, 	/* 0x442b */
        {8,	0}, 	/* 0x442c */
        {8,	0}, 	/* 0x442d */
        {8,	0}, 	/* 0x442e */
        {8,	0}, 	/* 0x442f */
        {8,	0}, 	/* 0x4430 */
        {8,	0}, 	/* 0x4431 */
        {8,	0}, 	/* 0x4432 */
        {8,	0}, 	/* 0x4433 */
        {8,	0}, 	/* 0x4434 */
        {8,	0}, 	/* 0x4435 */
        {8,	0}, 	/* 0x4436 */
        {8,	0}, 	/* 0x4437 */
        {8,	0}, 	/* 0x4438 */
        {8,	0}, 	/* 0x4439 */
        {8,	0}, 	/* 0x443a */
        {8,	0}, 	/* 0x443b */
        {8,	0}, 	/* 0x443c */
        {8,	0}, 	/* 0x443d */
        {8,	0}, 	/* 0x443e */
        {8,	0}, 	/* 0x443f */
        {8,	0}, 	/* 0x4440 */
        {8,	0}, 	/* 0x4441 */
        {8,	0}, 	/* 0x4442 */
        {8,	0}, 	/* 0x4443 */
        {8,	0}, 	/* 0x4444 */
        {8,	0}, 	/* 0x4445 */
        {8,	0}, 	/* 0x4446 */
        {8,	0}, 	/* 0x4447 */
        {8,	0}, 	/* 0x4448 */
        {8,	0}, 	/* 0x4449 */
        {8,	0}, 	/* 0x444a */
        {8,	0}, 	/* 0x444b */
        {8,	0}, 	/* 0x444c */
        {8,	0}, 	/* 0x444d */
        {8,	0}, 	/* 0x444e */
        {8,	0}, 	/* 0x444f */
        {8,	0}, 	/* 0x4450 */
        {8,	0}, 	/* 0x4451 */
        {8,	0}, 	/* 0x4452 */
        {8,	0}, 	/* 0x4453 */
        {8,	0}, 	/* 0x4454 */
        {8,	0}, 	/* 0x4455 */
        {8,	0}, 	/* 0x4456 */
        {8,	0}, 	/* 0x4457 */
        {8,	0}, 	/* 0x4458 */
        {8,	0}, 	/* 0x4459 */
        {8,	0}, 	/* 0x445a */
        {8,	0}, 	/* 0x445b */
        {8,	0}, 	/* 0x445c */
        {8,	0}, 	/* 0x445d */
        {8,	0}, 	/* 0x445e */
        {8,	0}, 	/* 0x445f */
        {8,	0}, 	/* 0x4460 */
        {8,	0}, 	/* 0x4461 */
        {8,	0}, 	/* 0x4462 */
        {8,	0}, 	/* 0x4463 */
        {8,	0}, 	/* 0x4464 */
        {8,	0}, 	/* 0x4465 */
        {8,	0}, 	/* 0x4466 */
        {8,	0}, 	/* 0x4467 */
        {8,	0}, 	/* 0x4468 */
        {8,	0}, 	/* 0x4469 */
        {8,	0}, 	/* 0x446a */
        {8,	0}, 	/* 0x446b */
        {8,	0}, 	/* 0x446c */
        {8,	0}, 	/* 0x446d */
        {8,	0}, 	/* 0x446e */
        {8,	0}, 	/* 0x446f */
        {8,	0}, 	/* 0x4470 */
        {8,	0}, 	/* 0x4471 */
        {8,	0}, 	/* 0x4472 */
        {8,	0}, 	/* 0x4473 */
        {8,	0}, 	/* 0x4474 */
        {8,	0}, 	/* 0x4475 */
        {8,	0}, 	/* 0x4476 */
        {8,	0}, 	/* 0x4477 */
        {8,	0}, 	/* 0x4478 */
        {8,	0}, 	/* 0x4479 */
        {8,	0}, 	/* 0x447a */
        {8,	0}, 	/* 0x447b */
        {8,	0}, 	/* 0x447c */
        {8,	0}, 	/* 0x447d */
        {8,	0}, 	/* 0x447e */
        {8,	0}, 	/* 0x447f */
        {8,	0}, 	/* 0x4480 */
        {8,	0}, 	/* 0x4481 */
        {8,	0}, 	/* 0x4482 */
        {8,	0}, 	/* 0x4483 */
        {8,	0}, 	/* 0x4484 */
        {8,	0}, 	/* 0x4485 */
        {8,	0}, 	/* 0x4486 */
        {8,	0}, 	/* 0x4487 */
        {8,	0}, 	/* 0x4488 */
        {8,	0}, 	/* 0x4489 */
        {8,	0}, 	/* 0x448a */
        {8,	0}, 	/* 0x448b */
        {8,	0}, 	/* 0x448c */
        {8,	0}, 	/* 0x448d */
        {8,	0}, 	/* 0x448e */
        {8,	0}, 	/* 0x448f */
        {8,	0}, 	/* 0x4490 */
        {8,	0}, 	/* 0x4491 */
        {8,	0}, 	/* 0x4492 */
        {8,	0}, 	/* 0x4493 */
        {8,	0}, 	/* 0x4494 */
        {8,	0}, 	/* 0x4495 */
        {8,	0}, 	/* 0x4496 */
        {8,	0}, 	/* 0x4497 */
        {8,	0}, 	/* 0x4498 */
        {8,	0}, 	/* 0x4499 */
        {8,	0}, 	/* 0x449a */
        {8,	0}, 	/* 0x449b */
        {8,	0}, 	/* 0x449c */
        {8,	0}, 	/* 0x449d */
        {8,	0}, 	/* 0x449e */
        {8,	0}, 	/* 0x449f */
        {8,	0}, 	/* 0x44a0 */
        {8,	0}, 	/* 0x44a1 */
        {8,	0}, 	/* 0x44a2 */
        {8,	0}, 	/* 0x44a3 */
        {8,	0}, 	/* 0x44a4 */
        {8,	0}, 	/* 0x44a5 */
        {8,	0}, 	/* 0x44a6 */
        {8,	0}, 	/* 0x44a7 */
        {8,	0}, 	/* 0x44a8 */
        {8,	0}, 	/* 0x44a9 */
        {8,	0}, 	/* 0x44aa */
        {8,	0}, 	/* 0x44ab */
        {8,	0}, 	/* 0x44ac */
        {8,	0}, 	/* 0x44ad */
        {8,	0}, 	/* 0x44ae */
        {8,	0}, 	/* 0x44af */
        {8,	0}, 	/* 0x44b0 */
        {8,	0}, 	/* 0x44b1 */
        {8,	0}, 	/* 0x44b2 */
        {8,	0}, 	/* 0x44b3 */
        {8,	0}, 	/* 0x44b4 */
        {8,	0}, 	/* 0x44b5 */
        {8,	0}, 	/* 0x44b6 */
        {8,	0}, 	/* 0x44b7 */
        {8,	0}, 	/* 0x44b8 */
        {8,	0}, 	/* 0x44b9 */
        {8,	0}, 	/* 0x44ba */
        {8,	0}, 	/* 0x44bb */
        {8,	0}, 	/* 0x44bc */
        {8,	0}, 	/* 0x44bd */
        {8,	0}, 	/* 0x44be */
        {8,	0}, 	/* 0x44bf */
        {8,	0}, 	/* 0x44c0 */
        {8,	0}, 	/* 0x44c1 */
        {8,	0}, 	/* 0x44c2 */
        {8,	0}, 	/* 0x44c3 */
        {8,	0}, 	/* 0x44c4 */
        {8,	0}, 	/* 0x44c5 */
        {8,	0}, 	/* 0x44c6 */
        {8,	0}, 	/* 0x44c7 */
        {8,	0}, 	/* 0x44c8 */
        {8,	0}, 	/* 0x44c9 */
        {8,	0}, 	/* 0x44ca */
        {8,	0}, 	/* 0x44cb */
        {8,	0}, 	/* 0x44cc */
        {8,	0}, 	/* 0x44cd */
        {8,	0}, 	/* 0x44ce */
        {8,	0}, 	/* 0x44cf */
        {8,	0}, 	/* 0x44d0 */
        {8,	0}, 	/* 0x44d1 */
        {8,	0}, 	/* 0x44d2 */
        {8,	0}, 	/* 0x44d3 */
        {8,	0}, 	/* 0x44d4 */
        {8,	0}, 	/* 0x44d5 */
        {8,	0}, 	/* 0x44d6 */
        {8,	0}, 	/* 0x44d7 */
        {8,	0}, 	/* 0x44d8 */
        {8,	0}, 	/* 0x44d9 */
        {8,	0}, 	/* 0x44da */
        {8,	0}, 	/* 0x44db */
        {8,	0}, 	/* 0x44dc */
        {8,	0}, 	/* 0x44dd */
        {8,	0}, 	/* 0x44de */
        {8,	0}, 	/* 0x44df */
        {8,	0}, 	/* 0x44e0 */
        {8,	0}, 	/* 0x44e1 */
        {8,	0}, 	/* 0x44e2 */
        {8,	0}, 	/* 0x44e3 */
        {8,	0}, 	/* 0x44e4 */
        {8,	0}, 	/* 0x44e5 */
        {8,	0}, 	/* 0x44e6 */
        {8,	0}, 	/* 0x44e7 */
        {8,	0}, 	/* 0x44e8 */
        {8,	0}, 	/* 0x44e9 */
        {8,	0}, 	/* 0x44ea */
        {8,	0}, 	/* 0x44eb */
        {8,	0}, 	/* 0x44ec */
        {8,	0}, 	/* 0x44ed */
        {8,	0}, 	/* 0x44ee */
        {8,	0}, 	/* 0x44ef */
        {8,	0}, 	/* 0x44f0 */
        {8,	0}, 	/* 0x44f1 */
        {8,	0}, 	/* 0x44f2 */
        {8,	0}, 	/* 0x44f3 */
        {8,	0}, 	/* 0x44f4 */
        {8,	0}, 	/* 0x44f5 */
        {8,	0}, 	/* 0x44f6 */
        {8,	0}, 	/* 0x44f7 */
        {8,	0}, 	/* 0x44f8 */
        {8,	0}, 	/* 0x44f9 */
        {8,	0}, 	/* 0x44fa */
        {8,	0}, 	/* 0x44fb */
        {8,	0}, 	/* 0x44fc */
        {8,	0}, 	/* 0x44fd */
        {8,	0}, 	/* 0x44fe */
        {8,	0}, 	/* 0x44ff */
        {8,	0}, 	/* 0x4500 */
        {8,	0}, 	/* 0x4501 */
        {8,	0}, 	/* 0x4502 */
        {8,	0}, 	/* 0x4503 */
        {8,	0}, 	/* 0x4504 */
        {8,	0}, 	/* 0x4505 */
        {8,	0}, 	/* 0x4506 */
        {8,	0}, 	/* 0x4507 */
        {8,	0}, 	/* 0x4508 */
        {8,	0}, 	/* 0x4509 */
        {8,	0}, 	/* 0x450a */
        {8,	0}, 	/* 0x450b */
        {8,	0}, 	/* 0x450c */
        {8,	0}, 	/* 0x450d */
        {8,	0}, 	/* 0x450e */
        {8,	0}, 	/* 0x450f */
        {8,	0}, 	/* 0x4510 */
        {8,	0}, 	/* 0x4511 */
        {8,	0}, 	/* 0x4512 */
        {8,	0}, 	/* 0x4513 */
        {8,	0}, 	/* 0x4514 */
        {8,	0}, 	/* 0x4515 */
        {8,	0}, 	/* 0x4516 */
        {8,	0}, 	/* 0x4517 */
        {8,	0}, 	/* 0x4518 */
        {8,	0}, 	/* 0x4519 */
        {8,	0}, 	/* 0x451a */
        {8,	0}, 	/* 0x451b */
        {8,	0}, 	/* 0x451c */
        {8,	0}, 	/* 0x451d */
        {8,	0}, 	/* 0x451e */
        {8,	0}, 	/* 0x451f */
        {8,	0}, 	/* 0x4520 */
        {8,	0}, 	/* 0x4521 */
        {8,	0}, 	/* 0x4522 */
        {8,	0}, 	/* 0x4523 */
        {8,	0}, 	/* 0x4524 */
        {8,	0}, 	/* 0x4525 */
        {8,	0}, 	/* 0x4526 */
        {8,	0}, 	/* 0x4527 */
        {8,	0}, 	/* 0x4528 */
        {8,	0}, 	/* 0x4529 */
        {8,	0}, 	/* 0x452a */
        {8,	0}, 	/* 0x452b */
        {8,	0}, 	/* 0x452c */
        {8,	0}, 	/* 0x452d */
        {8,	0}, 	/* 0x452e */
        {8,	0}, 	/* 0x452f */
        {8,	0}, 	/* 0x4530 */
        {8,	0}, 	/* 0x4531 */
        {8,	0}, 	/* 0x4532 */
        {8,	0}, 	/* 0x4533 */
        {8,	0}, 	/* 0x4534 */
        {8,	0}, 	/* 0x4535 */
        {8,	0}, 	/* 0x4536 */
        {8,	0}, 	/* 0x4537 */
        {8,	0}, 	/* 0x4538 */
        {8,	0}, 	/* 0x4539 */
        {8,	0}, 	/* 0x453a */
        {8,	0}, 	/* 0x453b */
        {8,	0}, 	/* 0x453c */
        {8,	0}, 	/* 0x453d */
        {8,	0}, 	/* 0x453e */
        {8,	0}, 	/* 0x453f */
        {8,	0}, 	/* 0x4540 */
        {8,	0}, 	/* 0x4541 */
        {8,	0}, 	/* 0x4542 */
        {8,	0}, 	/* 0x4543 */
        {8,	0}, 	/* 0x4544 */
        {8,	0}, 	/* 0x4545 */
        {8,	0}, 	/* 0x4546 */
        {8,	0}, 	/* 0x4547 */
        {8,	0}, 	/* 0x4548 */
        {8,	0}, 	/* 0x4549 */
        {8,	0}, 	/* 0x454a */
        {8,	0}, 	/* 0x454b */
        {8,	0}, 	/* 0x454c */
        {8,	0}, 	/* 0x454d */
        {8,	0}, 	/* 0x454e */
        {8,	0}, 	/* 0x454f */
        {8,	0}, 	/* 0x4550 */
        {8,	0}, 	/* 0x4551 */
        {8,	0}, 	/* 0x4552 */
        {8,	0}, 	/* 0x4553 */
        {8,	0}, 	/* 0x4554 */
        {8,	0}, 	/* 0x4555 */
        {8,	0}, 	/* 0x4556 */
        {8,	0}, 	/* 0x4557 */
        {8,	0}, 	/* 0x4558 */
        {8,	0}, 	/* 0x4559 */
        {8,	0}, 	/* 0x455a */
        {8,	0}, 	/* 0x455b */
        {8,	0}, 	/* 0x455c */
        {8,	0}, 	/* 0x455d */
        {8,	0}, 	/* 0x455e */
        {8,	0}, 	/* 0x455f */
        {8,	0}, 	/* 0x4560 */
        {8,	0}, 	/* 0x4561 */
        {8,	0}, 	/* 0x4562 */
        {8,	0}, 	/* 0x4563 */
        {8,	0}, 	/* 0x4564 */
        {8,	0}, 	/* 0x4565 */
        {8,	0}, 	/* 0x4566 */
        {8,	0}, 	/* 0x4567 */
        {8,	0}, 	/* 0x4568 */
        {8,	0}, 	/* 0x4569 */
        {8,	0}, 	/* 0x456a */
        {8,	0}, 	/* 0x456b */
        {8,	0}, 	/* 0x456c */
        {8,	0}, 	/* 0x456d */
        {8,	0}, 	/* 0x456e */
        {8,	0}, 	/* 0x456f */
        {8,	0}, 	/* 0x4570 */
        {8,	0}, 	/* 0x4571 */
        {8,	0}, 	/* 0x4572 */
        {8,	0}, 	/* 0x4573 */
        {8,	0}, 	/* 0x4574 */
        {8,	0}, 	/* 0x4575 */
        {8,	0}, 	/* 0x4576 */
        {8,	0}, 	/* 0x4577 */
        {8,	0}, 	/* 0x4578 */
        {8,	0}, 	/* 0x4579 */
        {8,	0}, 	/* 0x457a */
        {8,	0}, 	/* 0x457b */
        {8,	0}, 	/* 0x457c */
        {8,	0}, 	/* 0x457d */
        {8,	0}, 	/* 0x457e */
        {8,	0}, 	/* 0x457f */
        {8,	0}, 	/* 0x4580 */
        {8,	0}, 	/* 0x4581 */
        {8,	0}, 	/* 0x4582 */
        {8,	0}, 	/* 0x4583 */
        {8,	0}, 	/* 0x4584 */
        {8,	0}, 	/* 0x4585 */
        {8,	0}, 	/* 0x4586 */
        {8,	0}, 	/* 0x4587 */
        {8,	0}, 	/* 0x4588 */
        {8,	0}, 	/* 0x4589 */
        {8,	0}, 	/* 0x458a */
        {8,	0}, 	/* 0x458b */
        {8,	0}, 	/* 0x458c */
        {8,	0}, 	/* 0x458d */
        {8,	0}, 	/* 0x458e */
        {8,	0}, 	/* 0x458f */
        {8,	0}, 	/* 0x4590 */
        {8,	0}, 	/* 0x4591 */
        {8,	0}, 	/* 0x4592 */
        {8,	0}, 	/* 0x4593 */
        {8,	0}, 	/* 0x4594 */
        {8,	0}, 	/* 0x4595 */
        {8,	0}, 	/* 0x4596 */
        {8,	0}, 	/* 0x4597 */
        {8,	0}, 	/* 0x4598 */
        {8,	0}, 	/* 0x4599 */
        {8,	0}, 	/* 0x459a */
        {8,	0}, 	/* 0x459b */
        {8,	0}, 	/* 0x459c */
        {8,	0}, 	/* 0x459d */
        {8,	0}, 	/* 0x459e */
        {8,	0}, 	/* 0x459f */
        {8,	0}, 	/* 0x45a0 */
        {8,	0}, 	/* 0x45a1 */
        {8,	0}, 	/* 0x45a2 */
        {8,	0}, 	/* 0x45a3 */
        {8,	0}, 	/* 0x45a4 */
        {8,	0}, 	/* 0x45a5 */
        {8,	0}, 	/* 0x45a6 */
        {8,	0}, 	/* 0x45a7 */
        {8,	0}, 	/* 0x45a8 */
        {8,	0}, 	/* 0x45a9 */
        {8,	0}, 	/* 0x45aa */
        {8,	0}, 	/* 0x45ab */
        {8,	0}, 	/* 0x45ac */
        {8,	0}, 	/* 0x45ad */
        {8,	0}, 	/* 0x45ae */
        {8,	0}, 	/* 0x45af */
        {8,	0}, 	/* 0x45b0 */
        {8,	0}, 	/* 0x45b1 */
        {8,	0}, 	/* 0x45b2 */
        {8,	0}, 	/* 0x45b3 */
        {8,	0}, 	/* 0x45b4 */
        {8,	0}, 	/* 0x45b5 */
        {8,	0}, 	/* 0x45b6 */
        {8,	0}, 	/* 0x45b7 */
        {8,	0}, 	/* 0x45b8 */
        {8,	0}, 	/* 0x45b9 */
        {8,	0}, 	/* 0x45ba */
        {8,	0}, 	/* 0x45bb */
        {8,	0}, 	/* 0x45bc */
        {8,	0}, 	/* 0x45bd */
        {8,	0}, 	/* 0x45be */
        {8,	0}, 	/* 0x45bf */
        {8,	0}, 	/* 0x45c0 */
        {8,	0}, 	/* 0x45c1 */
        {8,	0}, 	/* 0x45c2 */
        {8,	0}, 	/* 0x45c3 */
        {8,	0}, 	/* 0x45c4 */
        {8,	0}, 	/* 0x45c5 */
        {8,	0}, 	/* 0x45c6 */
        {8,	0}, 	/* 0x45c7 */
        {8,	0}, 	/* 0x45c8 */
        {8,	0}, 	/* 0x45c9 */
        {8,	0}, 	/* 0x45ca */
        {8,	0}, 	/* 0x45cb */
        {8,	0}, 	/* 0x45cc */
        {8,	0}, 	/* 0x45cd */
        {8,	0}, 	/* 0x45ce */
        {8,	0}, 	/* 0x45cf */
        {8,	0}, 	/* 0x45d0 */
        {8,	0}, 	/* 0x45d1 */
        {8,	0}, 	/* 0x45d2 */
        {8,	0}, 	/* 0x45d3 */
        {8,	0}, 	/* 0x45d4 */
        {8,	0}, 	/* 0x45d5 */
        {8,	0}, 	/* 0x45d6 */
        {8,	0}, 	/* 0x45d7 */
        {8,	0}, 	/* 0x45d8 */
        {8,	0}, 	/* 0x45d9 */
        {8,	0}, 	/* 0x45da */
        {8,	0}, 	/* 0x45db */
        {8,	0}, 	/* 0x45dc */
        {8,	0}, 	/* 0x45dd */
        {8,	0}, 	/* 0x45de */
        {8,	0}, 	/* 0x45df */
        {8,	0}, 	/* 0x45e0 */
        {8,	0}, 	/* 0x45e1 */
        {8,	0}, 	/* 0x45e2 */
        {8,	0}, 	/* 0x45e3 */
        {8,	0}, 	/* 0x45e4 */
        {8,	0}, 	/* 0x45e5 */
        {8,	0}, 	/* 0x45e6 */
        {8,	0}, 	/* 0x45e7 */
        {8,	0}, 	/* 0x45e8 */
        {8,	0}, 	/* 0x45e9 */
        {8,	0}, 	/* 0x45ea */
        {8,	0}, 	/* 0x45eb */
        {8,	0}, 	/* 0x45ec */
        {8,	0}, 	/* 0x45ed */
        {8,	0}, 	/* 0x45ee */
        {8,	0}, 	/* 0x45ef */
        {8,	0}, 	/* 0x45f0 */
        {8,	0}, 	/* 0x45f1 */
        {8,	0}, 	/* 0x45f2 */
        {8,	0}, 	/* 0x45f3 */
        {8,	0}, 	/* 0x45f4 */
        {8,	0}, 	/* 0x45f5 */
        {8,	0}, 	/* 0x45f6 */
        {8,	0}, 	/* 0x45f7 */
        {8,	0}, 	/* 0x45f8 */
        {8,	0}, 	/* 0x45f9 */
        {8,	0}, 	/* 0x45fa */
        {8,	0}, 	/* 0x45fb */
        {8,	0}, 	/* 0x45fc */
        {8,	0}, 	/* 0x45fd */
        {8,	0}, 	/* 0x45fe */
        {8,	0}, 	/* 0x45ff */
        {8,	0}, 	/* 0x4600 */
        {8,	0}, 	/* 0x4601 */
        {8,	0}, 	/* 0x4602 */
        {8,	0}, 	/* 0x4603 */
        {8,	0}, 	/* 0x4604 */
        {8,	0}, 	/* 0x4605 */
        {8,	0}, 	/* 0x4606 */
        {8,	0}, 	/* 0x4607 */
        {8,	0}, 	/* 0x4608 */
        {8,	0}, 	/* 0x4609 */
        {8,	0}, 	/* 0x460a */
        {8,	0}, 	/* 0x460b */
        {8,	0}, 	/* 0x460c */
        {8,	0}, 	/* 0x460d */
        {8,	0}, 	/* 0x460e */
        {8,	0}, 	/* 0x460f */
        {8,	0}, 	/* 0x4610 */
        {8,	0}, 	/* 0x4611 */
        {8,	0}, 	/* 0x4612 */
        {8,	0}, 	/* 0x4613 */
        {8,	0}, 	/* 0x4614 */
        {8,	0}, 	/* 0x4615 */
        {8,	0}, 	/* 0x4616 */
        {8,	0}, 	/* 0x4617 */
        {8,	0}, 	/* 0x4618 */
        {8,	0}, 	/* 0x4619 */
        {8,	0}, 	/* 0x461a */
        {8,	0}, 	/* 0x461b */
        {8,	0}, 	/* 0x461c */
        {8,	0}, 	/* 0x461d */
        {8,	0}, 	/* 0x461e */
        {8,	0}, 	/* 0x461f */
        {8,	0}, 	/* 0x4620 */
        {8,	0}, 	/* 0x4621 */
        {8,	0}, 	/* 0x4622 */
        {8,	0}, 	/* 0x4623 */
        {8,	0}, 	/* 0x4624 */
        {8,	0}, 	/* 0x4625 */
        {8,	0}, 	/* 0x4626 */
        {8,	0}, 	/* 0x4627 */
        {8,	0}, 	/* 0x4628 */
        {8,	0}, 	/* 0x4629 */
        {8,	0}, 	/* 0x462a */
        {8,	0}, 	/* 0x462b */
        {8,	0}, 	/* 0x462c */
        {8,	0}, 	/* 0x462d */
        {8,	0}, 	/* 0x462e */
        {8,	0}, 	/* 0x462f */
        {8,	0}, 	/* 0x4630 */
        {8,	0}, 	/* 0x4631 */
        {8,	0}, 	/* 0x4632 */
        {8,	0}, 	/* 0x4633 */
        {8,	0}, 	/* 0x4634 */
        {8,	0}, 	/* 0x4635 */
        {8,	0}, 	/* 0x4636 */
        {8,	0}, 	/* 0x4637 */
        {8,	0}, 	/* 0x4638 */
        {8,	0}, 	/* 0x4639 */
        {8,	0}, 	/* 0x463a */
        {8,	0}, 	/* 0x463b */
        {8,	0}, 	/* 0x463c */
        {8,	0}, 	/* 0x463d */
        {8,	0}, 	/* 0x463e */
        {8,	0}, 	/* 0x463f */
        {8,	0}, 	/* 0x4640 */
        {8,	0}, 	/* 0x4641 */
        {8,	0}, 	/* 0x4642 */
        {8,	0}, 	/* 0x4643 */
        {8,	0}, 	/* 0x4644 */
        {8,	0}, 	/* 0x4645 */
        {8,	0}, 	/* 0x4646 */
        {8,	0}, 	/* 0x4647 */
        {8,	0}, 	/* 0x4648 */
        {8,	0}, 	/* 0x4649 */
        {8,	0}, 	/* 0x464a */
        {8,	0}, 	/* 0x464b */
        {8,	0}, 	/* 0x464c */
        {8,	0}, 	/* 0x464d */
        {8,	0}, 	/* 0x464e */
        {8,	0}, 	/* 0x464f */
        {8,	0}, 	/* 0x4650 */
        {8,	0}, 	/* 0x4651 */
        {8,	0}, 	/* 0x4652 */
        {8,	0}, 	/* 0x4653 */
        {8,	0}, 	/* 0x4654 */
        {8,	0}, 	/* 0x4655 */
        {8,	0}, 	/* 0x4656 */
        {8,	0}, 	/* 0x4657 */
        {8,	0}, 	/* 0x4658 */
        {8,	0}, 	/* 0x4659 */
        {8,	0}, 	/* 0x465a */
        {8,	0}, 	/* 0x465b */
        {8,	0}, 	/* 0x465c */
        {8,	0}, 	/* 0x465d */
        {8,	0}, 	/* 0x465e */
        {8,	0}, 	/* 0x465f */
        {8,	0}, 	/* 0x4660 */
        {8,	0}, 	/* 0x4661 */
        {8,	0}, 	/* 0x4662 */
        {8,	0}, 	/* 0x4663 */
        {8,	0}, 	/* 0x4664 */
        {8,	0}, 	/* 0x4665 */
        {8,	0}, 	/* 0x4666 */
        {8,	0}, 	/* 0x4667 */
        {8,	0}, 	/* 0x4668 */
        {8,	0}, 	/* 0x4669 */
        {8,	0}, 	/* 0x466a */
        {8,	0}, 	/* 0x466b */
        {8,	0}, 	/* 0x466c */
        {8,	0}, 	/* 0x466d */
        {8,	0}, 	/* 0x466e */
        {8,	0}, 	/* 0x466f */
        {8,	0}, 	/* 0x4670 */
        {8,	0}, 	/* 0x4671 */
        {8,	0}, 	/* 0x4672 */
        {8,	0}, 	/* 0x4673 */
        {8,	0}, 	/* 0x4674 */
        {8,	0}, 	/* 0x4675 */
        {8,	0}, 	/* 0x4676 */
        {8,	0}, 	/* 0x4677 */
        {8,	0}, 	/* 0x4678 */
        {8,	0}, 	/* 0x4679 */
        {8,	0}, 	/* 0x467a */
        {8,	0}, 	/* 0x467b */
        {8,	0}, 	/* 0x467c */
        {8,	0}, 	/* 0x467d */
        {8,	0}, 	/* 0x467e */
        {8,	0}, 	/* 0x467f */
        {8,	0}, 	/* 0x4680 */
        {8,	0}, 	/* 0x4681 */
        {8,	0}, 	/* 0x4682 */
        {8,	0}, 	/* 0x4683 */
        {8,	0}, 	/* 0x4684 */
        {8,	0}, 	/* 0x4685 */
        {8,	0}, 	/* 0x4686 */
        {8,	0}, 	/* 0x4687 */
        {8,	0}, 	/* 0x4688 */
        {8,	0}, 	/* 0x4689 */
        {8,	0}, 	/* 0x468a */
        {8,	0}, 	/* 0x468b */
        {8,	0}, 	/* 0x468c */
        {8,	0}, 	/* 0x468d */
        {8,	0}, 	/* 0x468e */
        {8,	0}, 	/* 0x468f */
        {8,	0}, 	/* 0x4690 */
        {8,	0}, 	/* 0x4691 */
        {8,	0}, 	/* 0x4692 */
        {8,	0}, 	/* 0x4693 */
        {8,	0}, 	/* 0x4694 */
        {8,	0}, 	/* 0x4695 */
        {8,	0}, 	/* 0x4696 */
        {8,	0}, 	/* 0x4697 */
        {8,	0}, 	/* 0x4698 */
        {8,	0}, 	/* 0x4699 */
        {8,	0}, 	/* 0x469a */
        {8,	0}, 	/* 0x469b */
        {8,	0}, 	/* 0x469c */
        {8,	0}, 	/* 0x469d */
        {8,	0}, 	/* 0x469e */
        {8,	0}, 	/* 0x469f */
        {8,	0}, 	/* 0x46a0 */
        {8,	0}, 	/* 0x46a1 */
        {8,	0}, 	/* 0x46a2 */
        {8,	0}, 	/* 0x46a3 */
        {8,	0}, 	/* 0x46a4 */
        {8,	0}, 	/* 0x46a5 */
        {8,	0}, 	/* 0x46a6 */
        {8,	0}, 	/* 0x46a7 */
        {8,	0}, 	/* 0x46a8 */
        {8,	0}, 	/* 0x46a9 */
        {8,	0}, 	/* 0x46aa */
        {8,	0}, 	/* 0x46ab */
        {8,	0}, 	/* 0x46ac */
        {8,	0}, 	/* 0x46ad */
        {8,	0}, 	/* 0x46ae */
        {8,	0}, 	/* 0x46af */
        {8,	0}, 	/* 0x46b0 */
        {8,	0}, 	/* 0x46b1 */
        {8,	0}, 	/* 0x46b2 */
        {8,	0}, 	/* 0x46b3 */
        {8,	0}, 	/* 0x46b4 */
        {8,	0}, 	/* 0x46b5 */
        {8,	0}, 	/* 0x46b6 */
        {8,	0}, 	/* 0x46b7 */
        {8,	0}, 	/* 0x46b8 */
        {8,	0}, 	/* 0x46b9 */
        {8,	0}, 	/* 0x46ba */
        {8,	0}, 	/* 0x46bb */
        {8,	0}, 	/* 0x46bc */
        {8,	0}, 	/* 0x46bd */
        {8,	0}, 	/* 0x46be */
        {8,	0}, 	/* 0x46bf */
        {8,	0}, 	/* 0x46c0 */
        {8,	0}, 	/* 0x46c1 */
        {8,	0}, 	/* 0x46c2 */
        {8,	0}, 	/* 0x46c3 */
        {8,	0}, 	/* 0x46c4 */
        {8,	0}, 	/* 0x46c5 */
        {8,	0}, 	/* 0x46c6 */
        {8,	0}, 	/* 0x46c7 */
        {8,	0}, 	/* 0x46c8 */
        {8,	0}, 	/* 0x46c9 */
        {8,	0}, 	/* 0x46ca */
        {8,	0}, 	/* 0x46cb */
        {8,	0}, 	/* 0x46cc */
        {8,	0}, 	/* 0x46cd */
        {8,	0}, 	/* 0x46ce */
        {8,	0}, 	/* 0x46cf */
        {8,	0}, 	/* 0x46d0 */
        {8,	0}, 	/* 0x46d1 */
        {8,	0}, 	/* 0x46d2 */
        {8,	0}, 	/* 0x46d3 */
        {8,	0}, 	/* 0x46d4 */
        {8,	0}, 	/* 0x46d5 */
        {8,	0}, 	/* 0x46d6 */
        {8,	0}, 	/* 0x46d7 */
        {8,	0}, 	/* 0x46d8 */
        {8,	0}, 	/* 0x46d9 */
        {8,	0}, 	/* 0x46da */
        {8,	0}, 	/* 0x46db */
        {8,	0}, 	/* 0x46dc */
        {8,	0}, 	/* 0x46dd */
        {8,	0}, 	/* 0x46de */
        {8,	0}, 	/* 0x46df */
        {8,	0}, 	/* 0x46e0 */
        {8,	0}, 	/* 0x46e1 */
        {8,	0}, 	/* 0x46e2 */
        {8,	0}, 	/* 0x46e3 */
        {8,	0}, 	/* 0x46e4 */
        {8,	0}, 	/* 0x46e5 */
        {8,	0}, 	/* 0x46e6 */
        {8,	0}, 	/* 0x46e7 */
        {8,	0}, 	/* 0x46e8 */
        {8,	0}, 	/* 0x46e9 */
        {8,	0}, 	/* 0x46ea */
        {8,	0}, 	/* 0x46eb */
        {8,	0}, 	/* 0x46ec */
        {8,	0}, 	/* 0x46ed */
        {8,	0}, 	/* 0x46ee */
        {8,	0}, 	/* 0x46ef */
        {8,	0}, 	/* 0x46f0 */
        {8,	0}, 	/* 0x46f1 */
        {8,	0}, 	/* 0x46f2 */
        {8,	0}, 	/* 0x46f3 */
        {8,	0}, 	/* 0x46f4 */
        {8,	0}, 	/* 0x46f5 */
        {8,	0}, 	/* 0x46f6 */
        {8,	0}, 	/* 0x46f7 */
        {8,	0}, 	/* 0x46f8 */
        {8,	0}, 	/* 0x46f9 */
        {8,	0}, 	/* 0x46fa */
        {8,	0}, 	/* 0x46fb */
        {8,	0}, 	/* 0x46fc */
        {8,	0}, 	/* 0x46fd */
        {8,	0}, 	/* 0x46fe */
        {8,	0}, 	/* 0x46ff */
        {8,	0}, 	/* 0x4700 */
        {8,	0}, 	/* 0x4701 */
        {8,	0}, 	/* 0x4702 */
        {8,	0}, 	/* 0x4703 */
        {8,	0}, 	/* 0x4704 */
        {8,	0}, 	/* 0x4705 */
        {8,	0}, 	/* 0x4706 */
        {8,	0}, 	/* 0x4707 */
        {8,	0}, 	/* 0x4708 */
        {8,	0}, 	/* 0x4709 */
        {8,	0}, 	/* 0x470a */
        {8,	0}, 	/* 0x470b */
        {8,	0}, 	/* 0x470c */
        {8,	0}, 	/* 0x470d */
        {8,	0}, 	/* 0x470e */
        {8,	0}, 	/* 0x470f */
        {8,	0}, 	/* 0x4710 */
        {8,	0}, 	/* 0x4711 */
        {8,	0}, 	/* 0x4712 */
        {8,	0}, 	/* 0x4713 */
        {8,	0}, 	/* 0x4714 */
        {8,	0}, 	/* 0x4715 */
        {8,	0}, 	/* 0x4716 */
        {8,	0}, 	/* 0x4717 */
        {8,	0}, 	/* 0x4718 */
        {8,	0}, 	/* 0x4719 */
        {8,	0}, 	/* 0x471a */
        {8,	0}, 	/* 0x471b */
        {8,	0}, 	/* 0x471c */
        {8,	0}, 	/* 0x471d */
        {8,	0}, 	/* 0x471e */
        {8,	0}, 	/* 0x471f */
        {8,	0}, 	/* 0x4720 */
        {8,	0}, 	/* 0x4721 */
        {8,	0}, 	/* 0x4722 */
        {8,	0}, 	/* 0x4723 */
        {8,	0}, 	/* 0x4724 */
        {8,	0}, 	/* 0x4725 */
        {8,	0}, 	/* 0x4726 */
        {8,	0}, 	/* 0x4727 */
        {8,	0}, 	/* 0x4728 */
        {8,	0}, 	/* 0x4729 */
        {8,	0}, 	/* 0x472a */
        {8,	0}, 	/* 0x472b */
        {8,	0}, 	/* 0x472c */
        {8,	0}, 	/* 0x472d */
        {8,	0}, 	/* 0x472e */
        {8,	0}, 	/* 0x472f */
        {8,	0}, 	/* 0x4730 */
        {8,	0}, 	/* 0x4731 */
        {8,	0}, 	/* 0x4732 */
        {8,	0}, 	/* 0x4733 */
        {8,	0}, 	/* 0x4734 */
        {8,	0}, 	/* 0x4735 */
        {8,	0}, 	/* 0x4736 */
        {8,	0}, 	/* 0x4737 */
        {8,	0}, 	/* 0x4738 */
        {8,	0}, 	/* 0x4739 */
        {8,	0}, 	/* 0x473a */
        {8,	0}, 	/* 0x473b */
        {8,	0}, 	/* 0x473c */
        {8,	0}, 	/* 0x473d */
        {8,	0}, 	/* 0x473e */
        {8,	0}, 	/* 0x473f */
        {8,	0}, 	/* 0x4740 */
        {8,	0}, 	/* 0x4741 */
        {8,	0}, 	/* 0x4742 */
        {8,	0}, 	/* 0x4743 */
        {8,	0}, 	/* 0x4744 */
        {8,	0}, 	/* 0x4745 */
        {8,	0}, 	/* 0x4746 */
        {8,	0}, 	/* 0x4747 */
        {8,	0}, 	/* 0x4748 */
        {8,	0}, 	/* 0x4749 */
        {8,	0}, 	/* 0x474a */
        {8,	0}, 	/* 0x474b */
        {8,	0}, 	/* 0x474c */
        {8,	0}, 	/* 0x474d */
        {8,	0}, 	/* 0x474e */
        {8,	0}, 	/* 0x474f */
        {8,	0}, 	/* 0x4750 */
        {8,	0}, 	/* 0x4751 */
        {8,	0}, 	/* 0x4752 */
        {8,	0}, 	/* 0x4753 */
        {8,	0}, 	/* 0x4754 */
        {8,	0}, 	/* 0x4755 */
        {8,	0}, 	/* 0x4756 */
        {8,	0}, 	/* 0x4757 */
        {8,	0}, 	/* 0x4758 */
        {8,	0}, 	/* 0x4759 */
        {8,	0}, 	/* 0x475a */
        {8,	0}, 	/* 0x475b */
        {8,	0}, 	/* 0x475c */
        {8,	0}, 	/* 0x475d */
        {8,	0}, 	/* 0x475e */
        {8,	0}, 	/* 0x475f */
        {8,	0}, 	/* 0x4760 */
        {8,	0}, 	/* 0x4761 */
        {8,	0}, 	/* 0x4762 */
        {8,	0}, 	/* 0x4763 */
        {8,	0}, 	/* 0x4764 */
        {8,	0}, 	/* 0x4765 */
        {8,	0}, 	/* 0x4766 */
        {8,	0}, 	/* 0x4767 */
        {8,	0}, 	/* 0x4768 */
        {8,	0}, 	/* 0x4769 */
        {8,	0}, 	/* 0x476a */
        {8,	0}, 	/* 0x476b */
        {8,	0}, 	/* 0x476c */
        {8,	0}, 	/* 0x476d */
        {8,	0}, 	/* 0x476e */
        {8,	0}, 	/* 0x476f */
        {8,	0}, 	/* 0x4770 */
        {8,	0}, 	/* 0x4771 */
        {8,	0}, 	/* 0x4772 */
        {8,	0}, 	/* 0x4773 */
        {8,	0}, 	/* 0x4774 */
        {8,	0}, 	/* 0x4775 */
        {8,	0}, 	/* 0x4776 */
        {8,	0}, 	/* 0x4777 */
        {8,	0}, 	/* 0x4778 */
        {8,	0}, 	/* 0x4779 */
        {8,	0}, 	/* 0x477a */
        {8,	0}, 	/* 0x477b */
        {8,	0}, 	/* 0x477c */
        {8,	0}, 	/* 0x477d */
        {8,	0}, 	/* 0x477e */
        {8,	0}, 	/* 0x477f */
        {8,	0}, 	/* 0x4780 */
        {8,	0}, 	/* 0x4781 */
        {8,	0}, 	/* 0x4782 */
        {8,	0}, 	/* 0x4783 */
        {8,	0}, 	/* 0x4784 */
        {8,	0}, 	/* 0x4785 */
        {8,	0}, 	/* 0x4786 */
        {8,	0}, 	/* 0x4787 */
        {8,	0}, 	/* 0x4788 */
        {8,	0}, 	/* 0x4789 */
        {8,	0}, 	/* 0x478a */
        {8,	0}, 	/* 0x478b */
        {8,	0}, 	/* 0x478c */
        {8,	0}, 	/* 0x478d */
        {8,	0}, 	/* 0x478e */
        {8,	0}, 	/* 0x478f */
        {8,	0}, 	/* 0x4790 */
        {8,	0}, 	/* 0x4791 */
        {8,	0}, 	/* 0x4792 */
        {8,	0}, 	/* 0x4793 */
        {8,	0}, 	/* 0x4794 */
        {8,	0}, 	/* 0x4795 */
        {8,	0}, 	/* 0x4796 */
        {8,	0}, 	/* 0x4797 */
        {8,	0}, 	/* 0x4798 */
        {8,	0}, 	/* 0x4799 */
        {8,	0}, 	/* 0x479a */
        {8,	0}, 	/* 0x479b */
        {8,	0}, 	/* 0x479c */
        {8,	0}, 	/* 0x479d */
        {8,	0}, 	/* 0x479e */
        {8,	0}, 	/* 0x479f */
        {8,	0}, 	/* 0x47a0 */
        {8,	0}, 	/* 0x47a1 */
        {8,	0}, 	/* 0x47a2 */
        {8,	0}, 	/* 0x47a3 */
        {8,	0}, 	/* 0x47a4 */
        {8,	0}, 	/* 0x47a5 */
        {8,	0}, 	/* 0x47a6 */
        {8,	0}, 	/* 0x47a7 */
        {8,	0}, 	/* 0x47a8 */
        {8,	0}, 	/* 0x47a9 */
        {8,	0}, 	/* 0x47aa */
        {8,	0}, 	/* 0x47ab */
        {8,	0}, 	/* 0x47ac */
        {8,	0}, 	/* 0x47ad */
        {8,	0}, 	/* 0x47ae */
        {8,	0}, 	/* 0x47af */
        {8,	0}, 	/* 0x47b0 */
        {8,	0}, 	/* 0x47b1 */
        {8,	0}, 	/* 0x47b2 */
        {8,	0}, 	/* 0x47b3 */
        {8,	0}, 	/* 0x47b4 */
        {8,	0}, 	/* 0x47b5 */
        {8,	0}, 	/* 0x47b6 */
        {8,	0}, 	/* 0x47b7 */
        {8,	0}, 	/* 0x47b8 */
        {8,	0}, 	/* 0x47b9 */
        {8,	0}, 	/* 0x47ba */
        {8,	0}, 	/* 0x47bb */
        {8,	0}, 	/* 0x47bc */
        {8,	0}, 	/* 0x47bd */
        {8,	0}, 	/* 0x47be */
        {8,	0}, 	/* 0x47bf */
        {8,	0}, 	/* 0x47c0 */
        {8,	0}, 	/* 0x47c1 */
        {8,	0}, 	/* 0x47c2 */
        {8,	0}, 	/* 0x47c3 */
        {8,	0}, 	/* 0x47c4 */
        {8,	0}, 	/* 0x47c5 */
        {8,	0}, 	/* 0x47c6 */
        {8,	0}, 	/* 0x47c7 */
        {8,	0}, 	/* 0x47c8 */
        {8,	0}, 	/* 0x47c9 */
        {8,	0}, 	/* 0x47ca */
        {8,	0}, 	/* 0x47cb */
        {8,	0}, 	/* 0x47cc */
        {8,	0}, 	/* 0x47cd */
        {8,	0}, 	/* 0x47ce */
        {8,	0}, 	/* 0x47cf */
        {8,	0}, 	/* 0x47d0 */
        {8,	0}, 	/* 0x47d1 */
        {8,	0}, 	/* 0x47d2 */
        {8,	0}, 	/* 0x47d3 */
        {8,	0}, 	/* 0x47d4 */
        {8,	0}, 	/* 0x47d5 */
        {8,	0}, 	/* 0x47d6 */
        {8,	0}, 	/* 0x47d7 */
        {8,	0}, 	/* 0x47d8 */
        {8,	0}, 	/* 0x47d9 */
        {8,	0}, 	/* 0x47da */
        {8,	0}, 	/* 0x47db */
        {8,	0}, 	/* 0x47dc */
        {8,	0}, 	/* 0x47dd */
        {8,	0}, 	/* 0x47de */
        {8,	0}, 	/* 0x47df */
        {8,	0}, 	/* 0x47e0 */
        {8,	0}, 	/* 0x47e1 */
        {8,	0}, 	/* 0x47e2 */
        {8,	0}, 	/* 0x47e3 */
        {8,	0}, 	/* 0x47e4 */
        {8,	0}, 	/* 0x47e5 */
        {8,	0}, 	/* 0x47e6 */
        {8,	0}, 	/* 0x47e7 */
        {8,	0}, 	/* 0x47e8 */
        {8,	0}, 	/* 0x47e9 */
        {8,	0}, 	/* 0x47ea */
        {8,	0}, 	/* 0x47eb */
        {8,	0}, 	/* 0x47ec */
        {8,	0}, 	/* 0x47ed */
        {8,	0}, 	/* 0x47ee */
        {8,	0}, 	/* 0x47ef */
        {8,	0}, 	/* 0x47f0 */
        {8,	0}, 	/* 0x47f1 */
        {8,	0}, 	/* 0x47f2 */
        {8,	0}, 	/* 0x47f3 */
        {8,	0}, 	/* 0x47f4 */
        {8,	0}, 	/* 0x47f5 */
        {8,	0}, 	/* 0x47f6 */
        {8,	0}, 	/* 0x47f7 */
        {8,	0}, 	/* 0x47f8 */
        {8,	0}, 	/* 0x47f9 */
        {8,	0}, 	/* 0x47fa */
        {8,	0}, 	/* 0x47fb */
        {8,	0}, 	/* 0x47fc */
        {8,	0}, 	/* 0x47fd */
        {8,	0}, 	/* 0x47fe */
        {8,	0}, 	/* 0x47ff */
        {8,	0}, 	/* 0x4800 */
        {8,	0}, 	/* 0x4801 */
        {8,	0}, 	/* 0x4802 */
        {8,	0}, 	/* 0x4803 */
        {8,	0}, 	/* 0x4804 */
        {8,	0}, 	/* 0x4805 */
        {8,	0}, 	/* 0x4806 */
        {8,	0}, 	/* 0x4807 */
        {8,	0}, 	/* 0x4808 */
        {8,	0}, 	/* 0x4809 */
        {8,	0}, 	/* 0x480a */
        {8,	0}, 	/* 0x480b */
        {8,	0}, 	/* 0x480c */
        {8,	0}, 	/* 0x480d */
        {8,	0}, 	/* 0x480e */
        {8,	0}, 	/* 0x480f */
        {8,	0}, 	/* 0x4810 */
        {8,	0}, 	/* 0x4811 */
        {8,	0}, 	/* 0x4812 */
        {8,	0}, 	/* 0x4813 */
        {8,	0}, 	/* 0x4814 */
        {8,	0}, 	/* 0x4815 */
        {8,	0}, 	/* 0x4816 */
        {8,	0}, 	/* 0x4817 */
        {8,	0}, 	/* 0x4818 */
        {8,	0}, 	/* 0x4819 */
        {8,	0}, 	/* 0x481a */
        {8,	0}, 	/* 0x481b */
        {8,	0}, 	/* 0x481c */
        {8,	0}, 	/* 0x481d */
        {8,	0}, 	/* 0x481e */
        {8,	0}, 	/* 0x481f */
        {8,	0}, 	/* 0x4820 */
        {8,	0}, 	/* 0x4821 */
        {8,	0}, 	/* 0x4822 */
        {8,	0}, 	/* 0x4823 */
        {8,	0}, 	/* 0x4824 */
        {8,	0}, 	/* 0x4825 */
        {8,	0}, 	/* 0x4826 */
        {8,	0}, 	/* 0x4827 */
        {8,	0}, 	/* 0x4828 */
        {8,	0}, 	/* 0x4829 */
        {8,	0}, 	/* 0x482a */
        {8,	0}, 	/* 0x482b */
        {8,	0}, 	/* 0x482c */
        {8,	0}, 	/* 0x482d */
        {8,	0}, 	/* 0x482e */
        {8,	0}, 	/* 0x482f */
        {8,	0}, 	/* 0x4830 */
        {8,	0}, 	/* 0x4831 */
        {8,	0}, 	/* 0x4832 */
        {8,	0}, 	/* 0x4833 */
        {8,	0}, 	/* 0x4834 */
        {8,	0}, 	/* 0x4835 */
        {8,	0}, 	/* 0x4836 */
        {8,	0}, 	/* 0x4837 */
        {8,	0}, 	/* 0x4838 */
        {8,	0}, 	/* 0x4839 */
        {8,	0}, 	/* 0x483a */
        {8,	0}, 	/* 0x483b */
        {8,	0}, 	/* 0x483c */
        {8,	0}, 	/* 0x483d */
        {8,	0}, 	/* 0x483e */
        {8,	0}, 	/* 0x483f */
        {8,	0}, 	/* 0x4840 */
        {8,	0}, 	/* 0x4841 */
        {8,	0}, 	/* 0x4842 */
        {8,	0}, 	/* 0x4843 */
        {8,	0}, 	/* 0x4844 */
        {8,	0}, 	/* 0x4845 */
        {8,	0}, 	/* 0x4846 */
        {8,	0}, 	/* 0x4847 */
        {8,	0}, 	/* 0x4848 */
        {8,	0}, 	/* 0x4849 */
        {8,	0}, 	/* 0x484a */
        {8,	0}, 	/* 0x484b */
        {8,	0}, 	/* 0x484c */
        {8,	0}, 	/* 0x484d */
        {8,	0}, 	/* 0x484e */
        {8,	0}, 	/* 0x484f */
        {8,	0}, 	/* 0x4850 */
        {8,	0}, 	/* 0x4851 */
        {8,	0}, 	/* 0x4852 */
        {8,	0}, 	/* 0x4853 */
        {8,	0}, 	/* 0x4854 */
        {8,	0}, 	/* 0x4855 */
        {8,	0}, 	/* 0x4856 */
        {8,	0}, 	/* 0x4857 */
        {8,	0}, 	/* 0x4858 */
        {8,	0}, 	/* 0x4859 */
        {8,	0}, 	/* 0x485a */
        {8,	0}, 	/* 0x485b */
        {8,	0}, 	/* 0x485c */
        {8,	0}, 	/* 0x485d */
        {8,	0}, 	/* 0x485e */
        {8,	0}, 	/* 0x485f */
        {8,	0}, 	/* 0x4860 */
        {8,	0}, 	/* 0x4861 */
        {8,	0}, 	/* 0x4862 */
        {8,	0}, 	/* 0x4863 */
        {8,	0}, 	/* 0x4864 */
        {8,	0}, 	/* 0x4865 */
        {8,	0}, 	/* 0x4866 */
        {8,	0}, 	/* 0x4867 */
        {8,	0}, 	/* 0x4868 */
        {8,	0}, 	/* 0x4869 */
        {8,	0}, 	/* 0x486a */
        {8,	0}, 	/* 0x486b */
        {8,	0}, 	/* 0x486c */
        {8,	0}, 	/* 0x486d */
        {8,	0}, 	/* 0x486e */
        {8,	0}, 	/* 0x486f */
        {8,	0}, 	/* 0x4870 */
        {8,	0}, 	/* 0x4871 */
        {8,	0}, 	/* 0x4872 */
        {8,	0}, 	/* 0x4873 */
        {8,	0}, 	/* 0x4874 */
        {8,	0}, 	/* 0x4875 */
        {8,	0}, 	/* 0x4876 */
        {8,	0}, 	/* 0x4877 */
        {8,	0}, 	/* 0x4878 */
        {8,	0}, 	/* 0x4879 */
        {8,	0}, 	/* 0x487a */
        {8,	0}, 	/* 0x487b */
        {8,	0}, 	/* 0x487c */
        {8,	0}, 	/* 0x487d */
        {8,	0}, 	/* 0x487e */
        {8,	0}, 	/* 0x487f */
        {8,	0}, 	/* 0x4880 */
        {8,	0}, 	/* 0x4881 */
        {8,	0}, 	/* 0x4882 */
        {8,	0}, 	/* 0x4883 */
        {8,	0}, 	/* 0x4884 */
        {8,	0}, 	/* 0x4885 */
        {8,	0}, 	/* 0x4886 */
        {8,	0}, 	/* 0x4887 */
        {8,	0}, 	/* 0x4888 */
        {8,	0}, 	/* 0x4889 */
        {8,	0}, 	/* 0x488a */
        {8,	0}, 	/* 0x488b */
        {8,	0}, 	/* 0x488c */
        {8,	0}, 	/* 0x488d */
        {8,	0}, 	/* 0x488e */
        {8,	0}, 	/* 0x488f */
        {8,	0}, 	/* 0x4890 */
        {8,	0}, 	/* 0x4891 */
        {8,	0}, 	/* 0x4892 */
        {8,	0}, 	/* 0x4893 */
        {8,	0}, 	/* 0x4894 */
        {8,	0}, 	/* 0x4895 */
        {8,	0}, 	/* 0x4896 */
        {8,	0}, 	/* 0x4897 */
        {8,	0}, 	/* 0x4898 */
        {8,	0}, 	/* 0x4899 */
        {8,	0}, 	/* 0x489a */
        {8,	0}, 	/* 0x489b */
        {8,	0}, 	/* 0x489c */
        {8,	0}, 	/* 0x489d */
        {8,	0}, 	/* 0x489e */
        {8,	0}, 	/* 0x489f */
        {8,	0}, 	/* 0x48a0 */
        {8,	0}, 	/* 0x48a1 */
        {8,	0}, 	/* 0x48a2 */
        {8,	0}, 	/* 0x48a3 */
        {8,	0}, 	/* 0x48a4 */
        {8,	0}, 	/* 0x48a5 */
        {8,	0}, 	/* 0x48a6 */
        {8,	0}, 	/* 0x48a7 */
        {8,	0}, 	/* 0x48a8 */
        {8,	0}, 	/* 0x48a9 */
        {8,	0}, 	/* 0x48aa */
        {8,	0}, 	/* 0x48ab */
        {8,	0}, 	/* 0x48ac */
        {8,	0}, 	/* 0x48ad */
        {8,	0}, 	/* 0x48ae */
        {8,	0}, 	/* 0x48af */
        {8,	0}, 	/* 0x48b0 */
        {8,	0}, 	/* 0x48b1 */
        {8,	0}, 	/* 0x48b2 */
        {8,	0}, 	/* 0x48b3 */
        {8,	0}, 	/* 0x48b4 */
        {8,	0}, 	/* 0x48b5 */
        {8,	0}, 	/* 0x48b6 */
        {8,	0}, 	/* 0x48b7 */
        {8,	0}, 	/* 0x48b8 */
        {8,	0}, 	/* 0x48b9 */
        {8,	0}, 	/* 0x48ba */
        {8,	0}, 	/* 0x48bb */
        {8,	0}, 	/* 0x48bc */
        {8,	0}, 	/* 0x48bd */
        {8,	0}, 	/* 0x48be */
        {8,	0}, 	/* 0x48bf */
        {8,	0}, 	/* 0x48c0 */
        {8,	0}, 	/* 0x48c1 */
        {8,	0}, 	/* 0x48c2 */
        {8,	0}, 	/* 0x48c3 */
        {8,	0}, 	/* 0x48c4 */
        {8,	0}, 	/* 0x48c5 */
        {8,	0}, 	/* 0x48c6 */
        {8,	0}, 	/* 0x48c7 */
        {8,	0}, 	/* 0x48c8 */
        {8,	0}, 	/* 0x48c9 */
        {8,	0}, 	/* 0x48ca */
        {8,	0}, 	/* 0x48cb */
        {8,	0}, 	/* 0x48cc */
        {8,	0}, 	/* 0x48cd */
        {8,	0}, 	/* 0x48ce */
        {8,	0}, 	/* 0x48cf */
        {8,	0}, 	/* 0x48d0 */
        {8,	0}, 	/* 0x48d1 */
        {8,	0}, 	/* 0x48d2 */
        {8,	0}, 	/* 0x48d3 */
        {8,	0}, 	/* 0x48d4 */
        {8,	0}, 	/* 0x48d5 */
        {8,	0}, 	/* 0x48d6 */
        {8,	0}, 	/* 0x48d7 */
        {8,	0}, 	/* 0x48d8 */
        {8,	0}, 	/* 0x48d9 */
        {8,	0}, 	/* 0x48da */
        {8,	0}, 	/* 0x48db */
        {8,	0}, 	/* 0x48dc */
        {8,	0}, 	/* 0x48dd */
        {8,	0}, 	/* 0x48de */
        {8,	0}, 	/* 0x48df */
        {8,	0}, 	/* 0x48e0 */
        {8,	0}, 	/* 0x48e1 */
        {8,	0}, 	/* 0x48e2 */
        {8,	0}, 	/* 0x48e3 */
        {8,	0}, 	/* 0x48e4 */
        {8,	0}, 	/* 0x48e5 */
        {8,	0}, 	/* 0x48e6 */
        {8,	0}, 	/* 0x48e7 */
        {8,	0}, 	/* 0x48e8 */
        {8,	0}, 	/* 0x48e9 */
        {8,	0}, 	/* 0x48ea */
        {8,	0}, 	/* 0x48eb */
        {8,	0}, 	/* 0x48ec */
        {8,	0}, 	/* 0x48ed */
        {8,	0}, 	/* 0x48ee */
        {8,	0}, 	/* 0x48ef */
        {8,	0}, 	/* 0x48f0 */
        {8,	0}, 	/* 0x48f1 */
        {8,	0}, 	/* 0x48f2 */
        {8,	0}, 	/* 0x48f3 */
        {8,	0}, 	/* 0x48f4 */
        {8,	0}, 	/* 0x48f5 */
        {8,	0}, 	/* 0x48f6 */
        {8,	0}, 	/* 0x48f7 */
        {8,	0}, 	/* 0x48f8 */
        {8,	0}, 	/* 0x48f9 */
        {8,	0}, 	/* 0x48fa */
        {8,	0}, 	/* 0x48fb */
        {8,	0}, 	/* 0x48fc */
        {8,	0}, 	/* 0x48fd */
        {8,	0}, 	/* 0x48fe */
        {8,	0}, 	/* 0x48ff */
        {8,	0}, 	/* 0x4900 */
        {8,	0}, 	/* 0x4901 */
        {8,	0}, 	/* 0x4902 */
        {8,	0}, 	/* 0x4903 */
        {8,	0}, 	/* 0x4904 */
        {8,	0}, 	/* 0x4905 */
        {8,	0}, 	/* 0x4906 */
        {8,	0}, 	/* 0x4907 */
        {8,	0}, 	/* 0x4908 */
        {8,	0}, 	/* 0x4909 */
        {8,	0}, 	/* 0x490a */
        {8,	0}, 	/* 0x490b */
        {8,	0}, 	/* 0x490c */
        {8,	0}, 	/* 0x490d */
        {8,	0}, 	/* 0x490e */
        {8,	0}, 	/* 0x490f */
        {8,	0}, 	/* 0x4910 */
        {8,	0}, 	/* 0x4911 */
        {8,	0}, 	/* 0x4912 */
        {8,	0}, 	/* 0x4913 */
        {8,	0}, 	/* 0x4914 */
        {8,	0}, 	/* 0x4915 */
        {8,	0}, 	/* 0x4916 */
        {8,	0}, 	/* 0x4917 */
        {8,	0}, 	/* 0x4918 */
        {8,	0}, 	/* 0x4919 */
        {8,	0}, 	/* 0x491a */
        {8,	0}, 	/* 0x491b */
        {8,	0}, 	/* 0x491c */
        {8,	0}, 	/* 0x491d */
        {8,	0}, 	/* 0x491e */
        {8,	0}, 	/* 0x491f */
        {8,	0}, 	/* 0x4920 */
        {8,	0}, 	/* 0x4921 */
        {8,	0}, 	/* 0x4922 */
        {8,	0}, 	/* 0x4923 */
        {8,	0}, 	/* 0x4924 */
        {8,	0}, 	/* 0x4925 */
        {8,	0}, 	/* 0x4926 */
        {8,	0}, 	/* 0x4927 */
        {8,	0}, 	/* 0x4928 */
        {8,	0}, 	/* 0x4929 */
        {8,	0}, 	/* 0x492a */
        {8,	0}, 	/* 0x492b */
        {8,	0}, 	/* 0x492c */
        {8,	0}, 	/* 0x492d */
        {8,	0}, 	/* 0x492e */
        {8,	0}, 	/* 0x492f */
        {8,	0}, 	/* 0x4930 */
        {8,	0}, 	/* 0x4931 */
        {8,	0}, 	/* 0x4932 */
        {8,	0}, 	/* 0x4933 */
        {8,	0}, 	/* 0x4934 */
        {8,	0}, 	/* 0x4935 */
        {8,	0}, 	/* 0x4936 */
        {8,	0}, 	/* 0x4937 */
        {8,	0}, 	/* 0x4938 */
        {8,	0}, 	/* 0x4939 */
        {8,	0}, 	/* 0x493a */
        {8,	0}, 	/* 0x493b */
        {8,	0}, 	/* 0x493c */
        {8,	0}, 	/* 0x493d */
        {8,	0}, 	/* 0x493e */
        {8,	0}, 	/* 0x493f */
        {8,	0}, 	/* 0x4940 */
        {8,	0}, 	/* 0x4941 */
        {8,	0}, 	/* 0x4942 */
        {8,	0}, 	/* 0x4943 */
        {8,	0}, 	/* 0x4944 */
        {8,	0}, 	/* 0x4945 */
        {8,	0}, 	/* 0x4946 */
        {8,	0}, 	/* 0x4947 */
        {8,	0}, 	/* 0x4948 */
        {8,	0}, 	/* 0x4949 */
        {8,	0}, 	/* 0x494a */
        {8,	0}, 	/* 0x494b */
        {8,	0}, 	/* 0x494c */
        {8,	0}, 	/* 0x494d */
        {8,	0}, 	/* 0x494e */
        {8,	0}, 	/* 0x494f */
        {8,	0}, 	/* 0x4950 */
        {8,	0}, 	/* 0x4951 */
        {8,	0}, 	/* 0x4952 */
        {8,	0}, 	/* 0x4953 */
        {8,	0}, 	/* 0x4954 */
        {8,	0}, 	/* 0x4955 */
        {8,	0}, 	/* 0x4956 */
        {8,	0}, 	/* 0x4957 */
        {8,	0}, 	/* 0x4958 */
        {8,	0}, 	/* 0x4959 */
        {8,	0}, 	/* 0x495a */
        {8,	0}, 	/* 0x495b */
        {8,	0}, 	/* 0x495c */
        {8,	0}, 	/* 0x495d */
        {8,	0}, 	/* 0x495e */
        {8,	0}, 	/* 0x495f */
        {8,	0}, 	/* 0x4960 */
        {8,	0}, 	/* 0x4961 */
        {8,	0}, 	/* 0x4962 */
        {8,	0}, 	/* 0x4963 */
        {8,	0}, 	/* 0x4964 */
        {8,	0}, 	/* 0x4965 */
        {8,	0}, 	/* 0x4966 */
        {8,	0}, 	/* 0x4967 */
        {8,	0}, 	/* 0x4968 */
        {8,	0}, 	/* 0x4969 */
        {8,	0}, 	/* 0x496a */
        {8,	0}, 	/* 0x496b */
        {8,	0}, 	/* 0x496c */
        {8,	0}, 	/* 0x496d */
        {8,	0}, 	/* 0x496e */
        {8,	0}, 	/* 0x496f */
        {8,	0}, 	/* 0x4970 */
        {8,	0}, 	/* 0x4971 */
        {8,	0}, 	/* 0x4972 */
        {8,	0}, 	/* 0x4973 */
        {8,	0}, 	/* 0x4974 */
        {8,	0}, 	/* 0x4975 */
        {8,	0}, 	/* 0x4976 */
        {8,	0}, 	/* 0x4977 */
        {8,	0}, 	/* 0x4978 */
        {8,	0}, 	/* 0x4979 */
        {8,	0}, 	/* 0x497a */
        {8,	0}, 	/* 0x497b */
        {8,	0}, 	/* 0x497c */
        {8,	0}, 	/* 0x497d */
        {8,	0}, 	/* 0x497e */
        {8,	0}, 	/* 0x497f */
        {8,	0}, 	/* 0x4980 */
        {8,	0}, 	/* 0x4981 */
        {8,	0}, 	/* 0x4982 */
        {8,	0}, 	/* 0x4983 */
        {8,	0}, 	/* 0x4984 */
        {8,	0}, 	/* 0x4985 */
        {8,	0}, 	/* 0x4986 */
        {8,	0}, 	/* 0x4987 */
        {8,	0}, 	/* 0x4988 */
        {8,	0}, 	/* 0x4989 */
        {8,	0}, 	/* 0x498a */
        {8,	0}, 	/* 0x498b */
        {8,	0}, 	/* 0x498c */
        {8,	0}, 	/* 0x498d */
        {8,	0}, 	/* 0x498e */
        {8,	0}, 	/* 0x498f */
        {8,	0}, 	/* 0x4990 */
        {8,	0}, 	/* 0x4991 */
        {8,	0}, 	/* 0x4992 */
        {8,	0}, 	/* 0x4993 */
        {8,	0}, 	/* 0x4994 */
        {8,	0}, 	/* 0x4995 */
        {8,	0}, 	/* 0x4996 */
        {8,	0}, 	/* 0x4997 */
        {8,	0}, 	/* 0x4998 */
        {8,	0}, 	/* 0x4999 */
        {8,	0}, 	/* 0x499a */
        {8,	0}, 	/* 0x499b */
        {8,	0}, 	/* 0x499c */
        {8,	0}, 	/* 0x499d */
        {8,	0}, 	/* 0x499e */
        {8,	0}, 	/* 0x499f */
        {8,	0}, 	/* 0x49a0 */
        {8,	0}, 	/* 0x49a1 */
        {8,	0}, 	/* 0x49a2 */
        {8,	0}, 	/* 0x49a3 */
        {8,	0}, 	/* 0x49a4 */
        {8,	0}, 	/* 0x49a5 */
        {8,	0}, 	/* 0x49a6 */
        {8,	0}, 	/* 0x49a7 */
        {8,	0}, 	/* 0x49a8 */
        {8,	0}, 	/* 0x49a9 */
        {8,	0}, 	/* 0x49aa */
        {8,	0}, 	/* 0x49ab */
        {8,	0}, 	/* 0x49ac */
        {8,	0}, 	/* 0x49ad */
        {8,	0}, 	/* 0x49ae */
        {8,	0}, 	/* 0x49af */
        {8,	0}, 	/* 0x49b0 */
        {8,	0}, 	/* 0x49b1 */
        {8,	0}, 	/* 0x49b2 */
        {8,	0}, 	/* 0x49b3 */
        {8,	0}, 	/* 0x49b4 */
        {8,	0}, 	/* 0x49b5 */
        {8,	0}, 	/* 0x49b6 */
        {8,	0}, 	/* 0x49b7 */
        {8,	0}, 	/* 0x49b8 */
        {8,	0}, 	/* 0x49b9 */
        {8,	0}, 	/* 0x49ba */
        {8,	0}, 	/* 0x49bb */
        {8,	0}, 	/* 0x49bc */
        {8,	0}, 	/* 0x49bd */
        {8,	0}, 	/* 0x49be */
        {8,	0}, 	/* 0x49bf */
        {8,	0}, 	/* 0x49c0 */
        {8,	0}, 	/* 0x49c1 */
        {8,	0}, 	/* 0x49c2 */
        {8,	0}, 	/* 0x49c3 */
        {8,	0}, 	/* 0x49c4 */
        {8,	0}, 	/* 0x49c5 */
        {8,	0}, 	/* 0x49c6 */
        {8,	0}, 	/* 0x49c7 */
        {8,	0}, 	/* 0x49c8 */
        {8,	0}, 	/* 0x49c9 */
        {8,	0}, 	/* 0x49ca */
        {8,	0}, 	/* 0x49cb */
        {8,	0}, 	/* 0x49cc */
        {8,	0}, 	/* 0x49cd */
        {8,	0}, 	/* 0x49ce */
        {8,	0}, 	/* 0x49cf */
        {8,	0}, 	/* 0x49d0 */
        {8,	0}, 	/* 0x49d1 */
        {8,	0}, 	/* 0x49d2 */
        {8,	0}, 	/* 0x49d3 */
        {8,	0}, 	/* 0x49d4 */
        {8,	0}, 	/* 0x49d5 */
        {8,	0}, 	/* 0x49d6 */
        {8,	0}, 	/* 0x49d7 */
        {8,	0}, 	/* 0x49d8 */
        {8,	0}, 	/* 0x49d9 */
        {8,	0}, 	/* 0x49da */
        {8,	0}, 	/* 0x49db */
        {8,	0}, 	/* 0x49dc */
        {8,	0}, 	/* 0x49dd */
        {8,	0}, 	/* 0x49de */
        {8,	0}, 	/* 0x49df */
        {8,	0}, 	/* 0x49e0 */
        {8,	0}, 	/* 0x49e1 */
        {8,	0}, 	/* 0x49e2 */
        {8,	0}, 	/* 0x49e3 */
        {8,	0}, 	/* 0x49e4 */
        {8,	0}, 	/* 0x49e5 */
        {8,	0}, 	/* 0x49e6 */
        {8,	0}, 	/* 0x49e7 */
        {8,	0}, 	/* 0x49e8 */
        {8,	0}, 	/* 0x49e9 */
        {8,	0}, 	/* 0x49ea */
        {8,	0}, 	/* 0x49eb */
        {8,	0}, 	/* 0x49ec */
        {8,	0}, 	/* 0x49ed */
        {8,	0}, 	/* 0x49ee */
        {8,	0}, 	/* 0x49ef */
        {8,	0}, 	/* 0x49f0 */
        {8,	0}, 	/* 0x49f1 */
        {8,	0}, 	/* 0x49f2 */
        {8,	0}, 	/* 0x49f3 */
        {8,	0}, 	/* 0x49f4 */
        {8,	0}, 	/* 0x49f5 */
        {8,	0}, 	/* 0x49f6 */
        {8,	0}, 	/* 0x49f7 */
        {8,	0}, 	/* 0x49f8 */
        {8,	0}, 	/* 0x49f9 */
        {8,	0}, 	/* 0x49fa */
        {8,	0}, 	/* 0x49fb */
        {8,	0}, 	/* 0x49fc */
        {8,	0}, 	/* 0x49fd */
        {8,	0}, 	/* 0x49fe */
        {8,	0}, 	/* 0x49ff */
        {8,	0}, 	/* 0x4a00 */
        {8,	0}, 	/* 0x4a01 */
        {8,	0}, 	/* 0x4a02 */
        {8,	0}, 	/* 0x4a03 */
        {8,	0}, 	/* 0x4a04 */
        {8,	0}, 	/* 0x4a05 */
        {8,	0}, 	/* 0x4a06 */
        {8,	0}, 	/* 0x4a07 */
        {8,	0}, 	/* 0x4a08 */
        {8,	0}, 	/* 0x4a09 */
        {8,	0}, 	/* 0x4a0a */
        {8,	0}, 	/* 0x4a0b */
        {8,	0}, 	/* 0x4a0c */
        {8,	0}, 	/* 0x4a0d */
        {8,	0}, 	/* 0x4a0e */
        {8,	0}, 	/* 0x4a0f */
        {8,	0}, 	/* 0x4a10 */
        {8,	0}, 	/* 0x4a11 */
        {8,	0}, 	/* 0x4a12 */
        {8,	0}, 	/* 0x4a13 */
        {8,	0}, 	/* 0x4a14 */
        {8,	0}, 	/* 0x4a15 */
        {8,	0}, 	/* 0x4a16 */
        {8,	0}, 	/* 0x4a17 */
        {8,	0}, 	/* 0x4a18 */
        {8,	0}, 	/* 0x4a19 */
        {8,	0}, 	/* 0x4a1a */
        {8,	0}, 	/* 0x4a1b */
        {8,	0}, 	/* 0x4a1c */
        {8,	0}, 	/* 0x4a1d */
        {8,	0}, 	/* 0x4a1e */
        {8,	0}, 	/* 0x4a1f */
        {8,	0}, 	/* 0x4a20 */
        {8,	0}, 	/* 0x4a21 */
        {8,	0}, 	/* 0x4a22 */
        {8,	0}, 	/* 0x4a23 */
        {8,	0}, 	/* 0x4a24 */
        {8,	0}, 	/* 0x4a25 */
        {8,	0}, 	/* 0x4a26 */
        {8,	0}, 	/* 0x4a27 */
        {8,	0}, 	/* 0x4a28 */
        {8,	0}, 	/* 0x4a29 */
        {8,	0}, 	/* 0x4a2a */
        {8,	0}, 	/* 0x4a2b */
        {8,	0}, 	/* 0x4a2c */
        {8,	0}, 	/* 0x4a2d */
        {8,	0}, 	/* 0x4a2e */
        {8,	0}, 	/* 0x4a2f */
        {8,	0}, 	/* 0x4a30 */
        {8,	0}, 	/* 0x4a31 */
        {8,	0}, 	/* 0x4a32 */
        {8,	0}, 	/* 0x4a33 */
        {8,	0}, 	/* 0x4a34 */
        {8,	0}, 	/* 0x4a35 */
        {8,	0}, 	/* 0x4a36 */
        {8,	0}, 	/* 0x4a37 */
        {8,	0}, 	/* 0x4a38 */
        {8,	0}, 	/* 0x4a39 */
        {8,	0}, 	/* 0x4a3a */
        {8,	0}, 	/* 0x4a3b */
        {8,	0}, 	/* 0x4a3c */
        {8,	0}, 	/* 0x4a3d */
        {8,	0}, 	/* 0x4a3e */
        {8,	0}, 	/* 0x4a3f */
        {8,	0}, 	/* 0x4a40 */
        {8,	0}, 	/* 0x4a41 */
        {8,	0}, 	/* 0x4a42 */
        {8,	0}, 	/* 0x4a43 */
        {8,	0}, 	/* 0x4a44 */
        {8,	0}, 	/* 0x4a45 */
        {8,	0}, 	/* 0x4a46 */
        {8,	0}, 	/* 0x4a47 */
        {8,	0}, 	/* 0x4a48 */
        {8,	0}, 	/* 0x4a49 */
        {8,	0}, 	/* 0x4a4a */
        {8,	0}, 	/* 0x4a4b */
        {8,	0}, 	/* 0x4a4c */
        {8,	0}, 	/* 0x4a4d */
        {8,	0}, 	/* 0x4a4e */
        {8,	0}, 	/* 0x4a4f */
        {8,	0}, 	/* 0x4a50 */
        {8,	0}, 	/* 0x4a51 */
        {8,	0}, 	/* 0x4a52 */
        {8,	0}, 	/* 0x4a53 */
        {8,	0}, 	/* 0x4a54 */
        {8,	0}, 	/* 0x4a55 */
        {8,	0}, 	/* 0x4a56 */
        {8,	0}, 	/* 0x4a57 */
        {8,	0}, 	/* 0x4a58 */
        {8,	0}, 	/* 0x4a59 */
        {8,	0}, 	/* 0x4a5a */
        {8,	0}, 	/* 0x4a5b */
        {8,	0}, 	/* 0x4a5c */
        {8,	0}, 	/* 0x4a5d */
        {8,	0}, 	/* 0x4a5e */
        {8,	0}, 	/* 0x4a5f */
        {8,	0}, 	/* 0x4a60 */
        {8,	0}, 	/* 0x4a61 */
        {8,	0}, 	/* 0x4a62 */
        {8,	0}, 	/* 0x4a63 */
        {8,	0}, 	/* 0x4a64 */
        {8,	0}, 	/* 0x4a65 */
        {8,	0}, 	/* 0x4a66 */
        {8,	0}, 	/* 0x4a67 */
        {8,	0}, 	/* 0x4a68 */
        {8,	0}, 	/* 0x4a69 */
        {8,	0}, 	/* 0x4a6a */
        {8,	0}, 	/* 0x4a6b */
        {8,	0}, 	/* 0x4a6c */
        {8,	0}, 	/* 0x4a6d */
        {8,	0}, 	/* 0x4a6e */
        {8,	0}, 	/* 0x4a6f */
        {8,	0}, 	/* 0x4a70 */
        {8,	0}, 	/* 0x4a71 */
        {8,	0}, 	/* 0x4a72 */
        {8,	0}, 	/* 0x4a73 */
        {8,	0}, 	/* 0x4a74 */
        {8,	0}, 	/* 0x4a75 */
        {8,	0}, 	/* 0x4a76 */
        {8,	0}, 	/* 0x4a77 */
        {8,	0}, 	/* 0x4a78 */
        {8,	0}, 	/* 0x4a79 */
        {8,	0}, 	/* 0x4a7a */
        {8,	0}, 	/* 0x4a7b */
        {8,	0}, 	/* 0x4a7c */
        {8,	0}, 	/* 0x4a7d */
        {8,	0}, 	/* 0x4a7e */
        {8,	0}, 	/* 0x4a7f */
        {8,	0}, 	/* 0x4a80 */
        {8,	0}, 	/* 0x4a81 */
        {8,	0}, 	/* 0x4a82 */
        {8,	0}, 	/* 0x4a83 */
        {8,	0}, 	/* 0x4a84 */
        {8,	0}, 	/* 0x4a85 */
        {8,	0}, 	/* 0x4a86 */
        {8,	0}, 	/* 0x4a87 */
        {8,	0}, 	/* 0x4a88 */
        {8,	0}, 	/* 0x4a89 */
        {8,	0}, 	/* 0x4a8a */
        {8,	0}, 	/* 0x4a8b */
        {8,	0}, 	/* 0x4a8c */
        {8,	0}, 	/* 0x4a8d */
        {8,	0}, 	/* 0x4a8e */
        {8,	0}, 	/* 0x4a8f */
        {8,	0}, 	/* 0x4a90 */
        {8,	0}, 	/* 0x4a91 */
        {8,	0}, 	/* 0x4a92 */
        {8,	0}, 	/* 0x4a93 */
        {8,	0}, 	/* 0x4a94 */
        {8,	0}, 	/* 0x4a95 */
        {8,	0}, 	/* 0x4a96 */
        {8,	0}, 	/* 0x4a97 */
        {8,	0}, 	/* 0x4a98 */
        {8,	0}, 	/* 0x4a99 */
        {8,	0}, 	/* 0x4a9a */
        {8,	0}, 	/* 0x4a9b */
        {8,	0}, 	/* 0x4a9c */
        {8,	0}, 	/* 0x4a9d */
        {8,	0}, 	/* 0x4a9e */
        {8,	0}, 	/* 0x4a9f */
        {8,	0}, 	/* 0x4aa0 */
        {8,	0}, 	/* 0x4aa1 */
        {8,	0}, 	/* 0x4aa2 */
        {8,	0}, 	/* 0x4aa3 */
        {8,	0}, 	/* 0x4aa4 */
        {8,	0}, 	/* 0x4aa5 */
        {8,	0}, 	/* 0x4aa6 */
        {8,	0}, 	/* 0x4aa7 */
        {8,	0}, 	/* 0x4aa8 */
        {8,	0}, 	/* 0x4aa9 */
        {8,	0}, 	/* 0x4aaa */
        {8,	0}, 	/* 0x4aab */
        {8,	0}, 	/* 0x4aac */
        {8,	0}, 	/* 0x4aad */
        {8,	0}, 	/* 0x4aae */
        {8,	0}, 	/* 0x4aaf */
        {8,	0}, 	/* 0x4ab0 */
        {8,	0}, 	/* 0x4ab1 */
        {8,	0}, 	/* 0x4ab2 */
        {8,	0}, 	/* 0x4ab3 */
        {8,	0}, 	/* 0x4ab4 */
        {8,	0}, 	/* 0x4ab5 */
        {8,	0}, 	/* 0x4ab6 */
        {8,	0}, 	/* 0x4ab7 */
        {8,	0}, 	/* 0x4ab8 */
        {8,	0}, 	/* 0x4ab9 */
        {8,	0}, 	/* 0x4aba */
        {8,	0}, 	/* 0x4abb */
        {8,	0}, 	/* 0x4abc */
        {8,	0}, 	/* 0x4abd */
        {8,	0}, 	/* 0x4abe */
        {8,	0}, 	/* 0x4abf */
        {8,	0}, 	/* 0x4ac0 */
        {8,	0}, 	/* 0x4ac1 */
        {8,	0}, 	/* 0x4ac2 */
        {8,	0}, 	/* 0x4ac3 */
        {8,	0}, 	/* 0x4ac4 */
        {8,	0}, 	/* 0x4ac5 */
        {8,	0}, 	/* 0x4ac6 */
        {8,	0}, 	/* 0x4ac7 */
        {8,	0}, 	/* 0x4ac8 */
        {8,	0}, 	/* 0x4ac9 */
        {8,	0}, 	/* 0x4aca */
        {8,	0}, 	/* 0x4acb */
        {8,	0}, 	/* 0x4acc */
        {8,	0}, 	/* 0x4acd */
        {8,	0}, 	/* 0x4ace */
        {8,	0}, 	/* 0x4acf */
        {8,	0}, 	/* 0x4ad0 */
        {8,	0}, 	/* 0x4ad1 */
        {8,	0}, 	/* 0x4ad2 */
        {8,	0}, 	/* 0x4ad3 */
        {8,	0}, 	/* 0x4ad4 */
        {8,	0}, 	/* 0x4ad5 */
        {8,	0}, 	/* 0x4ad6 */
        {8,	0}, 	/* 0x4ad7 */
        {8,	0}, 	/* 0x4ad8 */
        {8,	0}, 	/* 0x4ad9 */
        {8,	0}, 	/* 0x4ada */
        {8,	0}, 	/* 0x4adb */
        {8,	0}, 	/* 0x4adc */
        {8,	0}, 	/* 0x4add */
        {8,	0}, 	/* 0x4ade */
        {8,	0}, 	/* 0x4adf */
        {8,	0}, 	/* 0x4ae0 */
        {8,	0}, 	/* 0x4ae1 */
        {8,	0}, 	/* 0x4ae2 */
        {8,	0}, 	/* 0x4ae3 */
        {8,	0}, 	/* 0x4ae4 */
        {8,	0}, 	/* 0x4ae5 */
        {8,	0}, 	/* 0x4ae6 */
        {8,	0}, 	/* 0x4ae7 */
        {8,	0}, 	/* 0x4ae8 */
        {8,	0}, 	/* 0x4ae9 */
        {8,	0}, 	/* 0x4aea */
        {8,	0}, 	/* 0x4aeb */
        {8,	0}, 	/* 0x4aec */
        {8,	0}, 	/* 0x4aed */
        {8,	0}, 	/* 0x4aee */
        {8,	0}, 	/* 0x4aef */
        {8,	0}, 	/* 0x4af0 */
        {8,	0}, 	/* 0x4af1 */
        {8,	0}, 	/* 0x4af2 */
        {8,	0}, 	/* 0x4af3 */
        {8,	0}, 	/* 0x4af4 */
        {8,	0}, 	/* 0x4af5 */
        {8,	0}, 	/* 0x4af6 */
        {8,	0}, 	/* 0x4af7 */
        {8,	0}, 	/* 0x4af8 */
        {8,	0}, 	/* 0x4af9 */
        {8,	0}, 	/* 0x4afa */
        {8,	0}, 	/* 0x4afb */
        {8,	0}, 	/* 0x4afc */
        {8,	0}, 	/* 0x4afd */
        {8,	0}, 	/* 0x4afe */
        {8,	0}, 	/* 0x4aff */
        {8,	0}, 	/* 0x4b00 */
        {8,	0}, 	/* 0x4b01 */
        {8,	0}, 	/* 0x4b02 */
        {8,	0}, 	/* 0x4b03 */
        {8,	0}, 	/* 0x4b04 */
        {8,	0}, 	/* 0x4b05 */
        {8,	0}, 	/* 0x4b06 */
        {8,	0}, 	/* 0x4b07 */
        {8,	0}, 	/* 0x4b08 */
        {8,	0}, 	/* 0x4b09 */
        {8,	0}, 	/* 0x4b0a */
        {8,	0}, 	/* 0x4b0b */
        {8,	0}, 	/* 0x4b0c */
        {8,	0}, 	/* 0x4b0d */
        {8,	0}, 	/* 0x4b0e */
        {8,	0}, 	/* 0x4b0f */
        {8,	0}, 	/* 0x4b10 */
        {8,	0}, 	/* 0x4b11 */
        {8,	0}, 	/* 0x4b12 */
        {8,	0}, 	/* 0x4b13 */
        {8,	0}, 	/* 0x4b14 */
        {8,	0}, 	/* 0x4b15 */
        {8,	0}, 	/* 0x4b16 */
        {8,	0}, 	/* 0x4b17 */
        {8,	0}, 	/* 0x4b18 */
        {8,	0}, 	/* 0x4b19 */
        {8,	0}, 	/* 0x4b1a */
        {8,	0}, 	/* 0x4b1b */
        {8,	0}, 	/* 0x4b1c */
        {8,	0}, 	/* 0x4b1d */
        {8,	0}, 	/* 0x4b1e */
        {8,	0}, 	/* 0x4b1f */
        {8,	0}, 	/* 0x4b20 */
        {8,	0}, 	/* 0x4b21 */
        {8,	0}, 	/* 0x4b22 */
        {8,	0}, 	/* 0x4b23 */
        {8,	0}, 	/* 0x4b24 */
        {8,	0}, 	/* 0x4b25 */
        {8,	0}, 	/* 0x4b26 */
        {8,	0}, 	/* 0x4b27 */
        {8,	0}, 	/* 0x4b28 */
        {8,	0}, 	/* 0x4b29 */
        {8,	0}, 	/* 0x4b2a */
        {8,	0}, 	/* 0x4b2b */
        {8,	0}, 	/* 0x4b2c */
        {8,	0}, 	/* 0x4b2d */
        {8,	0}, 	/* 0x4b2e */
        {8,	0}, 	/* 0x4b2f */
        {8,	0}, 	/* 0x4b30 */
        {8,	0}, 	/* 0x4b31 */
        {8,	0}, 	/* 0x4b32 */
        {8,	0}, 	/* 0x4b33 */
        {8,	0}, 	/* 0x4b34 */
        {8,	0}, 	/* 0x4b35 */
        {8,	0}, 	/* 0x4b36 */
        {8,	0}, 	/* 0x4b37 */
        {8,	0}, 	/* 0x4b38 */
        {8,	0}, 	/* 0x4b39 */
        {8,	0}, 	/* 0x4b3a */
        {8,	0}, 	/* 0x4b3b */
        {8,	0}, 	/* 0x4b3c */
        {8,	0}, 	/* 0x4b3d */
        {8,	0}, 	/* 0x4b3e */
        {8,	0}, 	/* 0x4b3f */
        {8,	0}, 	/* 0x4b40 */
        {8,	0}, 	/* 0x4b41 */
        {8,	0}, 	/* 0x4b42 */
        {8,	0}, 	/* 0x4b43 */
        {8,	0}, 	/* 0x4b44 */
        {8,	0}, 	/* 0x4b45 */
        {8,	0}, 	/* 0x4b46 */
        {8,	0}, 	/* 0x4b47 */
        {8,	0}, 	/* 0x4b48 */
        {8,	0}, 	/* 0x4b49 */
        {8,	0}, 	/* 0x4b4a */
        {8,	0}, 	/* 0x4b4b */
        {8,	0}, 	/* 0x4b4c */
        {8,	0}, 	/* 0x4b4d */
        {8,	0}, 	/* 0x4b4e */
        {8,	0}, 	/* 0x4b4f */
        {8,	0}, 	/* 0x4b50 */
        {8,	0}, 	/* 0x4b51 */
        {8,	0}, 	/* 0x4b52 */
        {8,	0}, 	/* 0x4b53 */
        {8,	0}, 	/* 0x4b54 */
        {8,	0}, 	/* 0x4b55 */
        {8,	0}, 	/* 0x4b56 */
        {8,	0}, 	/* 0x4b57 */
        {8,	0}, 	/* 0x4b58 */
        {8,	0}, 	/* 0x4b59 */
        {8,	0}, 	/* 0x4b5a */
        {8,	0}, 	/* 0x4b5b */
        {8,	0}, 	/* 0x4b5c */
        {8,	0}, 	/* 0x4b5d */
        {8,	0}, 	/* 0x4b5e */
        {8,	0}, 	/* 0x4b5f */
        {8,	0}, 	/* 0x4b60 */
        {8,	0}, 	/* 0x4b61 */
        {8,	0}, 	/* 0x4b62 */
        {8,	0}, 	/* 0x4b63 */
        {8,	0}, 	/* 0x4b64 */
        {8,	0}, 	/* 0x4b65 */
        {8,	0}, 	/* 0x4b66 */
        {8,	0}, 	/* 0x4b67 */
        {8,	0}, 	/* 0x4b68 */
        {8,	0}, 	/* 0x4b69 */
        {8,	0}, 	/* 0x4b6a */
        {8,	0}, 	/* 0x4b6b */
        {8,	0}, 	/* 0x4b6c */
        {8,	0}, 	/* 0x4b6d */
        {8,	0}, 	/* 0x4b6e */
        {8,	0}, 	/* 0x4b6f */
        {8,	0}, 	/* 0x4b70 */
        {8,	0}, 	/* 0x4b71 */
        {8,	0}, 	/* 0x4b72 */
        {8,	0}, 	/* 0x4b73 */
        {8,	0}, 	/* 0x4b74 */
        {8,	0}, 	/* 0x4b75 */
        {8,	0}, 	/* 0x4b76 */
        {8,	0}, 	/* 0x4b77 */
        {8,	0}, 	/* 0x4b78 */
        {8,	0}, 	/* 0x4b79 */
        {8,	0}, 	/* 0x4b7a */
        {8,	0}, 	/* 0x4b7b */
        {8,	0}, 	/* 0x4b7c */
        {8,	0}, 	/* 0x4b7d */
        {8,	0}, 	/* 0x4b7e */
        {8,	0}, 	/* 0x4b7f */
        {8,	0}, 	/* 0x4b80 */
        {8,	0}, 	/* 0x4b81 */
        {8,	0}, 	/* 0x4b82 */
        {8,	0}, 	/* 0x4b83 */
        {8,	0}, 	/* 0x4b84 */
        {8,	0}, 	/* 0x4b85 */
        {8,	0}, 	/* 0x4b86 */
        {8,	0}, 	/* 0x4b87 */
        {8,	0}, 	/* 0x4b88 */
        {8,	0}, 	/* 0x4b89 */
        {8,	0}, 	/* 0x4b8a */
        {8,	0}, 	/* 0x4b8b */
        {8,	0}, 	/* 0x4b8c */
        {8,	0}, 	/* 0x4b8d */
        {8,	0}, 	/* 0x4b8e */
        {8,	0}, 	/* 0x4b8f */
        {8,	0}, 	/* 0x4b90 */
        {8,	0}, 	/* 0x4b91 */
        {8,	0}, 	/* 0x4b92 */
        {8,	0}, 	/* 0x4b93 */
        {8,	0}, 	/* 0x4b94 */
        {8,	0}, 	/* 0x4b95 */
        {8,	0}, 	/* 0x4b96 */
        {8,	0}, 	/* 0x4b97 */
        {8,	0}, 	/* 0x4b98 */
        {8,	0}, 	/* 0x4b99 */
        {8,	0}, 	/* 0x4b9a */
        {8,	0}, 	/* 0x4b9b */
        {8,	0}, 	/* 0x4b9c */
        {8,	0}, 	/* 0x4b9d */
        {8,	0}, 	/* 0x4b9e */
        {8,	0}, 	/* 0x4b9f */
        {8,	0}, 	/* 0x4ba0 */
        {8,	0}, 	/* 0x4ba1 */
        {8,	0}, 	/* 0x4ba2 */
        {8,	0}, 	/* 0x4ba3 */
        {8,	0}, 	/* 0x4ba4 */
        {8,	0}, 	/* 0x4ba5 */
        {8,	0}, 	/* 0x4ba6 */
        {8,	0}, 	/* 0x4ba7 */
        {8,	0}, 	/* 0x4ba8 */
        {8,	0}, 	/* 0x4ba9 */
        {8,	0}, 	/* 0x4baa */
        {8,	0}, 	/* 0x4bab */
        {8,	0}, 	/* 0x4bac */
        {8,	0}, 	/* 0x4bad */
        {8,	0}, 	/* 0x4bae */
        {8,	0}, 	/* 0x4baf */
        {8,	0}, 	/* 0x4bb0 */
        {8,	0}, 	/* 0x4bb1 */
        {8,	0}, 	/* 0x4bb2 */
        {8,	0}, 	/* 0x4bb3 */
        {8,	0}, 	/* 0x4bb4 */
        {8,	0}, 	/* 0x4bb5 */
        {8,	0}, 	/* 0x4bb6 */
        {8,	0}, 	/* 0x4bb7 */
        {8,	0}, 	/* 0x4bb8 */
        {8,	0}, 	/* 0x4bb9 */
        {8,	0}, 	/* 0x4bba */
        {8,	0}, 	/* 0x4bbb */
        {8,	0}, 	/* 0x4bbc */
        {8,	0}, 	/* 0x4bbd */
        {8,	0}, 	/* 0x4bbe */
        {8,	0}, 	/* 0x4bbf */
        {8,	0}, 	/* 0x4bc0 */
        {8,	0}, 	/* 0x4bc1 */
        {8,	0}, 	/* 0x4bc2 */
        {8,	0}, 	/* 0x4bc3 */
        {8,	0}, 	/* 0x4bc4 */
        {8,	0}, 	/* 0x4bc5 */
        {8,	0}, 	/* 0x4bc6 */
        {8,	0}, 	/* 0x4bc7 */
        {8,	0}, 	/* 0x4bc8 */
        {8,	0}, 	/* 0x4bc9 */
        {8,	0}, 	/* 0x4bca */
        {8,	0}, 	/* 0x4bcb */
        {8,	0}, 	/* 0x4bcc */
        {8,	0}, 	/* 0x4bcd */
        {8,	0}, 	/* 0x4bce */
        {8,	0}, 	/* 0x4bcf */
        {8,	0}, 	/* 0x4bd0 */
        {8,	0}, 	/* 0x4bd1 */
        {8,	0}, 	/* 0x4bd2 */
        {8,	0}, 	/* 0x4bd3 */
        {8,	0}, 	/* 0x4bd4 */
        {8,	0}, 	/* 0x4bd5 */
        {8,	0}, 	/* 0x4bd6 */
        {8,	0}, 	/* 0x4bd7 */
        {8,	0}, 	/* 0x4bd8 */
        {8,	0}, 	/* 0x4bd9 */
        {8,	0}, 	/* 0x4bda */
        {8,	0}, 	/* 0x4bdb */
        {8,	0}, 	/* 0x4bdc */
        {8,	0}, 	/* 0x4bdd */
        {8,	0}, 	/* 0x4bde */
        {8,	0}, 	/* 0x4bdf */
        {8,	0}, 	/* 0x4be0 */
        {8,	0}, 	/* 0x4be1 */
        {8,	0}, 	/* 0x4be2 */
        {8,	0}, 	/* 0x4be3 */
        {8,	0}, 	/* 0x4be4 */
        {8,	0}, 	/* 0x4be5 */
        {8,	0}, 	/* 0x4be6 */
        {8,	0}, 	/* 0x4be7 */
        {8,	0}, 	/* 0x4be8 */
        {8,	0}, 	/* 0x4be9 */
        {8,	0}, 	/* 0x4bea */
        {8,	0}, 	/* 0x4beb */
        {8,	0}, 	/* 0x4bec */
        {8,	0}, 	/* 0x4bed */
        {8,	0}, 	/* 0x4bee */
        {8,	0}, 	/* 0x4bef */
        {8,	0}, 	/* 0x4bf0 */
        {8,	0}, 	/* 0x4bf1 */
        {8,	0}, 	/* 0x4bf2 */
        {8,	0}, 	/* 0x4bf3 */
        {8,	0}, 	/* 0x4bf4 */
        {8,	0}, 	/* 0x4bf5 */
        {8,	0}, 	/* 0x4bf6 */
        {8,	0}, 	/* 0x4bf7 */
        {8,	0}, 	/* 0x4bf8 */
        {8,	0}, 	/* 0x4bf9 */
        {8,	0}, 	/* 0x4bfa */
        {8,	0}, 	/* 0x4bfb */
        {8,	0}, 	/* 0x4bfc */
        {8,	0}, 	/* 0x4bfd */
        {8,	0}, 	/* 0x4bfe */
        {8,	0}, 	/* 0x4bff */
        {8,	0}, 	/* 0x4c00 */
        {8,	0}, 	/* 0x4c01 */
        {8,	0}, 	/* 0x4c02 */
        {8,	0}, 	/* 0x4c03 */
        {8,	0}, 	/* 0x4c04 */
        {8,	0}, 	/* 0x4c05 */
        {8,	0}, 	/* 0x4c06 */
        {8,	0}, 	/* 0x4c07 */
        {8,	0}, 	/* 0x4c08 */
        {8,	0}, 	/* 0x4c09 */
        {8,	0}, 	/* 0x4c0a */
        {8,	0}, 	/* 0x4c0b */
        {8,	0}, 	/* 0x4c0c */
        {8,	0}, 	/* 0x4c0d */
        {8,	0}, 	/* 0x4c0e */
        {8,	0}, 	/* 0x4c0f */
        {8,	0}, 	/* 0x4c10 */
        {8,	0}, 	/* 0x4c11 */
        {8,	0}, 	/* 0x4c12 */
        {8,	0}, 	/* 0x4c13 */
        {8,	0}, 	/* 0x4c14 */
        {8,	0}, 	/* 0x4c15 */
        {8,	0}, 	/* 0x4c16 */
        {8,	0}, 	/* 0x4c17 */
        {8,	0}, 	/* 0x4c18 */
        {8,	0}, 	/* 0x4c19 */
        {8,	0}, 	/* 0x4c1a */
        {8,	0}, 	/* 0x4c1b */
        {8,	0}, 	/* 0x4c1c */
        {8,	0}, 	/* 0x4c1d */
        {8,	0}, 	/* 0x4c1e */
        {8,	0}, 	/* 0x4c1f */
        {8,	0}, 	/* 0x4c20 */
        {8,	0}, 	/* 0x4c21 */
        {8,	0}, 	/* 0x4c22 */
        {8,	0}, 	/* 0x4c23 */
        {8,	0}, 	/* 0x4c24 */
        {8,	0}, 	/* 0x4c25 */
        {8,	0}, 	/* 0x4c26 */
        {8,	0}, 	/* 0x4c27 */
        {8,	0}, 	/* 0x4c28 */
        {8,	0}, 	/* 0x4c29 */
        {8,	0}, 	/* 0x4c2a */
        {8,	0}, 	/* 0x4c2b */
        {8,	0}, 	/* 0x4c2c */
        {8,	0}, 	/* 0x4c2d */
        {8,	0}, 	/* 0x4c2e */
        {8,	0}, 	/* 0x4c2f */
        {8,	0}, 	/* 0x4c30 */
        {8,	0}, 	/* 0x4c31 */
        {8,	0}, 	/* 0x4c32 */
        {8,	0}, 	/* 0x4c33 */
        {8,	0}, 	/* 0x4c34 */
        {8,	0}, 	/* 0x4c35 */
        {8,	0}, 	/* 0x4c36 */
        {8,	0}, 	/* 0x4c37 */
        {8,	0}, 	/* 0x4c38 */
        {8,	0}, 	/* 0x4c39 */
        {8,	0}, 	/* 0x4c3a */
        {8,	0}, 	/* 0x4c3b */
        {8,	0}, 	/* 0x4c3c */
        {8,	0}, 	/* 0x4c3d */
        {8,	0}, 	/* 0x4c3e */
        {8,	0}, 	/* 0x4c3f */
        {8,	0}, 	/* 0x4c40 */
        {8,	0}, 	/* 0x4c41 */
        {8,	0}, 	/* 0x4c42 */
        {8,	0}, 	/* 0x4c43 */
        {8,	0}, 	/* 0x4c44 */
        {8,	0}, 	/* 0x4c45 */
        {8,	0}, 	/* 0x4c46 */
        {8,	0}, 	/* 0x4c47 */
        {8,	0}, 	/* 0x4c48 */
        {8,	0}, 	/* 0x4c49 */
        {8,	0}, 	/* 0x4c4a */
        {8,	0}, 	/* 0x4c4b */
        {8,	0}, 	/* 0x4c4c */
        {8,	0}, 	/* 0x4c4d */
        {8,	0}, 	/* 0x4c4e */
        {8,	0}, 	/* 0x4c4f */
        {8,	0}, 	/* 0x4c50 */
        {8,	0}, 	/* 0x4c51 */
        {8,	0}, 	/* 0x4c52 */
        {8,	0}, 	/* 0x4c53 */
        {8,	0}, 	/* 0x4c54 */
        {8,	0}, 	/* 0x4c55 */
        {8,	0}, 	/* 0x4c56 */
        {8,	0}, 	/* 0x4c57 */
        {8,	0}, 	/* 0x4c58 */
        {8,	0}, 	/* 0x4c59 */
        {8,	0}, 	/* 0x4c5a */
        {8,	0}, 	/* 0x4c5b */
        {8,	0}, 	/* 0x4c5c */
        {8,	0}, 	/* 0x4c5d */
        {8,	0}, 	/* 0x4c5e */
        {8,	0}, 	/* 0x4c5f */
        {8,	0}, 	/* 0x4c60 */
        {8,	0}, 	/* 0x4c61 */
        {8,	0}, 	/* 0x4c62 */
        {8,	0}, 	/* 0x4c63 */
        {8,	0}, 	/* 0x4c64 */
        {8,	0}, 	/* 0x4c65 */
        {8,	0}, 	/* 0x4c66 */
        {8,	0}, 	/* 0x4c67 */
        {8,	0}, 	/* 0x4c68 */
        {8,	0}, 	/* 0x4c69 */
        {8,	0}, 	/* 0x4c6a */
        {8,	0}, 	/* 0x4c6b */
        {8,	0}, 	/* 0x4c6c */
        {8,	0}, 	/* 0x4c6d */
        {8,	0}, 	/* 0x4c6e */
        {8,	0}, 	/* 0x4c6f */
        {8,	0}, 	/* 0x4c70 */
        {8,	0}, 	/* 0x4c71 */
        {8,	0}, 	/* 0x4c72 */
        {8,	0}, 	/* 0x4c73 */
        {8,	0}, 	/* 0x4c74 */
        {8,	0}, 	/* 0x4c75 */
        {8,	0}, 	/* 0x4c76 */
        {8,	0}, 	/* 0x4c77 */
        {8,	0}, 	/* 0x4c78 */
        {8,	0}, 	/* 0x4c79 */
        {8,	0}, 	/* 0x4c7a */
        {8,	0}, 	/* 0x4c7b */
        {8,	0}, 	/* 0x4c7c */
        {8,	0}, 	/* 0x4c7d */
        {8,	0}, 	/* 0x4c7e */
        {8,	0}, 	/* 0x4c7f */
        {8,	0}, 	/* 0x4c80 */
        {8,	0}, 	/* 0x4c81 */
        {8,	0}, 	/* 0x4c82 */
        {8,	0}, 	/* 0x4c83 */
        {8,	0}, 	/* 0x4c84 */
        {8,	0}, 	/* 0x4c85 */
        {8,	0}, 	/* 0x4c86 */
        {8,	0}, 	/* 0x4c87 */
        {8,	0}, 	/* 0x4c88 */
        {8,	0}, 	/* 0x4c89 */
        {8,	0}, 	/* 0x4c8a */
        {8,	0}, 	/* 0x4c8b */
        {8,	0}, 	/* 0x4c8c */
        {8,	0}, 	/* 0x4c8d */
        {8,	0}, 	/* 0x4c8e */
        {8,	0}, 	/* 0x4c8f */
        {8,	0}, 	/* 0x4c90 */
        {8,	0}, 	/* 0x4c91 */
        {8,	0}, 	/* 0x4c92 */
        {8,	0}, 	/* 0x4c93 */
        {8,	0}, 	/* 0x4c94 */
        {8,	0}, 	/* 0x4c95 */
        {8,	0}, 	/* 0x4c96 */
        {8,	0}, 	/* 0x4c97 */
        {8,	0}, 	/* 0x4c98 */
        {8,	0}, 	/* 0x4c99 */
        {8,	0}, 	/* 0x4c9a */
        {8,	0}, 	/* 0x4c9b */
        {8,	0}, 	/* 0x4c9c */
        {8,	0}, 	/* 0x4c9d */
        {8,	0}, 	/* 0x4c9e */
        {8,	0}, 	/* 0x4c9f */
        {8,	0}, 	/* 0x4ca0 */
        {8,	0}, 	/* 0x4ca1 */
        {8,	0}, 	/* 0x4ca2 */
        {8,	0}, 	/* 0x4ca3 */
        {8,	0}, 	/* 0x4ca4 */
        {8,	0}, 	/* 0x4ca5 */
        {8,	0}, 	/* 0x4ca6 */
        {8,	0}, 	/* 0x4ca7 */
        {8,	0}, 	/* 0x4ca8 */
        {8,	0}, 	/* 0x4ca9 */
        {8,	0}, 	/* 0x4caa */
        {8,	0}, 	/* 0x4cab */
        {8,	0}, 	/* 0x4cac */
        {8,	0}, 	/* 0x4cad */
        {8,	0}, 	/* 0x4cae */
        {8,	0}, 	/* 0x4caf */
        {8,	0}, 	/* 0x4cb0 */
        {8,	0}, 	/* 0x4cb1 */
        {8,	0}, 	/* 0x4cb2 */
        {8,	0}, 	/* 0x4cb3 */
        {8,	0}, 	/* 0x4cb4 */
        {8,	0}, 	/* 0x4cb5 */
        {8,	0}, 	/* 0x4cb6 */
        {8,	0}, 	/* 0x4cb7 */
        {8,	0}, 	/* 0x4cb8 */
        {8,	0}, 	/* 0x4cb9 */
        {8,	0}, 	/* 0x4cba */
        {8,	0}, 	/* 0x4cbb */
        {8,	0}, 	/* 0x4cbc */
        {8,	0}, 	/* 0x4cbd */
        {8,	0}, 	/* 0x4cbe */
        {8,	0}, 	/* 0x4cbf */
        {8,	0}, 	/* 0x4cc0 */
        {8,	0}, 	/* 0x4cc1 */
        {8,	0}, 	/* 0x4cc2 */
        {8,	0}, 	/* 0x4cc3 */
        {8,	0}, 	/* 0x4cc4 */
        {8,	0}, 	/* 0x4cc5 */
        {8,	0}, 	/* 0x4cc6 */
        {8,	0}, 	/* 0x4cc7 */
        {8,	0}, 	/* 0x4cc8 */
        {8,	0}, 	/* 0x4cc9 */
        {8,	0}, 	/* 0x4cca */
        {8,	0}, 	/* 0x4ccb */
        {8,	0}, 	/* 0x4ccc */
        {8,	0}, 	/* 0x4ccd */
        {8,	0}, 	/* 0x4cce */
        {8,	0}, 	/* 0x4ccf */
        {8,	0}, 	/* 0x4cd0 */
        {8,	0}, 	/* 0x4cd1 */
        {8,	0}, 	/* 0x4cd2 */
        {8,	0}, 	/* 0x4cd3 */
        {8,	0}, 	/* 0x4cd4 */
        {8,	0}, 	/* 0x4cd5 */
        {8,	0}, 	/* 0x4cd6 */
        {8,	0}, 	/* 0x4cd7 */
        {8,	0}, 	/* 0x4cd8 */
        {8,	0}, 	/* 0x4cd9 */
        {8,	0}, 	/* 0x4cda */
        {8,	0}, 	/* 0x4cdb */
        {8,	0}, 	/* 0x4cdc */
        {8,	0}, 	/* 0x4cdd */
        {8,	0}, 	/* 0x4cde */
        {8,	0}, 	/* 0x4cdf */
        {8,	0}, 	/* 0x4ce0 */
        {8,	0}, 	/* 0x4ce1 */
        {8,	0}, 	/* 0x4ce2 */
        {8,	0}, 	/* 0x4ce3 */
        {8,	0}, 	/* 0x4ce4 */
        {8,	0}, 	/* 0x4ce5 */
        {8,	0}, 	/* 0x4ce6 */
        {8,	0}, 	/* 0x4ce7 */
        {8,	0}, 	/* 0x4ce8 */
        {8,	0}, 	/* 0x4ce9 */
        {8,	0}, 	/* 0x4cea */
        {8,	0}, 	/* 0x4ceb */
        {8,	0}, 	/* 0x4cec */
        {8,	0}, 	/* 0x4ced */
        {8,	0}, 	/* 0x4cee */
        {8,	0}, 	/* 0x4cef */
        {8,	0}, 	/* 0x4cf0 */
        {8,	0}, 	/* 0x4cf1 */
        {8,	0}, 	/* 0x4cf2 */
        {8,	0}, 	/* 0x4cf3 */
        {8,	0}, 	/* 0x4cf4 */
        {8,	0}, 	/* 0x4cf5 */
        {8,	0}, 	/* 0x4cf6 */
        {8,	0}, 	/* 0x4cf7 */
        {8,	0}, 	/* 0x4cf8 */
        {8,	0}, 	/* 0x4cf9 */
        {8,	0}, 	/* 0x4cfa */
        {8,	0}, 	/* 0x4cfb */
        {8,	0}, 	/* 0x4cfc */
        {8,	0}, 	/* 0x4cfd */
        {8,	0}, 	/* 0x4cfe */
        {8,	0}, 	/* 0x4cff */
        {8,	0}, 	/* 0x4d00 */
        {8,	0}, 	/* 0x4d01 */
        {8,	0}, 	/* 0x4d02 */
        {8,	0}, 	/* 0x4d03 */
        {8,	0}, 	/* 0x4d04 */
        {8,	0}, 	/* 0x4d05 */
        {8,	0}, 	/* 0x4d06 */
        {8,	0}, 	/* 0x4d07 */
        {8,	0}, 	/* 0x4d08 */
        {8,	0}, 	/* 0x4d09 */
        {8,	0}, 	/* 0x4d0a */
        {8,	0}, 	/* 0x4d0b */
        {8,	0}, 	/* 0x4d0c */
        {8,	0}, 	/* 0x4d0d */
        {8,	0}, 	/* 0x4d0e */
        {8,	0}, 	/* 0x4d0f */
        {8,	0}, 	/* 0x4d10 */
        {8,	0}, 	/* 0x4d11 */
        {8,	0}, 	/* 0x4d12 */
        {8,	0}, 	/* 0x4d13 */
        {8,	0}, 	/* 0x4d14 */
        {8,	0}, 	/* 0x4d15 */
        {8,	0}, 	/* 0x4d16 */
        {8,	0}, 	/* 0x4d17 */
        {8,	0}, 	/* 0x4d18 */
        {8,	0}, 	/* 0x4d19 */
        {8,	0}, 	/* 0x4d1a */
        {8,	0}, 	/* 0x4d1b */
        {8,	0}, 	/* 0x4d1c */
        {8,	0}, 	/* 0x4d1d */
        {8,	0}, 	/* 0x4d1e */
        {8,	0}, 	/* 0x4d1f */
        {8,	0}, 	/* 0x4d20 */
        {8,	0}, 	/* 0x4d21 */
        {8,	0}, 	/* 0x4d22 */
        {8,	0}, 	/* 0x4d23 */
        {8,	0}, 	/* 0x4d24 */
        {8,	0}, 	/* 0x4d25 */
        {8,	0}, 	/* 0x4d26 */
        {8,	0}, 	/* 0x4d27 */
        {8,	0}, 	/* 0x4d28 */
        {8,	0}, 	/* 0x4d29 */
        {8,	0}, 	/* 0x4d2a */
        {8,	0}, 	/* 0x4d2b */
        {8,	0}, 	/* 0x4d2c */
        {8,	0}, 	/* 0x4d2d */
        {8,	0}, 	/* 0x4d2e */
        {8,	0}, 	/* 0x4d2f */
        {8,	0}, 	/* 0x4d30 */
        {8,	0}, 	/* 0x4d31 */
        {8,	0}, 	/* 0x4d32 */
        {8,	0}, 	/* 0x4d33 */
        {8,	0}, 	/* 0x4d34 */
        {8,	0}, 	/* 0x4d35 */
        {8,	0}, 	/* 0x4d36 */
        {8,	0}, 	/* 0x4d37 */
        {8,	0}, 	/* 0x4d38 */
        {8,	0}, 	/* 0x4d39 */
        {8,	0}, 	/* 0x4d3a */
        {8,	0}, 	/* 0x4d3b */
        {8,	0}, 	/* 0x4d3c */
        {8,	0}, 	/* 0x4d3d */
        {8,	0}, 	/* 0x4d3e */
        {8,	0}, 	/* 0x4d3f */
        {8,	0}, 	/* 0x4d40 */
        {8,	0}, 	/* 0x4d41 */
        {8,	0}, 	/* 0x4d42 */
        {8,	0}, 	/* 0x4d43 */
        {8,	0}, 	/* 0x4d44 */
        {8,	0}, 	/* 0x4d45 */
        {8,	0}, 	/* 0x4d46 */
        {8,	0}, 	/* 0x4d47 */
        {8,	0}, 	/* 0x4d48 */
        {8,	0}, 	/* 0x4d49 */
        {8,	0}, 	/* 0x4d4a */
        {8,	0}, 	/* 0x4d4b */
        {8,	0}, 	/* 0x4d4c */
        {8,	0}, 	/* 0x4d4d */
        {8,	0}, 	/* 0x4d4e */
        {8,	0}, 	/* 0x4d4f */
        {8,	0}, 	/* 0x4d50 */
        {8,	0}, 	/* 0x4d51 */
        {8,	0}, 	/* 0x4d52 */
        {8,	0}, 	/* 0x4d53 */
        {8,	0}, 	/* 0x4d54 */
        {8,	0}, 	/* 0x4d55 */
        {8,	0}, 	/* 0x4d56 */
        {8,	0}, 	/* 0x4d57 */
        {8,	0}, 	/* 0x4d58 */
        {8,	0}, 	/* 0x4d59 */
        {8,	0}, 	/* 0x4d5a */
        {8,	0}, 	/* 0x4d5b */
        {8,	0}, 	/* 0x4d5c */
        {8,	0}, 	/* 0x4d5d */
        {8,	0}, 	/* 0x4d5e */
        {8,	0}, 	/* 0x4d5f */
        {8,	0}, 	/* 0x4d60 */
        {8,	0}, 	/* 0x4d61 */
        {8,	0}, 	/* 0x4d62 */
        {8,	0}, 	/* 0x4d63 */
        {8,	0}, 	/* 0x4d64 */
        {8,	0}, 	/* 0x4d65 */
        {8,	0}, 	/* 0x4d66 */
        {8,	0}, 	/* 0x4d67 */
        {8,	0}, 	/* 0x4d68 */
        {8,	0}, 	/* 0x4d69 */
        {8,	0}, 	/* 0x4d6a */
        {8,	0}, 	/* 0x4d6b */
        {8,	0}, 	/* 0x4d6c */
        {8,	0}, 	/* 0x4d6d */
        {8,	0}, 	/* 0x4d6e */
        {8,	0}, 	/* 0x4d6f */
        {8,	0}, 	/* 0x4d70 */
        {8,	0}, 	/* 0x4d71 */
        {8,	0}, 	/* 0x4d72 */
        {8,	0}, 	/* 0x4d73 */
        {8,	0}, 	/* 0x4d74 */
        {8,	0}, 	/* 0x4d75 */
        {8,	0}, 	/* 0x4d76 */
        {8,	0}, 	/* 0x4d77 */
        {8,	0}, 	/* 0x4d78 */
        {8,	0}, 	/* 0x4d79 */
        {8,	0}, 	/* 0x4d7a */
        {8,	0}, 	/* 0x4d7b */
        {8,	0}, 	/* 0x4d7c */
        {8,	0}, 	/* 0x4d7d */
        {8,	0}, 	/* 0x4d7e */
        {8,	0}, 	/* 0x4d7f */
        {8,	0}, 	/* 0x4d80 */
        {8,	0}, 	/* 0x4d81 */
        {8,	0}, 	/* 0x4d82 */
        {8,	0}, 	/* 0x4d83 */
        {8,	0}, 	/* 0x4d84 */
        {8,	0}, 	/* 0x4d85 */
        {8,	0}, 	/* 0x4d86 */
        {8,	0}, 	/* 0x4d87 */
        {8,	0}, 	/* 0x4d88 */
        {8,	0}, 	/* 0x4d89 */
        {8,	0}, 	/* 0x4d8a */
        {8,	0}, 	/* 0x4d8b */
        {8,	0}, 	/* 0x4d8c */
        {8,	0}, 	/* 0x4d8d */
        {8,	0}, 	/* 0x4d8e */
        {8,	0}, 	/* 0x4d8f */
        {8,	0}, 	/* 0x4d90 */
        {8,	0}, 	/* 0x4d91 */
        {8,	0}, 	/* 0x4d92 */
        {8,	0}, 	/* 0x4d93 */
        {8,	0}, 	/* 0x4d94 */
        {8,	0}, 	/* 0x4d95 */
        {8,	0}, 	/* 0x4d96 */
        {8,	0}, 	/* 0x4d97 */
        {8,	0}, 	/* 0x4d98 */
        {8,	0}, 	/* 0x4d99 */
        {8,	0}, 	/* 0x4d9a */
        {8,	0}, 	/* 0x4d9b */
        {8,	0}, 	/* 0x4d9c */
        {8,	0}, 	/* 0x4d9d */
        {8,	0}, 	/* 0x4d9e */
        {8,	0}, 	/* 0x4d9f */
        {8,	0}, 	/* 0x4da0 */
        {8,	0}, 	/* 0x4da1 */
        {8,	0}, 	/* 0x4da2 */
        {8,	0}, 	/* 0x4da3 */
        {8,	0}, 	/* 0x4da4 */
        {8,	0}, 	/* 0x4da5 */
        {8,	0}, 	/* 0x4da6 */
        {8,	0}, 	/* 0x4da7 */
        {8,	0}, 	/* 0x4da8 */
        {8,	0}, 	/* 0x4da9 */
        {8,	0}, 	/* 0x4daa */
        {8,	0}, 	/* 0x4dab */
        {8,	0}, 	/* 0x4dac */
        {8,	0}, 	/* 0x4dad */
        {8,	0}, 	/* 0x4dae */
        {8,	0}, 	/* 0x4daf */
        {8,	0}, 	/* 0x4db0 */
        {8,	0}, 	/* 0x4db1 */
        {8,	0}, 	/* 0x4db2 */
        {8,	0}, 	/* 0x4db3 */
        {8,	0}, 	/* 0x4db4 */
        {8,	0}, 	/* 0x4db5 */
        {8,	0}, 	/* 0x4db6 */
        {8,	0}, 	/* 0x4db7 */
        {8,	0}, 	/* 0x4db8 */
        {8,	0}, 	/* 0x4db9 */
        {8,	0}, 	/* 0x4dba */
        {8,	0}, 	/* 0x4dbb */
        {8,	0}, 	/* 0x4dbc */
        {8,	0}, 	/* 0x4dbd */
        {8,	0}, 	/* 0x4dbe */
        {8,	0}, 	/* 0x4dbf */
        {8,	0}, 	/* 0x4dc0 */
        {8,	0}, 	/* 0x4dc1 */
        {8,	0}, 	/* 0x4dc2 */
        {8,	0}, 	/* 0x4dc3 */
        {8,	0}, 	/* 0x4dc4 */
        {8,	0}, 	/* 0x4dc5 */
        {8,	0}, 	/* 0x4dc6 */
        {8,	0}, 	/* 0x4dc7 */
        {8,	0}, 	/* 0x4dc8 */
        {8,	0}, 	/* 0x4dc9 */
        {8,	0}, 	/* 0x4dca */
        {8,	0}, 	/* 0x4dcb */
        {8,	0}, 	/* 0x4dcc */
        {8,	0}, 	/* 0x4dcd */
        {8,	0}, 	/* 0x4dce */
        {8,	0}, 	/* 0x4dcf */
        {8,	0}, 	/* 0x4dd0 */
        {8,	0}, 	/* 0x4dd1 */
        {8,	0}, 	/* 0x4dd2 */
        {8,	0}, 	/* 0x4dd3 */
        {8,	0}, 	/* 0x4dd4 */
        {8,	0}, 	/* 0x4dd5 */
        {8,	0}, 	/* 0x4dd6 */
        {8,	0}, 	/* 0x4dd7 */
        {8,	0}, 	/* 0x4dd8 */
        {8,	0}, 	/* 0x4dd9 */
        {8,	0}, 	/* 0x4dda */
        {8,	0}, 	/* 0x4ddb */
        {8,	0}, 	/* 0x4ddc */
        {8,	0}, 	/* 0x4ddd */
        {8,	0}, 	/* 0x4dde */
        {8,	0}, 	/* 0x4ddf */
        {8,	0}, 	/* 0x4de0 */
        {8,	0}, 	/* 0x4de1 */
        {8,	0}, 	/* 0x4de2 */
        {8,	0}, 	/* 0x4de3 */
        {8,	0}, 	/* 0x4de4 */
        {8,	0}, 	/* 0x4de5 */
        {8,	0}, 	/* 0x4de6 */
        {8,	0}, 	/* 0x4de7 */
        {8,	0}, 	/* 0x4de8 */
        {8,	0}, 	/* 0x4de9 */
        {8,	0}, 	/* 0x4dea */
        {8,	0}, 	/* 0x4deb */
        {8,	0}, 	/* 0x4dec */
        {8,	0}, 	/* 0x4ded */
        {8,	0}, 	/* 0x4dee */
        {8,	0}, 	/* 0x4def */
        {8,	0}, 	/* 0x4df0 */
        {8,	0}, 	/* 0x4df1 */
        {8,	0}, 	/* 0x4df2 */
        {8,	0}, 	/* 0x4df3 */
        {8,	0}, 	/* 0x4df4 */
        {8,	0}, 	/* 0x4df5 */
        {8,	0}, 	/* 0x4df6 */
        {8,	0}, 	/* 0x4df7 */
        {8,	0}, 	/* 0x4df8 */
        {8,	0}, 	/* 0x4df9 */
        {8,	0}, 	/* 0x4dfa */
        {8,	0}, 	/* 0x4dfb */
        {8,	0}, 	/* 0x4dfc */
        {8,	0}, 	/* 0x4dfd */
        {8,	0}, 	/* 0x4dfe */
        {8,	0}, 	/* 0x4dff */
        {8,	0}, 	/* 0x4e00 */
        {8,	0}, 	/* 0x4e01 */
        {8,	0}, 	/* 0x4e02 */
        {8,	0}, 	/* 0x4e03 */
        {8,	0}, 	/* 0x4e04 */
        {8,	0}, 	/* 0x4e05 */
        {8,	0}, 	/* 0x4e06 */
        {8,	0}, 	/* 0x4e07 */
        {8,	0}, 	/* 0x4e08 */
        {8,	0}, 	/* 0x4e09 */
        {8,	0}, 	/* 0x4e0a */
        {8,	0}, 	/* 0x4e0b */
        {8,	0}, 	/* 0x4e0c */
        {8,	0}, 	/* 0x4e0d */
        {8,	0}, 	/* 0x4e0e */
        {8,	0}, 	/* 0x4e0f */
        {8,	0}, 	/* 0x4e10 */
        {8,	0}, 	/* 0x4e11 */
        {8,	0}, 	/* 0x4e12 */
        {8,	0}, 	/* 0x4e13 */
        {8,	0}, 	/* 0x4e14 */
        {8,	0}, 	/* 0x4e15 */
        {8,	0}, 	/* 0x4e16 */
        {8,	0}, 	/* 0x4e17 */
        {8,	0}, 	/* 0x4e18 */
        {8,	0}, 	/* 0x4e19 */
        {8,	0}, 	/* 0x4e1a */
        {8,	0}, 	/* 0x4e1b */
        {8,	0}, 	/* 0x4e1c */
        {8,	0}, 	/* 0x4e1d */
        {8,	0}, 	/* 0x4e1e */
        {8,	0}, 	/* 0x4e1f */
        {8,	0}, 	/* 0x4e20 */
        {8,	0}, 	/* 0x4e21 */
        {8,	0}, 	/* 0x4e22 */
        {8,	0}, 	/* 0x4e23 */
        {8,	0}, 	/* 0x4e24 */
        {8,	0}, 	/* 0x4e25 */
        {8,	0}, 	/* 0x4e26 */
        {8,	0}, 	/* 0x4e27 */
        {8,	0}, 	/* 0x4e28 */
        {8,	0}, 	/* 0x4e29 */
        {8,	0}, 	/* 0x4e2a */
        {8,	0}, 	/* 0x4e2b */
        {8,	0}, 	/* 0x4e2c */
        {8,	0}, 	/* 0x4e2d */
        {8,	0}, 	/* 0x4e2e */
        {8,	0}, 	/* 0x4e2f */
        {8,	0}, 	/* 0x4e30 */
        {8,	0}, 	/* 0x4e31 */
        {8,	0}, 	/* 0x4e32 */
        {8,	0}, 	/* 0x4e33 */
        {8,	0}, 	/* 0x4e34 */
        {8,	0}, 	/* 0x4e35 */
        {8,	0}, 	/* 0x4e36 */
        {8,	0}, 	/* 0x4e37 */
        {8,	0}, 	/* 0x4e38 */
        {8,	0}, 	/* 0x4e39 */
        {8,	0}, 	/* 0x4e3a */
        {8,	0}, 	/* 0x4e3b */
        {8,	0}, 	/* 0x4e3c */
        {8,	0}, 	/* 0x4e3d */
        {8,	0}, 	/* 0x4e3e */
        {8,	0}, 	/* 0x4e3f */
        {8,	0}, 	/* 0x4e40 */
        {8,	0}, 	/* 0x4e41 */
        {8,	0}, 	/* 0x4e42 */
        {8,	0}, 	/* 0x4e43 */
        {8,	0}, 	/* 0x4e44 */
        {8,	0}, 	/* 0x4e45 */
        {8,	0}, 	/* 0x4e46 */
        {8,	0}, 	/* 0x4e47 */
        {8,	0}, 	/* 0x4e48 */
        {8,	0}, 	/* 0x4e49 */
        {8,	0}, 	/* 0x4e4a */
        {8,	0}, 	/* 0x4e4b */
        {8,	0}, 	/* 0x4e4c */
        {8,	0}, 	/* 0x4e4d */
        {8,	0}, 	/* 0x4e4e */
        {8,	0}, 	/* 0x4e4f */
        {8,	0}, 	/* 0x4e50 */
        {8,	0}, 	/* 0x4e51 */
        {8,	0}, 	/* 0x4e52 */
        {8,	0}, 	/* 0x4e53 */
        {8,	0}, 	/* 0x4e54 */
        {8,	0}, 	/* 0x4e55 */
        {8,	0}, 	/* 0x4e56 */
        {8,	0}, 	/* 0x4e57 */
        {8,	0}, 	/* 0x4e58 */
        {8,	0}, 	/* 0x4e59 */
        {8,	0}, 	/* 0x4e5a */
        {8,	0}, 	/* 0x4e5b */
        {8,	0}, 	/* 0x4e5c */
        {8,	0}, 	/* 0x4e5d */
        {8,	0}, 	/* 0x4e5e */
        {8,	0}, 	/* 0x4e5f */
        {8,	0}, 	/* 0x4e60 */
        {8,	0}, 	/* 0x4e61 */
        {8,	0}, 	/* 0x4e62 */
        {8,	0}, 	/* 0x4e63 */
        {8,	0}, 	/* 0x4e64 */
        {8,	0}, 	/* 0x4e65 */
        {8,	0}, 	/* 0x4e66 */
        {8,	0}, 	/* 0x4e67 */
        {8,	0}, 	/* 0x4e68 */
        {8,	0}, 	/* 0x4e69 */
        {8,	0}, 	/* 0x4e6a */
        {8,	0}, 	/* 0x4e6b */
        {8,	0}, 	/* 0x4e6c */
        {8,	0}, 	/* 0x4e6d */
        {8,	0}, 	/* 0x4e6e */
        {8,	0}, 	/* 0x4e6f */
        {8,	0}, 	/* 0x4e70 */
        {8,	0}, 	/* 0x4e71 */
        {8,	0}, 	/* 0x4e72 */
        {8,	0}, 	/* 0x4e73 */
        {8,	0}, 	/* 0x4e74 */
        {8,	0}, 	/* 0x4e75 */
        {8,	0}, 	/* 0x4e76 */
        {8,	0}, 	/* 0x4e77 */
        {8,	0}, 	/* 0x4e78 */
        {8,	0}, 	/* 0x4e79 */
        {8,	0}, 	/* 0x4e7a */
        {8,	0}, 	/* 0x4e7b */
        {8,	0}, 	/* 0x4e7c */
        {8,	0}, 	/* 0x4e7d */
        {8,	0}, 	/* 0x4e7e */
        {8,	0}, 	/* 0x4e7f */
        {8,	0}, 	/* 0x4e80 */
        {8,	0}, 	/* 0x4e81 */
        {8,	0}, 	/* 0x4e82 */
        {8,	0}, 	/* 0x4e83 */
        {8,	0}, 	/* 0x4e84 */
        {8,	0}, 	/* 0x4e85 */
        {8,	0}, 	/* 0x4e86 */
        {8,	0}, 	/* 0x4e87 */
        {8,	0}, 	/* 0x4e88 */
        {8,	0}, 	/* 0x4e89 */
        {8,	0}, 	/* 0x4e8a */
        {8,	0}, 	/* 0x4e8b */
        {8,	0}, 	/* 0x4e8c */
        {8,	0}, 	/* 0x4e8d */
        {8,	0}, 	/* 0x4e8e */
        {8,	0}, 	/* 0x4e8f */
        {8,	0}, 	/* 0x4e90 */
        {8,	0}, 	/* 0x4e91 */
        {8,	0}, 	/* 0x4e92 */
        {8,	0}, 	/* 0x4e93 */
        {8,	0}, 	/* 0x4e94 */
        {8,	0}, 	/* 0x4e95 */
        {8,	0}, 	/* 0x4e96 */
        {8,	0}, 	/* 0x4e97 */
        {8,	0}, 	/* 0x4e98 */
        {8,	0}, 	/* 0x4e99 */
        {8,	0}, 	/* 0x4e9a */
        {8,	0}, 	/* 0x4e9b */
        {8,	0}, 	/* 0x4e9c */
        {8,	0}, 	/* 0x4e9d */
        {8,	0}, 	/* 0x4e9e */
        {8,	0}, 	/* 0x4e9f */
        {8,	0}, 	/* 0x4ea0 */
        {8,	0}, 	/* 0x4ea1 */
        {8,	0}, 	/* 0x4ea2 */
        {8,	0}, 	/* 0x4ea3 */
        {8,	0}, 	/* 0x4ea4 */
        {8,	0}, 	/* 0x4ea5 */
        {8,	0}, 	/* 0x4ea6 */
        {8,	0}, 	/* 0x4ea7 */
        {8,	0}, 	/* 0x4ea8 */
        {8,	0}, 	/* 0x4ea9 */
        {8,	0}, 	/* 0x4eaa */
        {8,	0}, 	/* 0x4eab */
        {8,	0}, 	/* 0x4eac */
        {8,	0}, 	/* 0x4ead */
        {8,	0}, 	/* 0x4eae */
        {8,	0}, 	/* 0x4eaf */
        {8,	0}, 	/* 0x4eb0 */
        {8,	0}, 	/* 0x4eb1 */
        {8,	0}, 	/* 0x4eb2 */
        {8,	0}, 	/* 0x4eb3 */
        {8,	0}, 	/* 0x4eb4 */
        {8,	0}, 	/* 0x4eb5 */
        {8,	0}, 	/* 0x4eb6 */
        {8,	0}, 	/* 0x4eb7 */
        {8,	0}, 	/* 0x4eb8 */
        {8,	0}, 	/* 0x4eb9 */
        {8,	0}, 	/* 0x4eba */
        {8,	0}, 	/* 0x4ebb */
        {8,	0}, 	/* 0x4ebc */
        {8,	0}, 	/* 0x4ebd */
        {8,	0}, 	/* 0x4ebe */
        {8,	0}, 	/* 0x4ebf */
        {8,	0}, 	/* 0x4ec0 */
        {8,	0}, 	/* 0x4ec1 */
        {8,	0}, 	/* 0x4ec2 */
        {8,	0}, 	/* 0x4ec3 */
        {8,	0}, 	/* 0x4ec4 */
        {8,	0}, 	/* 0x4ec5 */
        {8,	0}, 	/* 0x4ec6 */
        {8,	0}, 	/* 0x4ec7 */
        {8,	0}, 	/* 0x4ec8 */
        {8,	0}, 	/* 0x4ec9 */
        {8,	0}, 	/* 0x4eca */
        {8,	0}, 	/* 0x4ecb */
        {8,	0}, 	/* 0x4ecc */
        {8,	0}, 	/* 0x4ecd */
        {8,	0}, 	/* 0x4ece */
        {8,	0}, 	/* 0x4ecf */
        {8,	0}, 	/* 0x4ed0 */
        {8,	0}, 	/* 0x4ed1 */
        {8,	0}, 	/* 0x4ed2 */
        {8,	0}, 	/* 0x4ed3 */
        {8,	0}, 	/* 0x4ed4 */
        {8,	0}, 	/* 0x4ed5 */
        {8,	0}, 	/* 0x4ed6 */
        {8,	0}, 	/* 0x4ed7 */
        {8,	0}, 	/* 0x4ed8 */
        {8,	0}, 	/* 0x4ed9 */
        {8,	0}, 	/* 0x4eda */
        {8,	0}, 	/* 0x4edb */
        {8,	0}, 	/* 0x4edc */
        {8,	0}, 	/* 0x4edd */
        {8,	0}, 	/* 0x4ede */
        {8,	0}, 	/* 0x4edf */
        {8,	0}, 	/* 0x4ee0 */
        {8,	0}, 	/* 0x4ee1 */
        {8,	0}, 	/* 0x4ee2 */
        {8,	0}, 	/* 0x4ee3 */
        {8,	0}, 	/* 0x4ee4 */
        {8,	0}, 	/* 0x4ee5 */
        {8,	0}, 	/* 0x4ee6 */
        {8,	0}, 	/* 0x4ee7 */
        {8,	0}, 	/* 0x4ee8 */
        {8,	0}, 	/* 0x4ee9 */
        {8,	0}, 	/* 0x4eea */
        {8,	0}, 	/* 0x4eeb */
        {8,	0}, 	/* 0x4eec */
        {8,	0}, 	/* 0x4eed */
        {8,	0}, 	/* 0x4eee */
        {8,	0}, 	/* 0x4eef */
        {8,	0}, 	/* 0x4ef0 */
        {8,	0}, 	/* 0x4ef1 */
        {8,	0}, 	/* 0x4ef2 */
        {8,	0}, 	/* 0x4ef3 */
        {8,	0}, 	/* 0x4ef4 */
        {8,	0}, 	/* 0x4ef5 */
        {8,	0}, 	/* 0x4ef6 */
        {8,	0}, 	/* 0x4ef7 */
        {8,	0}, 	/* 0x4ef8 */
        {8,	0}, 	/* 0x4ef9 */
        {8,	0}, 	/* 0x4efa */
        {8,	0}, 	/* 0x4efb */
        {8,	0}, 	/* 0x4efc */
        {8,	0}, 	/* 0x4efd */
        {8,	0}, 	/* 0x4efe */
        {8,	0}, 	/* 0x4eff */
        {8,	0}, 	/* 0x4f00 */
        {8,	0}, 	/* 0x4f01 */
        {8,	0}, 	/* 0x4f02 */
        {8,	0}, 	/* 0x4f03 */
        {8,	0}, 	/* 0x4f04 */
        {8,	0}, 	/* 0x4f05 */
        {8,	0}, 	/* 0x4f06 */
        {8,	0}, 	/* 0x4f07 */
        {8,	0}, 	/* 0x4f08 */
        {8,	0}, 	/* 0x4f09 */
        {8,	0}, 	/* 0x4f0a */
        {8,	0}, 	/* 0x4f0b */
        {8,	0}, 	/* 0x4f0c */
        {8,	0}, 	/* 0x4f0d */
        {8,	0}, 	/* 0x4f0e */
        {8,	0}, 	/* 0x4f0f */
        {8,	0}, 	/* 0x4f10 */
        {8,	0}, 	/* 0x4f11 */
        {8,	0}, 	/* 0x4f12 */
        {8,	0}, 	/* 0x4f13 */
        {8,	0}, 	/* 0x4f14 */
        {8,	0}, 	/* 0x4f15 */
        {8,	0}, 	/* 0x4f16 */
        {8,	0}, 	/* 0x4f17 */
        {8,	0}, 	/* 0x4f18 */
        {8,	0}, 	/* 0x4f19 */
        {8,	0}, 	/* 0x4f1a */
        {8,	0}, 	/* 0x4f1b */
        {8,	0}, 	/* 0x4f1c */
        {8,	0}, 	/* 0x4f1d */
        {8,	0}, 	/* 0x4f1e */
        {8,	0}, 	/* 0x4f1f */
        {8,	0}, 	/* 0x4f20 */
        {8,	0}, 	/* 0x4f21 */
        {8,	0}, 	/* 0x4f22 */
        {8,	0}, 	/* 0x4f23 */
        {8,	0}, 	/* 0x4f24 */
        {8,	0}, 	/* 0x4f25 */
        {8,	0}, 	/* 0x4f26 */
        {8,	0}, 	/* 0x4f27 */
        {8,	0}, 	/* 0x4f28 */
        {8,	0}, 	/* 0x4f29 */
        {8,	0}, 	/* 0x4f2a */
        {8,	0}, 	/* 0x4f2b */
        {8,	0}, 	/* 0x4f2c */
        {8,	0}, 	/* 0x4f2d */
        {8,	0}, 	/* 0x4f2e */
        {8,	0}, 	/* 0x4f2f */
        {8,	0}, 	/* 0x4f30 */
        {8,	0}, 	/* 0x4f31 */
        {8,	0}, 	/* 0x4f32 */
        {8,	0}, 	/* 0x4f33 */
        {8,	0}, 	/* 0x4f34 */
        {8,	0}, 	/* 0x4f35 */
        {8,	0}, 	/* 0x4f36 */
        {8,	0}, 	/* 0x4f37 */
        {8,	0}, 	/* 0x4f38 */
        {8,	0}, 	/* 0x4f39 */
        {8,	0}, 	/* 0x4f3a */
        {8,	0}, 	/* 0x4f3b */
        {8,	0}, 	/* 0x4f3c */
        {8,	0}, 	/* 0x4f3d */
        {8,	0}, 	/* 0x4f3e */
        {8,	0}, 	/* 0x4f3f */
        {8,	0}, 	/* 0x4f40 */
        {8,	0}, 	/* 0x4f41 */
        {8,	0}, 	/* 0x4f42 */
        {8,	0}, 	/* 0x4f43 */
        {8,	0}, 	/* 0x4f44 */
        {8,	0}, 	/* 0x4f45 */
        {8,	0}, 	/* 0x4f46 */
        {8,	0}, 	/* 0x4f47 */
        {8,	0}, 	/* 0x4f48 */
        {8,	0}, 	/* 0x4f49 */
        {8,	0}, 	/* 0x4f4a */
        {8,	0}, 	/* 0x4f4b */
        {8,	0}, 	/* 0x4f4c */
        {8,	0}, 	/* 0x4f4d */
        {8,	0}, 	/* 0x4f4e */
        {8,	0}, 	/* 0x4f4f */
        {8,	0}, 	/* 0x4f50 */
        {8,	0}, 	/* 0x4f51 */
        {8,	0}, 	/* 0x4f52 */
        {8,	0}, 	/* 0x4f53 */
        {8,	0}, 	/* 0x4f54 */
        {8,	0}, 	/* 0x4f55 */
        {8,	0}, 	/* 0x4f56 */
        {8,	0}, 	/* 0x4f57 */
        {8,	0}, 	/* 0x4f58 */
        {8,	0}, 	/* 0x4f59 */
        {8,	0}, 	/* 0x4f5a */
        {8,	0}, 	/* 0x4f5b */
        {8,	0}, 	/* 0x4f5c */
        {8,	0}, 	/* 0x4f5d */
        {8,	0}, 	/* 0x4f5e */
        {8,	0}, 	/* 0x4f5f */
        {8,	0}, 	/* 0x4f60 */
        {8,	0}, 	/* 0x4f61 */
        {8,	0}, 	/* 0x4f62 */
        {8,	0}, 	/* 0x4f63 */
        {8,	0}, 	/* 0x4f64 */
        {8,	0}, 	/* 0x4f65 */
        {8,	0}, 	/* 0x4f66 */
        {8,	0}, 	/* 0x4f67 */
        {8,	0}, 	/* 0x4f68 */
        {8,	0}, 	/* 0x4f69 */
        {8,	0}, 	/* 0x4f6a */
        {8,	0}, 	/* 0x4f6b */
        {8,	0}, 	/* 0x4f6c */
        {8,	0}, 	/* 0x4f6d */
        {8,	0}, 	/* 0x4f6e */
        {8,	0}, 	/* 0x4f6f */
        {8,	0}, 	/* 0x4f70 */
        {8,	0}, 	/* 0x4f71 */
        {8,	0}, 	/* 0x4f72 */
        {8,	0}, 	/* 0x4f73 */
        {8,	0}, 	/* 0x4f74 */
        {8,	0}, 	/* 0x4f75 */
        {8,	0}, 	/* 0x4f76 */
        {8,	0}, 	/* 0x4f77 */
        {8,	0}, 	/* 0x4f78 */
        {8,	0}, 	/* 0x4f79 */
        {8,	0}, 	/* 0x4f7a */
        {8,	0}, 	/* 0x4f7b */
        {8,	0}, 	/* 0x4f7c */
        {8,	0}, 	/* 0x4f7d */
        {8,	0}, 	/* 0x4f7e */
        {8,	0}, 	/* 0x4f7f */
        {8,	0}, 	/* 0x4f80 */
        {8,	0}, 	/* 0x4f81 */
        {8,	0}, 	/* 0x4f82 */
        {8,	0}, 	/* 0x4f83 */
        {8,	0}, 	/* 0x4f84 */
        {8,	0}, 	/* 0x4f85 */
        {8,	0}, 	/* 0x4f86 */
        {8,	0}, 	/* 0x4f87 */
        {8,	0}, 	/* 0x4f88 */
        {8,	0}, 	/* 0x4f89 */
        {8,	0}, 	/* 0x4f8a */
        {8,	0}, 	/* 0x4f8b */
        {8,	0}, 	/* 0x4f8c */
        {8,	0}, 	/* 0x4f8d */
        {8,	0}, 	/* 0x4f8e */
        {8,	0}, 	/* 0x4f8f */
        {8,	0}, 	/* 0x4f90 */
        {8,	0}, 	/* 0x4f91 */
        {8,	0}, 	/* 0x4f92 */
        {8,	0}, 	/* 0x4f93 */
        {8,	0}, 	/* 0x4f94 */
        {8,	0}, 	/* 0x4f95 */
        {8,	0}, 	/* 0x4f96 */
        {8,	0}, 	/* 0x4f97 */
        {8,	0}, 	/* 0x4f98 */
        {8,	0}, 	/* 0x4f99 */
        {8,	0}, 	/* 0x4f9a */
        {8,	0}, 	/* 0x4f9b */
        {8,	0}, 	/* 0x4f9c */
        {8,	0}, 	/* 0x4f9d */
        {8,	0}, 	/* 0x4f9e */
        {8,	0}, 	/* 0x4f9f */
        {8,	0}, 	/* 0x4fa0 */
        {8,	0}, 	/* 0x4fa1 */
        {8,	0}, 	/* 0x4fa2 */
        {8,	0}, 	/* 0x4fa3 */
        {8,	0}, 	/* 0x4fa4 */
        {8,	0}, 	/* 0x4fa5 */
        {8,	0}, 	/* 0x4fa6 */
        {8,	0}, 	/* 0x4fa7 */
        {8,	0}, 	/* 0x4fa8 */
        {8,	0}, 	/* 0x4fa9 */
        {8,	0}, 	/* 0x4faa */
        {8,	0}, 	/* 0x4fab */
        {8,	0}, 	/* 0x4fac */
        {8,	0}, 	/* 0x4fad */
        {8,	0}, 	/* 0x4fae */
        {8,	0}, 	/* 0x4faf */
        {8,	0}, 	/* 0x4fb0 */
        {8,	0}, 	/* 0x4fb1 */
        {8,	0}, 	/* 0x4fb2 */
        {8,	0}, 	/* 0x4fb3 */
        {8,	0}, 	/* 0x4fb4 */
        {8,	0}, 	/* 0x4fb5 */
        {8,	0}, 	/* 0x4fb6 */
        {8,	0}, 	/* 0x4fb7 */
        {8,	0}, 	/* 0x4fb8 */
        {8,	0}, 	/* 0x4fb9 */
        {8,	0}, 	/* 0x4fba */
        {8,	0}, 	/* 0x4fbb */
        {8,	0}, 	/* 0x4fbc */
        {8,	0}, 	/* 0x4fbd */
        {8,	0}, 	/* 0x4fbe */
        {8,	0}, 	/* 0x4fbf */
        {8,	0}, 	/* 0x4fc0 */
        {8,	0}, 	/* 0x4fc1 */
        {8,	0}, 	/* 0x4fc2 */
        {8,	0}, 	/* 0x4fc3 */
        {8,	0}, 	/* 0x4fc4 */
        {8,	0}, 	/* 0x4fc5 */
        {8,	0}, 	/* 0x4fc6 */
        {8,	0}, 	/* 0x4fc7 */
        {8,	0}, 	/* 0x4fc8 */
        {8,	0}, 	/* 0x4fc9 */
        {8,	0}, 	/* 0x4fca */
        {8,	0}, 	/* 0x4fcb */
        {8,	0}, 	/* 0x4fcc */
        {8,	0}, 	/* 0x4fcd */
        {8,	0}, 	/* 0x4fce */
        {8,	0}, 	/* 0x4fcf */
        {8,	0}, 	/* 0x4fd0 */
        {8,	0}, 	/* 0x4fd1 */
        {8,	0}, 	/* 0x4fd2 */
        {8,	0}, 	/* 0x4fd3 */
        {8,	0}, 	/* 0x4fd4 */
        {8,	0}, 	/* 0x4fd5 */
        {8,	0}, 	/* 0x4fd6 */
        {8,	0}, 	/* 0x4fd7 */
        {8,	0}, 	/* 0x4fd8 */
        {8,	0}, 	/* 0x4fd9 */
        {8,	0}, 	/* 0x4fda */
        {8,	0}, 	/* 0x4fdb */
        {8,	0}, 	/* 0x4fdc */
        {8,	0}, 	/* 0x4fdd */
        {8,	0}, 	/* 0x4fde */
        {8,	0}, 	/* 0x4fdf */
        {8,	0}, 	/* 0x4fe0 */
        {8,	0}, 	/* 0x4fe1 */
        {8,	0}, 	/* 0x4fe2 */
        {8,	0}, 	/* 0x4fe3 */
        {8,	0}, 	/* 0x4fe4 */
        {8,	0}, 	/* 0x4fe5 */
        {8,	0}, 	/* 0x4fe6 */
        {8,	0}, 	/* 0x4fe7 */
        {8,	0}, 	/* 0x4fe8 */
        {8,	0}, 	/* 0x4fe9 */
        {8,	0}, 	/* 0x4fea */
        {8,	0}, 	/* 0x4feb */
        {8,	0}, 	/* 0x4fec */
        {8,	0}, 	/* 0x4fed */
        {8,	0}, 	/* 0x4fee */
        {8,	0}, 	/* 0x4fef */
        {8,	0}, 	/* 0x4ff0 */
        {8,	0}, 	/* 0x4ff1 */
        {8,	0}, 	/* 0x4ff2 */
        {8,	0}, 	/* 0x4ff3 */
        {8,	0}, 	/* 0x4ff4 */
        {8,	0}, 	/* 0x4ff5 */
        {8,	0}, 	/* 0x4ff6 */
        {8,	0}, 	/* 0x4ff7 */
        {8,	0}, 	/* 0x4ff8 */
        {8,	0}, 	/* 0x4ff9 */
        {8,	0}, 	/* 0x4ffa */
        {8,	0}, 	/* 0x4ffb */
        {8,	0}, 	/* 0x4ffc */
        {8,	0}, 	/* 0x4ffd */
        {8,	0}, 	/* 0x4ffe */
        {8,	0}, 	/* 0x4fff */
        {8,	0}, 	/* 0x5000 */
        {8,	0}, 	/* 0x5001 */
        {8,	0}, 	/* 0x5002 */
        {8,	0}, 	/* 0x5003 */
        {8,	0}, 	/* 0x5004 */
        {8,	0}, 	/* 0x5005 */
        {8,	0}, 	/* 0x5006 */
        {8,	0}, 	/* 0x5007 */
        {8,	0}, 	/* 0x5008 */
        {8,	0}, 	/* 0x5009 */
        {8,	0}, 	/* 0x500a */
        {8,	0}, 	/* 0x500b */
        {8,	0}, 	/* 0x500c */
        {8,	0}, 	/* 0x500d */
        {8,	0}, 	/* 0x500e */
        {8,	0}, 	/* 0x500f */
        {8,	0}, 	/* 0x5010 */
        {8,	0}, 	/* 0x5011 */
        {8,	0}, 	/* 0x5012 */
        {8,	0}, 	/* 0x5013 */
        {8,	0}, 	/* 0x5014 */
        {8,	0}, 	/* 0x5015 */
        {8,	0}, 	/* 0x5016 */
        {8,	0}, 	/* 0x5017 */
        {8,	0}, 	/* 0x5018 */
        {8,	0}, 	/* 0x5019 */
        {8,	0}, 	/* 0x501a */
        {8,	0}, 	/* 0x501b */
        {8,	0}, 	/* 0x501c */
        {8,	0}, 	/* 0x501d */
        {8,	0}, 	/* 0x501e */
        {8,	0}, 	/* 0x501f */
        {8,	0}, 	/* 0x5020 */
        {8,	0}, 	/* 0x5021 */
        {8,	0}, 	/* 0x5022 */
        {8,	0}, 	/* 0x5023 */
        {8,	0}, 	/* 0x5024 */
        {8,	0}, 	/* 0x5025 */
        {8,	0}, 	/* 0x5026 */
        {8,	0}, 	/* 0x5027 */
        {8,	0}, 	/* 0x5028 */
        {8,	0}, 	/* 0x5029 */
        {8,	0}, 	/* 0x502a */
        {8,	0}, 	/* 0x502b */
        {8,	0}, 	/* 0x502c */
        {8,	0}, 	/* 0x502d */
        {8,	0}, 	/* 0x502e */
        {8,	0}, 	/* 0x502f */
        {8,	0}, 	/* 0x5030 */
        {8,	0}, 	/* 0x5031 */
        {8,	0}, 	/* 0x5032 */
        {8,	0}, 	/* 0x5033 */
        {8,	0}, 	/* 0x5034 */
        {8,	0}, 	/* 0x5035 */
        {8,	0}, 	/* 0x5036 */
        {8,	0}, 	/* 0x5037 */
        {8,	0}, 	/* 0x5038 */
        {8,	0}, 	/* 0x5039 */
        {8,	0}, 	/* 0x503a */
        {8,	0}, 	/* 0x503b */
        {8,	0}, 	/* 0x503c */
        {8,	0}, 	/* 0x503d */
        {8,	0}, 	/* 0x503e */
        {8,	0}, 	/* 0x503f */
        {8,	0}, 	/* 0x5040 */
        {8,	0}, 	/* 0x5041 */
        {8,	0}, 	/* 0x5042 */
        {8,	0}, 	/* 0x5043 */
        {8,	0}, 	/* 0x5044 */
        {8,	0}, 	/* 0x5045 */
        {8,	0}, 	/* 0x5046 */
        {8,	0}, 	/* 0x5047 */
        {8,	0}, 	/* 0x5048 */
        {8,	0}, 	/* 0x5049 */
        {8,	0}, 	/* 0x504a */
        {8,	0}, 	/* 0x504b */
        {8,	0}, 	/* 0x504c */
        {8,	0}, 	/* 0x504d */
        {8,	0}, 	/* 0x504e */
        {8,	0}, 	/* 0x504f */
        {8,	0}, 	/* 0x5050 */
        {8,	0}, 	/* 0x5051 */
        {8,	0}, 	/* 0x5052 */
        {8,	0}, 	/* 0x5053 */
        {8,	0}, 	/* 0x5054 */
        {8,	0}, 	/* 0x5055 */
        {8,	0}, 	/* 0x5056 */
        {8,	0}, 	/* 0x5057 */
        {8,	0}, 	/* 0x5058 */
        {8,	0}, 	/* 0x5059 */
        {8,	0}, 	/* 0x505a */
        {8,	0}, 	/* 0x505b */
        {8,	0}, 	/* 0x505c */
        {8,	0}, 	/* 0x505d */
        {8,	0}, 	/* 0x505e */
        {8,	0}, 	/* 0x505f */
        {8,	0}, 	/* 0x5060 */
        {8,	0}, 	/* 0x5061 */
        {8,	0}, 	/* 0x5062 */
        {8,	0}, 	/* 0x5063 */
        {8,	0}, 	/* 0x5064 */
        {8,	0}, 	/* 0x5065 */
        {8,	0}, 	/* 0x5066 */
        {8,	0}, 	/* 0x5067 */
        {8,	0}, 	/* 0x5068 */
        {8,	0}, 	/* 0x5069 */
        {8,	0}, 	/* 0x506a */
        {8,	0}, 	/* 0x506b */
        {8,	0}, 	/* 0x506c */
        {8,	0}, 	/* 0x506d */
        {8,	0}, 	/* 0x506e */
        {8,	0}, 	/* 0x506f */
        {8,	0}, 	/* 0x5070 */
        {8,	0}, 	/* 0x5071 */
        {8,	0}, 	/* 0x5072 */
        {8,	0}, 	/* 0x5073 */
        {8,	0}, 	/* 0x5074 */
        {8,	0}, 	/* 0x5075 */
        {8,	0}, 	/* 0x5076 */
        {8,	0}, 	/* 0x5077 */
        {8,	0}, 	/* 0x5078 */
        {8,	0}, 	/* 0x5079 */
        {8,	0}, 	/* 0x507a */
        {8,	0}, 	/* 0x507b */
        {8,	0}, 	/* 0x507c */
        {8,	0}, 	/* 0x507d */
        {8,	0}, 	/* 0x507e */
        {8,	0}, 	/* 0x507f */
        {8,	0}, 	/* 0x5080 */
        {8,	0}, 	/* 0x5081 */
        {8,	0}, 	/* 0x5082 */
        {8,	0}, 	/* 0x5083 */
        {8,	0}, 	/* 0x5084 */
        {8,	0}, 	/* 0x5085 */
        {8,	0}, 	/* 0x5086 */
        {8,	0}, 	/* 0x5087 */
        {8,	0}, 	/* 0x5088 */
        {8,	0}, 	/* 0x5089 */
        {8,	0}, 	/* 0x508a */
        {8,	0}, 	/* 0x508b */
        {8,	0}, 	/* 0x508c */
        {8,	0}, 	/* 0x508d */
        {8,	0}, 	/* 0x508e */
        {8,	0}, 	/* 0x508f */
        {8,	0}, 	/* 0x5090 */
        {8,	0}, 	/* 0x5091 */
        {8,	0}, 	/* 0x5092 */
        {8,	0}, 	/* 0x5093 */
        {8,	0}, 	/* 0x5094 */
        {8,	0}, 	/* 0x5095 */
        {8,	0}, 	/* 0x5096 */
        {8,	0}, 	/* 0x5097 */
        {8,	0}, 	/* 0x5098 */
        {8,	0}, 	/* 0x5099 */
        {8,	0}, 	/* 0x509a */
        {8,	0}, 	/* 0x509b */
        {8,	0}, 	/* 0x509c */
        {8,	0}, 	/* 0x509d */
        {8,	0}, 	/* 0x509e */
        {8,	0}, 	/* 0x509f */
        {8,	0}, 	/* 0x50a0 */
        {8,	0}, 	/* 0x50a1 */
        {8,	0}, 	/* 0x50a2 */
        {8,	0}, 	/* 0x50a3 */
        {8,	0}, 	/* 0x50a4 */
        {8,	0}, 	/* 0x50a5 */
        {8,	0}, 	/* 0x50a6 */
        {8,	0}, 	/* 0x50a7 */
        {8,	0}, 	/* 0x50a8 */
        {8,	0}, 	/* 0x50a9 */
        {8,	0}, 	/* 0x50aa */
        {8,	0}, 	/* 0x50ab */
        {8,	0}, 	/* 0x50ac */
        {8,	0}, 	/* 0x50ad */
        {8,	0}, 	/* 0x50ae */
        {8,	0}, 	/* 0x50af */
        {8,	0}, 	/* 0x50b0 */
        {8,	0}, 	/* 0x50b1 */
        {8,	0}, 	/* 0x50b2 */
        {8,	0}, 	/* 0x50b3 */
        {8,	0}, 	/* 0x50b4 */
        {8,	0}, 	/* 0x50b5 */
        {8,	0}, 	/* 0x50b6 */
        {8,	0}, 	/* 0x50b7 */
        {8,	0}, 	/* 0x50b8 */
        {8,	0}, 	/* 0x50b9 */
        {8,	0}, 	/* 0x50ba */
        {8,	0}, 	/* 0x50bb */
        {8,	0}, 	/* 0x50bc */
        {8,	0}, 	/* 0x50bd */
        {8,	0}, 	/* 0x50be */
        {8,	0}, 	/* 0x50bf */
        {8,	0}, 	/* 0x50c0 */
        {8,	0}, 	/* 0x50c1 */
        {8,	0}, 	/* 0x50c2 */
        {8,	0}, 	/* 0x50c3 */
        {8,	0}, 	/* 0x50c4 */
        {8,	0}, 	/* 0x50c5 */
        {8,	0}, 	/* 0x50c6 */
        {8,	0}, 	/* 0x50c7 */
        {8,	0}, 	/* 0x50c8 */
        {8,	0}, 	/* 0x50c9 */
        {8,	0}, 	/* 0x50ca */
        {8,	0}, 	/* 0x50cb */
        {8,	0}, 	/* 0x50cc */
        {8,	0}, 	/* 0x50cd */
        {8,	0}, 	/* 0x50ce */
        {8,	0}, 	/* 0x50cf */
        {8,	0}, 	/* 0x50d0 */
        {8,	0}, 	/* 0x50d1 */
        {8,	0}, 	/* 0x50d2 */
        {8,	0}, 	/* 0x50d3 */
        {8,	0}, 	/* 0x50d4 */
        {8,	0}, 	/* 0x50d5 */
        {8,	0}, 	/* 0x50d6 */
        {8,	0}, 	/* 0x50d7 */
        {8,	0}, 	/* 0x50d8 */
        {8,	0}, 	/* 0x50d9 */
        {8,	0}, 	/* 0x50da */
        {8,	0}, 	/* 0x50db */
        {8,	0}, 	/* 0x50dc */
        {8,	0}, 	/* 0x50dd */
        {8,	0}, 	/* 0x50de */
        {8,	0}, 	/* 0x50df */
        {8,	0}, 	/* 0x50e0 */
        {8,	0}, 	/* 0x50e1 */
        {8,	0}, 	/* 0x50e2 */
        {8,	0}, 	/* 0x50e3 */
        {8,	0}, 	/* 0x50e4 */
        {8,	0}, 	/* 0x50e5 */
        {8,	0}, 	/* 0x50e6 */
        {8,	0}, 	/* 0x50e7 */
        {8,	0}, 	/* 0x50e8 */
        {8,	0}, 	/* 0x50e9 */
        {8,	0}, 	/* 0x50ea */
        {8,	0}, 	/* 0x50eb */
        {8,	0}, 	/* 0x50ec */
        {8,	0}, 	/* 0x50ed */
        {8,	0}, 	/* 0x50ee */
        {8,	0}, 	/* 0x50ef */
        {8,	0}, 	/* 0x50f0 */
        {8,	0}, 	/* 0x50f1 */
        {8,	0}, 	/* 0x50f2 */
        {8,	0}, 	/* 0x50f3 */
        {8,	0}, 	/* 0x50f4 */
        {8,	0}, 	/* 0x50f5 */
        {8,	0}, 	/* 0x50f6 */
        {8,	0}, 	/* 0x50f7 */
        {8,	0}, 	/* 0x50f8 */
        {8,	0}, 	/* 0x50f9 */
        {8,	0}, 	/* 0x50fa */
        {8,	0}, 	/* 0x50fb */
        {8,	0}, 	/* 0x50fc */
        {8,	0}, 	/* 0x50fd */
        {8,	0}, 	/* 0x50fe */
        {8,	0}, 	/* 0x50ff */
        {8,	0}, 	/* 0x5100 */
        {8,	0}, 	/* 0x5101 */
        {8,	0}, 	/* 0x5102 */
        {8,	0}, 	/* 0x5103 */
        {8,	0}, 	/* 0x5104 */
        {8,	0}, 	/* 0x5105 */
        {8,	0}, 	/* 0x5106 */
        {8,	0}, 	/* 0x5107 */
        {8,	0}, 	/* 0x5108 */
        {8,	0}, 	/* 0x5109 */
        {8,	0}, 	/* 0x510a */
        {8,	0}, 	/* 0x510b */
        {8,	0}, 	/* 0x510c */
        {8,	0}, 	/* 0x510d */
        {8,	0}, 	/* 0x510e */
        {8,	0}, 	/* 0x510f */
        {8,	0}, 	/* 0x5110 */
        {8,	0}, 	/* 0x5111 */
        {8,	0}, 	/* 0x5112 */
        {8,	0}, 	/* 0x5113 */
        {8,	0}, 	/* 0x5114 */
        {8,	0}, 	/* 0x5115 */
        {8,	0}, 	/* 0x5116 */
        {8,	0}, 	/* 0x5117 */
        {8,	0}, 	/* 0x5118 */
        {8,	0}, 	/* 0x5119 */
        {8,	0}, 	/* 0x511a */
        {8,	0}, 	/* 0x511b */
        {8,	0}, 	/* 0x511c */
        {8,	0}, 	/* 0x511d */
        {8,	0}, 	/* 0x511e */
        {8,	0}, 	/* 0x511f */
        {8,	0}, 	/* 0x5120 */
        {8,	0}, 	/* 0x5121 */
        {8,	0}, 	/* 0x5122 */
        {8,	0}, 	/* 0x5123 */
        {8,	0}, 	/* 0x5124 */
        {8,	0}, 	/* 0x5125 */
        {8,	0}, 	/* 0x5126 */
        {8,	0}, 	/* 0x5127 */
        {8,	0}, 	/* 0x5128 */
        {8,	0}, 	/* 0x5129 */
        {8,	0}, 	/* 0x512a */
        {8,	0}, 	/* 0x512b */
        {8,	0}, 	/* 0x512c */
        {8,	0}, 	/* 0x512d */
        {8,	0}, 	/* 0x512e */
        {8,	0}, 	/* 0x512f */
        {8,	0}, 	/* 0x5130 */
        {8,	0}, 	/* 0x5131 */
        {8,	0}, 	/* 0x5132 */
        {8,	0}, 	/* 0x5133 */
        {8,	0}, 	/* 0x5134 */
        {8,	0}, 	/* 0x5135 */
        {8,	0}, 	/* 0x5136 */
        {8,	0}, 	/* 0x5137 */
        {8,	0}, 	/* 0x5138 */
        {8,	0}, 	/* 0x5139 */
        {8,	0}, 	/* 0x513a */
        {8,	0}, 	/* 0x513b */
        {8,	0}, 	/* 0x513c */
        {8,	0}, 	/* 0x513d */
        {8,	0}, 	/* 0x513e */
        {8,	0}, 	/* 0x513f */
        {8,	0}, 	/* 0x5140 */
        {8,	0}, 	/* 0x5141 */
        {8,	0}, 	/* 0x5142 */
        {8,	0}, 	/* 0x5143 */
        {8,	0}, 	/* 0x5144 */
        {8,	0}, 	/* 0x5145 */
        {8,	0}, 	/* 0x5146 */
        {8,	0}, 	/* 0x5147 */
        {8,	0}, 	/* 0x5148 */
        {8,	0}, 	/* 0x5149 */
        {8,	0}, 	/* 0x514a */
        {8,	0}, 	/* 0x514b */
        {8,	0}, 	/* 0x514c */
        {8,	0}, 	/* 0x514d */
        {8,	0}, 	/* 0x514e */
        {8,	0}, 	/* 0x514f */
        {8,	0}, 	/* 0x5150 */
        {8,	0}, 	/* 0x5151 */
        {8,	0}, 	/* 0x5152 */
        {8,	0}, 	/* 0x5153 */
        {8,	0}, 	/* 0x5154 */
        {8,	0}, 	/* 0x5155 */
        {8,	0}, 	/* 0x5156 */
        {8,	0}, 	/* 0x5157 */
        {8,	0}, 	/* 0x5158 */
        {8,	0}, 	/* 0x5159 */
        {8,	0}, 	/* 0x515a */
        {8,	0}, 	/* 0x515b */
        {8,	0}, 	/* 0x515c */
        {8,	0}, 	/* 0x515d */
        {8,	0}, 	/* 0x515e */
        {8,	0}, 	/* 0x515f */
        {8,	0}, 	/* 0x5160 */
        {8,	0}, 	/* 0x5161 */
        {8,	0}, 	/* 0x5162 */
        {8,	0}, 	/* 0x5163 */
        {8,	0}, 	/* 0x5164 */
        {8,	0}, 	/* 0x5165 */
        {8,	0}, 	/* 0x5166 */
        {8,	0}, 	/* 0x5167 */
        {8,	0}, 	/* 0x5168 */
        {8,	0}, 	/* 0x5169 */
        {8,	0}, 	/* 0x516a */
        {8,	0}, 	/* 0x516b */
        {8,	0}, 	/* 0x516c */
        {8,	0}, 	/* 0x516d */
        {8,	0}, 	/* 0x516e */
        {8,	0}, 	/* 0x516f */
        {8,	0}, 	/* 0x5170 */
        {8,	0}, 	/* 0x5171 */
        {8,	0}, 	/* 0x5172 */
        {8,	0}, 	/* 0x5173 */
        {8,	0}, 	/* 0x5174 */
        {8,	0}, 	/* 0x5175 */
        {8,	0}, 	/* 0x5176 */
        {8,	0}, 	/* 0x5177 */
        {8,	0}, 	/* 0x5178 */
        {8,	0}, 	/* 0x5179 */
        {8,	0}, 	/* 0x517a */
        {8,	0}, 	/* 0x517b */
        {8,	0}, 	/* 0x517c */
        {8,	0}, 	/* 0x517d */
        {8,	0}, 	/* 0x517e */
        {8,	0}, 	/* 0x517f */
        {8,	0}, 	/* 0x5180 */
        {8,	0}, 	/* 0x5181 */
        {8,	0}, 	/* 0x5182 */
        {8,	0}, 	/* 0x5183 */
        {8,	0}, 	/* 0x5184 */
        {8,	0}, 	/* 0x5185 */
        {8,	0}, 	/* 0x5186 */
        {8,	0}, 	/* 0x5187 */
        {8,	0}, 	/* 0x5188 */
        {8,	0}, 	/* 0x5189 */
        {8,	0}, 	/* 0x518a */
        {8,	0}, 	/* 0x518b */
        {8,	0}, 	/* 0x518c */
        {8,	0}, 	/* 0x518d */
        {8,	0}, 	/* 0x518e */
        {8,	0}, 	/* 0x518f */
        {8,	0}, 	/* 0x5190 */
        {8,	0}, 	/* 0x5191 */
        {8,	0}, 	/* 0x5192 */
        {8,	0}, 	/* 0x5193 */
        {8,	0}, 	/* 0x5194 */
        {8,	0}, 	/* 0x5195 */
        {8,	0}, 	/* 0x5196 */
        {8,	0}, 	/* 0x5197 */
        {8,	0}, 	/* 0x5198 */
        {8,	0}, 	/* 0x5199 */
        {8,	0}, 	/* 0x519a */
        {8,	0}, 	/* 0x519b */
        {8,	0}, 	/* 0x519c */
        {8,	0}, 	/* 0x519d */
        {8,	0}, 	/* 0x519e */
        {8,	0}, 	/* 0x519f */
        {8,	0}, 	/* 0x51a0 */
        {8,	0}, 	/* 0x51a1 */
        {8,	0}, 	/* 0x51a2 */
        {8,	0}, 	/* 0x51a3 */
        {8,	0}, 	/* 0x51a4 */
        {8,	0}, 	/* 0x51a5 */
        {8,	0}, 	/* 0x51a6 */
        {8,	0}, 	/* 0x51a7 */
        {8,	0}, 	/* 0x51a8 */
        {8,	0}, 	/* 0x51a9 */
        {8,	0}, 	/* 0x51aa */
        {8,	0}, 	/* 0x51ab */
        {8,	0}, 	/* 0x51ac */
        {8,	0}, 	/* 0x51ad */
        {8,	0}, 	/* 0x51ae */
        {8,	0}, 	/* 0x51af */
        {8,	0}, 	/* 0x51b0 */
        {8,	0}, 	/* 0x51b1 */
        {8,	0}, 	/* 0x51b2 */
        {8,	0}, 	/* 0x51b3 */
        {8,	0}, 	/* 0x51b4 */
        {8,	0}, 	/* 0x51b5 */
        {8,	0}, 	/* 0x51b6 */
        {8,	0}, 	/* 0x51b7 */
        {8,	0}, 	/* 0x51b8 */
        {8,	0}, 	/* 0x51b9 */
        {8,	0}, 	/* 0x51ba */
        {8,	0}, 	/* 0x51bb */
        {8,	0}, 	/* 0x51bc */
        {8,	0}, 	/* 0x51bd */
        {8,	0}, 	/* 0x51be */
        {8,	0}, 	/* 0x51bf */
        {8,	0}, 	/* 0x51c0 */
        {8,	0}, 	/* 0x51c1 */
        {8,	0}, 	/* 0x51c2 */
        {8,	0}, 	/* 0x51c3 */
        {8,	0}, 	/* 0x51c4 */
        {8,	0}, 	/* 0x51c5 */
        {8,	0}, 	/* 0x51c6 */
        {8,	0}, 	/* 0x51c7 */
        {8,	0}, 	/* 0x51c8 */
        {8,	0}, 	/* 0x51c9 */
        {8,	0}, 	/* 0x51ca */
        {8,	0}, 	/* 0x51cb */
        {8,	0}, 	/* 0x51cc */
        {8,	0}, 	/* 0x51cd */
        {8,	0}, 	/* 0x51ce */
        {8,	0}, 	/* 0x51cf */
        {8,	0}, 	/* 0x51d0 */
        {8,	0}, 	/* 0x51d1 */
        {8,	0}, 	/* 0x51d2 */
        {8,	0}, 	/* 0x51d3 */
        {8,	0}, 	/* 0x51d4 */
        {8,	0}, 	/* 0x51d5 */
        {8,	0}, 	/* 0x51d6 */
        {8,	0}, 	/* 0x51d7 */
        {8,	0}, 	/* 0x51d8 */
        {8,	0}, 	/* 0x51d9 */
        {8,	0}, 	/* 0x51da */
        {8,	0}, 	/* 0x51db */
        {8,	0}, 	/* 0x51dc */
        {8,	0}, 	/* 0x51dd */
        {8,	0}, 	/* 0x51de */
        {8,	0}, 	/* 0x51df */
        {8,	0}, 	/* 0x51e0 */
        {8,	0}, 	/* 0x51e1 */
        {8,	0}, 	/* 0x51e2 */
        {8,	0}, 	/* 0x51e3 */
        {8,	0}, 	/* 0x51e4 */
        {8,	0}, 	/* 0x51e5 */
        {8,	0}, 	/* 0x51e6 */
        {8,	0}, 	/* 0x51e7 */
        {8,	0}, 	/* 0x51e8 */
        {8,	0}, 	/* 0x51e9 */
        {8,	0}, 	/* 0x51ea */
        {8,	0}, 	/* 0x51eb */
        {8,	0}, 	/* 0x51ec */
        {8,	0}, 	/* 0x51ed */
        {8,	0}, 	/* 0x51ee */
        {8,	0}, 	/* 0x51ef */
        {8,	0}, 	/* 0x51f0 */
        {8,	0}, 	/* 0x51f1 */
        {8,	0}, 	/* 0x51f2 */
        {8,	0}, 	/* 0x51f3 */
        {8,	0}, 	/* 0x51f4 */
        {8,	0}, 	/* 0x51f5 */
        {8,	0}, 	/* 0x51f6 */
        {8,	0}, 	/* 0x51f7 */
        {8,	0}, 	/* 0x51f8 */
        {8,	0}, 	/* 0x51f9 */
        {8,	0}, 	/* 0x51fa */
        {8,	0}, 	/* 0x51fb */
        {8,	0}, 	/* 0x51fc */
        {8,	0}, 	/* 0x51fd */
        {8,	0}, 	/* 0x51fe */
        {8,	0}, 	/* 0x51ff */
        {8,	0}, 	/* 0x5200 */
        {8,	0}, 	/* 0x5201 */
        {8,	0}, 	/* 0x5202 */
        {8,	0}, 	/* 0x5203 */
        {8,	0}, 	/* 0x5204 */
        {8,	0}, 	/* 0x5205 */
        {8,	0}, 	/* 0x5206 */
        {8,	0}, 	/* 0x5207 */
        {8,	0}, 	/* 0x5208 */
        {8,	0}, 	/* 0x5209 */
        {8,	0}, 	/* 0x520a */
        {8,	0}, 	/* 0x520b */
        {8,	0}, 	/* 0x520c */
        {8,	0}, 	/* 0x520d */
        {8,	0}, 	/* 0x520e */
        {8,	0}, 	/* 0x520f */
        {8,	0}, 	/* 0x5210 */
        {8,	0}, 	/* 0x5211 */
        {8,	0}, 	/* 0x5212 */
        {8,	0}, 	/* 0x5213 */
        {8,	0}, 	/* 0x5214 */
        {8,	0}, 	/* 0x5215 */
        {8,	0}, 	/* 0x5216 */
        {8,	0}, 	/* 0x5217 */
        {8,	0}, 	/* 0x5218 */
        {8,	0}, 	/* 0x5219 */
        {8,	0}, 	/* 0x521a */
        {8,	0}, 	/* 0x521b */
        {8,	0}, 	/* 0x521c */
        {8,	0}, 	/* 0x521d */
        {8,	0}, 	/* 0x521e */
        {8,	0}, 	/* 0x521f */
        {8,	0}, 	/* 0x5220 */
        {8,	0}, 	/* 0x5221 */
        {8,	0}, 	/* 0x5222 */
        {8,	0}, 	/* 0x5223 */
        {8,	0}, 	/* 0x5224 */
        {8,	0}, 	/* 0x5225 */
        {8,	0}, 	/* 0x5226 */
        {8,	0}, 	/* 0x5227 */
        {8,	0}, 	/* 0x5228 */
        {8,	0}, 	/* 0x5229 */
        {8,	0}, 	/* 0x522a */
        {8,	0}, 	/* 0x522b */
        {8,	0}, 	/* 0x522c */
        {8,	0}, 	/* 0x522d */
        {8,	0}, 	/* 0x522e */
        {8,	0}, 	/* 0x522f */
        {8,	0}, 	/* 0x5230 */
        {8,	0}, 	/* 0x5231 */
        {8,	0}, 	/* 0x5232 */
        {8,	0}, 	/* 0x5233 */
        {8,	0}, 	/* 0x5234 */
        {8,	0}, 	/* 0x5235 */
        {8,	0}, 	/* 0x5236 */
        {8,	0}, 	/* 0x5237 */
        {8,	0}, 	/* 0x5238 */
        {8,	0}, 	/* 0x5239 */
        {8,	0}, 	/* 0x523a */
        {8,	0}, 	/* 0x523b */
        {8,	0}, 	/* 0x523c */
        {8,	0}, 	/* 0x523d */
        {8,	0}, 	/* 0x523e */
        {8,	0}, 	/* 0x523f */
        {8,	0}, 	/* 0x5240 */
        {8,	0}, 	/* 0x5241 */
        {8,	0}, 	/* 0x5242 */
        {8,	0}, 	/* 0x5243 */
        {8,	0}, 	/* 0x5244 */
        {8,	0}, 	/* 0x5245 */
        {8,	0}, 	/* 0x5246 */
        {8,	0}, 	/* 0x5247 */
        {8,	0}, 	/* 0x5248 */
        {8,	0}, 	/* 0x5249 */
        {8,	0}, 	/* 0x524a */
        {8,	0}, 	/* 0x524b */
        {8,	0}, 	/* 0x524c */
        {8,	0}, 	/* 0x524d */
        {8,	0}, 	/* 0x524e */
        {8,	0}, 	/* 0x524f */
        {8,	0}, 	/* 0x5250 */
        {8,	0}, 	/* 0x5251 */
        {8,	0}, 	/* 0x5252 */
        {8,	0}, 	/* 0x5253 */
        {8,	0}, 	/* 0x5254 */
        {8,	0}, 	/* 0x5255 */
        {8,	0}, 	/* 0x5256 */
        {8,	0}, 	/* 0x5257 */
        {8,	0}, 	/* 0x5258 */
        {8,	0}, 	/* 0x5259 */
        {8,	0}, 	/* 0x525a */
        {8,	0}, 	/* 0x525b */
        {8,	0}, 	/* 0x525c */
        {8,	0}, 	/* 0x525d */
        {8,	0}, 	/* 0x525e */
        {8,	0}, 	/* 0x525f */
        {8,	0}, 	/* 0x5260 */
        {8,	0}, 	/* 0x5261 */
        {8,	0}, 	/* 0x5262 */
        {8,	0}, 	/* 0x5263 */
        {8,	0}, 	/* 0x5264 */
        {8,	0}, 	/* 0x5265 */
        {8,	0}, 	/* 0x5266 */
        {8,	0}, 	/* 0x5267 */
        {8,	0}, 	/* 0x5268 */
        {8,	0}, 	/* 0x5269 */
        {8,	0}, 	/* 0x526a */
        {8,	0}, 	/* 0x526b */
        {8,	0}, 	/* 0x526c */
        {8,	0}, 	/* 0x526d */
        {8,	0}, 	/* 0x526e */
        {8,	0}, 	/* 0x526f */
        {8,	0}, 	/* 0x5270 */
        {8,	0}, 	/* 0x5271 */
        {8,	0}, 	/* 0x5272 */
        {8,	0}, 	/* 0x5273 */
        {8,	0}, 	/* 0x5274 */
        {8,	0}, 	/* 0x5275 */
        {8,	0}, 	/* 0x5276 */
        {8,	0}, 	/* 0x5277 */
        {8,	0}, 	/* 0x5278 */
        {8,	0}, 	/* 0x5279 */
        {8,	0}, 	/* 0x527a */
        {8,	0}, 	/* 0x527b */
        {8,	0}, 	/* 0x527c */
        {8,	0}, 	/* 0x527d */
        {8,	0}, 	/* 0x527e */
        {8,	0}, 	/* 0x527f */
        {8,	0}, 	/* 0x5280 */
        {8,	0}, 	/* 0x5281 */
        {8,	0}, 	/* 0x5282 */
        {8,	0}, 	/* 0x5283 */
        {8,	0}, 	/* 0x5284 */
        {8,	0}, 	/* 0x5285 */
        {8,	0}, 	/* 0x5286 */
        {8,	0}, 	/* 0x5287 */
        {8,	0}, 	/* 0x5288 */
        {8,	0}, 	/* 0x5289 */
        {8,	0}, 	/* 0x528a */
        {8,	0}, 	/* 0x528b */
        {8,	0}, 	/* 0x528c */
        {8,	0}, 	/* 0x528d */
        {8,	0}, 	/* 0x528e */
        {8,	0}, 	/* 0x528f */
        {8,	0}, 	/* 0x5290 */
        {8,	0}, 	/* 0x5291 */
        {8,	0}, 	/* 0x5292 */
        {8,	0}, 	/* 0x5293 */
        {8,	0}, 	/* 0x5294 */
        {8,	0}, 	/* 0x5295 */
        {8,	0}, 	/* 0x5296 */
        {8,	0}, 	/* 0x5297 */
        {8,	0}, 	/* 0x5298 */
        {8,	0}, 	/* 0x5299 */
        {8,	0}, 	/* 0x529a */
        {8,	0}, 	/* 0x529b */
        {8,	0}, 	/* 0x529c */
        {8,	0}, 	/* 0x529d */
        {8,	0}, 	/* 0x529e */
        {8,	0}, 	/* 0x529f */
        {8,	0}, 	/* 0x52a0 */
        {8,	0}, 	/* 0x52a1 */
        {8,	0}, 	/* 0x52a2 */
        {8,	0}, 	/* 0x52a3 */
        {8,	0}, 	/* 0x52a4 */
        {8,	0}, 	/* 0x52a5 */
        {8,	0}, 	/* 0x52a6 */
        {8,	0}, 	/* 0x52a7 */
        {8,	0}, 	/* 0x52a8 */
        {8,	0}, 	/* 0x52a9 */
        {8,	0}, 	/* 0x52aa */
        {8,	0}, 	/* 0x52ab */
        {8,	0}, 	/* 0x52ac */
        {8,	0}, 	/* 0x52ad */
        {8,	0}, 	/* 0x52ae */
        {8,	0}, 	/* 0x52af */
        {8,	0}, 	/* 0x52b0 */
        {8,	0}, 	/* 0x52b1 */
        {8,	0}, 	/* 0x52b2 */
        {8,	0}, 	/* 0x52b3 */
        {8,	0}, 	/* 0x52b4 */
        {8,	0}, 	/* 0x52b5 */
        {8,	0}, 	/* 0x52b6 */
        {8,	0}, 	/* 0x52b7 */
        {8,	0}, 	/* 0x52b8 */
        {8,	0}, 	/* 0x52b9 */
        {8,	0}, 	/* 0x52ba */
        {8,	0}, 	/* 0x52bb */
        {8,	0}, 	/* 0x52bc */
        {8,	0}, 	/* 0x52bd */
        {8,	0}, 	/* 0x52be */
        {8,	0}, 	/* 0x52bf */
        {8,	0}, 	/* 0x52c0 */
        {8,	0}, 	/* 0x52c1 */
        {8,	0}, 	/* 0x52c2 */
        {8,	0}, 	/* 0x52c3 */
        {8,	0}, 	/* 0x52c4 */
        {8,	0}, 	/* 0x52c5 */
        {8,	0}, 	/* 0x52c6 */
        {8,	0}, 	/* 0x52c7 */
        {8,	0}, 	/* 0x52c8 */
        {8,	0}, 	/* 0x52c9 */
        {8,	0}, 	/* 0x52ca */
        {8,	0}, 	/* 0x52cb */
        {8,	0}, 	/* 0x52cc */
        {8,	0}, 	/* 0x52cd */
        {8,	0}, 	/* 0x52ce */
        {8,	0}, 	/* 0x52cf */
        {8,	0}, 	/* 0x52d0 */
        {8,	0}, 	/* 0x52d1 */
        {8,	0}, 	/* 0x52d2 */
        {8,	0}, 	/* 0x52d3 */
        {8,	0}, 	/* 0x52d4 */
        {8,	0}, 	/* 0x52d5 */
        {8,	0}, 	/* 0x52d6 */
        {8,	0}, 	/* 0x52d7 */
        {8,	0}, 	/* 0x52d8 */
        {8,	0}, 	/* 0x52d9 */
        {8,	0}, 	/* 0x52da */
        {8,	0}, 	/* 0x52db */
        {8,	0}, 	/* 0x52dc */
        {8,	0}, 	/* 0x52dd */
        {8,	0}, 	/* 0x52de */
        {8,	0}, 	/* 0x52df */
        {8,	0}, 	/* 0x52e0 */
        {8,	0}, 	/* 0x52e1 */
        {8,	0}, 	/* 0x52e2 */
        {8,	0}, 	/* 0x52e3 */
        {8,	0}, 	/* 0x52e4 */
        {8,	0}, 	/* 0x52e5 */
        {8,	0}, 	/* 0x52e6 */
        {8,	0}, 	/* 0x52e7 */
        {8,	0}, 	/* 0x52e8 */
        {8,	0}, 	/* 0x52e9 */
        {8,	0}, 	/* 0x52ea */
        {8,	0}, 	/* 0x52eb */
        {8,	0}, 	/* 0x52ec */
        {8,	0}, 	/* 0x52ed */
        {8,	0}, 	/* 0x52ee */
        {8,	0}, 	/* 0x52ef */
        {8,	0}, 	/* 0x52f0 */
        {8,	0}, 	/* 0x52f1 */
        {8,	0}, 	/* 0x52f2 */
        {8,	0}, 	/* 0x52f3 */
        {8,	0}, 	/* 0x52f4 */
        {8,	0}, 	/* 0x52f5 */
        {8,	0}, 	/* 0x52f6 */
        {8,	0}, 	/* 0x52f7 */
        {8,	0}, 	/* 0x52f8 */
        {8,	0}, 	/* 0x52f9 */
        {8,	0}, 	/* 0x52fa */
        {8,	0}, 	/* 0x52fb */
        {8,	0}, 	/* 0x52fc */
        {8,	0}, 	/* 0x52fd */
        {8,	0}, 	/* 0x52fe */
        {8,	0}, 	/* 0x52ff */
        {8,	0}, 	/* 0x5300 */
        {8,	0}, 	/* 0x5301 */
        {8,	0}, 	/* 0x5302 */
        {8,	0}, 	/* 0x5303 */
        {8,	0}, 	/* 0x5304 */
        {8,	0}, 	/* 0x5305 */
        {8,	0}, 	/* 0x5306 */
        {8,	0}, 	/* 0x5307 */
        {8,	0}, 	/* 0x5308 */
        {8,	0}, 	/* 0x5309 */
        {8,	0}, 	/* 0x530a */
        {8,	0}, 	/* 0x530b */
        {8,	0}, 	/* 0x530c */
        {8,	0}, 	/* 0x530d */
        {8,	0}, 	/* 0x530e */
        {8,	0}, 	/* 0x530f */
        {8,	0}, 	/* 0x5310 */
        {8,	0}, 	/* 0x5311 */
        {8,	0}, 	/* 0x5312 */
        {8,	0}, 	/* 0x5313 */
        {8,	0}, 	/* 0x5314 */
        {8,	0}, 	/* 0x5315 */
        {8,	0}, 	/* 0x5316 */
        {8,	0}, 	/* 0x5317 */
        {8,	0}, 	/* 0x5318 */
        {8,	0}, 	/* 0x5319 */
        {8,	0}, 	/* 0x531a */
        {8,	0}, 	/* 0x531b */
        {8,	0}, 	/* 0x531c */
        {8,	0}, 	/* 0x531d */
        {8,	0}, 	/* 0x531e */
        {8,	0}, 	/* 0x531f */
        {8,	0}, 	/* 0x5320 */
        {8,	0}, 	/* 0x5321 */
        {8,	0}, 	/* 0x5322 */
        {8,	0}, 	/* 0x5323 */
        {8,	0}, 	/* 0x5324 */
        {8,	0}, 	/* 0x5325 */
        {8,	0}, 	/* 0x5326 */
        {8,	0}, 	/* 0x5327 */
        {8,	0}, 	/* 0x5328 */
        {8,	0}, 	/* 0x5329 */
        {8,	0}, 	/* 0x532a */
        {8,	0}, 	/* 0x532b */
        {8,	0}, 	/* 0x532c */
        {8,	0}, 	/* 0x532d */
        {8,	0}, 	/* 0x532e */
        {8,	0}, 	/* 0x532f */
        {8,	0}, 	/* 0x5330 */
        {8,	0}, 	/* 0x5331 */
        {8,	0}, 	/* 0x5332 */
        {8,	0}, 	/* 0x5333 */
        {8,	0}, 	/* 0x5334 */
        {8,	0}, 	/* 0x5335 */
        {8,	0}, 	/* 0x5336 */
        {8,	0}, 	/* 0x5337 */
        {8,	0}, 	/* 0x5338 */
        {8,	0}, 	/* 0x5339 */
        {8,	0}, 	/* 0x533a */
        {8,	0}, 	/* 0x533b */
        {8,	0}, 	/* 0x533c */
        {8,	0}, 	/* 0x533d */
        {8,	0}, 	/* 0x533e */
        {8,	0}, 	/* 0x533f */
        {8,	0}, 	/* 0x5340 */
        {8,	0}, 	/* 0x5341 */
        {8,	0}, 	/* 0x5342 */
        {8,	0}, 	/* 0x5343 */
        {8,	0}, 	/* 0x5344 */
        {8,	0}, 	/* 0x5345 */
        {8,	0}, 	/* 0x5346 */
        {8,	0}, 	/* 0x5347 */
        {8,	0}, 	/* 0x5348 */
        {8,	0}, 	/* 0x5349 */
        {8,	0}, 	/* 0x534a */
        {8,	0}, 	/* 0x534b */
        {8,	0}, 	/* 0x534c */
        {8,	0}, 	/* 0x534d */
        {8,	0}, 	/* 0x534e */
        {8,	0}, 	/* 0x534f */
        {8,	0}, 	/* 0x5350 */
        {8,	0}, 	/* 0x5351 */
        {8,	0}, 	/* 0x5352 */
        {8,	0}, 	/* 0x5353 */
        {8,	0}, 	/* 0x5354 */
        {8,	0}, 	/* 0x5355 */
        {8,	0}, 	/* 0x5356 */
        {8,	0}, 	/* 0x5357 */
        {8,	0}, 	/* 0x5358 */
        {8,	0}, 	/* 0x5359 */
        {8,	0}, 	/* 0x535a */
        {8,	0}, 	/* 0x535b */
        {8,	0}, 	/* 0x535c */
        {8,	0}, 	/* 0x535d */
        {8,	0}, 	/* 0x535e */
        {8,	0}, 	/* 0x535f */
        {8,	0}, 	/* 0x5360 */
        {8,	0}, 	/* 0x5361 */
        {8,	0}, 	/* 0x5362 */
        {8,	0}, 	/* 0x5363 */
        {8,	0}, 	/* 0x5364 */
        {8,	0}, 	/* 0x5365 */
        {8,	0}, 	/* 0x5366 */
        {8,	0}, 	/* 0x5367 */
        {8,	0}, 	/* 0x5368 */
        {8,	0}, 	/* 0x5369 */
        {8,	0}, 	/* 0x536a */
        {8,	0}, 	/* 0x536b */
        {8,	0}, 	/* 0x536c */
        {8,	0}, 	/* 0x536d */
        {8,	0}, 	/* 0x536e */
        {8,	0}, 	/* 0x536f */
        {8,	0}, 	/* 0x5370 */
        {8,	0}, 	/* 0x5371 */
        {8,	0}, 	/* 0x5372 */
        {8,	0}, 	/* 0x5373 */
        {8,	0}, 	/* 0x5374 */
        {8,	0}, 	/* 0x5375 */
        {8,	0}, 	/* 0x5376 */
        {8,	0}, 	/* 0x5377 */
        {8,	0}, 	/* 0x5378 */
        {8,	0}, 	/* 0x5379 */
        {8,	0}, 	/* 0x537a */
        {8,	0}, 	/* 0x537b */
        {8,	0}, 	/* 0x537c */
        {8,	0}, 	/* 0x537d */
        {8,	0}, 	/* 0x537e */
        {8,	0}, 	/* 0x537f */
        {8,	0}, 	/* 0x5380 */
        {8,	0}, 	/* 0x5381 */
        {8,	0}, 	/* 0x5382 */
        {8,	0}, 	/* 0x5383 */
        {8,	0}, 	/* 0x5384 */
        {8,	0}, 	/* 0x5385 */
        {8,	0}, 	/* 0x5386 */
        {8,	0}, 	/* 0x5387 */
        {8,	0}, 	/* 0x5388 */
        {8,	0}, 	/* 0x5389 */
        {8,	0}, 	/* 0x538a */
        {8,	0}, 	/* 0x538b */
        {8,	0}, 	/* 0x538c */
        {8,	0}, 	/* 0x538d */
        {8,	0}, 	/* 0x538e */
        {8,	0}, 	/* 0x538f */
        {8,	0}, 	/* 0x5390 */
        {8,	0}, 	/* 0x5391 */
        {8,	0}, 	/* 0x5392 */
        {8,	0}, 	/* 0x5393 */
        {8,	0}, 	/* 0x5394 */
        {8,	0}, 	/* 0x5395 */
        {8,	0}, 	/* 0x5396 */
        {8,	0}, 	/* 0x5397 */
        {8,	0}, 	/* 0x5398 */
        {8,	0}, 	/* 0x5399 */
        {8,	0}, 	/* 0x539a */
        {8,	0}, 	/* 0x539b */
        {8,	0}, 	/* 0x539c */
        {8,	0}, 	/* 0x539d */
        {8,	0}, 	/* 0x539e */
        {8,	0}, 	/* 0x539f */
        {8,	0}, 	/* 0x53a0 */
        {8,	0}, 	/* 0x53a1 */
        {8,	0}, 	/* 0x53a2 */
        {8,	0}, 	/* 0x53a3 */
        {8,	0}, 	/* 0x53a4 */
        {8,	0}, 	/* 0x53a5 */
        {8,	0}, 	/* 0x53a6 */
        {8,	0}, 	/* 0x53a7 */
        {8,	0}, 	/* 0x53a8 */
        {8,	0}, 	/* 0x53a9 */
        {8,	0}, 	/* 0x53aa */
        {8,	0}, 	/* 0x53ab */
        {8,	0}, 	/* 0x53ac */
        {8,	0}, 	/* 0x53ad */
        {8,	0}, 	/* 0x53ae */
        {8,	0}, 	/* 0x53af */
        {8,	0}, 	/* 0x53b0 */
        {8,	0}, 	/* 0x53b1 */
        {8,	0}, 	/* 0x53b2 */
        {8,	0}, 	/* 0x53b3 */
        {8,	0}, 	/* 0x53b4 */
        {8,	0}, 	/* 0x53b5 */
        {8,	0}, 	/* 0x53b6 */
        {8,	0}, 	/* 0x53b7 */
        {8,	0}, 	/* 0x53b8 */
        {8,	0}, 	/* 0x53b9 */
        {8,	0}, 	/* 0x53ba */
        {8,	0}, 	/* 0x53bb */
        {8,	0}, 	/* 0x53bc */
        {8,	0}, 	/* 0x53bd */
        {8,	0}, 	/* 0x53be */
        {8,	0}, 	/* 0x53bf */
        {8,	0}, 	/* 0x53c0 */
        {8,	0}, 	/* 0x53c1 */
        {8,	0}, 	/* 0x53c2 */
        {8,	0}, 	/* 0x53c3 */
        {8,	0}, 	/* 0x53c4 */
        {8,	0}, 	/* 0x53c5 */
        {8,	0}, 	/* 0x53c6 */
        {8,	0}, 	/* 0x53c7 */
        {8,	0}, 	/* 0x53c8 */
        {8,	0}, 	/* 0x53c9 */
        {8,	0}, 	/* 0x53ca */
        {8,	0}, 	/* 0x53cb */
        {8,	0}, 	/* 0x53cc */
        {8,	0}, 	/* 0x53cd */
        {8,	0}, 	/* 0x53ce */
        {8,	0}, 	/* 0x53cf */
        {8,	0}, 	/* 0x53d0 */
        {8,	0}, 	/* 0x53d1 */
        {8,	0}, 	/* 0x53d2 */
        {8,	0}, 	/* 0x53d3 */
        {8,	0}, 	/* 0x53d4 */
        {8,	0}, 	/* 0x53d5 */
        {8,	0}, 	/* 0x53d6 */
        {8,	0}, 	/* 0x53d7 */
        {8,	0}, 	/* 0x53d8 */
        {8,	0}, 	/* 0x53d9 */
        {8,	0}, 	/* 0x53da */
        {8,	0}, 	/* 0x53db */
        {8,	0}, 	/* 0x53dc */
        {8,	0}, 	/* 0x53dd */
        {8,	0}, 	/* 0x53de */
        {8,	0}, 	/* 0x53df */
        {8,	0}, 	/* 0x53e0 */
        {8,	0}, 	/* 0x53e1 */
        {8,	0}, 	/* 0x53e2 */
        {8,	0}, 	/* 0x53e3 */
        {8,	0}, 	/* 0x53e4 */
        {8,	0}, 	/* 0x53e5 */
        {8,	0}, 	/* 0x53e6 */
        {8,	0}, 	/* 0x53e7 */
        {8,	0}, 	/* 0x53e8 */
        {8,	0}, 	/* 0x53e9 */
        {8,	0}, 	/* 0x53ea */
        {8,	0}, 	/* 0x53eb */
        {8,	0}, 	/* 0x53ec */
        {8,	0}, 	/* 0x53ed */
        {8,	0}, 	/* 0x53ee */
        {8,	0}, 	/* 0x53ef */
        {8,	0}, 	/* 0x53f0 */
        {8,	0}, 	/* 0x53f1 */
        {8,	0}, 	/* 0x53f2 */
        {8,	0}, 	/* 0x53f3 */
        {8,	0}, 	/* 0x53f4 */
        {8,	0}, 	/* 0x53f5 */
        {8,	0}, 	/* 0x53f6 */
        {8,	0}, 	/* 0x53f7 */
        {8,	0}, 	/* 0x53f8 */
        {8,	0}, 	/* 0x53f9 */
        {8,	0}, 	/* 0x53fa */
        {8,	0}, 	/* 0x53fb */
        {8,	0}, 	/* 0x53fc */
        {8,	0}, 	/* 0x53fd */
        {8,	0}, 	/* 0x53fe */
        {8,	0}, 	/* 0x53ff */
        {8,	0}, 	/* 0x5400 */
        {8,	0}, 	/* 0x5401 */
        {8,	0}, 	/* 0x5402 */
        {8,	0}, 	/* 0x5403 */
        {8,	0}, 	/* 0x5404 */
        {8,	0}, 	/* 0x5405 */
        {8,	0}, 	/* 0x5406 */
        {8,	0}, 	/* 0x5407 */
        {8,	0}, 	/* 0x5408 */
        {8,	0}, 	/* 0x5409 */
        {8,	0}, 	/* 0x540a */
        {8,	0}, 	/* 0x540b */
        {8,	0}, 	/* 0x540c */
        {8,	0}, 	/* 0x540d */
        {8,	0}, 	/* 0x540e */
        {8,	0}, 	/* 0x540f */
        {8,	0}, 	/* 0x5410 */
        {8,	0}, 	/* 0x5411 */
        {8,	0}, 	/* 0x5412 */
        {8,	0}, 	/* 0x5413 */
        {8,	0}, 	/* 0x5414 */
        {8,	0}, 	/* 0x5415 */
        {8,	0}, 	/* 0x5416 */
        {8,	0}, 	/* 0x5417 */
        {8,	0}, 	/* 0x5418 */
        {8,	0}, 	/* 0x5419 */
        {8,	0}, 	/* 0x541a */
        {8,	0}, 	/* 0x541b */
        {8,	0}, 	/* 0x541c */
        {8,	0}, 	/* 0x541d */
        {8,	0}, 	/* 0x541e */
        {8,	0}, 	/* 0x541f */
        {8,	0}, 	/* 0x5420 */
        {8,	0}, 	/* 0x5421 */
        {8,	0}, 	/* 0x5422 */
        {8,	0}, 	/* 0x5423 */
        {8,	0}, 	/* 0x5424 */
        {8,	0}, 	/* 0x5425 */
        {8,	0}, 	/* 0x5426 */
        {8,	0}, 	/* 0x5427 */
        {8,	0}, 	/* 0x5428 */
        {8,	0}, 	/* 0x5429 */
        {8,	0}, 	/* 0x542a */
        {8,	0}, 	/* 0x542b */
        {8,	0}, 	/* 0x542c */
        {8,	0}, 	/* 0x542d */
        {8,	0}, 	/* 0x542e */
        {8,	0}, 	/* 0x542f */
        {8,	0}, 	/* 0x5430 */
        {8,	0}, 	/* 0x5431 */
        {8,	0}, 	/* 0x5432 */
        {8,	0}, 	/* 0x5433 */
        {8,	0}, 	/* 0x5434 */
        {8,	0}, 	/* 0x5435 */
        {8,	0}, 	/* 0x5436 */
        {8,	0}, 	/* 0x5437 */
        {8,	0}, 	/* 0x5438 */
        {8,	0}, 	/* 0x5439 */
        {8,	0}, 	/* 0x543a */
        {8,	0}, 	/* 0x543b */
        {8,	0}, 	/* 0x543c */
        {8,	0}, 	/* 0x543d */
        {8,	0}, 	/* 0x543e */
        {8,	0}, 	/* 0x543f */
        {8,	0}, 	/* 0x5440 */
        {8,	0}, 	/* 0x5441 */
        {8,	0}, 	/* 0x5442 */
        {8,	0}, 	/* 0x5443 */
        {8,	0}, 	/* 0x5444 */
        {8,	0}, 	/* 0x5445 */
        {8,	0}, 	/* 0x5446 */
        {8,	0}, 	/* 0x5447 */
        {8,	0}, 	/* 0x5448 */
        {8,	0}, 	/* 0x5449 */
        {8,	0}, 	/* 0x544a */
        {8,	0}, 	/* 0x544b */
        {8,	0}, 	/* 0x544c */
        {8,	0}, 	/* 0x544d */
        {8,	0}, 	/* 0x544e */
        {8,	0}, 	/* 0x544f */
        {8,	0}, 	/* 0x5450 */
        {8,	0}, 	/* 0x5451 */
        {8,	0}, 	/* 0x5452 */
        {8,	0}, 	/* 0x5453 */
        {8,	0}, 	/* 0x5454 */
        {8,	0}, 	/* 0x5455 */
        {8,	0}, 	/* 0x5456 */
        {8,	0}, 	/* 0x5457 */
        {8,	0}, 	/* 0x5458 */
        {8,	0}, 	/* 0x5459 */
        {8,	0}, 	/* 0x545a */
        {8,	0}, 	/* 0x545b */
        {8,	0}, 	/* 0x545c */
        {8,	0}, 	/* 0x545d */
        {8,	0}, 	/* 0x545e */
        {8,	0}, 	/* 0x545f */
        {8,	0}, 	/* 0x5460 */
        {8,	0}, 	/* 0x5461 */
        {8,	0}, 	/* 0x5462 */
        {8,	0}, 	/* 0x5463 */
        {8,	0}, 	/* 0x5464 */
        {8,	0}, 	/* 0x5465 */
        {8,	0}, 	/* 0x5466 */
        {8,	0}, 	/* 0x5467 */
        {8,	0}, 	/* 0x5468 */
        {8,	0}, 	/* 0x5469 */
        {8,	0}, 	/* 0x546a */
        {8,	0}, 	/* 0x546b */
        {8,	0}, 	/* 0x546c */
        {8,	0}, 	/* 0x546d */
        {8,	0}, 	/* 0x546e */
        {8,	0}, 	/* 0x546f */
        {8,	0}, 	/* 0x5470 */
        {8,	0}, 	/* 0x5471 */
        {8,	0}, 	/* 0x5472 */
        {8,	0}, 	/* 0x5473 */
        {8,	0}, 	/* 0x5474 */
        {8,	0}, 	/* 0x5475 */
        {8,	0}, 	/* 0x5476 */
        {8,	0}, 	/* 0x5477 */
        {8,	0}, 	/* 0x5478 */
        {8,	0}, 	/* 0x5479 */
        {8,	0}, 	/* 0x547a */
        {8,	0}, 	/* 0x547b */
        {8,	0}, 	/* 0x547c */
        {8,	0}, 	/* 0x547d */
        {8,	0}, 	/* 0x547e */
        {8,	0}, 	/* 0x547f */
        {8,	0}, 	/* 0x5480 */
        {8,	0}, 	/* 0x5481 */
        {8,	0}, 	/* 0x5482 */
        {8,	0}, 	/* 0x5483 */
        {8,	0}, 	/* 0x5484 */
        {8,	0}, 	/* 0x5485 */
        {8,	0}, 	/* 0x5486 */
        {8,	0}, 	/* 0x5487 */
        {8,	0}, 	/* 0x5488 */
        {8,	0}, 	/* 0x5489 */
        {8,	0}, 	/* 0x548a */
        {8,	0}, 	/* 0x548b */
        {8,	0}, 	/* 0x548c */
        {8,	0}, 	/* 0x548d */
        {8,	0}, 	/* 0x548e */
        {8,	0}, 	/* 0x548f */
        {8,	0}, 	/* 0x5490 */
        {8,	0}, 	/* 0x5491 */
        {8,	0}, 	/* 0x5492 */
        {8,	0}, 	/* 0x5493 */
        {8,	0}, 	/* 0x5494 */
        {8,	0}, 	/* 0x5495 */
        {8,	0}, 	/* 0x5496 */
        {8,	0}, 	/* 0x5497 */
        {8,	0}, 	/* 0x5498 */
        {8,	0}, 	/* 0x5499 */
        {8,	0}, 	/* 0x549a */
        {8,	0}, 	/* 0x549b */
        {8,	0}, 	/* 0x549c */
        {8,	0}, 	/* 0x549d */
        {8,	0}, 	/* 0x549e */
        {8,	0}, 	/* 0x549f */
        {8,	0}, 	/* 0x54a0 */
        {8,	0}, 	/* 0x54a1 */
        {8,	0}, 	/* 0x54a2 */
        {8,	0}, 	/* 0x54a3 */
        {8,	0}, 	/* 0x54a4 */
        {8,	0}, 	/* 0x54a5 */
        {8,	0}, 	/* 0x54a6 */
        {8,	0}, 	/* 0x54a7 */
        {8,	0}, 	/* 0x54a8 */
        {8,	0}, 	/* 0x54a9 */
        {8,	0}, 	/* 0x54aa */
        {8,	0}, 	/* 0x54ab */
        {8,	0}, 	/* 0x54ac */
        {8,	0}, 	/* 0x54ad */
        {8,	0}, 	/* 0x54ae */
        {8,	0}, 	/* 0x54af */
        {8,	0}, 	/* 0x54b0 */
        {8,	0}, 	/* 0x54b1 */
        {8,	0}, 	/* 0x54b2 */
        {8,	0}, 	/* 0x54b3 */
        {8,	0}, 	/* 0x54b4 */
        {8,	0}, 	/* 0x54b5 */
        {8,	0}, 	/* 0x54b6 */
        {8,	0}, 	/* 0x54b7 */
        {8,	0}, 	/* 0x54b8 */
        {8,	0}, 	/* 0x54b9 */
        {8,	0}, 	/* 0x54ba */
        {8,	0}, 	/* 0x54bb */
        {8,	0}, 	/* 0x54bc */
        {8,	0}, 	/* 0x54bd */
        {8,	0}, 	/* 0x54be */
        {8,	0}, 	/* 0x54bf */
        {8,	0}, 	/* 0x54c0 */
        {8,	0}, 	/* 0x54c1 */
        {8,	0}, 	/* 0x54c2 */
        {8,	0}, 	/* 0x54c3 */
        {8,	0}, 	/* 0x54c4 */
        {8,	0}, 	/* 0x54c5 */
        {8,	0}, 	/* 0x54c6 */
        {8,	0}, 	/* 0x54c7 */
        {8,	0}, 	/* 0x54c8 */
        {8,	0}, 	/* 0x54c9 */
        {8,	0}, 	/* 0x54ca */
        {8,	0}, 	/* 0x54cb */
        {8,	0}, 	/* 0x54cc */
        {8,	0}, 	/* 0x54cd */
        {8,	0}, 	/* 0x54ce */
        {8,	0}, 	/* 0x54cf */
        {8,	0}, 	/* 0x54d0 */
        {8,	0}, 	/* 0x54d1 */
        {8,	0}, 	/* 0x54d2 */
        {8,	0}, 	/* 0x54d3 */
        {8,	0}, 	/* 0x54d4 */
        {8,	0}, 	/* 0x54d5 */
        {8,	0}, 	/* 0x54d6 */
        {8,	0}, 	/* 0x54d7 */
        {8,	0}, 	/* 0x54d8 */
        {8,	0}, 	/* 0x54d9 */
        {8,	0}, 	/* 0x54da */
        {8,	0}, 	/* 0x54db */
        {8,	0}, 	/* 0x54dc */
        {8,	0}, 	/* 0x54dd */
        {8,	0}, 	/* 0x54de */
        {8,	0}, 	/* 0x54df */
        {8,	0}, 	/* 0x54e0 */
        {8,	0}, 	/* 0x54e1 */
        {8,	0}, 	/* 0x54e2 */
        {8,	0}, 	/* 0x54e3 */
        {8,	0}, 	/* 0x54e4 */
        {8,	0}, 	/* 0x54e5 */
        {8,	0}, 	/* 0x54e6 */
        {8,	0}, 	/* 0x54e7 */
        {8,	0}, 	/* 0x54e8 */
        {8,	0}, 	/* 0x54e9 */
        {8,	0}, 	/* 0x54ea */
        {8,	0}, 	/* 0x54eb */
        {8,	0}, 	/* 0x54ec */
        {8,	0}, 	/* 0x54ed */
        {8,	0}, 	/* 0x54ee */
        {8,	0}, 	/* 0x54ef */
        {8,	0}, 	/* 0x54f0 */
        {8,	0}, 	/* 0x54f1 */
        {8,	0}, 	/* 0x54f2 */
        {8,	0}, 	/* 0x54f3 */
        {8,	0}, 	/* 0x54f4 */
        {8,	0}, 	/* 0x54f5 */
        {8,	0}, 	/* 0x54f6 */
        {8,	0}, 	/* 0x54f7 */
        {8,	0}, 	/* 0x54f8 */
        {8,	0}, 	/* 0x54f9 */
        {8,	0}, 	/* 0x54fa */
        {8,	0}, 	/* 0x54fb */
        {8,	0}, 	/* 0x54fc */
        {8,	0}, 	/* 0x54fd */
        {8,	0}, 	/* 0x54fe */
        {8,	0}, 	/* 0x54ff */
        {8,	0}, 	/* 0x5500 */
        {8,	0}, 	/* 0x5501 */
        {8,	0}, 	/* 0x5502 */
        {8,	0}, 	/* 0x5503 */
        {8,	0}, 	/* 0x5504 */
        {8,	0}, 	/* 0x5505 */
        {8,	0}, 	/* 0x5506 */
        {8,	0}, 	/* 0x5507 */
        {8,	0}, 	/* 0x5508 */
        {8,	0}, 	/* 0x5509 */
        {8,	0}, 	/* 0x550a */
        {8,	0}, 	/* 0x550b */
        {8,	0}, 	/* 0x550c */
        {8,	0}, 	/* 0x550d */
        {8,	0}, 	/* 0x550e */
        {8,	0}, 	/* 0x550f */
        {8,	0}, 	/* 0x5510 */
        {8,	0}, 	/* 0x5511 */
        {8,	0}, 	/* 0x5512 */
        {8,	0}, 	/* 0x5513 */
        {8,	0}, 	/* 0x5514 */
        {8,	0}, 	/* 0x5515 */
        {8,	0}, 	/* 0x5516 */
        {8,	0}, 	/* 0x5517 */
        {8,	0}, 	/* 0x5518 */
        {8,	0}, 	/* 0x5519 */
        {8,	0}, 	/* 0x551a */
        {8,	0}, 	/* 0x551b */
        {8,	0}, 	/* 0x551c */
        {8,	0}, 	/* 0x551d */
        {8,	0}, 	/* 0x551e */
        {8,	0}, 	/* 0x551f */
        {8,	0}, 	/* 0x5520 */
        {8,	0}, 	/* 0x5521 */
        {8,	0}, 	/* 0x5522 */
        {8,	0}, 	/* 0x5523 */
        {8,	0}, 	/* 0x5524 */
        {8,	0}, 	/* 0x5525 */
        {8,	0}, 	/* 0x5526 */
        {8,	0}, 	/* 0x5527 */
        {8,	0}, 	/* 0x5528 */
        {8,	0}, 	/* 0x5529 */
        {8,	0}, 	/* 0x552a */
        {8,	0}, 	/* 0x552b */
        {8,	0}, 	/* 0x552c */
        {8,	0}, 	/* 0x552d */
        {8,	0}, 	/* 0x552e */
        {8,	0}, 	/* 0x552f */
        {8,	0}, 	/* 0x5530 */
        {8,	0}, 	/* 0x5531 */
        {8,	0}, 	/* 0x5532 */
        {8,	0}, 	/* 0x5533 */
        {8,	0}, 	/* 0x5534 */
        {8,	0}, 	/* 0x5535 */
        {8,	0}, 	/* 0x5536 */
        {8,	0}, 	/* 0x5537 */
        {8,	0}, 	/* 0x5538 */
        {8,	0}, 	/* 0x5539 */
        {8,	0}, 	/* 0x553a */
        {8,	0}, 	/* 0x553b */
        {8,	0}, 	/* 0x553c */
        {8,	0}, 	/* 0x553d */
        {8,	0}, 	/* 0x553e */
        {8,	0}, 	/* 0x553f */
        {8,	0}, 	/* 0x5540 */
        {8,	0}, 	/* 0x5541 */
        {8,	0}, 	/* 0x5542 */
        {8,	0}, 	/* 0x5543 */
        {8,	0}, 	/* 0x5544 */
        {8,	0}, 	/* 0x5545 */
        {8,	0}, 	/* 0x5546 */
        {8,	0}, 	/* 0x5547 */
        {8,	0}, 	/* 0x5548 */
        {8,	0}, 	/* 0x5549 */
        {8,	0}, 	/* 0x554a */
        {8,	0}, 	/* 0x554b */
        {8,	0}, 	/* 0x554c */
        {8,	0}, 	/* 0x554d */
        {8,	0}, 	/* 0x554e */
        {8,	0}, 	/* 0x554f */
        {8,	0}, 	/* 0x5550 */
        {8,	0}, 	/* 0x5551 */
        {8,	0}, 	/* 0x5552 */
        {8,	0}, 	/* 0x5553 */
        {8,	0}, 	/* 0x5554 */
        {8,	0}, 	/* 0x5555 */
        {8,	0}, 	/* 0x5556 */
        {8,	0}, 	/* 0x5557 */
        {8,	0}, 	/* 0x5558 */
        {8,	0}, 	/* 0x5559 */
        {8,	0}, 	/* 0x555a */
        {8,	0}, 	/* 0x555b */
        {8,	0}, 	/* 0x555c */
        {8,	0}, 	/* 0x555d */
        {8,	0}, 	/* 0x555e */
        {8,	0}, 	/* 0x555f */
        {8,	0}, 	/* 0x5560 */
        {8,	0}, 	/* 0x5561 */
        {8,	0}, 	/* 0x5562 */
        {8,	0}, 	/* 0x5563 */
        {8,	0}, 	/* 0x5564 */
        {8,	0}, 	/* 0x5565 */
        {8,	0}, 	/* 0x5566 */
        {8,	0}, 	/* 0x5567 */
        {8,	0}, 	/* 0x5568 */
        {8,	0}, 	/* 0x5569 */
        {8,	0}, 	/* 0x556a */
        {8,	0}, 	/* 0x556b */
        {8,	0}, 	/* 0x556c */
        {8,	0}, 	/* 0x556d */
        {8,	0}, 	/* 0x556e */
        {8,	0}, 	/* 0x556f */
        {8,	0}, 	/* 0x5570 */
        {8,	0}, 	/* 0x5571 */
        {8,	0}, 	/* 0x5572 */
        {8,	0}, 	/* 0x5573 */
        {8,	0}, 	/* 0x5574 */
        {8,	0}, 	/* 0x5575 */
        {8,	0}, 	/* 0x5576 */
        {8,	0}, 	/* 0x5577 */
        {8,	0}, 	/* 0x5578 */
        {8,	0}, 	/* 0x5579 */
        {8,	0}, 	/* 0x557a */
        {8,	0}, 	/* 0x557b */
        {8,	0}, 	/* 0x557c */
        {8,	0}, 	/* 0x557d */
        {8,	0}, 	/* 0x557e */
        {8,	0}, 	/* 0x557f */
        {8,	0}, 	/* 0x5580 */
        {8,	0}, 	/* 0x5581 */
        {8,	0}, 	/* 0x5582 */
        {8,	0}, 	/* 0x5583 */
        {8,	0}, 	/* 0x5584 */
        {8,	0}, 	/* 0x5585 */
        {8,	0}, 	/* 0x5586 */
        {8,	0}, 	/* 0x5587 */
        {8,	0}, 	/* 0x5588 */
        {8,	0}, 	/* 0x5589 */
        {8,	0}, 	/* 0x558a */
        {8,	0}, 	/* 0x558b */
        {8,	0}, 	/* 0x558c */
        {8,	0}, 	/* 0x558d */
        {8,	0}, 	/* 0x558e */
        {8,	0}, 	/* 0x558f */
        {8,	0}, 	/* 0x5590 */
        {8,	0}, 	/* 0x5591 */
        {8,	0}, 	/* 0x5592 */
        {8,	0}, 	/* 0x5593 */
        {8,	0}, 	/* 0x5594 */
        {8,	0}, 	/* 0x5595 */
        {8,	0}, 	/* 0x5596 */
        {8,	0}, 	/* 0x5597 */
        {8,	0}, 	/* 0x5598 */
        {8,	0}, 	/* 0x5599 */
        {8,	0}, 	/* 0x559a */
        {8,	0}, 	/* 0x559b */
        {8,	0}, 	/* 0x559c */
        {8,	0}, 	/* 0x559d */
        {8,	0}, 	/* 0x559e */
        {8,	0}, 	/* 0x559f */
        {8,	0}, 	/* 0x55a0 */
        {8,	0}, 	/* 0x55a1 */
        {8,	0}, 	/* 0x55a2 */
        {8,	0}, 	/* 0x55a3 */
        {8,	0}, 	/* 0x55a4 */
        {8,	0}, 	/* 0x55a5 */
        {8,	0}, 	/* 0x55a6 */
        {8,	0}, 	/* 0x55a7 */
        {8,	0}, 	/* 0x55a8 */
        {8,	0}, 	/* 0x55a9 */
        {8,	0}, 	/* 0x55aa */
        {8,	0}, 	/* 0x55ab */
        {8,	0}, 	/* 0x55ac */
        {8,	0}, 	/* 0x55ad */
        {8,	0}, 	/* 0x55ae */
        {8,	0}, 	/* 0x55af */
        {8,	0}, 	/* 0x55b0 */
        {8,	0}, 	/* 0x55b1 */
        {8,	0}, 	/* 0x55b2 */
        {8,	0}, 	/* 0x55b3 */
        {8,	0}, 	/* 0x55b4 */
        {8,	0}, 	/* 0x55b5 */
        {8,	0}, 	/* 0x55b6 */
        {8,	0}, 	/* 0x55b7 */
        {8,	0}, 	/* 0x55b8 */
        {8,	0}, 	/* 0x55b9 */
        {8,	0}, 	/* 0x55ba */
        {8,	0}, 	/* 0x55bb */
        {8,	0}, 	/* 0x55bc */
        {8,	0}, 	/* 0x55bd */
        {8,	0}, 	/* 0x55be */
        {8,	0}, 	/* 0x55bf */
        {8,	0}, 	/* 0x55c0 */
        {8,	0}, 	/* 0x55c1 */
        {8,	0}, 	/* 0x55c2 */
        {8,	0}, 	/* 0x55c3 */
        {8,	0}, 	/* 0x55c4 */
        {8,	0}, 	/* 0x55c5 */
        {8,	0}, 	/* 0x55c6 */
        {8,	0}, 	/* 0x55c7 */
        {8,	0}, 	/* 0x55c8 */
        {8,	0}, 	/* 0x55c9 */
        {8,	0}, 	/* 0x55ca */
        {8,	0}, 	/* 0x55cb */
        {8,	0}, 	/* 0x55cc */
        {8,	0}, 	/* 0x55cd */
        {8,	0}, 	/* 0x55ce */
        {8,	0}, 	/* 0x55cf */
        {8,	0}, 	/* 0x55d0 */
        {8,	0}, 	/* 0x55d1 */
        {8,	0}, 	/* 0x55d2 */
        {8,	0}, 	/* 0x55d3 */
        {8,	0}, 	/* 0x55d4 */
        {8,	0}, 	/* 0x55d5 */
        {8,	0}, 	/* 0x55d6 */
        {8,	0}, 	/* 0x55d7 */
        {8,	0}, 	/* 0x55d8 */
        {8,	0}, 	/* 0x55d9 */
        {8,	0}, 	/* 0x55da */
        {8,	0}, 	/* 0x55db */
        {8,	0}, 	/* 0x55dc */
        {8,	0}, 	/* 0x55dd */
        {8,	0}, 	/* 0x55de */
        {8,	0}, 	/* 0x55df */
        {8,	0}, 	/* 0x55e0 */
        {8,	0}, 	/* 0x55e1 */
        {8,	0}, 	/* 0x55e2 */
        {8,	0}, 	/* 0x55e3 */
        {8,	0}, 	/* 0x55e4 */
        {8,	0}, 	/* 0x55e5 */
        {8,	0}, 	/* 0x55e6 */
        {8,	0}, 	/* 0x55e7 */
        {8,	0}, 	/* 0x55e8 */
        {8,	0}, 	/* 0x55e9 */
        {8,	0}, 	/* 0x55ea */
        {8,	0}, 	/* 0x55eb */
        {8,	0}, 	/* 0x55ec */
        {8,	0}, 	/* 0x55ed */
        {8,	0}, 	/* 0x55ee */
        {8,	0}, 	/* 0x55ef */
        {8,	0}, 	/* 0x55f0 */
        {8,	0}, 	/* 0x55f1 */
        {8,	0}, 	/* 0x55f2 */
        {8,	0}, 	/* 0x55f3 */
        {8,	0}, 	/* 0x55f4 */
        {8,	0}, 	/* 0x55f5 */
        {8,	0}, 	/* 0x55f6 */
        {8,	0}, 	/* 0x55f7 */
        {8,	0}, 	/* 0x55f8 */
        {8,	0}, 	/* 0x55f9 */
        {8,	0}, 	/* 0x55fa */
        {8,	0}, 	/* 0x55fb */
        {8,	0}, 	/* 0x55fc */
        {8,	0}, 	/* 0x55fd */
        {8,	0}, 	/* 0x55fe */
        {8,	0}, 	/* 0x55ff */
        {8,	0}, 	/* 0x5600 */
        {8,	0}, 	/* 0x5601 */
        {8,	0}, 	/* 0x5602 */
        {8,	0}, 	/* 0x5603 */
        {8,	0}, 	/* 0x5604 */
        {8,	0}, 	/* 0x5605 */
        {8,	0}, 	/* 0x5606 */
        {8,	0}, 	/* 0x5607 */
        {8,	0}, 	/* 0x5608 */
        {8,	0}, 	/* 0x5609 */
        {8,	0}, 	/* 0x560a */
        {8,	0}, 	/* 0x560b */
        {8,	0}, 	/* 0x560c */
        {8,	0}, 	/* 0x560d */
        {8,	0}, 	/* 0x560e */
        {8,	0}, 	/* 0x560f */
        {8,	0}, 	/* 0x5610 */
        {8,	0}, 	/* 0x5611 */
        {8,	0}, 	/* 0x5612 */
        {8,	0}, 	/* 0x5613 */
        {8,	0}, 	/* 0x5614 */
        {8,	0}, 	/* 0x5615 */
        {8,	0}, 	/* 0x5616 */
        {8,	0}, 	/* 0x5617 */
        {8,	0}, 	/* 0x5618 */
        {8,	0}, 	/* 0x5619 */
        {8,	0}, 	/* 0x561a */
        {8,	0}, 	/* 0x561b */
        {8,	0}, 	/* 0x561c */
        {8,	0}, 	/* 0x561d */
        {8,	0}, 	/* 0x561e */
        {8,	0}, 	/* 0x561f */
        {8,	0}, 	/* 0x5620 */
        {8,	0}, 	/* 0x5621 */
        {8,	0}, 	/* 0x5622 */
        {8,	0}, 	/* 0x5623 */
        {8,	0}, 	/* 0x5624 */
        {8,	0}, 	/* 0x5625 */
        {8,	0}, 	/* 0x5626 */
        {8,	0}, 	/* 0x5627 */
        {8,	0}, 	/* 0x5628 */
        {8,	0}, 	/* 0x5629 */
        {8,	0}, 	/* 0x562a */
        {8,	0}, 	/* 0x562b */
        {8,	0}, 	/* 0x562c */
        {8,	0}, 	/* 0x562d */
        {8,	0}, 	/* 0x562e */
        {8,	0}, 	/* 0x562f */
        {8,	0}, 	/* 0x5630 */
        {8,	0}, 	/* 0x5631 */
        {8,	0}, 	/* 0x5632 */
        {8,	0}, 	/* 0x5633 */
        {8,	0}, 	/* 0x5634 */
        {8,	0}, 	/* 0x5635 */
        {8,	0}, 	/* 0x5636 */
        {8,	0}, 	/* 0x5637 */
        {8,	0}, 	/* 0x5638 */
        {8,	0}, 	/* 0x5639 */
        {8,	0}, 	/* 0x563a */
        {8,	0}, 	/* 0x563b */
        {8,	0}, 	/* 0x563c */
        {8,	0}, 	/* 0x563d */
        {8,	0}, 	/* 0x563e */
        {8,	0}, 	/* 0x563f */
        {8,	0}, 	/* 0x5640 */
        {8,	0}, 	/* 0x5641 */
        {8,	0}, 	/* 0x5642 */
        {8,	0}, 	/* 0x5643 */
        {8,	0}, 	/* 0x5644 */
        {8,	0}, 	/* 0x5645 */
        {8,	0}, 	/* 0x5646 */
        {8,	0}, 	/* 0x5647 */
        {8,	0}, 	/* 0x5648 */
        {8,	0}, 	/* 0x5649 */
        {8,	0}, 	/* 0x564a */
        {8,	0}, 	/* 0x564b */
        {8,	0}, 	/* 0x564c */
        {8,	0}, 	/* 0x564d */
        {8,	0}, 	/* 0x564e */
        {8,	0}, 	/* 0x564f */
        {8,	0}, 	/* 0x5650 */
        {8,	0}, 	/* 0x5651 */
        {8,	0}, 	/* 0x5652 */
        {8,	0}, 	/* 0x5653 */
        {8,	0}, 	/* 0x5654 */
        {8,	0}, 	/* 0x5655 */
        {8,	0}, 	/* 0x5656 */
        {8,	0}, 	/* 0x5657 */
        {8,	0}, 	/* 0x5658 */
        {8,	0}, 	/* 0x5659 */
        {8,	0}, 	/* 0x565a */
        {8,	0}, 	/* 0x565b */
        {8,	0}, 	/* 0x565c */
        {8,	0}, 	/* 0x565d */
        {8,	0}, 	/* 0x565e */
        {8,	0}, 	/* 0x565f */
        {8,	0}, 	/* 0x5660 */
        {8,	0}, 	/* 0x5661 */
        {8,	0}, 	/* 0x5662 */
        {8,	0}, 	/* 0x5663 */
        {8,	0}, 	/* 0x5664 */
        {8,	0}, 	/* 0x5665 */
        {8,	0}, 	/* 0x5666 */
        {8,	0}, 	/* 0x5667 */
        {8,	0}, 	/* 0x5668 */
        {8,	0}, 	/* 0x5669 */
        {8,	0}, 	/* 0x566a */
        {8,	0}, 	/* 0x566b */
        {8,	0}, 	/* 0x566c */
        {8,	0}, 	/* 0x566d */
        {8,	0}, 	/* 0x566e */
        {8,	0}, 	/* 0x566f */
        {8,	0}, 	/* 0x5670 */
        {8,	0}, 	/* 0x5671 */
        {8,	0}, 	/* 0x5672 */
        {8,	0}, 	/* 0x5673 */
        {8,	0}, 	/* 0x5674 */
        {8,	0}, 	/* 0x5675 */
        {8,	0}, 	/* 0x5676 */
        {8,	0}, 	/* 0x5677 */
        {8,	0}, 	/* 0x5678 */
        {8,	0}, 	/* 0x5679 */
        {8,	0}, 	/* 0x567a */
        {8,	0}, 	/* 0x567b */
        {8,	0}, 	/* 0x567c */
        {8,	0}, 	/* 0x567d */
        {8,	0}, 	/* 0x567e */
        {8,	0}, 	/* 0x567f */
        {8,	0}, 	/* 0x5680 */
        {8,	0}, 	/* 0x5681 */
        {8,	0}, 	/* 0x5682 */
        {8,	0}, 	/* 0x5683 */
        {8,	0}, 	/* 0x5684 */
        {8,	0}, 	/* 0x5685 */
        {8,	0}, 	/* 0x5686 */
        {8,	0}, 	/* 0x5687 */
        {8,	0}, 	/* 0x5688 */
        {8,	0}, 	/* 0x5689 */
        {8,	0}, 	/* 0x568a */
        {8,	0}, 	/* 0x568b */
        {8,	0}, 	/* 0x568c */
        {8,	0}, 	/* 0x568d */
        {8,	0}, 	/* 0x568e */
        {8,	0}, 	/* 0x568f */
        {8,	0}, 	/* 0x5690 */
        {8,	0}, 	/* 0x5691 */
        {8,	0}, 	/* 0x5692 */
        {8,	0}, 	/* 0x5693 */
        {8,	0}, 	/* 0x5694 */
        {8,	0}, 	/* 0x5695 */
        {8,	0}, 	/* 0x5696 */
        {8,	0}, 	/* 0x5697 */
        {8,	0}, 	/* 0x5698 */
        {8,	0}, 	/* 0x5699 */
        {8,	0}, 	/* 0x569a */
        {8,	0}, 	/* 0x569b */
        {8,	0}, 	/* 0x569c */
        {8,	0}, 	/* 0x569d */
        {8,	0}, 	/* 0x569e */
        {8,	0}, 	/* 0x569f */
        {8,	0}, 	/* 0x56a0 */
        {8,	0}, 	/* 0x56a1 */
        {8,	0}, 	/* 0x56a2 */
        {8,	0}, 	/* 0x56a3 */
        {8,	0}, 	/* 0x56a4 */
        {8,	0}, 	/* 0x56a5 */
        {8,	0}, 	/* 0x56a6 */
        {8,	0}, 	/* 0x56a7 */
        {8,	0}, 	/* 0x56a8 */
        {8,	0}, 	/* 0x56a9 */
        {8,	0}, 	/* 0x56aa */
        {8,	0}, 	/* 0x56ab */
        {8,	0}, 	/* 0x56ac */
        {8,	0}, 	/* 0x56ad */
        {8,	0}, 	/* 0x56ae */
        {8,	0}, 	/* 0x56af */
        {8,	0}, 	/* 0x56b0 */
        {8,	0}, 	/* 0x56b1 */
        {8,	0}, 	/* 0x56b2 */
        {8,	0}, 	/* 0x56b3 */
        {8,	0}, 	/* 0x56b4 */
        {8,	0}, 	/* 0x56b5 */
        {8,	0}, 	/* 0x56b6 */
        {8,	0}, 	/* 0x56b7 */
        {8,	0}, 	/* 0x56b8 */
        {8,	0}, 	/* 0x56b9 */
        {8,	0}, 	/* 0x56ba */
        {8,	0}, 	/* 0x56bb */
        {8,	0}, 	/* 0x56bc */
        {8,	0}, 	/* 0x56bd */
        {8,	0}, 	/* 0x56be */
        {8,	0}, 	/* 0x56bf */
        {8,	0}, 	/* 0x56c0 */
        {8,	0}, 	/* 0x56c1 */
        {8,	0}, 	/* 0x56c2 */
        {8,	0}, 	/* 0x56c3 */
        {8,	0}, 	/* 0x56c4 */
        {8,	0}, 	/* 0x56c5 */
        {8,	0}, 	/* 0x56c6 */
        {8,	0}, 	/* 0x56c7 */
        {8,	0}, 	/* 0x56c8 */
        {8,	0}, 	/* 0x56c9 */
        {8,	0}, 	/* 0x56ca */
        {8,	0}, 	/* 0x56cb */
        {8,	0}, 	/* 0x56cc */
        {8,	0}, 	/* 0x56cd */
        {8,	0}, 	/* 0x56ce */
        {8,	0}, 	/* 0x56cf */
        {8,	0}, 	/* 0x56d0 */
        {8,	0}, 	/* 0x56d1 */
        {8,	0}, 	/* 0x56d2 */
        {8,	0}, 	/* 0x56d3 */
        {8,	0}, 	/* 0x56d4 */
        {8,	0}, 	/* 0x56d5 */
        {8,	0}, 	/* 0x56d6 */
        {8,	0}, 	/* 0x56d7 */
        {8,	0}, 	/* 0x56d8 */
        {8,	0}, 	/* 0x56d9 */
        {8,	0}, 	/* 0x56da */
        {8,	0}, 	/* 0x56db */
        {8,	0}, 	/* 0x56dc */
        {8,	0}, 	/* 0x56dd */
        {8,	0}, 	/* 0x56de */
        {8,	0}, 	/* 0x56df */
        {8,	0}, 	/* 0x56e0 */
        {8,	0}, 	/* 0x56e1 */
        {8,	0}, 	/* 0x56e2 */
        {8,	0}, 	/* 0x56e3 */
        {8,	0}, 	/* 0x56e4 */
        {8,	0}, 	/* 0x56e5 */
        {8,	0}, 	/* 0x56e6 */
        {8,	0}, 	/* 0x56e7 */
        {8,	0}, 	/* 0x56e8 */
        {8,	0}, 	/* 0x56e9 */
        {8,	0}, 	/* 0x56ea */
        {8,	0}, 	/* 0x56eb */
        {8,	0}, 	/* 0x56ec */
        {8,	0}, 	/* 0x56ed */
        {8,	0}, 	/* 0x56ee */
        {8,	0}, 	/* 0x56ef */
        {8,	0}, 	/* 0x56f0 */
        {8,	0}, 	/* 0x56f1 */
        {8,	0}, 	/* 0x56f2 */
        {8,	0}, 	/* 0x56f3 */
        {8,	0}, 	/* 0x56f4 */
        {8,	0}, 	/* 0x56f5 */
        {8,	0}, 	/* 0x56f6 */
        {8,	0}, 	/* 0x56f7 */
        {8,	0}, 	/* 0x56f8 */
        {8,	0}, 	/* 0x56f9 */
        {8,	0}, 	/* 0x56fa */
        {8,	0}, 	/* 0x56fb */
        {8,	0}, 	/* 0x56fc */
        {8,	0}, 	/* 0x56fd */
        {8,	0}, 	/* 0x56fe */
        {8,	0}, 	/* 0x56ff */
        {8,	0}, 	/* 0x5700 */
        {8,	0}, 	/* 0x5701 */
        {8,	0}, 	/* 0x5702 */
        {8,	0}, 	/* 0x5703 */
        {8,	0}, 	/* 0x5704 */
        {8,	0}, 	/* 0x5705 */
        {8,	0}, 	/* 0x5706 */
        {8,	0}, 	/* 0x5707 */
        {8,	0}, 	/* 0x5708 */
        {8,	0}, 	/* 0x5709 */
        {8,	0}, 	/* 0x570a */
        {8,	0}, 	/* 0x570b */
        {8,	0}, 	/* 0x570c */
        {8,	0}, 	/* 0x570d */
        {8,	0}, 	/* 0x570e */
        {8,	0}, 	/* 0x570f */
        {8,	0}, 	/* 0x5710 */
        {8,	0}, 	/* 0x5711 */
        {8,	0}, 	/* 0x5712 */
        {8,	0}, 	/* 0x5713 */
        {8,	0}, 	/* 0x5714 */
        {8,	0}, 	/* 0x5715 */
        {8,	0}, 	/* 0x5716 */
        {8,	0}, 	/* 0x5717 */
        {8,	0}, 	/* 0x5718 */
        {8,	0}, 	/* 0x5719 */
        {8,	0}, 	/* 0x571a */
        {8,	0}, 	/* 0x571b */
        {8,	0}, 	/* 0x571c */
        {8,	0}, 	/* 0x571d */
        {8,	0}, 	/* 0x571e */
        {8,	0}, 	/* 0x571f */
        {8,	0}, 	/* 0x5720 */
        {8,	0}, 	/* 0x5721 */
        {8,	0}, 	/* 0x5722 */
        {8,	0}, 	/* 0x5723 */
        {8,	0}, 	/* 0x5724 */
        {8,	0}, 	/* 0x5725 */
        {8,	0}, 	/* 0x5726 */
        {8,	0}, 	/* 0x5727 */
        {8,	0}, 	/* 0x5728 */
        {8,	0}, 	/* 0x5729 */
        {8,	0}, 	/* 0x572a */
        {8,	0}, 	/* 0x572b */
        {8,	0}, 	/* 0x572c */
        {8,	0}, 	/* 0x572d */
        {8,	0}, 	/* 0x572e */
        {8,	0}, 	/* 0x572f */
        {8,	0}, 	/* 0x5730 */
        {8,	0}, 	/* 0x5731 */
        {8,	0}, 	/* 0x5732 */
        {8,	0}, 	/* 0x5733 */
        {8,	0}, 	/* 0x5734 */
        {8,	0}, 	/* 0x5735 */
        {8,	0}, 	/* 0x5736 */
        {8,	0}, 	/* 0x5737 */
        {8,	0}, 	/* 0x5738 */
        {8,	0}, 	/* 0x5739 */
        {8,	0}, 	/* 0x573a */
        {8,	0}, 	/* 0x573b */
        {8,	0}, 	/* 0x573c */
        {8,	0}, 	/* 0x573d */
        {8,	0}, 	/* 0x573e */
        {8,	0}, 	/* 0x573f */
        {8,	0}, 	/* 0x5740 */
        {8,	0}, 	/* 0x5741 */
        {8,	0}, 	/* 0x5742 */
        {8,	0}, 	/* 0x5743 */
        {8,	0}, 	/* 0x5744 */
        {8,	0}, 	/* 0x5745 */
        {8,	0}, 	/* 0x5746 */
        {8,	0}, 	/* 0x5747 */
        {8,	0}, 	/* 0x5748 */
        {8,	0}, 	/* 0x5749 */
        {8,	0}, 	/* 0x574a */
        {8,	0}, 	/* 0x574b */
        {8,	0}, 	/* 0x574c */
        {8,	0}, 	/* 0x574d */
        {8,	0}, 	/* 0x574e */
        {8,	0}, 	/* 0x574f */
        {8,	0}, 	/* 0x5750 */
        {8,	0}, 	/* 0x5751 */
        {8,	0}, 	/* 0x5752 */
        {8,	0}, 	/* 0x5753 */
        {8,	0}, 	/* 0x5754 */
        {8,	0}, 	/* 0x5755 */
        {8,	0}, 	/* 0x5756 */
        {8,	0}, 	/* 0x5757 */
        {8,	0}, 	/* 0x5758 */
        {8,	0}, 	/* 0x5759 */
        {8,	0}, 	/* 0x575a */
        {8,	0}, 	/* 0x575b */
        {8,	0}, 	/* 0x575c */
        {8,	0}, 	/* 0x575d */
        {8,	0}, 	/* 0x575e */
        {8,	0}, 	/* 0x575f */
        {8,	0}, 	/* 0x5760 */
        {8,	0}, 	/* 0x5761 */
        {8,	0}, 	/* 0x5762 */
        {8,	0}, 	/* 0x5763 */
        {8,	0}, 	/* 0x5764 */
        {8,	0}, 	/* 0x5765 */
        {8,	0}, 	/* 0x5766 */
        {8,	0}, 	/* 0x5767 */
        {8,	0}, 	/* 0x5768 */
        {8,	0}, 	/* 0x5769 */
        {8,	0}, 	/* 0x576a */
        {8,	0}, 	/* 0x576b */
        {8,	0}, 	/* 0x576c */
        {8,	0}, 	/* 0x576d */
        {8,	0}, 	/* 0x576e */
        {8,	0}, 	/* 0x576f */
        {8,	0}, 	/* 0x5770 */
        {8,	0}, 	/* 0x5771 */
        {8,	0}, 	/* 0x5772 */
        {8,	0}, 	/* 0x5773 */
        {8,	0}, 	/* 0x5774 */
        {8,	0}, 	/* 0x5775 */
        {8,	0}, 	/* 0x5776 */
        {8,	0}, 	/* 0x5777 */
        {8,	0}, 	/* 0x5778 */
        {8,	0}, 	/* 0x5779 */
        {8,	0}, 	/* 0x577a */
        {8,	0}, 	/* 0x577b */
        {8,	0}, 	/* 0x577c */
        {8,	0}, 	/* 0x577d */
        {8,	0}, 	/* 0x577e */
        {8,	0}, 	/* 0x577f */
        {8,	0}, 	/* 0x5780 */
        {8,	0}, 	/* 0x5781 */
        {8,	0}, 	/* 0x5782 */
        {8,	0}, 	/* 0x5783 */
        {8,	0}, 	/* 0x5784 */
        {8,	0}, 	/* 0x5785 */
        {8,	0}, 	/* 0x5786 */
        {8,	0}, 	/* 0x5787 */
        {8,	0}, 	/* 0x5788 */
        {8,	0}, 	/* 0x5789 */
        {8,	0}, 	/* 0x578a */
        {8,	0}, 	/* 0x578b */
        {8,	0}, 	/* 0x578c */
        {8,	0}, 	/* 0x578d */
        {8,	0}, 	/* 0x578e */
        {8,	0}, 	/* 0x578f */
        {8,	0}, 	/* 0x5790 */
        {8,	0}, 	/* 0x5791 */
        {8,	0}, 	/* 0x5792 */
        {8,	0}, 	/* 0x5793 */
        {8,	0}, 	/* 0x5794 */
        {8,	0}, 	/* 0x5795 */
        {8,	0}, 	/* 0x5796 */
        {8,	0}, 	/* 0x5797 */
        {8,	0}, 	/* 0x5798 */
        {8,	0}, 	/* 0x5799 */
        {8,	0}, 	/* 0x579a */
        {8,	0}, 	/* 0x579b */
        {8,	0}, 	/* 0x579c */
        {8,	0}, 	/* 0x579d */
        {8,	0}, 	/* 0x579e */
        {8,	0}, 	/* 0x579f */
        {8,	0}, 	/* 0x57a0 */
        {8,	0}, 	/* 0x57a1 */
        {8,	0}, 	/* 0x57a2 */
        {8,	0}, 	/* 0x57a3 */
        {8,	0}, 	/* 0x57a4 */
        {8,	0}, 	/* 0x57a5 */
        {8,	0}, 	/* 0x57a6 */
        {8,	0}, 	/* 0x57a7 */
        {8,	0}, 	/* 0x57a8 */
        {8,	0}, 	/* 0x57a9 */
        {8,	0}, 	/* 0x57aa */
        {8,	0}, 	/* 0x57ab */
        {8,	0}, 	/* 0x57ac */
        {8,	0}, 	/* 0x57ad */
        {8,	0}, 	/* 0x57ae */
        {8,	0}, 	/* 0x57af */
        {8,	0}, 	/* 0x57b0 */
        {8,	0}, 	/* 0x57b1 */
        {8,	0}, 	/* 0x57b2 */
        {8,	0}, 	/* 0x57b3 */
        {8,	0}, 	/* 0x57b4 */
        {8,	0}, 	/* 0x57b5 */
        {8,	0}, 	/* 0x57b6 */
        {8,	0}, 	/* 0x57b7 */
        {8,	0}, 	/* 0x57b8 */
        {8,	0}, 	/* 0x57b9 */
        {8,	0}, 	/* 0x57ba */
        {8,	0}, 	/* 0x57bb */
        {8,	0}, 	/* 0x57bc */
        {8,	0}, 	/* 0x57bd */
        {8,	0}, 	/* 0x57be */
        {8,	0}, 	/* 0x57bf */
        {8,	0}, 	/* 0x57c0 */
        {8,	0}, 	/* 0x57c1 */
        {8,	0}, 	/* 0x57c2 */
        {8,	0}, 	/* 0x57c3 */
        {8,	0}, 	/* 0x57c4 */
        {8,	0}, 	/* 0x57c5 */
        {8,	0}, 	/* 0x57c6 */
        {8,	0}, 	/* 0x57c7 */
        {8,	0}, 	/* 0x57c8 */
        {8,	0}, 	/* 0x57c9 */
        {8,	0}, 	/* 0x57ca */
        {8,	0}, 	/* 0x57cb */
        {8,	0}, 	/* 0x57cc */
        {8,	0}, 	/* 0x57cd */
        {8,	0}, 	/* 0x57ce */
        {8,	0}, 	/* 0x57cf */
        {8,	0}, 	/* 0x57d0 */
        {8,	0}, 	/* 0x57d1 */
        {8,	0}, 	/* 0x57d2 */
        {8,	0}, 	/* 0x57d3 */
        {8,	0}, 	/* 0x57d4 */
        {8,	0}, 	/* 0x57d5 */
        {8,	0}, 	/* 0x57d6 */
        {8,	0}, 	/* 0x57d7 */
        {8,	0}, 	/* 0x57d8 */
        {8,	0}, 	/* 0x57d9 */
        {8,	0}, 	/* 0x57da */
        {8,	0}, 	/* 0x57db */
        {8,	0}, 	/* 0x57dc */
        {8,	0}, 	/* 0x57dd */
        {8,	0}, 	/* 0x57de */
        {8,	0}, 	/* 0x57df */
        {8,	0}, 	/* 0x57e0 */
        {8,	0}, 	/* 0x57e1 */
        {8,	0}, 	/* 0x57e2 */
        {8,	0}, 	/* 0x57e3 */
        {8,	0}, 	/* 0x57e4 */
        {8,	0}, 	/* 0x57e5 */
        {8,	0}, 	/* 0x57e6 */
        {8,	0}, 	/* 0x57e7 */
        {8,	0}, 	/* 0x57e8 */
        {8,	0}, 	/* 0x57e9 */
        {8,	0}, 	/* 0x57ea */
        {8,	0}, 	/* 0x57eb */
        {8,	0}, 	/* 0x57ec */
        {8,	0}, 	/* 0x57ed */
        {8,	0}, 	/* 0x57ee */
        {8,	0}, 	/* 0x57ef */
        {8,	0}, 	/* 0x57f0 */
        {8,	0}, 	/* 0x57f1 */
        {8,	0}, 	/* 0x57f2 */
        {8,	0}, 	/* 0x57f3 */
        {8,	0}, 	/* 0x57f4 */
        {8,	0}, 	/* 0x57f5 */
        {8,	0}, 	/* 0x57f6 */
        {8,	0}, 	/* 0x57f7 */
        {8,	0}, 	/* 0x57f8 */
        {8,	0}, 	/* 0x57f9 */
        {8,	0}, 	/* 0x57fa */
        {8,	0}, 	/* 0x57fb */
        {8,	0}, 	/* 0x57fc */
        {8,	0}, 	/* 0x57fd */
        {8,	0}, 	/* 0x57fe */
        {8,	0}, 	/* 0x57ff */
        {8,	0}, 	/* 0x5800 */
        {8,	0}, 	/* 0x5801 */
        {8,	0}, 	/* 0x5802 */
        {8,	0}, 	/* 0x5803 */
        {8,	0}, 	/* 0x5804 */
        {8,	0}, 	/* 0x5805 */
        {8,	0}, 	/* 0x5806 */
        {8,	0}, 	/* 0x5807 */
        {8,	0}, 	/* 0x5808 */
        {8,	0}, 	/* 0x5809 */
        {8,	0}, 	/* 0x580a */
        {8,	0}, 	/* 0x580b */
        {8,	0}, 	/* 0x580c */
        {8,	0}, 	/* 0x580d */
        {8,	0}, 	/* 0x580e */
        {8,	0}, 	/* 0x580f */
        {8,	0}, 	/* 0x5810 */
        {8,	0}, 	/* 0x5811 */
        {8,	0}, 	/* 0x5812 */
        {8,	0}, 	/* 0x5813 */
        {8,	0}, 	/* 0x5814 */
        {8,	0}, 	/* 0x5815 */
        {8,	0}, 	/* 0x5816 */
        {8,	0}, 	/* 0x5817 */
        {8,	0}, 	/* 0x5818 */
        {8,	0}, 	/* 0x5819 */
        {8,	0}, 	/* 0x581a */
        {8,	0}, 	/* 0x581b */
        {8,	0}, 	/* 0x581c */
        {8,	0}, 	/* 0x581d */
        {8,	0}, 	/* 0x581e */
        {8,	0}, 	/* 0x581f */
        {8,	0}, 	/* 0x5820 */
        {8,	0}, 	/* 0x5821 */
        {8,	0}, 	/* 0x5822 */
        {8,	0}, 	/* 0x5823 */
        {8,	0}, 	/* 0x5824 */
        {8,	0}, 	/* 0x5825 */
        {8,	0}, 	/* 0x5826 */
        {8,	0}, 	/* 0x5827 */
        {8,	0}, 	/* 0x5828 */
        {8,	0}, 	/* 0x5829 */
        {8,	0}, 	/* 0x582a */
        {8,	0}, 	/* 0x582b */
        {8,	0}, 	/* 0x582c */
        {8,	0}, 	/* 0x582d */
        {8,	0}, 	/* 0x582e */
        {8,	0}, 	/* 0x582f */
        {8,	0}, 	/* 0x5830 */
        {8,	0}, 	/* 0x5831 */
        {8,	0}, 	/* 0x5832 */
        {8,	0}, 	/* 0x5833 */
        {8,	0}, 	/* 0x5834 */
        {8,	0}, 	/* 0x5835 */
        {8,	0}, 	/* 0x5836 */
        {8,	0}, 	/* 0x5837 */
        {8,	0}, 	/* 0x5838 */
        {8,	0}, 	/* 0x5839 */
        {8,	0}, 	/* 0x583a */
        {8,	0}, 	/* 0x583b */
        {8,	0}, 	/* 0x583c */
        {8,	0}, 	/* 0x583d */
        {8,	0}, 	/* 0x583e */
        {8,	0}, 	/* 0x583f */
        {8,	0}, 	/* 0x5840 */
        {8,	0}, 	/* 0x5841 */
        {8,	0}, 	/* 0x5842 */
        {8,	0}, 	/* 0x5843 */
        {8,	0}, 	/* 0x5844 */
        {8,	0}, 	/* 0x5845 */
        {8,	0}, 	/* 0x5846 */
        {8,	0}, 	/* 0x5847 */
        {8,	0}, 	/* 0x5848 */
        {8,	0}, 	/* 0x5849 */
        {8,	0}, 	/* 0x584a */
        {8,	0}, 	/* 0x584b */
        {8,	0}, 	/* 0x584c */
        {8,	0}, 	/* 0x584d */
        {8,	0}, 	/* 0x584e */
        {8,	0}, 	/* 0x584f */
        {8,	0}, 	/* 0x5850 */
        {8,	0}, 	/* 0x5851 */
        {8,	0}, 	/* 0x5852 */
        {8,	0}, 	/* 0x5853 */
        {8,	0}, 	/* 0x5854 */
        {8,	0}, 	/* 0x5855 */
        {8,	0}, 	/* 0x5856 */
        {8,	0}, 	/* 0x5857 */
        {8,	0}, 	/* 0x5858 */
        {8,	0}, 	/* 0x5859 */
        {8,	0}, 	/* 0x585a */
        {8,	0}, 	/* 0x585b */
        {8,	0}, 	/* 0x585c */
        {8,	0}, 	/* 0x585d */
        {8,	0}, 	/* 0x585e */
        {8,	0}, 	/* 0x585f */
        {8,	0}, 	/* 0x5860 */
        {8,	0}, 	/* 0x5861 */
        {8,	0}, 	/* 0x5862 */
        {8,	0}, 	/* 0x5863 */
        {8,	0}, 	/* 0x5864 */
        {8,	0}, 	/* 0x5865 */
        {8,	0}, 	/* 0x5866 */
        {8,	0}, 	/* 0x5867 */
        {8,	0}, 	/* 0x5868 */
        {8,	0}, 	/* 0x5869 */
        {8,	0}, 	/* 0x586a */
        {8,	0}, 	/* 0x586b */
        {8,	0}, 	/* 0x586c */
        {8,	0}, 	/* 0x586d */
        {8,	0}, 	/* 0x586e */
        {8,	0}, 	/* 0x586f */
        {8,	0}, 	/* 0x5870 */
        {8,	0}, 	/* 0x5871 */
        {8,	0}, 	/* 0x5872 */
        {8,	0}, 	/* 0x5873 */
        {8,	0}, 	/* 0x5874 */
        {8,	0}, 	/* 0x5875 */
        {8,	0}, 	/* 0x5876 */
        {8,	0}, 	/* 0x5877 */
        {8,	0}, 	/* 0x5878 */
        {8,	0}, 	/* 0x5879 */
        {8,	0}, 	/* 0x587a */
        {8,	0}, 	/* 0x587b */
        {8,	0}, 	/* 0x587c */
        {8,	0}, 	/* 0x587d */
        {8,	0}, 	/* 0x587e */
        {8,	0}, 	/* 0x587f */
        {8,	0}, 	/* 0x5880 */
        {8,	0}, 	/* 0x5881 */
        {8,	0}, 	/* 0x5882 */
        {8,	0}, 	/* 0x5883 */
        {8,	0}, 	/* 0x5884 */
        {8,	0}, 	/* 0x5885 */
        {8,	0}, 	/* 0x5886 */
        {8,	0}, 	/* 0x5887 */
        {8,	0}, 	/* 0x5888 */
        {8,	0}, 	/* 0x5889 */
        {8,	0}, 	/* 0x588a */
        {8,	0}, 	/* 0x588b */
        {8,	0}, 	/* 0x588c */
        {8,	0}, 	/* 0x588d */
        {8,	0}, 	/* 0x588e */
        {8,	0}, 	/* 0x588f */
        {8,	0}, 	/* 0x5890 */
        {8,	0}, 	/* 0x5891 */
        {8,	0}, 	/* 0x5892 */
        {8,	0}, 	/* 0x5893 */
        {8,	0}, 	/* 0x5894 */
        {8,	0}, 	/* 0x5895 */
        {8,	0}, 	/* 0x5896 */
        {8,	0}, 	/* 0x5897 */
        {8,	0}, 	/* 0x5898 */
        {8,	0}, 	/* 0x5899 */
        {8,	0}, 	/* 0x589a */
        {8,	0}, 	/* 0x589b */
        {8,	0}, 	/* 0x589c */
        {8,	0}, 	/* 0x589d */
        {8,	0}, 	/* 0x589e */
        {8,	0}, 	/* 0x589f */
        {8,	0}, 	/* 0x58a0 */
        {8,	0}, 	/* 0x58a1 */
        {8,	0}, 	/* 0x58a2 */
        {8,	0}, 	/* 0x58a3 */
        {8,	0}, 	/* 0x58a4 */
        {8,	0}, 	/* 0x58a5 */
        {8,	0}, 	/* 0x58a6 */
        {8,	0}, 	/* 0x58a7 */
        {8,	0}, 	/* 0x58a8 */
        {8,	0}, 	/* 0x58a9 */
        {8,	0}, 	/* 0x58aa */
        {8,	0}, 	/* 0x58ab */
        {8,	0}, 	/* 0x58ac */
        {8,	0}, 	/* 0x58ad */
        {8,	0}, 	/* 0x58ae */
        {8,	0}, 	/* 0x58af */
        {8,	0}, 	/* 0x58b0 */
        {8,	0}, 	/* 0x58b1 */
        {8,	0}, 	/* 0x58b2 */
        {8,	0}, 	/* 0x58b3 */
        {8,	0}, 	/* 0x58b4 */
        {8,	0}, 	/* 0x58b5 */
        {8,	0}, 	/* 0x58b6 */
        {8,	0}, 	/* 0x58b7 */
        {8,	0}, 	/* 0x58b8 */
        {8,	0}, 	/* 0x58b9 */
        {8,	0}, 	/* 0x58ba */
        {8,	0}, 	/* 0x58bb */
        {8,	0}, 	/* 0x58bc */
        {8,	0}, 	/* 0x58bd */
        {8,	0}, 	/* 0x58be */
        {8,	0}, 	/* 0x58bf */
        {8,	0}, 	/* 0x58c0 */
        {8,	0}, 	/* 0x58c1 */
        {8,	0}, 	/* 0x58c2 */
        {8,	0}, 	/* 0x58c3 */
        {8,	0}, 	/* 0x58c4 */
        {8,	0}, 	/* 0x58c5 */
        {8,	0}, 	/* 0x58c6 */
        {8,	0}, 	/* 0x58c7 */
        {8,	0}, 	/* 0x58c8 */
        {8,	0}, 	/* 0x58c9 */
        {8,	0}, 	/* 0x58ca */
        {8,	0}, 	/* 0x58cb */
        {8,	0}, 	/* 0x58cc */
        {8,	0}, 	/* 0x58cd */
        {8,	0}, 	/* 0x58ce */
        {8,	0}, 	/* 0x58cf */
        {8,	0}, 	/* 0x58d0 */
        {8,	0}, 	/* 0x58d1 */
        {8,	0}, 	/* 0x58d2 */
        {8,	0}, 	/* 0x58d3 */
        {8,	0}, 	/* 0x58d4 */
        {8,	0}, 	/* 0x58d5 */
        {8,	0}, 	/* 0x58d6 */
        {8,	0}, 	/* 0x58d7 */
        {8,	0}, 	/* 0x58d8 */
        {8,	0}, 	/* 0x58d9 */
        {8,	0}, 	/* 0x58da */
        {8,	0}, 	/* 0x58db */
        {8,	0}, 	/* 0x58dc */
        {8,	0}, 	/* 0x58dd */
        {8,	0}, 	/* 0x58de */
        {8,	0}, 	/* 0x58df */
        {8,	0}, 	/* 0x58e0 */
        {8,	0}, 	/* 0x58e1 */
        {8,	0}, 	/* 0x58e2 */
        {8,	0}, 	/* 0x58e3 */
        {8,	0}, 	/* 0x58e4 */
        {8,	0}, 	/* 0x58e5 */
        {8,	0}, 	/* 0x58e6 */
        {8,	0}, 	/* 0x58e7 */
        {8,	0}, 	/* 0x58e8 */
        {8,	0}, 	/* 0x58e9 */
        {8,	0}, 	/* 0x58ea */
        {8,	0}, 	/* 0x58eb */
        {8,	0}, 	/* 0x58ec */
        {8,	0}, 	/* 0x58ed */
        {8,	0}, 	/* 0x58ee */
        {8,	0}, 	/* 0x58ef */
        {8,	0}, 	/* 0x58f0 */
        {8,	0}, 	/* 0x58f1 */
        {8,	0}, 	/* 0x58f2 */
        {8,	0}, 	/* 0x58f3 */
        {8,	0}, 	/* 0x58f4 */
        {8,	0}, 	/* 0x58f5 */
        {8,	0}, 	/* 0x58f6 */
        {8,	0}, 	/* 0x58f7 */
        {8,	0}, 	/* 0x58f8 */
        {8,	0}, 	/* 0x58f9 */
        {8,	0}, 	/* 0x58fa */
        {8,	0}, 	/* 0x58fb */
        {8,	0}, 	/* 0x58fc */
        {8,	0}, 	/* 0x58fd */
        {8,	0}, 	/* 0x58fe */
        {8,	0}, 	/* 0x58ff */
        {8,	0}, 	/* 0x5900 */
        {8,	0}, 	/* 0x5901 */
        {8,	0}, 	/* 0x5902 */
        {8,	0}, 	/* 0x5903 */
        {8,	0}, 	/* 0x5904 */
        {8,	0}, 	/* 0x5905 */
        {8,	0}, 	/* 0x5906 */
        {8,	0}, 	/* 0x5907 */
        {8,	0}, 	/* 0x5908 */
        {8,	0}, 	/* 0x5909 */
        {8,	0}, 	/* 0x590a */
        {8,	0}, 	/* 0x590b */
        {8,	0}, 	/* 0x590c */
        {8,	0}, 	/* 0x590d */
        {8,	0}, 	/* 0x590e */
        {8,	0}, 	/* 0x590f */
        {8,	0}, 	/* 0x5910 */
        {8,	0}, 	/* 0x5911 */
        {8,	0}, 	/* 0x5912 */
        {8,	0}, 	/* 0x5913 */
        {8,	0}, 	/* 0x5914 */
        {8,	0}, 	/* 0x5915 */
        {8,	0}, 	/* 0x5916 */
        {8,	0}, 	/* 0x5917 */
        {8,	0}, 	/* 0x5918 */
        {8,	0}, 	/* 0x5919 */
        {8,	0}, 	/* 0x591a */
        {8,	0}, 	/* 0x591b */
        {8,	0}, 	/* 0x591c */
        {8,	0}, 	/* 0x591d */
        {8,	0}, 	/* 0x591e */
        {8,	0}, 	/* 0x591f */
        {8,	0}, 	/* 0x5920 */
        {8,	0}, 	/* 0x5921 */
        {8,	0}, 	/* 0x5922 */
        {8,	0}, 	/* 0x5923 */
        {8,	0}, 	/* 0x5924 */
        {8,	0}, 	/* 0x5925 */
        {8,	0}, 	/* 0x5926 */
        {8,	0}, 	/* 0x5927 */
        {8,	0}, 	/* 0x5928 */
        {8,	0}, 	/* 0x5929 */
        {8,	0}, 	/* 0x592a */
        {8,	0}, 	/* 0x592b */
        {8,	0}, 	/* 0x592c */
        {8,	0}, 	/* 0x592d */
        {8,	0}, 	/* 0x592e */
        {8,	0}, 	/* 0x592f */
        {8,	0}, 	/* 0x5930 */
        {8,	0}, 	/* 0x5931 */
        {8,	0}, 	/* 0x5932 */
        {8,	0}, 	/* 0x5933 */
        {8,	0}, 	/* 0x5934 */
        {8,	0}, 	/* 0x5935 */
        {8,	0}, 	/* 0x5936 */
        {8,	0}, 	/* 0x5937 */
        {8,	0}, 	/* 0x5938 */
        {8,	0}, 	/* 0x5939 */
        {8,	0}, 	/* 0x593a */
        {8,	0}, 	/* 0x593b */
        {8,	0}, 	/* 0x593c */
        {8,	0}, 	/* 0x593d */
        {8,	0}, 	/* 0x593e */
        {8,	0}, 	/* 0x593f */
        {8,	0}, 	/* 0x5940 */
        {8,	0}, 	/* 0x5941 */
        {8,	0}, 	/* 0x5942 */
        {8,	0}, 	/* 0x5943 */
        {8,	0}, 	/* 0x5944 */
        {8,	0}, 	/* 0x5945 */
        {8,	0}, 	/* 0x5946 */
        {8,	0}, 	/* 0x5947 */
        {8,	0}, 	/* 0x5948 */
        {8,	0}, 	/* 0x5949 */
        {8,	0}, 	/* 0x594a */
        {8,	0}, 	/* 0x594b */
        {8,	0}, 	/* 0x594c */
        {8,	0}, 	/* 0x594d */
        {8,	0}, 	/* 0x594e */
        {8,	0}, 	/* 0x594f */
        {8,	0}, 	/* 0x5950 */
        {8,	0}, 	/* 0x5951 */
        {8,	0}, 	/* 0x5952 */
        {8,	0}, 	/* 0x5953 */
        {8,	0}, 	/* 0x5954 */
        {8,	0}, 	/* 0x5955 */
        {8,	0}, 	/* 0x5956 */
        {8,	0}, 	/* 0x5957 */
        {8,	0}, 	/* 0x5958 */
        {8,	0}, 	/* 0x5959 */
        {8,	0}, 	/* 0x595a */
        {8,	0}, 	/* 0x595b */
        {8,	0}, 	/* 0x595c */
        {8,	0}, 	/* 0x595d */
        {8,	0}, 	/* 0x595e */
        {8,	0}, 	/* 0x595f */
        {8,	0}, 	/* 0x5960 */
        {8,	0}, 	/* 0x5961 */
        {8,	0}, 	/* 0x5962 */
        {8,	0}, 	/* 0x5963 */
        {8,	0}, 	/* 0x5964 */
        {8,	0}, 	/* 0x5965 */
        {8,	0}, 	/* 0x5966 */
        {8,	0}, 	/* 0x5967 */
        {8,	0}, 	/* 0x5968 */
        {8,	0}, 	/* 0x5969 */
        {8,	0}, 	/* 0x596a */
        {8,	0}, 	/* 0x596b */
        {8,	0}, 	/* 0x596c */
        {8,	0}, 	/* 0x596d */
        {8,	0}, 	/* 0x596e */
        {8,	0}, 	/* 0x596f */
        {8,	0}, 	/* 0x5970 */
        {8,	0}, 	/* 0x5971 */
        {8,	0}, 	/* 0x5972 */
        {8,	0}, 	/* 0x5973 */
        {8,	0}, 	/* 0x5974 */
        {8,	0}, 	/* 0x5975 */
        {8,	0}, 	/* 0x5976 */
        {8,	0}, 	/* 0x5977 */
        {8,	0}, 	/* 0x5978 */
        {8,	0}, 	/* 0x5979 */
        {8,	0}, 	/* 0x597a */
        {8,	0}, 	/* 0x597b */
        {8,	0}, 	/* 0x597c */
        {8,	0}, 	/* 0x597d */
        {8,	0}, 	/* 0x597e */
        {8,	0}, 	/* 0x597f */
        {8,	0}, 	/* 0x5980 */
        {8,	0}, 	/* 0x5981 */
        {8,	0}, 	/* 0x5982 */
        {8,	0}, 	/* 0x5983 */
        {8,	0}, 	/* 0x5984 */
        {8,	0}, 	/* 0x5985 */
        {8,	0}, 	/* 0x5986 */
        {8,	0}, 	/* 0x5987 */
        {8,	0}, 	/* 0x5988 */
        {8,	0}, 	/* 0x5989 */
        {8,	0}, 	/* 0x598a */
        {8,	0}, 	/* 0x598b */
        {8,	0}, 	/* 0x598c */
        {8,	0}, 	/* 0x598d */
        {8,	0}, 	/* 0x598e */
        {8,	0}, 	/* 0x598f */
        {8,	0}, 	/* 0x5990 */
        {8,	0}, 	/* 0x5991 */
        {8,	0}, 	/* 0x5992 */
        {8,	0}, 	/* 0x5993 */
        {8,	0}, 	/* 0x5994 */
        {8,	0}, 	/* 0x5995 */
        {8,	0}, 	/* 0x5996 */
        {8,	0}, 	/* 0x5997 */
        {8,	0}, 	/* 0x5998 */
        {8,	0}, 	/* 0x5999 */
        {8,	0}, 	/* 0x599a */
        {8,	0}, 	/* 0x599b */
        {8,	0}, 	/* 0x599c */
        {8,	0}, 	/* 0x599d */
        {8,	0}, 	/* 0x599e */
        {8,	0}, 	/* 0x599f */
        {8,	0}, 	/* 0x59a0 */
        {8,	0}, 	/* 0x59a1 */
        {8,	0}, 	/* 0x59a2 */
        {8,	0}, 	/* 0x59a3 */
        {8,	0}, 	/* 0x59a4 */
        {8,	0}, 	/* 0x59a5 */
        {8,	0}, 	/* 0x59a6 */
        {8,	0}, 	/* 0x59a7 */
        {8,	0}, 	/* 0x59a8 */
        {8,	0}, 	/* 0x59a9 */
        {8,	0}, 	/* 0x59aa */
        {8,	0}, 	/* 0x59ab */
        {8,	0}, 	/* 0x59ac */
        {8,	0}, 	/* 0x59ad */
        {8,	0}, 	/* 0x59ae */
        {8,	0}, 	/* 0x59af */
        {8,	0}, 	/* 0x59b0 */
        {8,	0}, 	/* 0x59b1 */
        {8,	0}, 	/* 0x59b2 */
        {8,	0}, 	/* 0x59b3 */
        {8,	0}, 	/* 0x59b4 */
        {8,	0}, 	/* 0x59b5 */
        {8,	0}, 	/* 0x59b6 */
        {8,	0}, 	/* 0x59b7 */
        {8,	0}, 	/* 0x59b8 */
        {8,	0}, 	/* 0x59b9 */
        {8,	0}, 	/* 0x59ba */
        {8,	0}, 	/* 0x59bb */
        {8,	0}, 	/* 0x59bc */
        {8,	0}, 	/* 0x59bd */
        {8,	0}, 	/* 0x59be */
        {8,	0}, 	/* 0x59bf */
        {8,	0}, 	/* 0x59c0 */
        {8,	0}, 	/* 0x59c1 */
        {8,	0}, 	/* 0x59c2 */
        {8,	0}, 	/* 0x59c3 */
        {8,	0}, 	/* 0x59c4 */
        {8,	0}, 	/* 0x59c5 */
        {8,	0}, 	/* 0x59c6 */
        {8,	0}, 	/* 0x59c7 */
        {8,	0}, 	/* 0x59c8 */
        {8,	0}, 	/* 0x59c9 */
        {8,	0}, 	/* 0x59ca */
        {8,	0}, 	/* 0x59cb */
        {8,	0}, 	/* 0x59cc */
        {8,	0}, 	/* 0x59cd */
        {8,	0}, 	/* 0x59ce */
        {8,	0}, 	/* 0x59cf */
        {8,	0}, 	/* 0x59d0 */
        {8,	0}, 	/* 0x59d1 */
        {8,	0}, 	/* 0x59d2 */
        {8,	0}, 	/* 0x59d3 */
        {8,	0}, 	/* 0x59d4 */
        {8,	0}, 	/* 0x59d5 */
        {8,	0}, 	/* 0x59d6 */
        {8,	0}, 	/* 0x59d7 */
        {8,	0}, 	/* 0x59d8 */
        {8,	0}, 	/* 0x59d9 */
        {8,	0}, 	/* 0x59da */
        {8,	0}, 	/* 0x59db */
        {8,	0}, 	/* 0x59dc */
        {8,	0}, 	/* 0x59dd */
        {8,	0}, 	/* 0x59de */
        {8,	0}, 	/* 0x59df */
        {8,	0}, 	/* 0x59e0 */
        {8,	0}, 	/* 0x59e1 */
        {8,	0}, 	/* 0x59e2 */
        {8,	0}, 	/* 0x59e3 */
        {8,	0}, 	/* 0x59e4 */
        {8,	0}, 	/* 0x59e5 */
        {8,	0}, 	/* 0x59e6 */
        {8,	0}, 	/* 0x59e7 */
        {8,	0}, 	/* 0x59e8 */
        {8,	0}, 	/* 0x59e9 */
        {8,	0}, 	/* 0x59ea */
        {8,	0}, 	/* 0x59eb */
        {8,	0}, 	/* 0x59ec */
        {8,	0}, 	/* 0x59ed */
        {8,	0}, 	/* 0x59ee */
        {8,	0}, 	/* 0x59ef */
        {8,	0}, 	/* 0x59f0 */
        {8,	0}, 	/* 0x59f1 */
        {8,	0}, 	/* 0x59f2 */
        {8,	0}, 	/* 0x59f3 */
        {8,	0}, 	/* 0x59f4 */
        {8,	0}, 	/* 0x59f5 */
        {8,	0}, 	/* 0x59f6 */
        {8,	0}, 	/* 0x59f7 */
        {8,	0}, 	/* 0x59f8 */
        {8,	0}, 	/* 0x59f9 */
        {8,	0}, 	/* 0x59fa */
        {8,	0}, 	/* 0x59fb */
        {8,	0}, 	/* 0x59fc */
        {8,	0}, 	/* 0x59fd */
        {8,	0}, 	/* 0x59fe */
        {8,	0}, 	/* 0x59ff */
        {8,	0}, 	/* 0x5a00 */
        {8,	0}, 	/* 0x5a01 */
        {8,	0}, 	/* 0x5a02 */
        {8,	0}, 	/* 0x5a03 */
        {8,	0}, 	/* 0x5a04 */
        {8,	0}, 	/* 0x5a05 */
        {8,	0}, 	/* 0x5a06 */
        {8,	0}, 	/* 0x5a07 */
        {8,	0}, 	/* 0x5a08 */
        {8,	0}, 	/* 0x5a09 */
        {8,	0}, 	/* 0x5a0a */
        {8,	0}, 	/* 0x5a0b */
        {8,	0}, 	/* 0x5a0c */
        {8,	0}, 	/* 0x5a0d */
        {8,	0}, 	/* 0x5a0e */
        {8,	0}, 	/* 0x5a0f */
        {8,	0}, 	/* 0x5a10 */
        {8,	0}, 	/* 0x5a11 */
        {8,	0}, 	/* 0x5a12 */
        {8,	0}, 	/* 0x5a13 */
        {8,	0}, 	/* 0x5a14 */
        {8,	0}, 	/* 0x5a15 */
        {8,	0}, 	/* 0x5a16 */
        {8,	0}, 	/* 0x5a17 */
        {8,	0}, 	/* 0x5a18 */
        {8,	0}, 	/* 0x5a19 */
        {8,	0}, 	/* 0x5a1a */
        {8,	0}, 	/* 0x5a1b */
        {8,	0}, 	/* 0x5a1c */
        {8,	0}, 	/* 0x5a1d */
        {8,	0}, 	/* 0x5a1e */
        {8,	0}, 	/* 0x5a1f */
        {8,	0}, 	/* 0x5a20 */
        {8,	0}, 	/* 0x5a21 */
        {8,	0}, 	/* 0x5a22 */
        {8,	0}, 	/* 0x5a23 */
        {8,	0}, 	/* 0x5a24 */
        {8,	0}, 	/* 0x5a25 */
        {8,	0}, 	/* 0x5a26 */
        {8,	0}, 	/* 0x5a27 */
        {8,	0}, 	/* 0x5a28 */
        {8,	0}, 	/* 0x5a29 */
        {8,	0}, 	/* 0x5a2a */
        {8,	0}, 	/* 0x5a2b */
        {8,	0}, 	/* 0x5a2c */
        {8,	0}, 	/* 0x5a2d */
        {8,	0}, 	/* 0x5a2e */
        {8,	0}, 	/* 0x5a2f */
        {8,	0}, 	/* 0x5a30 */
        {8,	0}, 	/* 0x5a31 */
        {8,	0}, 	/* 0x5a32 */
        {8,	0}, 	/* 0x5a33 */
        {8,	0}, 	/* 0x5a34 */
        {8,	0}, 	/* 0x5a35 */
        {8,	0}, 	/* 0x5a36 */
        {8,	0}, 	/* 0x5a37 */
        {8,	0}, 	/* 0x5a38 */
        {8,	0}, 	/* 0x5a39 */
        {8,	0}, 	/* 0x5a3a */
        {8,	0}, 	/* 0x5a3b */
        {8,	0}, 	/* 0x5a3c */
        {8,	0}, 	/* 0x5a3d */
        {8,	0}, 	/* 0x5a3e */
        {8,	0}, 	/* 0x5a3f */
        {8,	0}, 	/* 0x5a40 */
        {8,	0}, 	/* 0x5a41 */
        {8,	0}, 	/* 0x5a42 */
        {8,	0}, 	/* 0x5a43 */
        {8,	0}, 	/* 0x5a44 */
        {8,	0}, 	/* 0x5a45 */
        {8,	0}, 	/* 0x5a46 */
        {8,	0}, 	/* 0x5a47 */
        {8,	0}, 	/* 0x5a48 */
        {8,	0}, 	/* 0x5a49 */
        {8,	0}, 	/* 0x5a4a */
        {8,	0}, 	/* 0x5a4b */
        {8,	0}, 	/* 0x5a4c */
        {8,	0}, 	/* 0x5a4d */
        {8,	0}, 	/* 0x5a4e */
        {8,	0}, 	/* 0x5a4f */
        {8,	0}, 	/* 0x5a50 */
        {8,	0}, 	/* 0x5a51 */
        {8,	0}, 	/* 0x5a52 */
        {8,	0}, 	/* 0x5a53 */
        {8,	0}, 	/* 0x5a54 */
        {8,	0}, 	/* 0x5a55 */
        {8,	0}, 	/* 0x5a56 */
        {8,	0}, 	/* 0x5a57 */
        {8,	0}, 	/* 0x5a58 */
        {8,	0}, 	/* 0x5a59 */
        {8,	0}, 	/* 0x5a5a */
        {8,	0}, 	/* 0x5a5b */
        {8,	0}, 	/* 0x5a5c */
        {8,	0}, 	/* 0x5a5d */
        {8,	0}, 	/* 0x5a5e */
        {8,	0}, 	/* 0x5a5f */
        {8,	0}, 	/* 0x5a60 */
        {8,	0}, 	/* 0x5a61 */
        {8,	0}, 	/* 0x5a62 */
        {8,	0}, 	/* 0x5a63 */
        {8,	0}, 	/* 0x5a64 */
        {8,	0}, 	/* 0x5a65 */
        {8,	0}, 	/* 0x5a66 */
        {8,	0}, 	/* 0x5a67 */
        {8,	0}, 	/* 0x5a68 */
        {8,	0}, 	/* 0x5a69 */
        {8,	0}, 	/* 0x5a6a */
        {8,	0}, 	/* 0x5a6b */
        {8,	0}, 	/* 0x5a6c */
        {8,	0}, 	/* 0x5a6d */
        {8,	0}, 	/* 0x5a6e */
        {8,	0}, 	/* 0x5a6f */
        {8,	0}, 	/* 0x5a70 */
        {8,	0}, 	/* 0x5a71 */
        {8,	0}, 	/* 0x5a72 */
        {8,	0}, 	/* 0x5a73 */
        {8,	0}, 	/* 0x5a74 */
        {8,	0}, 	/* 0x5a75 */
        {8,	0}, 	/* 0x5a76 */
        {8,	0}, 	/* 0x5a77 */
        {8,	0}, 	/* 0x5a78 */
        {8,	0}, 	/* 0x5a79 */
        {8,	0}, 	/* 0x5a7a */
        {8,	0}, 	/* 0x5a7b */
        {8,	0}, 	/* 0x5a7c */
        {8,	0}, 	/* 0x5a7d */
        {8,	0}, 	/* 0x5a7e */
        {8,	0}, 	/* 0x5a7f */
        {8,	0}, 	/* 0x5a80 */
        {8,	0}, 	/* 0x5a81 */
        {8,	0}, 	/* 0x5a82 */
        {8,	0}, 	/* 0x5a83 */
        {8,	0}, 	/* 0x5a84 */
        {8,	0}, 	/* 0x5a85 */
        {8,	0}, 	/* 0x5a86 */
        {8,	0}, 	/* 0x5a87 */
        {8,	0}, 	/* 0x5a88 */
        {8,	0}, 	/* 0x5a89 */
        {8,	0}, 	/* 0x5a8a */
        {8,	0}, 	/* 0x5a8b */
        {8,	0}, 	/* 0x5a8c */
        {8,	0}, 	/* 0x5a8d */
        {8,	0}, 	/* 0x5a8e */
        {8,	0}, 	/* 0x5a8f */
        {8,	0}, 	/* 0x5a90 */
        {8,	0}, 	/* 0x5a91 */
        {8,	0}, 	/* 0x5a92 */
        {8,	0}, 	/* 0x5a93 */
        {8,	0}, 	/* 0x5a94 */
        {8,	0}, 	/* 0x5a95 */
        {8,	0}, 	/* 0x5a96 */
        {8,	0}, 	/* 0x5a97 */
        {8,	0}, 	/* 0x5a98 */
        {8,	0}, 	/* 0x5a99 */
        {8,	0}, 	/* 0x5a9a */
        {8,	0}, 	/* 0x5a9b */
        {8,	0}, 	/* 0x5a9c */
        {8,	0}, 	/* 0x5a9d */
        {8,	0}, 	/* 0x5a9e */
        {8,	0}, 	/* 0x5a9f */
        {8,	0}, 	/* 0x5aa0 */
        {8,	0}, 	/* 0x5aa1 */
        {8,	0}, 	/* 0x5aa2 */
        {8,	0}, 	/* 0x5aa3 */
        {8,	0}, 	/* 0x5aa4 */
        {8,	0}, 	/* 0x5aa5 */
        {8,	0}, 	/* 0x5aa6 */
        {8,	0}, 	/* 0x5aa7 */
        {8,	0}, 	/* 0x5aa8 */
        {8,	0}, 	/* 0x5aa9 */
        {8,	0}, 	/* 0x5aaa */
        {8,	0}, 	/* 0x5aab */
        {8,	0}, 	/* 0x5aac */
        {8,	0}, 	/* 0x5aad */
        {8,	0}, 	/* 0x5aae */
        {8,	0}, 	/* 0x5aaf */
        {8,	0}, 	/* 0x5ab0 */
        {8,	0}, 	/* 0x5ab1 */
        {8,	0}, 	/* 0x5ab2 */
        {8,	0}, 	/* 0x5ab3 */
        {8,	0}, 	/* 0x5ab4 */
        {8,	0}, 	/* 0x5ab5 */
        {8,	0}, 	/* 0x5ab6 */
        {8,	0}, 	/* 0x5ab7 */
        {8,	0}, 	/* 0x5ab8 */
        {8,	0}, 	/* 0x5ab9 */
        {8,	0}, 	/* 0x5aba */
        {8,	0}, 	/* 0x5abb */
        {8,	0}, 	/* 0x5abc */
        {8,	0}, 	/* 0x5abd */
        {8,	0}, 	/* 0x5abe */
        {8,	0}, 	/* 0x5abf */
        {8,	0}, 	/* 0x5ac0 */
        {8,	0}, 	/* 0x5ac1 */
        {8,	0}, 	/* 0x5ac2 */
        {8,	0}, 	/* 0x5ac3 */
        {8,	0}, 	/* 0x5ac4 */
        {8,	0}, 	/* 0x5ac5 */
        {8,	0}, 	/* 0x5ac6 */
        {8,	0}, 	/* 0x5ac7 */
        {8,	0}, 	/* 0x5ac8 */
        {8,	0}, 	/* 0x5ac9 */
        {8,	0}, 	/* 0x5aca */
        {8,	0}, 	/* 0x5acb */
        {8,	0}, 	/* 0x5acc */
        {8,	0}, 	/* 0x5acd */
        {8,	0}, 	/* 0x5ace */
        {8,	0}, 	/* 0x5acf */
        {8,	0}, 	/* 0x5ad0 */
        {8,	0}, 	/* 0x5ad1 */
        {8,	0}, 	/* 0x5ad2 */
        {8,	0}, 	/* 0x5ad3 */
        {8,	0}, 	/* 0x5ad4 */
        {8,	0}, 	/* 0x5ad5 */
        {8,	0}, 	/* 0x5ad6 */
        {8,	0}, 	/* 0x5ad7 */
        {8,	0}, 	/* 0x5ad8 */
        {8,	0}, 	/* 0x5ad9 */
        {8,	0}, 	/* 0x5ada */
        {8,	0}, 	/* 0x5adb */
        {8,	0}, 	/* 0x5adc */
        {8,	0}, 	/* 0x5add */
        {8,	0}, 	/* 0x5ade */
        {8,	0}, 	/* 0x5adf */
        {8,	0}, 	/* 0x5ae0 */
        {8,	0}, 	/* 0x5ae1 */
        {8,	0}, 	/* 0x5ae2 */
        {8,	0}, 	/* 0x5ae3 */
        {8,	0}, 	/* 0x5ae4 */
        {8,	0}, 	/* 0x5ae5 */
        {8,	0}, 	/* 0x5ae6 */
        {8,	0}, 	/* 0x5ae7 */
        {8,	0}, 	/* 0x5ae8 */
        {8,	0}, 	/* 0x5ae9 */
        {8,	0}, 	/* 0x5aea */
        {8,	0}, 	/* 0x5aeb */
        {8,	0}, 	/* 0x5aec */
        {8,	0}, 	/* 0x5aed */
        {8,	0}, 	/* 0x5aee */
        {8,	0}, 	/* 0x5aef */
        {8,	0}, 	/* 0x5af0 */
        {8,	0}, 	/* 0x5af1 */
        {8,	0}, 	/* 0x5af2 */
        {8,	0}, 	/* 0x5af3 */
        {8,	0}, 	/* 0x5af4 */
        {8,	0}, 	/* 0x5af5 */
        {8,	0}, 	/* 0x5af6 */
        {8,	0}, 	/* 0x5af7 */
        {8,	0}, 	/* 0x5af8 */
        {8,	0}, 	/* 0x5af9 */
        {8,	0}, 	/* 0x5afa */
        {8,	0}, 	/* 0x5afb */
        {8,	0}, 	/* 0x5afc */
        {8,	0}, 	/* 0x5afd */
        {8,	0}, 	/* 0x5afe */
        {8,	0}, 	/* 0x5aff */
        {8,	0}, 	/* 0x5b00 */
        {8,	0}, 	/* 0x5b01 */
        {8,	0}, 	/* 0x5b02 */
        {8,	0}, 	/* 0x5b03 */
        {8,	0}, 	/* 0x5b04 */
        {8,	0}, 	/* 0x5b05 */
        {8,	0}, 	/* 0x5b06 */
        {8,	0}, 	/* 0x5b07 */
        {8,	0}, 	/* 0x5b08 */
        {8,	0}, 	/* 0x5b09 */
        {8,	0}, 	/* 0x5b0a */
        {8,	0}, 	/* 0x5b0b */
        {8,	0}, 	/* 0x5b0c */
        {8,	0}, 	/* 0x5b0d */
        {8,	0}, 	/* 0x5b0e */
        {8,	0}, 	/* 0x5b0f */
        {8,	0}, 	/* 0x5b10 */
        {8,	0}, 	/* 0x5b11 */
        {8,	0}, 	/* 0x5b12 */
        {8,	0}, 	/* 0x5b13 */
        {8,	0}, 	/* 0x5b14 */
        {8,	0}, 	/* 0x5b15 */
        {8,	0}, 	/* 0x5b16 */
        {8,	0}, 	/* 0x5b17 */
        {8,	0}, 	/* 0x5b18 */
        {8,	0}, 	/* 0x5b19 */
        {8,	0}, 	/* 0x5b1a */
        {8,	0}, 	/* 0x5b1b */
        {8,	0}, 	/* 0x5b1c */
        {8,	0}, 	/* 0x5b1d */
        {8,	0}, 	/* 0x5b1e */
        {8,	0}, 	/* 0x5b1f */
        {8,	0}, 	/* 0x5b20 */
        {8,	0}, 	/* 0x5b21 */
        {8,	0}, 	/* 0x5b22 */
        {8,	0}, 	/* 0x5b23 */
        {8,	0}, 	/* 0x5b24 */
        {8,	0}, 	/* 0x5b25 */
        {8,	0}, 	/* 0x5b26 */
        {8,	0}, 	/* 0x5b27 */
        {8,	0}, 	/* 0x5b28 */
        {8,	0}, 	/* 0x5b29 */
        {8,	0}, 	/* 0x5b2a */
        {8,	0}, 	/* 0x5b2b */
        {8,	0}, 	/* 0x5b2c */
        {8,	0}, 	/* 0x5b2d */
        {8,	0}, 	/* 0x5b2e */
        {8,	0}, 	/* 0x5b2f */
        {8,	0}, 	/* 0x5b30 */
        {8,	0}, 	/* 0x5b31 */
        {8,	0}, 	/* 0x5b32 */
        {8,	0}, 	/* 0x5b33 */
        {8,	0}, 	/* 0x5b34 */
        {8,	0}, 	/* 0x5b35 */
        {8,	0}, 	/* 0x5b36 */
        {8,	0}, 	/* 0x5b37 */
        {8,	0}, 	/* 0x5b38 */
        {8,	0}, 	/* 0x5b39 */
        {8,	0}, 	/* 0x5b3a */
        {8,	0}, 	/* 0x5b3b */
        {8,	0}, 	/* 0x5b3c */
        {8,	0}, 	/* 0x5b3d */
        {8,	0}, 	/* 0x5b3e */
        {8,	0}, 	/* 0x5b3f */
        {8,	0}, 	/* 0x5b40 */
        {8,	0}, 	/* 0x5b41 */
        {8,	0}, 	/* 0x5b42 */
        {8,	0}, 	/* 0x5b43 */
        {8,	0}, 	/* 0x5b44 */
        {8,	0}, 	/* 0x5b45 */
        {8,	0}, 	/* 0x5b46 */
        {8,	0}, 	/* 0x5b47 */
        {8,	0}, 	/* 0x5b48 */
        {8,	0}, 	/* 0x5b49 */
        {8,	0}, 	/* 0x5b4a */
        {8,	0}, 	/* 0x5b4b */
        {8,	0}, 	/* 0x5b4c */
        {8,	0}, 	/* 0x5b4d */
        {8,	0}, 	/* 0x5b4e */
        {8,	0}, 	/* 0x5b4f */
        {8,	0}, 	/* 0x5b50 */
        {8,	0}, 	/* 0x5b51 */
        {8,	0}, 	/* 0x5b52 */
        {8,	0}, 	/* 0x5b53 */
        {8,	0}, 	/* 0x5b54 */
        {8,	0}, 	/* 0x5b55 */
        {8,	0}, 	/* 0x5b56 */
        {8,	0}, 	/* 0x5b57 */
        {8,	0}, 	/* 0x5b58 */
        {8,	0}, 	/* 0x5b59 */
        {8,	0}, 	/* 0x5b5a */
        {8,	0}, 	/* 0x5b5b */
        {8,	0}, 	/* 0x5b5c */
        {8,	0}, 	/* 0x5b5d */
        {8,	0}, 	/* 0x5b5e */
        {8,	0}, 	/* 0x5b5f */
        {8,	0}, 	/* 0x5b60 */
        {8,	0}, 	/* 0x5b61 */
        {8,	0}, 	/* 0x5b62 */
        {8,	0}, 	/* 0x5b63 */
        {8,	0}, 	/* 0x5b64 */
        {8,	0}, 	/* 0x5b65 */
        {8,	0}, 	/* 0x5b66 */
        {8,	0}, 	/* 0x5b67 */
        {8,	0}, 	/* 0x5b68 */
        {8,	0}, 	/* 0x5b69 */
        {8,	0}, 	/* 0x5b6a */
        {8,	0}, 	/* 0x5b6b */
        {8,	0}, 	/* 0x5b6c */
        {8,	0}, 	/* 0x5b6d */
        {8,	0}, 	/* 0x5b6e */
        {8,	0}, 	/* 0x5b6f */
        {8,	0}, 	/* 0x5b70 */
        {8,	0}, 	/* 0x5b71 */
        {8,	0}, 	/* 0x5b72 */
        {8,	0}, 	/* 0x5b73 */
        {8,	0}, 	/* 0x5b74 */
        {8,	0}, 	/* 0x5b75 */
        {8,	0}, 	/* 0x5b76 */
        {8,	0}, 	/* 0x5b77 */
        {8,	0}, 	/* 0x5b78 */
        {8,	0}, 	/* 0x5b79 */
        {8,	0}, 	/* 0x5b7a */
        {8,	0}, 	/* 0x5b7b */
        {8,	0}, 	/* 0x5b7c */
        {8,	0}, 	/* 0x5b7d */
        {8,	0}, 	/* 0x5b7e */
        {8,	0}, 	/* 0x5b7f */
        {8,	0}, 	/* 0x5b80 */
        {8,	0}, 	/* 0x5b81 */
        {8,	0}, 	/* 0x5b82 */
        {8,	0}, 	/* 0x5b83 */
        {8,	0}, 	/* 0x5b84 */
        {8,	0}, 	/* 0x5b85 */
        {8,	0}, 	/* 0x5b86 */
        {8,	0}, 	/* 0x5b87 */
        {8,	0}, 	/* 0x5b88 */
        {8,	0}, 	/* 0x5b89 */
        {8,	0}, 	/* 0x5b8a */
        {8,	0}, 	/* 0x5b8b */
        {8,	0}, 	/* 0x5b8c */
        {8,	0}, 	/* 0x5b8d */
        {8,	0}, 	/* 0x5b8e */
        {8,	0}, 	/* 0x5b8f */
        {8,	0}, 	/* 0x5b90 */
        {8,	0}, 	/* 0x5b91 */
        {8,	0}, 	/* 0x5b92 */
        {8,	0}, 	/* 0x5b93 */
        {8,	0}, 	/* 0x5b94 */
        {8,	0}, 	/* 0x5b95 */
        {8,	0}, 	/* 0x5b96 */
        {8,	0}, 	/* 0x5b97 */
        {8,	0}, 	/* 0x5b98 */
        {8,	0}, 	/* 0x5b99 */
        {8,	0}, 	/* 0x5b9a */
        {8,	0}, 	/* 0x5b9b */
        {8,	0}, 	/* 0x5b9c */
        {8,	0}, 	/* 0x5b9d */
        {8,	0}, 	/* 0x5b9e */
        {8,	0}, 	/* 0x5b9f */
        {8,	0}, 	/* 0x5ba0 */
        {8,	0}, 	/* 0x5ba1 */
        {8,	0}, 	/* 0x5ba2 */
        {8,	0}, 	/* 0x5ba3 */
        {8,	0}, 	/* 0x5ba4 */
        {8,	0}, 	/* 0x5ba5 */
        {8,	0}, 	/* 0x5ba6 */
        {8,	0}, 	/* 0x5ba7 */
        {8,	0}, 	/* 0x5ba8 */
        {8,	0}, 	/* 0x5ba9 */
        {8,	0}, 	/* 0x5baa */
        {8,	0}, 	/* 0x5bab */
        {8,	0}, 	/* 0x5bac */
        {8,	0}, 	/* 0x5bad */
        {8,	0}, 	/* 0x5bae */
        {8,	0}, 	/* 0x5baf */
        {8,	0}, 	/* 0x5bb0 */
        {8,	0}, 	/* 0x5bb1 */
        {8,	0}, 	/* 0x5bb2 */
        {8,	0}, 	/* 0x5bb3 */
        {8,	0}, 	/* 0x5bb4 */
        {8,	0}, 	/* 0x5bb5 */
        {8,	0}, 	/* 0x5bb6 */
        {8,	0}, 	/* 0x5bb7 */
        {8,	0}, 	/* 0x5bb8 */
        {8,	0}, 	/* 0x5bb9 */
        {8,	0}, 	/* 0x5bba */
        {8,	0}, 	/* 0x5bbb */
        {8,	0}, 	/* 0x5bbc */
        {8,	0}, 	/* 0x5bbd */
        {8,	0}, 	/* 0x5bbe */
        {8,	0}, 	/* 0x5bbf */
        {8,	0}, 	/* 0x5bc0 */
        {8,	0}, 	/* 0x5bc1 */
        {8,	0}, 	/* 0x5bc2 */
        {8,	0}, 	/* 0x5bc3 */
        {8,	0}, 	/* 0x5bc4 */
        {8,	0}, 	/* 0x5bc5 */
        {8,	0}, 	/* 0x5bc6 */
        {8,	0}, 	/* 0x5bc7 */
        {8,	0}, 	/* 0x5bc8 */
        {8,	0}, 	/* 0x5bc9 */
        {8,	0}, 	/* 0x5bca */
        {8,	0}, 	/* 0x5bcb */
        {8,	0}, 	/* 0x5bcc */
        {8,	0}, 	/* 0x5bcd */
        {8,	0}, 	/* 0x5bce */
        {8,	0}, 	/* 0x5bcf */
        {8,	0}, 	/* 0x5bd0 */
        {8,	0}, 	/* 0x5bd1 */
        {8,	0}, 	/* 0x5bd2 */
        {8,	0}, 	/* 0x5bd3 */
        {8,	0}, 	/* 0x5bd4 */
        {8,	0}, 	/* 0x5bd5 */
        {8,	0}, 	/* 0x5bd6 */
        {8,	0}, 	/* 0x5bd7 */
        {8,	0}, 	/* 0x5bd8 */
        {8,	0}, 	/* 0x5bd9 */
        {8,	0}, 	/* 0x5bda */
        {8,	0}, 	/* 0x5bdb */
        {8,	0}, 	/* 0x5bdc */
        {8,	0}, 	/* 0x5bdd */
        {8,	0}, 	/* 0x5bde */
        {8,	0}, 	/* 0x5bdf */
        {8,	0}, 	/* 0x5be0 */
        {8,	0}, 	/* 0x5be1 */
        {8,	0}, 	/* 0x5be2 */
        {8,	0}, 	/* 0x5be3 */
        {8,	0}, 	/* 0x5be4 */
        {8,	0}, 	/* 0x5be5 */
        {8,	0}, 	/* 0x5be6 */
        {8,	0}, 	/* 0x5be7 */
        {8,	0}, 	/* 0x5be8 */
        {8,	0}, 	/* 0x5be9 */
        {8,	0}, 	/* 0x5bea */
        {8,	0}, 	/* 0x5beb */
        {8,	0}, 	/* 0x5bec */
        {8,	0}, 	/* 0x5bed */
        {8,	0}, 	/* 0x5bee */
        {8,	0}, 	/* 0x5bef */
        {8,	0}, 	/* 0x5bf0 */
        {8,	0}, 	/* 0x5bf1 */
        {8,	0}, 	/* 0x5bf2 */
        {8,	0}, 	/* 0x5bf3 */
        {8,	0}, 	/* 0x5bf4 */
        {8,	0}, 	/* 0x5bf5 */
        {8,	0}, 	/* 0x5bf6 */
        {8,	0}, 	/* 0x5bf7 */
        {8,	0}, 	/* 0x5bf8 */
        {8,	0}, 	/* 0x5bf9 */
        {8,	0}, 	/* 0x5bfa */
        {8,	0}, 	/* 0x5bfb */
        {8,	0}, 	/* 0x5bfc */
        {8,	0}, 	/* 0x5bfd */
        {8,	0}, 	/* 0x5bfe */
        {8,	0}, 	/* 0x5bff */
        {8,	0}, 	/* 0x5c00 */
        {8,	0}, 	/* 0x5c01 */
        {8,	0}, 	/* 0x5c02 */
        {8,	0}, 	/* 0x5c03 */
        {8,	0}, 	/* 0x5c04 */
        {8,	0}, 	/* 0x5c05 */
        {8,	0}, 	/* 0x5c06 */
        {8,	0}, 	/* 0x5c07 */
        {8,	0}, 	/* 0x5c08 */
        {8,	0}, 	/* 0x5c09 */
        {8,	0}, 	/* 0x5c0a */
        {8,	0}, 	/* 0x5c0b */
        {8,	0}, 	/* 0x5c0c */
        {8,	0}, 	/* 0x5c0d */
        {8,	0}, 	/* 0x5c0e */
        {8,	0}, 	/* 0x5c0f */
        {8,	0}, 	/* 0x5c10 */
        {8,	0}, 	/* 0x5c11 */
        {8,	0}, 	/* 0x5c12 */
        {8,	0}, 	/* 0x5c13 */
        {8,	0}, 	/* 0x5c14 */
        {8,	0}, 	/* 0x5c15 */
        {8,	0}, 	/* 0x5c16 */
        {8,	0}, 	/* 0x5c17 */
        {8,	0}, 	/* 0x5c18 */
        {8,	0}, 	/* 0x5c19 */
        {8,	0}, 	/* 0x5c1a */
        {8,	0}, 	/* 0x5c1b */
        {8,	0}, 	/* 0x5c1c */
        {8,	0}, 	/* 0x5c1d */
        {8,	0}, 	/* 0x5c1e */
        {8,	0}, 	/* 0x5c1f */
        {8,	0}, 	/* 0x5c20 */
        {8,	0}, 	/* 0x5c21 */
        {8,	0}, 	/* 0x5c22 */
        {8,	0}, 	/* 0x5c23 */
        {8,	0}, 	/* 0x5c24 */
        {8,	0}, 	/* 0x5c25 */
        {8,	0}, 	/* 0x5c26 */
        {8,	0}, 	/* 0x5c27 */
        {8,	0}, 	/* 0x5c28 */
        {8,	0}, 	/* 0x5c29 */
        {8,	0}, 	/* 0x5c2a */
        {8,	0}, 	/* 0x5c2b */
        {8,	0}, 	/* 0x5c2c */
        {8,	0}, 	/* 0x5c2d */
        {8,	0}, 	/* 0x5c2e */
        {8,	0}, 	/* 0x5c2f */
        {8,	0}, 	/* 0x5c30 */
        {8,	0}, 	/* 0x5c31 */
        {8,	0}, 	/* 0x5c32 */
        {8,	0}, 	/* 0x5c33 */
        {8,	0}, 	/* 0x5c34 */
        {8,	0}, 	/* 0x5c35 */
        {8,	0}, 	/* 0x5c36 */
        {8,	0}, 	/* 0x5c37 */
        {8,	0}, 	/* 0x5c38 */
        {8,	0}, 	/* 0x5c39 */
        {8,	0}, 	/* 0x5c3a */
        {8,	0}, 	/* 0x5c3b */
        {8,	0}, 	/* 0x5c3c */
        {8,	0}, 	/* 0x5c3d */
        {8,	0}, 	/* 0x5c3e */
        {8,	0}, 	/* 0x5c3f */
        {8,	0}, 	/* 0x5c40 */
        {8,	0}, 	/* 0x5c41 */
        {8,	0}, 	/* 0x5c42 */
        {8,	0}, 	/* 0x5c43 */
        {8,	0}, 	/* 0x5c44 */
        {8,	0}, 	/* 0x5c45 */
        {8,	0}, 	/* 0x5c46 */
        {8,	0}, 	/* 0x5c47 */
        {8,	0}, 	/* 0x5c48 */
        {8,	0}, 	/* 0x5c49 */
        {8,	0}, 	/* 0x5c4a */
        {8,	0}, 	/* 0x5c4b */
        {8,	0}, 	/* 0x5c4c */
        {8,	0}, 	/* 0x5c4d */
        {8,	0}, 	/* 0x5c4e */
        {8,	0}, 	/* 0x5c4f */
        {8,	0}, 	/* 0x5c50 */
        {8,	0}, 	/* 0x5c51 */
        {8,	0}, 	/* 0x5c52 */
        {8,	0}, 	/* 0x5c53 */
        {8,	0}, 	/* 0x5c54 */
        {8,	0}, 	/* 0x5c55 */
        {8,	0}, 	/* 0x5c56 */
        {8,	0}, 	/* 0x5c57 */
        {8,	0}, 	/* 0x5c58 */
        {8,	0}, 	/* 0x5c59 */
        {8,	0}, 	/* 0x5c5a */
        {8,	0}, 	/* 0x5c5b */
        {8,	0}, 	/* 0x5c5c */
        {8,	0}, 	/* 0x5c5d */
        {8,	0}, 	/* 0x5c5e */
        {8,	0}, 	/* 0x5c5f */
        {8,	0}, 	/* 0x5c60 */
        {8,	0}, 	/* 0x5c61 */
        {8,	0}, 	/* 0x5c62 */
        {8,	0}, 	/* 0x5c63 */
        {8,	0}, 	/* 0x5c64 */
        {8,	0}, 	/* 0x5c65 */
        {8,	0}, 	/* 0x5c66 */
        {8,	0}, 	/* 0x5c67 */
        {8,	0}, 	/* 0x5c68 */
        {8,	0}, 	/* 0x5c69 */
        {8,	0}, 	/* 0x5c6a */
        {8,	0}, 	/* 0x5c6b */
        {8,	0}, 	/* 0x5c6c */
        {8,	0}, 	/* 0x5c6d */
        {8,	0}, 	/* 0x5c6e */
        {8,	0}, 	/* 0x5c6f */
        {8,	0}, 	/* 0x5c70 */
        {8,	0}, 	/* 0x5c71 */
        {8,	0}, 	/* 0x5c72 */
        {8,	0}, 	/* 0x5c73 */
        {8,	0}, 	/* 0x5c74 */
        {8,	0}, 	/* 0x5c75 */
        {8,	0}, 	/* 0x5c76 */
        {8,	0}, 	/* 0x5c77 */
        {8,	0}, 	/* 0x5c78 */
        {8,	0}, 	/* 0x5c79 */
        {8,	0}, 	/* 0x5c7a */
        {8,	0}, 	/* 0x5c7b */
        {8,	0}, 	/* 0x5c7c */
        {8,	0}, 	/* 0x5c7d */
        {8,	0}, 	/* 0x5c7e */
        {8,	0}, 	/* 0x5c7f */
        {8,	0}, 	/* 0x5c80 */
        {8,	0}, 	/* 0x5c81 */
        {8,	0}, 	/* 0x5c82 */
        {8,	0}, 	/* 0x5c83 */
        {8,	0}, 	/* 0x5c84 */
        {8,	0}, 	/* 0x5c85 */
        {8,	0}, 	/* 0x5c86 */
        {8,	0}, 	/* 0x5c87 */
        {8,	0}, 	/* 0x5c88 */
        {8,	0}, 	/* 0x5c89 */
        {8,	0}, 	/* 0x5c8a */
        {8,	0}, 	/* 0x5c8b */
        {8,	0}, 	/* 0x5c8c */
        {8,	0}, 	/* 0x5c8d */
        {8,	0}, 	/* 0x5c8e */
        {8,	0}, 	/* 0x5c8f */
        {8,	0}, 	/* 0x5c90 */
        {8,	0}, 	/* 0x5c91 */
        {8,	0}, 	/* 0x5c92 */
        {8,	0}, 	/* 0x5c93 */
        {8,	0}, 	/* 0x5c94 */
        {8,	0}, 	/* 0x5c95 */
        {8,	0}, 	/* 0x5c96 */
        {8,	0}, 	/* 0x5c97 */
        {8,	0}, 	/* 0x5c98 */
        {8,	0}, 	/* 0x5c99 */
        {8,	0}, 	/* 0x5c9a */
        {8,	0}, 	/* 0x5c9b */
        {8,	0}, 	/* 0x5c9c */
        {8,	0}, 	/* 0x5c9d */
        {8,	0}, 	/* 0x5c9e */
        {8,	0}, 	/* 0x5c9f */
        {8,	0}, 	/* 0x5ca0 */
        {8,	0}, 	/* 0x5ca1 */
        {8,	0}, 	/* 0x5ca2 */
        {8,	0}, 	/* 0x5ca3 */
        {8,	0}, 	/* 0x5ca4 */
        {8,	0}, 	/* 0x5ca5 */
        {8,	0}, 	/* 0x5ca6 */
        {8,	0}, 	/* 0x5ca7 */
        {8,	0}, 	/* 0x5ca8 */
        {8,	0}, 	/* 0x5ca9 */
        {8,	0}, 	/* 0x5caa */
        {8,	0}, 	/* 0x5cab */
        {8,	0}, 	/* 0x5cac */
        {8,	0}, 	/* 0x5cad */
        {8,	0}, 	/* 0x5cae */
        {8,	0}, 	/* 0x5caf */
        {8,	0}, 	/* 0x5cb0 */
        {8,	0}, 	/* 0x5cb1 */
        {8,	0}, 	/* 0x5cb2 */
        {8,	0}, 	/* 0x5cb3 */
        {8,	0}, 	/* 0x5cb4 */
        {8,	0}, 	/* 0x5cb5 */
        {8,	0}, 	/* 0x5cb6 */
        {8,	0}, 	/* 0x5cb7 */
        {8,	0}, 	/* 0x5cb8 */
        {8,	0}, 	/* 0x5cb9 */
        {8,	0}, 	/* 0x5cba */
        {8,	0}, 	/* 0x5cbb */
        {8,	0}, 	/* 0x5cbc */
        {8,	0}, 	/* 0x5cbd */
        {8,	0}, 	/* 0x5cbe */
        {8,	0}, 	/* 0x5cbf */
        {8,	0}, 	/* 0x5cc0 */
        {8,	0}, 	/* 0x5cc1 */
        {8,	0}, 	/* 0x5cc2 */
        {8,	0}, 	/* 0x5cc3 */
        {8,	0}, 	/* 0x5cc4 */
        {8,	0}, 	/* 0x5cc5 */
        {8,	0}, 	/* 0x5cc6 */
        {8,	0}, 	/* 0x5cc7 */
        {8,	0}, 	/* 0x5cc8 */
        {8,	0}, 	/* 0x5cc9 */
        {8,	0}, 	/* 0x5cca */
        {8,	0}, 	/* 0x5ccb */
        {8,	0}, 	/* 0x5ccc */
        {8,	0}, 	/* 0x5ccd */
        {8,	0}, 	/* 0x5cce */
        {8,	0}, 	/* 0x5ccf */
        {8,	0}, 	/* 0x5cd0 */
        {8,	0}, 	/* 0x5cd1 */
        {8,	0}, 	/* 0x5cd2 */
        {8,	0}, 	/* 0x5cd3 */
        {8,	0}, 	/* 0x5cd4 */
        {8,	0}, 	/* 0x5cd5 */
        {8,	0}, 	/* 0x5cd6 */
        {8,	0}, 	/* 0x5cd7 */
        {8,	0}, 	/* 0x5cd8 */
        {8,	0}, 	/* 0x5cd9 */
        {8,	0}, 	/* 0x5cda */
        {8,	0}, 	/* 0x5cdb */
        {8,	0}, 	/* 0x5cdc */
        {8,	0}, 	/* 0x5cdd */
        {8,	0}, 	/* 0x5cde */
        {8,	0}, 	/* 0x5cdf */
        {8,	0}, 	/* 0x5ce0 */
        {8,	0}, 	/* 0x5ce1 */
        {8,	0}, 	/* 0x5ce2 */
        {8,	0}, 	/* 0x5ce3 */
        {8,	0}, 	/* 0x5ce4 */
        {8,	0}, 	/* 0x5ce5 */
        {8,	0}, 	/* 0x5ce6 */
        {8,	0}, 	/* 0x5ce7 */
        {8,	0}, 	/* 0x5ce8 */
        {8,	0}, 	/* 0x5ce9 */
        {8,	0}, 	/* 0x5cea */
        {8,	0}, 	/* 0x5ceb */
        {8,	0}, 	/* 0x5cec */
        {8,	0}, 	/* 0x5ced */
        {8,	0}, 	/* 0x5cee */
        {8,	0}, 	/* 0x5cef */
        {8,	0}, 	/* 0x5cf0 */
        {8,	0}, 	/* 0x5cf1 */
        {8,	0}, 	/* 0x5cf2 */
        {8,	0}, 	/* 0x5cf3 */
        {8,	0}, 	/* 0x5cf4 */
        {8,	0}, 	/* 0x5cf5 */
        {8,	0}, 	/* 0x5cf6 */
        {8,	0}, 	/* 0x5cf7 */
        {8,	0}, 	/* 0x5cf8 */
        {8,	0}, 	/* 0x5cf9 */
        {8,	0}, 	/* 0x5cfa */
        {8,	0}, 	/* 0x5cfb */
        {8,	0}, 	/* 0x5cfc */
        {8,	0}, 	/* 0x5cfd */
        {8,	0}, 	/* 0x5cfe */
        {8,	0}, 	/* 0x5cff */
        {8,	0}, 	/* 0x5d00 */
        {8,	0}, 	/* 0x5d01 */
        {8,	0}, 	/* 0x5d02 */
        {8,	0}, 	/* 0x5d03 */
        {8,	0}, 	/* 0x5d04 */
        {8,	0}, 	/* 0x5d05 */
        {8,	0}, 	/* 0x5d06 */
        {8,	0}, 	/* 0x5d07 */
        {8,	0}, 	/* 0x5d08 */
        {8,	0}, 	/* 0x5d09 */
        {8,	0}, 	/* 0x5d0a */
        {8,	0}, 	/* 0x5d0b */
        {8,	0}, 	/* 0x5d0c */
        {8,	0}, 	/* 0x5d0d */
        {8,	0}, 	/* 0x5d0e */
        {8,	0}, 	/* 0x5d0f */
        {8,	0}, 	/* 0x5d10 */
        {8,	0}, 	/* 0x5d11 */
        {8,	0}, 	/* 0x5d12 */
        {8,	0}, 	/* 0x5d13 */
        {8,	0}, 	/* 0x5d14 */
        {8,	0}, 	/* 0x5d15 */
        {8,	0}, 	/* 0x5d16 */
        {8,	0}, 	/* 0x5d17 */
        {8,	0}, 	/* 0x5d18 */
        {8,	0}, 	/* 0x5d19 */
        {8,	0}, 	/* 0x5d1a */
        {8,	0}, 	/* 0x5d1b */
        {8,	0}, 	/* 0x5d1c */
        {8,	0}, 	/* 0x5d1d */
        {8,	0}, 	/* 0x5d1e */
        {8,	0}, 	/* 0x5d1f */
        {8,	0}, 	/* 0x5d20 */
        {8,	0}, 	/* 0x5d21 */
        {8,	0}, 	/* 0x5d22 */
        {8,	0}, 	/* 0x5d23 */
        {8,	0}, 	/* 0x5d24 */
        {8,	0}, 	/* 0x5d25 */
        {8,	0}, 	/* 0x5d26 */
        {8,	0}, 	/* 0x5d27 */
        {8,	0}, 	/* 0x5d28 */
        {8,	0}, 	/* 0x5d29 */
        {8,	0}, 	/* 0x5d2a */
        {8,	0}, 	/* 0x5d2b */
        {8,	0}, 	/* 0x5d2c */
        {8,	0}, 	/* 0x5d2d */
        {8,	0}, 	/* 0x5d2e */
        {8,	0}, 	/* 0x5d2f */
        {8,	0}, 	/* 0x5d30 */
        {8,	0}, 	/* 0x5d31 */
        {8,	0}, 	/* 0x5d32 */
        {8,	0}, 	/* 0x5d33 */
        {8,	0}, 	/* 0x5d34 */
        {8,	0}, 	/* 0x5d35 */
        {8,	0}, 	/* 0x5d36 */
        {8,	0}, 	/* 0x5d37 */
        {8,	0}, 	/* 0x5d38 */
        {8,	0}, 	/* 0x5d39 */
        {8,	0}, 	/* 0x5d3a */
        {8,	0}, 	/* 0x5d3b */
        {8,	0}, 	/* 0x5d3c */
        {8,	0}, 	/* 0x5d3d */
        {8,	0}, 	/* 0x5d3e */
        {8,	0}, 	/* 0x5d3f */
        {8,	0}, 	/* 0x5d40 */
        {8,	0}, 	/* 0x5d41 */
        {8,	0}, 	/* 0x5d42 */
        {8,	0}, 	/* 0x5d43 */
        {8,	0}, 	/* 0x5d44 */
        {8,	0}, 	/* 0x5d45 */
        {8,	0}, 	/* 0x5d46 */
        {8,	0}, 	/* 0x5d47 */
        {8,	0}, 	/* 0x5d48 */
        {8,	0}, 	/* 0x5d49 */
        {8,	0}, 	/* 0x5d4a */
        {8,	0}, 	/* 0x5d4b */
        {8,	0}, 	/* 0x5d4c */
        {8,	0}, 	/* 0x5d4d */
        {8,	0}, 	/* 0x5d4e */
        {8,	0}, 	/* 0x5d4f */
        {8,	0}, 	/* 0x5d50 */
        {8,	0}, 	/* 0x5d51 */
        {8,	0}, 	/* 0x5d52 */
        {8,	0}, 	/* 0x5d53 */
        {8,	0}, 	/* 0x5d54 */
        {8,	0}, 	/* 0x5d55 */
        {8,	0}, 	/* 0x5d56 */
        {8,	0}, 	/* 0x5d57 */
        {8,	0}, 	/* 0x5d58 */
        {8,	0}, 	/* 0x5d59 */
        {8,	0}, 	/* 0x5d5a */
        {8,	0}, 	/* 0x5d5b */
        {8,	0}, 	/* 0x5d5c */
        {8,	0}, 	/* 0x5d5d */
        {8,	0}, 	/* 0x5d5e */
        {8,	0}, 	/* 0x5d5f */
        {8,	0}, 	/* 0x5d60 */
        {8,	0}, 	/* 0x5d61 */
        {8,	0}, 	/* 0x5d62 */
        {8,	0}, 	/* 0x5d63 */
        {8,	0}, 	/* 0x5d64 */
        {8,	0}, 	/* 0x5d65 */
        {8,	0}, 	/* 0x5d66 */
        {8,	0}, 	/* 0x5d67 */
        {8,	0}, 	/* 0x5d68 */
        {8,	0}, 	/* 0x5d69 */
        {8,	0}, 	/* 0x5d6a */
        {8,	0}, 	/* 0x5d6b */
        {8,	0}, 	/* 0x5d6c */
        {8,	0}, 	/* 0x5d6d */
        {8,	0}, 	/* 0x5d6e */
        {8,	0}, 	/* 0x5d6f */
        {8,	0}, 	/* 0x5d70 */
        {8,	0}, 	/* 0x5d71 */
        {8,	0}, 	/* 0x5d72 */
        {8,	0}, 	/* 0x5d73 */
        {8,	0}, 	/* 0x5d74 */
        {8,	0}, 	/* 0x5d75 */
        {8,	0}, 	/* 0x5d76 */
        {8,	0}, 	/* 0x5d77 */
        {8,	0}, 	/* 0x5d78 */
        {8,	0}, 	/* 0x5d79 */
        {8,	0}, 	/* 0x5d7a */
        {8,	0}, 	/* 0x5d7b */
        {8,	0}, 	/* 0x5d7c */
        {8,	0}, 	/* 0x5d7d */
        {8,	0}, 	/* 0x5d7e */
        {8,	0}, 	/* 0x5d7f */
        {8,	0}, 	/* 0x5d80 */
        {8,	0}, 	/* 0x5d81 */
        {8,	0}, 	/* 0x5d82 */
        {8,	0}, 	/* 0x5d83 */
        {8,	0}, 	/* 0x5d84 */
        {8,	0}, 	/* 0x5d85 */
        {8,	0}, 	/* 0x5d86 */
        {8,	0}, 	/* 0x5d87 */
        {8,	0}, 	/* 0x5d88 */
        {8,	0}, 	/* 0x5d89 */
        {8,	0}, 	/* 0x5d8a */
        {8,	0}, 	/* 0x5d8b */
        {8,	0}, 	/* 0x5d8c */
        {8,	0}, 	/* 0x5d8d */
        {8,	0}, 	/* 0x5d8e */
        {8,	0}, 	/* 0x5d8f */
        {8,	0}, 	/* 0x5d90 */
        {8,	0}, 	/* 0x5d91 */
        {8,	0}, 	/* 0x5d92 */
        {8,	0}, 	/* 0x5d93 */
        {8,	0}, 	/* 0x5d94 */
        {8,	0}, 	/* 0x5d95 */
        {8,	0}, 	/* 0x5d96 */
        {8,	0}, 	/* 0x5d97 */
        {8,	0}, 	/* 0x5d98 */
        {8,	0}, 	/* 0x5d99 */
        {8,	0}, 	/* 0x5d9a */
        {8,	0}, 	/* 0x5d9b */
        {8,	0}, 	/* 0x5d9c */
        {8,	0}, 	/* 0x5d9d */
        {8,	0}, 	/* 0x5d9e */
        {8,	0}, 	/* 0x5d9f */
        {8,	0}, 	/* 0x5da0 */
        {8,	0}, 	/* 0x5da1 */
        {8,	0}, 	/* 0x5da2 */
        {8,	0}, 	/* 0x5da3 */
        {8,	0}, 	/* 0x5da4 */
        {8,	0}, 	/* 0x5da5 */
        {8,	0}, 	/* 0x5da6 */
        {8,	0}, 	/* 0x5da7 */
        {8,	0}, 	/* 0x5da8 */
        {8,	0}, 	/* 0x5da9 */
        {8,	0}, 	/* 0x5daa */
        {8,	0}, 	/* 0x5dab */
        {8,	0}, 	/* 0x5dac */
        {8,	0}, 	/* 0x5dad */
        {8,	0}, 	/* 0x5dae */
        {8,	0}, 	/* 0x5daf */
        {8,	0}, 	/* 0x5db0 */
        {8,	0}, 	/* 0x5db1 */
        {8,	0}, 	/* 0x5db2 */
        {8,	0}, 	/* 0x5db3 */
        {8,	0}, 	/* 0x5db4 */
        {8,	0}, 	/* 0x5db5 */
        {8,	0}, 	/* 0x5db6 */
        {8,	0}, 	/* 0x5db7 */
        {8,	0}, 	/* 0x5db8 */
        {8,	0}, 	/* 0x5db9 */
        {8,	0}, 	/* 0x5dba */
        {8,	0}, 	/* 0x5dbb */
        {8,	0}, 	/* 0x5dbc */
        {8,	0}, 	/* 0x5dbd */
        {8,	0}, 	/* 0x5dbe */
        {8,	0}, 	/* 0x5dbf */
        {8,	0}, 	/* 0x5dc0 */
        {8,	0}, 	/* 0x5dc1 */
        {8,	0}, 	/* 0x5dc2 */
        {8,	0}, 	/* 0x5dc3 */
        {8,	0}, 	/* 0x5dc4 */
        {8,	0}, 	/* 0x5dc5 */
        {8,	0}, 	/* 0x5dc6 */
        {8,	0}, 	/* 0x5dc7 */
        {8,	0}, 	/* 0x5dc8 */
        {8,	0}, 	/* 0x5dc9 */
        {8,	0}, 	/* 0x5dca */
        {8,	0}, 	/* 0x5dcb */
        {8,	0}, 	/* 0x5dcc */
        {8,	0}, 	/* 0x5dcd */
        {8,	0}, 	/* 0x5dce */
        {8,	0}, 	/* 0x5dcf */
        {8,	0}, 	/* 0x5dd0 */
        {8,	0}, 	/* 0x5dd1 */
        {8,	0}, 	/* 0x5dd2 */
        {8,	0}, 	/* 0x5dd3 */
        {8,	0}, 	/* 0x5dd4 */
        {8,	0}, 	/* 0x5dd5 */
        {8,	0}, 	/* 0x5dd6 */
        {8,	0}, 	/* 0x5dd7 */
        {8,	0}, 	/* 0x5dd8 */
        {8,	0}, 	/* 0x5dd9 */
        {8,	0}, 	/* 0x5dda */
        {8,	0}, 	/* 0x5ddb */
        {8,	0}, 	/* 0x5ddc */
        {8,	0}, 	/* 0x5ddd */
        {8,	0}, 	/* 0x5dde */
        {8,	0}, 	/* 0x5ddf */
        {8,	0}, 	/* 0x5de0 */
        {8,	0}, 	/* 0x5de1 */
        {8,	0}, 	/* 0x5de2 */
        {8,	0}, 	/* 0x5de3 */
        {8,	0}, 	/* 0x5de4 */
        {8,	0}, 	/* 0x5de5 */
        {8,	0}, 	/* 0x5de6 */
        {8,	0}, 	/* 0x5de7 */
        {8,	0}, 	/* 0x5de8 */
        {8,	0}, 	/* 0x5de9 */
        {8,	0}, 	/* 0x5dea */
        {8,	0}, 	/* 0x5deb */
        {8,	0}, 	/* 0x5dec */
        {8,	0}, 	/* 0x5ded */
        {8,	0}, 	/* 0x5dee */
        {8,	0}, 	/* 0x5def */
        {8,	0}, 	/* 0x5df0 */
        {8,	0}, 	/* 0x5df1 */
        {8,	0}, 	/* 0x5df2 */
        {8,	0}, 	/* 0x5df3 */
        {8,	0}, 	/* 0x5df4 */
        {8,	0}, 	/* 0x5df5 */
        {8,	0}, 	/* 0x5df6 */
        {8,	0}, 	/* 0x5df7 */
        {8,	0}, 	/* 0x5df8 */
        {8,	0}, 	/* 0x5df9 */
        {8,	0}, 	/* 0x5dfa */
        {8,	0}, 	/* 0x5dfb */
        {8,	0}, 	/* 0x5dfc */
        {8,	0}, 	/* 0x5dfd */
        {8,	0}, 	/* 0x5dfe */
        {8,	0}, 	/* 0x5dff */
        {8,	0}, 	/* 0x5e00 */
        {8,	0}, 	/* 0x5e01 */
        {8,	0}, 	/* 0x5e02 */
        {8,	0}, 	/* 0x5e03 */
        {8,	0}, 	/* 0x5e04 */
        {8,	0}, 	/* 0x5e05 */
        {8,	0}, 	/* 0x5e06 */
        {8,	0}, 	/* 0x5e07 */
        {8,	0}, 	/* 0x5e08 */
        {8,	0}, 	/* 0x5e09 */
        {8,	0}, 	/* 0x5e0a */
        {8,	0}, 	/* 0x5e0b */
        {8,	0}, 	/* 0x5e0c */
        {8,	0}, 	/* 0x5e0d */
        {8,	0}, 	/* 0x5e0e */
        {8,	0}, 	/* 0x5e0f */
        {8,	0}, 	/* 0x5e10 */
        {8,	0}, 	/* 0x5e11 */
        {8,	0}, 	/* 0x5e12 */
        {8,	0}, 	/* 0x5e13 */
        {8,	0}, 	/* 0x5e14 */
        {8,	0}, 	/* 0x5e15 */
        {8,	0}, 	/* 0x5e16 */
        {8,	0}, 	/* 0x5e17 */
        {8,	0}, 	/* 0x5e18 */
        {8,	0}, 	/* 0x5e19 */
        {8,	0}, 	/* 0x5e1a */
        {8,	0}, 	/* 0x5e1b */
        {8,	0}, 	/* 0x5e1c */
        {8,	0}, 	/* 0x5e1d */
        {8,	0}, 	/* 0x5e1e */
        {8,	0}, 	/* 0x5e1f */
        {8,	0}, 	/* 0x5e20 */
        {8,	0}, 	/* 0x5e21 */
        {8,	0}, 	/* 0x5e22 */
        {8,	0}, 	/* 0x5e23 */
        {8,	0}, 	/* 0x5e24 */
        {8,	0}, 	/* 0x5e25 */
        {8,	0}, 	/* 0x5e26 */
        {8,	0}, 	/* 0x5e27 */
        {8,	0}, 	/* 0x5e28 */
        {8,	0}, 	/* 0x5e29 */
        {8,	0}, 	/* 0x5e2a */
        {8,	0}, 	/* 0x5e2b */
        {8,	0}, 	/* 0x5e2c */
        {8,	0}, 	/* 0x5e2d */
        {8,	0}, 	/* 0x5e2e */
        {8,	0}, 	/* 0x5e2f */
        {8,	0}, 	/* 0x5e30 */
        {8,	0}, 	/* 0x5e31 */
        {8,	0}, 	/* 0x5e32 */
        {8,	0}, 	/* 0x5e33 */
        {8,	0}, 	/* 0x5e34 */
        {8,	0}, 	/* 0x5e35 */
        {8,	0}, 	/* 0x5e36 */
        {8,	0}, 	/* 0x5e37 */
        {8,	0}, 	/* 0x5e38 */
        {8,	0}, 	/* 0x5e39 */
        {8,	0}, 	/* 0x5e3a */
        {8,	0}, 	/* 0x5e3b */
        {8,	0}, 	/* 0x5e3c */
        {8,	0}, 	/* 0x5e3d */
        {8,	0}, 	/* 0x5e3e */
        {8,	0}, 	/* 0x5e3f */
        {8,	0}, 	/* 0x5e40 */
        {8,	0}, 	/* 0x5e41 */
        {8,	0}, 	/* 0x5e42 */
        {8,	0}, 	/* 0x5e43 */
        {8,	0}, 	/* 0x5e44 */
        {8,	0}, 	/* 0x5e45 */
        {8,	0}, 	/* 0x5e46 */
        {8,	0}, 	/* 0x5e47 */
        {8,	0}, 	/* 0x5e48 */
        {8,	0}, 	/* 0x5e49 */
        {8,	0}, 	/* 0x5e4a */
        {8,	0}, 	/* 0x5e4b */
        {8,	0}, 	/* 0x5e4c */
        {8,	0}, 	/* 0x5e4d */
        {8,	0}, 	/* 0x5e4e */
        {8,	0}, 	/* 0x5e4f */
        {8,	0}, 	/* 0x5e50 */
        {8,	0}, 	/* 0x5e51 */
        {8,	0}, 	/* 0x5e52 */
        {8,	0}, 	/* 0x5e53 */
        {8,	0}, 	/* 0x5e54 */
        {8,	0}, 	/* 0x5e55 */
        {8,	0}, 	/* 0x5e56 */
        {8,	0}, 	/* 0x5e57 */
        {8,	0}, 	/* 0x5e58 */
        {8,	0}, 	/* 0x5e59 */
        {8,	0}, 	/* 0x5e5a */
        {8,	0}, 	/* 0x5e5b */
        {8,	0}, 	/* 0x5e5c */
        {8,	0}, 	/* 0x5e5d */
        {8,	0}, 	/* 0x5e5e */
        {8,	0}, 	/* 0x5e5f */
        {8,	0}, 	/* 0x5e60 */
        {8,	0}, 	/* 0x5e61 */
        {8,	0}, 	/* 0x5e62 */
        {8,	0}, 	/* 0x5e63 */
        {8,	0}, 	/* 0x5e64 */
        {8,	0}, 	/* 0x5e65 */
        {8,	0}, 	/* 0x5e66 */
        {8,	0}, 	/* 0x5e67 */
        {8,	0}, 	/* 0x5e68 */
        {8,	0}, 	/* 0x5e69 */
        {8,	0}, 	/* 0x5e6a */
        {8,	0}, 	/* 0x5e6b */
        {8,	0}, 	/* 0x5e6c */
        {8,	0}, 	/* 0x5e6d */
        {8,	0}, 	/* 0x5e6e */
        {8,	0}, 	/* 0x5e6f */
        {8,	0}, 	/* 0x5e70 */
        {8,	0}, 	/* 0x5e71 */
        {8,	0}, 	/* 0x5e72 */
        {8,	0}, 	/* 0x5e73 */
        {8,	0}, 	/* 0x5e74 */
        {8,	0}, 	/* 0x5e75 */
        {8,	0}, 	/* 0x5e76 */
        {8,	0}, 	/* 0x5e77 */
        {8,	0}, 	/* 0x5e78 */
        {8,	0}, 	/* 0x5e79 */
        {8,	0}, 	/* 0x5e7a */
        {8,	0}, 	/* 0x5e7b */
        {8,	0}, 	/* 0x5e7c */
        {8,	0}, 	/* 0x5e7d */
        {8,	0}, 	/* 0x5e7e */
        {8,	0}, 	/* 0x5e7f */
        {8,	0}, 	/* 0x5e80 */
        {8,	0}, 	/* 0x5e81 */
        {8,	0}, 	/* 0x5e82 */
        {8,	0}, 	/* 0x5e83 */
        {8,	0}, 	/* 0x5e84 */
        {8,	0}, 	/* 0x5e85 */
        {8,	0}, 	/* 0x5e86 */
        {8,	0}, 	/* 0x5e87 */
        {8,	0}, 	/* 0x5e88 */
        {8,	0}, 	/* 0x5e89 */
        {8,	0}, 	/* 0x5e8a */
        {8,	0}, 	/* 0x5e8b */
        {8,	0}, 	/* 0x5e8c */
        {8,	0}, 	/* 0x5e8d */
        {8,	0}, 	/* 0x5e8e */
        {8,	0}, 	/* 0x5e8f */
        {8,	0}, 	/* 0x5e90 */
        {8,	0}, 	/* 0x5e91 */
        {8,	0}, 	/* 0x5e92 */
        {8,	0}, 	/* 0x5e93 */
        {8,	0}, 	/* 0x5e94 */
        {8,	0}, 	/* 0x5e95 */
        {8,	0}, 	/* 0x5e96 */
        {8,	0}, 	/* 0x5e97 */
        {8,	0}, 	/* 0x5e98 */
        {8,	0}, 	/* 0x5e99 */
        {8,	0}, 	/* 0x5e9a */
        {8,	0}, 	/* 0x5e9b */
        {8,	0}, 	/* 0x5e9c */
        {8,	0}, 	/* 0x5e9d */
        {8,	0}, 	/* 0x5e9e */
        {8,	0}, 	/* 0x5e9f */
        {8,	0}, 	/* 0x5ea0 */
        {8,	0}, 	/* 0x5ea1 */
        {8,	0}, 	/* 0x5ea2 */
        {8,	0}, 	/* 0x5ea3 */
        {8,	0}, 	/* 0x5ea4 */
        {8,	0}, 	/* 0x5ea5 */
        {8,	0}, 	/* 0x5ea6 */
        {8,	0}, 	/* 0x5ea7 */
        {8,	0}, 	/* 0x5ea8 */
        {8,	0}, 	/* 0x5ea9 */
        {8,	0}, 	/* 0x5eaa */
        {8,	0}, 	/* 0x5eab */
        {8,	0}, 	/* 0x5eac */
        {8,	0}, 	/* 0x5ead */
        {8,	0}, 	/* 0x5eae */
        {8,	0}, 	/* 0x5eaf */
        {8,	0}, 	/* 0x5eb0 */
        {8,	0}, 	/* 0x5eb1 */
        {8,	0}, 	/* 0x5eb2 */
        {8,	0}, 	/* 0x5eb3 */
        {8,	0}, 	/* 0x5eb4 */
        {8,	0}, 	/* 0x5eb5 */
        {8,	0}, 	/* 0x5eb6 */
        {8,	0}, 	/* 0x5eb7 */
        {8,	0}, 	/* 0x5eb8 */
        {8,	0}, 	/* 0x5eb9 */
        {8,	0}, 	/* 0x5eba */
        {8,	0}, 	/* 0x5ebb */
        {8,	0}, 	/* 0x5ebc */
        {8,	0}, 	/* 0x5ebd */
        {8,	0}, 	/* 0x5ebe */
        {8,	0}, 	/* 0x5ebf */
        {8,	0}, 	/* 0x5ec0 */
        {8,	0}, 	/* 0x5ec1 */
        {8,	0}, 	/* 0x5ec2 */
        {8,	0}, 	/* 0x5ec3 */
        {8,	0}, 	/* 0x5ec4 */
        {8,	0}, 	/* 0x5ec5 */
        {8,	0}, 	/* 0x5ec6 */
        {8,	0}, 	/* 0x5ec7 */
        {8,	0}, 	/* 0x5ec8 */
        {8,	0}, 	/* 0x5ec9 */
        {8,	0}, 	/* 0x5eca */
        {8,	0}, 	/* 0x5ecb */
        {8,	0}, 	/* 0x5ecc */
        {8,	0}, 	/* 0x5ecd */
        {8,	0}, 	/* 0x5ece */
        {8,	0}, 	/* 0x5ecf */
        {8,	0}, 	/* 0x5ed0 */
        {8,	0}, 	/* 0x5ed1 */
        {8,	0}, 	/* 0x5ed2 */
        {8,	0}, 	/* 0x5ed3 */
        {8,	0}, 	/* 0x5ed4 */
        {8,	0}, 	/* 0x5ed5 */
        {8,	0}, 	/* 0x5ed6 */
        {8,	0}, 	/* 0x5ed7 */
        {8,	0}, 	/* 0x5ed8 */
        {8,	0}, 	/* 0x5ed9 */
        {8,	0}, 	/* 0x5eda */
        {8,	0}, 	/* 0x5edb */
        {8,	0}, 	/* 0x5edc */
        {8,	0}, 	/* 0x5edd */
        {8,	0}, 	/* 0x5ede */
        {8,	0}, 	/* 0x5edf */
        {8,	0}, 	/* 0x5ee0 */
        {8,	0}, 	/* 0x5ee1 */
        {8,	0}, 	/* 0x5ee2 */
        {8,	0}, 	/* 0x5ee3 */
        {8,	0}, 	/* 0x5ee4 */
        {8,	0}, 	/* 0x5ee5 */
        {8,	0}, 	/* 0x5ee6 */
        {8,	0}, 	/* 0x5ee7 */
        {8,	0}, 	/* 0x5ee8 */
        {8,	0}, 	/* 0x5ee9 */
        {8,	0}, 	/* 0x5eea */
        {8,	0}, 	/* 0x5eeb */
        {8,	0}, 	/* 0x5eec */
        {8,	0}, 	/* 0x5eed */
        {8,	0}, 	/* 0x5eee */
        {8,	0}, 	/* 0x5eef */
        {8,	0}, 	/* 0x5ef0 */
        {8,	0}, 	/* 0x5ef1 */
        {8,	0}, 	/* 0x5ef2 */
        {8,	0}, 	/* 0x5ef3 */
        {8,	0}, 	/* 0x5ef4 */
        {8,	0}, 	/* 0x5ef5 */
        {8,	0}, 	/* 0x5ef6 */
        {8,	0}, 	/* 0x5ef7 */
        {8,	0}, 	/* 0x5ef8 */
        {8,	0}, 	/* 0x5ef9 */
        {8,	0}, 	/* 0x5efa */
        {8,	0}, 	/* 0x5efb */
        {8,	0}, 	/* 0x5efc */
        {8,	0}, 	/* 0x5efd */
        {8,	0}, 	/* 0x5efe */
        {8,	0}, 	/* 0x5eff */
        {8,	0}, 	/* 0x5f00 */
        {8,	0}, 	/* 0x5f01 */
        {8,	0}, 	/* 0x5f02 */
        {8,	0}, 	/* 0x5f03 */
        {8,	0}, 	/* 0x5f04 */
        {8,	0}, 	/* 0x5f05 */
        {8,	0}, 	/* 0x5f06 */
        {8,	0}, 	/* 0x5f07 */
        {8,	0}, 	/* 0x5f08 */
        {8,	0}, 	/* 0x5f09 */
        {8,	0}, 	/* 0x5f0a */
        {8,	0}, 	/* 0x5f0b */
        {8,	0}, 	/* 0x5f0c */
        {8,	0}, 	/* 0x5f0d */
        {8,	0}, 	/* 0x5f0e */
        {8,	0}, 	/* 0x5f0f */
        {8,	0}, 	/* 0x5f10 */
        {8,	0}, 	/* 0x5f11 */
        {8,	0}, 	/* 0x5f12 */
        {8,	0}, 	/* 0x5f13 */
        {8,	0}, 	/* 0x5f14 */
        {8,	0}, 	/* 0x5f15 */
        {8,	0}, 	/* 0x5f16 */
        {8,	0}, 	/* 0x5f17 */
        {8,	0}, 	/* 0x5f18 */
        {8,	0}, 	/* 0x5f19 */
        {8,	0}, 	/* 0x5f1a */
        {8,	0}, 	/* 0x5f1b */
        {8,	0}, 	/* 0x5f1c */
        {8,	0}, 	/* 0x5f1d */
        {8,	0}, 	/* 0x5f1e */
        {8,	0}, 	/* 0x5f1f */
        {8,	0}, 	/* 0x5f20 */
        {8,	0}, 	/* 0x5f21 */
        {8,	0}, 	/* 0x5f22 */
        {8,	0}, 	/* 0x5f23 */
        {8,	0}, 	/* 0x5f24 */
        {8,	0}, 	/* 0x5f25 */
        {8,	0}, 	/* 0x5f26 */
        {8,	0}, 	/* 0x5f27 */
        {8,	0}, 	/* 0x5f28 */
        {8,	0}, 	/* 0x5f29 */
        {8,	0}, 	/* 0x5f2a */
        {8,	0}, 	/* 0x5f2b */
        {8,	0}, 	/* 0x5f2c */
        {8,	0}, 	/* 0x5f2d */
        {8,	0}, 	/* 0x5f2e */
        {8,	0}, 	/* 0x5f2f */
        {8,	0}, 	/* 0x5f30 */
        {8,	0}, 	/* 0x5f31 */
        {8,	0}, 	/* 0x5f32 */
        {8,	0}, 	/* 0x5f33 */
        {8,	0}, 	/* 0x5f34 */
        {8,	0}, 	/* 0x5f35 */
        {8,	0}, 	/* 0x5f36 */
        {8,	0}, 	/* 0x5f37 */
        {8,	0}, 	/* 0x5f38 */
        {8,	0}, 	/* 0x5f39 */
        {8,	0}, 	/* 0x5f3a */
        {8,	0}, 	/* 0x5f3b */
        {8,	0}, 	/* 0x5f3c */
        {8,	0}, 	/* 0x5f3d */
        {8,	0}, 	/* 0x5f3e */
        {8,	0}, 	/* 0x5f3f */
        {8,	0}, 	/* 0x5f40 */
        {8,	0}, 	/* 0x5f41 */
        {8,	0}, 	/* 0x5f42 */
        {8,	0}, 	/* 0x5f43 */
        {8,	0}, 	/* 0x5f44 */
        {8,	0}, 	/* 0x5f45 */
        {8,	0}, 	/* 0x5f46 */
        {8,	0}, 	/* 0x5f47 */
        {8,	0}, 	/* 0x5f48 */
        {8,	0}, 	/* 0x5f49 */
        {8,	0}, 	/* 0x5f4a */
        {8,	0}, 	/* 0x5f4b */
        {8,	0}, 	/* 0x5f4c */
        {8,	0}, 	/* 0x5f4d */
        {8,	0}, 	/* 0x5f4e */
        {8,	0}, 	/* 0x5f4f */
        {8,	0}, 	/* 0x5f50 */
        {8,	0}, 	/* 0x5f51 */
        {8,	0}, 	/* 0x5f52 */
        {8,	0}, 	/* 0x5f53 */
        {8,	0}, 	/* 0x5f54 */
        {8,	0}, 	/* 0x5f55 */
        {8,	0}, 	/* 0x5f56 */
        {8,	0}, 	/* 0x5f57 */
        {8,	0}, 	/* 0x5f58 */
        {8,	0}, 	/* 0x5f59 */
        {8,	0}, 	/* 0x5f5a */
        {8,	0}, 	/* 0x5f5b */
        {8,	0}, 	/* 0x5f5c */
        {8,	0}, 	/* 0x5f5d */
        {8,	0}, 	/* 0x5f5e */
        {8,	0}, 	/* 0x5f5f */
        {8,	0}, 	/* 0x5f60 */
        {8,	0}, 	/* 0x5f61 */
        {8,	0}, 	/* 0x5f62 */
        {8,	0}, 	/* 0x5f63 */
        {8,	0}, 	/* 0x5f64 */
        {8,	0}, 	/* 0x5f65 */
        {8,	0}, 	/* 0x5f66 */
        {8,	0}, 	/* 0x5f67 */
        {8,	0}, 	/* 0x5f68 */
        {8,	0}, 	/* 0x5f69 */
        {8,	0}, 	/* 0x5f6a */
        {8,	0}, 	/* 0x5f6b */
        {8,	0}, 	/* 0x5f6c */
        {8,	0}, 	/* 0x5f6d */
        {8,	0}, 	/* 0x5f6e */
        {8,	0}, 	/* 0x5f6f */
        {8,	0}, 	/* 0x5f70 */
        {8,	0}, 	/* 0x5f71 */
        {8,	0}, 	/* 0x5f72 */
        {8,	0}, 	/* 0x5f73 */
        {8,	0}, 	/* 0x5f74 */
        {8,	0}, 	/* 0x5f75 */
        {8,	0}, 	/* 0x5f76 */
        {8,	0}, 	/* 0x5f77 */
        {8,	0}, 	/* 0x5f78 */
        {8,	0}, 	/* 0x5f79 */
        {8,	0}, 	/* 0x5f7a */
        {8,	0}, 	/* 0x5f7b */
        {8,	0}, 	/* 0x5f7c */
        {8,	0}, 	/* 0x5f7d */
        {8,	0}, 	/* 0x5f7e */
        {8,	0}, 	/* 0x5f7f */
        {8,	0}, 	/* 0x5f80 */
        {8,	0}, 	/* 0x5f81 */
        {8,	0}, 	/* 0x5f82 */
        {8,	0}, 	/* 0x5f83 */
        {8,	0}, 	/* 0x5f84 */
        {8,	0}, 	/* 0x5f85 */
        {8,	0}, 	/* 0x5f86 */
        {8,	0}, 	/* 0x5f87 */
        {8,	0}, 	/* 0x5f88 */
        {8,	0}, 	/* 0x5f89 */
        {8,	0}, 	/* 0x5f8a */
        {8,	0}, 	/* 0x5f8b */
        {8,	0}, 	/* 0x5f8c */
        {8,	0}, 	/* 0x5f8d */
        {8,	0}, 	/* 0x5f8e */
        {8,	0}, 	/* 0x5f8f */
        {8,	0}, 	/* 0x5f90 */
        {8,	0}, 	/* 0x5f91 */
        {8,	0}, 	/* 0x5f92 */
        {8,	0}, 	/* 0x5f93 */
        {8,	0}, 	/* 0x5f94 */
        {8,	0}, 	/* 0x5f95 */
        {8,	0}, 	/* 0x5f96 */
        {8,	0}, 	/* 0x5f97 */
        {8,	0}, 	/* 0x5f98 */
        {8,	0}, 	/* 0x5f99 */
        {8,	0}, 	/* 0x5f9a */
        {8,	0}, 	/* 0x5f9b */
        {8,	0}, 	/* 0x5f9c */
        {8,	0}, 	/* 0x5f9d */
        {8,	0}, 	/* 0x5f9e */
        {8,	0}, 	/* 0x5f9f */
        {8,	0}, 	/* 0x5fa0 */
        {8,	0}, 	/* 0x5fa1 */
        {8,	0}, 	/* 0x5fa2 */
        {8,	0}, 	/* 0x5fa3 */
        {8,	0}, 	/* 0x5fa4 */
        {8,	0}, 	/* 0x5fa5 */
        {8,	0}, 	/* 0x5fa6 */
        {8,	0}, 	/* 0x5fa7 */
        {8,	0}, 	/* 0x5fa8 */
        {8,	0}, 	/* 0x5fa9 */
        {8,	0}, 	/* 0x5faa */
        {8,	0}, 	/* 0x5fab */
        {8,	0}, 	/* 0x5fac */
        {8,	0}, 	/* 0x5fad */
        {8,	0}, 	/* 0x5fae */
        {8,	0}, 	/* 0x5faf */
        {8,	0}, 	/* 0x5fb0 */
        {8,	0}, 	/* 0x5fb1 */
        {8,	0}, 	/* 0x5fb2 */
        {8,	0}, 	/* 0x5fb3 */
        {8,	0}, 	/* 0x5fb4 */
        {8,	0}, 	/* 0x5fb5 */
        {8,	0}, 	/* 0x5fb6 */
        {8,	0}, 	/* 0x5fb7 */
        {8,	0}, 	/* 0x5fb8 */
        {8,	0}, 	/* 0x5fb9 */
        {8,	0}, 	/* 0x5fba */
        {8,	0}, 	/* 0x5fbb */
        {8,	0}, 	/* 0x5fbc */
        {8,	0}, 	/* 0x5fbd */
        {8,	0}, 	/* 0x5fbe */
        {8,	0}, 	/* 0x5fbf */
        {8,	0}, 	/* 0x5fc0 */
        {8,	0}, 	/* 0x5fc1 */
        {8,	0}, 	/* 0x5fc2 */
        {8,	0}, 	/* 0x5fc3 */
        {8,	0}, 	/* 0x5fc4 */
        {8,	0}, 	/* 0x5fc5 */
        {8,	0}, 	/* 0x5fc6 */
        {8,	0}, 	/* 0x5fc7 */
        {8,	0}, 	/* 0x5fc8 */
        {8,	0}, 	/* 0x5fc9 */
        {8,	0}, 	/* 0x5fca */
        {8,	0}, 	/* 0x5fcb */
        {8,	0}, 	/* 0x5fcc */
        {8,	0}, 	/* 0x5fcd */
        {8,	0}, 	/* 0x5fce */
        {8,	0}, 	/* 0x5fcf */
        {8,	0}, 	/* 0x5fd0 */
        {8,	0}, 	/* 0x5fd1 */
        {8,	0}, 	/* 0x5fd2 */
        {8,	0}, 	/* 0x5fd3 */
        {8,	0}, 	/* 0x5fd4 */
        {8,	0}, 	/* 0x5fd5 */
        {8,	0}, 	/* 0x5fd6 */
        {8,	0}, 	/* 0x5fd7 */
        {8,	0}, 	/* 0x5fd8 */
        {8,	0}, 	/* 0x5fd9 */
        {8,	0}, 	/* 0x5fda */
        {8,	0}, 	/* 0x5fdb */
        {8,	0}, 	/* 0x5fdc */
        {8,	0}, 	/* 0x5fdd */
        {8,	0}, 	/* 0x5fde */
        {8,	0}, 	/* 0x5fdf */
        {8,	0}, 	/* 0x5fe0 */
        {8,	0}, 	/* 0x5fe1 */
        {8,	0}, 	/* 0x5fe2 */
        {8,	0}, 	/* 0x5fe3 */
        {8,	0}, 	/* 0x5fe4 */
        {8,	0}, 	/* 0x5fe5 */
        {8,	0}, 	/* 0x5fe6 */
        {8,	0}, 	/* 0x5fe7 */
        {8,	0}, 	/* 0x5fe8 */
        {8,	0}, 	/* 0x5fe9 */
        {8,	0}, 	/* 0x5fea */
        {8,	0}, 	/* 0x5feb */
        {8,	0}, 	/* 0x5fec */
        {8,	0}, 	/* 0x5fed */
        {8,	0}, 	/* 0x5fee */
        {8,	0}, 	/* 0x5fef */
        {8,	0}, 	/* 0x5ff0 */
        {8,	0}, 	/* 0x5ff1 */
        {8,	0}, 	/* 0x5ff2 */
        {8,	0}, 	/* 0x5ff3 */
        {8,	0}, 	/* 0x5ff4 */
        {8,	0}, 	/* 0x5ff5 */
        {8,	0}, 	/* 0x5ff6 */
        {8,	0}, 	/* 0x5ff7 */
        {8,	0}, 	/* 0x5ff8 */
        {8,	0}, 	/* 0x5ff9 */
        {8,	0}, 	/* 0x5ffa */
        {8,	0}, 	/* 0x5ffb */
        {8,	0}, 	/* 0x5ffc */
        {8,	0}, 	/* 0x5ffd */
        {8,	0}, 	/* 0x5ffe */
        {8,	0}, 	/* 0x5fff */
        {8,	0}, 	/* 0x6000 */
        {8,	0}, 	/* 0x6001 */
        {8,	0}, 	/* 0x6002 */
        {8,	0}, 	/* 0x6003 */
        {8,	0}, 	/* 0x6004 */
        {8,	0}, 	/* 0x6005 */
        {8,	0}, 	/* 0x6006 */
        {8,	0}, 	/* 0x6007 */
        {8,	0}, 	/* 0x6008 */
        {8,	0}, 	/* 0x6009 */
        {8,	0}, 	/* 0x600a */
        {8,	0}, 	/* 0x600b */
        {8,	0}, 	/* 0x600c */
        {8,	0}, 	/* 0x600d */
        {8,	0}, 	/* 0x600e */
        {8,	0}, 	/* 0x600f */
        {8,	0}, 	/* 0x6010 */
        {8,	0}, 	/* 0x6011 */
        {8,	0}, 	/* 0x6012 */
        {8,	0}, 	/* 0x6013 */
        {8,	0}, 	/* 0x6014 */
        {8,	0}, 	/* 0x6015 */
        {8,	0}, 	/* 0x6016 */
        {8,	0}, 	/* 0x6017 */
        {8,	0}, 	/* 0x6018 */
        {8,	0}, 	/* 0x6019 */
        {8,	0}, 	/* 0x601a */
        {8,	0}, 	/* 0x601b */
        {8,	0}, 	/* 0x601c */
        {8,	0}, 	/* 0x601d */
        {8,	0}, 	/* 0x601e */
        {8,	0}, 	/* 0x601f */
        {8,	0}, 	/* 0x6020 */
        {8,	0}, 	/* 0x6021 */
        {8,	0}, 	/* 0x6022 */
        {8,	0}, 	/* 0x6023 */
        {8,	0}, 	/* 0x6024 */
        {8,	0}, 	/* 0x6025 */
        {8,	0}, 	/* 0x6026 */
        {8,	0}, 	/* 0x6027 */
        {8,	0}, 	/* 0x6028 */
        {8,	0}, 	/* 0x6029 */
        {8,	0}, 	/* 0x602a */
        {8,	0}, 	/* 0x602b */
        {8,	0}, 	/* 0x602c */
        {8,	0}, 	/* 0x602d */
        {8,	0}, 	/* 0x602e */
        {8,	0}, 	/* 0x602f */
        {8,	0}, 	/* 0x6030 */
        {8,	0}, 	/* 0x6031 */
        {8,	0}, 	/* 0x6032 */
        {8,	0}, 	/* 0x6033 */
        {8,	0}, 	/* 0x6034 */
        {8,	0}, 	/* 0x6035 */
        {8,	0}, 	/* 0x6036 */
        {8,	0}, 	/* 0x6037 */
        {8,	0}, 	/* 0x6038 */
        {8,	0}, 	/* 0x6039 */
        {8,	0}, 	/* 0x603a */
        {8,	0}, 	/* 0x603b */
        {8,	0}, 	/* 0x603c */
        {8,	0}, 	/* 0x603d */
        {8,	0}, 	/* 0x603e */
        {8,	0}, 	/* 0x603f */
        {8,	0}, 	/* 0x6040 */
        {8,	0}, 	/* 0x6041 */
        {8,	0}, 	/* 0x6042 */
        {8,	0}, 	/* 0x6043 */
        {8,	0}, 	/* 0x6044 */
        {8,	0}, 	/* 0x6045 */
        {8,	0}, 	/* 0x6046 */
        {8,	0}, 	/* 0x6047 */
        {8,	0}, 	/* 0x6048 */
        {8,	0}, 	/* 0x6049 */
        {8,	0}, 	/* 0x604a */
        {8,	0}, 	/* 0x604b */
        {8,	0}, 	/* 0x604c */
        {8,	0}, 	/* 0x604d */
        {8,	0}, 	/* 0x604e */
        {8,	0}, 	/* 0x604f */
        {8,	0}, 	/* 0x6050 */
        {8,	0}, 	/* 0x6051 */
        {8,	0}, 	/* 0x6052 */
        {8,	0}, 	/* 0x6053 */
        {8,	0}, 	/* 0x6054 */
        {8,	0}, 	/* 0x6055 */
        {8,	0}, 	/* 0x6056 */
        {8,	0}, 	/* 0x6057 */
        {8,	0}, 	/* 0x6058 */
        {8,	0}, 	/* 0x6059 */
        {8,	0}, 	/* 0x605a */
        {8,	0}, 	/* 0x605b */
        {8,	0}, 	/* 0x605c */
        {8,	0}, 	/* 0x605d */
        {8,	0}, 	/* 0x605e */
        {8,	0}, 	/* 0x605f */
        {8,	0}, 	/* 0x6060 */
        {8,	0}, 	/* 0x6061 */
        {8,	0}, 	/* 0x6062 */
        {8,	0}, 	/* 0x6063 */
        {8,	0}, 	/* 0x6064 */
        {8,	0}, 	/* 0x6065 */
        {8,	0}, 	/* 0x6066 */
        {8,	0}, 	/* 0x6067 */
        {8,	0}, 	/* 0x6068 */
        {8,	0}, 	/* 0x6069 */
        {8,	0}, 	/* 0x606a */
        {8,	0}, 	/* 0x606b */
        {8,	0}, 	/* 0x606c */
        {8,	0}, 	/* 0x606d */
        {8,	0}, 	/* 0x606e */
        {8,	0}, 	/* 0x606f */
        {8,	0}, 	/* 0x6070 */
        {8,	0}, 	/* 0x6071 */
        {8,	0}, 	/* 0x6072 */
        {8,	0}, 	/* 0x6073 */
        {8,	0}, 	/* 0x6074 */
        {8,	0}, 	/* 0x6075 */
        {8,	0}, 	/* 0x6076 */
        {8,	0}, 	/* 0x6077 */
        {8,	0}, 	/* 0x6078 */
        {8,	0}, 	/* 0x6079 */
        {8,	0}, 	/* 0x607a */
        {8,	0}, 	/* 0x607b */
        {8,	0}, 	/* 0x607c */
        {8,	0}, 	/* 0x607d */
        {8,	0}, 	/* 0x607e */
        {8,	0}, 	/* 0x607f */
        {8,	0}, 	/* 0x6080 */
        {8,	0}, 	/* 0x6081 */
        {8,	0}, 	/* 0x6082 */
        {8,	0}, 	/* 0x6083 */
        {8,	0}, 	/* 0x6084 */
        {8,	0}, 	/* 0x6085 */
        {8,	0}, 	/* 0x6086 */
        {8,	0}, 	/* 0x6087 */
        {8,	0}, 	/* 0x6088 */
        {8,	0}, 	/* 0x6089 */
        {8,	0}, 	/* 0x608a */
        {8,	0}, 	/* 0x608b */
        {8,	0}, 	/* 0x608c */
        {8,	0}, 	/* 0x608d */
        {8,	0}, 	/* 0x608e */
        {8,	0}, 	/* 0x608f */
        {8,	0}, 	/* 0x6090 */
        {8,	0}, 	/* 0x6091 */
        {8,	0}, 	/* 0x6092 */
        {8,	0}, 	/* 0x6093 */
        {8,	0}, 	/* 0x6094 */
        {8,	0}, 	/* 0x6095 */
        {8,	0}, 	/* 0x6096 */
        {8,	0}, 	/* 0x6097 */
        {8,	0}, 	/* 0x6098 */
        {8,	0}, 	/* 0x6099 */
        {8,	0}, 	/* 0x609a */
        {8,	0}, 	/* 0x609b */
        {8,	0}, 	/* 0x609c */
        {8,	0}, 	/* 0x609d */
        {8,	0}, 	/* 0x609e */
        {8,	0}, 	/* 0x609f */
        {8,	0}, 	/* 0x60a0 */
        {8,	0}, 	/* 0x60a1 */
        {8,	0}, 	/* 0x60a2 */
        {8,	0}, 	/* 0x60a3 */
        {8,	0}, 	/* 0x60a4 */
        {8,	0}, 	/* 0x60a5 */
        {8,	0}, 	/* 0x60a6 */
        {8,	0}, 	/* 0x60a7 */
        {8,	0}, 	/* 0x60a8 */
        {8,	0}, 	/* 0x60a9 */
        {8,	0}, 	/* 0x60aa */
        {8,	0}, 	/* 0x60ab */
        {8,	0}, 	/* 0x60ac */
        {8,	0}, 	/* 0x60ad */
        {8,	0}, 	/* 0x60ae */
        {8,	0}, 	/* 0x60af */
        {8,	0}, 	/* 0x60b0 */
        {8,	0}, 	/* 0x60b1 */
        {8,	0}, 	/* 0x60b2 */
        {8,	0}, 	/* 0x60b3 */
        {8,	0}, 	/* 0x60b4 */
        {8,	0}, 	/* 0x60b5 */
        {8,	0}, 	/* 0x60b6 */
        {8,	0}, 	/* 0x60b7 */
        {8,	0}, 	/* 0x60b8 */
        {8,	0}, 	/* 0x60b9 */
        {8,	0}, 	/* 0x60ba */
        {8,	0}, 	/* 0x60bb */
        {8,	0}, 	/* 0x60bc */
        {8,	0}, 	/* 0x60bd */
        {8,	0}, 	/* 0x60be */
        {8,	0}, 	/* 0x60bf */
        {8,	0}, 	/* 0x60c0 */
        {8,	0}, 	/* 0x60c1 */
        {8,	0}, 	/* 0x60c2 */
        {8,	0}, 	/* 0x60c3 */
        {8,	0}, 	/* 0x60c4 */
        {8,	0}, 	/* 0x60c5 */
        {8,	0}, 	/* 0x60c6 */
        {8,	0}, 	/* 0x60c7 */
        {8,	0}, 	/* 0x60c8 */
        {8,	0}, 	/* 0x60c9 */
        {8,	0}, 	/* 0x60ca */
        {8,	0}, 	/* 0x60cb */
        {8,	0}, 	/* 0x60cc */
        {8,	0}, 	/* 0x60cd */
        {8,	0}, 	/* 0x60ce */
        {8,	0}, 	/* 0x60cf */
        {8,	0}, 	/* 0x60d0 */
        {8,	0}, 	/* 0x60d1 */
        {8,	0}, 	/* 0x60d2 */
        {8,	0}, 	/* 0x60d3 */
        {8,	0}, 	/* 0x60d4 */
        {8,	0}, 	/* 0x60d5 */
        {8,	0}, 	/* 0x60d6 */
        {8,	0}, 	/* 0x60d7 */
        {8,	0}, 	/* 0x60d8 */
        {8,	0}, 	/* 0x60d9 */
        {8,	0}, 	/* 0x60da */
        {8,	0}, 	/* 0x60db */
        {8,	0}, 	/* 0x60dc */
        {8,	0}, 	/* 0x60dd */
        {8,	0}, 	/* 0x60de */
        {8,	0}, 	/* 0x60df */
        {8,	0}, 	/* 0x60e0 */
        {8,	0}, 	/* 0x60e1 */
        {8,	0}, 	/* 0x60e2 */
        {8,	0}, 	/* 0x60e3 */
        {8,	0}, 	/* 0x60e4 */
        {8,	0}, 	/* 0x60e5 */
        {8,	0}, 	/* 0x60e6 */
        {8,	0}, 	/* 0x60e7 */
        {8,	0}, 	/* 0x60e8 */
        {8,	0}, 	/* 0x60e9 */
        {8,	0}, 	/* 0x60ea */
        {8,	0}, 	/* 0x60eb */
        {8,	0}, 	/* 0x60ec */
        {8,	0}, 	/* 0x60ed */
        {8,	0}, 	/* 0x60ee */
        {8,	0}, 	/* 0x60ef */
        {8,	0}, 	/* 0x60f0 */
        {8,	0}, 	/* 0x60f1 */
        {8,	0}, 	/* 0x60f2 */
        {8,	0}, 	/* 0x60f3 */
        {8,	0}, 	/* 0x60f4 */
        {8,	0}, 	/* 0x60f5 */
        {8,	0}, 	/* 0x60f6 */
        {8,	0}, 	/* 0x60f7 */
        {8,	0}, 	/* 0x60f8 */
        {8,	0}, 	/* 0x60f9 */
        {8,	0}, 	/* 0x60fa */
        {8,	0}, 	/* 0x60fb */
        {8,	0}, 	/* 0x60fc */
        {8,	0}, 	/* 0x60fd */
        {8,	0}, 	/* 0x60fe */
        {8,	0}, 	/* 0x60ff */
        {8,	0}, 	/* 0x6100 */
        {8,	0}, 	/* 0x6101 */
        {8,	0}, 	/* 0x6102 */
        {8,	0}, 	/* 0x6103 */
        {8,	0}, 	/* 0x6104 */
        {8,	0}, 	/* 0x6105 */
        {8,	0}, 	/* 0x6106 */
        {8,	0}, 	/* 0x6107 */
        {8,	0}, 	/* 0x6108 */
        {8,	0}, 	/* 0x6109 */
        {8,	0}, 	/* 0x610a */
        {8,	0}, 	/* 0x610b */
        {8,	0}, 	/* 0x610c */
        {8,	0}, 	/* 0x610d */
        {8,	0}, 	/* 0x610e */
        {8,	0}, 	/* 0x610f */
        {8,	0}, 	/* 0x6110 */
        {8,	0}, 	/* 0x6111 */
        {8,	0}, 	/* 0x6112 */
        {8,	0}, 	/* 0x6113 */
        {8,	0}, 	/* 0x6114 */
        {8,	0}, 	/* 0x6115 */
        {8,	0}, 	/* 0x6116 */
        {8,	0}, 	/* 0x6117 */
        {8,	0}, 	/* 0x6118 */
        {8,	0}, 	/* 0x6119 */
        {8,	0}, 	/* 0x611a */
        {8,	0}, 	/* 0x611b */
        {8,	0}, 	/* 0x611c */
        {8,	0}, 	/* 0x611d */
        {8,	0}, 	/* 0x611e */
        {8,	0}, 	/* 0x611f */
        {8,	0}, 	/* 0x6120 */
        {8,	0}, 	/* 0x6121 */
        {8,	0}, 	/* 0x6122 */
        {8,	0}, 	/* 0x6123 */
        {8,	0}, 	/* 0x6124 */
        {8,	0}, 	/* 0x6125 */
        {8,	0}, 	/* 0x6126 */
        {8,	0}, 	/* 0x6127 */
        {8,	0}, 	/* 0x6128 */
        {8,	0}, 	/* 0x6129 */
        {8,	0}, 	/* 0x612a */
        {8,	0}, 	/* 0x612b */
        {8,	0}, 	/* 0x612c */
        {8,	0}, 	/* 0x612d */
        {8,	0}, 	/* 0x612e */
        {8,	0}, 	/* 0x612f */
        {8,	0}, 	/* 0x6130 */
        {8,	0}, 	/* 0x6131 */
        {8,	0}, 	/* 0x6132 */
        {8,	0}, 	/* 0x6133 */
        {8,	0}, 	/* 0x6134 */
        {8,	0}, 	/* 0x6135 */
        {8,	0}, 	/* 0x6136 */
        {8,	0}, 	/* 0x6137 */
        {8,	0}, 	/* 0x6138 */
        {8,	0}, 	/* 0x6139 */
        {8,	0}, 	/* 0x613a */
        {8,	0}, 	/* 0x613b */
        {8,	0}, 	/* 0x613c */
        {8,	0}, 	/* 0x613d */
        {8,	0}, 	/* 0x613e */
        {8,	0}, 	/* 0x613f */
        {8,	0}, 	/* 0x6140 */
        {8,	0}, 	/* 0x6141 */
        {8,	0}, 	/* 0x6142 */
        {8,	0}, 	/* 0x6143 */
        {8,	0}, 	/* 0x6144 */
        {8,	0}, 	/* 0x6145 */
        {8,	0}, 	/* 0x6146 */
        {8,	0}, 	/* 0x6147 */
        {8,	0}, 	/* 0x6148 */
        {8,	0}, 	/* 0x6149 */
        {8,	0}, 	/* 0x614a */
        {8,	0}, 	/* 0x614b */
        {8,	0}, 	/* 0x614c */
        {8,	0}, 	/* 0x614d */
        {8,	0}, 	/* 0x614e */
        {8,	0}, 	/* 0x614f */
        {8,	0}, 	/* 0x6150 */
        {8,	0}, 	/* 0x6151 */
        {8,	0}, 	/* 0x6152 */
        {8,	0}, 	/* 0x6153 */
        {8,	0}, 	/* 0x6154 */
        {8,	0}, 	/* 0x6155 */
        {8,	0}, 	/* 0x6156 */
        {8,	0}, 	/* 0x6157 */
        {8,	0}, 	/* 0x6158 */
        {8,	0}, 	/* 0x6159 */
        {8,	0}, 	/* 0x615a */
        {8,	0}, 	/* 0x615b */
        {8,	0}, 	/* 0x615c */
        {8,	0}, 	/* 0x615d */
        {8,	0}, 	/* 0x615e */
        {8,	0}, 	/* 0x615f */
        {8,	0}, 	/* 0x6160 */
        {8,	0}, 	/* 0x6161 */
        {8,	0}, 	/* 0x6162 */
        {8,	0}, 	/* 0x6163 */
        {8,	0}, 	/* 0x6164 */
        {8,	0}, 	/* 0x6165 */
        {8,	0}, 	/* 0x6166 */
        {8,	0}, 	/* 0x6167 */
        {8,	0}, 	/* 0x6168 */
        {8,	0}, 	/* 0x6169 */
        {8,	0}, 	/* 0x616a */
        {8,	0}, 	/* 0x616b */
        {8,	0}, 	/* 0x616c */
        {8,	0}, 	/* 0x616d */
        {8,	0}, 	/* 0x616e */
        {8,	0}, 	/* 0x616f */
        {8,	0}, 	/* 0x6170 */
        {8,	0}, 	/* 0x6171 */
        {8,	0}, 	/* 0x6172 */
        {8,	0}, 	/* 0x6173 */
        {8,	0}, 	/* 0x6174 */
        {8,	0}, 	/* 0x6175 */
        {8,	0}, 	/* 0x6176 */
        {8,	0}, 	/* 0x6177 */
        {8,	0}, 	/* 0x6178 */
        {8,	0}, 	/* 0x6179 */
        {8,	0}, 	/* 0x617a */
        {8,	0}, 	/* 0x617b */
        {8,	0}, 	/* 0x617c */
        {8,	0}, 	/* 0x617d */
        {8,	0}, 	/* 0x617e */
        {8,	0}, 	/* 0x617f */
        {8,	0}, 	/* 0x6180 */
        {8,	0}, 	/* 0x6181 */
        {8,	0}, 	/* 0x6182 */
        {8,	0}, 	/* 0x6183 */
        {8,	0}, 	/* 0x6184 */
        {8,	0}, 	/* 0x6185 */
        {8,	0}, 	/* 0x6186 */
        {8,	0}, 	/* 0x6187 */
        {8,	0}, 	/* 0x6188 */
        {8,	0}, 	/* 0x6189 */
        {8,	0}, 	/* 0x618a */
        {8,	0}, 	/* 0x618b */
        {8,	0}, 	/* 0x618c */
        {8,	0}, 	/* 0x618d */
        {8,	0}, 	/* 0x618e */
        {8,	0}, 	/* 0x618f */
        {8,	0}, 	/* 0x6190 */
        {8,	0}, 	/* 0x6191 */
        {8,	0}, 	/* 0x6192 */
        {8,	0}, 	/* 0x6193 */
        {8,	0}, 	/* 0x6194 */
        {8,	0}, 	/* 0x6195 */
        {8,	0}, 	/* 0x6196 */
        {8,	0}, 	/* 0x6197 */
        {8,	0}, 	/* 0x6198 */
        {8,	0}, 	/* 0x6199 */
        {8,	0}, 	/* 0x619a */
        {8,	0}, 	/* 0x619b */
        {8,	0}, 	/* 0x619c */
        {8,	0}, 	/* 0x619d */
        {8,	0}, 	/* 0x619e */
        {8,	0}, 	/* 0x619f */
        {8,	0}, 	/* 0x61a0 */
        {8,	0}, 	/* 0x61a1 */
        {8,	0}, 	/* 0x61a2 */
        {8,	0}, 	/* 0x61a3 */
        {8,	0}, 	/* 0x61a4 */
        {8,	0}, 	/* 0x61a5 */
        {8,	0}, 	/* 0x61a6 */
        {8,	0}, 	/* 0x61a7 */
        {8,	0}, 	/* 0x61a8 */
        {8,	0}, 	/* 0x61a9 */
        {8,	0}, 	/* 0x61aa */
        {8,	0}, 	/* 0x61ab */
        {8,	0}, 	/* 0x61ac */
        {8,	0}, 	/* 0x61ad */
        {8,	0}, 	/* 0x61ae */
        {8,	0}, 	/* 0x61af */
        {8,	0}, 	/* 0x61b0 */
        {8,	0}, 	/* 0x61b1 */
        {8,	0}, 	/* 0x61b2 */
        {8,	0}, 	/* 0x61b3 */
        {8,	0}, 	/* 0x61b4 */
        {8,	0}, 	/* 0x61b5 */
        {8,	0}, 	/* 0x61b6 */
        {8,	0}, 	/* 0x61b7 */
        {8,	0}, 	/* 0x61b8 */
        {8,	0}, 	/* 0x61b9 */
        {8,	0}, 	/* 0x61ba */
        {8,	0}, 	/* 0x61bb */
        {8,	0}, 	/* 0x61bc */
        {8,	0}, 	/* 0x61bd */
        {8,	0}, 	/* 0x61be */
        {8,	0}, 	/* 0x61bf */
        {8,	0}, 	/* 0x61c0 */
        {8,	0}, 	/* 0x61c1 */
        {8,	0}, 	/* 0x61c2 */
        {8,	0}, 	/* 0x61c3 */
        {8,	0}, 	/* 0x61c4 */
        {8,	0}, 	/* 0x61c5 */
        {8,	0}, 	/* 0x61c6 */
        {8,	0}, 	/* 0x61c7 */
        {8,	0}, 	/* 0x61c8 */
        {8,	0}, 	/* 0x61c9 */
        {8,	0}, 	/* 0x61ca */
        {8,	0}, 	/* 0x61cb */
        {8,	0}, 	/* 0x61cc */
        {8,	0}, 	/* 0x61cd */
        {8,	0}, 	/* 0x61ce */
        {8,	0}, 	/* 0x61cf */
        {8,	0}, 	/* 0x61d0 */
        {8,	0}, 	/* 0x61d1 */
        {8,	0}, 	/* 0x61d2 */
        {8,	0}, 	/* 0x61d3 */
        {8,	0}, 	/* 0x61d4 */
        {8,	0}, 	/* 0x61d5 */
        {8,	0}, 	/* 0x61d6 */
        {8,	0}, 	/* 0x61d7 */
        {8,	0}, 	/* 0x61d8 */
        {8,	0}, 	/* 0x61d9 */
        {8,	0}, 	/* 0x61da */
        {8,	0}, 	/* 0x61db */
        {8,	0}, 	/* 0x61dc */
        {8,	0}, 	/* 0x61dd */
        {8,	0}, 	/* 0x61de */
        {8,	0}, 	/* 0x61df */
        {8,	0}, 	/* 0x61e0 */
        {8,	0}, 	/* 0x61e1 */
        {8,	0}, 	/* 0x61e2 */
        {8,	0}, 	/* 0x61e3 */
        {8,	0}, 	/* 0x61e4 */
        {8,	0}, 	/* 0x61e5 */
        {8,	0}, 	/* 0x61e6 */
        {8,	0}, 	/* 0x61e7 */
        {8,	0}, 	/* 0x61e8 */
        {8,	0}, 	/* 0x61e9 */
        {8,	0}, 	/* 0x61ea */
        {8,	0}, 	/* 0x61eb */
        {8,	0}, 	/* 0x61ec */
        {8,	0}, 	/* 0x61ed */
        {8,	0}, 	/* 0x61ee */
        {8,	0}, 	/* 0x61ef */
        {8,	0}, 	/* 0x61f0 */
        {8,	0}, 	/* 0x61f1 */
        {8,	0}, 	/* 0x61f2 */
        {8,	0}, 	/* 0x61f3 */
        {8,	0}, 	/* 0x61f4 */
        {8,	0}, 	/* 0x61f5 */
        {8,	0}, 	/* 0x61f6 */
        {8,	0}, 	/* 0x61f7 */
        {8,	0}, 	/* 0x61f8 */
        {8,	0}, 	/* 0x61f9 */
        {8,	0}, 	/* 0x61fa */
        {8,	0}, 	/* 0x61fb */
        {8,	0}, 	/* 0x61fc */
        {8,	0}, 	/* 0x61fd */
        {8,	0}, 	/* 0x61fe */
        {8,	0}, 	/* 0x61ff */
        {8,	0}, 	/* 0x6200 */
        {8,	0}, 	/* 0x6201 */
        {8,	0}, 	/* 0x6202 */
        {8,	0}, 	/* 0x6203 */
        {8,	0}, 	/* 0x6204 */
        {8,	0}, 	/* 0x6205 */
        {8,	0}, 	/* 0x6206 */
        {8,	0}, 	/* 0x6207 */
        {8,	0}, 	/* 0x6208 */
        {8,	0}, 	/* 0x6209 */
        {8,	0}, 	/* 0x620a */
        {8,	0}, 	/* 0x620b */
        {8,	0}, 	/* 0x620c */
        {8,	0}, 	/* 0x620d */
        {8,	0}, 	/* 0x620e */
        {8,	0}, 	/* 0x620f */
        {8,	0}, 	/* 0x6210 */
        {8,	0}, 	/* 0x6211 */
        {8,	0}, 	/* 0x6212 */
        {8,	0}, 	/* 0x6213 */
        {8,	0}, 	/* 0x6214 */
        {8,	0}, 	/* 0x6215 */
        {8,	0}, 	/* 0x6216 */
        {8,	0}, 	/* 0x6217 */
        {8,	0}, 	/* 0x6218 */
        {8,	0}, 	/* 0x6219 */
        {8,	0}, 	/* 0x621a */
        {8,	0}, 	/* 0x621b */
        {8,	0}, 	/* 0x621c */
        {8,	0}, 	/* 0x621d */
        {8,	0}, 	/* 0x621e */
        {8,	0}, 	/* 0x621f */
        {8,	0}, 	/* 0x6220 */
        {8,	0}, 	/* 0x6221 */
        {8,	0}, 	/* 0x6222 */
        {8,	0}, 	/* 0x6223 */
        {8,	0}, 	/* 0x6224 */
        {8,	0}, 	/* 0x6225 */
        {8,	0}, 	/* 0x6226 */
        {8,	0}, 	/* 0x6227 */
        {8,	0}, 	/* 0x6228 */
        {8,	0}, 	/* 0x6229 */
        {8,	0}, 	/* 0x622a */
        {8,	0}, 	/* 0x622b */
        {8,	0}, 	/* 0x622c */
        {8,	0}, 	/* 0x622d */
        {8,	0}, 	/* 0x622e */
        {8,	0}, 	/* 0x622f */
        {8,	0}, 	/* 0x6230 */
        {8,	0}, 	/* 0x6231 */
        {8,	0}, 	/* 0x6232 */
        {8,	0}, 	/* 0x6233 */
        {8,	0}, 	/* 0x6234 */
        {8,	0}, 	/* 0x6235 */
        {8,	0}, 	/* 0x6236 */
        {8,	0}, 	/* 0x6237 */
        {8,	0}, 	/* 0x6238 */
        {8,	0}, 	/* 0x6239 */
        {8,	0}, 	/* 0x623a */
        {8,	0}, 	/* 0x623b */
        {8,	0}, 	/* 0x623c */
        {8,	0}, 	/* 0x623d */
        {8,	0}, 	/* 0x623e */
        {8,	0}, 	/* 0x623f */
        {8,	0}, 	/* 0x6240 */
        {8,	0}, 	/* 0x6241 */
        {8,	0}, 	/* 0x6242 */
        {8,	0}, 	/* 0x6243 */
        {8,	0}, 	/* 0x6244 */
        {8,	0}, 	/* 0x6245 */
        {8,	0}, 	/* 0x6246 */
        {8,	0}, 	/* 0x6247 */
        {8,	0}, 	/* 0x6248 */
        {8,	0}, 	/* 0x6249 */
        {8,	0}, 	/* 0x624a */
        {8,	0}, 	/* 0x624b */
        {8,	0}, 	/* 0x624c */
        {8,	0}, 	/* 0x624d */
        {8,	0}, 	/* 0x624e */
        {8,	0}, 	/* 0x624f */
        {8,	0}, 	/* 0x6250 */
        {8,	0}, 	/* 0x6251 */
        {8,	0}, 	/* 0x6252 */
        {8,	0}, 	/* 0x6253 */
        {8,	0}, 	/* 0x6254 */
        {8,	0}, 	/* 0x6255 */
        {8,	0}, 	/* 0x6256 */
        {8,	0}, 	/* 0x6257 */
        {8,	0}, 	/* 0x6258 */
        {8,	0}, 	/* 0x6259 */
        {8,	0}, 	/* 0x625a */
        {8,	0}, 	/* 0x625b */
        {8,	0}, 	/* 0x625c */
        {8,	0}, 	/* 0x625d */
        {8,	0}, 	/* 0x625e */
        {8,	0}, 	/* 0x625f */
        {8,	0}, 	/* 0x6260 */
        {8,	0}, 	/* 0x6261 */
        {8,	0}, 	/* 0x6262 */
        {8,	0}, 	/* 0x6263 */
        {8,	0}, 	/* 0x6264 */
        {8,	0}, 	/* 0x6265 */
        {8,	0}, 	/* 0x6266 */
        {8,	0}, 	/* 0x6267 */
        {8,	0}, 	/* 0x6268 */
        {8,	0}, 	/* 0x6269 */
        {8,	0}, 	/* 0x626a */
        {8,	0}, 	/* 0x626b */
        {8,	0}, 	/* 0x626c */
        {8,	0}, 	/* 0x626d */
        {8,	0}, 	/* 0x626e */
        {8,	0}, 	/* 0x626f */
        {8,	0}, 	/* 0x6270 */
        {8,	0}, 	/* 0x6271 */
        {8,	0}, 	/* 0x6272 */
        {8,	0}, 	/* 0x6273 */
        {8,	0}, 	/* 0x6274 */
        {8,	0}, 	/* 0x6275 */
        {8,	0}, 	/* 0x6276 */
        {8,	0}, 	/* 0x6277 */
        {8,	0}, 	/* 0x6278 */
        {8,	0}, 	/* 0x6279 */
        {8,	0}, 	/* 0x627a */
        {8,	0}, 	/* 0x627b */
        {8,	0}, 	/* 0x627c */
        {8,	0}, 	/* 0x627d */
        {8,	0}, 	/* 0x627e */
        {8,	0}, 	/* 0x627f */
        {8,	0}, 	/* 0x6280 */
        {8,	0}, 	/* 0x6281 */
        {8,	0}, 	/* 0x6282 */
        {8,	0}, 	/* 0x6283 */
        {8,	0}, 	/* 0x6284 */
        {8,	0}, 	/* 0x6285 */
        {8,	0}, 	/* 0x6286 */
        {8,	0}, 	/* 0x6287 */
        {8,	0}, 	/* 0x6288 */
        {8,	0}, 	/* 0x6289 */
        {8,	0}, 	/* 0x628a */
        {8,	0}, 	/* 0x628b */
        {8,	0}, 	/* 0x628c */
        {8,	0}, 	/* 0x628d */
        {8,	0}, 	/* 0x628e */
        {8,	0}, 	/* 0x628f */
        {8,	0}, 	/* 0x6290 */
        {8,	0}, 	/* 0x6291 */
        {8,	0}, 	/* 0x6292 */
        {8,	0}, 	/* 0x6293 */
        {8,	0}, 	/* 0x6294 */
        {8,	0}, 	/* 0x6295 */
        {8,	0}, 	/* 0x6296 */
        {8,	0}, 	/* 0x6297 */
        {8,	0}, 	/* 0x6298 */
        {8,	0}, 	/* 0x6299 */
        {8,	0}, 	/* 0x629a */
        {8,	0}, 	/* 0x629b */
        {8,	0}, 	/* 0x629c */
        {8,	0}, 	/* 0x629d */
        {8,	0}, 	/* 0x629e */
        {8,	0}, 	/* 0x629f */
        {8,	0}, 	/* 0x62a0 */
        {8,	0}, 	/* 0x62a1 */
        {8,	0}, 	/* 0x62a2 */
        {8,	0}, 	/* 0x62a3 */
        {8,	0}, 	/* 0x62a4 */
        {8,	0}, 	/* 0x62a5 */
        {8,	0}, 	/* 0x62a6 */
        {8,	0}, 	/* 0x62a7 */
        {8,	0}, 	/* 0x62a8 */
        {8,	0}, 	/* 0x62a9 */
        {8,	0}, 	/* 0x62aa */
        {8,	0}, 	/* 0x62ab */
        {8,	0}, 	/* 0x62ac */
        {8,	0}, 	/* 0x62ad */
        {8,	0}, 	/* 0x62ae */
        {8,	0}, 	/* 0x62af */
        {8,	0}, 	/* 0x62b0 */
        {8,	0}, 	/* 0x62b1 */
        {8,	0}, 	/* 0x62b2 */
        {8,	0}, 	/* 0x62b3 */
        {8,	0}, 	/* 0x62b4 */
        {8,	0}, 	/* 0x62b5 */
        {8,	0}, 	/* 0x62b6 */
        {8,	0}, 	/* 0x62b7 */
        {8,	0}, 	/* 0x62b8 */
        {8,	0}, 	/* 0x62b9 */
        {8,	0}, 	/* 0x62ba */
        {8,	0}, 	/* 0x62bb */
        {8,	0}, 	/* 0x62bc */
        {8,	0}, 	/* 0x62bd */
        {8,	0}, 	/* 0x62be */
        {8,	0}, 	/* 0x62bf */
        {8,	0}, 	/* 0x62c0 */
        {8,	0}, 	/* 0x62c1 */
        {8,	0}, 	/* 0x62c2 */
        {8,	0}, 	/* 0x62c3 */
        {8,	0}, 	/* 0x62c4 */
        {8,	0}, 	/* 0x62c5 */
        {8,	0}, 	/* 0x62c6 */
        {8,	0}, 	/* 0x62c7 */
        {8,	0}, 	/* 0x62c8 */
        {8,	0}, 	/* 0x62c9 */
        {8,	0}, 	/* 0x62ca */
        {8,	0}, 	/* 0x62cb */
        {8,	0}, 	/* 0x62cc */
        {8,	0}, 	/* 0x62cd */
        {8,	0}, 	/* 0x62ce */
        {8,	0}, 	/* 0x62cf */
        {8,	0}, 	/* 0x62d0 */
        {8,	0}, 	/* 0x62d1 */
        {8,	0}, 	/* 0x62d2 */
        {8,	0}, 	/* 0x62d3 */
        {8,	0}, 	/* 0x62d4 */
        {8,	0}, 	/* 0x62d5 */
        {8,	0}, 	/* 0x62d6 */
        {8,	0}, 	/* 0x62d7 */
        {8,	0}, 	/* 0x62d8 */
        {8,	0}, 	/* 0x62d9 */
        {8,	0}, 	/* 0x62da */
        {8,	0}, 	/* 0x62db */
        {8,	0}, 	/* 0x62dc */
        {8,	0}, 	/* 0x62dd */
        {8,	0}, 	/* 0x62de */
        {8,	0}, 	/* 0x62df */
        {8,	0}, 	/* 0x62e0 */
        {8,	0}, 	/* 0x62e1 */
        {8,	0}, 	/* 0x62e2 */
        {8,	0}, 	/* 0x62e3 */
        {8,	0}, 	/* 0x62e4 */
        {8,	0}, 	/* 0x62e5 */
        {8,	0}, 	/* 0x62e6 */
        {8,	0}, 	/* 0x62e7 */
        {8,	0}, 	/* 0x62e8 */
        {8,	0}, 	/* 0x62e9 */
        {8,	0}, 	/* 0x62ea */
        {8,	0}, 	/* 0x62eb */
        {8,	0}, 	/* 0x62ec */
        {8,	0}, 	/* 0x62ed */
        {8,	0}, 	/* 0x62ee */
        {8,	0}, 	/* 0x62ef */
        {8,	0}, 	/* 0x62f0 */
        {8,	0}, 	/* 0x62f1 */
        {8,	0}, 	/* 0x62f2 */
        {8,	0}, 	/* 0x62f3 */
        {8,	0}, 	/* 0x62f4 */
        {8,	0}, 	/* 0x62f5 */
        {8,	0}, 	/* 0x62f6 */
        {8,	0}, 	/* 0x62f7 */
        {8,	0}, 	/* 0x62f8 */
        {8,	0}, 	/* 0x62f9 */
        {8,	0}, 	/* 0x62fa */
        {8,	0}, 	/* 0x62fb */
        {8,	0}, 	/* 0x62fc */
        {8,	0}, 	/* 0x62fd */
        {8,	0}, 	/* 0x62fe */
        {8,	0}, 	/* 0x62ff */
        {8,	0}, 	/* 0x6300 */
        {8,	0}, 	/* 0x6301 */
        {8,	0}, 	/* 0x6302 */
        {8,	0}, 	/* 0x6303 */
        {8,	0}, 	/* 0x6304 */
        {8,	0}, 	/* 0x6305 */
        {8,	0}, 	/* 0x6306 */
        {8,	0}, 	/* 0x6307 */
        {8,	0}, 	/* 0x6308 */
        {8,	0}, 	/* 0x6309 */
        {8,	0}, 	/* 0x630a */
        {8,	0}, 	/* 0x630b */
        {8,	0}, 	/* 0x630c */
        {8,	0}, 	/* 0x630d */
        {8,	0}, 	/* 0x630e */
        {8,	0}, 	/* 0x630f */
        {8,	0}, 	/* 0x6310 */
        {8,	0}, 	/* 0x6311 */
        {8,	0}, 	/* 0x6312 */
        {8,	0}, 	/* 0x6313 */
        {8,	0}, 	/* 0x6314 */
        {8,	0}, 	/* 0x6315 */
        {8,	0}, 	/* 0x6316 */
        {8,	0}, 	/* 0x6317 */
        {8,	0}, 	/* 0x6318 */
        {8,	0}, 	/* 0x6319 */
        {8,	0}, 	/* 0x631a */
        {8,	0}, 	/* 0x631b */
        {8,	0}, 	/* 0x631c */
        {8,	0}, 	/* 0x631d */
        {8,	0}, 	/* 0x631e */
        {8,	0}, 	/* 0x631f */
        {8,	0}, 	/* 0x6320 */
        {8,	0}, 	/* 0x6321 */
        {8,	0}, 	/* 0x6322 */
        {8,	0}, 	/* 0x6323 */
        {8,	0}, 	/* 0x6324 */
        {8,	0}, 	/* 0x6325 */
        {8,	0}, 	/* 0x6326 */
        {8,	0}, 	/* 0x6327 */
        {8,	0}, 	/* 0x6328 */
        {8,	0}, 	/* 0x6329 */
        {8,	0}, 	/* 0x632a */
        {8,	0}, 	/* 0x632b */
        {8,	0}, 	/* 0x632c */
        {8,	0}, 	/* 0x632d */
        {8,	0}, 	/* 0x632e */
        {8,	0}, 	/* 0x632f */
        {8,	0}, 	/* 0x6330 */
        {8,	0}, 	/* 0x6331 */
        {8,	0}, 	/* 0x6332 */
        {8,	0}, 	/* 0x6333 */
        {8,	0}, 	/* 0x6334 */
        {8,	0}, 	/* 0x6335 */
        {8,	0}, 	/* 0x6336 */
        {8,	0}, 	/* 0x6337 */
        {8,	0}, 	/* 0x6338 */
        {8,	0}, 	/* 0x6339 */
        {8,	0}, 	/* 0x633a */
        {8,	0}, 	/* 0x633b */
        {8,	0}, 	/* 0x633c */
        {8,	0}, 	/* 0x633d */
        {8,	0}, 	/* 0x633e */
        {8,	0}, 	/* 0x633f */
        {8,	0}, 	/* 0x6340 */
        {8,	0}, 	/* 0x6341 */
        {8,	0}, 	/* 0x6342 */
        {8,	0}, 	/* 0x6343 */
        {8,	0}, 	/* 0x6344 */
        {8,	0}, 	/* 0x6345 */
        {8,	0}, 	/* 0x6346 */
        {8,	0}, 	/* 0x6347 */
        {8,	0}, 	/* 0x6348 */
        {8,	0}, 	/* 0x6349 */
        {8,	0}, 	/* 0x634a */
        {8,	0}, 	/* 0x634b */
        {8,	0}, 	/* 0x634c */
        {8,	0}, 	/* 0x634d */
        {8,	0}, 	/* 0x634e */
        {8,	0}, 	/* 0x634f */
        {8,	0}, 	/* 0x6350 */
        {8,	0}, 	/* 0x6351 */
        {8,	0}, 	/* 0x6352 */
        {8,	0}, 	/* 0x6353 */
        {8,	0}, 	/* 0x6354 */
        {8,	0}, 	/* 0x6355 */
        {8,	0}, 	/* 0x6356 */
        {8,	0}, 	/* 0x6357 */
        {8,	0}, 	/* 0x6358 */
        {8,	0}, 	/* 0x6359 */
        {8,	0}, 	/* 0x635a */
        {8,	0}, 	/* 0x635b */
        {8,	0}, 	/* 0x635c */
        {8,	0}, 	/* 0x635d */
        {8,	0}, 	/* 0x635e */
        {8,	0}, 	/* 0x635f */
        {8,	0}, 	/* 0x6360 */
        {8,	0}, 	/* 0x6361 */
        {8,	0}, 	/* 0x6362 */
        {8,	0}, 	/* 0x6363 */
        {8,	0}, 	/* 0x6364 */
        {8,	0}, 	/* 0x6365 */
        {8,	0}, 	/* 0x6366 */
        {8,	0}, 	/* 0x6367 */
        {8,	0}, 	/* 0x6368 */
        {8,	0}, 	/* 0x6369 */
        {8,	0}, 	/* 0x636a */
        {8,	0}, 	/* 0x636b */
        {8,	0}, 	/* 0x636c */
        {8,	0}, 	/* 0x636d */
        {8,	0}, 	/* 0x636e */
        {8,	0}, 	/* 0x636f */
        {8,	0}, 	/* 0x6370 */
        {8,	0}, 	/* 0x6371 */
        {8,	0}, 	/* 0x6372 */
        {8,	0}, 	/* 0x6373 */
        {8,	0}, 	/* 0x6374 */
        {8,	0}, 	/* 0x6375 */
        {8,	0}, 	/* 0x6376 */
        {8,	0}, 	/* 0x6377 */
        {8,	0}, 	/* 0x6378 */
        {8,	0}, 	/* 0x6379 */
        {8,	0}, 	/* 0x637a */
        {8,	0}, 	/* 0x637b */
        {8,	0}, 	/* 0x637c */
        {8,	0}, 	/* 0x637d */
        {8,	0}, 	/* 0x637e */
        {8,	0}, 	/* 0x637f */
        {8,	0}, 	/* 0x6380 */
        {8,	0}, 	/* 0x6381 */
        {8,	0}, 	/* 0x6382 */
        {8,	0}, 	/* 0x6383 */
        {8,	0}, 	/* 0x6384 */
        {8,	0}, 	/* 0x6385 */
        {8,	0}, 	/* 0x6386 */
        {8,	0}, 	/* 0x6387 */
        {8,	0}, 	/* 0x6388 */
        {8,	0}, 	/* 0x6389 */
        {8,	0}, 	/* 0x638a */
        {8,	0}, 	/* 0x638b */
        {8,	0}, 	/* 0x638c */
        {8,	0}, 	/* 0x638d */
        {8,	0}, 	/* 0x638e */
        {8,	0}, 	/* 0x638f */
        {8,	0}, 	/* 0x6390 */
        {8,	0}, 	/* 0x6391 */
        {8,	0}, 	/* 0x6392 */
        {8,	0}, 	/* 0x6393 */
        {8,	0}, 	/* 0x6394 */
        {8,	0}, 	/* 0x6395 */
        {8,	0}, 	/* 0x6396 */
        {8,	0}, 	/* 0x6397 */
        {8,	0}, 	/* 0x6398 */
        {8,	0}, 	/* 0x6399 */
        {8,	0}, 	/* 0x639a */
        {8,	0}, 	/* 0x639b */
        {8,	0}, 	/* 0x639c */
        {8,	0}, 	/* 0x639d */
        {8,	0}, 	/* 0x639e */
        {8,	0}, 	/* 0x639f */
        {8,	0}, 	/* 0x63a0 */
        {8,	0}, 	/* 0x63a1 */
        {8,	0}, 	/* 0x63a2 */
        {8,	0}, 	/* 0x63a3 */
        {8,	0}, 	/* 0x63a4 */
        {8,	0}, 	/* 0x63a5 */
        {8,	0}, 	/* 0x63a6 */
        {8,	0}, 	/* 0x63a7 */
        {8,	0}, 	/* 0x63a8 */
        {8,	0}, 	/* 0x63a9 */
        {8,	0}, 	/* 0x63aa */
        {8,	0}, 	/* 0x63ab */
        {8,	0}, 	/* 0x63ac */
        {8,	0}, 	/* 0x63ad */
        {8,	0}, 	/* 0x63ae */
        {8,	0}, 	/* 0x63af */
        {8,	0}, 	/* 0x63b0 */
        {8,	0}, 	/* 0x63b1 */
        {8,	0}, 	/* 0x63b2 */
        {8,	0}, 	/* 0x63b3 */
        {8,	0}, 	/* 0x63b4 */
        {8,	0}, 	/* 0x63b5 */
        {8,	0}, 	/* 0x63b6 */
        {8,	0}, 	/* 0x63b7 */
        {8,	0}, 	/* 0x63b8 */
        {8,	0}, 	/* 0x63b9 */
        {8,	0}, 	/* 0x63ba */
        {8,	0}, 	/* 0x63bb */
        {8,	0}, 	/* 0x63bc */
        {8,	0}, 	/* 0x63bd */
        {8,	0}, 	/* 0x63be */
        {8,	0}, 	/* 0x63bf */
        {8,	0}, 	/* 0x63c0 */
        {8,	0}, 	/* 0x63c1 */
        {8,	0}, 	/* 0x63c2 */
        {8,	0}, 	/* 0x63c3 */
        {8,	0}, 	/* 0x63c4 */
        {8,	0}, 	/* 0x63c5 */
        {8,	0}, 	/* 0x63c6 */
        {8,	0}, 	/* 0x63c7 */
        {8,	0}, 	/* 0x63c8 */
        {8,	0}, 	/* 0x63c9 */
        {8,	0}, 	/* 0x63ca */
        {8,	0}, 	/* 0x63cb */
        {8,	0}, 	/* 0x63cc */
        {8,	0}, 	/* 0x63cd */
        {8,	0}, 	/* 0x63ce */
        {8,	0}, 	/* 0x63cf */
        {8,	0}, 	/* 0x63d0 */
        {8,	0}, 	/* 0x63d1 */
        {8,	0}, 	/* 0x63d2 */
        {8,	0}, 	/* 0x63d3 */
        {8,	0}, 	/* 0x63d4 */
        {8,	0}, 	/* 0x63d5 */
        {8,	0}, 	/* 0x63d6 */
        {8,	0}, 	/* 0x63d7 */
        {8,	0}, 	/* 0x63d8 */
        {8,	0}, 	/* 0x63d9 */
        {8,	0}, 	/* 0x63da */
        {8,	0}, 	/* 0x63db */
        {8,	0}, 	/* 0x63dc */
        {8,	0}, 	/* 0x63dd */
        {8,	0}, 	/* 0x63de */
        {8,	0}, 	/* 0x63df */
        {8,	0}, 	/* 0x63e0 */
        {8,	0}, 	/* 0x63e1 */
        {8,	0}, 	/* 0x63e2 */
        {8,	0}, 	/* 0x63e3 */
        {8,	0}, 	/* 0x63e4 */
        {8,	0}, 	/* 0x63e5 */
        {8,	0}, 	/* 0x63e6 */
        {8,	0}, 	/* 0x63e7 */
        {8,	0}, 	/* 0x63e8 */
        {8,	0}, 	/* 0x63e9 */
        {8,	0}, 	/* 0x63ea */
        {8,	0}, 	/* 0x63eb */
        {8,	0}, 	/* 0x63ec */
        {8,	0}, 	/* 0x63ed */
        {8,	0}, 	/* 0x63ee */
        {8,	0}, 	/* 0x63ef */
        {8,	0}, 	/* 0x63f0 */
        {8,	0}, 	/* 0x63f1 */
        {8,	0}, 	/* 0x63f2 */
        {8,	0}, 	/* 0x63f3 */
        {8,	0}, 	/* 0x63f4 */
        {8,	0}, 	/* 0x63f5 */
        {8,	0}, 	/* 0x63f6 */
        {8,	0}, 	/* 0x63f7 */
        {8,	0}, 	/* 0x63f8 */
        {8,	0}, 	/* 0x63f9 */
        {8,	0}, 	/* 0x63fa */
        {8,	0}, 	/* 0x63fb */
        {8,	0}, 	/* 0x63fc */
        {8,	0}, 	/* 0x63fd */
        {8,	0}, 	/* 0x63fe */
        {8,	0}, 	/* 0x63ff */
        {8,	0}, 	/* 0x6400 */
        {8,	0}, 	/* 0x6401 */
        {8,	0}, 	/* 0x6402 */
        {8,	0}, 	/* 0x6403 */
        {8,	0}, 	/* 0x6404 */
        {8,	0}, 	/* 0x6405 */
        {8,	0}, 	/* 0x6406 */
        {8,	0}, 	/* 0x6407 */
        {8,	0}, 	/* 0x6408 */
        {8,	0}, 	/* 0x6409 */
        {8,	0}, 	/* 0x640a */
        {8,	0}, 	/* 0x640b */
        {8,	0}, 	/* 0x640c */
        {8,	0}, 	/* 0x640d */
        {8,	0}, 	/* 0x640e */
        {8,	0}, 	/* 0x640f */
        {8,	0}, 	/* 0x6410 */
        {8,	0}, 	/* 0x6411 */
        {8,	0}, 	/* 0x6412 */
        {8,	0}, 	/* 0x6413 */
        {8,	0}, 	/* 0x6414 */
        {8,	0}, 	/* 0x6415 */
        {8,	0}, 	/* 0x6416 */
        {8,	0}, 	/* 0x6417 */
        {8,	0}, 	/* 0x6418 */
        {8,	0}, 	/* 0x6419 */
        {8,	0}, 	/* 0x641a */
        {8,	0}, 	/* 0x641b */
        {8,	0}, 	/* 0x641c */
        {8,	0}, 	/* 0x641d */
        {8,	0}, 	/* 0x641e */
        {8,	0}, 	/* 0x641f */
        {8,	0}, 	/* 0x6420 */
        {8,	0}, 	/* 0x6421 */
        {8,	0}, 	/* 0x6422 */
        {8,	0}, 	/* 0x6423 */
        {8,	0}, 	/* 0x6424 */
        {8,	0}, 	/* 0x6425 */
        {8,	0}, 	/* 0x6426 */
        {8,	0}, 	/* 0x6427 */
        {8,	0}, 	/* 0x6428 */
        {8,	0}, 	/* 0x6429 */
        {8,	0}, 	/* 0x642a */
        {8,	0}, 	/* 0x642b */
        {8,	0}, 	/* 0x642c */
        {8,	0}, 	/* 0x642d */
        {8,	0}, 	/* 0x642e */
        {8,	0}, 	/* 0x642f */
        {8,	0}, 	/* 0x6430 */
        {8,	0}, 	/* 0x6431 */
        {8,	0}, 	/* 0x6432 */
        {8,	0}, 	/* 0x6433 */
        {8,	0}, 	/* 0x6434 */
        {8,	0}, 	/* 0x6435 */
        {8,	0}, 	/* 0x6436 */
        {8,	0}, 	/* 0x6437 */
        {8,	0}, 	/* 0x6438 */
        {8,	0}, 	/* 0x6439 */
        {8,	0}, 	/* 0x643a */
        {8,	0}, 	/* 0x643b */
        {8,	0}, 	/* 0x643c */
        {8,	0}, 	/* 0x643d */
        {8,	0}, 	/* 0x643e */
        {8,	0}, 	/* 0x643f */
        {8,	0}, 	/* 0x6440 */
        {8,	0}, 	/* 0x6441 */
        {8,	0}, 	/* 0x6442 */
        {8,	0}, 	/* 0x6443 */
        {8,	0}, 	/* 0x6444 */
        {8,	0}, 	/* 0x6445 */
        {8,	0}, 	/* 0x6446 */
        {8,	0}, 	/* 0x6447 */
        {8,	0}, 	/* 0x6448 */
        {8,	0}, 	/* 0x6449 */
        {8,	0}, 	/* 0x644a */
        {8,	0}, 	/* 0x644b */
        {8,	0}, 	/* 0x644c */
        {8,	0}, 	/* 0x644d */
        {8,	0}, 	/* 0x644e */
        {8,	0}, 	/* 0x644f */
        {8,	0}, 	/* 0x6450 */
        {8,	0}, 	/* 0x6451 */
        {8,	0}, 	/* 0x6452 */
        {8,	0}, 	/* 0x6453 */
        {8,	0}, 	/* 0x6454 */
        {8,	0}, 	/* 0x6455 */
        {8,	0}, 	/* 0x6456 */
        {8,	0}, 	/* 0x6457 */
        {8,	0}, 	/* 0x6458 */
        {8,	0}, 	/* 0x6459 */
        {8,	0}, 	/* 0x645a */
        {8,	0}, 	/* 0x645b */
        {8,	0}, 	/* 0x645c */
        {8,	0}, 	/* 0x645d */
        {8,	0}, 	/* 0x645e */
        {8,	0}, 	/* 0x645f */
        {8,	0}, 	/* 0x6460 */
        {8,	0}, 	/* 0x6461 */
        {8,	0}, 	/* 0x6462 */
        {8,	0}, 	/* 0x6463 */
        {8,	0}, 	/* 0x6464 */
        {8,	0}, 	/* 0x6465 */
        {8,	0}, 	/* 0x6466 */
        {8,	0}, 	/* 0x6467 */
        {8,	0}, 	/* 0x6468 */
        {8,	0}, 	/* 0x6469 */
        {8,	0}, 	/* 0x646a */
        {8,	0}, 	/* 0x646b */
        {8,	0}, 	/* 0x646c */
        {8,	0}, 	/* 0x646d */
        {8,	0}, 	/* 0x646e */
        {8,	0}, 	/* 0x646f */
        {8,	0}, 	/* 0x6470 */
        {8,	0}, 	/* 0x6471 */
        {8,	0}, 	/* 0x6472 */
        {8,	0}, 	/* 0x6473 */
        {8,	0}, 	/* 0x6474 */
        {8,	0}, 	/* 0x6475 */
        {8,	0}, 	/* 0x6476 */
        {8,	0}, 	/* 0x6477 */
        {8,	0}, 	/* 0x6478 */
        {8,	0}, 	/* 0x6479 */
        {8,	0}, 	/* 0x647a */
        {8,	0}, 	/* 0x647b */
        {8,	0}, 	/* 0x647c */
        {8,	0}, 	/* 0x647d */
        {8,	0}, 	/* 0x647e */
        {8,	0}, 	/* 0x647f */
        {8,	0}, 	/* 0x6480 */
        {8,	0}, 	/* 0x6481 */
        {8,	0}, 	/* 0x6482 */
        {8,	0}, 	/* 0x6483 */
        {8,	0}, 	/* 0x6484 */
        {8,	0}, 	/* 0x6485 */
        {8,	0}, 	/* 0x6486 */
        {8,	0}, 	/* 0x6487 */
        {8,	0}, 	/* 0x6488 */
        {8,	0}, 	/* 0x6489 */
        {8,	0}, 	/* 0x648a */
        {8,	0}, 	/* 0x648b */
        {8,	0}, 	/* 0x648c */
        {8,	0}, 	/* 0x648d */
        {8,	0}, 	/* 0x648e */
        {8,	0}, 	/* 0x648f */
        {8,	0}, 	/* 0x6490 */
        {8,	0}, 	/* 0x6491 */
        {8,	0}, 	/* 0x6492 */
        {8,	0}, 	/* 0x6493 */
        {8,	0}, 	/* 0x6494 */
        {8,	0}, 	/* 0x6495 */
        {8,	0}, 	/* 0x6496 */
        {8,	0}, 	/* 0x6497 */
        {8,	0}, 	/* 0x6498 */
        {8,	0}, 	/* 0x6499 */
        {8,	0}, 	/* 0x649a */
        {8,	0}, 	/* 0x649b */
        {8,	0}, 	/* 0x649c */
        {8,	0}, 	/* 0x649d */
        {8,	0}, 	/* 0x649e */
        {8,	0}, 	/* 0x649f */
        {8,	0}, 	/* 0x64a0 */
        {8,	0}, 	/* 0x64a1 */
        {8,	0}, 	/* 0x64a2 */
        {8,	0}, 	/* 0x64a3 */
        {8,	0}, 	/* 0x64a4 */
        {8,	0}, 	/* 0x64a5 */
        {8,	0}, 	/* 0x64a6 */
        {8,	0}, 	/* 0x64a7 */
        {8,	0}, 	/* 0x64a8 */
        {8,	0}, 	/* 0x64a9 */
        {8,	0}, 	/* 0x64aa */
        {8,	0}, 	/* 0x64ab */
        {8,	0}, 	/* 0x64ac */
        {8,	0}, 	/* 0x64ad */
        {8,	0}, 	/* 0x64ae */
        {8,	0}, 	/* 0x64af */
        {8,	0}, 	/* 0x64b0 */
        {8,	0}, 	/* 0x64b1 */
        {8,	0}, 	/* 0x64b2 */
        {8,	0}, 	/* 0x64b3 */
        {8,	0}, 	/* 0x64b4 */
        {8,	0}, 	/* 0x64b5 */
        {8,	0}, 	/* 0x64b6 */
        {8,	0}, 	/* 0x64b7 */
        {8,	0}, 	/* 0x64b8 */
        {8,	0}, 	/* 0x64b9 */
        {8,	0}, 	/* 0x64ba */
        {8,	0}, 	/* 0x64bb */
        {8,	0}, 	/* 0x64bc */
        {8,	0}, 	/* 0x64bd */
        {8,	0}, 	/* 0x64be */
        {8,	0}, 	/* 0x64bf */
        {8,	0}, 	/* 0x64c0 */
        {8,	0}, 	/* 0x64c1 */
        {8,	0}, 	/* 0x64c2 */
        {8,	0}, 	/* 0x64c3 */
        {8,	0}, 	/* 0x64c4 */
        {8,	0}, 	/* 0x64c5 */
        {8,	0}, 	/* 0x64c6 */
        {8,	0}, 	/* 0x64c7 */
        {8,	0}, 	/* 0x64c8 */
        {8,	0}, 	/* 0x64c9 */
        {8,	0}, 	/* 0x64ca */
        {8,	0}, 	/* 0x64cb */
        {8,	0}, 	/* 0x64cc */
        {8,	0}, 	/* 0x64cd */
        {8,	0}, 	/* 0x64ce */
        {8,	0}, 	/* 0x64cf */
        {8,	0}, 	/* 0x64d0 */
        {8,	0}, 	/* 0x64d1 */
        {8,	0}, 	/* 0x64d2 */
        {8,	0}, 	/* 0x64d3 */
        {8,	0}, 	/* 0x64d4 */
        {8,	0}, 	/* 0x64d5 */
        {8,	0}, 	/* 0x64d6 */
        {8,	0}, 	/* 0x64d7 */
        {8,	0}, 	/* 0x64d8 */
        {8,	0}, 	/* 0x64d9 */
        {8,	0}, 	/* 0x64da */
        {8,	0}, 	/* 0x64db */
        {8,	0}, 	/* 0x64dc */
        {8,	0}, 	/* 0x64dd */
        {8,	0}, 	/* 0x64de */
        {8,	0}, 	/* 0x64df */
        {8,	0}, 	/* 0x64e0 */
        {8,	0}, 	/* 0x64e1 */
        {8,	0}, 	/* 0x64e2 */
        {8,	0}, 	/* 0x64e3 */
        {8,	0}, 	/* 0x64e4 */
        {8,	0}, 	/* 0x64e5 */
        {8,	0}, 	/* 0x64e6 */
        {8,	0}, 	/* 0x64e7 */
        {8,	0}, 	/* 0x64e8 */
        {8,	0}, 	/* 0x64e9 */
        {8,	0}, 	/* 0x64ea */
        {8,	0}, 	/* 0x64eb */
        {8,	0}, 	/* 0x64ec */
        {8,	0}, 	/* 0x64ed */
        {8,	0}, 	/* 0x64ee */
        {8,	0}, 	/* 0x64ef */
        {8,	0}, 	/* 0x64f0 */
        {8,	0}, 	/* 0x64f1 */
        {8,	0}, 	/* 0x64f2 */
        {8,	0}, 	/* 0x64f3 */
        {8,	0}, 	/* 0x64f4 */
        {8,	0}, 	/* 0x64f5 */
        {8,	0}, 	/* 0x64f6 */
        {8,	0}, 	/* 0x64f7 */
        {8,	0}, 	/* 0x64f8 */
        {8,	0}, 	/* 0x64f9 */
        {8,	0}, 	/* 0x64fa */
        {8,	0}, 	/* 0x64fb */
        {8,	0}, 	/* 0x64fc */
        {8,	0}, 	/* 0x64fd */
        {8,	0}, 	/* 0x64fe */
        {8,	0}, 	/* 0x64ff */
        {8,	0}, 	/* 0x6500 */
        {8,	0}, 	/* 0x6501 */
        {8,	0}, 	/* 0x6502 */
        {8,	0}, 	/* 0x6503 */
        {8,	0}, 	/* 0x6504 */
        {8,	0}, 	/* 0x6505 */
        {8,	0}, 	/* 0x6506 */
        {8,	0}, 	/* 0x6507 */
        {8,	0}, 	/* 0x6508 */
        {8,	0}, 	/* 0x6509 */
        {8,	0}, 	/* 0x650a */
        {8,	0}, 	/* 0x650b */
        {8,	0}, 	/* 0x650c */
        {8,	0}, 	/* 0x650d */
        {8,	0}, 	/* 0x650e */
        {8,	0}, 	/* 0x650f */
        {8,	0}, 	/* 0x6510 */
        {8,	0}, 	/* 0x6511 */
        {8,	0}, 	/* 0x6512 */
        {8,	0}, 	/* 0x6513 */
        {8,	0}, 	/* 0x6514 */
        {8,	0}, 	/* 0x6515 */
        {8,	0}, 	/* 0x6516 */
        {8,	0}, 	/* 0x6517 */
        {8,	0}, 	/* 0x6518 */
        {8,	0}, 	/* 0x6519 */
        {8,	0}, 	/* 0x651a */
        {8,	0}, 	/* 0x651b */
        {8,	0}, 	/* 0x651c */
        {8,	0}, 	/* 0x651d */
        {8,	0}, 	/* 0x651e */
        {8,	0}, 	/* 0x651f */
        {8,	0}, 	/* 0x6520 */
        {8,	0}, 	/* 0x6521 */
        {8,	0}, 	/* 0x6522 */
        {8,	0}, 	/* 0x6523 */
        {8,	0}, 	/* 0x6524 */
        {8,	0}, 	/* 0x6525 */
        {8,	0}, 	/* 0x6526 */
        {8,	0}, 	/* 0x6527 */
        {8,	0}, 	/* 0x6528 */
        {8,	0}, 	/* 0x6529 */
        {8,	0}, 	/* 0x652a */
        {8,	0}, 	/* 0x652b */
        {8,	0}, 	/* 0x652c */
        {8,	0}, 	/* 0x652d */
        {8,	0}, 	/* 0x652e */
        {8,	0}, 	/* 0x652f */
        {8,	0}, 	/* 0x6530 */
        {8,	0}, 	/* 0x6531 */
        {8,	0}, 	/* 0x6532 */
        {8,	0}, 	/* 0x6533 */
        {8,	0}, 	/* 0x6534 */
        {8,	0}, 	/* 0x6535 */
        {8,	0}, 	/* 0x6536 */
        {8,	0}, 	/* 0x6537 */
        {8,	0}, 	/* 0x6538 */
        {8,	0}, 	/* 0x6539 */
        {8,	0}, 	/* 0x653a */
        {8,	0}, 	/* 0x653b */
        {8,	0}, 	/* 0x653c */
        {8,	0}, 	/* 0x653d */
        {8,	0}, 	/* 0x653e */
        {8,	0}, 	/* 0x653f */
        {8,	0}, 	/* 0x6540 */
        {8,	0}, 	/* 0x6541 */
        {8,	0}, 	/* 0x6542 */
        {8,	0}, 	/* 0x6543 */
        {8,	0}, 	/* 0x6544 */
        {8,	0}, 	/* 0x6545 */
        {8,	0}, 	/* 0x6546 */
        {8,	0}, 	/* 0x6547 */
        {8,	0}, 	/* 0x6548 */
        {8,	0}, 	/* 0x6549 */
        {8,	0}, 	/* 0x654a */
        {8,	0}, 	/* 0x654b */
        {8,	0}, 	/* 0x654c */
        {8,	0}, 	/* 0x654d */
        {8,	0}, 	/* 0x654e */
        {8,	0}, 	/* 0x654f */
        {8,	0}, 	/* 0x6550 */
        {8,	0}, 	/* 0x6551 */
        {8,	0}, 	/* 0x6552 */
        {8,	0}, 	/* 0x6553 */
        {8,	0}, 	/* 0x6554 */
        {8,	0}, 	/* 0x6555 */
        {8,	0}, 	/* 0x6556 */
        {8,	0}, 	/* 0x6557 */
        {8,	0}, 	/* 0x6558 */
        {8,	0}, 	/* 0x6559 */
        {8,	0}, 	/* 0x655a */
        {8,	0}, 	/* 0x655b */
        {8,	0}, 	/* 0x655c */
        {8,	0}, 	/* 0x655d */
        {8,	0}, 	/* 0x655e */
        {8,	0}, 	/* 0x655f */
        {8,	0}, 	/* 0x6560 */
        {8,	0}, 	/* 0x6561 */
        {8,	0}, 	/* 0x6562 */
        {8,	0}, 	/* 0x6563 */
        {8,	0}, 	/* 0x6564 */
        {8,	0}, 	/* 0x6565 */
        {8,	0}, 	/* 0x6566 */
        {8,	0}, 	/* 0x6567 */
        {8,	0}, 	/* 0x6568 */
        {8,	0}, 	/* 0x6569 */
        {8,	0}, 	/* 0x656a */
        {8,	0}, 	/* 0x656b */
        {8,	0}, 	/* 0x656c */
        {8,	0}, 	/* 0x656d */
        {8,	0}, 	/* 0x656e */
        {8,	0}, 	/* 0x656f */
        {8,	0}, 	/* 0x6570 */
        {8,	0}, 	/* 0x6571 */
        {8,	0}, 	/* 0x6572 */
        {8,	0}, 	/* 0x6573 */
        {8,	0}, 	/* 0x6574 */
        {8,	0}, 	/* 0x6575 */
        {8,	0}, 	/* 0x6576 */
        {8,	0}, 	/* 0x6577 */
        {8,	0}, 	/* 0x6578 */
        {8,	0}, 	/* 0x6579 */
        {8,	0}, 	/* 0x657a */
        {8,	0}, 	/* 0x657b */
        {8,	0}, 	/* 0x657c */
        {8,	0}, 	/* 0x657d */
        {8,	0}, 	/* 0x657e */
        {8,	0}, 	/* 0x657f */
        {8,	0}, 	/* 0x6580 */
        {8,	0}, 	/* 0x6581 */
        {8,	0}, 	/* 0x6582 */
        {8,	0}, 	/* 0x6583 */
        {8,	0}, 	/* 0x6584 */
        {8,	0}, 	/* 0x6585 */
        {8,	0}, 	/* 0x6586 */
        {8,	0}, 	/* 0x6587 */
        {8,	0}, 	/* 0x6588 */
        {8,	0}, 	/* 0x6589 */
        {8,	0}, 	/* 0x658a */
        {8,	0}, 	/* 0x658b */
        {8,	0}, 	/* 0x658c */
        {8,	0}, 	/* 0x658d */
        {8,	0}, 	/* 0x658e */
        {8,	0}, 	/* 0x658f */
        {8,	0}, 	/* 0x6590 */
        {8,	0}, 	/* 0x6591 */
        {8,	0}, 	/* 0x6592 */
        {8,	0}, 	/* 0x6593 */
        {8,	0}, 	/* 0x6594 */
        {8,	0}, 	/* 0x6595 */
        {8,	0}, 	/* 0x6596 */
        {8,	0}, 	/* 0x6597 */
        {8,	0}, 	/* 0x6598 */
        {8,	0}, 	/* 0x6599 */
        {8,	0}, 	/* 0x659a */
        {8,	0}, 	/* 0x659b */
        {8,	0}, 	/* 0x659c */
        {8,	0}, 	/* 0x659d */
        {8,	0}, 	/* 0x659e */
        {8,	0}, 	/* 0x659f */
        {8,	0}, 	/* 0x65a0 */
        {8,	0}, 	/* 0x65a1 */
        {8,	0}, 	/* 0x65a2 */
        {8,	0}, 	/* 0x65a3 */
        {8,	0}, 	/* 0x65a4 */
        {8,	0}, 	/* 0x65a5 */
        {8,	0}, 	/* 0x65a6 */
        {8,	0}, 	/* 0x65a7 */
        {8,	0}, 	/* 0x65a8 */
        {8,	0}, 	/* 0x65a9 */
        {8,	0}, 	/* 0x65aa */
        {8,	0}, 	/* 0x65ab */
        {8,	0}, 	/* 0x65ac */
        {8,	0}, 	/* 0x65ad */
        {8,	0}, 	/* 0x65ae */
        {8,	0}, 	/* 0x65af */
        {8,	0}, 	/* 0x65b0 */
        {8,	0}, 	/* 0x65b1 */
        {8,	0}, 	/* 0x65b2 */
        {8,	0}, 	/* 0x65b3 */
        {8,	0}, 	/* 0x65b4 */
        {8,	0}, 	/* 0x65b5 */
        {8,	0}, 	/* 0x65b6 */
        {8,	0}, 	/* 0x65b7 */
        {8,	0}, 	/* 0x65b8 */
        {8,	0}, 	/* 0x65b9 */
        {8,	0}, 	/* 0x65ba */
        {8,	0}, 	/* 0x65bb */
        {8,	0}, 	/* 0x65bc */
        {8,	0}, 	/* 0x65bd */
        {8,	0}, 	/* 0x65be */
        {8,	0}, 	/* 0x65bf */
        {8,	0}, 	/* 0x65c0 */
        {8,	0}, 	/* 0x65c1 */
        {8,	0}, 	/* 0x65c2 */
        {8,	0}, 	/* 0x65c3 */
        {8,	0}, 	/* 0x65c4 */
        {8,	0}, 	/* 0x65c5 */
        {8,	0}, 	/* 0x65c6 */
        {8,	0}, 	/* 0x65c7 */
        {8,	0}, 	/* 0x65c8 */
        {8,	0}, 	/* 0x65c9 */
        {8,	0}, 	/* 0x65ca */
        {8,	0}, 	/* 0x65cb */
        {8,	0}, 	/* 0x65cc */
        {8,	0}, 	/* 0x65cd */
        {8,	0}, 	/* 0x65ce */
        {8,	0}, 	/* 0x65cf */
        {8,	0}, 	/* 0x65d0 */
        {8,	0}, 	/* 0x65d1 */
        {8,	0}, 	/* 0x65d2 */
        {8,	0}, 	/* 0x65d3 */
        {8,	0}, 	/* 0x65d4 */
        {8,	0}, 	/* 0x65d5 */
        {8,	0}, 	/* 0x65d6 */
        {8,	0}, 	/* 0x65d7 */
        {8,	0}, 	/* 0x65d8 */
        {8,	0}, 	/* 0x65d9 */
        {8,	0}, 	/* 0x65da */
        {8,	0}, 	/* 0x65db */
        {8,	0}, 	/* 0x65dc */
        {8,	0}, 	/* 0x65dd */
        {8,	0}, 	/* 0x65de */
        {8,	0}, 	/* 0x65df */
        {8,	0}, 	/* 0x65e0 */
        {8,	0}, 	/* 0x65e1 */
        {8,	0}, 	/* 0x65e2 */
        {8,	0}, 	/* 0x65e3 */
        {8,	0}, 	/* 0x65e4 */
        {8,	0}, 	/* 0x65e5 */
        {8,	0}, 	/* 0x65e6 */
        {8,	0}, 	/* 0x65e7 */
        {8,	0}, 	/* 0x65e8 */
        {8,	0}, 	/* 0x65e9 */
        {8,	0}, 	/* 0x65ea */
        {8,	0}, 	/* 0x65eb */
        {8,	0}, 	/* 0x65ec */
        {8,	0}, 	/* 0x65ed */
        {8,	0}, 	/* 0x65ee */
        {8,	0}, 	/* 0x65ef */
        {8,	0}, 	/* 0x65f0 */
        {8,	0}, 	/* 0x65f1 */
        {8,	0}, 	/* 0x65f2 */
        {8,	0}, 	/* 0x65f3 */
        {8,	0}, 	/* 0x65f4 */
        {8,	0}, 	/* 0x65f5 */
        {8,	0}, 	/* 0x65f6 */
        {8,	0}, 	/* 0x65f7 */
        {8,	0}, 	/* 0x65f8 */
        {8,	0}, 	/* 0x65f9 */
        {8,	0}, 	/* 0x65fa */
        {8,	0}, 	/* 0x65fb */
        {8,	0}, 	/* 0x65fc */
        {8,	0}, 	/* 0x65fd */
        {8,	0}, 	/* 0x65fe */
        {8,	0}, 	/* 0x65ff */
        {8,	0}, 	/* 0x6600 */
        {8,	0}, 	/* 0x6601 */
        {8,	0}, 	/* 0x6602 */
        {8,	0}, 	/* 0x6603 */
        {8,	0}, 	/* 0x6604 */
        {8,	0}, 	/* 0x6605 */
        {8,	0}, 	/* 0x6606 */
        {8,	0}, 	/* 0x6607 */
        {8,	0}, 	/* 0x6608 */
        {8,	0}, 	/* 0x6609 */
        {8,	0}, 	/* 0x660a */
        {8,	0}, 	/* 0x660b */
        {8,	0}, 	/* 0x660c */
        {8,	0}, 	/* 0x660d */
        {8,	0}, 	/* 0x660e */
        {8,	0}, 	/* 0x660f */
        {8,	0}, 	/* 0x6610 */
        {8,	0}, 	/* 0x6611 */
        {8,	0}, 	/* 0x6612 */
        {8,	0}, 	/* 0x6613 */
        {8,	0}, 	/* 0x6614 */
        {8,	0}, 	/* 0x6615 */
        {8,	0}, 	/* 0x6616 */
        {8,	0}, 	/* 0x6617 */
        {8,	0}, 	/* 0x6618 */
        {8,	0}, 	/* 0x6619 */
        {8,	0}, 	/* 0x661a */
        {8,	0}, 	/* 0x661b */
        {8,	0}, 	/* 0x661c */
        {8,	0}, 	/* 0x661d */
        {8,	0}, 	/* 0x661e */
        {8,	0}, 	/* 0x661f */
        {8,	0}, 	/* 0x6620 */
        {8,	0}, 	/* 0x6621 */
        {8,	0}, 	/* 0x6622 */
        {8,	0}, 	/* 0x6623 */
        {8,	0}, 	/* 0x6624 */
        {8,	0}, 	/* 0x6625 */
        {8,	0}, 	/* 0x6626 */
        {8,	0}, 	/* 0x6627 */
        {8,	0}, 	/* 0x6628 */
        {8,	0}, 	/* 0x6629 */
        {8,	0}, 	/* 0x662a */
        {8,	0}, 	/* 0x662b */
        {8,	0}, 	/* 0x662c */
        {8,	0}, 	/* 0x662d */
        {8,	0}, 	/* 0x662e */
        {8,	0}, 	/* 0x662f */
        {8,	0}, 	/* 0x6630 */
        {8,	0}, 	/* 0x6631 */
        {8,	0}, 	/* 0x6632 */
        {8,	0}, 	/* 0x6633 */
        {8,	0}, 	/* 0x6634 */
        {8,	0}, 	/* 0x6635 */
        {8,	0}, 	/* 0x6636 */
        {8,	0}, 	/* 0x6637 */
        {8,	0}, 	/* 0x6638 */
        {8,	0}, 	/* 0x6639 */
        {8,	0}, 	/* 0x663a */
        {8,	0}, 	/* 0x663b */
        {8,	0}, 	/* 0x663c */
        {8,	0}, 	/* 0x663d */
        {8,	0}, 	/* 0x663e */
        {8,	0}, 	/* 0x663f */
        {8,	0}, 	/* 0x6640 */
        {8,	0}, 	/* 0x6641 */
        {8,	0}, 	/* 0x6642 */
        {8,	0}, 	/* 0x6643 */
        {8,	0}, 	/* 0x6644 */
        {8,	0}, 	/* 0x6645 */
        {8,	0}, 	/* 0x6646 */
        {8,	0}, 	/* 0x6647 */
        {8,	0}, 	/* 0x6648 */
        {8,	0}, 	/* 0x6649 */
        {8,	0}, 	/* 0x664a */
        {8,	0}, 	/* 0x664b */
        {8,	0}, 	/* 0x664c */
        {8,	0}, 	/* 0x664d */
        {8,	0}, 	/* 0x664e */
        {8,	0}, 	/* 0x664f */
        {8,	0}, 	/* 0x6650 */
        {8,	0}, 	/* 0x6651 */
        {8,	0}, 	/* 0x6652 */
        {8,	0}, 	/* 0x6653 */
        {8,	0}, 	/* 0x6654 */
        {8,	0}, 	/* 0x6655 */
        {8,	0}, 	/* 0x6656 */
        {8,	0}, 	/* 0x6657 */
        {8,	0}, 	/* 0x6658 */
        {8,	0}, 	/* 0x6659 */
        {8,	0}, 	/* 0x665a */
        {8,	0}, 	/* 0x665b */
        {8,	0}, 	/* 0x665c */
        {8,	0}, 	/* 0x665d */
        {8,	0}, 	/* 0x665e */
        {8,	0}, 	/* 0x665f */
        {8,	0}, 	/* 0x6660 */
        {8,	0}, 	/* 0x6661 */
        {8,	0}, 	/* 0x6662 */
        {8,	0}, 	/* 0x6663 */
        {8,	0}, 	/* 0x6664 */
        {8,	0}, 	/* 0x6665 */
        {8,	0}, 	/* 0x6666 */
        {8,	0}, 	/* 0x6667 */
        {8,	0}, 	/* 0x6668 */
        {8,	0}, 	/* 0x6669 */
        {8,	0}, 	/* 0x666a */
        {8,	0}, 	/* 0x666b */
        {8,	0}, 	/* 0x666c */
        {8,	0}, 	/* 0x666d */
        {8,	0}, 	/* 0x666e */
        {8,	0}, 	/* 0x666f */
        {8,	0}, 	/* 0x6670 */
        {8,	0}, 	/* 0x6671 */
        {8,	0}, 	/* 0x6672 */
        {8,	0}, 	/* 0x6673 */
        {8,	0}, 	/* 0x6674 */
        {8,	0}, 	/* 0x6675 */
        {8,	0}, 	/* 0x6676 */
        {8,	0}, 	/* 0x6677 */
        {8,	0}, 	/* 0x6678 */
        {8,	0}, 	/* 0x6679 */
        {8,	0}, 	/* 0x667a */
        {8,	0}, 	/* 0x667b */
        {8,	0}, 	/* 0x667c */
        {8,	0}, 	/* 0x667d */
        {8,	0}, 	/* 0x667e */
        {8,	0}, 	/* 0x667f */
        {8,	0}, 	/* 0x6680 */
        {8,	0}, 	/* 0x6681 */
        {8,	0}, 	/* 0x6682 */
        {8,	0}, 	/* 0x6683 */
        {8,	0}, 	/* 0x6684 */
        {8,	0}, 	/* 0x6685 */
        {8,	0}, 	/* 0x6686 */
        {8,	0}, 	/* 0x6687 */
        {8,	0}, 	/* 0x6688 */
        {8,	0}, 	/* 0x6689 */
        {8,	0}, 	/* 0x668a */
        {8,	0}, 	/* 0x668b */
        {8,	0}, 	/* 0x668c */
        {8,	0}, 	/* 0x668d */
        {8,	0}, 	/* 0x668e */
        {8,	0}, 	/* 0x668f */
        {8,	0}, 	/* 0x6690 */
        {8,	0}, 	/* 0x6691 */
        {8,	0}, 	/* 0x6692 */
        {8,	0}, 	/* 0x6693 */
        {8,	0}, 	/* 0x6694 */
        {8,	0}, 	/* 0x6695 */
        {8,	0}, 	/* 0x6696 */
        {8,	0}, 	/* 0x6697 */
        {8,	0}, 	/* 0x6698 */
        {8,	0}, 	/* 0x6699 */
        {8,	0}, 	/* 0x669a */
        {8,	0}, 	/* 0x669b */
        {8,	0}, 	/* 0x669c */
        {8,	0}, 	/* 0x669d */
        {8,	0}, 	/* 0x669e */
        {8,	0}, 	/* 0x669f */
        {8,	0}, 	/* 0x66a0 */
        {8,	0}, 	/* 0x66a1 */
        {8,	0}, 	/* 0x66a2 */
        {8,	0}, 	/* 0x66a3 */
        {8,	0}, 	/* 0x66a4 */
        {8,	0}, 	/* 0x66a5 */
        {8,	0}, 	/* 0x66a6 */
        {8,	0}, 	/* 0x66a7 */
        {8,	0}, 	/* 0x66a8 */
        {8,	0}, 	/* 0x66a9 */
        {8,	0}, 	/* 0x66aa */
        {8,	0}, 	/* 0x66ab */
        {8,	0}, 	/* 0x66ac */
        {8,	0}, 	/* 0x66ad */
        {8,	0}, 	/* 0x66ae */
        {8,	0}, 	/* 0x66af */
        {8,	0}, 	/* 0x66b0 */
        {8,	0}, 	/* 0x66b1 */
        {8,	0}, 	/* 0x66b2 */
        {8,	0}, 	/* 0x66b3 */
        {8,	0}, 	/* 0x66b4 */
        {8,	0}, 	/* 0x66b5 */
        {8,	0}, 	/* 0x66b6 */
        {8,	0}, 	/* 0x66b7 */
        {8,	0}, 	/* 0x66b8 */
        {8,	0}, 	/* 0x66b9 */
        {8,	0}, 	/* 0x66ba */
        {8,	0}, 	/* 0x66bb */
        {8,	0}, 	/* 0x66bc */
        {8,	0}, 	/* 0x66bd */
        {8,	0}, 	/* 0x66be */
        {8,	0}, 	/* 0x66bf */
        {8,	0}, 	/* 0x66c0 */
        {8,	0}, 	/* 0x66c1 */
        {8,	0}, 	/* 0x66c2 */
        {8,	0}, 	/* 0x66c3 */
        {8,	0}, 	/* 0x66c4 */
        {8,	0}, 	/* 0x66c5 */
        {8,	0}, 	/* 0x66c6 */
        {8,	0}, 	/* 0x66c7 */
        {8,	0}, 	/* 0x66c8 */
        {8,	0}, 	/* 0x66c9 */
        {8,	0}, 	/* 0x66ca */
        {8,	0}, 	/* 0x66cb */
        {8,	0}, 	/* 0x66cc */
        {8,	0}, 	/* 0x66cd */
        {8,	0}, 	/* 0x66ce */
        {8,	0}, 	/* 0x66cf */
        {8,	0}, 	/* 0x66d0 */
        {8,	0}, 	/* 0x66d1 */
        {8,	0}, 	/* 0x66d2 */
        {8,	0}, 	/* 0x66d3 */
        {8,	0}, 	/* 0x66d4 */
        {8,	0}, 	/* 0x66d5 */
        {8,	0}, 	/* 0x66d6 */
        {8,	0}, 	/* 0x66d7 */
        {8,	0}, 	/* 0x66d8 */
        {8,	0}, 	/* 0x66d9 */
        {8,	0}, 	/* 0x66da */
        {8,	0}, 	/* 0x66db */
        {8,	0}, 	/* 0x66dc */
        {8,	0}, 	/* 0x66dd */
        {8,	0}, 	/* 0x66de */
        {8,	0}, 	/* 0x66df */
        {8,	0}, 	/* 0x66e0 */
        {8,	0}, 	/* 0x66e1 */
        {8,	0}, 	/* 0x66e2 */
        {8,	0}, 	/* 0x66e3 */
        {8,	0}, 	/* 0x66e4 */
        {8,	0}, 	/* 0x66e5 */
        {8,	0}, 	/* 0x66e6 */
        {8,	0}, 	/* 0x66e7 */
        {8,	0}, 	/* 0x66e8 */
        {8,	0}, 	/* 0x66e9 */
        {8,	0}, 	/* 0x66ea */
        {8,	0}, 	/* 0x66eb */
        {8,	0}, 	/* 0x66ec */
        {8,	0}, 	/* 0x66ed */
        {8,	0}, 	/* 0x66ee */
        {8,	0}, 	/* 0x66ef */
        {8,	0}, 	/* 0x66f0 */
        {8,	0}, 	/* 0x66f1 */
        {8,	0}, 	/* 0x66f2 */
        {8,	0}, 	/* 0x66f3 */
        {8,	0}, 	/* 0x66f4 */
        {8,	0}, 	/* 0x66f5 */
        {8,	0}, 	/* 0x66f6 */
        {8,	0}, 	/* 0x66f7 */
        {8,	0}, 	/* 0x66f8 */
        {8,	0}, 	/* 0x66f9 */
        {8,	0}, 	/* 0x66fa */
        {8,	0}, 	/* 0x66fb */
        {8,	0}, 	/* 0x66fc */
        {8,	0}, 	/* 0x66fd */
        {8,	0}, 	/* 0x66fe */
        {8,	0}, 	/* 0x66ff */
        {8,	0}, 	/* 0x6700 */
        {8,	0}, 	/* 0x6701 */
        {8,	0}, 	/* 0x6702 */
        {8,	0}, 	/* 0x6703 */
        {8,	0}, 	/* 0x6704 */
        {8,	0}, 	/* 0x6705 */
        {8,	0}, 	/* 0x6706 */
        {8,	0}, 	/* 0x6707 */
        {8,	0}, 	/* 0x6708 */
        {8,	0}, 	/* 0x6709 */
        {8,	0}, 	/* 0x670a */
        {8,	0}, 	/* 0x670b */
        {8,	0}, 	/* 0x670c */
        {8,	0}, 	/* 0x670d */
        {8,	0}, 	/* 0x670e */
        {8,	0}, 	/* 0x670f */
        {8,	0}, 	/* 0x6710 */
        {8,	0}, 	/* 0x6711 */
        {8,	0}, 	/* 0x6712 */
        {8,	0}, 	/* 0x6713 */
        {8,	0}, 	/* 0x6714 */
        {8,	0}, 	/* 0x6715 */
        {8,	0}, 	/* 0x6716 */
        {8,	0}, 	/* 0x6717 */
        {8,	0}, 	/* 0x6718 */
        {8,	0}, 	/* 0x6719 */
        {8,	0}, 	/* 0x671a */
        {8,	0}, 	/* 0x671b */
        {8,	0}, 	/* 0x671c */
        {8,	0}, 	/* 0x671d */
        {8,	0}, 	/* 0x671e */
        {8,	0}, 	/* 0x671f */
        {8,	0}, 	/* 0x6720 */
        {8,	0}, 	/* 0x6721 */
        {8,	0}, 	/* 0x6722 */
        {8,	0}, 	/* 0x6723 */
        {8,	0}, 	/* 0x6724 */
        {8,	0}, 	/* 0x6725 */
        {8,	0}, 	/* 0x6726 */
        {8,	0}, 	/* 0x6727 */
        {8,	0}, 	/* 0x6728 */
        {8,	0}, 	/* 0x6729 */
        {8,	0}, 	/* 0x672a */
        {8,	0}, 	/* 0x672b */
        {8,	0}, 	/* 0x672c */
        {8,	0}, 	/* 0x672d */
        {8,	0}, 	/* 0x672e */
        {8,	0}, 	/* 0x672f */
        {8,	0}, 	/* 0x6730 */
        {8,	0}, 	/* 0x6731 */
        {8,	0}, 	/* 0x6732 */
        {8,	0}, 	/* 0x6733 */
        {8,	0}, 	/* 0x6734 */
        {8,	0}, 	/* 0x6735 */
        {8,	0}, 	/* 0x6736 */
        {8,	0}, 	/* 0x6737 */
        {8,	0}, 	/* 0x6738 */
        {8,	0}, 	/* 0x6739 */
        {8,	0}, 	/* 0x673a */
        {8,	0}, 	/* 0x673b */
        {8,	0}, 	/* 0x673c */
        {8,	0}, 	/* 0x673d */
        {8,	0}, 	/* 0x673e */
        {8,	0}, 	/* 0x673f */
        {8,	0}, 	/* 0x6740 */
        {8,	0}, 	/* 0x6741 */
        {8,	0}, 	/* 0x6742 */
        {8,	0}, 	/* 0x6743 */
        {8,	0}, 	/* 0x6744 */
        {8,	0}, 	/* 0x6745 */
        {8,	0}, 	/* 0x6746 */
        {8,	0}, 	/* 0x6747 */
        {8,	0}, 	/* 0x6748 */
        {8,	0}, 	/* 0x6749 */
        {8,	0}, 	/* 0x674a */
        {8,	0}, 	/* 0x674b */
        {8,	0}, 	/* 0x674c */
        {8,	0}, 	/* 0x674d */
        {8,	0}, 	/* 0x674e */
        {8,	0}, 	/* 0x674f */
        {8,	0}, 	/* 0x6750 */
        {8,	0}, 	/* 0x6751 */
        {8,	0}, 	/* 0x6752 */
        {8,	0}, 	/* 0x6753 */
        {8,	0}, 	/* 0x6754 */
        {8,	0}, 	/* 0x6755 */
        {8,	0}, 	/* 0x6756 */
        {8,	0}, 	/* 0x6757 */
        {8,	0}, 	/* 0x6758 */
        {8,	0}, 	/* 0x6759 */
        {8,	0}, 	/* 0x675a */
        {8,	0}, 	/* 0x675b */
        {8,	0}, 	/* 0x675c */
        {8,	0}, 	/* 0x675d */
        {8,	0}, 	/* 0x675e */
        {8,	0}, 	/* 0x675f */
        {8,	0}, 	/* 0x6760 */
        {8,	0}, 	/* 0x6761 */
        {8,	0}, 	/* 0x6762 */
        {8,	0}, 	/* 0x6763 */
        {8,	0}, 	/* 0x6764 */
        {8,	0}, 	/* 0x6765 */
        {8,	0}, 	/* 0x6766 */
        {8,	0}, 	/* 0x6767 */
        {8,	0}, 	/* 0x6768 */
        {8,	0}, 	/* 0x6769 */
        {8,	0}, 	/* 0x676a */
        {8,	0}, 	/* 0x676b */
        {8,	0}, 	/* 0x676c */
        {8,	0}, 	/* 0x676d */
        {8,	0}, 	/* 0x676e */
        {8,	0}, 	/* 0x676f */
        {8,	0}, 	/* 0x6770 */
        {8,	0}, 	/* 0x6771 */
        {8,	0}, 	/* 0x6772 */
        {8,	0}, 	/* 0x6773 */
        {8,	0}, 	/* 0x6774 */
        {8,	0}, 	/* 0x6775 */
        {8,	0}, 	/* 0x6776 */
        {8,	0}, 	/* 0x6777 */
        {8,	0}, 	/* 0x6778 */
        {8,	0}, 	/* 0x6779 */
        {8,	0}, 	/* 0x677a */
        {8,	0}, 	/* 0x677b */
        {8,	0}, 	/* 0x677c */
        {8,	0}, 	/* 0x677d */
        {8,	0}, 	/* 0x677e */
        {8,	0}, 	/* 0x677f */
        {8,	0}, 	/* 0x6780 */
        {8,	0}, 	/* 0x6781 */
        {8,	0}, 	/* 0x6782 */
        {8,	0}, 	/* 0x6783 */
        {8,	0}, 	/* 0x6784 */
        {8,	0}, 	/* 0x6785 */
        {8,	0}, 	/* 0x6786 */
        {8,	0}, 	/* 0x6787 */
        {8,	0}, 	/* 0x6788 */
        {8,	0}, 	/* 0x6789 */
        {8,	0}, 	/* 0x678a */
        {8,	0}, 	/* 0x678b */
        {8,	0}, 	/* 0x678c */
        {8,	0}, 	/* 0x678d */
        {8,	0}, 	/* 0x678e */
        {8,	0}, 	/* 0x678f */
        {8,	0}, 	/* 0x6790 */
        {8,	0}, 	/* 0x6791 */
        {8,	0}, 	/* 0x6792 */
        {8,	0}, 	/* 0x6793 */
        {8,	0}, 	/* 0x6794 */
        {8,	0}, 	/* 0x6795 */
        {8,	0}, 	/* 0x6796 */
        {8,	0}, 	/* 0x6797 */
        {8,	0}, 	/* 0x6798 */
        {8,	0}, 	/* 0x6799 */
        {8,	0}, 	/* 0x679a */
        {8,	0}, 	/* 0x679b */
        {8,	0}, 	/* 0x679c */
        {8,	0}, 	/* 0x679d */
        {8,	0}, 	/* 0x679e */
        {8,	0}, 	/* 0x679f */
        {8,	0}, 	/* 0x67a0 */
        {8,	0}, 	/* 0x67a1 */
        {8,	0}, 	/* 0x67a2 */
        {8,	0}, 	/* 0x67a3 */
        {8,	0}, 	/* 0x67a4 */
        {8,	0}, 	/* 0x67a5 */
        {8,	0}, 	/* 0x67a6 */
        {8,	0}, 	/* 0x67a7 */
        {8,	0}, 	/* 0x67a8 */
        {8,	0}, 	/* 0x67a9 */
        {8,	0}, 	/* 0x67aa */
        {8,	0}, 	/* 0x67ab */
        {8,	0}, 	/* 0x67ac */
        {8,	0}, 	/* 0x67ad */
        {8,	0}, 	/* 0x67ae */
        {8,	0}, 	/* 0x67af */
        {8,	0}, 	/* 0x67b0 */
        {8,	0}, 	/* 0x67b1 */
        {8,	0}, 	/* 0x67b2 */
        {8,	0}, 	/* 0x67b3 */
        {8,	0}, 	/* 0x67b4 */
        {8,	0}, 	/* 0x67b5 */
        {8,	0}, 	/* 0x67b6 */
        {8,	0}, 	/* 0x67b7 */
        {8,	0}, 	/* 0x67b8 */
        {8,	0}, 	/* 0x67b9 */
        {8,	0}, 	/* 0x67ba */
        {8,	0}, 	/* 0x67bb */
        {8,	0}, 	/* 0x67bc */
        {8,	0}, 	/* 0x67bd */
        {8,	0}, 	/* 0x67be */
        {8,	0}, 	/* 0x67bf */
        {8,	0}, 	/* 0x67c0 */
        {8,	0}, 	/* 0x67c1 */
        {8,	0}, 	/* 0x67c2 */
        {8,	0}, 	/* 0x67c3 */
        {8,	0}, 	/* 0x67c4 */
        {8,	0}, 	/* 0x67c5 */
        {8,	0}, 	/* 0x67c6 */
        {8,	0}, 	/* 0x67c7 */
        {8,	0}, 	/* 0x67c8 */
        {8,	0}, 	/* 0x67c9 */
        {8,	0}, 	/* 0x67ca */
        {8,	0}, 	/* 0x67cb */
        {8,	0}, 	/* 0x67cc */
        {8,	0}, 	/* 0x67cd */
        {8,	0}, 	/* 0x67ce */
        {8,	0}, 	/* 0x67cf */
        {8,	0}, 	/* 0x67d0 */
        {8,	0}, 	/* 0x67d1 */
        {8,	0}, 	/* 0x67d2 */
        {8,	0}, 	/* 0x67d3 */
        {8,	0}, 	/* 0x67d4 */
        {8,	0}, 	/* 0x67d5 */
        {8,	0}, 	/* 0x67d6 */
        {8,	0}, 	/* 0x67d7 */
        {8,	0}, 	/* 0x67d8 */
        {8,	0}, 	/* 0x67d9 */
        {8,	0}, 	/* 0x67da */
        {8,	0}, 	/* 0x67db */
        {8,	0}, 	/* 0x67dc */
        {8,	0}, 	/* 0x67dd */
        {8,	0}, 	/* 0x67de */
        {8,	0}, 	/* 0x67df */
        {8,	0}, 	/* 0x67e0 */
        {8,	0}, 	/* 0x67e1 */
        {8,	0}, 	/* 0x67e2 */
        {8,	0}, 	/* 0x67e3 */
        {8,	0}, 	/* 0x67e4 */
        {8,	0}, 	/* 0x67e5 */
        {8,	0}, 	/* 0x67e6 */
        {8,	0}, 	/* 0x67e7 */
        {8,	0}, 	/* 0x67e8 */
        {8,	0}, 	/* 0x67e9 */
        {8,	0}, 	/* 0x67ea */
        {8,	0}, 	/* 0x67eb */
        {8,	0}, 	/* 0x67ec */
        {8,	0}, 	/* 0x67ed */
        {8,	0}, 	/* 0x67ee */
        {8,	0}, 	/* 0x67ef */
        {8,	0}, 	/* 0x67f0 */
        {8,	0}, 	/* 0x67f1 */
        {8,	0}, 	/* 0x67f2 */
        {8,	0}, 	/* 0x67f3 */
        {8,	0}, 	/* 0x67f4 */
        {8,	0}, 	/* 0x67f5 */
        {8,	0}, 	/* 0x67f6 */
        {8,	0}, 	/* 0x67f7 */
        {8,	0}, 	/* 0x67f8 */
        {8,	0}, 	/* 0x67f9 */
        {8,	0}, 	/* 0x67fa */
        {8,	0}, 	/* 0x67fb */
        {8,	0}, 	/* 0x67fc */
        {8,	0}, 	/* 0x67fd */
        {8,	0}, 	/* 0x67fe */
        {8,	0}, 	/* 0x67ff */
        {8,	0}, 	/* 0x6800 */
        {8,	0}, 	/* 0x6801 */
        {8,	0}, 	/* 0x6802 */
        {8,	0}, 	/* 0x6803 */
        {8,	0}, 	/* 0x6804 */
        {8,	0}, 	/* 0x6805 */
        {8,	0}, 	/* 0x6806 */
        {8,	0}, 	/* 0x6807 */
        {8,	0}, 	/* 0x6808 */
        {8,	0}, 	/* 0x6809 */
        {8,	0}, 	/* 0x680a */
        {8,	0}, 	/* 0x680b */
        {8,	0}, 	/* 0x680c */
        {8,	0}, 	/* 0x680d */
        {8,	0}, 	/* 0x680e */
        {8,	0}, 	/* 0x680f */
        {8,	0}, 	/* 0x6810 */
        {8,	0}, 	/* 0x6811 */
        {8,	0}, 	/* 0x6812 */
        {8,	0}, 	/* 0x6813 */
        {8,	0}, 	/* 0x6814 */
        {8,	0}, 	/* 0x6815 */
        {8,	0}, 	/* 0x6816 */
        {8,	0}, 	/* 0x6817 */
        {8,	0}, 	/* 0x6818 */
        {8,	0}, 	/* 0x6819 */
        {8,	0}, 	/* 0x681a */
        {8,	0}, 	/* 0x681b */
        {8,	0}, 	/* 0x681c */
        {8,	0}, 	/* 0x681d */
        {8,	0}, 	/* 0x681e */
        {8,	0}, 	/* 0x681f */
        {8,	0}, 	/* 0x6820 */
        {8,	0}, 	/* 0x6821 */
        {8,	0}, 	/* 0x6822 */
        {8,	0}, 	/* 0x6823 */
        {8,	0}, 	/* 0x6824 */
        {8,	0}, 	/* 0x6825 */
        {8,	0}, 	/* 0x6826 */
        {8,	0}, 	/* 0x6827 */
        {8,	0}, 	/* 0x6828 */
        {8,	0}, 	/* 0x6829 */
        {8,	0}, 	/* 0x682a */
        {8,	0}, 	/* 0x682b */
        {8,	0}, 	/* 0x682c */
        {8,	0}, 	/* 0x682d */
        {8,	0}, 	/* 0x682e */
        {8,	0}, 	/* 0x682f */
        {8,	0}, 	/* 0x6830 */
        {8,	0}, 	/* 0x6831 */
        {8,	0}, 	/* 0x6832 */
        {8,	0}, 	/* 0x6833 */
        {8,	0}, 	/* 0x6834 */
        {8,	0}, 	/* 0x6835 */
        {8,	0}, 	/* 0x6836 */
        {8,	0}, 	/* 0x6837 */
        {8,	0}, 	/* 0x6838 */
        {8,	0}, 	/* 0x6839 */
        {8,	0}, 	/* 0x683a */
        {8,	0}, 	/* 0x683b */
        {8,	0}, 	/* 0x683c */
        {8,	0}, 	/* 0x683d */
        {8,	0}, 	/* 0x683e */
        {8,	0}, 	/* 0x683f */
        {8,	0}, 	/* 0x6840 */
        {8,	0}, 	/* 0x6841 */
        {8,	0}, 	/* 0x6842 */
        {8,	0}, 	/* 0x6843 */
        {8,	0}, 	/* 0x6844 */
        {8,	0}, 	/* 0x6845 */
        {8,	0}, 	/* 0x6846 */
        {8,	0}, 	/* 0x6847 */
        {8,	0}, 	/* 0x6848 */
        {8,	0}, 	/* 0x6849 */
        {8,	0}, 	/* 0x684a */
        {8,	0}, 	/* 0x684b */
        {8,	0}, 	/* 0x684c */
        {8,	0}, 	/* 0x684d */
        {8,	0}, 	/* 0x684e */
        {8,	0}, 	/* 0x684f */
        {8,	0}, 	/* 0x6850 */
        {8,	0}, 	/* 0x6851 */
        {8,	0}, 	/* 0x6852 */
        {8,	0}, 	/* 0x6853 */
        {8,	0}, 	/* 0x6854 */
        {8,	0}, 	/* 0x6855 */
        {8,	0}, 	/* 0x6856 */
        {8,	0}, 	/* 0x6857 */
        {8,	0}, 	/* 0x6858 */
        {8,	0}, 	/* 0x6859 */
        {8,	0}, 	/* 0x685a */
        {8,	0}, 	/* 0x685b */
        {8,	0}, 	/* 0x685c */
        {8,	0}, 	/* 0x685d */
        {8,	0}, 	/* 0x685e */
        {8,	0}, 	/* 0x685f */
        {8,	0}, 	/* 0x6860 */
        {8,	0}, 	/* 0x6861 */
        {8,	0}, 	/* 0x6862 */
        {8,	0}, 	/* 0x6863 */
        {8,	0}, 	/* 0x6864 */
        {8,	0}, 	/* 0x6865 */
        {8,	0}, 	/* 0x6866 */
        {8,	0}, 	/* 0x6867 */
        {8,	0}, 	/* 0x6868 */
        {8,	0}, 	/* 0x6869 */
        {8,	0}, 	/* 0x686a */
        {8,	0}, 	/* 0x686b */
        {8,	0}, 	/* 0x686c */
        {8,	0}, 	/* 0x686d */
        {8,	0}, 	/* 0x686e */
        {8,	0}, 	/* 0x686f */
        {8,	0}, 	/* 0x6870 */
        {8,	0}, 	/* 0x6871 */
        {8,	0}, 	/* 0x6872 */
        {8,	0}, 	/* 0x6873 */
        {8,	0}, 	/* 0x6874 */
        {8,	0}, 	/* 0x6875 */
        {8,	0}, 	/* 0x6876 */
        {8,	0}, 	/* 0x6877 */
        {8,	0}, 	/* 0x6878 */
        {8,	0}, 	/* 0x6879 */
        {8,	0}, 	/* 0x687a */
        {8,	0}, 	/* 0x687b */
        {8,	0}, 	/* 0x687c */
        {8,	0}, 	/* 0x687d */
        {8,	0}, 	/* 0x687e */
        {8,	0}, 	/* 0x687f */
        {8,	0}, 	/* 0x6880 */
        {8,	0}, 	/* 0x6881 */
        {8,	0}, 	/* 0x6882 */
        {8,	0}, 	/* 0x6883 */
        {8,	0}, 	/* 0x6884 */
        {8,	0}, 	/* 0x6885 */
        {8,	0}, 	/* 0x6886 */
        {8,	0}, 	/* 0x6887 */
        {8,	0}, 	/* 0x6888 */
        {8,	0}, 	/* 0x6889 */
        {8,	0}, 	/* 0x688a */
        {8,	0}, 	/* 0x688b */
        {8,	0}, 	/* 0x688c */
        {8,	0}, 	/* 0x688d */
        {8,	0}, 	/* 0x688e */
        {8,	0}, 	/* 0x688f */
        {8,	0}, 	/* 0x6890 */
        {8,	0}, 	/* 0x6891 */
        {8,	0}, 	/* 0x6892 */
        {8,	0}, 	/* 0x6893 */
        {8,	0}, 	/* 0x6894 */
        {8,	0}, 	/* 0x6895 */
        {8,	0}, 	/* 0x6896 */
        {8,	0}, 	/* 0x6897 */
        {8,	0}, 	/* 0x6898 */
        {8,	0}, 	/* 0x6899 */
        {8,	0}, 	/* 0x689a */
        {8,	0}, 	/* 0x689b */
        {8,	0}, 	/* 0x689c */
        {8,	0}, 	/* 0x689d */
        {8,	0}, 	/* 0x689e */
        {8,	0}, 	/* 0x689f */
        {8,	0}, 	/* 0x68a0 */
        {8,	0}, 	/* 0x68a1 */
        {8,	0}, 	/* 0x68a2 */
        {8,	0}, 	/* 0x68a3 */
        {8,	0}, 	/* 0x68a4 */
        {8,	0}, 	/* 0x68a5 */
        {8,	0}, 	/* 0x68a6 */
        {8,	0}, 	/* 0x68a7 */
        {8,	0}, 	/* 0x68a8 */
        {8,	0}, 	/* 0x68a9 */
        {8,	0}, 	/* 0x68aa */
        {8,	0}, 	/* 0x68ab */
        {8,	0}, 	/* 0x68ac */
        {8,	0}, 	/* 0x68ad */
        {8,	0}, 	/* 0x68ae */
        {8,	0}, 	/* 0x68af */
        {8,	0}, 	/* 0x68b0 */
        {8,	0}, 	/* 0x68b1 */
        {8,	0}, 	/* 0x68b2 */
        {8,	0}, 	/* 0x68b3 */
        {8,	0}, 	/* 0x68b4 */
        {8,	0}, 	/* 0x68b5 */
        {8,	0}, 	/* 0x68b6 */
        {8,	0}, 	/* 0x68b7 */
        {8,	0}, 	/* 0x68b8 */
        {8,	0}, 	/* 0x68b9 */
        {8,	0}, 	/* 0x68ba */
        {8,	0}, 	/* 0x68bb */
        {8,	0}, 	/* 0x68bc */
        {8,	0}, 	/* 0x68bd */
        {8,	0}, 	/* 0x68be */
        {8,	0}, 	/* 0x68bf */
        {8,	0}, 	/* 0x68c0 */
        {8,	0}, 	/* 0x68c1 */
        {8,	0}, 	/* 0x68c2 */
        {8,	0}, 	/* 0x68c3 */
        {8,	0}, 	/* 0x68c4 */
        {8,	0}, 	/* 0x68c5 */
        {8,	0}, 	/* 0x68c6 */
        {8,	0}, 	/* 0x68c7 */
        {8,	0}, 	/* 0x68c8 */
        {8,	0}, 	/* 0x68c9 */
        {8,	0}, 	/* 0x68ca */
        {8,	0}, 	/* 0x68cb */
        {8,	0}, 	/* 0x68cc */
        {8,	0}, 	/* 0x68cd */
        {8,	0}, 	/* 0x68ce */
        {8,	0}, 	/* 0x68cf */
        {8,	0}, 	/* 0x68d0 */
        {8,	0}, 	/* 0x68d1 */
        {8,	0}, 	/* 0x68d2 */
        {8,	0}, 	/* 0x68d3 */
        {8,	0}, 	/* 0x68d4 */
        {8,	0}, 	/* 0x68d5 */
        {8,	0}, 	/* 0x68d6 */
        {8,	0}, 	/* 0x68d7 */
        {8,	0}, 	/* 0x68d8 */
        {8,	0}, 	/* 0x68d9 */
        {8,	0}, 	/* 0x68da */
        {8,	0}, 	/* 0x68db */
        {8,	0}, 	/* 0x68dc */
        {8,	0}, 	/* 0x68dd */
        {8,	0}, 	/* 0x68de */
        {8,	0}, 	/* 0x68df */
        {8,	0}, 	/* 0x68e0 */
        {8,	0}, 	/* 0x68e1 */
        {8,	0}, 	/* 0x68e2 */
        {8,	0}, 	/* 0x68e3 */
        {8,	0}, 	/* 0x68e4 */
        {8,	0}, 	/* 0x68e5 */
        {8,	0}, 	/* 0x68e6 */
        {8,	0}, 	/* 0x68e7 */
        {8,	0}, 	/* 0x68e8 */
        {8,	0}, 	/* 0x68e9 */
        {8,	0}, 	/* 0x68ea */
        {8,	0}, 	/* 0x68eb */
        {8,	0}, 	/* 0x68ec */
        {8,	0}, 	/* 0x68ed */
        {8,	0}, 	/* 0x68ee */
        {8,	0}, 	/* 0x68ef */
        {8,	0}, 	/* 0x68f0 */
        {8,	0}, 	/* 0x68f1 */
        {8,	0}, 	/* 0x68f2 */
        {8,	0}, 	/* 0x68f3 */
        {8,	0}, 	/* 0x68f4 */
        {8,	0}, 	/* 0x68f5 */
        {8,	0}, 	/* 0x68f6 */
        {8,	0}, 	/* 0x68f7 */
        {8,	0}, 	/* 0x68f8 */
        {8,	0}, 	/* 0x68f9 */
        {8,	0}, 	/* 0x68fa */
        {8,	0}, 	/* 0x68fb */
        {8,	0}, 	/* 0x68fc */
        {8,	0}, 	/* 0x68fd */
        {8,	0}, 	/* 0x68fe */
        {8,	0}, 	/* 0x68ff */
        {8,	0}, 	/* 0x6900 */
        {8,	0}, 	/* 0x6901 */
        {8,	0}, 	/* 0x6902 */
        {8,	0}, 	/* 0x6903 */
        {8,	0}, 	/* 0x6904 */
        {8,	0}, 	/* 0x6905 */
        {8,	0}, 	/* 0x6906 */
        {8,	0}, 	/* 0x6907 */
        {8,	0}, 	/* 0x6908 */
        {8,	0}, 	/* 0x6909 */
        {8,	0}, 	/* 0x690a */
        {8,	0}, 	/* 0x690b */
        {8,	0}, 	/* 0x690c */
        {8,	0}, 	/* 0x690d */
        {8,	0}, 	/* 0x690e */
        {8,	0}, 	/* 0x690f */
        {8,	0}, 	/* 0x6910 */
        {8,	0}, 	/* 0x6911 */
        {8,	0}, 	/* 0x6912 */
        {8,	0}, 	/* 0x6913 */
        {8,	0}, 	/* 0x6914 */
        {8,	0}, 	/* 0x6915 */
        {8,	0}, 	/* 0x6916 */
        {8,	0}, 	/* 0x6917 */
        {8,	0}, 	/* 0x6918 */
        {8,	0}, 	/* 0x6919 */
        {8,	0}, 	/* 0x691a */
        {8,	0}, 	/* 0x691b */
        {8,	0}, 	/* 0x691c */
        {8,	0}, 	/* 0x691d */
        {8,	0}, 	/* 0x691e */
        {8,	0}, 	/* 0x691f */
        {8,	0}, 	/* 0x6920 */
        {8,	0}, 	/* 0x6921 */
        {8,	0}, 	/* 0x6922 */
        {8,	0}, 	/* 0x6923 */
        {8,	0}, 	/* 0x6924 */
        {8,	0}, 	/* 0x6925 */
        {8,	0}, 	/* 0x6926 */
        {8,	0}, 	/* 0x6927 */
        {8,	0}, 	/* 0x6928 */
        {8,	0}, 	/* 0x6929 */
        {8,	0}, 	/* 0x692a */
        {8,	0}, 	/* 0x692b */
        {8,	0}, 	/* 0x692c */
        {8,	0}, 	/* 0x692d */
        {8,	0}, 	/* 0x692e */
        {8,	0}, 	/* 0x692f */
        {8,	0}, 	/* 0x6930 */
        {8,	0}, 	/* 0x6931 */
        {8,	0}, 	/* 0x6932 */
        {8,	0}, 	/* 0x6933 */
        {8,	0}, 	/* 0x6934 */
        {8,	0}, 	/* 0x6935 */
        {8,	0}, 	/* 0x6936 */
        {8,	0}, 	/* 0x6937 */
        {8,	0}, 	/* 0x6938 */
        {8,	0}, 	/* 0x6939 */
        {8,	0}, 	/* 0x693a */
        {8,	0}, 	/* 0x693b */
        {8,	0}, 	/* 0x693c */
        {8,	0}, 	/* 0x693d */
        {8,	0}, 	/* 0x693e */
        {8,	0}, 	/* 0x693f */
        {8,	0}, 	/* 0x6940 */
        {8,	0}, 	/* 0x6941 */
        {8,	0}, 	/* 0x6942 */
        {8,	0}, 	/* 0x6943 */
        {8,	0}, 	/* 0x6944 */
        {8,	0}, 	/* 0x6945 */
        {8,	0}, 	/* 0x6946 */
        {8,	0}, 	/* 0x6947 */
        {8,	0}, 	/* 0x6948 */
        {8,	0}, 	/* 0x6949 */
        {8,	0}, 	/* 0x694a */
        {8,	0}, 	/* 0x694b */
        {8,	0}, 	/* 0x694c */
        {8,	0}, 	/* 0x694d */
        {8,	0}, 	/* 0x694e */
        {8,	0}, 	/* 0x694f */
        {8,	0}, 	/* 0x6950 */
        {8,	0}, 	/* 0x6951 */
        {8,	0}, 	/* 0x6952 */
        {8,	0}, 	/* 0x6953 */
        {8,	0}, 	/* 0x6954 */
        {8,	0}, 	/* 0x6955 */
        {8,	0}, 	/* 0x6956 */
        {8,	0}, 	/* 0x6957 */
        {8,	0}, 	/* 0x6958 */
        {8,	0}, 	/* 0x6959 */
        {8,	0}, 	/* 0x695a */
        {8,	0}, 	/* 0x695b */
        {8,	0}, 	/* 0x695c */
        {8,	0}, 	/* 0x695d */
        {8,	0}, 	/* 0x695e */
        {8,	0}, 	/* 0x695f */
        {8,	0}, 	/* 0x6960 */
        {8,	0}, 	/* 0x6961 */
        {8,	0}, 	/* 0x6962 */
        {8,	0}, 	/* 0x6963 */
        {8,	0}, 	/* 0x6964 */
        {8,	0}, 	/* 0x6965 */
        {8,	0}, 	/* 0x6966 */
        {8,	0}, 	/* 0x6967 */
        {8,	0}, 	/* 0x6968 */
        {8,	0}, 	/* 0x6969 */
        {8,	0}, 	/* 0x696a */
        {8,	0}, 	/* 0x696b */
        {8,	0}, 	/* 0x696c */
        {8,	0}, 	/* 0x696d */
        {8,	0}, 	/* 0x696e */
        {8,	0}, 	/* 0x696f */
        {8,	0}, 	/* 0x6970 */
        {8,	0}, 	/* 0x6971 */
        {8,	0}, 	/* 0x6972 */
        {8,	0}, 	/* 0x6973 */
        {8,	0}, 	/* 0x6974 */
        {8,	0}, 	/* 0x6975 */
        {8,	0}, 	/* 0x6976 */
        {8,	0}, 	/* 0x6977 */
        {8,	0}, 	/* 0x6978 */
        {8,	0}, 	/* 0x6979 */
        {8,	0}, 	/* 0x697a */
        {8,	0}, 	/* 0x697b */
        {8,	0}, 	/* 0x697c */
        {8,	0}, 	/* 0x697d */
        {8,	0}, 	/* 0x697e */
        {8,	0}, 	/* 0x697f */
        {8,	0}, 	/* 0x6980 */
        {8,	0}, 	/* 0x6981 */
        {8,	0}, 	/* 0x6982 */
        {8,	0}, 	/* 0x6983 */
        {8,	0}, 	/* 0x6984 */
        {8,	0}, 	/* 0x6985 */
        {8,	0}, 	/* 0x6986 */
        {8,	0}, 	/* 0x6987 */
        {8,	0}, 	/* 0x6988 */
        {8,	0}, 	/* 0x6989 */
        {8,	0}, 	/* 0x698a */
        {8,	0}, 	/* 0x698b */
        {8,	0}, 	/* 0x698c */
        {8,	0}, 	/* 0x698d */
        {8,	0}, 	/* 0x698e */
        {8,	0}, 	/* 0x698f */
        {8,	0}, 	/* 0x6990 */
        {8,	0}, 	/* 0x6991 */
        {8,	0}, 	/* 0x6992 */
        {8,	0}, 	/* 0x6993 */
        {8,	0}, 	/* 0x6994 */
        {8,	0}, 	/* 0x6995 */
        {8,	0}, 	/* 0x6996 */
        {8,	0}, 	/* 0x6997 */
        {8,	0}, 	/* 0x6998 */
        {8,	0}, 	/* 0x6999 */
        {8,	0}, 	/* 0x699a */
        {8,	0}, 	/* 0x699b */
        {8,	0}, 	/* 0x699c */
        {8,	0}, 	/* 0x699d */
        {8,	0}, 	/* 0x699e */
        {8,	0}, 	/* 0x699f */
        {8,	0}, 	/* 0x69a0 */
        {8,	0}, 	/* 0x69a1 */
        {8,	0}, 	/* 0x69a2 */
        {8,	0}, 	/* 0x69a3 */
        {8,	0}, 	/* 0x69a4 */
        {8,	0}, 	/* 0x69a5 */
        {8,	0}, 	/* 0x69a6 */
        {8,	0}, 	/* 0x69a7 */
        {8,	0}, 	/* 0x69a8 */
        {8,	0}, 	/* 0x69a9 */
        {8,	0}, 	/* 0x69aa */
        {8,	0}, 	/* 0x69ab */
        {8,	0}, 	/* 0x69ac */
        {8,	0}, 	/* 0x69ad */
        {8,	0}, 	/* 0x69ae */
        {8,	0}, 	/* 0x69af */
        {8,	0}, 	/* 0x69b0 */
        {8,	0}, 	/* 0x69b1 */
        {8,	0}, 	/* 0x69b2 */
        {8,	0}, 	/* 0x69b3 */
        {8,	0}, 	/* 0x69b4 */
        {8,	0}, 	/* 0x69b5 */
        {8,	0}, 	/* 0x69b6 */
        {8,	0}, 	/* 0x69b7 */
        {8,	0}, 	/* 0x69b8 */
        {8,	0}, 	/* 0x69b9 */
        {8,	0}, 	/* 0x69ba */
        {8,	0}, 	/* 0x69bb */
        {8,	0}, 	/* 0x69bc */
        {8,	0}, 	/* 0x69bd */
        {8,	0}, 	/* 0x69be */
        {8,	0}, 	/* 0x69bf */
        {8,	0}, 	/* 0x69c0 */
        {8,	0}, 	/* 0x69c1 */
        {8,	0}, 	/* 0x69c2 */
        {8,	0}, 	/* 0x69c3 */
        {8,	0}, 	/* 0x69c4 */
        {8,	0}, 	/* 0x69c5 */
        {8,	0}, 	/* 0x69c6 */
        {8,	0}, 	/* 0x69c7 */
        {8,	0}, 	/* 0x69c8 */
        {8,	0}, 	/* 0x69c9 */
        {8,	0}, 	/* 0x69ca */
        {8,	0}, 	/* 0x69cb */
        {8,	0}, 	/* 0x69cc */
        {8,	0}, 	/* 0x69cd */
        {8,	0}, 	/* 0x69ce */
        {8,	0}, 	/* 0x69cf */
        {8,	0}, 	/* 0x69d0 */
        {8,	0}, 	/* 0x69d1 */
        {8,	0}, 	/* 0x69d2 */
        {8,	0}, 	/* 0x69d3 */
        {8,	0}, 	/* 0x69d4 */
        {8,	0}, 	/* 0x69d5 */
        {8,	0}, 	/* 0x69d6 */
        {8,	0}, 	/* 0x69d7 */
        {8,	0}, 	/* 0x69d8 */
        {8,	0}, 	/* 0x69d9 */
        {8,	0}, 	/* 0x69da */
        {8,	0}, 	/* 0x69db */
        {8,	0}, 	/* 0x69dc */
        {8,	0}, 	/* 0x69dd */
        {8,	0}, 	/* 0x69de */
        {8,	0}, 	/* 0x69df */
        {8,	0}, 	/* 0x69e0 */
        {8,	0}, 	/* 0x69e1 */
        {8,	0}, 	/* 0x69e2 */
        {8,	0}, 	/* 0x69e3 */
        {8,	0}, 	/* 0x69e4 */
        {8,	0}, 	/* 0x69e5 */
        {8,	0}, 	/* 0x69e6 */
        {8,	0}, 	/* 0x69e7 */
        {8,	0}, 	/* 0x69e8 */
        {8,	0}, 	/* 0x69e9 */
        {8,	0}, 	/* 0x69ea */
        {8,	0}, 	/* 0x69eb */
        {8,	0}, 	/* 0x69ec */
        {8,	0}, 	/* 0x69ed */
        {8,	0}, 	/* 0x69ee */
        {8,	0}, 	/* 0x69ef */
        {8,	0}, 	/* 0x69f0 */
        {8,	0}, 	/* 0x69f1 */
        {8,	0}, 	/* 0x69f2 */
        {8,	0}, 	/* 0x69f3 */
        {8,	0}, 	/* 0x69f4 */
        {8,	0}, 	/* 0x69f5 */
        {8,	0}, 	/* 0x69f6 */
        {8,	0}, 	/* 0x69f7 */
        {8,	0}, 	/* 0x69f8 */
        {8,	0}, 	/* 0x69f9 */
        {8,	0}, 	/* 0x69fa */
        {8,	0}, 	/* 0x69fb */
        {8,	0}, 	/* 0x69fc */
        {8,	0}, 	/* 0x69fd */
        {8,	0}, 	/* 0x69fe */
        {8,	0}, 	/* 0x69ff */
        {8,	0}, 	/* 0x6a00 */
        {8,	0}, 	/* 0x6a01 */
        {8,	0}, 	/* 0x6a02 */
        {8,	0}, 	/* 0x6a03 */
        {8,	0}, 	/* 0x6a04 */
        {8,	0}, 	/* 0x6a05 */
        {8,	0}, 	/* 0x6a06 */
        {8,	0}, 	/* 0x6a07 */
        {8,	0}, 	/* 0x6a08 */
        {8,	0}, 	/* 0x6a09 */
        {8,	0}, 	/* 0x6a0a */
        {8,	0}, 	/* 0x6a0b */
        {8,	0}, 	/* 0x6a0c */
        {8,	0}, 	/* 0x6a0d */
        {8,	0}, 	/* 0x6a0e */
        {8,	0}, 	/* 0x6a0f */
        {8,	0}, 	/* 0x6a10 */
        {8,	0}, 	/* 0x6a11 */
        {8,	0}, 	/* 0x6a12 */
        {8,	0}, 	/* 0x6a13 */
        {8,	0}, 	/* 0x6a14 */
        {8,	0}, 	/* 0x6a15 */
        {8,	0}, 	/* 0x6a16 */
        {8,	0}, 	/* 0x6a17 */
        {8,	0}, 	/* 0x6a18 */
        {8,	0}, 	/* 0x6a19 */
        {8,	0}, 	/* 0x6a1a */
        {8,	0}, 	/* 0x6a1b */
        {8,	0}, 	/* 0x6a1c */
        {8,	0}, 	/* 0x6a1d */
        {8,	0}, 	/* 0x6a1e */
        {8,	0}, 	/* 0x6a1f */
        {8,	0}, 	/* 0x6a20 */
        {8,	0}, 	/* 0x6a21 */
        {8,	0}, 	/* 0x6a22 */
        {8,	0}, 	/* 0x6a23 */
        {8,	0}, 	/* 0x6a24 */
        {8,	0}, 	/* 0x6a25 */
        {8,	0}, 	/* 0x6a26 */
        {8,	0}, 	/* 0x6a27 */
        {8,	0}, 	/* 0x6a28 */
        {8,	0}, 	/* 0x6a29 */
        {8,	0}, 	/* 0x6a2a */
        {8,	0}, 	/* 0x6a2b */
        {8,	0}, 	/* 0x6a2c */
        {8,	0}, 	/* 0x6a2d */
        {8,	0}, 	/* 0x6a2e */
        {8,	0}, 	/* 0x6a2f */
        {8,	0}, 	/* 0x6a30 */
        {8,	0}, 	/* 0x6a31 */
        {8,	0}, 	/* 0x6a32 */
        {8,	0}, 	/* 0x6a33 */
        {8,	0}, 	/* 0x6a34 */
        {8,	0}, 	/* 0x6a35 */
        {8,	0}, 	/* 0x6a36 */
        {8,	0}, 	/* 0x6a37 */
        {8,	0}, 	/* 0x6a38 */
        {8,	0}, 	/* 0x6a39 */
        {8,	0}, 	/* 0x6a3a */
        {8,	0}, 	/* 0x6a3b */
        {8,	0}, 	/* 0x6a3c */
        {8,	0}, 	/* 0x6a3d */
        {8,	0}, 	/* 0x6a3e */
        {8,	0}, 	/* 0x6a3f */
        {8,	0}, 	/* 0x6a40 */
        {8,	0}, 	/* 0x6a41 */
        {8,	0}, 	/* 0x6a42 */
        {8,	0}, 	/* 0x6a43 */
        {8,	0}, 	/* 0x6a44 */
        {8,	0}, 	/* 0x6a45 */
        {8,	0}, 	/* 0x6a46 */
        {8,	0}, 	/* 0x6a47 */
        {8,	0}, 	/* 0x6a48 */
        {8,	0}, 	/* 0x6a49 */
        {8,	0}, 	/* 0x6a4a */
        {8,	0}, 	/* 0x6a4b */
        {8,	0}, 	/* 0x6a4c */
        {8,	0}, 	/* 0x6a4d */
        {8,	0}, 	/* 0x6a4e */
        {8,	0}, 	/* 0x6a4f */
        {8,	0}, 	/* 0x6a50 */
        {8,	0}, 	/* 0x6a51 */
        {8,	0}, 	/* 0x6a52 */
        {8,	0}, 	/* 0x6a53 */
        {8,	0}, 	/* 0x6a54 */
        {8,	0}, 	/* 0x6a55 */
        {8,	0}, 	/* 0x6a56 */
        {8,	0}, 	/* 0x6a57 */
        {8,	0}, 	/* 0x6a58 */
        {8,	0}, 	/* 0x6a59 */
        {8,	0}, 	/* 0x6a5a */
        {8,	0}, 	/* 0x6a5b */
        {8,	0}, 	/* 0x6a5c */
        {8,	0}, 	/* 0x6a5d */
        {8,	0}, 	/* 0x6a5e */
        {8,	0}, 	/* 0x6a5f */
        {8,	0}, 	/* 0x6a60 */
        {8,	0}, 	/* 0x6a61 */
        {8,	0}, 	/* 0x6a62 */
        {8,	0}, 	/* 0x6a63 */
        {8,	0}, 	/* 0x6a64 */
        {8,	0}, 	/* 0x6a65 */
        {8,	0}, 	/* 0x6a66 */
        {8,	0}, 	/* 0x6a67 */
        {8,	0}, 	/* 0x6a68 */
        {8,	0}, 	/* 0x6a69 */
        {8,	0}, 	/* 0x6a6a */
        {8,	0}, 	/* 0x6a6b */
        {8,	0}, 	/* 0x6a6c */
        {8,	0}, 	/* 0x6a6d */
        {8,	0}, 	/* 0x6a6e */
        {8,	0}, 	/* 0x6a6f */
        {8,	0}, 	/* 0x6a70 */
        {8,	0}, 	/* 0x6a71 */
        {8,	0}, 	/* 0x6a72 */
        {8,	0}, 	/* 0x6a73 */
        {8,	0}, 	/* 0x6a74 */
        {8,	0}, 	/* 0x6a75 */
        {8,	0}, 	/* 0x6a76 */
        {8,	0}, 	/* 0x6a77 */
        {8,	0}, 	/* 0x6a78 */
        {8,	0}, 	/* 0x6a79 */
        {8,	0}, 	/* 0x6a7a */
        {8,	0}, 	/* 0x6a7b */
        {8,	0}, 	/* 0x6a7c */
        {8,	0}, 	/* 0x6a7d */
        {8,	0}, 	/* 0x6a7e */
        {8,	0}, 	/* 0x6a7f */
        {8,	0}, 	/* 0x6a80 */
        {8,	0}, 	/* 0x6a81 */
        {8,	0}, 	/* 0x6a82 */
        {8,	0}, 	/* 0x6a83 */
        {8,	0}, 	/* 0x6a84 */
        {8,	0}, 	/* 0x6a85 */
        {8,	0}, 	/* 0x6a86 */
        {8,	0}, 	/* 0x6a87 */
        {8,	0}, 	/* 0x6a88 */
        {8,	0}, 	/* 0x6a89 */
        {8,	0}, 	/* 0x6a8a */
        {8,	0}, 	/* 0x6a8b */
        {8,	0}, 	/* 0x6a8c */
        {8,	0}, 	/* 0x6a8d */
        {8,	0}, 	/* 0x6a8e */
        {8,	0}, 	/* 0x6a8f */
        {8,	0}, 	/* 0x6a90 */
        {8,	0}, 	/* 0x6a91 */
        {8,	0}, 	/* 0x6a92 */
        {8,	0}, 	/* 0x6a93 */
        {8,	0}, 	/* 0x6a94 */
        {8,	0}, 	/* 0x6a95 */
        {8,	0}, 	/* 0x6a96 */
        {8,	0}, 	/* 0x6a97 */
        {8,	0}, 	/* 0x6a98 */
        {8,	0}, 	/* 0x6a99 */
        {8,	0}, 	/* 0x6a9a */
        {8,	0}, 	/* 0x6a9b */
        {8,	0}, 	/* 0x6a9c */
        {8,	0}, 	/* 0x6a9d */
        {8,	0}, 	/* 0x6a9e */
        {8,	0}, 	/* 0x6a9f */
        {8,	0}, 	/* 0x6aa0 */
        {8,	0}, 	/* 0x6aa1 */
        {8,	0}, 	/* 0x6aa2 */
        {8,	0}, 	/* 0x6aa3 */
        {8,	0}, 	/* 0x6aa4 */
        {8,	0}, 	/* 0x6aa5 */
        {8,	0}, 	/* 0x6aa6 */
        {8,	0}, 	/* 0x6aa7 */
        {8,	0}, 	/* 0x6aa8 */
        {8,	0}, 	/* 0x6aa9 */
        {8,	0}, 	/* 0x6aaa */
        {8,	0}, 	/* 0x6aab */
        {8,	0}, 	/* 0x6aac */
        {8,	0}, 	/* 0x6aad */
        {8,	0}, 	/* 0x6aae */
        {8,	0}, 	/* 0x6aaf */
        {8,	0}, 	/* 0x6ab0 */
        {8,	0}, 	/* 0x6ab1 */
        {8,	0}, 	/* 0x6ab2 */
        {8,	0}, 	/* 0x6ab3 */
        {8,	0}, 	/* 0x6ab4 */
        {8,	0}, 	/* 0x6ab5 */
        {8,	0}, 	/* 0x6ab6 */
        {8,	0}, 	/* 0x6ab7 */
        {8,	0}, 	/* 0x6ab8 */
        {8,	0}, 	/* 0x6ab9 */
        {8,	0}, 	/* 0x6aba */
        {8,	0}, 	/* 0x6abb */
        {8,	0}, 	/* 0x6abc */
        {8,	0}, 	/* 0x6abd */
        {8,	0}, 	/* 0x6abe */
        {8,	0}, 	/* 0x6abf */
        {8,	0}, 	/* 0x6ac0 */
        {8,	0}, 	/* 0x6ac1 */
        {8,	0}, 	/* 0x6ac2 */
        {8,	0}, 	/* 0x6ac3 */
        {8,	0}, 	/* 0x6ac4 */
        {8,	0}, 	/* 0x6ac5 */
        {8,	0}, 	/* 0x6ac6 */
        {8,	0}, 	/* 0x6ac7 */
        {8,	0}, 	/* 0x6ac8 */
        {8,	0}, 	/* 0x6ac9 */
        {8,	0}, 	/* 0x6aca */
        {8,	0}, 	/* 0x6acb */
        {8,	0}, 	/* 0x6acc */
        {8,	0}, 	/* 0x6acd */
        {8,	0}, 	/* 0x6ace */
        {8,	0}, 	/* 0x6acf */
        {8,	0}, 	/* 0x6ad0 */
        {8,	0}, 	/* 0x6ad1 */
        {8,	0}, 	/* 0x6ad2 */
        {8,	0}, 	/* 0x6ad3 */
        {8,	0}, 	/* 0x6ad4 */
        {8,	0}, 	/* 0x6ad5 */
        {8,	0}, 	/* 0x6ad6 */
        {8,	0}, 	/* 0x6ad7 */
        {8,	0}, 	/* 0x6ad8 */
        {8,	0}, 	/* 0x6ad9 */
        {8,	0}, 	/* 0x6ada */
        {8,	0}, 	/* 0x6adb */
        {8,	0}, 	/* 0x6adc */
        {8,	0}, 	/* 0x6add */
        {8,	0}, 	/* 0x6ade */
        {8,	0}, 	/* 0x6adf */
        {8,	0}, 	/* 0x6ae0 */
        {8,	0}, 	/* 0x6ae1 */
        {8,	0}, 	/* 0x6ae2 */
        {8,	0}, 	/* 0x6ae3 */
        {8,	0}, 	/* 0x6ae4 */
        {8,	0}, 	/* 0x6ae5 */
        {8,	0}, 	/* 0x6ae6 */
        {8,	0}, 	/* 0x6ae7 */
        {8,	0}, 	/* 0x6ae8 */
        {8,	0}, 	/* 0x6ae9 */
        {8,	0}, 	/* 0x6aea */
        {8,	0}, 	/* 0x6aeb */
        {8,	0}, 	/* 0x6aec */
        {8,	0}, 	/* 0x6aed */
        {8,	0}, 	/* 0x6aee */
        {8,	0}, 	/* 0x6aef */
        {8,	0}, 	/* 0x6af0 */
        {8,	0}, 	/* 0x6af1 */
        {8,	0}, 	/* 0x6af2 */
        {8,	0}, 	/* 0x6af3 */
        {8,	0}, 	/* 0x6af4 */
        {8,	0}, 	/* 0x6af5 */
        {8,	0}, 	/* 0x6af6 */
        {8,	0}, 	/* 0x6af7 */
        {8,	0}, 	/* 0x6af8 */
        {8,	0}, 	/* 0x6af9 */
        {8,	0}, 	/* 0x6afa */
        {8,	0}, 	/* 0x6afb */
        {8,	0}, 	/* 0x6afc */
        {8,	0}, 	/* 0x6afd */
        {8,	0}, 	/* 0x6afe */
        {8,	0}, 	/* 0x6aff */
        {8,	0}, 	/* 0x6b00 */
        {8,	0}, 	/* 0x6b01 */
        {8,	0}, 	/* 0x6b02 */
        {8,	0}, 	/* 0x6b03 */
        {8,	0}, 	/* 0x6b04 */
        {8,	0}, 	/* 0x6b05 */
        {8,	0}, 	/* 0x6b06 */
        {8,	0}, 	/* 0x6b07 */
        {8,	0}, 	/* 0x6b08 */
        {8,	0}, 	/* 0x6b09 */
        {8,	0}, 	/* 0x6b0a */
        {8,	0}, 	/* 0x6b0b */
        {8,	0}, 	/* 0x6b0c */
        {8,	0}, 	/* 0x6b0d */
        {8,	0}, 	/* 0x6b0e */
        {8,	0}, 	/* 0x6b0f */
        {8,	0}, 	/* 0x6b10 */
        {8,	0}, 	/* 0x6b11 */
        {8,	0}, 	/* 0x6b12 */
        {8,	0}, 	/* 0x6b13 */
        {8,	0}, 	/* 0x6b14 */
        {8,	0}, 	/* 0x6b15 */
        {8,	0}, 	/* 0x6b16 */
        {8,	0}, 	/* 0x6b17 */
        {8,	0}, 	/* 0x6b18 */
        {8,	0}, 	/* 0x6b19 */
        {8,	0}, 	/* 0x6b1a */
        {8,	0}, 	/* 0x6b1b */
        {8,	0}, 	/* 0x6b1c */
        {8,	0}, 	/* 0x6b1d */
        {8,	0}, 	/* 0x6b1e */
        {8,	0}, 	/* 0x6b1f */
        {8,	0}, 	/* 0x6b20 */
        {8,	0}, 	/* 0x6b21 */
        {8,	0}, 	/* 0x6b22 */
        {8,	0}, 	/* 0x6b23 */
        {8,	0}, 	/* 0x6b24 */
        {8,	0}, 	/* 0x6b25 */
        {8,	0}, 	/* 0x6b26 */
        {8,	0}, 	/* 0x6b27 */
        {8,	0}, 	/* 0x6b28 */
        {8,	0}, 	/* 0x6b29 */
        {8,	0}, 	/* 0x6b2a */
        {8,	0}, 	/* 0x6b2b */
        {8,	0}, 	/* 0x6b2c */
        {8,	0}, 	/* 0x6b2d */
        {8,	0}, 	/* 0x6b2e */
        {8,	0}, 	/* 0x6b2f */
        {8,	0}, 	/* 0x6b30 */
        {8,	0}, 	/* 0x6b31 */
        {8,	0}, 	/* 0x6b32 */
        {8,	0}, 	/* 0x6b33 */
        {8,	0}, 	/* 0x6b34 */
        {8,	0}, 	/* 0x6b35 */
        {8,	0}, 	/* 0x6b36 */
        {8,	0}, 	/* 0x6b37 */
        {8,	0}, 	/* 0x6b38 */
        {8,	0}, 	/* 0x6b39 */
        {8,	0}, 	/* 0x6b3a */
        {8,	0}, 	/* 0x6b3b */
        {8,	0}, 	/* 0x6b3c */
        {8,	0}, 	/* 0x6b3d */
        {8,	0}, 	/* 0x6b3e */
        {8,	0}, 	/* 0x6b3f */
        {8,	0}, 	/* 0x6b40 */
        {8,	0}, 	/* 0x6b41 */
        {8,	0}, 	/* 0x6b42 */
        {8,	0}, 	/* 0x6b43 */
        {8,	0}, 	/* 0x6b44 */
        {8,	0}, 	/* 0x6b45 */
        {8,	0}, 	/* 0x6b46 */
        {8,	0}, 	/* 0x6b47 */
        {8,	0}, 	/* 0x6b48 */
        {8,	0}, 	/* 0x6b49 */
        {8,	0}, 	/* 0x6b4a */
        {8,	0}, 	/* 0x6b4b */
        {8,	0}, 	/* 0x6b4c */
        {8,	0}, 	/* 0x6b4d */
        {8,	0}, 	/* 0x6b4e */
        {8,	0}, 	/* 0x6b4f */
        {8,	0}, 	/* 0x6b50 */
        {8,	0}, 	/* 0x6b51 */
        {8,	0}, 	/* 0x6b52 */
        {8,	0}, 	/* 0x6b53 */
        {8,	0}, 	/* 0x6b54 */
        {8,	0}, 	/* 0x6b55 */
        {8,	0}, 	/* 0x6b56 */
        {8,	0}, 	/* 0x6b57 */
        {8,	0}, 	/* 0x6b58 */
        {8,	0}, 	/* 0x6b59 */
        {8,	0}, 	/* 0x6b5a */
        {8,	0}, 	/* 0x6b5b */
        {8,	0}, 	/* 0x6b5c */
        {8,	0}, 	/* 0x6b5d */
        {8,	0}, 	/* 0x6b5e */
        {8,	0}, 	/* 0x6b5f */
        {8,	0}, 	/* 0x6b60 */
        {8,	0}, 	/* 0x6b61 */
        {8,	0}, 	/* 0x6b62 */
        {8,	0}, 	/* 0x6b63 */
        {8,	0}, 	/* 0x6b64 */
        {8,	0}, 	/* 0x6b65 */
        {8,	0}, 	/* 0x6b66 */
        {8,	0}, 	/* 0x6b67 */
        {8,	0}, 	/* 0x6b68 */
        {8,	0}, 	/* 0x6b69 */
        {8,	0}, 	/* 0x6b6a */
        {8,	0}, 	/* 0x6b6b */
        {8,	0}, 	/* 0x6b6c */
        {8,	0}, 	/* 0x6b6d */
        {8,	0}, 	/* 0x6b6e */
        {8,	0}, 	/* 0x6b6f */
        {8,	0}, 	/* 0x6b70 */
        {8,	0}, 	/* 0x6b71 */
        {8,	0}, 	/* 0x6b72 */
        {8,	0}, 	/* 0x6b73 */
        {8,	0}, 	/* 0x6b74 */
        {8,	0}, 	/* 0x6b75 */
        {8,	0}, 	/* 0x6b76 */
        {8,	0}, 	/* 0x6b77 */
        {8,	0}, 	/* 0x6b78 */
        {8,	0}, 	/* 0x6b79 */
        {8,	0}, 	/* 0x6b7a */
        {8,	0}, 	/* 0x6b7b */
        {8,	0}, 	/* 0x6b7c */
        {8,	0}, 	/* 0x6b7d */
        {8,	0}, 	/* 0x6b7e */
        {8,	0}, 	/* 0x6b7f */
        {8,	0}, 	/* 0x6b80 */
        {8,	0}, 	/* 0x6b81 */
        {8,	0}, 	/* 0x6b82 */
        {8,	0}, 	/* 0x6b83 */
        {8,	0}, 	/* 0x6b84 */
        {8,	0}, 	/* 0x6b85 */
        {8,	0}, 	/* 0x6b86 */
        {8,	0}, 	/* 0x6b87 */
        {8,	0}, 	/* 0x6b88 */
        {8,	0}, 	/* 0x6b89 */
        {8,	0}, 	/* 0x6b8a */
        {8,	0}, 	/* 0x6b8b */
        {8,	0}, 	/* 0x6b8c */
        {8,	0}, 	/* 0x6b8d */
        {8,	0}, 	/* 0x6b8e */
        {8,	0}, 	/* 0x6b8f */
        {8,	0}, 	/* 0x6b90 */
        {8,	0}, 	/* 0x6b91 */
        {8,	0}, 	/* 0x6b92 */
        {8,	0}, 	/* 0x6b93 */
        {8,	0}, 	/* 0x6b94 */
        {8,	0}, 	/* 0x6b95 */
        {8,	0}, 	/* 0x6b96 */
        {8,	0}, 	/* 0x6b97 */
        {8,	0}, 	/* 0x6b98 */
        {8,	0}, 	/* 0x6b99 */
        {8,	0}, 	/* 0x6b9a */
        {8,	0}, 	/* 0x6b9b */
        {8,	0}, 	/* 0x6b9c */
        {8,	0}, 	/* 0x6b9d */
        {8,	0}, 	/* 0x6b9e */
        {8,	0}, 	/* 0x6b9f */
        {8,	0}, 	/* 0x6ba0 */
        {8,	0}, 	/* 0x6ba1 */
        {8,	0}, 	/* 0x6ba2 */
        {8,	0}, 	/* 0x6ba3 */
        {8,	0}, 	/* 0x6ba4 */
        {8,	0}, 	/* 0x6ba5 */
        {8,	0}, 	/* 0x6ba6 */
        {8,	0}, 	/* 0x6ba7 */
        {8,	0}, 	/* 0x6ba8 */
        {8,	0}, 	/* 0x6ba9 */
        {8,	0}, 	/* 0x6baa */
        {8,	0}, 	/* 0x6bab */
        {8,	0}, 	/* 0x6bac */
        {8,	0}, 	/* 0x6bad */
        {8,	0}, 	/* 0x6bae */
        {8,	0}, 	/* 0x6baf */
        {8,	0}, 	/* 0x6bb0 */
        {8,	0}, 	/* 0x6bb1 */
        {8,	0}, 	/* 0x6bb2 */
        {8,	0}, 	/* 0x6bb3 */
        {8,	0}, 	/* 0x6bb4 */
        {8,	0}, 	/* 0x6bb5 */
        {8,	0}, 	/* 0x6bb6 */
        {8,	0}, 	/* 0x6bb7 */
        {8,	0}, 	/* 0x6bb8 */
        {8,	0}, 	/* 0x6bb9 */
        {8,	0}, 	/* 0x6bba */
        {8,	0}, 	/* 0x6bbb */
        {8,	0}, 	/* 0x6bbc */
        {8,	0}, 	/* 0x6bbd */
        {8,	0}, 	/* 0x6bbe */
        {8,	0}, 	/* 0x6bbf */
        {8,	0}, 	/* 0x6bc0 */
        {8,	0}, 	/* 0x6bc1 */
        {8,	0}, 	/* 0x6bc2 */
        {8,	0}, 	/* 0x6bc3 */
        {8,	0}, 	/* 0x6bc4 */
        {8,	0}, 	/* 0x6bc5 */
        {8,	0}, 	/* 0x6bc6 */
        {8,	0}, 	/* 0x6bc7 */
        {8,	0}, 	/* 0x6bc8 */
        {8,	0}, 	/* 0x6bc9 */
        {8,	0}, 	/* 0x6bca */
        {8,	0}, 	/* 0x6bcb */
        {8,	0}, 	/* 0x6bcc */
        {8,	0}, 	/* 0x6bcd */
        {8,	0}, 	/* 0x6bce */
        {8,	0}, 	/* 0x6bcf */
        {8,	0}, 	/* 0x6bd0 */
        {8,	0}, 	/* 0x6bd1 */
        {8,	0}, 	/* 0x6bd2 */
        {8,	0}, 	/* 0x6bd3 */
        {8,	0}, 	/* 0x6bd4 */
        {8,	0}, 	/* 0x6bd5 */
        {8,	0}, 	/* 0x6bd6 */
        {8,	0}, 	/* 0x6bd7 */
        {8,	0}, 	/* 0x6bd8 */
        {8,	0}, 	/* 0x6bd9 */
        {8,	0}, 	/* 0x6bda */
        {8,	0}, 	/* 0x6bdb */
        {8,	0}, 	/* 0x6bdc */
        {8,	0}, 	/* 0x6bdd */
        {8,	0}, 	/* 0x6bde */
        {8,	0}, 	/* 0x6bdf */
        {8,	0}, 	/* 0x6be0 */
        {8,	0}, 	/* 0x6be1 */
        {8,	0}, 	/* 0x6be2 */
        {8,	0}, 	/* 0x6be3 */
        {8,	0}, 	/* 0x6be4 */
        {8,	0}, 	/* 0x6be5 */
        {8,	0}, 	/* 0x6be6 */
        {8,	0}, 	/* 0x6be7 */
        {8,	0}, 	/* 0x6be8 */
        {8,	0}, 	/* 0x6be9 */
        {8,	0}, 	/* 0x6bea */
        {8,	0}, 	/* 0x6beb */
        {8,	0}, 	/* 0x6bec */
        {8,	0}, 	/* 0x6bed */
        {8,	0}, 	/* 0x6bee */
        {8,	0}, 	/* 0x6bef */
        {8,	0}, 	/* 0x6bf0 */
        {8,	0}, 	/* 0x6bf1 */
        {8,	0}, 	/* 0x6bf2 */
        {8,	0}, 	/* 0x6bf3 */
        {8,	0}, 	/* 0x6bf4 */
        {8,	0}, 	/* 0x6bf5 */
        {8,	0}, 	/* 0x6bf6 */
        {8,	0}, 	/* 0x6bf7 */
        {8,	0}, 	/* 0x6bf8 */
        {8,	0}, 	/* 0x6bf9 */
        {8,	0}, 	/* 0x6bfa */
        {8,	0}, 	/* 0x6bfb */
        {8,	0}, 	/* 0x6bfc */
        {8,	0}, 	/* 0x6bfd */
        {8,	0}, 	/* 0x6bfe */
        {8,	0}, 	/* 0x6bff */
        {8,	0}, 	/* 0x6c00 */
        {8,	0}, 	/* 0x6c01 */
        {8,	0}, 	/* 0x6c02 */
        {8,	0}, 	/* 0x6c03 */
        {8,	0}, 	/* 0x6c04 */
        {8,	0}, 	/* 0x6c05 */
        {8,	0}, 	/* 0x6c06 */
        {8,	0}, 	/* 0x6c07 */
        {8,	0}, 	/* 0x6c08 */
        {8,	0}, 	/* 0x6c09 */
        {8,	0}, 	/* 0x6c0a */
        {8,	0}, 	/* 0x6c0b */
        {8,	0}, 	/* 0x6c0c */
        {8,	0}, 	/* 0x6c0d */
        {8,	0}, 	/* 0x6c0e */
        {8,	0}, 	/* 0x6c0f */
        {8,	0}, 	/* 0x6c10 */
        {8,	0}, 	/* 0x6c11 */
        {8,	0}, 	/* 0x6c12 */
        {8,	0}, 	/* 0x6c13 */
        {8,	0}, 	/* 0x6c14 */
        {8,	0}, 	/* 0x6c15 */
        {8,	0}, 	/* 0x6c16 */
        {8,	0}, 	/* 0x6c17 */
        {8,	0}, 	/* 0x6c18 */
        {8,	0}, 	/* 0x6c19 */
        {8,	0}, 	/* 0x6c1a */
        {8,	0}, 	/* 0x6c1b */
        {8,	0}, 	/* 0x6c1c */
        {8,	0}, 	/* 0x6c1d */
        {8,	0}, 	/* 0x6c1e */
        {8,	0}, 	/* 0x6c1f */
        {8,	0}, 	/* 0x6c20 */
        {8,	0}, 	/* 0x6c21 */
        {8,	0}, 	/* 0x6c22 */
        {8,	0}, 	/* 0x6c23 */
        {8,	0}, 	/* 0x6c24 */
        {8,	0}, 	/* 0x6c25 */
        {8,	0}, 	/* 0x6c26 */
        {8,	0}, 	/* 0x6c27 */
        {8,	0}, 	/* 0x6c28 */
        {8,	0}, 	/* 0x6c29 */
        {8,	0}, 	/* 0x6c2a */
        {8,	0}, 	/* 0x6c2b */
        {8,	0}, 	/* 0x6c2c */
        {8,	0}, 	/* 0x6c2d */
        {8,	0}, 	/* 0x6c2e */
        {8,	0}, 	/* 0x6c2f */
        {8,	0}, 	/* 0x6c30 */
        {8,	0}, 	/* 0x6c31 */
        {8,	0}, 	/* 0x6c32 */
        {8,	0}, 	/* 0x6c33 */
        {8,	0}, 	/* 0x6c34 */
        {8,	0}, 	/* 0x6c35 */
        {8,	0}, 	/* 0x6c36 */
        {8,	0}, 	/* 0x6c37 */
        {8,	0}, 	/* 0x6c38 */
        {8,	0}, 	/* 0x6c39 */
        {8,	0}, 	/* 0x6c3a */
        {8,	0}, 	/* 0x6c3b */
        {8,	0}, 	/* 0x6c3c */
        {8,	0}, 	/* 0x6c3d */
        {8,	0}, 	/* 0x6c3e */
        {8,	0}, 	/* 0x6c3f */
        {8,	0}, 	/* 0x6c40 */
        {8,	0}, 	/* 0x6c41 */
        {8,	0}, 	/* 0x6c42 */
        {8,	0}, 	/* 0x6c43 */
        {8,	0}, 	/* 0x6c44 */
        {8,	0}, 	/* 0x6c45 */
        {8,	0}, 	/* 0x6c46 */
        {8,	0}, 	/* 0x6c47 */
        {8,	0}, 	/* 0x6c48 */
        {8,	0}, 	/* 0x6c49 */
        {8,	0}, 	/* 0x6c4a */
        {8,	0}, 	/* 0x6c4b */
        {8,	0}, 	/* 0x6c4c */
        {8,	0}, 	/* 0x6c4d */
        {8,	0}, 	/* 0x6c4e */
        {8,	0}, 	/* 0x6c4f */
        {8,	0}, 	/* 0x6c50 */
        {8,	0}, 	/* 0x6c51 */
        {8,	0}, 	/* 0x6c52 */
        {8,	0}, 	/* 0x6c53 */
        {8,	0}, 	/* 0x6c54 */
        {8,	0}, 	/* 0x6c55 */
        {8,	0}, 	/* 0x6c56 */
        {8,	0}, 	/* 0x6c57 */
        {8,	0}, 	/* 0x6c58 */
        {8,	0}, 	/* 0x6c59 */
        {8,	0}, 	/* 0x6c5a */
        {8,	0}, 	/* 0x6c5b */
        {8,	0}, 	/* 0x6c5c */
        {8,	0}, 	/* 0x6c5d */
        {8,	0}, 	/* 0x6c5e */
        {8,	0}, 	/* 0x6c5f */
        {8,	0}, 	/* 0x6c60 */
        {8,	0}, 	/* 0x6c61 */
        {8,	0}, 	/* 0x6c62 */
        {8,	0}, 	/* 0x6c63 */
        {8,	0}, 	/* 0x6c64 */
        {8,	0}, 	/* 0x6c65 */
        {8,	0}, 	/* 0x6c66 */
        {8,	0}, 	/* 0x6c67 */
        {8,	0}, 	/* 0x6c68 */
        {8,	0}, 	/* 0x6c69 */
        {8,	0}, 	/* 0x6c6a */
        {8,	0}, 	/* 0x6c6b */
        {8,	0}, 	/* 0x6c6c */
        {8,	0}, 	/* 0x6c6d */
        {8,	0}, 	/* 0x6c6e */
        {8,	0}, 	/* 0x6c6f */
        {8,	0}, 	/* 0x6c70 */
        {8,	0}, 	/* 0x6c71 */
        {8,	0}, 	/* 0x6c72 */
        {8,	0}, 	/* 0x6c73 */
        {8,	0}, 	/* 0x6c74 */
        {8,	0}, 	/* 0x6c75 */
        {8,	0}, 	/* 0x6c76 */
        {8,	0}, 	/* 0x6c77 */
        {8,	0}, 	/* 0x6c78 */
        {8,	0}, 	/* 0x6c79 */
        {8,	0}, 	/* 0x6c7a */
        {8,	0}, 	/* 0x6c7b */
        {8,	0}, 	/* 0x6c7c */
        {8,	0}, 	/* 0x6c7d */
        {8,	0}, 	/* 0x6c7e */
        {8,	0}, 	/* 0x6c7f */
        {8,	0}, 	/* 0x6c80 */
        {8,	0}, 	/* 0x6c81 */
        {8,	0}, 	/* 0x6c82 */
        {8,	0}, 	/* 0x6c83 */
        {8,	0}, 	/* 0x6c84 */
        {8,	0}, 	/* 0x6c85 */
        {8,	0}, 	/* 0x6c86 */
        {8,	0}, 	/* 0x6c87 */
        {8,	0}, 	/* 0x6c88 */
        {8,	0}, 	/* 0x6c89 */
        {8,	0}, 	/* 0x6c8a */
        {8,	0}, 	/* 0x6c8b */
        {8,	0}, 	/* 0x6c8c */
        {8,	0}, 	/* 0x6c8d */
        {8,	0}, 	/* 0x6c8e */
        {8,	0}, 	/* 0x6c8f */
        {8,	0}, 	/* 0x6c90 */
        {8,	0}, 	/* 0x6c91 */
        {8,	0}, 	/* 0x6c92 */
        {8,	0}, 	/* 0x6c93 */
        {8,	0}, 	/* 0x6c94 */
        {8,	0}, 	/* 0x6c95 */
        {8,	0}, 	/* 0x6c96 */
        {8,	0}, 	/* 0x6c97 */
        {8,	0}, 	/* 0x6c98 */
        {8,	0}, 	/* 0x6c99 */
        {8,	0}, 	/* 0x6c9a */
        {8,	0}, 	/* 0x6c9b */
        {8,	0}, 	/* 0x6c9c */
        {8,	0}, 	/* 0x6c9d */
        {8,	0}, 	/* 0x6c9e */
        {8,	0}, 	/* 0x6c9f */
        {8,	0}, 	/* 0x6ca0 */
        {8,	0}, 	/* 0x6ca1 */
        {8,	0}, 	/* 0x6ca2 */
        {8,	0}, 	/* 0x6ca3 */
        {8,	0}, 	/* 0x6ca4 */
        {8,	0}, 	/* 0x6ca5 */
        {8,	0}, 	/* 0x6ca6 */
        {8,	0}, 	/* 0x6ca7 */
        {8,	0}, 	/* 0x6ca8 */
        {8,	0}, 	/* 0x6ca9 */
        {8,	0}, 	/* 0x6caa */
        {8,	0}, 	/* 0x6cab */
        {8,	0}, 	/* 0x6cac */
        {8,	0}, 	/* 0x6cad */
        {8,	0}, 	/* 0x6cae */
        {8,	0}, 	/* 0x6caf */
        {8,	0}, 	/* 0x6cb0 */
        {8,	0}, 	/* 0x6cb1 */
        {8,	0}, 	/* 0x6cb2 */
        {8,	0}, 	/* 0x6cb3 */
        {8,	0}, 	/* 0x6cb4 */
        {8,	0}, 	/* 0x6cb5 */
        {8,	0}, 	/* 0x6cb6 */
        {8,	0}, 	/* 0x6cb7 */
        {8,	0}, 	/* 0x6cb8 */
        {8,	0}, 	/* 0x6cb9 */
        {8,	0}, 	/* 0x6cba */
        {8,	0}, 	/* 0x6cbb */
        {8,	0}, 	/* 0x6cbc */
        {8,	0}, 	/* 0x6cbd */
        {8,	0}, 	/* 0x6cbe */
        {8,	0}, 	/* 0x6cbf */
        {8,	0}, 	/* 0x6cc0 */
        {8,	0}, 	/* 0x6cc1 */
        {8,	0}, 	/* 0x6cc2 */
        {8,	0}, 	/* 0x6cc3 */
        {8,	0}, 	/* 0x6cc4 */
        {8,	0}, 	/* 0x6cc5 */
        {8,	0}, 	/* 0x6cc6 */
        {8,	0}, 	/* 0x6cc7 */
        {8,	0}, 	/* 0x6cc8 */
        {8,	0}, 	/* 0x6cc9 */
        {8,	0}, 	/* 0x6cca */
        {8,	0}, 	/* 0x6ccb */
        {8,	0}, 	/* 0x6ccc */
        {8,	0}, 	/* 0x6ccd */
        {8,	0}, 	/* 0x6cce */
        {8,	0}, 	/* 0x6ccf */
        {8,	0}, 	/* 0x6cd0 */
        {8,	0}, 	/* 0x6cd1 */
        {8,	0}, 	/* 0x6cd2 */
        {8,	0}, 	/* 0x6cd3 */
        {8,	0}, 	/* 0x6cd4 */
        {8,	0}, 	/* 0x6cd5 */
        {8,	0}, 	/* 0x6cd6 */
        {8,	0}, 	/* 0x6cd7 */
        {8,	0}, 	/* 0x6cd8 */
        {8,	0}, 	/* 0x6cd9 */
        {8,	0}, 	/* 0x6cda */
        {8,	0}, 	/* 0x6cdb */
        {8,	0}, 	/* 0x6cdc */
        {8,	0}, 	/* 0x6cdd */
        {8,	0}, 	/* 0x6cde */
        {8,	0}, 	/* 0x6cdf */
        {8,	0}, 	/* 0x6ce0 */
        {8,	0}, 	/* 0x6ce1 */
        {8,	0}, 	/* 0x6ce2 */
        {8,	0}, 	/* 0x6ce3 */
        {8,	0}, 	/* 0x6ce4 */
        {8,	0}, 	/* 0x6ce5 */
        {8,	0}, 	/* 0x6ce6 */
        {8,	0}, 	/* 0x6ce7 */
        {8,	0}, 	/* 0x6ce8 */
        {8,	0}, 	/* 0x6ce9 */
        {8,	0}, 	/* 0x6cea */
        {8,	0}, 	/* 0x6ceb */
        {8,	0}, 	/* 0x6cec */
        {8,	0}, 	/* 0x6ced */
        {8,	0}, 	/* 0x6cee */
        {8,	0}, 	/* 0x6cef */
        {8,	0}, 	/* 0x6cf0 */
        {8,	0}, 	/* 0x6cf1 */
        {8,	0}, 	/* 0x6cf2 */
        {8,	0}, 	/* 0x6cf3 */
        {8,	0}, 	/* 0x6cf4 */
        {8,	0}, 	/* 0x6cf5 */
        {8,	0}, 	/* 0x6cf6 */
        {8,	0}, 	/* 0x6cf7 */
        {8,	0}, 	/* 0x6cf8 */
        {8,	0}, 	/* 0x6cf9 */
        {8,	0}, 	/* 0x6cfa */
        {8,	0}, 	/* 0x6cfb */
        {8,	0}, 	/* 0x6cfc */
        {8,	0}, 	/* 0x6cfd */
        {8,	0}, 	/* 0x6cfe */
        {8,	0}, 	/* 0x6cff */
        {8,	0}, 	/* 0x6d00 */
        {8,	0}, 	/* 0x6d01 */
        {8,	0}, 	/* 0x6d02 */
        {8,	0}, 	/* 0x6d03 */
        {8,	0}, 	/* 0x6d04 */
        {8,	0}, 	/* 0x6d05 */
        {8,	0}, 	/* 0x6d06 */
        {8,	0}, 	/* 0x6d07 */
        {8,	0}, 	/* 0x6d08 */
        {8,	0}, 	/* 0x6d09 */
        {8,	0}, 	/* 0x6d0a */
        {8,	0}, 	/* 0x6d0b */
        {8,	0}, 	/* 0x6d0c */
        {8,	0}, 	/* 0x6d0d */
        {8,	0}, 	/* 0x6d0e */
        {8,	0}, 	/* 0x6d0f */
        {8,	0}, 	/* 0x6d10 */
        {8,	0}, 	/* 0x6d11 */
        {8,	0}, 	/* 0x6d12 */
        {8,	0}, 	/* 0x6d13 */
        {8,	0}, 	/* 0x6d14 */
        {8,	0}, 	/* 0x6d15 */
        {8,	0}, 	/* 0x6d16 */
        {8,	0}, 	/* 0x6d17 */
        {8,	0}, 	/* 0x6d18 */
        {8,	0}, 	/* 0x6d19 */
        {8,	0}, 	/* 0x6d1a */
        {8,	0}, 	/* 0x6d1b */
        {8,	0}, 	/* 0x6d1c */
        {8,	0}, 	/* 0x6d1d */
        {8,	0}, 	/* 0x6d1e */
        {8,	0}, 	/* 0x6d1f */
        {8,	0}, 	/* 0x6d20 */
        {8,	0}, 	/* 0x6d21 */
        {8,	0}, 	/* 0x6d22 */
        {8,	0}, 	/* 0x6d23 */
        {8,	0}, 	/* 0x6d24 */
        {8,	0}, 	/* 0x6d25 */
        {8,	0}, 	/* 0x6d26 */
        {8,	0}, 	/* 0x6d27 */
        {8,	0}, 	/* 0x6d28 */
        {8,	0}, 	/* 0x6d29 */
        {8,	0}, 	/* 0x6d2a */
        {8,	0}, 	/* 0x6d2b */
        {8,	0}, 	/* 0x6d2c */
        {8,	0}, 	/* 0x6d2d */
        {8,	0}, 	/* 0x6d2e */
        {8,	0}, 	/* 0x6d2f */
        {8,	0}, 	/* 0x6d30 */
        {8,	0}, 	/* 0x6d31 */
        {8,	0}, 	/* 0x6d32 */
        {8,	0}, 	/* 0x6d33 */
        {8,	0}, 	/* 0x6d34 */
        {8,	0}, 	/* 0x6d35 */
        {8,	0}, 	/* 0x6d36 */
        {8,	0}, 	/* 0x6d37 */
        {8,	0}, 	/* 0x6d38 */
        {8,	0}, 	/* 0x6d39 */
        {8,	0}, 	/* 0x6d3a */
        {8,	0}, 	/* 0x6d3b */
        {8,	0}, 	/* 0x6d3c */
        {8,	0}, 	/* 0x6d3d */
        {8,	0}, 	/* 0x6d3e */
        {8,	0}, 	/* 0x6d3f */
        {8,	0}, 	/* 0x6d40 */
        {8,	0}, 	/* 0x6d41 */
        {8,	0}, 	/* 0x6d42 */
        {8,	0}, 	/* 0x6d43 */
        {8,	0}, 	/* 0x6d44 */
        {8,	0}, 	/* 0x6d45 */
        {8,	0}, 	/* 0x6d46 */
        {8,	0}, 	/* 0x6d47 */
        {8,	0}, 	/* 0x6d48 */
        {8,	0}, 	/* 0x6d49 */
        {8,	0}, 	/* 0x6d4a */
        {8,	0}, 	/* 0x6d4b */
        {8,	0}, 	/* 0x6d4c */
        {8,	0}, 	/* 0x6d4d */
        {8,	0}, 	/* 0x6d4e */
        {8,	0}, 	/* 0x6d4f */
        {8,	0}, 	/* 0x6d50 */
        {8,	0}, 	/* 0x6d51 */
        {8,	0}, 	/* 0x6d52 */
        {8,	0}, 	/* 0x6d53 */
        {8,	0}, 	/* 0x6d54 */
        {8,	0}, 	/* 0x6d55 */
        {8,	0}, 	/* 0x6d56 */
        {8,	0}, 	/* 0x6d57 */
        {8,	0}, 	/* 0x6d58 */
        {8,	0}, 	/* 0x6d59 */
        {8,	0}, 	/* 0x6d5a */
        {8,	0}, 	/* 0x6d5b */
        {8,	0}, 	/* 0x6d5c */
        {8,	0}, 	/* 0x6d5d */
        {8,	0}, 	/* 0x6d5e */
        {8,	0}, 	/* 0x6d5f */
        {8,	0}, 	/* 0x6d60 */
        {8,	0}, 	/* 0x6d61 */
        {8,	0}, 	/* 0x6d62 */
        {8,	0}, 	/* 0x6d63 */
        {8,	0}, 	/* 0x6d64 */
        {8,	0}, 	/* 0x6d65 */
        {8,	0}, 	/* 0x6d66 */
        {8,	0}, 	/* 0x6d67 */
        {8,	0}, 	/* 0x6d68 */
        {8,	0}, 	/* 0x6d69 */
        {8,	0}, 	/* 0x6d6a */
        {8,	0}, 	/* 0x6d6b */
        {8,	0}, 	/* 0x6d6c */
        {8,	0}, 	/* 0x6d6d */
        {8,	0}, 	/* 0x6d6e */
        {8,	0}, 	/* 0x6d6f */
        {8,	0}, 	/* 0x6d70 */
        {8,	0}, 	/* 0x6d71 */
        {8,	0}, 	/* 0x6d72 */
        {8,	0}, 	/* 0x6d73 */
        {8,	0}, 	/* 0x6d74 */
        {8,	0}, 	/* 0x6d75 */
        {8,	0}, 	/* 0x6d76 */
        {8,	0}, 	/* 0x6d77 */
        {8,	0}, 	/* 0x6d78 */
        {8,	0}, 	/* 0x6d79 */
        {8,	0}, 	/* 0x6d7a */
        {8,	0}, 	/* 0x6d7b */
        {8,	0}, 	/* 0x6d7c */
        {8,	0}, 	/* 0x6d7d */
        {8,	0}, 	/* 0x6d7e */
        {8,	0}, 	/* 0x6d7f */
        {8,	0}, 	/* 0x6d80 */
        {8,	0}, 	/* 0x6d81 */
        {8,	0}, 	/* 0x6d82 */
        {8,	0}, 	/* 0x6d83 */
        {8,	0}, 	/* 0x6d84 */
        {8,	0}, 	/* 0x6d85 */
        {8,	0}, 	/* 0x6d86 */
        {8,	0}, 	/* 0x6d87 */
        {8,	0}, 	/* 0x6d88 */
        {8,	0}, 	/* 0x6d89 */
        {8,	0}, 	/* 0x6d8a */
        {8,	0}, 	/* 0x6d8b */
        {8,	0}, 	/* 0x6d8c */
        {8,	0}, 	/* 0x6d8d */
        {8,	0}, 	/* 0x6d8e */
        {8,	0}, 	/* 0x6d8f */
        {8,	0}, 	/* 0x6d90 */
        {8,	0}, 	/* 0x6d91 */
        {8,	0}, 	/* 0x6d92 */
        {8,	0}, 	/* 0x6d93 */
        {8,	0}, 	/* 0x6d94 */
        {8,	0}, 	/* 0x6d95 */
        {8,	0}, 	/* 0x6d96 */
        {8,	0}, 	/* 0x6d97 */
        {8,	0}, 	/* 0x6d98 */
        {8,	0}, 	/* 0x6d99 */
        {8,	0}, 	/* 0x6d9a */
        {8,	0}, 	/* 0x6d9b */
        {8,	0}, 	/* 0x6d9c */
        {8,	0}, 	/* 0x6d9d */
        {8,	0}, 	/* 0x6d9e */
        {8,	0}, 	/* 0x6d9f */
        {8,	0}, 	/* 0x6da0 */
        {8,	0}, 	/* 0x6da1 */
        {8,	0}, 	/* 0x6da2 */
        {8,	0}, 	/* 0x6da3 */
        {8,	0}, 	/* 0x6da4 */
        {8,	0}, 	/* 0x6da5 */
        {8,	0}, 	/* 0x6da6 */
        {8,	0}, 	/* 0x6da7 */
        {8,	0}, 	/* 0x6da8 */
        {8,	0}, 	/* 0x6da9 */
        {8,	0}, 	/* 0x6daa */
        {8,	0}, 	/* 0x6dab */
        {8,	0}, 	/* 0x6dac */
        {8,	0}, 	/* 0x6dad */
        {8,	0}, 	/* 0x6dae */
        {8,	0}, 	/* 0x6daf */
        {8,	0}, 	/* 0x6db0 */
        {8,	0}, 	/* 0x6db1 */
        {8,	0}, 	/* 0x6db2 */
        {8,	0}, 	/* 0x6db3 */
        {8,	0}, 	/* 0x6db4 */
        {8,	0}, 	/* 0x6db5 */
        {8,	0}, 	/* 0x6db6 */
        {8,	0}, 	/* 0x6db7 */
        {8,	0}, 	/* 0x6db8 */
        {8,	0}, 	/* 0x6db9 */
        {8,	0}, 	/* 0x6dba */
        {8,	0}, 	/* 0x6dbb */
        {8,	0}, 	/* 0x6dbc */
        {8,	0}, 	/* 0x6dbd */
        {8,	0}, 	/* 0x6dbe */
        {8,	0}, 	/* 0x6dbf */
        {8,	0}, 	/* 0x6dc0 */
        {8,	0}, 	/* 0x6dc1 */
        {8,	0}, 	/* 0x6dc2 */
        {8,	0}, 	/* 0x6dc3 */
        {8,	0}, 	/* 0x6dc4 */
        {8,	0}, 	/* 0x6dc5 */
        {8,	0}, 	/* 0x6dc6 */
        {8,	0}, 	/* 0x6dc7 */
        {8,	0}, 	/* 0x6dc8 */
        {8,	0}, 	/* 0x6dc9 */
        {8,	0}, 	/* 0x6dca */
        {8,	0}, 	/* 0x6dcb */
        {8,	0}, 	/* 0x6dcc */
        {8,	0}, 	/* 0x6dcd */
        {8,	0}, 	/* 0x6dce */
        {8,	0}, 	/* 0x6dcf */
        {8,	0}, 	/* 0x6dd0 */
        {8,	0}, 	/* 0x6dd1 */
        {8,	0}, 	/* 0x6dd2 */
        {8,	0}, 	/* 0x6dd3 */
        {8,	0}, 	/* 0x6dd4 */
        {8,	0}, 	/* 0x6dd5 */
        {8,	0}, 	/* 0x6dd6 */
        {8,	0}, 	/* 0x6dd7 */
        {8,	0}, 	/* 0x6dd8 */
        {8,	0}, 	/* 0x6dd9 */
        {8,	0}, 	/* 0x6dda */
        {8,	0}, 	/* 0x6ddb */
        {8,	0}, 	/* 0x6ddc */
        {8,	0}, 	/* 0x6ddd */
        {8,	0}, 	/* 0x6dde */
        {8,	0}, 	/* 0x6ddf */
        {8,	0}, 	/* 0x6de0 */
        {8,	0}, 	/* 0x6de1 */
        {8,	0}, 	/* 0x6de2 */
        {8,	0}, 	/* 0x6de3 */
        {8,	0}, 	/* 0x6de4 */
        {8,	0}, 	/* 0x6de5 */
        {8,	0}, 	/* 0x6de6 */
        {8,	0}, 	/* 0x6de7 */
        {8,	0}, 	/* 0x6de8 */
        {8,	0}, 	/* 0x6de9 */
        {8,	0}, 	/* 0x6dea */
        {8,	0}, 	/* 0x6deb */
        {8,	0}, 	/* 0x6dec */
        {8,	0}, 	/* 0x6ded */
        {8,	0}, 	/* 0x6dee */
        {8,	0}, 	/* 0x6def */
        {8,	0}, 	/* 0x6df0 */
        {8,	0}, 	/* 0x6df1 */
        {8,	0}, 	/* 0x6df2 */
        {8,	0}, 	/* 0x6df3 */
        {8,	0}, 	/* 0x6df4 */
        {8,	0}, 	/* 0x6df5 */
        {8,	0}, 	/* 0x6df6 */
        {8,	0}, 	/* 0x6df7 */
        {8,	0}, 	/* 0x6df8 */
        {8,	0}, 	/* 0x6df9 */
        {8,	0}, 	/* 0x6dfa */
        {8,	0}, 	/* 0x6dfb */
        {8,	0}, 	/* 0x6dfc */
        {8,	0}, 	/* 0x6dfd */
        {8,	0}, 	/* 0x6dfe */
        {8,	0}, 	/* 0x6dff */
        {8,	0}, 	/* 0x6e00 */
        {8,	0}, 	/* 0x6e01 */
        {8,	0}, 	/* 0x6e02 */
        {8,	0}, 	/* 0x6e03 */
        {8,	0}, 	/* 0x6e04 */
        {8,	0}, 	/* 0x6e05 */
        {8,	0}, 	/* 0x6e06 */
        {8,	0}, 	/* 0x6e07 */
        {8,	0}, 	/* 0x6e08 */
        {8,	0}, 	/* 0x6e09 */
        {8,	0}, 	/* 0x6e0a */
        {8,	0}, 	/* 0x6e0b */
        {8,	0}, 	/* 0x6e0c */
        {8,	0}, 	/* 0x6e0d */
        {8,	0}, 	/* 0x6e0e */
        {8,	0}, 	/* 0x6e0f */
        {8,	0}, 	/* 0x6e10 */
        {8,	0}, 	/* 0x6e11 */
        {8,	0}, 	/* 0x6e12 */
        {8,	0}, 	/* 0x6e13 */
        {8,	0}, 	/* 0x6e14 */
        {8,	0}, 	/* 0x6e15 */
        {8,	0}, 	/* 0x6e16 */
        {8,	0}, 	/* 0x6e17 */
        {8,	0}, 	/* 0x6e18 */
        {8,	0}, 	/* 0x6e19 */
        {8,	0}, 	/* 0x6e1a */
        {8,	0}, 	/* 0x6e1b */
        {8,	0}, 	/* 0x6e1c */
        {8,	0}, 	/* 0x6e1d */
        {8,	0}, 	/* 0x6e1e */
        {8,	0}, 	/* 0x6e1f */
        {8,	0}, 	/* 0x6e20 */
        {8,	0}, 	/* 0x6e21 */
        {8,	0}, 	/* 0x6e22 */
        {8,	0}, 	/* 0x6e23 */
        {8,	0}, 	/* 0x6e24 */
        {8,	0}, 	/* 0x6e25 */
        {8,	0}, 	/* 0x6e26 */
        {8,	0}, 	/* 0x6e27 */
        {8,	0}, 	/* 0x6e28 */
        {8,	0}, 	/* 0x6e29 */
        {8,	0}, 	/* 0x6e2a */
        {8,	0}, 	/* 0x6e2b */
        {8,	0}, 	/* 0x6e2c */
        {8,	0}, 	/* 0x6e2d */
        {8,	0}, 	/* 0x6e2e */
        {8,	0}, 	/* 0x6e2f */
        {8,	0}, 	/* 0x6e30 */
        {8,	0}, 	/* 0x6e31 */
        {8,	0}, 	/* 0x6e32 */
        {8,	0}, 	/* 0x6e33 */
        {8,	0}, 	/* 0x6e34 */
        {8,	0}, 	/* 0x6e35 */
        {8,	0}, 	/* 0x6e36 */
        {8,	0}, 	/* 0x6e37 */
        {8,	0}, 	/* 0x6e38 */
        {8,	0}, 	/* 0x6e39 */
        {8,	0}, 	/* 0x6e3a */
        {8,	0}, 	/* 0x6e3b */
        {8,	0}, 	/* 0x6e3c */
        {8,	0}, 	/* 0x6e3d */
        {8,	0}, 	/* 0x6e3e */
        {8,	0}, 	/* 0x6e3f */
        {8,	0}, 	/* 0x6e40 */
        {8,	0}, 	/* 0x6e41 */
        {8,	0}, 	/* 0x6e42 */
        {8,	0}, 	/* 0x6e43 */
        {8,	0}, 	/* 0x6e44 */
        {8,	0}, 	/* 0x6e45 */
        {8,	0}, 	/* 0x6e46 */
        {8,	0}, 	/* 0x6e47 */
        {8,	0}, 	/* 0x6e48 */
        {8,	0}, 	/* 0x6e49 */
        {8,	0}, 	/* 0x6e4a */
        {8,	0}, 	/* 0x6e4b */
        {8,	0}, 	/* 0x6e4c */
        {8,	0}, 	/* 0x6e4d */
        {8,	0}, 	/* 0x6e4e */
        {8,	0}, 	/* 0x6e4f */
        {8,	0}, 	/* 0x6e50 */
        {8,	0}, 	/* 0x6e51 */
        {8,	0}, 	/* 0x6e52 */
        {8,	0}, 	/* 0x6e53 */
        {8,	0}, 	/* 0x6e54 */
        {8,	0}, 	/* 0x6e55 */
        {8,	0}, 	/* 0x6e56 */
        {8,	0}, 	/* 0x6e57 */
        {8,	0}, 	/* 0x6e58 */
        {8,	0}, 	/* 0x6e59 */
        {8,	0}, 	/* 0x6e5a */
        {8,	0}, 	/* 0x6e5b */
        {8,	0}, 	/* 0x6e5c */
        {8,	0}, 	/* 0x6e5d */
        {8,	0}, 	/* 0x6e5e */
        {8,	0}, 	/* 0x6e5f */
        {8,	0}, 	/* 0x6e60 */
        {8,	0}, 	/* 0x6e61 */
        {8,	0}, 	/* 0x6e62 */
        {8,	0}, 	/* 0x6e63 */
        {8,	0}, 	/* 0x6e64 */
        {8,	0}, 	/* 0x6e65 */
        {8,	0}, 	/* 0x6e66 */
        {8,	0}, 	/* 0x6e67 */
        {8,	0}, 	/* 0x6e68 */
        {8,	0}, 	/* 0x6e69 */
        {8,	0}, 	/* 0x6e6a */
        {8,	0}, 	/* 0x6e6b */
        {8,	0}, 	/* 0x6e6c */
        {8,	0}, 	/* 0x6e6d */
        {8,	0}, 	/* 0x6e6e */
        {8,	0}, 	/* 0x6e6f */
        {8,	0}, 	/* 0x6e70 */
        {8,	0}, 	/* 0x6e71 */
        {8,	0}, 	/* 0x6e72 */
        {8,	0}, 	/* 0x6e73 */
        {8,	0}, 	/* 0x6e74 */
        {8,	0}, 	/* 0x6e75 */
        {8,	0}, 	/* 0x6e76 */
        {8,	0}, 	/* 0x6e77 */
        {8,	0}, 	/* 0x6e78 */
        {8,	0}, 	/* 0x6e79 */
        {8,	0}, 	/* 0x6e7a */
        {8,	0}, 	/* 0x6e7b */
        {8,	0}, 	/* 0x6e7c */
        {8,	0}, 	/* 0x6e7d */
        {8,	0}, 	/* 0x6e7e */
        {8,	0}, 	/* 0x6e7f */
        {8,	0}, 	/* 0x6e80 */
        {8,	0}, 	/* 0x6e81 */
        {8,	0}, 	/* 0x6e82 */
        {8,	0}, 	/* 0x6e83 */
        {8,	0}, 	/* 0x6e84 */
        {8,	0}, 	/* 0x6e85 */
        {8,	0}, 	/* 0x6e86 */
        {8,	0}, 	/* 0x6e87 */
        {8,	0}, 	/* 0x6e88 */
        {8,	0}, 	/* 0x6e89 */
        {8,	0}, 	/* 0x6e8a */
        {8,	0}, 	/* 0x6e8b */
        {8,	0}, 	/* 0x6e8c */
        {8,	0}, 	/* 0x6e8d */
        {8,	0}, 	/* 0x6e8e */
        {8,	0}, 	/* 0x6e8f */
        {8,	0}, 	/* 0x6e90 */
        {8,	0}, 	/* 0x6e91 */
        {8,	0}, 	/* 0x6e92 */
        {8,	0}, 	/* 0x6e93 */
        {8,	0}, 	/* 0x6e94 */
        {8,	0}, 	/* 0x6e95 */
        {8,	0}, 	/* 0x6e96 */
        {8,	0}, 	/* 0x6e97 */
        {8,	0}, 	/* 0x6e98 */
        {8,	0}, 	/* 0x6e99 */
        {8,	0}, 	/* 0x6e9a */
        {8,	0}, 	/* 0x6e9b */
        {8,	0}, 	/* 0x6e9c */
        {8,	0}, 	/* 0x6e9d */
        {8,	0}, 	/* 0x6e9e */
        {8,	0}, 	/* 0x6e9f */
        {8,	0}, 	/* 0x6ea0 */
        {8,	0}, 	/* 0x6ea1 */
        {8,	0}, 	/* 0x6ea2 */
        {8,	0}, 	/* 0x6ea3 */
        {8,	0}, 	/* 0x6ea4 */
        {8,	0}, 	/* 0x6ea5 */
        {8,	0}, 	/* 0x6ea6 */
        {8,	0}, 	/* 0x6ea7 */
        {8,	0}, 	/* 0x6ea8 */
        {8,	0}, 	/* 0x6ea9 */
        {8,	0}, 	/* 0x6eaa */
        {8,	0}, 	/* 0x6eab */
        {8,	0}, 	/* 0x6eac */
        {8,	0}, 	/* 0x6ead */
        {8,	0}, 	/* 0x6eae */
        {8,	0}, 	/* 0x6eaf */
        {8,	0}, 	/* 0x6eb0 */
        {8,	0}, 	/* 0x6eb1 */
        {8,	0}, 	/* 0x6eb2 */
        {8,	0}, 	/* 0x6eb3 */
        {8,	0}, 	/* 0x6eb4 */
        {8,	0}, 	/* 0x6eb5 */
        {8,	0}, 	/* 0x6eb6 */
        {8,	0}, 	/* 0x6eb7 */
        {8,	0}, 	/* 0x6eb8 */
        {8,	0}, 	/* 0x6eb9 */
        {8,	0}, 	/* 0x6eba */
        {8,	0}, 	/* 0x6ebb */
        {8,	0}, 	/* 0x6ebc */
        {8,	0}, 	/* 0x6ebd */
        {8,	0}, 	/* 0x6ebe */
        {8,	0}, 	/* 0x6ebf */
        {8,	0}, 	/* 0x6ec0 */
        {8,	0}, 	/* 0x6ec1 */
        {8,	0}, 	/* 0x6ec2 */
        {8,	0}, 	/* 0x6ec3 */
        {8,	0}, 	/* 0x6ec4 */
        {8,	0}, 	/* 0x6ec5 */
        {8,	0}, 	/* 0x6ec6 */
        {8,	0}, 	/* 0x6ec7 */
        {8,	0}, 	/* 0x6ec8 */
        {8,	0}, 	/* 0x6ec9 */
        {8,	0}, 	/* 0x6eca */
        {8,	0}, 	/* 0x6ecb */
        {8,	0}, 	/* 0x6ecc */
        {8,	0}, 	/* 0x6ecd */
        {8,	0}, 	/* 0x6ece */
        {8,	0}, 	/* 0x6ecf */
        {8,	0}, 	/* 0x6ed0 */
        {8,	0}, 	/* 0x6ed1 */
        {8,	0}, 	/* 0x6ed2 */
        {8,	0}, 	/* 0x6ed3 */
        {8,	0}, 	/* 0x6ed4 */
        {8,	0}, 	/* 0x6ed5 */
        {8,	0}, 	/* 0x6ed6 */
        {8,	0}, 	/* 0x6ed7 */
        {8,	0}, 	/* 0x6ed8 */
        {8,	0}, 	/* 0x6ed9 */
        {8,	0}, 	/* 0x6eda */
        {8,	0}, 	/* 0x6edb */
        {8,	0}, 	/* 0x6edc */
        {8,	0}, 	/* 0x6edd */
        {8,	0}, 	/* 0x6ede */
        {8,	0}, 	/* 0x6edf */
        {8,	0}, 	/* 0x6ee0 */
        {8,	0}, 	/* 0x6ee1 */
        {8,	0}, 	/* 0x6ee2 */
        {8,	0}, 	/* 0x6ee3 */
        {8,	0}, 	/* 0x6ee4 */
        {8,	0}, 	/* 0x6ee5 */
        {8,	0}, 	/* 0x6ee6 */
        {8,	0}, 	/* 0x6ee7 */
        {8,	0}, 	/* 0x6ee8 */
        {8,	0}, 	/* 0x6ee9 */
        {8,	0}, 	/* 0x6eea */
        {8,	0}, 	/* 0x6eeb */
        {8,	0}, 	/* 0x6eec */
        {8,	0}, 	/* 0x6eed */
        {8,	0}, 	/* 0x6eee */
        {8,	0}, 	/* 0x6eef */
        {8,	0}, 	/* 0x6ef0 */
        {8,	0}, 	/* 0x6ef1 */
        {8,	0}, 	/* 0x6ef2 */
        {8,	0}, 	/* 0x6ef3 */
        {8,	0}, 	/* 0x6ef4 */
        {8,	0}, 	/* 0x6ef5 */
        {8,	0}, 	/* 0x6ef6 */
        {8,	0}, 	/* 0x6ef7 */
        {8,	0}, 	/* 0x6ef8 */
        {8,	0}, 	/* 0x6ef9 */
        {8,	0}, 	/* 0x6efa */
        {8,	0}, 	/* 0x6efb */
        {8,	0}, 	/* 0x6efc */
        {8,	0}, 	/* 0x6efd */
        {8,	0}, 	/* 0x6efe */
        {8,	0}, 	/* 0x6eff */
        {8,	0}, 	/* 0x6f00 */
        {8,	0}, 	/* 0x6f01 */
        {8,	0}, 	/* 0x6f02 */
        {8,	0}, 	/* 0x6f03 */
        {8,	0}, 	/* 0x6f04 */
        {8,	0}, 	/* 0x6f05 */
        {8,	0}, 	/* 0x6f06 */
        {8,	0}, 	/* 0x6f07 */
        {8,	0}, 	/* 0x6f08 */
        {8,	0}, 	/* 0x6f09 */
        {8,	0}, 	/* 0x6f0a */
        {8,	0}, 	/* 0x6f0b */
        {8,	0}, 	/* 0x6f0c */
        {8,	0}, 	/* 0x6f0d */
        {8,	0}, 	/* 0x6f0e */
        {8,	0}, 	/* 0x6f0f */
        {8,	0}, 	/* 0x6f10 */
        {8,	0}, 	/* 0x6f11 */
        {8,	0}, 	/* 0x6f12 */
        {8,	0}, 	/* 0x6f13 */
        {8,	0}, 	/* 0x6f14 */
        {8,	0}, 	/* 0x6f15 */
        {8,	0}, 	/* 0x6f16 */
        {8,	0}, 	/* 0x6f17 */
        {8,	0}, 	/* 0x6f18 */
        {8,	0}, 	/* 0x6f19 */
        {8,	0}, 	/* 0x6f1a */
        {8,	0}, 	/* 0x6f1b */
        {8,	0}, 	/* 0x6f1c */
        {8,	0}, 	/* 0x6f1d */
        {8,	0}, 	/* 0x6f1e */
        {8,	0}, 	/* 0x6f1f */
        {8,	0}, 	/* 0x6f20 */
        {8,	0}, 	/* 0x6f21 */
        {8,	0}, 	/* 0x6f22 */
        {8,	0}, 	/* 0x6f23 */
        {8,	0}, 	/* 0x6f24 */
        {8,	0}, 	/* 0x6f25 */
        {8,	0}, 	/* 0x6f26 */
        {8,	0}, 	/* 0x6f27 */
        {8,	0}, 	/* 0x6f28 */
        {8,	0}, 	/* 0x6f29 */
        {8,	0}, 	/* 0x6f2a */
        {8,	0}, 	/* 0x6f2b */
        {8,	0}, 	/* 0x6f2c */
        {8,	0}, 	/* 0x6f2d */
        {8,	0}, 	/* 0x6f2e */
        {8,	0}, 	/* 0x6f2f */
        {8,	0}, 	/* 0x6f30 */
        {8,	0}, 	/* 0x6f31 */
        {8,	0}, 	/* 0x6f32 */
        {8,	0}, 	/* 0x6f33 */
        {8,	0}, 	/* 0x6f34 */
        {8,	0}, 	/* 0x6f35 */
        {8,	0}, 	/* 0x6f36 */
        {8,	0}, 	/* 0x6f37 */
        {8,	0}, 	/* 0x6f38 */
        {8,	0}, 	/* 0x6f39 */
        {8,	0}, 	/* 0x6f3a */
        {8,	0}, 	/* 0x6f3b */
        {8,	0}, 	/* 0x6f3c */
        {8,	0}, 	/* 0x6f3d */
        {8,	0}, 	/* 0x6f3e */
        {8,	0}, 	/* 0x6f3f */
        {8,	0}, 	/* 0x6f40 */
        {8,	0}, 	/* 0x6f41 */
        {8,	0}, 	/* 0x6f42 */
        {8,	0}, 	/* 0x6f43 */
        {8,	0}, 	/* 0x6f44 */
        {8,	0}, 	/* 0x6f45 */
        {8,	0}, 	/* 0x6f46 */
        {8,	0}, 	/* 0x6f47 */
        {8,	0}, 	/* 0x6f48 */
        {8,	0}, 	/* 0x6f49 */
        {8,	0}, 	/* 0x6f4a */
        {8,	0}, 	/* 0x6f4b */
        {8,	0}, 	/* 0x6f4c */
        {8,	0}, 	/* 0x6f4d */
        {8,	0}, 	/* 0x6f4e */
        {8,	0}, 	/* 0x6f4f */
        {8,	0}, 	/* 0x6f50 */
        {8,	0}, 	/* 0x6f51 */
        {8,	0}, 	/* 0x6f52 */
        {8,	0}, 	/* 0x6f53 */
        {8,	0}, 	/* 0x6f54 */
        {8,	0}, 	/* 0x6f55 */
        {8,	0}, 	/* 0x6f56 */
        {8,	0}, 	/* 0x6f57 */
        {8,	0}, 	/* 0x6f58 */
        {8,	0}, 	/* 0x6f59 */
        {8,	0}, 	/* 0x6f5a */
        {8,	0}, 	/* 0x6f5b */
        {8,	0}, 	/* 0x6f5c */
        {8,	0}, 	/* 0x6f5d */
        {8,	0}, 	/* 0x6f5e */
        {8,	0}, 	/* 0x6f5f */
        {8,	0}, 	/* 0x6f60 */
        {8,	0}, 	/* 0x6f61 */
        {8,	0}, 	/* 0x6f62 */
        {8,	0}, 	/* 0x6f63 */
        {8,	0}, 	/* 0x6f64 */
        {8,	0}, 	/* 0x6f65 */
        {8,	0}, 	/* 0x6f66 */
        {8,	0}, 	/* 0x6f67 */
        {8,	0}, 	/* 0x6f68 */
        {8,	0}, 	/* 0x6f69 */
        {8,	0}, 	/* 0x6f6a */
        {8,	0}, 	/* 0x6f6b */
        {8,	0}, 	/* 0x6f6c */
        {8,	0}, 	/* 0x6f6d */
        {8,	0}, 	/* 0x6f6e */
        {8,	0}, 	/* 0x6f6f */
        {8,	0}, 	/* 0x6f70 */
        {8,	0}, 	/* 0x6f71 */
        {8,	0}, 	/* 0x6f72 */
        {8,	0}, 	/* 0x6f73 */
        {8,	0}, 	/* 0x6f74 */
        {8,	0}, 	/* 0x6f75 */
        {8,	0}, 	/* 0x6f76 */
        {8,	0}, 	/* 0x6f77 */
        {8,	0}, 	/* 0x6f78 */
        {8,	0}, 	/* 0x6f79 */
        {8,	0}, 	/* 0x6f7a */
        {8,	0}, 	/* 0x6f7b */
        {8,	0}, 	/* 0x6f7c */
        {8,	0}, 	/* 0x6f7d */
        {8,	0}, 	/* 0x6f7e */
        {8,	0}, 	/* 0x6f7f */
        {8,	0}, 	/* 0x6f80 */
        {8,	0}, 	/* 0x6f81 */
        {8,	0}, 	/* 0x6f82 */
        {8,	0}, 	/* 0x6f83 */
        {8,	0}, 	/* 0x6f84 */
        {8,	0}, 	/* 0x6f85 */
        {8,	0}, 	/* 0x6f86 */
        {8,	0}, 	/* 0x6f87 */
        {8,	0}, 	/* 0x6f88 */
        {8,	0}, 	/* 0x6f89 */
        {8,	0}, 	/* 0x6f8a */
        {8,	0}, 	/* 0x6f8b */
        {8,	0}, 	/* 0x6f8c */
        {8,	0}, 	/* 0x6f8d */
        {8,	0}, 	/* 0x6f8e */
        {8,	0}, 	/* 0x6f8f */
        {8,	0}, 	/* 0x6f90 */
        {8,	0}, 	/* 0x6f91 */
        {8,	0}, 	/* 0x6f92 */
        {8,	0}, 	/* 0x6f93 */
        {8,	0}, 	/* 0x6f94 */
        {8,	0}, 	/* 0x6f95 */
        {8,	0}, 	/* 0x6f96 */
        {8,	0}, 	/* 0x6f97 */
        {8,	0}, 	/* 0x6f98 */
        {8,	0}, 	/* 0x6f99 */
        {8,	0}, 	/* 0x6f9a */
        {8,	0}, 	/* 0x6f9b */
        {8,	0}, 	/* 0x6f9c */
        {8,	0}, 	/* 0x6f9d */
        {8,	0}, 	/* 0x6f9e */
        {8,	0}, 	/* 0x6f9f */
        {8,	0}, 	/* 0x6fa0 */
        {8,	0}, 	/* 0x6fa1 */
        {8,	0}, 	/* 0x6fa2 */
        {8,	0}, 	/* 0x6fa3 */
        {8,	0}, 	/* 0x6fa4 */
        {8,	0}, 	/* 0x6fa5 */
        {8,	0}, 	/* 0x6fa6 */
        {8,	0}, 	/* 0x6fa7 */
        {8,	0}, 	/* 0x6fa8 */
        {8,	0}, 	/* 0x6fa9 */
        {8,	0}, 	/* 0x6faa */
        {8,	0}, 	/* 0x6fab */
        {8,	0}, 	/* 0x6fac */
        {8,	0}, 	/* 0x6fad */
        {8,	0}, 	/* 0x6fae */
        {8,	0}, 	/* 0x6faf */
        {8,	0}, 	/* 0x6fb0 */
        {8,	0}, 	/* 0x6fb1 */
        {8,	0}, 	/* 0x6fb2 */
        {8,	0}, 	/* 0x6fb3 */
        {8,	0}, 	/* 0x6fb4 */
        {8,	0}, 	/* 0x6fb5 */
        {8,	0}, 	/* 0x6fb6 */
        {8,	0}, 	/* 0x6fb7 */
        {8,	0}, 	/* 0x6fb8 */
        {8,	0}, 	/* 0x6fb9 */
        {8,	0}, 	/* 0x6fba */
        {8,	0}, 	/* 0x6fbb */
        {8,	0}, 	/* 0x6fbc */
        {8,	0}, 	/* 0x6fbd */
        {8,	0}, 	/* 0x6fbe */
        {8,	0}, 	/* 0x6fbf */
        {8,	0}, 	/* 0x6fc0 */
        {8,	0}, 	/* 0x6fc1 */
        {8,	0}, 	/* 0x6fc2 */
        {8,	0}, 	/* 0x6fc3 */
        {8,	0}, 	/* 0x6fc4 */
        {8,	0}, 	/* 0x6fc5 */
        {8,	0}, 	/* 0x6fc6 */
        {8,	0}, 	/* 0x6fc7 */
        {8,	0}, 	/* 0x6fc8 */
        {8,	0}, 	/* 0x6fc9 */
        {8,	0}, 	/* 0x6fca */
        {8,	0}, 	/* 0x6fcb */
        {8,	0}, 	/* 0x6fcc */
        {8,	0}, 	/* 0x6fcd */
        {8,	0}, 	/* 0x6fce */
        {8,	0}, 	/* 0x6fcf */
        {8,	0}, 	/* 0x6fd0 */
        {8,	0}, 	/* 0x6fd1 */
        {8,	0}, 	/* 0x6fd2 */
        {8,	0}, 	/* 0x6fd3 */
        {8,	0}, 	/* 0x6fd4 */
        {8,	0}, 	/* 0x6fd5 */
        {8,	0}, 	/* 0x6fd6 */
        {8,	0}, 	/* 0x6fd7 */
        {8,	0}, 	/* 0x6fd8 */
        {8,	0}, 	/* 0x6fd9 */
        {8,	0}, 	/* 0x6fda */
        {8,	0}, 	/* 0x6fdb */
        {8,	0}, 	/* 0x6fdc */
        {8,	0}, 	/* 0x6fdd */
        {8,	0}, 	/* 0x6fde */
        {8,	0}, 	/* 0x6fdf */
        {8,	0}, 	/* 0x6fe0 */
        {8,	0}, 	/* 0x6fe1 */
        {8,	0}, 	/* 0x6fe2 */
        {8,	0}, 	/* 0x6fe3 */
        {8,	0}, 	/* 0x6fe4 */
        {8,	0}, 	/* 0x6fe5 */
        {8,	0}, 	/* 0x6fe6 */
        {8,	0}, 	/* 0x6fe7 */
        {8,	0}, 	/* 0x6fe8 */
        {8,	0}, 	/* 0x6fe9 */
        {8,	0}, 	/* 0x6fea */
        {8,	0}, 	/* 0x6feb */
        {8,	0}, 	/* 0x6fec */
        {8,	0}, 	/* 0x6fed */
        {8,	0}, 	/* 0x6fee */
        {8,	0}, 	/* 0x6fef */
        {8,	0}, 	/* 0x6ff0 */
        {8,	0}, 	/* 0x6ff1 */
        {8,	0}, 	/* 0x6ff2 */
        {8,	0}, 	/* 0x6ff3 */
        {8,	0}, 	/* 0x6ff4 */
        {8,	0}, 	/* 0x6ff5 */
        {8,	0}, 	/* 0x6ff6 */
        {8,	0}, 	/* 0x6ff7 */
        {8,	0}, 	/* 0x6ff8 */
        {8,	0}, 	/* 0x6ff9 */
        {8,	0}, 	/* 0x6ffa */
        {8,	0}, 	/* 0x6ffb */
        {8,	0}, 	/* 0x6ffc */
        {8,	0}, 	/* 0x6ffd */
        {8,	0}, 	/* 0x6ffe */
        {8,	0}, 	/* 0x6fff */
        {8,	0}, 	/* 0x7000 */
        {8,	0}, 	/* 0x7001 */
        {8,	0}, 	/* 0x7002 */
        {8,	0}, 	/* 0x7003 */
        {8,	0}, 	/* 0x7004 */
        {8,	0}, 	/* 0x7005 */
        {8,	0}, 	/* 0x7006 */
        {8,	0}, 	/* 0x7007 */
        {8,	0}, 	/* 0x7008 */
        {8,	0}, 	/* 0x7009 */
        {8,	0}, 	/* 0x700a */
        {8,	0}, 	/* 0x700b */
        {8,	0}, 	/* 0x700c */
        {8,	0}, 	/* 0x700d */
        {8,	0}, 	/* 0x700e */
        {8,	0}, 	/* 0x700f */
        {8,	0}, 	/* 0x7010 */
        {8,	0}, 	/* 0x7011 */
        {8,	0}, 	/* 0x7012 */
        {8,	0}, 	/* 0x7013 */
        {8,	0}, 	/* 0x7014 */
        {8,	0}, 	/* 0x7015 */
        {8,	0}, 	/* 0x7016 */
        {8,	0}, 	/* 0x7017 */
        {8,	0}, 	/* 0x7018 */
        {8,	0}, 	/* 0x7019 */
        {8,	0}, 	/* 0x701a */
        {8,	0}, 	/* 0x701b */
        {8,	0}, 	/* 0x701c */
        {8,	0}, 	/* 0x701d */
        {8,	0}, 	/* 0x701e */
        {8,	0}, 	/* 0x701f */
        {8,	0}, 	/* 0x7020 */
        {8,	0}, 	/* 0x7021 */
        {8,	0}, 	/* 0x7022 */
        {8,	0}, 	/* 0x7023 */
        {8,	0}, 	/* 0x7024 */
        {8,	0}, 	/* 0x7025 */
        {8,	0}, 	/* 0x7026 */
        {8,	0}, 	/* 0x7027 */
        {8,	0}, 	/* 0x7028 */
        {8,	0}, 	/* 0x7029 */
        {8,	0}, 	/* 0x702a */
        {8,	0}, 	/* 0x702b */
        {8,	0}, 	/* 0x702c */
        {8,	0}, 	/* 0x702d */
        {8,	0}, 	/* 0x702e */
        {8,	0}, 	/* 0x702f */
        {8,	0}, 	/* 0x7030 */
        {8,	0}, 	/* 0x7031 */
        {8,	0}, 	/* 0x7032 */
        {8,	0}, 	/* 0x7033 */
        {8,	0}, 	/* 0x7034 */
        {8,	0}, 	/* 0x7035 */
        {8,	0}, 	/* 0x7036 */
        {8,	0}, 	/* 0x7037 */
        {8,	0}, 	/* 0x7038 */
        {8,	0}, 	/* 0x7039 */
        {8,	0}, 	/* 0x703a */
        {8,	0}, 	/* 0x703b */
        {8,	0}, 	/* 0x703c */
        {8,	0}, 	/* 0x703d */
        {8,	0}, 	/* 0x703e */
        {8,	0}, 	/* 0x703f */
        {8,	0}, 	/* 0x7040 */
        {8,	0}, 	/* 0x7041 */
        {8,	0}, 	/* 0x7042 */
        {8,	0}, 	/* 0x7043 */
        {8,	0}, 	/* 0x7044 */
        {8,	0}, 	/* 0x7045 */
        {8,	0}, 	/* 0x7046 */
        {8,	0}, 	/* 0x7047 */
        {8,	0}, 	/* 0x7048 */
        {8,	0}, 	/* 0x7049 */
        {8,	0}, 	/* 0x704a */
        {8,	0}, 	/* 0x704b */
        {8,	0}, 	/* 0x704c */
        {8,	0}, 	/* 0x704d */
        {8,	0}, 	/* 0x704e */
        {8,	0}, 	/* 0x704f */
        {8,	0}, 	/* 0x7050 */
        {8,	0}, 	/* 0x7051 */
        {8,	0}, 	/* 0x7052 */
        {8,	0}, 	/* 0x7053 */
        {8,	0}, 	/* 0x7054 */
        {8,	0}, 	/* 0x7055 */
        {8,	0}, 	/* 0x7056 */
        {8,	0}, 	/* 0x7057 */
        {8,	0}, 	/* 0x7058 */
        {8,	0}, 	/* 0x7059 */
        {8,	0}, 	/* 0x705a */
        {8,	0}, 	/* 0x705b */
        {8,	0}, 	/* 0x705c */
        {8,	0}, 	/* 0x705d */
        {8,	0}, 	/* 0x705e */
        {8,	0}, 	/* 0x705f */
        {8,	0}, 	/* 0x7060 */
        {8,	0}, 	/* 0x7061 */
        {8,	0}, 	/* 0x7062 */
        {8,	0}, 	/* 0x7063 */
        {8,	0}, 	/* 0x7064 */
        {8,	0}, 	/* 0x7065 */
        {8,	0}, 	/* 0x7066 */
        {8,	0}, 	/* 0x7067 */
        {8,	0}, 	/* 0x7068 */
        {8,	0}, 	/* 0x7069 */
        {8,	0}, 	/* 0x706a */
        {8,	0}, 	/* 0x706b */
        {8,	0}, 	/* 0x706c */
        {8,	0}, 	/* 0x706d */
        {8,	0}, 	/* 0x706e */
        {8,	0}, 	/* 0x706f */
        {8,	0}, 	/* 0x7070 */
        {8,	0}, 	/* 0x7071 */
        {8,	0}, 	/* 0x7072 */
        {8,	0}, 	/* 0x7073 */
        {8,	0}, 	/* 0x7074 */
        {8,	0}, 	/* 0x7075 */
        {8,	0}, 	/* 0x7076 */
        {8,	0}, 	/* 0x7077 */
        {8,	0}, 	/* 0x7078 */
        {8,	0}, 	/* 0x7079 */
        {8,	0}, 	/* 0x707a */
        {8,	0}, 	/* 0x707b */
        {8,	0}, 	/* 0x707c */
        {8,	0}, 	/* 0x707d */
        {8,	0}, 	/* 0x707e */
        {8,	0}, 	/* 0x707f */
        {8,	0}, 	/* 0x7080 */
        {8,	0}, 	/* 0x7081 */
        {8,	0}, 	/* 0x7082 */
        {8,	0}, 	/* 0x7083 */
        {8,	0}, 	/* 0x7084 */
        {8,	0}, 	/* 0x7085 */
        {8,	0}, 	/* 0x7086 */
        {8,	0}, 	/* 0x7087 */
        {8,	0}, 	/* 0x7088 */
        {8,	0}, 	/* 0x7089 */
        {8,	0}, 	/* 0x708a */
        {8,	0}, 	/* 0x708b */
        {8,	0}, 	/* 0x708c */
        {8,	0}, 	/* 0x708d */
        {8,	0}, 	/* 0x708e */
        {8,	0}, 	/* 0x708f */
        {8,	0}, 	/* 0x7090 */
        {8,	0}, 	/* 0x7091 */
        {8,	0}, 	/* 0x7092 */
        {8,	0}, 	/* 0x7093 */
        {8,	0}, 	/* 0x7094 */
        {8,	0}, 	/* 0x7095 */
        {8,	0}, 	/* 0x7096 */
        {8,	0}, 	/* 0x7097 */
        {8,	0}, 	/* 0x7098 */
        {8,	0}, 	/* 0x7099 */
        {8,	0}, 	/* 0x709a */
        {8,	0}, 	/* 0x709b */
        {8,	0}, 	/* 0x709c */
        {8,	0}, 	/* 0x709d */
        {8,	0}, 	/* 0x709e */
        {8,	0}, 	/* 0x709f */
        {8,	0}, 	/* 0x70a0 */
        {8,	0}, 	/* 0x70a1 */
        {8,	0}, 	/* 0x70a2 */
        {8,	0}, 	/* 0x70a3 */
        {8,	0}, 	/* 0x70a4 */
        {8,	0}, 	/* 0x70a5 */
        {8,	0}, 	/* 0x70a6 */
        {8,	0}, 	/* 0x70a7 */
        {8,	0}, 	/* 0x70a8 */
        {8,	0}, 	/* 0x70a9 */
        {8,	0}, 	/* 0x70aa */
        {8,	0}, 	/* 0x70ab */
        {8,	0}, 	/* 0x70ac */
        {8,	0}, 	/* 0x70ad */
        {8,	0}, 	/* 0x70ae */
        {8,	0}, 	/* 0x70af */
        {8,	0}, 	/* 0x70b0 */
        {8,	0}, 	/* 0x70b1 */
        {8,	0}, 	/* 0x70b2 */
        {8,	0}, 	/* 0x70b3 */
        {8,	0}, 	/* 0x70b4 */
        {8,	0}, 	/* 0x70b5 */
        {8,	0}, 	/* 0x70b6 */
        {8,	0}, 	/* 0x70b7 */
        {8,	0}, 	/* 0x70b8 */
        {8,	0}, 	/* 0x70b9 */
        {8,	0}, 	/* 0x70ba */
        {8,	0}, 	/* 0x70bb */
        {8,	0}, 	/* 0x70bc */
        {8,	0}, 	/* 0x70bd */
        {8,	0}, 	/* 0x70be */
        {8,	0}, 	/* 0x70bf */
        {8,	0}, 	/* 0x70c0 */
        {8,	0}, 	/* 0x70c1 */
        {8,	0}, 	/* 0x70c2 */
        {8,	0}, 	/* 0x70c3 */
        {8,	0}, 	/* 0x70c4 */
        {8,	0}, 	/* 0x70c5 */
        {8,	0}, 	/* 0x70c6 */
        {8,	0}, 	/* 0x70c7 */
        {8,	0}, 	/* 0x70c8 */
        {8,	0}, 	/* 0x70c9 */
        {8,	0}, 	/* 0x70ca */
        {8,	0}, 	/* 0x70cb */
        {8,	0}, 	/* 0x70cc */
        {8,	0}, 	/* 0x70cd */
        {8,	0}, 	/* 0x70ce */
        {8,	0}, 	/* 0x70cf */
        {8,	0}, 	/* 0x70d0 */
        {8,	0}, 	/* 0x70d1 */
        {8,	0}, 	/* 0x70d2 */
        {8,	0}, 	/* 0x70d3 */
        {8,	0}, 	/* 0x70d4 */
        {8,	0}, 	/* 0x70d5 */
        {8,	0}, 	/* 0x70d6 */
        {8,	0}, 	/* 0x70d7 */
        {8,	0}, 	/* 0x70d8 */
        {8,	0}, 	/* 0x70d9 */
        {8,	0}, 	/* 0x70da */
        {8,	0}, 	/* 0x70db */
        {8,	0}, 	/* 0x70dc */
        {8,	0}, 	/* 0x70dd */
        {8,	0}, 	/* 0x70de */
        {8,	0}, 	/* 0x70df */
        {8,	0}, 	/* 0x70e0 */
        {8,	0}, 	/* 0x70e1 */
        {8,	0}, 	/* 0x70e2 */
        {8,	0}, 	/* 0x70e3 */
        {8,	0}, 	/* 0x70e4 */
        {8,	0}, 	/* 0x70e5 */
        {8,	0}, 	/* 0x70e6 */
        {8,	0}, 	/* 0x70e7 */
        {8,	0}, 	/* 0x70e8 */
        {8,	0}, 	/* 0x70e9 */
        {8,	0}, 	/* 0x70ea */
        {8,	0}, 	/* 0x70eb */
        {8,	0}, 	/* 0x70ec */
        {8,	0}, 	/* 0x70ed */
        {8,	0}, 	/* 0x70ee */
        {8,	0}, 	/* 0x70ef */
        {8,	0}, 	/* 0x70f0 */
        {8,	0}, 	/* 0x70f1 */
        {8,	0}, 	/* 0x70f2 */
        {8,	0}, 	/* 0x70f3 */
        {8,	0}, 	/* 0x70f4 */
        {8,	0}, 	/* 0x70f5 */
        {8,	0}, 	/* 0x70f6 */
        {8,	0}, 	/* 0x70f7 */
        {8,	0}, 	/* 0x70f8 */
        {8,	0}, 	/* 0x70f9 */
        {8,	0}, 	/* 0x70fa */
        {8,	0}, 	/* 0x70fb */
        {8,	0}, 	/* 0x70fc */
        {8,	0}, 	/* 0x70fd */
        {8,	0}, 	/* 0x70fe */
        {8,	0}, 	/* 0x70ff */
        {8,	0}, 	/* 0x7100 */
        {8,	0}, 	/* 0x7101 */
        {8,	0}, 	/* 0x7102 */
        {8,	0}, 	/* 0x7103 */
        {8,	0}, 	/* 0x7104 */
        {8,	0}, 	/* 0x7105 */
        {8,	0}, 	/* 0x7106 */
        {8,	0}, 	/* 0x7107 */
        {8,	0}, 	/* 0x7108 */
        {8,	0}, 	/* 0x7109 */
        {8,	0}, 	/* 0x710a */
        {8,	0}, 	/* 0x710b */
        {8,	0}, 	/* 0x710c */
        {8,	0}, 	/* 0x710d */
        {8,	0}, 	/* 0x710e */
        {8,	0}, 	/* 0x710f */
        {8,	0}, 	/* 0x7110 */
        {8,	0}, 	/* 0x7111 */
        {8,	0}, 	/* 0x7112 */
        {8,	0}, 	/* 0x7113 */
        {8,	0}, 	/* 0x7114 */
        {8,	0}, 	/* 0x7115 */
        {8,	0}, 	/* 0x7116 */
        {8,	0}, 	/* 0x7117 */
        {8,	0}, 	/* 0x7118 */
        {8,	0}, 	/* 0x7119 */
        {8,	0}, 	/* 0x711a */
        {8,	0}, 	/* 0x711b */
        {8,	0}, 	/* 0x711c */
        {8,	0}, 	/* 0x711d */
        {8,	0}, 	/* 0x711e */
        {8,	0}, 	/* 0x711f */
        {8,	0}, 	/* 0x7120 */
        {8,	0}, 	/* 0x7121 */
        {8,	0}, 	/* 0x7122 */
        {8,	0}, 	/* 0x7123 */
        {8,	0}, 	/* 0x7124 */
        {8,	0}, 	/* 0x7125 */
        {8,	0}, 	/* 0x7126 */
        {8,	0}, 	/* 0x7127 */
        {8,	0}, 	/* 0x7128 */
        {8,	0}, 	/* 0x7129 */
        {8,	0}, 	/* 0x712a */
        {8,	0}, 	/* 0x712b */
        {8,	0}, 	/* 0x712c */
        {8,	0}, 	/* 0x712d */
        {8,	0}, 	/* 0x712e */
        {8,	0}, 	/* 0x712f */
        {8,	0}, 	/* 0x7130 */
        {8,	0}, 	/* 0x7131 */
        {8,	0}, 	/* 0x7132 */
        {8,	0}, 	/* 0x7133 */
        {8,	0}, 	/* 0x7134 */
        {8,	0}, 	/* 0x7135 */
        {8,	0}, 	/* 0x7136 */
        {8,	0}, 	/* 0x7137 */
        {8,	0}, 	/* 0x7138 */
        {8,	0}, 	/* 0x7139 */
        {8,	0}, 	/* 0x713a */
        {8,	0}, 	/* 0x713b */
        {8,	0}, 	/* 0x713c */
        {8,	0}, 	/* 0x713d */
        {8,	0}, 	/* 0x713e */
        {8,	0}, 	/* 0x713f */
        {8,	0}, 	/* 0x7140 */
        {8,	0}, 	/* 0x7141 */
        {8,	0}, 	/* 0x7142 */
        {8,	0}, 	/* 0x7143 */
        {8,	0}, 	/* 0x7144 */
        {8,	0}, 	/* 0x7145 */
        {8,	0}, 	/* 0x7146 */
        {8,	0}, 	/* 0x7147 */
        {8,	0}, 	/* 0x7148 */
        {8,	0}, 	/* 0x7149 */
        {8,	0}, 	/* 0x714a */
        {8,	0}, 	/* 0x714b */
        {8,	0}, 	/* 0x714c */
        {8,	0}, 	/* 0x714d */
        {8,	0}, 	/* 0x714e */
        {8,	0}, 	/* 0x714f */
        {8,	0}, 	/* 0x7150 */
        {8,	0}, 	/* 0x7151 */
        {8,	0}, 	/* 0x7152 */
        {8,	0}, 	/* 0x7153 */
        {8,	0}, 	/* 0x7154 */
        {8,	0}, 	/* 0x7155 */
        {8,	0}, 	/* 0x7156 */
        {8,	0}, 	/* 0x7157 */
        {8,	0}, 	/* 0x7158 */
        {8,	0}, 	/* 0x7159 */
        {8,	0}, 	/* 0x715a */
        {8,	0}, 	/* 0x715b */
        {8,	0}, 	/* 0x715c */
        {8,	0}, 	/* 0x715d */
        {8,	0}, 	/* 0x715e */
        {8,	0}, 	/* 0x715f */
        {8,	0}, 	/* 0x7160 */
        {8,	0}, 	/* 0x7161 */
        {8,	0}, 	/* 0x7162 */
        {8,	0}, 	/* 0x7163 */
        {8,	0}, 	/* 0x7164 */
        {8,	0}, 	/* 0x7165 */
        {8,	0}, 	/* 0x7166 */
        {8,	0}, 	/* 0x7167 */
        {8,	0}, 	/* 0x7168 */
        {8,	0}, 	/* 0x7169 */
        {8,	0}, 	/* 0x716a */
        {8,	0}, 	/* 0x716b */
        {8,	0}, 	/* 0x716c */
        {8,	0}, 	/* 0x716d */
        {8,	0}, 	/* 0x716e */
        {8,	0}, 	/* 0x716f */
        {8,	0}, 	/* 0x7170 */
        {8,	0}, 	/* 0x7171 */
        {8,	0}, 	/* 0x7172 */
        {8,	0}, 	/* 0x7173 */
        {8,	0}, 	/* 0x7174 */
        {8,	0}, 	/* 0x7175 */
        {8,	0}, 	/* 0x7176 */
        {8,	0}, 	/* 0x7177 */
        {8,	0}, 	/* 0x7178 */
        {8,	0}, 	/* 0x7179 */
        {8,	0}, 	/* 0x717a */
        {8,	0}, 	/* 0x717b */
        {8,	0}, 	/* 0x717c */
        {8,	0}, 	/* 0x717d */
        {8,	0}, 	/* 0x717e */
        {8,	0}, 	/* 0x717f */
        {8,	0}, 	/* 0x7180 */
        {8,	0}, 	/* 0x7181 */
        {8,	0}, 	/* 0x7182 */
        {8,	0}, 	/* 0x7183 */
        {8,	0}, 	/* 0x7184 */
        {8,	0}, 	/* 0x7185 */
        {8,	0}, 	/* 0x7186 */
        {8,	0}, 	/* 0x7187 */
        {8,	0}, 	/* 0x7188 */
        {8,	0}, 	/* 0x7189 */
        {8,	0}, 	/* 0x718a */
        {8,	0}, 	/* 0x718b */
        {8,	0}, 	/* 0x718c */
        {8,	0}, 	/* 0x718d */
        {8,	0}, 	/* 0x718e */
        {8,	0}, 	/* 0x718f */
        {8,	0}, 	/* 0x7190 */
        {8,	0}, 	/* 0x7191 */
        {8,	0}, 	/* 0x7192 */
        {8,	0}, 	/* 0x7193 */
        {8,	0}, 	/* 0x7194 */
        {8,	0}, 	/* 0x7195 */
        {8,	0}, 	/* 0x7196 */
        {8,	0}, 	/* 0x7197 */
        {8,	0}, 	/* 0x7198 */
        {8,	0}, 	/* 0x7199 */
        {8,	0}, 	/* 0x719a */
        {8,	0}, 	/* 0x719b */
        {8,	0}, 	/* 0x719c */
        {8,	0}, 	/* 0x719d */
        {8,	0}, 	/* 0x719e */
        {8,	0}, 	/* 0x719f */
        {8,	0}, 	/* 0x71a0 */
        {8,	0}, 	/* 0x71a1 */
        {8,	0}, 	/* 0x71a2 */
        {8,	0}, 	/* 0x71a3 */
        {8,	0}, 	/* 0x71a4 */
        {8,	0}, 	/* 0x71a5 */
        {8,	0}, 	/* 0x71a6 */
        {8,	0}, 	/* 0x71a7 */
        {8,	0}, 	/* 0x71a8 */
        {8,	0}, 	/* 0x71a9 */
        {8,	0}, 	/* 0x71aa */
        {8,	0}, 	/* 0x71ab */
        {8,	0}, 	/* 0x71ac */
        {8,	0}, 	/* 0x71ad */
        {8,	0}, 	/* 0x71ae */
        {8,	0}, 	/* 0x71af */
        {8,	0}, 	/* 0x71b0 */
        {8,	0}, 	/* 0x71b1 */
        {8,	0}, 	/* 0x71b2 */
        {8,	0}, 	/* 0x71b3 */
        {8,	0}, 	/* 0x71b4 */
        {8,	0}, 	/* 0x71b5 */
        {8,	0}, 	/* 0x71b6 */
        {8,	0}, 	/* 0x71b7 */
        {8,	0}, 	/* 0x71b8 */
        {8,	0}, 	/* 0x71b9 */
        {8,	0}, 	/* 0x71ba */
        {8,	0}, 	/* 0x71bb */
        {8,	0}, 	/* 0x71bc */
        {8,	0}, 	/* 0x71bd */
        {8,	0}, 	/* 0x71be */
        {8,	0}, 	/* 0x71bf */
        {8,	0}, 	/* 0x71c0 */
        {8,	0}, 	/* 0x71c1 */
        {8,	0}, 	/* 0x71c2 */
        {8,	0}, 	/* 0x71c3 */
        {8,	0}, 	/* 0x71c4 */
        {8,	0}, 	/* 0x71c5 */
        {8,	0}, 	/* 0x71c6 */
        {8,	0}, 	/* 0x71c7 */
        {8,	0}, 	/* 0x71c8 */
        {8,	0}, 	/* 0x71c9 */
        {8,	0}, 	/* 0x71ca */
        {8,	0}, 	/* 0x71cb */
        {8,	0}, 	/* 0x71cc */
        {8,	0}, 	/* 0x71cd */
        {8,	0}, 	/* 0x71ce */
        {8,	0}, 	/* 0x71cf */
        {8,	0}, 	/* 0x71d0 */
        {8,	0}, 	/* 0x71d1 */
        {8,	0}, 	/* 0x71d2 */
        {8,	0}, 	/* 0x71d3 */
        {8,	0}, 	/* 0x71d4 */
        {8,	0}, 	/* 0x71d5 */
        {8,	0}, 	/* 0x71d6 */
        {8,	0}, 	/* 0x71d7 */
        {8,	0}, 	/* 0x71d8 */
        {8,	0}, 	/* 0x71d9 */
        {8,	0}, 	/* 0x71da */
        {8,	0}, 	/* 0x71db */
        {8,	0}, 	/* 0x71dc */
        {8,	0}, 	/* 0x71dd */
        {8,	0}, 	/* 0x71de */
        {8,	0}, 	/* 0x71df */
        {8,	0}, 	/* 0x71e0 */
        {8,	0}, 	/* 0x71e1 */
        {8,	0}, 	/* 0x71e2 */
        {8,	0}, 	/* 0x71e3 */
        {8,	0}, 	/* 0x71e4 */
        {8,	0}, 	/* 0x71e5 */
        {8,	0}, 	/* 0x71e6 */
        {8,	0}, 	/* 0x71e7 */
        {8,	0}, 	/* 0x71e8 */
        {8,	0}, 	/* 0x71e9 */
        {8,	0}, 	/* 0x71ea */
        {8,	0}, 	/* 0x71eb */
        {8,	0}, 	/* 0x71ec */
        {8,	0}, 	/* 0x71ed */
        {8,	0}, 	/* 0x71ee */
        {8,	0}, 	/* 0x71ef */
        {8,	0}, 	/* 0x71f0 */
        {8,	0}, 	/* 0x71f1 */
        {8,	0}, 	/* 0x71f2 */
        {8,	0}, 	/* 0x71f3 */
        {8,	0}, 	/* 0x71f4 */
        {8,	0}, 	/* 0x71f5 */
        {8,	0}, 	/* 0x71f6 */
        {8,	0}, 	/* 0x71f7 */
        {8,	0}, 	/* 0x71f8 */
        {8,	0}, 	/* 0x71f9 */
        {8,	0}, 	/* 0x71fa */
        {8,	0}, 	/* 0x71fb */
        {8,	0}, 	/* 0x71fc */
        {8,	0}, 	/* 0x71fd */
        {8,	0}, 	/* 0x71fe */
        {8,	0}, 	/* 0x71ff */
        {8,	0}, 	/* 0x7200 */
        {8,	0}, 	/* 0x7201 */
        {8,	0}, 	/* 0x7202 */
        {8,	0}, 	/* 0x7203 */
        {8,	0}, 	/* 0x7204 */
        {8,	0}, 	/* 0x7205 */
        {8,	0}, 	/* 0x7206 */
        {8,	0}, 	/* 0x7207 */
        {8,	0}, 	/* 0x7208 */
        {8,	0}, 	/* 0x7209 */
        {8,	0}, 	/* 0x720a */
        {8,	0}, 	/* 0x720b */
        {8,	0}, 	/* 0x720c */
        {8,	0}, 	/* 0x720d */
        {8,	0}, 	/* 0x720e */
        {8,	0}, 	/* 0x720f */
        {8,	0}, 	/* 0x7210 */
        {8,	0}, 	/* 0x7211 */
        {8,	0}, 	/* 0x7212 */
        {8,	0}, 	/* 0x7213 */
        {8,	0}, 	/* 0x7214 */
        {8,	0}, 	/* 0x7215 */
        {8,	0}, 	/* 0x7216 */
        {8,	0}, 	/* 0x7217 */
        {8,	0}, 	/* 0x7218 */
        {8,	0}, 	/* 0x7219 */
        {8,	0}, 	/* 0x721a */
        {8,	0}, 	/* 0x721b */
        {8,	0}, 	/* 0x721c */
        {8,	0}, 	/* 0x721d */
        {8,	0}, 	/* 0x721e */
        {8,	0}, 	/* 0x721f */
        {8,	0}, 	/* 0x7220 */
        {8,	0}, 	/* 0x7221 */
        {8,	0}, 	/* 0x7222 */
        {8,	0}, 	/* 0x7223 */
        {8,	0}, 	/* 0x7224 */
        {8,	0}, 	/* 0x7225 */
        {8,	0}, 	/* 0x7226 */
        {8,	0}, 	/* 0x7227 */
        {8,	0}, 	/* 0x7228 */
        {8,	0}, 	/* 0x7229 */
        {8,	0}, 	/* 0x722a */
        {8,	0}, 	/* 0x722b */
        {8,	0}, 	/* 0x722c */
        {8,	0}, 	/* 0x722d */
        {8,	0}, 	/* 0x722e */
        {8,	0}, 	/* 0x722f */
        {8,	0}, 	/* 0x7230 */
        {8,	0}, 	/* 0x7231 */
        {8,	0}, 	/* 0x7232 */
        {8,	0}, 	/* 0x7233 */
        {8,	0}, 	/* 0x7234 */
        {8,	0}, 	/* 0x7235 */
        {8,	0}, 	/* 0x7236 */
        {8,	0}, 	/* 0x7237 */
        {8,	0}, 	/* 0x7238 */
        {8,	0}, 	/* 0x7239 */
        {8,	0}, 	/* 0x723a */
        {8,	0}, 	/* 0x723b */
        {8,	0}, 	/* 0x723c */
        {8,	0}, 	/* 0x723d */
        {8,	0}, 	/* 0x723e */
        {8,	0}, 	/* 0x723f */
        {8,	0}, 	/* 0x7240 */
        {8,	0}, 	/* 0x7241 */
        {8,	0}, 	/* 0x7242 */
        {8,	0}, 	/* 0x7243 */
        {8,	0}, 	/* 0x7244 */
        {8,	0}, 	/* 0x7245 */
        {8,	0}, 	/* 0x7246 */
        {8,	0}, 	/* 0x7247 */
        {8,	0}, 	/* 0x7248 */
        {8,	0}, 	/* 0x7249 */
        {8,	0}, 	/* 0x724a */
        {8,	0}, 	/* 0x724b */
        {8,	0}, 	/* 0x724c */
        {8,	0}, 	/* 0x724d */
        {8,	0}, 	/* 0x724e */
        {8,	0}, 	/* 0x724f */
        {8,	0}, 	/* 0x7250 */
        {8,	0}, 	/* 0x7251 */
        {8,	0}, 	/* 0x7252 */
        {8,	0}, 	/* 0x7253 */
        {8,	0}, 	/* 0x7254 */
        {8,	0}, 	/* 0x7255 */
        {8,	0}, 	/* 0x7256 */
        {8,	0}, 	/* 0x7257 */
        {8,	0}, 	/* 0x7258 */
        {8,	0}, 	/* 0x7259 */
        {8,	0}, 	/* 0x725a */
        {8,	0}, 	/* 0x725b */
        {8,	0}, 	/* 0x725c */
        {8,	0}, 	/* 0x725d */
        {8,	0}, 	/* 0x725e */
        {8,	0}, 	/* 0x725f */
        {8,	0}, 	/* 0x7260 */
        {8,	0}, 	/* 0x7261 */
        {8,	0}, 	/* 0x7262 */
        {8,	0}, 	/* 0x7263 */
        {8,	0}, 	/* 0x7264 */
        {8,	0}, 	/* 0x7265 */
        {8,	0}, 	/* 0x7266 */
        {8,	0}, 	/* 0x7267 */
        {8,	0}, 	/* 0x7268 */
        {8,	0}, 	/* 0x7269 */
        {8,	0}, 	/* 0x726a */
        {8,	0}, 	/* 0x726b */
        {8,	0}, 	/* 0x726c */
        {8,	0}, 	/* 0x726d */
        {8,	0}, 	/* 0x726e */
        {8,	0}, 	/* 0x726f */
        {8,	0}, 	/* 0x7270 */
        {8,	0}, 	/* 0x7271 */
        {8,	0}, 	/* 0x7272 */
        {8,	0}, 	/* 0x7273 */
        {8,	0}, 	/* 0x7274 */
        {8,	0}, 	/* 0x7275 */
        {8,	0}, 	/* 0x7276 */
        {8,	0}, 	/* 0x7277 */
        {8,	0}, 	/* 0x7278 */
        {8,	0}, 	/* 0x7279 */
        {8,	0}, 	/* 0x727a */
        {8,	0}, 	/* 0x727b */
        {8,	0}, 	/* 0x727c */
        {8,	0}, 	/* 0x727d */
        {8,	0}, 	/* 0x727e */
        {8,	0}, 	/* 0x727f */
        {8,	0}, 	/* 0x7280 */
        {8,	0}, 	/* 0x7281 */
        {8,	0}, 	/* 0x7282 */
        {8,	0}, 	/* 0x7283 */
        {8,	0}, 	/* 0x7284 */
        {8,	0}, 	/* 0x7285 */
        {8,	0}, 	/* 0x7286 */
        {8,	0}, 	/* 0x7287 */
        {8,	0}, 	/* 0x7288 */
        {8,	0}, 	/* 0x7289 */
        {8,	0}, 	/* 0x728a */
        {8,	0}, 	/* 0x728b */
        {8,	0}, 	/* 0x728c */
        {8,	0}, 	/* 0x728d */
        {8,	0}, 	/* 0x728e */
        {8,	0}, 	/* 0x728f */
        {8,	0}, 	/* 0x7290 */
        {8,	0}, 	/* 0x7291 */
        {8,	0}, 	/* 0x7292 */
        {8,	0}, 	/* 0x7293 */
        {8,	0}, 	/* 0x7294 */
        {8,	0}, 	/* 0x7295 */
        {8,	0}, 	/* 0x7296 */
        {8,	0}, 	/* 0x7297 */
        {8,	0}, 	/* 0x7298 */
        {8,	0}, 	/* 0x7299 */
        {8,	0}, 	/* 0x729a */
        {8,	0}, 	/* 0x729b */
        {8,	0}, 	/* 0x729c */
        {8,	0}, 	/* 0x729d */
        {8,	0}, 	/* 0x729e */
        {8,	0}, 	/* 0x729f */
        {8,	0}, 	/* 0x72a0 */
        {8,	0}, 	/* 0x72a1 */
        {8,	0}, 	/* 0x72a2 */
        {8,	0}, 	/* 0x72a3 */
        {8,	0}, 	/* 0x72a4 */
        {8,	0}, 	/* 0x72a5 */
        {8,	0}, 	/* 0x72a6 */
        {8,	0}, 	/* 0x72a7 */
        {8,	0}, 	/* 0x72a8 */
        {8,	0}, 	/* 0x72a9 */
        {8,	0}, 	/* 0x72aa */
        {8,	0}, 	/* 0x72ab */
        {8,	0}, 	/* 0x72ac */
        {8,	0}, 	/* 0x72ad */
        {8,	0}, 	/* 0x72ae */
        {8,	0}, 	/* 0x72af */
        {8,	0}, 	/* 0x72b0 */
        {8,	0}, 	/* 0x72b1 */
        {8,	0}, 	/* 0x72b2 */
        {8,	0}, 	/* 0x72b3 */
        {8,	0}, 	/* 0x72b4 */
        {8,	0}, 	/* 0x72b5 */
        {8,	0}, 	/* 0x72b6 */
        {8,	0}, 	/* 0x72b7 */
        {8,	0}, 	/* 0x72b8 */
        {8,	0}, 	/* 0x72b9 */
        {8,	0}, 	/* 0x72ba */
        {8,	0}, 	/* 0x72bb */
        {8,	0}, 	/* 0x72bc */
        {8,	0}, 	/* 0x72bd */
        {8,	0}, 	/* 0x72be */
        {8,	0}, 	/* 0x72bf */
        {8,	0}, 	/* 0x72c0 */
        {8,	0}, 	/* 0x72c1 */
        {8,	0}, 	/* 0x72c2 */
        {8,	0}, 	/* 0x72c3 */
        {8,	0}, 	/* 0x72c4 */
        {8,	0}, 	/* 0x72c5 */
        {8,	0}, 	/* 0x72c6 */
        {8,	0}, 	/* 0x72c7 */
        {8,	0}, 	/* 0x72c8 */
        {8,	0}, 	/* 0x72c9 */
        {8,	0}, 	/* 0x72ca */
        {8,	0}, 	/* 0x72cb */
        {8,	0}, 	/* 0x72cc */
        {8,	0}, 	/* 0x72cd */
        {8,	0}, 	/* 0x72ce */
        {8,	0}, 	/* 0x72cf */
        {8,	0}, 	/* 0x72d0 */
        {8,	0}, 	/* 0x72d1 */
        {8,	0}, 	/* 0x72d2 */
        {8,	0}, 	/* 0x72d3 */
        {8,	0}, 	/* 0x72d4 */
        {8,	0}, 	/* 0x72d5 */
        {8,	0}, 	/* 0x72d6 */
        {8,	0}, 	/* 0x72d7 */
        {8,	0}, 	/* 0x72d8 */
        {8,	0}, 	/* 0x72d9 */
        {8,	0}, 	/* 0x72da */
        {8,	0}, 	/* 0x72db */
        {8,	0}, 	/* 0x72dc */
        {8,	0}, 	/* 0x72dd */
        {8,	0}, 	/* 0x72de */
        {8,	0}, 	/* 0x72df */
        {8,	0}, 	/* 0x72e0 */
        {8,	0}, 	/* 0x72e1 */
        {8,	0}, 	/* 0x72e2 */
        {8,	0}, 	/* 0x72e3 */
        {8,	0}, 	/* 0x72e4 */
        {8,	0}, 	/* 0x72e5 */
        {8,	0}, 	/* 0x72e6 */
        {8,	0}, 	/* 0x72e7 */
        {8,	0}, 	/* 0x72e8 */
        {8,	0}, 	/* 0x72e9 */
        {8,	0}, 	/* 0x72ea */
        {8,	0}, 	/* 0x72eb */
        {8,	0}, 	/* 0x72ec */
        {8,	0}, 	/* 0x72ed */
        {8,	0}, 	/* 0x72ee */
        {8,	0}, 	/* 0x72ef */
        {8,	0}, 	/* 0x72f0 */
        {8,	0}, 	/* 0x72f1 */
        {8,	0}, 	/* 0x72f2 */
        {8,	0}, 	/* 0x72f3 */
        {8,	0}, 	/* 0x72f4 */
        {8,	0}, 	/* 0x72f5 */
        {8,	0}, 	/* 0x72f6 */
        {8,	0}, 	/* 0x72f7 */
        {8,	0}, 	/* 0x72f8 */
        {8,	0}, 	/* 0x72f9 */
        {8,	0}, 	/* 0x72fa */
        {8,	0}, 	/* 0x72fb */
        {8,	0}, 	/* 0x72fc */
        {8,	0}, 	/* 0x72fd */
        {8,	0}, 	/* 0x72fe */
        {8,	0}, 	/* 0x72ff */
        {8,	0}, 	/* 0x7300 */
        {8,	0}, 	/* 0x7301 */
        {8,	0}, 	/* 0x7302 */
        {8,	0}, 	/* 0x7303 */
        {8,	0}, 	/* 0x7304 */
        {8,	0}, 	/* 0x7305 */
        {8,	0}, 	/* 0x7306 */
        {8,	0}, 	/* 0x7307 */
        {8,	0}, 	/* 0x7308 */
        {8,	0}, 	/* 0x7309 */
        {8,	0}, 	/* 0x730a */
        {8,	0}, 	/* 0x730b */
        {8,	0}, 	/* 0x730c */
        {8,	0}, 	/* 0x730d */
        {8,	0}, 	/* 0x730e */
        {8,	0}, 	/* 0x730f */
        {8,	0}, 	/* 0x7310 */
        {8,	0}, 	/* 0x7311 */
        {8,	0}, 	/* 0x7312 */
        {8,	0}, 	/* 0x7313 */
        {8,	0}, 	/* 0x7314 */
        {8,	0}, 	/* 0x7315 */
        {8,	0}, 	/* 0x7316 */
        {8,	0}, 	/* 0x7317 */
        {8,	0}, 	/* 0x7318 */
        {8,	0}, 	/* 0x7319 */
        {8,	0}, 	/* 0x731a */
        {8,	0}, 	/* 0x731b */
        {8,	0}, 	/* 0x731c */
        {8,	0}, 	/* 0x731d */
        {8,	0}, 	/* 0x731e */
        {8,	0}, 	/* 0x731f */
        {8,	0}, 	/* 0x7320 */
        {8,	0}, 	/* 0x7321 */
        {8,	0}, 	/* 0x7322 */
        {8,	0}, 	/* 0x7323 */
        {8,	0}, 	/* 0x7324 */
        {8,	0}, 	/* 0x7325 */
        {8,	0}, 	/* 0x7326 */
        {8,	0}, 	/* 0x7327 */
        {8,	0}, 	/* 0x7328 */
        {8,	0}, 	/* 0x7329 */
        {8,	0}, 	/* 0x732a */
        {8,	0}, 	/* 0x732b */
        {8,	0}, 	/* 0x732c */
        {8,	0}, 	/* 0x732d */
        {8,	0}, 	/* 0x732e */
        {8,	0}, 	/* 0x732f */
        {8,	0}, 	/* 0x7330 */
        {8,	0}, 	/* 0x7331 */
        {8,	0}, 	/* 0x7332 */
        {8,	0}, 	/* 0x7333 */
        {8,	0}, 	/* 0x7334 */
        {8,	0}, 	/* 0x7335 */
        {8,	0}, 	/* 0x7336 */
        {8,	0}, 	/* 0x7337 */
        {8,	0}, 	/* 0x7338 */
        {8,	0}, 	/* 0x7339 */
        {8,	0}, 	/* 0x733a */
        {8,	0}, 	/* 0x733b */
        {8,	0}, 	/* 0x733c */
        {8,	0}, 	/* 0x733d */
        {8,	0}, 	/* 0x733e */
        {8,	0}, 	/* 0x733f */
        {8,	0}, 	/* 0x7340 */
        {8,	0}, 	/* 0x7341 */
        {8,	0}, 	/* 0x7342 */
        {8,	0}, 	/* 0x7343 */
        {8,	0}, 	/* 0x7344 */
        {8,	0}, 	/* 0x7345 */
        {8,	0}, 	/* 0x7346 */
        {8,	0}, 	/* 0x7347 */
        {8,	0}, 	/* 0x7348 */
        {8,	0}, 	/* 0x7349 */
        {8,	0}, 	/* 0x734a */
        {8,	0}, 	/* 0x734b */
        {8,	0}, 	/* 0x734c */
        {8,	0}, 	/* 0x734d */
        {8,	0}, 	/* 0x734e */
        {8,	0}, 	/* 0x734f */
        {8,	0}, 	/* 0x7350 */
        {8,	0}, 	/* 0x7351 */
        {8,	0}, 	/* 0x7352 */
        {8,	0}, 	/* 0x7353 */
        {8,	0}, 	/* 0x7354 */
        {8,	0}, 	/* 0x7355 */
        {8,	0}, 	/* 0x7356 */
        {8,	0}, 	/* 0x7357 */
        {8,	0}, 	/* 0x7358 */
        {8,	0}, 	/* 0x7359 */
        {8,	0}, 	/* 0x735a */
        {8,	0}, 	/* 0x735b */
        {8,	0}, 	/* 0x735c */
        {8,	0}, 	/* 0x735d */
        {8,	0}, 	/* 0x735e */
        {8,	0}, 	/* 0x735f */
        {8,	0}, 	/* 0x7360 */
        {8,	0}, 	/* 0x7361 */
        {8,	0}, 	/* 0x7362 */
        {8,	0}, 	/* 0x7363 */
        {8,	0}, 	/* 0x7364 */
        {8,	0}, 	/* 0x7365 */
        {8,	0}, 	/* 0x7366 */
        {8,	0}, 	/* 0x7367 */
        {8,	0}, 	/* 0x7368 */
        {8,	0}, 	/* 0x7369 */
        {8,	0}, 	/* 0x736a */
        {8,	0}, 	/* 0x736b */
        {8,	0}, 	/* 0x736c */
        {8,	0}, 	/* 0x736d */
        {8,	0}, 	/* 0x736e */
        {8,	0}, 	/* 0x736f */
        {8,	0}, 	/* 0x7370 */
        {8,	0}, 	/* 0x7371 */
        {8,	0}, 	/* 0x7372 */
        {8,	0}, 	/* 0x7373 */
        {8,	0}, 	/* 0x7374 */
        {8,	0}, 	/* 0x7375 */
        {8,	0}, 	/* 0x7376 */
        {8,	0}, 	/* 0x7377 */
        {8,	0}, 	/* 0x7378 */
        {8,	0}, 	/* 0x7379 */
        {8,	0}, 	/* 0x737a */
        {8,	0}, 	/* 0x737b */
        {8,	0}, 	/* 0x737c */
        {8,	0}, 	/* 0x737d */
        {8,	0}, 	/* 0x737e */
        {8,	0}, 	/* 0x737f */
        {8,	0}, 	/* 0x7380 */
        {8,	0}, 	/* 0x7381 */
        {8,	0}, 	/* 0x7382 */
        {8,	0}, 	/* 0x7383 */
        {8,	0}, 	/* 0x7384 */
        {8,	0}, 	/* 0x7385 */
        {8,	0}, 	/* 0x7386 */
        {8,	0}, 	/* 0x7387 */
        {8,	0}, 	/* 0x7388 */
        {8,	0}, 	/* 0x7389 */
        {8,	0}, 	/* 0x738a */
        {8,	0}, 	/* 0x738b */
        {8,	0}, 	/* 0x738c */
        {8,	0}, 	/* 0x738d */
        {8,	0}, 	/* 0x738e */
        {8,	0}, 	/* 0x738f */
        {8,	0}, 	/* 0x7390 */
        {8,	0}, 	/* 0x7391 */
        {8,	0}, 	/* 0x7392 */
        {8,	0}, 	/* 0x7393 */
        {8,	0}, 	/* 0x7394 */
        {8,	0}, 	/* 0x7395 */
        {8,	0}, 	/* 0x7396 */
        {8,	0}, 	/* 0x7397 */
        {8,	0}, 	/* 0x7398 */
        {8,	0}, 	/* 0x7399 */
        {8,	0}, 	/* 0x739a */
        {8,	0}, 	/* 0x739b */
        {8,	0}, 	/* 0x739c */
        {8,	0}, 	/* 0x739d */
        {8,	0}, 	/* 0x739e */
        {8,	0}, 	/* 0x739f */
        {8,	0}, 	/* 0x73a0 */
        {8,	0}, 	/* 0x73a1 */
        {8,	0}, 	/* 0x73a2 */
        {8,	0}, 	/* 0x73a3 */
        {8,	0}, 	/* 0x73a4 */
        {8,	0}, 	/* 0x73a5 */
        {8,	0}, 	/* 0x73a6 */
        {8,	0}, 	/* 0x73a7 */
        {8,	0}, 	/* 0x73a8 */
        {8,	0}, 	/* 0x73a9 */
        {8,	0}, 	/* 0x73aa */
        {8,	0}, 	/* 0x73ab */
        {8,	0}, 	/* 0x73ac */
        {8,	0}, 	/* 0x73ad */
        {8,	0}, 	/* 0x73ae */
        {8,	0}, 	/* 0x73af */
        {8,	0}, 	/* 0x73b0 */
        {8,	0}, 	/* 0x73b1 */
        {8,	0}, 	/* 0x73b2 */
        {8,	0}, 	/* 0x73b3 */
        {8,	0}, 	/* 0x73b4 */
        {8,	0}, 	/* 0x73b5 */
        {8,	0}, 	/* 0x73b6 */
        {8,	0}, 	/* 0x73b7 */
        {8,	0}, 	/* 0x73b8 */
        {8,	0}, 	/* 0x73b9 */
        {8,	0}, 	/* 0x73ba */
        {8,	0}, 	/* 0x73bb */
        {8,	0}, 	/* 0x73bc */
        {8,	0}, 	/* 0x73bd */
        {8,	0}, 	/* 0x73be */
        {8,	0}, 	/* 0x73bf */
        {8,	0}, 	/* 0x73c0 */
        {8,	0}, 	/* 0x73c1 */
        {8,	0}, 	/* 0x73c2 */
        {8,	0}, 	/* 0x73c3 */
        {8,	0}, 	/* 0x73c4 */
        {8,	0}, 	/* 0x73c5 */
        {8,	0}, 	/* 0x73c6 */
        {8,	0}, 	/* 0x73c7 */
        {8,	0}, 	/* 0x73c8 */
        {8,	0}, 	/* 0x73c9 */
        {8,	0}, 	/* 0x73ca */
        {8,	0}, 	/* 0x73cb */
        {8,	0}, 	/* 0x73cc */
        {8,	0}, 	/* 0x73cd */
        {8,	0}, 	/* 0x73ce */
        {8,	0}, 	/* 0x73cf */
        {8,	0}, 	/* 0x73d0 */
        {8,	0}, 	/* 0x73d1 */
        {8,	0}, 	/* 0x73d2 */
        {8,	0}, 	/* 0x73d3 */
        {8,	0}, 	/* 0x73d4 */
        {8,	0}, 	/* 0x73d5 */
        {8,	0}, 	/* 0x73d6 */
        {8,	0}, 	/* 0x73d7 */
        {8,	0}, 	/* 0x73d8 */
        {8,	0}, 	/* 0x73d9 */
        {8,	0}, 	/* 0x73da */
        {8,	0}, 	/* 0x73db */
        {8,	0}, 	/* 0x73dc */
        {8,	0}, 	/* 0x73dd */
        {8,	0}, 	/* 0x73de */
        {8,	0}, 	/* 0x73df */
        {8,	0}, 	/* 0x73e0 */
        {8,	0}, 	/* 0x73e1 */
        {8,	0}, 	/* 0x73e2 */
        {8,	0}, 	/* 0x73e3 */
        {8,	0}, 	/* 0x73e4 */
        {8,	0}, 	/* 0x73e5 */
        {8,	0}, 	/* 0x73e6 */
        {8,	0}, 	/* 0x73e7 */
        {8,	0}, 	/* 0x73e8 */
        {8,	0}, 	/* 0x73e9 */
        {8,	0}, 	/* 0x73ea */
        {8,	0}, 	/* 0x73eb */
        {8,	0}, 	/* 0x73ec */
        {8,	0}, 	/* 0x73ed */
        {8,	0}, 	/* 0x73ee */
        {8,	0}, 	/* 0x73ef */
        {8,	0}, 	/* 0x73f0 */
        {8,	0}, 	/* 0x73f1 */
        {8,	0}, 	/* 0x73f2 */
        {8,	0}, 	/* 0x73f3 */
        {8,	0}, 	/* 0x73f4 */
        {8,	0}, 	/* 0x73f5 */
        {8,	0}, 	/* 0x73f6 */
        {8,	0}, 	/* 0x73f7 */
        {8,	0}, 	/* 0x73f8 */
        {8,	0}, 	/* 0x73f9 */
        {8,	0}, 	/* 0x73fa */
        {8,	0}, 	/* 0x73fb */
        {8,	0}, 	/* 0x73fc */
        {8,	0}, 	/* 0x73fd */
        {8,	0}, 	/* 0x73fe */
        {8,	0}, 	/* 0x73ff */
        {8,	0}, 	/* 0x7400 */
        {8,	0}, 	/* 0x7401 */
        {8,	0}, 	/* 0x7402 */
        {8,	0}, 	/* 0x7403 */
        {8,	0}, 	/* 0x7404 */
        {8,	0}, 	/* 0x7405 */
        {8,	0}, 	/* 0x7406 */
        {8,	0}, 	/* 0x7407 */
        {8,	0}, 	/* 0x7408 */
        {8,	0}, 	/* 0x7409 */
        {8,	0}, 	/* 0x740a */
        {8,	0}, 	/* 0x740b */
        {8,	0}, 	/* 0x740c */
        {8,	0}, 	/* 0x740d */
        {8,	0}, 	/* 0x740e */
        {8,	0}, 	/* 0x740f */
        {8,	0}, 	/* 0x7410 */
        {8,	0}, 	/* 0x7411 */
        {8,	0}, 	/* 0x7412 */
        {8,	0}, 	/* 0x7413 */
        {8,	0}, 	/* 0x7414 */
        {8,	0}, 	/* 0x7415 */
        {8,	0}, 	/* 0x7416 */
        {8,	0}, 	/* 0x7417 */
        {8,	0}, 	/* 0x7418 */
        {8,	0}, 	/* 0x7419 */
        {8,	0}, 	/* 0x741a */
        {8,	0}, 	/* 0x741b */
        {8,	0}, 	/* 0x741c */
        {8,	0}, 	/* 0x741d */
        {8,	0}, 	/* 0x741e */
        {8,	0}, 	/* 0x741f */
        {8,	0}, 	/* 0x7420 */
        {8,	0}, 	/* 0x7421 */
        {8,	0}, 	/* 0x7422 */
        {8,	0}, 	/* 0x7423 */
        {8,	0}, 	/* 0x7424 */
        {8,	0}, 	/* 0x7425 */
        {8,	0}, 	/* 0x7426 */
        {8,	0}, 	/* 0x7427 */
        {8,	0}, 	/* 0x7428 */
        {8,	0}, 	/* 0x7429 */
        {8,	0}, 	/* 0x742a */
        {8,	0}, 	/* 0x742b */
        {8,	0}, 	/* 0x742c */
        {8,	0}, 	/* 0x742d */
        {8,	0}, 	/* 0x742e */
        {8,	0}, 	/* 0x742f */
        {8,	0}, 	/* 0x7430 */
        {8,	0}, 	/* 0x7431 */
        {8,	0}, 	/* 0x7432 */
        {8,	0}, 	/* 0x7433 */
        {8,	0}, 	/* 0x7434 */
        {8,	0}, 	/* 0x7435 */
        {8,	0}, 	/* 0x7436 */
        {8,	0}, 	/* 0x7437 */
        {8,	0}, 	/* 0x7438 */
        {8,	0}, 	/* 0x7439 */
        {8,	0}, 	/* 0x743a */
        {8,	0}, 	/* 0x743b */
        {8,	0}, 	/* 0x743c */
        {8,	0}, 	/* 0x743d */
        {8,	0}, 	/* 0x743e */
        {8,	0}, 	/* 0x743f */
        {8,	0}, 	/* 0x7440 */
        {8,	0}, 	/* 0x7441 */
        {8,	0}, 	/* 0x7442 */
        {8,	0}, 	/* 0x7443 */
        {8,	0}, 	/* 0x7444 */
        {8,	0}, 	/* 0x7445 */
        {8,	0}, 	/* 0x7446 */
        {8,	0}, 	/* 0x7447 */
        {8,	0}, 	/* 0x7448 */
        {8,	0}, 	/* 0x7449 */
        {8,	0}, 	/* 0x744a */
        {8,	0}, 	/* 0x744b */
        {8,	0}, 	/* 0x744c */
        {8,	0}, 	/* 0x744d */
        {8,	0}, 	/* 0x744e */
        {8,	0}, 	/* 0x744f */
        {8,	0}, 	/* 0x7450 */
        {8,	0}, 	/* 0x7451 */
        {8,	0}, 	/* 0x7452 */
        {8,	0}, 	/* 0x7453 */
        {8,	0}, 	/* 0x7454 */
        {8,	0}, 	/* 0x7455 */
        {8,	0}, 	/* 0x7456 */
        {8,	0}, 	/* 0x7457 */
        {8,	0}, 	/* 0x7458 */
        {8,	0}, 	/* 0x7459 */
        {8,	0}, 	/* 0x745a */
        {8,	0}, 	/* 0x745b */
        {8,	0}, 	/* 0x745c */
        {8,	0}, 	/* 0x745d */
        {8,	0}, 	/* 0x745e */
        {8,	0}, 	/* 0x745f */
        {8,	0}, 	/* 0x7460 */
        {8,	0}, 	/* 0x7461 */
        {8,	0}, 	/* 0x7462 */
        {8,	0}, 	/* 0x7463 */
        {8,	0}, 	/* 0x7464 */
        {8,	0}, 	/* 0x7465 */
        {8,	0}, 	/* 0x7466 */
        {8,	0}, 	/* 0x7467 */
        {8,	0}, 	/* 0x7468 */
        {8,	0}, 	/* 0x7469 */
        {8,	0}, 	/* 0x746a */
        {8,	0}, 	/* 0x746b */
        {8,	0}, 	/* 0x746c */
        {8,	0}, 	/* 0x746d */
        {8,	0}, 	/* 0x746e */
        {8,	0}, 	/* 0x746f */
        {8,	0}, 	/* 0x7470 */
        {8,	0}, 	/* 0x7471 */
        {8,	0}, 	/* 0x7472 */
        {8,	0}, 	/* 0x7473 */
        {8,	0}, 	/* 0x7474 */
        {8,	0}, 	/* 0x7475 */
        {8,	0}, 	/* 0x7476 */
        {8,	0}, 	/* 0x7477 */
        {8,	0}, 	/* 0x7478 */
        {8,	0}, 	/* 0x7479 */
        {8,	0}, 	/* 0x747a */
        {8,	0}, 	/* 0x747b */
        {8,	0}, 	/* 0x747c */
        {8,	0}, 	/* 0x747d */
        {8,	0}, 	/* 0x747e */
        {8,	0}, 	/* 0x747f */
        {8,	0}, 	/* 0x7480 */
        {8,	0}, 	/* 0x7481 */
        {8,	0}, 	/* 0x7482 */
        {8,	0}, 	/* 0x7483 */
        {8,	0}, 	/* 0x7484 */
        {8,	0}, 	/* 0x7485 */
        {8,	0}, 	/* 0x7486 */
        {8,	0}, 	/* 0x7487 */
        {8,	0}, 	/* 0x7488 */
        {8,	0}, 	/* 0x7489 */
        {8,	0}, 	/* 0x748a */
        {8,	0}, 	/* 0x748b */
        {8,	0}, 	/* 0x748c */
        {8,	0}, 	/* 0x748d */
        {8,	0}, 	/* 0x748e */
        {8,	0}, 	/* 0x748f */
        {8,	0}, 	/* 0x7490 */
        {8,	0}, 	/* 0x7491 */
        {8,	0}, 	/* 0x7492 */
        {8,	0}, 	/* 0x7493 */
        {8,	0}, 	/* 0x7494 */
        {8,	0}, 	/* 0x7495 */
        {8,	0}, 	/* 0x7496 */
        {8,	0}, 	/* 0x7497 */
        {8,	0}, 	/* 0x7498 */
        {8,	0}, 	/* 0x7499 */
        {8,	0}, 	/* 0x749a */
        {8,	0}, 	/* 0x749b */
        {8,	0}, 	/* 0x749c */
        {8,	0}, 	/* 0x749d */
        {8,	0}, 	/* 0x749e */
        {8,	0}, 	/* 0x749f */
        {8,	0}, 	/* 0x74a0 */
        {8,	0}, 	/* 0x74a1 */
        {8,	0}, 	/* 0x74a2 */
        {8,	0}, 	/* 0x74a3 */
        {8,	0}, 	/* 0x74a4 */
        {8,	0}, 	/* 0x74a5 */
        {8,	0}, 	/* 0x74a6 */
        {8,	0}, 	/* 0x74a7 */
        {8,	0}, 	/* 0x74a8 */
        {8,	0}, 	/* 0x74a9 */
        {8,	0}, 	/* 0x74aa */
        {8,	0}, 	/* 0x74ab */
        {8,	0}, 	/* 0x74ac */
        {8,	0}, 	/* 0x74ad */
        {8,	0}, 	/* 0x74ae */
        {8,	0}, 	/* 0x74af */
        {8,	0}, 	/* 0x74b0 */
        {8,	0}, 	/* 0x74b1 */
        {8,	0}, 	/* 0x74b2 */
        {8,	0}, 	/* 0x74b3 */
        {8,	0}, 	/* 0x74b4 */
        {8,	0}, 	/* 0x74b5 */
        {8,	0}, 	/* 0x74b6 */
        {8,	0}, 	/* 0x74b7 */
        {8,	0}, 	/* 0x74b8 */
        {8,	0}, 	/* 0x74b9 */
        {8,	0}, 	/* 0x74ba */
        {8,	0}, 	/* 0x74bb */
        {8,	0}, 	/* 0x74bc */
        {8,	0}, 	/* 0x74bd */
        {8,	0}, 	/* 0x74be */
        {8,	0}, 	/* 0x74bf */
        {8,	0}, 	/* 0x74c0 */
        {8,	0}, 	/* 0x74c1 */
        {8,	0}, 	/* 0x74c2 */
        {8,	0}, 	/* 0x74c3 */
        {8,	0}, 	/* 0x74c4 */
        {8,	0}, 	/* 0x74c5 */
        {8,	0}, 	/* 0x74c6 */
        {8,	0}, 	/* 0x74c7 */
        {8,	0}, 	/* 0x74c8 */
        {8,	0}, 	/* 0x74c9 */
        {8,	0}, 	/* 0x74ca */
        {8,	0}, 	/* 0x74cb */
        {8,	0}, 	/* 0x74cc */
        {8,	0}, 	/* 0x74cd */
        {8,	0}, 	/* 0x74ce */
        {8,	0}, 	/* 0x74cf */
        {8,	0}, 	/* 0x74d0 */
        {8,	0}, 	/* 0x74d1 */
        {8,	0}, 	/* 0x74d2 */
        {8,	0}, 	/* 0x74d3 */
        {8,	0}, 	/* 0x74d4 */
        {8,	0}, 	/* 0x74d5 */
        {8,	0}, 	/* 0x74d6 */
        {8,	0}, 	/* 0x74d7 */
        {8,	0}, 	/* 0x74d8 */
        {8,	0}, 	/* 0x74d9 */
        {8,	0}, 	/* 0x74da */
        {8,	0}, 	/* 0x74db */
        {8,	0}, 	/* 0x74dc */
        {8,	0}, 	/* 0x74dd */
        {8,	0}, 	/* 0x74de */
        {8,	0}, 	/* 0x74df */
        {8,	0}, 	/* 0x74e0 */
        {8,	0}, 	/* 0x74e1 */
        {8,	0}, 	/* 0x74e2 */
        {8,	0}, 	/* 0x74e3 */
        {8,	0}, 	/* 0x74e4 */
        {8,	0}, 	/* 0x74e5 */
        {8,	0}, 	/* 0x74e6 */
        {8,	0}, 	/* 0x74e7 */
        {8,	0}, 	/* 0x74e8 */
        {8,	0}, 	/* 0x74e9 */
        {8,	0}, 	/* 0x74ea */
        {8,	0}, 	/* 0x74eb */
        {8,	0}, 	/* 0x74ec */
        {8,	0}, 	/* 0x74ed */
        {8,	0}, 	/* 0x74ee */
        {8,	0}, 	/* 0x74ef */
        {8,	0}, 	/* 0x74f0 */
        {8,	0}, 	/* 0x74f1 */
        {8,	0}, 	/* 0x74f2 */
        {8,	0}, 	/* 0x74f3 */
        {8,	0}, 	/* 0x74f4 */
        {8,	0}, 	/* 0x74f5 */
        {8,	0}, 	/* 0x74f6 */
        {8,	0}, 	/* 0x74f7 */
        {8,	0}, 	/* 0x74f8 */
        {8,	0}, 	/* 0x74f9 */
        {8,	0}, 	/* 0x74fa */
        {8,	0}, 	/* 0x74fb */
        {8,	0}, 	/* 0x74fc */
        {8,	0}, 	/* 0x74fd */
        {8,	0}, 	/* 0x74fe */
        {8,	0}, 	/* 0x74ff */
        {8,	0}, 	/* 0x7500 */
        {8,	0}, 	/* 0x7501 */
        {8,	0}, 	/* 0x7502 */
        {8,	0}, 	/* 0x7503 */
        {8,	0}, 	/* 0x7504 */
        {8,	0}, 	/* 0x7505 */
        {8,	0}, 	/* 0x7506 */
        {8,	0}, 	/* 0x7507 */
        {8,	0}, 	/* 0x7508 */
        {8,	0}, 	/* 0x7509 */
        {8,	0}, 	/* 0x750a */
        {8,	0}, 	/* 0x750b */
        {8,	0}, 	/* 0x750c */
        {8,	0}, 	/* 0x750d */
        {8,	0}, 	/* 0x750e */
        {8,	0}, 	/* 0x750f */
        {8,	0}, 	/* 0x7510 */
        {8,	0}, 	/* 0x7511 */
        {8,	0}, 	/* 0x7512 */
        {8,	0}, 	/* 0x7513 */
        {8,	0}, 	/* 0x7514 */
        {8,	0}, 	/* 0x7515 */
        {8,	0}, 	/* 0x7516 */
        {8,	0}, 	/* 0x7517 */
        {8,	0}, 	/* 0x7518 */
        {8,	0}, 	/* 0x7519 */
        {8,	0}, 	/* 0x751a */
        {8,	0}, 	/* 0x751b */
        {8,	0}, 	/* 0x751c */
        {8,	0}, 	/* 0x751d */
        {8,	0}, 	/* 0x751e */
        {8,	0}, 	/* 0x751f */
        {8,	0}, 	/* 0x7520 */
        {8,	0}, 	/* 0x7521 */
        {8,	0}, 	/* 0x7522 */
        {8,	0}, 	/* 0x7523 */
        {8,	0}, 	/* 0x7524 */
        {8,	0}, 	/* 0x7525 */
        {8,	0}, 	/* 0x7526 */
        {8,	0}, 	/* 0x7527 */
        {8,	0}, 	/* 0x7528 */
        {8,	0}, 	/* 0x7529 */
        {8,	0}, 	/* 0x752a */
        {8,	0}, 	/* 0x752b */
        {8,	0}, 	/* 0x752c */
        {8,	0}, 	/* 0x752d */
        {8,	0}, 	/* 0x752e */
        {8,	0}, 	/* 0x752f */
        {8,	0}, 	/* 0x7530 */
        {8,	0}, 	/* 0x7531 */
        {8,	0}, 	/* 0x7532 */
        {8,	0}, 	/* 0x7533 */
        {8,	0}, 	/* 0x7534 */
        {8,	0}, 	/* 0x7535 */
        {8,	0}, 	/* 0x7536 */
        {8,	0}, 	/* 0x7537 */
        {8,	0}, 	/* 0x7538 */
        {8,	0}, 	/* 0x7539 */
        {8,	0}, 	/* 0x753a */
        {8,	0}, 	/* 0x753b */
        {8,	0}, 	/* 0x753c */
        {8,	0}, 	/* 0x753d */
        {8,	0}, 	/* 0x753e */
        {8,	0}, 	/* 0x753f */
        {8,	0}, 	/* 0x7540 */
        {8,	0}, 	/* 0x7541 */
        {8,	0}, 	/* 0x7542 */
        {8,	0}, 	/* 0x7543 */
        {8,	0}, 	/* 0x7544 */
        {8,	0}, 	/* 0x7545 */
        {8,	0}, 	/* 0x7546 */
        {8,	0}, 	/* 0x7547 */
        {8,	0}, 	/* 0x7548 */
        {8,	0}, 	/* 0x7549 */
        {8,	0}, 	/* 0x754a */
        {8,	0}, 	/* 0x754b */
        {8,	0}, 	/* 0x754c */
        {8,	0}, 	/* 0x754d */
        {8,	0}, 	/* 0x754e */
        {8,	0}, 	/* 0x754f */
        {8,	0}, 	/* 0x7550 */
        {8,	0}, 	/* 0x7551 */
        {8,	0}, 	/* 0x7552 */
        {8,	0}, 	/* 0x7553 */
        {8,	0}, 	/* 0x7554 */
        {8,	0}, 	/* 0x7555 */
        {8,	0}, 	/* 0x7556 */
        {8,	0}, 	/* 0x7557 */
        {8,	0}, 	/* 0x7558 */
        {8,	0}, 	/* 0x7559 */
        {8,	0}, 	/* 0x755a */
        {8,	0}, 	/* 0x755b */
        {8,	0}, 	/* 0x755c */
        {8,	0}, 	/* 0x755d */
        {8,	0}, 	/* 0x755e */
        {8,	0}, 	/* 0x755f */
        {8,	0}, 	/* 0x7560 */
        {8,	0}, 	/* 0x7561 */
        {8,	0}, 	/* 0x7562 */
        {8,	0}, 	/* 0x7563 */
        {8,	0}, 	/* 0x7564 */
        {8,	0}, 	/* 0x7565 */
        {8,	0}, 	/* 0x7566 */
        {8,	0}, 	/* 0x7567 */
        {8,	0}, 	/* 0x7568 */
        {8,	0}, 	/* 0x7569 */
        {8,	0}, 	/* 0x756a */
        {8,	0}, 	/* 0x756b */
        {8,	0}, 	/* 0x756c */
        {8,	0}, 	/* 0x756d */
        {8,	0}, 	/* 0x756e */
        {8,	0}, 	/* 0x756f */
        {8,	0}, 	/* 0x7570 */
        {8,	0}, 	/* 0x7571 */
        {8,	0}, 	/* 0x7572 */
        {8,	0}, 	/* 0x7573 */
        {8,	0}, 	/* 0x7574 */
        {8,	0}, 	/* 0x7575 */
        {8,	0}, 	/* 0x7576 */
        {8,	0}, 	/* 0x7577 */
        {8,	0}, 	/* 0x7578 */
        {8,	0}, 	/* 0x7579 */
        {8,	0}, 	/* 0x757a */
        {8,	0}, 	/* 0x757b */
        {8,	0}, 	/* 0x757c */
        {8,	0}, 	/* 0x757d */
        {8,	0}, 	/* 0x757e */
        {8,	0}, 	/* 0x757f */
        {8,	0}, 	/* 0x7580 */
        {8,	0}, 	/* 0x7581 */
        {8,	0}, 	/* 0x7582 */
        {8,	0}, 	/* 0x7583 */
        {8,	0}, 	/* 0x7584 */
        {8,	0}, 	/* 0x7585 */
        {8,	0}, 	/* 0x7586 */
        {8,	0}, 	/* 0x7587 */
        {8,	0}, 	/* 0x7588 */
        {8,	0}, 	/* 0x7589 */
        {8,	0}, 	/* 0x758a */
        {8,	0}, 	/* 0x758b */
        {8,	0}, 	/* 0x758c */
        {8,	0}, 	/* 0x758d */
        {8,	0}, 	/* 0x758e */
        {8,	0}, 	/* 0x758f */
        {8,	0}, 	/* 0x7590 */
        {8,	0}, 	/* 0x7591 */
        {8,	0}, 	/* 0x7592 */
        {8,	0}, 	/* 0x7593 */
        {8,	0}, 	/* 0x7594 */
        {8,	0}, 	/* 0x7595 */
        {8,	0}, 	/* 0x7596 */
        {8,	0}, 	/* 0x7597 */
        {8,	0}, 	/* 0x7598 */
        {8,	0}, 	/* 0x7599 */
        {8,	0}, 	/* 0x759a */
        {8,	0}, 	/* 0x759b */
        {8,	0}, 	/* 0x759c */
        {8,	0}, 	/* 0x759d */
        {8,	0}, 	/* 0x759e */
        {8,	0}, 	/* 0x759f */
        {8,	0}, 	/* 0x75a0 */
        {8,	0}, 	/* 0x75a1 */
        {8,	0}, 	/* 0x75a2 */
        {8,	0}, 	/* 0x75a3 */
        {8,	0}, 	/* 0x75a4 */
        {8,	0}, 	/* 0x75a5 */
        {8,	0}, 	/* 0x75a6 */
        {8,	0}, 	/* 0x75a7 */
        {8,	0}, 	/* 0x75a8 */
        {8,	0}, 	/* 0x75a9 */
        {8,	0}, 	/* 0x75aa */
        {8,	0}, 	/* 0x75ab */
        {8,	0}, 	/* 0x75ac */
        {8,	0}, 	/* 0x75ad */
        {8,	0}, 	/* 0x75ae */
        {8,	0}, 	/* 0x75af */
        {8,	0}, 	/* 0x75b0 */
        {8,	0}, 	/* 0x75b1 */
        {8,	0}, 	/* 0x75b2 */
        {8,	0}, 	/* 0x75b3 */
        {8,	0}, 	/* 0x75b4 */
        {8,	0}, 	/* 0x75b5 */
        {8,	0}, 	/* 0x75b6 */
        {8,	0}, 	/* 0x75b7 */
        {8,	0}, 	/* 0x75b8 */
        {8,	0}, 	/* 0x75b9 */
        {8,	0}, 	/* 0x75ba */
        {8,	0}, 	/* 0x75bb */
        {8,	0}, 	/* 0x75bc */
        {8,	0}, 	/* 0x75bd */
        {8,	0}, 	/* 0x75be */
        {8,	0}, 	/* 0x75bf */
        {8,	0}, 	/* 0x75c0 */
        {8,	0}, 	/* 0x75c1 */
        {8,	0}, 	/* 0x75c2 */
        {8,	0}, 	/* 0x75c3 */
        {8,	0}, 	/* 0x75c4 */
        {8,	0}, 	/* 0x75c5 */
        {8,	0}, 	/* 0x75c6 */
        {8,	0}, 	/* 0x75c7 */
        {8,	0}, 	/* 0x75c8 */
        {8,	0}, 	/* 0x75c9 */
        {8,	0}, 	/* 0x75ca */
        {8,	0}, 	/* 0x75cb */
        {8,	0}, 	/* 0x75cc */
        {8,	0}, 	/* 0x75cd */
        {8,	0}, 	/* 0x75ce */
        {8,	0}, 	/* 0x75cf */
        {8,	0}, 	/* 0x75d0 */
        {8,	0}, 	/* 0x75d1 */
        {8,	0}, 	/* 0x75d2 */
        {8,	0}, 	/* 0x75d3 */
        {8,	0}, 	/* 0x75d4 */
        {8,	0}, 	/* 0x75d5 */
        {8,	0}, 	/* 0x75d6 */
        {8,	0}, 	/* 0x75d7 */
        {8,	0}, 	/* 0x75d8 */
        {8,	0}, 	/* 0x75d9 */
        {8,	0}, 	/* 0x75da */
        {8,	0}, 	/* 0x75db */
        {8,	0}, 	/* 0x75dc */
        {8,	0}, 	/* 0x75dd */
        {8,	0}, 	/* 0x75de */
        {8,	0}, 	/* 0x75df */
        {8,	0}, 	/* 0x75e0 */
        {8,	0}, 	/* 0x75e1 */
        {8,	0}, 	/* 0x75e2 */
        {8,	0}, 	/* 0x75e3 */
        {8,	0}, 	/* 0x75e4 */
        {8,	0}, 	/* 0x75e5 */
        {8,	0}, 	/* 0x75e6 */
        {8,	0}, 	/* 0x75e7 */
        {8,	0}, 	/* 0x75e8 */
        {8,	0}, 	/* 0x75e9 */
        {8,	0}, 	/* 0x75ea */
        {8,	0}, 	/* 0x75eb */
        {8,	0}, 	/* 0x75ec */
        {8,	0}, 	/* 0x75ed */
        {8,	0}, 	/* 0x75ee */
        {8,	0}, 	/* 0x75ef */
        {8,	0}, 	/* 0x75f0 */
        {8,	0}, 	/* 0x75f1 */
        {8,	0}, 	/* 0x75f2 */
        {8,	0}, 	/* 0x75f3 */
        {8,	0}, 	/* 0x75f4 */
        {8,	0}, 	/* 0x75f5 */
        {8,	0}, 	/* 0x75f6 */
        {8,	0}, 	/* 0x75f7 */
        {8,	0}, 	/* 0x75f8 */
        {8,	0}, 	/* 0x75f9 */
        {8,	0}, 	/* 0x75fa */
        {8,	0}, 	/* 0x75fb */
        {8,	0}, 	/* 0x75fc */
        {8,	0}, 	/* 0x75fd */
        {8,	0}, 	/* 0x75fe */
        {8,	0}, 	/* 0x75ff */
        {8,	0}, 	/* 0x7600 */
        {8,	0}, 	/* 0x7601 */
        {8,	0}, 	/* 0x7602 */
        {8,	0}, 	/* 0x7603 */
        {8,	0}, 	/* 0x7604 */
        {8,	0}, 	/* 0x7605 */
        {8,	0}, 	/* 0x7606 */
        {8,	0}, 	/* 0x7607 */
        {8,	0}, 	/* 0x7608 */
        {8,	0}, 	/* 0x7609 */
        {8,	0}, 	/* 0x760a */
        {8,	0}, 	/* 0x760b */
        {8,	0}, 	/* 0x760c */
        {8,	0}, 	/* 0x760d */
        {8,	0}, 	/* 0x760e */
        {8,	0}, 	/* 0x760f */
        {8,	0}, 	/* 0x7610 */
        {8,	0}, 	/* 0x7611 */
        {8,	0}, 	/* 0x7612 */
        {8,	0}, 	/* 0x7613 */
        {8,	0}, 	/* 0x7614 */
        {8,	0}, 	/* 0x7615 */
        {8,	0}, 	/* 0x7616 */
        {8,	0}, 	/* 0x7617 */
        {8,	0}, 	/* 0x7618 */
        {8,	0}, 	/* 0x7619 */
        {8,	0}, 	/* 0x761a */
        {8,	0}, 	/* 0x761b */
        {8,	0}, 	/* 0x761c */
        {8,	0}, 	/* 0x761d */
        {8,	0}, 	/* 0x761e */
        {8,	0}, 	/* 0x761f */
        {8,	0}, 	/* 0x7620 */
        {8,	0}, 	/* 0x7621 */
        {8,	0}, 	/* 0x7622 */
        {8,	0}, 	/* 0x7623 */
        {8,	0}, 	/* 0x7624 */
        {8,	0}, 	/* 0x7625 */
        {8,	0}, 	/* 0x7626 */
        {8,	0}, 	/* 0x7627 */
        {8,	0}, 	/* 0x7628 */
        {8,	0}, 	/* 0x7629 */
        {8,	0}, 	/* 0x762a */
        {8,	0}, 	/* 0x762b */
        {8,	0}, 	/* 0x762c */
        {8,	0}, 	/* 0x762d */
        {8,	0}, 	/* 0x762e */
        {8,	0}, 	/* 0x762f */
        {8,	0}, 	/* 0x7630 */
        {8,	0}, 	/* 0x7631 */
        {8,	0}, 	/* 0x7632 */
        {8,	0}, 	/* 0x7633 */
        {8,	0}, 	/* 0x7634 */
        {8,	0}, 	/* 0x7635 */
        {8,	0}, 	/* 0x7636 */
        {8,	0}, 	/* 0x7637 */
        {8,	0}, 	/* 0x7638 */
        {8,	0}, 	/* 0x7639 */
        {8,	0}, 	/* 0x763a */
        {8,	0}, 	/* 0x763b */
        {8,	0}, 	/* 0x763c */
        {8,	0}, 	/* 0x763d */
        {8,	0}, 	/* 0x763e */
        {8,	0}, 	/* 0x763f */
        {8,	0}, 	/* 0x7640 */
        {8,	0}, 	/* 0x7641 */
        {8,	0}, 	/* 0x7642 */
        {8,	0}, 	/* 0x7643 */
        {8,	0}, 	/* 0x7644 */
        {8,	0}, 	/* 0x7645 */
        {8,	0}, 	/* 0x7646 */
        {8,	0}, 	/* 0x7647 */
        {8,	0}, 	/* 0x7648 */
        {8,	0}, 	/* 0x7649 */
        {8,	0}, 	/* 0x764a */
        {8,	0}, 	/* 0x764b */
        {8,	0}, 	/* 0x764c */
        {8,	0}, 	/* 0x764d */
        {8,	0}, 	/* 0x764e */
        {8,	0}, 	/* 0x764f */
        {8,	0}, 	/* 0x7650 */
        {8,	0}, 	/* 0x7651 */
        {8,	0}, 	/* 0x7652 */
        {8,	0}, 	/* 0x7653 */
        {8,	0}, 	/* 0x7654 */
        {8,	0}, 	/* 0x7655 */
        {8,	0}, 	/* 0x7656 */
        {8,	0}, 	/* 0x7657 */
        {8,	0}, 	/* 0x7658 */
        {8,	0}, 	/* 0x7659 */
        {8,	0}, 	/* 0x765a */
        {8,	0}, 	/* 0x765b */
        {8,	0}, 	/* 0x765c */
        {8,	0}, 	/* 0x765d */
        {8,	0}, 	/* 0x765e */
        {8,	0}, 	/* 0x765f */
        {8,	0}, 	/* 0x7660 */
        {8,	0}, 	/* 0x7661 */
        {8,	0}, 	/* 0x7662 */
        {8,	0}, 	/* 0x7663 */
        {8,	0}, 	/* 0x7664 */
        {8,	0}, 	/* 0x7665 */
        {8,	0}, 	/* 0x7666 */
        {8,	0}, 	/* 0x7667 */
        {8,	0}, 	/* 0x7668 */
        {8,	0}, 	/* 0x7669 */
        {8,	0}, 	/* 0x766a */
        {8,	0}, 	/* 0x766b */
        {8,	0}, 	/* 0x766c */
        {8,	0}, 	/* 0x766d */
        {8,	0}, 	/* 0x766e */
        {8,	0}, 	/* 0x766f */
        {8,	0}, 	/* 0x7670 */
        {8,	0}, 	/* 0x7671 */
        {8,	0}, 	/* 0x7672 */
        {8,	0}, 	/* 0x7673 */
        {8,	0}, 	/* 0x7674 */
        {8,	0}, 	/* 0x7675 */
        {8,	0}, 	/* 0x7676 */
        {8,	0}, 	/* 0x7677 */
        {8,	0}, 	/* 0x7678 */
        {8,	0}, 	/* 0x7679 */
        {8,	0}, 	/* 0x767a */
        {8,	0}, 	/* 0x767b */
        {8,	0}, 	/* 0x767c */
        {8,	0}, 	/* 0x767d */
        {8,	0}, 	/* 0x767e */
        {8,	0}, 	/* 0x767f */
        {8,	0}, 	/* 0x7680 */
        {8,	0}, 	/* 0x7681 */
        {8,	0}, 	/* 0x7682 */
        {8,	0}, 	/* 0x7683 */
        {8,	0}, 	/* 0x7684 */
        {8,	0}, 	/* 0x7685 */
        {8,	0}, 	/* 0x7686 */
        {8,	0}, 	/* 0x7687 */
        {8,	0}, 	/* 0x7688 */
        {8,	0}, 	/* 0x7689 */
        {8,	0}, 	/* 0x768a */
        {8,	0}, 	/* 0x768b */
        {8,	0}, 	/* 0x768c */
        {8,	0}, 	/* 0x768d */
        {8,	0}, 	/* 0x768e */
        {8,	0}, 	/* 0x768f */
        {8,	0}, 	/* 0x7690 */
        {8,	0}, 	/* 0x7691 */
        {8,	0}, 	/* 0x7692 */
        {8,	0}, 	/* 0x7693 */
        {8,	0}, 	/* 0x7694 */
        {8,	0}, 	/* 0x7695 */
        {8,	0}, 	/* 0x7696 */
        {8,	0}, 	/* 0x7697 */
        {8,	0}, 	/* 0x7698 */
        {8,	0}, 	/* 0x7699 */
        {8,	0}, 	/* 0x769a */
        {8,	0}, 	/* 0x769b */
        {8,	0}, 	/* 0x769c */
        {8,	0}, 	/* 0x769d */
        {8,	0}, 	/* 0x769e */
        {8,	0}, 	/* 0x769f */
        {8,	0}, 	/* 0x76a0 */
        {8,	0}, 	/* 0x76a1 */
        {8,	0}, 	/* 0x76a2 */
        {8,	0}, 	/* 0x76a3 */
        {8,	0}, 	/* 0x76a4 */
        {8,	0}, 	/* 0x76a5 */
        {8,	0}, 	/* 0x76a6 */
        {8,	0}, 	/* 0x76a7 */
        {8,	0}, 	/* 0x76a8 */
        {8,	0}, 	/* 0x76a9 */
        {8,	0}, 	/* 0x76aa */
        {8,	0}, 	/* 0x76ab */
        {8,	0}, 	/* 0x76ac */
        {8,	0}, 	/* 0x76ad */
        {8,	0}, 	/* 0x76ae */
        {8,	0}, 	/* 0x76af */
        {8,	0}, 	/* 0x76b0 */
        {8,	0}, 	/* 0x76b1 */
        {8,	0}, 	/* 0x76b2 */
        {8,	0}, 	/* 0x76b3 */
        {8,	0}, 	/* 0x76b4 */
        {8,	0}, 	/* 0x76b5 */
        {8,	0}, 	/* 0x76b6 */
        {8,	0}, 	/* 0x76b7 */
        {8,	0}, 	/* 0x76b8 */
        {8,	0}, 	/* 0x76b9 */
        {8,	0}, 	/* 0x76ba */
        {8,	0}, 	/* 0x76bb */
        {8,	0}, 	/* 0x76bc */
        {8,	0}, 	/* 0x76bd */
        {8,	0}, 	/* 0x76be */
        {8,	0}, 	/* 0x76bf */
        {8,	0}, 	/* 0x76c0 */
        {8,	0}, 	/* 0x76c1 */
        {8,	0}, 	/* 0x76c2 */
        {8,	0}, 	/* 0x76c3 */
        {8,	0}, 	/* 0x76c4 */
        {8,	0}, 	/* 0x76c5 */
        {8,	0}, 	/* 0x76c6 */
        {8,	0}, 	/* 0x76c7 */
        {8,	0}, 	/* 0x76c8 */
        {8,	0}, 	/* 0x76c9 */
        {8,	0}, 	/* 0x76ca */
        {8,	0}, 	/* 0x76cb */
        {8,	0}, 	/* 0x76cc */
        {8,	0}, 	/* 0x76cd */
        {8,	0}, 	/* 0x76ce */
        {8,	0}, 	/* 0x76cf */
        {8,	0}, 	/* 0x76d0 */
        {8,	0}, 	/* 0x76d1 */
        {8,	0}, 	/* 0x76d2 */
        {8,	0}, 	/* 0x76d3 */
        {8,	0}, 	/* 0x76d4 */
        {8,	0}, 	/* 0x76d5 */
        {8,	0}, 	/* 0x76d6 */
        {8,	0}, 	/* 0x76d7 */
        {8,	0}, 	/* 0x76d8 */
        {8,	0}, 	/* 0x76d9 */
        {8,	0}, 	/* 0x76da */
        {8,	0}, 	/* 0x76db */
        {8,	0}, 	/* 0x76dc */
        {8,	0}, 	/* 0x76dd */
        {8,	0}, 	/* 0x76de */
        {8,	0}, 	/* 0x76df */
        {8,	0}, 	/* 0x76e0 */
        {8,	0}, 	/* 0x76e1 */
        {8,	0}, 	/* 0x76e2 */
        {8,	0}, 	/* 0x76e3 */
        {8,	0}, 	/* 0x76e4 */
        {8,	0}, 	/* 0x76e5 */
        {8,	0}, 	/* 0x76e6 */
        {8,	0}, 	/* 0x76e7 */
        {8,	0}, 	/* 0x76e8 */
        {8,	0}, 	/* 0x76e9 */
        {8,	0}, 	/* 0x76ea */
        {8,	0}, 	/* 0x76eb */
        {8,	0}, 	/* 0x76ec */
        {8,	0}, 	/* 0x76ed */
        {8,	0}, 	/* 0x76ee */
        {8,	0}, 	/* 0x76ef */
        {8,	0}, 	/* 0x76f0 */
        {8,	0}, 	/* 0x76f1 */
        {8,	0}, 	/* 0x76f2 */
        {8,	0}, 	/* 0x76f3 */
        {8,	0}, 	/* 0x76f4 */
        {8,	0}, 	/* 0x76f5 */
        {8,	0}, 	/* 0x76f6 */
        {8,	0}, 	/* 0x76f7 */
        {8,	0}, 	/* 0x76f8 */
        {8,	0}, 	/* 0x76f9 */
        {8,	0}, 	/* 0x76fa */
        {8,	0}, 	/* 0x76fb */
        {8,	0}, 	/* 0x76fc */
        {8,	0}, 	/* 0x76fd */
        {8,	0}, 	/* 0x76fe */
        {8,	0}, 	/* 0x76ff */
        {8,	0}, 	/* 0x7700 */
        {8,	0}, 	/* 0x7701 */
        {8,	0}, 	/* 0x7702 */
        {8,	0}, 	/* 0x7703 */
        {8,	0}, 	/* 0x7704 */
        {8,	0}, 	/* 0x7705 */
        {8,	0}, 	/* 0x7706 */
        {8,	0}, 	/* 0x7707 */
        {8,	0}, 	/* 0x7708 */
        {8,	0}, 	/* 0x7709 */
        {8,	0}, 	/* 0x770a */
        {8,	0}, 	/* 0x770b */
        {8,	0}, 	/* 0x770c */
        {8,	0}, 	/* 0x770d */
        {8,	0}, 	/* 0x770e */
        {8,	0}, 	/* 0x770f */
        {8,	0}, 	/* 0x7710 */
        {8,	0}, 	/* 0x7711 */
        {8,	0}, 	/* 0x7712 */
        {8,	0}, 	/* 0x7713 */
        {8,	0}, 	/* 0x7714 */
        {8,	0}, 	/* 0x7715 */
        {8,	0}, 	/* 0x7716 */
        {8,	0}, 	/* 0x7717 */
        {8,	0}, 	/* 0x7718 */
        {8,	0}, 	/* 0x7719 */
        {8,	0}, 	/* 0x771a */
        {8,	0}, 	/* 0x771b */
        {8,	0}, 	/* 0x771c */
        {8,	0}, 	/* 0x771d */
        {8,	0}, 	/* 0x771e */
        {8,	0}, 	/* 0x771f */
        {8,	0}, 	/* 0x7720 */
        {8,	0}, 	/* 0x7721 */
        {8,	0}, 	/* 0x7722 */
        {8,	0}, 	/* 0x7723 */
        {8,	0}, 	/* 0x7724 */
        {8,	0}, 	/* 0x7725 */
        {8,	0}, 	/* 0x7726 */
        {8,	0}, 	/* 0x7727 */
        {8,	0}, 	/* 0x7728 */
        {8,	0}, 	/* 0x7729 */
        {8,	0}, 	/* 0x772a */
        {8,	0}, 	/* 0x772b */
        {8,	0}, 	/* 0x772c */
        {8,	0}, 	/* 0x772d */
        {8,	0}, 	/* 0x772e */
        {8,	0}, 	/* 0x772f */
        {8,	0}, 	/* 0x7730 */
        {8,	0}, 	/* 0x7731 */
        {8,	0}, 	/* 0x7732 */
        {8,	0}, 	/* 0x7733 */
        {8,	0}, 	/* 0x7734 */
        {8,	0}, 	/* 0x7735 */
        {8,	0}, 	/* 0x7736 */
        {8,	0}, 	/* 0x7737 */
        {8,	0}, 	/* 0x7738 */
        {8,	0}, 	/* 0x7739 */
        {8,	0}, 	/* 0x773a */
        {8,	0}, 	/* 0x773b */
        {8,	0}, 	/* 0x773c */
        {8,	0}, 	/* 0x773d */
        {8,	0}, 	/* 0x773e */
        {8,	0}, 	/* 0x773f */
        {8,	0}, 	/* 0x7740 */
        {8,	0}, 	/* 0x7741 */
        {8,	0}, 	/* 0x7742 */
        {8,	0}, 	/* 0x7743 */
        {8,	0}, 	/* 0x7744 */
        {8,	0}, 	/* 0x7745 */
        {8,	0}, 	/* 0x7746 */
        {8,	0}, 	/* 0x7747 */
        {8,	0}, 	/* 0x7748 */
        {8,	0}, 	/* 0x7749 */
        {8,	0}, 	/* 0x774a */
        {8,	0}, 	/* 0x774b */
        {8,	0}, 	/* 0x774c */
        {8,	0}, 	/* 0x774d */
        {8,	0}, 	/* 0x774e */
        {8,	0}, 	/* 0x774f */
        {8,	0}, 	/* 0x7750 */
        {8,	0}, 	/* 0x7751 */
        {8,	0}, 	/* 0x7752 */
        {8,	0}, 	/* 0x7753 */
        {8,	0}, 	/* 0x7754 */
        {8,	0}, 	/* 0x7755 */
        {8,	0}, 	/* 0x7756 */
        {8,	0}, 	/* 0x7757 */
        {8,	0}, 	/* 0x7758 */
        {8,	0}, 	/* 0x7759 */
        {8,	0}, 	/* 0x775a */
        {8,	0}, 	/* 0x775b */
        {8,	0}, 	/* 0x775c */
        {8,	0}, 	/* 0x775d */
        {8,	0}, 	/* 0x775e */
        {8,	0}, 	/* 0x775f */
        {8,	0}, 	/* 0x7760 */
        {8,	0}, 	/* 0x7761 */
        {8,	0}, 	/* 0x7762 */
        {8,	0}, 	/* 0x7763 */
        {8,	0}, 	/* 0x7764 */
        {8,	0}, 	/* 0x7765 */
        {8,	0}, 	/* 0x7766 */
        {8,	0}, 	/* 0x7767 */
        {8,	0}, 	/* 0x7768 */
        {8,	0}, 	/* 0x7769 */
        {8,	0}, 	/* 0x776a */
        {8,	0}, 	/* 0x776b */
        {8,	0}, 	/* 0x776c */
        {8,	0}, 	/* 0x776d */
        {8,	0}, 	/* 0x776e */
        {8,	0}, 	/* 0x776f */
        {8,	0}, 	/* 0x7770 */
        {8,	0}, 	/* 0x7771 */
        {8,	0}, 	/* 0x7772 */
        {8,	0}, 	/* 0x7773 */
        {8,	0}, 	/* 0x7774 */
        {8,	0}, 	/* 0x7775 */
        {8,	0}, 	/* 0x7776 */
        {8,	0}, 	/* 0x7777 */
        {8,	0}, 	/* 0x7778 */
        {8,	0}, 	/* 0x7779 */
        {8,	0}, 	/* 0x777a */
        {8,	0}, 	/* 0x777b */
        {8,	0}, 	/* 0x777c */
        {8,	0}, 	/* 0x777d */
        {8,	0}, 	/* 0x777e */
        {8,	0}, 	/* 0x777f */
        {8,	0}, 	/* 0x7780 */
        {8,	0}, 	/* 0x7781 */
        {8,	0}, 	/* 0x7782 */
        {8,	0}, 	/* 0x7783 */
        {8,	0}, 	/* 0x7784 */
        {8,	0}, 	/* 0x7785 */
        {8,	0}, 	/* 0x7786 */
        {8,	0}, 	/* 0x7787 */
        {8,	0}, 	/* 0x7788 */
        {8,	0}, 	/* 0x7789 */
        {8,	0}, 	/* 0x778a */
        {8,	0}, 	/* 0x778b */
        {8,	0}, 	/* 0x778c */
        {8,	0}, 	/* 0x778d */
        {8,	0}, 	/* 0x778e */
        {8,	0}, 	/* 0x778f */
        {8,	0}, 	/* 0x7790 */
        {8,	0}, 	/* 0x7791 */
        {8,	0}, 	/* 0x7792 */
        {8,	0}, 	/* 0x7793 */
        {8,	0}, 	/* 0x7794 */
        {8,	0}, 	/* 0x7795 */
        {8,	0}, 	/* 0x7796 */
        {8,	0}, 	/* 0x7797 */
        {8,	0}, 	/* 0x7798 */
        {8,	0}, 	/* 0x7799 */
        {8,	0}, 	/* 0x779a */
        {8,	0}, 	/* 0x779b */
        {8,	0}, 	/* 0x779c */
        {8,	0}, 	/* 0x779d */
        {8,	0}, 	/* 0x779e */
        {8,	0}, 	/* 0x779f */
        {8,	0}, 	/* 0x77a0 */
        {8,	0}, 	/* 0x77a1 */
        {8,	0}, 	/* 0x77a2 */
        {8,	0}, 	/* 0x77a3 */
        {8,	0}, 	/* 0x77a4 */
        {8,	0}, 	/* 0x77a5 */
        {8,	0}, 	/* 0x77a6 */
        {8,	0}, 	/* 0x77a7 */
        {8,	0}, 	/* 0x77a8 */
        {8,	0}, 	/* 0x77a9 */
        {8,	0}, 	/* 0x77aa */
        {8,	0}, 	/* 0x77ab */
        {8,	0}, 	/* 0x77ac */
        {8,	0}, 	/* 0x77ad */
        {8,	0}, 	/* 0x77ae */
        {8,	0}, 	/* 0x77af */
        {8,	0}, 	/* 0x77b0 */
        {8,	0}, 	/* 0x77b1 */
        {8,	0}, 	/* 0x77b2 */
        {8,	0}, 	/* 0x77b3 */
        {8,	0}, 	/* 0x77b4 */
        {8,	0}, 	/* 0x77b5 */
        {8,	0}, 	/* 0x77b6 */
        {8,	0}, 	/* 0x77b7 */
        {8,	0}, 	/* 0x77b8 */
        {8,	0}, 	/* 0x77b9 */
        {8,	0}, 	/* 0x77ba */
        {8,	0}, 	/* 0x77bb */
        {8,	0}, 	/* 0x77bc */
        {8,	0}, 	/* 0x77bd */
        {8,	0}, 	/* 0x77be */
        {8,	0}, 	/* 0x77bf */
        {8,	0}, 	/* 0x77c0 */
        {8,	0}, 	/* 0x77c1 */
        {8,	0}, 	/* 0x77c2 */
        {8,	0}, 	/* 0x77c3 */
        {8,	0}, 	/* 0x77c4 */
        {8,	0}, 	/* 0x77c5 */
        {8,	0}, 	/* 0x77c6 */
        {8,	0}, 	/* 0x77c7 */
        {8,	0}, 	/* 0x77c8 */
        {8,	0}, 	/* 0x77c9 */
        {8,	0}, 	/* 0x77ca */
        {8,	0}, 	/* 0x77cb */
        {8,	0}, 	/* 0x77cc */
        {8,	0}, 	/* 0x77cd */
        {8,	0}, 	/* 0x77ce */
        {8,	0}, 	/* 0x77cf */
        {8,	0}, 	/* 0x77d0 */
        {8,	0}, 	/* 0x77d1 */
        {8,	0}, 	/* 0x77d2 */
        {8,	0}, 	/* 0x77d3 */
        {8,	0}, 	/* 0x77d4 */
        {8,	0}, 	/* 0x77d5 */
        {8,	0}, 	/* 0x77d6 */
        {8,	0}, 	/* 0x77d7 */
        {8,	0}, 	/* 0x77d8 */
        {8,	0}, 	/* 0x77d9 */
        {8,	0}, 	/* 0x77da */
        {8,	0}, 	/* 0x77db */
        {8,	0}, 	/* 0x77dc */
        {8,	0}, 	/* 0x77dd */
        {8,	0}, 	/* 0x77de */
        {8,	0}, 	/* 0x77df */
        {8,	0}, 	/* 0x77e0 */
        {8,	0}, 	/* 0x77e1 */
        {8,	0}, 	/* 0x77e2 */
        {8,	0}, 	/* 0x77e3 */
        {8,	0}, 	/* 0x77e4 */
        {8,	0}, 	/* 0x77e5 */
        {8,	0}, 	/* 0x77e6 */
        {8,	0}, 	/* 0x77e7 */
        {8,	0}, 	/* 0x77e8 */
        {8,	0}, 	/* 0x77e9 */
        {8,	0}, 	/* 0x77ea */
        {8,	0}, 	/* 0x77eb */
        {8,	0}, 	/* 0x77ec */
        {8,	0}, 	/* 0x77ed */
        {8,	0}, 	/* 0x77ee */
        {8,	0}, 	/* 0x77ef */
        {8,	0}, 	/* 0x77f0 */
        {8,	0}, 	/* 0x77f1 */
        {8,	0}, 	/* 0x77f2 */
        {8,	0}, 	/* 0x77f3 */
        {8,	0}, 	/* 0x77f4 */
        {8,	0}, 	/* 0x77f5 */
        {8,	0}, 	/* 0x77f6 */
        {8,	0}, 	/* 0x77f7 */
        {8,	0}, 	/* 0x77f8 */
        {8,	0}, 	/* 0x77f9 */
        {8,	0}, 	/* 0x77fa */
        {8,	0}, 	/* 0x77fb */
        {8,	0}, 	/* 0x77fc */
        {8,	0}, 	/* 0x77fd */
        {8,	0}, 	/* 0x77fe */
        {8,	0}, 	/* 0x77ff */
        {8,	0}, 	/* 0x7800 */
        {8,	0}, 	/* 0x7801 */
        {8,	0}, 	/* 0x7802 */
        {8,	0}, 	/* 0x7803 */
        {8,	0}, 	/* 0x7804 */
        {8,	0}, 	/* 0x7805 */
        {8,	0}, 	/* 0x7806 */
        {8,	0}, 	/* 0x7807 */
        {8,	0}, 	/* 0x7808 */
        {8,	0}, 	/* 0x7809 */
        {8,	0}, 	/* 0x780a */
        {8,	0}, 	/* 0x780b */
        {8,	0}, 	/* 0x780c */
        {8,	0}, 	/* 0x780d */
        {8,	0}, 	/* 0x780e */
        {8,	0}, 	/* 0x780f */
        {8,	0}, 	/* 0x7810 */
        {8,	0}, 	/* 0x7811 */
        {8,	0}, 	/* 0x7812 */
        {8,	0}, 	/* 0x7813 */
        {8,	0}, 	/* 0x7814 */
        {8,	0}, 	/* 0x7815 */
        {8,	0}, 	/* 0x7816 */
        {8,	0}, 	/* 0x7817 */
        {8,	0}, 	/* 0x7818 */
        {8,	0}, 	/* 0x7819 */
        {8,	0}, 	/* 0x781a */
        {8,	0}, 	/* 0x781b */
        {8,	0}, 	/* 0x781c */
        {8,	0}, 	/* 0x781d */
        {8,	0}, 	/* 0x781e */
        {8,	0}, 	/* 0x781f */
        {8,	0}, 	/* 0x7820 */
        {8,	0}, 	/* 0x7821 */
        {8,	0}, 	/* 0x7822 */
        {8,	0}, 	/* 0x7823 */
        {8,	0}, 	/* 0x7824 */
        {8,	0}, 	/* 0x7825 */
        {8,	0}, 	/* 0x7826 */
        {8,	0}, 	/* 0x7827 */
        {8,	0}, 	/* 0x7828 */
        {8,	0}, 	/* 0x7829 */
        {8,	0}, 	/* 0x782a */
        {8,	0}, 	/* 0x782b */
        {8,	0}, 	/* 0x782c */
        {8,	0}, 	/* 0x782d */
        {8,	0}, 	/* 0x782e */
        {8,	0}, 	/* 0x782f */
        {8,	0}, 	/* 0x7830 */
        {8,	0}, 	/* 0x7831 */
        {8,	0}, 	/* 0x7832 */
        {8,	0}, 	/* 0x7833 */
        {8,	0}, 	/* 0x7834 */
        {8,	0}, 	/* 0x7835 */
        {8,	0}, 	/* 0x7836 */
        {8,	0}, 	/* 0x7837 */
        {8,	0}, 	/* 0x7838 */
        {8,	0}, 	/* 0x7839 */
        {8,	0}, 	/* 0x783a */
        {8,	0}, 	/* 0x783b */
        {8,	0}, 	/* 0x783c */
        {8,	0}, 	/* 0x783d */
        {8,	0}, 	/* 0x783e */
        {8,	0}, 	/* 0x783f */
        {8,	0}, 	/* 0x7840 */
        {8,	0}, 	/* 0x7841 */
        {8,	0}, 	/* 0x7842 */
        {8,	0}, 	/* 0x7843 */
        {8,	0}, 	/* 0x7844 */
        {8,	0}, 	/* 0x7845 */
        {8,	0}, 	/* 0x7846 */
        {8,	0}, 	/* 0x7847 */
        {8,	0}, 	/* 0x7848 */
        {8,	0}, 	/* 0x7849 */
        {8,	0}, 	/* 0x784a */
        {8,	0}, 	/* 0x784b */
        {8,	0}, 	/* 0x784c */
        {8,	0}, 	/* 0x784d */
        {8,	0}, 	/* 0x784e */
        {8,	0}, 	/* 0x784f */
        {8,	0}, 	/* 0x7850 */
        {8,	0}, 	/* 0x7851 */
        {8,	0}, 	/* 0x7852 */
        {8,	0}, 	/* 0x7853 */
        {8,	0}, 	/* 0x7854 */
        {8,	0}, 	/* 0x7855 */
        {8,	0}, 	/* 0x7856 */
        {8,	0}, 	/* 0x7857 */
        {8,	0}, 	/* 0x7858 */
        {8,	0}, 	/* 0x7859 */
        {8,	0}, 	/* 0x785a */
        {8,	0}, 	/* 0x785b */
        {8,	0}, 	/* 0x785c */
        {8,	0}, 	/* 0x785d */
        {8,	0}, 	/* 0x785e */
        {8,	0}, 	/* 0x785f */
        {8,	0}, 	/* 0x7860 */
        {8,	0}, 	/* 0x7861 */
        {8,	0}, 	/* 0x7862 */
        {8,	0}, 	/* 0x7863 */
        {8,	0}, 	/* 0x7864 */
        {8,	0}, 	/* 0x7865 */
        {8,	0}, 	/* 0x7866 */
        {8,	0}, 	/* 0x7867 */
        {8,	0}, 	/* 0x7868 */
        {8,	0}, 	/* 0x7869 */
        {8,	0}, 	/* 0x786a */
        {8,	0}, 	/* 0x786b */
        {8,	0}, 	/* 0x786c */
        {8,	0}, 	/* 0x786d */
        {8,	0}, 	/* 0x786e */
        {8,	0}, 	/* 0x786f */
        {8,	0}, 	/* 0x7870 */
        {8,	0}, 	/* 0x7871 */
        {8,	0}, 	/* 0x7872 */
        {8,	0}, 	/* 0x7873 */
        {8,	0}, 	/* 0x7874 */
        {8,	0}, 	/* 0x7875 */
        {8,	0}, 	/* 0x7876 */
        {8,	0}, 	/* 0x7877 */
        {8,	0}, 	/* 0x7878 */
        {8,	0}, 	/* 0x7879 */
        {8,	0}, 	/* 0x787a */
        {8,	0}, 	/* 0x787b */
        {8,	0}, 	/* 0x787c */
        {8,	0}, 	/* 0x787d */
        {8,	0}, 	/* 0x787e */
        {8,	0}, 	/* 0x787f */
        {8,	0}, 	/* 0x7880 */
        {8,	0}, 	/* 0x7881 */
        {8,	0}, 	/* 0x7882 */
        {8,	0}, 	/* 0x7883 */
        {8,	0}, 	/* 0x7884 */
        {8,	0}, 	/* 0x7885 */
        {8,	0}, 	/* 0x7886 */
        {8,	0}, 	/* 0x7887 */
        {8,	0}, 	/* 0x7888 */
        {8,	0}, 	/* 0x7889 */
        {8,	0}, 	/* 0x788a */
        {8,	0}, 	/* 0x788b */
        {8,	0}, 	/* 0x788c */
        {8,	0}, 	/* 0x788d */
        {8,	0}, 	/* 0x788e */
        {8,	0}, 	/* 0x788f */
        {8,	0}, 	/* 0x7890 */
        {8,	0}, 	/* 0x7891 */
        {8,	0}, 	/* 0x7892 */
        {8,	0}, 	/* 0x7893 */
        {8,	0}, 	/* 0x7894 */
        {8,	0}, 	/* 0x7895 */
        {8,	0}, 	/* 0x7896 */
        {8,	0}, 	/* 0x7897 */
        {8,	0}, 	/* 0x7898 */
        {8,	0}, 	/* 0x7899 */
        {8,	0}, 	/* 0x789a */
        {8,	0}, 	/* 0x789b */
        {8,	0}, 	/* 0x789c */
        {8,	0}, 	/* 0x789d */
        {8,	0}, 	/* 0x789e */
        {8,	0}, 	/* 0x789f */
        {8,	0}, 	/* 0x78a0 */
        {8,	0}, 	/* 0x78a1 */
        {8,	0}, 	/* 0x78a2 */
        {8,	0}, 	/* 0x78a3 */
        {8,	0}, 	/* 0x78a4 */
        {8,	0}, 	/* 0x78a5 */
        {8,	0}, 	/* 0x78a6 */
        {8,	0}, 	/* 0x78a7 */
        {8,	0}, 	/* 0x78a8 */
        {8,	0}, 	/* 0x78a9 */
        {8,	0}, 	/* 0x78aa */
        {8,	0}, 	/* 0x78ab */
        {8,	0}, 	/* 0x78ac */
        {8,	0}, 	/* 0x78ad */
        {8,	0}, 	/* 0x78ae */
        {8,	0}, 	/* 0x78af */
        {8,	0}, 	/* 0x78b0 */
        {8,	0}, 	/* 0x78b1 */
        {8,	0}, 	/* 0x78b2 */
        {8,	0}, 	/* 0x78b3 */
        {8,	0}, 	/* 0x78b4 */
        {8,	0}, 	/* 0x78b5 */
        {8,	0}, 	/* 0x78b6 */
        {8,	0}, 	/* 0x78b7 */
        {8,	0}, 	/* 0x78b8 */
        {8,	0}, 	/* 0x78b9 */
        {8,	0}, 	/* 0x78ba */
        {8,	0}, 	/* 0x78bb */
        {8,	0}, 	/* 0x78bc */
        {8,	0}, 	/* 0x78bd */
        {8,	0}, 	/* 0x78be */
        {8,	0}, 	/* 0x78bf */
        {8,	0}, 	/* 0x78c0 */
        {8,	0}, 	/* 0x78c1 */
        {8,	0}, 	/* 0x78c2 */
        {8,	0}, 	/* 0x78c3 */
        {8,	0}, 	/* 0x78c4 */
        {8,	0}, 	/* 0x78c5 */
        {8,	0}, 	/* 0x78c6 */
        {8,	0}, 	/* 0x78c7 */
        {8,	0}, 	/* 0x78c8 */
        {8,	0}, 	/* 0x78c9 */
        {8,	0}, 	/* 0x78ca */
        {8,	0}, 	/* 0x78cb */
        {8,	0}, 	/* 0x78cc */
        {8,	0}, 	/* 0x78cd */
        {8,	0}, 	/* 0x78ce */
        {8,	0}, 	/* 0x78cf */
        {8,	0}, 	/* 0x78d0 */
        {8,	0}, 	/* 0x78d1 */
        {8,	0}, 	/* 0x78d2 */
        {8,	0}, 	/* 0x78d3 */
        {8,	0}, 	/* 0x78d4 */
        {8,	0}, 	/* 0x78d5 */
        {8,	0}, 	/* 0x78d6 */
        {8,	0}, 	/* 0x78d7 */
        {8,	0}, 	/* 0x78d8 */
        {8,	0}, 	/* 0x78d9 */
        {8,	0}, 	/* 0x78da */
        {8,	0}, 	/* 0x78db */
        {8,	0}, 	/* 0x78dc */
        {8,	0}, 	/* 0x78dd */
        {8,	0}, 	/* 0x78de */
        {8,	0}, 	/* 0x78df */
        {8,	0}, 	/* 0x78e0 */
        {8,	0}, 	/* 0x78e1 */
        {8,	0}, 	/* 0x78e2 */
        {8,	0}, 	/* 0x78e3 */
        {8,	0}, 	/* 0x78e4 */
        {8,	0}, 	/* 0x78e5 */
        {8,	0}, 	/* 0x78e6 */
        {8,	0}, 	/* 0x78e7 */
        {8,	0}, 	/* 0x78e8 */
        {8,	0}, 	/* 0x78e9 */
        {8,	0}, 	/* 0x78ea */
        {8,	0}, 	/* 0x78eb */
        {8,	0}, 	/* 0x78ec */
        {8,	0}, 	/* 0x78ed */
        {8,	0}, 	/* 0x78ee */
        {8,	0}, 	/* 0x78ef */
        {8,	0}, 	/* 0x78f0 */
        {8,	0}, 	/* 0x78f1 */
        {8,	0}, 	/* 0x78f2 */
        {8,	0}, 	/* 0x78f3 */
        {8,	0}, 	/* 0x78f4 */
        {8,	0}, 	/* 0x78f5 */
        {8,	0}, 	/* 0x78f6 */
        {8,	0}, 	/* 0x78f7 */
        {8,	0}, 	/* 0x78f8 */
        {8,	0}, 	/* 0x78f9 */
        {8,	0}, 	/* 0x78fa */
        {8,	0}, 	/* 0x78fb */
        {8,	0}, 	/* 0x78fc */
        {8,	0}, 	/* 0x78fd */
        {8,	0}, 	/* 0x78fe */
        {8,	0}, 	/* 0x78ff */
        {8,	0}, 	/* 0x7900 */
        {8,	0}, 	/* 0x7901 */
        {8,	0}, 	/* 0x7902 */
        {8,	0}, 	/* 0x7903 */
        {8,	0}, 	/* 0x7904 */
        {8,	0}, 	/* 0x7905 */
        {8,	0}, 	/* 0x7906 */
        {8,	0}, 	/* 0x7907 */
        {8,	0}, 	/* 0x7908 */
        {8,	0}, 	/* 0x7909 */
        {8,	0}, 	/* 0x790a */
        {8,	0}, 	/* 0x790b */
        {8,	0}, 	/* 0x790c */
        {8,	0}, 	/* 0x790d */
        {8,	0}, 	/* 0x790e */
        {8,	0}, 	/* 0x790f */
        {8,	0}, 	/* 0x7910 */
        {8,	0}, 	/* 0x7911 */
        {8,	0}, 	/* 0x7912 */
        {8,	0}, 	/* 0x7913 */
        {8,	0}, 	/* 0x7914 */
        {8,	0}, 	/* 0x7915 */
        {8,	0}, 	/* 0x7916 */
        {8,	0}, 	/* 0x7917 */
        {8,	0}, 	/* 0x7918 */
        {8,	0}, 	/* 0x7919 */
        {8,	0}, 	/* 0x791a */
        {8,	0}, 	/* 0x791b */
        {8,	0}, 	/* 0x791c */
        {8,	0}, 	/* 0x791d */
        {8,	0}, 	/* 0x791e */
        {8,	0}, 	/* 0x791f */
        {8,	0}, 	/* 0x7920 */
        {8,	0}, 	/* 0x7921 */
        {8,	0}, 	/* 0x7922 */
        {8,	0}, 	/* 0x7923 */
        {8,	0}, 	/* 0x7924 */
        {8,	0}, 	/* 0x7925 */
        {8,	0}, 	/* 0x7926 */
        {8,	0}, 	/* 0x7927 */
        {8,	0}, 	/* 0x7928 */
        {8,	0}, 	/* 0x7929 */
        {8,	0}, 	/* 0x792a */
        {8,	0}, 	/* 0x792b */
        {8,	0}, 	/* 0x792c */
        {8,	0}, 	/* 0x792d */
        {8,	0}, 	/* 0x792e */
        {8,	0}, 	/* 0x792f */
        {8,	0}, 	/* 0x7930 */
        {8,	0}, 	/* 0x7931 */
        {8,	0}, 	/* 0x7932 */
        {8,	0}, 	/* 0x7933 */
        {8,	0}, 	/* 0x7934 */
        {8,	0}, 	/* 0x7935 */
        {8,	0}, 	/* 0x7936 */
        {8,	0}, 	/* 0x7937 */
        {8,	0}, 	/* 0x7938 */
        {8,	0}, 	/* 0x7939 */
        {8,	0}, 	/* 0x793a */
        {8,	0}, 	/* 0x793b */
        {8,	0}, 	/* 0x793c */
        {8,	0}, 	/* 0x793d */
        {8,	0}, 	/* 0x793e */
        {8,	0}, 	/* 0x793f */
        {8,	0}, 	/* 0x7940 */
        {8,	0}, 	/* 0x7941 */
        {8,	0}, 	/* 0x7942 */
        {8,	0}, 	/* 0x7943 */
        {8,	0}, 	/* 0x7944 */
        {8,	0}, 	/* 0x7945 */
        {8,	0}, 	/* 0x7946 */
        {8,	0}, 	/* 0x7947 */
        {8,	0}, 	/* 0x7948 */
        {8,	0}, 	/* 0x7949 */
        {8,	0}, 	/* 0x794a */
        {8,	0}, 	/* 0x794b */
        {8,	0}, 	/* 0x794c */
        {8,	0}, 	/* 0x794d */
        {8,	0}, 	/* 0x794e */
        {8,	0}, 	/* 0x794f */
        {8,	0}, 	/* 0x7950 */
        {8,	0}, 	/* 0x7951 */
        {8,	0}, 	/* 0x7952 */
        {8,	0}, 	/* 0x7953 */
        {8,	0}, 	/* 0x7954 */
        {8,	0}, 	/* 0x7955 */
        {8,	0}, 	/* 0x7956 */
        {8,	0}, 	/* 0x7957 */
        {8,	0}, 	/* 0x7958 */
        {8,	0}, 	/* 0x7959 */
        {8,	0}, 	/* 0x795a */
        {8,	0}, 	/* 0x795b */
        {8,	0}, 	/* 0x795c */
        {8,	0}, 	/* 0x795d */
        {8,	0}, 	/* 0x795e */
        {8,	0}, 	/* 0x795f */
        {8,	0}, 	/* 0x7960 */
        {8,	0}, 	/* 0x7961 */
        {8,	0}, 	/* 0x7962 */
        {8,	0}, 	/* 0x7963 */
        {8,	0}, 	/* 0x7964 */
        {8,	0}, 	/* 0x7965 */
        {8,	0}, 	/* 0x7966 */
        {8,	0}, 	/* 0x7967 */
        {8,	0}, 	/* 0x7968 */
        {8,	0}, 	/* 0x7969 */
        {8,	0}, 	/* 0x796a */
        {8,	0}, 	/* 0x796b */
        {8,	0}, 	/* 0x796c */
        {8,	0}, 	/* 0x796d */
        {8,	0}, 	/* 0x796e */
        {8,	0}, 	/* 0x796f */
        {8,	0}, 	/* 0x7970 */
        {8,	0}, 	/* 0x7971 */
        {8,	0}, 	/* 0x7972 */
        {8,	0}, 	/* 0x7973 */
        {8,	0}, 	/* 0x7974 */
        {8,	0}, 	/* 0x7975 */
        {8,	0}, 	/* 0x7976 */
        {8,	0}, 	/* 0x7977 */
        {8,	0}, 	/* 0x7978 */
        {8,	0}, 	/* 0x7979 */
        {8,	0}, 	/* 0x797a */
        {8,	0}, 	/* 0x797b */
        {8,	0}, 	/* 0x797c */
        {8,	0}, 	/* 0x797d */
        {8,	0}, 	/* 0x797e */
        {8,	0}, 	/* 0x797f */
        {8,	0}, 	/* 0x7980 */
        {8,	0}, 	/* 0x7981 */
        {8,	0}, 	/* 0x7982 */
        {8,	0}, 	/* 0x7983 */
        {8,	0}, 	/* 0x7984 */
        {8,	0}, 	/* 0x7985 */
        {8,	0}, 	/* 0x7986 */
        {8,	0}, 	/* 0x7987 */
        {8,	0}, 	/* 0x7988 */
        {8,	0}, 	/* 0x7989 */
        {8,	0}, 	/* 0x798a */
        {8,	0}, 	/* 0x798b */
        {8,	0}, 	/* 0x798c */
        {8,	0}, 	/* 0x798d */
        {8,	0}, 	/* 0x798e */
        {8,	0}, 	/* 0x798f */
        {8,	0}, 	/* 0x7990 */
        {8,	0}, 	/* 0x7991 */
        {8,	0}, 	/* 0x7992 */
        {8,	0}, 	/* 0x7993 */
        {8,	0}, 	/* 0x7994 */
        {8,	0}, 	/* 0x7995 */
        {8,	0}, 	/* 0x7996 */
        {8,	0}, 	/* 0x7997 */
        {8,	0}, 	/* 0x7998 */
        {8,	0}, 	/* 0x7999 */
        {8,	0}, 	/* 0x799a */
        {8,	0}, 	/* 0x799b */
        {8,	0}, 	/* 0x799c */
        {8,	0}, 	/* 0x799d */
        {8,	0}, 	/* 0x799e */
        {8,	0}, 	/* 0x799f */
        {8,	0}, 	/* 0x79a0 */
        {8,	0}, 	/* 0x79a1 */
        {8,	0}, 	/* 0x79a2 */
        {8,	0}, 	/* 0x79a3 */
        {8,	0}, 	/* 0x79a4 */
        {8,	0}, 	/* 0x79a5 */
        {8,	0}, 	/* 0x79a6 */
        {8,	0}, 	/* 0x79a7 */
        {8,	0}, 	/* 0x79a8 */
        {8,	0}, 	/* 0x79a9 */
        {8,	0}, 	/* 0x79aa */
        {8,	0}, 	/* 0x79ab */
        {8,	0}, 	/* 0x79ac */
        {8,	0}, 	/* 0x79ad */
        {8,	0}, 	/* 0x79ae */
        {8,	0}, 	/* 0x79af */
        {8,	0}, 	/* 0x79b0 */
        {8,	0}, 	/* 0x79b1 */
        {8,	0}, 	/* 0x79b2 */
        {8,	0}, 	/* 0x79b3 */
        {8,	0}, 	/* 0x79b4 */
        {8,	0}, 	/* 0x79b5 */
        {8,	0}, 	/* 0x79b6 */
        {8,	0}, 	/* 0x79b7 */
        {8,	0}, 	/* 0x79b8 */
        {8,	0}, 	/* 0x79b9 */
        {8,	0}, 	/* 0x79ba */
        {8,	0}, 	/* 0x79bb */
        {8,	0}, 	/* 0x79bc */
        {8,	0}, 	/* 0x79bd */
        {8,	0}, 	/* 0x79be */
        {8,	0}, 	/* 0x79bf */
        {8,	0}, 	/* 0x79c0 */
        {8,	0}, 	/* 0x79c1 */
        {8,	0}, 	/* 0x79c2 */
        {8,	0}, 	/* 0x79c3 */
        {8,	0}, 	/* 0x79c4 */
        {8,	0}, 	/* 0x79c5 */
        {8,	0}, 	/* 0x79c6 */
        {8,	0}, 	/* 0x79c7 */
        {8,	0}, 	/* 0x79c8 */
        {8,	0}, 	/* 0x79c9 */
        {8,	0}, 	/* 0x79ca */
        {8,	0}, 	/* 0x79cb */
        {8,	0}, 	/* 0x79cc */
        {8,	0}, 	/* 0x79cd */
        {8,	0}, 	/* 0x79ce */
        {8,	0}, 	/* 0x79cf */
        {8,	0}, 	/* 0x79d0 */
        {8,	0}, 	/* 0x79d1 */
        {8,	0}, 	/* 0x79d2 */
        {8,	0}, 	/* 0x79d3 */
        {8,	0}, 	/* 0x79d4 */
        {8,	0}, 	/* 0x79d5 */
        {8,	0}, 	/* 0x79d6 */
        {8,	0}, 	/* 0x79d7 */
        {8,	0}, 	/* 0x79d8 */
        {8,	0}, 	/* 0x79d9 */
        {8,	0}, 	/* 0x79da */
        {8,	0}, 	/* 0x79db */
        {8,	0}, 	/* 0x79dc */
        {8,	0}, 	/* 0x79dd */
        {8,	0}, 	/* 0x79de */
        {8,	0}, 	/* 0x79df */
        {8,	0}, 	/* 0x79e0 */
        {8,	0}, 	/* 0x79e1 */
        {8,	0}, 	/* 0x79e2 */
        {8,	0}, 	/* 0x79e3 */
        {8,	0}, 	/* 0x79e4 */
        {8,	0}, 	/* 0x79e5 */
        {8,	0}, 	/* 0x79e6 */
        {8,	0}, 	/* 0x79e7 */
        {8,	0}, 	/* 0x79e8 */
        {8,	0}, 	/* 0x79e9 */
        {8,	0}, 	/* 0x79ea */
        {8,	0}, 	/* 0x79eb */
        {8,	0}, 	/* 0x79ec */
        {8,	0}, 	/* 0x79ed */
        {8,	0}, 	/* 0x79ee */
        {8,	0}, 	/* 0x79ef */
        {8,	0}, 	/* 0x79f0 */
        {8,	0}, 	/* 0x79f1 */
        {8,	0}, 	/* 0x79f2 */
        {8,	0}, 	/* 0x79f3 */
        {8,	0}, 	/* 0x79f4 */
        {8,	0}, 	/* 0x79f5 */
        {8,	0}, 	/* 0x79f6 */
        {8,	0}, 	/* 0x79f7 */
        {8,	0}, 	/* 0x79f8 */
        {8,	0}, 	/* 0x79f9 */
        {8,	0}, 	/* 0x79fa */
        {8,	0}, 	/* 0x79fb */
        {8,	0}, 	/* 0x79fc */
        {8,	0}, 	/* 0x79fd */
        {8,	0}, 	/* 0x79fe */
        {8,	0}, 	/* 0x79ff */
        {8,	0}, 	/* 0x7a00 */
        {8,	0}, 	/* 0x7a01 */
        {8,	0}, 	/* 0x7a02 */
        {8,	0}, 	/* 0x7a03 */
        {8,	0}, 	/* 0x7a04 */
        {8,	0}, 	/* 0x7a05 */
        {8,	0}, 	/* 0x7a06 */
        {8,	0}, 	/* 0x7a07 */
        {8,	0}, 	/* 0x7a08 */
        {8,	0}, 	/* 0x7a09 */
        {8,	0}, 	/* 0x7a0a */
        {8,	0}, 	/* 0x7a0b */
        {8,	0}, 	/* 0x7a0c */
        {8,	0}, 	/* 0x7a0d */
        {8,	0}, 	/* 0x7a0e */
        {8,	0}, 	/* 0x7a0f */
        {8,	0}, 	/* 0x7a10 */
        {8,	0}, 	/* 0x7a11 */
        {8,	0}, 	/* 0x7a12 */
        {8,	0}, 	/* 0x7a13 */
        {8,	0}, 	/* 0x7a14 */
        {8,	0}, 	/* 0x7a15 */
        {8,	0}, 	/* 0x7a16 */
        {8,	0}, 	/* 0x7a17 */
        {8,	0}, 	/* 0x7a18 */
        {8,	0}, 	/* 0x7a19 */
        {8,	0}, 	/* 0x7a1a */
        {8,	0}, 	/* 0x7a1b */
        {8,	0}, 	/* 0x7a1c */
        {8,	0}, 	/* 0x7a1d */
        {8,	0}, 	/* 0x7a1e */
        {8,	0}, 	/* 0x7a1f */
        {8,	0}, 	/* 0x7a20 */
        {8,	0}, 	/* 0x7a21 */
        {8,	0}, 	/* 0x7a22 */
        {8,	0}, 	/* 0x7a23 */
        {8,	0}, 	/* 0x7a24 */
        {8,	0}, 	/* 0x7a25 */
        {8,	0}, 	/* 0x7a26 */
        {8,	0}, 	/* 0x7a27 */
        {8,	0}, 	/* 0x7a28 */
        {8,	0}, 	/* 0x7a29 */
        {8,	0}, 	/* 0x7a2a */
        {8,	0}, 	/* 0x7a2b */
        {8,	0}, 	/* 0x7a2c */
        {8,	0}, 	/* 0x7a2d */
        {8,	0}, 	/* 0x7a2e */
        {8,	0}, 	/* 0x7a2f */
        {8,	0}, 	/* 0x7a30 */
        {8,	0}, 	/* 0x7a31 */
        {8,	0}, 	/* 0x7a32 */
        {8,	0}, 	/* 0x7a33 */
        {8,	0}, 	/* 0x7a34 */
        {8,	0}, 	/* 0x7a35 */
        {8,	0}, 	/* 0x7a36 */
        {8,	0}, 	/* 0x7a37 */
        {8,	0}, 	/* 0x7a38 */
        {8,	0}, 	/* 0x7a39 */
        {8,	0}, 	/* 0x7a3a */
        {8,	0}, 	/* 0x7a3b */
        {8,	0}, 	/* 0x7a3c */
        {8,	0}, 	/* 0x7a3d */
        {8,	0}, 	/* 0x7a3e */
        {8,	0}, 	/* 0x7a3f */
        {8,	0}, 	/* 0x7a40 */
        {8,	0}, 	/* 0x7a41 */
        {8,	0}, 	/* 0x7a42 */
        {8,	0}, 	/* 0x7a43 */
        {8,	0}, 	/* 0x7a44 */
        {8,	0}, 	/* 0x7a45 */
        {8,	0}, 	/* 0x7a46 */
        {8,	0}, 	/* 0x7a47 */
        {8,	0}, 	/* 0x7a48 */
        {8,	0}, 	/* 0x7a49 */
        {8,	0}, 	/* 0x7a4a */
        {8,	0}, 	/* 0x7a4b */
        {8,	0}, 	/* 0x7a4c */
        {8,	0}, 	/* 0x7a4d */
        {8,	0}, 	/* 0x7a4e */
        {8,	0}, 	/* 0x7a4f */
        {8,	0}, 	/* 0x7a50 */
        {8,	0}, 	/* 0x7a51 */
        {8,	0}, 	/* 0x7a52 */
        {8,	0}, 	/* 0x7a53 */
        {8,	0}, 	/* 0x7a54 */
        {8,	0}, 	/* 0x7a55 */
        {8,	0}, 	/* 0x7a56 */
        {8,	0}, 	/* 0x7a57 */
        {8,	0}, 	/* 0x7a58 */
        {8,	0}, 	/* 0x7a59 */
        {8,	0}, 	/* 0x7a5a */
        {8,	0}, 	/* 0x7a5b */
        {8,	0}, 	/* 0x7a5c */
        {8,	0}, 	/* 0x7a5d */
        {8,	0}, 	/* 0x7a5e */
        {8,	0}, 	/* 0x7a5f */
        {8,	0}, 	/* 0x7a60 */
        {8,	0}, 	/* 0x7a61 */
        {8,	0}, 	/* 0x7a62 */
        {8,	0}, 	/* 0x7a63 */
        {8,	0}, 	/* 0x7a64 */
        {8,	0}, 	/* 0x7a65 */
        {8,	0}, 	/* 0x7a66 */
        {8,	0}, 	/* 0x7a67 */
        {8,	0}, 	/* 0x7a68 */
        {8,	0}, 	/* 0x7a69 */
        {8,	0}, 	/* 0x7a6a */
        {8,	0}, 	/* 0x7a6b */
        {8,	0}, 	/* 0x7a6c */
        {8,	0}, 	/* 0x7a6d */
        {8,	0}, 	/* 0x7a6e */
        {8,	0}, 	/* 0x7a6f */
        {8,	0}, 	/* 0x7a70 */
        {8,	0}, 	/* 0x7a71 */
        {8,	0}, 	/* 0x7a72 */
        {8,	0}, 	/* 0x7a73 */
        {8,	0}, 	/* 0x7a74 */
        {8,	0}, 	/* 0x7a75 */
        {8,	0}, 	/* 0x7a76 */
        {8,	0}, 	/* 0x7a77 */
        {8,	0}, 	/* 0x7a78 */
        {8,	0}, 	/* 0x7a79 */
        {8,	0}, 	/* 0x7a7a */
        {8,	0}, 	/* 0x7a7b */
        {8,	0}, 	/* 0x7a7c */
        {8,	0}, 	/* 0x7a7d */
        {8,	0}, 	/* 0x7a7e */
        {8,	0}, 	/* 0x7a7f */
        {8,	0}, 	/* 0x7a80 */
        {8,	0}, 	/* 0x7a81 */
        {8,	0}, 	/* 0x7a82 */
        {8,	0}, 	/* 0x7a83 */
        {8,	0}, 	/* 0x7a84 */
        {8,	0}, 	/* 0x7a85 */
        {8,	0}, 	/* 0x7a86 */
        {8,	0}, 	/* 0x7a87 */
        {8,	0}, 	/* 0x7a88 */
        {8,	0}, 	/* 0x7a89 */
        {8,	0}, 	/* 0x7a8a */
        {8,	0}, 	/* 0x7a8b */
        {8,	0}, 	/* 0x7a8c */
        {8,	0}, 	/* 0x7a8d */
        {8,	0}, 	/* 0x7a8e */
        {8,	0}, 	/* 0x7a8f */
        {8,	0}, 	/* 0x7a90 */
        {8,	0}, 	/* 0x7a91 */
        {8,	0}, 	/* 0x7a92 */
        {8,	0}, 	/* 0x7a93 */
        {8,	0}, 	/* 0x7a94 */
        {8,	0}, 	/* 0x7a95 */
        {8,	0}, 	/* 0x7a96 */
        {8,	0}, 	/* 0x7a97 */
        {8,	0}, 	/* 0x7a98 */
        {8,	0}, 	/* 0x7a99 */
        {8,	0}, 	/* 0x7a9a */
        {8,	0}, 	/* 0x7a9b */
        {8,	0}, 	/* 0x7a9c */
        {8,	0}, 	/* 0x7a9d */
        {8,	0}, 	/* 0x7a9e */
        {8,	0}, 	/* 0x7a9f */
        {8,	0}, 	/* 0x7aa0 */
        {8,	0}, 	/* 0x7aa1 */
        {8,	0}, 	/* 0x7aa2 */
        {8,	0}, 	/* 0x7aa3 */
        {8,	0}, 	/* 0x7aa4 */
        {8,	0}, 	/* 0x7aa5 */
        {8,	0}, 	/* 0x7aa6 */
        {8,	0}, 	/* 0x7aa7 */
        {8,	0}, 	/* 0x7aa8 */
        {8,	0}, 	/* 0x7aa9 */
        {8,	0}, 	/* 0x7aaa */
        {8,	0}, 	/* 0x7aab */
        {8,	0}, 	/* 0x7aac */
        {8,	0}, 	/* 0x7aad */
        {8,	0}, 	/* 0x7aae */
        {8,	0}, 	/* 0x7aaf */
        {8,	0}, 	/* 0x7ab0 */
        {8,	0}, 	/* 0x7ab1 */
        {8,	0}, 	/* 0x7ab2 */
        {8,	0}, 	/* 0x7ab3 */
        {8,	0}, 	/* 0x7ab4 */
        {8,	0}, 	/* 0x7ab5 */
        {8,	0}, 	/* 0x7ab6 */
        {8,	0}, 	/* 0x7ab7 */
        {8,	0}, 	/* 0x7ab8 */
        {8,	0}, 	/* 0x7ab9 */
        {8,	0}, 	/* 0x7aba */
        {8,	0}, 	/* 0x7abb */
        {8,	0}, 	/* 0x7abc */
        {8,	0}, 	/* 0x7abd */
        {8,	0}, 	/* 0x7abe */
        {8,	0}, 	/* 0x7abf */
        {8,	0}, 	/* 0x7ac0 */
        {8,	0}, 	/* 0x7ac1 */
        {8,	0}, 	/* 0x7ac2 */
        {8,	0}, 	/* 0x7ac3 */
        {8,	0}, 	/* 0x7ac4 */
        {8,	0}, 	/* 0x7ac5 */
        {8,	0}, 	/* 0x7ac6 */
        {8,	0}, 	/* 0x7ac7 */
        {8,	0}, 	/* 0x7ac8 */
        {8,	0}, 	/* 0x7ac9 */
        {8,	0}, 	/* 0x7aca */
        {8,	0}, 	/* 0x7acb */
        {8,	0}, 	/* 0x7acc */
        {8,	0}, 	/* 0x7acd */
        {8,	0}, 	/* 0x7ace */
        {8,	0}, 	/* 0x7acf */
        {8,	0}, 	/* 0x7ad0 */
        {8,	0}, 	/* 0x7ad1 */
        {8,	0}, 	/* 0x7ad2 */
        {8,	0}, 	/* 0x7ad3 */
        {8,	0}, 	/* 0x7ad4 */
        {8,	0}, 	/* 0x7ad5 */
        {8,	0}, 	/* 0x7ad6 */
        {8,	0}, 	/* 0x7ad7 */
        {8,	0}, 	/* 0x7ad8 */
        {8,	0}, 	/* 0x7ad9 */
        {8,	0}, 	/* 0x7ada */
        {8,	0}, 	/* 0x7adb */
        {8,	0}, 	/* 0x7adc */
        {8,	0}, 	/* 0x7add */
        {8,	0}, 	/* 0x7ade */
        {8,	0}, 	/* 0x7adf */
        {8,	0}, 	/* 0x7ae0 */
        {8,	0}, 	/* 0x7ae1 */
        {8,	0}, 	/* 0x7ae2 */
        {8,	0}, 	/* 0x7ae3 */
        {8,	0}, 	/* 0x7ae4 */
        {8,	0}, 	/* 0x7ae5 */
        {8,	0}, 	/* 0x7ae6 */
        {8,	0}, 	/* 0x7ae7 */
        {8,	0}, 	/* 0x7ae8 */
        {8,	0}, 	/* 0x7ae9 */
        {8,	0}, 	/* 0x7aea */
        {8,	0}, 	/* 0x7aeb */
        {8,	0}, 	/* 0x7aec */
        {8,	0}, 	/* 0x7aed */
        {8,	0}, 	/* 0x7aee */
        {8,	0}, 	/* 0x7aef */
        {8,	0}, 	/* 0x7af0 */
        {8,	0}, 	/* 0x7af1 */
        {8,	0}, 	/* 0x7af2 */
        {8,	0}, 	/* 0x7af3 */
        {8,	0}, 	/* 0x7af4 */
        {8,	0}, 	/* 0x7af5 */
        {8,	0}, 	/* 0x7af6 */
        {8,	0}, 	/* 0x7af7 */
        {8,	0}, 	/* 0x7af8 */
        {8,	0}, 	/* 0x7af9 */
        {8,	0}, 	/* 0x7afa */
        {8,	0}, 	/* 0x7afb */
        {8,	0}, 	/* 0x7afc */
        {8,	0}, 	/* 0x7afd */
        {8,	0}, 	/* 0x7afe */
        {8,	0}, 	/* 0x7aff */
        {8,	0}, 	/* 0x7b00 */
        {8,	0}, 	/* 0x7b01 */
        {8,	0}, 	/* 0x7b02 */
        {8,	0}, 	/* 0x7b03 */
        {8,	0}, 	/* 0x7b04 */
        {8,	0}, 	/* 0x7b05 */
        {8,	0}, 	/* 0x7b06 */
        {8,	0}, 	/* 0x7b07 */
        {8,	0}, 	/* 0x7b08 */
        {8,	0}, 	/* 0x7b09 */
        {8,	0}, 	/* 0x7b0a */
        {8,	0}, 	/* 0x7b0b */
        {8,	0}, 	/* 0x7b0c */
        {8,	0}, 	/* 0x7b0d */
        {8,	0}, 	/* 0x7b0e */
        {8,	0}, 	/* 0x7b0f */
        {8,	0}, 	/* 0x7b10 */
        {8,	0}, 	/* 0x7b11 */
        {8,	0}, 	/* 0x7b12 */
        {8,	0}, 	/* 0x7b13 */
        {8,	0}, 	/* 0x7b14 */
        {8,	0}, 	/* 0x7b15 */
        {8,	0}, 	/* 0x7b16 */
        {8,	0}, 	/* 0x7b17 */
        {8,	0}, 	/* 0x7b18 */
        {8,	0}, 	/* 0x7b19 */
        {8,	0}, 	/* 0x7b1a */
        {8,	0}, 	/* 0x7b1b */
        {8,	0}, 	/* 0x7b1c */
        {8,	0}, 	/* 0x7b1d */
        {8,	0}, 	/* 0x7b1e */
        {8,	0}, 	/* 0x7b1f */
        {8,	0}, 	/* 0x7b20 */
        {8,	0}, 	/* 0x7b21 */
        {8,	0}, 	/* 0x7b22 */
        {8,	0}, 	/* 0x7b23 */
        {8,	0}, 	/* 0x7b24 */
        {8,	0}, 	/* 0x7b25 */
        {8,	0}, 	/* 0x7b26 */
        {8,	0}, 	/* 0x7b27 */
        {8,	0}, 	/* 0x7b28 */
        {8,	0}, 	/* 0x7b29 */
        {8,	0}, 	/* 0x7b2a */
        {8,	0}, 	/* 0x7b2b */
        {8,	0}, 	/* 0x7b2c */
        {8,	0}, 	/* 0x7b2d */
        {8,	0}, 	/* 0x7b2e */
        {8,	0}, 	/* 0x7b2f */
        {8,	0}, 	/* 0x7b30 */
        {8,	0}, 	/* 0x7b31 */
        {8,	0}, 	/* 0x7b32 */
        {8,	0}, 	/* 0x7b33 */
        {8,	0}, 	/* 0x7b34 */
        {8,	0}, 	/* 0x7b35 */
        {8,	0}, 	/* 0x7b36 */
        {8,	0}, 	/* 0x7b37 */
        {8,	0}, 	/* 0x7b38 */
        {8,	0}, 	/* 0x7b39 */
        {8,	0}, 	/* 0x7b3a */
        {8,	0}, 	/* 0x7b3b */
        {8,	0}, 	/* 0x7b3c */
        {8,	0}, 	/* 0x7b3d */
        {8,	0}, 	/* 0x7b3e */
        {8,	0}, 	/* 0x7b3f */
        {8,	0}, 	/* 0x7b40 */
        {8,	0}, 	/* 0x7b41 */
        {8,	0}, 	/* 0x7b42 */
        {8,	0}, 	/* 0x7b43 */
        {8,	0}, 	/* 0x7b44 */
        {8,	0}, 	/* 0x7b45 */
        {8,	0}, 	/* 0x7b46 */
        {8,	0}, 	/* 0x7b47 */
        {8,	0}, 	/* 0x7b48 */
        {8,	0}, 	/* 0x7b49 */
        {8,	0}, 	/* 0x7b4a */
        {8,	0}, 	/* 0x7b4b */
        {8,	0}, 	/* 0x7b4c */
        {8,	0}, 	/* 0x7b4d */
        {8,	0}, 	/* 0x7b4e */
        {8,	0}, 	/* 0x7b4f */
        {8,	0}, 	/* 0x7b50 */
        {8,	0}, 	/* 0x7b51 */
        {8,	0}, 	/* 0x7b52 */
        {8,	0}, 	/* 0x7b53 */
        {8,	0}, 	/* 0x7b54 */
        {8,	0}, 	/* 0x7b55 */
        {8,	0}, 	/* 0x7b56 */
        {8,	0}, 	/* 0x7b57 */
        {8,	0}, 	/* 0x7b58 */
        {8,	0}, 	/* 0x7b59 */
        {8,	0}, 	/* 0x7b5a */
        {8,	0}, 	/* 0x7b5b */
        {8,	0}, 	/* 0x7b5c */
        {8,	0}, 	/* 0x7b5d */
        {8,	0}, 	/* 0x7b5e */
        {8,	0}, 	/* 0x7b5f */
        {8,	0}, 	/* 0x7b60 */
        {8,	0}, 	/* 0x7b61 */
        {8,	0}, 	/* 0x7b62 */
        {8,	0}, 	/* 0x7b63 */
        {8,	0}, 	/* 0x7b64 */
        {8,	0}, 	/* 0x7b65 */
        {8,	0}, 	/* 0x7b66 */
        {8,	0}, 	/* 0x7b67 */
        {8,	0}, 	/* 0x7b68 */
        {8,	0}, 	/* 0x7b69 */
        {8,	0}, 	/* 0x7b6a */
        {8,	0}, 	/* 0x7b6b */
        {8,	0}, 	/* 0x7b6c */
        {8,	0}, 	/* 0x7b6d */
        {8,	0}, 	/* 0x7b6e */
        {8,	0}, 	/* 0x7b6f */
        {8,	0}, 	/* 0x7b70 */
        {8,	0}, 	/* 0x7b71 */
        {8,	0}, 	/* 0x7b72 */
        {8,	0}, 	/* 0x7b73 */
        {8,	0}, 	/* 0x7b74 */
        {8,	0}, 	/* 0x7b75 */
        {8,	0}, 	/* 0x7b76 */
        {8,	0}, 	/* 0x7b77 */
        {8,	0}, 	/* 0x7b78 */
        {8,	0}, 	/* 0x7b79 */
        {8,	0}, 	/* 0x7b7a */
        {8,	0}, 	/* 0x7b7b */
        {8,	0}, 	/* 0x7b7c */
        {8,	0}, 	/* 0x7b7d */
        {8,	0}, 	/* 0x7b7e */
        {8,	0}, 	/* 0x7b7f */
        {8,	0}, 	/* 0x7b80 */
        {8,	0}, 	/* 0x7b81 */
        {8,	0}, 	/* 0x7b82 */
        {8,	0}, 	/* 0x7b83 */
        {8,	0}, 	/* 0x7b84 */
        {8,	0}, 	/* 0x7b85 */
        {8,	0}, 	/* 0x7b86 */
        {8,	0}, 	/* 0x7b87 */
        {8,	0}, 	/* 0x7b88 */
        {8,	0}, 	/* 0x7b89 */
        {8,	0}, 	/* 0x7b8a */
        {8,	0}, 	/* 0x7b8b */
        {8,	0}, 	/* 0x7b8c */
        {8,	0}, 	/* 0x7b8d */
        {8,	0}, 	/* 0x7b8e */
        {8,	0}, 	/* 0x7b8f */
        {8,	0}, 	/* 0x7b90 */
        {8,	0}, 	/* 0x7b91 */
        {8,	0}, 	/* 0x7b92 */
        {8,	0}, 	/* 0x7b93 */
        {8,	0}, 	/* 0x7b94 */
        {8,	0}, 	/* 0x7b95 */
        {8,	0}, 	/* 0x7b96 */
        {8,	0}, 	/* 0x7b97 */
        {8,	0}, 	/* 0x7b98 */
        {8,	0}, 	/* 0x7b99 */
        {8,	0}, 	/* 0x7b9a */
        {8,	0}, 	/* 0x7b9b */
        {8,	0}, 	/* 0x7b9c */
        {8,	0}, 	/* 0x7b9d */
        {8,	0}, 	/* 0x7b9e */
        {8,	0}, 	/* 0x7b9f */
        {8,	0}, 	/* 0x7ba0 */
        {8,	0}, 	/* 0x7ba1 */
        {8,	0}, 	/* 0x7ba2 */
        {8,	0}, 	/* 0x7ba3 */
        {8,	0}, 	/* 0x7ba4 */
        {8,	0}, 	/* 0x7ba5 */
        {8,	0}, 	/* 0x7ba6 */
        {8,	0}, 	/* 0x7ba7 */
        {8,	0}, 	/* 0x7ba8 */
        {8,	0}, 	/* 0x7ba9 */
        {8,	0}, 	/* 0x7baa */
        {8,	0}, 	/* 0x7bab */
        {8,	0}, 	/* 0x7bac */
        {8,	0}, 	/* 0x7bad */
        {8,	0}, 	/* 0x7bae */
        {8,	0}, 	/* 0x7baf */
        {8,	0}, 	/* 0x7bb0 */
        {8,	0}, 	/* 0x7bb1 */
        {8,	0}, 	/* 0x7bb2 */
        {8,	0}, 	/* 0x7bb3 */
        {8,	0}, 	/* 0x7bb4 */
        {8,	0}, 	/* 0x7bb5 */
        {8,	0}, 	/* 0x7bb6 */
        {8,	0}, 	/* 0x7bb7 */
        {8,	0}, 	/* 0x7bb8 */
        {8,	0}, 	/* 0x7bb9 */
        {8,	0}, 	/* 0x7bba */
        {8,	0}, 	/* 0x7bbb */
        {8,	0}, 	/* 0x7bbc */
        {8,	0}, 	/* 0x7bbd */
        {8,	0}, 	/* 0x7bbe */
        {8,	0}, 	/* 0x7bbf */
        {8,	0}, 	/* 0x7bc0 */
        {8,	0}, 	/* 0x7bc1 */
        {8,	0}, 	/* 0x7bc2 */
        {8,	0}, 	/* 0x7bc3 */
        {8,	0}, 	/* 0x7bc4 */
        {8,	0}, 	/* 0x7bc5 */
        {8,	0}, 	/* 0x7bc6 */
        {8,	0}, 	/* 0x7bc7 */
        {8,	0}, 	/* 0x7bc8 */
        {8,	0}, 	/* 0x7bc9 */
        {8,	0}, 	/* 0x7bca */
        {8,	0}, 	/* 0x7bcb */
        {8,	0}, 	/* 0x7bcc */
        {8,	0}, 	/* 0x7bcd */
        {8,	0}, 	/* 0x7bce */
        {8,	0}, 	/* 0x7bcf */
        {8,	0}, 	/* 0x7bd0 */
        {8,	0}, 	/* 0x7bd1 */
        {8,	0}, 	/* 0x7bd2 */
        {8,	0}, 	/* 0x7bd3 */
        {8,	0}, 	/* 0x7bd4 */
        {8,	0}, 	/* 0x7bd5 */
        {8,	0}, 	/* 0x7bd6 */
        {8,	0}, 	/* 0x7bd7 */
        {8,	0}, 	/* 0x7bd8 */
        {8,	0}, 	/* 0x7bd9 */
        {8,	0}, 	/* 0x7bda */
        {8,	0}, 	/* 0x7bdb */
        {8,	0}, 	/* 0x7bdc */
        {8,	0}, 	/* 0x7bdd */
        {8,	0}, 	/* 0x7bde */
        {8,	0}, 	/* 0x7bdf */
        {8,	0}, 	/* 0x7be0 */
        {8,	0}, 	/* 0x7be1 */
        {8,	0}, 	/* 0x7be2 */
        {8,	0}, 	/* 0x7be3 */
        {8,	0}, 	/* 0x7be4 */
        {8,	0}, 	/* 0x7be5 */
        {8,	0}, 	/* 0x7be6 */
        {8,	0}, 	/* 0x7be7 */
        {8,	0}, 	/* 0x7be8 */
        {8,	0}, 	/* 0x7be9 */
        {8,	0}, 	/* 0x7bea */
        {8,	0}, 	/* 0x7beb */
        {8,	0}, 	/* 0x7bec */
        {8,	0}, 	/* 0x7bed */
        {8,	0}, 	/* 0x7bee */
        {8,	0}, 	/* 0x7bef */
        {8,	0}, 	/* 0x7bf0 */
        {8,	0}, 	/* 0x7bf1 */
        {8,	0}, 	/* 0x7bf2 */
        {8,	0}, 	/* 0x7bf3 */
        {8,	0}, 	/* 0x7bf4 */
        {8,	0}, 	/* 0x7bf5 */
        {8,	0}, 	/* 0x7bf6 */
        {8,	0}, 	/* 0x7bf7 */
        {8,	0}, 	/* 0x7bf8 */
        {8,	0}, 	/* 0x7bf9 */
        {8,	0}, 	/* 0x7bfa */
        {8,	0}, 	/* 0x7bfb */
        {8,	0}, 	/* 0x7bfc */
        {8,	0}, 	/* 0x7bfd */
        {8,	0}, 	/* 0x7bfe */
        {8,	0}, 	/* 0x7bff */
        {8,	0}, 	/* 0x7c00 */
        {8,	0}, 	/* 0x7c01 */
        {8,	0}, 	/* 0x7c02 */
        {8,	0}, 	/* 0x7c03 */
        {8,	0}, 	/* 0x7c04 */
        {8,	0}, 	/* 0x7c05 */
        {8,	0}, 	/* 0x7c06 */
        {8,	0}, 	/* 0x7c07 */
        {8,	0}, 	/* 0x7c08 */
        {8,	0}, 	/* 0x7c09 */
        {8,	0}, 	/* 0x7c0a */
        {8,	0}, 	/* 0x7c0b */
        {8,	0}, 	/* 0x7c0c */
        {8,	0}, 	/* 0x7c0d */
        {8,	0}, 	/* 0x7c0e */
        {8,	0}, 	/* 0x7c0f */
        {8,	0}, 	/* 0x7c10 */
        {8,	0}, 	/* 0x7c11 */
        {8,	0}, 	/* 0x7c12 */
        {8,	0}, 	/* 0x7c13 */
        {8,	0}, 	/* 0x7c14 */
        {8,	0}, 	/* 0x7c15 */
        {8,	0}, 	/* 0x7c16 */
        {8,	0}, 	/* 0x7c17 */
        {8,	0}, 	/* 0x7c18 */
        {8,	0}, 	/* 0x7c19 */
        {8,	0}, 	/* 0x7c1a */
        {8,	0}, 	/* 0x7c1b */
        {8,	0}, 	/* 0x7c1c */
        {8,	0}, 	/* 0x7c1d */
        {8,	0}, 	/* 0x7c1e */
        {8,	0}, 	/* 0x7c1f */
        {8,	0}, 	/* 0x7c20 */
        {8,	0}, 	/* 0x7c21 */
        {8,	0}, 	/* 0x7c22 */
        {8,	0}, 	/* 0x7c23 */
        {8,	0}, 	/* 0x7c24 */
        {8,	0}, 	/* 0x7c25 */
        {8,	0}, 	/* 0x7c26 */
        {8,	0}, 	/* 0x7c27 */
        {8,	0}, 	/* 0x7c28 */
        {8,	0}, 	/* 0x7c29 */
        {8,	0}, 	/* 0x7c2a */
        {8,	0}, 	/* 0x7c2b */
        {8,	0}, 	/* 0x7c2c */
        {8,	0}, 	/* 0x7c2d */
        {8,	0}, 	/* 0x7c2e */
        {8,	0}, 	/* 0x7c2f */
        {8,	0}, 	/* 0x7c30 */
        {8,	0}, 	/* 0x7c31 */
        {8,	0}, 	/* 0x7c32 */
        {8,	0}, 	/* 0x7c33 */
        {8,	0}, 	/* 0x7c34 */
        {8,	0}, 	/* 0x7c35 */
        {8,	0}, 	/* 0x7c36 */
        {8,	0}, 	/* 0x7c37 */
        {8,	0}, 	/* 0x7c38 */
        {8,	0}, 	/* 0x7c39 */
        {8,	0}, 	/* 0x7c3a */
        {8,	0}, 	/* 0x7c3b */
        {8,	0}, 	/* 0x7c3c */
        {8,	0}, 	/* 0x7c3d */
        {8,	0}, 	/* 0x7c3e */
        {8,	0}, 	/* 0x7c3f */
        {8,	0}, 	/* 0x7c40 */
        {8,	0}, 	/* 0x7c41 */
        {8,	0}, 	/* 0x7c42 */
        {8,	0}, 	/* 0x7c43 */
        {8,	0}, 	/* 0x7c44 */
        {8,	0}, 	/* 0x7c45 */
        {8,	0}, 	/* 0x7c46 */
        {8,	0}, 	/* 0x7c47 */
        {8,	0}, 	/* 0x7c48 */
        {8,	0}, 	/* 0x7c49 */
        {8,	0}, 	/* 0x7c4a */
        {8,	0}, 	/* 0x7c4b */
        {8,	0}, 	/* 0x7c4c */
        {8,	0}, 	/* 0x7c4d */
        {8,	0}, 	/* 0x7c4e */
        {8,	0}, 	/* 0x7c4f */
        {8,	0}, 	/* 0x7c50 */
        {8,	0}, 	/* 0x7c51 */
        {8,	0}, 	/* 0x7c52 */
        {8,	0}, 	/* 0x7c53 */
        {8,	0}, 	/* 0x7c54 */
        {8,	0}, 	/* 0x7c55 */
        {8,	0}, 	/* 0x7c56 */
        {8,	0}, 	/* 0x7c57 */
        {8,	0}, 	/* 0x7c58 */
        {8,	0}, 	/* 0x7c59 */
        {8,	0}, 	/* 0x7c5a */
        {8,	0}, 	/* 0x7c5b */
        {8,	0}, 	/* 0x7c5c */
        {8,	0}, 	/* 0x7c5d */
        {8,	0}, 	/* 0x7c5e */
        {8,	0}, 	/* 0x7c5f */
        {8,	0}, 	/* 0x7c60 */
        {8,	0}, 	/* 0x7c61 */
        {8,	0}, 	/* 0x7c62 */
        {8,	0}, 	/* 0x7c63 */
        {8,	0}, 	/* 0x7c64 */
        {8,	0}, 	/* 0x7c65 */
        {8,	0}, 	/* 0x7c66 */
        {8,	0}, 	/* 0x7c67 */
        {8,	0}, 	/* 0x7c68 */
        {8,	0}, 	/* 0x7c69 */
        {8,	0}, 	/* 0x7c6a */
        {8,	0}, 	/* 0x7c6b */
        {8,	0}, 	/* 0x7c6c */
        {8,	0}, 	/* 0x7c6d */
        {8,	0}, 	/* 0x7c6e */
        {8,	0}, 	/* 0x7c6f */
        {8,	0}, 	/* 0x7c70 */
        {8,	0}, 	/* 0x7c71 */
        {8,	0}, 	/* 0x7c72 */
        {8,	0}, 	/* 0x7c73 */
        {8,	0}, 	/* 0x7c74 */
        {8,	0}, 	/* 0x7c75 */
        {8,	0}, 	/* 0x7c76 */
        {8,	0}, 	/* 0x7c77 */
        {8,	0}, 	/* 0x7c78 */
        {8,	0}, 	/* 0x7c79 */
        {8,	0}, 	/* 0x7c7a */
        {8,	0}, 	/* 0x7c7b */
        {8,	0}, 	/* 0x7c7c */
        {8,	0}, 	/* 0x7c7d */
        {8,	0}, 	/* 0x7c7e */
        {8,	0}, 	/* 0x7c7f */
        {8,	0}, 	/* 0x7c80 */
        {8,	0}, 	/* 0x7c81 */
        {8,	0}, 	/* 0x7c82 */
        {8,	0}, 	/* 0x7c83 */
        {8,	0}, 	/* 0x7c84 */
        {8,	0}, 	/* 0x7c85 */
        {8,	0}, 	/* 0x7c86 */
        {8,	0}, 	/* 0x7c87 */
        {8,	0}, 	/* 0x7c88 */
        {8,	0}, 	/* 0x7c89 */
        {8,	0}, 	/* 0x7c8a */
        {8,	0}, 	/* 0x7c8b */
        {8,	0}, 	/* 0x7c8c */
        {8,	0}, 	/* 0x7c8d */
        {8,	0}, 	/* 0x7c8e */
        {8,	0}, 	/* 0x7c8f */
        {8,	0}, 	/* 0x7c90 */
        {8,	0}, 	/* 0x7c91 */
        {8,	0}, 	/* 0x7c92 */
        {8,	0}, 	/* 0x7c93 */
        {8,	0}, 	/* 0x7c94 */
        {8,	0}, 	/* 0x7c95 */
        {8,	0}, 	/* 0x7c96 */
        {8,	0}, 	/* 0x7c97 */
        {8,	0}, 	/* 0x7c98 */
        {8,	0}, 	/* 0x7c99 */
        {8,	0}, 	/* 0x7c9a */
        {8,	0}, 	/* 0x7c9b */
        {8,	0}, 	/* 0x7c9c */
        {8,	0}, 	/* 0x7c9d */
        {8,	0}, 	/* 0x7c9e */
        {8,	0}, 	/* 0x7c9f */
        {8,	0}, 	/* 0x7ca0 */
        {8,	0}, 	/* 0x7ca1 */
        {8,	0}, 	/* 0x7ca2 */
        {8,	0}, 	/* 0x7ca3 */
        {8,	0}, 	/* 0x7ca4 */
        {8,	0}, 	/* 0x7ca5 */
        {8,	0}, 	/* 0x7ca6 */
        {8,	0}, 	/* 0x7ca7 */
        {8,	0}, 	/* 0x7ca8 */
        {8,	0}, 	/* 0x7ca9 */
        {8,	0}, 	/* 0x7caa */
        {8,	0}, 	/* 0x7cab */
        {8,	0}, 	/* 0x7cac */
        {8,	0}, 	/* 0x7cad */
        {8,	0}, 	/* 0x7cae */
        {8,	0}, 	/* 0x7caf */
        {8,	0}, 	/* 0x7cb0 */
        {8,	0}, 	/* 0x7cb1 */
        {8,	0}, 	/* 0x7cb2 */
        {8,	0}, 	/* 0x7cb3 */
        {8,	0}, 	/* 0x7cb4 */
        {8,	0}, 	/* 0x7cb5 */
        {8,	0}, 	/* 0x7cb6 */
        {8,	0}, 	/* 0x7cb7 */
        {8,	0}, 	/* 0x7cb8 */
        {8,	0}, 	/* 0x7cb9 */
        {8,	0}, 	/* 0x7cba */
        {8,	0}, 	/* 0x7cbb */
        {8,	0}, 	/* 0x7cbc */
        {8,	0}, 	/* 0x7cbd */
        {8,	0}, 	/* 0x7cbe */
        {8,	0}, 	/* 0x7cbf */
        {8,	0}, 	/* 0x7cc0 */
        {8,	0}, 	/* 0x7cc1 */
        {8,	0}, 	/* 0x7cc2 */
        {8,	0}, 	/* 0x7cc3 */
        {8,	0}, 	/* 0x7cc4 */
        {8,	0}, 	/* 0x7cc5 */
        {8,	0}, 	/* 0x7cc6 */
        {8,	0}, 	/* 0x7cc7 */
        {8,	0}, 	/* 0x7cc8 */
        {8,	0}, 	/* 0x7cc9 */
        {8,	0}, 	/* 0x7cca */
        {8,	0}, 	/* 0x7ccb */
        {8,	0}, 	/* 0x7ccc */
        {8,	0}, 	/* 0x7ccd */
        {8,	0}, 	/* 0x7cce */
        {8,	0}, 	/* 0x7ccf */
        {8,	0}, 	/* 0x7cd0 */
        {8,	0}, 	/* 0x7cd1 */
        {8,	0}, 	/* 0x7cd2 */
        {8,	0}, 	/* 0x7cd3 */
        {8,	0}, 	/* 0x7cd4 */
        {8,	0}, 	/* 0x7cd5 */
        {8,	0}, 	/* 0x7cd6 */
        {8,	0}, 	/* 0x7cd7 */
        {8,	0}, 	/* 0x7cd8 */
        {8,	0}, 	/* 0x7cd9 */
        {8,	0}, 	/* 0x7cda */
        {8,	0}, 	/* 0x7cdb */
        {8,	0}, 	/* 0x7cdc */
        {8,	0}, 	/* 0x7cdd */
        {8,	0}, 	/* 0x7cde */
        {8,	0}, 	/* 0x7cdf */
        {8,	0}, 	/* 0x7ce0 */
        {8,	0}, 	/* 0x7ce1 */
        {8,	0}, 	/* 0x7ce2 */
        {8,	0}, 	/* 0x7ce3 */
        {8,	0}, 	/* 0x7ce4 */
        {8,	0}, 	/* 0x7ce5 */
        {8,	0}, 	/* 0x7ce6 */
        {8,	0}, 	/* 0x7ce7 */
        {8,	0}, 	/* 0x7ce8 */
        {8,	0}, 	/* 0x7ce9 */
        {8,	0}, 	/* 0x7cea */
        {8,	0}, 	/* 0x7ceb */
        {8,	0}, 	/* 0x7cec */
        {8,	0}, 	/* 0x7ced */
        {8,	0}, 	/* 0x7cee */
        {8,	0}, 	/* 0x7cef */
        {8,	0}, 	/* 0x7cf0 */
        {8,	0}, 	/* 0x7cf1 */
        {8,	0}, 	/* 0x7cf2 */
        {8,	0}, 	/* 0x7cf3 */
        {8,	0}, 	/* 0x7cf4 */
        {8,	0}, 	/* 0x7cf5 */
        {8,	0}, 	/* 0x7cf6 */
        {8,	0}, 	/* 0x7cf7 */
        {8,	0}, 	/* 0x7cf8 */
        {8,	0}, 	/* 0x7cf9 */
        {8,	0}, 	/* 0x7cfa */
        {8,	0}, 	/* 0x7cfb */
        {8,	0}, 	/* 0x7cfc */
        {8,	0}, 	/* 0x7cfd */
        {8,	0}, 	/* 0x7cfe */
        {8,	0}, 	/* 0x7cff */
        {8,	0}, 	/* 0x7d00 */
        {8,	0}, 	/* 0x7d01 */
        {8,	0}, 	/* 0x7d02 */
        {8,	0}, 	/* 0x7d03 */
        {8,	0}, 	/* 0x7d04 */
        {8,	0}, 	/* 0x7d05 */
        {8,	0}, 	/* 0x7d06 */
        {8,	0}, 	/* 0x7d07 */
        {8,	0}, 	/* 0x7d08 */
        {8,	0}, 	/* 0x7d09 */
        {8,	0}, 	/* 0x7d0a */
        {8,	0}, 	/* 0x7d0b */
        {8,	0}, 	/* 0x7d0c */
        {8,	0}, 	/* 0x7d0d */
        {8,	0}, 	/* 0x7d0e */
        {8,	0}, 	/* 0x7d0f */
        {8,	0}, 	/* 0x7d10 */
        {8,	0}, 	/* 0x7d11 */
        {8,	0}, 	/* 0x7d12 */
        {8,	0}, 	/* 0x7d13 */
        {8,	0}, 	/* 0x7d14 */
        {8,	0}, 	/* 0x7d15 */
        {8,	0}, 	/* 0x7d16 */
        {8,	0}, 	/* 0x7d17 */
        {8,	0}, 	/* 0x7d18 */
        {8,	0}, 	/* 0x7d19 */
        {8,	0}, 	/* 0x7d1a */
        {8,	0}, 	/* 0x7d1b */
        {8,	0}, 	/* 0x7d1c */
        {8,	0}, 	/* 0x7d1d */
        {8,	0}, 	/* 0x7d1e */
        {8,	0}, 	/* 0x7d1f */
        {8,	0}, 	/* 0x7d20 */
        {8,	0}, 	/* 0x7d21 */
        {8,	0}, 	/* 0x7d22 */
        {8,	0}, 	/* 0x7d23 */
        {8,	0}, 	/* 0x7d24 */
        {8,	0}, 	/* 0x7d25 */
        {8,	0}, 	/* 0x7d26 */
        {8,	0}, 	/* 0x7d27 */
        {8,	0}, 	/* 0x7d28 */
        {8,	0}, 	/* 0x7d29 */
        {8,	0}, 	/* 0x7d2a */
        {8,	0}, 	/* 0x7d2b */
        {8,	0}, 	/* 0x7d2c */
        {8,	0}, 	/* 0x7d2d */
        {8,	0}, 	/* 0x7d2e */
        {8,	0}, 	/* 0x7d2f */
        {8,	0}, 	/* 0x7d30 */
        {8,	0}, 	/* 0x7d31 */
        {8,	0}, 	/* 0x7d32 */
        {8,	0}, 	/* 0x7d33 */
        {8,	0}, 	/* 0x7d34 */
        {8,	0}, 	/* 0x7d35 */
        {8,	0}, 	/* 0x7d36 */
        {8,	0}, 	/* 0x7d37 */
        {8,	0}, 	/* 0x7d38 */
        {8,	0}, 	/* 0x7d39 */
        {8,	0}, 	/* 0x7d3a */
        {8,	0}, 	/* 0x7d3b */
        {8,	0}, 	/* 0x7d3c */
        {8,	0}, 	/* 0x7d3d */
        {8,	0}, 	/* 0x7d3e */
        {8,	0}, 	/* 0x7d3f */
        {8,	0}, 	/* 0x7d40 */
        {8,	0}, 	/* 0x7d41 */
        {8,	0}, 	/* 0x7d42 */
        {8,	0}, 	/* 0x7d43 */
        {8,	0}, 	/* 0x7d44 */
        {8,	0}, 	/* 0x7d45 */
        {8,	0}, 	/* 0x7d46 */
        {8,	0}, 	/* 0x7d47 */
        {8,	0}, 	/* 0x7d48 */
        {8,	0}, 	/* 0x7d49 */
        {8,	0}, 	/* 0x7d4a */
        {8,	0}, 	/* 0x7d4b */
        {8,	0}, 	/* 0x7d4c */
        {8,	0}, 	/* 0x7d4d */
        {8,	0}, 	/* 0x7d4e */
        {8,	0}, 	/* 0x7d4f */
        {8,	0}, 	/* 0x7d50 */
        {8,	0}, 	/* 0x7d51 */
        {8,	0}, 	/* 0x7d52 */
        {8,	0}, 	/* 0x7d53 */
        {8,	0}, 	/* 0x7d54 */
        {8,	0}, 	/* 0x7d55 */
        {8,	0}, 	/* 0x7d56 */
        {8,	0}, 	/* 0x7d57 */
        {8,	0}, 	/* 0x7d58 */
        {8,	0}, 	/* 0x7d59 */
        {8,	0}, 	/* 0x7d5a */
        {8,	0}, 	/* 0x7d5b */
        {8,	0}, 	/* 0x7d5c */
        {8,	0}, 	/* 0x7d5d */
        {8,	0}, 	/* 0x7d5e */
        {8,	0}, 	/* 0x7d5f */
        {8,	0}, 	/* 0x7d60 */
        {8,	0}, 	/* 0x7d61 */
        {8,	0}, 	/* 0x7d62 */
        {8,	0}, 	/* 0x7d63 */
        {8,	0}, 	/* 0x7d64 */
        {8,	0}, 	/* 0x7d65 */
        {8,	0}, 	/* 0x7d66 */
        {8,	0}, 	/* 0x7d67 */
        {8,	0}, 	/* 0x7d68 */
        {8,	0}, 	/* 0x7d69 */
        {8,	0}, 	/* 0x7d6a */
        {8,	0}, 	/* 0x7d6b */
        {8,	0}, 	/* 0x7d6c */
        {8,	0}, 	/* 0x7d6d */
        {8,	0}, 	/* 0x7d6e */
        {8,	0}, 	/* 0x7d6f */
        {8,	0}, 	/* 0x7d70 */
        {8,	0}, 	/* 0x7d71 */
        {8,	0}, 	/* 0x7d72 */
        {8,	0}, 	/* 0x7d73 */
        {8,	0}, 	/* 0x7d74 */
        {8,	0}, 	/* 0x7d75 */
        {8,	0}, 	/* 0x7d76 */
        {8,	0}, 	/* 0x7d77 */
        {8,	0}, 	/* 0x7d78 */
        {8,	0}, 	/* 0x7d79 */
        {8,	0}, 	/* 0x7d7a */
        {8,	0}, 	/* 0x7d7b */
        {8,	0}, 	/* 0x7d7c */
        {8,	0}, 	/* 0x7d7d */
        {8,	0}, 	/* 0x7d7e */
        {8,	0}, 	/* 0x7d7f */
        {8,	0}, 	/* 0x7d80 */
        {8,	0}, 	/* 0x7d81 */
        {8,	0}, 	/* 0x7d82 */
        {8,	0}, 	/* 0x7d83 */
        {8,	0}, 	/* 0x7d84 */
        {8,	0}, 	/* 0x7d85 */
        {8,	0}, 	/* 0x7d86 */
        {8,	0}, 	/* 0x7d87 */
        {8,	0}, 	/* 0x7d88 */
        {8,	0}, 	/* 0x7d89 */
        {8,	0}, 	/* 0x7d8a */
        {8,	0}, 	/* 0x7d8b */
        {8,	0}, 	/* 0x7d8c */
        {8,	0}, 	/* 0x7d8d */
        {8,	0}, 	/* 0x7d8e */
        {8,	0}, 	/* 0x7d8f */
        {8,	0}, 	/* 0x7d90 */
        {8,	0}, 	/* 0x7d91 */
        {8,	0}, 	/* 0x7d92 */
        {8,	0}, 	/* 0x7d93 */
        {8,	0}, 	/* 0x7d94 */
        {8,	0}, 	/* 0x7d95 */
        {8,	0}, 	/* 0x7d96 */
        {8,	0}, 	/* 0x7d97 */
        {8,	0}, 	/* 0x7d98 */
        {8,	0}, 	/* 0x7d99 */
        {8,	0}, 	/* 0x7d9a */
        {8,	0}, 	/* 0x7d9b */
        {8,	0}, 	/* 0x7d9c */
        {8,	0}, 	/* 0x7d9d */
        {8,	0}, 	/* 0x7d9e */
        {8,	0}, 	/* 0x7d9f */
        {8,	0}, 	/* 0x7da0 */
        {8,	0}, 	/* 0x7da1 */
        {8,	0}, 	/* 0x7da2 */
        {8,	0}, 	/* 0x7da3 */
        {8,	0}, 	/* 0x7da4 */
        {8,	0}, 	/* 0x7da5 */
        {8,	0}, 	/* 0x7da6 */
        {8,	0}, 	/* 0x7da7 */
        {8,	0}, 	/* 0x7da8 */
        {8,	0}, 	/* 0x7da9 */
        {8,	0}, 	/* 0x7daa */
        {8,	0}, 	/* 0x7dab */
        {8,	0}, 	/* 0x7dac */
        {8,	0}, 	/* 0x7dad */
        {8,	0}, 	/* 0x7dae */
        {8,	0}, 	/* 0x7daf */
        {8,	0}, 	/* 0x7db0 */
        {8,	0}, 	/* 0x7db1 */
        {8,	0}, 	/* 0x7db2 */
        {8,	0}, 	/* 0x7db3 */
        {8,	0}, 	/* 0x7db4 */
        {8,	0}, 	/* 0x7db5 */
        {8,	0}, 	/* 0x7db6 */
        {8,	0}, 	/* 0x7db7 */
        {8,	0}, 	/* 0x7db8 */
        {8,	0}, 	/* 0x7db9 */
        {8,	0}, 	/* 0x7dba */
        {8,	0}, 	/* 0x7dbb */
        {8,	0}, 	/* 0x7dbc */
        {8,	0}, 	/* 0x7dbd */
        {8,	0}, 	/* 0x7dbe */
        {8,	0}, 	/* 0x7dbf */
        {8,	0}, 	/* 0x7dc0 */
        {8,	0}, 	/* 0x7dc1 */
        {8,	0}, 	/* 0x7dc2 */
        {8,	0}, 	/* 0x7dc3 */
        {8,	0}, 	/* 0x7dc4 */
        {8,	0}, 	/* 0x7dc5 */
        {8,	0}, 	/* 0x7dc6 */
        {8,	0}, 	/* 0x7dc7 */
        {8,	0}, 	/* 0x7dc8 */
        {8,	0}, 	/* 0x7dc9 */
        {8,	0}, 	/* 0x7dca */
        {8,	0}, 	/* 0x7dcb */
        {8,	0}, 	/* 0x7dcc */
        {8,	0}, 	/* 0x7dcd */
        {8,	0}, 	/* 0x7dce */
        {8,	0}, 	/* 0x7dcf */
        {8,	0}, 	/* 0x7dd0 */
        {8,	0}, 	/* 0x7dd1 */
        {8,	0}, 	/* 0x7dd2 */
        {8,	0}, 	/* 0x7dd3 */
        {8,	0}, 	/* 0x7dd4 */
        {8,	0}, 	/* 0x7dd5 */
        {8,	0}, 	/* 0x7dd6 */
        {8,	0}, 	/* 0x7dd7 */
        {8,	0}, 	/* 0x7dd8 */
        {8,	0}, 	/* 0x7dd9 */
        {8,	0}, 	/* 0x7dda */
        {8,	0}, 	/* 0x7ddb */
        {8,	0}, 	/* 0x7ddc */
        {8,	0}, 	/* 0x7ddd */
        {8,	0}, 	/* 0x7dde */
        {8,	0}, 	/* 0x7ddf */
        {8,	0}, 	/* 0x7de0 */
        {8,	0}, 	/* 0x7de1 */
        {8,	0}, 	/* 0x7de2 */
        {8,	0}, 	/* 0x7de3 */
        {8,	0}, 	/* 0x7de4 */
        {8,	0}, 	/* 0x7de5 */
        {8,	0}, 	/* 0x7de6 */
        {8,	0}, 	/* 0x7de7 */
        {8,	0}, 	/* 0x7de8 */
        {8,	0}, 	/* 0x7de9 */
        {8,	0}, 	/* 0x7dea */
        {8,	0}, 	/* 0x7deb */
        {8,	0}, 	/* 0x7dec */
        {8,	0}, 	/* 0x7ded */
        {8,	0}, 	/* 0x7dee */
        {8,	0}, 	/* 0x7def */
        {8,	0}, 	/* 0x7df0 */
        {8,	0}, 	/* 0x7df1 */
        {8,	0}, 	/* 0x7df2 */
        {8,	0}, 	/* 0x7df3 */
        {8,	0}, 	/* 0x7df4 */
        {8,	0}, 	/* 0x7df5 */
        {8,	0}, 	/* 0x7df6 */
        {8,	0}, 	/* 0x7df7 */
        {8,	0}, 	/* 0x7df8 */
        {8,	0}, 	/* 0x7df9 */
        {8,	0}, 	/* 0x7dfa */
        {8,	0}, 	/* 0x7dfb */
        {8,	0}, 	/* 0x7dfc */
        {8,	0}, 	/* 0x7dfd */
        {8,	0}, 	/* 0x7dfe */
        {8,	0}, 	/* 0x7dff */
        {8,	0}, 	/* 0x7e00 */
        {8,	0}, 	/* 0x7e01 */
        {8,	0}, 	/* 0x7e02 */
        {8,	0}, 	/* 0x7e03 */
        {8,	0}, 	/* 0x7e04 */
        {8,	0}, 	/* 0x7e05 */
        {8,	0}, 	/* 0x7e06 */
        {8,	0}, 	/* 0x7e07 */
        {8,	0}, 	/* 0x7e08 */
        {8,	0}, 	/* 0x7e09 */
        {8,	0}, 	/* 0x7e0a */
        {8,	0}, 	/* 0x7e0b */
        {8,	0}, 	/* 0x7e0c */
        {8,	0}, 	/* 0x7e0d */
        {8,	0}, 	/* 0x7e0e */
        {8,	0}, 	/* 0x7e0f */
        {8,	0}, 	/* 0x7e10 */
        {8,	0}, 	/* 0x7e11 */
        {8,	0}, 	/* 0x7e12 */
        {8,	0}, 	/* 0x7e13 */
        {8,	0}, 	/* 0x7e14 */
        {8,	0}, 	/* 0x7e15 */
        {8,	0}, 	/* 0x7e16 */
        {8,	0}, 	/* 0x7e17 */
        {8,	0}, 	/* 0x7e18 */
        {8,	0}, 	/* 0x7e19 */
        {8,	0}, 	/* 0x7e1a */
        {8,	0}, 	/* 0x7e1b */
        {8,	0}, 	/* 0x7e1c */
        {8,	0}, 	/* 0x7e1d */
        {8,	0}, 	/* 0x7e1e */
        {8,	0}, 	/* 0x7e1f */
        {8,	0}, 	/* 0x7e20 */
        {8,	0}, 	/* 0x7e21 */
        {8,	0}, 	/* 0x7e22 */
        {8,	0}, 	/* 0x7e23 */
        {8,	0}, 	/* 0x7e24 */
        {8,	0}, 	/* 0x7e25 */
        {8,	0}, 	/* 0x7e26 */
        {8,	0}, 	/* 0x7e27 */
        {8,	0}, 	/* 0x7e28 */
        {8,	0}, 	/* 0x7e29 */
        {8,	0}, 	/* 0x7e2a */
        {8,	0}, 	/* 0x7e2b */
        {8,	0}, 	/* 0x7e2c */
        {8,	0}, 	/* 0x7e2d */
        {8,	0}, 	/* 0x7e2e */
        {8,	0}, 	/* 0x7e2f */
        {8,	0}, 	/* 0x7e30 */
        {8,	0}, 	/* 0x7e31 */
        {8,	0}, 	/* 0x7e32 */
        {8,	0}, 	/* 0x7e33 */
        {8,	0}, 	/* 0x7e34 */
        {8,	0}, 	/* 0x7e35 */
        {8,	0}, 	/* 0x7e36 */
        {8,	0}, 	/* 0x7e37 */
        {8,	0}, 	/* 0x7e38 */
        {8,	0}, 	/* 0x7e39 */
        {8,	0}, 	/* 0x7e3a */
        {8,	0}, 	/* 0x7e3b */
        {8,	0}, 	/* 0x7e3c */
        {8,	0}, 	/* 0x7e3d */
        {8,	0}, 	/* 0x7e3e */
        {8,	0}, 	/* 0x7e3f */
        {8,	0}, 	/* 0x7e40 */
        {8,	0}, 	/* 0x7e41 */
        {8,	0}, 	/* 0x7e42 */
        {8,	0}, 	/* 0x7e43 */
        {8,	0}, 	/* 0x7e44 */
        {8,	0}, 	/* 0x7e45 */
        {8,	0}, 	/* 0x7e46 */
        {8,	0}, 	/* 0x7e47 */
        {8,	0}, 	/* 0x7e48 */
        {8,	0}, 	/* 0x7e49 */
        {8,	0}, 	/* 0x7e4a */
        {8,	0}, 	/* 0x7e4b */
        {8,	0}, 	/* 0x7e4c */
        {8,	0}, 	/* 0x7e4d */
        {8,	0}, 	/* 0x7e4e */
        {8,	0}, 	/* 0x7e4f */
        {8,	0}, 	/* 0x7e50 */
        {8,	0}, 	/* 0x7e51 */
        {8,	0}, 	/* 0x7e52 */
        {8,	0}, 	/* 0x7e53 */
        {8,	0}, 	/* 0x7e54 */
        {8,	0}, 	/* 0x7e55 */
        {8,	0}, 	/* 0x7e56 */
        {8,	0}, 	/* 0x7e57 */
        {8,	0}, 	/* 0x7e58 */
        {8,	0}, 	/* 0x7e59 */
        {8,	0}, 	/* 0x7e5a */
        {8,	0}, 	/* 0x7e5b */
        {8,	0}, 	/* 0x7e5c */
        {8,	0}, 	/* 0x7e5d */
        {8,	0}, 	/* 0x7e5e */
        {8,	0}, 	/* 0x7e5f */
        {8,	0}, 	/* 0x7e60 */
        {8,	0}, 	/* 0x7e61 */
        {8,	0}, 	/* 0x7e62 */
        {8,	0}, 	/* 0x7e63 */
        {8,	0}, 	/* 0x7e64 */
        {8,	0}, 	/* 0x7e65 */
        {8,	0}, 	/* 0x7e66 */
        {8,	0}, 	/* 0x7e67 */
        {8,	0}, 	/* 0x7e68 */
        {8,	0}, 	/* 0x7e69 */
        {8,	0}, 	/* 0x7e6a */
        {8,	0}, 	/* 0x7e6b */
        {8,	0}, 	/* 0x7e6c */
        {8,	0}, 	/* 0x7e6d */
        {8,	0}, 	/* 0x7e6e */
        {8,	0}, 	/* 0x7e6f */
        {8,	0}, 	/* 0x7e70 */
        {8,	0}, 	/* 0x7e71 */
        {8,	0}, 	/* 0x7e72 */
        {8,	0}, 	/* 0x7e73 */
        {8,	0}, 	/* 0x7e74 */
        {8,	0}, 	/* 0x7e75 */
        {8,	0}, 	/* 0x7e76 */
        {8,	0}, 	/* 0x7e77 */
        {8,	0}, 	/* 0x7e78 */
        {8,	0}, 	/* 0x7e79 */
        {8,	0}, 	/* 0x7e7a */
        {8,	0}, 	/* 0x7e7b */
        {8,	0}, 	/* 0x7e7c */
        {8,	0}, 	/* 0x7e7d */
        {8,	0}, 	/* 0x7e7e */
        {8,	0}, 	/* 0x7e7f */
        {8,	0}, 	/* 0x7e80 */
        {8,	0}, 	/* 0x7e81 */
        {8,	0}, 	/* 0x7e82 */
        {8,	0}, 	/* 0x7e83 */
        {8,	0}, 	/* 0x7e84 */
        {8,	0}, 	/* 0x7e85 */
        {8,	0}, 	/* 0x7e86 */
        {8,	0}, 	/* 0x7e87 */
        {8,	0}, 	/* 0x7e88 */
        {8,	0}, 	/* 0x7e89 */
        {8,	0}, 	/* 0x7e8a */
        {8,	0}, 	/* 0x7e8b */
        {8,	0}, 	/* 0x7e8c */
        {8,	0}, 	/* 0x7e8d */
        {8,	0}, 	/* 0x7e8e */
        {8,	0}, 	/* 0x7e8f */
        {8,	0}, 	/* 0x7e90 */
        {8,	0}, 	/* 0x7e91 */
        {8,	0}, 	/* 0x7e92 */
        {8,	0}, 	/* 0x7e93 */
        {8,	0}, 	/* 0x7e94 */
        {8,	0}, 	/* 0x7e95 */
        {8,	0}, 	/* 0x7e96 */
        {8,	0}, 	/* 0x7e97 */
        {8,	0}, 	/* 0x7e98 */
        {8,	0}, 	/* 0x7e99 */
        {8,	0}, 	/* 0x7e9a */
        {8,	0}, 	/* 0x7e9b */
        {8,	0}, 	/* 0x7e9c */
        {8,	0}, 	/* 0x7e9d */
        {8,	0}, 	/* 0x7e9e */
        {8,	0}, 	/* 0x7e9f */
        {8,	0}, 	/* 0x7ea0 */
        {8,	0}, 	/* 0x7ea1 */
        {8,	0}, 	/* 0x7ea2 */
        {8,	0}, 	/* 0x7ea3 */
        {8,	0}, 	/* 0x7ea4 */
        {8,	0}, 	/* 0x7ea5 */
        {8,	0}, 	/* 0x7ea6 */
        {8,	0}, 	/* 0x7ea7 */
        {8,	0}, 	/* 0x7ea8 */
        {8,	0}, 	/* 0x7ea9 */
        {8,	0}, 	/* 0x7eaa */
        {8,	0}, 	/* 0x7eab */
        {8,	0}, 	/* 0x7eac */
        {8,	0}, 	/* 0x7ead */
        {8,	0}, 	/* 0x7eae */
        {8,	0}, 	/* 0x7eaf */
        {8,	0}, 	/* 0x7eb0 */
        {8,	0}, 	/* 0x7eb1 */
        {8,	0}, 	/* 0x7eb2 */
        {8,	0}, 	/* 0x7eb3 */
        {8,	0}, 	/* 0x7eb4 */
        {8,	0}, 	/* 0x7eb5 */
        {8,	0}, 	/* 0x7eb6 */
        {8,	0}, 	/* 0x7eb7 */
        {8,	0}, 	/* 0x7eb8 */
        {8,	0}, 	/* 0x7eb9 */
        {8,	0}, 	/* 0x7eba */
        {8,	0}, 	/* 0x7ebb */
        {8,	0}, 	/* 0x7ebc */
        {8,	0}, 	/* 0x7ebd */
        {8,	0}, 	/* 0x7ebe */
        {8,	0}, 	/* 0x7ebf */
        {8,	0}, 	/* 0x7ec0 */
        {8,	0}, 	/* 0x7ec1 */
        {8,	0}, 	/* 0x7ec2 */
        {8,	0}, 	/* 0x7ec3 */
        {8,	0}, 	/* 0x7ec4 */
        {8,	0}, 	/* 0x7ec5 */
        {8,	0}, 	/* 0x7ec6 */
        {8,	0}, 	/* 0x7ec7 */
        {8,	0}, 	/* 0x7ec8 */
        {8,	0}, 	/* 0x7ec9 */
        {8,	0}, 	/* 0x7eca */
        {8,	0}, 	/* 0x7ecb */
        {8,	0}, 	/* 0x7ecc */
        {8,	0}, 	/* 0x7ecd */
        {8,	0}, 	/* 0x7ece */
        {8,	0}, 	/* 0x7ecf */
        {8,	0}, 	/* 0x7ed0 */
        {8,	0}, 	/* 0x7ed1 */
        {8,	0}, 	/* 0x7ed2 */
        {8,	0}, 	/* 0x7ed3 */
        {8,	0}, 	/* 0x7ed4 */
        {8,	0}, 	/* 0x7ed5 */
        {8,	0}, 	/* 0x7ed6 */
        {8,	0}, 	/* 0x7ed7 */
        {8,	0}, 	/* 0x7ed8 */
        {8,	0}, 	/* 0x7ed9 */
        {8,	0}, 	/* 0x7eda */
        {8,	0}, 	/* 0x7edb */
        {8,	0}, 	/* 0x7edc */
        {8,	0}, 	/* 0x7edd */
        {8,	0}, 	/* 0x7ede */
        {8,	0}, 	/* 0x7edf */
        {8,	0}, 	/* 0x7ee0 */
        {8,	0}, 	/* 0x7ee1 */
        {8,	0}, 	/* 0x7ee2 */
        {8,	0}, 	/* 0x7ee3 */
        {8,	0}, 	/* 0x7ee4 */
        {8,	0}, 	/* 0x7ee5 */
        {8,	0}, 	/* 0x7ee6 */
        {8,	0}, 	/* 0x7ee7 */
        {8,	0}, 	/* 0x7ee8 */
        {8,	0}, 	/* 0x7ee9 */
        {8,	0}, 	/* 0x7eea */
        {8,	0}, 	/* 0x7eeb */
        {8,	0}, 	/* 0x7eec */
        {8,	0}, 	/* 0x7eed */
        {8,	0}, 	/* 0x7eee */
        {8,	0}, 	/* 0x7eef */
        {8,	0}, 	/* 0x7ef0 */
        {8,	0}, 	/* 0x7ef1 */
        {8,	0}, 	/* 0x7ef2 */
        {8,	0}, 	/* 0x7ef3 */
        {8,	0}, 	/* 0x7ef4 */
        {8,	0}, 	/* 0x7ef5 */
        {8,	0}, 	/* 0x7ef6 */
        {8,	0}, 	/* 0x7ef7 */
        {8,	0}, 	/* 0x7ef8 */
        {8,	0}, 	/* 0x7ef9 */
        {8,	0}, 	/* 0x7efa */
        {8,	0}, 	/* 0x7efb */
        {8,	0}, 	/* 0x7efc */
        {8,	0}, 	/* 0x7efd */
        {8,	0}, 	/* 0x7efe */
        {8,	0}, 	/* 0x7eff */
        {8,	0}, 	/* 0x7f00 */
        {8,	0}, 	/* 0x7f01 */
        {8,	0}, 	/* 0x7f02 */
        {8,	0}, 	/* 0x7f03 */
        {8,	0}, 	/* 0x7f04 */
        {8,	0}, 	/* 0x7f05 */
        {8,	0}, 	/* 0x7f06 */
        {8,	0}, 	/* 0x7f07 */
        {8,	0}, 	/* 0x7f08 */
        {8,	0}, 	/* 0x7f09 */
        {8,	0}, 	/* 0x7f0a */
        {8,	0}, 	/* 0x7f0b */
        {8,	0}, 	/* 0x7f0c */
        {8,	0}, 	/* 0x7f0d */
        {8,	0}, 	/* 0x7f0e */
        {8,	0}, 	/* 0x7f0f */
        {8,	0}, 	/* 0x7f10 */
        {8,	0}, 	/* 0x7f11 */
        {8,	0}, 	/* 0x7f12 */
        {8,	0}, 	/* 0x7f13 */
        {8,	0}, 	/* 0x7f14 */
        {8,	0}, 	/* 0x7f15 */
        {8,	0}, 	/* 0x7f16 */
        {8,	0}, 	/* 0x7f17 */
        {8,	0}, 	/* 0x7f18 */
        {8,	0}, 	/* 0x7f19 */
        {8,	0}, 	/* 0x7f1a */
        {8,	0}, 	/* 0x7f1b */
        {8,	0}, 	/* 0x7f1c */
        {8,	0}, 	/* 0x7f1d */
        {8,	0}, 	/* 0x7f1e */
        {8,	0}, 	/* 0x7f1f */
        {8,	0}, 	/* 0x7f20 */
        {8,	0}, 	/* 0x7f21 */
        {8,	0}, 	/* 0x7f22 */
        {8,	0}, 	/* 0x7f23 */
        {8,	0}, 	/* 0x7f24 */
        {8,	0}, 	/* 0x7f25 */
        {8,	0}, 	/* 0x7f26 */
        {8,	0}, 	/* 0x7f27 */
        {8,	0}, 	/* 0x7f28 */
        {8,	0}, 	/* 0x7f29 */
        {8,	0}, 	/* 0x7f2a */
        {8,	0}, 	/* 0x7f2b */
        {8,	0}, 	/* 0x7f2c */
        {8,	0}, 	/* 0x7f2d */
        {8,	0}, 	/* 0x7f2e */
        {8,	0}, 	/* 0x7f2f */
        {8,	0}, 	/* 0x7f30 */
        {8,	0}, 	/* 0x7f31 */
        {8,	0}, 	/* 0x7f32 */
        {8,	0}, 	/* 0x7f33 */
        {8,	0}, 	/* 0x7f34 */
        {8,	0}, 	/* 0x7f35 */
        {8,	0}, 	/* 0x7f36 */
        {8,	0}, 	/* 0x7f37 */
        {8,	0}, 	/* 0x7f38 */
        {8,	0}, 	/* 0x7f39 */
        {8,	0}, 	/* 0x7f3a */
        {8,	0}, 	/* 0x7f3b */
        {8,	0}, 	/* 0x7f3c */
        {8,	0}, 	/* 0x7f3d */
        {8,	0}, 	/* 0x7f3e */
        {8,	0}, 	/* 0x7f3f */
        {8,	0}, 	/* 0x7f40 */
        {8,	0}, 	/* 0x7f41 */
        {8,	0}, 	/* 0x7f42 */
        {8,	0}, 	/* 0x7f43 */
        {8,	0}, 	/* 0x7f44 */
        {8,	0}, 	/* 0x7f45 */
        {8,	0}, 	/* 0x7f46 */
        {8,	0}, 	/* 0x7f47 */
        {8,	0}, 	/* 0x7f48 */
        {8,	0}, 	/* 0x7f49 */
        {8,	0}, 	/* 0x7f4a */
        {8,	0}, 	/* 0x7f4b */
        {8,	0}, 	/* 0x7f4c */
        {8,	0}, 	/* 0x7f4d */
        {8,	0}, 	/* 0x7f4e */
        {8,	0}, 	/* 0x7f4f */
        {8,	0}, 	/* 0x7f50 */
        {8,	0}, 	/* 0x7f51 */
        {8,	0}, 	/* 0x7f52 */
        {8,	0}, 	/* 0x7f53 */
        {8,	0}, 	/* 0x7f54 */
        {8,	0}, 	/* 0x7f55 */
        {8,	0}, 	/* 0x7f56 */
        {8,	0}, 	/* 0x7f57 */
        {8,	0}, 	/* 0x7f58 */
        {8,	0}, 	/* 0x7f59 */
        {8,	0}, 	/* 0x7f5a */
        {8,	0}, 	/* 0x7f5b */
        {8,	0}, 	/* 0x7f5c */
        {8,	0}, 	/* 0x7f5d */
        {8,	0}, 	/* 0x7f5e */
        {8,	0}, 	/* 0x7f5f */
        {8,	0}, 	/* 0x7f60 */
        {8,	0}, 	/* 0x7f61 */
        {8,	0}, 	/* 0x7f62 */
        {8,	0}, 	/* 0x7f63 */
        {8,	0}, 	/* 0x7f64 */
        {8,	0}, 	/* 0x7f65 */
        {8,	0}, 	/* 0x7f66 */
        {8,	0}, 	/* 0x7f67 */
        {8,	0}, 	/* 0x7f68 */
        {8,	0}, 	/* 0x7f69 */
        {8,	0}, 	/* 0x7f6a */
        {8,	0}, 	/* 0x7f6b */
        {8,	0}, 	/* 0x7f6c */
        {8,	0}, 	/* 0x7f6d */
        {8,	0}, 	/* 0x7f6e */
        {8,	0}, 	/* 0x7f6f */
        {8,	0}, 	/* 0x7f70 */
        {8,	0}, 	/* 0x7f71 */
        {8,	0}, 	/* 0x7f72 */
        {8,	0}, 	/* 0x7f73 */
        {8,	0}, 	/* 0x7f74 */
        {8,	0}, 	/* 0x7f75 */
        {8,	0}, 	/* 0x7f76 */
        {8,	0}, 	/* 0x7f77 */
        {8,	0}, 	/* 0x7f78 */
        {8,	0}, 	/* 0x7f79 */
        {8,	0}, 	/* 0x7f7a */
        {8,	0}, 	/* 0x7f7b */
        {8,	0}, 	/* 0x7f7c */
        {8,	0}, 	/* 0x7f7d */
        {8,	0}, 	/* 0x7f7e */
        {8,	0}, 	/* 0x7f7f */
        {8,	0}, 	/* 0x7f80 */
        {8,	0}, 	/* 0x7f81 */
        {8,	0}, 	/* 0x7f82 */
        {8,	0}, 	/* 0x7f83 */
        {8,	0}, 	/* 0x7f84 */
        {8,	0}, 	/* 0x7f85 */
        {8,	0}, 	/* 0x7f86 */
        {8,	0}, 	/* 0x7f87 */
        {8,	0}, 	/* 0x7f88 */
        {8,	0}, 	/* 0x7f89 */
        {8,	0}, 	/* 0x7f8a */
        {8,	0}, 	/* 0x7f8b */
        {8,	0}, 	/* 0x7f8c */
        {8,	0}, 	/* 0x7f8d */
        {8,	0}, 	/* 0x7f8e */
        {8,	0}, 	/* 0x7f8f */
        {8,	0}, 	/* 0x7f90 */
        {8,	0}, 	/* 0x7f91 */
        {8,	0}, 	/* 0x7f92 */
        {8,	0}, 	/* 0x7f93 */
        {8,	0}, 	/* 0x7f94 */
        {8,	0}, 	/* 0x7f95 */
        {8,	0}, 	/* 0x7f96 */
        {8,	0}, 	/* 0x7f97 */
        {8,	0}, 	/* 0x7f98 */
        {8,	0}, 	/* 0x7f99 */
        {8,	0}, 	/* 0x7f9a */
        {8,	0}, 	/* 0x7f9b */
        {8,	0}, 	/* 0x7f9c */
        {8,	0}, 	/* 0x7f9d */
        {8,	0}, 	/* 0x7f9e */
        {8,	0}, 	/* 0x7f9f */
        {8,	0}, 	/* 0x7fa0 */
        {8,	0}, 	/* 0x7fa1 */
        {8,	0}, 	/* 0x7fa2 */
        {8,	0}, 	/* 0x7fa3 */
        {8,	0}, 	/* 0x7fa4 */
        {8,	0}, 	/* 0x7fa5 */
        {8,	0}, 	/* 0x7fa6 */
        {8,	0}, 	/* 0x7fa7 */
        {8,	0}, 	/* 0x7fa8 */
        {8,	0}, 	/* 0x7fa9 */
        {8,	0}, 	/* 0x7faa */
        {8,	0}, 	/* 0x7fab */
        {8,	0}, 	/* 0x7fac */
        {8,	0}, 	/* 0x7fad */
        {8,	0}, 	/* 0x7fae */
        {8,	0}, 	/* 0x7faf */
        {8,	0}, 	/* 0x7fb0 */
        {8,	0}, 	/* 0x7fb1 */
        {8,	0}, 	/* 0x7fb2 */
        {8,	0}, 	/* 0x7fb3 */
        {8,	0}, 	/* 0x7fb4 */
        {8,	0}, 	/* 0x7fb5 */
        {8,	0}, 	/* 0x7fb6 */
        {8,	0}, 	/* 0x7fb7 */
        {8,	0}, 	/* 0x7fb8 */
        {8,	0}, 	/* 0x7fb9 */
        {8,	0}, 	/* 0x7fba */
        {8,	0}, 	/* 0x7fbb */
        {8,	0}, 	/* 0x7fbc */
        {8,	0}, 	/* 0x7fbd */
        {8,	0}, 	/* 0x7fbe */
        {8,	0}, 	/* 0x7fbf */
        {8,	0}, 	/* 0x7fc0 */
        {8,	0}, 	/* 0x7fc1 */
        {8,	0}, 	/* 0x7fc2 */
        {8,	0}, 	/* 0x7fc3 */
        {8,	0}, 	/* 0x7fc4 */
        {8,	0}, 	/* 0x7fc5 */
        {8,	0}, 	/* 0x7fc6 */
        {8,	0}, 	/* 0x7fc7 */
        {8,	0}, 	/* 0x7fc8 */
        {8,	0}, 	/* 0x7fc9 */
        {8,	0}, 	/* 0x7fca */
        {8,	0}, 	/* 0x7fcb */
        {8,	0}, 	/* 0x7fcc */
        {8,	0}, 	/* 0x7fcd */
        {8,	0}, 	/* 0x7fce */
        {8,	0}, 	/* 0x7fcf */
        {8,	0}, 	/* 0x7fd0 */
        {8,	0}, 	/* 0x7fd1 */
        {8,	0}, 	/* 0x7fd2 */
        {8,	0}, 	/* 0x7fd3 */
        {8,	0}, 	/* 0x7fd4 */
        {8,	0}, 	/* 0x7fd5 */
        {8,	0}, 	/* 0x7fd6 */
        {8,	0}, 	/* 0x7fd7 */
        {8,	0}, 	/* 0x7fd8 */
        {8,	0}, 	/* 0x7fd9 */
        {8,	0}, 	/* 0x7fda */
        {8,	0}, 	/* 0x7fdb */
        {8,	0}, 	/* 0x7fdc */
        {8,	0}, 	/* 0x7fdd */
        {8,	0}, 	/* 0x7fde */
        {8,	0}, 	/* 0x7fdf */
        {8,	0}, 	/* 0x7fe0 */
        {8,	0}, 	/* 0x7fe1 */
        {8,	0}, 	/* 0x7fe2 */
        {8,	0}, 	/* 0x7fe3 */
        {8,	0}, 	/* 0x7fe4 */
        {8,	0}, 	/* 0x7fe5 */
        {8,	0}, 	/* 0x7fe6 */
        {8,	0}, 	/* 0x7fe7 */
        {8,	0}, 	/* 0x7fe8 */
        {8,	0}, 	/* 0x7fe9 */
        {8,	0}, 	/* 0x7fea */
        {8,	0}, 	/* 0x7feb */
        {8,	0}, 	/* 0x7fec */
        {8,	0}, 	/* 0x7fed */
        {8,	0}, 	/* 0x7fee */
        {8,	0}, 	/* 0x7fef */
        {8,	0}, 	/* 0x7ff0 */
        {8,	0}, 	/* 0x7ff1 */
        {8,	0}, 	/* 0x7ff2 */
        {8,	0}, 	/* 0x7ff3 */
        {8,	0}, 	/* 0x7ff4 */
        {8,	0}, 	/* 0x7ff5 */
        {8,	0}, 	/* 0x7ff6 */
        {8,	0}, 	/* 0x7ff7 */
        {8,	0}, 	/* 0x7ff8 */
        {8,	0}, 	/* 0x7ff9 */
        {8,	0}, 	/* 0x7ffa */
        {8,	0}, 	/* 0x7ffb */
        {8,	0}, 	/* 0x7ffc */
        {8,	0}, 	/* 0x7ffd */
        {8,	0}, 	/* 0x7ffe */
        {8,	0}, 	/* 0x7fff */
        {8,	0}, 	/* 0x8000 */
        {8,	0}, 	/* 0x8001 */
        {8,	0}, 	/* 0x8002 */
        {8,	0}, 	/* 0x8003 */
        {8,	0}, 	/* 0x8004 */
        {8,	0}, 	/* 0x8005 */
        {8,	0}, 	/* 0x8006 */
        {8,	0}, 	/* 0x8007 */
        {8,	0}, 	/* 0x8008 */
        {8,	0}, 	/* 0x8009 */
        {8,	0}, 	/* 0x800a */
        {8,	0}, 	/* 0x800b */
        {8,	0}, 	/* 0x800c */
        {8,	0}, 	/* 0x800d */
        {8,	0}, 	/* 0x800e */
        {8,	0}, 	/* 0x800f */
        {8,	0}, 	/* 0x8010 */
        {8,	0}, 	/* 0x8011 */
        {8,	0}, 	/* 0x8012 */
        {8,	0}, 	/* 0x8013 */
        {8,	0}, 	/* 0x8014 */
        {8,	0}, 	/* 0x8015 */
        {8,	0}, 	/* 0x8016 */
        {8,	0}, 	/* 0x8017 */
        {8,	0}, 	/* 0x8018 */
        {8,	0}, 	/* 0x8019 */
        {8,	0}, 	/* 0x801a */
        {8,	0}, 	/* 0x801b */
        {8,	0}, 	/* 0x801c */
        {8,	0}, 	/* 0x801d */
        {8,	0}, 	/* 0x801e */
        {8,	0}, 	/* 0x801f */
        {8,	0}, 	/* 0x8020 */
        {8,	0}, 	/* 0x8021 */
        {8,	0}, 	/* 0x8022 */
        {8,	0}, 	/* 0x8023 */
        {8,	0}, 	/* 0x8024 */
        {8,	0}, 	/* 0x8025 */
        {8,	0}, 	/* 0x8026 */
        {8,	0}, 	/* 0x8027 */
        {8,	0}, 	/* 0x8028 */
        {8,	0}, 	/* 0x8029 */
        {8,	0}, 	/* 0x802a */
        {8,	0}, 	/* 0x802b */
        {8,	0}, 	/* 0x802c */
        {8,	0}, 	/* 0x802d */
        {8,	0}, 	/* 0x802e */
        {8,	0}, 	/* 0x802f */
        {8,	0}, 	/* 0x8030 */
        {8,	0}, 	/* 0x8031 */
        {8,	0}, 	/* 0x8032 */
        {8,	0}, 	/* 0x8033 */
        {8,	0}, 	/* 0x8034 */
        {8,	0}, 	/* 0x8035 */
        {8,	0}, 	/* 0x8036 */
        {8,	0}, 	/* 0x8037 */
        {8,	0}, 	/* 0x8038 */
        {8,	0}, 	/* 0x8039 */
        {8,	0}, 	/* 0x803a */
        {8,	0}, 	/* 0x803b */
        {8,	0}, 	/* 0x803c */
        {8,	0}, 	/* 0x803d */
        {8,	0}, 	/* 0x803e */
        {8,	0}, 	/* 0x803f */
        {8,	0}, 	/* 0x8040 */
        {8,	0}, 	/* 0x8041 */
        {8,	0}, 	/* 0x8042 */
        {8,	0}, 	/* 0x8043 */
        {8,	0}, 	/* 0x8044 */
        {8,	0}, 	/* 0x8045 */
        {8,	0}, 	/* 0x8046 */
        {8,	0}, 	/* 0x8047 */
        {8,	0}, 	/* 0x8048 */
        {8,	0}, 	/* 0x8049 */
        {8,	0}, 	/* 0x804a */
        {8,	0}, 	/* 0x804b */
        {8,	0}, 	/* 0x804c */
        {8,	0}, 	/* 0x804d */
        {8,	0}, 	/* 0x804e */
        {8,	0}, 	/* 0x804f */
        {8,	0}, 	/* 0x8050 */
        {8,	0}, 	/* 0x8051 */
        {8,	0}, 	/* 0x8052 */
        {8,	0}, 	/* 0x8053 */
        {8,	0}, 	/* 0x8054 */
        {8,	0}, 	/* 0x8055 */
        {8,	0}, 	/* 0x8056 */
        {8,	0}, 	/* 0x8057 */
        {8,	0}, 	/* 0x8058 */
        {8,	0}, 	/* 0x8059 */
        {8,	0}, 	/* 0x805a */
        {8,	0}, 	/* 0x805b */
        {8,	0}, 	/* 0x805c */
        {8,	0}, 	/* 0x805d */
        {8,	0}, 	/* 0x805e */
        {8,	0}, 	/* 0x805f */
        {8,	0}, 	/* 0x8060 */
        {8,	0}, 	/* 0x8061 */
        {8,	0}, 	/* 0x8062 */
        {8,	0}, 	/* 0x8063 */
        {8,	0}, 	/* 0x8064 */
        {8,	0}, 	/* 0x8065 */
        {8,	0}, 	/* 0x8066 */
        {8,	0}, 	/* 0x8067 */
        {8,	0}, 	/* 0x8068 */
        {8,	0}, 	/* 0x8069 */
        {8,	0}, 	/* 0x806a */
        {8,	0}, 	/* 0x806b */
        {8,	0}, 	/* 0x806c */
        {8,	0}, 	/* 0x806d */
        {8,	0}, 	/* 0x806e */
        {8,	0}, 	/* 0x806f */
        {8,	0}, 	/* 0x8070 */
        {8,	0}, 	/* 0x8071 */
        {8,	0}, 	/* 0x8072 */
        {8,	0}, 	/* 0x8073 */
        {8,	0}, 	/* 0x8074 */
        {8,	0}, 	/* 0x8075 */
        {8,	0}, 	/* 0x8076 */
        {8,	0}, 	/* 0x8077 */
        {8,	0}, 	/* 0x8078 */
        {8,	0}, 	/* 0x8079 */
        {8,	0}, 	/* 0x807a */
        {8,	0}, 	/* 0x807b */
        {8,	0}, 	/* 0x807c */
        {8,	0}, 	/* 0x807d */
        {8,	0}, 	/* 0x807e */
        {8,	0}, 	/* 0x807f */
        {8,	0}, 	/* 0x8080 */
        {8,	0}, 	/* 0x8081 */
        {8,	0}, 	/* 0x8082 */
        {8,	0}, 	/* 0x8083 */
        {8,	0}, 	/* 0x8084 */
        {8,	0}, 	/* 0x8085 */
        {8,	0}, 	/* 0x8086 */
        {8,	0}, 	/* 0x8087 */
        {8,	0}, 	/* 0x8088 */
        {8,	0}, 	/* 0x8089 */
        {8,	0}, 	/* 0x808a */
        {8,	0}, 	/* 0x808b */
        {8,	0}, 	/* 0x808c */
        {8,	0}, 	/* 0x808d */
        {8,	0}, 	/* 0x808e */
        {8,	0}, 	/* 0x808f */
        {8,	0}, 	/* 0x8090 */
        {8,	0}, 	/* 0x8091 */
        {8,	0}, 	/* 0x8092 */
        {8,	0}, 	/* 0x8093 */
        {8,	0}, 	/* 0x8094 */
        {8,	0}, 	/* 0x8095 */
        {8,	0}, 	/* 0x8096 */
        {8,	0}, 	/* 0x8097 */
        {8,	0}, 	/* 0x8098 */
        {8,	0}, 	/* 0x8099 */
        {8,	0}, 	/* 0x809a */
        {8,	0}, 	/* 0x809b */
        {8,	0}, 	/* 0x809c */
        {8,	0}, 	/* 0x809d */
        {8,	0}, 	/* 0x809e */
        {8,	0}, 	/* 0x809f */
        {8,	0}, 	/* 0x80a0 */
        {8,	0}, 	/* 0x80a1 */
        {8,	0}, 	/* 0x80a2 */
        {8,	0}, 	/* 0x80a3 */
        {8,	0}, 	/* 0x80a4 */
        {8,	0}, 	/* 0x80a5 */
        {8,	0}, 	/* 0x80a6 */
        {8,	0}, 	/* 0x80a7 */
        {8,	0}, 	/* 0x80a8 */
        {8,	0}, 	/* 0x80a9 */
        {8,	0}, 	/* 0x80aa */
        {8,	0}, 	/* 0x80ab */
        {8,	0}, 	/* 0x80ac */
        {8,	0}, 	/* 0x80ad */
        {8,	0}, 	/* 0x80ae */
        {8,	0}, 	/* 0x80af */
        {8,	0}, 	/* 0x80b0 */
        {8,	0}, 	/* 0x80b1 */
        {8,	0}, 	/* 0x80b2 */
        {8,	0}, 	/* 0x80b3 */
        {8,	0}, 	/* 0x80b4 */
        {8,	0}, 	/* 0x80b5 */
        {8,	0}, 	/* 0x80b6 */
        {8,	0}, 	/* 0x80b7 */
        {8,	0}, 	/* 0x80b8 */
        {8,	0}, 	/* 0x80b9 */
        {8,	0}, 	/* 0x80ba */
        {8,	0}, 	/* 0x80bb */
        {8,	0}, 	/* 0x80bc */
        {8,	0}, 	/* 0x80bd */
        {8,	0}, 	/* 0x80be */
        {8,	0}, 	/* 0x80bf */
        {8,	0}, 	/* 0x80c0 */
        {8,	0}, 	/* 0x80c1 */
        {8,	0}, 	/* 0x80c2 */
        {8,	0}, 	/* 0x80c3 */
        {8,	0}, 	/* 0x80c4 */
        {8,	0}, 	/* 0x80c5 */
        {8,	0}, 	/* 0x80c6 */
        {8,	0}, 	/* 0x80c7 */
        {8,	0}, 	/* 0x80c8 */
        {8,	0}, 	/* 0x80c9 */
        {8,	0}, 	/* 0x80ca */
        {8,	0}, 	/* 0x80cb */
        {8,	0}, 	/* 0x80cc */
        {8,	0}, 	/* 0x80cd */
        {8,	0}, 	/* 0x80ce */
        {8,	0}, 	/* 0x80cf */
        {8,	0}, 	/* 0x80d0 */
        {8,	0}, 	/* 0x80d1 */
        {8,	0}, 	/* 0x80d2 */
        {8,	0}, 	/* 0x80d3 */
        {8,	0}, 	/* 0x80d4 */
        {8,	0}, 	/* 0x80d5 */
        {8,	0}, 	/* 0x80d6 */
        {8,	0}, 	/* 0x80d7 */
        {8,	0}, 	/* 0x80d8 */
        {8,	0}, 	/* 0x80d9 */
        {8,	0}, 	/* 0x80da */
        {8,	0}, 	/* 0x80db */
        {8,	0}, 	/* 0x80dc */
        {8,	0}, 	/* 0x80dd */
        {8,	0}, 	/* 0x80de */
        {8,	0}, 	/* 0x80df */
        {8,	0}, 	/* 0x80e0 */
        {8,	0}, 	/* 0x80e1 */
        {8,	0}, 	/* 0x80e2 */
        {8,	0}, 	/* 0x80e3 */
        {8,	0}, 	/* 0x80e4 */
        {8,	0}, 	/* 0x80e5 */
        {8,	0}, 	/* 0x80e6 */
        {8,	0}, 	/* 0x80e7 */
        {8,	0}, 	/* 0x80e8 */
        {8,	0}, 	/* 0x80e9 */
        {8,	0}, 	/* 0x80ea */
        {8,	0}, 	/* 0x80eb */
        {8,	0}, 	/* 0x80ec */
        {8,	0}, 	/* 0x80ed */
        {8,	0}, 	/* 0x80ee */
        {8,	0}, 	/* 0x80ef */
        {8,	0}, 	/* 0x80f0 */
        {8,	0}, 	/* 0x80f1 */
        {8,	0}, 	/* 0x80f2 */
        {8,	0}, 	/* 0x80f3 */
        {8,	0}, 	/* 0x80f4 */
        {8,	0}, 	/* 0x80f5 */
        {8,	0}, 	/* 0x80f6 */
        {8,	0}, 	/* 0x80f7 */
        {8,	0}, 	/* 0x80f8 */
        {8,	0}, 	/* 0x80f9 */
        {8,	0}, 	/* 0x80fa */
        {8,	0}, 	/* 0x80fb */
        {8,	0}, 	/* 0x80fc */
        {8,	0}, 	/* 0x80fd */
        {8,	0}, 	/* 0x80fe */
        {8,	0}, 	/* 0x80ff */
        {8,	0}, 	/* 0x8100 */
        {8,	0}, 	/* 0x8101 */
        {8,	0}, 	/* 0x8102 */
        {8,	0}, 	/* 0x8103 */
        {8,	0}, 	/* 0x8104 */
        {8,	0}, 	/* 0x8105 */
        {8,	0}, 	/* 0x8106 */
        {8,	0}, 	/* 0x8107 */
        {8,	0}, 	/* 0x8108 */
        {8,	0}, 	/* 0x8109 */
        {8,	0}, 	/* 0x810a */
        {8,	0}, 	/* 0x810b */
        {8,	0}, 	/* 0x810c */
        {8,	0}, 	/* 0x810d */
        {8,	0}, 	/* 0x810e */
        {8,	0}, 	/* 0x810f */
        {8,	0}, 	/* 0x8110 */
        {8,	0}, 	/* 0x8111 */
        {8,	0}, 	/* 0x8112 */
        {8,	0}, 	/* 0x8113 */
        {8,	0}, 	/* 0x8114 */
        {8,	0}, 	/* 0x8115 */
        {8,	0}, 	/* 0x8116 */
        {8,	0}, 	/* 0x8117 */
        {8,	0}, 	/* 0x8118 */
        {8,	0}, 	/* 0x8119 */
        {8,	0}, 	/* 0x811a */
        {8,	0}, 	/* 0x811b */
        {8,	0}, 	/* 0x811c */
        {8,	0}, 	/* 0x811d */
        {8,	0}, 	/* 0x811e */
        {8,	0}, 	/* 0x811f */
        {8,	0}, 	/* 0x8120 */
        {8,	0}, 	/* 0x8121 */
        {8,	0}, 	/* 0x8122 */
        {8,	0}, 	/* 0x8123 */
        {8,	0}, 	/* 0x8124 */
        {8,	0}, 	/* 0x8125 */
        {8,	0}, 	/* 0x8126 */
        {8,	0}, 	/* 0x8127 */
        {8,	0}, 	/* 0x8128 */
        {8,	0}, 	/* 0x8129 */
        {8,	0}, 	/* 0x812a */
        {8,	0}, 	/* 0x812b */
        {8,	0}, 	/* 0x812c */
        {8,	0}, 	/* 0x812d */
        {8,	0}, 	/* 0x812e */
        {8,	0}, 	/* 0x812f */
        {8,	0}, 	/* 0x8130 */
        {8,	0}, 	/* 0x8131 */
        {8,	0}, 	/* 0x8132 */
        {8,	0}, 	/* 0x8133 */
        {8,	0}, 	/* 0x8134 */
        {8,	0}, 	/* 0x8135 */
        {8,	0}, 	/* 0x8136 */
        {8,	0}, 	/* 0x8137 */
        {8,	0}, 	/* 0x8138 */
        {8,	0}, 	/* 0x8139 */
        {8,	0}, 	/* 0x813a */
        {8,	0}, 	/* 0x813b */
        {8,	0}, 	/* 0x813c */
        {8,	0}, 	/* 0x813d */
        {8,	0}, 	/* 0x813e */
        {8,	0}, 	/* 0x813f */
        {8,	0}, 	/* 0x8140 */
        {8,	0}, 	/* 0x8141 */
        {8,	0}, 	/* 0x8142 */
        {8,	0}, 	/* 0x8143 */
        {8,	0}, 	/* 0x8144 */
        {8,	0}, 	/* 0x8145 */
        {8,	0}, 	/* 0x8146 */
        {8,	0}, 	/* 0x8147 */
        {8,	0}, 	/* 0x8148 */
        {8,	0}, 	/* 0x8149 */
        {8,	0}, 	/* 0x814a */
        {8,	0}, 	/* 0x814b */
        {8,	0}, 	/* 0x814c */
        {8,	0}, 	/* 0x814d */
        {8,	0}, 	/* 0x814e */
        {8,	0}, 	/* 0x814f */
        {8,	0}, 	/* 0x8150 */
        {8,	0}, 	/* 0x8151 */
        {8,	0}, 	/* 0x8152 */
        {8,	0}, 	/* 0x8153 */
        {8,	0}, 	/* 0x8154 */
        {8,	0}, 	/* 0x8155 */
        {8,	0}, 	/* 0x8156 */
        {8,	0}, 	/* 0x8157 */
        {8,	0}, 	/* 0x8158 */
        {8,	0}, 	/* 0x8159 */
        {8,	0}, 	/* 0x815a */
        {8,	0}, 	/* 0x815b */
        {8,	0}, 	/* 0x815c */
        {8,	0}, 	/* 0x815d */
        {8,	0}, 	/* 0x815e */
        {8,	0}, 	/* 0x815f */
        {8,	0}, 	/* 0x8160 */
        {8,	0}, 	/* 0x8161 */
        {8,	0}, 	/* 0x8162 */
        {8,	0}, 	/* 0x8163 */
        {8,	0}, 	/* 0x8164 */
        {8,	0}, 	/* 0x8165 */
        {8,	0}, 	/* 0x8166 */
        {8,	0}, 	/* 0x8167 */
        {8,	0}, 	/* 0x8168 */
        {8,	0}, 	/* 0x8169 */
        {8,	0}, 	/* 0x816a */
        {8,	0}, 	/* 0x816b */
        {8,	0}, 	/* 0x816c */
        {8,	0}, 	/* 0x816d */
        {8,	0}, 	/* 0x816e */
        {8,	0}, 	/* 0x816f */
        {8,	0}, 	/* 0x8170 */
        {8,	0}, 	/* 0x8171 */
        {8,	0}, 	/* 0x8172 */
        {8,	0}, 	/* 0x8173 */
        {8,	0}, 	/* 0x8174 */
        {8,	0}, 	/* 0x8175 */
        {8,	0}, 	/* 0x8176 */
        {8,	0}, 	/* 0x8177 */
        {8,	0}, 	/* 0x8178 */
        {8,	0}, 	/* 0x8179 */
        {8,	0}, 	/* 0x817a */
        {8,	0}, 	/* 0x817b */
        {8,	0}, 	/* 0x817c */
        {8,	0}, 	/* 0x817d */
        {8,	0}, 	/* 0x817e */
        {8,	0}, 	/* 0x817f */
        {8,	0}, 	/* 0x8180 */
        {8,	0}, 	/* 0x8181 */
        {8,	0}, 	/* 0x8182 */
        {8,	0}, 	/* 0x8183 */
        {8,	0}, 	/* 0x8184 */
        {8,	0}, 	/* 0x8185 */
        {8,	0}, 	/* 0x8186 */
        {8,	0}, 	/* 0x8187 */
        {8,	0}, 	/* 0x8188 */
        {8,	0}, 	/* 0x8189 */
        {8,	0}, 	/* 0x818a */
        {8,	0}, 	/* 0x818b */
        {8,	0}, 	/* 0x818c */
        {8,	0}, 	/* 0x818d */
        {8,	0}, 	/* 0x818e */
        {8,	0}, 	/* 0x818f */
        {8,	0}, 	/* 0x8190 */
        {8,	0}, 	/* 0x8191 */
        {8,	0}, 	/* 0x8192 */
        {8,	0}, 	/* 0x8193 */
        {8,	0}, 	/* 0x8194 */
        {8,	0}, 	/* 0x8195 */
        {8,	0}, 	/* 0x8196 */
        {8,	0}, 	/* 0x8197 */
        {8,	0}, 	/* 0x8198 */
        {8,	0}, 	/* 0x8199 */
        {8,	0}, 	/* 0x819a */
        {8,	0}, 	/* 0x819b */
        {8,	0}, 	/* 0x819c */
        {8,	0}, 	/* 0x819d */
        {8,	0}, 	/* 0x819e */
        {8,	0}, 	/* 0x819f */
        {8,	0}, 	/* 0x81a0 */
        {8,	0}, 	/* 0x81a1 */
        {8,	0}, 	/* 0x81a2 */
        {8,	0}, 	/* 0x81a3 */
        {8,	0}, 	/* 0x81a4 */
        {8,	0}, 	/* 0x81a5 */
        {8,	0}, 	/* 0x81a6 */
        {8,	0}, 	/* 0x81a7 */
        {8,	0}, 	/* 0x81a8 */
        {8,	0}, 	/* 0x81a9 */
        {8,	0}, 	/* 0x81aa */
        {8,	0}, 	/* 0x81ab */
        {8,	0}, 	/* 0x81ac */
        {8,	0}, 	/* 0x81ad */
        {8,	0}, 	/* 0x81ae */
        {8,	0}, 	/* 0x81af */
        {8,	0}, 	/* 0x81b0 */
        {8,	0}, 	/* 0x81b1 */
        {8,	0}, 	/* 0x81b2 */
        {8,	0}, 	/* 0x81b3 */
        {8,	0}, 	/* 0x81b4 */
        {8,	0}, 	/* 0x81b5 */
        {8,	0}, 	/* 0x81b6 */
        {8,	0}, 	/* 0x81b7 */
        {8,	0}, 	/* 0x81b8 */
        {8,	0}, 	/* 0x81b9 */
        {8,	0}, 	/* 0x81ba */
        {8,	0}, 	/* 0x81bb */
        {8,	0}, 	/* 0x81bc */
        {8,	0}, 	/* 0x81bd */
        {8,	0}, 	/* 0x81be */
        {8,	0}, 	/* 0x81bf */
        {8,	0}, 	/* 0x81c0 */
        {8,	0}, 	/* 0x81c1 */
        {8,	0}, 	/* 0x81c2 */
        {8,	0}, 	/* 0x81c3 */
        {8,	0}, 	/* 0x81c4 */
        {8,	0}, 	/* 0x81c5 */
        {8,	0}, 	/* 0x81c6 */
        {8,	0}, 	/* 0x81c7 */
        {8,	0}, 	/* 0x81c8 */
        {8,	0}, 	/* 0x81c9 */
        {8,	0}, 	/* 0x81ca */
        {8,	0}, 	/* 0x81cb */
        {8,	0}, 	/* 0x81cc */
        {8,	0}, 	/* 0x81cd */
        {8,	0}, 	/* 0x81ce */
        {8,	0}, 	/* 0x81cf */
        {8,	0}, 	/* 0x81d0 */
        {8,	0}, 	/* 0x81d1 */
        {8,	0}, 	/* 0x81d2 */
        {8,	0}, 	/* 0x81d3 */
        {8,	0}, 	/* 0x81d4 */
        {8,	0}, 	/* 0x81d5 */
        {8,	0}, 	/* 0x81d6 */
        {8,	0}, 	/* 0x81d7 */
        {8,	0}, 	/* 0x81d8 */
        {8,	0}, 	/* 0x81d9 */
        {8,	0}, 	/* 0x81da */
        {8,	0}, 	/* 0x81db */
        {8,	0}, 	/* 0x81dc */
        {8,	0}, 	/* 0x81dd */
        {8,	0}, 	/* 0x81de */
        {8,	0}, 	/* 0x81df */
        {8,	0}, 	/* 0x81e0 */
        {8,	0}, 	/* 0x81e1 */
        {8,	0}, 	/* 0x81e2 */
        {8,	0}, 	/* 0x81e3 */
        {8,	0}, 	/* 0x81e4 */
        {8,	0}, 	/* 0x81e5 */
        {8,	0}, 	/* 0x81e6 */
        {8,	0}, 	/* 0x81e7 */
        {8,	0}, 	/* 0x81e8 */
        {8,	0}, 	/* 0x81e9 */
        {8,	0}, 	/* 0x81ea */
        {8,	0}, 	/* 0x81eb */
        {8,	0}, 	/* 0x81ec */
        {8,	0}, 	/* 0x81ed */
        {8,	0}, 	/* 0x81ee */
        {8,	0}, 	/* 0x81ef */
        {8,	0}, 	/* 0x81f0 */
        {8,	0}, 	/* 0x81f1 */
        {8,	0}, 	/* 0x81f2 */
        {8,	0}, 	/* 0x81f3 */
        {8,	0}, 	/* 0x81f4 */
        {8,	0}, 	/* 0x81f5 */
        {8,	0}, 	/* 0x81f6 */
        {8,	0}, 	/* 0x81f7 */
        {8,	0}, 	/* 0x81f8 */
        {8,	0}, 	/* 0x81f9 */
        {8,	0}, 	/* 0x81fa */
        {8,	0}, 	/* 0x81fb */
        {8,	0}, 	/* 0x81fc */
        {8,	0}, 	/* 0x81fd */
        {8,	0}, 	/* 0x81fe */
        {8,	0}, 	/* 0x81ff */
        {8,	0}, 	/* 0x8200 */
        {8,	0}, 	/* 0x8201 */
        {8,	0}, 	/* 0x8202 */
        {8,	0}, 	/* 0x8203 */
        {8,	0}, 	/* 0x8204 */
        {8,	0}, 	/* 0x8205 */
        {8,	0}, 	/* 0x8206 */
        {8,	0}, 	/* 0x8207 */
        {8,	0}, 	/* 0x8208 */
        {8,	0}, 	/* 0x8209 */
        {8,	0}, 	/* 0x820a */
        {8,	0}, 	/* 0x820b */
        {8,	0}, 	/* 0x820c */
        {8,	0}, 	/* 0x820d */
        {8,	0}, 	/* 0x820e */
        {8,	0}, 	/* 0x820f */
        {8,	0}, 	/* 0x8210 */
        {8,	0}, 	/* 0x8211 */
        {8,	0}, 	/* 0x8212 */
        {8,	0}, 	/* 0x8213 */
        {8,	0}, 	/* 0x8214 */
        {8,	0}, 	/* 0x8215 */
        {8,	0}, 	/* 0x8216 */
        {8,	0}, 	/* 0x8217 */
        {8,	0}, 	/* 0x8218 */
        {8,	0}, 	/* 0x8219 */
        {8,	0}, 	/* 0x821a */
        {8,	0}, 	/* 0x821b */
        {8,	0}, 	/* 0x821c */
        {8,	0}, 	/* 0x821d */
        {8,	0}, 	/* 0x821e */
        {8,	0}, 	/* 0x821f */
        {8,	0}, 	/* 0x8220 */
        {8,	0}, 	/* 0x8221 */
        {8,	0}, 	/* 0x8222 */
        {8,	0}, 	/* 0x8223 */
        {8,	0}, 	/* 0x8224 */
        {8,	0}, 	/* 0x8225 */
        {8,	0}, 	/* 0x8226 */
        {8,	0}, 	/* 0x8227 */
        {8,	0}, 	/* 0x8228 */
        {8,	0}, 	/* 0x8229 */
        {8,	0}, 	/* 0x822a */
        {8,	0}, 	/* 0x822b */
        {8,	0}, 	/* 0x822c */
        {8,	0}, 	/* 0x822d */
        {8,	0}, 	/* 0x822e */
        {8,	0}, 	/* 0x822f */
        {8,	0}, 	/* 0x8230 */
        {8,	0}, 	/* 0x8231 */
        {8,	0}, 	/* 0x8232 */
        {8,	0}, 	/* 0x8233 */
        {8,	0}, 	/* 0x8234 */
        {8,	0}, 	/* 0x8235 */
        {8,	0}, 	/* 0x8236 */
        {8,	0}, 	/* 0x8237 */
        {8,	0}, 	/* 0x8238 */
        {8,	0}, 	/* 0x8239 */
        {8,	0}, 	/* 0x823a */
        {8,	0}, 	/* 0x823b */
        {8,	0}, 	/* 0x823c */
        {8,	0}, 	/* 0x823d */
        {8,	0}, 	/* 0x823e */
        {8,	0}, 	/* 0x823f */
        {8,	0}, 	/* 0x8240 */
        {8,	0}, 	/* 0x8241 */
        {8,	0}, 	/* 0x8242 */
        {8,	0}, 	/* 0x8243 */
        {8,	0}, 	/* 0x8244 */
        {8,	0}, 	/* 0x8245 */
        {8,	0}, 	/* 0x8246 */
        {8,	0}, 	/* 0x8247 */
        {8,	0}, 	/* 0x8248 */
        {8,	0}, 	/* 0x8249 */
        {8,	0}, 	/* 0x824a */
        {8,	0}, 	/* 0x824b */
        {8,	0}, 	/* 0x824c */
        {8,	0}, 	/* 0x824d */
        {8,	0}, 	/* 0x824e */
        {8,	0}, 	/* 0x824f */
        {8,	0}, 	/* 0x8250 */
        {8,	0}, 	/* 0x8251 */
        {8,	0}, 	/* 0x8252 */
        {8,	0}, 	/* 0x8253 */
        {8,	0}, 	/* 0x8254 */
        {8,	0}, 	/* 0x8255 */
        {8,	0}, 	/* 0x8256 */
        {8,	0}, 	/* 0x8257 */
        {8,	0}, 	/* 0x8258 */
        {8,	0}, 	/* 0x8259 */
        {8,	0}, 	/* 0x825a */
        {8,	0}, 	/* 0x825b */
        {8,	0}, 	/* 0x825c */
        {8,	0}, 	/* 0x825d */
        {8,	0}, 	/* 0x825e */
        {8,	0}, 	/* 0x825f */
        {8,	0}, 	/* 0x8260 */
        {8,	0}, 	/* 0x8261 */
        {8,	0}, 	/* 0x8262 */
        {8,	0}, 	/* 0x8263 */
        {8,	0}, 	/* 0x8264 */
        {8,	0}, 	/* 0x8265 */
        {8,	0}, 	/* 0x8266 */
        {8,	0}, 	/* 0x8267 */
        {8,	0}, 	/* 0x8268 */
        {8,	0}, 	/* 0x8269 */
        {8,	0}, 	/* 0x826a */
        {8,	0}, 	/* 0x826b */
        {8,	0}, 	/* 0x826c */
        {8,	0}, 	/* 0x826d */
        {8,	0}, 	/* 0x826e */
        {8,	0}, 	/* 0x826f */
        {8,	0}, 	/* 0x8270 */
        {8,	0}, 	/* 0x8271 */
        {8,	0}, 	/* 0x8272 */
        {8,	0}, 	/* 0x8273 */
        {8,	0}, 	/* 0x8274 */
        {8,	0}, 	/* 0x8275 */
        {8,	0}, 	/* 0x8276 */
        {8,	0}, 	/* 0x8277 */
        {8,	0}, 	/* 0x8278 */
        {8,	0}, 	/* 0x8279 */
        {8,	0}, 	/* 0x827a */
        {8,	0}, 	/* 0x827b */
        {8,	0}, 	/* 0x827c */
        {8,	0}, 	/* 0x827d */
        {8,	0}, 	/* 0x827e */
        {8,	0}, 	/* 0x827f */
        {8,	0}, 	/* 0x8280 */
        {8,	0}, 	/* 0x8281 */
        {8,	0}, 	/* 0x8282 */
        {8,	0}, 	/* 0x8283 */
        {8,	0}, 	/* 0x8284 */
        {8,	0}, 	/* 0x8285 */
        {8,	0}, 	/* 0x8286 */
        {8,	0}, 	/* 0x8287 */
        {8,	0}, 	/* 0x8288 */
        {8,	0}, 	/* 0x8289 */
        {8,	0}, 	/* 0x828a */
        {8,	0}, 	/* 0x828b */
        {8,	0}, 	/* 0x828c */
        {8,	0}, 	/* 0x828d */
        {8,	0}, 	/* 0x828e */
        {8,	0}, 	/* 0x828f */
        {8,	0}, 	/* 0x8290 */
        {8,	0}, 	/* 0x8291 */
        {8,	0}, 	/* 0x8292 */
        {8,	0}, 	/* 0x8293 */
        {8,	0}, 	/* 0x8294 */
        {8,	0}, 	/* 0x8295 */
        {8,	0}, 	/* 0x8296 */
        {8,	0}, 	/* 0x8297 */
        {8,	0}, 	/* 0x8298 */
        {8,	0}, 	/* 0x8299 */
        {8,	0}, 	/* 0x829a */
        {8,	0}, 	/* 0x829b */
        {8,	0}, 	/* 0x829c */
        {8,	0}, 	/* 0x829d */
        {8,	0}, 	/* 0x829e */
        {8,	0}, 	/* 0x829f */
        {8,	0}, 	/* 0x82a0 */
        {8,	0}, 	/* 0x82a1 */
        {8,	0}, 	/* 0x82a2 */
        {8,	0}, 	/* 0x82a3 */
        {8,	0}, 	/* 0x82a4 */
        {8,	0}, 	/* 0x82a5 */
        {8,	0}, 	/* 0x82a6 */
        {8,	0}, 	/* 0x82a7 */
        {8,	0}, 	/* 0x82a8 */
        {8,	0}, 	/* 0x82a9 */
        {8,	0}, 	/* 0x82aa */
        {8,	0}, 	/* 0x82ab */
        {8,	0}, 	/* 0x82ac */
        {8,	0}, 	/* 0x82ad */
        {8,	0}, 	/* 0x82ae */
        {8,	0}, 	/* 0x82af */
        {8,	0}, 	/* 0x82b0 */
        {8,	0}, 	/* 0x82b1 */
        {8,	0}, 	/* 0x82b2 */
        {8,	0}, 	/* 0x82b3 */
        {8,	0}, 	/* 0x82b4 */
        {8,	0}, 	/* 0x82b5 */
        {8,	0}, 	/* 0x82b6 */
        {8,	0}, 	/* 0x82b7 */
        {8,	0}, 	/* 0x82b8 */
        {8,	0}, 	/* 0x82b9 */
        {8,	0}, 	/* 0x82ba */
        {8,	0}, 	/* 0x82bb */
        {8,	0}, 	/* 0x82bc */
        {8,	0}, 	/* 0x82bd */
        {8,	0}, 	/* 0x82be */
        {8,	0}, 	/* 0x82bf */
        {8,	0}, 	/* 0x82c0 */
        {8,	0}, 	/* 0x82c1 */
        {8,	0}, 	/* 0x82c2 */
        {8,	0}, 	/* 0x82c3 */
        {8,	0}, 	/* 0x82c4 */
        {8,	0}, 	/* 0x82c5 */
        {8,	0}, 	/* 0x82c6 */
        {8,	0}, 	/* 0x82c7 */
        {8,	0}, 	/* 0x82c8 */
        {8,	0}, 	/* 0x82c9 */
        {8,	0}, 	/* 0x82ca */
        {8,	0}, 	/* 0x82cb */
        {8,	0}, 	/* 0x82cc */
        {8,	0}, 	/* 0x82cd */
        {8,	0}, 	/* 0x82ce */
        {8,	0}, 	/* 0x82cf */
        {8,	0}, 	/* 0x82d0 */
        {8,	0}, 	/* 0x82d1 */
        {8,	0}, 	/* 0x82d2 */
        {8,	0}, 	/* 0x82d3 */
        {8,	0}, 	/* 0x82d4 */
        {8,	0}, 	/* 0x82d5 */
        {8,	0}, 	/* 0x82d6 */
        {8,	0}, 	/* 0x82d7 */
        {8,	0}, 	/* 0x82d8 */
        {8,	0}, 	/* 0x82d9 */
        {8,	0}, 	/* 0x82da */
        {8,	0}, 	/* 0x82db */
        {8,	0}, 	/* 0x82dc */
        {8,	0}, 	/* 0x82dd */
        {8,	0}, 	/* 0x82de */
        {8,	0}, 	/* 0x82df */
        {8,	0}, 	/* 0x82e0 */
        {8,	0}, 	/* 0x82e1 */
        {8,	0}, 	/* 0x82e2 */
        {8,	0}, 	/* 0x82e3 */
        {8,	0}, 	/* 0x82e4 */
        {8,	0}, 	/* 0x82e5 */
        {8,	0}, 	/* 0x82e6 */
        {8,	0}, 	/* 0x82e7 */
        {8,	0}, 	/* 0x82e8 */
        {8,	0}, 	/* 0x82e9 */
        {8,	0}, 	/* 0x82ea */
        {8,	0}, 	/* 0x82eb */
        {8,	0}, 	/* 0x82ec */
        {8,	0}, 	/* 0x82ed */
        {8,	0}, 	/* 0x82ee */
        {8,	0}, 	/* 0x82ef */
        {8,	0}, 	/* 0x82f0 */
        {8,	0}, 	/* 0x82f1 */
        {8,	0}, 	/* 0x82f2 */
        {8,	0}, 	/* 0x82f3 */
        {8,	0}, 	/* 0x82f4 */
        {8,	0}, 	/* 0x82f5 */
        {8,	0}, 	/* 0x82f6 */
        {8,	0}, 	/* 0x82f7 */
        {8,	0}, 	/* 0x82f8 */
        {8,	0}, 	/* 0x82f9 */
        {8,	0}, 	/* 0x82fa */
        {8,	0}, 	/* 0x82fb */
        {8,	0}, 	/* 0x82fc */
        {8,	0}, 	/* 0x82fd */
        {8,	0}, 	/* 0x82fe */
        {8,	0}, 	/* 0x82ff */
        {8,	0}, 	/* 0x8300 */
        {8,	0}, 	/* 0x8301 */
        {8,	0}, 	/* 0x8302 */
        {8,	0}, 	/* 0x8303 */
        {8,	0}, 	/* 0x8304 */
        {8,	0}, 	/* 0x8305 */
        {8,	0}, 	/* 0x8306 */
        {8,	0}, 	/* 0x8307 */
        {8,	0}, 	/* 0x8308 */
        {8,	0}, 	/* 0x8309 */
        {8,	0}, 	/* 0x830a */
        {8,	0}, 	/* 0x830b */
        {8,	0}, 	/* 0x830c */
        {8,	0}, 	/* 0x830d */
        {8,	0}, 	/* 0x830e */
        {8,	0}, 	/* 0x830f */
        {8,	0}, 	/* 0x8310 */
        {8,	0}, 	/* 0x8311 */
        {8,	0}, 	/* 0x8312 */
        {8,	0}, 	/* 0x8313 */
        {8,	0}, 	/* 0x8314 */
        {8,	0}, 	/* 0x8315 */
        {8,	0}, 	/* 0x8316 */
        {8,	0}, 	/* 0x8317 */
        {8,	0}, 	/* 0x8318 */
        {8,	0}, 	/* 0x8319 */
        {8,	0}, 	/* 0x831a */
        {8,	0}, 	/* 0x831b */
        {8,	0}, 	/* 0x831c */
        {8,	0}, 	/* 0x831d */
        {8,	0}, 	/* 0x831e */
        {8,	0}, 	/* 0x831f */
        {8,	0}, 	/* 0x8320 */
        {8,	0}, 	/* 0x8321 */
        {8,	0}, 	/* 0x8322 */
        {8,	0}, 	/* 0x8323 */
        {8,	0}, 	/* 0x8324 */
        {8,	0}, 	/* 0x8325 */
        {8,	0}, 	/* 0x8326 */
        {8,	0}, 	/* 0x8327 */
        {8,	0}, 	/* 0x8328 */
        {8,	0}, 	/* 0x8329 */
        {8,	0}, 	/* 0x832a */
        {8,	0}, 	/* 0x832b */
        {8,	0}, 	/* 0x832c */
        {8,	0}, 	/* 0x832d */
        {8,	0}, 	/* 0x832e */
        {8,	0}, 	/* 0x832f */
        {8,	0}, 	/* 0x8330 */
        {8,	0}, 	/* 0x8331 */
        {8,	0}, 	/* 0x8332 */
        {8,	0}, 	/* 0x8333 */
        {8,	0}, 	/* 0x8334 */
        {8,	0}, 	/* 0x8335 */
        {8,	0}, 	/* 0x8336 */
        {8,	0}, 	/* 0x8337 */
        {8,	0}, 	/* 0x8338 */
        {8,	0}, 	/* 0x8339 */
        {8,	0}, 	/* 0x833a */
        {8,	0}, 	/* 0x833b */
        {8,	0}, 	/* 0x833c */
        {8,	0}, 	/* 0x833d */
        {8,	0}, 	/* 0x833e */
        {8,	0}, 	/* 0x833f */
        {8,	0}, 	/* 0x8340 */
        {8,	0}, 	/* 0x8341 */
        {8,	0}, 	/* 0x8342 */
        {8,	0}, 	/* 0x8343 */
        {8,	0}, 	/* 0x8344 */
        {8,	0}, 	/* 0x8345 */
        {8,	0}, 	/* 0x8346 */
        {8,	0}, 	/* 0x8347 */
        {8,	0}, 	/* 0x8348 */
        {8,	0}, 	/* 0x8349 */
        {8,	0}, 	/* 0x834a */
        {8,	0}, 	/* 0x834b */
        {8,	0}, 	/* 0x834c */
        {8,	0}, 	/* 0x834d */
        {8,	0}, 	/* 0x834e */
        {8,	0}, 	/* 0x834f */
        {8,	0}, 	/* 0x8350 */
        {8,	0}, 	/* 0x8351 */
        {8,	0}, 	/* 0x8352 */
        {8,	0}, 	/* 0x8353 */
        {8,	0}, 	/* 0x8354 */
        {8,	0}, 	/* 0x8355 */
        {8,	0}, 	/* 0x8356 */
        {8,	0}, 	/* 0x8357 */
        {8,	0}, 	/* 0x8358 */
        {8,	0}, 	/* 0x8359 */
        {8,	0}, 	/* 0x835a */
        {8,	0}, 	/* 0x835b */
        {8,	0}, 	/* 0x835c */
        {8,	0}, 	/* 0x835d */
        {8,	0}, 	/* 0x835e */
        {8,	0}, 	/* 0x835f */
        {8,	0}, 	/* 0x8360 */
        {8,	0}, 	/* 0x8361 */
        {8,	0}, 	/* 0x8362 */
        {8,	0}, 	/* 0x8363 */
        {8,	0}, 	/* 0x8364 */
        {8,	0}, 	/* 0x8365 */
        {8,	0}, 	/* 0x8366 */
        {8,	0}, 	/* 0x8367 */
        {8,	0}, 	/* 0x8368 */
        {8,	0}, 	/* 0x8369 */
        {8,	0}, 	/* 0x836a */
        {8,	0}, 	/* 0x836b */
        {8,	0}, 	/* 0x836c */
        {8,	0}, 	/* 0x836d */
        {8,	0}, 	/* 0x836e */
        {8,	0}, 	/* 0x836f */
        {8,	0}, 	/* 0x8370 */
        {8,	0}, 	/* 0x8371 */
        {8,	0}, 	/* 0x8372 */
        {8,	0}, 	/* 0x8373 */
        {8,	0}, 	/* 0x8374 */
        {8,	0}, 	/* 0x8375 */
        {8,	0}, 	/* 0x8376 */
        {8,	0}, 	/* 0x8377 */
        {8,	0}, 	/* 0x8378 */
        {8,	0}, 	/* 0x8379 */
        {8,	0}, 	/* 0x837a */
        {8,	0}, 	/* 0x837b */
        {8,	0}, 	/* 0x837c */
        {8,	0}, 	/* 0x837d */
        {8,	0}, 	/* 0x837e */
        {8,	0}, 	/* 0x837f */
        {8,	0}, 	/* 0x8380 */
        {8,	0}, 	/* 0x8381 */
        {8,	0}, 	/* 0x8382 */
        {8,	0}, 	/* 0x8383 */
        {8,	0}, 	/* 0x8384 */
        {8,	0}, 	/* 0x8385 */
        {8,	0}, 	/* 0x8386 */
        {8,	0}, 	/* 0x8387 */
        {8,	0}, 	/* 0x8388 */
        {8,	0}, 	/* 0x8389 */
        {8,	0}, 	/* 0x838a */
        {8,	0}, 	/* 0x838b */
        {8,	0}, 	/* 0x838c */
        {8,	0}, 	/* 0x838d */
        {8,	0}, 	/* 0x838e */
        {8,	0}, 	/* 0x838f */
        {8,	0}, 	/* 0x8390 */
        {8,	0}, 	/* 0x8391 */
        {8,	0}, 	/* 0x8392 */
        {8,	0}, 	/* 0x8393 */
        {8,	0}, 	/* 0x8394 */
        {8,	0}, 	/* 0x8395 */
        {8,	0}, 	/* 0x8396 */
        {8,	0}, 	/* 0x8397 */
        {8,	0}, 	/* 0x8398 */
        {8,	0}, 	/* 0x8399 */
        {8,	0}, 	/* 0x839a */
        {8,	0}, 	/* 0x839b */
        {8,	0}, 	/* 0x839c */
        {8,	0}, 	/* 0x839d */
        {8,	0}, 	/* 0x839e */
        {8,	0}, 	/* 0x839f */
        {8,	0}, 	/* 0x83a0 */
        {8,	0}, 	/* 0x83a1 */
        {8,	0}, 	/* 0x83a2 */
        {8,	0}, 	/* 0x83a3 */
        {8,	0}, 	/* 0x83a4 */
        {8,	0}, 	/* 0x83a5 */
        {8,	0}, 	/* 0x83a6 */
        {8,	0}, 	/* 0x83a7 */
        {8,	0}, 	/* 0x83a8 */
        {8,	0}, 	/* 0x83a9 */
        {8,	0}, 	/* 0x83aa */
        {8,	0}, 	/* 0x83ab */
        {8,	0}, 	/* 0x83ac */
        {8,	0}, 	/* 0x83ad */
        {8,	0}, 	/* 0x83ae */
        {8,	0}, 	/* 0x83af */
        {8,	0}, 	/* 0x83b0 */
        {8,	0}, 	/* 0x83b1 */
        {8,	0}, 	/* 0x83b2 */
        {8,	0}, 	/* 0x83b3 */
        {8,	0}, 	/* 0x83b4 */
        {8,	0}, 	/* 0x83b5 */
        {8,	0}, 	/* 0x83b6 */
        {8,	0}, 	/* 0x83b7 */
        {8,	0}, 	/* 0x83b8 */
        {8,	0}, 	/* 0x83b9 */
        {8,	0}, 	/* 0x83ba */
        {8,	0}, 	/* 0x83bb */
        {8,	0}, 	/* 0x83bc */
        {8,	0}, 	/* 0x83bd */
        {8,	0}, 	/* 0x83be */
        {8,	0}, 	/* 0x83bf */
        {8,	0}, 	/* 0x83c0 */
        {8,	0}, 	/* 0x83c1 */
        {8,	0}, 	/* 0x83c2 */
        {8,	0}, 	/* 0x83c3 */
        {8,	0}, 	/* 0x83c4 */
        {8,	0}, 	/* 0x83c5 */
        {8,	0}, 	/* 0x83c6 */
        {8,	0}, 	/* 0x83c7 */
        {8,	0}, 	/* 0x83c8 */
        {8,	0}, 	/* 0x83c9 */
        {8,	0}, 	/* 0x83ca */
        {8,	0}, 	/* 0x83cb */
        {8,	0}, 	/* 0x83cc */
        {8,	0}, 	/* 0x83cd */
        {8,	0}, 	/* 0x83ce */
        {8,	0}, 	/* 0x83cf */
        {8,	0}, 	/* 0x83d0 */
        {8,	0}, 	/* 0x83d1 */
        {8,	0}, 	/* 0x83d2 */
        {8,	0}, 	/* 0x83d3 */
        {8,	0}, 	/* 0x83d4 */
        {8,	0}, 	/* 0x83d5 */
        {8,	0}, 	/* 0x83d6 */
        {8,	0}, 	/* 0x83d7 */
        {8,	0}, 	/* 0x83d8 */
        {8,	0}, 	/* 0x83d9 */
        {8,	0}, 	/* 0x83da */
        {8,	0}, 	/* 0x83db */
        {8,	0}, 	/* 0x83dc */
        {8,	0}, 	/* 0x83dd */
        {8,	0}, 	/* 0x83de */
        {8,	0}, 	/* 0x83df */
        {8,	0}, 	/* 0x83e0 */
        {8,	0}, 	/* 0x83e1 */
        {8,	0}, 	/* 0x83e2 */
        {8,	0}, 	/* 0x83e3 */
        {8,	0}, 	/* 0x83e4 */
        {8,	0}, 	/* 0x83e5 */
        {8,	0}, 	/* 0x83e6 */
        {8,	0}, 	/* 0x83e7 */
        {8,	0}, 	/* 0x83e8 */
        {8,	0}, 	/* 0x83e9 */
        {8,	0}, 	/* 0x83ea */
        {8,	0}, 	/* 0x83eb */
        {8,	0}, 	/* 0x83ec */
        {8,	0}, 	/* 0x83ed */
        {8,	0}, 	/* 0x83ee */
        {8,	0}, 	/* 0x83ef */
        {8,	0}, 	/* 0x83f0 */
        {8,	0}, 	/* 0x83f1 */
        {8,	0}, 	/* 0x83f2 */
        {8,	0}, 	/* 0x83f3 */
        {8,	0}, 	/* 0x83f4 */
        {8,	0}, 	/* 0x83f5 */
        {8,	0}, 	/* 0x83f6 */
        {8,	0}, 	/* 0x83f7 */
        {8,	0}, 	/* 0x83f8 */
        {8,	0}, 	/* 0x83f9 */
        {8,	0}, 	/* 0x83fa */
        {8,	0}, 	/* 0x83fb */
        {8,	0}, 	/* 0x83fc */
        {8,	0}, 	/* 0x83fd */
        {8,	0}, 	/* 0x83fe */
        {8,	0}, 	/* 0x83ff */
        {8,	0}, 	/* 0x8400 */
        {8,	0}, 	/* 0x8401 */
        {8,	0}, 	/* 0x8402 */
        {8,	0}, 	/* 0x8403 */
        {8,	0}, 	/* 0x8404 */
        {8,	0}, 	/* 0x8405 */
        {8,	0}, 	/* 0x8406 */
        {8,	0}, 	/* 0x8407 */
        {8,	0}, 	/* 0x8408 */
        {8,	0}, 	/* 0x8409 */
        {8,	0}, 	/* 0x840a */
        {8,	0}, 	/* 0x840b */
        {8,	0}, 	/* 0x840c */
        {8,	0}, 	/* 0x840d */
        {8,	0}, 	/* 0x840e */
        {8,	0}, 	/* 0x840f */
        {8,	0}, 	/* 0x8410 */
        {8,	0}, 	/* 0x8411 */
        {8,	0}, 	/* 0x8412 */
        {8,	0}, 	/* 0x8413 */
        {8,	0}, 	/* 0x8414 */
        {8,	0}, 	/* 0x8415 */
        {8,	0}, 	/* 0x8416 */
        {8,	0}, 	/* 0x8417 */
        {8,	0}, 	/* 0x8418 */
        {8,	0}, 	/* 0x8419 */
        {8,	0}, 	/* 0x841a */
        {8,	0}, 	/* 0x841b */
        {8,	0}, 	/* 0x841c */
        {8,	0}, 	/* 0x841d */
        {8,	0}, 	/* 0x841e */
        {8,	0}, 	/* 0x841f */
        {8,	0}, 	/* 0x8420 */
        {8,	0}, 	/* 0x8421 */
        {8,	0}, 	/* 0x8422 */
        {8,	0}, 	/* 0x8423 */
        {8,	0}, 	/* 0x8424 */
        {8,	0}, 	/* 0x8425 */
        {8,	0}, 	/* 0x8426 */
        {8,	0}, 	/* 0x8427 */
        {8,	0}, 	/* 0x8428 */
        {8,	0}, 	/* 0x8429 */
        {8,	0}, 	/* 0x842a */
        {8,	0}, 	/* 0x842b */
        {8,	0}, 	/* 0x842c */
        {8,	0}, 	/* 0x842d */
        {8,	0}, 	/* 0x842e */
        {8,	0}, 	/* 0x842f */
        {8,	0}, 	/* 0x8430 */
        {8,	0}, 	/* 0x8431 */
        {8,	0}, 	/* 0x8432 */
        {8,	0}, 	/* 0x8433 */
        {8,	0}, 	/* 0x8434 */
        {8,	0}, 	/* 0x8435 */
        {8,	0}, 	/* 0x8436 */
        {8,	0}, 	/* 0x8437 */
        {8,	0}, 	/* 0x8438 */
        {8,	0}, 	/* 0x8439 */
        {8,	0}, 	/* 0x843a */
        {8,	0}, 	/* 0x843b */
        {8,	0}, 	/* 0x843c */
        {8,	0}, 	/* 0x843d */
        {8,	0}, 	/* 0x843e */
        {8,	0}, 	/* 0x843f */
        {8,	0}, 	/* 0x8440 */
        {8,	0}, 	/* 0x8441 */
        {8,	0}, 	/* 0x8442 */
        {8,	0}, 	/* 0x8443 */
        {8,	0}, 	/* 0x8444 */
        {8,	0}, 	/* 0x8445 */
        {8,	0}, 	/* 0x8446 */
        {8,	0}, 	/* 0x8447 */
        {8,	0}, 	/* 0x8448 */
        {8,	0}, 	/* 0x8449 */
        {8,	0}, 	/* 0x844a */
        {8,	0}, 	/* 0x844b */
        {8,	0}, 	/* 0x844c */
        {8,	0}, 	/* 0x844d */
        {8,	0}, 	/* 0x844e */
        {8,	0}, 	/* 0x844f */
        {8,	0}, 	/* 0x8450 */
        {8,	0}, 	/* 0x8451 */
        {8,	0}, 	/* 0x8452 */
        {8,	0}, 	/* 0x8453 */
        {8,	0}, 	/* 0x8454 */
        {8,	0}, 	/* 0x8455 */
        {8,	0}, 	/* 0x8456 */
        {8,	0}, 	/* 0x8457 */
        {8,	0}, 	/* 0x8458 */
        {8,	0}, 	/* 0x8459 */
        {8,	0}, 	/* 0x845a */
        {8,	0}, 	/* 0x845b */
        {8,	0}, 	/* 0x845c */
        {8,	0}, 	/* 0x845d */
        {8,	0}, 	/* 0x845e */
        {8,	0}, 	/* 0x845f */
        {8,	0}, 	/* 0x8460 */
        {8,	0}, 	/* 0x8461 */
        {8,	0}, 	/* 0x8462 */
        {8,	0}, 	/* 0x8463 */
        {8,	0}, 	/* 0x8464 */
        {8,	0}, 	/* 0x8465 */
        {8,	0}, 	/* 0x8466 */
        {8,	0}, 	/* 0x8467 */
        {8,	0}, 	/* 0x8468 */
        {8,	0}, 	/* 0x8469 */
        {8,	0}, 	/* 0x846a */
        {8,	0}, 	/* 0x846b */
        {8,	0}, 	/* 0x846c */
        {8,	0}, 	/* 0x846d */
        {8,	0}, 	/* 0x846e */
        {8,	0}, 	/* 0x846f */
        {8,	0}, 	/* 0x8470 */
        {8,	0}, 	/* 0x8471 */
        {8,	0}, 	/* 0x8472 */
        {8,	0}, 	/* 0x8473 */
        {8,	0}, 	/* 0x8474 */
        {8,	0}, 	/* 0x8475 */
        {8,	0}, 	/* 0x8476 */
        {8,	0}, 	/* 0x8477 */
        {8,	0}, 	/* 0x8478 */
        {8,	0}, 	/* 0x8479 */
        {8,	0}, 	/* 0x847a */
        {8,	0}, 	/* 0x847b */
        {8,	0}, 	/* 0x847c */
        {8,	0}, 	/* 0x847d */
        {8,	0}, 	/* 0x847e */
        {8,	0}, 	/* 0x847f */
        {8,	0}, 	/* 0x8480 */
        {8,	0}, 	/* 0x8481 */
        {8,	0}, 	/* 0x8482 */
        {8,	0}, 	/* 0x8483 */
        {8,	0}, 	/* 0x8484 */
        {8,	0}, 	/* 0x8485 */
        {8,	0}, 	/* 0x8486 */
        {8,	0}, 	/* 0x8487 */
        {8,	0}, 	/* 0x8488 */
        {8,	0}, 	/* 0x8489 */
        {8,	0}, 	/* 0x848a */
        {8,	0}, 	/* 0x848b */
        {8,	0}, 	/* 0x848c */
        {8,	0}, 	/* 0x848d */
        {8,	0}, 	/* 0x848e */
        {8,	0}, 	/* 0x848f */
        {8,	0}, 	/* 0x8490 */
        {8,	0}, 	/* 0x8491 */
        {8,	0}, 	/* 0x8492 */
        {8,	0}, 	/* 0x8493 */
        {8,	0}, 	/* 0x8494 */
        {8,	0}, 	/* 0x8495 */
        {8,	0}, 	/* 0x8496 */
        {8,	0}, 	/* 0x8497 */
        {8,	0}, 	/* 0x8498 */
        {8,	0}, 	/* 0x8499 */
        {8,	0}, 	/* 0x849a */
        {8,	0}, 	/* 0x849b */
        {8,	0}, 	/* 0x849c */
        {8,	0}, 	/* 0x849d */
        {8,	0}, 	/* 0x849e */
        {8,	0}, 	/* 0x849f */
        {8,	0}, 	/* 0x84a0 */
        {8,	0}, 	/* 0x84a1 */
        {8,	0}, 	/* 0x84a2 */
        {8,	0}, 	/* 0x84a3 */
        {8,	0}, 	/* 0x84a4 */
        {8,	0}, 	/* 0x84a5 */
        {8,	0}, 	/* 0x84a6 */
        {8,	0}, 	/* 0x84a7 */
        {8,	0}, 	/* 0x84a8 */
        {8,	0}, 	/* 0x84a9 */
        {8,	0}, 	/* 0x84aa */
        {8,	0}, 	/* 0x84ab */
        {8,	0}, 	/* 0x84ac */
        {8,	0}, 	/* 0x84ad */
        {8,	0}, 	/* 0x84ae */
        {8,	0}, 	/* 0x84af */
        {8,	0}, 	/* 0x84b0 */
        {8,	0}, 	/* 0x84b1 */
        {8,	0}, 	/* 0x84b2 */
        {8,	0}, 	/* 0x84b3 */
        {8,	0}, 	/* 0x84b4 */
        {8,	0}, 	/* 0x84b5 */
        {8,	0}, 	/* 0x84b6 */
        {8,	0}, 	/* 0x84b7 */
        {8,	0}, 	/* 0x84b8 */
        {8,	0}, 	/* 0x84b9 */
        {8,	0}, 	/* 0x84ba */
        {8,	0}, 	/* 0x84bb */
        {8,	0}, 	/* 0x84bc */
        {8,	0}, 	/* 0x84bd */
        {8,	0}, 	/* 0x84be */
        {8,	0}, 	/* 0x84bf */
        {8,	0}, 	/* 0x84c0 */
        {8,	0}, 	/* 0x84c1 */
        {8,	0}, 	/* 0x84c2 */
        {8,	0}, 	/* 0x84c3 */
        {8,	0}, 	/* 0x84c4 */
        {8,	0}, 	/* 0x84c5 */
        {8,	0}, 	/* 0x84c6 */
        {8,	0}, 	/* 0x84c7 */
        {8,	0}, 	/* 0x84c8 */
        {8,	0}, 	/* 0x84c9 */
        {8,	0}, 	/* 0x84ca */
        {8,	0}, 	/* 0x84cb */
        {8,	0}, 	/* 0x84cc */
        {8,	0}, 	/* 0x84cd */
        {8,	0}, 	/* 0x84ce */
        {8,	0}, 	/* 0x84cf */
        {8,	0}, 	/* 0x84d0 */
        {8,	0}, 	/* 0x84d1 */
        {8,	0}, 	/* 0x84d2 */
        {8,	0}, 	/* 0x84d3 */
        {8,	0}, 	/* 0x84d4 */
        {8,	0}, 	/* 0x84d5 */
        {8,	0}, 	/* 0x84d6 */
        {8,	0}, 	/* 0x84d7 */
        {8,	0}, 	/* 0x84d8 */
        {8,	0}, 	/* 0x84d9 */
        {8,	0}, 	/* 0x84da */
        {8,	0}, 	/* 0x84db */
        {8,	0}, 	/* 0x84dc */
        {8,	0}, 	/* 0x84dd */
        {8,	0}, 	/* 0x84de */
        {8,	0}, 	/* 0x84df */
        {8,	0}, 	/* 0x84e0 */
        {8,	0}, 	/* 0x84e1 */
        {8,	0}, 	/* 0x84e2 */
        {8,	0}, 	/* 0x84e3 */
        {8,	0}, 	/* 0x84e4 */
        {8,	0}, 	/* 0x84e5 */
        {8,	0}, 	/* 0x84e6 */
        {8,	0}, 	/* 0x84e7 */
        {8,	0}, 	/* 0x84e8 */
        {8,	0}, 	/* 0x84e9 */
        {8,	0}, 	/* 0x84ea */
        {8,	0}, 	/* 0x84eb */
        {8,	0}, 	/* 0x84ec */
        {8,	0}, 	/* 0x84ed */
        {8,	0}, 	/* 0x84ee */
        {8,	0}, 	/* 0x84ef */
        {8,	0}, 	/* 0x84f0 */
        {8,	0}, 	/* 0x84f1 */
        {8,	0}, 	/* 0x84f2 */
        {8,	0}, 	/* 0x84f3 */
        {8,	0}, 	/* 0x84f4 */
        {8,	0}, 	/* 0x84f5 */
        {8,	0}, 	/* 0x84f6 */
        {8,	0}, 	/* 0x84f7 */
        {8,	0}, 	/* 0x84f8 */
        {8,	0}, 	/* 0x84f9 */
        {8,	0}, 	/* 0x84fa */
        {8,	0}, 	/* 0x84fb */
        {8,	0}, 	/* 0x84fc */
        {8,	0}, 	/* 0x84fd */
        {8,	0}, 	/* 0x84fe */
        {8,	0}, 	/* 0x84ff */
        {8,	0}, 	/* 0x8500 */
        {8,	0}, 	/* 0x8501 */
        {8,	0}, 	/* 0x8502 */
        {8,	0}, 	/* 0x8503 */
        {8,	0}, 	/* 0x8504 */
        {8,	0}, 	/* 0x8505 */
        {8,	0}, 	/* 0x8506 */
        {8,	0}, 	/* 0x8507 */
        {8,	0}, 	/* 0x8508 */
        {8,	0}, 	/* 0x8509 */
        {8,	0}, 	/* 0x850a */
        {8,	0}, 	/* 0x850b */
        {8,	0}, 	/* 0x850c */
        {8,	0}, 	/* 0x850d */
        {8,	0}, 	/* 0x850e */
        {8,	0}, 	/* 0x850f */
        {8,	0}, 	/* 0x8510 */
        {8,	0}, 	/* 0x8511 */
        {8,	0}, 	/* 0x8512 */
        {8,	0}, 	/* 0x8513 */
        {8,	0}, 	/* 0x8514 */
        {8,	0}, 	/* 0x8515 */
        {8,	0}, 	/* 0x8516 */
        {8,	0}, 	/* 0x8517 */
        {8,	0}, 	/* 0x8518 */
        {8,	0}, 	/* 0x8519 */
        {8,	0}, 	/* 0x851a */
        {8,	0}, 	/* 0x851b */
        {8,	0}, 	/* 0x851c */
        {8,	0}, 	/* 0x851d */
        {8,	0}, 	/* 0x851e */
        {8,	0}, 	/* 0x851f */
        {8,	0}, 	/* 0x8520 */
        {8,	0}, 	/* 0x8521 */
        {8,	0}, 	/* 0x8522 */
        {8,	0}, 	/* 0x8523 */
        {8,	0}, 	/* 0x8524 */
        {8,	0}, 	/* 0x8525 */
        {8,	0}, 	/* 0x8526 */
        {8,	0}, 	/* 0x8527 */
        {8,	0}, 	/* 0x8528 */
        {8,	0}, 	/* 0x8529 */
        {8,	0}, 	/* 0x852a */
        {8,	0}, 	/* 0x852b */
        {8,	0}, 	/* 0x852c */
        {8,	0}, 	/* 0x852d */
        {8,	0}, 	/* 0x852e */
        {8,	0}, 	/* 0x852f */
        {8,	0}, 	/* 0x8530 */
        {8,	0}, 	/* 0x8531 */
        {8,	0}, 	/* 0x8532 */
        {8,	0}, 	/* 0x8533 */
        {8,	0}, 	/* 0x8534 */
        {8,	0}, 	/* 0x8535 */
        {8,	0}, 	/* 0x8536 */
        {8,	0}, 	/* 0x8537 */
        {8,	0}, 	/* 0x8538 */
        {8,	0}, 	/* 0x8539 */
        {8,	0}, 	/* 0x853a */
        {8,	0}, 	/* 0x853b */
        {8,	0}, 	/* 0x853c */
        {8,	0}, 	/* 0x853d */
        {8,	0}, 	/* 0x853e */
        {8,	0}, 	/* 0x853f */
        {8,	0}, 	/* 0x8540 */
        {8,	0}, 	/* 0x8541 */
        {8,	0}, 	/* 0x8542 */
        {8,	0}, 	/* 0x8543 */
        {8,	0}, 	/* 0x8544 */
        {8,	0}, 	/* 0x8545 */
        {8,	0}, 	/* 0x8546 */
        {8,	0}, 	/* 0x8547 */
        {8,	0}, 	/* 0x8548 */
        {8,	0}, 	/* 0x8549 */
        {8,	0}, 	/* 0x854a */
        {8,	0}, 	/* 0x854b */
        {8,	0}, 	/* 0x854c */
        {8,	0}, 	/* 0x854d */
        {8,	0}, 	/* 0x854e */
        {8,	0}, 	/* 0x854f */
        {8,	0}, 	/* 0x8550 */
        {8,	0}, 	/* 0x8551 */
        {8,	0}, 	/* 0x8552 */
        {8,	0}, 	/* 0x8553 */
        {8,	0}, 	/* 0x8554 */
        {8,	0}, 	/* 0x8555 */
        {8,	0}, 	/* 0x8556 */
        {8,	0}, 	/* 0x8557 */
        {8,	0}, 	/* 0x8558 */
        {8,	0}, 	/* 0x8559 */
        {8,	0}, 	/* 0x855a */
        {8,	0}, 	/* 0x855b */
        {8,	0}, 	/* 0x855c */
        {8,	0}, 	/* 0x855d */
        {8,	0}, 	/* 0x855e */
        {8,	0}, 	/* 0x855f */
        {8,	0}, 	/* 0x8560 */
        {8,	0}, 	/* 0x8561 */
        {8,	0}, 	/* 0x8562 */
        {8,	0}, 	/* 0x8563 */
        {8,	0}, 	/* 0x8564 */
        {8,	0}, 	/* 0x8565 */
        {8,	0}, 	/* 0x8566 */
        {8,	0}, 	/* 0x8567 */
        {8,	0}, 	/* 0x8568 */
        {8,	0}, 	/* 0x8569 */
        {8,	0}, 	/* 0x856a */
        {8,	0}, 	/* 0x856b */
        {8,	0}, 	/* 0x856c */
        {8,	0}, 	/* 0x856d */
        {8,	0}, 	/* 0x856e */
        {8,	0}, 	/* 0x856f */
        {8,	0}, 	/* 0x8570 */
        {8,	0}, 	/* 0x8571 */
        {8,	0}, 	/* 0x8572 */
        {8,	0}, 	/* 0x8573 */
        {8,	0}, 	/* 0x8574 */
        {8,	0}, 	/* 0x8575 */
        {8,	0}, 	/* 0x8576 */
        {8,	0}, 	/* 0x8577 */
        {8,	0}, 	/* 0x8578 */
        {8,	0}, 	/* 0x8579 */
        {8,	0}, 	/* 0x857a */
        {8,	0}, 	/* 0x857b */
        {8,	0}, 	/* 0x857c */
        {8,	0}, 	/* 0x857d */
        {8,	0}, 	/* 0x857e */
        {8,	0}, 	/* 0x857f */
        {8,	0}, 	/* 0x8580 */
        {8,	0}, 	/* 0x8581 */
        {8,	0}, 	/* 0x8582 */
        {8,	0}, 	/* 0x8583 */
        {8,	0}, 	/* 0x8584 */
        {8,	0}, 	/* 0x8585 */
        {8,	0}, 	/* 0x8586 */
        {8,	0}, 	/* 0x8587 */
        {8,	0}, 	/* 0x8588 */
        {8,	0}, 	/* 0x8589 */
        {8,	0}, 	/* 0x858a */
        {8,	0}, 	/* 0x858b */
        {8,	0}, 	/* 0x858c */
        {8,	0}, 	/* 0x858d */
        {8,	0}, 	/* 0x858e */
        {8,	0}, 	/* 0x858f */
        {8,	0}, 	/* 0x8590 */
        {8,	0}, 	/* 0x8591 */
        {8,	0}, 	/* 0x8592 */
        {8,	0}, 	/* 0x8593 */
        {8,	0}, 	/* 0x8594 */
        {8,	0}, 	/* 0x8595 */
        {8,	0}, 	/* 0x8596 */
        {8,	0}, 	/* 0x8597 */
        {8,	0}, 	/* 0x8598 */
        {8,	0}, 	/* 0x8599 */
        {8,	0}, 	/* 0x859a */
        {8,	0}, 	/* 0x859b */
        {8,	0}, 	/* 0x859c */
        {8,	0}, 	/* 0x859d */
        {8,	0}, 	/* 0x859e */
        {8,	0}, 	/* 0x859f */
        {8,	0}, 	/* 0x85a0 */
        {8,	0}, 	/* 0x85a1 */
        {8,	0}, 	/* 0x85a2 */
        {8,	0}, 	/* 0x85a3 */
        {8,	0}, 	/* 0x85a4 */
        {8,	0}, 	/* 0x85a5 */
        {8,	0}, 	/* 0x85a6 */
        {8,	0}, 	/* 0x85a7 */
        {8,	0}, 	/* 0x85a8 */
        {8,	0}, 	/* 0x85a9 */
        {8,	0}, 	/* 0x85aa */
        {8,	0}, 	/* 0x85ab */
        {8,	0}, 	/* 0x85ac */
        {8,	0}, 	/* 0x85ad */
        {8,	0}, 	/* 0x85ae */
        {8,	0}, 	/* 0x85af */
        {8,	0}, 	/* 0x85b0 */
        {8,	0}, 	/* 0x85b1 */
        {8,	0}, 	/* 0x85b2 */
        {8,	0}, 	/* 0x85b3 */
        {8,	0}, 	/* 0x85b4 */
        {8,	0}, 	/* 0x85b5 */
        {8,	0}, 	/* 0x85b6 */
        {8,	0}, 	/* 0x85b7 */
        {8,	0}, 	/* 0x85b8 */
        {8,	0}, 	/* 0x85b9 */
        {8,	0}, 	/* 0x85ba */
        {8,	0}, 	/* 0x85bb */
        {8,	0}, 	/* 0x85bc */
        {8,	0}, 	/* 0x85bd */
        {8,	0}, 	/* 0x85be */
        {8,	0}, 	/* 0x85bf */
        {8,	0}, 	/* 0x85c0 */
        {8,	0}, 	/* 0x85c1 */
        {8,	0}, 	/* 0x85c2 */
        {8,	0}, 	/* 0x85c3 */
        {8,	0}, 	/* 0x85c4 */
        {8,	0}, 	/* 0x85c5 */
        {8,	0}, 	/* 0x85c6 */
        {8,	0}, 	/* 0x85c7 */
        {8,	0}, 	/* 0x85c8 */
        {8,	0}, 	/* 0x85c9 */
        {8,	0}, 	/* 0x85ca */
        {8,	0}, 	/* 0x85cb */
        {8,	0}, 	/* 0x85cc */
        {8,	0}, 	/* 0x85cd */
        {8,	0}, 	/* 0x85ce */
        {8,	0}, 	/* 0x85cf */
        {8,	0}, 	/* 0x85d0 */
        {8,	0}, 	/* 0x85d1 */
        {8,	0}, 	/* 0x85d2 */
        {8,	0}, 	/* 0x85d3 */
        {8,	0}, 	/* 0x85d4 */
        {8,	0}, 	/* 0x85d5 */
        {8,	0}, 	/* 0x85d6 */
        {8,	0}, 	/* 0x85d7 */
        {8,	0}, 	/* 0x85d8 */
        {8,	0}, 	/* 0x85d9 */
        {8,	0}, 	/* 0x85da */
        {8,	0}, 	/* 0x85db */
        {8,	0}, 	/* 0x85dc */
        {8,	0}, 	/* 0x85dd */
        {8,	0}, 	/* 0x85de */
        {8,	0}, 	/* 0x85df */
        {8,	0}, 	/* 0x85e0 */
        {8,	0}, 	/* 0x85e1 */
        {8,	0}, 	/* 0x85e2 */
        {8,	0}, 	/* 0x85e3 */
        {8,	0}, 	/* 0x85e4 */
        {8,	0}, 	/* 0x85e5 */
        {8,	0}, 	/* 0x85e6 */
        {8,	0}, 	/* 0x85e7 */
        {8,	0}, 	/* 0x85e8 */
        {8,	0}, 	/* 0x85e9 */
        {8,	0}, 	/* 0x85ea */
        {8,	0}, 	/* 0x85eb */
        {8,	0}, 	/* 0x85ec */
        {8,	0}, 	/* 0x85ed */
        {8,	0}, 	/* 0x85ee */
        {8,	0}, 	/* 0x85ef */
        {8,	0}, 	/* 0x85f0 */
        {8,	0}, 	/* 0x85f1 */
        {8,	0}, 	/* 0x85f2 */
        {8,	0}, 	/* 0x85f3 */
        {8,	0}, 	/* 0x85f4 */
        {8,	0}, 	/* 0x85f5 */
        {8,	0}, 	/* 0x85f6 */
        {8,	0}, 	/* 0x85f7 */
        {8,	0}, 	/* 0x85f8 */
        {8,	0}, 	/* 0x85f9 */
        {8,	0}, 	/* 0x85fa */
        {8,	0}, 	/* 0x85fb */
        {8,	0}, 	/* 0x85fc */
        {8,	0}, 	/* 0x85fd */
        {8,	0}, 	/* 0x85fe */
        {8,	0}, 	/* 0x85ff */
        {8,	0}, 	/* 0x8600 */
        {8,	0}, 	/* 0x8601 */
        {8,	0}, 	/* 0x8602 */
        {8,	0}, 	/* 0x8603 */
        {8,	0}, 	/* 0x8604 */
        {8,	0}, 	/* 0x8605 */
        {8,	0}, 	/* 0x8606 */
        {8,	0}, 	/* 0x8607 */
        {8,	0}, 	/* 0x8608 */
        {8,	0}, 	/* 0x8609 */
        {8,	0}, 	/* 0x860a */
        {8,	0}, 	/* 0x860b */
        {8,	0}, 	/* 0x860c */
        {8,	0}, 	/* 0x860d */
        {8,	0}, 	/* 0x860e */
        {8,	0}, 	/* 0x860f */
        {8,	0}, 	/* 0x8610 */
        {8,	0}, 	/* 0x8611 */
        {8,	0}, 	/* 0x8612 */
        {8,	0}, 	/* 0x8613 */
        {8,	0}, 	/* 0x8614 */
        {8,	0}, 	/* 0x8615 */
        {8,	0}, 	/* 0x8616 */
        {8,	0}, 	/* 0x8617 */
        {8,	0}, 	/* 0x8618 */
        {8,	0}, 	/* 0x8619 */
        {8,	0}, 	/* 0x861a */
        {8,	0}, 	/* 0x861b */
        {8,	0}, 	/* 0x861c */
        {8,	0}, 	/* 0x861d */
        {8,	0}, 	/* 0x861e */
        {8,	0}, 	/* 0x861f */
        {8,	0}, 	/* 0x8620 */
        {8,	0}, 	/* 0x8621 */
        {8,	0}, 	/* 0x8622 */
        {8,	0}, 	/* 0x8623 */
        {8,	0}, 	/* 0x8624 */
        {8,	0}, 	/* 0x8625 */
        {8,	0}, 	/* 0x8626 */
        {8,	0}, 	/* 0x8627 */
        {8,	0}, 	/* 0x8628 */
        {8,	0}, 	/* 0x8629 */
        {8,	0}, 	/* 0x862a */
        {8,	0}, 	/* 0x862b */
        {8,	0}, 	/* 0x862c */
        {8,	0}, 	/* 0x862d */
        {8,	0}, 	/* 0x862e */
        {8,	0}, 	/* 0x862f */
        {8,	0}, 	/* 0x8630 */
        {8,	0}, 	/* 0x8631 */
        {8,	0}, 	/* 0x8632 */
        {8,	0}, 	/* 0x8633 */
        {8,	0}, 	/* 0x8634 */
        {8,	0}, 	/* 0x8635 */
        {8,	0}, 	/* 0x8636 */
        {8,	0}, 	/* 0x8637 */
        {8,	0}, 	/* 0x8638 */
        {8,	0}, 	/* 0x8639 */
        {8,	0}, 	/* 0x863a */
        {8,	0}, 	/* 0x863b */
        {8,	0}, 	/* 0x863c */
        {8,	0}, 	/* 0x863d */
        {8,	0}, 	/* 0x863e */
        {8,	0}, 	/* 0x863f */
        {8,	0}, 	/* 0x8640 */
        {8,	0}, 	/* 0x8641 */
        {8,	0}, 	/* 0x8642 */
        {8,	0}, 	/* 0x8643 */
        {8,	0}, 	/* 0x8644 */
        {8,	0}, 	/* 0x8645 */
        {8,	0}, 	/* 0x8646 */
        {8,	0}, 	/* 0x8647 */
        {8,	0}, 	/* 0x8648 */
        {8,	0}, 	/* 0x8649 */
        {8,	0}, 	/* 0x864a */
        {8,	0}, 	/* 0x864b */
        {8,	0}, 	/* 0x864c */
        {8,	0}, 	/* 0x864d */
        {8,	0}, 	/* 0x864e */
        {8,	0}, 	/* 0x864f */
        {8,	0}, 	/* 0x8650 */
        {8,	0}, 	/* 0x8651 */
        {8,	0}, 	/* 0x8652 */
        {8,	0}, 	/* 0x8653 */
        {8,	0}, 	/* 0x8654 */
        {8,	0}, 	/* 0x8655 */
        {8,	0}, 	/* 0x8656 */
        {8,	0}, 	/* 0x8657 */
        {8,	0}, 	/* 0x8658 */
        {8,	0}, 	/* 0x8659 */
        {8,	0}, 	/* 0x865a */
        {8,	0}, 	/* 0x865b */
        {8,	0}, 	/* 0x865c */
        {8,	0}, 	/* 0x865d */
        {8,	0}, 	/* 0x865e */
        {8,	0}, 	/* 0x865f */
        {8,	0}, 	/* 0x8660 */
        {8,	0}, 	/* 0x8661 */
        {8,	0}, 	/* 0x8662 */
        {8,	0}, 	/* 0x8663 */
        {8,	0}, 	/* 0x8664 */
        {8,	0}, 	/* 0x8665 */
        {8,	0}, 	/* 0x8666 */
        {8,	0}, 	/* 0x8667 */
        {8,	0}, 	/* 0x8668 */
        {8,	0}, 	/* 0x8669 */
        {8,	0}, 	/* 0x866a */
        {8,	0}, 	/* 0x866b */
        {8,	0}, 	/* 0x866c */
        {8,	0}, 	/* 0x866d */
        {8,	0}, 	/* 0x866e */
        {8,	0}, 	/* 0x866f */
        {8,	0}, 	/* 0x8670 */
        {8,	0}, 	/* 0x8671 */
        {8,	0}, 	/* 0x8672 */
        {8,	0}, 	/* 0x8673 */
        {8,	0}, 	/* 0x8674 */
        {8,	0}, 	/* 0x8675 */
        {8,	0}, 	/* 0x8676 */
        {8,	0}, 	/* 0x8677 */
        {8,	0}, 	/* 0x8678 */
        {8,	0}, 	/* 0x8679 */
        {8,	0}, 	/* 0x867a */
        {8,	0}, 	/* 0x867b */
        {8,	0}, 	/* 0x867c */
        {8,	0}, 	/* 0x867d */
        {8,	0}, 	/* 0x867e */
        {8,	0}, 	/* 0x867f */
        {8,	0}, 	/* 0x8680 */
        {8,	0}, 	/* 0x8681 */
        {8,	0}, 	/* 0x8682 */
        {8,	0}, 	/* 0x8683 */
        {8,	0}, 	/* 0x8684 */
        {8,	0}, 	/* 0x8685 */
        {8,	0}, 	/* 0x8686 */
        {8,	0}, 	/* 0x8687 */
        {8,	0}, 	/* 0x8688 */
        {8,	0}, 	/* 0x8689 */
        {8,	0}, 	/* 0x868a */
        {8,	0}, 	/* 0x868b */
        {8,	0}, 	/* 0x868c */
        {8,	0}, 	/* 0x868d */
        {8,	0}, 	/* 0x868e */
        {8,	0}, 	/* 0x868f */
        {8,	0}, 	/* 0x8690 */
        {8,	0}, 	/* 0x8691 */
        {8,	0}, 	/* 0x8692 */
        {8,	0}, 	/* 0x8693 */
        {8,	0}, 	/* 0x8694 */
        {8,	0}, 	/* 0x8695 */
        {8,	0}, 	/* 0x8696 */
        {8,	0}, 	/* 0x8697 */
        {8,	0}, 	/* 0x8698 */
        {8,	0}, 	/* 0x8699 */
        {8,	0}, 	/* 0x869a */
        {8,	0}, 	/* 0x869b */
        {8,	0}, 	/* 0x869c */
        {8,	0}, 	/* 0x869d */
        {8,	0}, 	/* 0x869e */
        {8,	0}, 	/* 0x869f */
        {8,	0}, 	/* 0x86a0 */
        {8,	0}, 	/* 0x86a1 */
        {8,	0}, 	/* 0x86a2 */
        {8,	0}, 	/* 0x86a3 */
        {8,	0}, 	/* 0x86a4 */
        {8,	0}, 	/* 0x86a5 */
        {8,	0}, 	/* 0x86a6 */
        {8,	0}, 	/* 0x86a7 */
        {8,	0}, 	/* 0x86a8 */
        {8,	0}, 	/* 0x86a9 */
        {8,	0}, 	/* 0x86aa */
        {8,	0}, 	/* 0x86ab */
        {8,	0}, 	/* 0x86ac */
        {8,	0}, 	/* 0x86ad */
        {8,	0}, 	/* 0x86ae */
        {8,	0}, 	/* 0x86af */
        {8,	0}, 	/* 0x86b0 */
        {8,	0}, 	/* 0x86b1 */
        {8,	0}, 	/* 0x86b2 */
        {8,	0}, 	/* 0x86b3 */
        {8,	0}, 	/* 0x86b4 */
        {8,	0}, 	/* 0x86b5 */
        {8,	0}, 	/* 0x86b6 */
        {8,	0}, 	/* 0x86b7 */
        {8,	0}, 	/* 0x86b8 */
        {8,	0}, 	/* 0x86b9 */
        {8,	0}, 	/* 0x86ba */
        {8,	0}, 	/* 0x86bb */
        {8,	0}, 	/* 0x86bc */
        {8,	0}, 	/* 0x86bd */
        {8,	0}, 	/* 0x86be */
        {8,	0}, 	/* 0x86bf */
        {8,	0}, 	/* 0x86c0 */
        {8,	0}, 	/* 0x86c1 */
        {8,	0}, 	/* 0x86c2 */
        {8,	0}, 	/* 0x86c3 */
        {8,	0}, 	/* 0x86c4 */
        {8,	0}, 	/* 0x86c5 */
        {8,	0}, 	/* 0x86c6 */
        {8,	0}, 	/* 0x86c7 */
        {8,	0}, 	/* 0x86c8 */
        {8,	0}, 	/* 0x86c9 */
        {8,	0}, 	/* 0x86ca */
        {8,	0}, 	/* 0x86cb */
        {8,	0}, 	/* 0x86cc */
        {8,	0}, 	/* 0x86cd */
        {8,	0}, 	/* 0x86ce */
        {8,	0}, 	/* 0x86cf */
        {8,	0}, 	/* 0x86d0 */
        {8,	0}, 	/* 0x86d1 */
        {8,	0}, 	/* 0x86d2 */
        {8,	0}, 	/* 0x86d3 */
        {8,	0}, 	/* 0x86d4 */
        {8,	0}, 	/* 0x86d5 */
        {8,	0}, 	/* 0x86d6 */
        {8,	0}, 	/* 0x86d7 */
        {8,	0}, 	/* 0x86d8 */
        {8,	0}, 	/* 0x86d9 */
        {8,	0}, 	/* 0x86da */
        {8,	0}, 	/* 0x86db */
        {8,	0}, 	/* 0x86dc */
        {8,	0}, 	/* 0x86dd */
        {8,	0}, 	/* 0x86de */
        {8,	0}, 	/* 0x86df */
        {8,	0}, 	/* 0x86e0 */
        {8,	0}, 	/* 0x86e1 */
        {8,	0}, 	/* 0x86e2 */
        {8,	0}, 	/* 0x86e3 */
        {8,	0}, 	/* 0x86e4 */
        {8,	0}, 	/* 0x86e5 */
        {8,	0}, 	/* 0x86e6 */
        {8,	0}, 	/* 0x86e7 */
        {8,	0}, 	/* 0x86e8 */
        {8,	0}, 	/* 0x86e9 */
        {8,	0}, 	/* 0x86ea */
        {8,	0}, 	/* 0x86eb */
        {8,	0}, 	/* 0x86ec */
        {8,	0}, 	/* 0x86ed */
        {8,	0}, 	/* 0x86ee */
        {8,	0}, 	/* 0x86ef */
        {8,	0}, 	/* 0x86f0 */
        {8,	0}, 	/* 0x86f1 */
        {8,	0}, 	/* 0x86f2 */
        {8,	0}, 	/* 0x86f3 */
        {8,	0}, 	/* 0x86f4 */
        {8,	0}, 	/* 0x86f5 */
        {8,	0}, 	/* 0x86f6 */
        {8,	0}, 	/* 0x86f7 */
        {8,	0}, 	/* 0x86f8 */
        {8,	0}, 	/* 0x86f9 */
        {8,	0}, 	/* 0x86fa */
        {8,	0}, 	/* 0x86fb */
        {8,	0}, 	/* 0x86fc */
        {8,	0}, 	/* 0x86fd */
        {8,	0}, 	/* 0x86fe */
        {8,	0}, 	/* 0x86ff */
        {8,	0}, 	/* 0x8700 */
        {8,	0}, 	/* 0x8701 */
        {8,	0}, 	/* 0x8702 */
        {8,	0}, 	/* 0x8703 */
        {8,	0}, 	/* 0x8704 */
        {8,	0}, 	/* 0x8705 */
        {8,	0}, 	/* 0x8706 */
        {8,	0}, 	/* 0x8707 */
        {8,	0}, 	/* 0x8708 */
        {8,	0}, 	/* 0x8709 */
        {8,	0}, 	/* 0x870a */
        {8,	0}, 	/* 0x870b */
        {8,	0}, 	/* 0x870c */
        {8,	0}, 	/* 0x870d */
        {8,	0}, 	/* 0x870e */
        {8,	0}, 	/* 0x870f */
        {8,	0}, 	/* 0x8710 */
        {8,	0}, 	/* 0x8711 */
        {8,	0}, 	/* 0x8712 */
        {8,	0}, 	/* 0x8713 */
        {8,	0}, 	/* 0x8714 */
        {8,	0}, 	/* 0x8715 */
        {8,	0}, 	/* 0x8716 */
        {8,	0}, 	/* 0x8717 */
        {8,	0}, 	/* 0x8718 */
        {8,	0}, 	/* 0x8719 */
        {8,	0}, 	/* 0x871a */
        {8,	0}, 	/* 0x871b */
        {8,	0}, 	/* 0x871c */
        {8,	0}, 	/* 0x871d */
        {8,	0}, 	/* 0x871e */
        {8,	0}, 	/* 0x871f */
        {8,	0}, 	/* 0x8720 */
        {8,	0}, 	/* 0x8721 */
        {8,	0}, 	/* 0x8722 */
        {8,	0}, 	/* 0x8723 */
        {8,	0}, 	/* 0x8724 */
        {8,	0}, 	/* 0x8725 */
        {8,	0}, 	/* 0x8726 */
        {8,	0}, 	/* 0x8727 */
        {8,	0}, 	/* 0x8728 */
        {8,	0}, 	/* 0x8729 */
        {8,	0}, 	/* 0x872a */
        {8,	0}, 	/* 0x872b */
        {8,	0}, 	/* 0x872c */
        {8,	0}, 	/* 0x872d */
        {8,	0}, 	/* 0x872e */
        {8,	0}, 	/* 0x872f */
        {8,	0}, 	/* 0x8730 */
        {8,	0}, 	/* 0x8731 */
        {8,	0}, 	/* 0x8732 */
        {8,	0}, 	/* 0x8733 */
        {8,	0}, 	/* 0x8734 */
        {8,	0}, 	/* 0x8735 */
        {8,	0}, 	/* 0x8736 */
        {8,	0}, 	/* 0x8737 */
        {8,	0}, 	/* 0x8738 */
        {8,	0}, 	/* 0x8739 */
        {8,	0}, 	/* 0x873a */
        {8,	0}, 	/* 0x873b */
        {8,	0}, 	/* 0x873c */
        {8,	0}, 	/* 0x873d */
        {8,	0}, 	/* 0x873e */
        {8,	0}, 	/* 0x873f */
        {8,	0}, 	/* 0x8740 */
        {8,	0}, 	/* 0x8741 */
        {8,	0}, 	/* 0x8742 */
        {8,	0}, 	/* 0x8743 */
        {8,	0}, 	/* 0x8744 */
        {8,	0}, 	/* 0x8745 */
        {8,	0}, 	/* 0x8746 */
        {8,	0}, 	/* 0x8747 */
        {8,	0}, 	/* 0x8748 */
        {8,	0}, 	/* 0x8749 */
        {8,	0}, 	/* 0x874a */
        {8,	0}, 	/* 0x874b */
        {8,	0}, 	/* 0x874c */
        {8,	0}, 	/* 0x874d */
        {8,	0}, 	/* 0x874e */
        {8,	0}, 	/* 0x874f */
        {8,	0}, 	/* 0x8750 */
        {8,	0}, 	/* 0x8751 */
        {8,	0}, 	/* 0x8752 */
        {8,	0}, 	/* 0x8753 */
        {8,	0}, 	/* 0x8754 */
        {8,	0}, 	/* 0x8755 */
        {8,	0}, 	/* 0x8756 */
        {8,	0}, 	/* 0x8757 */
        {8,	0}, 	/* 0x8758 */
        {8,	0}, 	/* 0x8759 */
        {8,	0}, 	/* 0x875a */
        {8,	0}, 	/* 0x875b */
        {8,	0}, 	/* 0x875c */
        {8,	0}, 	/* 0x875d */
        {8,	0}, 	/* 0x875e */
        {8,	0}, 	/* 0x875f */
        {8,	0}, 	/* 0x8760 */
        {8,	0}, 	/* 0x8761 */
        {8,	0}, 	/* 0x8762 */
        {8,	0}, 	/* 0x8763 */
        {8,	0}, 	/* 0x8764 */
        {8,	0}, 	/* 0x8765 */
        {8,	0}, 	/* 0x8766 */
        {8,	0}, 	/* 0x8767 */
        {8,	0}, 	/* 0x8768 */
        {8,	0}, 	/* 0x8769 */
        {8,	0}, 	/* 0x876a */
        {8,	0}, 	/* 0x876b */
        {8,	0}, 	/* 0x876c */
        {8,	0}, 	/* 0x876d */
        {8,	0}, 	/* 0x876e */
        {8,	0}, 	/* 0x876f */
        {8,	0}, 	/* 0x8770 */
        {8,	0}, 	/* 0x8771 */
        {8,	0}, 	/* 0x8772 */
        {8,	0}, 	/* 0x8773 */
        {8,	0}, 	/* 0x8774 */
        {8,	0}, 	/* 0x8775 */
        {8,	0}, 	/* 0x8776 */
        {8,	0}, 	/* 0x8777 */
        {8,	0}, 	/* 0x8778 */
        {8,	0}, 	/* 0x8779 */
        {8,	0}, 	/* 0x877a */
        {8,	0}, 	/* 0x877b */
        {8,	0}, 	/* 0x877c */
        {8,	0}, 	/* 0x877d */
        {8,	0}, 	/* 0x877e */
        {8,	0}, 	/* 0x877f */
        {8,	0}, 	/* 0x8780 */
        {8,	0}, 	/* 0x8781 */
        {8,	0}, 	/* 0x8782 */
        {8,	0}, 	/* 0x8783 */
        {8,	0}, 	/* 0x8784 */
        {8,	0}, 	/* 0x8785 */
        {8,	0}, 	/* 0x8786 */
        {8,	0}, 	/* 0x8787 */
        {8,	0}, 	/* 0x8788 */
        {8,	0}, 	/* 0x8789 */
        {8,	0}, 	/* 0x878a */
        {8,	0}, 	/* 0x878b */
        {8,	0}, 	/* 0x878c */
        {8,	0}, 	/* 0x878d */
        {8,	0}, 	/* 0x878e */
        {8,	0}, 	/* 0x878f */
        {8,	0}, 	/* 0x8790 */
        {8,	0}, 	/* 0x8791 */
        {8,	0}, 	/* 0x8792 */
        {8,	0}, 	/* 0x8793 */
        {8,	0}, 	/* 0x8794 */
        {8,	0}, 	/* 0x8795 */
        {8,	0}, 	/* 0x8796 */
        {8,	0}, 	/* 0x8797 */
        {8,	0}, 	/* 0x8798 */
        {8,	0}, 	/* 0x8799 */
        {8,	0}, 	/* 0x879a */
        {8,	0}, 	/* 0x879b */
        {8,	0}, 	/* 0x879c */
        {8,	0}, 	/* 0x879d */
        {8,	0}, 	/* 0x879e */
        {8,	0}, 	/* 0x879f */
        {8,	0}, 	/* 0x87a0 */
        {8,	0}, 	/* 0x87a1 */
        {8,	0}, 	/* 0x87a2 */
        {8,	0}, 	/* 0x87a3 */
        {8,	0}, 	/* 0x87a4 */
        {8,	0}, 	/* 0x87a5 */
        {8,	0}, 	/* 0x87a6 */
        {8,	0}, 	/* 0x87a7 */
        {8,	0}, 	/* 0x87a8 */
        {8,	0}, 	/* 0x87a9 */
        {8,	0}, 	/* 0x87aa */
        {8,	0}, 	/* 0x87ab */
        {8,	0}, 	/* 0x87ac */
        {8,	0}, 	/* 0x87ad */
        {8,	0}, 	/* 0x87ae */
        {8,	0}, 	/* 0x87af */
        {8,	0}, 	/* 0x87b0 */
        {8,	0}, 	/* 0x87b1 */
        {8,	0}, 	/* 0x87b2 */
        {8,	0}, 	/* 0x87b3 */
        {8,	0}, 	/* 0x87b4 */
        {8,	0}, 	/* 0x87b5 */
        {8,	0}, 	/* 0x87b6 */
        {8,	0}, 	/* 0x87b7 */
        {8,	0}, 	/* 0x87b8 */
        {8,	0}, 	/* 0x87b9 */
        {8,	0}, 	/* 0x87ba */
        {8,	0}, 	/* 0x87bb */
        {8,	0}, 	/* 0x87bc */
        {8,	0}, 	/* 0x87bd */
        {8,	0}, 	/* 0x87be */
        {8,	0}, 	/* 0x87bf */
        {8,	0}, 	/* 0x87c0 */
        {8,	0}, 	/* 0x87c1 */
        {8,	0}, 	/* 0x87c2 */
        {8,	0}, 	/* 0x87c3 */
        {8,	0}, 	/* 0x87c4 */
        {8,	0}, 	/* 0x87c5 */
        {8,	0}, 	/* 0x87c6 */
        {8,	0}, 	/* 0x87c7 */
        {8,	0}, 	/* 0x87c8 */
        {8,	0}, 	/* 0x87c9 */
        {8,	0}, 	/* 0x87ca */
        {8,	0}, 	/* 0x87cb */
        {8,	0}, 	/* 0x87cc */
        {8,	0}, 	/* 0x87cd */
        {8,	0}, 	/* 0x87ce */
        {8,	0}, 	/* 0x87cf */
        {8,	0}, 	/* 0x87d0 */
        {8,	0}, 	/* 0x87d1 */
        {8,	0}, 	/* 0x87d2 */
        {8,	0}, 	/* 0x87d3 */
        {8,	0}, 	/* 0x87d4 */
        {8,	0}, 	/* 0x87d5 */
        {8,	0}, 	/* 0x87d6 */
        {8,	0}, 	/* 0x87d7 */
        {8,	0}, 	/* 0x87d8 */
        {8,	0}, 	/* 0x87d9 */
        {8,	0}, 	/* 0x87da */
        {8,	0}, 	/* 0x87db */
        {8,	0}, 	/* 0x87dc */
        {8,	0}, 	/* 0x87dd */
        {8,	0}, 	/* 0x87de */
        {8,	0}, 	/* 0x87df */
        {8,	0}, 	/* 0x87e0 */
        {8,	0}, 	/* 0x87e1 */
        {8,	0}, 	/* 0x87e2 */
        {8,	0}, 	/* 0x87e3 */
        {8,	0}, 	/* 0x87e4 */
        {8,	0}, 	/* 0x87e5 */
        {8,	0}, 	/* 0x87e6 */
        {8,	0}, 	/* 0x87e7 */
        {8,	0}, 	/* 0x87e8 */
        {8,	0}, 	/* 0x87e9 */
        {8,	0}, 	/* 0x87ea */
        {8,	0}, 	/* 0x87eb */
        {8,	0}, 	/* 0x87ec */
        {8,	0}, 	/* 0x87ed */
        {8,	0}, 	/* 0x87ee */
        {8,	0}, 	/* 0x87ef */
        {8,	0}, 	/* 0x87f0 */
        {8,	0}, 	/* 0x87f1 */
        {8,	0}, 	/* 0x87f2 */
        {8,	0}, 	/* 0x87f3 */
        {8,	0}, 	/* 0x87f4 */
        {8,	0}, 	/* 0x87f5 */
        {8,	0}, 	/* 0x87f6 */
        {8,	0}, 	/* 0x87f7 */
        {8,	0}, 	/* 0x87f8 */
        {8,	0}, 	/* 0x87f9 */
        {8,	0}, 	/* 0x87fa */
        {8,	0}, 	/* 0x87fb */
        {8,	0}, 	/* 0x87fc */
        {8,	0}, 	/* 0x87fd */
        {8,	0}, 	/* 0x87fe */
        {8,	0}, 	/* 0x87ff */
        {8,	0}, 	/* 0x8800 */
        {8,	0}, 	/* 0x8801 */
        {8,	0}, 	/* 0x8802 */
        {8,	0}, 	/* 0x8803 */
        {8,	0}, 	/* 0x8804 */
        {8,	0}, 	/* 0x8805 */
        {8,	0}, 	/* 0x8806 */
        {8,	0}, 	/* 0x8807 */
        {8,	0}, 	/* 0x8808 */
        {8,	0}, 	/* 0x8809 */
        {8,	0}, 	/* 0x880a */
        {8,	0}, 	/* 0x880b */
        {8,	0}, 	/* 0x880c */
        {8,	0}, 	/* 0x880d */
        {8,	0}, 	/* 0x880e */
        {8,	0}, 	/* 0x880f */
        {8,	0}, 	/* 0x8810 */
        {8,	0}, 	/* 0x8811 */
        {8,	0}, 	/* 0x8812 */
        {8,	0}, 	/* 0x8813 */
        {8,	0}, 	/* 0x8814 */
        {8,	0}, 	/* 0x8815 */
        {8,	0}, 	/* 0x8816 */
        {8,	0}, 	/* 0x8817 */
        {8,	0}, 	/* 0x8818 */
        {8,	0}, 	/* 0x8819 */
        {8,	0}, 	/* 0x881a */
        {8,	0}, 	/* 0x881b */
        {8,	0}, 	/* 0x881c */
        {8,	0}, 	/* 0x881d */
        {8,	0}, 	/* 0x881e */
        {8,	0}, 	/* 0x881f */
        {8,	0}, 	/* 0x8820 */
        {8,	0}, 	/* 0x8821 */
        {8,	0}, 	/* 0x8822 */
        {8,	0}, 	/* 0x8823 */
        {8,	0}, 	/* 0x8824 */
        {8,	0}, 	/* 0x8825 */
        {8,	0}, 	/* 0x8826 */
        {8,	0}, 	/* 0x8827 */
        {8,	0}, 	/* 0x8828 */
        {8,	0}, 	/* 0x8829 */
        {8,	0}, 	/* 0x882a */
        {8,	0}, 	/* 0x882b */
        {8,	0}, 	/* 0x882c */
        {8,	0}, 	/* 0x882d */
        {8,	0}, 	/* 0x882e */
        {8,	0}, 	/* 0x882f */
        {8,	0}, 	/* 0x8830 */
        {8,	0}, 	/* 0x8831 */
        {8,	0}, 	/* 0x8832 */
        {8,	0}, 	/* 0x8833 */
        {8,	0}, 	/* 0x8834 */
        {8,	0}, 	/* 0x8835 */
        {8,	0}, 	/* 0x8836 */
        {8,	0}, 	/* 0x8837 */
        {8,	0}, 	/* 0x8838 */
        {8,	0}, 	/* 0x8839 */
        {8,	0}, 	/* 0x883a */
        {8,	0}, 	/* 0x883b */
        {8,	0}, 	/* 0x883c */
        {8,	0}, 	/* 0x883d */
        {8,	0}, 	/* 0x883e */
        {8,	0}, 	/* 0x883f */
        {8,	0}, 	/* 0x8840 */
        {8,	0}, 	/* 0x8841 */
        {8,	0}, 	/* 0x8842 */
        {8,	0}, 	/* 0x8843 */
        {8,	0}, 	/* 0x8844 */
        {8,	0}, 	/* 0x8845 */
        {8,	0}, 	/* 0x8846 */
        {8,	0}, 	/* 0x8847 */
        {8,	0}, 	/* 0x8848 */
        {8,	0}, 	/* 0x8849 */
        {8,	0}, 	/* 0x884a */
        {8,	0}, 	/* 0x884b */
        {8,	0}, 	/* 0x884c */
        {8,	0}, 	/* 0x884d */
        {8,	0}, 	/* 0x884e */
        {8,	0}, 	/* 0x884f */
        {8,	0}, 	/* 0x8850 */
        {8,	0}, 	/* 0x8851 */
        {8,	0}, 	/* 0x8852 */
        {8,	0}, 	/* 0x8853 */
        {8,	0}, 	/* 0x8854 */
        {8,	0}, 	/* 0x8855 */
        {8,	0}, 	/* 0x8856 */
        {8,	0}, 	/* 0x8857 */
        {8,	0}, 	/* 0x8858 */
        {8,	0}, 	/* 0x8859 */
        {8,	0}, 	/* 0x885a */
        {8,	0}, 	/* 0x885b */
        {8,	0}, 	/* 0x885c */
        {8,	0}, 	/* 0x885d */
        {8,	0}, 	/* 0x885e */
        {8,	0}, 	/* 0x885f */
        {8,	0}, 	/* 0x8860 */
        {8,	0}, 	/* 0x8861 */
        {8,	0}, 	/* 0x8862 */
        {8,	0}, 	/* 0x8863 */
        {8,	0}, 	/* 0x8864 */
        {8,	0}, 	/* 0x8865 */
        {8,	0}, 	/* 0x8866 */
        {8,	0}, 	/* 0x8867 */
        {8,	0}, 	/* 0x8868 */
        {8,	0}, 	/* 0x8869 */
        {8,	0}, 	/* 0x886a */
        {8,	0}, 	/* 0x886b */
        {8,	0}, 	/* 0x886c */
        {8,	0}, 	/* 0x886d */
        {8,	0}, 	/* 0x886e */
        {8,	0}, 	/* 0x886f */
        {8,	0}, 	/* 0x8870 */
        {8,	0}, 	/* 0x8871 */
        {8,	0}, 	/* 0x8872 */
        {8,	0}, 	/* 0x8873 */
        {8,	0}, 	/* 0x8874 */
        {8,	0}, 	/* 0x8875 */
        {8,	0}, 	/* 0x8876 */
        {8,	0}, 	/* 0x8877 */
        {8,	0}, 	/* 0x8878 */
        {8,	0}, 	/* 0x8879 */
        {8,	0}, 	/* 0x887a */
        {8,	0}, 	/* 0x887b */
        {8,	0}, 	/* 0x887c */
        {8,	0}, 	/* 0x887d */
        {8,	0}, 	/* 0x887e */
        {8,	0}, 	/* 0x887f */
        {8,	0}, 	/* 0x8880 */
        {8,	0}, 	/* 0x8881 */
        {8,	0}, 	/* 0x8882 */
        {8,	0}, 	/* 0x8883 */
        {8,	0}, 	/* 0x8884 */
        {8,	0}, 	/* 0x8885 */
        {8,	0}, 	/* 0x8886 */
        {8,	0}, 	/* 0x8887 */
        {8,	0}, 	/* 0x8888 */
        {8,	0}, 	/* 0x8889 */
        {8,	0}, 	/* 0x888a */
        {8,	0}, 	/* 0x888b */
        {8,	0}, 	/* 0x888c */
        {8,	0}, 	/* 0x888d */
        {8,	0}, 	/* 0x888e */
        {8,	0}, 	/* 0x888f */
        {8,	0}, 	/* 0x8890 */
        {8,	0}, 	/* 0x8891 */
        {8,	0}, 	/* 0x8892 */
        {8,	0}, 	/* 0x8893 */
        {8,	0}, 	/* 0x8894 */
        {8,	0}, 	/* 0x8895 */
        {8,	0}, 	/* 0x8896 */
        {8,	0}, 	/* 0x8897 */
        {8,	0}, 	/* 0x8898 */
        {8,	0}, 	/* 0x8899 */
        {8,	0}, 	/* 0x889a */
        {8,	0}, 	/* 0x889b */
        {8,	0}, 	/* 0x889c */
        {8,	0}, 	/* 0x889d */
        {8,	0}, 	/* 0x889e */
        {8,	0}, 	/* 0x889f */
        {8,	0}, 	/* 0x88a0 */
        {8,	0}, 	/* 0x88a1 */
        {8,	0}, 	/* 0x88a2 */
        {8,	0}, 	/* 0x88a3 */
        {8,	0}, 	/* 0x88a4 */
        {8,	0}, 	/* 0x88a5 */
        {8,	0}, 	/* 0x88a6 */
        {8,	0}, 	/* 0x88a7 */
        {8,	0}, 	/* 0x88a8 */
        {8,	0}, 	/* 0x88a9 */
        {8,	0}, 	/* 0x88aa */
        {8,	0}, 	/* 0x88ab */
        {8,	0}, 	/* 0x88ac */
        {8,	0}, 	/* 0x88ad */
        {8,	0}, 	/* 0x88ae */
        {8,	0}, 	/* 0x88af */
        {8,	0}, 	/* 0x88b0 */
        {8,	0}, 	/* 0x88b1 */
        {8,	0}, 	/* 0x88b2 */
        {8,	0}, 	/* 0x88b3 */
        {8,	0}, 	/* 0x88b4 */
        {8,	0}, 	/* 0x88b5 */
        {8,	0}, 	/* 0x88b6 */
        {8,	0}, 	/* 0x88b7 */
        {8,	0}, 	/* 0x88b8 */
        {8,	0}, 	/* 0x88b9 */
        {8,	0}, 	/* 0x88ba */
        {8,	0}, 	/* 0x88bb */
        {8,	0}, 	/* 0x88bc */
        {8,	0}, 	/* 0x88bd */
        {8,	0}, 	/* 0x88be */
        {8,	0}, 	/* 0x88bf */
        {8,	0}, 	/* 0x88c0 */
        {8,	0}, 	/* 0x88c1 */
        {8,	0}, 	/* 0x88c2 */
        {8,	0}, 	/* 0x88c3 */
        {8,	0}, 	/* 0x88c4 */
        {8,	0}, 	/* 0x88c5 */
        {8,	0}, 	/* 0x88c6 */
        {8,	0}, 	/* 0x88c7 */
        {8,	0}, 	/* 0x88c8 */
        {8,	0}, 	/* 0x88c9 */
        {8,	0}, 	/* 0x88ca */
        {8,	0}, 	/* 0x88cb */
        {8,	0}, 	/* 0x88cc */
        {8,	0}, 	/* 0x88cd */
        {8,	0}, 	/* 0x88ce */
        {8,	0}, 	/* 0x88cf */
        {8,	0}, 	/* 0x88d0 */
        {8,	0}, 	/* 0x88d1 */
        {8,	0}, 	/* 0x88d2 */
        {8,	0}, 	/* 0x88d3 */
        {8,	0}, 	/* 0x88d4 */
        {8,	0}, 	/* 0x88d5 */
        {8,	0}, 	/* 0x88d6 */
        {8,	0}, 	/* 0x88d7 */
        {8,	0}, 	/* 0x88d8 */
        {8,	0}, 	/* 0x88d9 */
        {8,	0}, 	/* 0x88da */
        {8,	0}, 	/* 0x88db */
        {8,	0}, 	/* 0x88dc */
        {8,	0}, 	/* 0x88dd */
        {8,	0}, 	/* 0x88de */
        {8,	0}, 	/* 0x88df */
        {8,	0}, 	/* 0x88e0 */
        {8,	0}, 	/* 0x88e1 */
        {8,	0}, 	/* 0x88e2 */
        {8,	0}, 	/* 0x88e3 */
        {8,	0}, 	/* 0x88e4 */
        {8,	0}, 	/* 0x88e5 */
        {8,	0}, 	/* 0x88e6 */
        {8,	0}, 	/* 0x88e7 */
        {8,	0}, 	/* 0x88e8 */
        {8,	0}, 	/* 0x88e9 */
        {8,	0}, 	/* 0x88ea */
        {8,	0}, 	/* 0x88eb */
        {8,	0}, 	/* 0x88ec */
        {8,	0}, 	/* 0x88ed */
        {8,	0}, 	/* 0x88ee */
        {8,	0}, 	/* 0x88ef */
        {8,	0}, 	/* 0x88f0 */
        {8,	0}, 	/* 0x88f1 */
        {8,	0}, 	/* 0x88f2 */
        {8,	0}, 	/* 0x88f3 */
        {8,	0}, 	/* 0x88f4 */
        {8,	0}, 	/* 0x88f5 */
        {8,	0}, 	/* 0x88f6 */
        {8,	0}, 	/* 0x88f7 */
        {8,	0}, 	/* 0x88f8 */
        {8,	0}, 	/* 0x88f9 */
        {8,	0}, 	/* 0x88fa */
        {8,	0}, 	/* 0x88fb */
        {8,	0}, 	/* 0x88fc */
        {8,	0}, 	/* 0x88fd */
        {8,	0}, 	/* 0x88fe */
        {8,	0}, 	/* 0x88ff */
        {8,	0}, 	/* 0x8900 */
        {8,	0}, 	/* 0x8901 */
        {8,	0}, 	/* 0x8902 */
        {8,	0}, 	/* 0x8903 */
        {8,	0}, 	/* 0x8904 */
        {8,	0}, 	/* 0x8905 */
        {8,	0}, 	/* 0x8906 */
        {8,	0}, 	/* 0x8907 */
        {8,	0}, 	/* 0x8908 */
        {8,	0}, 	/* 0x8909 */
        {8,	0}, 	/* 0x890a */
        {8,	0}, 	/* 0x890b */
        {8,	0}, 	/* 0x890c */
        {8,	0}, 	/* 0x890d */
        {8,	0}, 	/* 0x890e */
        {8,	0}, 	/* 0x890f */
        {8,	0}, 	/* 0x8910 */
        {8,	0}, 	/* 0x8911 */
        {8,	0}, 	/* 0x8912 */
        {8,	0}, 	/* 0x8913 */
        {8,	0}, 	/* 0x8914 */
        {8,	0}, 	/* 0x8915 */
        {8,	0}, 	/* 0x8916 */
        {8,	0}, 	/* 0x8917 */
        {8,	0}, 	/* 0x8918 */
        {8,	0}, 	/* 0x8919 */
        {8,	0}, 	/* 0x891a */
        {8,	0}, 	/* 0x891b */
        {8,	0}, 	/* 0x891c */
        {8,	0}, 	/* 0x891d */
        {8,	0}, 	/* 0x891e */
        {8,	0}, 	/* 0x891f */
        {8,	0}, 	/* 0x8920 */
        {8,	0}, 	/* 0x8921 */
        {8,	0}, 	/* 0x8922 */
        {8,	0}, 	/* 0x8923 */
        {8,	0}, 	/* 0x8924 */
        {8,	0}, 	/* 0x8925 */
        {8,	0}, 	/* 0x8926 */
        {8,	0}, 	/* 0x8927 */
        {8,	0}, 	/* 0x8928 */
        {8,	0}, 	/* 0x8929 */
        {8,	0}, 	/* 0x892a */
        {8,	0}, 	/* 0x892b */
        {8,	0}, 	/* 0x892c */
        {8,	0}, 	/* 0x892d */
        {8,	0}, 	/* 0x892e */
        {8,	0}, 	/* 0x892f */
        {8,	0}, 	/* 0x8930 */
        {8,	0}, 	/* 0x8931 */
        {8,	0}, 	/* 0x8932 */
        {8,	0}, 	/* 0x8933 */
        {8,	0}, 	/* 0x8934 */
        {8,	0}, 	/* 0x8935 */
        {8,	0}, 	/* 0x8936 */
        {8,	0}, 	/* 0x8937 */
        {8,	0}, 	/* 0x8938 */
        {8,	0}, 	/* 0x8939 */
        {8,	0}, 	/* 0x893a */
        {8,	0}, 	/* 0x893b */
        {8,	0}, 	/* 0x893c */
        {8,	0}, 	/* 0x893d */
        {8,	0}, 	/* 0x893e */
        {8,	0}, 	/* 0x893f */
        {8,	0}, 	/* 0x8940 */
        {8,	0}, 	/* 0x8941 */
        {8,	0}, 	/* 0x8942 */
        {8,	0}, 	/* 0x8943 */
        {8,	0}, 	/* 0x8944 */
        {8,	0}, 	/* 0x8945 */
        {8,	0}, 	/* 0x8946 */
        {8,	0}, 	/* 0x8947 */
        {8,	0}, 	/* 0x8948 */
        {8,	0}, 	/* 0x8949 */
        {8,	0}, 	/* 0x894a */
        {8,	0}, 	/* 0x894b */
        {8,	0}, 	/* 0x894c */
        {8,	0}, 	/* 0x894d */
        {8,	0}, 	/* 0x894e */
        {8,	0}, 	/* 0x894f */
        {8,	0}, 	/* 0x8950 */
        {8,	0}, 	/* 0x8951 */
        {8,	0}, 	/* 0x8952 */
        {8,	0}, 	/* 0x8953 */
        {8,	0}, 	/* 0x8954 */
        {8,	0}, 	/* 0x8955 */
        {8,	0}, 	/* 0x8956 */
        {8,	0}, 	/* 0x8957 */
        {8,	0}, 	/* 0x8958 */
        {8,	0}, 	/* 0x8959 */
        {8,	0}, 	/* 0x895a */
        {8,	0}, 	/* 0x895b */
        {8,	0}, 	/* 0x895c */
        {8,	0}, 	/* 0x895d */
        {8,	0}, 	/* 0x895e */
        {8,	0}, 	/* 0x895f */
        {8,	0}, 	/* 0x8960 */
        {8,	0}, 	/* 0x8961 */
        {8,	0}, 	/* 0x8962 */
        {8,	0}, 	/* 0x8963 */
        {8,	0}, 	/* 0x8964 */
        {8,	0}, 	/* 0x8965 */
        {8,	0}, 	/* 0x8966 */
        {8,	0}, 	/* 0x8967 */
        {8,	0}, 	/* 0x8968 */
        {8,	0}, 	/* 0x8969 */
        {8,	0}, 	/* 0x896a */
        {8,	0}, 	/* 0x896b */
        {8,	0}, 	/* 0x896c */
        {8,	0}, 	/* 0x896d */
        {8,	0}, 	/* 0x896e */
        {8,	0}, 	/* 0x896f */
        {8,	0}, 	/* 0x8970 */
        {8,	0}, 	/* 0x8971 */
        {8,	0}, 	/* 0x8972 */
        {8,	0}, 	/* 0x8973 */
        {8,	0}, 	/* 0x8974 */
        {8,	0}, 	/* 0x8975 */
        {8,	0}, 	/* 0x8976 */
        {8,	0}, 	/* 0x8977 */
        {8,	0}, 	/* 0x8978 */
        {8,	0}, 	/* 0x8979 */
        {8,	0}, 	/* 0x897a */
        {8,	0}, 	/* 0x897b */
        {8,	0}, 	/* 0x897c */
        {8,	0}, 	/* 0x897d */
        {8,	0}, 	/* 0x897e */
        {8,	0}, 	/* 0x897f */
        {8,	0}, 	/* 0x8980 */
        {8,	0}, 	/* 0x8981 */
        {8,	0}, 	/* 0x8982 */
        {8,	0}, 	/* 0x8983 */
        {8,	0}, 	/* 0x8984 */
        {8,	0}, 	/* 0x8985 */
        {8,	0}, 	/* 0x8986 */
        {8,	0}, 	/* 0x8987 */
        {8,	0}, 	/* 0x8988 */
        {8,	0}, 	/* 0x8989 */
        {8,	0}, 	/* 0x898a */
        {8,	0}, 	/* 0x898b */
        {8,	0}, 	/* 0x898c */
        {8,	0}, 	/* 0x898d */
        {8,	0}, 	/* 0x898e */
        {8,	0}, 	/* 0x898f */
        {8,	0}, 	/* 0x8990 */
        {8,	0}, 	/* 0x8991 */
        {8,	0}, 	/* 0x8992 */
        {8,	0}, 	/* 0x8993 */
        {8,	0}, 	/* 0x8994 */
        {8,	0}, 	/* 0x8995 */
        {8,	0}, 	/* 0x8996 */
        {8,	0}, 	/* 0x8997 */
        {8,	0}, 	/* 0x8998 */
        {8,	0}, 	/* 0x8999 */
        {8,	0}, 	/* 0x899a */
        {8,	0}, 	/* 0x899b */
        {8,	0}, 	/* 0x899c */
        {8,	0}, 	/* 0x899d */
        {8,	0}, 	/* 0x899e */
        {8,	0}, 	/* 0x899f */
        {8,	0}, 	/* 0x89a0 */
        {8,	0}, 	/* 0x89a1 */
        {8,	0}, 	/* 0x89a2 */
        {8,	0}, 	/* 0x89a3 */
        {8,	0}, 	/* 0x89a4 */
        {8,	0}, 	/* 0x89a5 */
        {8,	0}, 	/* 0x89a6 */
        {8,	0}, 	/* 0x89a7 */
        {8,	0}, 	/* 0x89a8 */
        {8,	0}, 	/* 0x89a9 */
        {8,	0}, 	/* 0x89aa */
        {8,	0}, 	/* 0x89ab */
        {8,	0}, 	/* 0x89ac */
        {8,	0}, 	/* 0x89ad */
        {8,	0}, 	/* 0x89ae */
        {8,	0}, 	/* 0x89af */
        {8,	0}, 	/* 0x89b0 */
        {8,	0}, 	/* 0x89b1 */
        {8,	0}, 	/* 0x89b2 */
        {8,	0}, 	/* 0x89b3 */
        {8,	0}, 	/* 0x89b4 */
        {8,	0}, 	/* 0x89b5 */
        {8,	0}, 	/* 0x89b6 */
        {8,	0}, 	/* 0x89b7 */
        {8,	0}, 	/* 0x89b8 */
        {8,	0}, 	/* 0x89b9 */
        {8,	0}, 	/* 0x89ba */
        {8,	0}, 	/* 0x89bb */
        {8,	0}, 	/* 0x89bc */
        {8,	0}, 	/* 0x89bd */
        {8,	0}, 	/* 0x89be */
        {8,	0}, 	/* 0x89bf */
        {8,	0}, 	/* 0x89c0 */
        {8,	0}, 	/* 0x89c1 */
        {8,	0}, 	/* 0x89c2 */
        {8,	0}, 	/* 0x89c3 */
        {8,	0}, 	/* 0x89c4 */
        {8,	0}, 	/* 0x89c5 */
        {8,	0}, 	/* 0x89c6 */
        {8,	0}, 	/* 0x89c7 */
        {8,	0}, 	/* 0x89c8 */
        {8,	0}, 	/* 0x89c9 */
        {8,	0}, 	/* 0x89ca */
        {8,	0}, 	/* 0x89cb */
        {8,	0}, 	/* 0x89cc */
        {8,	0}, 	/* 0x89cd */
        {8,	0}, 	/* 0x89ce */
        {8,	0}, 	/* 0x89cf */
        {8,	0}, 	/* 0x89d0 */
        {8,	0}, 	/* 0x89d1 */
        {8,	0}, 	/* 0x89d2 */
        {8,	0}, 	/* 0x89d3 */
        {8,	0}, 	/* 0x89d4 */
        {8,	0}, 	/* 0x89d5 */
        {8,	0}, 	/* 0x89d6 */
        {8,	0}, 	/* 0x89d7 */
        {8,	0}, 	/* 0x89d8 */
        {8,	0}, 	/* 0x89d9 */
        {8,	0}, 	/* 0x89da */
        {8,	0}, 	/* 0x89db */
        {8,	0}, 	/* 0x89dc */
        {8,	0}, 	/* 0x89dd */
        {8,	0}, 	/* 0x89de */
        {8,	0}, 	/* 0x89df */
        {8,	0}, 	/* 0x89e0 */
        {8,	0}, 	/* 0x89e1 */
        {8,	0}, 	/* 0x89e2 */
        {8,	0}, 	/* 0x89e3 */
        {8,	0}, 	/* 0x89e4 */
        {8,	0}, 	/* 0x89e5 */
        {8,	0}, 	/* 0x89e6 */
        {8,	0}, 	/* 0x89e7 */
        {8,	0}, 	/* 0x89e8 */
        {8,	0}, 	/* 0x89e9 */
        {8,	0}, 	/* 0x89ea */
        {8,	0}, 	/* 0x89eb */
        {8,	0}, 	/* 0x89ec */
        {8,	0}, 	/* 0x89ed */
        {8,	0}, 	/* 0x89ee */
        {8,	0}, 	/* 0x89ef */
        {8,	0}, 	/* 0x89f0 */
        {8,	0}, 	/* 0x89f1 */
        {8,	0}, 	/* 0x89f2 */
        {8,	0}, 	/* 0x89f3 */
        {8,	0}, 	/* 0x89f4 */
        {8,	0}, 	/* 0x89f5 */
        {8,	0}, 	/* 0x89f6 */
        {8,	0}, 	/* 0x89f7 */
        {8,	0}, 	/* 0x89f8 */
        {8,	0}, 	/* 0x89f9 */
        {8,	0}, 	/* 0x89fa */
        {8,	0}, 	/* 0x89fb */
        {8,	0}, 	/* 0x89fc */
        {8,	0}, 	/* 0x89fd */
        {8,	0}, 	/* 0x89fe */
        {8,	0}, 	/* 0x89ff */
        {8,	0}, 	/* 0x8a00 */
        {8,	0}, 	/* 0x8a01 */
        {8,	0}, 	/* 0x8a02 */
        {8,	0}, 	/* 0x8a03 */
        {8,	0}, 	/* 0x8a04 */
        {8,	0}, 	/* 0x8a05 */
        {8,	0}, 	/* 0x8a06 */
        {8,	0}, 	/* 0x8a07 */
        {8,	0}, 	/* 0x8a08 */
        {8,	0}, 	/* 0x8a09 */
        {8,	0}, 	/* 0x8a0a */
        {8,	0}, 	/* 0x8a0b */
        {8,	0}, 	/* 0x8a0c */
        {8,	0}, 	/* 0x8a0d */
        {8,	0}, 	/* 0x8a0e */
        {8,	0}, 	/* 0x8a0f */
        {8,	0}, 	/* 0x8a10 */
        {8,	0}, 	/* 0x8a11 */
        {8,	0}, 	/* 0x8a12 */
        {8,	0}, 	/* 0x8a13 */
        {8,	0}, 	/* 0x8a14 */
        {8,	0}, 	/* 0x8a15 */
        {8,	0}, 	/* 0x8a16 */
        {8,	0}, 	/* 0x8a17 */
        {8,	0}, 	/* 0x8a18 */
        {8,	0}, 	/* 0x8a19 */
        {8,	0}, 	/* 0x8a1a */
        {8,	0}, 	/* 0x8a1b */
        {8,	0}, 	/* 0x8a1c */
        {8,	0}, 	/* 0x8a1d */
        {8,	0}, 	/* 0x8a1e */
        {8,	0}, 	/* 0x8a1f */
        {8,	0}, 	/* 0x8a20 */
        {8,	0}, 	/* 0x8a21 */
        {8,	0}, 	/* 0x8a22 */
        {8,	0}, 	/* 0x8a23 */
        {8,	0}, 	/* 0x8a24 */
        {8,	0}, 	/* 0x8a25 */
        {8,	0}, 	/* 0x8a26 */
        {8,	0}, 	/* 0x8a27 */
        {8,	0}, 	/* 0x8a28 */
        {8,	0}, 	/* 0x8a29 */
        {8,	0}, 	/* 0x8a2a */
        {8,	0}, 	/* 0x8a2b */
        {8,	0}, 	/* 0x8a2c */
        {8,	0}, 	/* 0x8a2d */
        {8,	0}, 	/* 0x8a2e */
        {8,	0}, 	/* 0x8a2f */
        {8,	0}, 	/* 0x8a30 */
        {8,	0}, 	/* 0x8a31 */
        {8,	0}, 	/* 0x8a32 */
        {8,	0}, 	/* 0x8a33 */
        {8,	0}, 	/* 0x8a34 */
        {8,	0}, 	/* 0x8a35 */
        {8,	0}, 	/* 0x8a36 */
        {8,	0}, 	/* 0x8a37 */
        {8,	0}, 	/* 0x8a38 */
        {8,	0}, 	/* 0x8a39 */
        {8,	0}, 	/* 0x8a3a */
        {8,	0}, 	/* 0x8a3b */
        {8,	0}, 	/* 0x8a3c */
        {8,	0}, 	/* 0x8a3d */
        {8,	0}, 	/* 0x8a3e */
        {8,	0}, 	/* 0x8a3f */
        {8,	0}, 	/* 0x8a40 */
        {8,	0}, 	/* 0x8a41 */
        {8,	0}, 	/* 0x8a42 */
        {8,	0}, 	/* 0x8a43 */
        {8,	0}, 	/* 0x8a44 */
        {8,	0}, 	/* 0x8a45 */
        {8,	0}, 	/* 0x8a46 */
        {8,	0}, 	/* 0x8a47 */
        {8,	0}, 	/* 0x8a48 */
        {8,	0}, 	/* 0x8a49 */
        {8,	0}, 	/* 0x8a4a */
        {8,	0}, 	/* 0x8a4b */
        {8,	0}, 	/* 0x8a4c */
        {8,	0}, 	/* 0x8a4d */
        {8,	0}, 	/* 0x8a4e */
        {8,	0}, 	/* 0x8a4f */
        {8,	0}, 	/* 0x8a50 */
        {8,	0}, 	/* 0x8a51 */
        {8,	0}, 	/* 0x8a52 */
        {8,	0}, 	/* 0x8a53 */
        {8,	0}, 	/* 0x8a54 */
        {8,	0}, 	/* 0x8a55 */
        {8,	0}, 	/* 0x8a56 */
        {8,	0}, 	/* 0x8a57 */
        {8,	0}, 	/* 0x8a58 */
        {8,	0}, 	/* 0x8a59 */
        {8,	0}, 	/* 0x8a5a */
        {8,	0}, 	/* 0x8a5b */
        {8,	0}, 	/* 0x8a5c */
        {8,	0}, 	/* 0x8a5d */
        {8,	0}, 	/* 0x8a5e */
        {8,	0}, 	/* 0x8a5f */
        {8,	0}, 	/* 0x8a60 */
        {8,	0}, 	/* 0x8a61 */
        {8,	0}, 	/* 0x8a62 */
        {8,	0}, 	/* 0x8a63 */
        {8,	0}, 	/* 0x8a64 */
        {8,	0}, 	/* 0x8a65 */
        {8,	0}, 	/* 0x8a66 */
        {8,	0}, 	/* 0x8a67 */
        {8,	0}, 	/* 0x8a68 */
        {8,	0}, 	/* 0x8a69 */
        {8,	0}, 	/* 0x8a6a */
        {8,	0}, 	/* 0x8a6b */
        {8,	0}, 	/* 0x8a6c */
        {8,	0}, 	/* 0x8a6d */
        {8,	0}, 	/* 0x8a6e */
        {8,	0}, 	/* 0x8a6f */
        {8,	0}, 	/* 0x8a70 */
        {8,	0}, 	/* 0x8a71 */
        {8,	0}, 	/* 0x8a72 */
        {8,	0}, 	/* 0x8a73 */
        {8,	0}, 	/* 0x8a74 */
        {8,	0}, 	/* 0x8a75 */
        {8,	0}, 	/* 0x8a76 */
        {8,	0}, 	/* 0x8a77 */
        {8,	0}, 	/* 0x8a78 */
        {8,	0}, 	/* 0x8a79 */
        {8,	0}, 	/* 0x8a7a */
        {8,	0}, 	/* 0x8a7b */
        {8,	0}, 	/* 0x8a7c */
        {8,	0}, 	/* 0x8a7d */
        {8,	0}, 	/* 0x8a7e */
        {8,	0}, 	/* 0x8a7f */
        {8,	0}, 	/* 0x8a80 */
        {8,	0}, 	/* 0x8a81 */
        {8,	0}, 	/* 0x8a82 */
        {8,	0}, 	/* 0x8a83 */
        {8,	0}, 	/* 0x8a84 */
        {8,	0}, 	/* 0x8a85 */
        {8,	0}, 	/* 0x8a86 */
        {8,	0}, 	/* 0x8a87 */
        {8,	0}, 	/* 0x8a88 */
        {8,	0}, 	/* 0x8a89 */
        {8,	0}, 	/* 0x8a8a */
        {8,	0}, 	/* 0x8a8b */
        {8,	0}, 	/* 0x8a8c */
        {8,	0}, 	/* 0x8a8d */
        {8,	0}, 	/* 0x8a8e */
        {8,	0}, 	/* 0x8a8f */
        {8,	0}, 	/* 0x8a90 */
        {8,	0}, 	/* 0x8a91 */
        {8,	0}, 	/* 0x8a92 */
        {8,	0}, 	/* 0x8a93 */
        {8,	0}, 	/* 0x8a94 */
        {8,	0}, 	/* 0x8a95 */
        {8,	0}, 	/* 0x8a96 */
        {8,	0}, 	/* 0x8a97 */
        {8,	0}, 	/* 0x8a98 */
        {8,	0}, 	/* 0x8a99 */
        {8,	0}, 	/* 0x8a9a */
        {8,	0}, 	/* 0x8a9b */
        {8,	0}, 	/* 0x8a9c */
        {8,	0}, 	/* 0x8a9d */
        {8,	0}, 	/* 0x8a9e */
        {8,	0}, 	/* 0x8a9f */
        {8,	0}, 	/* 0x8aa0 */
        {8,	0}, 	/* 0x8aa1 */
        {8,	0}, 	/* 0x8aa2 */
        {8,	0}, 	/* 0x8aa3 */
        {8,	0}, 	/* 0x8aa4 */
        {8,	0}, 	/* 0x8aa5 */
        {8,	0}, 	/* 0x8aa6 */
        {8,	0}, 	/* 0x8aa7 */
        {8,	0}, 	/* 0x8aa8 */
        {8,	0}, 	/* 0x8aa9 */
        {8,	0}, 	/* 0x8aaa */
        {8,	0}, 	/* 0x8aab */
        {8,	0}, 	/* 0x8aac */
        {8,	0}, 	/* 0x8aad */
        {8,	0}, 	/* 0x8aae */
        {8,	0}, 	/* 0x8aaf */
        {8,	0}, 	/* 0x8ab0 */
        {8,	0}, 	/* 0x8ab1 */
        {8,	0}, 	/* 0x8ab2 */
        {8,	0}, 	/* 0x8ab3 */
        {8,	0}, 	/* 0x8ab4 */
        {8,	0}, 	/* 0x8ab5 */
        {8,	0}, 	/* 0x8ab6 */
        {8,	0}, 	/* 0x8ab7 */
        {8,	0}, 	/* 0x8ab8 */
        {8,	0}, 	/* 0x8ab9 */
        {8,	0}, 	/* 0x8aba */
        {8,	0}, 	/* 0x8abb */
        {8,	0}, 	/* 0x8abc */
        {8,	0}, 	/* 0x8abd */
        {8,	0}, 	/* 0x8abe */
        {8,	0}, 	/* 0x8abf */
        {8,	0}, 	/* 0x8ac0 */
        {8,	0}, 	/* 0x8ac1 */
        {8,	0}, 	/* 0x8ac2 */
        {8,	0}, 	/* 0x8ac3 */
        {8,	0}, 	/* 0x8ac4 */
        {8,	0}, 	/* 0x8ac5 */
        {8,	0}, 	/* 0x8ac6 */
        {8,	0}, 	/* 0x8ac7 */
        {8,	0}, 	/* 0x8ac8 */
        {8,	0}, 	/* 0x8ac9 */
        {8,	0}, 	/* 0x8aca */
        {8,	0}, 	/* 0x8acb */
        {8,	0}, 	/* 0x8acc */
        {8,	0}, 	/* 0x8acd */
        {8,	0}, 	/* 0x8ace */
        {8,	0}, 	/* 0x8acf */
        {8,	0}, 	/* 0x8ad0 */
        {8,	0}, 	/* 0x8ad1 */
        {8,	0}, 	/* 0x8ad2 */
        {8,	0}, 	/* 0x8ad3 */
        {8,	0}, 	/* 0x8ad4 */
        {8,	0}, 	/* 0x8ad5 */
        {8,	0}, 	/* 0x8ad6 */
        {8,	0}, 	/* 0x8ad7 */
        {8,	0}, 	/* 0x8ad8 */
        {8,	0}, 	/* 0x8ad9 */
        {8,	0}, 	/* 0x8ada */
        {8,	0}, 	/* 0x8adb */
        {8,	0}, 	/* 0x8adc */
        {8,	0}, 	/* 0x8add */
        {8,	0}, 	/* 0x8ade */
        {8,	0}, 	/* 0x8adf */
        {8,	0}, 	/* 0x8ae0 */
        {8,	0}, 	/* 0x8ae1 */
        {8,	0}, 	/* 0x8ae2 */
        {8,	0}, 	/* 0x8ae3 */
        {8,	0}, 	/* 0x8ae4 */
        {8,	0}, 	/* 0x8ae5 */
        {8,	0}, 	/* 0x8ae6 */
        {8,	0}, 	/* 0x8ae7 */
        {8,	0}, 	/* 0x8ae8 */
        {8,	0}, 	/* 0x8ae9 */
        {8,	0}, 	/* 0x8aea */
        {8,	0}, 	/* 0x8aeb */
        {8,	0}, 	/* 0x8aec */
        {8,	0}, 	/* 0x8aed */
        {8,	0}, 	/* 0x8aee */
        {8,	0}, 	/* 0x8aef */
        {8,	0}, 	/* 0x8af0 */
        {8,	0}, 	/* 0x8af1 */
        {8,	0}, 	/* 0x8af2 */
        {8,	0}, 	/* 0x8af3 */
        {8,	0}, 	/* 0x8af4 */
        {8,	0}, 	/* 0x8af5 */
        {8,	0}, 	/* 0x8af6 */
        {8,	0}, 	/* 0x8af7 */
        {8,	0}, 	/* 0x8af8 */
        {8,	0}, 	/* 0x8af9 */
        {8,	0}, 	/* 0x8afa */
        {8,	0}, 	/* 0x8afb */
        {8,	0}, 	/* 0x8afc */
        {8,	0}, 	/* 0x8afd */
        {8,	0}, 	/* 0x8afe */
        {8,	0}, 	/* 0x8aff */
        {8,	0}, 	/* 0x8b00 */
        {8,	0}, 	/* 0x8b01 */
        {8,	0}, 	/* 0x8b02 */
        {8,	0}, 	/* 0x8b03 */
        {8,	0}, 	/* 0x8b04 */
        {8,	0}, 	/* 0x8b05 */
        {8,	0}, 	/* 0x8b06 */
        {8,	0}, 	/* 0x8b07 */
        {8,	0}, 	/* 0x8b08 */
        {8,	0}, 	/* 0x8b09 */
        {8,	0}, 	/* 0x8b0a */
        {8,	0}, 	/* 0x8b0b */
        {8,	0}, 	/* 0x8b0c */
        {8,	0}, 	/* 0x8b0d */
        {8,	0}, 	/* 0x8b0e */
        {8,	0}, 	/* 0x8b0f