;;  Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>
;;
;;  This file is part of Upmf.
;;
;;  Upmf is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Upmf is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with Upmf.  If not, see <http://www.gnu.org/licenses/>.

;; TODO in bootstrap mode: only get 'bootstrap-options if package-obj
;; contains a 'bootstrap-options entry.
(define autotools-install
  (lambda* (package-obj archive-dir dest-dir)
    (let* ((settings (if (eq? (assq-ref package-obj 'autotools-settings) #f)
			 '()
			 (assq-ref package-obj 'autotools-settings)))
	   (build-dir (if (eq? (member 'dedicate-directory settings) #f)
			  archive-dir
			  (string-append archive-dir "/../build")))
	   
	   ;; Compose the string called to run the configure script
	   (confstring (string-append "cd " build-dir "; "
				      "LDFLAGS=\"" ldflags "\" "
				      "CFLAGS=\"" cflags "\" "
				      archive-dir "/configure "
				      (if (eq? bootstrap-mode #f)
					  ;; Normal mode:
					  (string-append
					   "--prefix=" package-prefix " "
					   (eval (assq-ref package-obj 'options)
						 (interaction-environment)))
					  ;; Bootstrap mode:
					  (string-append
					   "--prefix=" bootstrap-prefix " "
					   (if (eq? (assq-ref package-obj 'bootstrap-options)
						    #f)
					       ""
					       (eval (assq-ref package-obj 'bootstrap-options)
						     (interaction-environment))))))))
      (display bootstrap-mode)(newline)
      (if (not (string=? archive-dir build-dir))
          (exec (string-append "mkdir -v " build-dir)))
      (statusmsg (_ "Configuring directory") archive-dir)
      (statusmsg (_ "Calling ./configure with") confstring)
      (if (exec confstring)
	  (statusmsg (_ "Directory configured") archive-dir)
	  (errormsg (_ "Failed to configure directory") archive-dir 'fatal))
      (if (exec (string-append "cd " build-dir "; "
			       "make " make-options))
	  (statusmsg (_ "\"make\" exited successfully"))
	  (errormsg (_ "\"make\" exited abnormally in directory")
		    archive-dir 'fatal))
      (if (exec (string-append "cd " build-dir "; make DESTDIR=\""
			       dest-dir "\" install"))
	  (begin (statusmsg (_ "\"make install\" exited successfully"))
		 (string-append (assq-ref package-obj 'section) "/"
				(assq-ref package-obj 'name)))
	  (errormsg (_ "\"make install\" exited abnormally in directory")
		    archive-dir 'fatal))
      #t)))

