/* Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>

   This file is part of Upmf.

   Upmf is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   Upmf is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with Upmf.  If not, see <http://www.gnu.org/licenses/>. */

#include "version-comp.h"

void
init_version_functions ()
{
  scm_c_define_gsubr ("make-version-c", 1, 0, 0, upmf_make_version);
  scm_c_define_gsubr ("compare-version-c", 2, 0, 0, upmf_compare_version);
}

SCM
upmf_make_version (SCM string)
{
  /* SCM is not used here because string->list functions only take
     one character as a delimiter */
  char *token;
  char *version_str;
  SCM vlist;

  version_str = scm_to_locale_string (string);
  token = strtok (version_str, ".-_");
  vlist = scm_list_1 (scm_from_locale_string (token));
  
  while ((token = strtok (NULL, ".-_")) != NULL)
    {
      vlist = scm_append_x (scm_list_2
			    (vlist,
			     scm_list_1 (scm_from_locale_string (token))));
    }

  free (token);
  free (version_str);
  return vlist;
}

/* Return -1 if version list vr is lower than version list vl.
   Return 1 if version list vr is higher than version list vl.
   Return 0 if they are equal. */
SCM
upmf_compare_version (SCM vl, SCM vr)
{
  for (int pos = 0; pos < scm_to_int (scm_length (vl)); pos++)
    {
      /* If second version is longer than version but equal until the
	 end of the first version, the second version is higher */
      if (pos + 1 == scm_to_int (scm_length (vl)) &&
	  scm_to_int (scm_length (vr)) > scm_to_int (scm_length (vl)))
	return scm_from_int (1);

      if (pos + 1 == scm_to_int (scm_length (vr)) &&
	  scm_to_int (scm_length (vl)) > scm_to_int (scm_length (vr)))
	return scm_from_int (-1); 

      if (scm_to_int (scm_string_to_number
		      (scm_list_ref (vr, scm_from_int (pos)),
		       scm_from_int (10))) <
	  scm_to_int (scm_string_to_number
		      (scm_list_ref (vl, scm_from_int (pos)),
		       scm_from_int (10))))
	return scm_from_int (-1);

      if (scm_to_int (scm_string_to_number
		      (scm_list_ref (vr, scm_from_int (pos)),
		       scm_from_int (10)))>
	  scm_to_int (scm_string_to_number
		      (scm_list_ref (vl, scm_from_int (pos)),
		       scm_from_int (10))))
	return scm_from_int (1);
    }
   
  return scm_from_int (0);
}
