;;  Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>
;;
;;  This file is part of Upmf.
;;
;;  Upmf is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Upmf is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with Upmf.  If not, see <http://www.gnu.org/licenses/>.

(define apply-patches
  (lambda (directory patchlist for-version)
    (let ((cur-patch #f))
      (if (eq? patchlist #f)
	  (statusmsg (_ "No patches for this package"))
	  (begin
	    (do ((k 0 (1+ k)))
		((> k (- (length patchlist) 1)))
	      (set! cur-patch (list-ref patchlist k))
	      (if (eq? (list-ref cur-patch 0) #f)
		  (statusmsg (_ "No patches for this package"))
		  (if (member for-version (assq-ref cur-patch 'for-version))
		      (patch directory (assq-ref cur-patch 'name))))))))))
