;;  Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>
;;
;;  This file is part of Upmf.
;;
;;  Upmf is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  Upmf is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with Upmf.  If not, see <http://www.gnu.org/licenses/>.

(load "default.scm")
(load "default-values.scm")

;; I18n
(textdomain "upmf")
(setlocale LC_ALL "")

;; Determine the user startup file
(define startup-file (getenv "XDG_CONFIG_HOME"))
(if (eq? startup-file #f)
    (set! startup-file (string-append (getenv "HOME") "/.config/upmf.scm"))
    (set! startup-file (string-append startup-file "/upmf.scm")))

;; Load the user startup file after the default library, so that
;; the user can override the default variables
(if (access? startup-file R_OK)
    (load startup-file)
    (begin (display "User startup file not found, aborting\n")(quit)))

;; Any custom mode should bind its main procedure to this variable
(upmf-start)
