/* Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>

   This file is part of Upmf.

   Upmf is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   Upmf is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with Upmf.  If not, see <http://www.gnu.org/licenses/>. */

#include "version-comp.h"

void
init_version_functions ()
{
  scm_c_define_gsubr ("make-version", 1, 0, 0, upmf_make_version);
  scm_c_define_gsubr ("compare-version", 2, 0, 0, upmf_compare_version);
}

SCM
upmf_make_version (SCM string)
{
  /* SCM is not used here because string->list functions only take
     one character as a delimiter */
  char *token;
  char *version_str;
  SCM vlist;

  version_str = scm_to_locale_string (string);
  token = strtok (version_str, ".-_");
  vlist = scm_list_1 (scm_from_locale_string (token));
  
  while ((token = strtok (NULL, ".-_")) != NULL)
    {
      vlist = scm_append_x (scm_list_2
			    (vlist,
			     scm_list_1 (scm_from_locale_string (token))));
    }

  free (token);
  free (version_str);
  return vlist;
}

SCM
upmf_compare_version (SCM vl, SCM vr)
{
  return SCM_UNDEFINED;
}
