/* Copyright (C) 2013 Aljosha Papsch <misc@rpapsch.de>

   This file is part of Upmf.

   Upmf is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   Upmf is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with Upmf.  If not, see <http://www.gnu.org/licenses/>. */

#include "package.h"

void
init_package_type ()
{
  package_tag = scm_make_smob_type ("package", sizeof (struct upmf_package));
  scm_set_smob_mark (package_tag, mark_package);
  /*scm_set_smob_print (package_tag, print_package);*/

  scm_c_define_gsubr ("make-package", 4, 0, 0, make_package);
}

SCM
make_package (SCM name, SCM section, SCM description, SCM license,
	      SCM release_list)
{
  SCM smob;
  struct upmf_package *pkg;
  
  pkg = (struct upmf_package*) scm_gc_malloc
    (sizeof (struct upmf_package), "package");

  pkg->name = SCM_BOOL_F;
  pkg->section = SCM_BOOL_F;
  pkg->description = SCM_BOOL_F;
  pkg->license = SCM_BOOL_F;
  pkg->release_list = SCM_BOOL_F;

  SCM_NEWSMOB (smob, package_tag, pkg);

  pkg->name = name;
  pkg->section = section;
  pkg->description = description;
  pkg->license = license;
  pkg->release_list = release_list;

  return smob;
}

static SCM
mark_package (SCM package)
{
  struct upmf_package *pkg = (struct upmf_package*)
    SCM_SMOB_DATA (package);

  scm_gc_mark (pkg->name);
  scm_gc_mark (pkg->section);
  scm_gc_mark (pkg->description);
  scm_gc_mark (pkg->license);
  return pkg->release_list;
}

/*
static int
print_package (SCM package, SCM port, scm_print_state *pstate)
{
  struct upmf_package *pkg = (struct upmf_package*)
    SCM_SMOB_DATA (package);

  scm_puts ("#<package ", port);
  scm_display (pkg->section, port);
  scm_puts ("/", port);
  scm_display (pkg->name, port);
  scm_puts ("\n", port);
  scm_display (pkg->description, port);
  scm_puts ("\n", port);
  scm_display (pkg->license, port);
  scm_puts (">\n", port);

  return 1;
}
*/
