
-- color pattern: columns, lines diags of n squares with same colors ---------


function color_match_vertical(min_size)
    local i
    local x
    local y
    local size
    local found_size
    local found_x
    local found_y
    local last_color
    local found_color

    found_size=0
    x=u61_get_width()-1
    while x>=0 and found_size<min_size do
        size=1
        last_color=-1
        y=u61_get_height()-1
        while y>=0 do
            found_color=u61_get_square_color(x,y)
            if found_color>=0 and found_color==last_color then
                size=size+1
                if size>found_size then
                    found_size=size
                    found_x=x
                    found_y=y
                end
            else
                size=1
            end
            last_color=found_color
            y=y-1
        end
        x=x-1
    end

    if found_size>=min_size then
        i=found_size-1
        while i>=0 do
            u61_blow_up_square(found_x,found_y+i)
            i=i-1
        end
    end 
    
    return found_size 
end

function color_match_horizontal(min_size)
    local i
    local x
    local y
    local size
    local found_size
    local found_x
    local found_y
    local last_color
    local found_color

    found_size=0
    y=u61_get_height()-1
    while y>=0 and found_size<min_size do
        size=1
        last_color=-1
        x=u61_get_width()-1
        while x>=0 do
            found_color=u61_get_square_color(x,y)
            if found_color>=0 and found_color==last_color then
                size=size+1
                if size>found_size then
                    found_size=size
                    found_x=x
                    found_y=y
                end
            else
                size=1
            end
            last_color=found_color
            x=x-1
        end
        y=y-1
    end

    if found_size>=min_size then
        i=found_size-1
        while i>=0 do
            u61_blow_up_square(found_x+i,found_y)
            i=i-1
        end
    end 
    
    return found_size 
end

function color_match_diagonal1(min_size)
    local i
    local x
    local y
    local size
    local found_size
    local found_x
    local found_y
    local last_color
    local found_color

    found_size=0
    y=u61_get_height()+u61_get_width()-1
    while y>=0 and found_size<min_size do
        size=1
        last_color=-1
        x=u61_get_width()-1
        while x>=0 do
            found_color=u61_get_square_color(x,y-x)
            if found_color>=0 and found_color==last_color then
                size=size+1
                if size>found_size then
                    found_size=size
                    found_x=x
                    found_y=y-x
                end
            else
                size=1
            end
            last_color=found_color
            x=x-1
        end
        y=y-1
    end

    if found_size>=min_size then
        i=found_size-1
        while i>=0 do
            u61_blow_up_square(found_x+i,found_y-i)
            i=i-1
        end
    end 
    
    return found_size 
end

function color_match_diagonal2(min_size)
    local i
    local x
    local y
    local size
    local found_size
    local found_x
    local found_y
    local last_color
    local found_color

    found_size=0
    y=u61_get_height()-1
    while y>=-u61_get_width() and found_size<min_size do
        size=1
        last_color=-1
        x=u61_get_width()-1
        while x>=0 do
            found_color=u61_get_square_color(x,y+x)
            if found_color>=0 and found_color==last_color then
                size=size+1
                if size>found_size then
                    found_size=size
                    found_x=x
                    found_y=y+x
                end
            else
                size=1
            end
            last_color=found_color
            x=x-1
        end
        y=y-1
    end

    if found_size>=min_size then
        i=found_size-1
        while i>=0 do
            u61_blow_up_square(found_x+i,found_y+i)
            i=i-1
        end
    end 
    
    return found_size 
end

function color_match_pattern(match_count,min_size)
    local nb_found
    local found
    
    nb_found=0
    found=0

    if (nb_found<min_size) then
        nb_found=color_match_vertical(min_size)
    end
    if (nb_found<min_size) then
        nb_found=color_match_horizontal(min_size)
    end
    if (nb_found<min_size) then
        nb_found=color_match_diagonal1(min_size)
    end
    if (nb_found<min_size) then
        nb_found=color_match_diagonal2(min_size)
    end

    if nb_found>=min_size then
        u61_add_score((match_count+1)*10
            *(nb_found-min_size+3)
            *(nb_found-min_size+3))
        found=1
    end

    return found
end

