------------------------------------------------------------------------------
--                                                                          --
-- U U    6   1            U U   FFF  O   O  TTT                            --
-- U U   6   11   b        U U   F   O O O O  T                             --
-- U U - 66   1   bb  y y  U U - FF  O O O O  T                             --
-- U U   6 6  1   b b  y   U U   F   O O O O  T                             --
--  U     6   1   bb   y    U    F    O   O   T                             --
--                                                                          --
-- U61 is another block based game                                          --
-- Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   --
--                                                                          --
-- This program is free software; you can redistribute it and/or            --
-- modify it under the terms of the GNU General Public License              --
-- as published by the Free Software Foundation; either version 2           --
-- of the License, or (at your option) any later version.                   --
--                                                                          --
-- This program is distributed in the hope that it will be useful,          --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of           --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            --
-- GNU General Public License for more details.                             --
--                                                                          --
-- You should have received a copy of the GNU General Public License        --
-- along with this program; if not, write to the Free Software              --
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA--
--                                                                          --
-- This project is also available on SourceForge  (http://sourceforge.net)  --
------------------------------------------------------------------------------

-- tetramino game, the goal is to have an horizontal line filled with
-- squares of any color. possible movements include translation & rotation
-- colors do not have any purpose except make the game look nicer


-- shape definition ----------------------------------------------------------

function user_new_shape(num)
    num=mod(num,100)

    return num
end

function user_do_shape(num)
    if num>=80 then
        tetramino_bar()
    elseif num>=70 then
        tetramino_square()
    elseif num>=60 then
        tetramino_pyramid()
    elseif num>=45 then
        tetramino_s1()
    elseif num>=30 then
        tetramino_s2()
    elseif num>=15 then
        tetramino_l1()
    else
        tetramino_l2()
    end

    fiftytwo_do_shape(num)
end


-- actions -------------------------------------------------------------------

function user_rotate_left()
    rotation_left()    
end

function user_rotate_right()
    rotation_right()    
end

function user_move_left()
    goofy_left()
end

function user_move_right()
    goofy_right()
end

function user_move_down()
    translation_y(1)
end

function user_use_antidote()
    u61_cancel_curse(u61_get_oldest_curse())
end

-- pattern match -------------------------------------------------------------

function user_match_pattern(match_count)
    local matched

    matched=line_match_pattern(match_count)

    if matched>0 and match_count>=2 then
        u61_send_curse(ID_CURSE_HOLEDLINE)
    end

    return matched
end

function user_land()

end

function user_square_blown_up(x,y)
    utils_shift_column_down(x,y)
end

-- curse functions  ----------------------------------------------------------

function user_new_curse(num)
    num=mod(num,100)

    if num<10 then
        num=ID_CURSE_ANTIDOTE
    elseif num<70 then
        num=ID_CURSE_HOLEDLINE
    elseif num<75 then
        num=ID_CURSE_GOOFY
    elseif num<80 then
        num=ID_CURSE_CLEAR
    elseif num<85 then 
        num=ID_CURSE_SHUFFLE
    elseif num<90 then 
        num=ID_CURSE_WIND
    elseif num<95 then 
        num=ID_CURSE_FIFTYTWO
    elseif num<100 then 
        num=ID_CURSE_BIGX
    end

    return num
end

function user_do_curse(num,sent)
    if (num==ID_CURSE_ANTIDOTE) then
        antidote_do_curse()
    elseif (num==ID_CURSE_HOLEDLINE) then
        holedline_do_curse(sent)
    elseif (num==ID_CURSE_GOOFY) then
        goofy_do_curse(sent)
    elseif (num==ID_CURSE_CLEAR) then
        clear_do_curse()
    elseif (num==ID_CURSE_SHUFFLE) then
        shuffle_do_curse(sent)
    elseif (num==ID_CURSE_WIND) then
        wind_do_curse(sent)
    elseif (num==ID_CURSE_FIFTYTWO) then
        fiftytwo_do_curse(sent)
    elseif (num==ID_CURSE_BIGX) then
        bigx_do_curse(sent)
    end    
end

function user_get_curse_name(num)
    name="surprise"

    if (num==ID_CURSE_ANTIDOTE) then
        name="antidote"
    elseif (num==ID_CURSE_HOLEDLINE) then
        name="line"
    elseif (num==ID_CURSE_GOOFY) then
        name="goofy"
    elseif (num==ID_CURSE_CLEAR) then
        name="clear"
    elseif (num==ID_CURSE_SHUFFLE) then
        name="shuffle"
    elseif (num==ID_CURSE_WIND) then
        name="wind"
    elseif (num==ID_CURSE_FIFTYTWO) then
        name="52"
    elseif (num==ID_CURSE_BIGX) then
        name="X"
    end

    return name
end 

-- other functions -----------------------------------------------------------

function user_time_callback()
    u61_add_score(10)
    shuffle_time_callback()
    wind_time_callback()
end

