/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   menuitem.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: abstract class, parent of all menu items
 *              fondamentaly, a menu item is a line in a menu
 *              this line is made of letters, stored in a array
 *              the menu item will basically handle key presses
 *              and modify
 *              - its display
 *              - some parameter in the config object
 *              special events may open another menu or go back
 *              of course the class provides a "draw" function
 *              and automatically centers itself
 */

#ifndef INC_U61_MENUITEM
#define INC_U61_MENUITEM

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "letter.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_MenuItem
{
 public:
  U61_MenuItem();
  U61_MenuItem(char *str);
  virtual ~U61_MenuItem();

  virtual bool action(int key);
  virtual void update();
  void draw(int y);
  int get_width();
  int get_height();
  void set_text(char *str);
  void put_text(char *buf);

  void select_char(int i);
  void select_right(int start);
  void blink_char(int i);
  virtual void select();
  virtual void unselect();
  virtual bool is_modal();

  bool is_mouse_in(int y);
 protected:
  vector<U61_Letter> text;    
  bool selected;
  static char *const SEPARATOR=" : ";
  int mouse_up_limit;
  int mouse_down_limit;
};

#endif
