/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   keydef.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: A keydef is usefull to identify a key, that's to
 *              say make the link between a system code, an ascii code
 *              and a label. It also contains a "state" field which
 *              is used by the global input monitor to know wether it
 *              is pressed or not.
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "keydef.h"

/*---------------------------------------------------------------------------
 methods
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a default keydef
 */ 
U61_KeyDef::U61_KeyDef()
{
  define(' ',"unknown");
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of a keydef
 */ 
U61_KeyDef::~U61_KeyDef()
{
}

/*--------------------------------------------------------------------------*/
/* 
 * resets the state of a keydef
 */ 
void U61_KeyDef::reset()
{
  key_state=false;
  key_flag=false;
}

/*--------------------------------------------------------------------------*/
/* 
 * Sets the parameters of a keydef
 */ 
void U61_KeyDef::define(int ascii, char *label)
{
  key_ascii=ascii;
  key_label=label;
  reset();
}

/*--------------------------------------------------------------------------*/
/* 
 * Returns the ascii code of a keydef
 */ 
char U61_KeyDef::get_ascii()
{
  return key_ascii;
}

/*--------------------------------------------------------------------------*/
/* 
 * Returns the label of a keydef
 */ 
char *U61_KeyDef::get_label()
{
  return key_label;
}

/*--------------------------------------------------------------------------*/
/* 
 * Returns the state (pressed or not) of a keydef
 * Note the use of the special "key_flag" value. This value is set to true
 * when the key is pressed, and polling the key with get_state sets it back
 * to false. This way if a key is pressed and then released, the first call
 * to get_state will still return true at least once. This prevents keys
 * from being "forgetted" if they are pressed during a period when the
 * keyboard is not polled at all (when there's heavy drawing for instance)
 */ 
bool U61_KeyDef::get_state()
{
  bool result;

  result=key_state||key_flag;
  key_flag=false;

  return result;
}

/*--------------------------------------------------------------------------*/
/* 
 * Acknowledges a press on the key
 */ 
void U61_KeyDef::press()
{
  key_flag=true;
  key_state=true;
}

/*--------------------------------------------------------------------------*/
/* 
 * Acknowledges a release of the key
 */ 
void U61_KeyDef::release()
{
  key_state=false;
}




