/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   inputmonitor.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: This class is responsible for listening to keyboard events.
 *              It gets key-down and key-up signals, and updates the
 *              array of pressed-down keys. Then repetition is handled
 *              separately by other classes. 
 */

#ifndef INC_U61_INPUTMONITOR
#define INC_U61_INPUTMONITOR

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "keydef.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_InputMonitor
{ 
 public:
  U61_InputMonitor();
  ~U61_InputMonitor();

  void init();
  void reset();

  bool is_pressed(int key);
  char to_ascii(int key);
  int to_scancode(int key);
  char *to_label(int key);

  void check();

  static const int NUM_KEYS=96+CL_NUM_KEYS;
 protected:
  U61_KeyDef ascii[96];
  int ascii_time[96];
  U61_KeyDef scancode[CL_NUM_KEYS];
  char ascii_labels[96*2];  

  thSlotContainer slots;
  void on_button_press(CL_InputDevice *device, const CL_Key &key);
  void on_button_release(CL_InputDevice *device, const CL_Key &key);

  CL_InputDevice *device;
};

#endif

