/* -----------------------------------------------------------------------
   sysv.S - Copyright (c) 1996 Cygnus Solutions
   
   X86 Foreign Function Interface 

   $Id: sysv.S,v 1.5 1998/02/25 01:49:51 green Exp $

   Permission is hereby granted, free of charge, to any person obtaining
   a copy of this software and associated documentation files (the
   ``Software''), to deal in the Software without restriction, including
   without limitation the rights to use, copy, modify, merge, publish,
   distribute, sublicense, and/or sell copies of the Software, and to
   permit persons to whom the Software is furnished to do so, subject to
   the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED ``AS IS'', WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL CYGNUS SOLUTIONS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
   ----------------------------------------------------------------------- */

#define LIBFFI_ASM	
#include <ffi.h>

.text

.globl ffi_prep_args

	# This assumes we are using gas.
        .balign 16
.globl ffi_call_SYSV
        .type    ffi_call_SYSV,@function

ffi_call_SYSV:
        pushl %ebp
        movl  %esp,%ebp

	# Make room for all of the new args.
	movl  16(%ebp),%ecx
	subl  %ecx,%esp

	movl  %esp,%eax

	# Place all of the ffi_prep_args in position
	pushl 12(%ebp)
	pushl %eax
	call  ffi_prep_args

	# Return stack to previous state and call the function
	addl  $8,%esp	

	call  *28(%ebp)

	# Remove the space we pushed for the args
	movl  16(%ebp),%ecx
	addl  %ecx,%esp

	# Load %ecx with the pointer to storage for the return value
	movl  24(%ebp),%ecx	

	# Load %edx with the return type code 
	movl  20(%ebp),%edx	

	# If the return value pointer is NULL, assume no return value.
	cmpl  $0,%ecx
	jne   retint

	# Even if there is no space for the return value, we are 
	# obliged to handle floating-point values.
	cmpl  $FFI_TYPE_FLOAT,%edx
	jne   noretval
	fstp  %st(0)

        jmp   epilogue

retint:
	cmpl  $FFI_TYPE_INT,%edx
	jne   retfloat
	movl  %eax,0(%ecx)
	jmp   epilogue

retfloat:
	cmpl  $FFI_TYPE_FLOAT,%edx
	jne   retdouble
	fstps (%ecx)
	jmp   epilogue

retdouble:
	cmpl  $FFI_TYPE_DOUBLE,%edx
	jne   retlongdouble
	fstpl (%ecx)
	jmp   epilogue

retlongdouble:
	cmpl  $FFI_TYPE_LONGDOUBLE,%edx
	jne   retstruct
	fstpt (%ecx)

retstruct:
	# Nothing to do!

noretval:
epilogue:
        movl %ebp,%esp
        popl %ebp
        ret
.ffi_call_SYSV_end:
        .size    ffi_call_SYSV,.ffi_call_SYSV_end-ffi_call_SYSV

