'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\" Window command created by George Howlett.
'\"
.so man.macros
.HS winop BLT
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
winop \- Perform assorted window operations
.SH SYNOPSIS
\fBwinop lower\fR ?\fIwindow\fR?...
.sp
\fBwinop map\fR ?\fIwindow\fR?...
.sp
\fBwinop move \fIwindow x y\fR
.sp
\fBwinop raise\fR ?\fIwindow\fR?...
.sp
\fBwinop snap \fIwindow photoName\fR
.sp
\fBwinop unmap\fR ?\fIwindow\fR?...
.sp
\fBwinop warpto\fR ?\fIwindow\fR?
.BE
.SH DESCRIPTION
The \fBwinop\fR command performs various window operations on Tk
windows using low-level Xlib function calls to work around window
manager pecularities.
.SH INTRODUCTION
Tk has several commands for manipulating its windows: \fBraise\fR,
\fBlower\fR, \fBwm\fR, etc.  These commands ask the window manager to
perform operations on Tk windows.  In some cases, a particular window
manager won't perform the operation as expected.
.PP
For example, if you positioned a toplevel window using \fBwm geometry\fR,
the window may not actually be at those particular coordinates.  The
position of the window may be offset by dimensions of the title bar added
by the window manager.  
.PP
In situations like these, the \fBwinop\fR command can be used to
workaround these difficulties.  Instead, it makes low-level Xlib
(such \fBXRaiseWindow\fR and \fBXMapWindow\fR) calls to perform these
operations.
.DS
toplevel .top
wm withdraw .top

# Set the geometry to make the window manager 
# place the window.
wm geometry .top +100+100

# Move the window to the desired location
# and "update" to force the window manager
# to recognize it.
winop move .top 100 100
update 

wm deiconify .top
winop move .top 100 100
.DE
.SH OPERATIONS
The following operations are available for the \fBwinop\fR command:
.TP
\fBwinop lower\fR ?\fIwindow\fR?...
Lowers \fIwindow\fR to the bottom of the X window stack.  \fIWindow\fR is
the path name of a Tk window.  
.TP
\fBwinop map\fR ?\fIwindow\fR?...
Maps \fIwindow\fR on the screen.  \fIWindow\fR
is the path name of a Tk window. If \fIwindow\fR is already mapped,
this command has no effect.  
.TP
\fBwinop move \fIwindow x y\fR
Move \fIwindow\fR to the screen location specified by \fIx\fR
and \fIy\fR. \fIWindow\fR is the path name of a Tk window, while
\fIx\fR and \fIy\fR are screen coordinates.  This command returns 
the empty string.
.TP
\fBwinop raise\fR ?\fIwindow\fR?...
Raises \fIwindow\fR to the top of the X window stack. \fIWindow\fR must be
a valid path name of a Tk window.  This command returns the empty string.
.TP
\fBwinop snap \fIwindow photoName\fR
Takes a snapshot of the \fIwindow\fR and stores the contents in the
photo image \fIphotoName\fR. \fIWindow\fR is the valid path name of a
Tk window which must be totally visible (unobscured).  \fIPhotoName\fR
is the name of a Tk photo image which must already exist.  This command
can fail if the window is obscured in any fashion, such as covered by 
another window or partially offscreen.  In that case, an error message
is returned.
.TP
\fBwinop unmap\fR ?\fIwindow\fR?...
Unmaps \fIwindow\fR from the screen. \fIWindow\fR is the path name of a Tk
window. 
.TP
\fBwinop warpto\fR ?\fIwindow\fR?
Warps the pointer to \fIwindow\fR. \fIWindow\fR is the path name of a Tk window
which must be mapped. If \fIwindow\fR is in the form \fI@x,y\fR, where
\fIx\fR and \fIy\fR are root screen coordinates, the pointer is warped to
that location on the screen.
.sp
[\fII've never heard a good case for warping the pointer in an
application.  It can be useful for testing, but in applications, it's
always a bad idea.  Simply stated, the user owns the pointer, not the
application.  If you have an application that needs it, I'd like to
hear about it.\fR]
.sp
If no \fIwindow\fR argument is present the current location of the
pointer is returned. The location is returned as a list in the form
"\fIx y\fR", where \fIx\fR and \fIy\fR are the current coordinates of
the pointer.
.SH KEYWORDS
window, map, raise, lower, pointer, warp
