/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.BlockExp;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.Target;
import java.io.PrintWriter;

public class ExitExp
extends Expression {
    BlockExp block;
    Expression result;

    public ExitExp(BlockExp blockExp) {
        this.result = QuoteExp.voidExp;
        this.block = blockExp;
    }

    public ExitExp(Expression expression, BlockExp blockExp) {
        this.result = expression;
        this.block = blockExp;
    }

    public void compile(Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        Expression expression = this.result == null ? QuoteExp.voidExp : this.result;
        expression.compileWithPosition(compilation, this.block.subTarget);
        codeAttr.emitGoto(this.block.exitLabel);
    }

    public Type getType() {
        return Type.neverReturnsType;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("(#%exit ");
        if (this.block == null || this.block.label == null) {
            printWriter.print("<unknown>");
        } else {
            printWriter.print(this.block.label.getName());
        }
        if (this.result != null) {
            printWriter.print(' ');
            this.result.print(printWriter);
        }
        printWriter.print(')');
    }

    Object walk(ExpWalker expWalker) {
        return expWalker.walkExitExp(this);
    }
}

