/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;

public class ArrayType
extends ObjectType {
    public Type elements;

    public ArrayType(Type elements) {
        this(elements, String.valueOf(elements.getName()) + "[]");
    }

    ArrayType(Type elements, String name) {
        this.this_name = name;
        this.setSignature("[" + elements.getSignature());
        this.elements = elements;
    }

    public int compare(Type other) {
        if (other == Type.nullType) {
            return 1;
        }
        if (other instanceof ArrayType) {
            return this.elements.compare(((ArrayType)other).elements);
        }
        if (other.getName().equals("java.lang.Object")) {
            return -1;
        }
        return -3;
    }

    public Type getComponentType() {
        return this.elements;
    }

    public String getNameOrSignature() {
        return this.getSignature();
    }

    public static ArrayType make(Type elements) {
        String name = String.valueOf(elements.getName()) + "[]";
        ArrayType type = (ArrayType)Type.lookupType(name);
        if (type == null || type.elements != elements) {
            type = new ArrayType(elements, name);
            Type.mapNameToType.put(name, type);
        }
        return type;
    }
}

