
#import <swarmgraph/java.h>
#import <swarmgraph/JavaObject.h>


@interface JavaGraph : JavaObject {
  jmethodID _setRanges;
  jmethodID _setTitle;
  jmethodID _setAxisLabels;
  jmethodID _setScaleMode;
  jmethodID _setElemLen;
  jmethodID _createElem;
  jmethodID _addElem;
  jmethodID _dropElem;
  jmethodID _setColor;
  jmethodID _update;
}

+ newW: (int)w H: (int) h;

- initW: (int)w H: (int) h;
- free;

- setRangesXMin: (double)minx Max: (double)maxx 
	YMin: (double)miny Max: (double)maxy;
- setScaleModeX: (int)x Y: (int)y; 
- title: (char *)t;
- axisLabelsX: (char *) xl Y: (char *) yl;
- createElement: (char *)name;
- addElem: (char *)name X: (double)x Y: (double)y;
- setElem: (char *)name Len: (int)n;
- dropElem: (char *)name;
- setColor: (char *)name Color: (char *) color;
- update;

@end

