// Swarm library. Copyright (C) 1996 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// Quick code to test the 10000th output of PMMLCG1 against a known value.
// Checks if the math is handling overflow type things right.

#import "PMMLCG.h"
#import <stdio.h>

int
main(int argc, char ** argv) {
  id generator;
  unsigned i;

  generator = [PMMLCG1 alloc];
  [generator initSeed: 1];

  for (i = 0; i < 9999; i++)
    [generator r];

  if ([generator r] == 1043618064) {
    printf("10000th PMMLCG1 checked out ok: math is probably right\n");
    return 0;
  } else {
    printf("10000th PMMLCG1 failed. Probably a math error.\n");
    return 1;
  }
}
