/* 
 * $Id: local.h,v 1.3 2004/03/17 09:42:54 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _LOCAL_H
#define _LOCAL_H

#include <streamtuner/streamtuner.h>

#define LOCAL_DURATION(seconds)				\
  g_strdup_printf("%02u:%02u",				\
		  (unsigned int) (seconds) / 60,	\
		  (unsigned int) (seconds) % 60)

typedef enum
{
  LOCAL_TYPE_UNKNOWN,
  LOCAL_TYPE_MP3,
  LOCAL_TYPE_OGG,
  LOCAL_TYPE_PLAYLIST		/* .m3u or .pls playlist */
} LocalType;

typedef struct
{
  STStream	stream;

  char		*pathname;	/* full pathname, in the fs locale */
  LocalType	type;

  char		*filename;	/* filename only, converted to UTF-8 */
  char		*title;
  char		*artist;
  char		*album;
  char		*year;
  char		*genre;
  char		*comment;
  char		*duration;
} LocalStream;

enum {
  LOCAL_FIELD_PATHNAME,
  LOCAL_FIELD_TYPE,
  LOCAL_FIELD_FILENAME,
  LOCAL_FIELD_TITLE,
  LOCAL_FIELD_ARTIST,
  LOCAL_FIELD_ALBUM,
  LOCAL_FIELD_YEAR,
  LOCAL_FIELD_GENRE,
  LOCAL_FIELD_COMMENT,
  LOCAL_FIELD_DURATION
};

#endif /* _LOCAL_H */
