/* 
 * $Id: gettext.h,v 1.2 2004/03/02 00:07:24 jylefort Exp $
 *
 * Copyright (c) 2003, 2004 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GETTEXT_H
#define _GETTEXT_H

#ifdef ENABLE_NLS

#include <libintl.h>

#else /* ENABLE_NLS */

/*
 * Quoting GNU:
 *
 * "Solaris /usr/include/locale.h includes /usr/include/libintl.h,
 * which chokes if dcgettext is defined as a macro. So include it now,
 * to make later inclusions of <locale.h> a NOP. We don't include
 * <libintl.h> as well because people using "gettext.h" will not
 * include <libintl.h>, and also including <libintl.h> would fail on
 * SunOS 4, whereas <locale.h> is OK."
 */
#ifdef __sun
#include <locale.h>
#endif /* __sun */

/*
 * Quoting GNU:
 *
 * "Disabled NLS.
 * The casts to 'const char *' serve the purpose of producing warnings
 * for invalid uses of the value returned from these functions. On
 * pre-ANSI systems without 'const', the config.h file is supposed to
 * contain "#define const".
 */
#define gettext(Msgid)				((const char *) (Msgid))
#define dgettext(Domainname, Msgid)		((const char *) (Msgid))
#define dcgettext(Domainname, Msgid, Category)	((const char *) (Msgid))
#define ngettext(Msgid1, Msgid2, N) \
	((N) == 1 ? (const char *) (Msgid1) : (const char *) (Msgid2))
#define dngettext(Domainname, Msgid1, Msgid2, N) \
	((N) == 1 ? (const char *) (Msgid1) : (const char *) (Msgid2))
#define dcngettext(Domainname, Msgid1, Msgid2, N, Category) \
	((N) == 1 ? (const char *) (Msgid1) : (const char *) (Msgid2))
#define textdomain(Domainname)			((const char *) (Domainname))
#define bindtextdomain(Domainname, Dirname)	((const char *) (Dirname))
#define bind_textdomain_codeset(Domainname, Codeset) \
	((const char *) (Codeset))

#endif /* ENABLE_NLS */

/*
 * Quoting GNU:
 *
 * "A pseudo function call that serves as a marker for the automated
 * extraction of messages, but does not call gettext(). The run-time
 * translation is done at a different place in the code. The argument,
 * String, should be a literal string. Concatenated strings and other
 * string expressions won't work. The macro's expansion is not
 * parenthesized, so that it is suitable as initializer for static
 * 'char[]' or 'const char[]' variables.
 */
#define gettext_noop(String)	String

#define _(String)		dgettext(GETTEXT_PACKAGE, String)
#define N_(String)		gettext_noop(String)

#endif /* _GETTEXT_H */
